(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39542,       1543]
NotebookOptionsPosition[     31429,       1251]
NotebookOutlinePosition[     32767,       1289]
CellTagsIndexPosition[     32681,       1284]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Working with Operators" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithOperators"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Working with Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ComposeList" :> 
          Documentation`HelpLookup["paclet:ref/ComposeList"], "Nest" :> 
          Documentation`HelpLookup["paclet:ref/Nest"], "Function" :> 
          Documentation`HelpLookup["paclet:ref/Function"], "ComposeSeries" :> 
          Documentation`HelpLookup["paclet:ref/ComposeSeries"], "Identity" :> 
          Documentation`HelpLookup["paclet:ref/Identity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ComposeList\"\>", 2->"\<\"Nest\"\>",
        3->"\<\"Function\"\>", 4->"\<\"ComposeSeries\"\>", 
       5->"\<\"Identity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"], 
          "Structural Operations on Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/StructuralOperationsOnExpressions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Functional Programming\"\>", 
       2->"\<\"Structural Operations on Expressions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Composition", "ObjectName",
 CellID->21881],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Composition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Composition"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["3", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a composition of the functions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["3", "TR"]]], "InlineFormula"],
     ", \[Ellipsis]",
     " ",
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31998]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Composition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Composition"]], "InlineFormula"],
 " allows you to build up compositions of functions which can later be \
applied to specific arguments. "
}], "Notes",
 CellID->10322],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Composition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Composition"]], "InlineFormula"],
 " objects containing ",
 Cell[BoxData[
  ButtonBox["Identity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Identity"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["InverseFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InverseFunction"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 " are automatically simplified when possible. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->2024643649]
}], "Notes",
 CellID->18651],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Composition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Composition"]], "InlineFormula"],
 " has the attributes ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["OneIdentity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OneIdentity"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10021],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], "@", 
   RowBox[{
    StyleBox["b", "TI"], "@", 
    StyleBox["c", "TI"]}]}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{
   StyleBox["a", "TI"], "[", 
   RowBox[{
    StyleBox["b", "TI"], "[", 
    StyleBox["c", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5699],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["a", "TI"], "//", 
    StyleBox["b", "TI"]}], "//", 
   StyleBox["c", "TI"]}]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  RowBox[{
   StyleBox["c", "TI"], "[", 
   RowBox[{
    StyleBox["b", "TI"], "[", 
    StyleBox["a", "TI"], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3557]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->354932530],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->7771607],

Cell["Apply a composition of functions to arguments:", "ExampleText",
 CellID->17861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Composition", "[", 
   RowBox[{"f", ",", "g", ",", "h"}], "]"}], "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14688],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"g", "[", 
   RowBox[{"h", "[", 
    RowBox[{"x", ",", "y"}], "]"}], "]"}], "]"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13401]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15255],

Cell[TextData[{
 "Use pure functions inside ",
 Cell[BoxData[
  ButtonBox["Composition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Composition"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->16423],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Composition", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"#", "^", "#"}]}], "&"}], ",", 
    RowBox[{
     RowBox[{"a", " ", "#"}], "&"}], ",", 
    RowBox[{
     RowBox[{"#", "/", 
      RowBox[{"(", 
       RowBox[{"#", "+", "1"}], ")"}]}], "&"}]}], "]"}], "[", "x", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5002],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox[
   RowBox[{"(", 
    FractionBox[
     RowBox[{"a", " ", "x"}], 
     RowBox[{"1", "+", "x"}]], ")"}], 
   FractionBox[
    RowBox[{"a", " ", "x"}], 
    RowBox[{"1", "+", "x"}]]]}]], "Output",
 ImageSize->{87, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10585]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24182],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["InverseFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFunction"]], "InlineFormula"],
 " on ",
 Cell[BoxData[
  ButtonBox["Composition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Composition"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->10285],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFunction", "[", 
  RowBox[{"Composition", "[", 
   RowBox[{"f", ",", "g", ",", "h"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27088],

Cell[BoxData[
 RowBox[{"Composition", "[", 
  RowBox[{
   TagBox[
    SuperscriptBox["h", 
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}]],
    InverseFunction,
    Editable->False], ",", 
   TagBox[
    SuperscriptBox["g", 
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}]],
    InverseFunction,
    Editable->False], ",", 
   TagBox[
    SuperscriptBox["f", 
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}]],
    InverseFunction,
    Editable->False]}], "]"}]], "Output",
 ImageSize->{200, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31426]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseFunction", "[", 
   RowBox[{"Composition", "[", 
    RowBox[{"f", ",", "g", ",", "h"}], "]"}], "]"}], "[", "x", "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->28617],

Cell[BoxData[
 RowBox[{
  TagBox[
   SuperscriptBox["h", 
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}]],
   InverseFunction,
   Editable->False], "[", 
  RowBox[{
   TagBox[
    SuperscriptBox["g", 
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}]],
    InverseFunction,
    Editable->False], "[", 
   RowBox[{
    TagBox[
     SuperscriptBox["f", 
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}]],
     InverseFunction,
     Editable->False], "[", "x", "]"}], "]"}], "]"}]], "Output",
 ImageSize->{136, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23757]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9832],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  ButtonBox["Composition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Composition"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->30932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Composition", "[", 
   RowBox[{"f", ",", "g", ",", "h"}], "]"}], "@@", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4169],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"g", "[", 
   RowBox[{"h", "[", 
    RowBox[{"x", ",", "y", ",", "z"}], "]"}], "]"}], "]"}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2154]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1306508552],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Identity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Identity"]], "InlineFormula"],
 " inside a composition is simplified:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->2024643649],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Composition", "[", 
  RowBox[{"f", ",", "Identity", ",", "g"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1679463767],

Cell[BoxData[
 RowBox[{"Composition", "[", 
  RowBox[{"f", ",", "g"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->497286181]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19976],

Cell["Create a composition of a sequence of functions:", "ExampleText",
 CellID->31329],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Apply", "[", 
   RowBox[{"Composition", ",", 
    RowBox[{"Array", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Subscript", "[", 
        RowBox[{"f", ",", "#"}], "]"}], "&"}], ",", "10"}], "]"}]}], "]"}], 
  "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2368],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWM1uwyAMdiBp1faQXVbt2KfZTnuIqJrUHqZNXd8/BQIbsQyYNlmaVkqN
sfkw5uMneW/Oh4/P5nzcN7u3U/N9OO5/dq9fJ1UlC4DiGQDqF1DlVpXMo39b
9QAs1X+lqqSSQsm1klLJytOFp2+svfR0kA6z7eFouUj44foy0O/KxikC/hvk
f6uUJjsrImpfx/YK6Xh0OHoqKyF8sFmP2XH/60z83PgN/vJX71CYWHgsU+tF
F7e04euiUyMZ1BmpCD+MHvIL4WlZEjPu7FR9CCc2w9fExcUTkfgNfow5pW8T
tmcK8d70jkfUPhXLb4o/qfbUPHD7o+aR8hcZfouB483NBx5fyt/YmTuZifWP
n4TH1Bwch5PXcCZ3Drgcu2UcQ8f9H3nhcjO0/qZmII+R3F0mdzcYkyFOlwMz
nIuXmwfqDA3t4hz8+bItdTtO3c4fvf0T0ud67uE7PX5rc3dSnA9XPxf/uj8/
7SPcm+99jUzdHq/Rebxlu/NNM9mdhxL6X32msNftmF+TdAK2jBIUF6YIXgM=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{277, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->848461382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21425],

Cell["Create a sum of numbers to be displayed in held form:", "ExampleText",
 CellID->10555],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Composition", "[", 
   RowBox[{"HoldForm", ",", "Plus"}], "]"}], "@@", 
  RowBox[{"Range", "[", "20", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3434],

Cell[BoxData[
 TagBox[
  RowBox[{
  "1", "+", "2", "+", "3", "+", "4", "+", "5", "+", "6", "+", "7", "+", "8", 
   "+", "9", "+", "10", "+", "11", "+", "12", "+", "13", "+", "14", "+", "15",
    "+", "16", "+", "17", "+", "18", "+", "19", "+", "20"}],
  HoldForm]], "Output",
 ImageSize->{461, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->153357910]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7441],

Cell[TextData[{
 "Pure functions let you set up objects that work like ",
 Cell[BoxData[
  ButtonBox["Composition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Composition"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->9512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Composition", "[", 
   RowBox[{"f", ",", "g", ",", "h"}], "]"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30145],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"g", "[", 
   RowBox[{"h", "[", "x", "]"}], "]"}], "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->18060]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"g", "[", 
     RowBox[{"h", "[", "#", "]"}], "]"}], "]"}], "&"}], "[", "x", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21718],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"g", "[", 
   RowBox[{"h", "[", "x", "]"}], "]"}], "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3753]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16139],

Cell["Different ways of entering compositions: ", "ExampleText",
 CellID->583025245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Composition", "[", 
   RowBox[{"f", ",", "g", ",", "h"}], "]"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12423],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"g", "[", 
   RowBox[{"h", "[", "x", "]"}], "]"}], "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183827411]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "@", 
  RowBox[{"g", "@", 
   RowBox[{"h", "@", "x"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25996],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"g", "[", 
   RowBox[{"h", "[", "x", "]"}], "]"}], "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->304818732]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"x", "//", "h"}], "//", "g"}], "//", "f"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->12529],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"g", "[", 
   RowBox[{"h", "[", "x", "]"}], "]"}], "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->137900318]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->214719353],

Cell[TextData[{
 "Compose a function with itself ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " times using ",
 Cell[BoxData[
  ButtonBox["Nest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Nest"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->854905772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Nest", "[", 
  RowBox[{"f", ",", "x", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->525263695],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"f", "[", 
   RowBox[{"f", "[", "x", "]"}], "]"}], "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->129199803]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Composition", "[", 
   RowBox[{"f", ",", "f", ",", "f"}], "]"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->62595433],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"f", "[", 
   RowBox[{"f", "[", "x", "]"}], "]"}], "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->56918559]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->207931268],

Cell[TextData[{
 "Compose a function with itself ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " times using ",
 Cell[BoxData[
  ButtonBox["RSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->303562052],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  FractionBox[
   RowBox[{
    RowBox[{"2", "x"}], "+", "3"}], 
   RowBox[{"x", "+", "4"}]]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44283880],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fn", "=", 
  RowBox[{"a", "/.", 
   RowBox[{"First", "@", 
    RowBox[{"RSolve", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"a", "[", 
          RowBox[{"n", "+", "1"}], "]"}], "\[Equal]", 
         RowBox[{"f", "[", 
          RowBox[{"a", "[", "n", "]"}], "]"}]}], ",", 
        RowBox[{
         RowBox[{"a", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", "a", 
      ",", "n"}], "]"}]}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20255127],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{
   RowBox[{"{", "n", "}"}], ",", 
   FractionBox[
    RowBox[{"3", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "n"], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", 
          FractionBox["1", "5"]}], ")"}], "n"]}], ")"}]}], 
    RowBox[{
     RowBox[{"3", " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "n"]}], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", 
        FractionBox["1", "5"]}], ")"}], "n"]}]]}], "]"}]], "Output",
 ImageSize->{219, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->355561115]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fn", "[", "10", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->897966397],

Cell[BoxData[
 FractionBox["7324218", "7324219"]], "Output",
 ImageSize->{62, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->232834326]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"Composition", "@@", 
    RowBox[{"Table", "[", 
     RowBox[{"f", ",", 
      RowBox[{"{", "10", "}"}]}], "]"}]}], ")"}], "[", "0", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->263085174],

Cell[BoxData[
 FractionBox["7324218", "7324219"]], "Output",
 ImageSize->{62, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->516020770]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->147397106],

Cell[TextData[{
 "Compose ",
 Cell[BoxData[
  ButtonBox["TransformationFunction",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TransformationFunction"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->138491977],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Composition", "[", 
   RowBox[{
    RowBox[{"RotationTransform", "[", "\[Theta]", "]"}], ",", 
    RowBox[{"RotationTransform", "[", "\[Phi]", "]"}]}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12114648],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {
      RowBox[{"Cos", "[", 
       RowBox[{"\[Theta]", "+", "\[Phi]"}], "]"}], 
      RowBox[{"-", 
       RowBox[{"Sin", "[", 
        RowBox[{"\[Theta]", "+", "\[Phi]"}], "]"}]}], "0"},
     {
      RowBox[{"Sin", "[", 
       RowBox[{"\[Theta]", "+", "\[Phi]"}], "]"}], 
      RowBox[{"Cos", "[", 
       RowBox[{"\[Theta]", "+", "\[Phi]"}], "]"}], "0"},
     {"0", "0", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{348, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21796122]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Composition", "[", 
   RowBox[{
    RowBox[{"RotationTransform", "[", "\[Theta]", "]"}], ",", 
    RowBox[{"RotationTransform", "[", 
     RowBox[{"-", "\[Theta]"}], "]"}]}], "]"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->425576887],

Cell[BoxData[
 RowBox[{"TransformationFunction", "[", 
  RowBox[{"(", GridBox[{
     {"1", "0", "0"},
     {"0", "1", "0"},
     {"0", "0", "1"}
    },
    GridBoxDividers->{
     "ColumnsIndexed" -> {-2 -> True}, "RowsIndexed" -> {-2 -> True}}], ")"}],
   "]"}]], "Output",
 ImageSize->{230, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2822645]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132477096],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ComposeSeries",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComposeSeries"]], "InlineFormula"],
 " to do composition of series expansions:"
}], "ExampleText",
 CellID->544243192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Composition", "[", 
     RowBox[{"Sin", ",", "Cos"}], "]"}], "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->377109873],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Sin", "[", "1", "]"}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Cos", "[", "1", "]"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    Sin[1], 0, Rational[-1, 2] Cos[1]}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{177, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145064422]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComposeSeries", "[", 
  RowBox[{
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"Cos", "[", "0", "]"}], ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"Series", "[", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->814654041],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"Sin", "[", "1", "]"}], "-", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"Cos", "[", "1", "]"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    Sin[1], 0, Rational[-1, 2] Cos[1]}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{177, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->202881109]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12949],

Cell["\<\
Tabulate square roots of values without using auxiliary variables:\
\>", "ExampleText",
 CellID->228422292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Composition", "[", 
    RowBox[{"Through", ",", 
     RowBox[{"{", 
      RowBox[{"Identity", ",", "Sqrt"}], "}"}]}], "]"}], "/@", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1.0", ",", "2.0", ",", "3.0", ",", "4.0"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->398812588],

Cell[BoxData[
 TagBox[GridBox[{
    {"0", "0"},
    {"1.`", "1.`"},
    {"2.`", "1.4142135623730951`"},
    {"3.`", "1.7320508075688772`"},
    {"4.`", "2.`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{75, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->584512132]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10712],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComposeList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComposeList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Nest",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Nest"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Function",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Function"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComposeSeries",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComposeSeries"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Identity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Identity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2600]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28476],

Cell[TextData[ButtonBox["Working with Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/WorkingWithOperators"]], "Tutorials",
 CellID->27892]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->219002120],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->255648293],

Cell[TextData[ButtonBox["Structural Operations on Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StructuralOperationsOnExpressions"]], "MoreAbout",
 CellID->250033473]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Composition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 29, 50.5107328}", "context" -> "System`", 
    "keywords" -> {
     "Compose (Version 1 function)", "functions", "composition of functions", 
      "nesting of functions"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Composition[f_1, f_2, f_3, ...] represents a composition of the \
functions f_1, f_2, f_3, ... . ", "synonyms" -> {}, "title" -> "Composition", 
    "type" -> "Symbol", "uri" -> "ref/Composition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6907, 242, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->354932530]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 32538, 1277}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2370, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2993, 83, 49, 1, 70, "ObjectName",
 CellID->21881],
Cell[3045, 86, 1202, 42, 70, "Usage",
 CellID->31998]
}, Open  ]],
Cell[CellGroupData[{
Cell[4284, 133, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4762, 150, 275, 8, 70, "Notes",
 CellID->10322],
Cell[5040, 160, 643, 22, 70, "Notes",
 CellID->18651],
Cell[5686, 184, 446, 17, 70, "Notes",
 CellID->10021],
Cell[6135, 203, 365, 16, 70, "Notes",
 CellID->5699],
Cell[6503, 221, 367, 16, 70, "Notes",
 CellID->3557]
}, Closed]],
Cell[CellGroupData[{
Cell[6907, 242, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->354932530],
Cell[CellGroupData[{
Cell[7292, 256, 146, 5, 70, "ExampleSection",
 CellID->7771607],
Cell[7441, 263, 85, 1, 70, "ExampleText",
 CellID->17861],
Cell[CellGroupData[{
Cell[7551, 268, 188, 6, 28, "Input",
 CellID->14688],
Cell[7742, 276, 263, 9, 36, "Output",
 CellID->13401]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8054, 291, 216, 7, 70, "ExampleSection",
 CellID->15255],
Cell[8273, 300, 211, 8, 70, "ExampleText",
 CellID->16423],
Cell[CellGroupData[{
Cell[8509, 312, 387, 15, 70, "Input",
 CellID->5002],
Cell[8899, 329, 371, 14, 53, "Output",
 CellID->10585]
}, Open  ]],
Cell[9285, 346, 121, 3, 70, "ExampleDelimiter",
 CellID->24182],
Cell[9409, 351, 331, 13, 70, "ExampleText",
 CellID->10285],
Cell[CellGroupData[{
Cell[9765, 368, 179, 5, 70, "Input",
 CellID->27088],
Cell[9947, 375, 609, 25, 39, "Output",
 CellID->31426]
}, Open  ]],
Cell[CellGroupData[{
Cell[10593, 405, 211, 7, 70, "Input",
 CellID->28617],
Cell[10807, 414, 623, 26, 39, "Output",
 CellID->23757]
}, Open  ]],
Cell[11445, 443, 120, 3, 70, "ExampleDelimiter",
 CellID->9832],
Cell[11568, 448, 313, 13, 70, "ExampleText",
 CellID->30932],
Cell[CellGroupData[{
Cell[11906, 465, 217, 7, 70, "Input",
 CellID->4169],
Cell[12126, 474, 273, 9, 36, "Output",
 CellID->2154]
}, Open  ]],
Cell[12414, 486, 126, 3, 70, "ExampleDelimiter",
 CellID->1306508552],
Cell[12543, 491, 262, 8, 70, "ExampleText",
 CellID->2024643649],
Cell[CellGroupData[{
Cell[12830, 503, 148, 4, 70, "Input",
 CellID->1679463767],
Cell[12981, 509, 219, 7, 36, "Output",
 CellID->497286181]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13249, 522, 223, 7, 70, "ExampleSection",
 CellID->19976],
Cell[13475, 531, 87, 1, 70, "ExampleText",
 CellID->31329],
Cell[CellGroupData[{
Cell[13587, 536, 314, 11, 70, "Input",
 CellID->2368],
Cell[13904, 549, 761, 17, 70, "Output",
 Evaluatable->False,
 CellID->848461382]
}, Open  ]],
Cell[14680, 569, 121, 3, 70, "ExampleDelimiter",
 CellID->21425],
Cell[14804, 574, 92, 1, 70, "ExampleText",
 CellID->10555],
Cell[CellGroupData[{
Cell[14921, 579, 193, 6, 70, "Input",
 CellID->3434],
Cell[15117, 587, 406, 11, 36, "Output",
 CellID->153357910]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15572, 604, 232, 7, 70, "ExampleSection",
 CellID->7441],
Cell[15807, 613, 237, 8, 70, "ExampleText",
 CellID->9512],
Cell[CellGroupData[{
Cell[16069, 625, 165, 5, 70, "Input",
 CellID->30145],
Cell[16237, 632, 238, 8, 36, "Output",
 CellID->18060]
}, Open  ]],
Cell[CellGroupData[{
Cell[16512, 645, 204, 8, 70, "Input",
 CellID->21718],
Cell[16719, 655, 237, 8, 36, "Output",
 CellID->3753]
}, Open  ]],
Cell[16971, 666, 121, 3, 70, "ExampleDelimiter",
 CellID->16139],
Cell[17095, 671, 84, 1, 70, "ExampleText",
 CellID->583025245],
Cell[CellGroupData[{
Cell[17204, 676, 165, 5, 70, "Input",
 CellID->12423],
Cell[17372, 683, 242, 8, 36, "Output",
 CellID->183827411]
}, Open  ]],
Cell[CellGroupData[{
Cell[17651, 696, 135, 5, 70, "Input",
 CellID->25996],
Cell[17789, 703, 242, 8, 36, "Output",
 CellID->304818732]
}, Open  ]],
Cell[CellGroupData[{
Cell[18068, 716, 138, 5, 70, "Input",
 CellID->12529],
Cell[18209, 723, 242, 8, 36, "Output",
 CellID->137900318]
}, Open  ]],
Cell[18466, 734, 125, 3, 70, "ExampleDelimiter",
 CellID->214719353],
Cell[18594, 739, 289, 11, 70, "ExampleText",
 CellID->854905772],
Cell[CellGroupData[{
Cell[18908, 754, 133, 4, 70, "Input",
 CellID->525263695],
Cell[19044, 760, 242, 8, 36, "Output",
 CellID->129199803]
}, Open  ]],
Cell[CellGroupData[{
Cell[19323, 773, 168, 5, 70, "Input",
 CellID->62595433],
Cell[19494, 780, 241, 8, 36, "Output",
 CellID->56918559]
}, Open  ]],
Cell[19750, 791, 125, 3, 70, "ExampleDelimiter",
 CellID->207931268],
Cell[19878, 796, 292, 11, 70, "ExampleText",
 CellID->303562052],
Cell[20173, 809, 210, 8, 70, "Input",
 CellID->44283880],
Cell[CellGroupData[{
Cell[20408, 821, 521, 17, 70, "Input",
 CellID->20255127],
Cell[20932, 840, 770, 28, 68, "Output",
 CellID->355561115]
}, Open  ]],
Cell[CellGroupData[{
Cell[21739, 873, 99, 3, 70, "Input",
 CellID->897966397],
Cell[21841, 878, 190, 6, 51, "Output",
 CellID->232834326]
}, Open  ]],
Cell[CellGroupData[{
Cell[22068, 889, 243, 8, 70, "Input",
 CellID->263085174],
Cell[22314, 899, 190, 6, 51, "Output",
 CellID->516020770]
}, Open  ]],
Cell[22519, 908, 125, 3, 70, "ExampleDelimiter",
 CellID->147397106],
Cell[22647, 913, 227, 8, 70, "ExampleText",
 CellID->138491977],
Cell[CellGroupData[{
Cell[22899, 925, 268, 8, 70, "Input",
 CellID->12114648],
Cell[23170, 935, 724, 23, 64, "Output",
 CellID->21796122]
}, Open  ]],
Cell[CellGroupData[{
Cell[23931, 963, 289, 8, 70, "Input",
 CellID->425576887],
Cell[24223, 973, 403, 14, 64, "Output",
 CellID->2822645]
}, Open  ]],
Cell[24641, 990, 125, 3, 70, "ExampleDelimiter",
 CellID->132477096],
Cell[24769, 995, 236, 8, 70, "ExampleText",
 CellID->544243192],
Cell[CellGroupData[{
Cell[25030, 1007, 283, 9, 70, "Input",
 CellID->377109873],
Cell[25316, 1018, 611, 20, 51, "Output",
 CellID->145064422]
}, Open  ]],
Cell[CellGroupData[{
Cell[25964, 1043, 477, 15, 70, "Input",
 CellID->814654041],
Cell[26444, 1060, 611, 20, 51, "Output",
 CellID->202881109]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27104, 1086, 224, 7, 70, "ExampleSection",
 CellID->12949],
Cell[27331, 1095, 117, 3, 70, "ExampleText",
 CellID->228422292],
Cell[CellGroupData[{
Cell[27473, 1102, 352, 11, 70, "Input",
 CellID->398812588],
Cell[27828, 1115, 756, 24, 108, "Output",
 CellID->584512132]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28645, 1146, 311, 9, 70, "SeeAlsoSection",
 CellID->10712],
Cell[28959, 1157, 1193, 44, 70, "SeeAlso",
 CellID->2600]
}, Open  ]],
Cell[CellGroupData[{
Cell[30189, 1206, 314, 9, 70, "TutorialsSection",
 CellID->28476],
Cell[30506, 1217, 153, 3, 70, "Tutorials",
 CellID->27892]
}, Open  ]],
Cell[CellGroupData[{
Cell[30696, 1225, 319, 9, 70, "MoreAboutSection",
 CellID->219002120],
Cell[31018, 1236, 155, 3, 70, "MoreAbout",
 CellID->255648293],
Cell[31176, 1241, 181, 3, 70, "MoreAbout",
 CellID->250033473]
}, Open  ]],
Cell[31372, 1247, 27, 0, 70, "History"],
Cell[31402, 1249, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

