(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25118,        926]
NotebookOptionsPosition[     19951,        746]
NotebookOutlinePosition[     21247,        783]
CellTagsIndexPosition[     21162,        778]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"], 
          "Total Derivatives" :> 
          Documentation`HelpLookup["paclet:tutorial/TotalDerivatives"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Attributes\"\>", 
       2->"\<\"Total Derivatives\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constants" :> 
          Documentation`HelpLookup["paclet:ref/Constants"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Constants\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Attributes\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Constant", "ObjectName",
 CellID->8380],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Constant",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Constant"]], "InlineFormula"],
     "\[LineSeparator]is an attribute which indicates zero derivative of a \
symbol with respect to all parameters. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29815]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Constant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Constant"]], "InlineFormula"],
 " is used by ",
 Cell[BoxData[
  ButtonBox["Dt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dt"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25951],

Cell[TextData[{
 "Functions ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 " are taken to have zero total derivative if ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["Constant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Constant"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6541],

Cell[TextData[{
 "Mathematical constants such as ",
 Cell[BoxData[
  ButtonBox["Pi",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pi"]], "InlineFormula"],
 " have attribute ",
 Cell[BoxData[
  ButtonBox["Constant",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Constant"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18115]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->126667455],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->771520848],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["\[Pi]", "TR"]], "InlineFormula"],
 " is a mathematical constant representing a number:"
}], "ExampleText",
 CellID->114978521],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "\[Pi]", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->349131668],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Constant", ",", "Protected", ",", "ReadProtected"}], 
  "}"}]], "Output",
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->150398160]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["\[Pi]", "TR"]], "InlineFormula"],
 " is not explicitly a number:"
}], "ExampleText",
 CellID->261845355],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberQ", "[", "\[Pi]", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->415292255],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25109521]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["\[Pi]", "TR"]], "InlineFormula"],
 " is numeric and evaluates to a number with ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->127610466],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", "\[Pi]", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->47507856],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->27887812]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"\[Pi]", ",", "32"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->53054931],

Cell[BoxData["3.141592653589793238462643383279502884197169399375`32."], \
"Output",
 ImageSize->{235, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->61266920]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->741246873],

Cell[TextData[{
 "Define ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " to be a constant function for total derivatives computed with ",
 Cell[BoxData[
  ButtonBox["Dt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dt"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->229601458],

Cell[BoxData[
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", "Constant"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162534775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"x", ",", "y"}], "]"}], " ", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->375713151],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y"}], "]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"Dt", "[", "y", "]"}], " ", 
     RowBox[{
      SuperscriptBox["g", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"0", ",", "1"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], "+", 
    RowBox[{
     RowBox[{"Dt", "[", "x", "]"}], " ", 
     RowBox[{
      SuperscriptBox["g", 
       TagBox[
        RowBox[{"(", 
         RowBox[{"1", ",", "0"}], ")"}],
        Derivative],
       MultilineFunction->None], "[", 
      RowBox[{"x", ",", "y"}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{300, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->776866097]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10008],

Cell["The built-in system mathematical constants:", "ExampleText",
 CellID->586045741],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"constants", "=", 
  RowBox[{"Map", "[", 
   RowBox[{"ToExpression", ",", 
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{"Names", "[", "\"\<System`*\>\"", "]"}], ",", 
      RowBox[{
       RowBox[{"MemberQ", "[", 
        RowBox[{
         RowBox[{"Attributes", "[", "#", "]"}], ",", "Constant"}], "]"}], 
       "&"}]}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->89564358],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "Catalan", ",", "\[Degree]", ",", "\[ExponentialE]", ",", "EulerGamma", ",",
    "Glaisher", ",", "GoldenRatio", ",", "Khinchin", ",", "MachinePrecision", 
   ",", "\[Pi]"}], "}"}]], "Output",
 ImageSize->{550, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->970652295]
}, Open  ]],

Cell[TextData[{
 "They are all ",
 Cell[BoxData[
  ButtonBox["NumericQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumericQ"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->264450826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"NumericQ", ",", "constants"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->158823365],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "True", ",", "True", ",", "True", ",", "True", ",", "True", 
   ",", "True", ",", "True", ",", "True"}], "}"}]], "Output",
 ImageSize->{360, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->372739940]
}, Open  ]],

Cell[TextData[{
 "They all represent exact values that can be evaluated to numbers of any \
precision with ",
 Cell[BoxData[
  ButtonBox["N",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/N"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->354322259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"N", "[", "c", "]"}], ",", 
      RowBox[{"N", "[", 
       RowBox[{"c", ",", "24"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "constants"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->22581385],

Cell[BoxData[
 TagBox[GridBox[{
    {"Catalan", "0.915965594177219`", 
     "0.91596559417721901505460342446514388249`24."},
    {"\[Degree]", "0.017453292519943295`", 
     "0.01745329251994329576923690768488612714`24."},
    {"\[ExponentialE]", "2.718281828459045`", 
     "2.71828182845904523536028747135266249776`24."},
    {"EulerGamma", "0.5772156649015329`", 
     "0.57721566490153286060651190435237101255`24."},
    {"Glaisher", "1.2824271291006226`", 
     "1.28242712910062263687534256895526756738`24."},
    {"GoldenRatio", "1.618033988749895`", 
     "1.61803398874989484820458683436563811772`24."},
    {"Khinchin", "2.6854520010653062`", 
     "2.6854520010653064453097148174040341881`24."},
    {"MachinePrecision", "15.954589770191003`", 
     "15.95458977019100334632816142039364847703`24."},
    {"\[Pi]", "3.141592653589793`", 
     "3.1415926535897932384626433832795028842`24."}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$4151]]]], "Output",
 ImageSize->{384, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TableForm=",
 CellID->808516664]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30709941],

Cell[TextData[{
 "Define ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " locally to be a constant function:"
}], "ExampleText",
 CellID->888807626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", "f", "}"}], ",", 
   RowBox[{
    RowBox[{"SetAttributes", "[", 
     RowBox[{"f", ",", "Constant"}], "]"}], ";", 
    RowBox[{"Dt", "[", 
     RowBox[{"g", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", "x", ",", "y"}], "]"}], 
     "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->360608416],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Dt", "[", "y", "]"}], " ", 
   RowBox[{
    SuperscriptBox["g", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", "x", ",", "y"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"Dt", "[", "x", "]"}], " ", 
   RowBox[{
    SuperscriptBox["g", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", "x", ",", "y"}], 
    "]"}]}]}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139580940]
}, Open  ]],

Cell[TextData[{
 "This does not affect subsequent computations with ",
 Cell[BoxData[
  ButtonBox["Dt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dt"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->547512519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{"g", "[", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", "x", ",", "y"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->144275285],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWc1u1DAQdpPNLi37Q5GQ4LBtEQK6HIAngBuceIilqtQeEKj0DBJneoAj
Qn0+xEuYOGtnvV8mHttJ2t0SaTcZx5755seO8+Xd/Pzk+MP8/PRofvD2bP7p
5PTo88Gbj2d5U7olxNZ3IcSj+yK/lvlV8VPHRf4TYqj+U9MmxR+Qfxa9bkPr
X5B/NOi1m/8luZjm515+7ml5ps/YfwD9Hlr9XONuwbiM0KvEQ31/6Gkf9UwY
u70iCjvQ6y7IPUZ+CvKO1o56cdw+yOhdnV7sx+HbBvkxY9cXf6r73fHElSyj
3StbdUb6cpFxzheUVcazXJxWtCpEibTyDHXg0jog7ldQeluLw4hZ4yLR1xix
ahJtPQwzFyHKxybeWLWBrUvMRm9meyH0eoXaqfWgD/Iea8/4tV2jESsli0RM
W24Hu5nPqJHKYRUp1hMiR63hMTTZGgR74KgaNuKoy74vIuJvr4YuPWY1oKPt
gzLRK1EMul0GXTc14RubsSfK1vNenbGxmXdqIleL66kBJ84rqAKn/ZU6cPZs
sxLoUVw1cHtOEvGKT2Mvu+3UTvhzprl/Ey//yJqz9RJjHjA6wqPhl4tRpI8h
1Vq/b0tL1eag/MyIdqwhlNOKLXtPN/SyTUcibhfajR8jLz+oeZ+UHRdHEoiL
xBm8V/fLw1DGeB20D3fMLHwXxFUF7ZI4bP11WC15CvKkG9QrecmIKkCZw43P
aUQ5jLLaFBW3dmK0Z5S+KiegK9FmidR7Qcp4VBZuZWWh1nSldSqXu40Qq2Rl
9u0qkmQtGbt7kn5XGTWxE2A/k0uOwo7DM2lzXpiX50zskQ9A9HPmfh/0IXqs
Hi5aqG/A6J//x14jr1x4PYB5VOMxzo4j5j4iRA/QY9xNcvrQY9T/vmh/JamV
QvmWEGOOEYNeHaoaXtf1xGd8ZWRho2i6qL2qY98VbmWgazb8QK6ukMburGW7
1FeD1Xd+dbkprDY+vbE/4nzSEU6vrw2iCde+2Qwz7uWacfomFodrGYvQ7xv3
pCypAGuj0ZBt3zw+meQ+OmHz6dhgNV1HbHy/dOia0W/DJZqKT653XtFZ1bTN
OKu4tc/at1MFob76fqFolGH+vXst+WS/DK1Rvr38Dv8yEZt7Pw79JnK77VSO
55MjMHaub53dxi7u20ZN9dmIBbXHSkvl5qDeoG8+i0tHPW5v2kXEKO6qq4j5
jdqXy8lmlW8wY4xcC8eycrIP792UqR2vRv0KvI5hzTmZ8xqfsvuFqxQzPHYg
K2uijpH15qc5nlY9daLR0Sg8WGSzt6hDZ7igBWfD8afI1nF86i9GH47n+NUv
G4TyhfqvYWU5hDh3fjt0cejQ269F+0tJVRVyLuZZgTouydGGj6W51m+L89Y/
mdxiUA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{396, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->593813501]
}, Open  ]],

Cell[TextData[{
 "Using the ",
 Cell[BoxData[
  ButtonBox["Constants",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Constants"]], "InlineFormula"],
 " option in ",
 Cell[BoxData[
  ButtonBox["Dt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dt"]], "InlineFormula"],
 " is similar, but has completely unambiguous output:"
}], "ExampleText",
 CellID->50980523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dt", "[", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", "x", ",", "y"}], "]"}], ",", 
   RowBox[{"Constants", "\[Rule]", "f"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->439776662],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Dt", "[", 
    RowBox[{"y", ",", 
     RowBox[{"Constants", "\[Rule]", 
      RowBox[{"{", "f", "}"}]}]}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["g", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "0", ",", "1"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", "x", ",", "y"}], "]"}]}], "+", 
  RowBox[{
   RowBox[{"Dt", "[", 
    RowBox[{"x", ",", 
     RowBox[{"Constants", "\[Rule]", 
      RowBox[{"{", "f", "}"}]}]}], "]"}], " ", 
   RowBox[{
    SuperscriptBox["g", 
     TagBox[
      RowBox[{"(", 
       RowBox[{"0", ",", "1", ",", "0"}], ")"}],
      Derivative],
     MultilineFunction->None], "[", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", "x", ",", "y"}], 
    "]"}]}]}]], "Output",
 ImageSize->{303, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->246452715]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23977],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Constants",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Constants"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->4664]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1679],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->17110],

Cell[TextData[ButtonBox["Total Derivatives",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TotalDerivatives"]], "Tutorials",
 CellID->25898]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->207267284]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Constant - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 30, 3.2454338}", "context" -> "System`", 
    "keywords" -> {
     "differentiation", "numerical constants", "total differentiation"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Constant is an attribute which indicates zero derivative of a symbol \
with respect to all parameters. ", "synonyms" -> {}, "title" -> "Constant", 
    "type" -> "Symbol", "uri" -> "ref/Constant"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4576, 164, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->126667455]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21019, 771}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1819, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2442, 75, 45, 1, 70, "ObjectName",
 CellID->8380],
Cell[2490, 78, 477, 14, 70, "Usage",
 CellID->29815]
}, Open  ]],
Cell[CellGroupData[{
Cell[3004, 97, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3482, 114, 293, 12, 70, "Notes",
 CellID->25951],
Cell[3778, 128, 425, 16, 70, "Notes",
 CellID->6541],
Cell[4206, 146, 333, 13, 70, "Notes",
 CellID->18115]
}, Closed]],
Cell[CellGroupData[{
Cell[4576, 164, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->126667455],
Cell[CellGroupData[{
Cell[4961, 178, 148, 5, 70, "ExampleSection",
 CellID->771520848],
Cell[5112, 185, 169, 5, 70, "ExampleText",
 CellID->114978521],
Cell[CellGroupData[{
Cell[5306, 194, 110, 3, 28, "Input",
 CellID->349131668],
Cell[5419, 199, 244, 8, 36, "Output",
 CellID->150398160]
}, Open  ]],
Cell[5678, 210, 147, 5, 70, "ExampleText",
 CellID->261845355],
Cell[CellGroupData[{
Cell[5850, 219, 107, 3, 28, "Input",
 CellID->415292255],
Cell[5960, 224, 161, 5, 36, "Output",
 CellID->25109521]
}, Open  ]],
Cell[6136, 232, 273, 10, 70, "ExampleText",
 CellID->127610466],
Cell[CellGroupData[{
Cell[6434, 246, 107, 3, 70, "Input",
 CellID->47507856],
Cell[6544, 251, 160, 5, 36, "Output",
 CellID->27887812]
}, Open  ]],
Cell[CellGroupData[{
Cell[6741, 261, 124, 4, 70, "Input",
 CellID->53054931],
Cell[6868, 267, 213, 6, 36, "Output",
 CellID->61266920]
}, Open  ]],
Cell[7096, 276, 125, 3, 70, "ExampleDelimiter",
 CellID->741246873],
Cell[7224, 281, 303, 11, 70, "ExampleText",
 CellID->229601458],
Cell[7530, 294, 139, 4, 70, "Input",
 CellID->162534775],
Cell[CellGroupData[{
Cell[7694, 302, 229, 8, 70, "Input",
 CellID->375713151],
Cell[7926, 312, 820, 30, 39, "Output",
 CellID->776866097]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8795, 348, 216, 7, 70, "ExampleSection",
 CellID->10008],
Cell[9014, 357, 86, 1, 70, "ExampleText",
 CellID->586045741],
Cell[CellGroupData[{
Cell[9125, 362, 425, 13, 70, "Input",
 CellID->89564358],
Cell[9553, 377, 365, 10, 36, "Output",
 CellID->970652295]
}, Open  ]],
Cell[9933, 390, 196, 8, 70, "ExampleText",
 CellID->264450826],
Cell[CellGroupData[{
Cell[10154, 402, 137, 4, 70, "Input",
 CellID->158823365],
Cell[10294, 408, 308, 9, 36, "Output",
 CellID->372739940]
}, Open  ]],
Cell[10617, 420, 258, 9, 70, "ExampleText",
 CellID->354322259],
Cell[CellGroupData[{
Cell[10900, 433, 373, 12, 70, "Input",
 CellID->22581385],
Cell[11276, 447, 1518, 37, 168, "Output",
 CellID->808516664]
}, Open  ]],
Cell[12809, 487, 124, 3, 70, "ExampleDelimiter",
 CellID->30709941],
Cell[12936, 492, 162, 6, 70, "ExampleText",
 CellID->888807626],
Cell[CellGroupData[{
Cell[13123, 502, 414, 14, 70, "Input",
 CellID->360608416],
Cell[13540, 518, 842, 31, 36, "Output",
 CellID->139580940]
}, Open  ]],
Cell[14397, 552, 221, 8, 70, "ExampleText",
 CellID->547512519],
Cell[CellGroupData[{
Cell[14643, 564, 219, 8, 70, "Input",
 CellID->144275285],
Cell[14865, 574, 1623, 31, 70, "Output",
 Evaluatable->False,
 CellID->593813501]
}, Open  ]],
Cell[16503, 608, 367, 13, 70, "ExampleText",
 CellID->50980523],
Cell[CellGroupData[{
Cell[16895, 625, 281, 9, 70, "Input",
 CellID->439776662],
Cell[17179, 636, 1026, 37, 54, "Output",
 CellID->246452715]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18266, 680, 311, 9, 70, "SeeAlsoSection",
 CellID->23977],
Cell[18580, 691, 197, 6, 70, "SeeAlso",
 CellID->4664]
}, Open  ]],
Cell[CellGroupData[{
Cell[18814, 702, 313, 9, 70, "TutorialsSection",
 CellID->1679],
Cell[19130, 713, 131, 3, 70, "Tutorials",
 CellID->17110],
Cell[19264, 718, 144, 3, 70, "Tutorials",
 CellID->25898]
}, Open  ]],
Cell[CellGroupData[{
Cell[19445, 726, 299, 8, 70, "MoreAboutSection"],
Cell[19747, 736, 132, 3, 70, "MoreAbout",
 CellID->207267284]
}, Open  ]],
Cell[19894, 742, 27, 0, 70, "History"],
Cell[19924, 744, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

