(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     41187,       1487]
NotebookOptionsPosition[     32639,       1192]
NotebookOutlinePosition[     34169,       1233]
CellTagsIndexPosition[     34083,       1228]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Array" :> Documentation`HelpLookup["paclet:ref/Array"], 
          "Table" :> Documentation`HelpLookup["paclet:ref/Table"], "Range" :> 
          Documentation`HelpLookup["paclet:ref/Range"], "SparseArray" :> 
          Documentation`HelpLookup["paclet:ref/SparseArray"], 
          "IdentityMatrix" :> 
          Documentation`HelpLookup["paclet:ref/IdentityMatrix"], "UnitVector" :> 
          Documentation`HelpLookup["paclet:ref/UnitVector"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Array\"\>", 2->"\<\"Table\"\>", 
       3->"\<\"Range\"\>", 4->"\<\"SparseArray\"\>", 
       5->"\<\"IdentityMatrix\"\>", 
       6->"\<\"UnitVector\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Lists" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingLists"], 
          "Constructing Matrices" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingMatrices"], 
          "Operations on Vectors" :> 
          Documentation`HelpLookup["paclet:guide/OperationsOnVectors"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60ListManipulation"], 
          "New in 6.0: Matrix & Linear Algebra Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Constructing Lists\"\>", 
       2->"\<\"Constructing Matrices\"\>", 3->"\<\"Operations on Vectors\"\>",
        4->"\<\"New in 6.0: List Manipulation\"\>", 
       5->"\<\"New in 6.0: Matrix & Linear Algebra Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ConstantArray", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ConstantArray",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ConstantArray"], "[", 
       RowBox[{
        StyleBox["c", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]generates a list of ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " copies of the element ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ConstantArray",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ConstantArray"], "[", 
       RowBox[{
        StyleBox["c", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["n", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates an ",
     Cell[BoxData[
      FormBox[
       RowBox[{
        SubscriptBox["n", "1"], "\[Cross]", 
        SubscriptBox["n", "2"], "\[Cross]", "..."}], TraditionalForm]], 
      "InlineMath"],
     " array of nested lists containing copies of the element ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->455185878],

Cell[TextData[{
 "Make a vector of 10 ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 "'s:"
}], "ExampleText",
 CellID->111412784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConstantArray", "[", 
  RowBox[{"c", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->192778414],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "c", ",", "c", ",", "c", ",", "c", ",", "c", ",", "c", ",", "c", ",", "c", 
   ",", "c", ",", "c"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->275245503]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->450946693],

Cell[TextData[{
 "Make a 3\[Times]4 array of ",
 Cell[BoxData[
  StyleBox["c", "TI"]], "InlineFormula"],
 "'s:"
}], "ExampleText",
 CellID->25313002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConstantArray", "[", 
  RowBox[{"c", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79542736],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", ",", "c", ",", "c", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "c", ",", "c", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", "c", ",", "c", ",", "c"}], "}"}]}], "}"}]], "Output",
 ImageSize->{268, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->133834943]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["A machine-zero vector:", "ExampleText",
 CellID->115967637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConstantArray", "[", 
  RowBox[{"0.", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->636327064],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`"}], "}"}]], "Output",
 ImageSize->{259, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145725132]
}, Open  ]],

Cell["A vector of exact zeros:", "ExampleText",
 CellID->293487317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConstantArray", "[", 
  RowBox[{"0", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->957148],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->454224799]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->464731],

Cell["A machine-zero matrix:", "ExampleText",
 CellID->115877065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"zm", " ", "=", " ", 
  RowBox[{"ConstantArray", "[", 
   RowBox[{"0.", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->523591084],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", "0.`", ",", "0.`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{276, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12157678]
}, Open  ]],

Cell["A matrix of exact zeros:", "ExampleText",
 CellID->431881819],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConstantArray", "[", 
  RowBox[{"0", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4916708],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}]], "Output",
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->475223156]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->476572416],

Cell["A vector of ones:", "ExampleText",
 CellID->470355982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConstantArray", "[", 
  RowBox[{"1", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->485246402],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->505024261]
}, Open  ]],

Cell["A machine-number vector of ones:", "ExampleText",
 CellID->465889444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConstantArray", "[", 
  RowBox[{"1.", ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->33406487],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", 
   "1.`", ",", "1.`", ",", "1.`", ",", "1.`"}], "}"}]], "Output",
 ImageSize->{259, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->192704743]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->282595781],

Cell["A deeply nested constant array:", "ExampleText",
 CellID->185049549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ConstantArray", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1", ",", "2", ",", "1", ",", "2"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19571951],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNV9uOAiEM7cy43tfbk4kx8UfWR33aj5gYE30wGvX/EVRcg8TDLAU0GeRw
aXvaTmF+y/NmvSvP21U5Wx7Lw2a7Os0W+6McKjKi7IeI+mOSfSF710f95vIh
qqm20GPCG7cM3K+4vx1Yvq/+0Pw7ifkXqrm1zF7NJRw6aFfrUBRc5bmwddHH
zQ9FmYufiXPBFt3aA99tze//5uovMI9wM6n2f1n3Mb4zq8Vn+Y4xG02pfxxl
R/NoWGeQbLXT6seAOjlsSuEnVEdj++k123JmqZr54JnHm/XfzPIQdtHHaU8v
Mj8TZyJETdHntra6DtajW1lVeQj73gKr2jOIzC/VydF7GUFVCUWCQ0fobOCw
EWVIDD+kuP12RbU7kzVWbNKDZAqbddYcicY9Tk2ZekYA7Q9dC5B+9J772m+P
EnfsJ2AefYej/Qj7fucj/aPA9tvO/xuYO/QouwBVYT20\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{317, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->547828045]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Set up an array to use as storage in a program:", "ExampleText",
 CellID->46530564],

Cell[BoxData[
 RowBox[{
  RowBox[{"esteps", "[", 
   RowBox[{"f_", ",", "x0_", ",", "h_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"res", "=", 
       RowBox[{"ConstantArray", "[", 
        RowBox[{"x0", ",", 
         RowBox[{"{", 
          RowBox[{"n", "+", "1"}], "}"}]}], "]"}]}], ",", 
      RowBox[{"x", "=", "x0"}]}], "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "+=", 
         RowBox[{"h", " ", 
          RowBox[{"f", "[", 
           RowBox[{
            RowBox[{"i", " ", "h"}], ",", "x"}], "]"}]}]}], ";", 
        RowBox[{
         RowBox[{"res", "[", 
          RowBox[{"[", 
           RowBox[{"i", "+", "1"}], "]"}], "]"}], "=", "x"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "n"}], "}"}]}], "]"}], ";", "res"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->338587269],

Cell[TextData[{
 "Numerically solve ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{
     StyleBox["x", "TI"], "'"}], "[", 
    StyleBox["t", "TI"], "]"}], "==", 
   RowBox[{
    StyleBox["1", "TR"], "/", 
    RowBox[{"(", 
     RowBox[{
      StyleBox["t", "TI"], "+", 
      RowBox[{
       RowBox[{
        StyleBox["x", "TI"], "[", 
        StyleBox["t", "TI"], "]"}], "^", 
       StyleBox["2", "TR"]}]}], ")"}]}]}]], "InlineFormula"],
 " using Euler's method:"
}], "ExampleText",
 CellID->1881285],

Cell[BoxData[
 RowBox[{
  RowBox[{"sol", " ", "=", " ", 
   RowBox[{"esteps", "[", 
    RowBox[{
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"t", ",", "x"}], "}"}], ",", 
       RowBox[{"1", "/", 
        RowBox[{"(", 
         RowBox[{"t", "+", 
          RowBox[{"x", "^", "2"}]}], ")"}]}]}], "]"}], ",", "1", ",", ".01", 
     ",", "100"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->422245174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"sol", ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->188637876],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WNtLFUEY386eS0mSZNohiiQrKkmQpJK0ewmiFZKUleAFS4ssL0mH7heK
yorEELsQ3YkeekgKeg2innrtuX9km9nZ23zzmzPrqRbO7s7M9/2+33eZb/ds
S9dIX+/JrpH+nq6KxqGu0339PcMVu08NsSl7lmVZ0+w3mrXYvcPu3N+047Br
9LyanRNsyeYjm8vwWcu9LYuupcSaOCy6agerVsKwVs5u+FQCrLny1ip+ToYr
lpUi7BYoEmmCNl+RSCozpTFkygmurUgkNJwpI2wtGZPH/+WaiRe9vBmIw5nn
ked54X9k6tvADO2Y3AuPpYql2tNzTBG7/zLv/l5Pe9dy70pjWhqZ91kiPX8s
dq3aW0oI7nN3dp47+/rVT7Zwd+yr9cKdLWbnl753Qib14/tvNnPpwpctDVNc
MknwaKzmGtZnOv5bvH/NB/ovosy784G2NyxQXqzaiexiMl4u67JQ79rxhOmy
s/UsWOPZdfNwauBjmIenoW4mQGSHIMARIhKzoxIMqf3AWwHzRLIinhQhQrgq
PSMcry4kPo+grNgn0aBM5ZGLBmBKYpaGNichVoZ4kUdKQXwIZecoXkxI7IoU
9mLd20jeQZ+1Nuno/LYIshp3Yag+rUz6nJ+rsH7wFzhR7+Lj8GEx9Ol+QVzm
KT7dKxwnHfi0Y+tjgTYmEmaHefP7K0UsiXi1p/m5V2tjUl2UQs9vwxpboHh2
Sy8HmN+E0mWQ5U2JZdbPb9AVbkAsVy4lGAZmret6WTuwayWYtGUzeW/9CtRa
pFTaNYnpYhhPjLVEiedlvRyI50XJ8lI+ykTjGEbgPMStMEQg5+TvEHyMOsQy
Dd8c3Af0jZGiVcL6wFi6/b1CqZ+zUJ++i9P1lbC+RgvHyhP9YYiqvrPReK3S
RF/g6foGv67JU0GDsIKqDD4MQK21GoZYutpg40SgxX2o0WCfgNg1Buw+qLVO
YwNL1+aJ6lGJ+wYDmx6Iv1HDBkvXGWx0Qq1NGhudEv8GA3ZHpGB1/QQ9xzZr
rHfAHWLad1sMLA8VhLpNwxGjJZ1w5/Hp7Q7tcQxAYdYGsUzvETuhv2ENYlST
v7sdr6N2d77vOPKOAVO2rQ7tN763fr9p0sSsFdZgkyFve6FWMz/NJjb6j30Q
llqgTouSja0NjxR7TYEu92Wfb4fpPJz4RjxqgnZaDR41Qq39mqhh6TZoIwiA
qI7Ai4N+VgU2c5ty2gatHMzrPdY5HKvm66Fuh6Gm6yWvOo21WudoOpPyNZPu
tm45YowCxV7vFLJrewweYlSOkgTvBL1+foIIRPNTq8WKdmZ/9/YZKqoGokU7
XnT+uLHiqmeE5z7n02olUtQqh3Yn+nWLZmTAkJEqqeYGfR4k4pTHSljfwwZb
WOuMH0ttnVdKHHPG2q2AdnKIXVKwEwSXQr1zGn6hX0ug3sWYscxK3l01xDAL
bV3TcAzruwzq3TDW8Xyo5/7PLYKdMzBZIvl1x6F9M3w6hSyLHU1HM7xrjaH9
A7xxvwLN+K3hPkIHmcwUhD6OMp4iwfS+hsbB5kP3KxntnCwe4m8oxtL1pslI
5pj37Pz50y8NH9rB6Vh8I6f9KwF6v5BUv7pbs/4A2CdSxA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->205397128]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->94625700],

Cell["Find the sum of the elements in a list:", "ExampleText",
 CellID->238205567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"list", "=", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{"9", ",", "20"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48332742],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4", ",", "0", ",", "2", ",", "3", ",", "9", ",", "3", ",", "2", ",", "9", 
   ",", "8", ",", "2", ",", "2", ",", "7", ",", "1", ",", "6", ",", "7", ",", 
   "9", ",", "2", ",", "3", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{371, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->775258007]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"list", ".", 
  RowBox[{"ConstantArray", "[", 
   RowBox[{"1", ",", 
    RowBox[{"Length", "[", "list", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->206927807],

Cell[BoxData["81"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->33208654]
}, Open  ]],

Cell[TextData[{
 "This can also be done with ",
 Cell[BoxData[
  ButtonBox["Total",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Total"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->570703139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", "list", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->240693282],

Cell[BoxData["81"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->278880281]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->161574096],

Cell["\<\
Use a vector of ones to see the effects of conditioning on the solution of a \
linear system:\
\>", "ExampleText",
 CellID->17539983],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ones", " ", "=", " ", 
  RowBox[{"ConstantArray", "[", 
   RowBox[{"1", ",", "10"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->448711572],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{189, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->100258308]
}, Open  ]],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"HilbertMatrix", "[", "10", "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"m", ".", "ones"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->382802299],

Cell["The solution at machine precision has significant errors:", \
"ExampleText",
 CellID->14459683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"LinearSolve", "[", 
   RowBox[{
    RowBox[{"N", "[", "m", "]"}], ",", "b"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->82844860],

Cell[BoxData[
 RowBox[{
  RowBox[{"LinearSolve", "::", "\<\"luc\"\>"}], ":", 
  " ", "\<\"Result for \\!\\(LinearSolve\\) of badly conditioned matrix \
\\!\\({\\(\\({1.`, 0.5`, 0.3333333333333333`, 0.25`, 0.2`, \\(\\(\
\[LeftSkeleton] 20 \[RightSkeleton]\\)\\), 0.14285714285714285`, 0.125`, \
0.1111111111111111`, 0.1`}\\)\\), \\(\\(\[LeftSkeleton] 9 \[RightSkeleton]\\)\
\\)}\\) may contain significant numerical errors.\"\>"}]], "Message", "MSG",
 CellID->845913829],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.0000000017786643`", ",", "0.9999998490437421`", ",", 
   "1.0000031727555616`", ",", "0.9999714532272986`", ",", 
   "1.0001350390595238`", ",", "0.9996312947522822`", ",", 
   "1.0006014991297207`", ",", "0.9994215265763721`", ",", 
   "1.0003024308587822`", ",", "0.9999337317226473`"}], "}"}]], "Output",
 ImageSize->{518, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->281559695]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{"x", "-", "ones"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->27878285],

Cell[BoxData["0.0009732896426644486`"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->74664922]
}, Open  ]],

Cell["At higher precision, the solution is much better:", "ExampleText",
 CellID->46746242],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x30", "=", 
   RowBox[{"LinearSolve", "[", 
    RowBox[{
     RowBox[{"N", "[", 
      RowBox[{"m", ",", "30"}], "]"}], ",", "b"}], "]"}]}], ";"}], "\n", 
 RowBox[{"Norm", "[", 
  RowBox[{"Block", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"$MaxPrecision", "=", "30"}], ",", 
      RowBox[{"$MinPrecision", "=", "30"}]}], "}"}], ",", 
    RowBox[{"x30", "-", "ones"}]}], "]"}], "]"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->440686833],

Cell[BoxData["3.42707739967263571112712880382547439896188`30.*^-36"], "Output",
 ImageSize->{262, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->73749870]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ConstantArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ConstantArray"], "[", 
   RowBox[{
    StyleBox["c", "TI"], ",", " ", 
    StyleBox["dims", "TI"]}], "]"}]], "InlineFormula"],
 " has ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dimensions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dimensions"], "[", 
   StyleBox["dims", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1414140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"dims", " ", "=", " ", 
  RowBox[{"RandomInteger", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "4"}], "}"}], ",", "5"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->460695507],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "1", ",", "3", ",", "4", ",", "3"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->333783548]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dimensions", "[", 
  RowBox[{"ConstantArray", "[", 
   RowBox[{"c", ",", "dims"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->637931636],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "1", ",", "3", ",", "4", ",", "3"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24244680]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->156175481],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ConstantArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ConstantArray"], "[", 
   RowBox[{
    StyleBox["c", "TI"], ",", 
    StyleBox["dims", "TI"]}], "]"}]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"], "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", 
    StyleBox["dims", "TI"], ",", 
    StyleBox["c", "TI"]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->549681204],

Cell[BoxData[
 RowBox[{
  RowBox[{"dims", " ", "=", " ", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], ",", "5"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->368696065],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", " ", "=", " ", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", "}"}], ",", "dims", ",", "c"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6567900],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "0", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 0, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "1", ",", "2", ",", "2", ",", "1"}], "}"}], ",", "c"}],
    "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{240, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->800559374]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConstantArray", "[", 
   RowBox[{"c", ",", "dims"}], "]"}], " ", "\[Equal]", " ", "s"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->292796215],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->459137718]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Normal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Normal"], "[", 
   StyleBox["s", "TI"], "]"}]], "InlineFormula"],
 " is identical to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ConstantArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ConstantArray"], "[", 
   RowBox[{
    StyleBox["c", "TI"], ",", " ", 
    StyleBox["dims", "TI"]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->292518981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConstantArray", "[", 
   RowBox[{"c", ",", "dims"}], "]"}], "===", 
  RowBox[{"Normal", "[", "s", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->377649269],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->47217554]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->292630780],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ConstantArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ConstantArray"], "[", 
   RowBox[{
    StyleBox["c", "TI"], ",", 
    StyleBox["dims", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Apply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apply"], "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      ButtonBox["Table",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Table"], "[", 
      RowBox[{
       StyleBox["c", "TI"], ",", "##"}], "]"}], "&"}], ",", 
    RowBox[{
     ButtonBox["Map",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Map"], "[", 
     RowBox[{
      ButtonBox["List",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/List"], ",", " ", 
      StyleBox["dims", "TI"]}], "]"}]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->748646500],

Cell[BoxData[
 RowBox[{
  RowBox[{"dims", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "4"}], "}"}], ",", "5"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->522951654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ConstantArray", "[", 
   RowBox[{"c", ",", "dims"}], "]"}], "===", 
  RowBox[{"Apply", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{"c", ",", "##"}], "]"}], "&"}], ",", 
    RowBox[{"Map", "[", 
     RowBox[{"List", ",", "dims"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->729295933],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->972025263]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Array",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Array"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Range",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Range"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SparseArray",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SparseArray"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IdentityMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IdentityMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UnitVector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UnitVector"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Constructing Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingLists"]], "MoreAbout",
 CellID->590540326],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingMatrices"]], "MoreAbout",
 CellID->146449862],

Cell[TextData[ButtonBox["Operations on Vectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnVectors"]], "MoreAbout",
 CellID->966637542],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->664547460],

Cell[TextData[ButtonBox["New in 6.0: Matrix & Linear Algebra Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], "MoreAbout",
 CellID->48397348]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ConstantArray - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 30, 2.7454210}", "context" -> "System`", 
    "keywords" -> {
     "constant vector", "constant matrix", "constant tensor", 
      "workspace array", "workspace matrix", "zero vector", "zero matrix", 
      "ones vector", "ones matrix"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ConstantArray[c, n] generates a list of n copies of the element c. \
ConstantArray[c, {n_1, n_2, ...}] generates an n_1*n_2* ... array of nested \
lists containing copies of the element c.", 
    "synonyms" -> {"constant array", "ones", "zeros"}, "title" -> 
    "ConstantArray", "type" -> "Symbol", "uri" -> "ref/ConstantArray"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6227, 173, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33948, 1221}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2366, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2989, 77, 1578, 37, 70, "ObjectNameGrid"],
Cell[4570, 116, 1620, 52, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6227, 173, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[6604, 187, 148, 5, 70, "ExampleSection",
 CellID->455185878],
Cell[6755, 194, 143, 6, 70, "ExampleText",
 CellID->111412784],
Cell[CellGroupData[{
Cell[6923, 204, 133, 4, 28, "Input",
 CellID->192778414],
Cell[7059, 210, 291, 9, 36, "Output",
 CellID->275245503]
}, Open  ]],
Cell[7365, 222, 125, 3, 70, "ExampleDelimiter",
 CellID->450946693],
Cell[7493, 227, 149, 6, 70, "ExampleText",
 CellID->25313002],
Cell[CellGroupData[{
Cell[7667, 237, 180, 6, 28, "Input",
 CellID->79542736],
Cell[7850, 245, 421, 13, 36, "Output",
 CellID->133834943]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8320, 264, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[8544, 273, 65, 1, 70, "ExampleText",
 CellID->115967637],
Cell[CellGroupData[{
Cell[8634, 278, 134, 4, 70, "Input",
 CellID->636327064],
Cell[8771, 284, 311, 9, 36, "Output",
 CellID->145725132]
}, Open  ]],
Cell[9097, 296, 67, 1, 70, "ExampleText",
 CellID->293487317],
Cell[CellGroupData[{
Cell[9189, 301, 130, 4, 70, "Input",
 CellID->957148],
Cell[9322, 307, 291, 9, 36, "Output",
 CellID->454224799]
}, Open  ]],
Cell[9628, 319, 122, 3, 70, "ExampleDelimiter",
 CellID->464731],
Cell[9753, 324, 65, 1, 70, "ExampleText",
 CellID->115877065],
Cell[CellGroupData[{
Cell[9843, 329, 219, 7, 70, "Input",
 CellID->523591084],
Cell[10065, 338, 408, 13, 36, "Output",
 CellID->12157678]
}, Open  ]],
Cell[10488, 354, 67, 1, 70, "ExampleText",
 CellID->431881819],
Cell[CellGroupData[{
Cell[10580, 359, 179, 6, 70, "Input",
 CellID->4916708],
Cell[10762, 367, 391, 13, 36, "Output",
 CellID->475223156]
}, Open  ]],
Cell[11168, 383, 125, 3, 70, "ExampleDelimiter",
 CellID->476572416],
Cell[11296, 388, 60, 1, 70, "ExampleText",
 CellID->470355982],
Cell[CellGroupData[{
Cell[11381, 393, 133, 4, 70, "Input",
 CellID->485246402],
Cell[11517, 399, 291, 9, 36, "Output",
 CellID->505024261]
}, Open  ]],
Cell[11823, 411, 75, 1, 70, "ExampleText",
 CellID->465889444],
Cell[CellGroupData[{
Cell[11923, 416, 133, 4, 70, "Input",
 CellID->33406487],
Cell[12059, 422, 311, 9, 36, "Output",
 CellID->192704743]
}, Open  ]],
Cell[12385, 434, 125, 3, 70, "ExampleDelimiter",
 CellID->282595781],
Cell[12513, 439, 74, 1, 70, "ExampleText",
 CellID->185049549],
Cell[CellGroupData[{
Cell[12612, 444, 213, 7, 70, "Input",
 CellID->19571951],
Cell[12828, 453, 683, 15, 70, "Output",
 Evaluatable->False,
 CellID->547828045]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13560, 474, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[13790, 483, 89, 1, 70, "ExampleText",
 CellID->46530564],
Cell[13882, 486, 964, 31, 70, "Input",
 CellID->338587269],
Cell[14849, 519, 508, 20, 70, "ExampleText",
 CellID->1881285],
Cell[15360, 541, 451, 15, 70, "Input",
 CellID->422245174],
Cell[CellGroupData[{
Cell[15836, 560, 218, 7, 70, "Input",
 CellID->188637876],
Cell[16057, 569, 1847, 34, 70, "Output",
 Evaluatable->False,
 CellID->205397128]
}, Open  ]],
Cell[17919, 606, 124, 3, 70, "ExampleDelimiter",
 CellID->94625700],
Cell[18046, 611, 82, 1, 70, "ExampleText",
 CellID->238205567],
Cell[CellGroupData[{
Cell[18153, 616, 159, 5, 70, "Input",
 CellID->48332742],
Cell[18315, 623, 395, 10, 36, "Output",
 CellID->775258007]
}, Open  ]],
Cell[CellGroupData[{
Cell[18747, 638, 197, 6, 70, "Input",
 CellID->206927807],
Cell[18947, 646, 158, 5, 36, "Output",
 CellID->33208654]
}, Open  ]],
Cell[19120, 654, 204, 8, 70, "ExampleText",
 CellID->570703139],
Cell[CellGroupData[{
Cell[19349, 666, 104, 3, 70, "Input",
 CellID->240693282],
Cell[19456, 671, 159, 5, 36, "Output",
 CellID->278880281]
}, Open  ]],
Cell[19630, 679, 125, 3, 70, "ExampleDelimiter",
 CellID->161574096],
Cell[19758, 684, 143, 4, 70, "ExampleText",
 CellID->17539983],
Cell[CellGroupData[{
Cell[19926, 692, 170, 5, 70, "Input",
 CellID->448711572],
Cell[20099, 699, 291, 9, 36, "Output",
 CellID->100258308]
}, Open  ]],
Cell[20405, 711, 232, 8, 70, "Input",
 CellID->382802299],
Cell[20640, 721, 101, 2, 70, "ExampleText",
 CellID->14459683],
Cell[CellGroupData[{
Cell[20766, 727, 183, 6, 70, "Input",
 CellID->82844860],
Cell[20952, 735, 469, 8, 70, "Message",
 CellID->845913829],
Cell[21424, 745, 483, 12, 36, "Output",
 CellID->281559695]
}, Open  ]],
Cell[CellGroupData[{
Cell[21944, 762, 125, 4, 70, "Input",
 CellID->27878285],
Cell[22072, 768, 178, 5, 36, "Output",
 CellID->74664922]
}, Open  ]],
Cell[22265, 776, 91, 1, 70, "ExampleText",
 CellID->46746242],
Cell[CellGroupData[{
Cell[22381, 781, 495, 16, 70, "Input",
 CellID->440686833],
Cell[22879, 799, 209, 5, 36, "Output",
 CellID->73749870]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23137, 810, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[23378, 819, 478, 18, 70, "ExampleText",
 CellID->1414140],
Cell[CellGroupData[{
Cell[23881, 841, 220, 7, 70, "Input",
 CellID->460695507],
Cell[24104, 850, 233, 7, 36, "Output",
 CellID->333783548]
}, Open  ]],
Cell[CellGroupData[{
Cell[24374, 862, 173, 5, 70, "Input",
 CellID->637931636],
Cell[24550, 869, 232, 7, 36, "Output",
 CellID->24244680]
}, Open  ]],
Cell[24797, 879, 125, 3, 70, "ExampleDelimiter",
 CellID->156175481],
Cell[24925, 884, 561, 21, 70, "ExampleText",
 CellID->549681204],
Cell[25489, 907, 242, 8, 70, "Input",
 CellID->368696065],
Cell[CellGroupData[{
Cell[25756, 919, 195, 6, 70, "Input",
 CellID->6567900],
Cell[25954, 927, 523, 18, 36, "Output",
 CellID->800559374]
}, Open  ]],
Cell[CellGroupData[{
Cell[26514, 950, 176, 5, 70, "Input",
 CellID->292796215],
Cell[26693, 957, 161, 5, 36, "Output",
 CellID->459137718]
}, Open  ]],
Cell[26869, 965, 481, 18, 70, "ExampleText",
 CellID->292518981],
Cell[CellGroupData[{
Cell[27375, 987, 194, 6, 70, "Input",
 CellID->377649269],
Cell[27572, 995, 160, 5, 36, "Output",
 CellID->47217554]
}, Open  ]],
Cell[27747, 1003, 125, 3, 70, "ExampleDelimiter",
 CellID->292630780],
Cell[27875, 1008, 921, 34, 70, "ExampleText",
 CellID->748646500],
Cell[28799, 1044, 232, 8, 70, "Input",
 CellID->522951654],
Cell[CellGroupData[{
Cell[29056, 1056, 364, 12, 70, "Input",
 CellID->729295933],
Cell[29423, 1070, 161, 5, 36, "Output",
 CellID->972025263]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29645, 1082, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[29964, 1093, 1439, 53, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[31440, 1151, 299, 8, 70, "MoreAboutSection"],
Cell[31742, 1161, 147, 3, 70, "MoreAbout",
 CellID->590540326],
Cell[31892, 1166, 153, 3, 70, "MoreAbout",
 CellID->146449862],
Cell[32048, 1171, 152, 3, 70, "MoreAbout",
 CellID->966637542],
Cell[32203, 1176, 164, 3, 70, "MoreAbout",
 CellID->664547460],
Cell[32370, 1181, 197, 4, 70, "MoreAbout",
 CellID->48397348]
}, Open  ]],
Cell[32582, 1188, 27, 0, 70, "History"],
Cell[32612, 1190, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

