(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17611,        610]
NotebookOptionsPosition[     13868,        488]
NotebookOutlinePosition[     15349,        528]
CellTagsIndexPosition[     15264,        523]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Selectable" :> 
         Documentation`HelpLookup["paclet:ref/Selectable"], "Deployed" :> 
         Documentation`HelpLookup["paclet:ref/Deployed"], "GraphicsGroup" :> 
         Documentation`HelpLookup["paclet:ref/GraphicsGroup"], "Inset" :> 
         Documentation`HelpLookup["paclet:ref/Inset"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"Selectable\"\>", 2->"\<\"Deployed\"\>", 
      3->"\<\"GraphicsGroup\"\>", 4->"\<\"Inset\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ContentSelectable", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ContentSelectable",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ContentSelectable"]], "InlineFormula"],
     "\[LineSeparator]is an option to constructs such as ",
     Cell[BoxData[
      ButtonBox["Inset",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Inset"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Graphics",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["GraphicsGroup",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/GraphicsGroup"]], "InlineFormula"],
     " that specifies whether and how content within them should be \
selectable. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28510]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Possible settings are: ", "Notes",
 CellID->10422],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "single clicks immediately select content objects ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[
    "content objects cannot be selected ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["\<\
double\[Hyphen]click allows content selection (default) \
\>", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->30774],

Cell[TextData[{
 "Even with the option ",
 Cell[BoxData[
  RowBox[{"ContentSelectable", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", a complete graphics object is itself selectable. "
}], "Notes",
 CellID->8779]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->68464930],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->323948577],

Cell["\<\
Allow the individual graphics objects to be selectable by a single click:\
\>", "ExampleText",
 CellID->189168641],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Disk", "[", "]"}], ",", 
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"ContentSelectable", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9339115],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}], RectangleBox[{2, -1}, {4, 1}]},
  ContentSelectable->True]], "Output",
 ImageSize->{184, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112626532]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->445946109],

Cell["\<\
No individual object is selectable; the whole graphic appears as one object:\
\>", "ExampleText",
 CellID->118110927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Disk", "[", "]"}], ",", 
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"ContentSelectable", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->713606423],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}], RectangleBox[{2, -1}, {4, 1}]},
  ContentSelectable->False]], "Output",
 ImageSize->{184, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->238776575]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->172648066],

Cell["\<\
The first click selects the whole graphic, and subsequent clicks select \
individual objects:\
\>", "ExampleText",
 CellID->448229726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Disk", "[", "]"}], ",", 
     RowBox[{"Rectangle", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"4", ",", "1"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"ContentSelectable", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184691575],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}], RectangleBox[{2, -1}, {4, 1}]},
  ContentSelectable->Automatic]], "Output",
 ImageSize->{184, 77},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44067148]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4460],

Cell["\<\
No individual object is selectable; the graphics complex appears as one \
object:\
\>", "ExampleText",
 CellID->82279554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Blue", ",", 
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1.5"}], ",", ".5"}], "}"}], ",", ".5"}], "]"}], ",", 
     "Pink", ",", 
     RowBox[{"GraphicsComplex", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", ".5"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Disk", "[", 
          RowBox[{"1", ",", ".5"}], "]"}], ",", 
         RowBox[{"Rectangle", "[", "2", "]"}]}], "}"}]}], "]"}]}], "}"}], ",",
    
   RowBox[{"ContentSelectable", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53007151],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[0, 0, 1], DiskBox[{-1.5, 0.5}, 0.5]}, 
   {RGBColor[1, 0.5, 0.5], 
    GraphicsComplexBox[{{0, 0.5}, {1, 0}}, {DiskBox[1, 0.5], 
      RectangleBox[2]}]}},
  ContentSelectable->False]], "Output",
 ImageSize->{184, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->57221656]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->296645453],

Cell["\<\
No individual object is selectable; the graphics group appears as one object:\
\
\>", "ExampleText",
 CellID->707454389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Blue", ",", 
    RowBox[{"Disk", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "0"}], "}"}], "]"}], ",", 
    RowBox[{"GraphicsGroup", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Pink", ",", 
        RowBox[{"Disk", "[", "]"}], ",", 
        RowBox[{"Rectangle", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2", ",", 
            RowBox[{"-", "1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"4", ",", "1"}], "}"}]}], "]"}]}], "}"}], ",", 
      RowBox[{"ContentSelectable", "\[Rule]", "False"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->421907420],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0, 0, 1], DiskBox[{-3, 0}], GraphicsGroupBox[
    {RGBColor[1, 0.5, 0.5], 
     GraphicsGroupBox[{DiskBox[{0, 0}], RectangleBox[{2, -1}, {4, 1}]}]},
    ContentSelectable->False]}]], "Output",
 ImageSize->{184, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29808899]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15495],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Selectable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Selectable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Deployed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Deployed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsGroup",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsGroup"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5764]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ContentSelectable - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 30, 4.1048308}", "context" -> "System`", 
    "keywords" -> {
     "selecting contents", "protecting contents", "non-editable contents", 
      "editable contents", "selecting graphics", "editing graphics"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ContentSelectable is an option to constructs such as Inset, Graphics and \
GraphicsGroup that specifies whether and how content within them should be \
selectable. ", "synonyms" -> {"content selectable"}, "title" -> 
    "ContentSelectable", "type" -> "Symbol", "uri" -> 
    "ref/ContentSelectable"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5923, 180, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->68464930]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15122, 516}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 865, 18, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1488, 45, 1582, 37, 70, "ObjectNameGrid"],
Cell[3073, 84, 955, 29, 70, "Usage",
 CellID->28510]
}, Open  ]],
Cell[CellGroupData[{
Cell[4065, 118, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4543, 135, 56, 1, 70, "Notes",
 CellID->10422],
Cell[4602, 138, 1001, 26, 70, "2ColumnTableMod",
 CellID->30774],
Cell[5606, 166, 280, 9, 70, "Notes",
 CellID->8779]
}, Closed]],
Cell[CellGroupData[{
Cell[5923, 180, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->68464930],
Cell[CellGroupData[{
Cell[6307, 194, 148, 5, 70, "ExampleSection",
 CellID->323948577],
Cell[6458, 201, 124, 3, 70, "ExampleText",
 CellID->189168641],
Cell[CellGroupData[{
Cell[6607, 208, 470, 15, 28, "Input",
 CellID->9339115],
Cell[7080, 225, 272, 8, 98, "Output",
 CellID->112626532]
}, Open  ]],
Cell[7367, 236, 125, 3, 70, "ExampleDelimiter",
 CellID->445946109],
Cell[7495, 241, 127, 3, 70, "ExampleText",
 CellID->118110927],
Cell[CellGroupData[{
Cell[7647, 248, 473, 15, 70, "Input",
 CellID->713606423],
Cell[8123, 265, 273, 8, 98, "Output",
 CellID->238776575]
}, Open  ]],
Cell[8411, 276, 125, 3, 70, "ExampleDelimiter",
 CellID->172648066],
Cell[8539, 281, 144, 4, 70, "ExampleText",
 CellID->448229726],
Cell[CellGroupData[{
Cell[8708, 289, 477, 15, 70, "Input",
 CellID->184691575],
Cell[9188, 306, 276, 8, 98, "Output",
 CellID->44067148]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9513, 320, 215, 7, 70, "ExampleSection",
 CellID->4460],
Cell[9731, 329, 131, 4, 70, "ExampleText",
 CellID->82279554],
Cell[CellGroupData[{
Cell[9887, 337, 830, 27, 70, "Input",
 CellID->53007151],
Cell[10720, 366, 367, 11, 72, "Output",
 CellID->57221656]
}, Open  ]],
Cell[11102, 380, 125, 3, 70, "ExampleDelimiter",
 CellID->296645453],
Cell[11230, 385, 130, 4, 70, "ExampleText",
 CellID->707454389],
Cell[CellGroupData[{
Cell[11385, 393, 723, 23, 70, "Input",
 CellID->421907420],
Cell[12111, 418, 362, 10, 72, "Output",
 CellID->29808899]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12534, 435, 311, 9, 70, "SeeAlsoSection",
 CellID->15495],
Cell[12848, 446, 948, 35, 70, "SeeAlso",
 CellID->5764]
}, Open  ]],
Cell[13811, 484, 27, 0, 70, "History"],
Cell[13841, 486, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

