(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13481,        483]
NotebookOptionsPosition[     10129,        369]
NotebookOutlinePosition[     11432,        407]
CellTagsIndexPosition[     11347,        402]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Contexts" :> 
          Documentation`HelpLookup["paclet:tutorial/Contexts"], 
          "Manipulating Symbols and Contexts by Name" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingSymbolsAndContextsByName"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Contexts\"\>", 
       2->"\<\"Manipulating Symbols and Contexts by Name\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Begin" :> Documentation`HelpLookup["paclet:ref/Begin"], 
          "$ContextPath" :> 
          Documentation`HelpLookup["paclet:ref/$ContextPath"], "Remove" :> 
          Documentation`HelpLookup["paclet:ref/Remove"], "$Context" :> 
          Documentation`HelpLookup["paclet:ref/$Context"], "Contexts" :> 
          Documentation`HelpLookup["paclet:ref/Contexts"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Begin\"\>", 
       2->"\<\"$ContextPath\"\>", 3->"\<\"Remove\"\>", 4->"\<\"$Context\"\>", 
       5->"\<\"Contexts\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atomic Elements of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AtomicElementsOfExpressions"], "Symbol Handling" :> 
          Documentation`HelpLookup["paclet:guide/SymbolHandling"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Atomic Elements of Expressions\"\>",
        2->"\<\"Symbol Handling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Context", "ObjectName",
 CellID->11192],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Context",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Context"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the current context. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Context",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Context"], "[", 
       StyleBox["symbol", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the context in which a symbol appears. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->1454]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The current context is the value of ",
 Cell[BoxData[
  ButtonBox["$Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15869]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->17708438],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->316069979],

Cell[TextData[{
 "Give the current context. The default is ",
 Cell[BoxData["\"\<Global`\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellContext->"Global`",
 CellID->1035369981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->70215566],

Cell[BoxData["\<\"Global`\"\>"], "Output",
 CellContext->"Global`",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4287741]
}, Open  ]],

Cell["If a new symbol is created, it will have this context:", "ExampleText",
 CellContext->"Global`",
 CellID->533837196],

Cell[CellGroupData[{

Cell[BoxData["newsymbol"], "Input",
 CellContext->"Global`",
 CellLabel->"In[2]:=",
 CellID->675276971],

Cell[BoxData["newsymbol"], "Output",
 CellContext->"Global`",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->377198061]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "newsymbol", "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[3]:=",
 CellID->25437285],

Cell[BoxData["\<\"Global`\"\>"], "Output",
 CellContext->"Global`",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->590498967]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellContext->"Global`",
 CellID->114826844],

Cell["Give the context of an existing symbol:", "ExampleText",
 CellContext->"Global`",
 CellID->783496258],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "Context", "]"}]], "Input",
 CellContext->"Global`",
 CellLabel->"In[1]:=",
 CellID->309069235],

Cell[BoxData["\<\"System`\"\>"], "Output",
 CellContext->"Global`",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68339202]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19793],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Begin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Begin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ContextPath",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ContextPath"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Remove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Remove"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Context",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Context"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Contexts",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Contexts"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18634]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->681],

Cell[TextData[ButtonBox["Contexts",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Contexts"]], "Tutorials",
 CellID->27465],

Cell[TextData[ButtonBox["Manipulating Symbols and Contexts by Name",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingSymbolsAndContextsByName"]], "Tutorials",
 CellID->7720]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "MoreAbout",
 CellID->39094868],

Cell[TextData[ButtonBox["Symbol Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolHandling"]], "MoreAbout",
 CellID->102639792]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Context - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 30, 4.5267166}", "context" -> "System`", 
    "keywords" -> {
     "namespaces", "qualified name", "namespace", "private name", 
      "full name"}, "index" -> True, "label" -> "Built-in Mathematica Symbol",
     "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "Context[] gives the current context. Context[symbol] gives the context \
in which a symbol appears. ", "synonyms" -> {}, "title" -> "Context", "type" -> 
    "Symbol", "uri" -> "ref/Context"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4648, 145, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->17708438]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11205, 395}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2472, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3095, 84, 45, 1, 70, "ObjectName",
 CellID->11192],
Cell[3143, 87, 743, 23, 70, "Usage",
 CellID->1454]
}, Open  ]],
Cell[CellGroupData[{
Cell[3923, 115, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4401, 132, 210, 8, 70, "Notes",
 CellID->15869]
}, Closed]],
Cell[CellGroupData[{
Cell[4648, 145, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->17708438],
Cell[CellGroupData[{
Cell[5032, 159, 148, 5, 70, "ExampleSection",
 CellID->316069979],
Cell[5183, 166, 183, 6, 70, "ExampleText",
 CellID->1035369981],
Cell[CellGroupData[{
Cell[5391, 176, 122, 4, 28, "Input",
 CellID->70215566],
Cell[5516, 182, 195, 6, 36, "Output",
 CellID->4287741]
}, Open  ]],
Cell[5726, 191, 122, 2, 70, "ExampleText",
 CellID->533837196],
Cell[CellGroupData[{
Cell[5873, 197, 103, 3, 28, "Input",
 CellID->675276971],
Cell[5979, 202, 191, 6, 36, "Output",
 CellID->377198061]
}, Open  ]],
Cell[CellGroupData[{
Cell[6207, 213, 135, 4, 70, "Input",
 CellID->25437285],
Cell[6345, 219, 197, 6, 36, "Output",
 CellID->590498967]
}, Open  ]],
Cell[6557, 228, 150, 4, 70, "ExampleDelimiter",
 CellID->114826844],
Cell[6710, 234, 107, 2, 70, "ExampleText",
 CellID->783496258],
Cell[CellGroupData[{
Cell[6842, 240, 134, 4, 70, "Input",
 CellID->309069235],
Cell[6979, 246, 196, 6, 36, "Output",
 CellID->68339202]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7236, 259, 311, 9, 70, "SeeAlsoSection",
 CellID->19793],
Cell[7550, 270, 1184, 44, 70, "SeeAlso",
 CellID->18634]
}, Open  ]],
Cell[CellGroupData[{
Cell[8771, 319, 312, 9, 70, "TutorialsSection",
 CellID->681],
Cell[9086, 330, 127, 3, 70, "Tutorials",
 CellID->27465],
Cell[9216, 335, 190, 4, 70, "Tutorials",
 CellID->7720]
}, Open  ]],
Cell[CellGroupData[{
Cell[9443, 344, 299, 8, 70, "MoreAboutSection"],
Cell[9745, 354, 168, 3, 70, "MoreAbout",
 CellID->39094868],
Cell[9916, 359, 141, 3, 70, "MoreAbout",
 CellID->102639792]
}, Open  ]],
Cell[10072, 365, 27, 0, 70, "History"],
Cell[10102, 367, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

