(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11411,        391]
NotebookOptionsPosition[      8725,        303]
NotebookOutlinePosition[     10001,        339]
CellTagsIndexPosition[      9917,        334]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Contexts" :> 
          Documentation`HelpLookup["paclet:tutorial/Contexts"], 
          "Manipulating Symbols and Contexts by Name" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingSymbolsAndContextsByName"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Contexts\"\>", 
       2->"\<\"Manipulating Symbols and Contexts by Name\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$Packages" :> Documentation`HelpLookup["paclet:ref/$Packages"],
           "$ContextPath" :> 
          Documentation`HelpLookup["paclet:ref/$ContextPath"], "Names" :> 
          Documentation`HelpLookup["paclet:ref/Names"], "Context" :> 
          Documentation`HelpLookup["paclet:ref/Context"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"$Packages\"\>", 2->"\<\"$ContextPath\"\>", 
       3->"\<\"Names\"\>", 4->"\<\"Context\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Low-Level System Spelunking" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelSystemSpelunking"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Low-Level System Spelunking\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Contexts", "ObjectName",
 CellID->24865],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Contexts",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Contexts"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of all contexts. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Contexts",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Contexts"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the contexts which match the string. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->10938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Contexts",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Contexts"]], "InlineFormula"],
 " allows abbreviated string patterns containing the following \
metacharacters:"
}], "Notes",
 CellID->23859],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "*", Cell[
    "zero or more characters", "TableText"]},
   {Cell["      ", "TableRowIcon"], "@", Cell[
    "one or more characters, excluding upper-case letters", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell["\\\\*, etc.", "TableText"], Cell[
    "literal *, etc.", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->439942953]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->171269150],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->411876865],

Cell[TextData[{
 "Give all contexts starting with ",
 Cell[BoxData["\"\<As\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->30420941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Contexts", "[", "\"\<As*\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88420997],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Assumptions`\"\>", ",", "\<\"AssumptionsDump`\"\>"}], 
  "}"}]], "Output",
 ImageSize->{226, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5354899]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2661],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Packages",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Packages"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ContextPath",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ContextPath"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Names",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Names"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Context",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Context"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26063]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9257],

Cell[TextData[ButtonBox["Contexts",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Contexts"]], "Tutorials",
 CellID->22750],

Cell[TextData[ButtonBox["Manipulating Symbols and Contexts by Name",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingSymbolsAndContextsByName"]], "Tutorials",
 CellID->28614]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Low-Level System Spelunking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelSystemSpelunking"]], "MoreAbout",
 CellID->521623450]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Contexts - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 30, 4.7454722}", "context" -> "System`", 
    "keywords" -> {"context names", "all name qualifiers"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Contexts[] gives a list of all contexts. Contexts[\"string\"] gives a \
list of the contexts which match the string. ", "synonyms" -> {}, "title" -> 
    "Contexts", "type" -> "Symbol", "uri" -> "ref/Contexts"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5094, 157, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->171269150]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9774, 327}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2245, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2868, 81, 46, 1, 70, "ObjectName",
 CellID->24865],
Cell[2917, 84, 774, 23, 70, "Usage",
 CellID->10938]
}, Open  ]],
Cell[CellGroupData[{
Cell[3728, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4206, 129, 245, 8, 70, "Notes",
 CellID->23859],
Cell[4454, 139, 603, 13, 70, "2ColumnTableMod",
 CellID->439942953]
}, Closed]],
Cell[CellGroupData[{
Cell[5094, 157, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->171269150],
Cell[CellGroupData[{
Cell[5479, 171, 148, 5, 70, "ExampleSection",
 CellID->411876865],
Cell[5630, 178, 142, 5, 70, "ExampleText",
 CellID->30420941],
Cell[CellGroupData[{
Cell[5797, 187, 113, 3, 28, "Input",
 CellID->88420997],
Cell[5913, 192, 247, 8, 36, "Output",
 CellID->5354899]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6221, 207, 310, 9, 70, "SeeAlsoSection",
 CellID->2661],
Cell[6534, 218, 943, 35, 70, "SeeAlso",
 CellID->26063]
}, Open  ]],
Cell[CellGroupData[{
Cell[7514, 258, 313, 9, 70, "TutorialsSection",
 CellID->9257],
Cell[7830, 269, 127, 3, 70, "Tutorials",
 CellID->22750],
Cell[7960, 274, 191, 4, 70, "Tutorials",
 CellID->28614]
}, Open  ]],
Cell[CellGroupData[{
Cell[8188, 283, 299, 8, 70, "MoreAboutSection"],
Cell[8490, 293, 163, 3, 70, "MoreAbout",
 CellID->521623450]
}, Open  ]],
Cell[8668, 299, 27, 0, 70, "History"],
Cell[8698, 301, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

