(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    227121,       4224]
NotebookOptionsPosition[    223191,       4095]
NotebookOutlinePosition[    224443,       4131]
CellTagsIndexPosition[    224356,       4126]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Density and Contour Plots" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DensityAndContourPlots"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Density and Contour Plots\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mesh" :> Documentation`HelpLookup["paclet:ref/Mesh"], 
          "MeshFunctions" :> 
          Documentation`HelpLookup["paclet:ref/MeshFunctions"], 
          "ContourStyle" :> 
          Documentation`HelpLookup["paclet:ref/ContourStyle"], 
          "ContourLabels" :> 
          Documentation`HelpLookup["paclet:ref/ContourLabels"], 
          "ContourShading" :> 
          Documentation`HelpLookup["paclet:ref/ContourShading"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Mesh\"\>", 
       2->"\<\"MeshFunctions\"\>", 3->"\<\"ContourStyle\"\>", 
       4->"\<\"ContourLabels\"\>", 
       5->"\<\"ContourShading\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Plotting Options\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Contours", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Contours",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Contours"]], "InlineFormula"],
     "\[LineSeparator]is an option for contour plots that specifies the \
contours to draw. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21476]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The following settings can be given for ",
 Cell[BoxData[
  ButtonBox["Contours",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Contours"]], "InlineFormula"],
 ":"
}], "Notes",
 CellID->6334],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "contours at ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " equally spaced levels "
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "contours chosen automatically ", "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"], ",", 
      StyleBox["n", "TI"]}], "}"}], Cell[TextData[{
     "at most ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " contours chosen automatically"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "contours at levels ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["gr", "TI"], 
         StyleBox["1", "TR"]]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[TextData[{
     "contours drawn with graphics directives ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["gr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"]
    }], "TableText"]},
   {Cell["\[FilledVerySmallSquare]", "TableRowIcon",
     FontColor->None], 
    StyleBox["func", "TI"], Cell[TextData[{
     "a function to be applied to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " to get the list of contours"
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], None, 
     Dynamic[
      If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
       RGBColor[0.92, 1, 0.59], None]], {
      Dynamic[
       If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
        RGBColor[0.92, 1, 0.59], None]]}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->485],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " settings, \"nice\" equally spaced contour levels are chosen, whose values \
minimize the number of digits in their decimal representation. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->26843],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListContourPlot"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Contours",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Contours"]], "InlineFormula"],
 " specifies contour lines. "
}], "Notes",
 CellID->16371],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["ContourPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot3D"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListContourPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListContourPlot3D"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Contours",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Contours"]], "InlineFormula"],
 " specifies contour surfaces. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->16760],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ContourPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ContourPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot3D"]], "InlineFormula"],
 " let you give an equation ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "==", 
   StyleBox["g", "TI"]}]], "InlineFormula"],
 " or a list of equations as a way to specify single contours to draw. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->5752]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->916915954],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->2642354],

Cell["Automatically select contours:", "ExampleText",
 CellID->928250401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1783277799],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFnQmUVcW194mg0RiV4IREjfqMSZyewzOOWI1IolGcYpA4olHf5xSRaKI4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   "], {{{}, 
     {RGBColor[0.3441169110780499, 0.14555959182307163`, 0.6006782639620051], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVktsVVUUPe/Xd+97t9EEppaaFJs2CjM0xPgZtDrRVlDbKNoWGpN+sIIT
jE5MHLT4SQstxoExCtqBn7ZAsaKxLSUYdaDIr4A0EhUSkYTWKJYquFbXMh2c
nHP32Xd/19773Lqxa92z6RDCLFYGayoXwnslIXwE4iTOCyDekgphOgrhZBxC
EfTHsA8nutuK9TNofeApz4dQg/Uhvm8vhnAH1nxWNN5dxbm/EMIG0OtxnsU/
s+BtwP4WdP4DWefw3Yzvh7HKsK6Ddhh2lKfEdwX3v8LOz6G/JdZ9PeiHwPMj
6Dtz0kddB8DzTCQbq7H+wHrJMuYykvMD7DmG9S74d2A9mJWc9VnRYvDeBT1r
wTPrf7ohAypCVUa0X3DuA+8DWKdwfgN678Y/W+HTbjA+AjqO4VHs67Dg/uJO
HRC76DN9p791WcUGbiz6PWXfH0opD6dB3w6fDheUsC0l2i9i2wW9b2K9CFof
1kROuaCvpB1Jy9YK20+Z4znJ5T7h82Iusc6Cpw17E9YKx7jed4zlfFrxZG75
/zT4jxeEFeJkMC/7iaUu6K9Myd9W7JuwVmI9jTjdXBrCT2nF67kSxbzX+ae/
tIcYo17aOG6/aBf/o20bIeezRHyUwbgwJp24uw0L16HOftAvypm0v7TxkOP8
L/w6b5n7QdsGORFrAb7054SR1yPhmHkagM7aWLFtdqzOQH5lRrbxex8SfiPR
//xutm/DOeGUcXsFMquKwg9jwxiBFIag/zfWIb6PRsLxtZT82mzfGn2+ELR3
+rws0pm+t1gvbVse6e5SXrQW11uD80K9jHG5a5n4mkspnrSXdNpMm2atizHv
cu4+KFFd8+4m5PZJGDCD71Xwbw3idg78q6DkRiycs56IS2LynazqhTEfA//7
sepsIKO927ihnaxF8ta5vhgX4rHDMeiwba8lygHj/zHOj8eqjxXGOvHA/Nfm
VfvV4J0qqKZJ2+Ge0AZaO1ZVVjHvcfyZZ+KG8ra4hxG/L0DPtlh18jzohax6
z1OQv6ugftBhmy8Yn23GKHvbvQX1N2K017VwOS8/O8zb7pw2+fuM8dPg+FD2
guWzzppi2ZuG7OPIwQTkX4U930TK8UhOPZs5IubpP+t3CHFrjeQf/UjZl/2M
baL+zdqjvayjfTn1PualBjr7E9XS1wXhmD6c99ygvz24rykKbzOuG9bICfB+
VxAezjqujMedoK2B3CHQTkXqO+w5xN0VzxTG6ve8/GpwnTAO7PfzRfX3HtOJ
+Ubz8TzrM/npx568bFjvmcA+RnsYD9pEvHwVCTOsK9YX667deanzrCMOaN/f
0H8ykizGgTOKsXg5Vn9nzbGnDBjzjP3eRPqOgSddqrt7CprHnMWcdQcTyWIO
6o1tyuk2Hhhb9ibGtxX/fZFo3s8kmnOcZ+yjm2Llk31rr2unE7oOFBXzCueY
+SX23y6RH8O4v55oDn+KfSzRHWfyTvft+yHnvoIwNI77LxP1jFHszbHksGbY
+xbch6mLPYJ54DdzQT0jRcllPfVGqiliq9qzPlWqPvJ/76jyvB7NSQ7Pn0BO
Q6x8sr+xL3OWMxaj5jkK+d8X1J9YH6wTvhWIr+XRUs557rD+tbHmJG0mhuhD
O+7HYuGAvPyf/KyzQdfaoOuOPekJ8I4k6infRqpV4rkxlt20mbyT7lO1uH81
kRxigvesF85e2khMMrYL7jvELmWXmafLc5O5mcssvZWO+N212fXCvsc3y4z/
pR+X7cs1196cc7fHvlN/ZWppLi9zrE7AqNWR3kVlnkWnPYP4Rpl2n9/tGqSs
Cs8M9gDikpicsx2U3+W3xEW/aQcdT95fMs9K1wTnTuw3CuuaWJ90Lhgnzl/2
A2Jtu7H9J85/FXW3IdacYyz45l3td+9/nY+bvQ==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllMtvjFEYxs9887WZ7ztf/wgrmRLdESUui152KHFtkZZNF2htKlYSiaBT
qh1iIULCBpkaLQ1CG+Nad2ktpELs7KZ1G/ffk3fxJO9z3st5b+fMad/dsitw
zjWBENRHzu0DFQ5n0879Qw5i58aQq9AvRF4ECuin4VPoJ4FH9pw9zDjXi76J
YP2ghKIBfU+1c8MEeAbfAT8Pvwc/hv1r7M9huxZ0oevkbC/3lYl3HDmPvgXd
OjCKvgji0GwOof9KzM/EKhDzCfwx9j9Tzs2AOnibN1/lmEM3H6ECbwaDCflj
kwksx6vwYXAaeZqzl9j3oV+D7VlwFF0vGOS+y+ife6tJtZSqzHYAn1Wh+RTR
PeLsRGg+X+B38b9I/DL5PYUvw/4XtYyjv++tZ+rVCFhMrSex34/9DDYd8Fvw
v8ifuL8T34PEf0ttWe6Yh+8QGMD3OzyocS4FstjnwU5stxLjA75z4ZuQW8F7
+G/4KLFHwEf4Ge68k9hMNAvlvAG5oDNs3wVWa46Yq0OrWbWqx+qtat6GfRv4
k7Y7b+LbHlnu3ZwtRc5xtofY3eCbtx6pN5rpbXSN3nqtnemJbOaatXZUsW8k
lqvuWB7bTDQL9Uixl2DTVW13vED/KrZZauZbIuuJeqEe1OG7wNtua0fkewC4
tMU4Rbw8eBDYTBrRvYmstzqb8DZTzXIMDGG7MbJeacba3ZXcnwpthyvY/gBR
YG9gRWwz16xlc0GzIUY5bTPcDr+eWO80owZ8r8D7yeUSvIi8ObLd1YxKxJvI
2FtQDesjy1G5yadV9WbsbWuGWXitt7ernZpC15fYbJTjEeTDid2lHbuW2A5p
d/Rm9Fb1pvWW9WbrY9tp7bJq0N+gHdVu6o/4D4SbqxY=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4455187332341498, 0.32186997546921486`, 0.7432107918860154], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGuMVVcVx8/ce+fee865QyGpCO1QQwJqweKr1IjvR/vBZ4UWlHcorZVq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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllnusz3UYx7/n+/v+fr63gzbrgmq2KIQkaq11HSuty2xobiEpcvnHH2mr
TUnHtYRz3BNzbcr1OHIrsnBQ7g6VZq3LkFqR5NLrvfcfz/bcP8/383me9/Nt
NnBktxFhEATzoQhqUB4EfZIg+A5l93pB0BP+0zwIppWCYDoUYj+E7kZ8G2F/
MA2CB5DX4b8T+ioOgu3o5sP/WhYEHbHdkwXB+QJ5ZMc2AZ9x2GZw4Cz4eej6
wfeHcvjn8b+tGAS7iBmG3IkcV7C1hjZSy0DkBdTyETSY+Gp0c+H3UtMKYt9G
twt+fNG5ZyK/GPmMldjH4T+05BonwndBdwO+w0v2TdFdKzrmOWwjyDGbem9F
txpbL86fiW8VNAB+E7qP4U+Tr4r4Wfj3IrZP5Lt7AZ8ZJd9hB/j25Lwa+U6O
43sMXWPqXYquAv8W2JeR6zX8dyPvharhr6J7F99nsW8itgB9zXk7yLEc2+/U
WIt9DLrN5JuE7hVsr0I1+C5FPor9OPZFnFWF7pHU36Daf4IWwvcg/x186z7O
7IS9LfJl/M/hvxh7DfJs7PuxN6Qf+qGr5bye9MNb8CPJPxf7tdB3UYncO/Kd
rCV2Uu67voTcDntf7FPw/4X87bC3gVaGPvME+eqgFuRvgm46sZ0T99p89YN6
lfhl8KMKrq2s3L2pGpdgP0XMBWytoa6c9xRUjn996F78hyOvDv0mH5CrEjnV
WdxnBXxTfM5hewLqTr6H0Z3AXhe69i+QJ0f+hurMPaterUR+FP4xqBtnr8f/
GrWsyvxWGTWuh1+XeTbO4rMz9pk6633odc4bDVVjH0XMVuK3Qb+R+ybNLHw9
6DLyzficIHYqOWaSa4V6EP4i8euRJ+PTHn4APs2wnYFu16xB+wN/453i8ZmK
/9/Ii5GXZH6bZlAPbCs5r2HRd6BeOky+hZF7qhy+vu6v4DfT2xxDXhL5jZ6E
702+lsSHxDeBf4d8Q+iHs9ibI9+XuFdVg96iL7rWRb9JHfLJ1N9WH/k0+ZPc
b9s09Cy0wv9C5JkoYvsx9t30RdcJfnBmrNHMFfB/OnUvNAo863NT+2rmX8Z3
UObe2whtwrYVmoj9Z+zfwh+A5iFPQ26J71jO+LDgGgYid4ydWzPQDv5I4tnT
N92CvTFUERmznlF84tneWjD23Z969oSBR4m/hM8fxJZBW1K/sd5WNW3MXLNq
1Qxux/YePo9HPmMz/I7Ytc8JjTV3ZX5rYU4pN4YJu9RTnbGNRzes5DevoJ6y
1LU1LRqrR8TGRmH2IuwdU/dyc+QqYitz9/4b5GgjPEndS8Koi3qrzL2tnv4H
vjb2bjiDPJrYVomxTD08FvmTzLWrZzYjD0qMXcJw9fbyzNivHn8p8c7QrhBG
C9tUo2oTxvXXbGCfU/IOqYHfAJ0KrVudeWY1qxfJNynxjtJuUo/vwfZmYmwW
xnQR1uf+Vu3I3ol3qnapMPIw3xYSvwXfIjEPYZ+S+y03hN6lP+TGVu3UOvwv
Z8a2HLk2N8YKW7UTVuXGJGGRdsx1+LbEtCr6jAm5v0G16w3/hT/E+Qsi91CG
Pc49O9p5B4ndpxmIvGNqyDc0NtYIw9bovpH3BN6Bn+fewdq92sna7WMSf4t2
vGb/ZOzdJgxYi/+63LtT/xjC3g3UVFU0BgtLjuH/Z9GYsgbbdfwbcH/ny3z2
Z7n/RVTDntg9o16Zhf8B5N2p+bPojgqrY9+dMFHffjA1tusOOsB/n3vXCQOv
ZMYYYctf+gdIvOO029QT/yXGUGGndup0YX/s2S9pP+fGcGG3/jE0e8I4YZtm
8BvkI7F3lzDjS+Rtqf+VtEP2p8ZIYaPeYCj8EOFdaEzpk/lMnaU31i7TTGoW
tdN0V9qx2q26M+3SuzPfnXbq/23nZHo=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5469205553902496, 0.49818035911535813`, 0.8857433198100256], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmGuwlVUZx9+z9/ue/V724dg4IB7k4ggcBDMRjk1DJvYhpNQaK7sKCAL2
QdQPKTVjMwJe4OAFHZVz4q4yY6XTGGTc02oMFXEMRZBbiiXUmJfUFK3+P/4P
c2b2mnfttZ713G9rnT792svm1JIkebclSer6DtGfGzRZpv9XtCbJVI39ml9e
JcmaIklGaO+5ZpJs11invWVlkszR+GyaJLMEc16ukSVJp2BvbPr8Yu3dJLxb
hf+AcE3T2ibNF2WmAf7bBH9KW5Kkwj+l1esbBHOPcE8Q3ktSn7syzmaCawjn
yZofDJy/0vxF0VwiXO3aH1w33ceC7k9rhlnZSJI9wveo5g3hziv/Xyj4V1LD
nI1MGn/T2je039R8RGK4vXH2Tcn6F9F7QTBbRH+7vh2isVbwD2vcIvmWipeP
muYFebsblusi4Xteoylct+n7lHC9IR4nZcY3XjBN4ThT5xfWLM9OjVGan5pZ
Ty2azxLu2RqXif7jdX+Rc1Th85w93OIvdBc3zAO8MND9xsRnOYeentB8qeb/
1Hys8BzT6K0ZdlHN8Nhjn2hdrO828f9kaTsPqiwPspwpvv4tuSbozPe0/l2N
TtG8u2588AWO/Rr44LzMfEAj1/epsPFW4fhtafp3ae0BrT2d2Bfv1nyn5s8I
x106f6jFZzl3htZvF++TS/vLTPFzWmE5LxTsEZ15UPBnBJ5tgl+l/Y+bXjsq
uu80DdeZWifQXZhaT/gh9nkmbDQxtS/iP/jdneHzR1Lzzfl19T6b3J2Z5yOa
d8gmw+o+3196GqDxJvrMbG9sjc2Z4/OP6/tf7R/SvCfwYd9zxMuU0jpCf/1r
1sXamu2KTcHREXjmScZfVLbJDp09uerjlS/yLtD6JZXPHJQ+1ur/zlbT5Ry0
B2je02KdTxL9DwUzSXtn6NxwjXfE61H9f0vflcHPe5q/lNje2B2dvq9zbZX1
hM7fTc3zeHJP5f/Pa95Zef2B0Ck8gBddYscjWhsedt0hfl7MrcMhOje0Mh/j
9B1fWY/odnPE1C+1tkBydkvet7T2a62t0ZhStxzw/kXBTK7st7vFzyui0aP9
s7SwSt/ztL5XNF/W+sM681Dq7/3i76Sa/98fvnck+ITff9Ttz+SL1yJ/XSE8
nxOeLVrf3uqc1K31gaJ/SmX/wr+fDL+f33QcEoPEyNHAf2XpeO4NX3gzfPqW
1DbYH3n0QPjwIPnk/My0duvsPvHRRm4R7pGV7bdH+PZqLBO+0TV/V+t8l/Yn
VfZP9FoL3a4WjoOFdTS4Zp0tC530aj4o8bmL4myv4Ps1vTdNa2P5r/XTxddf
687t7Tr7iHhR+UiWaH9vad3i+9vq9vORddsSO6JXYhPdvpvZFtA9TfhvL+1D
F6aWmzw/UTCfaPy8xfpAL9AFhjlwP65bBugO0NqnghslmDHifYV4ukqwKzLv
sf4b6XmX5mtarLNjmfWGH/dGnjms/aENx1FTeF7PXZ/JM+QLcsWnwRs4gR2i
sUvz87X2H43hmleSqbtwXjwrtT8fTCgwsonGB4K7PPUXXXKO88Tz/aLZU3pO
rJwX8bJJ/PdvuCZS+5lTm5YKfnlpXY0W7vci/8/WFwNBe2Lo8kwtzRS+DRpd
mfuIr1fG97Lw7W64nt4qPI9WzpfTY491/HFDYZ+E549C3rfJ2bljcapkfj10
uEP7hfgeo/W5Eavof672b2yYrzd0bp9wDq1Zl5z9imBfathe2I21w4HzIcF+
0rR/EWMro448UjneeiNvkDPIdV8K3a5qsb0Oh83eEvy23PWL/gv6xAU6Rdf0
AyNTxy24xpauVeQP+IK/jTXXEHwDvz0kfFnTepldWTbw4ofLM8PTw70UckEH
3ULrAcG2Nm33za22BfsPFu4FySsd2t9cuYbOTO2/5D1yw+1N54drxOe5lf0O
mruCz9GpdUY8bg7a+BK9SU/0Kgsy5zviC3uTX7oS8wvf4BmXmXfsiE+RU/Ar
etCeyDH3FO4L2yPXDA2Y9uinkPczaV8Ou4maLvj1raazPmj10/7WVtsOnun5
4AvdbI45vgtO/BDfpwfC/2el/nZFPrkx8sBo0fqJYKZHbzs9+tsZ8Z8Yv16w
B1qd9/Bn/AmfvLqyXZHnauF4unAPS5+4rdX87tf6uNI1AL+HLvbiOzfmP9O5
ZwXXmTjPkmPIh9CE9nfE+9eEo166xqATdA78hNzxdiKW+OIDxNncoIndexp9
9HtCdr69MX8/cw4l/5CL+JLPqcGLG329M3PqGj7SHXNy28A257ejqXsS9slJ
SyNHrRDMq+LzWfE1rXSfsS7qJXWCGsF8QPSNByRX3ua9mYKfkTv+9mj+SeV6
82ruukj+oQ6sirpAjuoIW9Nnzo3c0hN5Bj1cr7MvNO1Pf9L8lqbrznOt7mXJ
A8My47ww8v3KiOs76vYPfIPadVLYC99uizk4kHVb3Fk4S92g33wm1skD6B/7
jJVM4wrH45jc/Q29DTHUFrmIPoEenV6B2KQWbolelzmyr5M+Nur8zdwPJNPK
wjJxp2mPe01X6TwyInqre1PXI+5PxCExeG7ueo/P36z5s4Xlppf/avTzhyM/
kz9T2WpIm3PqPMEOaHPPsTizD3FnuZQ7WeGeelHqPdb3Cd/S0n5+/H6U2a+4
vy0IGelXLsrs208J9o/i6c7Uci+IHunDzPGDPXLJXjVdmx8r3BNTL/DxszPD
LMmMgzsC38Un5vTzcZchp44Lutw74Htj6Bx4ePuheNlSOm8czt0rEMPkj2nh
J+BYE/n5D4LZXBoX90/0pN9xWcALTnrMYdFn0hPho0ei36ZHoT/hHOfp664W
zGyNUXE3Whh8nqNzUyvLzL1katxN6uKx1rTOuuMuujFkR270QK45N3NMdgnP
9Mr/eRsAnhpxbe78RS7ChvfmtiO84uv4OXf3xYXzAHfxb+Xur9mnp4BWd9RO
4muK9o813Y93iOaplfMKCenzhX2WuFkRfddWdF9aZu5FK6K2pql9dljk462R
k/9HD1U559Hvj4yen3vn93PX9EPBP7xRK+/LDEPPOzj63lFRk6g19GTcCSfr
+yC9gfDMTt3/ptEDI9PqwnL1L/1+QVyigyVBa3DEOvXxxJ0Eur8vfQ/BN/JW
9zHUQXLkwdx5kr6GdfIncTk16tQrknV35f5rZOY7FDWsM/4D92rp3EpeRV93
xF34Gp2bo3FBZlyco4+iLzk/aK2K+fDory6IdfIu+ZcaR482NbeuPygcM8TL
lzPDIO+M1O8v5KiG4NOm+8pdkSOJH+J5Ytj9icr9Db3NQMH+PbdueqPGLQ/c
EwM/OWl+4bhZp7PrK9u10NnXcvfy+Dz+3og7TXvcKejB6cmQmzr/56j1305d
L9siHi9NHcvk1MmRV3lf4Z2FN5vu3G9qzIG9OO1798Pu1I7pgpmf+x5BD0A8
QYe+vid3n7U9eqWOqLP0b/gj9xzqH7WP2jUo6lfZ9N2AsxMCDpjlWltdWvfj
M+cpch71Y2La917XEfWL/hT82Gi0zg0pHBPoekz0IMQnNqGW0ZfOClrg555x
PFc0zDf9GnECHLnxqsp3kq7gY2acJffPDpj2uO9hlx9UfssjD14nWX5UuX9f
yf2jadroYVjUx39p/+3K+Z0ealzwQ009EG9xx1LH/Jq4vxAj+D04Tg883Ns7
420EnwaeOD1xt0EP5GJgyNXQGR+0jsUc+XaE3oiR93Pf2bDPvNR2Ix+SY4gx
4ut68X5d5bihz+wXPTT+8oXSPvMx76m579a/09oTpXuHc9BrYfk2ab4sN95+
9FClfeoyrX+zsqz01S+Hb9HfLYo7LO/EtxbxBlr6jY9+gHc9YgKfeS/eadAP
77XzQpYbuKsVfmOmxqWRb+bkfucdEf3bjPCxtqbtik15G745fBLfP/7Okbi3
5t5HvhzcFvVea+upC7lp/x+7EezL
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwll3eMVVUQxi/v3bfc8gANRdqChLJIk24hFowJFtAEC6CRVboBQUxANDGR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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6259490281195165, 0.6273881033512626, 0.9109150720273521], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmnuwV1UVx8/vdX7n9/sdQO6Dyxsut1IQ8wImL7MU1AErEzFB6OEDwRQQ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnuQj3UUxt/fb/f32/fd90Vo2eROuaUWlcsaaTKUrkgsxjV2JayY0nRF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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7005028309634165, 0.7471753197051194, 0.9126146691033419], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnuUVmUVxs/3zXznnO8CKJYKljJeAG24eFvcBmQCcjRAvCAlogxeyuSi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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnuQl2MUx9/d7ff7ve/vfVfaLUnUrjTC2m5mahMVpRQVukwXUbnW7oYa
WlZtGYwaBsWkNWK6mkrESFKxJbcipRhKha7bRU3j2uDzna8/zsw5z/k+53me
85zne57iMRNurswNgmAj0gBZGwbBbUkQ9EsHwfc5QTANfTpyF/ZP2LPiIJiN
7MoLgmbICPBLsJ9MBcEq5o8FewdyI/hvwA/KBsFvYNYR/BxkKfZy7LX4BrJw
0ygIbgXfB/z1yDz8tfjn4S/E/wX2cOK3IX4t8yeCnYQMB/sDmDHoo5HXA6/Z
Hf0jYr6H71LsEdgjkV7oWxhL8PXF7ow9kzlD0Yck9lWyxmjWHsuaF7LWx/in
YI9KvLcl2IPQC4hRzt6Wc/438O9jfzuZW0eMteiLGNuKvSDlvZdg5+T5DIOz
zoly0RS5hnhPgBmDr4Q11hH7csbOQ69mzmqwH2kNYs9mzW/A7kA+BZ9lbDp6
EP1/VsbGMXc8Mhj7XVznoz8AppS5MWN/KHbkuzmDfSN6HvIta30JZjj+YUht
4Jw1ySfn+G8BPzYTBPeg/0i87ax1BHwr9lfE2IRc18SH6H+z3z7YNdiNiNUE
SROrmLEjzD0cO/fLiVGK7yHsq3J95m7Skc+wI/zNiDcXe3LKNfmgail2bgcQ
Yyt6DTKD/W1i7ALiFSNngW1LjEvY/8VIBt+n7L8HvmXEWAP+MjDnEv/XyHfZ
FzvDea5ETmNvRNbga544d1XYn+PbnHUtdiTeUvxPEO9P4nXDvxg7zHpuCswE
5lYmrtUa9tAH7GOx72oo+98HfkjWtdAl8FmmIcNSPtNJ9FNIdco1cCf4eyPn
/l/WyI1cQ6od1eBA4j8Xu5afJl5TYs8C0wn81+ArwJYnftuqkd1gF4IpZ/1t
zPkObAp7A9ha5ADYg8hOsM2ZUw9+leoR7J6U31I+c8rSflPprHOgsyvGXvQW
wuB7Lc+1/jhyW8o1fyjrHOjsbzPnF/R24C8AvwB8pNrE3oR9K2cYHZsjxA3t
mX8A/w2Ra3dRnu/u6ti1ozucgT0Tma/ayzHX6M511+Kc3egFjKXQXwGfpVZK
GKtjP9dwv1dx1oHML2BvJYx1Cp0j5aYraxTEfqN6m/vBPECs+xNzoTjqCvDH
sPehFzH2FnY980eC/4T9bGB+Xey38AayHX1b7LvTG59M7CpkaK45U29lMtIv
5TfzKLGrE3OzOFhvfSLSK+U3fxjfIeR4ru/wALH2I4tyfKZ+ifekvegObwnN
EeIGccAz7PU49s/YrYgxG/s09glxB3YZ+BPYB7DbBa61U9j1adfcHtb6Mevc
LWO9uyPXsGr3sM4E9j7shbrvtLm7LnJvEIeLa76K/bbFOd1D15RqSTl4hNjV
ej96r+BXgL0XzBx8zyNdQ9+x7lY5qWG9qYm5XT3tVfCDQ3Ol3tjtoWNoboAU
Mndw4rsR5y/FfxE1siJjDsnkmxPEBR2QCvwdQ9dmbcp3/xQx5uS4Bn7H15o5
q8B2J97DrFUVW3+UPY5DHx+7tooYezl2D1LvqWJsMfqu2G91PfksTMyx4lbV
cHd8vVkviz9GlrO3N0PnRjW0DHtF6F6lGsxnLzdF7iX9M+byiLFuGXN6G2Kf
Al+W6552c+Q5wt7BWFHWb1RvU3dwLes3iv0WzgI/O3SOlBvl4Dzw/4Sunf5I
Y+K/z/yH8twjzqDfFbk2VjPWM3ZMxWqIdEjcI9UbW6R91jb55nadWbW0LDIX
q6a+A/9i5L+KOEtctyBr7hXnNWZuJf561rudGJ3Bd0Va6z/CWFv0jonXujrX
e22InZf2nk9ylosTc6tyVEi88WCmEn+Uzpy4JlQL1cy5MnGPVG/UGi+oFzO2
MW2O24m+A5kVeKwocQ9S71FPK0WPWaNnxhx1eWTOElfVsP5c8GXIRWCnIEfJ
3bHYXK2YLykX4CvAr9T/h73Nj92b9If6QLknP+80MEccRK8Pzc0rG/itPxuZ
C/TmKyLnULnLAd8+cc6UK3G4uOK60L1anNEycY9Wb1ZPUK21jLwX1Zy4pnNo
rhTn9A1dE6qFIcwpZq9FsXuR/mg9Q/cM9Qr9OcQ93UJzkTioS+I71V0qJ7+j
N4xcu39hT4r8x9Hf5hRjR0OfWWdVDvTWz2Rdq3rz6l05kf8O6mEDQsdULN25
7qZt5F6jOyqPXBOqBdWY/sLrI791/Ym3YKfwl2b8x1Kv6hSbe9Sz9Pepjf32
9QfSX2Or1szxn+Or0D1QvU9j4pYfYnODOKZ36JpQLehPob9eg8i51J9PtTA3
cu2oJvT36hGbO/QH0942h75b7XGv+nXWXK4/+tmJOUtcpTfxHxK/jYc=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7737900624999999, 0.85071925, 0.90903175], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHmwl1UZx19+67v8bl6VErUBFRWdUZAgUMwuXDXckFQuQiNWrqUSyGag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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllnmwz2UUxr/u7/e7vsvPuJasRa59hiiyxrU2TCGFaFJhWlUqW+61ZGlE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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8407444374999999, 0.87304675, 0.87903625], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmH+QlWUVx1/ufffe+773dUSZMlPzR5o6zjSSYTMJmvww5fcu1KjrKDI1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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllnmwjmUYxl/f957P9y7HMioVhdD6TxttqI4l+3Jo0jpT00wmjUZx6FiO
okYNjmqyDCoizrELlZKt40j2ZRrJEGdKydIUoZF+11x/3DPP/Vz3fT/Pc69P
s+deLh6UCYKgAgqhblEQzEiDYEwuCN6AfkyCYF4+CAYC7iwIghHg1eDLwUpq
BcEW1qXsXcTICvbWsv49DoJVyI/IBkGTwiAoh6+szRnQEeQXINMKrBqZUmz3
gF7A9lj2VrCu4cwD8N9hvxvrKnSWYLshe8PAO0INkF0A3wPbPaHv4VOoM7Jd
oINgz3KnL5DtCd8W/TLOW4bsZWh76DN+wf4qZHaF1inibpXIT0J+A/rHwVeD
jwb/CbwO76lEZj9YH95TD1tnwL8KfYfB8AvgB8HfDk1E/xHstcLeTvjZrOdA
48RjYzPyi7F3AH4q+Ar4lehv5e0vgs+Hr4BfDd8BvgLd7vClxGoiOstj+0y+
GpBxrFoj0yznmHXB9qzUsdwGfh78L3TWgzVl71Ow+dB41uvAf0X+EvhW8Pm8
5wRYNW/YCnYQmcZgjaCXOP+cfABWHtn3m6HerBegMyFnHypXRkbODeXMCOQf
5g5dA/uoBvxYal/sAb8P/F4og6+zUFP8PT7vXFMOneDsPtCdGefYPHTnQgMD
v+FrZGP0D4Mt5T71ObsP+INghdh7l/Xk1G+thN8HfhR+L/gAbBSh+zf2N6Kf
gu8E3wV1x9Yw8PeR7QC/Ef0Q/EPkWyA/F6wUvhz8IfBvwM+hcwasAdQOfA02
h0oXmYWctwgayn2LoN7oliHfCez+xLaVM2+zfidxLPpjsx34K9i7A1s3g38L
3xeb+8AWw7+GrU2RZUsC59am1Gcpx47D/wY9kXEMx2CrDGqDvbZQR2Rj8GeU
K9CfYM3Zq4tuK/gm8NfHti2Zj8E+Su0b5fSj3HUm+k24bw3UVr5PfdduyA/h
fq1S555y4Bi2DuWdO8s4f27ePUe9Zi38DcjWR2Zb1ndYhu1O8BFYL/aeZH0V
ez/AN4ZWsV4eGRsEFaNfC3u7Q+eAes0SdIaH7jmq3dPwX4au4XJkJyXuHQ+E
9q1qXrUuH/fCXo/Utaaecgr9U7F73V2q59Q+lO/Us6rAduRd21NCn3U671zQ
mQ2RPcpeS+RrIz9DvYC9I1n7cGbqHFVuvg7erNAxUSwWcac63LUeVIOt99i7
B/lR8J0y7gG3INsM/YOhbSZgT7P3ZsY1Il+2k/2sfdoc++djx2oJ9tuz/hz8
H/gs+AT0z3HG2Zx71JVgucS19qpqKm8b0l0DPifvO+uuS+H7wH+QONdUM6Ow
Pzq2r6vAR4OVQZczfsNF5K+OXRvtM679IXpfgXtAC+7SMnWuqMY6c5/pqWtX
PasY/RvROYz+EPbGsZ6SeN2IvVPIP87etehPQ39sbBlhu7jPRdb/QptD92DF
qiZ2ripmw9Wb4O8O3YOqWW+JHetS5Ndx1vrEs0o9Qb6fDT+6wDGYHHtGajbK
Rj/ucyv89tqeMfL96si9VjEYmXgmaBaoZ+Qiz1DNTtW0YqOZo1mjGP0Xe4Zq
dmrmqbdXQIND9/gC9ZrEb9eMO5w4hordvgLPRs1AzT7NyCs4rwp6i/P2w5/D
1tnYsVXPVK0FiX2nmpueuEZVmyXYeCy2Deleox4dOwcUe9XkysgzQL1fOalZ
8Fnk2aOZoFo/CS3MuuY1yy5wxw2hZ1ql5m/su+uNfyCbwcbe0DrqdfoT6C+g
nncTfAtkDoXOkdsK/QfQ7D9MDNrGnqGanfqz1MVWy8i9TTWnXl4Sufeqp/eP
/Ua9TTk1InWNqjafzzm2vVPPIsVYs7JX5FmumTmG9Y7Us0M10BdbxVDrjHug
/mZdI/cC/dGmYXtq4tpTTC4geynvv5VyNpv4T6G/hHywB93dkXNTM0294Snw
60L3iDaxfaC3a8bJN5HiH9pHJ8FP5t3rPsn6L1YUuzfoT6ZYHIuMKSaaVfoT
6S+kmSVbzcH75WxTZ89KPDt1hwqwn1P/BTST/weOtneB
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.9076988125, 0.8953742499999999, 0.84904075], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFVltsVUUUnXPP7bk9956atAmEP4EaTdQvjQWNLULkUWgiFj9sCcRo2lI/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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllMtrU1EQxk9zk5Jzc11UKLj0AbpXFBEbtb4T0Rr9A0RXbqxgUwUj+ECx
IlitVAWfrVVTFyot+CpiqW2j0JgGN7ryuVJ3ttpWwd/HLAZm5vvmm3PnzLnz
djfn9sWccxksjm31zn2JnHtX69x04Nx5/MGUcy8htZD7Af4TayG+BL8OvwlO
GmwvuTXE7ZFxf1P/ntruJBji5YRzWfBr4FNgYzHDJkLnhuLGKYEV4PyVFpxG
6q+QO4LeenJP4TtyVbhHsW/4/eQK+B/Q70paT/UaIHed2i7sFPUV6gfxb2An
iYtYAW4jNVlkm+G/Amul/wTc5fR/661G3A7iJuJe4j/4VTijnL2N+mH6XaY+
B7Y9slnojDvh3yc+V2szysHtpOcqsB5n2BviFwnj7ECvDmsAq4fTAb4CfBd6
B8G7ie9iZ/DHyT1Av+LtbEn4efTnUF8N7JsW4S8Mrdcx+GfR6oNT1rzpeSey
O9NdSXMt/gXNAH92jX3bOLmLgX1jHq1WbCn1WexWZDujXdGM9S293manb3qI
/wibofeAZuLtzDqrNPP4Q2isDmzm/cRpb9w95L6D9Xnzn6A3Se9foe2CdqYI
9hlOJ/gy7Cp+xttuKXczsh3Q3evOV4b2jfo23eEI5x1NmfZjrAX8ALYY7SXY
V2o/RaatN3GY2tOaccJ2dJM3DdVqR3siuyPdTRvxZri3I/PrA9MuJm3X1GPu
LO6dXCZumlP4M1iJeAsar9EuYc/AnmMNoeXk6w19RPtf0rgVepwAP46l47Zj
I/hl8Mkam/EG+Bsju3vtVBF/m7dd3g8+n3hBZG9HO6je97xp6wzS1hvU21OP
9tB2QrugbxjW2UN7C+oZUB9L2b9Cb1S7pzert6od1K6t87bb2rlDSZuZZqUd
mw7tTnQXmsl/DPGvcQ==
         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2298, 2584, 2165, 2114, 2940, 2727, 2217, 2675, 2676, 2810, 
         2811, 2809, 2301, 3296, 2472, 3016, 3017, 2621, 2377, 3229, 2379, 
         3227, 2378, 3228, 2516, 3298, 2473, 3297, 3300, 3299, 2382, 3233, 
         3234, 3230, 3232, 3231, 3265, 2511, 2512, 2479, 2514, 2513, 2185, 
         2759, 2760, 2757, 2254, 2758, 2477, 3267, 2421, 3266, 2422, 3268, 
         2387, 3342, 2474, 3018, 3243, 2388, 3370, 3152, 2321, 3153, 3154, 
         2817, 2816, 2233, 2690, 2691, 2692, 2966, 2130, 2598, 2599, 2340, 
         2825, 2339}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2642, 2643, 2577, 3106, 3107, 2801, 3361, 2210, 3033, 2211, 
         2805, 2806, 2804, 2882, 3225, 2376, 3014, 3015, 3307, 2483, 2872, 
         2873, 2484, 2366, 2630, 2480, 2481, 2485, 786, 2426, 3272, 2428, 
         3271, 2427, 2184, 3360, 2703, 3359, 2704, 2677, 2678, 2168, 2121, 
         3236, 3237, 3235, 3239, 3238, 2369, 3216, 3217, 3009, 1451, 2124, 
         3241, 2383, 3240, 2384, 3242, 2370, 3371, 2620, 2371, 3218, 2372, 
         3219, 2874, 3142, 3143, 2957, 3318, 2956, 2227, 3045, 2228, 2738, 
         2819, 2818, 2540, 2541, 2326, 2651, 2969}],
        "3"],
       Annotation[#, 3, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2110, 2932, 2641, 2795, 2794, 2493, 2798, 2286, 2796, 2285, 
         2797, 2530, 2531, 2297, 2803, 2296, 3125, 2164, 2113, 2939, 2726, 
         2216, 2673, 2674, 3134, 3135, 3133, 2300, 2808, 3363, 2218, 3039, 
         2728, 2730, 2729, 2813, 2535, 2954, 2953, 2952, 2309, 2499, 2169, 
         2123, 2590, 2591, 2315, 3140, 2314, 3141, 3270, 3269, 2891, 2814, 
         2815, 2736, 3044, 2226, 2737, 2320, 3149, 3151, 3150, 2232, 2687, 
         2688, 2689, 2965, 2129, 2596, 2974, 2973, 2652, 2337, 2601, 2600, 
         3289, 2459, 2900, 2460, 2901, 2341, 2831, 2832, 2830, 3195, 3194}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2134, 2977, 2653, 2827, 2826, 2236, 2822, 2325, 2650, 2967, 
         2968, 2173, 2501, 2324, 2647, 2648, 2649, 2542, 2820, 2821, 2739, 
         2230, 3048, 2229, 3046, 3047, 3145, 3144, 2958, 2959, 2171, 2686, 
         2685, 2735, 2734, 2125, 2170, 2310, 3139, 2311, 2537, 2536, 2589, 
         2587, 2588, 2423, 2629, 2486, 2487, 2627, 2626, 2117, 2167, 3008, 
         3007, 2368, 3215, 2367, 3278, 2432, 3277, 2431, 2943, 2942, 2941, 
         3127, 3126, 2213, 3034, 2212, 3362, 2802, 3109, 3108, 2579, 2800, 
         2287, 2799, 2288, 2576, 2575, 2638, 2637, 2636, 2447, 2897, 2269, 
         2787, 2788, 2786, 3095, 3094}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2092, 2906, 2763, 2764, 2762, 3335, 2196, 3030, 2197, 2441, 
         3309, 2100, 2569, 2104, 3310, 2446, 2278, 2448, 3311, 2105, 2578, 
         2111, 3314, 2451, 2583, 2582, 3111, 2289, 3110, 2290, 3112, 2214, 
         3005, 3006, 2166, 2115, 2585, 2118, 3316, 2452, 2302, 2586, 2303, 
         2812, 3364, 2219, 3040, 2220, 3137, 2305, 2949, 2950, 3138, 2306, 
         3366, 3041, 2222, 3042, 2223, 2732, 2312, 2539, 2225, 3147, 2317, 
         3146, 2316, 2172, 2126, 3049, 3050, 3010, 3011, 3157, 2323, 3155, 
         2322, 3156, 2543, 2544, 2328, 3165, 2327, 3166, 2174, 2972, 2971, 
         2970, 2329, 3167, 2237, 3180, 3181, 3177, 3179, 3178, 2175, 2133, 
         2976, 2975, 3058, 3057, 2240, 3059, 2241, 2745, 2834, 2833, 2883, 
         2884}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2153, 2991, 2144, 3325, 2871, 2699, 2698, 2697, 2246, 2351, 
         3339, 2350, 2604, 2348, 3338, 2349, 2338, 2458, 3353, 2457, 2597, 
         2335, 3337, 2336, 2595, 2594, 2964, 2963, 2962, 2454, 3288, 2231, 
         3051, 3053, 3052, 3148, 2593, 3285, 3286, 3284, 2453, 3287, 2313, 
         2592, 2955, 2684, 2683, 2682, 2224, 2733, 2951, 2681, 2680, 2679, 
         2221, 2731, 2948, 2498, 2497, 3136, 2304, 2946, 2947, 2120, 2533, 
         2807, 2724, 2725, 3037, 3036, 2215, 3035, 3365, 2295, 3124, 2937, 
         2938, 2163, 2495, 2294, 2644, 2645, 2646, 2529, 2792, 2283, 2791, 
         2284, 2793, 2492, 2789, 2790, 2639, 2640, 2109, 2526, 2782, 2783, 
         2781, 2785, 2784, 2672, 2671, 2203, 2719, 2913, 2099, 2157, 3224}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1, 812, 226, 813, 17, 1906, 1759, 33, 1910, 1764, 49, 2016, 
         65, 81, 241, 97, 245, 338, 2062, 113, 3261, 1699, 340, 259, 129, 271,
          145, 161, 2044, 177, 1928, 1791, 193, 1934, 1796, 209, 826, 289, 
         825, 225}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{15, 3367, 3369, 3368, 2375, 2880, 2881, 2877, 2879, 2878, 
         2619, 2567, 2568, 2471, 2566, 2565, 2520, 2103, 2923, 2922, 3088, 
         3087, 2490, 3092, 3093, 3089, 3091, 3090, 2525, 2108, 2931, 2930, 
         3100, 3099, 2491, 3104, 3105, 3101, 3103, 3102, 2528, 2112, 2936, 
         2935, 3118, 3117, 2494, 3122, 3123, 3119, 3121, 3120, 2532, 2116, 
         3315, 2299, 2496, 3131, 3132, 3128, 3130, 3129, 3226, 2119, 2945, 
         2944, 3024, 3023, 3038, 2408, 3346, 2409, 2405, 2407, 3345, 2406, 
         2556, 2122, 3317, 2308, 2307, 2381, 3340, 2380, 2534, 2255, 3334, 
         2256, 2182, 2475, 3354, 2476, 2416, 3261}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{211, 2890, 2415, 3304, 3305, 3301, 3303, 3302, 2850, 2848, 
         2849, 2658, 2659, 2145, 3306, 3199, 3200, 3198, 3202, 3201, 2508, 
         3196, 3197, 2983, 2984, 2139, 2548, 3185, 3186, 3184, 3188, 3187, 
         2505, 3182, 3183, 2978, 2979, 2135, 2546, 3169, 3170, 3168, 3172, 
         3171, 2502, 2330, 3320, 2131, 2545, 3161, 3162, 3160, 3164, 3163, 
         2500, 3158, 3159, 2960, 2961, 2128, 3244, 3026, 3027, 3025, 3029, 
         3028, 3043, 2385, 3341, 2386, 2318, 2319, 3319, 2127, 2557, 2411, 
         3347, 2412, 2410, 2414, 3348, 2413, 2538, 2252, 3333, 2253, 2181, 
         2419, 3349, 2420, 2418, 3264, 113}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2098, 2912, 2097, 3355, 2780, 2712, 2195, 2711, 2194, 3072, 
         3073, 3069, 3071, 3070, 2156, 2096, 2911, 2910, 3075, 3074, 2202, 
         3086, 2276, 3084, 2275, 3085, 2160, 2921, 2920, 2919, 2277, 2524, 
         2523, 2929, 2928, 2927, 2282, 3313, 3098, 3004, 3032, 3031, 3097, 
         2162, 2107, 3312, 2281, 2209, 2527, 2934, 2723, 2208, 2722, 2207, 
         3116, 2293, 3114, 2291, 3113, 2292, 3115, 2206, 2720, 2205, 2721, 
         2933, 2581, 2280, 3283, 2450, 3282, 2449, 2580, 3281, 2161, 3280, 
         3003, 2204, 3096, 2279, 2924, 2925, 2926, 2570, 2571, 2443, 3352, 
         2442, 2564, 2270, 3336, 2271, 2259, 2439, 3351, 2438, 2558, 2434, 
         3350, 2435, 2188, 2705, 2187, 2706, 2875, 3308, 2091, 2876, 2889}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2146, 2179, 2617, 3332, 3358, 3357, 2478, 2631, 2551, 2552, 
         2905, 2904, 2903, 2851, 2852, 2660, 2661, 2147, 2553, 2837, 2838, 
         2836, 2840, 2839, 2509, 2835, 2352, 2654, 2655, 2656, 2549, 2829, 
         2344, 2828, 2345, 2506, 2176, 3190, 2342, 3189, 2343, 3191, 2238, 
         2742, 2744, 2743, 2136, 2547, 3174, 3175, 3173, 2332, 3176, 2503, 
         2504, 2331, 2740, 2234, 2693, 2823, 2824, 2333, 2741, 2235, 2694, 
         2898, 2899, 2455, 2602, 2334, 2456, 3321, 2132, 2603, 2137, 3055, 
         3056, 3054, 2239, 3292, 2463, 3290, 2462, 3291, 2608, 2609, 2464, 
         3322, 2138, 2610, 2142, 3323, 2465, 2354, 2468, 3324, 2143, 2616, 
         2151, 3328, 2359, 2249, 2702, 2867, 2868, 2870, 2869, 2887, 2888}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2093, 2907, 2632, 2766, 2765, 2258, 2894, 2437, 2892, 2436, 
         2893, 2560, 2561, 2440, 2633, 2634, 2635, 2563, 2101, 2914, 2714, 
         2198, 2713, 2199, 3078, 3079, 3076, 2272, 3077, 2715, 2716, 2670, 
         2895, 3356, 2158, 2896, 2572, 2444, 3279, 2445, 2574, 2573, 2106, 
         2521, 2522, 2273, 2915, 2916, 2917, 3001, 2159, 2430, 3275, 3276, 
         3273, 2429, 3274, 2365, 3295, 2470, 3002, 3331, 3081, 2274, 3080, 
         3083, 3082, 2200, 2717, 2201, 2718, 2918, 2102, 2519, 2776, 2267, 
         2775, 2268, 2489, 2155, 3066, 2265, 2773, 2266, 2774, 2193, 2778, 
         2779, 2777, 3068, 3067}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2152, 2999, 2669, 2866, 2865, 2355, 2864, 2357, 2667, 2996, 
         2997, 2612, 2613, 2467, 2902, 2466, 3293, 2611, 2846, 2847, 2845, 
         2844, 2696, 2245, 3205, 3206, 2989, 2990, 2754, 2244, 2751, 2753, 
         2752, 2141, 2607, 2982, 2981, 2980, 2461, 2606, 2605, 2628, 2177, 
         2507, 2347, 3192, 2346, 3193, 2550, 2140, 2749, 2750, 2747, 2243, 
         2748, 2988, 2987, 3204, 3203, 2843, 2695, 2242, 2746, 2842, 2841, 
         2178, 2986, 2985, 2657, 2353, 2555, 2554, 2664, 2663, 2662, 2356, 
         2853, 2510, 2855, 2856, 2854, 3208, 3207}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2260, 2562, 2559, 2094, 2908, 2708, 2189, 2707, 2190, 2768, 
         2769, 2767, 2261, 3220, 2373, 3012, 3013, 2618, 2360, 3294, 2469, 
         3000, 3329, 3330, 2515, 2374, 3221, 3223, 3222, 2361, 2624, 2625, 
         2482, 2488, 2154, 2417, 3262, 3263, 3060, 3062, 3061, 2183, 2424, 
         2425, 2362, 810, 2257, 2761, 2250, 3063, 2251, 2756, 2186, 2433, 
         2363, 3213, 2364, 3214, 2262, 3064, 3065, 2771, 2770, 2191, 2709, 
         2192, 2710, 2909, 2095, 2517, 2518, 2264, 2772, 2263}],
        RowBox[{"-", "3"}]],
       Annotation[#, -3, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2665, 2666, 2180, 2857, 2858, 2755, 2247, 2700, 2859, 2992, 
         3326, 2993, 3210, 3209, 2885, 3245, 2390, 3019, 3020, 2622, 2389, 
         3248, 2392, 3246, 2391, 3247, 2148, 3250, 2394, 3249, 3252, 3251, 
         2393, 2396, 3343, 2395, 2149, 2398, 3344, 2399, 2397, 3255, 3256, 
         3253, 2400, 3254, 2150, 3258, 2402, 3257, 2403, 3259, 2401, 2623, 
         3022, 3021, 2404, 3260, 2886, 3211, 3212, 2995, 3327, 2994, 2248, 
         2701, 2860, 2861, 2863, 2862, 2614, 2615, 2358, 2668, 2998}],
        RowBox[{"-", "3"}]],
       Annotation[#, -3, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1268190261]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1601823287],

Cell["Select three equally spaced contours:", "ExampleText",
 CellID->1007007724],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Contours", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->698520152],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFnA2QllUVxzfFSafUBqiQIvMzm6yxHLN06r5mZH6QSqaNDSVWzKgRtknq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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFl0lslVUUx7/3ve8rpRCFIFPBUiJoIguH+kDF4LDARIQiibbqglFQigoB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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllEtsTVEYhc89Z28NA48EoWmiRQwYKG0ZEMGAiEfjEaJmLfeWAZF4hfa6
SsVIamTqGTUjIUjvpZ0VIaoNTShTDAw8UyLxrazBStb6/33+s/fa65y61kPb
DqZJkmwAASyNSbIDMpXiRVBGf0Ovg18GR+At1AbhX8Ej+Gdqy7MkWSbA26mN
0qtm3jF0F3oaupJLkk/Bz2jtS/oX0D/QH9Ej9PfCm6hNp/c6da8ZbEy95he9
VdF7Ue0W/CaYCa+lv53+bPQJ9BTQB38MVmY+Qx/9IfRh9EDOfCu1wcQ1nb1E
7WdqD07Bi/JAz7J+MzwPRtA96Kvwa9FeaMYW+BpQjX6Y2psmdE9qj27An1Cb
gc5rDfpBtBcN9M/Bq6K9+0M/wFtZX0ZXofvhA2AW/BJoDr4z3dUKMAf+nlo9
vAjmou+CRcwuoRvhu+Rh6j3Ju9ugLrOHHfTegcXwTnkePEPPNoB58PnRfAF7
+k5/T/BZ14MD8AL9N6kzsB/djf4Hfwv2wbupvcrZww700WBvJ6NL8LPUxuF/
wXHNRz+D/wbt6Db0EHxYe4y+c9217qgevSTaC3k2CT4xeq/DvON88Aw9qz3k
4UXwHF6gVhOdEWXjZOp3FYKzqHd+Cb4DeS8PK8F71N6U8a7gmZr1ghnjwWfS
WXYqs8zbFD1bGdDdtNBfmPmOrqPLwV7UoHvRE6Kzoju6E51BZU/PVKLvQN4r
4/Jenstr3YG8PB2cJXl6Rjr6W1TGr8DvBWdL34y8vh+dRXk+FpwJZUGZ6qf3
Af2U59dmzvrqaG+VefVqo7OnNWPKY/S3rQx00t8d7IU8179EZ9ZZ9U9pDH6H
Zusf8B/UcZll
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.563820859082933, 0.527565423056382, 0.909498741130694], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmQmQVsURx9/3vXkocqjrct+HnGKBIipe6CIWcumCSUVNGdaLWCapKEJU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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwlln2QllMYxp/3ee+TKfpL09eWShFjGE3roy1kBiHT11jfpK1omsEMkWqT
UrGSpDSz2JRJH0M7WZbaatOklSYtZZFKGYZ8K2ZXmOF3zTXz3jPXde5znvc5
97nu6zx9Kh4Yc3+eZVk1EcTJlGWHAKeDvytmWSm4D2OzmDSAmA7/Al5Fro05
XcDrtZDcI8RP4MsZWwUeSqwAdyM2M6Uba/4CtxE9yH0D7w7exJpT4dOIS8Db
GbuaXE/WtIBvZqwZXMlYK7iMsZdz/8dA+Db4UHL8ss3gE4wNhpQRx8ADGVvE
3MuIruA6xhJ4KjEI3J6xyeAXiRb4b8RV4JXERnLvEEPApTxvOPh64m14PXEn
+A6ilf+uhQ9j7evwvsytgx8O11S13FWgNvCd8NHwYazZCt8PnwpvJH8h+FJi
GWsXEjPJH4AvIF/C/Lnwg9qP9gafDJ8Eb2HtYmIMfB98CvkG8kPg78NHwAfB
14LXEb3g7zG/jPwO+HD4eeRHqtbw++Bb4VfCm+A3wsdnruW7ybVQTaeDXyVK
4KfB5zD/S/hC+LM8fxX8NaINXEV+BLnb4f151hr4EXAdY+cz/yzGloJfINrD
l7PmKfKH4M/DNzH/Fvhn0iP8CPPnw/+QZvU+zN+SrEFpTxr4GPyp/g++JLeW
L9IeC9a0al0BH5+75j20F+IDnt0RvhXcmKwlvfMZ4E+Yfza5SqJvsoakndnE
r6onUZJbQwvAXzFnKeuX8J9TwjVTrRoKPtvHwrXSGR+Gzydqcu/5bvBdxDPk
9zLWAfwk8//NrVlpcRu8Z9Ga3Bfes/aqd5RWngj3kjQzOFnj0vYK4gD4c+Ic
nT98nXqZOWPB/xTcWwfD2lWP6WxnwztmPuMfwz2q3uySu3erwntVD0t7S+HV
BWvwLXBRNc/dgwGuZ6x70WfQoN5kbEJuT6iF5/BxuT1mgvwn/K5NPHMGuYfh
x+G/5/amGfDygj1K2l4EX1awxqWVefB+mTVzhbwjWYurc2u9hvwvBWv+mvCZ
66yl4a+lz3DvvkT+FXlB2Nu6EiPCnigvDPkheE+4d+rlH+DO6k9y//G83eEe
UW/0zt27W8LaUA9fDD6FsUm5e1xaejrcq9LUUfhz4d6uLro3tofPQj1SmewJ
8gLV6Kaw58prOxHHwDvDXlJbtHYbwzlp+GfyzfAz5YVFe8P38Ha5PWJU2FPl
pR2IH9Q74bthQ9G9fRR+QdE9Lu8eRTTk9vBp4TPVWe4glpO7lvgb3Jn5J8DH
yZ/L3N1Frx2Z7AV6hrTxRriW0oi09Wa49tKYnnVdshfrmU3hPWuvuoOG6iyT
vbucd94b3rP2Kk8fB36I+JZ8M7E4XHPVWpqSVjeG9y7NLgtrRNqQ5kvlN8l3
j+4w9XJF8rPU0yeZf2vY2/fAO5F7NFyLB6XpcA20d2la2lkb7k1paDx4dNir
JupOJN8u2dvlCerlmuRaqqcngu+Rh+fuAd1F1WGv1Z0k77sh+W6TB+ruq0++
m3QHrgGvlodkvkOWyJuTayfP1t03NtmrdAfKy+Yl303ytJXJ76x31Z3RC947
+dtC3xzyAvWUekmesD9cE9VCHi7tDUi+G6VBeaF6WL0rT5yruyFcS/XMBPi9
4btBnr8Bflv4rlENpM1+yd4tje4Ka1jalQfMBj+efBf+qW8c8rOScSvxUbjH
1dvqEXnpenj/oj21HD4neW5jZi19GO51aWqm/D/Zu/SNpG8BrdFcfRP8D1hN
QuU=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.762631, 0.846998, 0.914031], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXu0V0UVx8/vnDlrBS0FtBKzVASVSr3oEkWRBBP1WktA5SEPLxCKiHBF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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllllsVlUUhe+9/z6JAQWF8GAMIQ4gosiTUgWMgkxOMaJYtSglGqOFVpyR
Bx9EhqICBQUsM2KtLcVaFCVGEgQLAo4E0TiBTDFSMBFwQv1W1sNO1jr73HvP
2cPa9/wJNbdVF1mWLcQCezhl2YtYqZRl+/Is+4fF2fACvgg+FzwHWwpu4sFG
/Afgq/GvZW09eD9rV+Cbhs0Hz2ItK/kd88AvY53BR9jfgv8gfA28FT4F/jV8
OnwMfCx8N3wKfCuvWQHvDp/Mu7uydiN8J/x+cD3+DfAT8H36HntGwLfDK+DP
4u+A/wZvh5/H+1fDt8HvgjfDl+luyXdp5flV+BfBz8HfHWuC74BXgtvY8ya4
DusEvwB7Hf/P8JXgBXxvAfhf1ioK3/kW8KesVYEb8d8Mfyv8rnfge3Q+bDj7
+7DnVvDn7K8Bb8A/EzwjOReN7FkHbsGex9eNPcvZvxDeBTyVtRfAFyfnQjkd
iP8M+EPwPbyjDX4I3oBvPbwPuDc2IHMOK8ETsF3gTvgPg98P56KJZ0aDe7D2
GP7Tud/1dviseqdidQO8IXPMjsMPhXOzBd4TvhN+IXxq4dy9C/8ocw6Pwr8I
525jybWyNhw71YxyeQzet3BOj8H3hmtnE/xM+Fz49/CJ7KmFn4UN4vkc/2l8
C7D9+O/G/5fqNRybO+GjwP3ZXwseWDh2zymHuWPYWT7VLLwK/iq4WvUHLucb
f8PnYN/hL2ftXvAwrB48DqsAD1EP4L8H/gTPPqkYFc6pamcxdjh3DXVV/6jG
4GrcqnDPqlfVkx3g3az1xvcB9/sFvj2cuzZ4O3wZ/DX1FnwbeAk2g/29Cvfa
h+HeUM89rtqDHyl8JtWWelC9pxqbBt6MnVs4JqrV95T/3DWrWm8N15Zqvho8
ibWfCsdoPPg+aU7mGrssuefUazPh14Z7TL21Tt+AT4T/AL6oMK7AdhRe+xj/
Fmw5uCf2B76TujP4QMln3Rr26czl6v3k3LZwxiXSGuxPcA/2Xw8elqx1zdgu
9T9WV7hmB4GHJvdif+7wiOKFPZj5jlXgSexZkTvHj0q7kntzM/5flX/pJ3io
agI8ApuV+04j8Y9O1iLFSL6RybHQHvVeffJZ1YPK5VKsI3dOf1Rs4b2k8ey5
OlyzqlXVpGr7JtbKCtf4APjlWFvmNd31s3CsdWdpeV24d6Tp0tY18JO5NXaz
ahG+Fz6qZO1cGdYmaWilnk3WCmlCP3Bf6Rfvnl5Yi4ezpzazJl8C/1Y9WniP
ave/cO+ohuvVu8pvyTEuC59B35aGbQxrlrRKNflSOCaKhc44Dn47fJNinzn3
k8OzQDVwMKxZ0irF5Ktwj6m3cvxfhjVK2qSe+yTcc+o1xeR3aXly7Qxh7Zuw
Rkmb+rE2OKxR0iZp0HVhTZQWKoe6mzRFWqI7bkyuGdVKGfwq+Cn4HfDFhbXl
0uTekcY8lTyTNIvUw5rVb4RnpWb2ePDY5FpUzI/DH8Dac8+gMfiOhr+lGKm3
TiX3knrsbM3SsHbUYN2Sc6pcakYPTo6B7r6q8Gx/Ohw7zXh9a6p6Mvc3B+K/
MjkXupNyrzvqbqqB2WGNljZLc68Ja6K0UBq5MKyp0tID8PnJ/xz619CMHhrW
QGmfenReWKOlzZoRmg1dkp/VjHgmfEfdTWd8JTwzNCukwZr1DWHt0MxvTp7h
mt29sRPhGOju6nH9qzSH/3X0z/I/DHxQKA==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFlu1rl2UUx+/f/bvvSVBBq3zfix4s3TQkG+kEl7XUvakR/ZYbFqjLhz1I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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllNtrz3Ecxr+/3+/zJiXl8A+4cFhmDsnhYtQO9SM3ZswuzLhQ2vbbb3O8
5oKMEWFMyaHEalOUEqXEhfIPzCnG5LCEll1ovB7PxVPP83l/vp/T87y/c3d1
NpTyWZYVQQJ3I8veQ5YVsmwpeIHeiL5BbTf6PnwInOCjaaCJejd6DP4UlOGH
GPsC/wq64VvArVyWjaCfw29rDXQL632EVzHWQ20N2IGuAz9VR0/Af4NK+GKw
Kjwmfg5cRveDPs73DT2SfAedfTnYid4AJlmvlfpxamfQb9Ed6Ivoq+hf6Cr0
fvQlMIdvP6GHwnNUq2BsE7yD+a/RD0EL/C/4zvcHOMNB6p3oAfQEeIAeQ9cy
t0+AzwjvPYX11qFXhu/SCFaj56GPwFeAOng9KMJHWa9Xbw8Oo4dz9mI0+e3k
STv8FPOnsvYrdBu8Wm+Q+cxL0B/QubzfXF51Jb+dPGsI31F3ewRK1Eroz+x1
DWxPPrPO+hjUwGdSL+f9BrPgs8EPeDt77qV+BxT0tmBbODPKyjNQpNYc5spY
f/IZtLf2PA2vDd9ddxpIXlNrydPryZlT1sZz9m4w7JU8bKVWn1x7kncWt4a5
Mnlefinz6OnML8ub8F01dgxeA96gJ9HrkzOs7Cpz8uJdslfyZBxeHfZant2D
LwBrM/dUBXxh+G2U6Ur4onB2lEH1Ri6cVfXI/HCmlWVl4gK8l7Eo2FNxZUpZ
0pi8Vc+qV+VxG3oPehj+ElxJ7jH1ljySd3qD/3dXhuAnw3N15j/MPRq+ezPY
p7OGe0MZ19rKnLKmPdS7XeFeVw9vhjeGs6IeOEu9J7yWelD/jpvJvaJ/yD8h
dpsm
         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1083, 1346, 1416, 1415, 1276, 1419, 1171, 1417, 1170, 1418, 
         1293, 1294, 1176, 1422, 1175, 1116, 1085, 1387, 1133, 1361, 1362, 
         1179, 1506, 1178, 1390, 1134, 1389, 1392, 1391, 1430, 1297, 1090, 
         1479, 1182, 1279, 1118, 1091, 1323, 1324, 1186, 1432, 1185, 1433, 
         1455, 1454, 1434, 1397, 1398, 1396, 1135, 1399, 1190, 1507, 1191, 
         1138, 1367, 1368, 1369, 1096, 1325, 1100, 1485, 1252, 1327, 1326, 
         1253, 1520, 1254, 1199, 1207, 1525, 1206}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1101, 1200, 1139, 1195, 1483, 1098, 1121, 1281, 1194, 1482, 
         1097, 1301, 1435, 1436, 1401, 1137, 1400, 1136, 1187, 1480, 1093, 
         1120, 1366, 1365, 1394, 1393, 1092, 1119, 1183, 1431, 1184, 1299, 
         1298, 1322, 1320, 1321, 1242, 1337, 1271, 1272, 1335, 1334, 1087, 
         1117, 1364, 1363, 1261, 1466, 1260, 1341, 1269, 1340, 1268, 1349, 
         1348, 1347, 1424, 1423, 1132, 1385, 1131, 1386, 1421, 1420, 1319, 
         1460, 1250, 1459, 1251, 1318, 1317, 1080, 1474, 1249, 1164, 1166, 
         1503, 1165}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1, 226, 17, 1023, 33, 49, 65, 81, 241, 97, 245, 338, 1040, 
         113, 1452, 804, 340, 259, 129, 271, 145, 161, 177, 193, 1026, 209, 
         289, 225}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{15, 1526, 1528, 1527, 1220, 1222, 1512, 1221, 1218, 1156, 
         1499, 1155, 1288, 1079, 1473, 1161, 1274, 1163, 1502, 1162, 1291, 
         1082, 1475, 1167, 1275, 1169, 1504, 1168, 1292, 1084, 1476, 1172, 
         1277, 1174, 1505, 1173, 1295, 1086, 1477, 1177, 1278, 1428, 1429, 
         1425, 1427, 1426, 1450, 1088, 1351, 1350, 1373, 1372, 1388, 1230, 
         1516, 1231, 1227, 1229, 1515, 1228, 1309, 1089, 1478, 1181, 1180, 
         1224, 1513, 1223, 1296, 1146, 1496, 1147, 1125, 1264, 1522, 1265, 
         1238, 1452}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{211, 1339, 1237, 1263, 1521, 1262, 1219, 1214, 1492, 1110, 
         1306, 1209, 1511, 1210, 1285, 1208, 1488, 1104, 1304, 1202, 1510, 
         1203, 1283, 1201, 1486, 1102, 1303, 1197, 1509, 1198, 1282, 1196, 
         1484, 1099, 1302, 1192, 1508, 1193, 1280, 1437, 1438, 1352, 1353, 
         1095, 1451, 1375, 1376, 1374, 1378, 1377, 1395, 1225, 1514, 1226, 
         1188, 1189, 1481, 1094, 1310, 1233, 1517, 1234, 1232, 1236, 1518, 
         1235, 1300, 1144, 1495, 1145, 1124, 1240, 1519, 1241, 1239, 1453, 
         113}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1075, 1471, 1243, 1148, 1245, 1529, 1244, 1311, 1312, 1246, 
         1472, 1076, 1313, 1077, 1380, 1127, 1379, 1128, 1158, 1523, 1157, 
         1381, 1382, 1357, 1456, 1114, 1457, 1314, 1247, 1458, 1248, 1316, 
         1315, 1081, 1289, 1290, 1159, 1343, 1344, 1345, 1358, 1115, 1267, 
         1469, 1470, 1467, 1266, 1468, 1259, 1342, 1270, 1338, 1360, 1359, 
         1524, 1160, 1500, 1501, 1414, 1413, 1129, 1383, 1130, 1384, 1078, 
         1287, 1412, 1151, 1411, 1152, 1273, 1113, 1149, 1497, 1150, 1126, 
         1154, 1498, 1153}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1112, 1494, 1217, 1216, 1258, 1493, 1111, 1332, 1333, 1257, 
         1465, 1256, 1331, 1463, 1464, 1462, 1461, 1371, 1143, 1213, 1491, 
         1109, 1410, 1142, 1407, 1409, 1408, 1108, 1330, 1103, 1487, 1255, 
         1329, 1328, 1336, 1122, 1284, 1205, 1439, 1204, 1440, 1305, 1107, 
         1405, 1406, 1403, 1141, 1404, 1106, 1490, 1212, 1443, 1370, 1140, 
         1402, 1442, 1441, 1123, 1105, 1489, 1211, 1308, 1307, 1356, 1355, 
         1354, 1215, 1444, 1286, 1448, 1449, 1445, 1447, 1446}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1859694743]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1413138780],

Cell["Specify an explicit set of contours:", "ExampleText",
 CellID->460195261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "-", 
    RowBox[{"y", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Contours", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1412547163],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFnA2UllW1xycZUUqKMJCobmJo+VVqn3bhnheVkjQvkpF3pQRElimpqDe0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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmG2QlmUVx+/nee77Xt0FNF0QtsEW3F12l7HaFZj6UM1kxWqDu6Uzu9/c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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllVeMj2kYxb/5vv/7jo2axQWJZZQZQ5RR5s7FqkFEvXApoq2N3jZ6IkQW
MfqMFiXZDREJUYJoGy6ElVV2dUaizbA6EaL8jnNx8j/ne563Pe1fMHLSkIlp
kiTjQA6UhSTpDvbzcSioD6/CUJWXJEvR1fCa+UlSi99i/I9gbwSOwJthXwb/
CTyGDwQn4MeDfe+xx3T4n2AstvPgErxHTJLmWZIsSr13P75tyPMZL8BC7L9h
L2WPVvBiUAvdFv+O+DdAV8On4PuStbVBJ/QF0AxeA/uT1D6v0I1Z0xnfq+z3
HJ0PxmA7B+rgm6EHsP9rdA/4Nr4tgd/VndCXwV7p1G+N2B+mfnNT9CZ0Beur
0DvQpZxXwXl/sb4Xtq1gI/Zr6HJxUI7+D10X/0p8C9GLWd8FW2D9J/QjdH90
v+hY6k5b4C1YU5F6zzHouWBy5hi+h/+IvRr9FLRGH0OXp47hB/R69HD0MTAB
PhGcynNOf8beDtTFtwDMwNYNvE8d467wKdhHY1sO7uecE+WiTmLfgP1B6jWK
VZPgtyhm29E9g2OrN5TCp/JtLHutABXRMVEsFKN/gmtGtTI7te9n8Cbzmuec
Wxn8li6cPwh+APt05ZMzfkHfRK/B3hA8Q/8PRsFP4v9ObwHr8hyzPth+4D35
OX+bh62Qb9OwTQV94W3A1tQ9Mh6+KvruV8FB+ODgs2ehx8HLomN1ESyAtw62
zcyc67ucpZ5Uzjep/8AZPrzNXMuqMdWWanotenV0bZVlzsUtcCVzTjrBS0Al
+9XLnIsO0Vw5ybHXmui1zdEt4dP0ptQ1UoCeFNzbe8Dm6JpVrarGi4PfoLt/
71Huvz04lqp59dLfYHfqnjod3NPqZcXsV/RmMCL1G6uD76S7nAVz2HsX2Jm5
ppNgH9m0pj22L+iS1DW6Cn4LHEIPA8vh/4J98EGqWe5Xku/a0QxYh+0eOJq6
B2oEzxDNDs2oEDwjNBtUI1+ic6JcqOZ09tfgWaA7FAXXiGpDNTc/uiZVi6qZ
j9g/BcdSMdasXRF8N81c3X1l8OzVG7pH96B6TzPyBvxadO1eyhwbzWjNZsWo
KHpGajbWRNdW/0TPMvX07egaVW2qRjTLCqN9NdNuo+8Ex65F4thohmh2KEaK
5e/Bs10xVW6vR99FOe4dPeM02zTDDgfXvGpdPadeepLz3uqpP4L/E/RfoBn8
DaQy2+c=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6035828872663465, 0.5914519384451056, 0.9104051929045551], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmnuwltV1xr/vey/HK4xCBK1iELlq8AAGxRkkcMgFvFTxHJ1JOzVAbWva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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnm0zVUUx++7951zoyi8KJE5wxOZ4lnLUFQkIalV/WF4S61W5VlLopLm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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7228689718165866, 0.7831114846112766, 0.9131245482261389], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXm0ltV1xt/ve4eLtg61ahXSKCVrZWgSY8JVhKtCFw4VI6BGHIgCWhVl
MKDEARQhRgmaDlGbUhPEoBfU5RAtNIOmKohAS2KcSbVBRJNIBEWiWOH2+fk8
d6V/7O+c94z77LP3s/c+X/8JU0+e0i6K4nf6KVUeVhVFp2hwqyguVtvNanxG
9atUv0X1k1Suqotirqil9gGl2xkzT+V80R1a52b1HyvaqPbrm6L4gur3qr5B
5auin2qd32ufV1T/QuF9bs06W1vu36Ly/fDwS9UHa+wtWusJ1Wdp7kzRMPVt
1vfzGne7yhPVNlptA/XdJfqZqK32X4jWiYaIbtA6/USnqP7PjddlTfZnL/Y8
LXMYP6T2OMZcofq3VN9d9Xe110Z9jxT/P9ecY0UD1X6Xyj8VLePsKhdqzV+r
vlD17vC7QPP26SiKs9V2QumxS7XOQVpzOf2FZXtr+LlDe/6g8VoniR7RmOUa
M099d+r7TX3fqf67RIv0fZ/K+xvvd1vbbRs0ZpXavi36juaerr3GiI5jDZWL
RQNFN5S+S+7xAc2p1D9L9S2l+/5J9Y+p/QS1P6P6PVrv3sZ8PK22h0Xr1f+6
1lqvcx6sMYsKz2XNaWrrEq3SmLEqb2i8xz36LlVeqjFr1d6j+f+q+l+pf4Co
j+Z/RuVnRf00drL6J4n6as4v1fasaK3G/InKg0RjNHeNyv/k7krLeq+2eThA
3/uJfqv60W2v/cm29ahVWpcO17xBor+IfHepb7DGr2u7bXDbdEDW4Q65d+5u
hPj/S83t0fcF4vH8ynuzRk/WeVZjPlT7NapjfPQt0BotzTtAdLPqbenIdbVl
PVTUtzS/Peov1fcHfb/HOJXHa5n5av9frTlf9f017+za9a2l76/W3Nc05nXR
en2PbbttbmEd/UD1z6reVVnvsLsdqs9rfDedok+Xvt8r1dZf6/+D6hs15vjG
fWepbW/x1tbY/dS+r+hD1tG6H6g8DV3SmK+JHld9qdp2is4prO8DggMrNK9H
5d+pfbTqo0R9sE3Ne632HOjDzEUGb7Uth5tU7sheH2FAcOA9rfHNxutO0BoH
dfjO7hcdI1rb8jjK9zX3Iq15segm1UdW/r4anax9fs5+IDoIFqk+Hf0V9UeW
GjdddJ7oJfXvUrm98PqsPa2wzqPvnBFcuTzY8nmt/43GsrlG9U90GF+mq+1S
0UTx0dKaRWWM3Q89bXx/Z6jvCtHQwmc7t7ROfjFYgC7PS4kefk/rvyn6oep3
tbz2vGDq5ozp0/LZkcM20VTROPREbVtVThEdWhvr742tsD76PC93jxzebdm2
uCP8w3fiI0qdo13ZFyyszPuh6Enhux0l+orGfrf2fb+d/UeLhqVkDGc/vTQm
H9Eyr5eIVlbWp9tEvxCP54E/YKvK90QviN+j9L2zMNatUdvq2lg+XuW42roH
Nq+JPHsK6wKyqNU+J/e9B5gpuhZ+gq+76fu+lu3sI3xrWd8GxnavjO5eK97m
NP7+uvbs32E/xtifZ/w7WnO/+B3woE8wYXtKsHGi1riosX7drrGTauPkoZr7
iMaNF01S/+TGfIHZ62Lfd7e8J3p6S+wRv/9C8BF9mA1uVfZdc1XOqeyXFqj/
oeD/V9U2VnSivhfXtnns/dra2Afugbn41ZWF9fuq0jqI7n+utv7frfIQyeFy
9X8NHWq85vPcW+39+pWWBRiJvg1pW+fA/CeC+/hiMA58Qw4TSmPjIeGbvslt
xz3gz7Nt+0zGz9Q+Azp8Dx+An7V96Bsqf1N7D+xsQnQDP46M8V8b8e+leeqM
z8BfbMge2Mh/aI3Nlff6huqza+sNdkw8hD0sqqzf1GnbkvY91b5H5W9k8XTk
D+5iC6My9/Z8D1L/KaV5eUn7vFj7/he3rIP4zbdZs8O+BdusgjMtjT1AtExj
XpUc/l31R4PB7Mdek7TGRNGrhfEJnDo47cSRG1W/TOW04OQbpe+WmAscWhgs
2qD2mW3Hcr/VXj9W+4qW74n7wj/iT8B6cJ6xF4pGtyzb6+PLntLch9GT8IhP
wnY4UxnMuUD9/1bbvvcIFoE/8xM3EDPMyPj+he3iqugJeD8jZ9kt/qAn5706
suC8s3Nm9Gty5MP3NehZ4XJ2+L8s2M5ex2mvV0rbCDJ4q7Ecjih9Z2Oy1+Tw
c1H2YP1Z4QGZE9teHJ+Ovzowscfs8PfRvjkLMh9R+Wyfb1tv9o3cZmQ85+Vs
7NEqvM+k7DU5dXggroSnP8u9z8xem+OHwJO+4FBtW9gumt+2jyBm/0Ew6Rli
udpx8ibV19WOgckh3sg9PlUas4nFHlX9Z6Vj2Osaxw3EC0+WHseYx0vHhtgp
Nr0qsTFx62vRW/Tiuca68VTtmLUKFoNV+DVwa2Kwa1l8BHzCwyPBmcEqfyTq
Vv9Srb0kWMz5unLGFyqXxAbo10mR5/fV/r3Kdz4+a95Y2P7eaGyD8ITvxX+d
o/YnG5+fuO2+xBljwODGfKxtHGdzduLllbV1Cf3fM/LcEnvAFoiLb2zbf7eD
OYwh3tw/ceaj7NkY744U/bg0hp8ORjb+xmc8Gfljl//V2DbJ5x7PuTjj47kX
YrV7Egf+WmMPr53/gKfsAwYcVTsvJSf9EfuIfqi+RW2X6NSq7LuksPwfjW6Q
L55cGjseKq17jEdPN6SdvBJ72Ce5wXuJYda37cOwzcXRXdrbxMuNcxzubnDu
fXHsFrz6EnF+h9ekn3bkzxxs7unC5xxeWs/f1PjfN8YCZEvsRdzVL/EntvwT
YoDSetCVcciftqEZT+78N6Vl/o7W21k5rtuaeI54i/5hifeI/YblXtCRP1Tm
E/8/PPKkPCZ1YoMRpXWyaJzPgNXg2PGlfcdYtX1VdGxpX/Tp+KNK8ti9tjyf
jK4sCeZcGlziTkbnXtbFnzKX/Y/NeOKR47LXE9mbNVeHT+TaWTonJyYdkb2w
WTCmHZyZn37udGjkiQyJeUaWxuHnSsc+yxLPoBPEYK/mbPjbkRnDPYJbTbCL
eyLuxGaJPY/K+kflHqdEtusz9yTN+3iH/f+tkt/ZjWUKjwtjm6+X9qn4U2Kl
62vHS4MSgxAffSD+N9XO/3aW9jVgHb79lcZngd/nIqtFsQn0lzePd+ILNpXe
j71mNNYndIa9NmY/YrZtjceBQ+w5t/A38+kHV7Ap+F9e2qdj1zuyN/velnhs
Qc66OePRBXQC3eBtoOiw/MHiecHn3viYd4v9G8dbxAbLwHXeSkrn0oxh7pvZ
b0F80f2R8bdr537kfeSU5I3E8tzDObmLByrn2/iRd0rXybEXJC7DFrZnP/L6
HpW7Ssufe+A+8Ps7yOUbz6efcey7ubGdoM/TKvfhW5eU9qfI5Y7S8Q/ygp/v
Vn/M/yl5w7lM63y9cX67I3cLLuG71sYWHqqdM4PBO8m9auv3zMQAyPzPtcY+
jd8LrorfJw7hzeNa0YNaZ7vmvVs73uXN5jrRY8GWoS3nUcRMw1Ifp/U2NrbL
gTprp+jW5P+jkmuPzJsA+fJw0V4t51z/KNq75TMim52R7Zr4HOLzwVr7CNGB
pd9vWJv3IPIHdAU94Y2qHQyf0thm0F3eR8nriPUuVPsFjePyixu/leBv4WVO
eGHsmckDySOvTC65KP3wyf3w5sYb2dDG72roxt+q/VOV86YJav9dYyy5UG0D
KsfJ5HZ3Jr/DZsE+7Je7+uvG94VegoFgITgHdvfiNnWwmvx+ZORZRabIc2B0
DN37RG1MR4d7ZQf+8pa5q3KszFvikMpxJvn751r2KXtqzLbKukY+t7R23P8l
1fcqLH/eOa6unQvyhvR+ZTvDT+5W21d2Rvbk9bzfnFv7neNltf935beWLY39
Jb6SvG1W7dyNfPry2vEW8kbu2Cl6NDpnJ+85pTYe9Y3OoW/HtKxX3CtvO0e2
nO/36iJ6u6xyroDO42eGBz8PbPxGw/sMcQ2xTm/MMyv1Voff9cAF8mbyZ96o
eVs4MvEbPnD6/4vJhxXOuYZlTXz0bxq/8eEzyCPnJJckliOOG1r4rvvE1s5S
eVblN//uyjER/ggd4C2DWJTYkziGGIZY5fuJRVcmLu1OzDI9cQs23SfroL/o
Me3MYfxpWfO21PeOfPELnItclbMtTN4Kz5QL0w7mn5h4rM5c7mVM8hr0owz/
6DBvAexFDAkvJ1S2a3If8i7yMOLxpTk/ed6M5IHcBfJBTozpjpyxC3IbsBd9
R+9pwxeuVXlqy/13xhb6RL7IpDvxP3sRyy/JmqzTlfHY5exe22x7LdrxEeSH
ve9m1PEXxLPwz3q8GYMjYMiw3PVNudOu6O2W6D+Yc0LuCJz5suZtqvwuMr4x
FoPDI7Gpyu+I6DAxOjyfFRmhq6PxV5VjqzNUX904lpyq8sbG7yPgE/HTitjT
3GDgmcHVVvAHHrnTOrrPuC/WfrcijriisQ/DfxHfjM0dndsYK0cG8+Zkr1PU
tr1ybHJ04nZ8/ZmNeYVP3mW7ovPoEfpEXE3sj77h78B63lPQ0xcr52yrg+9j
onvoJXOwCTCO/5LQi4/JxofWzmvR50XRbeadnr12xn7Qk6+Ir1Mb29xewWRk
clh0Epkf0vI757jgw4jwyfmRMz6Bs4Ez6ALx45drx5D45H6N/TL2uDI2CWaT
D4Db+PDz42+Q769UnqxyUMbw/kn/BfFHa2MDQ+LbOQ84wxvtluDVoMTsvINt
jY8Yl3MdHh3gLsixzyuM6WD7JbkXMLcn87bk7MOjN8gHmfBGPL4w3+eHt94c
G95eiX6gG9hQGZsiNiFGAbfQK85MjDohOk/8gM0sit72TUxDPHNHfAB9u8I3
PCOv9ZXf/1dHZ9AxyhfDD/0vZcyatDOW9l8Fn1/ON3XeNDnXg9HZKnrbGVkN
Dq4fljpy5s6mBH/ABOx3W+Q1PvgDhvXGt73/h/BuBAaBP2ABuEQcwZsP7z+8
Aw2rrd/rcufsNTW+srNl7H07e3Ff8NgZ+XSGT+6dWGNgcPUBrblv7fzgjIxn
zBPBIPzmpuQfp8YP1MGUD6XX/1I7Bt+eWJu47u6caVp8eB2sQW/XBLfh7eXI
DX6Is4kjDw+f2B14iQ/Br4FB+NTdo5f898C5Ho6eE/eDtcTixBvkZPOSl23L
eGS1NfkD2Lw+PLwU27swOkaJzlH/qc74k8bvFtgt/3Eg53WN//tETrzNjoot
fyq6Dc6T6/M2QPvfk7c1jokeVPlA43wCX8Jb+fzcIX6U9Z9v/J8reQLrTc6a
W2Ln48LnxPAKb8w9Lb64M3bN//BH15YnbegK7dtjP+Njd/CA7ZGHcMbu6PO4
4M/7mTc9+gaP+Iwl4rG7cT70VvJIcvn/UdvLjfPbIb25ptpPrR2nEqPuim3A
AxjwWGUcOKT2/yu8SWEfA4NV2OoeiTu60gY/u0UnLgm2Tw0erosuDgmmsgf6
Rt5P/n9vcH1X5hKjjgz2YfsPBm/Q2bXBkKfF1/m13znI9cAnbIF4+q7wis8l
75gTvesJT9wlOdLy8LM+OM+ZVgev1gSTOOMK/GbtN6eDK//nwXvdxOgqeLs+
MTAxzGPk3Y3ze2S/IfJfEb/THZ+CjMAoYmXe+sk1iMN55yIWfzF2ynmPjM5w
1+wPH8tzV8jz5ODCmvCMDjEODP84/yORz6jt/wC0/HcR
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnmwjmUYxt/ve7/nIRlZEjlqlMqUJYUIRU3KlCUOFVETldSgbayVQYkR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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmFuMllcVhvd/+L5fS2NnqqKVGWrVcsOhak17MRWKQQQLXKC0c0axHITC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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlF1o11UYx8//9/ufIyLCXLqmo8lMuupNuwhMELwYjl4urFm+bNYq860N
g24E3+amvejELGuBJNXAK5EyKFAZ07S80sASoTm3uQm6xmS6ckv8fPl68eX3
fc7z/M55zvN8z1PV0LS0MQshvAeKoC2FcA505iF8AvbC9yXz44UQemMI18Ai
YpfzYwu+p7G34d8CSieF8HV0bCUbXoEP8K0l9idQQfwoa0P4/8fOsTNwDd4L
yvn/uWT+JP8dILYa/Jx5jznwNrAUfgsUiA3gKrwH/C0O/iSXCuzd8HnEt2A3
g5fglboPvn/IYSN8Pmut+FaD/zhzA2t18A9VF/hasAL724JrM0B8V+YafQWv
BaewV2a+y0LsO5nvtAe7CfzAv7uJ78C3EZzD965iknNWrn/hv4FvEHzH2W+x
VorvETAGLwk++x72SO4c1sGfYW079irQBx8tOpeToJJ6vhKd+2LW18Av8s8R
fNPAGGs/qqbwNexfBh9nbRL2PtCtXhXd61/AVPYbwa4hdhrfMfz/gsP47nJG
P3yZ+pW7JtPhx6J9+mdX8pk6Szk/ij1D/cY/Tvxr8FrwAr77rA0WnYPOXpY5
t0+Ta6kcP4Kvwn8id49nk18Ddjv7VxNbH30n3SWBj5N7rN6q5+XJGpJ2JsD7
yZqQFt6UJuD14DK8BvQ/1LS0LA22wyf0XuB14DH4i9HaUk2U22+gI3OOp/G/
gR0yv5mnot+Q3s5WUKf7JPdmf+azD4LPcudwVrlF30V7PhutcWl7J1gC7yPH
So4Ywv92dE1UC2nw5WhNSAt6w5uwh8F5Yp9QD1n/VXrJ3IMq+Gb2bMytwRnY
t4lZkflNXJcesVuCa6B/ZxOf595DvZ2ZXFv1+Cb+Q9HaPguOwmclzwK9ycfh
c8AZ9hvNfJY0LS3rzFvYndoDfkl6UD+Ta6830QzfATo4a5i1L6Wl6L0O5J4V
c6Nro5mh2fJ5tLY0Y5bDzyTXUj3SWz0MGjK/2S/wLcAu5u7J5OiZpVn1R3At
GpO1o5ooVjnobP2jWn8f/fZV81ej35TeknLW3cqS34Lu2AV/Pfot6I2+A7+Q
rI0S8Lt6F82l+fXJM0GzQDPsm+iaq9a6Qze+ct0584zULL4TXUvN5PtFz3DN
bs0gxRaita9/NNs+iNaKZtzz8J7k2aWZot5PSa69NCDtaGZrVktDmg2tyVrX
jHgAbxLiDg==
         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1247, 1604, 1554, 1555, 1553, 1821, 1313, 1658, 1314, 1422, 
         1798, 1252, 1498, 1254, 1799, 1427, 1350, 1428, 1800, 1255, 1502, 
         1261, 1804, 1431, 1506, 1505, 1357, 1822, 1358, 1323, 1639, 1640, 
         1301, 1266, 1507, 1268, 1807, 1432, 1365, 1508, 1366, 1669, 1325, 
         1668, 1326, 1731, 1368, 1622, 1624, 1623, 1369, 1732, 1328, 1671, 
         1329, 1672, 1372, 1480, 1331, 1734, 1375, 1733, 1374, 1302, 1275, 
         1675, 1676, 1647, 1648, 1379, 1823, 1378, 1481, 1482, 1381, 1743, 
         1380, 1744, 1303, 1629, 1628, 1627, 1382, 1745, 1335, 1760, 1761, 
         1757, 1759, 1758, 1304, 1281, 1631, 1630, 1686, 1685, 1338, 1687, 
         1339, 1552, 1571, 1570, 1595, 1596}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1294, 1636, 1289, 1816, 1587, 1540, 1539, 1538, 1340, 1394, 
         1824, 1393, 1519, 1444, 1838, 1445, 1388, 1440, 1837, 1439, 1515, 
         1437, 1836, 1438, 1512, 1511, 1278, 1810, 1434, 1332, 1677, 1679, 
         1678, 1735, 1510, 1786, 1787, 1785, 1433, 1788, 1373, 1509, 1274, 
         1646, 1645, 1644, 1330, 1673, 1273, 1643, 1642, 1641, 1327, 1670, 
         1271, 1459, 1458, 1730, 1367, 1620, 1621, 1270, 1477, 1567, 1547, 
         1548, 1666, 1665, 1324, 1363, 1805, 1265, 1300, 1456, 1362, 1526, 
         1527, 1528, 1475, 1565, 1355, 1564, 1356, 1566, 1454, 1562, 1563, 
         1524, 1525, 1260, 1472, 1558, 1559, 1557, 1561, 1560, 1537, 1536, 
         1316, 1546, 1608, 1251, 1296, 1776}],
        "1"],
       Annotation[#, 1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1, 617, 226, 618, 17, 1138, 1021, 33, 1142, 1026, 49, 1183, 
         65, 81, 241, 97, 245, 338, 1217, 113, 1779, 997, 340, 259, 129, 271, 
         145, 161, 1206, 177, 1153, 1059, 193, 1157, 1064, 209, 627, 289, 626,
          225}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{15, 1843, 1845, 1844, 1398, 1593, 1594, 1590, 1592, 1591, 
         1522, 1496, 1497, 1448, 1495, 1494, 1468, 1253, 1613, 1612, 1699, 
         1698, 1452, 1703, 1704, 1700, 1702, 1701, 1471, 1259, 1615, 1614, 
         1708, 1707, 1453, 1712, 1713, 1709, 1711, 1710, 1474, 1264, 1617, 
         1616, 1719, 1718, 1455, 1723, 1724, 1720, 1722, 1721, 1476, 1267, 
         1806, 1364, 1457, 1728, 1729, 1725, 1727, 1726, 1777, 1269, 1619, 
         1618, 1652, 1651, 1667, 1406, 1828, 1407, 1403, 1405, 1827, 1404, 
         1491, 1272, 1808, 1371, 1370, 1400, 1825, 1399, 1478, 1344, 1820, 
         1345, 1308, 1449, 1839, 1450, 1414, 1779}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{211, 1600, 1413, 1794, 1795, 1791, 1793, 1792, 1580, 1578, 
         1579, 1532, 1533, 1290, 1796, 1772, 1773, 1771, 1775, 1774, 1466, 
         1769, 1770, 1634, 1635, 1286, 1486, 1765, 1766, 1764, 1768, 1767, 
         1464, 1762, 1763, 1632, 1633, 1282, 1484, 1747, 1748, 1746, 1750, 
         1749, 1461, 1383, 1811, 1279, 1483, 1739, 1740, 1738, 1742, 1741, 
         1460, 1736, 1737, 1625, 1626, 1277, 1778, 1654, 1655, 1653, 1657, 
         1656, 1674, 1401, 1826, 1402, 1376, 1377, 1809, 1276, 1492, 1409, 
         1829, 1410, 1408, 1412, 1830, 1411, 1479, 1342, 1819, 1343, 1307, 
         1416, 1831, 1417, 1415, 1780, 113}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1250, 1607, 1249, 1840, 1556, 1545, 1312, 1544, 1311, 1691, 
         1692, 1688, 1690, 1689, 1295, 1248, 1606, 1605, 1694, 1693, 1315, 
         1697, 1348, 1695, 1347, 1696, 1297, 1611, 1610, 1609, 1349, 1470, 
         1469, 1258, 1803, 1354, 1706, 1638, 1660, 1659, 1705, 1299, 1257, 
         1802, 1353, 1322, 1473, 1263, 1664, 1321, 1663, 1320, 1717, 1361, 
         1715, 1359, 1714, 1360, 1716, 1319, 1661, 1318, 1662, 1262, 1504, 
         1352, 1784, 1430, 1783, 1429, 1503, 1782, 1298, 1781, 1637, 1317, 
         1351, 1801, 1256, 1500, 1501, 1426, 1835, 1425, 1499, 1423, 1834, 
         1424, 1346, 1421, 1833, 1420, 1493, 1418, 1832, 1419, 1310, 1542, 
         1309, 1543, 1588, 1797, 1246, 1589, 1599}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1291, 1306, 1521, 1818, 1842, 1841, 1451, 1523, 1488, 1489, 
         1603, 1602, 1601, 1581, 1582, 1534, 1535, 1292, 1490, 1574, 1575, 
         1573, 1577, 1576, 1467, 1572, 1395, 1529, 1530, 1531, 1487, 1569, 
         1391, 1568, 1392, 1465, 1305, 1389, 1390, 1336, 1549, 1551, 1550, 
         1283, 1485, 1752, 1753, 1751, 1385, 1754, 1462, 1463, 1384, 1680, 
         1333, 1649, 1755, 1756, 1386, 1681, 1334, 1650, 1789, 1790, 1435, 
         1513, 1387, 1436, 1812, 1280, 1514, 1284, 1683, 1684, 1682, 1337, 
         1442, 1846, 1441, 1516, 1517, 1443, 1813, 1285, 1518, 1287, 1814, 
         1446, 1396, 1447, 1815, 1288, 1520, 1293, 1817, 1397, 1341, 1541, 
         1583, 1584, 1586, 1585, 1597, 1598}],
        RowBox[{"-", "1"}]],
       Annotation[#, -1, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-2, 2}, {-2, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->248450956]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->988985817],

Cell["Select five contour surfaces in three dimensions:", "ExampleText",
 CellID->1934030579],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}], "-", 
    RowBox[{"z", "^", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Contours", "\[Rule]", "5"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->361198539],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 215},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78576931]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2401],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mesh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mesh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeshFunctions",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MeshFunctions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContourStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContourStyle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContourLabels",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContourLabels"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContourShading",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ContourShading"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3034]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13758],

Cell[TextData[ButtonBox["Density and Contour Plots",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DensityAndContourPlots"]], "Tutorials",
 CellID->32255]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Contours",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Contours"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->318663613],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->446286157]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Contours - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 34, 44.6745132}", "context" -> "System`", 
    "keywords" -> {"contour levels", "ContourLevels", "iso levels"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Contours is an option for contour plots that specifies the contours to \
draw. ", "synonyms" -> {}, "title" -> "Contours", "type" -> "Symbol", "uri" -> 
    "ref/Contours"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13761, 395, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->916915954]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 224212, 4119}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2232, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2855, 83, 4192, 83, 70, "ObjectNameGrid"],
Cell[7050, 168, 453, 14, 70, "Usage",
 CellID->21476]
}, Open  ]],
Cell[CellGroupData[{
Cell[7540, 187, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8018, 204, 212, 8, 70, "Notes",
 CellID->6334],
Cell[8233, 214, 3294, 97, 70, "2ColumnTableMod",
 CellID->485],
Cell[11530, 313, 449, 12, 70, "Notes",
 CellID->26843],
Cell[11982, 327, 476, 18, 70, "Notes",
 CellID->16371],
Cell[12461, 347, 617, 21, 70, "Notes",
 CellID->16760],
Cell[13081, 370, 643, 20, 70, "Notes",
 CellID->5752]
}, Closed]],
Cell[CellGroupData[{
Cell[13761, 395, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->916915954],
Cell[CellGroupData[{
Cell[14146, 409, 146, 5, 70, "ExampleSection",
 CellID->2642354],
Cell[14295, 416, 73, 1, 70, "ExampleText",
 CellID->928250401],
Cell[CellGroupData[{
Cell[14393, 421, 375, 13, 28, "Input",
 CellID->1783277799],
Cell[14771, 436, 78208, 1325, 204, "Output",
 CellID->1268190261]
}, Open  ]],
Cell[92994, 1764, 126, 3, 70, "ExampleDelimiter",
 CellID->1601823287],
Cell[93123, 1769, 81, 1, 70, "ExampleText",
 CellID->1007007724],
Cell[CellGroupData[{
Cell[93229, 1774, 421, 14, 70, "Input",
 CellID->698520152],
Cell[93653, 1790, 33438, 582, 70, "Output",
 CellID->1859694743]
}, Open  ]],
Cell[127106, 2375, 126, 3, 70, "ExampleDelimiter",
 CellID->1413138780],
Cell[127235, 2380, 79, 1, 70, "ExampleText",
 CellID->460195261],
Cell[CellGroupData[{
Cell[127339, 2385, 505, 17, 70, "Input",
 CellID->1412547163],
Cell[127847, 2404, 40458, 689, 70, "Output",
 CellID->248450956]
}, Open  ]],
Cell[168320, 3096, 125, 3, 70, "ExampleDelimiter",
 CellID->988985817],
Cell[168448, 3101, 93, 1, 70, "ExampleText",
 CellID->1934030579],
Cell[CellGroupData[{
Cell[168566, 3106, 594, 19, 47, "Input",
 CellID->361198539],
Cell[169163, 3127, 50622, 834, 236, "Output",
 Evaluatable->False,
 CellID->78576931]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[219846, 3968, 310, 9, 70, "SeeAlsoSection",
 CellID->2401],
Cell[220159, 3979, 1217, 44, 70, "SeeAlso",
 CellID->3034]
}, Open  ]],
Cell[CellGroupData[{
Cell[221413, 4028, 314, 9, 70, "TutorialsSection",
 CellID->13758],
Cell[221730, 4039, 158, 3, 70, "Tutorials",
 CellID->32255]
}, Open  ]],
Cell[CellGroupData[{
Cell[221925, 4047, 305, 8, 70, "RelatedLinksSection"],
Cell[222233, 4057, 361, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[222631, 4074, 319, 9, 70, "MoreAboutSection",
 CellID->318663613],
Cell[222953, 4085, 143, 3, 70, "MoreAbout",
 CellID->446286157]
}, Open  ]],
Cell[223111, 4091, 50, 0, 70, "History"],
Cell[223164, 4093, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

