(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38074,       1168]
NotebookOptionsPosition[     32738,        989]
NotebookOutlinePosition[     34143,       1028]
CellTagsIndexPosition[     34057,       1023]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Advanced Dynamic Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedDynamicFunctionality"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Advanced Dynamic Functionality\"\>", 
       3->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EventHandler" :> 
          Documentation`HelpLookup["paclet:ref/EventHandler"], "CurrentValue" :> 
          Documentation`HelpLookup["paclet:ref/CurrentValue"], "Mouseover" :> 
          Documentation`HelpLookup["paclet:ref/Mouseover"], 
          "$ControlActiveSetting" :> 
          Documentation`HelpLookup["paclet:ref/$ControlActiveSetting"], 
          "$DynamicEvaluation" :> 
          Documentation`HelpLookup["paclet:ref/$DynamicEvaluation"], 
          "PerformanceGoal" :> 
          Documentation`HelpLookup["paclet:ref/PerformanceGoal"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"EventHandler\"\>", 
       2->"\<\"CurrentValue\"\>", 3->"\<\"Mouseover\"\>", 
       4->"\<\"$ControlActiveSetting\"\>", 5->"\<\"$DynamicEvaluation\"\>", 
       6->"\<\"PerformanceGoal\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Dynamic Interactivity Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/DynamicInteractivityLanguage"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"], 
          "Gamepad & Device Interface" :> 
          Documentation`HelpLookup["paclet:guide/GamepadAndDeviceInterface"], 
          "Interactive Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/InteractiveManipulation"], 
          "Low-Level Interface Control" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelInterfaceControl"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"Dynamic Interactivity Language\"\>", 
       3->"\<\"Dynamic Visualization\"\>", 
       4->"\<\"Gamepad & Device Interface\"\>", 
       5->"\<\"Interactive Manipulation\"\>", 
       6->"\<\"Low-Level Interface Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ControlActive", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ControlActive",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ControlActive"], "[", 
       RowBox[{
        StyleBox["act", "TI"], ",", 
        StyleBox["norm", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]evaluates to ",
     Cell[BoxData[
      StyleBox["act", "TI"]], "InlineFormula"],
     " if a control that affects ",
     Cell[BoxData[
      StyleBox["act", "TI"]], "InlineFormula"],
     " is actively being used, and to ",
     Cell[BoxData[
      StyleBox["norm", "TI"]], "InlineFormula"],
     " otherwise."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 " can be used to switch between a faster computation to be done while \
controls like sliders are being moved, and a slower computation to be done \
once the controls are released."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControlActive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlActive"], "[", 
   RowBox[{
    StyleBox["act", "TI"], ",", 
    StyleBox["norm", "TI"]}], "]"}]], "InlineFormula"],
 " can also be used to trigger evaluation of ",
 Cell[BoxData[
  StyleBox["norm", "TI"]], "InlineFormula"],
 " when controls are released."
}], "Notes",
 CellID->42329896],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControlActive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlActive"], "[", "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControlActive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlActive"], "[", 
   RowBox[{
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], ",", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->110610217],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ControlActive",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControlActive"], "[", 
   RowBox[{
    StyleBox["act", "TI"], ",", 
    StyleBox["norm", "TI"]}], "]"}]], "InlineFormula"],
 " is effectively equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["If",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/If"], "[", 
   RowBox[{"$ControlActiveSetting", ",", 
    StyleBox["act", "TI"], ",", 
    StyleBox["norm", "TI"]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->32459985]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->114702987],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->176134988],

Cell["Change the display while controls are being used:", "ExampleText",
 CellID->1102451213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ControlActive", "[", 
    RowBox[{"u", ",", 
     RowBox[{"u", " ", 
      RowBox[{"Range", "[", "4", "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->285816152],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0.742, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {187.5625, {2., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$1315$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$1315$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ControlActive[$CellContext`u$$, $CellContext`u$$ Range[4]], 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}}],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->179883715]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->47515935],

Cell[TextData[{
 "The arguments of ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 " can be any expression:"
}], "ExampleText",
 CellID->384599319],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ControlActive", "[", 
    RowBox[{"u", ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"Circle", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", "u"}], "]"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", "2"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1.5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5655741],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0.86, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1.5}}, Typeset`size$$ = {180., {88., 92.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$2133$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$2133$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ControlActive[$CellContext`u$$, 
        Graphics[
         Circle[{0, 0}, $CellContext`u$$], PlotRange -> 2]], 
      "Specifications" :> {{$CellContext`u$$, 0, 1.5}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {132., 137.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->355722685]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->140714464],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 " to switch between a low-resolution and high-resolution version: "
}], "ExampleText",
 CellID->559667288],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ArrayPlot", "[", 
    RowBox[{"CellularAutomaton", "[", 
     RowBox[{"n", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"ControlActive", "[", 
         RowBox[{"10", ",", "100"}], "]"}], ",", "All"}], "}"}]}], "]"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "64", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38587585],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 35, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 64, 1}}, Typeset`size$$ = {180., {45., 49.}},
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`n$2291$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$2291$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ArrayPlot[
        CellularAutomaton[$CellContext`n$$, {{1}, 0}, {
          ControlActive[10, 100], All}]], 
      "Specifications" :> {{$CellContext`n$$, 1, 64, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {89., 94.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->41938419]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["\<\
Only emit a sound when the manipulator is not actively used: \
\>", "ExampleText",
 CellID->218665680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ControlActive", "[", 
    RowBox[{"w", ",", 
     RowBox[{
      RowBox[{"EmitSound", "[", 
       RowBox[{"Play", "[", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"1000", " ", "w", " ", "t"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", ".2"}], "}"}]}], "]"}], "]"}], ";", 
      "w"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"w", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71107994],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`w$$ = 1.4, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`w$$], 1, 3}}, Typeset`size$$ = {21.5625, {1., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`w$3413$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`w$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`w$$, $CellContext`w$3413$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ControlActive[$CellContext`w$$, EmitSound[
          Play[
           
           Sin[(1000 $CellContext`w$$) $CellContext`t], {$CellContext`t, 0, 
            0.2}]]; $CellContext`w$$], 
      "Specifications" :> {{$CellContext`w$$, 1, 3}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{252., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->753555389]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16765034],

Cell["Use a lower sampling when actively manipulating: ", "ExampleText",
 CellID->802587775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"x", "-", "a"}], ")"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
     RowBox[{"PlotPoints", "\[Rule]", 
      RowBox[{"ControlActive", "[", 
       RowBox[{"5", ",", "50"}], "]"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->93645220],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 0.448, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 0, 1}}, Typeset`size$$ = {180., {52., 56.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$10466$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`a$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$10466$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Plot[
        Sin[1/($CellContext`x - $CellContext`a$$)], {$CellContext`x, 0, 1}, 
        PlotPoints -> ControlActive[5, 50], PlotRange -> 1], 
      "Specifications" :> {{$CellContext`a$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{249., {96., 101.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->7187439]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->47960046],

Cell[TextData[{
 "By using the second argument of ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 ", you can get an effect similar to ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->837063723],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ControlActive", "[", 
    RowBox[{"u", ",", 
     RowBox[{"u", " ", 
      RowBox[{"Range", "[", "4", "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195675894],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0.2, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {131.5625, {2., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$1791$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$1791$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      ControlActive[$CellContext`u$$, $CellContext`u$$ Range[4]], 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->92472409]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Slider", "[", 
    RowBox[{"Dynamic", "[", 
     RowBox[{"u", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"u", "=", 
           RowBox[{"p", "=", "#"}]}], ")"}], "&"}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"u", "#"}], ";", 
           RowBox[{"p", "=", 
            RowBox[{"#", " ", 
             RowBox[{"Range", "[", "4", "]"}]}]}]}], ")"}], "&"}]}], "}"}]}], 
     "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "p", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->452645954],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SliderBox[
    Dynamic[$CellContext`u, {($CellContext`u = ($CellContext`p = #))& , \
($CellContext`u #; $CellContext`p = # Range[4])& }]], ",", 
   DynamicBox[ToBoxes[$CellContext`p, StandardForm],
    ImageSizeCache->{103.5625, {2., 8.}}]}], "}"}]], "Output",
 CellLabel->"Out[2]=",
 CellID->1786646021]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->550439757],

Cell[TextData[{
 "Plot functions effectively use ",
 Cell[BoxData[
  ButtonBox["ControlActive",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlActive"]], "InlineFormula"],
 " for the ",
 Cell[BoxData[
  ButtonBox["PerformanceGoal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PerformanceGoal"]], "InlineFormula"],
 " setting: "
}], "ExampleText",
 CellID->211229140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"a", " ", "x"}], "]"}], 
      RowBox[{"Sin", "[", 
       RowBox[{"b", " ", "y"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "0", ",", "3"}], "}"}], ",", 
     RowBox[{"PerformanceGoal", "\[Rule]", 
      RowBox[{"ControlActive", "[", 
       RowBox[{"\"\<Speed\>\"", ",", "\"\<Quality\>\""}], "]"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "1"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "1", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->942113296],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 2.685, $CellContext`b$$ = 2.265, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 1, 3}, {
      Hold[$CellContext`b$$], 1, 3}}, Typeset`size$$ = {180., {70., 74.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`a$13957$$ = 0, $CellContext`b$13958$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 1, $CellContext`b$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$13957$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$13958$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Plot3D[Sin[$CellContext`a$$ $CellContext`x] 
        Sin[$CellContext`b$$ $CellContext`y], {$CellContext`x, 0, 
         3}, {$CellContext`y, 0, 3}, PerformanceGoal -> 
        ControlActive["Speed", "Quality"], PlotRange -> 1], 
      "Specifications" :> {{$CellContext`a$$, 1, 3}, {$CellContext`b$$, 1, 
         3}}, "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {128., 133.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->76853857]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EventHandler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EventHandler"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mouseover",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mouseover"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ControlActiveSetting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ControlActiveSetting"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$DynamicEvaluation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$DynamicEvaluation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PerformanceGoal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PerformanceGoal"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "Tutorials",
 CellID->558945376],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->296799979],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->98147542],

Cell[TextData[ButtonBox["Dynamic Interactivity Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicInteractivityLanguage"]], "MoreAbout",
 CellID->327012651],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "MoreAbout",
 CellID->119479297],

Cell[TextData[ButtonBox["Gamepad & Device Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GamepadAndDeviceInterface"]], "MoreAbout",
 CellID->154730914],

Cell[TextData[ButtonBox["Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InteractiveManipulation"]], "MoreAbout",
 CellID->702229690],

Cell[TextData[ButtonBox["Low-Level Interface Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelInterfaceControl"]], "MoreAbout",
 CellID->78248321]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ControlActive - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 34, 52.5653402}", "context" -> "System`", 
    "keywords" -> {
     "active state", "preview state", "high speed manipulation", 
      "high performance manipulation", "fast manipulation"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ControlActive[act, norm] evaluates to act if a control that affects act \
is actively being used, and to norm otherwise.", 
    "synonyms" -> {"control active"}, "title" -> "ControlActive", "type" -> 
    "Symbol", "uri" -> "ref/ControlActive"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9105, 268, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->114702987]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 33914, 1016}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3577, 78, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4200, 105, 1578, 37, 70, "ObjectNameGrid"],
Cell[5781, 144, 828, 26, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6646, 175, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7124, 192, 361, 9, 70, "Notes",
 CellID->1067943069],
Cell[7488, 203, 418, 14, 70, "Notes",
 CellID->42329896],
Cell[7909, 219, 599, 22, 70, "Notes",
 CellID->110610217],
Cell[8511, 243, 557, 20, 70, "Notes",
 CellID->32459985]
}, Closed]],
Cell[CellGroupData[{
Cell[9105, 268, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->114702987],
Cell[CellGroupData[{
Cell[9490, 282, 148, 5, 70, "ExampleSection",
 CellID->176134988],
Cell[9641, 289, 93, 1, 70, "ExampleText",
 CellID->1102451213],
Cell[CellGroupData[{
Cell[9759, 294, 316, 10, 28, "Input",
 CellID->285816152],
Cell[10078, 306, 1496, 32, 124, "Output",
 CellID->179883715]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11623, 344, 219, 7, 70, "ExampleSection",
 CellID->47515935],
Cell[11845, 353, 232, 8, 70, "ExampleText",
 CellID->384599319],
Cell[CellGroupData[{
Cell[12102, 365, 489, 15, 70, "Input",
 CellID->5655741],
Cell[12594, 382, 1573, 34, 70, "Output",
 CellID->355722685]
}, Open  ]],
Cell[14182, 419, 125, 3, 70, "ExampleDelimiter",
 CellID->140714464],
Cell[14310, 424, 261, 8, 70, "ExampleText",
 CellID->559667288],
Cell[CellGroupData[{
Cell[14596, 436, 542, 17, 70, "Input",
 CellID->38587585],
Cell[15141, 455, 1569, 34, 70, "Output",
 CellID->41938419]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16759, 495, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[16989, 504, 112, 3, 70, "ExampleText",
 CellID->218665680],
Cell[CellGroupData[{
Cell[17126, 511, 544, 17, 70, "Input",
 CellID->71107994],
Cell[17673, 530, 1649, 37, 70, "Output",
 CellID->753555389]
}, Open  ]],
Cell[19337, 570, 124, 3, 70, "ExampleDelimiter",
 CellID->16765034],
Cell[19464, 575, 92, 1, 70, "ExampleText",
 CellID->802587775],
Cell[CellGroupData[{
Cell[19581, 580, 598, 18, 70, "Input",
 CellID->93645220],
Cell[20182, 600, 1601, 34, 70, "Output",
 CellID->7187439]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21832, 640, 236, 7, 70, "ExampleSection",
 CellID->47960046],
Cell[22071, 649, 382, 13, 70, "ExampleText",
 CellID->837063723],
Cell[CellGroupData[{
Cell[22478, 666, 316, 10, 70, "Input",
 CellID->195675894],
Cell[22797, 678, 1522, 33, 70, "Output",
 CellID->92472409]
}, Open  ]],
Cell[CellGroupData[{
Cell[24356, 716, 644, 22, 70, "Input",
 CellID->452645954],
Cell[25003, 740, 347, 9, 70, "Output",
 CellID->1786646021]
}, Open  ]],
Cell[25365, 752, 125, 3, 70, "ExampleDelimiter",
 CellID->550439757],
Cell[25493, 757, 380, 13, 70, "ExampleText",
 CellID->211229140],
Cell[CellGroupData[{
Cell[25898, 774, 801, 23, 70, "Input",
 CellID->942113296],
Cell[26702, 799, 1906, 39, 70, "Output",
 CellID->76853857]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28669, 845, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[28988, 856, 1513, 53, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[30538, 914, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[30859, 925, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[31021, 930, 173, 3, 70, "Tutorials",
 CellID->558945376],
Cell[31197, 935, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[31382, 943, 319, 9, 70, "MoreAboutSection",
 CellID->296799979],
Cell[31704, 954, 140, 3, 70, "MoreAbout",
 CellID->98147542],
Cell[31847, 959, 170, 3, 70, "MoreAbout",
 CellID->327012651],
Cell[32020, 964, 153, 3, 70, "MoreAbout",
 CellID->119479297],
Cell[32176, 969, 163, 3, 70, "MoreAbout",
 CellID->154730914],
Cell[32342, 974, 159, 3, 70, "MoreAbout",
 CellID->702229690],
Cell[32504, 979, 162, 3, 70, "MoreAbout",
 CellID->78248321]
}, Open  ]],
Cell[32681, 985, 27, 0, 70, "History"],
Cell[32711, 987, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

