(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21565,        690]
NotebookOptionsPosition[     17969,        574]
NotebookOutlinePosition[     19450,        614]
CellTagsIndexPosition[     19365,        609]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ControlPlacement" :> 
          Documentation`HelpLookup["paclet:ref/ControlPlacement"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"ControlPlacement\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interactive Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/InteractiveManipulation"], 
          "Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Interactive Manipulation\"\>", 
       2->"\<\"Options & Styling for Interactive Manipulation\"\>"}, \
"\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ControlType", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ControlType",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ControlType"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Manipulate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
     " and related functions that specifies what type of controls should be \
displayed."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5469]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Possible control types are: ",
 Cell[BoxData[
  ButtonBox["Animator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Animator"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Checkbox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Checkbox"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ColorSetter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSetter"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["ColorSlider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ColorSlider"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["InputField",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputField"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Manipulator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulator"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PopupMenu",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupMenu"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RadioButton",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadioButton"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["RadioButtonBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RadioButtonBar"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Setter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Setter"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["SetterBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetterBar"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Slider2D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider2D"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["VerticalSlider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/VerticalSlider"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " can also be used. "
}], "Notes",
 CellID->13037],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"ControlType", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " specifies that no controls should explicitly be displayed."
}], "Notes",
 CellID->3925],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["ControlType",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlType"]], "InlineFormula"],
 " option can be specified separately for each variable in a ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->135678563],

Cell[TextData[{
 "Arbitrary controls can be set up in ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " by giving control specifications of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["func", "TI"]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->113660742]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->361913162],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->188455151],

Cell[TextData[{
 "Default ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " control:"
}], "ExampleText",
 CellID->273916055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1649680864],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$33876$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$33876$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`x$$, 
      "Specifications" :> {{$CellContext`x$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{249., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->88166650]
}, Open  ]],

Cell[TextData[{
 "Override with a ",
 Cell[BoxData[
  ButtonBox["Slider2D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider2D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1635739992],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"x", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "1", ",", 
     RowBox[{"ControlType", "\[Rule]", "Slider2D"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24914831],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`x$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`x$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`x$33901$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`x$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`x$$, $CellContext`x$33901$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`x$$, 
      "Specifications" :> {{$CellContext`x$$, 0, 1, ControlType -> Slider2D}},
       "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{118., {77., 82.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[2]=",
 CellID->316504740]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->625466731],

Cell[TextData[{
 "Default ",
 Cell[BoxData[
  ButtonBox["ControllerManipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControllerManipulate"]], "InlineFormula"],
 " control:"
}], "ExampleText",
 CellID->757797049],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ControllerManipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1716975833],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$33923$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$33923$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {
       AppearanceElements -> {}, ControlType -> None, Paneled -> False, 
        SynchronousUpdating -> True}, "DefaultOptions" :> {}],
     ImageSizeCache->{27., {15., 20.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->151404590]
}, Open  ]],

Cell[TextData[{
 "Add a ",
 Cell[BoxData[
  ButtonBox["Slider",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Slider"]], "InlineFormula"],
 " linked to the same variable:"
}], "ExampleText",
 CellID->676079890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ControllerManipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1", ",", 
     RowBox[{"ControlType", "\[Rule]", "Slider"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->790468076],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {7., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$33945$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$33945$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1, ControlType -> Slider}}, 
      "Options" :> {
       AppearanceElements -> {}, ControlType -> None, Paneled -> False, 
        SynchronousUpdating -> True}, "DefaultOptions" :> {}],
     ImageSizeCache->{213., {31.5, 36.5}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[2]=",
 CellID->326079456]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17953],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ControlPlacement",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControlPlacement"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->28392]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->41488446],

Cell[TextData[ButtonBox["Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/InteractiveManipulation"]], "MoreAbout",
 CellID->427404361],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->390947608]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ControlType - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 35, 1.9562056}", "context" -> "System`", 
    "keywords" -> {
     "animator", "checkbox", "colorsetter", "colorslider", "inputfield", 
      "manipulator", "popupmenu", "radiobutton", "radiobuttonbar", "setter", 
      "setterbar", "slider", "slider2D", "verticalslider"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ControlType is an option for Manipulate and related functions that \
specifies what type of controls should be displayed.", 
    "synonyms" -> {"control type"}, "title" -> "ControlType", "type" -> 
    "Symbol", "uri" -> "ref/ControlType"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7894, 267, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->361913162]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19222, 602}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1439, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2062, 63, 1576, 37, 70, "ObjectNameGrid"],
Cell[3641, 102, 636, 19, 70, "Usage",
 CellID->5469]
}, Open  ]],
Cell[CellGroupData[{
Cell[4314, 126, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4792, 143, 2030, 78, 70, "Notes",
 CellID->13037],
Cell[6825, 223, 254, 8, 70, "Notes",
 CellID->3925],
Cell[7082, 233, 373, 13, 70, "Notes",
 CellID->135678563],
Cell[7458, 248, 399, 14, 70, "Notes",
 CellID->113660742]
}, Closed]],
Cell[CellGroupData[{
Cell[7894, 267, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->361913162],
Cell[CellGroupData[{
Cell[8279, 281, 148, 5, 70, "ExampleSection",
 CellID->188455151],
Cell[8430, 288, 203, 8, 70, "ExampleText",
 CellID->273916055],
Cell[CellGroupData[{
Cell[8658, 300, 189, 6, 28, "Input",
 CellID->1649680864],
Cell[8850, 308, 1467, 32, 124, "Output",
 CellID->88166650]
}, Open  ]],
Cell[10332, 343, 200, 8, 70, "ExampleText",
 CellID->1635739992],
Cell[CellGroupData[{
Cell[10557, 355, 249, 8, 70, "Input",
 CellID->24914831],
Cell[10809, 365, 1493, 32, 70, "Output",
 CellID->316504740]
}, Open  ]],
Cell[12317, 400, 125, 3, 70, "ExampleDelimiter",
 CellID->625466731],
Cell[12445, 405, 223, 8, 70, "ExampleText",
 CellID->757797049],
Cell[CellGroupData[{
Cell[12693, 417, 199, 6, 70, "Input",
 CellID->1716975833],
Cell[12895, 425, 1576, 34, 70, "Output",
 CellID->151404590]
}, Open  ]],
Cell[14486, 462, 213, 8, 70, "ExampleText",
 CellID->676079890],
Cell[CellGroupData[{
Cell[14724, 474, 257, 8, 70, "Input",
 CellID->790468076],
Cell[14984, 484, 1602, 34, 70, "Output",
 CellID->326079456]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16647, 525, 311, 9, 70, "SeeAlsoSection",
 CellID->17953],
Cell[16961, 536, 212, 6, 70, "SeeAlso",
 CellID->28392]
}, Open  ]],
Cell[CellGroupData[{
Cell[17210, 547, 318, 9, 70, "MoreAboutSection",
 CellID->41488446],
Cell[17531, 558, 159, 3, 70, "MoreAbout",
 CellID->427404361],
Cell[17693, 563, 204, 4, 70, "MoreAbout",
 CellID->390947608]
}, Open  ]],
Cell[17912, 570, 27, 0, 70, "History"],
Cell[17942, 572, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

