(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14706,        458]
NotebookOptionsPosition[     11820,        369]
NotebookOutlinePosition[     13357,        410]
CellTagsIndexPosition[     13272,        405]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ControllerManipulate" :> 
          Documentation`HelpLookup["paclet:ref/ControllerManipulate"], 
          "ControllerState" :> 
          Documentation`HelpLookup["paclet:ref/ControllerState"], 
          "ControllerInformation" :> 
          Documentation`HelpLookup["paclet:ref/ControllerInformation"], 
          "ControllerLinking" :> 
          Documentation`HelpLookup["paclet:ref/ControllerLinking"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ControllerManipulate\"\>", 
       2->"\<\"ControllerState\"\>", 3->"\<\"ControllerInformation\"\>", 
       4->"\<\"ControllerLinking\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Gamepad & Device Interface" :> 
          Documentation`HelpLookup["paclet:guide/GamepadAndDeviceInterface"], 
          "Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Gamepad & Device Interface\"\>", 
       2->"\<\"Options & Styling for Interactive Manipulation\"\>"}, \
"\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ControllerMethod", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["ControllerMethod",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ControllerMethod"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Manipulate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Graphics3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Plot3D",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plot3D"]], "InlineFormula"],
     " and related functions that specifies the default way that controls on \
an external controller device should apply."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"ControllerMethod", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", if no explicit associations are specified, successive variables in ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ControllerManipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControllerManipulate"]], "InlineFormula"],
 " will be associated with successive suitable controls on the controller \
device. If any explicit associations are specified, no automatic associations \
are used."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"ControllerMethod", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 ", no automatic associations are ever made."
}], "Notes",
 CellID->59905847],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"ControllerMethod", "->", "\"\<Absolute\>\""}]], "InlineFormula"],
 ", the default associations used for controller specifications such as ",
 Cell[BoxData["\"\<X\>\""], "InlineFormula"],
 " is absolute, rather than relative with an option for absolute."
}], "Notes",
 CellID->298815146]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->612120361],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->20413985],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  ButtonBox["ControllerMethod",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControllerMethod"]], "InlineFormula"],
 " to ",
 Cell[BoxData["\"\<Absolute\>\""], "InlineFormula"],
 " forces absolute associations, rather than relative:"
}], "ExampleText",
 CellID->703626333],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{"u", ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ControllerMethod", "\[Rule]", "\"\<Absolute\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1294642811],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0.49999237048905165`, Typeset`show$$ =
     True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}}, Typeset`size$$ = {56., {0., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$33105$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$33105$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`u$$, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}}, 
      "Options" :> {ControllerMethod -> "Absolute"}, "DefaultOptions" :> {}],
     ImageSizeCache->{250., {48., 53.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->138441177]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControllerManipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerManipulate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControllerState",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerState"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControllerInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerInformation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControllerLinking",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerLinking"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->202939680]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->850870564],

Cell[TextData[ButtonBox["Gamepad & Device Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GamepadAndDeviceInterface"]], "MoreAbout",
 CellID->10040372],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->50201602]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ControllerMethod - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 34, 57.9404778}", "context" -> "System`", 
    "keywords" -> {
     "controller method", "absolute controller input", 
      "relative controller input", "position controller input", 
      "speed controller input", "integrating controller input"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ControllerMethod is an option for Manipulate, Graphics3D, Plot3D and \
related functions that specifies the default way that controls on an external \
controller device should apply.", "synonyms" -> {"controller method"}, 
    "title" -> "ControllerMethod", "type" -> "Symbol", "uri" -> 
    "ref/ControllerMethod"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6951, 207, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->612120361]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13129, 398}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1876, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2499, 70, 1581, 37, 70, "ObjectNameGrid"],
Cell[4083, 109, 977, 29, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[5097, 143, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5575, 160, 739, 21, 70, "Notes",
 CellID->1067943069],
Cell[6317, 183, 256, 9, 70, "Notes",
 CellID->59905847],
Cell[6576, 194, 338, 8, 70, "Notes",
 CellID->298815146]
}, Closed]],
Cell[CellGroupData[{
Cell[6951, 207, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->612120361],
Cell[CellGroupData[{
Cell[7336, 221, 147, 5, 70, "ExampleSection",
 CellID->20413985],
Cell[7486, 228, 320, 10, 70, "ExampleText",
 CellID->703626333],
Cell[CellGroupData[{
Cell[7831, 242, 262, 8, 28, "Input",
 CellID->1294642811],
Cell[8096, 252, 1518, 32, 124, "Output",
 CellID->138441177]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9675, 291, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[9994, 302, 1027, 35, 70, "SeeAlso",
 CellID->202939680]
}, Open  ]],
Cell[CellGroupData[{
Cell[11058, 342, 319, 9, 70, "MoreAboutSection",
 CellID->850870564],
Cell[11380, 353, 162, 3, 70, "MoreAbout",
 CellID->10040372],
Cell[11545, 358, 203, 4, 70, "MoreAbout",
 CellID->50201602]
}, Open  ]],
Cell[11763, 365, 27, 0, 70, "History"],
Cell[11793, 367, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

