(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     90225,       2347]
NotebookOptionsPosition[     82961,       2113]
NotebookOutlinePosition[     84891,       2159]
CellTagsIndexPosition[     84805,       2154]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Advanced Dynamic Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedDynamicFunctionality"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>", 
       2->"\<\"Advanced Dynamic Functionality\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ControllerInformation" :> 
          Documentation`HelpLookup["paclet:ref/ControllerInformation"], 
          "MousePosition" :> 
          Documentation`HelpLookup["paclet:ref/MousePosition"], 
          "ControllerManipulate" :> 
          Documentation`HelpLookup["paclet:ref/ControllerManipulate"], 
          "Manipulate" :> Documentation`HelpLookup["paclet:ref/Manipulate"], 
          "CurrentValue" :> 
          Documentation`HelpLookup["paclet:ref/CurrentValue"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ControllerInformation\"\>", 
       2->"\<\"MousePosition\"\>", 3->"\<\"ControllerManipulate\"\>", 
       4->"\<\"Manipulate\"\>", 
       5->"\<\"CurrentValue\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Click-Interactive Panels" :> 
          Documentation`HelpLookup["paclet:guide/ClickInteractivePanels"], 
          "Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"], 
          "External Operations" :> 
          Documentation`HelpLookup["paclet:guide/ExternalOperations"], 
          "Gamepad & Device Interface" :> 
          Documentation`HelpLookup["paclet:guide/GamepadAndDeviceInterface"], 
          "Low-Level Interface Control" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelInterfaceControl"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Click-Interactive Panels\"\>", 
       2->"\<\"Control Objects\"\>", 
       3->"\<\"Custom Interface Construction\"\>", 
       4->"\<\"Dynamic Visualization\"\>", 5->"\<\"External Operations\"\>", 
       6->"\<\"Gamepad & Device Interface\"\>", 
       7->"\<\"Low-Level Interface Control\"\>", 
       8->"\<\"Stand-Alone Interfaces\"\>", 
       9->"\<\"New in 6.0: Dynamic Interactivity\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ControllerState", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ControllerState",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ControllerState"], "[", "\"\<\!\(\*
StyleBox[\"c\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the state of the control ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " for the first connected controller device on which it is supported."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ControllerState",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ControllerState"], "[", 
       RowBox[{"{", 
        RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the states of several controls."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ControllerState",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ControllerState"], "[", 
       RowBox[{
        StyleBox["id", "TI"], ",", "\"\<\!\(\*
StyleBox[\"c\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the state of control ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " for controller devices with the specified identifier."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ControllerState",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ControllerState"], "[", 
       RowBox[{
        StyleBox["id", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the states of several controls for several \
controller devices."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dynamic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dynamic"], "[", 
   RowBox[{"ControllerState", "[", 
    StyleBox["\[Ellipsis]", "TR"], "]"}], "]"}]], "InlineFormula"],
 " gives continually updated current controller states."
}], "Notes",
 CellID->641683685],

Cell["Typical control names include:", "Notes",
 CellID->26221548],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData["\"\<X\>\""], "InlineFormula"],
     " or ",
     Cell[BoxData["\"\<X1\>\""], "InlineFormula"]
    }], "TableText"], 
    StyleBox["x", "TI"], Cell[TextData[{
     "primary ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     " value "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData["\"\<Y\>\""], "InlineFormula"],
     " or ",
     Cell[BoxData["\"\<Y1\>\""], "InlineFormula"]
    }], "TableText"], 
    StyleBox["y", "TI"], Cell[TextData[{
     "primary ",
     Cell[BoxData[
      FormBox["y", TraditionalForm]], "InlineMath"],
     " value"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData["\"\<Z\>\""], "InlineFormula"],
     " or ",
     Cell[BoxData["\"\<Z1\>\""], "InlineFormula"]
    }], "TableText"], 
    StyleBox["z", "TI"], Cell[TextData[{
     "primary ",
     Cell[BoxData[
      FormBox["z", TraditionalForm]], "InlineMath"],
     " value"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData["\"\<XY\>\""], "InlineFormula"],
     " or ",
     Cell[BoxData["\"\<XY1\>\""], "InlineFormula"]
    }], "TableText"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}], Cell[
    "primary 2-axis controller value", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData["\"\<XYZ\>\""], "InlineFormula"],
     " or ",
     Cell[BoxData["\"\<XYZ1\>\""], "InlineFormula"]
    }], "TableText"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"], ",", 
      StyleBox["z", "TI"]}], "}"}], Cell[
    "primary 3-axis controller value", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData["\"\<X2\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<Y2\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<XY2\>\""], "InlineFormula"],
     ",",
     " etc."
    }], "TableText"], Cell[TextData[{
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
     ", etc."
    }], "TableText"], Cell[
    "values from a secondary controller", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData["\"\<B1\>\""], "InlineFormula"],
     ", ",
     Cell[BoxData["\"\<B2\>\""], "InlineFormula"],
     ", etc."
    }], "TableText"], Cell[TextData[{
     Cell[BoxData[
      SubscriptBox[
       StyleBox["b", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["b", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", etc."
    }], "TableText"], Cell["button states", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True}}}},
 CellID->8762],

Cell["The following special control names are also possible:", "Notes",
 CellID->76409094],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Axes\>\"", Cell[
    "a list of all supported axis-like controls", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Buttons\>\"", Cell[
    "a list of all supported button-like controls", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Controls\>\"", Cell[
    "a list of all supported controls", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Hardware\>\"", Cell[
    "information on the controller device hardware", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Mapping\>\"", Cell[TextData[{
     "rules for ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " mappings of controls"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Rules\>\"", Cell[
    "rules for the settings of all controls", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->71814548],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ControllerState",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControllerState"]], "InlineFormula"],
 " always gives absolute instantaneous control states; it does not give \
relative or cyclic control states of the type available in ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->96650439],

Cell[TextData[{
 "If no explicit controller identifier ",
 Cell[BoxData[
  StyleBox["id", "TI"]], "InlineFormula"],
 " is given, the controller used will be the first one found on the list \
specified by the option ",
 Cell[BoxData[
  ButtonBox["ControllerPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControllerPath"]], "InlineFormula"],
 ", that supports all the controls ",
 Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"c\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
 " requested."
}], "Notes",
 CellID->610349524],

Cell["Identifiers for controllers can be the following:", "Notes",
 CellID->449310905],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", Cell[TextData[{
     "device name from ",
     Cell[BoxData[
      ButtonBox["ControllerInformation",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ControllerInformation"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"class\", \"TI\"]\)\>\"", Cell[
    "device class specifier", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["n", "TI"], Cell[TextData[{
     "raw device index from ",
     Cell[BoxData[
      ButtonBox["ControllerInformation",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ControllerInformation"]], "InlineFormula"],
     " "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "all devices supporting the requested controls", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->490303522],

Cell["Possible device class identifiers include:", "Notes",
 CellID->1067943069],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Gamepad\>\"", Cell[
    "controller typically including two analog controls", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Joystick\>\"", Cell[
    "controller typically including one primary analog control", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Detachable\>\"", Cell[
    "controller not built into a computer", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<BuiltIn\>\"", Cell[
    "controller built into a computer", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->126565940],

Cell[TextData[{
 "If a requested control value is not available, ",
 Cell[BoxData[
  ButtonBox["ControllerState",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControllerState"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " for that value."
}], "Notes",
 CellID->522435299]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->299232556],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->322614352],

Cell["Check the state of button 1:", "ExampleText",
 CellID->3845282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"ControllerState", "[", "\"\<B1\>\"", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->570121157],

Cell[BoxData[
 DynamicBox[ToBoxes[
   ControllerState["B1"], StandardForm],
  ImageSizeCache->{49., {1., 8.}}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->221890184]
}, Open  ]],

Cell["Check multiple values at once:", "ExampleText",
 CellID->99544732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"ControllerState", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<XY\>\"", ",", "\"\<B1\>\""}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->240841765],

Cell[BoxData[
 DynamicBox[ToBoxes[
   ControllerState[{"XY", "B1"}], StandardForm],
  ImageSizeCache->{123.1875, {2., 8.}}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20438237]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["\<\
Acquire a list of all button controls supported by the device:\
\>", "ExampleText",
 CellID->344696869],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ControllerState", "[", "\"\<Buttons\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44507777],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Button 1\"\>", ",", "\<\"Button 2\"\>", 
   ",", "\<\"Button 3\"\>", ",", "\<\"Button 4\"\>", ",", "\<\"Button 5\"\>", 
   ",", "\<\"Button 6\"\>", ",", "\<\"Button 7\"\>", ",", "\<\"Button 8\"\>", 
   ",", "\<\"Button 9\"\>", ",", "\<\"Button 10\"\>", 
   ",", "\<\"Button 11\"\>", ",", "\<\"Button 12\"\>"}], "}"}]], "Output",
 ImageSize->{431, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->660978475]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->465196369],

Cell["Specify which controller type should be used:", "ExampleText",
 CellID->4728582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"ControllerState", "[", 
   RowBox[{"\"\<Gamepad\>\"", ",", "\"\<B1\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->833698400],

Cell[BoxData[
 DynamicBox[ToBoxes[
   ControllerState["Gamepad", "B1"], StandardForm],
  ImageSizeCache->{49., {1., 8.}}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->314275043]
}, Open  ]],

Cell[TextData[{
 "If no device of that type is attached, ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " is returned:"
}], "ExampleText",
 CellID->351955541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"ControllerState", "[", 
   RowBox[{"\"\<Joystick\>\"", ",", "\"\<B1\>\""}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->112247595],

Cell[BoxData[
 DynamicBox[ToBoxes[
   ControllerState["Joystick", "B1"], StandardForm],
  ImageSizeCache->{49., {1., 8.}}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->666526040]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->307120427],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ControllerPath",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->45221608],

Cell["\<\
If multiple controllers are attached, specify the order of control sampling: \
\
\>", "ExampleText",
 CellID->101001943],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"ControllerState", "[", 
   RowBox[{"\"\<B1\>\"", ",", 
    RowBox[{"ControllerPath", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<Gamepad\>\"", ",", "\"\<Joystick\>\""}], "}"}]}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->242597882],

Cell[BoxData[
 DynamicBox[ToBoxes[
   ControllerState["B1", ControllerPath -> {"Gamepad", "Joystick"}], 
   StandardForm],
  ImageSizeCache->{49., {1., 8.}}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85259343]
}, Open  ]],

Cell["By default, controls are sampled in the following order:", "ExampleText",
 CellID->418353900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"ControllerState", "[", 
   RowBox[{"\"\<B1\>\"", ",", 
    RowBox[{"ControllerPath", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Gamepad\>\"", ",", "\"\<Joystick\>\"", ",", "\"\<Detachable\>\"", 
       ",", "1"}], "}"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->930658553],

Cell[BoxData[
 DynamicBox[ToBoxes[
   ControllerState[
   "B1", ControllerPath -> {"Gamepad", "Joystick", "Detachable", 1}], 
   StandardForm],
  ImageSizeCache->{49., {1., 8.}}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->584858712]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell["\<\
Manipulate controls are automatically linked to a controller:\
\>", "ExampleText",
 CellID->786442960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"If", "[", 
       RowBox[{"c", ",", "Red", ",", "Blue"}], "]"}], ",", 
      RowBox[{"First", "[", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"a", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"b", "*", "x"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "0", ",", 
           RowBox[{"2", "Pi"}]}], "}"}], ",", 
         RowBox[{"PlotRange", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "2"}], ",", "2"}], "}"}]}], ",", 
         RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], "]"}]}], "}"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->769692394],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`a$$ = 1, $CellContext`b$$ = 
    1, $CellContext`c$$ = True, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`a$$], 1, 3}, {
      Hold[$CellContext`b$$], 1, 4}, {
      Hold[$CellContext`c$$], {True, False}}}, Typeset`size$$ = {
    180., {29., 34.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`a$122288$$ = 
    0, $CellContext`b$122289$$ = 0, $CellContext`c$122290$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`a$$ = 1, $CellContext`b$$ = 
        1, $CellContext`c$$ = True}, "ControllerVariables" :> {
        Hold[$CellContext`a$$, $CellContext`a$122288$$, 0], 
        Hold[$CellContext`b$$, $CellContext`b$122289$$, 0], 
        Hold[$CellContext`c$$, $CellContext`c$122290$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Graphics[{
         If[$CellContext`c$$, Red, Blue], 
         First[
          
          Plot[$CellContext`a$$ 
           Sin[$CellContext`b$$ $CellContext`x], {$CellContext`x, 0, 2 Pi}, 
           PlotRange -> {-2, 2}, PlotStyle -> Thick]]}], 
      "Specifications" :> {{$CellContext`a$$, 1, 3}, {$CellContext`b$$, 1, 
         4}, {$CellContext`c$$, {True, False}}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {96., 101.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{254, 199},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23882074]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->829724538],

Cell[TextData[{
 "Bind ",
 Cell[BoxData["x"], "InlineFormula"],
 " to the X controller when your selection contains the output:"
}], "ExampleText",
 CellID->123198445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"CurrentValue", "[", "\"\<SelectionOver\>\"", "]"}], ",", 
     RowBox[{"x", "=", 
      RowBox[{"ControllerState", "[", "\"\<X\>\"", "]"}]}]}], "]"}], ";", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->160025826],

Cell[BoxData[
 DynamicBox[ToBoxes[If[
     CurrentValue["SelectionOver"], $CellContext`x = 
     ControllerState["X"]]; $CellContext`x, StandardForm],
  ImageSizeCache->{49., {1., 8.}}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->150313582]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->39090699],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ControllerInformation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ControllerInformation"]], "InlineFormula"],
 " can be used to find a device name:"
}], "ExampleText",
 CellID->141468524],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ControllerInformation", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48122216],

Cell[BoxData[
 InterpretationBox[
  PanelBox[
   StyleBox[
    TagBox[GridBox[{
       {
        DynamicModuleBox[{System`InfoDump`open$$ = False}, 
         PaneSelectorBox[{False->
          RowBox[{
           OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
           StyleBox[
            InterpretationBox[
             RowBox[{
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"], 
                 StandardForm],
                ImageSizeCache->{97., {1., 9.}}],
               StripOnInput->False,
               DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
              "\[InvisibleSpace]", "\<\"1\"\>", 
              "\[InvisibleSpace]", "\<\": \"\>", 
              "\[InvisibleSpace]", "\<\"Logitech Dual Action\"\>"}],
             Row[{
               Style[
                Dynamic[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"]], 
                DynamicUpdating -> True], " ", "1", ": ", 
               "Logitech Dual Action"}]],
            StripOnInput->False,
            FontWeight->Bold]}], True->
          TagBox[GridBox[{
             {
              RowBox[{
               OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
               StyleBox[
                InterpretationBox[
                 RowBox[{
                  StyleBox[
                   DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"], 
                    StandardForm]],
                   StripOnInput->False,
                   DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
                  "\[InvisibleSpace]", "\<\"1\"\>", 
                  "\[InvisibleSpace]", "\<\": \"\>", 
                  "\[InvisibleSpace]", "\<\"Logitech Dual Action\"\>"}],
                 Row[{
                   Style[
                    Dynamic[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"]], 
                    DynamicUpdating -> True], " ", "1", ": ", 
                   "Logitech Dual Action"}]],
                StripOnInput->False,
                FontWeight->Bold]}]},
             {
              TagBox[GridBox[{
                 {"\<\"Manufacturer\"\>", 
                  InterpretationBox[
                   
                   RowBox[{"\<\"Logitech\"\>", 
                    "\[InvisibleSpace]", "\<\" (\"\>", "\[InvisibleSpace]", 
                    "1133", "\[InvisibleSpace]", "\<\")\"\>"}],
                   Row[{"Logitech", " (", 1133, ")"}]]},
                 {"\<\"Raw Product Name\"\>", "\<\"\\\"Logitech Dual Action\\\
\"\"\>"},
                 {"\<\"Raw Product ID\"\>", "49686"},
                 {"\<\"Device Type\"\>", "\<\"Mac OS X Human Interface Device\
\"\>"},
                 {"\<\"Raw Controller Type\"\>", "\<\"Joystick\"\>"},
                 {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Mathematica\\\\\\\"\\\", \
\\\"IT\\\"]\\) Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"35", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"35", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"X\"\>", "0.0039215686274509665`"},
                    {"\<\"Y\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Z\"\>", "0.0039215686274509665`"},
                    {"\<\"X1\"\>", "0.0039215686274509665`"},
                    {"\<\"Y1\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Z1\"\>", "0.0039215686274509665`"},
                    {"\<\"X2\"\>", "0.0039215686274509665`"},
                    {"\<\"Y2\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"X3\"\>", "0.`"},
                    {"\<\"Y3\"\>", "0.`"},
                    {"\<\"X4\"\>", "0"},
                    {"\<\"Y4\"\>", "0"},
                    {"\<\"X5\"\>", "0"},
                    {"\<\"Y5\"\>", "0"},
                    {"\<\"B1\"\>", "False"},
                    {"\<\"B2\"\>", "False"},
                    {"\<\"B3\"\>", "False"},
                    {"\<\"B4\"\>", "False"},
                    {"\<\"B5\"\>", "False"},
                    {"\<\"B6\"\>", "False"},
                    {"\<\"B7\"\>", "False"},
                    {"\<\"B8\"\>", "False"},
                    {"\<\"B9\"\>", "False"},
                    {"\<\"B10\"\>", "False"},
                    {"\<\"B11\"\>", "False"},
                    {"\<\"B12\"\>", "False"},
                    {"\<\"BLB\"\>", "False"},
                    {"\<\"BRB\"\>", "False"},
                    {"\<\"JB\"\>", "False"},
                    {"\<\"JB1\"\>", "False"},
                    {"\<\"JB2\"\>", "False"},
                    {"\<\"Select Button\"\>", "False"},
                    {"\<\"Start Button\"\>", "False"},
                    {"\<\"TLB\"\>", "False"},
                    {"\<\"TRB\"\>", "False"}
                    },
                    ColumnsEqual->False,
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    
                    Transpose[{{"X", "Y", "Z", "X1", "Y1", "Z1", "X2", "Y2", 
                    "X3", "Y3", "X4", "Y4", "X5", "Y5", "B1", "B2", "B3", 
                    "B4", "B5", "B6", "B7", "B8", "B9", "B10", "B11", "B12", 
                    "BLB", "BRB", "JB", "JB1", "JB2", "Select Button", 
                    "Start Button", "TLB", "TRB"}, 
                    ControllerState[
                    1, {"X", "Y", "Z", "X1", "Y1", "Z1", "X2", "Y2", "X3", 
                    "Y3", "X4", "Y4", "X5", "Y5", "B1", "B2", "B3", "B4", 
                    "B5", "B6", "B7", "B8", "B9", "B10", "B11", "B12", "BLB", 
                    "BRB", "JB", "JB1", "JB2", "Select Button", 
                    "Start Button", "TLB", "TRB"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}},
                    RowsEqual->False],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]},
                 {"\<\"Raw Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"18", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"18", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"X Axis\"\>", "0.0039215686274509665`"},
                    {"\<\"Y Axis\"\>", "0.0039215686274509665`"},
                    {"\<\"Z Axis\"\>", "0.0039215686274509665`"},
                    {"\<\"Z Rotation\"\>", "0.0039215686274509665`"},
                    {"\<\"Hatswitch X Axis\"\>", "0.`"},
                    {"\<\"Hatswitch Y Axis\"\>", "0.`"},
                    {"\<\"Button 1\"\>", "False"},
                    {"\<\"Button 2\"\>", "False"},
                    {"\<\"Button 3\"\>", "False"},
                    {"\<\"Button 4\"\>", "False"},
                    {"\<\"Button 5\"\>", "False"},
                    {"\<\"Button 6\"\>", "False"},
                    {"\<\"Button 7\"\>", "False"},
                    {"\<\"Button 8\"\>", "False"},
                    {"\<\"Button 9\"\>", "False"},
                    {"\<\"Button 10\"\>", "False"},
                    {"\<\"Button 11\"\>", "False"},
                    {"\<\"Button 12\"\>", "False"}
                    },
                    ColumnsEqual->False,
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    
                    Transpose[{{"X Axis", "Y Axis", "Z Axis", "Z Rotation", 
                    "Hatswitch X Axis", "Hatswitch Y Axis", "Button 1", 
                    "Button 2", "Button 3", "Button 4", "Button 5", 
                    "Button 6", "Button 7", "Button 8", "Button 9", 
                    "Button 10", "Button 11", "Button 12"}, 
                    ControllerState[
                    1, {"X Axis", "Y Axis", "Z Axis", "Z Rotation", 
                    "Hatswitch X Axis", "Hatswitch Y Axis", "Button 1", 
                    "Button 2", "Button 3", "Button 4", "Button 5", 
                    "Button 6", "Button 7", "Button 8", "Button 9", 
                    "Button 10", "Button 11", "Button 12"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}},
                    RowsEqual->False],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]}
                },
                GridBoxAlignment->{"Columns" -> {Right, Left}},
                GridBoxDividers->{"Rows" -> {{False}, 
                    GrayLevel[0, 0.2]}},
                GridBoxItemSize->{"Columns" -> {17, 39.992700729927}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.28], {
                    Offset[0.84]}, 
                    Offset[0.28]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.48]}, 
                    Offset[0.2]}}],
               "Grid"]}
            },
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            RowsEqual->False],
           "Column"]}, Dynamic[System`InfoDump`open$$],
          ImageSize->Automatic],
         DynamicModuleValues:>{}]},
       {
        DynamicModuleBox[{System`InfoDump`open$$ = False}, 
         PaneSelectorBox[{False->
          RowBox[{
           OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
           StyleBox[
            InterpretationBox[
             RowBox[{
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"], 
                 StandardForm],
                ImageSizeCache->{97., {1., 9.}}],
               StripOnInput->False,
               DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
              "\[InvisibleSpace]", "\<\"2\"\>", 
              "\[InvisibleSpace]", "\<\": \"\>", 
              "\[InvisibleSpace]", "\<\"Apple IR\"\>"}],
             Row[{
               Style[
                Dynamic[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"]], 
                DynamicUpdating -> True], " ", "2", ": ", "Apple IR"}]],
            StripOnInput->False,
            FontWeight->Bold]}], True->
          TagBox[GridBox[{
             {
              RowBox[{
               OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
               StyleBox[
                InterpretationBox[
                 RowBox[{
                  StyleBox[
                   DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"], 
                    StandardForm]],
                   StripOnInput->False,
                   DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
                  "\[InvisibleSpace]", "\<\"2\"\>", 
                  "\[InvisibleSpace]", "\<\": \"\>", 
                  "\[InvisibleSpace]", "\<\"Apple IR\"\>"}],
                 Row[{
                   Style[
                    Dynamic[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"]], 
                    DynamicUpdating -> True], " ", "2", ": ", "Apple IR"}]],
                StripOnInput->False,
                FontWeight->Bold]}]},
             {
              TagBox[GridBox[{
                 {"\<\"Manufacturer\"\>", 
                  InterpretationBox[
                   
                   RowBox[{"\<\"Apple Computer, Inc.\"\>", 
                    "\[InvisibleSpace]", "\<\" (\"\>", "\[InvisibleSpace]", 
                    "1452", "\[InvisibleSpace]", "\<\")\"\>"}],
                   Row[{"Apple Computer, Inc.", " (", 1452, ")"}]]},
                 {"\<\"Raw Product Name\"\>", "\<\"\\\"Apple IR\\\"\"\>"},
                 {"\<\"Raw Product ID\"\>", "33344"},
                 {"\<\"Device Type\"\>", "\<\"Mac OS X Human Interface Device\
\"\>"},
                 {"\<\"Raw Controller Type\"\>", "\<\"External \
Controller\"\>"},
                 {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Mathematica\\\\\\\"\\\", \
\\\"IT\\\"]\\) Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"5", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"5", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"B\"\>", "False"},
                    {"\<\"B1\"\>", "False"},
                    {"\<\"B2\"\>", "False"},
                    {"\<\"Button 1\"\>", "False"},
                    {"\<\"Button 2\"\>", "False"}
                    },
                    ColumnsEqual->False,
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    Transpose[{{"B", "B1", "B2", "Button 1", "Button 2"}, 
                    ControllerState[
                    2, {"B", "B1", "B2", "Button 1", "Button 2"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}},
                    RowsEqual->False],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]},
                 {"\<\"Raw Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"17", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"17", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"Reserved Button\"\>", "False"},
                    {"\<\"Rewind Button\"\>", "False"},
                    {"\<\"FastForward Button\"\>", "False"},
                    {"\<\"Menu Button\"\>", "False"},
                    {"\<\"Reserved Button 2\"\>", "False"},
                    {"\<\"SystemAppMenu Button\"\>", "False"},
                    {"\<\"SystemMenu Button\"\>", "False"},
                    {"\<\"SystemMenuRight Button\"\>", "False"},
                    {"\<\"SystemMenuLeft Button\"\>", "False"},
                    {"\<\"Reserved Button 3\"\>", "False"},
                    {"\<\"SystemMenuUp Button\"\>", "False"},
                    {"\<\"SystemMenuDown Button\"\>", "False"},
                    {"\<\"Unknown:65281:65535 Button\"\>", "False"},
                    {"\<\"Unknown:65281:32 Button\"\>", "False"},
                    {"\<\"Unknown:65281:33 Button\"\>", "False"},
                    {"\<\"Unknown:65281:34 Button\"\>", "False"},
                    {"\<\"Unknown:65281:35 Button\"\>", "False"}
                    },
                    ColumnsEqual->False,
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    
                    Transpose[{{"Reserved Button", "Rewind Button", 
                    "FastForward Button", "Menu Button", "Reserved Button 2", 
                    "SystemAppMenu Button", "SystemMenu Button", 
                    "SystemMenuRight Button", "SystemMenuLeft Button", 
                    "Reserved Button 3", "SystemMenuUp Button", 
                    "SystemMenuDown Button", "Unknown:65281:65535 Button", 
                    "Unknown:65281:32 Button", "Unknown:65281:33 Button", 
                    "Unknown:65281:34 Button", "Unknown:65281:35 Button"}, 
                    ControllerState[
                    2, {"Reserved Button", "Rewind Button", 
                    "FastForward Button", "Menu Button", "Reserved Button 2", 
                    "SystemAppMenu Button", "SystemMenu Button", 
                    "SystemMenuRight Button", "SystemMenuLeft Button", 
                    "Reserved Button 3", "SystemMenuUp Button", 
                    "SystemMenuDown Button", "Unknown:65281:65535 Button", 
                    "Unknown:65281:32 Button", "Unknown:65281:33 Button", 
                    "Unknown:65281:34 Button", "Unknown:65281:35 Button"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}},
                    RowsEqual->False],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]}
                },
                GridBoxAlignment->{"Columns" -> {Right, Left}},
                GridBoxDividers->{"Rows" -> {{False}, 
                    GrayLevel[0, 0.2]}},
                GridBoxItemSize->{"Columns" -> {17, 39.992700729927}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.28], {
                    Offset[0.84]}, 
                    Offset[0.28]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.48]}, 
                    Offset[0.2]}}],
               "Grid"]}
            },
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            RowsEqual->False],
           "Column"]}, Dynamic[System`InfoDump`open$$],
          ImageSize->Automatic],
         DynamicModuleValues:>{}]},
       {
        DynamicModuleBox[{System`InfoDump`open$$ = False}, 
         PaneSelectorBox[{False->
          RowBox[{
           OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
           StyleBox[
            InterpretationBox[
             RowBox[{
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"], 
                 StandardForm],
                ImageSizeCache->{97., {1., 9.}}],
               StripOnInput->False,
               DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
              "\[InvisibleSpace]", "\<\"3\"\>", 
              "\[InvisibleSpace]", "\<\": \"\>", 
              "\[InvisibleSpace]", "\<\"Sudden Motion Sensor\"\>"}],
             Row[{
               Style[
                Dynamic[
                 FEPrivate`FrontEndResource[
                 "SystemInformationDialog", "ControllerDeviceText"]], 
                DynamicUpdating -> True], " ", "3", ": ", 
               "Sudden Motion Sensor"}]],
            StripOnInput->False,
            FontWeight->Bold]}], True->
          TagBox[GridBox[{
             {
              RowBox[{
               OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
               StyleBox[
                InterpretationBox[
                 RowBox[{
                  StyleBox[
                   DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"], 
                    StandardForm]],
                   StripOnInput->False,
                   DynamicUpdating->True], "\[InvisibleSpace]", "\<\" \"\>", 
                  "\[InvisibleSpace]", "\<\"3\"\>", 
                  "\[InvisibleSpace]", "\<\": \"\>", 
                  "\[InvisibleSpace]", "\<\"Sudden Motion Sensor\"\>"}],
                 Row[{
                   Style[
                    Dynamic[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControllerDeviceText"]], 
                    DynamicUpdating -> True], " ", "3", ": ", 
                   "Sudden Motion Sensor"}]],
                StripOnInput->False,
                FontWeight->Bold]}]},
             {
              TagBox[GridBox[{
                 {"\<\"Manufacturer\"\>", 
                  InterpretationBox[
                   
                   RowBox[{"\<\"Apple Computer, Inc.\"\>", 
                    "\[InvisibleSpace]", "\<\" (\"\>", "\[InvisibleSpace]", 
                    "1452", "\[InvisibleSpace]", "\<\")\"\>"}],
                   Row[{"Apple Computer, Inc.", " (", 1452, ")"}]]},
                 {"\<\"Raw Product Name\"\>", "\<\"\\\"Sudden Motion Sensor\\\
\"\"\>"},
                 {"\<\"Raw Product ID\"\>", "0"},
                 {"\<\"Device Type\"\>", "\<\"Mac OS X Motion Sensor Device\"\
\>"},
                 {"\<\"Raw Controller Type\"\>", "\<\"Internal \
Controller\"\>"},
                 {"\<\"\\!\\(\\*StyleBox[\\\"\\\\\\\"Mathematica\\\\\\\"\\\", \
\\\"IT\\\"]\\) Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"7", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"7", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"X\"\>", "0.0980392156862746`"},
                    {"\<\"Y\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Z\"\>", 
                    RowBox[{"-", "0.11372549019607847`"}]},
                    {"\<\"X1\"\>", "0.0980392156862746`"},
                    {"\<\"Y1\"\>", 
                    RowBox[{"-", "0.0039215686274509665`"}]},
                    {"\<\"Z1\"\>", 
                    RowBox[{"-", "0.11372549019607847`"}]},
                    {"\<\"X2\"\>", 
                    RowBox[{"-", "0.11372549019607847`"}]}
                    },
                    ColumnsEqual->False,
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    Transpose[{{"X", "Y", "Z", "X1", "Y1", "Z1", "X2"}, 
                    ControllerState[
                    3, {"X", "Y", "Z", "X1", "Y1", "Z1", "X2"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}},
                    RowsEqual->False],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]},
                 {"\<\"Raw Controls\"\>", 
                  DynamicModuleBox[{System`InfoDump`open$$ = False}, 
                   PaneSelectorBox[{False->
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"3", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}], True->
                    TagBox[GridBox[{
                    {
                    RowBox[{
                    OpenerBox[Dynamic[System`InfoDump`open$$]], "   ", 
                    StyleBox[
                    RowBox[{"3", "\[InvisibleSpace]", 
                    StyleBox[
                    DynamicBox[ToBoxes[
                    FEPrivate`FrontEndResource[
                    "SystemInformationDialog", "ControlsSmallText"], 
                    StandardForm]],
                    StripOnInput->False,
                    DynamicUpdating->True]}], "IT",
                    StripOnInput->False]}]},
                    {
                    DynamicModuleBox[{System`InfoDump`dynamic$$ = True}, 
                    TagBox[GridBox[{
                    {
                    PaneSelectorBox[{False->
                    TagBox[GridBox[{
                    {"\<\"X Axis\"\>", "0.0980392156862746`"},
                    {"\<\"Y Axis\"\>", "0.0039215686274509665`"},
                    {"\<\"Z Axis\"\>", 
                    RowBox[{"-", "0.11372549019607847`"}]}
                    },
                    ColumnsEqual->False,
                    
                    GridBoxAlignment->{
                    "Columns" -> {Right, {Left}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Grid"], True->
                    DynamicBox[ToBoxes[
                    Grid[
                    Transpose[{{"X Axis", "Y Axis", "Z Axis"}, 
                    ControllerState[3, {"X Axis", "Y Axis", "Z Axis"}]}], 
                    ColumnAlignments -> {Right, Left}], StandardForm]]}, 
                    Dynamic[System`InfoDump`dynamic$$]]},
                    {
                    InterpretationBox[
                    RowBox[{
                    CheckboxBox[Dynamic[System`InfoDump`dynamic$$],
                    ImageSize->Small], 
                    "\[InvisibleSpace]", "\<\" Show Dynamic Values\"\>"}],
                    Row[{
                    Checkbox[
                    Dynamic[System`InfoDump`dynamic$$], ImageSize -> Small], 
                    " Show Dynamic Values"}]]}
                    },
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
                    RowsEqual->False],
                    "Column"],
                    DynamicModuleValues:>{}]}
                    },
                    BaselinePosition->{Baseline, {1, 1}},
                    ColumnsEqual->False,
                    GridBoxAlignment->{"Columns" -> {{Left}}},
                    
                    GridBoxItemSize->{
                    "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, 
                    "Rows" -> {{1.}}, "RowsIndexed" -> {}},
                    RowsEqual->False],
                    "Column"]}, Dynamic[System`InfoDump`open$$],
                    BaselinePosition->Baseline,
                    FrameMargins->0,
                    ImageSize->Automatic],
                   DynamicModuleValues:>{}]}
                },
                GridBoxAlignment->{"Columns" -> {Right, Left}},
                GridBoxDividers->{"Rows" -> {{False}, 
                    GrayLevel[0, 0.2]}},
                GridBoxItemSize->{"Columns" -> {17, 39.992700729927}},
                GridBoxSpacings->{"Columns" -> {
                    Offset[0.28], {
                    Offset[0.84]}, 
                    Offset[0.28]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.48]}, 
                    Offset[0.2]}}],
               "Grid"]}
            },
            ColumnsEqual->False,
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            RowsEqual->False],
           "Column"]}, Dynamic[System`InfoDump`open$$],
          ImageSize->Automatic],
         DynamicModuleValues:>{}]}
      },
      ColumnsEqual->False,
      GridBoxAlignment->{"Columns" -> {{Left}}},
      GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
      RowsEqual->False],
     "Column"], "DialogStyle",
    Editable->False,
    Deletable->False,
    StripOnInput->False,
    ShowStringCharacters->False,
    TooltipBoxOptions->{ActionDelay->Automatic}],
   DefaultBaseStyle->"DialogStyle",
   FrameMargins->5],
  ControllerInformationData[{
   "Logitech Dual Action" -> {{
      "X Axis" -> 0.0039215686274509665`, "Y Axis" -> 0.0039215686274509665`, 
       "Z Axis" -> 0.0039215686274509665`, "Z Rotation" -> 
       0.0039215686274509665`, "Hatswitch X Axis" -> 0., "Hatswitch Y Axis" -> 
       0.}, {"Button 1" -> False, "Button 2" -> False, "Button 3" -> False, 
       "Button 4" -> False, "Button 5" -> False, "Button 6" -> False, 
       "Button 7" -> False, "Button 8" -> False, "Button 9" -> False, 
       "Button 10" -> False, "Button 11" -> False, "Button 12" -> False}, {
      "Manufacturer Name" -> "Logitech", "Manufacturer ID" -> 1133, 
       "Product Name" -> "Logitech Dual Action", "Product ID" -> 49686, 
       "Controller Type" -> "Joystick", "Device Type" -> 
       "Mac OS X Human Interface Device", "HID Usage Page" -> 
       "GenericDesktop", "HID Usage" -> "Joystick"}, {
      "X2" -> "Z Axis", "Y2" -> -"Z Rotation", "JB" -> "Button 11", "JB1" -> 
       "Button 11", "JB2" -> "Button 12", "JB3" -> None, "TLB" -> "Button 5", 
       "TRB" -> "Button 6", "BLB" -> "Button 7", "BRB" -> "Button 8", 
       "Select Button" -> "Button 9", "Start Button" -> "Button 10", "X" -> 
       "X Axis", "Y" -> -"Y Axis", "Z" -> "Z Axis", "X1" -> "X Axis", 
       "Y1" -> -"Y Axis", "Z1" -> "Z Axis", "X2" -> "Z Rotation", 
       "Y2" -> -"Slider", "Z2" -> None, "X3" -> "Hatswitch X Axis", 
       "Y3" -> -"Hatswitch Y Axis", "Z3" -> None, "X4" -> 
       Switch[{"Button 1", "Button 3"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y4" -> 
       Switch[{"Button 2", "Button 4"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "X5" -> 
       Switch[{"Button 7", "Button 5"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y5" -> 
       Switch[{"Button 8", "Button 6"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "B1" -> 
       "Button 1", "B2" -> "Button 2", "B3" -> "Button 3", "B4" -> "Button 4",
        "B5" -> "Button 5", "B6" -> "Button 6", "B7" -> "Button 7", "B8" -> 
       "Button 8", "B9" -> "Button 9", "B10" -> "Button 10", "B11" -> 
       "Button 11", "B12" -> "Button 12", "DefaultAbsolute" -> False}}, 
    "Apple IR" -> {{}, {
      "Reserved Button" -> False, "Rewind Button" -> False, 
       "FastForward Button" -> False, "Menu Button" -> False, 
       "Reserved Button 2" -> False, "SystemAppMenu Button" -> False, 
       "SystemMenu Button" -> False, "SystemMenuRight Button" -> False, 
       "SystemMenuLeft Button" -> False, "Reserved Button 3" -> False, 
       "SystemMenuUp Button" -> False, "SystemMenuDown Button" -> False, 
       "Unknown:65281:65535 Button" -> False, "Unknown:65281:32 Button" -> 
       False, "Unknown:65281:33 Button" -> False, "Unknown:65281:34 Button" -> 
       False, "Unknown:65281:35 Button" -> False}, {
      "Manufacturer Name" -> "Apple Computer, Inc.", "Manufacturer ID" -> 
       1452, "Product Name" -> "Apple IR", "Product ID" -> 33344, 
       "Controller Type" -> "External Controller", "Device Type" -> 
       "Mac OS X Human Interface Device", "HID Usage Page" -> "Consumer", 
       "HID Usage" -> "ConsumerControl"}, {
      "B" -> "Rewind Button", "B1" -> "Rewind Button", "Button 1" -> 
       "Rewind Button", "B2" -> "FastForward Button", "Button 2" -> 
       "FastForward Button", "X" -> "X Axis", "Y" -> -"Y Axis", "Z" -> 
       "Z Axis", "X1" -> "X Axis", "Y1" -> -"Y Axis", "Z1" -> "Z Axis", "X2" -> 
       "Z Rotation", "Y2" -> -"Slider", "Z2" -> None, "X3" -> 
       "Hatswitch X Axis", "Y3" -> -"Hatswitch Y Axis", "Z3" -> None, "X4" -> 
       Switch[{"Button 1", "Button 3"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y4" -> 
       Switch[{"Button 2", "Button 4"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "X5" -> 
       Switch[{"Button 7", "Button 5"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y5" -> 
       Switch[{"Button 8", "Button 6"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "B1" -> 
       "Button 1", "B2" -> "Button 2", "B3" -> "Button 3", "B4" -> "Button 4",
        "B5" -> "Button 5", "B6" -> "Button 6", "B7" -> "Button 7", "B8" -> 
       "Button 8", "B9" -> "Button 9", "B10" -> "Button 10", "B11" -> 
       "Button 11", "B12" -> "Button 12", "DefaultAbsolute" -> False}}, 
    "Sudden Motion Sensor" -> {{
      "X Axis" -> 0.0980392156862746, "Y Axis" -> 0.0039215686274509665`, 
       "Z Axis" -> -0.11372549019607847`}, {}, {
      "Manufacturer Name" -> "Apple Computer, Inc.", "Manufacturer ID" -> 
       1452, "Product Name" -> "Sudden Motion Sensor", "Product ID" -> 0, 
       "Controller Type" -> "Internal Controller", "Device Type" -> 
       "Mac OS X Motion Sensor Device"}, {
      "X2" -> "Z Axis", "Y2" -> -"Z Rotation", "JB" -> "Button 11", "JB1" -> 
       "Button 11", "JB2" -> "Button 12", "JB3" -> None, "TLB" -> "Button 5", 
       "TRB" -> "Button 6", "BLB" -> "Button 7", "BRB" -> "Button 8", "X" -> 
       "X Axis", "Y" -> -"Y Axis", "Z" -> "Z Axis", "X1" -> "X Axis", 
       "Y1" -> -"Y Axis", "Z1" -> "Z Axis", "X2" -> "Z Rotation", 
       "Y2" -> -"Slider", "Z2" -> None, "X3" -> "Hatswitch X Axis", 
       "Y3" -> -"Hatswitch Y Axis", "Z3" -> None, "X4" -> 
       Switch[{"Button 1", "Button 3"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y4" -> 
       Switch[{"Button 2", "Button 4"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "X5" -> 
       Switch[{"Button 7", "Button 5"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "Y5" -> 
       Switch[{"Button 8", "Button 6"}, {False, False}, 0, {
         True, False}, -1, {False, True}, 1, {True, True}, 0.00001], "B1" -> 
       "Button 1", "B2" -> "Button 2", "B3" -> "Button 3", "B4" -> "Button 4",
        "B5" -> "Button 5", "B6" -> "Button 6", "B7" -> "Button 7", "B8" -> 
       "Button 8", "B9" -> "Button 9", "B10" -> "Button 10", "B11" -> 
       "Button 11", "B12" -> "Button 12", "DefaultAbsolute" -> 
       False}}}]]], "Output",
 ImageSize->{277, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->912718068]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"ControllerState", "[", 
   RowBox[{"\"\<Logitech Dual Action\>\"", ",", "\"\<B1\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->649660755],

Cell[BoxData[
 DynamicBox[ToBoxes[
   ControllerState["Logitech Dual Action", "B1"], StandardForm],
  ImageSizeCache->{49., {1., 8.}}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->136539083]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControllerInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerInformation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MousePosition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MousePosition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControllerManipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerManipulate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "Tutorials",
 CellID->558945376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->127763525],

Cell[TextData[ButtonBox["Click-Interactive Panels",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ClickInteractivePanels"]], "MoreAbout",
 CellID->116159080],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->234972187],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->97296192],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "MoreAbout",
 CellID->119747199],

Cell[TextData[ButtonBox["External Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExternalOperations"]], "MoreAbout",
 CellID->394578792],

Cell[TextData[ButtonBox["Gamepad & Device Interface",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GamepadAndDeviceInterface"]], "MoreAbout",
 CellID->38925068],

Cell[TextData[ButtonBox["Low-Level Interface Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelInterfaceControl"]], "MoreAbout",
 CellID->916414344],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->238933789],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->290893103]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ControllerState - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 35, 0.1592846}", "context" -> "System`", 
    "keywords" -> {
     "human input device", "human interface device", "HID", "gamepad", 
      "joystick", "force feedback device", "3d mouse", "space ball", 
      "space mouse", "space navigator", "space pilot", "space explorer", 
      "space traveler", "input controller"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ControllerState[\"c\"] gives the state of the control c for the first \
connected controller device on which it is supported. \
ControllerState[{\"SubscriptBox[ c, 1]\", \"SubscriptBox[ c, 2]\", ...}] \
gives the states of several controls. ControllerState[id, \" c\"] gives the \
state of control c for controller devices with the specified identifier. \
ControllerState[id, {\"SubscriptBox[ c, 1]\", \"SubscriptBox[ c, 2]\", ...}] \
gives the states of several controls for several controller devices.", 
    "synonyms" -> {"controller state"}, "title" -> "ControllerState", "type" -> 
    "Symbol", "uri" -> "ref/ControllerState"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[17463, 493, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->299232556]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 84661, 2147}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3814, 83, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4437, 110, 1580, 37, 70, "ObjectNameGrid"],
Cell[6020, 149, 2326, 65, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[8383, 219, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8861, 236, 327, 10, 70, "Notes",
 CellID->641683685],
Cell[9191, 248, 66, 1, 70, "Notes",
 CellID->26221548],
Cell[9260, 251, 3347, 103, 70, "3ColumnTableMod",
 CellID->8762],
Cell[12610, 356, 90, 1, 70, "Notes",
 CellID->76409094],
Cell[12703, 359, 1126, 23, 70, "2ColumnTableMod",
 CellID->71814548],
Cell[13832, 384, 445, 13, 70, "Notes",
 CellID->96650439],
Cell[14280, 399, 551, 16, 70, "Notes",
 CellID->610349524],
Cell[14834, 417, 86, 1, 70, "Notes",
 CellID->449310905],
Cell[14923, 420, 1223, 32, 70, "2ColumnTableMod",
 CellID->490303522],
Cell[16149, 454, 80, 1, 70, "Notes",
 CellID->1067943069],
Cell[16232, 457, 807, 16, 70, "2ColumnTableMod",
 CellID->126565940],
Cell[17042, 475, 384, 13, 70, "Notes",
 CellID->522435299]
}, Closed]],
Cell[CellGroupData[{
Cell[17463, 493, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->299232556],
Cell[CellGroupData[{
Cell[17848, 507, 148, 5, 70, "ExampleSection",
 CellID->322614352],
Cell[17999, 514, 69, 1, 70, "ExampleText",
 CellID->3845282],
Cell[CellGroupData[{
Cell[18093, 519, 154, 4, 28, "Input",
 CellID->570121157],
Cell[18250, 525, 252, 8, 36, "Output",
 CellID->221890184]
}, Open  ]],
Cell[18517, 536, 72, 1, 70, "ExampleText",
 CellID->99544732],
Cell[CellGroupData[{
Cell[18614, 541, 212, 6, 28, "Input",
 CellID->240841765],
Cell[18829, 549, 265, 8, 36, "Output",
 CellID->20438237]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19143, 563, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[19367, 572, 113, 3, 70, "ExampleText",
 CellID->344696869],
Cell[CellGroupData[{
Cell[19505, 579, 124, 3, 70, "Input",
 CellID->44507777],
Cell[19632, 584, 503, 11, 54, "Output",
 CellID->660978475]
}, Open  ]],
Cell[20150, 598, 125, 3, 70, "ExampleDelimiter",
 CellID->465196369],
Cell[20278, 603, 86, 1, 70, "ExampleText",
 CellID->4728582],
Cell[CellGroupData[{
Cell[20389, 608, 192, 5, 70, "Input",
 CellID->833698400],
Cell[20584, 615, 263, 8, 70, "Output",
 CellID->314275043]
}, Open  ]],
Cell[20862, 626, 232, 8, 70, "ExampleText",
 CellID->351955541],
Cell[CellGroupData[{
Cell[21119, 638, 193, 5, 70, "Input",
 CellID->112247595],
Cell[21315, 645, 264, 8, 70, "Output",
 CellID->666526040]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21628, 659, 222, 7, 70, "ExampleSection",
 CellID->307120427],
Cell[CellGroupData[{
Cell[21875, 670, 234, 7, 70, "ExampleSubsection",
 CellID->45221608],
Cell[22112, 679, 130, 4, 70, "ExampleText",
 CellID->101001943],
Cell[CellGroupData[{
Cell[22267, 687, 307, 9, 70, "Input",
 CellID->242597882],
Cell[22577, 698, 298, 9, 70, "Output",
 CellID->85259343]
}, Open  ]],
Cell[22890, 710, 99, 1, 70, "ExampleText",
 CellID->418353900],
Cell[CellGroupData[{
Cell[23014, 715, 356, 10, 70, "Input",
 CellID->930658553],
Cell[23373, 727, 320, 10, 70, "Output",
 CellID->584858712]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[23754, 744, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[23995, 753, 112, 3, 70, "ExampleText",
 CellID->786442960],
Cell[CellGroupData[{
Cell[24132, 760, 1047, 32, 70, "Input",
 CellID->769692394],
Cell[25182, 794, 2252, 49, 70, "Output",
 CellID->23882074]
}, Open  ]],
Cell[27449, 846, 125, 3, 70, "ExampleDelimiter",
 CellID->829724538],
Cell[27577, 851, 167, 5, 70, "ExampleText",
 CellID->123198445],
Cell[CellGroupData[{
Cell[27769, 860, 327, 10, 70, "Input",
 CellID->160025826],
Cell[28099, 872, 327, 9, 70, "Output",
 CellID->150313582]
}, Open  ]],
Cell[28441, 884, 124, 3, 70, "ExampleDelimiter",
 CellID->39090699],
Cell[28568, 889, 238, 7, 70, "ExampleText",
 CellID->141468524],
Cell[CellGroupData[{
Cell[28831, 900, 111, 3, 70, "Input",
 CellID->48122216],
Cell[28945, 905, 49283, 1035, 70, "Output",
 CellID->912718068]
}, Open  ]],
Cell[CellGroupData[{
Cell[78265, 1945, 208, 6, 70, "Input",
 CellID->649660755],
Cell[78476, 1953, 276, 8, 70, "Output",
 CellID->136539083]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[78813, 1968, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[79132, 1979, 1262, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[80431, 2028, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[80752, 2039, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[80914, 2044, 173, 3, 70, "Tutorials",
 CellID->558945376]
}, Open  ]],
Cell[CellGroupData[{
Cell[81124, 2052, 319, 9, 70, "MoreAboutSection",
 CellID->127763525],
Cell[81446, 2063, 158, 3, 70, "MoreAbout",
 CellID->116159080],
Cell[81607, 2068, 141, 3, 70, "MoreAbout",
 CellID->234972187],
Cell[81751, 2073, 167, 3, 70, "MoreAbout",
 CellID->97296192],
Cell[81921, 2078, 153, 3, 70, "MoreAbout",
 CellID->119747199],
Cell[82077, 2083, 149, 3, 70, "MoreAbout",
 CellID->394578792],
Cell[82229, 2088, 162, 3, 70, "MoreAbout",
 CellID->38925068],
Cell[82394, 2093, 163, 3, 70, "MoreAbout",
 CellID->916414344],
Cell[82560, 2098, 154, 3, 70, "MoreAbout",
 CellID->238933789],
Cell[82717, 2103, 172, 3, 70, "MoreAbout",
 CellID->290893103]
}, Open  ]],
Cell[82904, 2109, 27, 0, 70, "History"],
Cell[82934, 2111, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

