(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     55422,       1511]
NotebookOptionsPosition[     49629,       1308]
NotebookOutlinePosition[     50978,       1346]
CellTagsIndexPosition[     50892,       1341]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer and Number\[Hyphen]Theoretical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Integer and Number\[Hyphen]Theoretical Functions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Divisible" :> Documentation`HelpLookup["paclet:ref/Divisible"],
           "GCD" :> Documentation`HelpLookup["paclet:ref/GCD"], "Mod" :> 
          Documentation`HelpLookup["paclet:ref/Mod"], "PrimeQ" :> 
          Documentation`HelpLookup["paclet:ref/PrimeQ"], "EulerPhi" :> 
          Documentation`HelpLookup["paclet:ref/EulerPhi"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Divisible\"\>", 2->"\<\"GCD\"\>", 
       3->"\<\"Mod\"\>", 4->"\<\"PrimeQ\"\>", 
       5->"\<\"EulerPhi\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Integer Functions" :> 
          Documentation`HelpLookup["paclet:guide/IntegerFunctions"], 
          "Number Theoretic Functions" :> 
          Documentation`HelpLookup["paclet:guide/NumberTheoreticFunctions"], 
          "Prime Numbers" :> 
          Documentation`HelpLookup["paclet:guide/PrimeNumbers"], 
          "Testing Expressions" :> 
          Documentation`HelpLookup["paclet:guide/TestingExpressions"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"], 
          "New in 6.0: Number Theory & Integer Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Integer Functions\"\>", 
       2->"\<\"Number Theoretic Functions\"\>", 3->"\<\"Prime Numbers\"\>", 
       4->"\<\"Testing Expressions\"\>", 
       5->"\<\"New in 6.0: Mathematics & Algorithms\"\>", 
       6->"\<\"New in 6.0: Number Theory & Integer Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CoprimeQ", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CoprimeQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CoprimeQ"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     " are relatively prime, and yields ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CoprimeQ",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CoprimeQ"], "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["n", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if all pairs of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " are relatively prime, and yields ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->15127]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["n", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be Gaussian integers."
}], "Notes",
 CellID->27577]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->277542497],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->830201449],

Cell["8, 9 and 11 are relatively prime:", "ExampleText",
 CellID->16430],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoprimeQ", "[", 
  RowBox[{"8", ",", "9", ",", "11"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5831],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21295]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15623],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CoprimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoprimeQ"]], "InlineFormula"],
 " works with numbers of any size:"
}], "ExampleText",
 CellID->17922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoprimeQ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"2", "^", "100"}], "-", "1"}], ",", 
   RowBox[{
    RowBox[{"3", "^", "100"}], "-", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2927],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28029]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30211],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CoprimeQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CoprimeQ"]], "InlineFormula"],
 " threads itself element-wise over lists:"
}], "ExampleText",
 CellID->16211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoprimeQ", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", "6"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11754],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False", ",", "False", ",", "False", ",", "True"}], 
  "}"}]], "Output",
 ImageSize->{224, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26880]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12253],

Cell["Gaussian integers:", "ExampleText",
 CellID->3293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CoprimeQ", "[", 
  RowBox[{
   RowBox[{"2", "+", "I"}], ",", 
   RowBox[{"3", "+", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21321],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20785]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10555],

Cell["Plot pairs of numbers that are relatively prime:", "ExampleText",
 CellID->24671],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Boole", "[", 
   RowBox[{"Array", "[", 
    RowBox[{"CoprimeQ", ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "50"}], "}"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9270],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJy9VNsVwyAI5XaTrpBRMkIW6P5/PVVTxaBwTU/VKA8fcCE8j9d+PERkK59A
AEjpIUryMWIpJ+OzUA3Fj2uHKS09bfgYl2mf9e41pJwPiUC6aYwPlAThN9CS
dMzrUCyUqhlkLIJYdZuW8uq0XzJ0yMZWbbeF9cIGp8NQb3BvJLEy1ZfM6TOt
19IviIWQw5mwzEYsFkpToxqdflSvpmLHC6uWNImkoRsI9T3x2u74oEW3sfIF
oyhP+onGF7dYbedyd2DyhFnHKkwuxPzOPxiNR2NibFms7dS0lFf/wYppb6MP
BcY=
   "], {{0, 0}, {50, 50}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None},
  ImageMargins->0.]], "Output",
 ImageSize->{236, 232},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{232., Automatic}},
 CellLabel->"Out[1]=",
 CellID->7452]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9375],

Cell["\<\
Find the fraction of pairs of the first 100 numbers that are relatively \
prime:\
\>", "ExampleText",
 CellID->14631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Total", "[", 
    RowBox[{
     RowBox[{"Boole", "[", 
      RowBox[{"Array", "[", 
       RowBox[{"CoprimeQ", ",", 
        RowBox[{"{", 
         RowBox[{"100", ",", "100"}], "}"}]}], "]"}], "]"}], ",", "2"}], 
    "]"}], "/", 
   RowBox[{"10", "^", "4"}]}], "//", "N"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13640],

Cell[BoxData["0.6087`"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8934]
}, Open  ]],

Cell[TextData[{
 "The result is close to ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", 
    TagBox[
     RowBox[{"\[Zeta]", "(", 
      TagBox["2",
       Zeta,
       Editable->True,
       Selectable->True], ")"}],
     InterpretTemplate[
      Function[BoxForm`e$, 
       Zeta[BoxForm`e$]]],
     Editable->False,
     Selectable->False]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->18040],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"1", "/", 
   RowBox[{"Zeta", "[", "2", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7986],

Cell[BoxData["0.6079271018540267`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28834]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->652418984],

Cell["\<\
Find the first 2x2 block of white squares in the array of coprime numbers:\
\>", "ExampleText",
 CellID->94614059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Position", "[", 
  RowBox[{
   RowBox[{"Partition", "[", 
    RowBox[{
     RowBox[{"Boole", "[", 
      RowBox[{"Array", "[", 
       RowBox[{"CoprimeQ", ",", 
        RowBox[{"{", 
         RowBox[{"30", ",", "30"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->340028943],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"14", ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"20", ",", "14"}], "}"}]}], "}"}]], "Output",
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->307690188]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12796],

Cell["Plot which triples of numbers are relatively prime:", "ExampleText",
 CellID->10312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Cuboid", "/@", 
   RowBox[{"Position", "[", 
    RowBox[{
     RowBox[{"Array", "[", 
      RowBox[{"CoprimeQ", ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "20", ",", "20"}], "}"}]}], "]"}], ",", "True"}], 
    "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7262],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{277, 301},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{277., Automatic}},
 CellLabel->"Out[1]=",
 CellID->106961663]
}, Open  ]],

Cell["2D slices:", "ExampleText",
 CellID->30731],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ArrayPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Boole", "[", 
        RowBox[{"CoprimeQ", "[", 
         RowBox[{"i", ",", "j", ",", "n"}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "50"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "50"}], "}"}]}], "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23987],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RasterBox[CompressedData["
1:eJy9VNsVwyAI5XaTrpBRMkIW6P5/PVVTxaBwTU/VKA8fcCE8j9d+PERkK59A
AEjpIUryMWIpJ+OzUA3Fj2uHKS09bfgYl2mf9e41pJwPiUC6aYwPlAThN9CS
dMzrUCyUqhlkLIJYdZuW8uq0XzJ0yMZWbbeF9cIGp8NQb3BvJLEy1ZfM6TOt
19IviIWQw5mwzEYsFkpToxqdflSvpmLHC6uWNImkoRsI9T3x2u74oEW3sfIF
oyhP+onGF7dYbedyd2DyhFnHKkwuxPzOPxiNR2NibFms7dS0lFf/wYppb6MP
BcY=
     "], {{0, 0}, {50, 50}}, {0, 1}],
    Frame->Automatic,
    FrameTicks->{None, None},
    ImageSize->Tiny], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJy9ltsNgDAIRcFNXMFRHMEF3P/PxNjWVtryECTSGj5u7gES1+PcjwUAtudF
8QN3pJPzpdXgBqpUIGeoMub7t+rno3D10sDXTa5B8RlnDx/WySp9bXtOUdLO
bn9+YlhR9X816KpGg8fHyqrXX/qm0+BSsrGqHbVk2j21+5jPmlVjvvkajZRr
Sog0K6uPvgdEm4+xAkVTrhGzgxH/DP57HsVKEhdH7QnS
     "], {{0, 0}, {50, 50}}, {0, 1}],
    Frame->Automatic,
    FrameTicks->{None, None},
    ImageSize->Tiny], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJzFlNsRhCAMRZPtZFuwFEuwAfv/21FRAhHCDbgyweERgRwu+S7rvHyIaAqV
eCu0V/nlq53P0m6hwaFbH4SL/N+2zV9HUIpMzoKnalw3Z9ViEexTrKInfuc9
rPTqflaZm4vVcZgLCJ8apaR7boApahSrPl3dOrhY2VqSZt9zGqunIIqKrNJb
NbuDWBXGObJCcomPlSe3G1rK0nsvKzWitsTfh48Vpt3ikctPp4MVV/hIh3dy
e1u+YhVKZdDFCnvn/9PVuNx+Zz/JwAi6
     "], {{0, 0}, {50, 50}}, {0, 1}],
    Frame->Automatic,
    FrameTicks->{None, None},
    ImageSize->Tiny], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJy9ltsNgDAIRcFNXMFRHMEF3P/PxNjWVtryECTSGj5u7gES1+PcjwUAtudF
8QN3pJPzpdXgBqpUIGeoMub7t+rno3D10sDXTa5B8RlnDx/WySp9bXtOUdLO
bn9+YlhR9X816KpGg8fHyqrXX/qm0+BSsrGqHbVk2j21+5jPmlVjvvkajZRr
Sog0K6uPvgdEm4+xAkVTrhGzgxH/DP57HsVKEhdH7QnS
     "], {{0, 0}, {50, 50}}, {0, 1}],
    Frame->Automatic,
    FrameTicks->{None, None},
    ImageSize->Tiny], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJy9VNsRwyAMs7pJV+goHSELdP+/NgSIAYMf3DUJnDEPIdnO8/i8jwcRvXKD
+6Fz1+89P8rDZGY30bDk2pca71HtfpadYugyctnLLAg+YqhO5t3tDWhmHnXx
FE3WCmYM3JafeYLLsSQ2vKbYbCUzKATB59UK3bBXQ8urAPPuppjdnvEQxEEj
TtEKM610DFukmc/PfIExmRUUkivlzt0xc9ZDfgpWJ2/FvPTWvFJqWgqPopDA
jSfSoiSLVpHHFOmW1rZW0CHd9RFgHsjdiSSYktnQCiQJhgEowFwvOvXfrlr8
4mgYddlUl7i1CjAP8PiXVp7uC6q6B9I=
     "], {{0, 0}, {50, 50}}, {0, 1}],
    Frame->Automatic,
    FrameTicks->{None, None},
    ImageSize->Tiny], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJxTTMoPSmJiYGAwgmJGkgEDFINIBqwkI4oIOQC7ufjtG4yAeH8wMiJ8Qxs7
GFHYgw+QFkrkhxWMhSv0KU279ACkhRL10xUu2cEIcLmXkRG3b8ixg/hQGtxh
RUxaomZYEZPzByMgLZQoDStSyvnBB+jVZqB1PqcHIL7NACMB5bsKzA==
     "], {{0, 0}, {50, 50}}, {0, 1}],
    Frame->Automatic,
    FrameTicks->{None, None},
    ImageSize->Tiny]}], "}"}]], "Output",
 ImageSize->{341, 210},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24464]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"ArrayPlot", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Boole", "[", 
        RowBox[{"CoprimeQ", "[", 
         RowBox[{
          RowBox[{"i", "+", 
           RowBox[{"n", " ", "I"}]}], ",", 
          RowBox[{"j", "+", 
           RowBox[{"n", " ", "I"}]}]}], "]"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"i", ",", "50"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", "50"}], "}"}]}], "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "0", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29556],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[RasterBox[CompressedData["
1:eJy9VNsVwyAI5XaTrpBRMkIW6P5/PVVTxaBwTU/VKA8fcCE8j9d+PERkK59A
AEjpIUryMWIpJ+OzUA3Fj2uHKS09bfgYl2mf9e41pJwPiUC6aYwPlAThN9CS
dMzrUCyUqhlkLIJYdZuW8uq0XzJ0yMZWbbeF9cIGp8NQb3BvJLEy1ZfM6TOt
19IviIWQw5mwzEYsFkpToxqdflSvpmLHC6uWNImkoRsI9T3x2u74oEW3sfIF
oyhP+onGF7dYbedyd2DyhFnHKkwuxPzOPxiNR2NibFms7dS0lFf/wYppb6MP
BcY=
     "], {{0, 0}, {50, 50}}, {0, 1}],
    Frame->Automatic,
    FrameTicks->{None, None},
    ImageSize->Tiny], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJy9ldENwyAMRH3dpCt0lI6QBbL/X6WGpGAwuXOqGAXZQQKfX3Cey/peHmb2
Ks9uMNIAU0fZXZiwnQLsnlXeZu27Ps2phm3Sdbh9T4MjX68h9ORS1RmSbEhD
7SaYd+DBMKeqROuADzPM/T7zQNNwmbnfL1iZFCV4kWIuCvkj83ApzZw+4Tbm
bT8ckW5WNQ3ZWn3niG8dlg9EYo6BDuLiX2ROtpZJ5t3/SWGO+J7zOoQ2L46h
kBHpn5rkPZdafJ9nrOA4g2uFvlb39vbT8QGtkwVJ
     "], {{0, 0}, {50, 50}}, {0, 1}],
    Frame->Automatic,
    FrameTicks->{None, None},
    ImageSize->Tiny], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJzNleERwiAMhfPcpCs4iiN0Aff/V08UiATygui1HBwEyKP5LrDt99t+EZHr
qwrCRZ5V8B4lU+4laz2c0gh8KKd5FLYXVSixCmjp/Y1Dw1CfsCpAdyZvZ5sv
mPPNT5jrRXbMYdg+ebAKKVYwvXnMaYWJWP2H+TCnNWlZzbw3VVh6HKA1AilI
k26Zw3ZoDE7KPKawgrmflOOc9u928mqZZc4qhGOFZcztlyP/h+2tyXg4zPsq
oSiltTyHSmOo0E5OMOcTXGsEqOf9bHMACqQFRQ==
     "], {{0, 0}, {50, 50}}, {0, 1}],
    Frame->Automatic,
    FrameTicks->{None, None},
    ImageSize->Tiny], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJzNVNsNwzAI5LpJVugoHSELdP+/RK1DaADncKSofgmwBPZxMM3v1/wQkWfb
+wCpYF3r/k5K+ngorvrcHgqoJKLejjaxLyTPyEf/GPlFGas8Iwhs8pPN3oAV
1Rs0Hgw+7rYaIUULiX37S4vbhJbuXB1mVS3nVV7RKBmsSlU4VIM7f84iKNpp
ckOljtUdVWjYknIJVs052okRJLZrOODg69HdBuOEbFVW3d7b2SPCxHetP+rt
cF1dsfLo5/VoS4scHJfsbTUChVZQQwYZSuW8XmCV9cn29is9kZQW9n0F8Q==

     "], {{0, 0}, {50, 50}}, {0, 1}],
    Frame->Automatic,
    FrameTicks->{None, None},
    ImageSize->Tiny], ",", 
   GraphicsBox[RasterBox[CompressedData["
1:eJzNVcENwyAM9GWTrNBROkIWyP6/VErbmHBgH23VYAU5RmD7zph5We/LZGa3
52c4BLBKiE0cjw3uFLzns+3kbd+pTADNoJtHkU340zy9KXoiTUSaWp6HQ5Xz
YKh0PBDOY02FSs+jCj9jGOIcryj7deBjcxqIrVjrDro8znnWw0U5F3MY9PGf
ex4WAmjnq1nwWOV74t7ag8jrWlahitCP3qhUi/w953mmCedCm09IgZjq4Tv3
vLDBr4JzHtaxhlIaq484H7jn+hu1ASB6BUk=
     "], {{0, 0}, {50, 50}}, {0, 1}],
    Frame->Automatic,
    FrameTicks->{None, None},
    ImageSize->Tiny]}], "}"}]], "Output",
 ImageSize->{563, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20170]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28400],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divisible",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divisible"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PrimeQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PrimeQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EulerPhi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/EulerPhi"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6558]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23817],

Cell[TextData[ButtonBox["Integer and Number\[Hyphen]Theoretical Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/IntegerAndNumberTheoreticalFunctions"]], "Tutorials",
 CellID->28609]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with CoprimeQ",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=CoprimeQ"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->100710654],

Cell[TextData[ButtonBox["Integer Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/IntegerFunctions"]], "MoreAbout",
 CellID->274686205],

Cell[TextData[ButtonBox["Number Theoretic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberTheoreticFunctions"]], "MoreAbout",
 CellID->179083879],

Cell[TextData[ButtonBox["Prime Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrimeNumbers"]], "MoreAbout",
 CellID->139329055],

Cell[TextData[ButtonBox["Testing Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TestingExpressions"]], "MoreAbout",
 CellID->11141055],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->686412711],

Cell[TextData[ButtonBox["New in 6.0: Number Theory & Integer Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60NumberTheoryAndIntegerFunctions"]], "MoreAbout",
 CellID->420016693]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CoprimeQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 35, 6.9875844}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CoprimeQ[n_1, n_2] yields True if n_1 and n_2 are relatively prime, and \
yields False otherwise. CoprimeQ[n_1, n_2, ...] yields True if all pairs of \
the n_i are relatively prime, and yields False otherwise. ", 
    "synonyms" -> {"coprime q"}, "title" -> "CoprimeQ", "type" -> "Symbol", 
    "uri" -> "ref/CoprimeQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8111, 241, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->277542497]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 50749, 1334}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3045, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3668, 95, 1573, 37, 70, "ObjectNameGrid"],
Cell[5244, 134, 2132, 72, 70, "Usage",
 CellID->15127]
}, Open  ]],
Cell[CellGroupData[{
Cell[7413, 211, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7891, 228, 183, 8, 70, "Notes",
 CellID->27577]
}, Closed]],
Cell[CellGroupData[{
Cell[8111, 241, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->277542497],
Cell[CellGroupData[{
Cell[8496, 255, 148, 5, 70, "ExampleSection",
 CellID->830201449],
Cell[8647, 262, 72, 1, 70, "ExampleText",
 CellID->16430],
Cell[CellGroupData[{
Cell[8744, 267, 133, 4, 28, "Input",
 CellID->5831],
Cell[8880, 273, 157, 5, 36, "Output",
 CellID->21295]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9086, 284, 216, 7, 70, "ExampleSection",
 CellID->15623],
Cell[9305, 293, 205, 7, 70, "ExampleText",
 CellID->17922],
Cell[CellGroupData[{
Cell[9535, 304, 224, 8, 70, "Input",
 CellID->2927],
Cell[9762, 314, 158, 5, 36, "Output",
 CellID->28029]
}, Open  ]],
Cell[9935, 322, 121, 3, 70, "ExampleDelimiter",
 CellID->30211],
Cell[10059, 327, 213, 7, 70, "ExampleText",
 CellID->16211],
Cell[CellGroupData[{
Cell[10297, 338, 205, 7, 70, "Input",
 CellID->11754],
Cell[10505, 347, 251, 8, 36, "Output",
 CellID->26880]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10805, 361, 239, 7, 70, "ExampleSection",
 CellID->12253],
Cell[11047, 370, 56, 1, 70, "ExampleText",
 CellID->3293],
Cell[CellGroupData[{
Cell[11128, 375, 171, 6, 70, "Input",
 CellID->21321],
Cell[11302, 383, 157, 5, 36, "Output",
 CellID->20785]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11508, 394, 223, 7, 70, "ExampleSection",
 CellID->10555],
Cell[11734, 403, 87, 1, 70, "ExampleText",
 CellID->24671],
Cell[CellGroupData[{
Cell[11846, 408, 252, 8, 70, "Input",
 CellID->9270],
Cell[12101, 418, 661, 17, 253, "Output",
 CellID->7452]
}, Open  ]],
Cell[12777, 438, 120, 3, 70, "ExampleDelimiter",
 CellID->9375],
Cell[12900, 443, 127, 4, 70, "ExampleText",
 CellID->14631],
Cell[CellGroupData[{
Cell[13052, 451, 369, 13, 70, "Input",
 CellID->13640],
Cell[13424, 466, 159, 5, 36, "Output",
 CellID->8934]
}, Open  ]],
Cell[13598, 474, 422, 18, 70, "ExampleText",
 CellID->18040],
Cell[CellGroupData[{
Cell[14045, 496, 147, 5, 70, "Input",
 CellID->7986],
Cell[14195, 503, 172, 5, 36, "Output",
 CellID->28834]
}, Open  ]],
Cell[14382, 511, 125, 3, 70, "ExampleDelimiter",
 CellID->652418984],
Cell[14510, 516, 124, 3, 70, "ExampleText",
 CellID->94614059],
Cell[CellGroupData[{
Cell[14659, 523, 627, 21, 70, "Input",
 CellID->340028943],
Cell[15289, 546, 306, 11, 36, "Output",
 CellID->307690188]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15644, 563, 224, 7, 70, "ExampleSection",
 CellID->12796],
Cell[15871, 572, 90, 1, 70, "ExampleText",
 CellID->10312],
Cell[CellGroupData[{
Cell[15986, 577, 338, 11, 70, "Input",
 CellID->7262],
Cell[16327, 590, 22378, 371, 70, "Output",
 Evaluatable->False,
 CellID->106961663]
}, Open  ]],
Cell[38720, 964, 49, 1, 70, "ExampleText",
 CellID->30731],
Cell[CellGroupData[{
Cell[38794, 969, 580, 18, 70, "Input",
 CellID->23987],
Cell[39377, 989, 2713, 65, 231, "Output",
 CellID->24464]
}, Open  ]],
Cell[42105, 1057, 121, 3, 70, "ExampleDelimiter",
 CellID->32557],
Cell[CellGroupData[{
Cell[42251, 1064, 706, 22, 70, "Input",
 CellID->29556],
Cell[42960, 1088, 2458, 59, 123, "Output",
 CellID->20170]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45479, 1154, 311, 9, 70, "SeeAlsoSection",
 CellID->28400],
Cell[45793, 1165, 1163, 44, 70, "SeeAlso",
 CellID->6558]
}, Open  ]],
Cell[CellGroupData[{
Cell[46993, 1214, 314, 9, 70, "TutorialsSection",
 CellID->23817],
Cell[47310, 1225, 198, 4, 70, "Tutorials",
 CellID->28609]
}, Open  ]],
Cell[CellGroupData[{
Cell[47545, 1234, 305, 8, 70, "RelatedLinksSection"],
Cell[47853, 1244, 361, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[48251, 1261, 319, 9, 70, "MoreAboutSection",
 CellID->100710654],
Cell[48573, 1272, 145, 3, 70, "MoreAbout",
 CellID->274686205],
Cell[48721, 1277, 162, 3, 70, "MoreAbout",
 CellID->179083879],
Cell[48886, 1282, 137, 3, 70, "MoreAbout",
 CellID->139329055],
Cell[49026, 1287, 148, 3, 70, "MoreAbout",
 CellID->11141055],
Cell[49177, 1292, 179, 3, 70, "MoreAbout",
 CellID->686412711],
Cell[49359, 1297, 198, 4, 70, "MoreAbout",
 CellID->420016693]
}, Open  ]],
Cell[49572, 1304, 27, 0, 70, "History"],
Cell[49602, 1306, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

