(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    174923,       4040]
NotebookOptionsPosition[    164509,       3668]
NotebookOutlinePosition[    165742,       3704]
CellTagsIndexPosition[    165655,       3699]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:tutorial/SpecialFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SinIntegral" :> 
          Documentation`HelpLookup["paclet:ref/SinIntegral"], "ExpIntegralE" :> 
          Documentation`HelpLookup["paclet:ref/ExpIntegralE"], 
          "ExpIntegralEi" :> 
          Documentation`HelpLookup["paclet:ref/ExpIntegralEi"], "FresnelC" :> 
          Documentation`HelpLookup["paclet:ref/FresnelC"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SinIntegral\"\>", 
       2->"\<\"ExpIntegralE\"\>", 3->"\<\"ExpIntegralEi\"\>", 
       4->"\<\"FresnelC\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Error and Exponential Integral Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/ErrorAndExponentialIntegralFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Error and Exponential Integral Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CosIntegral", "ObjectName",
 CellID->979],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CosIntegral",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CosIntegral"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the cosine integral function ",
     Cell[BoxData[
      FormBox[
       RowBox[{"Ci", "(", "z", ")"}], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32618]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"Ci", "(", "z", ")"}], "=", 
    RowBox[{"-", 
     RowBox[{
      SubsuperscriptBox["\[Integral]", "z", "\[Infinity]"], 
      RowBox[{
       RowBox[{
        RowBox[{"cos", "(", "t", ")"}], "/", "t"}], 
       RowBox[{"\[DifferentialD]", "t"}]}]}]}]}], TraditionalForm]], 
  "InlineMath"],
 ". "
}], "Notes",
 CellID->24007],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CosIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CosIntegral"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " has a branch cut discontinuity in the complex ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " plane running from ",
 Cell[BoxData[
  RowBox[{"-", "\[Infinity]"}]], "InlineFormula"],
 " to ",
 Cell[BoxData["0"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22284],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["CosIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CosIntegral"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->267469650],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CosIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CosIntegral"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CosIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CosIntegral"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->389902403],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->61880612],

Cell["Evaluate numerically:", "ExampleText",
 CellID->32621],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CosIntegral", "[", "2.8", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21501],

Cell[BoxData["0.18648838964317582`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132527812]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CosIntegral", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1436],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WkuIXEUUfel53dPzSY89YyeTxMlMfiZBUXciIi5ERUTEhYiKizEIyUIj
+aDEhbrRjaImqAmIWfgB8zMxMVFQECNqQA2IAVFBIkhcGASDi4DQnlu36p33
br9XMy3akJ6qV/eeuv+69Tp3zG7b+NDDs9s2bZiduXXL7KMbN23YOnPL5i14
NLAgSZKz+PfkZIJxFyP3b3G3200GZOQ+yRfylUSeNrKn+Dz/3MmLF//+rGL1
nrvfPnfuT67WsFhzyLoiw5Pz5C2ubnjwwI8//F61uvmRo6e/+fX/WH1ix4cn
P/25TKNnn/nkxPHvYxopRRVyfHXXzs/37/s2t5rmV2t7X//qP1gr7IjtsGmZ
phATwsY0VYoq5PjqqS9/2b7tuK4O+n0HuozGROb4V+/hhNvgPOVsFHUN9DmM
OL9uqZ9aRp6D0x1yGZL24J357rdNGw9XyTNo+GXDgcTvjMhH/CeXO0zIhXC/
8YY9t9+2Fy65cOHi7j4wizIp8Bp53oQfoC/SCDOAwuGYguDVCvS03KYl+Kvd
5kgUpEtmmwHsBHucP/9X8krBu43c3yIaSsvNN722ynGD74H734Gc3vKwLsQF
RfIyIymnu8YqrObnK9xc81eGbnfE//y4Z8Ke0ECGQ26uVUiGuyIocBvEJgog
AEQUQACoiMKoZ6WcNtQj3WLd2RmRwaJoPSEKrAsSsWYMBQ44e/YPGS53c6h1
151vCNdCg/pSBEUrLFGOHD6DY0SGC40s/aDQFy3j6RcjKE8/9dHHH/0kwyk3
h3pQUoZjxtoxFPpgykdV28jwQolnoTRU596Mi0vcXOtRkdvuLXspt2aeDMeN
Pa4WOoA5bTzvffNAfOvN03t2nyIi8/lKN0elxhw5ktQgZ5JiR0QDYgCi3Bux
Fv19mfGk5KSQN91zRAA0knqx0j+vefu5woPgg/dwVkAuX5tAi/gDk9fB1VO3
FD7rMUlzSAMROXnOLQvyIJUlLkcMfcPbzVWqQoWsBUoYB4HmMx6kcDbM5C1g
KnZuvla+6tmp5VURVGnnFsjfPjTQs7WbZX1Rg3zmicWTZl4TfCN8MIDYyq3V
UB4um0OLdaV2mY8GzAHdw9Yt0uvZx4xz9X4wvycEhxfEflmd0fMvWTqH/Bk9
XAjfOQc6a8JUsjSRo+/HP1Y75uyQj89hQ9erFXgkkPDRuoe08FotKVrdIzqq
FJEB3yFdkUKpaJMiMHDWajqNz0sfVjKei0uDpQAtw2Gj97DRcyanj8RdkvgF
fMaMPpNd5kKmvvomhYVQtxHsEMVVj1SrE3bCkqNpJMVo7sNPrK2qH/NqpOAn
VrZp/9wZSI8H10e2g318/i/ydKn/6+pDqqUNauM4GnVPoD+mUAisoznbz1XD
rOQ8qZSeNXaF0ezSwA8TStflekZ/Hkol0zMKwQK7SwXuRKRgPKgU7EacT3NZ
PR3ofR1aFOLL93raC2J/b7/xYC+YBoKDZKJUDo1T9nOTxjpLzL4qB0+mxWFf
+KUb8lD8jbnQd4L18nLNUwraXK3DGjZlokqlxKGMozmLMqxN5nwjvmhHdmc3
OmkiYmmwtc9lPZsQgkAVHbVG2Y4J/L6LUenUF5BRI8TVxq99jlXIVM/ioas5
PWSo3OnEzMcW0KJwo5Ohvf24ecnNMy1Dj/JpJ2T5SvezuklsZiXa6mU5NFtg
a1hQcqw2B32p5L7bgB/LJaqICxvr7PZahn4kSOkrR5Y72FXm1k5Zrvnbn8vQ
wbx9YSMcPKjYPq+0PsLqPRr2owGrSujKVVJGsN7HtLZKjesESRUq0XssXK+t
uVb5it2Jquvs5qeCTr626Dp7sZVBCrCIFBM5qeTcc28BUs1L6ASgZkQOW+GZ
78uNVVRbLKKCi19UW+01JF7bIQ78fL2TA8ygR9FBYWhE5ODtRms4b1bTxh4d
Q78mpz+4fB8AuRGPYp8ruj6vQA9IUNUzObKzFN5WuVhdZ4z+Ezl9Zbg2eB9x
DOhkNMgNu4MluSbYa85Y5O7cbcZkyXjIIqhA62IOQ2jsaB8DWoCACE+ujdib
ei4y8ac5pe/zZNg29nb2rGt8YR8QSuzXwlMAw/A4v8UG181Lgk7Qzd+XVoY5
dBePZr2DrzBXBUtDQrlK1uRSKRoAT86z6yO7Mo86IW78jX2V8W/LeGBLBJVc
isozeLXJstGgG6QQu22NoDIHOgZltYmGUeMjooYIz3cvisauek0uciVjhn1M
bi+VTdHYlUwEWXAfYF5AN2goaM0gGxBlGEMFROGORLuuC97zd8h6kBnrkn2P
RVDZP06Y2HZZNKQ9CyoyrIsd8Y0xLCv+eTyCy/dbistOTHMEBR4ug4D4lvN5
RwSLp9GEkXlfhEuPQRlqfdBWR4b7I1yMI/umhlwSN2pj1qRxHxcHKrFl1doi
Jgk9oZLw9IlxsXK0TWSrZM1u9e8AtttITZxlp5i3iCK6zij6+0A5LrtjxWUv
XoVb2sH04FLjtomeKtyy3pH2YNy0jR/6wcvP1T6sEnoqs6IdrMDt/dXAWlaR
ccCgKBOZd62DhRgIvxbY7l/nzOCsa/Cxrig2/urG2mNmHuNixzdmbBzjokQt
Y8FDGVemJ7LPWuNQBJt51DJ7xbh4graM9jEunrMto32Mi28CFhrt3y3lapio
GzV6xrhYcZWLVZJctSzy2S8pNU/T2B6sitmtyJ+ahyNc9i0mq1WMi7V1xMxj
XIycESNxjIt1bsR4N8bFKjZsvHuklGvQeHfIeJdc4qem8eqQ8WpsD56rysU6
EeOin3RvVtX3Ilz0S9N4QLkKp1nP+8zytxrM0abRWjH7P3cUl/lorVuFK9U7
LaniTRMnNiKORvDs7/IDmbfpt4aJjSq8erf8fGgajyoea/i/w2Nfoeu88xwr
+Lr0TUwPGr1hK/Ox0njTWObJabvBGBepVBb+lvt+hIuxbO985OL7cFpDqVlT
y/dwXI1MMnzUvici1Nn7SSiAkoVpObWrY/KrAKiR/Rh8UEqX3fp9HpRTxf6X
VLLgH5qDNpQ=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->185798123]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"CosIntegral", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4798],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"EulerGamma", "+", 
     RowBox[{"Log", "[", "x", "]"}]}], ")"}], "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "4"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "96"], "-", 
   FractionBox[
    SuperscriptBox["x", "6"], "4320"], "+", 
   FractionBox[
    SuperscriptBox["x", "8"], "322560"], "-", 
   FractionBox[
    SuperscriptBox["x", "10"], "36288000"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 0, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {EulerGamma + Log[$CellContext`x], 0, 
    Rational[-1, 4], 0, 
    Rational[1, 96], 0, 
    Rational[-1, 4320], 0, 
    Rational[1, 322560], 0, 
    Rational[-1, 36288000]}, 0, 11, 1],
  Editable->False]], "Output",
 ImageSize->{437, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->465376024]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1238],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->24816],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CosIntegral", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28488],

Cell[BoxData[
 RowBox[{"0.33146500990509875`", "\[InvisibleSpace]", "-", 
  RowBox[{"0.38823676733822654`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78183140]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->36437801],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->15032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"CosIntegral", "[", "2", "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20065],

Cell[BoxData["0.\
4229808287748649956985651531982558941357377563061876675733378446512`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10121966]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->215815883],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->14481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CosIntegral", "[", "2.0000000000000000000000000000000000000", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15579],

Cell[BoxData["0.422980828774864995698565153198255894135737756305`36.\
20169374065499"], "Output",
 ImageSize->{270, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->162431680]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1727],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CosIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CosIntegral"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->1771],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CosIntegral", "[", 
  RowBox[{"{", 
   RowBox[{"1.2", ",", "1.5", ",", "1.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31313],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.42045918289424045`", ",", "0.4703563171953999`", ",", 
   "0.4568111294183367`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->178518417]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5589],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->5513],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CosIntegral", "[", "0", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18259],

Cell[BoxData[
 RowBox[{"-", "\[Infinity]"}]], "Output",
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->105161847]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CosIntegral", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32271],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->577117096]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->65429833],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->286610149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CosIntegral", "[", "z", "]"}], "//", "TraditionalForm"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->664236091],

Cell[BoxData[
 FormBox[
  RowBox[{"Ci", "(", "z", ")"}], TraditionalForm]], "Output",
 ImageSize->{28, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->26431719]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6595],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CosIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CosIntegral"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->5059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CosIntegral", "[", 
  RowBox[{"1", "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "9"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27714],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"CosIntegral", "[", "1", "]"}], "+", 
   RowBox[{
    RowBox[{"Cos", "[", "1", "]"}], " ", "x"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"Cos", "[", "1", "]"}], "2"], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Cos", "[", "1", "]"}]}], "-", 
         RowBox[{"Sin", "[", "1", "]"}]}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      FractionBox[
       RowBox[{"Cos", "[", "1", "]"}], "9"], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Cos", "[", "1", "]"}]}], "-", 
         RowBox[{"Sin", "[", "1", "]"}]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{"Cos", "[", "1", "]"}], "2"], "+", 
         RowBox[{"Sin", "[", "1", "]"}]}], ")"}]}]}], ")"}], " ", 
    SuperscriptBox["x", "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    CosIntegral[1], 
    Cos[1], Rational[1, 2] Cos[1] + Rational[1, 2] (-Cos[1] - Sin[1]), 
    Rational[1, 9] Cos[1] + Rational[1, 2] (-Cos[1] - Sin[1]) + 
    Rational[1, 3] (Rational[1, 2] Cos[1] + Sin[1])}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{420, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->331612914]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4364],

Cell["Find series expansions at infinity:", "ExampleText",
 CellID->27038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"CosIntegral", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3012],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "x"], ")"}], "2"]}], "+", 
      RowBox[{"6", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "x"], ")"}], "4"]}], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "x"], "]"}], "5"],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {}, 2, 5, 1],
       Editable->False]}],
     SeriesData[$CellContext`x, 
      DirectedInfinity[1], {-1, 0, 6}, 2, 5, 1],
     Editable->False], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    InterpretationBox[
     RowBox[{
      FractionBox["1", "x"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox["1", "x"], ")"}], "3"]}], "+", 
      InterpretationBox[
       SuperscriptBox[
        RowBox[{"O", "[", 
         FractionBox["1", "x"], "]"}], "5"],
       SeriesData[$CellContext`x, 
        DirectedInfinity[1], {}, 1, 5, 1],
       Editable->False]}],
     SeriesData[$CellContext`x, 
      DirectedInfinity[1], {1, 0, -2}, 1, 5, 1],
     Editable->False], ")"}], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}]}]], "Output",
 ImageSize->{392, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->586297454]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24541],

Cell["Average radiated power for a thin linear half-wave antenna:", \
"ExampleText",
 CellID->20416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"Pi", " ", 
         RowBox[{"Cos", "[", "\[Theta]", "]"}]}], "]"}], "-", 
       RowBox[{"Cos", "[", "Pi", "]"}]}], ")"}], "^", "2"}], "/", 
    RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15377],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"3", " ", "EulerGamma"}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"CosIntegral", "[", 
      RowBox[{"2", " ", "\[Pi]"}], "]"}]}], "+", 
    RowBox[{"CosIntegral", "[", 
     RowBox[{"4", " ", "\[Pi]"}], "]"}], "+", 
    RowBox[{"Log", "[", "4", "]"}], "+", 
    RowBox[{"3", " ", 
     RowBox[{"Log", "[", "\[Pi]", "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{486, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->304178446]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->565],

Cell["Plot the imaginary part in the complex plane:", "ExampleText",
 CellID->19891],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Im", "[", 
    RowBox[{"CosIntegral", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->138],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->889973276]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20967],

Cell["\<\
Plot the logarithm of the absolute value in the complex plane: \
\>", "ExampleText",
 CellID->15055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"Abs", "[", 
     RowBox[{"CosIntegral", "[", 
      RowBox[{"x", "+", 
       RowBox[{"I", " ", "y"}]}], "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", " ", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13787],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyMvQV0Fb/zPlyjhbq73XuLu1thg7u7uxV3p7i7FyhWoLgUKM4Gp8AHl0LR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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{2866, 2542, 326}, {2544, 2852, 326}, {2852, 2874, 326}, {
        2874, 2869, 326}, {2546, 2866, 326}, {2542, 2863, 326}, {2863, 2544, 
        326}, {2869, 2546, 326}},
        VertexColors->None]]}, 
     {RGBColor[
      0.35828315616767537`, 0.17019086622692023`, 0.6205906351687778], 
      EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{2870, 2547, 2546, 2869}, {2545, 2853, 2852, 2544}, {2853, 
        2875, 2874, 2852}, {2547, 2867, 2866, 2546}, {2875, 2870, 2869, 
        2874}, {2543, 2864, 2863, 2542}, {2867, 2543, 2542, 2866}, {2864, 
        2545, 2544, 2863}},
        VertexColors->None]]}, 
     {RGBColor[0.4683322910669188, 0.36153659139685596`, 0.7752780072447244], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{1184, 2300, 956}, {2677, 2877, 1155}, {956, 1183, 441}, {
         3695, 3693, 2298}, {1184, 956, 441}, {2742, 2907, 1183}, {1286, 1184,
          441}, {2883, 2921, 441}, {2908, 2743, 1184}, {1183, 1285, 441}, {
         2991, 2989, 1259}, {3697, 3696, 2299}, {2989, 2990, 1259}, {3693, 
         3694, 2298}, {2921, 2884, 441}, {3027, 3026, 1286}, {2994, 2992, 
         1260}, {2995, 2996, 1261}, {2997, 2995, 1261}, {2299, 1183, 956}, {
         3698, 3699, 2300}, {2876, 2677, 1155}, {2992, 2993, 1260}, {3024, 
         3025, 1285}},
         VertexColors->None], 
        PolygonBox[{{3601, 3695, 2298, 956}, {3600, 3697, 2299, 956}, {3694, 
         3600, 956, 2298}, {2743, 3698, 2300, 1184}, {3026, 2908, 1184, 
         1286}, {2907, 3024, 1285, 1183}, {3696, 2742, 1183, 2299}, {2884, 
         3027, 1286, 441}, {3025, 2883, 441, 1285}, {3699, 3601, 956, 2300}},
         VertexColors->None], 
        PolygonBox[{{2877, 2871, 2870, 2875, 1155}, {2996, 2868, 2867, 2547, 
         1261}, {2990, 2865, 2864, 2543, 1259}, {2865, 2994, 1260, 2545, 
         2864}, {2993, 2854, 2853, 2545, 1260}, {2871, 2997, 1261, 2547, 
         2870}, {2868, 2991, 1259, 2543, 2867}, {2854, 2876, 1155, 2875, 
         2853}},
         VertexColors->None]}]}, 
     {RGBColor[0.5745262449391811, 0.5447659993220746, 0.9097427909551773], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmHuMVVcVxs+9w7kz9557jy1UmtoYpTQUgwkMmdq3rS2KrdJ2UHlqRJyh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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllllsllUQhk/79/v/9v+WaCFi4Ar0goSLIkEBBVciiwuWBKiiESoBlwgt
tRqpQKmJiVKJtIgLhQKFmliwKmhdUKOJkGjctSGAFVzuDIjGlgokPm/ei0lm
vnlnOXNm5nxja1fNX1kaQngGKoPmZiEsLYYwKQqhvzyEF5DbofEVIVTkQvg1
DeE3qAH9cyUhfAX/DTS+EEI3+pvBjsA+wmkrtCHBBtuRYI9jk8UhnERfBf5u
Ar6J/Da0Dv4K7Ovgl+HjNLHbsPkb3xfBzwdfDX0J/znfRheMGcb3JmKcxvc9
4Kdh24I8gPwJ+ibwd4HvzIewE2pHbkH+CX4AfT3yrcjtyD8ij8P2Nb6NIJc1
5PQ88uvIw3nHWAvfQY4n0HXx7SnkHcScRB67hMHXecUkvzuh78H+ALWCvw6f
i+HfRT8V/lroDeT90Lica7CdeB3QBWJdhI6BfThzrQ6AeR/sB9BZ5Abq+1/R
MRVrHlSO7b/kUoN+CvZ/oPsdmpzznX0GfwP+DnPWUQVjZ2CzIrLNW7HvRHfR
iDwP/BpiHAPfwfmG4Teh70NXDvUh3xv7bNNyvqtZ+Hs88p3lkc+kzm0f9zM7
8TfxT4C5HNvZ6F/E94P4q4JvTtwrqsEp8luPfBS+Epu94H/mWyx78K+iewU6
h34YaoefCtXC/wMNgO2OfZey+RT/R4o++2UF330d8pa8e6AZ7IbYte4CH1Gr
2zLPwrPUexb4Q1BlwTaLwC6E6sBOyHl2IuJPjDxDp5Ar0d9H/IkF1+ZC0WdX
jVaja4g9O+34uAnfy9Bfja4V/2PA349cp9iRazXEmf6MXDNhbye/o+W20Wxt
xWYw8oypNspBsVUj5bYE+arIOeaQDxH/OPlNQB6Dr3MVnqUh1QhdderZ0Qyv
0ywi70beo/PD10Dd8I3kOBP8Q1BPmXv+UfytgrrxNarEvd4LrS9zz2sW2/DZ
n/dM9qF7L3atdeYbM9+J7kI9+0DRNVJt1BNV5L+56NoshpqQfyH/S0t8xoVg
F6TuHeU4Bf01iXfXEvTf4fvb2LO4Uf2Pr17wvTnPjGr5EjQUuaYH0J9NvYtK
oS7VIvUs9qP/K/WMaDa0AzrJfzs0M+cdodpph2h3qIYtxN6SuFf3kNNSsLWZ
e1M9pd2lHaPdoh22DXxp4rvSDqoDWw91FbxTdsLvUzxiLUfej31P0b2pMx1U
b0NX5nwH3ejGJp4l7bwZ6Br51sZ5mjX/+JqPXFPqHVAfe0drN+8FvwPbTui8
asm3lZnvXHetnLSLF2HflPdOnpN6x2m3beXbJbrPzL10psSxp8fePcrhyaJ3
kHbPdugRsCf41pfzTFXDV2fe5cpRZ3sndu46o3p7NPrBgnv8Dvh85rdJM9OT
uYfUO6qZzjI3dW46UwP61Zl3m3q4J3UP6O71Jjwd+w51d8qpFfuNiWdBM7oZ
286i3071wAqw2xLvqoPYvAy/PDavHlOuH8aePeX8hXZB4l7VTjtC/MOpa603
8CQ5r03ce+r5tsw1U630ZmtX7eLb5ArvrK9T71ztWr3ZmtVbYve+ZnZ35h5S
78hmsMJvit4SvTnXw09PfPd6Mx6LvcO0u/QmfIz/j1Lfpe58JLnMyfy26p/g
f0NhJMo=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6554378235673213, 0.6747683922912766, 0.9115873257368308], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgeYltWVx99vvl7FqFnRXVfMo4hriRo1GmkzGEssawHULYmgqLEgMMDQ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3m0VmUVxs/9xvudc76DyiSRFbUUEVvoUkwKL3AJGQRcYoJYagwBCYLo
FUOQGRSI4XJ1iYAgIDKPGSmmJSXzYMmgiaGCykoCBEFFhn5Pz/1jr7P3u4d3
OHts0HNQl4GpIAjqlQRBhu/RKAj+C+yD6A6dSoKgSxgEu0qDYHg+CLaD92bt
j/DHp4NgFfQ25C9Ad8kGwVB4OwpB0B88zXcsvA+Q+Rr9N5GpA782MBXbK/Pm
1YB+IW+ZZ8EXag3b45BfDD0OuB76FuwNEi8Gx34LYDB0e/jb0X2KiyxB5h7o
T6Hbor+mGAQdgedynIc9aiP/EXRL8DzyjbB1DXAa2bm8we3oPo7MzJTvPAXe
VOA4ezXkDH3hlaM/FXvTgIXgw+FfDu9L6BHgI4H3kK/H2kvIfx+6I3RnYDjv
MQwYw14L4bcEP8iZ98CbwBlaQN+FzcXYGg8do3sMG60478+QeQQ8xxknQu/n
fHXBt+rOvOc/WFsG/SRQJtusrwL/Mzq/Q7c99EXgqtj/SmeYwn5r4D/PXtuA
Tsh3BCpS3uMEZ/kWfgHeDqA+upXQ2+E3wUYe/JnY/2It9uYjvwg4zfnrcIa1
4K/qzcAnot+Y/V4CDoPXZu1qdBsC/Ur8Dx5G9hX4x8H3cr9XwXuydgP2T7DW
n7OVQE9G/iv416LbGLgLflegRuQ76S73AAn4We7cE/kN7Fcf/ddYOwlvKPLv
Y2s09F+hz2BvHeedCxzj/FnuH8oW+r15383cuQL5zth4GnwacA5eV2Rmo38W
+AW6dwNL0J+Tsq8ORKcsa5+9IrGPyDcS9lsOvQK4oeA37YrsHPhV4D2A7tj6
GN4BdJdi83141yFzI7wtwFvsHbLWDP453Rf8FPyHq/d7DNufQW9mv43w22Dv
Qejm8Cqx1xb6odCxswNoi3w7YBK8ptBPydeABpyhBTb+gPx7wM28TTvo+9i/
iH5PbC8ATsH7uuC3vROZGehWAVcVHFOb4b9VdO6on/fZf4v+9Jzv8GjiGFbs
Bnw7I9sJ2MT/m5lzrlmJ/B1Z55wU+N2szZFvIt8ae1+w9hD8QcAKdJdDn0P3
W+AMMhsi+1JXbJYjfwL+QGQHAD+HPoROOWf7N2dcxHnGAIvBb0L3X8gm0M/D
P83/K08ck4rFbUA2sQ/Ldycg0wH6tsT4YO6/Ctvr4JdAX+Q834M3APoge1+K
zkH4n0O3gF8GjOM8Y2PzPwQi5F9XPMKrAh4Dv63ot1GOG8zd9rLWL+sc/UnR
d9JdWiN/r/wldG6YD78VvJms7Uo7Z59E/gugKXQM/wfwFyN/O7xOWeeW2UCT
gnPMRsVO5Ng9A2xQLlG+1r8AotB7ai/50CzszQaWQr+G/kl4tRLXgiuw3wz6
R0AF/DHAEeUu+L2Uf9J+K/mwfFdvcjx0jlRufBAogLcuOjeXqEZA78FeHrwU
GAc+PrKtM/z/MtWS2L7QJ2tfaANdkbVP6C2bx+bpTU+G9jH51mD9E/bqr/uX
+J/dCm879EXO+2jWtvRGehvZbAd9LvTb3g/0hdcPWJbxmyh2ZUO6iuER8EYC
qzjvPPbYCV4pH4eXyjq3yyfkC8rx53njS5HJYmsk8j9BtikwBv0e8omiY1ix
W5p3LZumGMi6pjWCTkF3V67Lea8dkd9Se+qsfYAlGZ95L/L7FJ/Y24pOU85y
Y+LcMYm1SchOjJw7D0Nfz3kPxJZVDlOsJtX1XDHbANm/A99geyDn/6bgnKJc
ohr8S2yHwK1p1/h6kWu6avnfWKtM7IPyvYbA1sj/bHB1vlgD/wL05eAd4Gfg
P6k9of+Jfi39O/i7M85pK5Ffnbh2Ske9yoHQtUc9i3KBaohqh3LCSuVH6MZ5
5xzV/kXQJ3LuARZh/2r5PHsdwl4t5QJsDM27h7kjdM+lXmtnqXk1Q+cWybSE
bgGsS7tm3cl+raC3wG/D2ilsfxk5lqaRQsvg3ZK4VsmHYmxtKjr3bkbnEtUz
5J/J2IZq62WRY1M19k1ke6J/FN6QtGvpA4lzn2rqdPB5od9aOf4N5K8D+iJb
kz3+hK31wLGMa7r+3b2qSaX+h+2R7QBcyLrmzY19Rp1Naz+OnAOV+4ajPww8
B9RNu2dqie7bwDXsNZk3Povu8aJjSz3LTvkna43gN1RO54zXqgfLuAe5BFuP
A+9kXaNrhO4BVPtLco7tfZFzx/9jHN59ofdSjRyN7ijZyLlGr6j2KfmSetxu
yP8G+Sk59wSdlE8L7q1HIV+TtxiSuNapRlfBfzp2r7w+7bfspvqa8pv2xnav
yL2WYrxP4phTrB3nzZoU3UOod9CZuiu3A5mse7zfY/sr7Y/+56xtQ/bm2Hsp
RwyI3NOol1mrnKVcqf4A3nro6bFjVLGpnPEu+P7IuVQ5Vrlva/U8oBy4RfdP
fLbv5t0rPwHsz7pn3h05xym36YzylftD95bymQB8EGsvg6dVn7EXxc596hlU
Kz4oOJZUMzbC3xzaVxUjqrWHi659qrn/Ue1Df1XGNU++8Ujku8lH5nHWucBz
KdewYeo10O+T8doL6M6P7RvqaX8I/gAyo1Kukd+J3ZOrF9cMNQf8ldC9k3La
RwX3+OrtNSMoF/SD/0TKOUF3vSl2rtad1YuOAvbk3JMql6gmqxYrp0xQrLJ2
pNQ5TL3C0rC6l8i6NqtGqjaqRi/gPPMT93rqOdU7pUPPVuqhukGvgD6fc0+r
u6lnV6+uO65Xbxu6t1cPsjZ0T6NeJshbVz2Xei3ZGAI9LXHsqmdWLzU2ca+m
nurFon1EvqGZYTn4stCzlnoQ9fZB5FytHn+1ZjP0z2c8EyqW1TOoV1BMKxe8
mLhXU05QLl5d9NmUk/eAHwpdK+QDM7CfDT37qSfOq9bLf1KeQY+G7snUi2lm
TEL3vOp11ZNoNllQ9OynGeUz4aFr3SfAEegzofG3kf+VZl/od3LOge8WPTNr
VlZPLV7H2LlBMoq9qZFnL8XgG+B/iTw76owjQtcA5f5Z0OnYNVy1WzOOcltZ
5FlaOa5H4hhXbCunf1jwDKrZUzFZF3xT5Fmigjf5FPsViWcH1XjNouqZ1Str
Jv246BhVbKpnronujMh3bY78aPidY88q8uFeoWcgzT6aMeX7DWLPxoqBWYln
ds3q6jGbwftp7FlOM6Jq1etF1xbVrK5Fz1yatTQzz9YsEPkt1MOoVvw6dO+t
mnGlZt/IvZFmCOXmybFzoXL0TPBnY8+K6nGqFP+Ja/FObJSGvqPupplEsfdy
0b2UYnAX+O6ia41y7JbIb6q3lM9WRp5ZNauqx6gTecbTbKcco1mzPPKsrJnz
f8H6WiU=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7363494021954614, 0.8047707852604787, 0.9134318605184841], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNm3e8VNW1x8/cmbkzZ87M2ABFsIOgcEEB6QqaACpYwEpXURGlKYqgiJSL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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtmHe4lcURxj/uPeee81UlAQUkAiaKlAsGkC4o0vKAJbTQRBSpKijSpIiE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         "],
         VertexColors->None], 
        PolygonBox[{{2507, 2473, 2385, 2416, 2363}, {2473, 2857, 1144, 2442, 
         2385}},
         VertexColors->None]}]}, 
     {RGBColor[0.8116924305747047, 0.8633586798085521, 0.892051523068081], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgmUVdWVhm+9Gt5w733OY1MMBUhAQFsoBpkURCkMkKUSTFqEKLRDM0Q7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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3u0jnUWxx+v932d5/aqI1HjyOGoDtEaxVEukY6iZprBqaZhdGGplcNM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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8843565197379811, 0.8875902173412832, 0.8594980762395943], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXl0VdUVxq8k7768vHtxYJAhIWESYu30r51bRwZFpEuXoiAOrUVx6rC6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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllmeMV0UUxR+7+3/L/ndmLdSF7VRLDOg3O0pnwQU1IhKjYIjSsZuYWANI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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNV1lzVFUQvnOTTGbu3JMQlgQERQSXKqssAkqV/gFlzUYCiUpJJEihwis+
CLiU24u/QPYlCSSETcQC1ycshbAGUHxBBdwREAJB/b58Xwofevqcvuf06b17
JrQur18WR1H0cCaKioDfL0TR6CSKUhBnlEbRdMBl0H/MR9EKfKvOiMZvp3Gh
JERRMaApG0X3AN8NWIJ1tiBe5NOFO+eKo+gP8DkDPj8H8TxpXt3Aq/DmOdDX
UBjgf9MoagCficCPAGpx5iHQtwBux8JbvX4cPJ4A/I6rS/FmX17rNf5Glo9l
tCb9V9z7LZH8Y7AeDWjDWwdx5lKx3irHpfWAEpzvxreurPa7gHcCNmJdBlgH
KKbIwGtj2fA18H466NtqrEsL+jYMsAGA61EPfnZktW+Bfncl4pfgXh7Qgm8N
uHcJukylPKCVARaAPhJ4BKAV6wv43oFzU3DmAOBCsXy0Gbz24vtwypCDfQHz
ARWxZIcpom+D7EWbbAFtH86PAJ6G+71QvAz0dyDb24AfsE/w/aOszm4F7Kcs
wGML8h/tvRY838S6E+svIduSoHNngb8L8tNMnD+Nb39Geudoic4n5k2ehaze
GAV4EvyuQ4ZZWPfhThPwaeBL9GNQLNYWxJc8GU/0LdfkzTe4bgaPMYl89RXu
3cD+Mn0K/Dro7Vjn8e6HWdmP8f5TXvb8HHhRkE1rsD8Pnt+AZzvOvJXK7qTR
TuRJzD3vbseZbQXF1gXQLpbIp49mtOea+n5sndfg7AcF5cxk8M4UlDsX84oJ
nv8C68VBPtuNM29A/o5Y+UCeZ3D+FdBXpLLBHp4DbIoVE8QIh0Fd91rfHTjb
ncoPU+H8B8F/APQeHGwG7RrW8/wG+e/E2Z5UslPn5pxs0gXa9lS2ZJ7VFeSP
XFZy8G36cMB+3IV7C0G/jn0t4G/AMfIH/dms9nWxvh8HfS/oS0G/iX1NLLmO
gj4FMk+CzLewb4yFGS/1wDcAJ7CeA3wV0BtJDtqEObEDPBuz+sZc+Qv4MM5M
Bs9bqfbn7Vvq2AFaO6AUd7YBd6bSbyvwFkAW62rc/QfrK7gzOxY+wpiBjO+m
ioNGvDU3p1xrymlf5rxo8po0rpkjK32mKtbbu1yLNoPfJkAJ9p8hNlqDdNuN
s4uy0n9uLJudAs89oL8Aen8s3r3OQfJuM/9RznO4L6qBHx8I8v+rOclRZbvX
2l+0aY1pzGHmMq4N1ox9zm3WF8YaRByM2ZeD4pY8ibEdrB/Lg+SpjJWXUG2w
l7DGxLbJStuOebPfucM8fjHozhH7m3LNBP12qv0vQbWDdYMx0QDaSeDvg+oU
axRjeXFONYe+es/+Yi1tNp135tqe5NFvWrNrLeOE+bcuKAcZ6/OcO7Mhz8Sg
PJiO9c1UMcKYm23Zh+xSZfvWOf6pM+m0VWdBNYj1h3I0OuaPO+6pX+5/eU/d
2Adpx42petU65+5qy/086OMSvct7Fa4Vm82DvvsEPwuCetgq350V3/Ex/T7f
fYc6fYrzzwX1zgbn2Rz3ItLYG1vx7thEPmf+9Lg/sv8MBNXUldadNngp6E6l
43SkY5V9mr2UvTvGmaKg3GZPZU1hPVkWpCd15HxyIqMZocMxR9u2Odc6LSdl
ZN9sd24wJjn3sD6yBlFW2qPca2L2evZ+xi5nA9qa/YczA3O123NFq3OUPqN9
WI9oo6UQZGGq95h/tYliiPJVWoZW5znvb0g1c6x1fZ3nGsv5hjnfb9+MsB/p
1wrrRV6jbMOCc5hnOaNxVuPMRpuWWX7OeazFN61nuW1OXsNM47zC+s7avcA1
vs5vD3dcUW7WKOZQBRQbHu70A+L6+M6MVWSb096sNS3uD6xBLUE9nudY+5uc
C0WuHawbnPH63Hv7XROZs5ydTmU0R5Ef+w7lZF7OSJSTKfiHoG+cR55KFPP0
H+dD2oX8jwPO8i0o+UzQt8MZzSWcrZj3cxLJd82ys2ZecU4w969av17bp8G5
vNj1h33ouuOFuT7UI1kn+lP1LfYszgLUlTWnEu9WBdl6PPCsRPWCteOAdWdt
YB7QVvcF9VTakryG6hPnGOrJOaTLecMZkutDgEyk3rTRtSPv+YIxxz5DG3Ae
O+T7nG0YQ42upZx9qlPNP5ybJqV686RtWG5/HQN87TxaP5RvrhmMP9Zr6s95
hfcO+y51WeV6ddCxMNV+457z/xLPF4yP+4PmIebTKc/ZfPdW0BxJX9SYXu3Z
sMbraZaZ+p6wvrQP/c6Zir4vBY9c0L7NPZn+pv5dtu10/9/qdtyyd1O2e3Fv
QtA8dMwy8O2BVPMHY4qxxPrHeOqzjozPsbg3LogXdSUP+uA/8i7V6g==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllFlTj2EYxp/e6r8+T4k2ypIyHIozXwBR/oqMqJQWu2NfwBgfooythfZC
2fkEjjRDjixljxOmLL9r7oNr5r7e67mf97nXivbz9eci51wryAHxtHMx4PnY
C454526A3Jhz+fB7SbTgXDN8LOHcHXgEPwgfgT+Ab4Cfgk/BZ+DF8A74BLyV
u4ZAEr6K+5qxB0AcXgC/wtleMIj9Ite5u/jH4YfRR/Ffxl4Ci+hv0dvwHQNp
9CK+/cKuynOuK2FnXnP2FfhKbDvizh1DHwEpzhei3+f+MvRu+CQ+57Er8e9M
2BtaOHsLJNBXwo9i94EYfAW8PVgMevsE3wbI3SD4QDK3ZTmXjZ4F9kWWo9PK
TbC39oM+7H4wTyx/4NXctRV8471z3FGEthp04tuAfhb7DCjGHgAnsZ8TwzT6
TMzefo5vJZHFsAZ7HTiBdoBvrdiPOD+ifILj8CdJe/sk6IQ/hU9h3wHd8Gfw
u9j3wHvsS95yX018beiP+TaGNg72ppzbqBopXtUX+yH6ENowqMK3EmTwXSC+
y9jz6NuzLAcZ/LcEy8Uh5Ru7iTN5kd1Rjj7hLXbFWAYf95ZL5eRYsBqpNnpT
Hfomvi3DG8EX7M9gNtu5GvqhFL2MevVE1vMX8X2XtNhUwyP6PwjqTbACuxC0
c3d9ZLXNBY0xq3FLsJnRrCjHa7j/mjdfxTDL3Re89fZ3arwa/aq3WdM/bnur
gXKvGRn2VgPlXj076q3mqrV6vivYTGmWVKNksBnVbDZpxoLNoGZPby4J1lPq
Jc1kebAeUW9oBmp4zzL3/YTXggV8b6etVqrRLvTf6D/Q9iomfKc5M879LfgH
eBrsj2xHJLBjIBPZDFdh16asFuqRE8FmUrOoHl4ZLMfKbRu8I9gMavbUkze9
9bB6VzOof+UH+7f+uVmzlrLeUc2ve+tB9Z522F/4HvS6yGL8522HaXc1oC/B
d6csdsU46G1GNBvaAdotO1MWu3bMH3QXzFd3KtZUsNwr5v3kLpO2Wqvn5tDe
BNtF6rmX/LsnbbOuHbU22A7V7tTMVsDXB5sl7dTSYDtLu0o74SP8U7BeXsS/
39tMaha1U3OC7VDtTvWoalUQLLeq2X9fw7mO
         "],
         VertexColors->None]}]}}, {{}, {}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2521, 3562, 3563, 3561, 3565, 3564, 2797, 2897, 2896, 2891, 
         2520, 3193, 3192, 3488, 3487, 2692, 3439, 3619, 3438, 3171, 2588, 
         3251, 2691, 3437, 3436, 3170, 2587, 3250, 2690, 3435, 3434, 3169, 
         3249, 3248, 3433, 2499, 3432, 3168, 3247, 3246, 3431, 2498, 3430, 
         3167, 3245, 3244, 3429, 2497, 3428, 3166, 3243, 3242, 3427, 2496, 
         3426, 3165, 3241, 3240, 3425, 2495, 3424, 3164, 3239, 3238, 3423, 
         2494, 3422, 3163, 3237, 3236, 3421, 2493, 3420, 3162, 2586, 3235, 
         2689, 3419, 3418, 3161, 2585, 3234, 2688, 2823, 2822, 2959, 2584, 
         2843, 2687, 3549, 3550, 3546, 3548, 3547, 2922, 2519, 2974, 2973, 
         3121, 3120, 2817}],
        "6"],
       Annotation[#, 6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2535, 2985, 2986, 2984, 3206, 2533, 2936, 2534, 3208, 3207, 
         3580, 3579, 3530, 3320, 3620, 2631, 3319, 2632, 3321, 3632, 3323, 
         2633, 3322, 2634, 3324, 3633, 3326, 2635, 3325, 3328, 3327, 2486, 
         3330, 3331, 3329, 3333, 3332, 2487, 3335, 3336, 3334, 3338, 3337, 
         2488, 3340, 3341, 3339, 3343, 3342, 2489, 3345, 3346, 3344, 3348, 
         3347, 2490, 3350, 3351, 3349, 3353, 3352, 2491, 3355, 3356, 3354, 
         3358, 3357, 2492, 3360, 3361, 3359, 2636, 3362, 3634, 3364, 2637, 
         3363, 2638, 3365, 3635, 3367, 2639, 3366, 2640, 3368, 3494, 3495, 
         3496, 3209, 3210, 2536, 2899, 2537, 2988, 2987, 3108, 3107, 3118}],
        "6"],
       Annotation[#, 6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2483, 3072, 3073, 2970, 3102, 3609, 2510, 3465, 3298, 3299, 
         3179, 3466, 2511, 3467, 3300, 3301, 3180, 3468, 2512, 3469, 3302, 
         3303, 3181, 3470, 3471, 2712, 3304, 2621, 3182, 3472, 3473, 2713, 
         3474, 2714, 3475, 2622, 3305, 2623, 3306, 3629, 3308, 2624, 3307, 
         2625, 3309, 3630, 3311, 2626, 3310, 2627, 3312, 3631, 3573, 3667, 
         3666, 2628, 3183, 3476, 3477, 2715, 3313, 2629, 3184, 3478, 3479, 
         2716, 3314, 2630, 3185, 3480, 3481, 3483, 3482, 3315, 3316, 3186, 
         3484, 2513, 3485, 3317, 3318, 3187, 3514, 2514, 3515, 2888, 2889, 
         2752, 3159, 3160, 2484, 2890, 2485}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2881, 2500, 2463, 3146, 3145, 2693, 2845, 2844, 2469, 3281, 
         3282, 3278, 3280, 3279, 2468, 3276, 3277, 3273, 3275, 3274, 2467, 
         3625, 3272, 2600, 3270, 2599, 3271, 3624, 3269, 2598, 3267, 2597, 
         3268, 3623, 3266, 2596, 3265, 2595, 3445, 3446, 3444, 2697, 3092, 
         3091, 2964, 2594, 3047, 2696, 3443, 3442, 3173, 2593, 3264, 2695, 
         3441, 3440, 3172, 2592, 3664, 2694, 3572, 3622, 3263, 2591, 3261, 
         2590, 3262, 3621, 3260, 2589, 3257, 3259, 3258, 2466, 3255, 3256, 
         3252, 3254, 3253, 2465, 3045, 3046, 3042, 3044, 3043, 2464, 3040, 
         3041, 3037, 3039, 3038, 3090}],
        "4"],
       Annotation[#, 4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2583, 2842, 2648, 3587, 2649, 3651, 3711, 2548, 3380, 3381, 
         3377, 3379, 3378, 2479, 3383, 3384, 3382, 2650, 3385, 3644, 3583, 
         3724, 3723, 3710, 3709, 2651, 3722, 2821, 3370, 3371, 3190, 3191, 
         2516, 3386, 2517, 3687, 3688, 3529, 2765, 2934, 2933, 2531, 2935, 
         2532, 3205, 2983, 2766, 2827, 2518, 3388, 2652, 3387, 3390, 3389, 
         2644, 3372, 2643, 3612, 3153, 3154, 2480, 3076, 3034, 3035, 3033, 
         2582, 3036, 2718, 3100, 2708, 2963, 3627, 3294, 2611, 3293, 2612, 
         3295, 3628, 3055, 2613, 3054, 2614, 3056, 3152, 3151, 2709, 3459, 
         2615, 3177, 3460, 3461, 2710, 3462, 3296, 3297, 3178, 3511, 2509, 
         3512, 2885, 3678, 2750, 3513, 2751, 2887, 2886, 2481, 3062, 3063, 
         3061, 3065, 3064, 2482, 3155, 3067, 2616, 3066, 2617, 3068, 3156, 
         3070, 2618, 3069, 2619, 3071, 3158, 3157, 3464, 3463, 2620, 2969, 
         3101, 3616, 3618, 3617, 2711}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2818, 2819, 2720, 3732, 2721, 3733, 2717, 2900, 2901, 2807, 
         2824, 2501, 3671, 3497, 3498, 3373, 2645, 3374, 3713, 3712, 3726, 
         3725, 2601, 2960, 2602, 2846, 2975, 2976, 2769, 3531, 2770, 3532, 
         2756, 3519, 3520, 3188, 3189, 2515, 2850, 2847, 3123, 3124, 3122, 
         2760, 2912, 2911, 2913, 2925, 2522, 2828, 2956, 2955, 2757, 3747, 
         2758, 3707, 3708, 3652, 2653, 3588, 3654, 3653, 2603, 3174, 3574, 
         3575, 2837, 2872, 3692, 2782, 3537, 2783, 3538, 2740, 2906, 3752, 
         3717, 2741, 3737, 2829, 3689, 2767, 3581, 3642, 2539, 2937, 2538, 
         3668, 3669, 3577, 3638, 2523, 2892, 3679, 2753, 3596, 2754, 3680, 
         2578, 3670, 2724, 3578, 3639, 3640, 2893, 3672, 3673, 3591, 3593, 
         3592, 2540, 2938, 2541, 3643, 3582, 2768, 2977, 2524, 2926, 2980, 
         2979, 2978, 2761, 3683, 3523, 3524, 3286, 3287, 3285, 3289, 3288, 
         2470, 2848, 3449, 2698, 3448, 2699, 2825, 2502, 3447, 3283, 3284, 
         3175, 3450, 2503, 3451, 3452, 3048, 2604, 2965, 3093, 3094, 2700, 
         3049, 2605, 2966, 3095, 3096, 2701, 3453, 3455, 3454, 2606, 3050, 
         2607, 3051, 3147}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2475, 2858, 2862, 2855, 3706, 2507, 2473, 2857, 2475}],
        "2"],
       Annotation[#, 2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2478, 3059, 3060, 3057, 3058, 3604, 3606, 3605, 2477, 3117, 
         2476, 2820, 2951, 2950, 2747, 3508, 3509, 3507, 3545, 3544, 3705, 
         2508, 3608, 3137, 2968, 2794, 3136, 2755, 3540, 2787, 3539, 2786, 
         2841, 2581, 3553, 2796, 3551, 2795, 3552, 2923, 3030, 3029, 3135, 
         3028, 3032, 3031, 2577, 2948, 2949, 2793, 3543, 2792, 3704, 2574, 
         2910, 2573, 2836, 2815, 2961, 3116, 3115, 2816, 3760, 2814, 3757, 
         3759, 3758, 2748, 3595, 2749, 3510, 2728, 3489, 3493, 3492, 3528, 
         3685, 3686, 3637, 3636, 3576, 2610, 3655, 3656, 3391, 2654, 3392, 
         3536, 3748, 3749, 3714, 3715, 2562, 2904, 2563, 3751, 3716, 2735, 
         3736, 3015, 3016, 2839, 3014, 3013, 3082, 2665, 3396, 3083, 3021, 
         3217, 3020, 3081, 3395, 2663, 3394, 3215, 3216, 2849, 3012, 3011, 
         3740, 2744, 3720, 3721, 2571, 2909, 2570, 3754, 3719, 3739, 3738, 
         3504, 3404, 2679, 3403, 3406, 3405, 2569, 2952, 2568, 2835, 2962, 
         2474, 3560, 2806, 3559, 2804, 3558, 2805, 2954, 2953, 2704, 2826, 
         2506, 2882, 2703, 3505, 2745, 3232, 3233, 2575, 3506, 3486, 3456, 
         3457, 3150, 3626, 3291, 2608, 3290, 2609, 3292, 3541, 3542, 2789, 
         3602, 2790, 3700, 2788, 3703, 2791, 3603, 3702, 3701, 2472, 3674, 
         3675, 3594, 3677, 3676, 2702, 3148, 3149, 2471, 2504, 3097, 3052, 
         3053, 2967, 3098, 3607, 2505, 3176}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3005, 2662, 3079, 2722, 3734, 2723, 3735, 2680, 2878, 3194, 
         3088, 2670, 3087, 2671, 3089, 3221, 2567, 2914, 2917, 2915, 2916, 
         2808, 2833, 2557, 3131, 2558, 2898, 3109, 2733, 3018, 2734, 3110, 
         2559, 2939, 2940, 2772, 3597, 2771, 3007, 3006, 3005}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3662, 2676, 3584, 3645, 3646, 2775, 3750, 2776, 2943, 2942, 
         3023, 3022, 2905, 2736, 2957, 2831, 2832, 3130, 3129, 2555, 2895, 
         3111, 3112, 3009, 3114, 3113, 2564, 2941, 2565, 3218, 3085, 2669, 
         3397, 2668, 3614, 3615, 2729, 3203, 3204, 2861, 2667, 3727, 2678, 
         3718, 3753, 3662}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2706, 3458, 2707, 3665, 2641, 3586, 2642, 3663, 2682, 3407, 
         2681, 3730, 3731, 3728, 2719, 3729, 2746, 3741, 3743, 3742, 2684, 
         3408, 2683, 3409, 2838, 3417, 2530, 3201, 3200, 3375, 2646, 3228, 
         3229, 3401, 3402, 3231, 3230, 2572, 3526, 3527, 3525, 2763, 3684, 
         2928, 2929, 2773, 3132, 3134, 3133, 2549, 3080, 2550, 3002, 3001, 
         2658, 3490, 3491, 3196, 3197, 2528, 2880, 2527, 3195, 3078, 2656, 
         3077, 2657, 3658, 3659, 3589, 2674, 3000, 2999, 2998, 2655, 3099, 
         2705, 3119, 3755, 3756, 3744, 3746, 3745, 3516, 3399, 2672, 3398, 
         2673, 3657, 2580, 3585, 2579, 3650, 2675, 3590, 3661, 3660, 2660, 
         3393, 2659, 3613, 3198, 3199, 2529, 2879, 3413, 3414, 3412, 3416, 
         3415, 2661, 3211, 3212, 2551, 3400, 2840, 3534, 3535, 3533, 2774, 
         2931, 2930, 2932, 2764, 2958, 2809, 3568, 2811, 3566, 2810, 3567, 
         2566, 3144, 2812, 3143, 2813, 3570, 3569, 2739, 3499, 2730, 3213, 
         3214, 2553, 3571, 2552, 3611, 3003, 3610, 3004, 3075, 3369, 3074, 
         2971, 2972, 2685, 3410, 2686, 3411, 3649, 2576, 2894, 3517, 3518, 
         3376, 2647, 3202, 3641}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3017, 2802, 3139, 2801, 3086, 2803, 3142, 3019, 3017}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3008, 2799, 3084, 2798, 3138, 2800, 3141, 3010, 3008}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3225, 2785, 2834, 2561, 3691, 2780, 3599, 2781, 2947, 2946, 
         3220, 3219, 3128, 2762, 3125, 3127, 3126, 2927, 2560, 3554, 3555, 
         3140, 3557, 3556, 2738, 3502, 2737, 3503, 2777, 3501, 2731, 3500, 
         2732, 2903, 2902, 2556, 2924, 3681, 3682, 3521, 2759, 3522, 3647, 
         3648, 2944, 2945, 2779, 3598, 2778, 3690, 2554, 2830, 2784, 3222, 
         3223, 3224, 2918, 2920, 2919, 3227, 3226, 3225}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{3104, 2727, 3106, 2666, 2859, 2982, 2526, 2860, 2873, 2851, 
         2525, 2981, 2856, 2664, 3105, 2726, 3103, 2725, 3104}],
        RowBox[{"-", "2"}]],
       Annotation[#, -2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2908, 2743, 3698, 3699, 3601, 3695, 3693, 3694, 3600, 3697, 
         3696, 2742, 2907, 3024, 3025, 2883, 2921, 2884, 3027, 3026, 2908}],
        RowBox[{"-", "4"}]],
       Annotation[#, -4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2876, 2677, 2877, 2871, 2997, 2995, 2996, 2868, 2991, 2989, 
         2990, 2865, 2994, 2992, 2993, 2854, 2876}],
        RowBox[{"-", "4"}]],
       Annotation[#, -4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2545, 2853, 2875, 2870, 2547, 2867, 2543, 2864, 2545}],
        RowBox[{"-", "6"}]],
       Annotation[#, -6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2852, 2544, 2863, 2542, 2866, 2546, 2869, 2874, 2852}],
        RowBox[{"-", "8"}]],
       Annotation[#, -8, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-10, 10}, {-10, 10}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 176},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->312453144]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18222],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions containing the cosine integral:"
}], "ExampleText",
 CellID->16439],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"MeijerG", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "1", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         FractionBox["1", 
          RowBox[{" ", "2"}]], "}"}]}], "}"}], ",", 
      FractionBox[
       SuperscriptBox["z", "2"], "4"]}], "]"}], "-", 
    RowBox[{"CosIntegral", "[", "z", "]"}]}], ",", 
   RowBox[{"z", ">", "0"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27441],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "-", 
    FractionBox["2", 
     SqrtBox["\[Pi]"]]}], ")"}], " ", 
  RowBox[{"CosIntegral", "[", "z", "]"}]}]], "Output",
 ImageSize->{176, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->520610132]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->81899242],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to express ",
 Cell[BoxData[
  ButtonBox["CosIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CosIntegral"]], "InlineFormula"],
 " through other functions:"
}], "ExampleText",
 CellID->80676246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{
   RowBox[{"CosIntegral", "[", "z", "]"}], "-", 
   RowBox[{"CosIntegral", "[", 
    RowBox[{"-", "z"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->298157039],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Log", "[", 
    RowBox[{"-", "z"}], "]"}]}], "+", 
  RowBox[{"Log", "[", "z", "]"}]}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->360797968]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26804],

Cell["Find a numerical root:", "ExampleText",
 CellID->27834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"CosIntegral", "[", "z", "]"}], "\[Equal]", 
    RowBox[{"1", "/", "4"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19368],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "0.8638422765430179`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17694390]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8872],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["CosIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CosIntegral"]], "InlineFormula"],
 " from integrals, sums:"
}], "ExampleText",
 CellID->32668],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Cos", "[", "t", "]"}], "t"], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "z", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19974],

Cell[BoxData[
 RowBox[{"If", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"z", ">", "0"}], "||", 
    RowBox[{
     RowBox[{"Im", "[", "z", "]"}], "\[NotEqual]", "0"}]}], ",", 
   RowBox[{"-", 
    RowBox[{"CosIntegral", "[", "z", "]"}]}], ",", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"Cos", "[", "t", "]"}], "t"], ",", 
     RowBox[{"{", 
      RowBox[{"t", ",", "z", ",", "\[Infinity]"}], "}"}], ",", 
     RowBox[{"Assumptions", "\[Rule]", 
      RowBox[{"z", "\[LessEqual]", "0"}]}]}], "]"}]}], "]"}]], "Output",
 ImageSize->{343, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->200018047]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"k", "=", "1"}], "\[Infinity]"], 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"-", "1"}], ")"}], "k"], " ", 
    SuperscriptBox["z", 
     RowBox[{"2", " ", "k"}]]}], 
   RowBox[{"k", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", " ", "k"}], ")"}], "!"}]}]]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5137],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "2"}], " ", 
  RowBox[{"(", 
   RowBox[{"EulerGamma", "-", 
    RowBox[{"CosIntegral", "[", "z", "]"}], "+", 
    RowBox[{"Log", "[", "z", "]"}]}], ")"}]}]], "Output",
 ImageSize->{271, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37544941]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3241],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["CosIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CosIntegral"]], "InlineFormula"],
 " from a differential equation:"
}], "ExampleText",
 CellID->5745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"z", " ", 
       RowBox[{
        SuperscriptBox["w", 
         TagBox[
          RowBox[{"(", "3", ")"}],
          Derivative],
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"2", " ", 
       RowBox[{
        SuperscriptBox["w", "\[Prime]\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}], "+", 
      RowBox[{"z", " ", 
       RowBox[{
        SuperscriptBox["w", "\[Prime]",
         MultilineFunction->None], "[", "z", "]"}]}]}], "\[Equal]", "0"}], 
    ",", 
    RowBox[{"w", "[", "z", "]"}], ",", "z"}], "]"}], "//", 
  "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18018],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"w", "[", "z", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"C", "[", "3", "]"}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", 
         RowBox[{"C", "[", "1", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"CosIntegral", "[", "z", "]"}], "+", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"Log", "[", 
                FractionBox["\[ImaginaryI]", "z"], "]"}]}], "+", 
              RowBox[{"Log", "[", 
               RowBox[{
                RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}], "]"}]}], ")"}]}], 
           "-", 
           RowBox[{"Log", "[", "z", "]"}], "-", 
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"SinIntegral", "[", "z", "]"}]}]}], ")"}]}], "-", 
        RowBox[{"\[ImaginaryI]", " ", 
         RowBox[{"C", "[", "2", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"CosIntegral", "[", "z", "]"}], "+", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"Log", "[", 
                RowBox[{"-", 
                 FractionBox["\[ImaginaryI]", "z"]}], "]"}]}], "+", 
              RowBox[{"Log", "[", 
               RowBox[{"\[ImaginaryI]", " ", "z"}], "]"}]}], ")"}]}], "-", 
           RowBox[{"Log", "[", "z", "]"}], "+", 
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"SinIntegral", "[", "z", "]"}]}]}], ")"}]}]}], 
       ")"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{574, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33469275]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22974],

Cell["Calculate the Wronskian:", "ExampleText",
 CellID->19252],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Det", "[", 
   RowBox[{"Outer", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"#1", ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "#2"}], "}"}]}], "]"}], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", " ", 
       RowBox[{"SinIntegral", "[", "x", "]"}], ",", 
       RowBox[{"CosIntegral", "[", "x", "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "]"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->846],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", 
   SuperscriptBox["x", "2"]]}]], "Output",
 ImageSize->{29, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13455642]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25524],

Cell["Integrals:", "ExampleText",
 CellID->6966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"CosIntegral", "[", 
    SuperscriptBox["z", "a"], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15581],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "z", " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"CosIntegral", "[", 
      SuperscriptBox["z", "a"], "]"}]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SuperscriptBox["z", "a"]}], ")"}], 
      RowBox[{
       RowBox[{"-", "1"}], "/", "a"}]], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{
       FractionBox["1", "a"], ",", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", 
        SuperscriptBox["z", "a"]}]}], "]"}]}], "+", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["z", "a"]}], ")"}], 
      RowBox[{
       RowBox[{"-", "1"}], "/", "a"}]], " ", 
     RowBox[{"Gamma", "[", 
      RowBox[{
       FractionBox["1", "a"], ",", 
       RowBox[{"\[ImaginaryI]", " ", 
        SuperscriptBox["z", "a"]}]}], "]"}]}]}], ")"}]}]], "Output",
 ImageSize->{508, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58003784]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32240],

Cell["Laplace transform:", "ExampleText",
 CellID->29334],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LaplaceTransform", "[", 
  RowBox[{
   RowBox[{"CosIntegral", "[", "t", "]"}], ",", "t", ",", "s"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15296],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"Log", "[", 
    RowBox[{"1", "+", 
     SuperscriptBox["s", "2"]}], "]"}], 
   RowBox[{"2", " ", "s"}]]}]], "Output",
 ImageSize->{83, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->89650463]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25027],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CosIntegral",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CosIntegral"]], "InlineFormula"],
 " can take large values for moderate\[Hyphen]size arguments:"
}], "ExampleText",
 CellID->1205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CosIntegral", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", "I", "]"}], " ", 
   RowBox[{"10.", "^", "6"}]}], " ", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2018],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.60787007947801561169656937`15.954589770191005*^307086"}], 
  "-", 
  RowBox[{
  "9.5745516653148603591884917`15.954589770191005*^307085", " ", 
   "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{381, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102575916]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31641],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be needed:"
}], "ExampleText",
 CellID->13465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"CosIntegral", "[", 
    RowBox[{"10", "^", "60"}], " ", "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16191],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \
\\!\\(CosIntegral[\
1000000000000000000000000000000000000000000000000000000000000]\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->6742243],

Cell[BoxData["8.3038976521934266466406179`10.474314166381525*^-61"], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24846211]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "200"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"CosIntegral", "[", 
      RowBox[{"10", "^", "60"}], " ", "]"}], ",", "20"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23700],

Cell[BoxData["8.30389765219342664664061785421328757`20.*^-61"], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->172956393]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10405],

Cell["Nested integrals:", "ExampleText",
 CellID->24346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NestList", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Integrate", "[", 
      RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", 
    RowBox[{"CosIntegral", "[", " ", "x", "]"}], ",", "4"}], "]"}], 
  " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1025],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"CosIntegral", "[", "x", "]"}], ",", 
   RowBox[{
    RowBox[{"x", " ", 
     RowBox[{"CosIntegral", "[", "x", "]"}]}], "-", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{
    FractionBox[
     RowBox[{"Cos", "[", "x", "]"}], "2"], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"CosIntegral", "[", "x", "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", "x", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{
     FractionBox["1", "6"], " ", "x", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     SuperscriptBox["x", "3"], " ", 
     RowBox[{"CosIntegral", "[", "x", "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       SuperscriptBox["x", "2"]}], ")"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{"Cos", "[", "x", "]"}], "6"]}], "+", 
    RowBox[{
     FractionBox["1", "24"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       SuperscriptBox["x", "2"]}], ")"}], " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "+", 
    RowBox[{
     FractionBox["1", "24"], " ", 
     SuperscriptBox["x", "4"], " ", 
     RowBox[{"CosIntegral", "[", "x", "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "6"], " ", "x", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "24"], " ", "x", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "6"}], "+", 
       SuperscriptBox["x", "2"]}], ")"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}]}]}], "}"}]], "Output",
 ImageSize->{573, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->214523552]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18709],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SinIntegral",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SinIntegral"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpIntegralE",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpIntegralE"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExpIntegralEi",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExpIntegralEi"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FresnelC",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FresnelC"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13371]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24547],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFunctions"]], "Tutorials",
 CellID->29977]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->15675],

Cell[TextData[{
 ButtonBox["Demonstrations with CosIntegral",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=CosIntegral"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/CosineIntegral.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/GammaBetaErf/CosIntegral/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->590172487],

Cell[TextData[ButtonBox["Error and Exponential Integral Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ErrorAndExponentialIntegralFunctions"]], "MoreAbout",
 CellID->246382581]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CosIntegral - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 35, 19.2535234}", "context" -> "System`", 
    "keywords" -> {"ci", "cosine integral"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CosIntegral[z] gives the cosine integral function Ci(z). ", 
    "synonyms" -> {"cos integral"}, "title" -> "CosIntegral", "type" -> 
    "Symbol", "uri" -> "ref/CosIntegral"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5654, 197, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->389902403]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 165512, 3692}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2143, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2766, 80, 47, 1, 70, "ObjectName",
 CellID->979],
Cell[2816, 83, 600, 19, 70, "Usage",
 CellID->32618]
}, Open  ]],
Cell[CellGroupData[{
Cell[3453, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3931, 124, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4054, 130, 393, 15, 70, "Notes",
 CellID->24007],
Cell[4450, 147, 473, 17, 70, "Notes",
 CellID->22284],
Cell[4926, 166, 254, 8, 70, "Notes",
 CellID->267469650],
Cell[5183, 176, 224, 7, 70, "Notes",
 CellID->31226],
Cell[5410, 185, 207, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5654, 197, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->389902403],
Cell[CellGroupData[{
Cell[6039, 211, 147, 5, 70, "ExampleSection",
 CellID->61880612],
Cell[6189, 218, 60, 1, 70, "ExampleText",
 CellID->32621],
Cell[CellGroupData[{
Cell[6274, 223, 105, 3, 28, "Input",
 CellID->21501],
Cell[6382, 228, 177, 5, 36, "Output",
 CellID->132527812]
}, Open  ]],
Cell[6574, 236, 121, 3, 70, "ExampleDelimiter",
 CellID->18129],
Cell[CellGroupData[{
Cell[6720, 243, 217, 7, 28, "Input",
 CellID->1436],
Cell[6940, 252, 3327, 59, 148, "Output",
 Evaluatable->False,
 CellID->185798123]
}, Open  ]],
Cell[10282, 314, 121, 3, 70, "ExampleDelimiter",
 CellID->28504],
Cell[CellGroupData[{
Cell[10428, 321, 219, 7, 70, "Input",
 CellID->4798],
Cell[10650, 330, 989, 32, 54, "Output",
 CellID->465376024]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11688, 368, 215, 7, 70, "ExampleSection",
 CellID->1238],
Cell[11906, 377, 70, 1, 70, "ExampleText",
 CellID->24816],
Cell[CellGroupData[{
Cell[12001, 382, 128, 4, 70, "Input",
 CellID->28488],
Cell[12132, 388, 274, 7, 36, "Output",
 CellID->78183140]
}, Open  ]],
Cell[12421, 398, 124, 3, 70, "ExampleDelimiter",
 CellID->36437801],
Cell[12548, 403, 66, 1, 70, "ExampleText",
 CellID->15032],
Cell[CellGroupData[{
Cell[12639, 408, 156, 5, 70, "Input",
 CellID->20065],
Cell[12798, 415, 234, 7, 36, "Output",
 CellID->10121966]
}, Open  ]],
Cell[13047, 425, 125, 3, 70, "ExampleDelimiter",
 CellID->215815883],
Cell[13175, 430, 109, 3, 70, "ExampleText",
 CellID->14481],
Cell[CellGroupData[{
Cell[13309, 437, 144, 4, 70, "Input",
 CellID->15579],
Cell[13456, 443, 228, 6, 36, "Output",
 CellID->162431680]
}, Open  ]],
Cell[13699, 452, 120, 3, 70, "ExampleDelimiter",
 CellID->1727],
Cell[13822, 457, 211, 7, 70, "ExampleText",
 CellID->1771],
Cell[CellGroupData[{
Cell[14058, 468, 166, 5, 70, "Input",
 CellID->31313],
Cell[14227, 475, 276, 9, 36, "Output",
 CellID->178518417]
}, Open  ]],
Cell[14518, 487, 120, 3, 70, "ExampleDelimiter",
 CellID->5589],
Cell[14641, 492, 86, 1, 70, "ExampleText",
 CellID->5513],
Cell[CellGroupData[{
Cell[14752, 497, 103, 3, 70, "Input",
 CellID->18259],
Cell[14858, 502, 185, 6, 36, "Output",
 CellID->105161847]
}, Open  ]],
Cell[CellGroupData[{
Cell[15080, 513, 110, 3, 70, "Input",
 CellID->32271],
Cell[15193, 518, 158, 5, 36, "Output",
 CellID->577117096]
}, Open  ]],
Cell[15366, 526, 124, 3, 70, "ExampleDelimiter",
 CellID->65429833],
Cell[15493, 531, 203, 7, 70, "ExampleText",
 CellID->286610149],
Cell[CellGroupData[{
Cell[15721, 542, 147, 5, 70, "Input",
 CellID->664236091],
Cell[15871, 549, 231, 7, 50, "Output",
 CellID->26431719]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16151, 562, 238, 7, 70, "ExampleSection",
 CellID->6595],
Cell[16392, 571, 210, 7, 70, "ExampleText",
 CellID->5059],
Cell[CellGroupData[{
Cell[16627, 582, 307, 10, 70, "Input",
 CellID->27714],
Cell[16937, 594, 1717, 54, 81, "Output",
 CellID->331612914]
}, Open  ]],
Cell[18669, 651, 120, 3, 70, "ExampleDelimiter",
 CellID->4364],
Cell[18792, 656, 74, 1, 70, "ExampleText",
 CellID->27038],
Cell[CellGroupData[{
Cell[18891, 661, 225, 7, 70, "Input",
 CellID->3012],
Cell[19119, 670, 1462, 49, 52, "Output",
 CellID->586297454]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20630, 725, 223, 7, 70, "ExampleSection",
 CellID->24541],
Cell[20856, 734, 100, 2, 70, "ExampleText",
 CellID->20416],
Cell[CellGroupData[{
Cell[20981, 740, 477, 15, 70, "Input",
 CellID->15377],
Cell[21461, 757, 574, 18, 51, "Output",
 CellID->304178446]
}, Open  ]],
Cell[22050, 778, 119, 3, 70, "ExampleDelimiter",
 CellID->565],
Cell[22172, 783, 84, 1, 70, "ExampleText",
 CellID->19891],
Cell[CellGroupData[{
Cell[22281, 788, 414, 14, 70, "Input",
 CellID->138],
Cell[22698, 804, 22136, 367, 70, "Output",
 Evaluatable->False,
 CellID->889973276]
}, Open  ]],
Cell[44849, 1174, 121, 3, 70, "ExampleDelimiter",
 CellID->20967],
Cell[44973, 1179, 110, 3, 70, "ExampleText",
 CellID->15055],
Cell[CellGroupData[{
Cell[45108, 1186, 464, 15, 70, "Input",
 CellID->13787],
Cell[45575, 1203, 98224, 1664, 70, "Output",
 CellID->312453144]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[143848, 2873, 233, 7, 70, "ExampleSection",
 CellID->18222],
Cell[144084, 2882, 246, 8, 70, "ExampleText",
 CellID->16439],
Cell[CellGroupData[{
Cell[144355, 2894, 646, 22, 70, "Input",
 CellID->27441],
Cell[145004, 2918, 328, 12, 58, "Output",
 CellID->520610132]
}, Open  ]],
Cell[145347, 2933, 124, 3, 70, "ExampleDelimiter",
 CellID->81899242],
Cell[145474, 2938, 364, 13, 70, "ExampleText",
 CellID->80676246],
Cell[CellGroupData[{
Cell[145863, 2955, 231, 7, 70, "Input",
 CellID->298157039],
Cell[146097, 2964, 280, 10, 36, "Output",
 CellID->360797968]
}, Open  ]],
Cell[146392, 2977, 121, 3, 70, "ExampleDelimiter",
 CellID->26804],
Cell[146516, 2982, 61, 1, 70, "ExampleText",
 CellID->27834],
Cell[CellGroupData[{
Cell[146602, 2987, 273, 9, 70, "Input",
 CellID->19368],
Cell[146878, 2998, 226, 7, 36, "Output",
 CellID->17694390]
}, Open  ]],
Cell[147119, 3008, 120, 3, 70, "ExampleDelimiter",
 CellID->8872],
Cell[147242, 3013, 213, 8, 70, "ExampleText",
 CellID->32668],
Cell[CellGroupData[{
Cell[147480, 3025, 244, 8, 70, "Input",
 CellID->19974],
Cell[147727, 3035, 679, 21, 73, "Output",
 CellID->200018047]
}, Open  ]],
Cell[CellGroupData[{
Cell[148443, 3061, 422, 16, 70, "Input",
 CellID->5137],
Cell[148868, 3079, 336, 11, 36, "Output",
 CellID->37544941]
}, Open  ]],
Cell[149219, 3093, 120, 3, 70, "ExampleDelimiter",
 CellID->3241],
Cell[149342, 3098, 220, 8, 70, "ExampleText",
 CellID->5745],
Cell[CellGroupData[{
Cell[149587, 3110, 740, 25, 70, "Input",
 CellID->18018],
Cell[150330, 3137, 1868, 53, 103, "Output",
 CellID->33469275]
}, Open  ]],
Cell[152213, 3193, 121, 3, 70, "ExampleDelimiter",
 CellID->22974],
Cell[152337, 3198, 63, 1, 70, "ExampleText",
 CellID->19252],
Cell[CellGroupData[{
Cell[152425, 3203, 554, 18, 70, "Input",
 CellID->846],
Cell[152982, 3223, 220, 8, 52, "Output",
 CellID->13455642]
}, Open  ]],
Cell[153217, 3234, 121, 3, 70, "ExampleDelimiter",
 CellID->25524],
Cell[153341, 3239, 48, 1, 70, "ExampleText",
 CellID->6966],
Cell[CellGroupData[{
Cell[153414, 3244, 189, 6, 70, "Input",
 CellID->15581],
Cell[153606, 3252, 1124, 38, 51, "Output",
 CellID->58003784]
}, Open  ]],
Cell[154745, 3293, 121, 3, 70, "ExampleDelimiter",
 CellID->32240],
Cell[154869, 3298, 57, 1, 70, "ExampleText",
 CellID->29334],
Cell[CellGroupData[{
Cell[154951, 3303, 183, 6, 70, "Input",
 CellID->15296],
Cell[155137, 3311, 302, 11, 57, "Output",
 CellID->89650463]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[155488, 3328, 226, 7, 70, "ExampleSection",
 CellID->25027],
Cell[155717, 3337, 237, 7, 70, "ExampleText",
 CellID->1205],
Cell[CellGroupData[{
Cell[155979, 3348, 188, 6, 70, "Input",
 CellID->2018],
Cell[156170, 3356, 351, 11, 36, "Output",
 CellID->102575916]
}, Open  ]],
Cell[156536, 3370, 121, 3, 70, "ExampleDelimiter",
 CellID->31641],
Cell[156660, 3375, 234, 8, 70, "ExampleText",
 CellID->13465],
Cell[CellGroupData[{
Cell[156919, 3387, 188, 6, 70, "Input",
 CellID->16191],
Cell[157110, 3395, 491, 10, 70, "Message",
 CellID->6742243],
Cell[157604, 3407, 208, 5, 36, "Output",
 CellID->24846211]
}, Open  ]],
Cell[CellGroupData[{
Cell[157849, 3417, 321, 11, 70, "Input",
 CellID->23700],
Cell[158173, 3430, 204, 5, 36, "Output",
 CellID->172956393]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[158426, 3441, 224, 7, 70, "ExampleSection",
 CellID->10405],
Cell[158653, 3450, 56, 1, 70, "ExampleText",
 CellID->24346],
Cell[CellGroupData[{
Cell[158734, 3455, 285, 10, 70, "Input",
 CellID->1025],
Cell[159022, 3467, 1912, 62, 111, "Output",
 CellID->214523552]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[160995, 3536, 311, 9, 70, "SeeAlsoSection",
 CellID->18709],
Cell[161309, 3547, 965, 35, 70, "SeeAlso",
 CellID->13371]
}, Open  ]],
Cell[CellGroupData[{
Cell[162311, 3587, 314, 9, 70, "TutorialsSection",
 CellID->24547],
Cell[162628, 3598, 144, 3, 70, "Tutorials",
 CellID->29977]
}, Open  ]],
Cell[CellGroupData[{
Cell[162809, 3606, 321, 9, 70, "RelatedLinksSection",
 CellID->15675],
Cell[163133, 3617, 367, 12, 70, "RelatedLinks"],
Cell[163503, 3631, 185, 4, 70, "RelatedLinks"],
Cell[163691, 3637, 196, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[163924, 3646, 319, 9, 70, "MoreAboutSection",
 CellID->590172487],
Cell[164246, 3657, 191, 4, 70, "MoreAbout",
 CellID->246382581]
}, Open  ]],
Cell[164452, 3664, 27, 0, 70, "History"],
Cell[164482, 3666, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

