(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25949,        955]
NotebookOptionsPosition[     20661,        773]
NotebookOutlinePosition[     22017,        811]
CellTagsIndexPosition[     21932,        806]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Partitioning Data into Clusters" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PartitioningDataIntoClusters"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Partitioning Data into Clusters\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CorrelationDistance" :> 
          Documentation`HelpLookup["paclet:ref/CorrelationDistance"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"CorrelationDistance\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Distance and Dissimilarity Measures" :> 
          Documentation`HelpLookup[
           "paclet:guide/DistanceAndDissimilarityMeasures"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Distance and Dissimilarity Measures\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CosineDistance", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CosineDistance",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CosineDistance"], "[", 
       RowBox[{
        StyleBox["u", "TI"], ",", 
        StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the angular cosine distance between vectors ",
     Cell[BoxData[
      StyleBox["u", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["v", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18007]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CosineDistance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CosineDistance"], "[", 
   RowBox[{
    StyleBox["u", "TI"], ",", 
    StyleBox["v", "TI"]}], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["1", "TR"], "-", 
   RowBox[{
    RowBox[{
     StyleBox["u", "TI"], ".", 
     StyleBox["v", "TI"]}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       ButtonBox["Norm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Norm"], "[", 
       StyleBox["u", "TI"], "]"}], 
      RowBox[{
       ButtonBox["Norm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Norm"], "[", 
       StyleBox["v", "TI"], "]"}]}], ")"}]}]}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->709349618,
  ButtonNote->"709349618"]
}], "Notes",
 CellID->24221]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->824277007],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->4807854],

Cell["Cosine distance between two vectors:", "ExampleText",
 CellID->235641551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CosineDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->196650888],

Cell[BoxData[
 RowBox[{"1", "-", 
  FractionBox[
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}], "+", 
    RowBox[{"c", " ", "z"}]}], 
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Abs", "[", "a", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "b", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "c", "]"}], "2"]}]], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Abs", "[", "x", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "y", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "z", "]"}], "2"]}]]}]]}]], "Output",
 ImageSize->{404, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->373892988]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->125461358],

Cell["Cosine distance between numeric vectors:", "ExampleText",
 CellID->319587507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CosineDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "5", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190454384],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"17", " ", 
   SqrtBox[
    FractionBox["2", "581"]]}]}]], "Output",
 ImageSize->{86, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->91594193]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10075],

Cell["Compute distance between any vectors of equal length:", "ExampleText",
 CellID->86273121],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CosineDistance", "[", 
  RowBox[{
   RowBox[{"RandomReal", "[", 
    RowBox[{"5", ",", "100"}], "]"}], ",", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"5", ",", "100"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488208944],

Cell[BoxData["0.20682205818429333`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->307998578]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->204991544],

Cell["Compute distance between vectors of any precision:", "ExampleText",
 CellID->14044010],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CosineDistance", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "5", ",", "2", ",", "3", ",", "10"}], "}"}], ",", 
     "50"}], "]"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "15", ",", "20", ",", "5", ",", "5"}], "}"}], ",", 
     "50"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323525768],

Cell[BoxData["0.\
4062940529572788872406931125582100673373718289257040507745378019202`49.\
23320907495654"], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->142877199]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23847],

Cell["Cluster data using cosine distance:", "ExampleText",
 CellID->245478961],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindClusters", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"DistanceFunction", "\[Rule]", "CosineDistance"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108189764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"5", ",", "10"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->549340086]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32604],

Cell["Cosine distance includes a dot product scaled by norms:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->709349618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CosineDistance", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->418619957],

Cell[BoxData[
 RowBox[{"1", "-", 
  FractionBox[
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}], "+", 
    RowBox[{"c", " ", "z"}]}], 
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Abs", "[", "a", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "b", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "c", "]"}], "2"]}]], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Abs", "[", "x", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "y", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "z", "]"}], "2"]}]]}]]}]], "Output",
 ImageSize->{404, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->343735718]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ".", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Norm", "[", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}], 
     RowBox[{"Norm", "[", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}], "]"}]}], ")"}]}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->6273653],

Cell[BoxData[
 RowBox[{"1", "-", 
  FractionBox[
   RowBox[{
    RowBox[{"a", " ", "x"}], "+", 
    RowBox[{"b", " ", "y"}], "+", 
    RowBox[{"c", " ", "z"}]}], 
   RowBox[{
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Abs", "[", "a", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "b", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "c", "]"}], "2"]}]], " ", 
    SqrtBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"Abs", "[", "x", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "y", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"Abs", "[", "z", "]"}], "2"]}]]}]]}]], "Output",
 ImageSize->{404, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->234135498]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23098092],

Cell["\<\
Cosine distance includes a dot product scaled by Euclidean distances from the \
origin:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->38175833],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->201109570],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"scale", "=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"EuclideanDistance", "[", 
     RowBox[{"u", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}], 
    RowBox[{"EuclideanDistance", "[", 
     RowBox[{"v", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}]}], ")"}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->3304662],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"Abs", "[", "a", "]"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"Abs", "[", "b", "]"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"Abs", "[", "c", "]"}], "2"]}]], " ", 
  SqrtBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"Abs", "[", "x", "]"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"Abs", "[", "y", "]"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"Abs", "[", "z", "]"}], "2"]}]]}]], "Output",
 ImageSize->{381, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->700312193]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CosineDistance", "[", 
   RowBox[{"u", ",", "v"}], "]"}], "==", 
  RowBox[{"1", "-", 
   RowBox[{
    RowBox[{"u", ".", "v"}], "/", "scale"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->45975943],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->947315045]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->179646547],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CosineDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CosineDistance"]], "InlineFormula"],
 " of vectors shifted by their means is equivalent to ",
 Cell[BoxData[
  ButtonBox["CorrelationDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CorrelationDistance"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->655878966],

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"v", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->10753412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CosineDistance", "[", 
   RowBox[{
    RowBox[{"u", "-", 
     RowBox[{"Mean", "[", "u", "]"}]}], ",", 
    RowBox[{"v", "-", 
     RowBox[{"Mean", "[", "v", "]"}]}]}], "]"}], "\[Equal]", 
  RowBox[{"CorrelationDistance", "[", 
   RowBox[{"u", ",", "v"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31468961],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17770255]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23392],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["CorrelationDistance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CorrelationDistance"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->15759]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8213],

Cell[TextData[ButtonBox["Partitioning Data into Clusters",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/PartitioningDataIntoClusters"]], "Tutorials",
 CellID->22256]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with CosineDistance",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=CosineDistance"]\
, None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->636469],

Cell[TextData[ButtonBox["Distance and Dissimilarity Measures",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DistanceAndDissimilarityMeasures"]], "MoreAbout",
 CellID->172774102]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CosineDistance - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 35, 18.8003868}", "context" -> "System`", 
    "keywords" -> {
     "angular cosine distance", "cosine angle dissimilarity", 
      "cosine angle distance", "cosine dissimilarity"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CosineDistance[u, v] gives the angular cosine distance between vectors u \
and v.", "synonyms" -> {"cosine distance"}, "title" -> "CosineDistance", 
    "type" -> "Symbol", "uri" -> "ref/CosineDistance"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6260, 200, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->824277007]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21789, 799}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1868, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2491, 76, 1579, 37, 70, "ObjectNameGrid"],
Cell[4073, 115, 712, 23, 70, "Usage",
 CellID->18007]
}, Open  ]],
Cell[CellGroupData[{
Cell[4822, 143, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5300, 160, 923, 35, 70, "Notes",
 CellID->24221]
}, Closed]],
Cell[CellGroupData[{
Cell[6260, 200, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->824277007],
Cell[CellGroupData[{
Cell[6645, 214, 146, 5, 70, "ExampleSection",
 CellID->4807854],
Cell[6794, 221, 79, 1, 70, "ExampleText",
 CellID->235641551],
Cell[CellGroupData[{
Cell[6898, 226, 251, 8, 28, "Input",
 CellID->196650888],
Cell[7152, 236, 813, 28, 62, "Output",
 CellID->373892988]
}, Open  ]],
Cell[7980, 267, 125, 3, 70, "ExampleDelimiter",
 CellID->125461358],
Cell[8108, 272, 83, 1, 70, "ExampleText",
 CellID->319587507],
Cell[CellGroupData[{
Cell[8216, 277, 251, 8, 70, "Input",
 CellID->190454384],
Cell[8470, 287, 241, 9, 60, "Output",
 CellID->91594193]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8760, 302, 216, 7, 70, "ExampleSection",
 CellID->10075],
Cell[8979, 311, 95, 1, 70, "ExampleText",
 CellID->86273121],
Cell[CellGroupData[{
Cell[9099, 316, 263, 8, 70, "Input",
 CellID->488208944],
Cell[9365, 326, 177, 5, 36, "Output",
 CellID->307998578]
}, Open  ]],
Cell[9557, 334, 125, 3, 70, "ExampleDelimiter",
 CellID->204991544],
Cell[9685, 339, 92, 1, 70, "ExampleText",
 CellID->14044010],
Cell[CellGroupData[{
Cell[9802, 344, 424, 14, 70, "Input",
 CellID->323525768],
Cell[10229, 360, 249, 7, 36, "Output",
 CellID->142877199]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10527, 373, 223, 7, 70, "ExampleSection",
 CellID->23847],
Cell[10753, 382, 78, 1, 70, "ExampleText",
 CellID->245478961],
Cell[CellGroupData[{
Cell[10856, 387, 474, 16, 70, "Input",
 CellID->108189764],
Cell[11333, 405, 498, 18, 36, "Output",
 CellID->549340086]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11880, 429, 233, 7, 70, "ExampleSection",
 CellID->32604],
Cell[12116, 438, 146, 2, 70, "ExampleText",
 CellID->709349618],
Cell[CellGroupData[{
Cell[12287, 444, 251, 8, 70, "Input",
 CellID->418619957],
Cell[12541, 454, 813, 28, 62, "Output",
 CellID->343735718]
}, Open  ]],
Cell[CellGroupData[{
Cell[13391, 487, 503, 18, 70, "Input",
 CellID->6273653],
Cell[13897, 507, 813, 28, 62, "Output",
 CellID->234135498]
}, Open  ]],
Cell[14725, 538, 124, 3, 70, "ExampleDelimiter",
 CellID->23098092],
Cell[14852, 543, 185, 5, 70, "ExampleText",
 CellID->38175833],
Cell[15040, 550, 281, 10, 70, "Input",
 CellID->201109570],
Cell[CellGroupData[{
Cell[15346, 564, 412, 14, 70, "Input",
 CellID->3304662],
Cell[15761, 580, 627, 22, 45, "Output",
 CellID->700312193]
}, Open  ]],
Cell[CellGroupData[{
Cell[16425, 607, 233, 8, 70, "Input",
 CellID->45975943],
Cell[16661, 617, 161, 5, 36, "Output",
 CellID->947315045]
}, Open  ]],
Cell[16837, 625, 125, 3, 70, "ExampleDelimiter",
 CellID->179646547],
Cell[16965, 630, 436, 13, 70, "ExampleText",
 CellID->655878966],
Cell[17404, 645, 280, 10, 70, "Input",
 CellID->10753412],
Cell[CellGroupData[{
Cell[17709, 659, 351, 11, 70, "Input",
 CellID->31468961],
Cell[18063, 672, 160, 5, 36, "Output",
 CellID->17770255]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18284, 684, 311, 9, 70, "SeeAlsoSection",
 CellID->23392],
Cell[18598, 695, 218, 6, 70, "SeeAlso",
 CellID->15759]
}, Open  ]],
Cell[CellGroupData[{
Cell[18853, 706, 313, 9, 70, "TutorialsSection",
 CellID->8213],
Cell[19169, 717, 170, 3, 70, "Tutorials",
 CellID->22256]
}, Open  ]],
Cell[CellGroupData[{
Cell[19376, 725, 305, 8, 70, "RelatedLinksSection"],
Cell[19684, 735, 370, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20091, 752, 316, 9, 70, "MoreAboutSection",
 CellID->636469],
Cell[20410, 763, 179, 3, 70, "MoreAbout",
 CellID->172774102]
}, Open  ]],
Cell[20604, 769, 27, 0, 70, "History"],
Cell[20634, 771, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

