(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    114979,       3828]
NotebookOptionsPosition[     96991,       3166]
NotebookOutlinePosition[     98187,       3202]
CellTagsIndexPosition[     98101,       3197]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tan" :> Documentation`HelpLookup["paclet:ref/Tan"], "Coth" :> 
          Documentation`HelpLookup["paclet:ref/Coth"], "Cos" :> 
          Documentation`HelpLookup["paclet:ref/Cos"], "ArcCot" :> 
          Documentation`HelpLookup["paclet:ref/ArcCot"], "Degree" :> 
          Documentation`HelpLookup["paclet:ref/Degree"], "TrigToExp" :> 
          Documentation`HelpLookup["paclet:ref/TrigToExp"], "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Tan\"\>", 2->"\<\"Coth\"\>", 
       3->"\<\"Cos\"\>", 4->"\<\"ArcCot\"\>", 5->"\<\"Degree\"\>", 
       6->"\<\"TrigToExp\"\>", 7->"\<\"TrigExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Trigonometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Cot", "ObjectName",
 CellID->8437],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Cot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cot"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the cotangent of ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19198]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The argument of ",
 Cell[BoxData[
  ButtonBox["Cot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cot"]], "InlineFormula"],
 " is assumed to be in radians. (Multiply by ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 " to convert from degrees.) "
}], "Notes",
 CellID->18364],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"cot", "(", "z", ")"}], "=", 
    RowBox[{"1", "/", 
     RowBox[{"tan", "(", "z", ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->1085],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Cos",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Cos"], "[", 
    StyleBox["z", "TI"], "]"}], "/", 
   RowBox[{
    ButtonBox["Sin",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sin"], "[", 
    StyleBox["z", "TI"], "]"}]}]], "InlineFormula"],
 " is automatically converted to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cot"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TrigFactorList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigFactorList"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " does decomposition. "
}], "Notes",
 CellID->31665],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Cot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cot"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cot"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cot"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->242366160],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->124645595],

Cell["The argument is given in radians:", "ExampleText",
 CellID->12525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cot", "[", 
  RowBox[{"Pi", "/", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30630],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox["3"]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->239534590]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23179],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 " to specify an argument in degrees:"
}], "ExampleText",
 CellID->3079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cot", "[", 
  RowBox[{"60", "Degree"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8313],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox["3"]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->224881713]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32517],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cot", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14145],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{192, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{192., Automatic}},
 CellLabel->"Out[1]=",
 CellID->369835778]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1969],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Cot", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21839],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "x"], "-", 
   FractionBox["x", "3"], "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "45"], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "5"]}], "945"], "-", 
   FractionBox[
    SuperscriptBox["x", "7"], "4725"], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "9"]}], "93555"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, -1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 3], 0, 
    Rational[-1, 45], 0, 
    Rational[-2, 945], 0, 
    Rational[-1, 4725], 0, 
    Rational[-2, 93555]}, -1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{259, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->657295929]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(12)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23762],

Cell["Evaluate numerically:", "ExampleText",
 CellID->19473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cot", "[", "1.2", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23681],

Cell[BoxData["0.38877956936820496`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->40395231]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23147],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->27053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Cot", "[", 
    RowBox[{"12", "/", "10"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22708],

Cell[BoxData["0.\
3887795693682049116341915049719034095949849259409758245726565785777`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->181046504]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16967726],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->16715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cot", "[", "1.20000000000000000000000", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4429],

Cell[BoxData["0.3887795693682049116341915049719034096`22.52857168497864"], \
"Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->307647682]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->126574333],

Cell["\<\
The precision of the output can be much smaller than the precision of the \
input:\
\>", "ExampleText",
 CellID->27689],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cot", "[", "1.5707963267948966192213216916397514421", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14663],

Cell[BoxData["9.999999999999999998584699687`17.*^-21"], "Output",
 ImageSize->{171, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->42449067]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5541],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cot"]], "InlineFormula"],
 " threads element-wise over lists and matrices:"
}], "ExampleText",
 CellID->16259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cot", "[", 
  RowBox[{"{", 
   RowBox[{"1.2", ",", "1.5", ",", "1.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18631],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.38877956936820496`", ",", "0.07091484430265245`", ",", 
   RowBox[{"-", "0.23330353485401106`"}]}], "}"}]], "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183635601]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cot", "[", 
  TagBox[
   RowBox[{"(", "\:f3a2", GridBox[{
      {
       FractionBox["\[Pi]", "2"], "u"},
      {"v", 
       FractionBox["\[Pi]", "3"]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{
      "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
       "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2514],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"Cot", "[", "u", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cot", "[", "v", "]"}], ",", 
     FractionBox["1", 
      SqrtBox["3"]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{199, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->53616628]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25988],

Cell["Evaluate for complex arguments:", "ExampleText",
 CellID->18170],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cot", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28168],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.2756691212298994`"}], "-", 
  RowBox[{"1.0426406420944216`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{141, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59474375]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->655],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->3850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cot", "[", 
  RowBox[{"Pi", "/", "6"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13444],

Cell[BoxData[
 SqrtBox["3"]], "Output",
 ImageSize->{28, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->645422911]
}, Open  ]],

Cell[TextData[{
 "More complicated cases require explicit use of ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->16278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cot", "[", 
  RowBox[{"Pi", "/", "8"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19406],

Cell[BoxData[
 RowBox[{"Cot", "[", 
  FractionBox["\[Pi]", "8"], "]"}]], "Output",
 ImageSize->{52, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->113275765]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10313],

Cell[BoxData[
 SqrtBox[
  FractionBox[
   RowBox[{"2", "+", 
    SqrtBox["2"]}], 
   RowBox[{"2", "-", 
    SqrtBox["2"]}]]]], "Output",
 ImageSize->{71, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->9509234]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32371],

Cell["\<\
Convert multiple\[Hyphen]angle expressions:\
\>", "ExampleText",
 CellID->23327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Cot", "[", 
   RowBox[{"4", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17073],

Cell[BoxData[
 RowBox[{
  FractionBox[
   SuperscriptBox[
    RowBox[{"Cos", "[", "x", "]"}], "4"], 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "3"]}]}]], "-", 
  FractionBox[
   RowBox[{"6", " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "2"]}], 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "3"]}]}]], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"Sin", "[", "x", "]"}], "4"], 
   RowBox[{
    RowBox[{"4", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], "-", 
    RowBox[{"4", " ", 
     RowBox[{"Cos", "[", "x", "]"}], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "3"]}]}]]}]], "Output",
 ImageSize->{468, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->767635674]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2173],

Cell[BoxData[
 RowBox[{"Cot", "[", 
  RowBox[{"4", " ", "x"}], "]"}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->92477508]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31102],

Cell["Convert sums of trigonometric functions to products:", "ExampleText",
 CellID->25587],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{
   RowBox[{"Cot", "[", "x", "]"}], "+", 
   RowBox[{"Cot", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31417],

Cell[BoxData[
 RowBox[{
  RowBox[{"Csc", "[", "x", "]"}], " ", 
  RowBox[{"Csc", "[", "y", "]"}], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{"x", "+", "y"}], "]"}]}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55154340]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6153],

Cell["Expand assuming real variables:", "ExampleText",
 CellID->26126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Cot", "[", 
   RowBox[{"x", "+", 
    RowBox[{"I", " ", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20595],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "x"}], "]"}], 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], "-", 
     RowBox[{"Cosh", "[", 
      RowBox[{"2", " ", "y"}], "]"}]}]]}], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"Sinh", "[", 
     RowBox[{"2", " ", "y"}], "]"}]}], 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "x"}], "]"}], "-", 
    RowBox[{"Cosh", "[", 
     RowBox[{"2", " ", "y"}], "]"}]}]]}]], "Output",
 ImageSize->{280, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->533064026]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29213],

Cell["Convert to complex exponentials:", "ExampleText",
 CellID->2406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"Cot", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27370],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}]], "+", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]]}], ")"}]}], 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}]], "-", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "z"}]]}]]}]], "Output",
 ImageSize->{98, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->802036039]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->223811447],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->249568345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cot", "[", "z", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6155808],

Cell[BoxData[
 FormBox[
  RowBox[{"cot", "(", "z", ")"}], TraditionalForm]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->216054973]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23305],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cot"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals:"
}], "ExampleText",
 CellID->22496],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cot", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Pi", "/", "6"}], ",", 
     RowBox[{"Pi", "/", "3"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24833],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    FractionBox["1", 
     SqrtBox["3"]], ",", 
    SqrtBox["3"]}], "}"}], "]"}]], "Output",
 ImageSize->{152, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->374899644]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4852],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->17879],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cot", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30519],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], 
  "]"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->183084446]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cot", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7793],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->337295419]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21465],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cot"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->31371],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cot", "[", 
  RowBox[{
   FractionBox["\[Pi]", "2"], "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15444],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", "x"}], "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}], "3"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 1, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {-1, 
    Rational[-1, 2], 
    Rational[-2, 3]}, 1, 4, 1],
  Editable->False]], "Output",
 ImageSize->{134, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->355075933]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17271],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cot"]], "InlineFormula"],
 " threads element-wise over sparse arrays as well as lists: "
}], "ExampleText",
 CellID->24087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", 
     FractionBox["\[Pi]", "2"]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
     FractionBox["\[Pi]", "3"]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
     FractionBox["\[Pi]", "12"]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", " ", "2"}], "}"}], "->", 
     FractionBox["\[Pi]", "4"]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"_", ",", "_"}], "}"}], "->", 
     FractionBox["\[Pi]", "2"]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28099],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}], ",", 
    FractionBox["\[Pi]", "2"]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{190, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->224248131]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cot", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8596],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->616166503]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", "%", "]"}], " ", "//", " ", "MatrixForm"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->17552],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", 
      FractionBox["1", 
       SqrtBox["3"]]},
     {"0", "0", "0"},
     {"0", "0", 
      RowBox[{"2", "+", 
       SqrtBox["3"]}]},
     {"0", "1", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{98, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->82054528]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8257],

Cell["Generate a plot with poles removed:", "ExampleText",
 CellID->27590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cot", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "Pi"}], "/", "2"}], ",", 
     RowBox[{
      RowBox[{"3", "/", "2"}], "Pi"}]}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13357],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{173, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{173., Automatic}},
 CellLabel->"Out[1]=",
 CellID->184991932]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7809],

Cell["Generate a plot over the complex argument plane:", "ExampleText",
 CellID->5865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"Cot", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Pi"}], ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25686],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->978280871]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->259],

Cell["\<\
The cotangent function conformally maps a parabola into the unit disk:\
\>", "ExampleText",
 CellID->22313],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"parabola", " ", "=", " ", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"1", "-", 
         RowBox[{
          RowBox[{"x", "^", "2"}], "/", "4"}], "+", 
         RowBox[{"I", " ", "x"}]}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", "20", ",", " ", 
          RowBox[{"1", "/", "10"}]}], "}"}]}], "]"}]}], ",", 
     RowBox[{"pnts", "=", 
      RowBox[{
       RowBox[{"Point", "[", 
        RowBox[{"Thread", "[", 
         RowBox[{"Through", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"Re", ",", "Im"}], "}"}], "@", "#"}], "]"}], "]"}], "]"}],
        "&"}]}], ",", 
     RowBox[{"opts", "=", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Axes", "->", "True"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "All"}]}], "}"}]}]}], "}"}], ",", 
   "\n", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"pnts", "[", "parabola", "]"}], ",", "opts"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"pnts", "[", 
        RowBox[{
         RowBox[{"Cot", "[", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "4."}], " ", 
           RowBox[{"Sqrt", "[", "parabola", "]"}]}], "]"}], "^", "2"}], "]"}],
        ",", "opts"}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2435],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->264582055]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(12)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4101],

Cell["\<\
Basic parity and periodicity properties of the cotangent function are \
automatically applied:\
\>", "ExampleText",
 CellID->10468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cot", "[", 
  RowBox[{"x", "+", "Pi"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22869],

Cell[BoxData[
 RowBox[{"Cot", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55129158]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cot", "[", 
  RowBox[{"-", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6731],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Cot", "[", "x", "]"}]}]], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->413116543]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cot", "[", 
  RowBox[{"I", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->26074],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[ImaginaryI]"}], " ", 
  RowBox[{"Coth", "[", "x", "]"}]}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->226922585]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"Cot", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->30843],

Cell[BoxData[
 RowBox[{"Tan", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->164775667]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13316],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TrigFactorList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigFactorList"]], "InlineFormula"],
 " to factor ",
 Cell[BoxData[
  ButtonBox["Cot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cot"]], "InlineFormula"],
 " into ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->15024],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cos", "[", "x", "]"}], "/", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30511],

Cell[BoxData[
 RowBox[{"Cot", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31870758]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactorList", "[", 
  RowBox[{"Cot", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5722],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{236, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1054201942]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10057],

Cell["\<\
Complicated expressions containing trigonometric functions do not simplify \
automatically:\
\>", "ExampleText",
 CellID->14095],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cot", "[", "z", "]"}], "+", 
  RowBox[{"Tan", "[", "z", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8174],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cot", "[", "z", "]"}], "+", 
  RowBox[{"Tan", "[", "z", "]"}]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->979254082]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2183],

Cell[BoxData[
 RowBox[{
  RowBox[{"Csc", "[", "z", "]"}], " ", 
  RowBox[{"Sec", "[", "z", "]"}]}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->326703542]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17295],

Cell["Simplify with assumptions on parameters:", "ExampleText",
 CellID->25722],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cot", "[", 
  RowBox[{
   RowBox[{"-", "x"}], "+", 
   RowBox[{"k", " ", "Pi"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16983],

Cell[BoxData[
 RowBox[{"Cot", "[", 
  RowBox[{
   RowBox[{"k", " ", "\[Pi]"}], "-", "x"}], "]"}]], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->557572356]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", ",", 
   RowBox[{"k", "\[Element]", "Integers"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29503],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Cot", "[", "x", "]"}]}]], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->62438309]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24300],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->15590],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cot", "[", 
    RowBox[{"ArcCot", "[", "z", "]"}], "]"}], ",", " ", 
   RowBox[{"Cot", "[", 
    RowBox[{"2", 
     RowBox[{"ArcCot", "[", "z", "]"}]}], "]"}], ",", " ", 
   RowBox[{"Cot", "[", 
    RowBox[{"3", 
     RowBox[{"ArcCot", "[", "z", "]"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21480],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"Cot", "[", 
    RowBox[{"2", " ", 
     RowBox[{"ArcCot", "[", "z", "]"}]}], "]"}], ",", 
   RowBox[{"Cot", "[", 
    RowBox[{"3", " ", 
     RowBox[{"ArcCot", "[", "z", "]"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{264, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->311413673]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionExpand", "[", "%", "]"}], "//", "Together"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32702],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   FractionBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["z", "2"]}], 
    RowBox[{"2", " ", "z"}]], ",", 
   FractionBox[
    RowBox[{"z", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "3"}], "+", 
       SuperscriptBox["z", "2"]}], ")"}]}], 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["z", "2"]}]}]]}], "}"}]], "Output",
 ImageSize->{160, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39946379]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9818],

Cell["Solve a trigonometric equation:", "ExampleText",
 CellID->10557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cot", "[", "z", "]"}], "2"], "-", 
     RowBox[{"2", " ", 
      RowBox[{"Cot", "[", 
       RowBox[{"z", "+", 
        RowBox[{"Pi", "/", "4"}]}], "]"}]}]}], "\[Equal]", "4"}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15561],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{534, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2612871]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5028],

Cell["Solve for zeros and poles: ", "ExampleText",
 CellID->23656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cot", "[", 
     RowBox[{
      RowBox[{"\[Alpha]", " ", "x"}], "+", "\[Beta]"}], "]"}], "==", "0"}], 
   ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25713],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[Equal]", "0"}], "&&", 
      RowBox[{"\[Beta]", "\[Equal]", 
       RowBox[{
        FractionBox["\[Pi]", "2"], "+", 
        RowBox[{"\[Pi]", " ", 
         RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         FractionBox["\[Pi]", "2"], "-", "\[Beta]", "+", 
         RowBox[{"\[Pi]", " ", 
          RowBox[{"C", "[", "1", "]"}]}]}], "\[Alpha]"]}]}], ")"}]}], 
   ")"}]}]], "Output",
 ImageSize->{479, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27782428]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Cot", "[", 
      RowBox[{
       RowBox[{"\[Alpha]", " ", "x"}], "+", "\[Beta]"}], "]"}]}], "==", "0"}],
    ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23092],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[Equal]", "0"}], "&&", 
      RowBox[{"\[Beta]", "\[Equal]", 
       RowBox[{"\[Pi]", " ", 
        RowBox[{"C", "[", "1", "]"}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "\[Beta]"}], "+", 
         RowBox[{"\[Pi]", " ", 
          RowBox[{"C", "[", "1", "]"}]}]}], "\[Alpha]"]}]}], ")"}]}], 
   ")"}]}]], "Output",
 ImageSize->{439, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->579624072]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26467],

Cell["Numerically find a root of a transcendental equation:", "ExampleText",
 CellID->11320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cot", "[", "z", "]"}], "2"], "+", 
     RowBox[{"3", " ", 
      RowBox[{"Cot", "[", 
       RowBox[{"z", "+", 
        RowBox[{"Pi", "/", "6"}]}], "]"}]}], "+", "z"}], "\[Equal]", "4"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7358],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "0.6152626849180285`"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->262016900]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3987],

Cell["Integrals:", "ExampleText",
 CellID->9094],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Cot", "[", "z", "]"}], "a"], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4983],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cot", "[", "z", "]"}], 
     RowBox[{"1", "+", "a"}]], " ", 
    RowBox[{"Hypergeometric2F1", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"1", "+", "a"}], "2"], ",", "1", ",", 
      RowBox[{"1", "+", 
       FractionBox[
        RowBox[{"1", "+", "a"}], "2"]}], ",", 
      RowBox[{"-", 
       SuperscriptBox[
        RowBox[{"Cot", "[", "z", "]"}], "2"]}]}], "]"}]}], 
   RowBox[{"1", "+", "a"}]]}]], "Output",
 ImageSize->{363, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->332290646]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19714],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cot"]], "InlineFormula"],
 " appears in special cases of many mathematical functions: "
}], "ExampleText",
 CellID->26746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"BesselJ", "[", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "2"]}], ",", "z"}], "]"}], "/", 
    RowBox[{"BesselJ", "[", 
     RowBox[{
      FractionBox["1", "2"], ",", "z"}], "]"}]}], ",", 
   FractionBox[
    RowBox[{"MathieuC", "[", 
     RowBox[{"1", ",", "0", ",", "z"}], "]"}], 
    RowBox[{"MathieuS", "[", 
     RowBox[{"1", ",", "0", ",", "z"}], "]"}]], ",", 
   RowBox[{"JacobiCS", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"JacobiSC", "[", 
    RowBox[{
     RowBox[{
      FractionBox["\[Pi]", "2"], "-", "z"}], ",", "0"}], "]"}], ",", " ", 
   RowBox[{"JacobiNS", "[", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", "z"}], ",", "1"}], "]"}], ",", " ", 
   RowBox[{"JacobiSN", "[", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"\[Pi]", " ", "\[ImaginaryI]"}], "2"], "-", 
      RowBox[{"\[ImaginaryI]", " ", "z"}]}], ",", "1"}], "]"}], ",", 
   RowBox[{
    RowBox[{"HypergeometricPFQ", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       FractionBox["1", "2"], "}"}], ",", 
      RowBox[{"-", "z"}]}], "]"}], "/", 
    RowBox[{"HypergeometricPFQ", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       FractionBox["3", "2"], "}"}], ",", 
      RowBox[{"-", "z"}]}], "]"}]}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24390],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Cot", "[", "z", "]"}], ",", 
   RowBox[{"Cot", "[", "z", "]"}], ",", 
   RowBox[{"Cot", "[", "z", "]"}], ",", 
   RowBox[{"Cot", "[", "z", "]"}], ",", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    RowBox[{"Cot", "[", "z", "]"}]}], ",", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"Cot", "[", "z", "]"}]}], ",", 
   RowBox[{"2", " ", 
    SqrtBox["z"], " ", 
    RowBox[{"Cot", "[", 
     RowBox[{"2", " ", 
      SqrtBox["z"]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{473, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->344935011]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26255],

Cell["Calculate residue symbolically and numerically: ", "ExampleText",
 CellID->13163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Residue", "[", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Cot", "[", "z", "]"}], "k"], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31467],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", 
   RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0", ",", 
   RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0"}], "}"}]], "Output",
 ImageSize->{205, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->232492695]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", "\[Pi]", " ", "I"}]], 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"Cot", "[", "z", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{"-", 
       FractionBox["1", "4"]}], ",", 
      RowBox[{"-", 
       FractionBox["I", "4"]}], ",", 
      RowBox[{"+", 
       FractionBox["1", "4"]}], ",", 
      RowBox[{"+", 
       FractionBox["I", "4"]}], ",", 
      RowBox[{"-", 
       FractionBox["1", "4"]}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14231],

Cell[BoxData[
 RowBox[{"0.9999999999999982`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30616709]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2880],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cot"]], "InlineFormula"],
 " is a numeric function:"
}], "ExampleText",
 CellID->4718],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Cot", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16128],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Listable", ",", "NumericFunction", ",", "Protected"}], 
  "}"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8415262]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"Cot", "[", 
   RowBox[{"2", "+", "E"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4720],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->537850155]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32091],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText",
 CellID->3766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cot", "[", 
  RowBox[{"10.", "^", "30"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27587],

Cell[BoxData[
 RowBox[{"-", "0.8651332729636558`"}]], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5396945]
}, Open  ]],

Cell["With exact input, the answer is correct:", "ExampleText",
 CellID->12126],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Cot", "[", 
    RowBox[{"10", "^", "30"}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14825],

Cell[BoxData["11.05154719340447478515848536935`20."], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->154690184]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17518],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " is needed:"
}], "ExampleText",
 CellID->3220],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Cot", "[", 
    RowBox[{"10", "^", "100"}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10035],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \
\\!\\(Cot[\
100000000000000000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->51889726],

Cell[BoxData["0``-30."], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->467060100]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "200"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Cot", "[", 
      RowBox[{"10", "^", "100"}], "]"}], ",", "20"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->29156],

Cell[BoxData["2.49232387927982069486640543726040396169`20."], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21563219]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Product]", 
   RowBox[{"k", "=", "1"}], 
   RowBox[{"n", "-", "1"}]], " ", 
  RowBox[{"Cot", "[", 
   RowBox[{"z", "+", 
    FractionBox[
     RowBox[{"k", " ", "\[Pi]"}], "n"]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8186],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{"-", "n"}]]}], " ", 
  RowBox[{"Csc", "[", 
   RowBox[{"n", " ", "z"}], "]"}], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{
    FractionBox["1", "2"], " ", "n", " ", 
    RowBox[{"(", 
     RowBox[{"\[Pi]", "-", 
      RowBox[{"2", " ", "z"}]}], ")"}]}], "]"}], " ", 
  RowBox[{"Tan", "[", "z", "]"}]}]], "Output",
 ImageSize->{265, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->548508210]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", ",", 
   RowBox[{
    FractionBox["n", "2"], "\[Element]", "Integers"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->388142573],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ImaginaryI]", "n"], " ", 
  RowBox[{"Tan", "[", "z", "]"}]}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37998810]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%%", ",", 
   RowBox[{
    FractionBox[
     RowBox[{"n", "-", "1"}], "2"], "\[Element]", "Integers"}]}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->52332370],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[ImaginaryI]"}], " ", 
  SuperscriptBox["\[ImaginaryI]", "n"], " ", 
  RowBox[{"Cot", "[", 
   RowBox[{"n", " ", "z"}], "]"}], " ", 
  RowBox[{"Tan", "[", "z", "]"}]}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->618305995]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Cot", "[", 
    RowBox[{"ArcTan", "[", "z", "]"}], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15169],

Cell[BoxData[
 RowBox[{"Log", "[", "z", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51663059]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14899],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["Cot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cot"]], "InlineFormula"],
 " at integer points:"
}], "ExampleText",
 CellID->22514],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ArcCot", "[", 
     RowBox[{"Abs", "[", 
      RowBox[{"Cot", "[", 
       RowBox[{"x", " ", "y"}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10415],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{155, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{155., Automatic}},
 CellLabel->"Out[1]=",
 CellID->994817233]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5436],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cot", "[", 
   FractionBox["\[Pi]", 
    SuperscriptBox["2", "12"]], "]"}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23669],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   RowBox[{"2", "+", 
    SqrtBox[
     RowBox[{"2", "+", 
      SqrtBox[
       RowBox[{"2", "+", 
        SqrtBox[
         RowBox[{"2", "+", 
          SqrtBox[
           RowBox[{"2", "+", 
            SqrtBox[
             RowBox[{"2", "+", 
              SqrtBox[
               RowBox[{"2", "+", 
                SqrtBox[
                 RowBox[{"2", "+", 
                  SqrtBox[
                   RowBox[{"2", "+", 
                    SqrtBox[
                    RowBox[{"2", "+", 
                    SqrtBox["2"]}]]}]]}]]}]]}]]}]]}]]}]]}]]}]], 
  SqrtBox[
   RowBox[{"2", "-", 
    SqrtBox[
     RowBox[{"2", "+", 
      SqrtBox[
       RowBox[{"2", "+", 
        SqrtBox[
         RowBox[{"2", "+", 
          SqrtBox[
           RowBox[{"2", "+", 
            SqrtBox[
             RowBox[{"2", "+", 
              SqrtBox[
               RowBox[{"2", "+", 
                SqrtBox[
                 RowBox[{"2", "+", 
                  SqrtBox[
                   RowBox[{"2", "+", 
                    SqrtBox[
                    RowBox[{"2", "+", 
                    SqrtBox["2"]}]]}]]}]]}]]}]]}]]}]]}]]}]]}]]]], "Output",
 ImageSize->{411, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->393125206]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31676],

Cell["The continued fraction is highly regular:", "ExampleText",
 CellID->17858],

Cell[CellGroupData[{

Cell["ContinuedFraction[Cot[1],22]", "Input",
 CellLabel->"In[1]:=",
 CellID->7952],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "1", ",", "1", ",", "3", ",", "1", ",", "5", ",", "1", 
   ",", "7", ",", "1", ",", "9", ",", "1", ",", "11", ",", "1", ",", "13", 
   ",", "1", ",", "15", ",", "1", ",", "17", ",", "1", ",", "19", ",", "1"}], 
  "}"}]], "Output",
 ImageSize->{442, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->338180379]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{
   RowBox[{"Cot", "[", "1", "]"}], ",", "Algebraics"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5915],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17921877]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21154],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tan"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Coth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Coth"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cos",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cos"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcCot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Degree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Degree"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18012]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18908],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->20340]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->1360],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Cotangent.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/Cot/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Cot"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->226500351],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->213529647]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 35, 30.0819256}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Cot[z] gives the cotangent of z. ", 
    "synonyms" -> {"cot", "cotan", "cotangent", "cotg", "ctg", "ctn"}, 
    "title" -> "Cot", "type" -> "Symbol", "uri" -> "ref/Cot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6228, 218, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->242366160]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 97958, 3190}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2342, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2965, 81, 40, 1, 70, "ObjectName",
 CellID->8437],
Cell[3008, 84, 531, 18, 70, "Usage",
 CellID->19198]
}, Open  ]],
Cell[CellGroupData[{
Cell[3576, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4054, 124, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4177, 130, 368, 13, 70, "Notes",
 CellID->18364],
Cell[4548, 145, 227, 9, 70, "Notes",
 CellID->1085],
Cell[4778, 156, 772, 29, 70, "Notes",
 CellID->31665],
Cell[5553, 187, 233, 8, 70, "Notes",
 CellID->9487],
Cell[5789, 197, 208, 7, 70, "Notes",
 CellID->31226],
Cell[6000, 206, 191, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6228, 218, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->242366160],
Cell[CellGroupData[{
Cell[6613, 232, 148, 5, 70, "ExampleSection",
 CellID->124645595],
Cell[6764, 239, 72, 1, 70, "ExampleText",
 CellID->12525],
Cell[CellGroupData[{
Cell[6861, 244, 119, 4, 28, "Input",
 CellID->30630],
Cell[6983, 250, 190, 7, 55, "Output",
 CellID->239534590]
}, Open  ]],
Cell[7188, 260, 121, 3, 70, "ExampleDelimiter",
 CellID->23179],
Cell[7312, 265, 212, 8, 70, "ExampleText",
 CellID->3079],
Cell[CellGroupData[{
Cell[7549, 277, 118, 4, 70, "Input",
 CellID->8313],
Cell[7670, 283, 190, 7, 55, "Output",
 CellID->224881713]
}, Open  ]],
Cell[7875, 293, 121, 3, 70, "ExampleDelimiter",
 CellID->32517],
Cell[CellGroupData[{
Cell[8021, 300, 232, 8, 28, "Input",
 CellID->14145],
Cell[8256, 310, 3051, 54, 140, "Output",
 Evaluatable->False,
 CellID->369835778]
}, Open  ]],
Cell[11322, 367, 120, 3, 70, "ExampleDelimiter",
 CellID->1969],
Cell[CellGroupData[{
Cell[11467, 374, 212, 7, 70, "Input",
 CellID->21839],
Cell[11682, 383, 906, 31, 54, "Output",
 CellID->657295929]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12637, 420, 217, 7, 70, "ExampleSection",
 CellID->23762],
Cell[12857, 429, 60, 1, 70, "ExampleText",
 CellID->19473],
Cell[CellGroupData[{
Cell[12942, 434, 97, 3, 70, "Input",
 CellID->23681],
Cell[13042, 439, 176, 5, 36, "Output",
 CellID->40395231]
}, Open  ]],
Cell[13233, 447, 121, 3, 70, "ExampleDelimiter",
 CellID->23147],
Cell[13357, 452, 66, 1, 70, "ExampleText",
 CellID->27053],
Cell[CellGroupData[{
Cell[13448, 457, 175, 6, 70, "Input",
 CellID->22708],
Cell[13626, 465, 235, 7, 36, "Output",
 CellID->181046504]
}, Open  ]],
Cell[13876, 475, 124, 3, 70, "ExampleDelimiter",
 CellID->16967726],
Cell[14003, 480, 109, 3, 70, "ExampleText",
 CellID->16715],
Cell[CellGroupData[{
Cell[14137, 487, 118, 3, 70, "Input",
 CellID->4429],
Cell[14258, 492, 217, 6, 36, "Output",
 CellID->307647682]
}, Open  ]],
Cell[14490, 501, 125, 3, 70, "ExampleDelimiter",
 CellID->126574333],
Cell[14618, 506, 129, 4, 70, "ExampleText",
 CellID->27689],
Cell[CellGroupData[{
Cell[14772, 514, 136, 4, 70, "Input",
 CellID->14663],
Cell[14911, 520, 195, 5, 36, "Output",
 CellID->42449067]
}, Open  ]],
Cell[15121, 528, 120, 3, 70, "ExampleDelimiter",
 CellID->5541],
Cell[15244, 533, 209, 7, 70, "ExampleText",
 CellID->16259],
Cell[CellGroupData[{
Cell[15478, 544, 158, 5, 70, "Input",
 CellID->18631],
Cell[15639, 551, 290, 8, 36, "Output",
 CellID->183635601]
}, Open  ]],
Cell[CellGroupData[{
Cell[15966, 564, 596, 18, 70, "Input",
 CellID->2514],
Cell[16565, 584, 407, 15, 55, "Output",
 CellID->53616628]
}, Open  ]],
Cell[16987, 602, 121, 3, 70, "ExampleDelimiter",
 CellID->25988],
Cell[17111, 607, 70, 1, 70, "ExampleText",
 CellID->18170],
Cell[CellGroupData[{
Cell[17206, 612, 120, 4, 70, "Input",
 CellID->28168],
Cell[17329, 618, 269, 8, 36, "Output",
 CellID->59474375]
}, Open  ]],
Cell[17613, 629, 119, 3, 70, "ExampleDelimiter",
 CellID->655],
Cell[17735, 634, 86, 1, 70, "ExampleText",
 CellID->3850],
Cell[CellGroupData[{
Cell[17846, 639, 119, 4, 70, "Input",
 CellID->13444],
Cell[17968, 645, 169, 6, 38, "Output",
 CellID->645422911]
}, Open  ]],
Cell[18152, 654, 238, 8, 70, "ExampleText",
 CellID->16278],
Cell[CellGroupData[{
Cell[18415, 666, 119, 4, 70, "Input",
 CellID->19406],
Cell[18537, 672, 212, 7, 49, "Output",
 CellID->113275765]
}, Open  ]],
Cell[CellGroupData[{
Cell[18786, 684, 106, 3, 70, "Input",
 CellID->10313],
Cell[18895, 689, 264, 11, 72, "Output",
 CellID->9509234]
}, Open  ]],
Cell[19174, 703, 121, 3, 70, "ExampleDelimiter",
 CellID->32371],
Cell[19298, 708, 90, 3, 70, "ExampleText",
 CellID->23327],
Cell[CellGroupData[{
Cell[19413, 715, 151, 5, 70, "Input",
 CellID->17073],
Cell[19567, 722, 1366, 45, 93, "Output",
 CellID->767635674]
}, Open  ]],
Cell[CellGroupData[{
Cell[20970, 772, 101, 3, 70, "Input",
 CellID->2173],
Cell[21074, 777, 209, 7, 36, "Output",
 CellID->92477508]
}, Open  ]],
Cell[21298, 787, 121, 3, 70, "ExampleDelimiter",
 CellID->31102],
Cell[21422, 792, 91, 1, 70, "ExampleText",
 CellID->25587],
Cell[CellGroupData[{
Cell[21538, 797, 187, 6, 70, "Input",
 CellID->31417],
Cell[21728, 805, 304, 10, 36, "Output",
 CellID->55154340]
}, Open  ]],
Cell[22047, 818, 120, 3, 70, "ExampleDelimiter",
 CellID->6153],
Cell[22170, 823, 70, 1, 70, "ExampleText",
 CellID->26126],
Cell[CellGroupData[{
Cell[22265, 828, 184, 6, 70, "Input",
 CellID->20595],
Cell[22452, 836, 682, 24, 53, "Output",
 CellID->533064026]
}, Open  ]],
Cell[23149, 863, 121, 3, 70, "ExampleDelimiter",
 CellID->29213],
Cell[23273, 868, 70, 1, 70, "ExampleText",
 CellID->2406],
Cell[CellGroupData[{
Cell[23368, 873, 131, 4, 70, "Input",
 CellID->27370],
Cell[23502, 879, 673, 21, 59, "Output",
 CellID->802036039]
}, Open  ]],
Cell[24190, 903, 125, 3, 70, "ExampleDelimiter",
 CellID->223811447],
Cell[24318, 908, 203, 7, 70, "ExampleText",
 CellID->249568345],
Cell[CellGroupData[{
Cell[24546, 919, 135, 4, 70, "Input",
 CellID->6155808],
Cell[24684, 925, 233, 7, 50, "Output",
 CellID->216054973]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24966, 938, 239, 7, 70, "ExampleSection",
 CellID->23305],
Cell[25208, 947, 208, 7, 70, "ExampleText",
 CellID->22496],
Cell[CellGroupData[{
Cell[25441, 958, 233, 8, 70, "Input",
 CellID->24833],
Cell[25677, 968, 292, 11, 55, "Output",
 CellID->374899644]
}, Open  ]],
Cell[25984, 982, 120, 3, 70, "ExampleDelimiter",
 CellID->4852],
Cell[26107, 987, 80, 1, 70, "ExampleText",
 CellID->17879],
Cell[CellGroupData[{
Cell[26212, 992, 102, 3, 70, "Input",
 CellID->30519],
Cell[26317, 997, 283, 10, 36, "Output",
 CellID->183084446]
}, Open  ]],
Cell[CellGroupData[{
Cell[26637, 1012, 108, 3, 70, "Input",
 CellID->7793],
Cell[26748, 1017, 170, 5, 36, "Output",
 CellID->337295419]
}, Open  ]],
Cell[26933, 1025, 121, 3, 70, "ExampleDelimiter",
 CellID->21465],
Cell[27057, 1030, 195, 7, 70, "ExampleText",
 CellID->31371],
Cell[CellGroupData[{
Cell[27277, 1041, 325, 11, 70, "Input",
 CellID->15444],
Cell[27605, 1054, 624, 22, 54, "Output",
 CellID->355075933]
}, Open  ]],
Cell[28244, 1079, 121, 3, 70, "ExampleDelimiter",
 CellID->17271],
Cell[28368, 1084, 222, 7, 70, "ExampleText",
 CellID->24087],
Cell[CellGroupData[{
Cell[28615, 1095, 741, 25, 70, "Input",
 CellID->28099],
Cell[29359, 1122, 516, 18, 49, "Output",
 CellID->224248131]
}, Open  ]],
Cell[CellGroupData[{
Cell[29912, 1145, 94, 3, 70, "Input",
 CellID->8596],
Cell[30009, 1150, 479, 17, 36, "Output",
 CellID->616166503]
}, Open  ]],
Cell[CellGroupData[{
Cell[30525, 1172, 143, 5, 70, "Input",
 CellID->17552],
Cell[30671, 1179, 864, 28, 114, "Output",
 CellID->82054528]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31584, 1213, 222, 7, 70, "ExampleSection",
 CellID->8257],
Cell[31809, 1222, 74, 1, 70, "ExampleText",
 CellID->27590],
Cell[CellGroupData[{
Cell[31908, 1227, 421, 14, 70, "Input",
 CellID->13357],
Cell[32332, 1243, 2742, 49, 70, "Output",
 Evaluatable->False,
 CellID->184991932]
}, Open  ]],
Cell[35089, 1295, 120, 3, 70, "ExampleDelimiter",
 CellID->7809],
Cell[35212, 1300, 86, 1, 70, "ExampleText",
 CellID->5865],
Cell[CellGroupData[{
Cell[35323, 1305, 387, 13, 70, "Input",
 CellID->25686],
Cell[35713, 1320, 19220, 319, 70, "Output",
 Evaluatable->False,
 CellID->978280871]
}, Open  ]],
Cell[54948, 1642, 119, 3, 70, "ExampleDelimiter",
 CellID->259],
Cell[55070, 1647, 117, 3, 70, "ExampleText",
 CellID->22313],
Cell[CellGroupData[{
Cell[55212, 1654, 1467, 46, 70, "Input",
 CellID->2435],
Cell[56682, 1702, 2851, 51, 70, "Output",
 Evaluatable->False,
 CellID->264582055]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[59582, 1759, 233, 7, 70, "ExampleSection",
 CellID->4101],
Cell[59818, 1768, 141, 4, 70, "ExampleText",
 CellID->10468],
Cell[CellGroupData[{
Cell[59984, 1776, 119, 4, 70, "Input",
 CellID->22869],
Cell[60106, 1782, 186, 6, 36, "Output",
 CellID->55129158]
}, Open  ]],
Cell[CellGroupData[{
Cell[60329, 1793, 112, 4, 70, "Input",
 CellID->6731],
Cell[60444, 1799, 205, 7, 36, "Output",
 CellID->413116543]
}, Open  ]],
Cell[CellGroupData[{
Cell[60686, 1811, 118, 4, 70, "Input",
 CellID->26074],
Cell[60807, 1817, 241, 8, 36, "Output",
 CellID->226922585]
}, Open  ]],
Cell[CellGroupData[{
Cell[61085, 1830, 118, 4, 70, "Input",
 CellID->30843],
Cell[61206, 1836, 187, 6, 36, "Output",
 CellID->164775667]
}, Open  ]],
Cell[61408, 1845, 121, 3, 70, "ExampleDelimiter",
 CellID->13316],
Cell[61532, 1850, 559, 23, 70, "ExampleText",
 CellID->15024],
Cell[CellGroupData[{
Cell[62116, 1877, 148, 5, 70, "Input",
 CellID->30511],
Cell[62267, 1884, 186, 6, 36, "Output",
 CellID->31870758]
}, Open  ]],
Cell[CellGroupData[{
Cell[62490, 1895, 135, 4, 70, "Input",
 CellID->5722],
Cell[62628, 1901, 449, 16, 36, "Output",
 CellID->1054201942]
}, Open  ]],
Cell[63092, 1920, 121, 3, 70, "ExampleDelimiter",
 CellID->10057],
Cell[63216, 1925, 138, 4, 70, "ExampleText",
 CellID->14095],
Cell[CellGroupData[{
Cell[63379, 1933, 147, 5, 70, "Input",
 CellID->8174],
Cell[63529, 1940, 241, 8, 36, "Output",
 CellID->979254082]
}, Open  ]],
Cell[CellGroupData[{
Cell[63807, 1953, 99, 3, 70, "Input",
 CellID->2183],
Cell[63909, 1958, 240, 8, 36, "Output",
 CellID->326703542]
}, Open  ]],
Cell[64164, 1969, 121, 3, 70, "ExampleDelimiter",
 CellID->17295],
Cell[64288, 1974, 79, 1, 70, "ExampleText",
 CellID->25722],
Cell[CellGroupData[{
Cell[64392, 1979, 162, 6, 70, "Input",
 CellID->16983],
Cell[64557, 1987, 238, 8, 36, "Output",
 CellID->557572356]
}, Open  ]],
Cell[CellGroupData[{
Cell[64832, 2000, 163, 5, 70, "Input",
 CellID->29503],
Cell[64998, 2007, 204, 7, 36, "Output",
 CellID->62438309]
}, Open  ]],
Cell[65217, 2017, 121, 3, 70, "ExampleDelimiter",
 CellID->24300],
Cell[65341, 2022, 70, 1, 70, "ExampleText",
 CellID->15590],
Cell[CellGroupData[{
Cell[65436, 2027, 371, 12, 70, "Input",
 CellID->21480],
Cell[65810, 2041, 398, 13, 36, "Output",
 CellID->311413673]
}, Open  ]],
Cell[CellGroupData[{
Cell[66245, 2059, 137, 4, 70, "Input",
 CellID->32702],
Cell[66385, 2065, 585, 22, 58, "Output",
 CellID->39946379]
}, Open  ]],
Cell[66985, 2090, 120, 3, 70, "ExampleDelimiter",
 CellID->9818],
Cell[67108, 2095, 70, 1, 70, "ExampleText",
 CellID->10557],
Cell[CellGroupData[{
Cell[67203, 2100, 359, 13, 70, "Input",
 CellID->15561],
Cell[67565, 2115, 2838, 51, 70, "Output",
 Evaluatable->False,
 CellID->2612871]
}, Open  ]],
Cell[70418, 2169, 120, 3, 70, "ExampleDelimiter",
 CellID->5028],
Cell[70541, 2174, 66, 1, 70, "ExampleText",
 CellID->23656],
Cell[CellGroupData[{
Cell[70632, 2179, 248, 9, 70, "Input",
 CellID->25713],
Cell[70883, 2190, 871, 28, 63, "Output",
 CellID->27782428]
}, Open  ]],
Cell[CellGroupData[{
Cell[71791, 2223, 276, 10, 70, "Input",
 CellID->23092],
Cell[72070, 2235, 794, 26, 51, "Output",
 CellID->579624072]
}, Open  ]],
Cell[72879, 2264, 121, 3, 70, "ExampleDelimiter",
 CellID->26467],
Cell[73003, 2269, 92, 1, 70, "ExampleText",
 CellID->11320],
Cell[CellGroupData[{
Cell[73120, 2274, 425, 15, 70, "Input",
 CellID->7358],
Cell[73548, 2291, 227, 7, 36, "Output",
 CellID->262016900]
}, Open  ]],
Cell[73790, 2301, 120, 3, 70, "ExampleDelimiter",
 CellID->3987],
Cell[73913, 2306, 48, 1, 70, "ExampleText",
 CellID->9094],
Cell[CellGroupData[{
Cell[73986, 2311, 180, 6, 70, "Input",
 CellID->4983],
Cell[74169, 2319, 644, 22, 59, "Output",
 CellID->332290646]
}, Open  ]],
Cell[74828, 2344, 121, 3, 70, "ExampleDelimiter",
 CellID->19714],
Cell[74952, 2349, 221, 7, 70, "ExampleText",
 CellID->26746],
Cell[CellGroupData[{
Cell[75198, 2360, 1413, 45, 70, "Input",
 CellID->24390],
Cell[76614, 2407, 656, 21, 43, "Output",
 CellID->344935011]
}, Open  ]],
Cell[77285, 2431, 121, 3, 70, "ExampleDelimiter",
 CellID->26255],
Cell[77409, 2436, 87, 1, 70, "ExampleText",
 CellID->13163],
Cell[CellGroupData[{
Cell[77521, 2441, 344, 12, 70, "Input",
 CellID->31467],
Cell[77868, 2455, 322, 9, 36, "Output",
 CellID->232492695]
}, Open  ]],
Cell[CellGroupData[{
Cell[78227, 2469, 561, 20, 70, "Input",
 CellID->14231],
Cell[78791, 2491, 255, 7, 36, "Output",
 CellID->30616709]
}, Open  ]],
Cell[79061, 2501, 120, 3, 70, "ExampleDelimiter",
 CellID->2880],
Cell[79184, 2506, 185, 7, 70, "ExampleText",
 CellID->4718],
Cell[CellGroupData[{
Cell[79394, 2517, 104, 3, 70, "Input",
 CellID->16128],
Cell[79501, 2522, 244, 8, 36, "Output",
 CellID->8415262]
}, Open  ]],
Cell[CellGroupData[{
Cell[79782, 2535, 153, 5, 70, "Input",
 CellID->4720],
Cell[79938, 2542, 161, 5, 36, "Output",
 CellID->537850155]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[80148, 2553, 226, 7, 70, "ExampleSection",
 CellID->32091],
Cell[80377, 2562, 111, 3, 70, "ExampleText",
 CellID->3766],
Cell[CellGroupData[{
Cell[80513, 2569, 121, 4, 70, "Input",
 CellID->27587],
Cell[80637, 2575, 191, 6, 36, "Output",
 CellID->5396945]
}, Open  ]],
Cell[80843, 2584, 79, 1, 70, "ExampleText",
 CellID->12126],
Cell[CellGroupData[{
Cell[80947, 2589, 175, 6, 70, "Input",
 CellID->14825],
Cell[81125, 2597, 194, 5, 36, "Output",
 CellID->154690184]
}, Open  ]],
Cell[81334, 2605, 121, 3, 70, "ExampleDelimiter",
 CellID->17518],
Cell[81458, 2610, 229, 8, 70, "ExampleText",
 CellID->3220],
Cell[CellGroupData[{
Cell[81712, 2622, 176, 6, 70, "Input",
 CellID->10035],
Cell[81891, 2630, 526, 11, 70, "Message",
 CellID->51889726],
Cell[82420, 2643, 164, 5, 36, "Output",
 CellID->467060100]
}, Open  ]],
Cell[CellGroupData[{
Cell[82621, 2653, 308, 11, 70, "Input",
 CellID->29156],
Cell[82932, 2666, 201, 5, 36, "Output",
 CellID->21563219]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[83182, 2677, 224, 7, 70, "ExampleSection",
 CellID->11827],
Cell[CellGroupData[{
Cell[83431, 2688, 284, 10, 70, "Input",
 CellID->8186],
Cell[83718, 2700, 563, 20, 51, "Output",
 CellID->548508210]
}, Open  ]],
Cell[CellGroupData[{
Cell[84318, 2725, 190, 6, 70, "Input",
 CellID->388142573],
Cell[84511, 2733, 245, 8, 36, "Output",
 CellID->37998810]
}, Open  ]],
Cell[CellGroupData[{
Cell[84793, 2746, 219, 8, 70, "Input",
 CellID->52332370],
Cell[85015, 2756, 351, 11, 36, "Output",
 CellID->618305995]
}, Open  ]],
Cell[85381, 2770, 120, 3, 70, "ExampleDelimiter",
 CellID->1827],
Cell[CellGroupData[{
Cell[85526, 2777, 190, 6, 70, "Input",
 CellID->15169],
Cell[85719, 2785, 186, 6, 36, "Output",
 CellID->51663059]
}, Open  ]],
Cell[85920, 2794, 121, 3, 70, "ExampleDelimiter",
 CellID->14899],
Cell[86044, 2799, 192, 8, 70, "ExampleText",
 CellID->22514],
Cell[CellGroupData[{
Cell[86261, 2811, 467, 15, 70, "Input",
 CellID->10415],
Cell[86731, 2828, 3088, 55, 70, "Output",
 Evaluatable->False,
 CellID->994817233]
}, Open  ]],
Cell[89834, 2886, 120, 3, 70, "ExampleDelimiter",
 CellID->5436],
Cell[CellGroupData[{
Cell[89979, 2893, 185, 6, 70, "Input",
 CellID->23669],
Cell[90167, 2901, 1318, 48, 164, "Output",
 CellID->393125206]
}, Open  ]],
Cell[91500, 2952, 121, 3, 70, "ExampleDelimiter",
 CellID->31676],
Cell[91624, 2957, 80, 1, 70, "ExampleText",
 CellID->17858],
Cell[CellGroupData[{
Cell[91729, 2962, 83, 2, 70, "Input",
 CellID->7952],
Cell[91815, 2966, 423, 11, 36, "Output",
 CellID->338180379]
}, Open  ]],
Cell[92253, 2980, 121, 3, 70, "ExampleDelimiter",
 CellID->27137],
Cell[CellGroupData[{
Cell[92399, 2987, 161, 5, 70, "Input",
 CellID->5915],
Cell[92563, 2994, 161, 5, 36, "Output",
 CellID->17921877]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[92785, 3006, 311, 9, 70, "SeeAlsoSection",
 CellID->21154],
Cell[93099, 3017, 1646, 62, 70, "SeeAlso",
 CellID->18012]
}, Open  ]],
Cell[CellGroupData[{
Cell[94782, 3084, 314, 9, 70, "TutorialsSection",
 CellID->18908],
Cell[95099, 3095, 182, 4, 70, "Tutorials",
 CellID->20340]
}, Open  ]],
Cell[CellGroupData[{
Cell[95318, 3104, 320, 9, 70, "RelatedLinksSection",
 CellID->1360],
Cell[95641, 3115, 180, 4, 70, "RelatedLinks"],
Cell[95824, 3121, 195, 4, 70, "RelatedLinks"],
Cell[96022, 3127, 381, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[96440, 3145, 319, 9, 70, "MoreAboutSection",
 CellID->226500351],
Cell[96762, 3156, 157, 3, 70, "MoreAbout",
 CellID->213529647]
}, Open  ]],
Cell[96934, 3162, 27, 0, 70, "History"],
Cell[96964, 3164, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

