(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6533,        226]
NotebookOptionsPosition[      4803,        172]
NotebookOutlinePosition[      5882,        202]
CellTagsIndexPosition[      5839,        199]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Automatic Numbering" :> 
         Documentation`HelpLookup["paclet:ref/menuitem/AutomaticNumbering"], 
         "CounterFunction" :> 
         Documentation`HelpLookup["paclet:ref/CounterFunction"], 
         "CounterIncrements" :> 
         Documentation`HelpLookup["paclet:ref/CounterIncrements"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"Automatic Numbering\"\>", 
      2->"\<\"CounterFunction\"\>", 
      3->"\<\"CounterIncrements\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CounterAssignments", "ObjectName",
 CellID->3554],

Cell[TextData[{
 "This function has not been fully integrated into the long-term ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " system, and is subject to change.  "
}], "AwaitingReviewNote",
 CellID->62951132],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["CounterAssignments",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/CounterAssignments"]], "InlineFormula"],
     "\[LineSeparator]is an option for selections that sets the value of a \
specified counter."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19443]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"CounterAssignments", "->", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Counter1\>\"", ",", "\"\<\!\(\*
StyleBox[\"m\", \"TI\"]\)\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Counter2\>\"", ",", "\"\<\!\(\*
StyleBox[\"n\", \"TI\"]\)\>\""}], "}"}]}], "}"}]}]], "InlineFormula"],
 "} assigns the values ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " to ",
 Cell[BoxData["Counter1"], "InlineFormula"],
 " and ",
 Cell[BoxData["Counter2"], "InlineFormula"],
 ", respectively."
}], "Notes",
 CellID->6824],

Cell[TextData[{
 Cell["CounterAssignments", "InlineFormula"],
 " is usually defined for particular cell styles in the stylesheet, but it \
can also be defined for an individual cell."
}], "Notes",
 CellID->31999]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19917],

Cell[TextData[{
 StyleBox[ButtonBox["Automatic Numbering",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/menuitem/AutomaticNumbering"], "MenuName",
  FontFamily->"Verdana"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CounterFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CounterFunction"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CounterIncrements",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CounterIncrements"],
   FontFamily->"Verdana"]], "InlineFormula"],
 " "
}], "SeeAlso",
 CellID->12657228]
}, Open  ]],

Cell["New in 4.0", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CounterAssignments - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 35, 31.3007068}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CounterAssignments is an option for selections that sets the value of a \
specified counter.", "synonyms" -> {"counter assignments"}, "title" -> 
    "CounterAssignments", "type" -> "Symbol", "uri" -> 
    "ref/CounterAssignments"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 873, 20, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1496, 47, 55, 1, 70, "ObjectName",
 CellID->3554],
Cell[1554, 50, 217, 6, 70, "AwaitingReviewNote",
 CellID->62951132],
Cell[1774, 58, 476, 14, 70, "Usage",
 CellID->19443]
}, Open  ]],
Cell[CellGroupData[{
Cell[2287, 77, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2765, 94, 663, 23, 70, "Notes",
 CellID->6824],
Cell[3431, 119, 212, 5, 70, "Notes",
 CellID->31999]
}, Closed]],
Cell[CellGroupData[{
Cell[3680, 129, 311, 9, 70, "SeeAlsoSection",
 CellID->19917],
Cell[3994, 140, 735, 25, 70, "SeeAlso",
 CellID->12657228]
}, Open  ]],
Cell[4744, 168, 29, 0, 70, "History"],
Cell[4776, 170, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

