(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     69349,       1769]
NotebookOptionsPosition[     61954,       1527]
NotebookOutlinePosition[     63860,       1576]
CellTagsIndexPosition[     63740,       1570]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DocumentNotebook" :> 
          Documentation`HelpLookup["paclet:ref/DocumentNotebook"], 
          "PopupWindow" :> Documentation`HelpLookup["paclet:ref/PopupWindow"],
           "WindowSize" :> Documentation`HelpLookup["paclet:ref/WindowSize"], 
          "WindowMargins" :> 
          Documentation`HelpLookup["paclet:ref/WindowMargins"], "Saveable" :> 
          Documentation`HelpLookup["paclet:ref/Saveable"], "CreatePalette" :> 
          Documentation`HelpLookup["paclet:ref/CreatePalette"], 
          "CreateDialog" :> 
          Documentation`HelpLookup["paclet:ref/CreateDialog"], "NotebookOpen" :> 
          Documentation`HelpLookup["paclet:ref/NotebookOpen"], 
          "NotebookClose" :> 
          Documentation`HelpLookup["paclet:ref/NotebookClose"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DocumentNotebook\"\>", 
       2->"\<\"PopupWindow\"\>", 3->"\<\"WindowSize\"\>", 
       4->"\<\"WindowMargins\"\>", 5->"\<\"Saveable\"\>", 
       6->"\<\"CreatePalette\"\>", 7->"\<\"CreateDialog\"\>", 
       8->"\<\"NotebookOpen\"\>", 
       9->"\<\"NotebookClose\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Low-Level Interface Control" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelInterfaceControl"], 
          "Palettes" :> Documentation`HelpLookup["paclet:guide/Palettes"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Document Generation\"\>", 
       2->"\<\"Low-Level Interface Control\"\>", 3->"\<\"Palettes\"\>", 
       4->"\<\"Stand-Alone Interfaces\"\>", 
       5->"\<\"New in 6.0: Notebooks & Documents\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CreateDocument", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CreateDocument",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CreateDocument"], "[", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]creates an empty document notebook, and opens it in the \
front end."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CreateDocument",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CreateDocument"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]creates and opens a document notebook containing the \
expression ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CreateDocument",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CreateDocument"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]creates and opens a document notebook consisting of a \
sequence of cells containing the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CreateDocument",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CreateDocument"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["obj", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]replaces the notebook represented by the notebook \
object ",
     Cell[BoxData[
      StyleBox["obj", "TI"]], "InlineFormula"],
     " with the one obtained from ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Possible forms for ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " include:"
}], "Notes",
 CellID->312356304],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["DocumentNotebook",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DocumentNotebook"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[
    "a complete notebook", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["TextCell",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TextCell"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell["a text cell", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["ExpressionCell",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpressionCell"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[
    "an expression cell", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["CellGroup",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CellGroup"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[
    "a cell group, potentially nested", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", Cell[
    "a string, inside a text cell", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["e", "TI"], Cell[TextData[{
     "an expression ",
     Cell[BoxData[
      StyleBox["e", "TI"]], "InlineFormula"],
     ", in an expression cell"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->54695456],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreateDocument",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDocument"]], "InlineFormula"],
 " can take any notebook option, together with the following additional \
options:"
}], "Notes",
 CellID->278614600],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "WindowSelected", 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether the new window should immediately be selected", "TableText"]},
   {Cell["      ", "TableRowIcon"], "NotebookFileName", 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "the file name for the document created", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->33463124],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreateDocument",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDocument"]], "InlineFormula"],
 " will by default create a notebook with name ",
 Cell[BoxData["\"\<Untitled-\!\(\*
StyleBox[\"n\", \"TI\"]\)\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3696],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreateDocument",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDocument"]], "InlineFormula"],
 " returns a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " corresponding to the notebook it creates. "
}], "Notes",
 CellID->319373478],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CreateDocument",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDocument"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["obj", "TI"]}], "]"}]], "InlineFormula"],
 " overwrites whatever data was contained in the notebook represented by the \
notebook object ",
 Cell[BoxData[
  StyleBox["obj", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28785]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20535380],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->22503696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{
      RowBox[{"1", "/", "x"}], "+", 
      RowBox[{"1", "/", "y"}]}]}], "}"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56057613],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d9TlNcdx3Eyve/kX8i/0h+3OunkJu1MIzaiaSbj2OlFZjqTi0xM2thk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   "], {{0, 0}, {458, 99}}, {0, 255}],
  ImageSize->{458 0.75, 99 0.75},
  PlotRange->{{0, 458}, {0, 99}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->369624756]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->46740633],

Cell["Specify styles for cells:", "ExampleText",
 CellID->7382880],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"TextCell", "[", 
      RowBox[{"\"\<The head\>\"", ",", "\"\<Section\>\""}], "]"}], ",", 
     RowBox[{"TextCell", "[", "\"\<first cell\>\"", "]"}]}], "}"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18467],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f1TVNcdx3E6/b2Tf6H/idOHH9VJJr+kmWnEqUjSyTjt5Lc47UymJm00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   "], {{0, 0}, {458, 127}}, {0, 255}],
  ImageSize->{458 0.75, 127 0.75},
  PlotRange->{{0, 458}, {0, 127}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->206180762]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18365327],

Cell["Create a notebook with a two-dimensional typeset expression:", \
"ExampleText",
 CellID->339165482],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"TextCell", "[", 
      RowBox[{"\"\<S1\>\"", ",", "\"\<Section\>\""}], "]"}], ",", 
     RowBox[{"ExpressionCell", "[", 
      RowBox[{
       RowBox[{"x", "^", "2"}], ",", "\"\<Input\>\""}], "]"}]}], "}"}], "]"}],
   ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132857053],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3e9vU9cdx3FPez71X9jz/RFoPx4CatUnXaWVoBHSThVq1QeTau0BGu1W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   "], {{0, 0}, {458, 130}}, {0, 255}],
  ImageSize->{458 0.75, 130 0.75},
  PlotRange->{{0, 458}, {0, 130}}]], "NotebookImage",
 CellID->375384021]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->184003782],

Cell["Create a document containing an unevaluated expression:", "ExampleText",
 CellID->311273947],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{"Defer", "[", 
    RowBox[{"1", "+", "1"}], "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->249292979],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPlEcch2l63/gV+kma9HCraeNN26SCKWDbGGPTiyZNemGqtlKb4gFE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   "], {{0, 0}, {458, 63}}, {0, 255}],
  ImageSize->{458 0.75, 63 0.75},
  PlotRange->{{0, 458}, {0, 63}}]], "NotebookImage",
 CellID->147151870]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->903491740],

Cell["Create a notebook with a graphic:", "ExampleText",
 CellID->673890765],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"x", "^", "2"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "]"}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->140915099],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnf9vFGd+gF319+r+hf4rTe+HqlJQqjudWkQvmIaYOx3oKpCqIFVwaqC9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   "], {{0, 0}, {458, 207}}, {0, 255}],
  ImageSize->{458 0.75, 207 0.75},
  PlotRange->{{0, 458}, {0, 207}}]], "NotebookImage",
 CellID->12578911]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->465664839],

Cell["Create a notebook with a grid:", "ExampleText",
 CellID->195972657],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{"Grid", "[", 
    RowBox[{"Array", "[", 
     RowBox[{"a", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], "]"}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->250450915],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztne9PW9cZxz3t/dR/Yf/Kfr1MtKlvtklriBaSrqqqTnsxadJeVEu7Neu0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   "], {{0, 0}, {458, 70}}, {0, 255}],
  ImageSize->{458 0.75, 70 0.75},
  PlotRange->{{0, 458}, {0, 70}}]], "NotebookImage",
 CellID->65102042]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->54058442],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->38637084],

Cell["Set a background color:", "ExampleText",
 CellID->1492460]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "CellDingbat",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->151637147],

Cell["Set a cell dingbat:", "ExampleText",
 CellID->518136766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"CellDingbat", "\[Rule]", "\"\<\[MathematicaIcon]\>\""}]}], "]"}],
   ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->213796355],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d9TlFUcx3Ga7pv+hf6Vftzq1HRTzZQ4iVbjODZdNNNMF032y2oyFcQQ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   "], {{0, 0}, {458, 91}}, {0, 255}],
  ImageSize->{458 0.75, 91 0.75},
  PlotRange->{{0, 458}, {0, 91}}]], "NotebookImage",
 CellID->107424529]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "CellGrouping",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->294034374],

Cell["Make a document with manually grouped cells:", "ExampleText",
 CellID->555911444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"CellGroup", "[", 
       RowBox[{"{", 
        RowBox[{"\"\<a\>\"", ",", "\"\<b\>\""}], "}"}], "]"}], ",", 
      "\"\<c\>\""}], "}"}], ",", 
    RowBox[{"CellGrouping", "\[Rule]", "Manual"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49046929],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3f9TVNUfx3Gafm/6F/pX+vJrjE2/WDMpTiLWOE6NvzXTD072zWryG6gJ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   "], {{0, 0}, {458, 116}}, {0, 255}],
  ImageSize->{458 0.75, 116 0.75},
  PlotRange->{{0, 458}, {0, 116}}]], "NotebookImage",
 CellID->538473428]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TextAlignment",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->7024970],

Cell["Align contents on the right:", "ExampleText",
 CellID->147918168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<a\>\"", ",", "\"\<b\>\""}], "}"}], ",", 
    RowBox[{"TextAlignment", "\[Rule]", "Right"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->450162015],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etPVEccxnGavm/8F/qv9PJWYtM3tkkVU0DbGNOm75r0hanaam2KF/AG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   "], {{0, 0}, {458, 89}}, {0, 255}],
  ImageSize->{458 0.75, 89 0.75},
  PlotRange->{{0, 458}, {0, 89}}]], "NotebookImage",
 CellID->120184258]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Visible",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->341074678],

Cell["Create a notebook that is not visible:", "ExampleText",
 CellID->54936393],

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<a\>\"", ",", "\"\<b\>\""}], "}"}], ",", 
     RowBox[{"Visible", "\[Rule]", "False"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->698794166],

Cell["Make the notebook appear:", "ExampleText",
 CellID->143624510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetOptions", "[", 
  RowBox[{"nb", ",", 
   RowBox[{"Visible", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->113871627],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etPVEccxnGavm/8F/qv9PJWYtMXtU0qmILYxpg2fdekL0zVVmtTbyCK
qBRQEEWgomK5yGVZFlwuC7Igiy2spqh4SzFaoKdzdvbMzjm7KsoOmPX7yVMy
v5k5p7x6siHN9t2NWz/a+HZWVtYn4p/AW1lZ9jo//3tCCCEmMr+wSAghJI1R
7Xqq6jIhhJC0xNOuq/4RmhBCMiAp29UCACxDvvO3VtoVANKIdgUAE2hXADCB
dgUAE2hXADCBdgUAE2hXADCBdgUAE2hXADCBdgUAE2hXAHhl337X8OHaYpl1
64/pR7QrAKSFKFh9pF0BIC0yu12zHKv9iwB442Rwu+qlSsECWGG0KwCYQLsC
gAmZ3a6qVGlXACsss9vVcncsAKyYjG9XAFgVtCsAmEC7AoAJGdyuALDyEl81
kE27AkD68dkVANJF/46sgq01+hHtCgAm0K4AYALtCgAm0K4AYALtCgAm0K4A
YALtCgAm0K4AYALtCgAm0K4AYALtCgAm0K4AYALtCgAm0K4AYALtCgCvTP8G
wnXrj+lHtCsApAXfng0AJmR2u2ZpVvt3AfBmyeB2VY1KtQJYebQrAJiQwe1q
aX8ZWO1fBMAbJ4Pblc+uAFZRBrer5Xx2Xe3fAsCbKLPbFQBWC+0KACbQrgBg
Au0KAGmU+KqBbNoVANKPz64AkC76d2QVbK3Rj2hXADCBdgUAE2hXADCBdgUA
E2hXADCBdgUAE2hXADBBb9evtuyOTPxZ1+DftbucEELIMjP/77zPP/r1N3vz
t+wR7SoyNjZJCCFkmdHbdSw8bVmLi4sLhBBClpP/Fhf0dr02MjU/vzD3+InI
41ji6znx86ka5+biF8SmuqzWeh4zMjIyvqbjS3faoZKqox+/V5n9fkX2B8kR
++JU3JEPPnnydG7uqWrXocEbDx/N3Z19eHf2QeznQ2f9wLu+p19Q99XmI/cp
IyMj42s1vkqn1X+8dmH/Aet4mVVamiLHy8SpuCMfnL1nP6Latb9/4tbfs1PR
O1PTM++sWaNnKjozFb0dX0/r69si2rU7zuK2Wssxsa/dT3k58ebYZXkqF96n
3KeMjIyMSxrtEpuJbcqdGWffSfxoxn7KecP1TblW43mrtvqZaTwv7shnp2/e
mY7eVe3a2zc+cePW2PVpWV9iIeOM0cT+eOKOs5iKXY7fGXe9ZEofPS/3nIrR
fcE+1S8//5SRkZHxhaOziCY2x92jvZ7S7thvGM/PterrrNMn4//RlVjIqLG+
TtyJPRIdn4hej9xS7ervCYdGbgyGIrLBxGIgFNFHtUi1OZlyf8D9kgH3y5NP
B9xreapffv4pIyMj4xLHQfc6KZP6U2LhbVehRls77SqfGhqODF/7S7WrWPQG
w4Gro7LBevrC/t5wT19idBaj+jq+uBru6R1NjL3qqdGAuK+Nnr8AJF+Wa7/7
pt/+l7pO1ZvFgpGRkXHpY6AvLNLj/Oyx98P2fqzx5GXVaeoN4/k5Vn2tVV1h
x6PymFVRap2tEu3aI995NRwcmFDt2uUb6fSFOnwh2WBi0dEVavcNxccu175n
sz222dGlLg8l9n0hfVQPtj/jcnzdNaSelZeXcsrIyMi4hDG+I9aJnfh+PKrT
1BvGvthg92rZEavssHVC+z8RlBZaRw9YR/aJgh3L2+A8MuQPhFuvDMp27fSN
tLT1i8gGa75ir1uuBOWo9lX0y85O0LPwjM1t/c3uR5rtlwRTvTwoL8tTNT7/
lJGRkXEJY3ynOb7vinbf9Qa7XcuPWsV7rUN7vZ9d9++x9v1sHS0W7are0+kb
/r3RL9u1o2v4YlPPpcsB2WBiISPHi5d7L9kJXGoKiLU9NvVql2NH9n4gdlM9
lXr0XNZH9cLkU9W9z3qWkZGR8YXjxcR+ik6Tp8mdNpaXY5UWL/y6W3Xq018S
68c/7bSKDo7n5cSeDVxsCrS1D5yqbom3a+dwQ6Pv/AW/bDCxkPGMnrhPu9Wo
7Xcnj1q8o+eFL3XKyMjI+JLj89Otftp/dy06+GjnDlmn//y441Escry/fbt1
8IC4o55tbg2WlDY47TpSW9dd1+A3EdmK6b1JCCErlkhBrlVYeHfbtvvbf0iO
2LeKCiObcuTlc/X+pj/69+6vjrdrx7Wa051nz/gIIYR4Etz8qXW4yCoSKUyR
wkLrcEnfl5/Ly2dqfBcag7t2l8t2bWsLlZ1orixvJYQQ4smhkqr+vM8mN2+c
2JSbnMmC3OCmXHFHXq74reVcrZ92JYSQ9IZ2JYQQE6FdCSHERDzt2t4RKi9r
PlnZSgghZDmprGipr0u063T0XmTydmRyhhBCyDJz8+YD1a6EEELSG9Gu/wMl
4h98
   "], {{0, 0}, {458, 88}}, {0, 255}],
  ImageSize->{458 0.75, 88 0.75},
  PlotRange->{{0, 458}, {0, 88}}]], "NotebookImage",
 CellID->1349620]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->307884368],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreateDocument",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDocument"]], "InlineFormula"],
 " combines the functions of ",
 Cell[BoxData[
  ButtonBox["DocumentNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DocumentNotebook"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["CreateWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateWindow"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->299951754],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"DocumentNotebook", "[", "\"\<abc\>\"", "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156402489],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPVFcYhml63/gX+ldse6tp403bpIIpoG2MadO7Jr0wVVupTfEAooBK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   "], {{0, 0}, {458, 66}}, {0, 255}],
  ImageSize->{458 0.75, 66 0.75},
  PlotRange->{{0, 458}, {0, 66}}]], "NotebookImage",
 CellID->77397584]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", "\"\<abc\>\"", "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->148526580],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnd1Pk1ccx1l2v/gv7F9x261mizfbkglmgG4xZsvuluzCTN1kLsMXEAVU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   "], {{0, 0}, {458, 66}}, {0, 255}],
  ImageSize->{458 0.75, 66 0.75},
  PlotRange->{{0, 458}, {0, 66}}]], "NotebookImage",
 CellID->188456746]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DocumentNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DocumentNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PopupWindow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupWindow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowSize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowMargins"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Saveable",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Saveable"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreatePalette",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreatePalette"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookOpen",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookOpen"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookClose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookClose"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->120740508],

Cell[TextData[ButtonBox["Low-Level Interface Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelInterfaceControl"]], "MoreAbout",
 CellID->7922457],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->28629533],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->50086189],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->327333595]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CreateDocument - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 35, 59.1607950}", "context" -> "System`", 
    "keywords" -> {"create notebook", "make notebook object"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "CreateDocument[] creates an empty document notebook, and opens it in the \
front end. CreateDocument[expr] creates and opens a document notebook \
containing the expression expr. CreateDocument[{expr_1, expr_2, ...}] creates \
and opens a document notebook consisting of a sequence of cells containing \
the expr_i. CreateDocument[expr, obj] replaces the notebook represented by \
the notebook object obj with the one obtained from expr.", 
    "synonyms" -> {"create document"}, "title" -> "CreateDocument", "type" -> 
    "Symbol", "uri" -> "ref/CreateDocument"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11742, 349, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->20535380]},
 "Notebook Image"->{
  Cell[12583, 384, 2971, 51, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->369624756],
  Cell[16115, 460, 3491, 60, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->206180762]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 63367, 1556},
 {"Notebook Image", 63508, 1560}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2734, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3357, 84, 1579, 37, 70, "ObjectNameGrid"],
Cell[4939, 123, 2231, 70, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[7207, 198, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7685, 215, 258, 11, 70, "Notes",
 CellID->312356304],
Cell[7946, 228, 1664, 44, 70, "2ColumnTableMod",
 CellID->54695456],
Cell[9613, 274, 263, 8, 70, "Notes",
 CellID->278614600],
Cell[9879, 284, 688, 17, 70, "3ColumnTableMod",
 CellID->33463124],
Cell[10570, 303, 316, 10, 70, "Notes",
 CellID->3696],
Cell[10889, 315, 373, 12, 70, "Notes",
 CellID->319373478],
Cell[11265, 329, 440, 15, 70, "Notes",
 CellID->28785]
}, Closed]],
Cell[CellGroupData[{
Cell[11742, 349, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20535380],
Cell[CellGroupData[{
Cell[12126, 363, 147, 5, 70, "ExampleSection",
 CellID->22503696],
Cell[CellGroupData[{
Cell[12298, 372, 282, 10, 70, "Input",
 CellID->56057613],
Cell[12583, 384, 2971, 51, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->369624756]
}, Open  ]],
Cell[15569, 438, 124, 3, 70, "ExampleDelimiter",
 CellID->46740633],
Cell[15696, 443, 66, 1, 70, "ExampleText",
 CellID->7382880],
Cell[CellGroupData[{
Cell[15787, 448, 325, 10, 70, "Input",
 CellID->18467],
Cell[16115, 460, 3491, 60, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->206180762]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19655, 526, 219, 7, 70, "ExampleSection",
 CellID->18365327],
Cell[19877, 535, 105, 2, 70, "ExampleText",
 CellID->339165482],
Cell[CellGroupData[{
Cell[20007, 541, 379, 12, 70, "Input",
 CellID->132857053],
Cell[20389, 555, 3267, 56, 70, "NotebookImage",
 CellID->375384021]
}, Open  ]],
Cell[23671, 614, 125, 3, 70, "ExampleDelimiter",
 CellID->184003782],
Cell[23799, 619, 98, 1, 70, "ExampleText",
 CellID->311273947],
Cell[CellGroupData[{
Cell[23922, 624, 186, 6, 70, "Input",
 CellID->249292979],
Cell[24111, 632, 2410, 42, 70, "NotebookImage",
 CellID->147151870]
}, Open  ]],
Cell[26536, 677, 125, 3, 70, "ExampleDelimiter",
 CellID->903491740],
Cell[26664, 682, 76, 1, 70, "ExampleText",
 CellID->673890765],
Cell[CellGroupData[{
Cell[26765, 687, 299, 11, 70, "Input",
 CellID->140915099],
Cell[27067, 700, 7259, 121, 70, "NotebookImage",
 CellID->12578911]
}, Open  ]],
Cell[34341, 824, 125, 3, 70, "ExampleDelimiter",
 CellID->465664839],
Cell[34469, 829, 73, 1, 70, "ExampleText",
 CellID->195972657],
Cell[CellGroupData[{
Cell[34567, 834, 277, 10, 70, "Input",
 CellID->250450915],
Cell[34847, 846, 2921, 50, 70, "NotebookImage",
 CellID->65102042]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37817, 902, 221, 7, 70, "ExampleSection",
 CellID->54058442],
Cell[CellGroupData[{
Cell[38063, 913, 230, 7, 70, "ExampleSubsection",
 CellID->38637084],
Cell[38296, 922, 64, 1, 70, "ExampleText",
 CellID->1492460]
}, Closed]],
Cell[CellGroupData[{
Cell[38397, 928, 232, 7, 70, "ExampleSubsection",
 CellID->151637147],
Cell[38632, 937, 62, 1, 70, "ExampleText",
 CellID->518136766],
Cell[CellGroupData[{
Cell[38719, 942, 272, 9, 70, "Input",
 CellID->213796355],
Cell[38994, 953, 2812, 48, 70, "NotebookImage",
 CellID->107424529]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41855, 1007, 233, 7, 70, "ExampleSubsection",
 CellID->294034374],
Cell[42091, 1016, 87, 1, 70, "ExampleText",
 CellID->555911444],
Cell[CellGroupData[{
Cell[42203, 1021, 377, 12, 70, "Input",
 CellID->49046929],
Cell[42583, 1035, 2844, 49, 70, "NotebookImage",
 CellID->538473428]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[45476, 1090, 232, 7, 70, "ExampleSubsection",
 CellID->7024970],
Cell[45711, 1099, 71, 1, 70, "ExampleText",
 CellID->147918168],
Cell[CellGroupData[{
Cell[45807, 1104, 266, 8, 70, "Input",
 CellID->450162015],
Cell[46076, 1114, 2568, 44, 70, "NotebookImage",
 CellID->120184258]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[48693, 1164, 228, 7, 70, "ExampleSubsection",
 CellID->341074678],
Cell[48924, 1173, 80, 1, 70, "ExampleText",
 CellID->54936393],
Cell[49007, 1176, 289, 9, 70, "Input",
 CellID->698794166],
Cell[49299, 1187, 68, 1, 70, "ExampleText",
 CellID->143624510],
Cell[CellGroupData[{
Cell[49392, 1192, 169, 5, 70, "Input",
 CellID->113871627],
Cell[49564, 1199, 2583, 45, 70, "NotebookImage",
 CellID->1349620]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[52208, 1251, 237, 7, 70, "ExampleSection",
 CellID->307884368],
Cell[52448, 1260, 494, 17, 70, "ExampleText",
 CellID->299951754],
Cell[CellGroupData[{
Cell[52967, 1281, 183, 6, 70, "Input",
 CellID->156402489],
Cell[53153, 1289, 2397, 42, 70, "NotebookImage",
 CellID->77397584]
}, Open  ]],
Cell[CellGroupData[{
Cell[55587, 1336, 138, 4, 70, "Input",
 CellID->148526580],
Cell[55728, 1342, 2418, 42, 70, "NotebookImage",
 CellID->188456746]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[58207, 1391, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[58526, 1402, 2242, 80, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[60805, 1487, 299, 8, 70, "MoreAboutSection"],
Cell[61107, 1497, 149, 3, 70, "MoreAbout",
 CellID->120740508],
Cell[61259, 1502, 161, 3, 70, "MoreAbout",
 CellID->7922457],
Cell[61423, 1507, 127, 3, 70, "MoreAbout",
 CellID->28629533],
Cell[61553, 1512, 153, 3, 70, "MoreAbout",
 CellID->50086189],
Cell[61709, 1517, 173, 3, 70, "MoreAbout",
 CellID->327333595]
}, Open  ]],
Cell[61897, 1523, 27, 0, 70, "History"],
Cell[61927, 1525, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

