(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     54774,       1503]
NotebookOptionsPosition[     48527,       1296]
NotebookOutlinePosition[     50038,       1336]
CellTagsIndexPosition[     49952,       1331]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CreateDialog" :> 
          Documentation`HelpLookup["paclet:ref/CreateDialog"], 
          "PaletteNotebook" :> 
          Documentation`HelpLookup["paclet:ref/PaletteNotebook"], 
          "PasteButton" :> Documentation`HelpLookup["paclet:ref/PasteButton"],
           "Button" :> Documentation`HelpLookup["paclet:ref/Button"], 
          "CreateDocument" :> 
          Documentation`HelpLookup["paclet:ref/CreateDocument"], 
          "CreateWindow" :> 
          Documentation`HelpLookup["paclet:ref/CreateWindow"], 
          "NotebookClose" :> 
          Documentation`HelpLookup["paclet:ref/NotebookClose"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CreateDialog\"\>", 
       2->"\<\"PaletteNotebook\"\>", 3->"\<\"PasteButton\"\>", 
       4->"\<\"Button\"\>", 5->"\<\"CreateDocument\"\>", 
       6->"\<\"CreateWindow\"\>", 
       7->"\<\"NotebookClose\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Creating Inspectors" :> 
          Documentation`HelpLookup["paclet:guide/CreatingInspectors"], 
          "Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], "Palettes" :> 
          Documentation`HelpLookup["paclet:guide/Palettes"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Creating Inspectors\"\>", 
       2->"\<\"Custom Interface Construction\"\>", 3->"\<\"Palettes\"\>", 
       4->"\<\"Stand-Alone Interfaces\"\>", 
       5->"\<\"New in 6.0: Dynamic Interactivity\"\>"}, "\<\"more about\"\>", 
       
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CreatePalette", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CreatePalette",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CreatePalette"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]creates a palette notebook containing ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", and opens it in the front end."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CreatePalette",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CreatePalette"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["expr", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]creates and opens a palette notebook consisting of a \
sequence of cells containing the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["expr", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CreatePalette",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CreatePalette"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["obj", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]replaces the notebook represented by the notebook \
object ",
     Cell[BoxData[
      StyleBox["obj", "TI"]], "InlineFormula"],
     " with the one obtained from ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->32053]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreatePalette",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreatePalette"]], "InlineFormula"],
 " by default creates a notebook with options set so as to be suitable for \
the appearance and behavior of a typical palette. The option settings include \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Deployed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Deployed"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ShowCellBracket",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowCellBracket"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowFloating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowFloating"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WindowSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowSize"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->18135],

Cell[TextData[{
 "Palette notebooks created by ",
 Cell[BoxData[
  ButtonBox["CreatePalette",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreatePalette"]], "InlineFormula"],
 " are by default opened on the top right of the main display screen. \
Explicit settings for ",
 Cell[BoxData[
  ButtonBox["WindowMargins",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WindowMargins"]], "InlineFormula"],
 " override this."
}], "Notes",
 CellID->12258],

Cell[TextData[{
 "Possible forms for ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["expr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " include:"
}], "Notes",
 CellID->312356304],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["DocumentNotebook",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/DocumentNotebook"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[
    "a complete notebook", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["TextCell",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TextCell"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell["a text cell", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["ExpressionCell",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ExpressionCell"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[
    "an expression cell", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{
     ButtonBox["CellGroup",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/CellGroup"], "[", 
     StyleBox["\[Ellipsis]", "TR"], "]"}], Cell[
    "a cell group, potentially nested", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", Cell[
    "a string, inside a text cell", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["e", "TI"], Cell[TextData[{
     "an expression ",
     Cell[BoxData[
      StyleBox["e", "TI"]], "InlineFormula"],
     ", in an expression cell"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->256271009],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreatePalette",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreatePalette"]], "InlineFormula"],
 " can take any notebook option."
}], "Notes",
 CellID->18140],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreatePalette",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreatePalette"]], "InlineFormula"],
 " returns a ",
 Cell[BoxData[
  ButtonBox["NotebookObject",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NotebookObject"]], "InlineFormula"],
 " corresponding to the notebook it creates. "
}], "Notes",
 CellID->16466],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CreatePalette",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreatePalette"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["obj", "TI"]}], "]"}]], "InlineFormula"],
 " overwrites whatever data was contained in the notebook represented by the \
notebook object ",
 Cell[BoxData[
  StyleBox["obj", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22951]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->32834997],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->755307293],

Cell["Create a palette:", "ExampleText",
 CellID->69177635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreatePalette", "[", 
   RowBox[{"PasteButton", "[", "\[Alpha]", "]"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->175969606],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztlFtPE0EUgJv4bvgDPvjsv1CfJTE8aSItsS2YGP+BD0RARYzcthTaipUW
qFykCHJJuC3dbEuh0At0S7eQbn3gjsQ2JbaOZzps2fQSjWxjSJh8Ozln9pwv
s5PdvVn17H7VNYVCcQuuG3DhWKN5XiJ+ptLyktX29U/LRY5WlgcvqN3eEv4G
VGRkz/NK+1+0CsmQS5tVkSDHLJe2FLuV8RByHl+uQ8jfqtR8Qe0lem+vtBfX
8uHt14098sKwG6DluIi8gJYLCul0SkZ+pVOgXQ9E44lkIpHEcxzP8biYJpId
hn5jxW1r+R1L+d18YB3uQk1crI8nTpPJU9B617b2D76LHGc4T+0V91Ktbajb
jEymAnSb4S7UiL246+DwBLQeTzga24sKu3iO7VwvK5OyqVWh8TE0bCvK+BjU
RIWdaGw3I9kVvu2Bdskd4jYFAlFl4hhJQxoVso+gT71n7xAEhGxqH4Ea0RCF
xlA4BlrWGVzz8at+ftXHEy2khAJaGAOSWNSuii2A18+DFnAtb7jcG+xSkGid
bpzCnNEqkX0Y2SyYnGF9jywmNNQPWqc7yILBHYTAuRwEp4MJ0IyPdnhph49o
cYpXcMo9rsRCcxcyd6IP+nOniULGNtTVAmZOXQnFwALxMN7Z+bVFJjAz5yEQ
rTTF2h4j0jejjubc3bY2oZY3yKgH7VnL/Fnjl3GWdvgnp12T00swE+3klGtC
TDm1Epn0qXeNWdnp2/M48aoB6dpDauWEaIBgYsrVZ5uhF/1jX1kC0UpTfLa6
9pOGeuL58bL+JANJj+rqUHsb1GRbCAbTKL0YGBlli8FXqxBF7dfWHtW9yAfW
kY7itUppy2c729xqo+n1oUGmGCs1D1CnDukAqgAUhToN7iePpC2DAwz8xObm
fNae2WLA9+5RP4zUVIW1qnwi1aoVrQpqpC2WjzN/1P4Dl1G7QPt6rbMyYrVg
rRA75CM78gJazdOmUvAbT4z2Ew==
   "], {{0, 0}, {29, 43}}, {0, 255}],
  ImageSize->{29 0.75, 43 0.75},
  PlotRange->{{0, 29}, {0, 43}}]], "NotebookImage",
 CellID->681078895]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8543725],

Cell["Create a palette with a column of buttons:", "ExampleText",
 CellID->248519753],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreatePalette", "[", 
   RowBox[{"Column", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PasteButton", "[", "\[Alpha]", "]"}], ",", 
      RowBox[{"PasteButton", "[", "\[Beta]", "]"}]}], "}"}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->366017690],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztlVtPE0EUgJv4bvgDPvhTvDxLYnjSRFpiWzAx/gMfiICKGLltKdCKtS1Q
uUgR5JJwW7rZlkKhF+iWbiFtfeCuxDYlto5nO2zZlBaJTE2qTL6dzNk958vs
7O7s9YondyuuyGSyG3Bcg0MYq1RPC8SPZIosGW1P7yQpsrREbjyndnMjch5Q
npZZz0vtGVp4nws02zPMF9fKxEZQK7VJxxd8ZMWoJbu2WZMkONvCaQu0CMQ/
h/9Wmy//nO3f0BbXI7vU/h2tTNJIabO2WVIbY87dm6yW4CJk3T7Zv4N0qsT/
ZUXx3l5qL67lg5sv641kYdg10HJciCyg5fyRVCpJkJ+pJGhXfeFYPBGPJ4Q+
JvSxmBjGE22dvbqym+bSW6bS26eB83AVcmJifix+lEgcgda9srG7903ka5qT
0Fp2J9ncgroMSK/PQZcBrkKOWCtU7e0fgtblCoajO+HIttBHt66WlEhZVyvQ
6AgatORldARywpGtcHQ7LdmOfNkB7YIzwK1HMFiVHkdxGFApkHUIfeg+fodg
gMmE1iHIEQ1hKAwEo6Bl7f4VD7/s5Zc9PNZCiMmhhdYnGYvaZbEEcHt50AKO
xTWHc41d8GOt3SmE0Ke1cmQdRBaTQFYzv0UmPRroBa3d6WfB4PTDwL7oB6eN
8dGMh7a5aZsHa4VQOCOE3MNyQWjoQIZ29E574tRTSNeCOprAzCnLIRmYwx7G
PT27Ms/4pmZcGKyVhoLWqEPaRtTWmD3b5gbU9ArptKA9Lpk9Lvw0ytI27/ik
Y3xyAXqsHZ9wjIkhp5QjvTb5pj4jO3p9Mo6/qEOa1oBSPiYaYDA24eixTNHz
3pHPLAZrpaGwtprWw7pa7Pn+vPYwDQ4PampQawvkZEownfphet43NMzmg69U
IIrara4+qHl2GjiPNBSvlktLPlrZxmYLTa8O9DP5WKq6h9o1SANQOaAo1N7p
fPRAWtLfx8AmNjPjMRun8wHfu0t5P1RVEVQrThOqVCypFZAjLTG9n/qt9g8o
Ru0c7ek2TxPEbBK0keg+H9oiC2hVjxsKwS+ynirP
   "], {{0, 0}, {29, 65}}, {0, 255}],
  ImageSize->{29 0.75, 65 0.75},
  PlotRange->{{0, 29}, {0, 65}}]], "NotebookImage",
 CellID->387776761]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->630007204],

Cell["\<\
Make a palette for applying a square root sign to the selection:\
\>", "ExampleText",
 CellID->391484396],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreatePalette", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<Square root\>\"", ",", 
     RowBox[{"PasteButton", "[", 
      SqrtBox["\[SelectionPlaceholder]"], "]"}]}], "}"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56057613],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztl0tPG1cUx5G6yK7Khg/QbfoF0lX6UrpKIlV000oNRgFCoyhNF203TaWo
JG1JohLABAIuOLxDQjDF4RHzshnsMbHBxmAb26S2QeUZQDWCYnp7Zu74ejx+
BOOWmWkY/Rmdc+Z/7twfd649fivvysd5b2RlZb3H/TFxQcG1/4F2w3vyFUFo
ae2XowQIoj8M6Sohwou5gFxEnv8jhCOEQ0Mw0xZtd4/oc84EIS/vwrXvvhd9
zgdGgCU4duzYmTNnRZ/zgRFgCU6cePv06Y+SDZUVe0gNAS/BrZI7OTmf2CYd
ckSAJcjOznY5PbAXWprbZIeAlwBvZPhE+ubrb+WFADM/depdvASQwjnZjpYs
AsigH6uve0DSFDtaFB3g2xn2RbIdLRcE+FyqrqoRfeaZIOieDX555aroM88E
AQTfDqLPPEMESe3ogyEUFV2CjynRJ58JAmxn6ezogyHA9zUshOiTzwQBBG+t
J0++sx8BrzQRpKMjBCnotUU4zHfp1xkh4Y+X+OIrKwLYZD+IXmlLVtnnKsRP
JpNKsjmniFNXxEJIsQriIqR+kGJ/Wx/GKsQ/5Gn9h4knxQgCun8XIeGip/4P
CzwJ75hwCfZjix+WpGkhSEfpPkgSxEl3O0tcRwhSEB/h0uUSr+dFZ5fx55IG
eWn3r13KOHP1q9KCy7cBAeRy+eQlPoLLGUBob28vLCP9vRfmI0w7/Lu74dDW
NmiLFReH4LxD0lCIM0CRmEkcp7Qb79W01ua833Tug8ZzH8YL6nAVPLhxe3sn
FNohCLbJuY3N0MrqxsrqOnveiMTrwniNbyB+UtyMrafXqMk5Gy4rR3VqpFIl
UJ0aroIHN66uMS0EwWr1LPyx6g8u+wOLbx4/zpc/uOgPLnFxgB8vgXi25Uiw
RGKcCoNAXCXIDAXn2UIF0najjrak0naDh73FUmB+ORBcIQjmcbdnbsE1G8Bj
QoAVSYPRujvqiQR+1sx53DGDBKO2RI08px8a3QUKpOlED5sRPiDAIqmmEzzs
sEG3JzjrXSAIRpPT7pibtHvxmBBM2L38lASJir4kdS8eh5/Gykc8+HZCBDja
eXEEAXfZprxT078TBAjMFif9fAbfzjTuNJqdpvFoGglm+DEXPHeazDPR1MwF
9DiM4KSjfohnaHZY7CeNIJotugtykaYDtTUyEhxNv6JGFXrcCggmdmRot0x4
CMIo5TBQdj1lx7eDQD9qH6FsXDoaUxcUR9iifpSYowFTp6J+PefkRBpHKHzJ
5rpwnpm8+j5SV6P6quj8VUpUW47u3wUKV/75SIvNSDsHhycxgoFyDAxZQfh2
umEmHhi24JTUifjmSMUiCLihonUrkY45WyKpRRepMAgNtaiqFN0rFa5C2W10
9xaqrQIEMo6BmvpNa8QI+tGpnj5Tbz+NbwcBFk57+s29jOjePhpiJu0z88zs
JaZOs07ShVMzGYQ0sjEd3+jKz0WqqvAvJWTiO3ei8dZPN1FlhTs/l+2le/ro
oZGJlrYBDsEw1aWlup8a8e0gwBKkAsVeHSNpWoNAIzkze6GyYvPmDTznP3+8
sckKpy+Li1FFOXhIr27QUqPqiiA4OjrH4E3vvxBG2I/Te1GBlMqV69dfFv8Q
L6ijSqW3MBebn2iMfc+spWVtHIJ+uv2h4fEjSlxZij5F1ZWoEqRMIKUSVdeM
f/E5Nj9qp55qLfC+ihGGhuzqel1Tw6C4gvcfa/5nvqI8T6EiXr6LCkuhAjzY
3Phg4EmHUWoIaekIQQoSIIzo7Q1qXXPToIzU1Dig6YwiBIJrXt+S17coL83P
rxMEWQsQ/gFqOJ5l
   "], {{0, 0}, {65, 65}}, {0, 255}],
  ImageSize->{65 0.75, 65 0.75},
  PlotRange->{{0, 65}, {0, 65}}]], "NotebookImage",
 CellID->640516985]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->50549498],

Cell["Make a palette for listing files in the current directory:", \
"ExampleText",
 CellID->79623556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreatePalette", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<File Operations\>\"", ",", 
     RowBox[{"Button", "[", 
      RowBox[{"\"\<List files\>\"", ",", 
       RowBox[{"CreateDocument", "[", 
        RowBox[{"{", 
         RowBox[{"Column", "[", 
          RowBox[{"FileNames", "[", "]"}], "]"}], "}"}], "]"}]}], "]"}]}], 
    "}"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->641157802],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztWFtTU1cUZqbvHZ/63gf/RacPbR86nWntdKwP7UwFp4DWsR07fWinUx8c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   "], {{0, 0}, {80, 62}}, {0, 255}],
  ImageSize->{80 0.75, 62 0.75},
  PlotRange->{{0, 80}, {0, 62}}]], "NotebookImage",
 CellID->103851902]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->68768619],

Cell["Create a palette window with text and graphics:", "ExampleText",
 CellID->320320905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreatePalette", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<Choose a direction:\>\"", ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Circle", "[", "]"}], ",", 
         RowBox[{"Inset", "[", 
          RowBox[{
           RowBox[{"Button", "[", "\"\<N\>\"", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "1"}], "}"}]}], "]"}], ",", 
         RowBox[{"Inset", "[", 
          RowBox[{
           RowBox[{"Button", "[", "\"\<E\>\"", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"1", ",", "0"}], "}"}]}], "]"}], ",", 
         RowBox[{"Inset", "[", 
          RowBox[{
           RowBox[{"Button", "[", "\"\<S\>\"", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", 
             RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
         RowBox[{"Inset", "[", 
          RowBox[{
           RowBox[{"Button", "[", "\"\<W\>\"", "]"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"-", "1"}], ",", "0"}], "}"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "Tiny"}]}], "]"}]}], "}"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->231238666],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtMXMcZx5H64DeUF/rES+X4ocmT8+RIlZy6lXuRnEgVTtVaaYwV41Ar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   "], {{0, 0}, {112, 139}}, {0, 255}],
  ImageSize->{112 0.75, 139 0.75},
  PlotRange->{{0, 112}, {0, 139}}]], "NotebookImage",
 CellID->535502147]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32035785],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WindowElements",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->541818168],

Cell["Make a scrolling palette:", "ExampleText",
 CellID->243534950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreatePalette", "[", 
   RowBox[{
    RowBox[{"Button", "/@", 
     RowBox[{"Range", "[", "40", "]"}]}], ",", 
    RowBox[{"WindowSize", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Fit", ",", "350"}], "}"}]}], ",", 
    RowBox[{"WindowElements", "\[Rule]", 
     RowBox[{"{", "\"\<VerticalScrollBar\>\"", "}"}]}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75302836],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztndlvG8cdx1X0vchT3/vQP6FvNQK0fSgKtAGKtA8t0FhGLMcN0iJFH1IU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   "], {{0, 0}, {53, 376}}, {0, 255}],
  ImageSize->{53 0.75, 376 0.75},
  PlotRange->{{0, 53}, {0, 376}}]], "NotebookImage",
 CellID->397084422]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WindowFloating",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->23429889],

Cell[TextData[{
 "Set to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 " to make a palette that can be covered up by other windows:"
}], "ExampleText",
 CellID->44053675],

Cell[BoxData[
 RowBox[{
  RowBox[{"CreatePalette", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TextCell", "[", "\"\<Do not float\>\"", "]"}], ",", 
      RowBox[{"CancelButton", "[", "]"}]}], "}"}], ",", 
    RowBox[{"WindowFloating", "\[Rule]", "False"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->160029109]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WindowMargins",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->394708648],

Cell[TextData[{
 "Set to ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " to position a palette in the center of your screen:"
}], "ExampleText",
 CellID->53238020],

Cell[BoxData[
 RowBox[{
  RowBox[{"CreatePalette", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TextCell", "[", "\"\<Center\>\"", "]"}], ",", 
      RowBox[{"CancelButton", "[", "]"}]}], "}"}], ",", 
    RowBox[{"WindowMargins", "\[Rule]", "Automatic"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->269769918]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WindowSize",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->113658486],

Cell["\<\
Set the height of a palette to a fixed value while letting the width fit the \
contents:\
\>", "ExampleText",
 CellID->866201194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreatePalette", "[", 
   RowBox[{
    RowBox[{"Button", "/@", 
     RowBox[{"Range", "[", "40", "]"}]}], ",", 
    RowBox[{"WindowSize", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Fit", ",", "350"}], "}"}]}], ",", 
    RowBox[{"WindowElements", "\[Rule]", 
     RowBox[{"{", "\"\<VerticalScrollBar\>\"", "}"}]}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->976264736],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztndlvG8cdx1X0vchT3/vQP6FvNQK0fSgKtAGKtA8t0FhGLMcN0iJFH1IU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   "], {{0, 0}, {53, 376}}, {0, 255}],
  ImageSize->{53 0.75, 376 0.75},
  PlotRange->{{0, 53}, {0, 376}}]], "NotebookImage",
 CellID->32261461]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WindowTitle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->49685964],

Cell["Set the title bar text for a palette:", "ExampleText",
 CellID->18901963],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreatePalette", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TextCell", "[", "\"\<Trivial example palette\>\"", "]"}], ",", 
      
      RowBox[{"CancelButton", "[", "]"}]}], "}"}], ",", 
    RowBox[{"WindowTitle", "\[Rule]", "\"\<Minipalette\>\""}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->520599730],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztmdtTE1ccx5npe8envveh/0SnT20fOp1pnelYH9qZCk4BrWM7dnxop1Mf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   "], {{0, 0}, {116, 58}}, {0, 255}],
  ImageSize->{116 0.75, 58 0.75},
  PlotRange->{{0, 116}, {0, 58}}]], "NotebookImage",
 CellID->15522290]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19239221],

Cell["\<\
Make a palette to change selected text to upper or lower case:\
\>", "ExampleText",
 CellID->7382880],

Cell[BoxData[
 RowBox[{
  RowBox[{"CreatePalette", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Button", "[", 
      RowBox[{"\"\<Shout!\>\"", ",", 
       RowBox[{"NotebookWrite", "[", 
        RowBox[{
         RowBox[{"InputNotebook", "[", "]"}], ",", 
         RowBox[{"ToUpperCase", "[", 
          RowBox[{"NotebookRead", "[", 
           RowBox[{"InputNotebook", "[", "]"}], "]"}], "]"}]}], "]"}]}], 
      "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Button", "[", 
      RowBox[{"\"\<Quiet\>\"", ",", 
       RowBox[{"NotebookWrite", "[", 
        RowBox[{
         RowBox[{"InputNotebook", "[", "]"}], ",", 
         RowBox[{"ToLowerCase", "[", 
          RowBox[{"NotebookRead", "[", 
           RowBox[{"InputNotebook", "[", "]"}], "]"}], "]"}]}], "]"}]}], 
      "]"}]}], "}"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->701257175]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6097],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PaletteNotebook",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PaletteNotebook"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PasteButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PasteButton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Button",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Button"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDocument",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDocument"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateWindow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateWindow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookClose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookClose"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9551]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Creating Inspectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingInspectors"]], "MoreAbout",
 CellID->1134778],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->386570731],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->335079326],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->52786637],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->117774670]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CreatePalette - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 0.7545858}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CreatePalette[expr] creates a palette notebook containing expr, and \
opens it in the front end. CreatePalette[{expr_1, expr_2, ...}] creates and \
opens a palette notebook consisting of a sequence of cells containing the \
expr_i. CreatePalette[expr, obj] replaces the notebook represented by the \
notebook object obj with the one obtained from expr.", 
    "synonyms" -> {"create palette"}, "title" -> "CreatePalette", "type" -> 
    "Symbol", "uri" -> "ref/CreatePalette"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11884, 368, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->32834997]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 49809, 1324}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2534, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3157, 83, 1578, 37, 70, "ObjectNameGrid"],
Cell[4738, 122, 1909, 59, 70, "Usage",
 CellID->32053]
}, Open  ]],
Cell[CellGroupData[{
Cell[6684, 186, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7162, 203, 1280, 45, 70, "Notes",
 CellID->18135],
Cell[8445, 250, 452, 14, 70, "Notes",
 CellID->12258],
Cell[8900, 266, 258, 11, 70, "Notes",
 CellID->312356304],
Cell[9161, 279, 1665, 44, 70, "2ColumnTableMod",
 CellID->256271009],
Cell[10829, 325, 207, 7, 70, "Notes",
 CellID->18140],
Cell[11039, 334, 367, 12, 70, "Notes",
 CellID->16466],
Cell[11409, 348, 438, 15, 70, "Notes",
 CellID->22951]
}, Closed]],
Cell[CellGroupData[{
Cell[11884, 368, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->32834997],
Cell[CellGroupData[{
Cell[12268, 382, 148, 5, 70, "ExampleSection",
 CellID->755307293],
Cell[12419, 389, 59, 1, 70, "ExampleText",
 CellID->69177635],
Cell[CellGroupData[{
Cell[12503, 394, 173, 5, 70, "Input",
 CellID->175969606],
Cell[12679, 401, 1203, 22, 70, "NotebookImage",
 CellID->681078895]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13931, 429, 218, 7, 70, "ExampleSection",
 CellID->8543725],
Cell[14152, 438, 85, 1, 70, "ExampleText",
 CellID->248519753],
Cell[CellGroupData[{
Cell[14262, 443, 312, 10, 70, "Input",
 CellID->366017690],
Cell[14577, 455, 1276, 23, 70, "NotebookImage",
 CellID->387776761]
}, Open  ]],
Cell[15868, 481, 125, 3, 70, "ExampleDelimiter",
 CellID->630007204],
Cell[15996, 486, 115, 3, 70, "ExampleText",
 CellID->391484396],
Cell[CellGroupData[{
Cell[16136, 493, 275, 9, 70, "Input",
 CellID->56057613],
Cell[16414, 504, 2045, 36, 70, "NotebookImage",
 CellID->640516985]
}, Open  ]],
Cell[18474, 543, 124, 3, 70, "ExampleDelimiter",
 CellID->50549498],
Cell[18601, 548, 102, 2, 70, "ExampleText",
 CellID->79623556],
Cell[CellGroupData[{
Cell[18728, 554, 437, 13, 70, "Input",
 CellID->641157802],
Cell[19168, 569, 2521, 44, 70, "NotebookImage",
 CellID->103851902]
}, Open  ]],
Cell[21704, 616, 124, 3, 70, "ExampleDelimiter",
 CellID->68768619],
Cell[21831, 621, 90, 1, 70, "ExampleText",
 CellID->320320905],
Cell[CellGroupData[{
Cell[21946, 626, 1235, 35, 70, "Input",
 CellID->231238666],
Cell[23184, 663, 4670, 79, 70, "NotebookImage",
 CellID->535502147]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27903, 748, 221, 7, 70, "ExampleSection",
 CellID->32035785],
Cell[CellGroupData[{
Cell[28149, 759, 235, 7, 70, "ExampleSubsection",
 CellID->541818168],
Cell[28387, 768, 68, 1, 70, "ExampleText",
 CellID->243534950],
Cell[CellGroupData[{
Cell[28480, 773, 421, 13, 70, "Input",
 CellID->75302836],
Cell[28904, 788, 4504, 76, 70, "NotebookImage",
 CellID->397084422]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33457, 870, 234, 7, 70, "ExampleSubsection",
 CellID->23429889],
Cell[33694, 879, 241, 8, 70, "ExampleText",
 CellID->44053675],
Cell[33938, 889, 346, 10, 70, "Input",
 CellID->160029109]
}, Closed]],
Cell[CellGroupData[{
Cell[34321, 904, 234, 7, 70, "ExampleSubsection",
 CellID->394708648],
Cell[34558, 913, 242, 8, 70, "ExampleText",
 CellID->53238020],
Cell[34803, 923, 346, 11, 70, "Input",
 CellID->269769918]
}, Closed]],
Cell[CellGroupData[{
Cell[35186, 939, 231, 7, 70, "ExampleSubsection",
 CellID->113658486],
Cell[35420, 948, 139, 4, 70, "ExampleText",
 CellID->866201194],
Cell[CellGroupData[{
Cell[35584, 956, 422, 13, 70, "Input",
 CellID->976264736],
Cell[36009, 971, 4503, 76, 70, "NotebookImage",
 CellID->32261461]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40561, 1053, 231, 7, 70, "ExampleSubsection",
 CellID->49685964],
Cell[40795, 1062, 79, 1, 70, "ExampleText",
 CellID->18901963],
Cell[CellGroupData[{
Cell[40899, 1067, 378, 12, 70, "Input",
 CellID->520599730],
Cell[41280, 1081, 2693, 46, 70, "NotebookImage",
 CellID->15522290]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[44034, 1134, 226, 7, 70, "ExampleSection",
 CellID->19239221],
Cell[44263, 1143, 111, 3, 70, "ExampleText",
 CellID->7382880],
Cell[44377, 1148, 868, 24, 70, "Input",
 CellID->701257175]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[45294, 1178, 310, 9, 70, "SeeAlsoSection",
 CellID->6097],
Cell[45607, 1189, 1729, 62, 70, "SeeAlso",
 CellID->9551]
}, Open  ]],
Cell[CellGroupData[{
Cell[47373, 1256, 299, 8, 70, "MoreAboutSection"],
Cell[47675, 1266, 147, 3, 70, "MoreAbout",
 CellID->1134778],
Cell[47825, 1271, 168, 3, 70, "MoreAbout",
 CellID->386570731],
Cell[47996, 1276, 128, 3, 70, "MoreAbout",
 CellID->335079326],
Cell[48127, 1281, 153, 3, 70, "MoreAbout",
 CellID->52786637],
Cell[48283, 1286, 172, 3, 70, "MoreAbout",
 CellID->117774670]
}, Open  ]],
Cell[48470, 1292, 27, 0, 70, "History"],
Cell[48500, 1294, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

