(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     61520,       1644]
NotebookOptionsPosition[     54818,       1421]
NotebookOutlinePosition[     56625,       1471]
CellTagsIndexPosition[     56505,       1465]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"CreateDocument" :> 
         Documentation`HelpLookup["paclet:ref/CreateDocument"], 
         "CreatePalette" :> 
         Documentation`HelpLookup["paclet:ref/CreatePalette"], "CreateDialog" :> 
         Documentation`HelpLookup["paclet:ref/CreateDialog"], "NotebookPut" :> 
         Documentation`HelpLookup["paclet:ref/NotebookPut"], "WindowMargins" :> 
         Documentation`HelpLookup["paclet:ref/WindowMargins"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"CreateDocument\"\>", 
      2->"\<\"CreatePalette\"\>", 3->"\<\"CreateDialog\"\>", 
      4->"\<\"NotebookPut\"\>", 
      5->"\<\"WindowMargins\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["CreateWindow", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CreateWindow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CreateWindow"], "[", "]"}]], "InlineFormula"],
     
     "\[LineSeparator]creates an empty window in the front end."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CreateWindow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CreateWindow"], "[", 
       StyleBox["nb", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]creates a window displaying the notebook expression ",
     Cell[BoxData[
      StyleBox["nb", "TI"]], "InlineFormula"],
     ", and opens it in the front end."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CreateWindow",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CreateWindow"], "[", 
       RowBox[{
        StyleBox["nb", "TI"], ",", 
        StyleBox["obj", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]replaces the notebook represented by the notebook \
object ",
     Cell[BoxData[
      StyleBox["obj", "TI"]], "InlineFormula"],
     " with the one obtained from ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The notebook expression ",
 Cell[BoxData[
  StyleBox["nb", "TI"]], "InlineFormula"],
 " can be ",
 Cell[BoxData[
  ButtonBox["DocumentNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DocumentNotebook"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PaletteNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaletteNotebook"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["DialogNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogNotebook"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreateWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateWindow"]], "InlineFormula"],
 " can take any notebook option. "
}], "Notes",
 CellID->543447351],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CreateWindow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateWindow"], "[", 
   RowBox[{
    ButtonBox["Visible",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Visible"], "->", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"]}], "]"}]], "InlineFormula"],
 " creates a new invisible window. "
}], "Notes",
 CellID->8938]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->234022684],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->340579248],

Cell["Create a blank notebook window:", "ExampleText",
 CellID->575597725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->195535420],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt2mtvlncdB3CMz83egm9FfewSs0eaOEqkbJrF6AvwwSKbjs3IgHIY1I0B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   "], {{0, 0}, {458, 140}}, {0, 255}],
  ImageSize->{458 0.75, 140 0.75},
  PlotRange->{{0, 458}, {0, 140}}]], "NotebookImage",
 CellID->52626221]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->40363662],

Cell["Create a notebook window with specified contents:", "ExampleText",
 CellID->8156606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateWindow", "[", 
    RowBox[{"DocumentNotebook", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b", ",", "c"}], "}"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->555501666],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d1PFFccxnGa3jf+C/1X+nKraeNN26SCKaBtjLHpRZMmvTBVW6lN8QVE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   "], {{0, 0}, {458, 98}}, {0, 255}],
  ImageSize->{458 0.75, 98 0.75},
  PlotRange->{{0, 458}, {0, 98}}]], "NotebookImage",
 CellID->388012563]
}, Open  ]],

Cell["Replace the contents of an existing window:", "ExampleText",
 CellID->211292090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{
    RowBox[{"DocumentNotebook", "[", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "]"}], ",", "nb"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->111185767],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etPVEccxnGavm/8F/qv9PJW06Zv2iZVSAFtY4xNXzRp0hemaiu1KV5A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   "], {{0, 0}, {458, 98}}, {0, 255}],
  ImageSize->{458 0.75, 98 0.75},
  PlotRange->{{0, 458}, {0, 98}}]], "NotebookImage",
 CellID->5916726]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2863286],

Cell["Create a palette window:", "ExampleText",
 CellID->454056546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"PaletteNotebook", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<Square root\>\"", ",", 
      RowBox[{"Button", "[", 
       RowBox[{
        SqrtBox["\[Pi]"], ",", 
        RowBox[{"p", "=", 
         RowBox[{"N", "[", 
          SqrtBox["\[Pi]"], "]"}]}]}], "]"}]}], "}"}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->311919308],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztmOtPU2cYwEn2gX1a/DL3eR/8Ypa4P2CZuxgzTZBsYybTZFwiIHNucZqI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   "], {{0, 0}, {63, 73}}, {0, 255}],
  ImageSize->{63 0.75, 73 0.75},
  PlotRange->{{0, 63}, {0, 73}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->117726845]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->763232210],

Cell["Create a dialog window:", "ExampleText",
 CellID->142140356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{"DialogNotebook", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"TextCell", "[", "\"\<Enter a name: \>\"", "]"}], ",", 
      RowBox[{"InputField", "[", 
       RowBox[{
        RowBox[{"Dynamic", "[", "nm", "]"}], ",", "String"}], "]"}], ",", 
      RowBox[{"DefaultButton", "[", 
       RowBox[{"DialogReturn", "[", 
        RowBox[{"ret", "=", "nm"}], "]"}], "]"}]}], "}"}], "]"}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->517681080],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3N1PW+cdB3Cm3U+92vV2UfWf2NW227TSVPWik9YQDdKsqqpNvVg1tRdR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   "], {{0, 0}, {288, 121}}, {0, 255}],
  ImageSize->{288 0.75, 121 0.75},
  PlotRange->{{0, 288}, {0, 121}}]], "NotebookImage",
 CellID->444366747]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->635744571],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->41820432],

Cell["Set a background color:", "ExampleText",
 CellID->82889571],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", 
   RowBox[{
    RowBox[{"DocumentNotebook", "[", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], "]"}], ",", 
    RowBox[{"Background", "\[Rule]", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"1", ",", ".9", ",", ".7"}], "]"}]}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->522940521],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etPFFccxnGavm/8F/qv9PJW28akSZtUMAXUxjT28rYvTNVWalO8gCBQ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   "], {{0, 0}, {458, 80}}, {0, 255}],
  ImageSize->{458 0.75, 80 0.75},
  PlotRange->{{0, 458}, {0, 80}}]], "NotebookImage",
 CellID->561246926]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31775648],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DocumentNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DocumentNotebook"]], "InlineFormula"],
 " creates an in-cell representation of a notebook document:"
}], "ExampleText",
 CellID->151187096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DocumentNotebook", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "+", "y"}], ",", 
    RowBox[{
     RowBox[{"1", "/", "x"}], "+", 
     RowBox[{"1", "/", "y"}]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56057613],

Cell[BoxData[
 InterpretationBox[
  PanelBox[GridBox[{
     {
      TooltipBox[
       ButtonBox[
        DynamicBox[FEPrivate`FrontEndResource[
         "FEBitmaps", "ManipulatePasteIcon"],
         ImageSizeCache->{13., {4., 9.}}],
        ButtonFrame->None,
        ButtonFunction:>FrontEndExecute[{
           FrontEnd`NotebookOpen[
            Notebook[{
              Cell[
               BoxData[
                FormBox[
                 RowBox[{"x", "+", "y"}], StandardForm]]], 
              Cell[
               BoxData[
                FormBox[
                 RowBox[{
                   FractionBox["1", "x"], "+", 
                   FractionBox["1", "y"]}], StandardForm]]]}]]}],
        DefaultBaseStyle->{},
        Evaluator->None,
        Method->"Queued"],
       "Open this notebook in a new window"]},
     {GridBox[{
        {Cell[BoxData[
          RowBox[{"x", "+", "y"}]]]},
        {Cell[BoxData[
          RowBox[{
           FractionBox["1", "x"], "+", 
           FractionBox["1", "y"]}]]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxBackground->{
     "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {Inherited, {
         GrayLevel[1]}}, "RowsIndexed" -> {}}],
   DefaultBaseStyle->{}],
  DocumentNotebook[{$CellContext`x + $CellContext`y, $CellContext`x^(-1) + \
$CellContext`y^(-1)}]]], "Output",
 ImageSize->{59, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->623684741]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreateWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateWindow"]], "InlineFormula"],
 " puts the document into its own window:"
}], "ExampleText",
 CellID->130149328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", "%", "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->186194412],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3etPXEUcxnGM743/gv+Kl7dtNL5REy2NpVXTmBpfmJj4orHeqsbaFkql
VBGwVytgsaVyKZftstCFslAWylKFbSMtvSpNEXCcs3N2dvbssqXdM1y2308e
yfzmzDn66slmWdlnNr770sYni4qKNsp/Qk8UFTnrkpKPCCGE2Mjc/AIhhBAf
o9v10OEzhBBCfImnXVf8JTQhhBRAsrarAADkoST5XivtCgA+ol0BwAbaFQBs
oF0BwAbaFQBsoF0BwAbaFQBsoF0BwAbaFQBsoF0BwAbaFQBsoF0BwAbaFQBs
oF0BwAbaFQAe2fsfNrywrlzlxVcOmpdWsF2LDMvwrwMAq2TBmuOKv3alWgEU
hvzb1Xy1mf8rT9oVQGHw5bWr2a55/vfwzgCAwuDXOwO+tKJ6Au0KoACswnYV
FCyAtW/1vDNg3ku7AljrVslvtczPYvG5LAAFYLV9IgsACgPtCgA20K4AYAPt
CgA2LGe78osqAI8P2hUAbMi/XVtbW4syyE3zjOfqoz0EANYQXrsCgA20KwDY
wGcGAMAG2hUAbKBdAcAG2hUAbPDrLxDm/52DvjwEAFYJH1+7+lKJ9CqANS31
pdvraVcA8NnY+DSvXQHAX7Ja1StYc5N2BYB8qGr9+59Z2hUA/KKrVfBbLQDw
iVmtYvV94zbtCmCNKqsIbPug3v3AwLryLe8eM6/yfxMAgA20KwDYQLsCgA20
KwDYQLsCgA20KwDYQLsCgA20KwDYQLsCwCNL/fnBdeUvvnLQvLRs7cofygZQ
2Fb2m1+oVgCFKp92NV95LvYqNHd/0q4AClWer13Nds19YLGrFCyAgpT/OwM5
XrXmfnNVbdKuAAqSvXbVVx94iYIFUHhW6p0Bc592BVB4bP9WK8eN+p0B3n0F
UDBsfOM2AEDx9xu3AQDCwjduAwBsfOM2ADzmLH3jNgA8zix94zYAPOb4xm0A
WH60KwDYQLsCgA2LtWsRACAPZru+s3VnbOyPuobgFzurCSGE5Jm5f+cCweFt
7+0q2fqVbFeZkZFxQgghecZs15HopBALCwvzhBBC8sl/C/Nmu14cmpibm5+5
d1/mXiLuekb+nNXjzIx7QG7qw3pt5h4jIyPjKh0futP2VRw+8PKzteufq1n/
fGbkvrwqz6gb79+fnZmZ1e06cOHynbsz0zfuTN+4nfh5J7m+7V3fNA/o83rz
bvpVRkZGxlU1Pkqn1b+8bn73HvF9laiszJLvq+RVeUbdeOOmc4tu176+sat/
3ZiIX5+YnHrq6afNTMSnJuLX3PWkub4mYxy7nlxc02s1pvaN81kPp56cOKyu
qoX3rvSrjIyMjEsanRKbSmyqnankfjLupSnnruQTLm0uFo0nxYkji6bxpDyj
7p28cn0yPq3btad3dOzy1ZFLk6q+5EIlOcZT+6OpM8nFROKwe2Y07SET5uh5
uOeqHNMPOFfNw7mvMjIyMj5wTC7iqc3R9NFZTxhnnCeMlhSL+jpx9Cf3I61y
oaLH+jp5JnFLfHQsfil2VbdrsDsaGbp8IRJTDSYX/ZGYOepFts3xrPv96Q/p
T3945tX+9LW6ah7OfZWRkZFxieOF9HVGxs275MLbrtIxY51sV3XXwGBs8OKf
ul3loiccDZ0fVg3W3RsN9kS7e1NjcjFsrt3F+Wh3z3Bq7NF3DYfkeWP0vAOQ
eVitg+kng86/NO2qfrJcMDIyMi59DPVGZbqTP7ud/aizn2g8dVh3mn7CaMkG
UX9CHKlx4lF7UNRUip8Py3btVs88Hw33j+l27QoMdQYiHYGIajC56OiKtAcG
3LErbd+z2Z7Y7OjShwdS+4GIOeob2xc57K67BvS96vBSrjIyMjIuYXR35Dq1
4+670Z2mnzDy5htOr1Z9J6r2ix+MvzdYWSoO7BHffSsLdmTTG8lbBoKhaOvZ
C6pdOwNDLW19MqrBms8665azYTXqfR3zcHIn7Fl4xua2vub0W5qdh4SzPTys
Dquresx9lZGRkXEJo7vT7O6nxTif9gSnXasPiPJdYt8u72vX3V+Jb78UB8pl
u+rndAYGf20Mqnbt6Bo81dR9+kxINZhcqKjx1Jme005Cp5tCcu2MTT3G4cQl
Zz+UOKnvyj56DpujfmDmVd29i93LyMjI+MDxVGo/S6epq5mdNrJpg6gsn/9m
p+7U2a9T63uffyrK9o5u2pC4N3SqKdTW3n/oSIvbrp2DDY2Bk78FVYPJhYpn
9CT96jk9GvvnMkcj3tHzwIe6ysjIyPiQY+6c0z+d913L9t799BNVp/989snd
RNR4a8cOsXePPKPvbW4NV1Q2JNt16ETdubqGoI2oVvT3JCGELFtiW4pFaen0
9u23dnycGbkvykpjmzeow7/UB5t+79u1+4jbrh0Xjx3t/Pl4gBBCiCfht14V
+8tEmUxplpSWiv0VvW+/rg4fPxb4rTH8xc5q1a5tbZGqH5prq1sJIYR4sq/i
cN+m18bf2ji2uTgz41uKw5uL5Rl1uObHll9OBGlXQgjxN7QrIYTYCO1KCCE2
4mnX9o5IdVXzT7WthBBC8kltTUt9XapdJ+M3Y+PXYuNThBBC8syVK7d1uxJC
CPE3sl3/B1M+vj4=
   "], {{0, 0}, {458, 98}}, {0, 255}],
  ImageSize->{458 0.75, 98 0.75},
  PlotRange->{{0, 458}, {0, 98}}]], "NotebookImage",
 CellID->139402511]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->286859637],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["PaletteNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaletteNotebook"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DialogNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogNotebook"]], "InlineFormula"],
 " create representations of specialized notebooks:"
}], "ExampleText",
 CellID->192476053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaletteNotebook", "[", 
  RowBox[{"{", 
   RowBox[{"PasteButton", "[", 
    RowBox[{"Grid", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}], "]"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86821122],

Cell[BoxData[
 InterpretationBox[
  PanelBox[GridBox[{
     {
      TooltipBox[
       ButtonBox[
        DynamicBox[FEPrivate`FrontEndResource[
         "FEBitmaps", "ManipulatePasteIcon"],
         ImageSizeCache->{13., {4., 9.}}],
        ButtonFrame->None,
        ButtonFunction:>FrontEndExecute[{
           FrontEnd`NotebookOpen[
            Notebook[{
              Cell[
               BoxData[
                FormBox[
                 ButtonBox[
                  TagBox[
                   GridBox[{{"a", "b"}, {"c", "d"}}], "Grid"], BaseStyle -> 
                  "Paste"], StandardForm]]]}, Active -> True, 
             CellMargins -> {{0, 0}, {0, 0}}, CellOpen -> True, 
             ClosingAutoSave -> False, ImageMargins -> {{0, 0}, {0, 0}}, 
             Magnification -> 1., 
             ScrollingOptions -> {"VerticalScrollRange" -> Fit}, 
             ShowCellBracket -> False, ShowCellLabel -> False, ShowCellTags -> 
             False, WindowClickSelect -> False, WindowElements -> {}, 
             WindowFloating -> True, WindowFrame -> "Palette", 
             WindowFrameElements -> "CloseBox", 
             WindowMargins -> {{Automatic, 0}, {Automatic, 0}}, WindowSize -> 
             All, WindowToolbars -> {}]]}],
        DefaultBaseStyle->{},
        Evaluator->None,
        Method->"Queued"],
       "Open this notebook in a new window"]},
     {GridBox[{
        {Cell[BoxData[
          ButtonBox[
           TagBox[GridBox[{
              {"a", "b"},
              {"c", "d"}
             }],
            "Grid"],
           BaseStyle->"Paste"]]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxBackground->{
     "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {Inherited, {
         GrayLevel[1]}}, "RowsIndexed" -> {}}],
   DefaultBaseStyle->{}],
  PaletteNotebook[{
    PasteButton[
     Grid[{{$CellContext`a, $CellContext`b}, {$CellContext`c, \
$CellContext`d}}]]}]]], "Output",
 ImageSize->{50, 75},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->600535508]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DialogNotebook", "[", 
  RowBox[{"{", 
   RowBox[{"TextCell", "[", 
    RowBox[{"Row", "[", 
     RowBox[{"{", 
      RowBox[{"\"\<Your name:\>\"", ",", 
       RowBox[{"InputField", "[", "]"}]}], "}"}], "]"}], "]"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3322274],

Cell[BoxData[
 InterpretationBox[
  PanelBox[GridBox[{
     {
      TooltipBox[
       ButtonBox[
        DynamicBox[FEPrivate`FrontEndResource[
         "FEBitmaps", "ManipulatePasteIcon"],
         ImageSizeCache->{13., {4., 9.}}],
        ButtonFrame->None,
        ButtonFunction:>FrontEndExecute[{
           FrontEnd`NotebookOpen[
            Notebook[{
              Cell[
               TextData[{"Your name:", 
                 Cell[
                  BoxData[
                   FormBox[
                    TagBox[
                    DynamicModuleBox[{Typeset`i$$ = Null}, 
                    InputFieldBox[
                    Dynamic[Typeset`i$$]], DynamicModuleValues -> Automatic], 
                    InputField[
                    Setting[#]]& ], StandardForm]]]}]]}, Active -> True, 
             CellMargins -> {{8, 8}, {8, 8}}, ClosingAutoSave -> False, 
             Editable -> False, ImageMargins -> {{0, 0}, {0, 0}}, 
             Magnification -> 1., 
             PrivateNotebookOptions -> {"FileOutlineCache" -> False}, 
             Saveable -> False, 
             ScrollingOptions -> {"VerticalScrollRange" -> Fit}, Selectable -> 
             False, ShowCellBracket -> False, ShowCellLabel -> False, 
             ShowCellTags -> False, WindowElements -> {}, WindowFloating -> 
             False, WindowFrameElements -> "CloseBox", WindowSize -> All, 
             WindowToolbars -> {}]]}],
        DefaultBaseStyle->{},
        Evaluator->None,
        Method->"Queued"],
       "Open this notebook in a new window"]},
     {GridBox[{
        {Cell[TextData[{
          "Your name:",
          Cell[BoxData[
           TagBox[
            DynamicModuleBox[{Typeset`i$$ = Null}, 
             InputFieldBox[Dynamic[Typeset`i$$]],
             DynamicModuleValues:>{}],
            InputField[
             Setting[#]]& ]]]
         }]]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxBackground->{
     "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {Inherited, {
         GrayLevel[1]}}, "RowsIndexed" -> {}}],
   DefaultBaseStyle->{}],
  DialogNotebook[{
    TextCell[
     Row[{"Your name:", 
       InputField[]}]]}]]], "Output",
 ImageSize->{358, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->100950233]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["CreateWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateWindow"]], "InlineFormula"],
 " to put a palette or dialog expression into its own notebook window:"
}], "ExampleText",
 CellID->368641369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateWindow", "[", "%", "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->322590194],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnO1Pk1cYxln2ffFf2L8y93kmi9mHLZlgBugWs2x/wD6YqZvMZfhSRIEp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   "], {{0, 0}, {342, 67}}, {0, 255}],
  ImageSize->{342 0.75, 67 0.75},
  PlotRange->{{0, 342}, {0, 67}}]], "NotebookImage",
 CellID->547750765]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42283130],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreateDocument",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDocument"]], "InlineFormula"],
 " is essentially a combination of ",
 Cell[BoxData[
  ButtonBox["DocumentNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DocumentNotebook"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["CreateWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateWindow"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->207715406],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDocument", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "+", "y"}], ",", 
     RowBox[{
      RowBox[{"1", "/", "x"}], "+", 
      RowBox[{"1", "/", "y"}]}]}], "}"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87506315],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3d9TlNcdx3Eyve/kX8i/0h+3OunkJu1MIzaiaSbj2OlFZjqTi0xM2thk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   "], {{0, 0}, {458, 99}}, {0, 255}],
  ImageSize->{458 0.75, 99 0.75},
  PlotRange->{{0, 458}, {0, 99}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->644017151]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->645276832],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreatePalette",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreatePalette"]], "InlineFormula"],
 " acts like a combination of ",
 Cell[BoxData[
  ButtonBox["PaletteNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PaletteNotebook"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["CreateWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateWindow"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->15734902],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreatePalette", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<Square root\>\"", ",", 
     RowBox[{"Button", "[", 
      RowBox[{
       SqrtBox["\[Pi]"], ",", 
       RowBox[{"p", "=", 
        RowBox[{"N", "[", 
         SqrtBox["\[Pi]"], "]"}]}]}], "]"}]}], "}"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->940432951],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztmOtPU3cYx0n2gr1afDP3ei98Y5a4P2CZczNuM0GyjZlMk3GJgMy5xWki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   "], {{0, 0}, {65, 71}}, {0, 255}],
  ImageSize->{65 0.75, 71 0.75},
  PlotRange->{{0, 65}, {0, 71}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->548585467]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19693241],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CreateDialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateDialog"]], "InlineFormula"],
 " acts like a combination of ",
 Cell[BoxData[
  ButtonBox["DialogNotebook",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogNotebook"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["CreateWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CreateWindow"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->140177676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CreateDialog", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<Click OK to close\>\"", ",", 
     RowBox[{"DefaultButton", "[", "]"}]}], "}"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->185067965],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnEtPG1cUgJG6r7Lqvosof6KrtlsaqYqyaKUGogKhUVS16qJVlSyikDSh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   "], {{0, 0}, {125, 86}}, {0, 255}],
  ImageSize->{125 0.75, 86 0.75},
  PlotRange->{{0, 125}, {0, 86}}]], "NotebookImage",
 CellID->71193586]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDocument",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDocument"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreatePalette",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreatePalette"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookPut",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookPut"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowMargins",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowMargins"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CreateWindow - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 1.9733670}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CreateWindow[] creates an empty window in the front end. \
CreateWindow[nb] creates a window displaying the notebook expression nb, and \
opens it in the front end. CreateWindow[nb, obj] replaces the notebook \
represented by the notebook object obj with the one obtained from expr.", 
    "synonyms" -> {"create window"}, "title" -> "CreateWindow", "type" -> 
    "Symbol", "uri" -> "ref/CreateWindow"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6474, 207, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->234022684]},
 "Notebook Image"->{
  Cell[16947, 456, 2550, 45, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->117726845],
  Cell[42827, 1126, 2971, 51, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->644017151],
  Cell[46822, 1220, 2558, 45, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->548585467]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 56026, 1448},
 {"Notebook Image", 56167, 1452}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1042, 22, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1665, 49, 1577, 37, 70, "ObjectNameGrid"],
Cell[3245, 88, 1463, 45, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[4745, 138, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5223, 155, 569, 21, 70, "Notes",
 CellID->1067943069],
Cell[5795, 178, 210, 7, 70, "Notes",
 CellID->543447351],
Cell[6008, 187, 429, 15, 70, "Notes",
 CellID->8938]
}, Closed]],
Cell[CellGroupData[{
Cell[6474, 207, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->234022684],
Cell[CellGroupData[{
Cell[6859, 221, 148, 5, 70, "ExampleSection",
 CellID->340579248],
Cell[7010, 228, 74, 1, 70, "ExampleText",
 CellID->575597725],
Cell[CellGroupData[{
Cell[7109, 233, 121, 4, 70, "Input",
 CellID->195535420],
Cell[7233, 239, 2717, 47, 70, "NotebookImage",
 CellID->52626221]
}, Open  ]],
Cell[9965, 289, 124, 3, 70, "ExampleDelimiter",
 CellID->40363662],
Cell[10092, 294, 90, 1, 70, "ExampleText",
 CellID->8156606],
Cell[CellGroupData[{
Cell[10207, 299, 262, 9, 70, "Input",
 CellID->555501666],
Cell[10472, 310, 2678, 46, 70, "NotebookImage",
 CellID->388012563]
}, Open  ]],
Cell[13165, 359, 86, 1, 70, "ExampleText",
 CellID->211292090],
Cell[CellGroupData[{
Cell[13276, 364, 252, 9, 70, "Input",
 CellID->111185767],
Cell[13531, 375, 2635, 45, 70, "NotebookImage",
 CellID->5916726]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16215, 426, 218, 7, 70, "ExampleSection",
 CellID->2863286],
Cell[16436, 435, 67, 1, 70, "ExampleText",
 CellID->454056546],
Cell[CellGroupData[{
Cell[16528, 440, 416, 14, 70, "Input",
 CellID->311919308],
Cell[16947, 456, 2550, 45, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->117726845]
}, Open  ]],
Cell[19512, 504, 125, 3, 70, "ExampleDelimiter",
 CellID->763232210],
Cell[19640, 509, 66, 1, 70, "ExampleText",
 CellID->142140356],
Cell[CellGroupData[{
Cell[19731, 514, 527, 15, 70, "Input",
 CellID->517681080],
Cell[20261, 531, 3413, 58, 70, "NotebookImage",
 CellID->444366747]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23723, 595, 222, 7, 70, "ExampleSection",
 CellID->635744571],
Cell[CellGroupData[{
Cell[23970, 606, 230, 7, 70, "ExampleSubsection",
 CellID->41820432],
Cell[24203, 615, 65, 1, 70, "ExampleText",
 CellID->82889571],
Cell[CellGroupData[{
Cell[24293, 620, 365, 11, 70, "Input",
 CellID->522940521],
Cell[24661, 633, 2479, 43, 70, "NotebookImage",
 CellID->561246926]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[27201, 683, 236, 7, 70, "ExampleSection",
 CellID->31775648],
Cell[27440, 692, 251, 7, 70, "ExampleText",
 CellID->151187096],
Cell[CellGroupData[{
Cell[27716, 703, 260, 9, 70, "Input",
 CellID->56057613],
Cell[27979, 714, 1725, 52, 70, "Output",
 CellID->623684741]
}, Open  ]],
Cell[29719, 769, 224, 7, 70, "ExampleText",
 CellID->130149328],
Cell[CellGroupData[{
Cell[29968, 780, 126, 4, 70, "Input",
 CellID->186194412],
Cell[30097, 786, 2841, 49, 70, "NotebookImage",
 CellID->139402511]
}, Open  ]],
Cell[32953, 838, 125, 3, 70, "ExampleDelimiter",
 CellID->286859637],
Cell[33081, 843, 381, 12, 70, "ExampleText",
 CellID->192476053],
Cell[CellGroupData[{
Cell[33487, 859, 375, 13, 70, "Input",
 CellID->86821122],
Cell[33865, 874, 2314, 63, 70, "Output",
 CellID->600535508]
}, Open  ]],
Cell[CellGroupData[{
Cell[36216, 942, 309, 10, 70, "Input",
 CellID->3322274],
Cell[36528, 954, 2559, 69, 70, "Output",
 CellID->100950233]
}, Open  ]],
Cell[39102, 1026, 262, 8, 70, "ExampleText",
 CellID->368641369],
Cell[CellGroupData[{
Cell[39389, 1038, 126, 4, 70, "Input",
 CellID->322590194],
Cell[39518, 1044, 2357, 41, 70, "NotebookImage",
 CellID->547750765]
}, Open  ]],
Cell[41890, 1088, 124, 3, 70, "ExampleDelimiter",
 CellID->42283130],
Cell[42017, 1093, 500, 17, 70, "ExampleText",
 CellID->207715406],
Cell[CellGroupData[{
Cell[42542, 1114, 282, 10, 70, "Input",
 CellID->87506315],
Cell[42827, 1126, 2971, 51, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->644017151]
}, Open  ]],
Cell[45813, 1180, 125, 3, 70, "ExampleDelimiter",
 CellID->645276832],
Cell[45941, 1185, 490, 17, 70, "ExampleText",
 CellID->15734902],
Cell[CellGroupData[{
Cell[46456, 1206, 363, 12, 70, "Input",
 CellID->940432951],
Cell[46822, 1220, 2558, 45, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->548585467]
}, Open  ]],
Cell[49395, 1268, 124, 3, 70, "ExampleDelimiter",
 CellID->19693241],
Cell[49522, 1273, 487, 17, 70, "ExampleText",
 CellID->140177676],
Cell[CellGroupData[{
Cell[50034, 1294, 237, 7, 70, "Input",
 CellID->185067965],
Cell[50274, 1303, 2856, 49, 70, "NotebookImage",
 CellID->71193586]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53191, 1359, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[53510, 1370, 1236, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[54761, 1417, 27, 0, 70, "History"],
Cell[54791, 1419, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

