(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    125703,       4194]
NotebookOptionsPosition[    106738,       3494]
NotebookOutlinePosition[    107905,       3529]
CellTagsIndexPosition[    107818,       3524]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ArcCsc" :> Documentation`HelpLookup["paclet:ref/ArcCsc"], 
          "Sec" :> Documentation`HelpLookup["paclet:ref/Sec"], "Sin" :> 
          Documentation`HelpLookup["paclet:ref/Sin"], "Degree" :> 
          Documentation`HelpLookup["paclet:ref/Degree"], "TrigToExp" :> 
          Documentation`HelpLookup["paclet:ref/TrigToExp"], "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ArcCsc\"\>", 2->"\<\"Sec\"\>", 
       3->"\<\"Sin\"\>", 4->"\<\"Degree\"\>", 5->"\<\"TrigToExp\"\>", 
       6->"\<\"TrigExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Trigonometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Csc", "ObjectName",
 CellID->1807],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Csc",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Csc"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the cosecant of ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14449]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The argument of ",
 Cell[BoxData[
  ButtonBox["Csc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Csc"]], "InlineFormula"],
 " is assumed to be in radians. (Multiply by ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 " to convert from degrees.) "
}], "Notes",
 CellID->18760],

Cell[TextData[{
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"csc", "(", "z", ")"}], "=", 
    RowBox[{"1", "/", 
     RowBox[{"sin", "(", "z", ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->24382],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"1", "/", 
   RowBox[{
    ButtonBox["Sin",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sin"], "[", 
    StyleBox["z", "TI"], "]"}]}]], "InlineFormula"],
 " is automatically converted to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Csc",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Csc"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TrigFactorList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigFactorList"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " does decomposition. "
}], "Notes",
 CellID->4836],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Csc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Csc"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Csc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Csc"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Csc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Csc"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->366868346],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->514783465],

Cell["The argument is given in radians:", "ExampleText",
 CellID->12725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Csc", "[", 
  RowBox[{"Pi", "/", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22301],

Cell[BoxData[
 FractionBox["2", 
  SqrtBox["3"]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->384424790]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3969],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 " to specify an argument in degrees:"
}], "ExampleText",
 CellID->12488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Csc", "[", 
  RowBox[{"60", "Degree"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21164],

Cell[BoxData[
 FractionBox["2", 
  SqrtBox["3"]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->748100688]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24124],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Csc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "Pi"}], "/", "2"}], ",", 
     RowBox[{
      RowBox[{"3", "/", "2"}], "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7534],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34997371]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2851],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Csc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13997],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["1", "x"], "+", 
   FractionBox["x", "6"], "+", 
   FractionBox[
    RowBox[{"7", " ", 
     SuperscriptBox["x", "3"]}], "360"], "+", 
   FractionBox[
    RowBox[{"31", " ", 
     SuperscriptBox["x", "5"]}], "15120"], "+", 
   FractionBox[
    RowBox[{"127", " ", 
     SuperscriptBox["x", "7"]}], "604800"], "+", 
   FractionBox[
    RowBox[{"73", " ", 
     SuperscriptBox["x", "9"]}], "3421440"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, -1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 6], 0, 
    Rational[7, 360], 0, 
    Rational[31, 15120], 0, 
    Rational[127, 604800], 0, 
    Rational[73, 3421440]}, -1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{314, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->335418773]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20067],

Cell["Evaluate numerically:", "ExampleText",
 CellID->30265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Csc", "[", "1.2", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20840],

Cell[BoxData["1.0729163777098973`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->480723526]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24955],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->16028],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Csc", "[", 
    RowBox[{"12", "/", "10"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1661],

Cell[BoxData["1.\
0729163777098972287051169224352391548376390066977578706100405915939`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38222697]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->486764325],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->18227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Csc", "[", "1.2000000000000000000000000000000000000000000", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30160],

Cell[BoxData["1.0729163777098972287051169224352391548376390066977578706101`43.\
410296565617635"], "Output",
 ImageSize->{319, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->410613508]
}, Open  ]],

Cell["\<\
The precision of the output can be much smaller or larger than the precision \
of the input:\
\>", "ExampleText",
 CellID->32666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Csc", "[", "3.141592653589793238462643383279502884297", 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22237],

Cell[BoxData[
 RowBox[{"-", "1.001696868235245084`1.9992636840279785*^37"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->860924312]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Csc", "[", "1.5707963267948966192213216916397514421", 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->24848],

Cell[BoxData["1.\
0000000000000000000000000000000000000000499999999999999999858469969`57."], \
"Output",
 ImageSize->{410, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->20720676]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7048],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Csc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Csc"]], "InlineFormula"],
 " ",
 "threads element-wise over lists and matrices:"
}], "ExampleText",
 CellID->25565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Csc", "[", 
  RowBox[{"{", 
   RowBox[{"1.2", ",", "1.5", ",", "1.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28221],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.0729163777098973`", ",", "1.0025113042467249`", ",", 
   "1.026854682696328`"}], "}"}]], "Output",
 ImageSize->{188, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->633185192]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Csc", "[", 
  TagBox[
   RowBox[{"(", "\:f3a2", GridBox[{
      {
       FractionBox["\[Pi]", "2"], "u"},
      {"v", 
       FractionBox["\[Pi]", "3"]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{
      "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
       "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13175],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     RowBox[{"Csc", "[", "u", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Csc", "[", "v", "]"}], ",", 
     FractionBox["2", 
      SqrtBox["3"]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{199, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->347868881]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32514],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Csc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Csc"]], "InlineFormula"],
 " can take complex number inputs:"
}], "ExampleText",
 CellID->12147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sec", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17362],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.6111085641552315`"}], "+", 
  RowBox[{"0.347676660710496`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{148, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->521561547]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29676],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->3454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Csc", "[", 
  RowBox[{"Pi", "/", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21658],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox[
   RowBox[{
    FractionBox["5", "8"], "-", 
    FractionBox[
     SqrtBox["5"], "8"]}]]]], "Output",
 ImageSize->{76, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110530596]
}, Open  ]],

Cell[TextData[{
 "More complicated cases require explicit use of ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->20784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Csc", "[", 
  RowBox[{"Pi", "/", "30"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10688],

Cell[BoxData[
 RowBox[{"Csc", "[", 
  FractionBox["\[Pi]", "30"], "]"}]], "Output",
 ImageSize->{58, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->727900659]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->16116],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   RowBox[{
    FractionBox["1", "8"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "-", 
      SqrtBox["5"]}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SqrtBox[
     RowBox[{
      FractionBox["3", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"5", "-", 
        SqrtBox["5"]}], ")"}]}]]}]}]]], "Output",
 ImageSize->{203, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->41830059]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30180],

Cell["\<\
Convert multiple\[Hyphen]angle expressions:\
\>", "ExampleText",
 CellID->26429],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Csc", "[", 
   RowBox[{"4", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24537],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{
   RowBox[{"4", " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], "-", 
   RowBox[{"4", " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "3"]}]}]]], "Output",
 ImageSize->{226, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55267700]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18389],

Cell[BoxData[
 RowBox[{"Csc", "[", 
  RowBox[{"4", " ", "x"}], "]"}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->540843754]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7004],

Cell["Convert sums of trigonometric functions to products:", "ExampleText",
 CellID->20101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{
   RowBox[{"Csc", "[", "x", "]"}], "+", 
   RowBox[{"Csc", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29384],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"Cos", "[", 
   RowBox[{
    FractionBox["x", "2"], "-", 
    FractionBox["y", "2"]}], "]"}], " ", 
  RowBox[{"Csc", "[", 
   FractionBox["x", "2"], "]"}], " ", 
  RowBox[{"Csc", "[", 
   FractionBox["y", "2"], "]"}], " ", 
  RowBox[{"Sec", "[", 
   FractionBox["x", "2"], "]"}], " ", 
  RowBox[{"Sec", "[", 
   FractionBox["y", "2"], "]"}], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{
    FractionBox["x", "2"], "+", 
    FractionBox["y", "2"]}], "]"}]}]], "Output",
 ImageSize->{358, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99222650]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31987],

Cell["Expand assuming real variables:", "ExampleText",
 CellID->5136],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Csc", "[", 
   RowBox[{"x", "+", 
    RowBox[{"I", " ", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29052],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"Cosh", "[", "y", "]"}], " ", 
     RowBox[{"Sin", "[", "x", "]"}]}], 
    RowBox[{
     RowBox[{"Cos", "[", 
      RowBox[{"2", " ", "x"}], "]"}], "-", 
     RowBox[{"Cosh", "[", 
      RowBox[{"2", " ", "y"}], "]"}]}]]}], "+", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]", " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    RowBox[{"Sinh", "[", "y", "]"}]}], 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "x"}], "]"}], "-", 
    RowBox[{"Cosh", "[", 
     RowBox[{"2", " ", "y"}], "]"}]}]]}]], "Output",
 ImageSize->{280, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->122999188]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1528],

Cell["Convert to complex exponentials:", "ExampleText",
 CellID->6366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"Csc", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1472],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]"}], 
   RowBox[{
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}]], "-", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "z"}]]}]]}]], "Output",
 ImageSize->{73, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->321259888]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->427862131],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->256137772],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Csc", "[", "z", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30008825],

Cell[BoxData[
 FormBox[
  RowBox[{"csc", "(", "z", ")"}], TraditionalForm]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->139951346]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26958],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Csc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Csc"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals:"
}], "ExampleText",
 CellID->4179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Csc", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Pi", "/", "6"}], ",", 
     RowBox[{"Pi", "/", "3"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28983],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    FractionBox["2", 
     SqrtBox["3"]], ",", "2"}], "}"}], "]"}]], "Output",
 ImageSize->{135, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->125010935]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10823],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Csc", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11096],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "\[Infinity]"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "\[Infinity]"}], "}"}]}], "]"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->666498618]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Csc", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8901],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->18642499]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14520],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Csc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Csc"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->30503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Csc", "[", 
  RowBox[{
   FractionBox["\[Pi]", "2"], "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13472],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "2"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 2], 
    Rational[1, 2]}, 0, 4, 1],
  Editable->False]], "Output",
 ImageSize->{116, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->166041]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1932],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Csc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Csc"]], "InlineFormula"],
 " threads over explicit lists as well as over sparse arrays: "
}], "ExampleText",
 CellID->4953],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", 
     FractionBox["\[Pi]", "2"]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
     FractionBox["\[Pi]", "3"]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
     FractionBox["\[Pi]", "4"]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", " ", "2"}], "}"}], "->", "2"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"_", ",", "_"}], "}"}], "->", 
     FractionBox["\[Pi]", "2"]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10824],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}], ",", 
    FractionBox["\[Pi]", "2"]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{190, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53732146]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Csc", "[", "%", "]"}], " ", "-", "1"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30057],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "3", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 3, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->38576203]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", "%", "]"}], " ", "//", " ", "MatrixForm"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->2732],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       FractionBox["2", 
        SqrtBox["3"]]}]},
     {"0", "0", "0"},
     {"0", "0", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SqrtBox["2"]}]},
     {"0", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{"Csc", "[", "2", "]"}]}], "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{169, 79},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->255457820]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16966],

Cell["Generate a plot with poles removed:", "ExampleText",
 CellID->25690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Csc", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "6"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "\[Equal]", "0"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->868],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->54244386]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22828],

Cell["Generate a plot over the complex argument plane:", "ExampleText",
 CellID->21479],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"Csc", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "Pi"}], ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14144],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 149},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37412290]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(12)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29703],

Cell["\<\
Basic parity and periodicity properties of the cosecant function get \
automatically applied:\
\>", "ExampleText",
 CellID->9449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Csc", "[", 
   RowBox[{"x", "+", "Pi"}], "]"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18833],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Csc", "[", "x", "]"}]}]], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->216156979]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Csc", "[", 
  RowBox[{"-", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22910],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Csc", "[", "x", "]"}]}]], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->378990052]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Csc", "[", 
  RowBox[{"I", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->21027],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "\[ImaginaryI]"}], " ", 
  RowBox[{"Csch", "[", "x", "]"}]}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->424709465]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"Csc", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->527],

Cell[BoxData[
 RowBox[{"Sin", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->108566232]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26393],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TrigFactorList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigFactorList"]], "InlineFormula"],
 " to factor ",
 Cell[BoxData[
  ButtonBox["Csc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Csc"]], "InlineFormula"],
 " into ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7863],

Cell[BoxData[
 RowBox[{"Csc", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->167645436]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactorList", "[", 
  RowBox[{"Csc", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2565],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->282409822]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19251],

Cell["\<\
Complicated expressions containing trigonometric functions do not \
automatically simplify:\
\>", "ExampleText",
 CellID->27318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", 
   RowBox[{"Csc", "[", 
    RowBox[{
     SubscriptBox["z", "1"], "+", 
     SubscriptBox["z", "2"]}], "]"}]}], "-", 
  RowBox[{"2", 
   RowBox[{"Sin", "[", 
    SubscriptBox["z", "2"], "]"}], 
   RowBox[{"Cos", "[", 
    SubscriptBox["z", "1"], "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12081],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], " ", 
   RowBox[{"Cos", "[", 
    SubscriptBox["z", "1"], "]"}], " ", 
   RowBox[{"Sin", "[", 
    SubscriptBox["z", "2"], "]"}]}], "+", 
  RowBox[{"Sin", "[", 
   RowBox[{
    SubscriptBox["z", "1"], "+", 
    SubscriptBox["z", "2"]}], "]"}]}]], "Output",
 ImageSize->{205, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156629751]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28103],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{
   SubscriptBox["z", "1"], "-", 
   SubscriptBox["z", "2"]}], "]"}]], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->628990311]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Csc", "[", 
   RowBox[{"Conjugate", "[", "z", "]"}], "]"}], " ", "-", " ", 
  RowBox[{"Conjugate", "[", 
   RowBox[{"Csc", "[", "z", "]"}], "]"}], " "}]], "Input",
 CellLabel->"In[3]:=",
 CellID->15238],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Conjugate", "[", 
    RowBox[{"Csc", "[", "z", "]"}], "]"}]}], "+", 
  RowBox[{"Csc", "[", 
   RowBox[{"Conjugate", "[", "z", "]"}], "]"}]}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->471520109]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->17464],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->72635573]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6572],

Cell["Simplification with additional assumptions:", "ExampleText",
 CellID->7221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Csc", "[", 
  RowBox[{
   RowBox[{"-", "x"}], "+", 
   RowBox[{"k", " ", "Pi"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16922],

Cell[BoxData[
 RowBox[{"Csc", "[", 
  RowBox[{
   RowBox[{"k", " ", "\[Pi]"}], "-", "x"}], "]"}]], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5797086]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", ",", 
   RowBox[{"k", "\[Element]", "Integers"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10867],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "k"]}], " ", 
  RowBox[{"Csc", "[", "x", "]"}]}]], "Output",
 ImageSize->{92, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->382910431]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9298],

Cell["Compositions with the inverse functions:", "ExampleText",
 CellID->25343],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Csc", "[", 
    RowBox[{"ArcCsc", "[", "z", "]"}], "]"}], ",", 
   RowBox[{"Csc", "[", 
    RowBox[{"2", 
     RowBox[{"ArcCsc", "[", "z", "]"}]}], "]"}], ",", 
   RowBox[{"Csc", "[", 
    RowBox[{"3", 
     RowBox[{"ArcCsc", "[", "z", "]"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5234],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"Csc", "[", 
    RowBox[{"2", " ", 
     RowBox[{"ArcCsc", "[", "z", "]"}]}], "]"}], ",", 
   RowBox[{"Csc", "[", 
    RowBox[{"3", " ", 
     RowBox[{"ArcCsc", "[", "z", "]"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{264, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->156657859]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionExpand", "[", "%", "]"}], "//", "Together"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24019],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   FractionBox[
    RowBox[{
     SqrtBox[
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}]], " ", 
     SqrtBox[
      RowBox[{"\[ImaginaryI]", " ", "z"}]], " ", "z"}], 
    RowBox[{"2", " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["z", "2"]}]]}]], ",", 
   FractionBox[
    SuperscriptBox["z", "3"], 
    RowBox[{
     RowBox[{"-", "4"}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["z", "2"]}]}]]}], "}"}]], "Output",
 ImageSize->{196, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->239541838]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14062],

Cell["Solve a trigonometric equation:", "ExampleText",
 CellID->8411],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"3", 
      SuperscriptBox[
       RowBox[{"Csc", "[", "z", "]"}], "2"]}], "-", 
     RowBox[{"6", 
      RowBox[{"Csc", "[", 
       RowBox[{"z", "-", 
        RowBox[{"Pi", "/", "6"}]}], "]"}]}]}], "\[Equal]", 
    RowBox[{"-", "8"}]}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16811],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{554, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->316504451]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17405],

Cell["Solve for zeros and poles: ", "ExampleText",
 CellID->6881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Csc", "[", 
     RowBox[{
      RowBox[{"\[Alpha]", " ", "x"}], "+", "\[Beta]"}], "]"}], "==", "0"}], 
   ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3651],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->913356526]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Csc", "[", 
      RowBox[{
       RowBox[{"\[Alpha]", " ", "x"}], "+", "\[Beta]"}], "]"}]}], "==", "0"}],
    ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17898],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[Equal]", "0"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[Beta]", "\[Equal]", 
         RowBox[{"2", " ", "\[Pi]", " ", 
          RowBox[{"C", "[", "1", "]"}]}]}], "||", 
        RowBox[{"\[Beta]", "\[Equal]", 
         RowBox[{"\[Pi]", "+", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "\[Equal]", 
         FractionBox[
          RowBox[{
           RowBox[{"-", "\[Beta]"}], "+", 
           RowBox[{"2", " ", "\[Pi]", " ", 
            RowBox[{"C", "[", "1", "]"}]}]}], "\[Alpha]"]}], "||", 
        RowBox[{"x", "\[Equal]", 
         FractionBox[
          RowBox[{"\[Pi]", "-", "\[Beta]", "+", 
           RowBox[{"2", " ", "\[Pi]", " ", 
            RowBox[{"C", "[", "1", "]"}]}]}], "\[Alpha]"]}]}], ")"}]}], 
     ")"}]}], ")"}]}]], "Output",
 ImageSize->{411, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->203237614]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15842],

Cell["Numerically find a root of a transcendental equation:", "ExampleText",
 CellID->5694],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", "z", "]"}], "2"], "+", 
     RowBox[{"3", " ", 
      RowBox[{"Csc", "[", 
       RowBox[{"z", "+", 
        RowBox[{"Pi", "/", "3"}]}], "]"}]}], "+", "z"}], "\[Equal]", "4"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5084],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "3.7266402636642733`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->510801893]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16500],

Cell["Integrals:", "ExampleText",
 CellID->10955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Csc", "[", "z", "]"}], "a"], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31155],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Cos", "[", "z", "]"}]}], " ", 
  SuperscriptBox[
   RowBox[{"Csc", "[", "z", "]"}], 
   RowBox[{
    RowBox[{"-", "1"}], "+", "a"}]], " ", 
  RowBox[{"Hypergeometric2F1", "[", 
   RowBox[{
    FractionBox["1", "2"], ",", 
    FractionBox[
     RowBox[{"1", "+", "a"}], "2"], ",", 
    FractionBox["3", "2"], ",", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "z", "]"}], "2"]}], "]"}], " ", 
  SuperscriptBox[
   RowBox[{"(", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "z", "]"}], "2"], ")"}], 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "a"}], ")"}]}]]}]], "Output",
 ImageSize->{495, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173646128]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->650],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Csc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Csc"]], "InlineFormula"],
 " is automatically returned as a special case for many mathematical \
functions: "
}], "ExampleText",
 CellID->6688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"BesselJ", "[", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", "z"}], "]"}], 
    RowBox[{"-", "1"}]], ",", 
   SuperscriptBox[
    RowBox[{"StruveH", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "1"}], "/", "2"}], ",", "z"}], "]"}], 
    RowBox[{"-", "1"}]], ",", 
   RowBox[{"1", "/", 
    RowBox[{"MathieuS", "[", 
     RowBox[{"1", ",", "0", ",", "z"}], "]"}]}], ",", 
   RowBox[{"JacobiDS", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"JacobiNS", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   SuperscriptBox[
    RowBox[{"HypergeometricPFQ", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       FractionBox["3", "2"], "}"}], ",", 
      RowBox[{"-", "z"}]}], "]"}], 
    RowBox[{"-", "1"}]], ",", 
   SuperscriptBox[
    RowBox[{"MeijerG", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         FractionBox["1", "2"], "}"}], ",", 
        RowBox[{"{", "0", "}"}]}], "}"}], ",", "z"}], "]"}], 
    RowBox[{"-", "1"}]]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5939],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SqrtBox[
     FractionBox["\[Pi]", "2"]], " ", 
    SqrtBox["z"], " ", 
    RowBox[{"Csc", "[", "z", "]"}]}], ",", 
   RowBox[{
    SqrtBox[
     FractionBox["\[Pi]", "2"]], " ", 
    SqrtBox["z"], " ", 
    RowBox[{"Csc", "[", "z", "]"}]}], ",", 
   RowBox[{"Csc", "[", "z", "]"}], ",", 
   RowBox[{"Csc", "[", "z", "]"}], ",", 
   RowBox[{"Csc", "[", "z", "]"}], ",", 
   RowBox[{"2", " ", 
    SqrtBox["z"], " ", 
    RowBox[{"Csc", "[", 
     RowBox[{"2", " ", 
      SqrtBox["z"]}], "]"}]}], ",", 
   RowBox[{
    SqrtBox["\[Pi]"], " ", 
    RowBox[{"Csc", "[", 
     RowBox[{"2", " ", 
      SqrtBox["z"]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{339, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84622038]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26017],

Cell["Calculate residue symbolically and numerically: ", "ExampleText",
 CellID->14932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Residue", "[", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Csc", "[", "z", "]"}], "k"], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14948],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", 
   FractionBox["1", "2"], ",", "0", ",", 
   FractionBox["3", "8"]}], "}"}]], "Output",
 ImageSize->{106, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->69168653]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", "\[Pi]", " ", "I"}]], 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"Csc", "[", "z", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{"-", 
       FractionBox["1", "4"]}], ",", 
      RowBox[{"-", 
       FractionBox["I", "4"]}], ",", 
      RowBox[{"+", 
       FractionBox["1", "4"]}], ",", 
      RowBox[{"+", 
       FractionBox["I", "4"]}], ",", 
      RowBox[{"-", 
       FractionBox["1", "4"]}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3495],

Cell[BoxData[
 RowBox[{"0.9999999999999982`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->754508350]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14648],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Csc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Csc"]], "InlineFormula"],
 " is a numeric function:"
}], "ExampleText",
 CellID->4189],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Csc", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10171],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Listable", ",", "NumericFunction", ",", "Protected"}], 
  "}"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->388945478]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"Csc", "[", 
   RowBox[{"2", "+", "E"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3695],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->145431563]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3637],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText",
 CellID->16649],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Csc", "[", 
  RowBox[{"10.", "^", "30"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15800],

Cell[BoxData[
 RowBox[{"-", "1.3222917907893128`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->421754773]
}, Open  ]],

Cell["Use arbitrary-precision evaluation instead:", "ExampleText",
 CellID->28134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Csc", "[", 
    RowBox[{"10", "^", "30"}], "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->17177],

Cell[BoxData[
 RowBox[{"-", "11.0966974982670552928`10."}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->217710583]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20641],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " is needed:"
}], "ExampleText",
 CellID->25304],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Csc", "[", 
    RowBox[{"10", "^", "65"}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4496],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \
\\!\\(Csc[100000000000000000000000000000000000000000000000000000000000000000]\
\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->6653338],

Cell[BoxData[
 RowBox[{"-", "1.5650112255530363967`4.919426826748236"}]], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->49075623]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "70"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Csc", "[", 
      RowBox[{"10", "^", "65"}], "]"}], ",", "20"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->27445],

Cell[BoxData[
 RowBox[{"-", 
  "1.56501122555303639674311602158207880314`20.000000000000007"}]], "Output",
 ImageSize->{159, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37228163]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14526],

Cell["\<\
Machine-number inputs can give high\[Hyphen]precision results:\
\>", "ExampleText",
 CellID->2178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Csc", "[", 
  RowBox[{
   RowBox[{"10.", "^", "3"}], "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15745],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.0151917795098913530583618959`12.954589770191015*^-434"}], 
  " ", "\[ImaginaryI]"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2544284]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MachineNumberQ", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4205],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25914783]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22353],

Cell["\<\
In traditional form parentheses are needed around the argument:\
\>", "ExampleText",
 CellID->27795],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"csc", " ", "x"}], TraditionalForm]], "Input",
 CellLabel->"In[1]:=",
 CellID->26542],

Cell[BoxData[
 RowBox[{"csc", " ", "x"}]], "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14489988]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"csc", "(", "x", ")"}], TraditionalForm]], "Input",
 CellLabel->"In[2]:=",
 CellID->27149],

Cell[BoxData[
 RowBox[{"Csc", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->311512844]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28965],

Cell["Various integrals and products:", "ExampleText",
 CellID->137],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"Csc", "[", "x", "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"b", " ", "z"}], "]"}], " ", 
     RowBox[{"Csc", "[", 
      RowBox[{"c", " ", "z"}], "]"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}], ",", 
   RowBox[{"\[Integral]", 
    RowBox[{
     SuperscriptBox["z", "2"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"b", " ", "z"}]], 
     RowBox[{"Csc", "[", 
      RowBox[{"a", " ", "z"}], "]"}], 
     RowBox[{"\[DifferentialD]", "z"}]}]}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32169],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Log", "[", 
    RowBox[{"Tan", "[", 
     FractionBox["x", "2"], "]"}], "]"}], ",", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["b", "2"], "-", 
      SuperscriptBox["c", "2"]}]], 
    RowBox[{"\[ImaginaryI]", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", 
       RowBox[{"(", 
        RowBox[{"b", "-", "c"}], ")"}], " ", "z"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "+", "c"}], ")"}], " ", 
        RowBox[{"Hypergeometric2F1", "[", 
         RowBox[{
          FractionBox[
           RowBox[{
            RowBox[{"-", "b"}], "+", "c"}], 
           RowBox[{"2", " ", "c"}]], ",", "1", ",", 
          RowBox[{
           FractionBox["3", "2"], "-", 
           FractionBox["b", 
            RowBox[{"2", " ", "c"}]]}], ",", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "\[ImaginaryI]", " ", "c", " ", "z"}]]}], 
         "]"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"b", "-", "c"}], ")"}], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"2", " ", "\[ImaginaryI]", " ", "b", " ", "z"}]], " ", 
        RowBox[{"Hypergeometric2F1", "[", 
         RowBox[{
          FractionBox[
           RowBox[{"b", "+", "c"}], 
           RowBox[{"2", " ", "c"}]], ",", "1", ",", 
          FractionBox[
           RowBox[{"b", "+", 
            RowBox[{"3", " ", "c"}]}], 
           RowBox[{"2", " ", "c"}]], ",", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "\[ImaginaryI]", " ", "c", " ", "z"}]]}], 
         "]"}]}]}], ")"}]}]}], ",", 
   RowBox[{
    FractionBox["1", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[ImaginaryI]", " ", "a"}], "+", "b"}], ")"}], "3"]], 
    RowBox[{"2", " ", "\[ImaginaryI]", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "-", 
           RowBox[{"\[ImaginaryI]", " ", "b"}]}], ")"}], "2"], " ", 
        SuperscriptBox["z", "2"], " ", 
        RowBox[{"Hypergeometric2F1", "[", 
         RowBox[{"1", ",", 
          FractionBox[
           RowBox[{"a", "-", 
            RowBox[{"\[ImaginaryI]", " ", "b"}]}], 
           RowBox[{"2", " ", "a"}]], ",", 
          RowBox[{
           FractionBox["3", "2"], "-", 
           FractionBox[
            RowBox[{"\[ImaginaryI]", " ", "b"}], 
            RowBox[{"2", " ", "a"}]]}], ",", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"2", " ", "a", " ", "z"}], "]"}], "+", 
           RowBox[{"\[ImaginaryI]", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"2", " ", "a", " ", "z"}], "]"}]}]}]}], "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[ImaginaryI]", " ", "a"}], "+", "b"}], ")"}], " ", "z", 
        " ", 
        RowBox[{"HypergeometricPFQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{
             FractionBox["1", "2"], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "b"}], 
              RowBox[{"2", " ", "a"}]]}], ",", 
            RowBox[{
             FractionBox["1", "2"], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "b"}], 
              RowBox[{"2", " ", "a"}]]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             FractionBox["3", "2"], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "b"}], 
              RowBox[{"2", " ", "a"}]]}], ",", 
            RowBox[{
             FractionBox["3", "2"], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "b"}], 
              RowBox[{"2", " ", "a"}]]}]}], "}"}], ",", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "\[ImaginaryI]", " ", "a", " ", "z"}]]}], 
         "]"}]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"HypergeometricPFQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", 
            RowBox[{
             FractionBox["1", "2"], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "b"}], 
              RowBox[{"2", " ", "a"}]]}], ",", 
            RowBox[{
             FractionBox["1", "2"], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "b"}], 
              RowBox[{"2", " ", "a"}]]}], ",", 
            RowBox[{
             FractionBox["1", "2"], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "b"}], 
              RowBox[{"2", " ", "a"}]]}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             FractionBox["3", "2"], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "b"}], 
              RowBox[{"2", " ", "a"}]]}], ",", 
            RowBox[{
             FractionBox["3", "2"], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "b"}], 
              RowBox[{"2", " ", "a"}]]}], ",", 
            RowBox[{
             FractionBox["3", "2"], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", "b"}], 
              RowBox[{"2", " ", "a"}]]}]}], "}"}], ",", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "\[ImaginaryI]", " ", "a", " ", "z"}]]}], 
         "]"}]}]}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Cosh", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[ImaginaryI]", " ", "a"}], "+", "b"}], ")"}], " ", "z"}],
         "]"}], "+", 
       RowBox[{"Sinh", "[", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[ImaginaryI]", " ", "a"}], "+", "b"}], ")"}], " ", "z"}],
         "]"}]}], ")"}]}]}]}], "}"}]], "Output",
 ImageSize->{565, 188},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->732426205]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Product]", 
   RowBox[{"k", "=", "1"}], 
   RowBox[{"n", "-", "1"}]], " ", 
  RowBox[{"Csc", "[", 
   RowBox[{"z", "+", 
    FractionBox[
     RowBox[{"k", " ", "\[Pi]"}], "n"]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26053],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["2", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "n"}]], " ", 
  RowBox[{"Csc", "[", 
   RowBox[{"n", " ", "z"}], "]"}], " ", 
  RowBox[{"Sin", "[", "z", "]"}]}]], "Output",
 ImageSize->{132, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->617437396]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28052],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["Csc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Csc"]], "InlineFormula"],
 " at integer points:"
}], "ExampleText",
 CellID->13178],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ArcTan", "[", 
     RowBox[{"Abs", "[", 
      RowBox[{"Csc", "[", 
       RowBox[{"x", " ", "y"}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11156],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21965155]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Csc", "[", 
   FractionBox["\[Pi]", 
    SuperscriptBox["2", "12"]], "]"}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17859],

Cell[BoxData[
 FractionBox["2", 
  SqrtBox[
   RowBox[{"2", "-", 
    SqrtBox[
     RowBox[{"2", "+", 
      SqrtBox[
       RowBox[{"2", "+", 
        SqrtBox[
         RowBox[{"2", "+", 
          SqrtBox[
           RowBox[{"2", "+", 
            SqrtBox[
             RowBox[{"2", "+", 
              SqrtBox[
               RowBox[{"2", "+", 
                SqrtBox[
                 RowBox[{"2", "+", 
                  SqrtBox[
                   RowBox[{"2", "+", 
                    SqrtBox[
                    RowBox[{"2", "+", 
                    SqrtBox["2"]}]]}]]}]]}]]}]]}]]}]]}]]}]]}]]]], "Output",
 ImageSize->{411, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9234094]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5089],

Cell[TextData[{
 "Generate ",
 Cell[BoxData[
  ButtonBox["Csc",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Csc"]], "InlineFormula"],
 " from integrals and sums:"
}], "ExampleText",
 CellID->31958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", "z"], 
  RowBox[{
   UnderoverscriptBox["\[Product]", 
    RowBox[{"k", "=", "1"}], "\[Infinity]"], 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[Pi]", "2"], " ", 
     SuperscriptBox["k", "2"]}], 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox["k", "2"]}], "-", 
     SuperscriptBox["z", "2"]}]]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20238],

Cell[BoxData[
 RowBox[{"Csc", "[", "z", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->527256221]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "2"}], "\[ImaginaryI]", " ", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"k", "=", "1"}], "\[Infinity]"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"\[ImaginaryI]", " ", "z"}]], ")"}], 
     RowBox[{
      RowBox[{"2", " ", "k"}], "-", "1"}]]}]}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27972],

Cell[BoxData[
 RowBox[{"Csc", "[", "z", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->165858382]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sum", "[", 
   RowBox[{
    FractionBox[
     RowBox[{"\[ImaginaryI]", " ", 
      SuperscriptBox["\[ImaginaryI]", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "k"}]}]], " ", 
      SuperscriptBox["2", 
       RowBox[{"2", " ", "k"}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        SuperscriptBox["2", 
         RowBox[{"1", "-", 
          RowBox[{"2", " ", "k"}]}]]}], ")"}], " ", 
      SuperscriptBox["z", 
       RowBox[{
        RowBox[{"-", "1"}], "+", 
        RowBox[{"2", " ", "k"}]}]], " ", 
      RowBox[{"BernoulliB", "[", 
       RowBox[{"2", " ", "k"}], "]"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", " ", "k"}], ")"}], "!"}]], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "1", ",", "\[Infinity]"}], "}"}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25656],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["1", "z"]}], "+", 
  RowBox[{"Csc", "[", "z", "]"}]}]], "Output",
 ImageSize->{78, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->187843073]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18147],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{
   RowBox[{"Csc", "[", "1", "]"}], ",", " ", "Algebraics"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8503],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->412337860]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4809],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcCsc",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcCsc"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sec",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sec"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sin",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sin"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Degree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Degree"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16701]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30219],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->30270]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->1725],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Cosecant.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/Csc/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Csc"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->154737046],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->838036]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Csc - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 8.0985238}", "context" -> "System`", 
    "keywords" -> {"cosec", "cosecant", "csc"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Csc[z] gives the cosecant of z. ", "synonyms" -> {}, "title" -> "Csc", 
    "type" -> "Symbol", "uri" -> "ref/Csc"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6015, 212, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->366868346]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 107675, 3517}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2257, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2880, 80, 40, 1, 70, "ObjectName",
 CellID->1807],
Cell[2923, 83, 530, 18, 70, "Usage",
 CellID->14449]
}, Open  ]],
Cell[CellGroupData[{
Cell[3490, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3968, 123, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4091, 129, 368, 13, 70, "Notes",
 CellID->18760],
Cell[4462, 144, 228, 9, 70, "Notes",
 CellID->24382],
Cell[4693, 155, 644, 24, 70, "Notes",
 CellID->4836],
Cell[5340, 181, 233, 8, 70, "Notes",
 CellID->9487],
Cell[5576, 191, 208, 7, 70, "Notes",
 CellID->31226],
Cell[5787, 200, 191, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[6015, 212, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->366868346],
Cell[CellGroupData[{
Cell[6400, 226, 148, 5, 70, "ExampleSection",
 CellID->514783465],
Cell[6551, 233, 72, 1, 70, "ExampleText",
 CellID->12725],
Cell[CellGroupData[{
Cell[6648, 238, 119, 4, 28, "Input",
 CellID->22301],
Cell[6770, 244, 190, 7, 55, "Output",
 CellID->384424790]
}, Open  ]],
Cell[6975, 254, 120, 3, 70, "ExampleDelimiter",
 CellID->3969],
Cell[7098, 259, 213, 8, 70, "ExampleText",
 CellID->12488],
Cell[CellGroupData[{
Cell[7336, 271, 119, 4, 70, "Input",
 CellID->21164],
Cell[7458, 277, 190, 7, 55, "Output",
 CellID->748100688]
}, Open  ]],
Cell[7663, 287, 121, 3, 70, "ExampleDelimiter",
 CellID->24124],
Cell[CellGroupData[{
Cell[7809, 294, 306, 11, 28, "Input",
 CellID->7534],
Cell[8118, 307, 2672, 48, 133, "Output",
 Evaluatable->False,
 CellID->34997371]
}, Open  ]],
Cell[10805, 358, 120, 3, 70, "ExampleDelimiter",
 CellID->2851],
Cell[CellGroupData[{
Cell[10950, 365, 212, 7, 70, "Input",
 CellID->13997],
Cell[11165, 374, 975, 33, 54, "Output",
 CellID->335418773]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12189, 413, 217, 7, 70, "ExampleSection",
 CellID->20067],
Cell[12409, 422, 60, 1, 70, "ExampleText",
 CellID->30265],
Cell[CellGroupData[{
Cell[12494, 427, 97, 3, 70, "Input",
 CellID->20840],
Cell[12594, 432, 176, 5, 36, "Output",
 CellID->480723526]
}, Open  ]],
Cell[12785, 440, 121, 3, 70, "ExampleDelimiter",
 CellID->24955],
Cell[12909, 445, 66, 1, 70, "ExampleText",
 CellID->16028],
Cell[CellGroupData[{
Cell[13000, 450, 174, 6, 70, "Input",
 CellID->1661],
Cell[13177, 458, 234, 7, 36, "Output",
 CellID->38222697]
}, Open  ]],
Cell[13426, 468, 125, 3, 70, "ExampleDelimiter",
 CellID->486764325],
Cell[13554, 473, 109, 3, 70, "ExampleText",
 CellID->18227],
Cell[CellGroupData[{
Cell[13688, 480, 142, 4, 70, "Input",
 CellID->30160],
Cell[13833, 486, 239, 6, 36, "Output",
 CellID->410613508]
}, Open  ]],
Cell[14087, 495, 139, 4, 70, "ExampleText",
 CellID->32666],
Cell[CellGroupData[{
Cell[14251, 503, 138, 4, 70, "Input",
 CellID->22237],
Cell[14392, 509, 217, 6, 36, "Output",
 CellID->860924312]
}, Open  ]],
Cell[CellGroupData[{
Cell[14646, 520, 136, 4, 70, "Input",
 CellID->24848],
Cell[14785, 526, 234, 7, 36, "Output",
 CellID->20720676]
}, Open  ]],
Cell[15034, 536, 120, 3, 70, "ExampleDelimiter",
 CellID->7048],
Cell[15157, 541, 214, 8, 70, "ExampleText",
 CellID->25565],
Cell[CellGroupData[{
Cell[15396, 553, 158, 5, 70, "Input",
 CellID->28221],
Cell[15557, 560, 274, 9, 36, "Output",
 CellID->633185192]
}, Open  ]],
Cell[CellGroupData[{
Cell[15868, 574, 597, 18, 70, "Input",
 CellID->13175],
Cell[16468, 594, 408, 15, 55, "Output",
 CellID->347868881]
}, Open  ]],
Cell[16891, 612, 121, 3, 70, "ExampleDelimiter",
 CellID->32514],
Cell[17015, 617, 195, 7, 70, "ExampleText",
 CellID->12147],
Cell[CellGroupData[{
Cell[17235, 628, 120, 4, 70, "Input",
 CellID->17362],
Cell[17358, 634, 269, 8, 36, "Output",
 CellID->521561547]
}, Open  ]],
Cell[17642, 645, 121, 3, 70, "ExampleDelimiter",
 CellID->29676],
Cell[17766, 650, 86, 1, 70, "ExampleText",
 CellID->3454],
Cell[CellGroupData[{
Cell[17877, 655, 119, 4, 70, "Input",
 CellID->21658],
Cell[17999, 661, 275, 11, 77, "Output",
 CellID->110530596]
}, Open  ]],
Cell[18289, 675, 238, 8, 70, "ExampleText",
 CellID->20784],
Cell[CellGroupData[{
Cell[18552, 687, 120, 4, 70, "Input",
 CellID->10688],
Cell[18675, 693, 213, 7, 49, "Output",
 CellID->727900659]
}, Open  ]],
Cell[CellGroupData[{
Cell[18925, 705, 106, 3, 70, "Input",
 CellID->16116],
Cell[19034, 710, 522, 21, 77, "Output",
 CellID->41830059]
}, Open  ]],
Cell[19571, 734, 121, 3, 70, "ExampleDelimiter",
 CellID->30180],
Cell[19695, 739, 90, 3, 70, "ExampleText",
 CellID->26429],
Cell[CellGroupData[{
Cell[19810, 746, 151, 5, 70, "Input",
 CellID->24537],
Cell[19964, 753, 451, 15, 54, "Output",
 CellID->55267700]
}, Open  ]],
Cell[CellGroupData[{
Cell[20452, 773, 102, 3, 70, "Input",
 CellID->18389],
Cell[20557, 778, 210, 7, 36, "Output",
 CellID->540843754]
}, Open  ]],
Cell[20782, 788, 120, 3, 70, "ExampleDelimiter",
 CellID->7004],
Cell[20905, 793, 91, 1, 70, "ExampleText",
 CellID->20101],
Cell[CellGroupData[{
Cell[21021, 798, 187, 6, 70, "Input",
 CellID->29384],
Cell[21211, 806, 659, 23, 51, "Output",
 CellID->99222650]
}, Open  ]],
Cell[21885, 832, 121, 3, 70, "ExampleDelimiter",
 CellID->31987],
Cell[22009, 837, 69, 1, 70, "ExampleText",
 CellID->5136],
Cell[CellGroupData[{
Cell[22103, 842, 184, 6, 70, "Input",
 CellID->29052],
Cell[22290, 850, 752, 25, 53, "Output",
 CellID->122999188]
}, Open  ]],
Cell[23057, 878, 120, 3, 70, "ExampleDelimiter",
 CellID->1528],
Cell[23180, 883, 70, 1, 70, "ExampleText",
 CellID->6366],
Cell[CellGroupData[{
Cell[23275, 888, 130, 4, 70, "Input",
 CellID->1472],
Cell[23408, 894, 434, 14, 53, "Output",
 CellID->321259888]
}, Open  ]],
Cell[23857, 911, 125, 3, 70, "ExampleDelimiter",
 CellID->427862131],
Cell[23985, 916, 203, 7, 70, "ExampleText",
 CellID->256137772],
Cell[CellGroupData[{
Cell[24213, 927, 136, 4, 70, "Input",
 CellID->30008825],
Cell[24352, 933, 233, 7, 50, "Output",
 CellID->139951346]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24634, 946, 239, 7, 70, "ExampleSection",
 CellID->26958],
Cell[24876, 955, 207, 7, 70, "ExampleText",
 CellID->4179],
Cell[CellGroupData[{
Cell[25108, 966, 233, 8, 70, "Input",
 CellID->28983],
Cell[25344, 976, 278, 10, 55, "Output",
 CellID->125010935]
}, Open  ]],
Cell[25637, 989, 121, 3, 70, "ExampleDelimiter",
 CellID->10823],
Cell[25761, 994, 78, 1, 70, "ExampleText",
 CellID->397],
Cell[CellGroupData[{
Cell[25864, 999, 102, 3, 70, "Input",
 CellID->11096],
Cell[25969, 1004, 376, 13, 36, "Output",
 CellID->666498618]
}, Open  ]],
Cell[CellGroupData[{
Cell[26382, 1022, 108, 3, 70, "Input",
 CellID->8901],
Cell[26493, 1027, 169, 5, 36, "Output",
 CellID->18642499]
}, Open  ]],
Cell[26677, 1035, 121, 3, 70, "ExampleDelimiter",
 CellID->14520],
Cell[26801, 1040, 195, 7, 70, "ExampleText",
 CellID->30503],
Cell[CellGroupData[{
Cell[27021, 1051, 325, 11, 70, "Input",
 CellID->13472],
Cell[27349, 1064, 576, 20, 54, "Output",
 CellID->166041]
}, Open  ]],
Cell[27940, 1087, 120, 3, 70, "ExampleDelimiter",
 CellID->1932],
Cell[28063, 1092, 222, 7, 70, "ExampleText",
 CellID->4953],
Cell[CellGroupData[{
Cell[28310, 1103, 712, 24, 70, "Input",
 CellID->10824],
Cell[29025, 1129, 515, 18, 49, "Output",
 CellID->53732146]
}, Open  ]],
Cell[CellGroupData[{
Cell[29577, 1152, 123, 4, 70, "Input",
 CellID->30057],
Cell[29703, 1158, 478, 17, 36, "Output",
 CellID->38576203]
}, Open  ]],
Cell[CellGroupData[{
Cell[30218, 1180, 142, 5, 70, "Input",
 CellID->2732],
Cell[30363, 1187, 1026, 34, 114, "Output",
 CellID->255457820]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31438, 1227, 223, 7, 70, "ExampleSection",
 CellID->16966],
Cell[31664, 1236, 74, 1, 70, "ExampleText",
 CellID->25690],
Cell[CellGroupData[{
Cell[31763, 1241, 342, 11, 70, "Input",
 CellID->868],
Cell[32108, 1254, 2603, 47, 70, "Output",
 Evaluatable->False,
 CellID->54244386]
}, Open  ]],
Cell[34726, 1304, 121, 3, 70, "ExampleDelimiter",
 CellID->22828],
Cell[34850, 1309, 87, 1, 70, "ExampleText",
 CellID->21479],
Cell[CellGroupData[{
Cell[34962, 1314, 408, 14, 70, "Input",
 CellID->14144],
Cell[35373, 1330, 24140, 400, 70, "Output",
 Evaluatable->False,
 CellID->37412290]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[59562, 1736, 234, 7, 70, "ExampleSection",
 CellID->29703],
Cell[59799, 1745, 139, 4, 70, "ExampleText",
 CellID->9449],
Cell[CellGroupData[{
Cell[59963, 1753, 138, 5, 70, "Input",
 CellID->18833],
Cell[60104, 1760, 205, 7, 36, "Output",
 CellID->216156979]
}, Open  ]],
Cell[CellGroupData[{
Cell[60346, 1772, 113, 4, 70, "Input",
 CellID->22910],
Cell[60462, 1778, 205, 7, 36, "Output",
 CellID->378990052]
}, Open  ]],
Cell[CellGroupData[{
Cell[60704, 1790, 118, 4, 70, "Input",
 CellID->21027],
Cell[60825, 1796, 241, 8, 36, "Output",
 CellID->424709465]
}, Open  ]],
Cell[CellGroupData[{
Cell[61103, 1809, 116, 4, 70, "Input",
 CellID->527],
Cell[61222, 1815, 187, 6, 36, "Output",
 CellID->108566232]
}, Open  ]],
Cell[61424, 1824, 121, 3, 70, "ExampleDelimiter",
 CellID->26393],
Cell[61548, 1829, 559, 23, 70, "ExampleText",
 CellID->17187],
Cell[CellGroupData[{
Cell[62132, 1856, 117, 4, 70, "Input",
 CellID->7863],
Cell[62252, 1862, 187, 6, 36, "Output",
 CellID->167645436]
}, Open  ]],
Cell[CellGroupData[{
Cell[62476, 1873, 135, 4, 70, "Input",
 CellID->2565],
Cell[62614, 1879, 356, 13, 36, "Output",
 CellID->282409822]
}, Open  ]],
Cell[62985, 1895, 121, 3, 70, "ExampleDelimiter",
 CellID->19251],
Cell[63109, 1900, 138, 4, 70, "ExampleText",
 CellID->27318],
Cell[CellGroupData[{
Cell[63272, 1908, 350, 13, 70, "Input",
 CellID->12081],
Cell[63625, 1923, 445, 16, 36, "Output",
 CellID->156629751]
}, Open  ]],
Cell[CellGroupData[{
Cell[64107, 1944, 100, 3, 70, "Input",
 CellID->28103],
Cell[64210, 1949, 256, 9, 36, "Output",
 CellID->628990311]
}, Open  ]],
Cell[CellGroupData[{
Cell[64503, 1963, 237, 7, 70, "Input",
 CellID->15238],
Cell[64743, 1972, 335, 11, 36, "Output",
 CellID->471520109]
}, Open  ]],
Cell[CellGroupData[{
Cell[65115, 1988, 104, 3, 70, "Input",
 CellID->17464],
Cell[65222, 1993, 157, 5, 36, "Output",
 CellID->72635573]
}, Open  ]],
Cell[65394, 2001, 120, 3, 70, "ExampleDelimiter",
 CellID->6572],
Cell[65517, 2006, 81, 1, 70, "ExampleText",
 CellID->7221],
Cell[CellGroupData[{
Cell[65623, 2011, 162, 6, 70, "Input",
 CellID->16922],
Cell[65788, 2019, 236, 8, 36, "Output",
 CellID->5797086]
}, Open  ]],
Cell[CellGroupData[{
Cell[66061, 2032, 163, 5, 70, "Input",
 CellID->10867],
Cell[66227, 2039, 299, 11, 36, "Output",
 CellID->382910431]
}, Open  ]],
Cell[66541, 2053, 120, 3, 70, "ExampleDelimiter",
 CellID->9298],
Cell[66664, 2058, 79, 1, 70, "ExampleText",
 CellID->25343],
Cell[CellGroupData[{
Cell[66768, 2063, 360, 12, 70, "Input",
 CellID->5234],
Cell[67131, 2077, 398, 13, 36, "Output",
 CellID->156657859]
}, Open  ]],
Cell[CellGroupData[{
Cell[67566, 2095, 137, 4, 70, "Input",
 CellID->24019],
Cell[67706, 2101, 669, 25, 67, "Output",
 CellID->239541838]
}, Open  ]],
Cell[68390, 2129, 121, 3, 70, "ExampleDelimiter",
 CellID->14062],
Cell[68514, 2134, 69, 1, 70, "ExampleText",
 CellID->8411],
Cell[CellGroupData[{
Cell[68608, 2139, 394, 14, 70, "Input",
 CellID->16811],
Cell[69005, 2155, 3039, 54, 70, "Output",
 Evaluatable->False,
 CellID->316504451]
}, Open  ]],
Cell[72059, 2212, 121, 3, 70, "ExampleDelimiter",
 CellID->17405],
Cell[72183, 2217, 65, 1, 70, "ExampleText",
 CellID->6881],
Cell[CellGroupData[{
Cell[72273, 2222, 247, 9, 70, "Input",
 CellID->3651],
Cell[72523, 2233, 162, 5, 36, "Output",
 CellID->913356526]
}, Open  ]],
Cell[CellGroupData[{
Cell[72722, 2243, 276, 10, 70, "Input",
 CellID->17898],
Cell[73001, 2255, 1310, 39, 78, "Output",
 CellID->203237614]
}, Open  ]],
Cell[74326, 2297, 121, 3, 70, "ExampleDelimiter",
 CellID->15842],
Cell[74450, 2302, 91, 1, 70, "ExampleText",
 CellID->5694],
Cell[CellGroupData[{
Cell[74566, 2307, 425, 15, 70, "Input",
 CellID->5084],
Cell[74994, 2324, 227, 7, 36, "Output",
 CellID->510801893]
}, Open  ]],
Cell[75236, 2334, 121, 3, 70, "ExampleDelimiter",
 CellID->16500],
Cell[75360, 2339, 49, 1, 70, "ExampleText",
 CellID->10955],
Cell[CellGroupData[{
Cell[75434, 2344, 181, 6, 70, "Input",
 CellID->31155],
Cell[75618, 2352, 818, 29, 52, "Output",
 CellID->173646128]
}, Open  ]],
Cell[76451, 2384, 119, 3, 70, "ExampleDelimiter",
 CellID->650],
Cell[76573, 2389, 242, 8, 70, "ExampleText",
 CellID->6688],
Cell[CellGroupData[{
Cell[76840, 2401, 1255, 43, 70, "Input",
 CellID->5939],
Cell[78098, 2446, 828, 30, 82, "Output",
 CellID->84622038]
}, Open  ]],
Cell[78941, 2479, 121, 3, 70, "ExampleDelimiter",
 CellID->26017],
Cell[79065, 2484, 87, 1, 70, "ExampleText",
 CellID->14932],
Cell[CellGroupData[{
Cell[79177, 2489, 343, 12, 70, "Input",
 CellID->14948],
Cell[79523, 2503, 277, 9, 51, "Output",
 CellID->69168653]
}, Open  ]],
Cell[CellGroupData[{
Cell[79837, 2517, 560, 20, 70, "Input",
 CellID->3495],
Cell[80400, 2539, 256, 7, 36, "Output",
 CellID->754508350]
}, Open  ]],
Cell[80671, 2549, 121, 3, 70, "ExampleDelimiter",
 CellID->14648],
Cell[80795, 2554, 185, 7, 70, "ExampleText",
 CellID->4189],
Cell[CellGroupData[{
Cell[81005, 2565, 104, 3, 70, "Input",
 CellID->10171],
Cell[81112, 2570, 246, 8, 36, "Output",
 CellID->388945478]
}, Open  ]],
Cell[CellGroupData[{
Cell[81395, 2583, 153, 5, 70, "Input",
 CellID->3695],
Cell[81551, 2590, 161, 5, 36, "Output",
 CellID->145431563]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[81761, 2601, 225, 7, 70, "ExampleSection",
 CellID->3637],
Cell[81989, 2610, 112, 3, 70, "ExampleText",
 CellID->16649],
Cell[CellGroupData[{
Cell[82126, 2617, 121, 4, 70, "Input",
 CellID->15800],
Cell[82250, 2623, 193, 6, 36, "Output",
 CellID->421754773]
}, Open  ]],
Cell[82458, 2632, 82, 1, 70, "ExampleText",
 CellID->28134],
Cell[CellGroupData[{
Cell[82565, 2637, 175, 6, 70, "Input",
 CellID->17177],
Cell[82743, 2645, 200, 6, 36, "Output",
 CellID->217710583]
}, Open  ]],
Cell[82958, 2654, 121, 3, 70, "ExampleDelimiter",
 CellID->20641],
Cell[83082, 2659, 230, 8, 70, "ExampleText",
 CellID->25304],
Cell[CellGroupData[{
Cell[83337, 2671, 174, 6, 70, "Input",
 CellID->4496],
Cell[83514, 2679, 486, 9, 70, "Message",
 CellID->6653338],
Cell[84003, 2690, 212, 6, 36, "Output",
 CellID->49075623]
}, Open  ]],
Cell[CellGroupData[{
Cell[84252, 2701, 306, 11, 70, "Input",
 CellID->27445],
Cell[84561, 2714, 236, 7, 36, "Output",
 CellID->37228163]
}, Open  ]],
Cell[84812, 2724, 121, 3, 70, "ExampleDelimiter",
 CellID->14526],
Cell[84936, 2729, 108, 3, 70, "ExampleText",
 CellID->2178],
Cell[CellGroupData[{
Cell[85069, 2736, 139, 5, 70, "Input",
 CellID->15745],
Cell[85211, 2743, 266, 8, 36, "Output",
 CellID->2544284]
}, Open  ]],
Cell[CellGroupData[{
Cell[85514, 2756, 105, 3, 70, "Input",
 CellID->4205],
Cell[85622, 2761, 161, 5, 36, "Output",
 CellID->25914783]
}, Open  ]],
Cell[85798, 2769, 121, 3, 70, "ExampleDelimiter",
 CellID->22353],
Cell[85922, 2774, 110, 3, 70, "ExampleText",
 CellID->27795],
Cell[CellGroupData[{
Cell[86057, 2781, 119, 4, 70, "Input",
 CellID->26542],
Cell[86179, 2787, 181, 6, 36, "Output",
 CellID->14489988]
}, Open  ]],
Cell[CellGroupData[{
Cell[86397, 2798, 124, 4, 70, "Input",
 CellID->27149],
Cell[86524, 2804, 187, 6, 36, "Output",
 CellID->311512844]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[86760, 2816, 224, 7, 70, "ExampleSection",
 CellID->28965],
Cell[86987, 2825, 68, 1, 70, "ExampleText",
 CellID->137],
Cell[CellGroupData[{
Cell[87080, 2830, 686, 22, 70, "Input",
 CellID->32169],
Cell[87769, 2854, 6126, 176, 209, "Output",
 CellID->732426205]
}, Open  ]],
Cell[93910, 3033, 120, 3, 70, "ExampleDelimiter",
 CellID->7970],
Cell[CellGroupData[{
Cell[94055, 3040, 285, 10, 70, "Input",
 CellID->26053],
Cell[94343, 3052, 343, 12, 36, "Output",
 CellID->617437396]
}, Open  ]],
Cell[94701, 3067, 121, 3, 70, "ExampleDelimiter",
 CellID->28052],
Cell[94825, 3072, 192, 8, 70, "ExampleText",
 CellID->13178],
Cell[CellGroupData[{
Cell[95042, 3084, 467, 15, 70, "Input",
 CellID->11156],
Cell[95512, 3101, 2721, 49, 70, "Output",
 Evaluatable->False,
 CellID->21965155]
}, Open  ]],
Cell[98248, 3153, 120, 3, 70, "ExampleDelimiter",
 CellID->4278],
Cell[CellGroupData[{
Cell[98393, 3160, 185, 6, 70, "Input",
 CellID->17859],
Cell[98581, 3168, 746, 27, 108, "Output",
 CellID->9234094]
}, Open  ]],
Cell[99342, 3198, 120, 3, 70, "ExampleDelimiter",
 CellID->5089],
Cell[99465, 3203, 202, 8, 70, "ExampleText",
 CellID->31958],
Cell[CellGroupData[{
Cell[99692, 3215, 443, 16, 70, "Input",
 CellID->20238],
Cell[100138, 3233, 187, 6, 36, "Output",
 CellID->527256221]
}, Open  ]],
Cell[CellGroupData[{
Cell[100362, 3244, 449, 15, 70, "Input",
 CellID->27972],
Cell[100814, 3261, 187, 6, 36, "Output",
 CellID->165858382]
}, Open  ]],
Cell[CellGroupData[{
Cell[101038, 3272, 930, 31, 70, "Input",
 CellID->25656],
Cell[101971, 3305, 250, 9, 51, "Output",
 CellID->187843073]
}, Open  ]],
Cell[102236, 3317, 121, 3, 70, "ExampleDelimiter",
 CellID->18147],
Cell[CellGroupData[{
Cell[102382, 3324, 166, 5, 70, "Input",
 CellID->8503],
Cell[102551, 3331, 162, 5, 36, "Output",
 CellID->412337860]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[102774, 3343, 310, 9, 70, "SeeAlsoSection",
 CellID->4809],
Cell[103087, 3354, 1409, 53, 70, "SeeAlso",
 CellID->16701]
}, Open  ]],
Cell[CellGroupData[{
Cell[104533, 3412, 314, 9, 70, "TutorialsSection",
 CellID->30219],
Cell[104850, 3423, 182, 4, 70, "Tutorials",
 CellID->30270]
}, Open  ]],
Cell[CellGroupData[{
Cell[105069, 3432, 320, 9, 70, "RelatedLinksSection",
 CellID->1725],
Cell[105392, 3443, 179, 4, 70, "RelatedLinks"],
Cell[105574, 3449, 195, 4, 70, "RelatedLinks"],
Cell[105772, 3455, 381, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[106190, 3473, 319, 9, 70, "MoreAboutSection",
 CellID->154737046],
Cell[106512, 3484, 154, 3, 70, "MoreAbout",
 CellID->838036]
}, Open  ]],
Cell[106681, 3490, 27, 0, 70, "History"],
Cell[106711, 3492, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

