(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    225436,       4835]
NotebookOptionsPosition[    215367,       4504]
NotebookOutlinePosition[    216847,       4544]
CellTagsIndexPosition[    216760,       4539]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Graphics Primitives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Three\[Hyphen]Dimensional Graphics Primitives\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polygon" :> Documentation`HelpLookup["paclet:ref/Polygon"], 
          "Rectangle" :> Documentation`HelpLookup["paclet:ref/Rectangle"], 
          "GraphicsComplex" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsComplex"], "Sphere" :> 
          Documentation`HelpLookup["paclet:ref/Sphere"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Polygon\"\>", 2->"\<\"Rectangle\"\>", 
       3->"\<\"GraphicsComplex\"\>", 4->"\<\"Sphere\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Objects" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsObjects"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicGraphicsLanguage"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graphics Objects\"\>", 
       2->"\<\"Symbolic Graphics Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Cuboid", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Cuboid",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cuboid"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["min", "TI"]], ",", 
         SubscriptBox[
          StyleBox["y", "TI"], 
          StyleBox["min", "TI"]], ",", 
         SubscriptBox[
          StyleBox["z", "TI"], 
          StyleBox["min", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a three\[Hyphen]dimensional graphics primitive that \
represents a unit cuboid, oriented parallel to the axes. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Cuboid",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cuboid"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["z", "TI"], 
           StyleBox["min", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["max", "TI"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["max", "TI"]], ",", 
          SubscriptBox[
           StyleBox["z", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]specifies a cuboid by giving the coordinates of \
opposite corners. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->17644]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Each face of the cuboid (rectangular parallelepiped) is effectively a ",
 Cell[BoxData[
  ButtonBox["Polygon",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Polygon"]], "InlineFormula"],
 " object, with its front face on the outside. "
}], "Notes",
 CellID->19512],

Cell[TextData[{
 "You can specify how the faces and edges of the cuboid should be rendered \
using the same graphics directives as for polygons. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->134118418]
}], "Notes",
 CellID->29482],

Cell[TextData[{
 "Cuboids can be specified as transparent using ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " directives. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->94273435]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->2815],

Cell[TextData[{
 "The coordinates of the corners of the cuboid can be given using ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->53106414]
}], "Notes",
 CellID->5105],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cuboid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cuboid"], "[", "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cuboid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cuboid"], "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0"}], "}"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->25726]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->43950327],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->330370630],

Cell["A unit cuboid:", "ExampleText",
 CellID->60734798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Cuboid", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25858966],

Cell[BoxData[
 Graphics3DBox[CuboidBox[{0, 0, 0}]]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->507014065,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNmPtOE0EUxqe73d5oC20ptFzKHUQE0oCIVbzFYLwg6BsQbAKJBoP877Po
I/k+G505M92ZfjOLW5Hopgzd6fl935mzt9k5OL487X46vjw7OZ59cXH8+fTs
5Mvs/vkF7/JTjLEP/O9jg/HvP/k3+nsWhiHzu91uSBubEQ17zNuAd87S3h5v
Pb7nq/+yt8Nbv9fLpXoqvFUquwbn8wDvfP2rHbVjqvOoQESlxe+MycAWxW0p
P0+pZUWcSDL8dhGFsmmKbYNmwYgVHzN2E2KLIjbDv4D0FEXfgSzKlG0UzT8e
VLRJ3G1wqQgua3J6DJNErIBTjaqn8/JE42tqgqgl8BkDypcNITq7BaAaTkp7
SWoWMpwAKg1Ug6gWeE0DFUCG40RNgteMk9JekmqC1zxQGfAaI2ocqEUnpb0k
NQoZLgOVBapOVBW8VoHKQYajRI0oque15qS0l6RKRobCazO6HuUJiFSNqCHI
sJ2IykOGW0DlgaoSlVMUjZjJbQfGVoCKVCKyd9UJatdJab9k1BBQI4moImQ4
3E/xQAG4Ke0lqSx43Qeq1KNUSHkwSnklo8pAlRJRw1CN4gCU9kpGjQA1RHEZ
oDpAVSDDwgCU9kpGVeF45QejlJebegDXGFK5RFQNqkE15/fXfuohZFiDcQ1I
qQxvkhqFcWVunNLVuA6VBmrv71Kqhv8fVYfKB9egfKAeOSldw39PmeOSc4z+
GrqpjjGrlNv3H6Hc1b5XKtwz5rNyC4TEFVcEHRFGs950N5r1MrZtKeVBCe80
hpKRURsqIeYHJVDCu6pbacPKqEo6+t5XSaSzZunUIZ9kOrcsnSbo4PPMrbPo
qNA0KOHz1K00Z2U0Dzo4B5A6dDKZB5+1LKVlp5I++mrKl9Y9jE1ZKqt/oNK0
VNZBBWdRLpW6o8pt0Ckm0Kla2eyACs46XSrDlkoHVHDG21MxD1PRUnkEVwTO
05WKcc7kHXV56sxF5+9ZKhkrk33QyP9Ww7c0XoFGDo6P11cTRpsQfAtc1skJ
7D3UK+N2CKKqK5934IDvlL3Ryd2oR0RwUsCHoIBvwJ51f6d8eMARkPierkYX
6jc40xdrk4bjkiI6Yz0PjqBSuBIhOZrLWdU6BNaDKks2F5PxG8jYTRcclToQ
ZMwqjaSGYjxfi8axiiSpklUdcgrUoxo8ys6a0KjSKjFDezgmo5cUH406iq84
xm1eNzqPaozyc94IYRGVinRHrTE+UXHizPKjuHqM6q4RLWTkk2bcUr0LcfIt
p+EY1YYRKcop3ymbMf4roCtXDCYt/0UV5ytVua4zFaM6yZtARQsZuWrXslQb
4C7XQGdCe32kCv7z9NOcpVgE5xXqnrfisuC8Rt0LjvHQ3dJw3qTIJUNRnsw9
x236fZm3Gb63K+1SvwDIs5LX\
\>"]]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellLabel->"In[2]:=",
 CellID->71137257],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->341079342],

Cell["Two unit cuboids:", "ExampleText",
 CellID->148782367],

Cell[CellGroupData[{

Cell["\<\
Graphics3D[{Yellow,Cuboid[{0,0,0}],Blue,Cuboid[{0.5,0.5,0.5}]}]\
\>", "Input",
 CellLabel->"In[1]:=",
 CellID->13138992],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[1, 1, 0], CuboidBox[{0, 0, 0}]}, 
   {RGBColor[0, 0, 1], CuboidBox[{0.5, 0.5, 0.5}]}}]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->619344078,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->138122153],

Cell["Cuboids with different sizes:", "ExampleText",
 CellID->409176069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Yellow", ",", 
    RowBox[{"Cuboid", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "3", ",", "1"}], "}"}]}], "]"}], ",", "Blue", ",", 
    RowBox[{"Cuboid", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "2", ",", "3"}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->630930797],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[1, 1, 0], CuboidBox[{0, 0, 0}, {1, 3, 1}]}, 
   {RGBColor[0, 0, 1], CuboidBox[{2, 1, 1}, {4, 2, 3}]}}]], "Output",
 ImageSize->{154, 145},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->396257291,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy9WltvG0UY3Xh37Y3v8SWJk7iJc22Ttuk1BFqglLaU0qqAiqASIKIqqBVC
RaHv/Q288A4/if9jwcw3Z+312XFmY9JYzsaf58w5Z6673v2eHLx5efjrwZtX
Lw5WPjs6+O3lqxe/rzx4faS+8qc8z/tT/f0x76nP/6pP8vdLv9/3/MPDw768
vPP64L1Ux1B9eUGin9UxpyIf/823L9RRV8zjW1PzANF0glcdvS0p/RF1StbS
71G3qqNg4El92JTy56hd11E4KAfHhmC+BUfzGMwz8LSp7TmKVwX9NRjnM6Gf
gnuBSn2Ke4J+Au4ulQYUrwj6EbiXM6EfgnuVSkOKhc27D+51Ks1TfE7Qd4He
yoS+Ayc7DrT0gvchuC9RaYHiJUHfAveVTOh9cF+j0ojiRUHvgftmJvR1cL9H
pdMUy8zwroL7AyotUtwR9GVw386Evgjuj6m0RLHMaO8CuD+h0jLFc4LeAve9
TOh1cD+g0grFs4JeBffnmdDL4P6CSqsUyyqX8ddfPnWgW4JegBO9snJqm3yc
qdYcNOJanv/6kocXu6xRLPuVeI11/ZhAf+j/JSyPqFad4oawNMhHXrMEhsUQ
cQ/beerkJtI84YAHnh5S3RlbLGOY9FRKtEwT5fRBYlPrfibWEjmsEKtPrDxr
G7Z+MKtqeP4Bd524A+L+1DaiPOKyG2jH5oRgXk1iDon5bmbm2LUWSPMWiJdX
fIvi6pAX32q3LWKNiPUOsZhdfljOO0Ulk8o0qfDeprtTT03eKwx7NDqik/B7
soTe5iwa5YwaRdL4KCY2w+UVFL/Ennc08M77dwadEunoc4zQqsNb0Xo7ouVZ
2pRVq0xae9AKhB9i6p3XhyDWO7IoFjMqVkjxGhQLLsWjYxQTM69NelXS2+2b
Haxo0wuTerZ+nc6kWSPNHbSxbNP0h5o5fUjU4zO+6Jpro5E+Zv066W9Bv+bQ
9y29nFVzhjTXoNnIoJmsp3tYw6fH6DaUrp4WLdJbhl7boReQXgg9/j1QGKNf
U/qyQv7+Z6T9DfKzCD/zDj9qyh0F8MDX9uM8lOEhcniYg4dF8lCw9UlgdjLz
4mvkcU6KyoleTWVywrOhBSfnHE5CGp1jfCTWX4T+qDlc1OGi53ChxuiIr82N
cj7VAyG0mw7tMrTXM2gf1wP5MT58jMScw4dcwajwvGNensBH8resqrDgcGBG
T5RE2eWkYBmNcb1wzqGdP13tMHmV6WXQDyfQT/edaxRyGOOuw01wJm4GKsqN
NrTocOW/E1e8t+ZP6Cp3Jq4KWVyFA1bMuu3/uaeEVi9RFi/BkPVd+Zh2+Kif
kY9iFh9gzTIqtr3FrlzKoJw7VcVy1raOWQ025eNWg3HBd0KrDhe1M3FRc7io
kotNddAnpcihzrMusKrLXRxVaYlUK6S6pg5yh4b6IDwVFw3qAz7Hl8nNCtzw
r7rTcdN0uCmRmy7clMhNcCpuWg43RXKzADf8a0xB5P5ENJGLtsPFNLmYxSxt
Wly49gy7g1mHg4gcNNEPcxM74Kcy8w4HBXJQhwP+fZQ74b5hd9NxuMmTmwrc
LMtCGbrRbzV+jlnhWz0sODyE5KEID2uyPBIeJtRfdOgHpJ/HrNw8Jf0lh75P
+j7avzMyIyZV7/bN3s1njByrqiq7Q0WZdq5dwK64TO3t6MPw2YF6a/D1oVam
fc9o8R2SnkVLSBMtux6vJIhFlrVsZ18l9pY6yISQGy/xI5WbE/OvEX8d7vPq
vx6zPWLWfcT343JW5nViLoO5GM8C9M1VPdd1pL47gorrytSuuEGKERQrpHgJ
iuov/i0jwpOpbpJqANU6qeqrUt+soX6yR133euyqWwlVmWz6HEaKW1AsUzuz
KcqEMV9KPoUGzGJWbKAH68TMdxXdzBtg9vv99Dz0gEWTemhPm1T9E6uuQlWf
weL7djIjYhfowSW0s0Nj5lvWV1olfrbLvyLyaFtEah20r2tpH6+5qZSaPsfo
naFOajmolUitjbb1SC2XSW0ebRs8bfPMS/dmlZQaaNemVgqHSubZAvdjWqsN
rTlC1kmnihZta50goTNWY/TKXoec8cIaJbRld2RGZFGoQaHrUIigcI3Gxa1Q
wgxYcSgE6Ce1t+MJ/xDL13Rplahvz7ERlWCoYlpxK26FGU65izGlPmjeNHf8
FIIzcjR3ADZNZntKMZ41B9bt8f3S1+99sNvuUdnZZb0cprN8ZohZnf/FP6+r
MMVsywJqENsufHK+Q2Dx2R+sol1CN4l1G6ycT+anPRKCW98i5g20nnPP0sxx
bh4ztomxB69dwuVSjHxHh+fALDEvgZnzzZLM6Xu7FyjWLe2g1XJ9EA7KMGsM
T6GfyEW0/WaCqxlwbR/DxRlamxQvEGcFLZV5MZKnaPh4v9mgeJH4IvDdSOCG
7uIcF2ZZIhYfLd0H3tTmp7E9inWGnj6x3B6pxflNvC/+NDKmNdRllM7n1N1j
zu+cwdOl+DugzX1tzsxZovgZ0OYZfhMOGPUlUCaThddnh+LHQJvsp1kq5TX4
EGiTjTbXt2eJ3gPKZP2xIju6A7TJm+QzKufn3AbaZJ4uwgGj9oEyObTc6zwq
N4CW9WLyN1P7/jC+AvRlQS/DAaMuAiVZl6kZyDM0zkfcEzTvJpw9tAHu9wW9
BgeM6gH1oaB4JfH67wIt+VGp3YCvkTtA3xd0nB/JqDZQknmX2vV4r50B+omg
eefl3+xVoL8S9E5/mK2dRBWB+kZQcp4Y2bsilD+X8suJ2novClD6g5TqnS+v
ogOJvKn/AI9KciA=\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->270697137],

Cell["Differently styled cuboids:", "ExampleText",
 CellID->623678635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", 
      RowBox[{"Cuboid", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
      RowBox[{"Cuboid", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "Dashed", "]"}], ",", 
      RowBox[{"Cuboid", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Directive", "[", 
        RowBox[{"Thick", ",", "Dashed", ",", "Blue"}], "]"}], "]"}], ",", 
      "Pink", ",", 
      RowBox[{"Cuboid", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->58513546],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], CuboidBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNmIlOU0EUhqf3dl/pBi1lKWUTUUgDYq2CSwzGBUHfoMEmkGgwyKv4Ar5n
ozNnpnem/0zxViR6U4be6fn+/8y529w56l2d9b/0rs5Pe81Xl72vZ+en35qH
F5e8y48wxj7xv881xr//5N/o78VgMGB+v98f0MYWRcOe8jbGO5u0t89bj+/5
6r/s7fLWH/ZyqaEKb5VKx+B8HuBdVA/sqD1TnUfFRFRU/M6YDFyguB3l5ym1
hIgTSQ6OO0Eom6fYNmimjVjxMWO3ITYrYuP8C0jPUfQ9yCJP2QbR/ONBRevE
3QWXouASJqfH0CBiHZzKVD2dlycaX1OzRK2CzzRQvmwI0dktA1VzUtpLUk3I
cBaoKFA1ohbAax6oGGQ4Q1QDvBadlPaSVB28WkDFwWuaqBmgVpyU9pJUBTJc
AyoBVJWoEnhtAJWEDCtETSlq6LXppLSXpHJGhsJrO7ge5QmIVJmoDGTYDkWl
IMMdoFJAlYhKKopGzOS2B2NLQ0WKATm86gTVcVLaLxyVAWoqFJWFDAujFA8U
gJvSXpJKgNcjoHJDSoXkJ6OUVzgqD1QuFFWAamQnoLRXOGoKqAzFxYHqAlWE
DNMTUNorHFWC45WajFJebuoxXGNIJUNRZagG1ZzfX0epJ5BhGcY1IaUyvE2q
AuOK3zqlq3ETKgrU/t+lVA3/P6oKlY/dgPKBOnBSuob/njLHJecYozV0U11j
Vim3H2ff5a72vVbhoTGflVtMSFxzRdARYTTrjfaDWS9ju5ZSCpTwTmMoGRm1
oRJifpADJbyrupW2rIxKpKPvfcVQOpuWThXyCadzx9Kpgw4+z9w6K44KzYMS
Pk/dSktWRi3QwTmA1KGTyTz4bMFSWnMq6aOvpnxR3cPYnKWy8QcqdUvlPqjg
LMqlUnVUuQ062RA6JSubPVDBWadLpWCpdEEFZ7xDFfMwZS2VA7gicJ6uVIxz
JuWoy3NnLjp/z1KJW5kcgkbqtxq+pfEGNJJwfLyRmjDahOB74BJOTmAfoV5x
t0MsqLry+QAO+E45HJ3cDXpEBCcFfAwK+AbsWfd3yocHnACJ7+lqdAP9Bmf6
Ym2icFwiRMet58EJVApXIiRHczmrWsfAelBlySbHZPwOMnbTaUeljgQ5ZpVG
Upkxnm9F41hFklTOqg45xdSjGjzyzprQqKIqMUO7MCaj1xQfjDqILzrGbV43
Oo/SGOWXvBHCIioS6FasMT5TceLM8oO46hjVjhEtZOSTZsZSfQBx8i2n5hjV
lhEpyinfKetj/NdBV64YNCz/FRXnK1W5rjM3RrXBm5iKFjJy1W7BUq2Bu1wD
XRzY6yMl8G/RT0uWYhac16m7ZcUlwHmTupcd46G7peG8TZGrhqI8mYeOu/T7
Gm/jfK8j7SK/AHpv5VM=\
\>"]], ",", 
   Graphics3DBox[
    {EdgeForm[Thickness[Large]], CuboidBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNmP1uE0cUxTf75Y/g4Dgx+SBNHExCgNC0aRpIaAAhAVKAIB4hQpZAoqIK
/M+ztI/E+1h05s6sPXt8blhQK1glI6/3/s49c+/ueneen354Pfjz9MObV6e9
J2enf71+8+p97/G7M/NVMhVF0cD8v12MzOfP5pP8PxwOh1EyGAyGskU9O0T3
zZiZL9dl78iMsdmLJdbqyBa5o3f90SiRXdliO1hVF+xV75gxYZH5u1sffWQU
mWPmw5qE7AeZUytpAlHbRf6maOcFkYbqqxL0K6jXi1g79eHfZ6Pw6CeJ31Fm
Oj3JeW+O21a8tQoud1yYckVCb4DDti2U74CNju1Q7BvgslBbis85Qo+q6fu/
JMiG4rgLCkmR39dpWcL7Sv5FQmP+RUF6Sv5lUEghv3O/ClVbASqDqrmcK4rr
NUKj60uCLCmu10EhB9cLEr5A8tugPtA1cO9ydxX3m4RG9/OCdBT3W6BQB/dd
CW8r+W8SGvPPCdJS8t8Kr3l/ldTAg5vBtFLBHaJQhyo6Dw1lFruKAs5kVrC6
V7Hn3h4hG+C+M6LkLjVKvU/YJvgeZyzuiXa7rZDo9yKl70DPLkDOdmUK881U
IltQH+eyNlEf5GbA58yYS8bcAaHQ54Uy6X0ieRHytSpTmG+6EtkmZLMSOQtO
Xb58oqKMw4yNimwHutgcc0E3DsmZim4bZdLPUSPRb60y3YG89a8iMa9w5tcC
6/R/8HPgvDZmg1rf/WbyD+jt/PmUr9T3prCiwphnBqzoV7JBXY6A7ILX/L+g
/Ax/PCqZqOTReWeYvw8EbFCTewqJfUgpbTtoU9hf3W5l6sDnlFeDc2ablWlf
o999zqSg//k0NH9RbIdzzl+utquoZWb40n3KKcYT3dhRNBtEE++5muZ2ULM2
0WnrOkHlryvOOlA7dj9PqOKmongJFNlvKCj6jvQVxSUya3wSSKliL6hdj6jg
8wtXWVF8XSGKLaooE/bfWGJJUdwkivgs6BXTsaJ5k1H0bkAvFHclrXm8Rr3W
z6A18uXvMkxr1muhr10yT/a0HJc0XTdaylz3iWajomZT0TxUNMMa+heX0jVb
U/TuQQ3x3cJrBVdZFnTjEdBfdKK4eExmhe+4bFaoc0x08E3b6eC5dELIjJKl
zpndl1CDnHR4qtRh973GhnOOJ36ziqwviN+U0jYpvs8yOqE0PqtbitUKV6Ec
XSO5T2DOPG+D5H0OZAz9cWSTVEvIdET6Dk2ZPdsZ1x22cvCsmGnmU8o2ztUi
Lp8WTDpiBn7dVN5GMcfTsJol9TZRPw5mEirPklkfB/Uaq3aIB3v9ZZF7dnLV
mCe5H5ioXJyOzuOAYKtPh56QVThzzD0JLBDtPYh073uLRHOHuLBi7s17mWhv
GaJGfLs1l8uE6IMbt77GVgdXFTduFXSVaC8obtwa9prPYdvWARd9iVgnmtNE
04Zck5grgWauZN+WyKt2zMI7rD2FQg+/yJEN8JCQ3HtybNOMdmn7wEVO/QsO
gzOI\
\>"]], ",", 
   Graphics3DBox[
    {EdgeForm[Dashing[{Small, Small}]], CuboidBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVmPtOE0EUxpfudkuB3rkUhELBBkRRQfACeAl/QKLghTcgpAkmGg36v8+i
j+T7NDrnnNmd6TfTumg0cQPbdnt+3/fNme10uydnny+6788+vz0/Wzq6PPt4
8fb809Lhh0t1KBwJgqCr/t81A/X8h3rG/we9Xi8Iu91uj7dgiXbBM7WP1ME2
v3qs9lQSqsecepSaPf0qokclZd55qOvpnfDDxpcgIm+2UPtFrrmvadIM1dvR
gLptq45cClSXT+ukNGhx7ab2zfGYVI16pPIi7ULNfL0McjDma0zfAacJouKU
oj82W+DqDaguU3XBrhZ/SjfPxLrVxbqT6Oslppplag18Gh4yGSt5yVg6Vifo
zSmgQqDmmFqxZnQWiEgwLjfp2pBuzkPhuGaYbEHCBSZN8yJI2GRq3krYBiIP
CcVnFnyWvZTxEWoGxtUBKgavaaamrHRr0IkYfISoW+nIZx2ogqd/DSarkPAW
kKOQcJKpspWQqxVFoNAK6aNNWqHHIe0meBaBkqRFSHovMxXk01ETo7YdYMeA
rTM7anWMqIdAjUNvapmoCaCqV6BMwmxUCbwqV6CMF1Ay3Q5VTigtXGaqAF6P
BlHay6XoKVIVz/k87vXbhU9cBToycQXKpBxGmZRVoIYlNFQNEo5xXQzUHnzS
auA1jDJedZizYiaqAQlHHYqAYRQldCmf1yR4Ff46ZbohVB6o/f+X0ueGSxGA
1BT0MM7k5acioB7/FvUEPpXYjWHU4B7+E0p3/k+oENa7p7/oYd6h0EuuH7JQ
u0DR93AQfvvekwVIe5vu+FUeWNfmssVKwp7RRiadbUenyDq41vxKZ0vp0MsS
0HXov5++7aSogQ6uyaKTA52bnt5OsZJZ3fGbxFWip2tOojnobxVmO/Im6jg6
CzCybDorur9toCswO3665elLB5TwmsOvNK9zrANd8tLcXNNUtTWdftyG+cGr
M60UmQ4FwbSjsgWzM55Bpe7pyg6MC68wQ9RRW8VJswsqeHXrqKgXJd3ZJ8CO
ZWCLToIDUCnC/CQq9uTESoUOHEIvRzOwOSfBC1ApwIz0qwS8UflLSO7nCDuF
Svw9J5U0q+ndB0UQ9NpLmo7mzLnfN8pTGBP+vs15v13oKDr6Sb5v05XfZW/A
K4RZEIK/z/Kpl+7kK3DDewvCFrQbducEaLyfIXQRR6kKeO4KaWbigBqzPDll
bFdLqVROON3nXJ67P1Jf8naCmUgDVnV5wNifc33a5bS+6qQ5trpkxlezdI/T
GZQOjHBFw1E6UnUhn/699IpeaicHpKQ1ItKLABlI9bSjvC9rKz9PPrnUIlkN
Z/rr1bZj6dIb8humOSDFhtrlktyWA5E8G3IPqy/RDcuBksjv/GsDHNq6M3mt
KndoFhzVllZNxif3zlrO+JowPrmfuTjAvabdk+oVrm477iVwX+XDy1o16Q5t
cdox0tdrnla/xWXXnbM4OSGTFHe5rgPqPb0iELrNh1b1q0dSMPITZqHvQg==
\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[{RGBColor[0, 0, 1], Thickness[Large], 
     Dashing[{Small, Small}]}], CuboidBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzFWH9vE0cQvfjubOwk/hknxISQyKGkpShNBNQpAVH+AKk0BT5ChCwFCURF
+Sr9Av2ep3ZnZvdu7t1ce5Ei1XLOZ++8N2/e7G3u9vzi6+Xy08XXD+8v9l59
ufj98sP7P/Zefv7ifopXoihaur+PNyN3/rc7478XWZa1lsvlvvuMouf+WxS7
E/dJP+7xyFN3jMNIFPGbImX0icfRYOyGipHTwJjkOIr5PH0WJe6cRvh4h4cf
W1ncIaH4NI8XcdEuBz2E3G0Vm71ZlGKPA39JTY8QcY6IWjQYS/l0eouDj3we
GiXpq4TqFHkcMFe2w4gHShlV0VdVC4J+1ZlmjPvOVDmqqHSHuMgpKg9B5RhQ
cUD57krGbxSKBqcGCrXeZOQcOkbHbUAnhAZPtzh8X8831e8ZMKSgWnLv+txB
9U4dyjskqB1VK3fDvQgYZbvuo6hSWppAZtE9q9G9X8OA3k0ZtlUz2+cGC9ay
yZBp0NHO3c+ruWuwtKWZ+bUtOiY11RzWMGAvJwwb1lRzH7pyAxzd4PA+rBPy
OjKw6OWYAavVa8a9jwHfBRdFeReumRNA9UDxOEdFaa7Dp31kYFHxsMDHsqDR
e8HIwume4fSAkTd45noxDP4Rsq5Bn4cFLi5wCwOFWvtlZElrgVwHhwaNUZhv
vRGyD31spnIAKiVXp+Lmwpj3fXB0rQZ7yjldcCmniVOdOK3JiO70ymhfp4Ue
GOhuY/QQnGqed2jk5b7IElXy6ifozxi62m2Im4DHKp9S8cRAodJ2GenrPIMr
cwLudEwU5tv431FpxUkLh56kBVbN2LNrQ06he+0KigBXRKnO4QzF2XJVZOGq
IJOKq1fEKm+eXjsSe5JcJ9p7ZaE3wOW0kpca+uw/uiqo2Jy34TljsyEmrFZy
j0KrDC/SPmfhr8Irhx57NFEmf13+ifWOG7GceN30U9exVFexYvUDBu91fkfk
PsOyxN8dGxH2gHVsdDE2mb9X2oZGhSOoMDFZ6G4vAU2joMk7PoaOCVMLvLqH
/fJsW8xW/IcdNmI7qGGbgV/N2PbCjE/dyTK8eAT48J7D5rutvD8wvF+HuQEs
3vsd7/2hwWDd27VMlk2l5QF0zrpjExbtGUVM1VN44c4x9G4N3JGZyeXl5oyU
Ht25E3Aa73ktrr66ik8Bv9oA36vt+5nhefdfGcXujqruZ4MDn5YsjkStCQGu
nXoBXcSnIM+Z6tWSqIJTmusVcxX6OsaMWPEaNR9qeg3uY50yqzD7b4ZDbROJ
z7PvDGQK/YHrIcxvh3proBMTzXs9Kjcd30Ktdl59dyavd+B1DH0THN7nks43
kDHs36y479Qd6VAnq+zNufd5qDXJM5voblmvG8+709ZIUSFae1mxI3YOGlvQ
R8nCz0updoUS/ErYdo7NwjafZFnPqvsZnC1UpGIHsBKTfp6baa7Euy16hpWq
X5fmho4dqWp/8VEt76HsumDf6OqKS1EbRi3PXRTtU1Db4jxyUymTwDNZbXOc
qBSJTOkO0vqtrNgBeeRQZC3vhrjf5ClsuzI7j/J5omdPQMmz9cxw91vPj0pG
HHPLqHceXMlkH1Uj5Q6QQm9X6r/jcKnSJHudu6rWbcVc+v/qDrJjvGd0aeJ5
UcecEWFPk+jWVKeI8x5HzCtKuz4OPbnPEQfqGhCNYfqHyn7gkbuGd5ZfD3mY
tNCFuuBv0co/nalzgg==\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->286235489]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2700],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Cuboid Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->100694218],

Cell["A unit cube:", "ExampleText",
 CellID->346080421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Cuboid", "[", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->551570173],

Cell[BoxData[
 Graphics3DBox[CuboidBox[{1, 1, 1}]]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->105636344,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNmPtOE0EUxqe73d5oC20ptFzKHUQE0oCIVbzFYLwg6BsQbAKJBoP877Po
I/k+G505M92ZfjOLW5Hopgzd6fl935mzt9k5OL487X46vjw7OZ59cXH8+fTs
5Mvs/vkF7/JTjLEP/O9jg/HvP/k3+nsWhiHzu91uSBubEQ17zNuAd87S3h5v
Pb7nq/+yt8Nbv9fLpXoqvFUquwbn8wDvfP2rHbVjqvOoQESlxe+MycAWxW0p
P0+pZUWcSDL8dhGFsmmKbYNmwYgVHzN2E2KLIjbDv4D0FEXfgSzKlG0UzT8e
VLRJ3G1wqQgua3J6DJNErIBTjaqn8/JE42tqgqgl8BkDypcNITq7BaAaTkp7
SWoWMpwAKg1Ug6gWeE0DFUCG40RNgteMk9JekmqC1zxQGfAaI2ocqEUnpb0k
NQoZLgOVBapOVBW8VoHKQYajRI0oque15qS0l6RKRobCazO6HuUJiFSNqCHI
sJ2IykOGW0DlgaoSlVMUjZjJbQfGVoCKVCKyd9UJatdJab9k1BBQI4moImQ4
3E/xQAG4Ke0lqSx43Qeq1KNUSHkwSnklo8pAlRJRw1CN4gCU9kpGjQA1RHEZ
oDpAVSDDwgCU9kpGVeF45QejlJebegDXGFK5RFQNqkE15/fXfuohZFiDcQ1I
qQxvkhqFcWVunNLVuA6VBmrv71Kqhv8fVYfKB9egfKAeOSldw39PmeOSc4z+
GrqpjjGrlNv3H6Hc1b5XKtwz5rNyC4TEFVcEHRFGs950N5r1MrZtKeVBCe80
hpKRURsqIeYHJVDCu6pbacPKqEo6+t5XSaSzZunUIZ9kOrcsnSbo4PPMrbPo
qNA0KOHz1K00Z2U0Dzo4B5A6dDKZB5+1LKVlp5I++mrKl9Y9jE1ZKqt/oNK0
VNZBBWdRLpW6o8pt0Ckm0Kla2eyACs46XSrDlkoHVHDG21MxD1PRUnkEVwTO
05WKcc7kHXV56sxF5+9ZKhkrk33QyP9Ww7c0XoFGDo6P11cTRpsQfAtc1skJ
7D3UK+N2CKKqK5934IDvlL3Ryd2oR0RwUsCHoIBvwJ51f6d8eMARkPierkYX
6jc40xdrk4bjkiI6Yz0PjqBSuBIhOZrLWdU6BNaDKks2F5PxG8jYTRcclToQ
ZMwqjaSGYjxfi8axiiSpklUdcgrUoxo8ys6a0KjSKjFDezgmo5cUH406iq84
xm1eNzqPaozyc94IYRGVinRHrTE+UXHizPKjuHqM6q4RLWTkk2bcUr0LcfIt
p+EY1YYRKcop3ymbMf4roCtXDCYt/0UV5ytVua4zFaM6yZtARQsZuWrXslQb
4C7XQGdCe32kCv7z9NOcpVgE5xXqnrfisuC8Rt0LjvHQ3dJw3qTIJUNRnsw9
x236fZm3Gb63K+1SvwDIs5LX\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->123000813],

Cell["A cuboid parallel to each axis:", "ExampleText",
 CellID->371588825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Cuboid", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2", ",", "1"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->414149705],

Cell[BoxData[
 Graphics3DBox[CuboidBox[{0, 0, 0}, {3, 2, 1}]]], "Output",
 ImageSize->{154, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->29779970,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyNmP9PFEcYxofdvTvu4LgTDzk8OThBEaRaKWrV4BcUFQORiBajNhTMEbSh
WNQ0TZq2Sb/Yv6C/2z+p/8+lzryzu7f7vO+UJbC3zL7PZ55nd25ndle33u22
97bevXq5NX7vYOvN7quXb8fv7h/oJr9HKfW3/vuurvT+f3qP/t50Oh2v3W5P
6k+l9vTW1/8pX+/oT9M4QUe+DeuC8NO27ob1nvnUOBXEOr09STXtsMYgPV3i
7X/2i/lUflyobOU2VOZ0pTLYzscDU2V6iVRmd4xU34SO/NBDAVQ+qJqk+hqc
l4wq6KoU683qnoHHclqnt9jfKOmegssKy/bxAHu0yifgdFBQWgf0o5us00fg
9FikszZJh14bpHyYUBpBnZ1R7tUqVyFlQ1CmvZ4g3QPI2ARdIHgdIeU9SNkC
ZU7wapVL4HVCUKa9HifdIng9Dbq84HWYlDfA6zQoC4JXq1wAr2cFZdprnXRX
wes50PUKXodIeRmUF0BZFLxa5TyknBeUaa/HSDcHGS+BrsR0tr/z4PQK6PoE
p0dJOQvKBfiG8B5rpJtJODUJbwo9pnW2vynobxF0/YLTI6ScBOWSoEz3OEi6
FlyL+6ArM53tbwyuxQPQDQhOK6Q8AU5XBWW6xyrpRkC3BroK09n+huFarGfU
1aC/J6CrMt0A6Y6A7qmZzaJbWzhueJ9l0g7A1TBaYtFseLi+H67KRqhXOf3P
P/927K+iuUsTfIszu/ys9xOxCGlioh8TVc5swhnOeuTnpo9o+Qy0otn873m2
rJzZBvHoCs+YRCwfSiwRMVq52AWB/flK4FUz5C3GxMijXTM8Fng1xuPX1/L8
dGZd8Ejg1Q/N2+ugPRRojQxpCw7eisAby5DWxVsWeBMZeHkH767Amzr07OUc
tNsCbSaDOxfvpsA7J/PCOcmuSmJaeO814/i6wJqDpNwZjV+7zk05uybQLgGN
31FctC8F2hWWk89ELt5FgbfAeHxGdPHmBN4tSFsW5jvPwTsv8O6I/rISZwXi
fUbsi0aKjatceacF2grklVk0+JIoNSWw1oDFV1G+gzYp0NZZTr5+dPFaAm+D
8Xoz85oC7zmkzU5rCLRNgYajpMfBqwu8bZZWesZwEYcE4g4j5mGsuPIOCrTX
kNfBSo3fqsDZY67405snsMoC63vGCjKxSgLrPeTLRioIpB+BxJ+kJVIgkH5i
+aLn+R69b8ZCNB6SJFoeA+lXRvJkUuJNjweM3yGXByMgvCcmBoMR/EUL01hl
NMre66KeVfJdVMeuHj8kVJ3oNQ+oqL9u8nDsfkgkbcdvh7oq362C91ddTSBq
/jSavNUo+yRKKazGfKm86Fo7zqI55MWKAnzXzXn4I05D6Li2V3T0m672WOKi
WPuzrjU26Aklri05XP+gN0FIDuIZmp5MUqP4PVDt+rYsJNsHon2WGBC9voZa
+1xYEWt3wIF9nq86cm0C2b7fGBT8vgCufcN0VPSwAdRRaq+JteshN6ptUfuQ
w+9KgmxcnKLqYXYdlsHBGWquC7nuQP+zVDkier0BvX9O7cfF2mvA/YLaG45c
80C+TNWjLNcFyHWVmptCrlno/zpVjolep6D3RWofd3htAXmJqk8yr82QGr2h
j+6py3R4gtWPgItVap4UstXAwRpVnhKzVYD6mNpPO7IVgbxB1WeY17wj23M6
PJ12Es4ESReb1DyT4Hbv1aZhm46f1VuD2bGQnk/qf7e/\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->544915418],

Cell["Short form for a unit cube cornered at the origin:", "ExampleText",
 CellID->733728274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cuboid", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->393465097],

Cell[BoxData[
 Graphics3DBox[CuboidBox[{0, 0, 0}],
  Axes->True]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->81424888,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->385973761],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " coordinates:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->53106414],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cuboid", "[", 
    RowBox[{
     RowBox[{"Scaled", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", ".2", ",", ".4"}], "}"}], "]"}], ",", 
     RowBox[{"Scaled", "[", 
      RowBox[{"{", 
       RowBox[{"1", ",", ".8", ",", ".6"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42510562],

Cell[BoxData[
 Graphics3DBox[CuboidBox[Scaled[{0, 0.2, 0.4}], Scaled[{1, 0.8, 0.6}]],
  Axes->True,
  PlotRange->{{0, 10}, {0, 10}, {0, 10}}]], "Output",
 ImageSize->{154, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->64740920,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Cuboid Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->462895622],

Cell["Color directives specify the face colors of cuboids:", "ExampleText",
 CellID->151980596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"Cuboid", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75401255],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0, 0], CuboidBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNmItO2zAUht2k9wvQG7TcKbcxNlAFY4wNdtHEtAuD7Q0qVgmkTUyMJ+p7
Rpt97MTmt8PSMbRFrSHO+f7/+DhJnRz1rs7633pX56e9+TeXve9n56c/5g8v
LnmXn2KMfeHfry3G///J/6PvqyAImN/v9wPa2Jxo2HPeZnjnPO3t89bje776
K3v3eOuHvVwqVOGtUtk1OJ8HeBeuqB1TnQdkRFRaHGdMBs5S3Jby85RaTsSJ
JANhrkLZDMV2QbNoxAYQuwmxZRGb5V+QnqboB5DFCGUbRfOPBxVtE3cfXKqC
y5mcHsMUEavgVKfq6by8QO0rapKoZfAZB8qXDSE6u0WgWk5Ke0lqHjKcBCoN
VIuoWfCaASoDGU4QNQVec05Ke0mqDV4doLLgNU7UBFBLTkp7SaoBGa4AlQOq
SVQNvNaAykOGDaLGFBV6rTsp7SWpipGh8NqMrkd5AiJVJ6oEGXYTUQXIcAuo
AlA1ovKKohEzue3A2IpQkWpEhledoHadlPZLRpWAGktElSHD0esUP3gRS2kv
SeXA6wlQlcDY5yEjw1HKKxk1AlQlETUK1SgPQWmvZNQYUCWKywK1B1QVMiwO
QWmvZFQN5qswHKW83NRTuMaQyiei6lANqjm/v16nnkGGdRjXkJTK8C6pBowr
e+eUrsZtqDRQ+3+XUjX8/6gmVD5zC8oH6sBJ6Rr+e8ocl1xjXK+hm9ozVpVy
G4husat9b1R4bKxn5ZYZ3HxF0IzIVW+6H616Gdu2lAqghHcaQ8nIqAuVEOuD
CijhXdWttGFlVCMdfe+rJtJZt3SakE8ynXuWTht08PfMrbPkqNAMKOHvqVtp
wcqoAzq4BpA6dDKZk89mLaUVp5KefbXkS+sexqYtlbU/UGlbKg9BBVdRLpWm
o8pd0Ckn0KlZ2eyACq46XSqjlsoeqOCKN1Qxp6lsqRzAFYHrdKVinDMFR11e
OnPR+XuWStbK5BA0Cr/V8C2Nd6CRh/nxrtWE0SYEPwKXc3IC+wz1yrodMlHV
lc8ncMBnynB0cjfqERED+rBjUMAnYM+6v1M+POAESHxOV6ML9BOc6Yu1ScO8
pIjOWr8HJ1ApfBMhOVrLWdU6BtaDKks2H5PxB8jYTRcdlToSZMxbGkmVYjzf
i8bxFklSFas65JSR8egx4qwJjSqtEjO0R2MyejvQV4cZX3WM27xudB61GOXX
AyksolKRbsMa4wsVJ84sP4prxqjuGtFCRv7STFiqjyBOPuW0HKPaMCJFOeUz
ZTvGfxV05RuDKct/ScX5SlW+15mOUZ0ayGn2lap8azdrqbbAXb4DnQvs9yM1
8O/QoQVLsQzOq9TdseJy4LxO3YuO8TB1koTOmxS5bCjKkzl03KbjK7zN8r1d
aZf6BV+GMhE=\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[0, 1, 0], CuboidBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNmItO2zAUhk2T9EIvtIVCudNxHaNsFYxxGTChXaQNtok3qFAlkDZtYrwQ
r8T7VJt9jlOnvx2UIpBWgdu45/v/4xOniX3Wvrns/GzfXF20Fz5dt39fXl38
Wfj461p2eUNCiI78/1EX8vNf+Yn+T7rdrvA6nU6XXmJBNeJYtoHsbNDRoWxT
8sjT79x7EO2VUqGKbLXKrmxVZ0q9y4CUaArhq++F4MB5itsBpYDiVL6hIMdt
ab0wLqPiAo7rSYo5im1FNJV3TsV6OvZW5gLjnibqJWRSUFTaUKHJLEVvwPhK
KjpjoiOAmCFiHfQrmJVqPEZMVmtAjTop48XUMmRXA8oDaoqoRfCqJ6IWwGsK
KB+oSaLmwGsWqACqUSdqBqh5J2W8mJqEDBtApYGaIGoCvJaAykCG40TVNBV6
rRJlJgV6MVWNZKi81oHKAFUjqgwZbiSiilCNTRhXFqgxovLg1QIqB9UYJSoH
1dhyUsaLqaymSE/wawfIYSCrPTK8shW1C1QesqwMQBmvZFQhpHRIeTBKewGl
kKZNFYEaISoDXntAlaAapQEo45WMGoFqFBNRZciwMABlMkxGVSDDPMWlgTqA
awy9klEVoIbvoUyGVahGbgDKeCWjRqEa2cEo7cVUANTbR6HGoBqZJ6dMNf5j
SteQKR+ow0ehalDD9JNTphqPSR3BVYmVZ4puQn6n97QYcvFVjHARt+MHUVEv
uocnovaB4rupuIs7F4FT5U3kWZxfgZS472py62xbOjnQwV8b1klZlW9ZSkVQ
qsYrRTLadNSnAkp4P3ArvbAyGied+DuEW2fN0pmEfJLpLFs6s04dc858p07D
UaEGKI0kUpqzMloBnRJUmnVogNGTL6YtpXVQKrqVfJOjXA1YKs0HqIxLFTU1
W8Di85uLrVoZ7IAKPnG6VEYslX1QwWdkl0rBUjlyqhhGP5T3XZc5S+UErgJc
H2iVyDxJO2bcB8glB2fGVvGsTD6DRtat4RsNFvwKHK6mmFPYOUTiGk87BL2K
aZ9zqBGuXsPR8SHVhBJW7B39fXM6myqnzO+x5f4dWFxxM6smS7iCizpjdXwn
HX1epF5h5+zB+WAyE+N7BjVLOemcdecg14zhboWpMzPDziqRX8y+DnP5mEy/
qMaxf8RU0VGZU0UEPaLPpRTjQrO7b7+M48tWBU57lWMDjqs4Rx29ZkxsNSaH
97LxRf9MHSJizDHKdzLa0z9DKkGOrMVo72rtMJrvehPW6F5DHK9y6jGqTR2t
ElaD59XolKX6HFR5l2HaMapFiOR9nZkY/xnw5520Ocu/Dqq8Fzofo1qG6EWK
bliqRXBfpe5nXXvXJS0jAx2pJDboq6X+OaMTiDq/ou7liDPPu9Bxm75fkW1a
Hu2xyNA/tRrz3A==\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[0, 0, 1], CuboidBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzVmOtPGkEUxUd2AVFegii+ELTER9XWFFsf1TR+sOnDtvE/IIZEkzZtqN/9
y0k7c+8sM5yZtauNTUrCyi7nd87dO+y4s+fdm6vet+7N9WW3+bbf/XF1ffmz
efa9Lw8FY0KInnx/rQv5+Zf8RO/TwWAggl6vN6CXaKqNeCO3oTzYor1juVWS
QP5Nyb+sOdJ76mggrcw3+7ZefSPErQhVPsXI7TLpXoJDGKPrWDrll1W6NOvk
lqWiQdpdnZ3SnjmlzUTa/lC+ROpn4JxHdd9Wb4O6qNRZW22qWSRiE6opKyIw
hHTpp2AE5ohch6yqh6R9nbdAVBvyakAFQM0TtQpZdaBCohgxFbaAmvdSJoup
BlS4RJRpIFJ1ohYhqwlUGiqcJWoOsla8lMliahay2kBlIGuGqBpQa9CNDGQx
VYEKN4DKAlUjqgxZW0CNQ4XTRBU1FWXteCmTxdSkVaHK2gUqB1SVqBxU+CIx
FV0JgucNsQfkBJAV0o4DuQ/UJHRk6h6UyUpG5YEqJ6IKUGHpHpTJAkohEkCq
GFHauEhUFrIO4iidlYwqAVXwUodwjZWgG/l7UCbrLspUWAZqMhE1BRVOkC4D
1JGXMlnJqAqMV+5+lM5KRlWtLHVoPBE1Dd3IPjplusFUGqjX/y+lx+sxqRp0
nnouQqCOH0SdwFWJ3biLiu/hP6F0D/+GUu0RYW94N+dy2MW04WLS6H4hEXUI
lPofrPYHOr4G/fG7vLLuw/mVURbWmFYT+XQcnxz5+GebeJ9dx6cAPjjX+X12
HJ8p8MH5mX1S4PPU0+UaOOF/Fb/TulPRPHS6DOMeen3ajs+St54/+aw4Pi3w
KcGI+X0ang61wQnvQvxOC05Fm+BT8PpQw+3LkFc1I0474IR3btopNF0T6joE
l90HuFQ8/dnz+hgq8PiUnGoOwQXvfH0uecflBFwmErjkHJdTcMnBSEUu9jDJ
meZWHTiD62A8AZtyKngPFeAaZ9RF0EuFfgIO12HMKewClLjOY2W07qJvaDoe
iC9e0nQ0Za6HkbO8gM7g2jdl5r70kNNnh5lp6Cqzalh9FWNXQi+d8SZ/Bhaf
RDCbjUk+BxqffjBtrx+pHimgmrOmW6KP1ERM5ke1ydgkY0zlnXGhGj3Pjlhf
8HaFMoZPsvojdRVj6qLfdBgxYphQ9pz9B6tvxnkqxvld9MvSdYyRuuqcqbo2
Q7pUWGi00zHOJ5pQvywVwOoZx1ne6/OTQLmrmsVz56znzDqWo7Lg1U09Jn8b
1LwKnXfyNyydyucV/0KMawtc+ZnOkuPa0LpAu/JTt4bnrGalMq2VyoKffy7H
5Jchf5XULSe/APlrdHhFu0aToODZdyR/i756Mvrb1QXYyc/pcBscB3pOUGiH
Dq3pvQMWjP0GKW3zkA==\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 1, 0], CuboidBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNmItOE0EUhofdbkvvLaVQWigtFxGRqyAgSgyJGBVEfYOGNIFEg0FeCB/J
92l0Zs50Z/rPbNwKGpt0uzt7vv8/c2Z3ujunnZuL7pfOzeV5p/X6uvP14vL8
W+v46po3+SOMsS7/fq4xvv+T78nvUa/X87rdbpv/MvZSHTGf7/Bf0diSZ17w
rc9bfBVBrQfqSLT6XE6f2TfOeOLM1SpjCZGDVOXbWRn3VOl6SiEh4gKK41sK
ZU0Zuw2aKSO2dzsYu2nmy0PSIjYZxobSMzJ6HfqRNbPlyrdM5Md8Sl7s1iW3
ChkVBJcyOd2HaUk8gv6WBOHrvDyx8TXVkNRD8KkA5dMmHDPK7gFQE5LSqaEX
UfOQYQ0oH6gpSbXBqxGLaoLXDFAJoGqSmgavFlQjgGpMSqoO1JyT0l5ETUKG
C0AlgZqQVBW8loBKQYZVSVUU1fdadlLai6iSkaHwegzUaJ9SXuOSKkCGa1GU
8iIqC9XYACoNVEVSafB6AlQGqjEWUv07TtxGgtxxktoPSH5CALtAZYEqS2oU
/PaAykGWpSEo7RWPysOYFZ3UPtwt6BWPygNViEUVoBp5GZcC6hn0qwBe8agi
VCMXiypBhtkhKJ1hPKoMGWaGo5QXUUmgDoAaAyodi6pANUaHoOhYeMWjxsEr
NQSla/jvqQCo51GUqvx9Ui/g/sIaJu+diq7GXagEUIf/A6Uq/zepKlQ+uAMl
GliiGz5rDtaenjIG62FweNWnQop/vv9gdKicf6ewC77iXzwQIhFzRLTStvFE
TZ+M1NHXLs5rbp1NSycP+cTTWbN0yk4dPTYJp84K1xFDVQW67KQ9a2SXrDzq
oFSC+hpKRh6Llk4T6ov/om6dOUunDfnE05m1dBZBB58F3DoNxxW4DEr4BONW
qlkZrYEOPj+RjryAzCFjVUtpy6mkR98nMqFb1DvcgMrOH6gUHfXZB50sjJhL
J2dlcwgqmRgqaUvlCFTSMVSSlsoxqODbSV/FHCZf3Zlv4T7Atygnyw/eOz11
nh7N8PzoE0Ti2x1F9t/sZCQnBPQByKSblNNqmJ+6Cj8CG0BlvXC+cjmfQVUS
Tjqw5ivMGN/QiUs6Mz4DFtcEiE1FZHwKNK5eEJ12OuNYelDnERmXiXA+EZtk
WKtef6mJHHPGPCMrx1Suga4u/edSfD7CRV6nejVrgCla43BiROsaUD9Kzhq8
E8TAChxFlyPyeWPUTGtXHL19xSOFcL+iOno8QvtQEeK298NMJqxeHqg4ISw6
RDPyZITqlqEqZOjNaMpSXYc4egutO3q2DP60UtCI8G+DLq0FzVj+TYijdbdm
z1h7ZfSpgT+tbbYsxTFQnJfNbYdiDiKX5Kl5SzEFziuyeWHwyqKuy8vQV3ob
snkRnHtqphcR27JJ+Ipbao8CRn4BoDDtag==\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->41296232]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->356363649],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FaceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 " can be used to specify the styles of the faces and edges:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->134118418],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"FaceForm", "[", "Pink", "]"}], ",", 
    RowBox[{"EdgeForm", "[", 
     RowBox[{"Directive", "[", 
      RowBox[{"Dashed", ",", "Thick", ",", "Blue"}], "]"}], "]"}], ",", 
    RowBox[{"Cuboid", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->136321887],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[{RGBColor[0, 0, 1], Thickness[Large], Dashing[{Small, Small}]}], 
   FaceForm[RGBColor[1, 0.5, 0.5]], CuboidBox[{0, 0, 0}]}]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->625968028,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100439864],

Cell[TextData[{
 "Different properties can be specified for front and back of faces using ",
 Cell[BoxData[
  ButtonBox["FaceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->512602954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FaceForm", "[", 
      RowBox[{"Yellow", ",", "Blue"}], "]"}], ",", 
     RowBox[{"Cuboid", "[", 
      RowBox[{
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{".1", ",", 
          RowBox[{"-", ".5"}], ",", ".1"}], "}"}], "]"}], ",", 
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{".9", ",", ".8", ",", ".9"}], "}"}], "]"}]}], "]"}]}], "}"}],
    ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "4"}], ",", 
        RowBox[{"5", "/", "4"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "4"}], ",", 
        RowBox[{"5", "/", "4"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "4"}], ",", 
        RowBox[{"5", "/", "4"}]}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30276328],

Cell[BoxData[
 Graphics3DBox[
  {FaceForm[RGBColor[1, 1, 0], RGBColor[0, 0, 1]], 
   CuboidBox[Scaled[{0.1, -0.5, 0.1}], Scaled[{0.9, 0.8, 0.9}]]},
  PlotRange->NCache[{{
      Rational[-1, 4], 
      Rational[5, 4]}, {
      Rational[1, 4], 
      Rational[5, 4]}, {
      Rational[-1, 4], 
      Rational[5, 4]}}, {{-0.25, 1.25}, {0.25, 1.25}, {-0.25, 
    1.25}}]]], "Output",
 ImageSize->{154, 164},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->155196366,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->493157315],

Cell["Cuboid with different specular exponents:", "ExampleText",
 CellID->358441062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Orange", ",", 
       RowBox[{"Specularity", "[", 
        RowBox[{"White", ",", "n"}], "]"}], ",", 
       RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Point\>\"", ",", "White", ",", 
         RowBox[{"Scaled", "[", 
          RowBox[{"{", 
           RowBox[{"2", ",", 
            RowBox[{"-", "1"}], ",", "1.2"}], "}"}], "]"}]}], "}"}], 
       "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "20", ",", "100"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->227665862],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 5], CuboidBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       GrayLevel[1], 
       Scaled[{2, -1, 1.2}]}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 20], CuboidBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       GrayLevel[1], 
       Scaled[{2, -1, 1.2}]}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 100], CuboidBox[{0, 0, 0}]},
    Lighting->{{"Point", 
       GrayLevel[1], 
       Scaled[{2, -1, 1.2}]}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->807113532]
}, Open  ]],

Cell["White cuboid that glows red:", "ExampleText",
 CellID->291906364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Glow", "[", "Red", "]"}], ",", "Black", ",", 
    RowBox[{"Cuboid", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3405511],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0], Glow[
    RGBColor[1, 0, 0]], CuboidBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->53108342,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNmAtPE0EUhYdu3/RBX9DyLG8VhRAQEQUfMRgVBP0HDTaBRKNB/v5GZ+6d
3ZmemcZtkGiTbrvb+51z587s9u6e9m4u+996N1cXve7b696Py6uLn93j79fy
UDAmhPgi31/bQn7/Jb/R+3UYhiLo9/shvcSC2ogXcpuRB7u0dyi3KbkX6E8+
eiC3QXRUSkUqcqtV9i0ukAGp0Be1Z6vLgIyKSqvfheDAeYrb0X4prZZTcSpJ
9RmFijmK3QbNohUbQuwWxJZUbFa+QXqWoh9CFhXKNo4O1SgHK9oh7gG41BSX
szkzhhki1sGpQdUzeaWifU1NE7UKPpNABbwhxGS3DFTbSxkvprqQ4TRQaaDa
RM2D1xxQGchwiqgZ8FrwUsaLqQ54LQGVBa9JoqaAWvFSxoupJmS4BlQOqBZR
dfC6D1QeMmwSNaGpyGvDSxkvpspWhsprKz4feQEi1SBqHDLcTkQVIMMdoApA
1YnKa4pGLPi1B2MrQkVqMRmddYra91LGLxk1DtREIqoEGVYHKcEV8FPGi6kc
eD0Fqmzvy5DKaJT2SkZVgConoqpQjdIIlPFKRk0ANU5xWaAOgKpBhsURKOOV
jKrDfBVGo7SXn3oG5xhS+URUA6pBNZfX10HqOWTYgHGNSOkM75Jqwriyd06Z
atyGSgN1+HcpXcP/j2pB5TO3oAKgjryUqeG/p+xxcY8xWEM/RdeNXEz1ow62
T/1GEoUnapu2FTKQP54RNCPc9ab7cdcrxK6jVAAlvNJYSlZG21AJ1R+UQQmv
qn6lTSejOlz7aol0NhydFuSTTOeeo9MBHfw/8+useCo0B0r4f+pXWnQywo4Z
ewDWocVkT77s8lEJ++EKzL5u+dLmiBCzjgr2x0lUOo7KI1DBLsqn0vJUeRt0
Sgl06k422OFi1+lTqToq2DNgxxup2NNUclSO4IzAPl2rWGum4KnLK28uJv+U
o5J1MjkGjcIfNQJH4z1o5O19o5E2Giz4Ebicl1PYZ6hX1u+QiauufT6BA95T
RqPj3fgIRbDTGSjgHXDKub5TPjLgHEi8T9ejC80dnO2LtUnDvIwRnXX+D86h
Uvgkgjnq5ZxqnQGbsnOI2fyQjE8gYz9d9FTqlCY/JnmF6CoxNT7E8wNNqvGM
MKbKTnXIKcPx6FHx1uQkXrmD2tUhGb2zzg47vuYZt33emDzqQ5TfhCysosZi
3aYzxpc6Tq2sII5rDVHdt6KVDP/TTDmqjyGO73LanlFtWpGqnHxP2Rnivw66
/MRgxvFf0XGBVuXnOrNDVGdCnuZAq/JTu3lHtQ3u/Ax0IXSfj9TBf4l+WnQU
S+C8ToeXnLgcOG/Q4WXPeIReJJHzFkWuWoq8mCPHXfp9TW6zcm+f7cZ+A+n2
csY=\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101004100],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " specify the face opacity:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->94273435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Opacity", "[", "o", "]"}], ",", 
       RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"o", ",", 
     RowBox[{"{", 
      RowBox[{"0.1", ",", "0.5", ",", "0.9"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36811579],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {Opacity[0.1], CuboidBox[{0, 0, 0}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyt2dlO20AUBmDjJXHsxFkcspWAA4S9ULYuqir1qr3qQyCoBFKrVpRX7XUR
gjugau9RO2fm2DG/BjKNimCaeP7zeTJe4344ODv++Png7OTwIHl/evD1+OTw
W/Luy6lY5ExZlnUk/j51LPH6j3gl/47u7u5ER659K1pHdA3kuzf8zr66uLXo
xZ38seZk72vR2mKhJ3rp30Qufck1xbTm9821aLnmOdcE2t497i1Tr6t6VWBW
9m+zHT3Qv8X1der3sn5eR19mNtiIcyOggE1N7jP2ZHqNxZZReoXTHUg7kO7K
9JBH0oO0C+mOTC+w3TdKJ2zPQdqDdFumZ9meN0rPcHoR0gVIt2S6yyNZgnQR
0tMy3WZ7VZtuV4N76Sbb65D2wW7KdIPtrTHpWKZrnN42Sld4JLuQLkG6IdMh
28+N0vSZ5VKRpgKsCqCqfr8qcMu6qhCqaverrn9ciMIHqkbbQVWVqPVUlfql
2n2oLcMaq6NaJ6u1bGocNWgCdkCpgBJpFQcU3IpmigvKM1AiUCpaxQMF9z8z
pQDKJihVUMpapQjKU1BqoIRS8UEpgbKhVUZ7iV4JQMGjuA5jCbRKCMoaKA1Q
SlqlDAqef8yUyj8qvlaJQFkxUoqg1EBZ1syuLTZRXipqpTpIeCan/Zc2tn1z
fjFea4A21JxhSPOMtBg0vCb5rPlGWlNq7emEtQXN9ZC00EibhrHh1dVmrQpa
Qau1QBvkNNqMtC0bWqkAUgckdY9AZ2xx/RXStJHSBYXuYlxCnPPvlyJGiJnU
A6nFkkuQoyiCmkbaE9AaoqG3/kTaDGgRa+FEWh+0gLXISPNAmwOtwFodNNwK
nlZLQLNZa06kDURD27A9cbUci6gmgBTqbk1U3eRq++ry52OzbKbVWSuAFk+k
RawFoOGRrDQXtHnQAtHQ16JojOYaaUUeWwxafSLNTbfh5JqbaWz1wKoZWzRL
s1CN52F9NR119NZyqnFbCIQkIEVG0gxLzq/bm7w2AK2i1RzNWVTul/9Fa7NW
Am1+jOZotZhnvAzaAmhlI63GY6uBtggaXqX1WoW1GLQhaIGRFrDWAm0JtJJW
s0Er8rx1/4vm8tj6oC2DhvdKOc3NNLYSsFbGWHZmEbUA1atQXXywmr49D6F6
DaoL2ursKBTVBAxAWTdSPFBwHjZAwbtZpRT4k2D1U6h2tdU+jAG36yYojlYp
8Riweguq8e5eVYcwhh4oz8YoU1Ipg4L7u5lS4U+C1dvUeFk11Vp85KpnELk1
43G7Q407WnNalz4dwvxubqSjtTRgLXiu2RONnaVjSDceTTd5JJjaT0dyb45a
YFc1c+Vldvo0DlO0f9KkqG+eXTDxLL+azqFYZMkf9WyiB3Wh5nxOY1HPmJ7w
WDCV8FjUE8E+mD6kZzitnsCmzz0x1eGU1NRz7ZzpQTrmcapn5gNIu5Cusr0k
0/M8AkyFnFqTqUVqvcwUvzSVvtzC2aRa5GzK/JBVeWuhUMthcVcmltNRcjm9
fCF7VtIe3m9eyaXqfwesqb8aBjDi\
\>"]], ",", 
   Graphics3DBox[
    {Opacity[0.5], CuboidBox[{0, 0, 0}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyt2ctu00AUBmDjS+w49zj3pmkuDUlbSi+UuxCsYIXgFaKqokggELDtA7Bl
gwQSPAA7JNix4QFYg8SWx6hgzsxJYn4GPASqZqg9//k8duKxY25Onhwe3J88
ubs/6d54NHl4eHf/cff6g0dilXPCsqwD8brXsMTf38Vf8nVwfHwsOmLtNdE6
oqsvl67wkv366Qdb/NuTay+Llpa8n9Ze5LW+WGtR0beP70VrdWXvOZbS2t49
rs1Sr6t6VWBF9u9wdZ76vVk/Gx2Z2WKj9IfMJmei2CgoYFNDy8fyx1qS6XXe
ahXSDqRbMj1mu2GUHrLdgrQL6aZMD9heNkr3OL0CaQ/SDZnu8Eh6kE5Bui7T
bbZXjdJNtkcJ6ZpM19leh7QP6apMVzl9yihd5pGchnQA6YpMF9neMUrn2D4D
6TSkI5nOsH0O0iGkyzIdUktrRZoK/rLqfO2qrioDVaWfq94dvRSFv1Rloao4
r3JVlSo8a1SXjm1N/Fo2NY4aMAG7oORAKWgVBxR8B80UF5RtUPKg5LWKB8oW
KAVQclolBQp+gs0UH5RNUIqgZLVKAAqeeyVQMlIJQAkTFByLXsmAspEwllCr
ZEHBucdMyYGyBkoZlLRWyYMyBiUCJdAqBVBw7qU9so9uXfhV8kEqgXRScxY4
QrI/v3ierJVBG2rmJNI8Iy0CDa9HAWuBkVYBbaC5cpKWBc3XalXQ+pq7DdIK
RloNtPh1mt5Gei/LRlIdJHV/QDO9ZZFU1SopUJqgLIlGIs6zySsRI8RMaoFU
Z8klyFEUQRUjbQm0iDV/Ia0NWoG1EDTc05RWWwYtFI0rFnMLaR3QUjy2csKe
6rUV0GzWqkaaB1pPNLRnjYWr5VhENQGk0L1SbaHqimjoxsR+8/ZrfCzRQlpJ
NNSd+i9anrUwQfOMtIw82upMpp88qDg/KNUFtQ+qz8evDFppIc3lPa6DVjTX
3JnGVuvfLGv60wEHZ2a9Q2cOHZ8+VOeNqmmGoUXn06cvlnP7zpFQCOolaK5W
a7KWAg3HltNqjuZKQYvp/6JVWMuCNgANr656rchHvQDaKmgZIy3HY4tAG4IW
GmkhazXQToKWNtJ81pqgjUDDexyl2aC5fNzaCRqOzZlr8295PLIuWOOEkc0t
ogZQvQbV/m+r6ZowhOp1qE5pq2fnjagmoA/KBih4N+rM5mMaw2LVPoxhBZRT
oLhaJQClA8omKI5WSfOeYPXphGr5eVDfzGJjaIGyDQp+U1BKlseA1TvUeLNq
qrX4HVTfuGNbrv9FbQFq8Wzdpcadj3paN30qhPkzsb2cb6UMW8EZZk809iwd
sY2ps5xS71YVzOIf0zVI44xJx8ibjWD69A1T9Dmig6G+szbBxDl9bXrsxCp1
bVXPI1rTOrGeSjKa+ZbK1JOoNmwFr0NdHrl6trcM6QDSbbbVk9cO7yemGpxS
T4q7YHqQjngE6jl5D/bOhXSB7ZFMD8C2IZ3h9IZMr1LrzdLilw5twNvfkpkh
75O8mVCQ5bCyJxOj2AhlULwuyJ7xtIfPyUtyrfrfAOvEDwKilTg=\
\>"]], ",", 
   Graphics3DBox[
    {Opacity[0.9], CuboidBox[{0, 0, 0}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJyt2cty0lAYB/A0FwIEQiDcWmiB0gtt7c3ajpcZx5WufAimU6ed0dGpdeno
A7jQjUuXbnwEV+59Cl9AF24ZPd85X4D+PTZHRqacQs7/++WDpAmkD4cXpydP
hhdnx8Pug/Phs9Oz4+fd+0/PxSJnzrKsE3F/3LTE41/ikbyfjEYjMTE13hOj
I6aW5bO7YrTFM/vF3Tf0uyeX3uGMe2npLc76YqlF0z8/vhaj1ZWzR1yTo1lX
zapAR87f4OrCX+av83xI8954ntexJDO7vI7oisw2O/FUlxSwaXC+vX00kjer
JdObLNYg7chBPOf0gkwP2G4apdc4vQBpF9LzMt3nThZT0k2Z7rHdNUovJdsc
0h6kGzLdZnvVKL3A6XVIZyBdl+kGd7IBaR/SNZmusX3NKF1hewfSWUhXZTpi
ex/SOUjHMh1y+sAoHXAnh5DOQ7oi03kaaenx4JwKjv6t6uWtV6Lwj6oAqsqT
KldVqULssQB10aTOG9fxOm+Y1zrjWsumwVEvlgDcAkVQSlLJgeKCsgdKCEqo
VTxQdmdSMqDs8HEzguqiUXVaD3rF1/QwrZRAKWiVLCjboOArCrRKDhT8+9Ur
WVACULZAKYOS1yoFUDZBqYCS0ypFUPD4ZaaEoAxAiUHJapUSKHjkpffFFie6
dCkCaU2z59Ep0/7+/iJdK4OG54+AtQxovtR80GLQVjRHddJyRloVtL7m3EZa
wUirgYbnVZu1kpFWB603pdFmpG1ZMZIaIHWkREdqyyKpZqQ0QWmJQSLOsx36
oEWIXsqAtABSgyWXIEdRBFWNtBZoMWvZFC2j1dqglVgLZtIWQQtYC2fSlkDz
WSvPpHVAc1irzqR1xeCJ6oZRtQfVy0kvopoAUuhMWZ+pOhYDfZixP3z5cVUv
npEWiYGmfdBiI60HWsha/r9oaq9Uf8l0C0HF44OZmuUeK6CVtZqb8v65vDXq
oEXmmjvWuLMWWHhETbGs5LY0k0P7Oj1dTql2tdV0hJF756ev3y3n3edvQiGo
B1popM1zLxnQsLeikVZnLQdaHzQ8HyrNAa3KWuG/aBG/byXQVkALjLQi9xaD
tgpa3kjLs1YHbS1Fc7Saz9o8aOug4Wccveay1gZtAFrWTBMPOzNJthipug/V
G1DtX92HqCYAlU1Q8NOkc3l/Z2UZlC1QPK1CRwU6O2H1Nah2ZfXk2pKq9qEH
fDdRwR7sUfIp29Zsi21tD1idhx5w39gBxdEqASgtUHZBwe8LSinwK8HqPRq8
cTXVWrwF1fftqTU3oXafBney5qSuxOsyzZdhPTWouz71CifdVaCqClUHUKX2
i5h7wyPSoRjscaoGdgTpo8Tm93hOVtXZxjT17477boJd1OxbtEHU97x5SONR
foNtdV0iuR6IqVVOqetQbTDxPNTlDtSVvUU2MdVmU11v7YCJZ8omp9V14i6k
PUhXOa2ukyfXWzFV4j7XZKoPJp75Aza3ZHqFRm+cFj8iaeU4syszq7xey1HT
cqPzOg9kYj1ZJxVTUNxvyplBMsN7yG25VP0XwJr7DWXADcM=\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->222658126]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13285],

Cell["A simple 3D bar chart:", "ExampleText",
 CellID->4437456],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "4"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12188379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"MapIndexed", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Last", "[", "#2", "]"}], "-", "1"}], ")"}], "/", "4"}], 
         "]"}], ",", 
        RowBox[{"Cuboid", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Append", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "#2"}], "-", 
              RowBox[{"{", 
               RowBox[{".5", ",", ".5"}], "}"}]}], ",", "0"}], "]"}], ",", 
           RowBox[{"Append", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "#2"}], "+", 
              RowBox[{"{", 
               RowBox[{".5", ",", ".5"}], "}"}]}], ",", "#1"}], "]"}]}], 
          "}"}], "]"}]}], "}"}], "&"}], ",", "data", ",", 
     RowBox[{"{", "2", "}"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"False", ",", "False", ",", "True"}], "}"}]}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->58746949],

Cell[BoxData[
 Graphics3DBox[{{
    {Hue[0], CuboidBox[{{0.5, 1.5, 0}, {1.5, 2.5, 1.7852874597719188`}}]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CuboidBox[{{0.5, 3.5, 0}, {1.5, 4.5, 8.649930536154296}}]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CuboidBox[{{0.5, 5.5, 0}, {1.5, 6.5, 1.117853398437614}}]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CuboidBox[{{0.5, 7.5, 0}, {1.5, 8.5, 8.077886921384504}}]}}, {
    {Hue[0], CuboidBox[{{1.5, 1.5, 0}, {2.5, 2.5, 8.259083111863369}}]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CuboidBox[{{1.5, 3.5, 0}, {2.5, 4.5, 1.855751201042672}}]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CuboidBox[{{1.5, 5.5, 0}, {2.5, 6.5, 7.156934510539018}}]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CuboidBox[{{1.5, 7.5, 0}, {2.5, 8.5, 3.081487126370715}}]}}, {
    {Hue[0], CuboidBox[{{2.5, 1.5, 0}, {3.5, 2.5, 3.3054576367354693`}}]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CuboidBox[{{2.5, 3.5, 0}, {3.5, 4.5, 6.784170043287585}}]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CuboidBox[{{2.5, 5.5, 0}, {3.5, 6.5, 1.1595464698176237`}}]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CuboidBox[{{2.5, 7.5, 0}, {3.5, 8.5, 7.909608605107523}}]}}, {
    {Hue[0], CuboidBox[{{3.5, 1.5, 0}, {4.5, 2.5, 5.853223145738515}}]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CuboidBox[{{3.5, 3.5, 0}, {4.5, 4.5, 9.661124906706286}}]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CuboidBox[{{3.5, 5.5, 0}, {4.5, 6.5, 5.374322013656229}}]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CuboidBox[{{3.5, 7.5, 0}, {4.5, 8.5, 5.841973153065842}}]}}, {
    {Hue[0], CuboidBox[{{4.5, 1.5, 0}, {5.5, 2.5, 6.485437534184167}}]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CuboidBox[{{4.5, 3.5, 0}, {5.5, 4.5, 4.435676875434508}}]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CuboidBox[{{4.5, 5.5, 0}, {5.5, 6.5, 2.0439031395036253`}}]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CuboidBox[{{4.5, 7.5, 0}, {5.5, 8.5, 7.5955068775510455`}}]}}, {
    {Hue[0], CuboidBox[{{5.5, 1.5, 0}, {6.5, 2.5, 5.2061252720903894`}}]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CuboidBox[{{5.5, 3.5, 0}, {6.5, 4.5, 2.336022406144541}}]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CuboidBox[{{5.5, 5.5, 0}, {6.5, 6.5, 8.2850914017299}}]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CuboidBox[{{5.5, 7.5, 0}, {6.5, 8.5, 4.1811102757179395`}}]}}, {
    {Hue[0], CuboidBox[{{6.5, 1.5, 0}, {7.5, 2.5, 4.8510342456289255`}}]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CuboidBox[{{6.5, 3.5, 0}, {7.5, 4.5, 5.111962434816665}}]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CuboidBox[{{6.5, 5.5, 0}, {7.5, 6.5, 1.781405138349609}}]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CuboidBox[{{6.5, 7.5, 0}, {7.5, 8.5, 5.540695350704774}}]}}, {
    {Hue[0], CuboidBox[{{7.5, 1.5, 0}, {8.5, 2.5, 5.035449846811138}}]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CuboidBox[{{7.5, 3.5, 0}, {8.5, 4.5, 6.574508855056423}}]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CuboidBox[{{7.5, 5.5, 0}, {8.5, 6.5, 6.662171580400464}}]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CuboidBox[{{7.5, 7.5, 0}, {8.5, 8.5, 4.69669367669148}}]}}, {
    {Hue[0], CuboidBox[{{8.5, 1.5, 0}, {9.5, 2.5, 6.655321404323512}}]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CuboidBox[{{8.5, 3.5, 0}, {9.5, 4.5, 2.4854004853357026`}}]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CuboidBox[{{8.5, 5.5, 0}, {9.5, 6.5, 6.925212044225999}}]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CuboidBox[{{8.5, 7.5, 0}, {9.5, 8.5, 6.823564896114622}}]}}, {
    {Hue[0], CuboidBox[{{9.5, 1.5, 0}, {10.5, 2.5, 4.399056524899466}}]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CuboidBox[{{9.5, 3.5, 0}, {10.5, 4.5, 7.075899788194757}}]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CuboidBox[{{9.5, 5.5, 0}, {10.5, 6.5, 2.7876006867442555`}}]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CuboidBox[{{9.5, 7.5, 0}, {10.5, 8.5, 8.49837253907538}}]}}, {
    {Hue[0], CuboidBox[{{10.5, 1.5, 0}, {11.5, 2.5, 2.176813868739882}}]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CuboidBox[{{10.5, 3.5, 0}, {11.5, 4.5, 5.095454465002923}}]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CuboidBox[{{10.5, 5.5, 0}, {11.5, 6.5, 7.327263453380867}}]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CuboidBox[{{10.5, 7.5, 0}, {11.5, 8.5, 7.6886336579645125`}}]}}, {
    {Hue[0], CuboidBox[{{11.5, 1.5, 0}, {12.5, 2.5, 3.954077027374005}}]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CuboidBox[{{11.5, 3.5, 0}, {12.5, 4.5, 2.142704598320327}}]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CuboidBox[{{11.5, 5.5, 0}, {12.5, 6.5, 4.192078256505672}}]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CuboidBox[{{11.5, 7.5, 0}, {12.5, 8.5, 9.161865465083515}}]}}},
  Axes->{False, False, True},
  Lighting->"Neutral"]], "Output",
 ImageSize->{184, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->99700299,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->561626156],

Cell["\<\
Show a sequence steps in the evolution of a 3D cellular automaton:\
\>", "ExampleText",
 CellID->36869246],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"Cuboid", "/@", 
      RowBox[{"Position", "[", 
       RowBox[{"#", ",", "1"}], "]"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "Tiny"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], "&"}], "/@", 
  RowBox[{"Take", "[", 
   RowBox[{
    RowBox[{"CellularAutomaton", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"14", ",", " ", 
        RowBox[{"{", 
         RowBox[{"2", ",", " ", "1"}], "}"}], ",", " ", 
        RowBox[{"{", 
         RowBox[{"1", ",", " ", "1", ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{"{", "1", "}"}], "}"}], "}"}], ",", "0"}], "}"}], ",", 
      "10"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      RowBox[{"-", "1"}], ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23867461],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{313, 210},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->532794878]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->716725367],

Cell["Use as a simple way to visualize volumes:", "ExampleText",
 CellID->77061886],

Cell[BoxData[
 RowBox[{
  RowBox[{"cuboidRegionPlot3D", "[", 
   RowBox[{"p_", ",", 
    RowBox[{"{", 
     RowBox[{"x_", ",", "xmin_", ",", "xmax_", ",", "dx_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y_", ",", "ymin_", ",", "ymax_", ",", "dy_"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z_", ",", "zmin_", ",", "zmax_", ",", "dz_"}], "}"}]}], "]"}], ":=",
   
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"f", "=", 
      RowBox[{"Function", "@@", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", "p"}], "}"}]}]}], 
     "}"}], ",", 
    RowBox[{"Graphics3D", "[", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"If", "[", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
         RowBox[{"Cuboid", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"x", ",", "y", ",", "z"}], "}"}], "+", 
            RowBox[{"{", 
             RowBox[{"dx", ",", "dy", ",", "dz"}], "}"}]}]}], "]"}], ",", 
         RowBox[{"{", "}"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "xmin", ",", "xmax", ",", "dx"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", "ymin", ",", "ymax", ",", "dy"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"z", ",", "zmin", ",", "zmax", ",", "dz"}], "}"}]}], "]"}], 
     "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->403843786],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cuboidRegionPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "\[LessEqual]", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}], "+", 
      RowBox[{"z", "^", "2"}]}], "\[LessEqual]", "2"}], "&&", 
    RowBox[{
     RowBox[{"x", " ", "y", " ", "z"}], "\[GreaterEqual]", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2", ",", ".1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2", ",", "0.1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "2"}], ",", "2", ",", "0.1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->472955575],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->44659025]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->735396897],

Cell["Hyperboloids:", "ExampleText",
 CellID->409920192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"With", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"p", "=", 
         RowBox[{"First", "@", "v"}]}], ",", 
        RowBox[{"q", "=", 
         RowBox[{"Last", "@", "v"}]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"Red", ",", "Thick", ",", 
        RowBox[{"Line", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"1.5", "p"}], "-", 
            RowBox[{".5", "q"}]}], ",", 
           RowBox[{
            RowBox[{"1.5", "q"}], "-", 
            RowBox[{".5", "p"}]}]}], "}"}], "]"}], ",", "Yellow", ",", 
        RowBox[{"EdgeForm", "[", "]"}], ",", 
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{"Rotate", "[", 
           RowBox[{
            RowBox[{"Cuboid", "[", "]"}], ",", 
            RowBox[{"2", "Pi", " ", 
             RowBox[{"k", "/", "20"}]}], ",", 
            RowBox[{"p", "-", "q"}], ",", "q"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"k", ",", "20"}], "}"}]}], "]"}]}], "}"}]}], "]"}], "]"}], 
   ",", "\[IndentingNewLine]", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", ".5", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", ".5", ",", "0"}], "}"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{".7", ",", ".7", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{".3", ",", ".3", ",", "0"}], "}"}]}], "}"}]}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->589276927],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->59708455]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6762],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Rotate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rotate"]], "InlineFormula"],
 " to get all possible cuboids:"
}], "ExampleText",
 CellID->810135533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Rotate", "[", 
    RowBox[{
     RowBox[{"Cuboid", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "2", ",", "1"}], "}"}]}], "]"}], ",", 
     RowBox[{
      RowBox[{"-", "30"}], " ", "Degree"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->56050736],

Cell[BoxData[
 Graphics3DBox[
  InterpretationBox[
   GraphicsComplex3DBox[{{0., 0., 0.}, {0., 0., 1.}, {0.9999999999999999, 
    1.7320508075688774`, 0.}, {0.9999999999999999, 1.7320508075688774`, 1.}, {
    0.8660254037844387, -0.49999999999999994`, 0.}, {
    0.8660254037844387, -0.49999999999999994`, 1.}, {1.8660254037844386`, 
    1.2320508075688774`, 0.}, {1.8660254037844386`, 1.2320508075688774`, 1.}},
     Polygon3DBox[{{1, 3, 7, 5}, {1, 5, 6, 2}, {2, 6, 8, 4}, {3, 4, 8, 7}, {1,
      2, 4, 3}, {5, 7, 8, 6}}],
    VertexColors->Automatic,
    VertexNormals->Automatic],
   Rotate[
    Cuboid[{0, 0, 0}, {1, 2, 1}], (-30) Degree, {0, 0, 1}]],
  Axes->True]], "Output",
 ImageSize->{184, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->202349895,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy9W9lyE0cUHaTRakm2bElekG2BVwy2iY1ZzBJIDIawJYSkqCJVictxYh5S
SRGes3xF3vMNfEm+J6pkbvfpUet0jzV2XKFA0vRyzrndt28v0zzde3d48MPe
uzf7e53dt3s/Hb7Z/7nz4Me3UVL2TBAE76N/f0wE0e9/ol/q3/tutxtlOJ+/
RZ+ZqEBWnrLRD5UaBJK2on7/Kp+hztGZBaus/FxSyS+jT0nMeJDa0W+BCHI6
MYZKwPqCUvP0PJNS0yCcMVhfcvByyFlJhVNHadWMBwcH8rPoxbRrXfBih8Cq
oz2z+C4ivYDv5Nr2c81Whk7JGGWRUp16K+5Bm2HIYg5CXViXv6m+Dj3Yqmwu
Lote3lbfB8CrKo09vExcYh8lRrwoN9T3dtf1M4PSRt4YM1DZqwrpJqVmnR6b
BF7zlPBaVp/aJUc9+GLPtZS4DeBOEQ57w5WUeMb3pk8Jbxh4s4THI2Kza3pY
rM/ju4ra5z1qJF2reIanBSrFkSHbdSNeF/4zr5CeoMTyAKR4HMV2hk7KnPp6
BG0rHsRYSyqkcx71dpSV71VicaObM3YS2DpOOreB8ej1/5GzkdCDl0hDmdvo
1BTI+JACmx6rs1ZEDCwvnk/ANjPNaNca8xamO4+sH4HEsV8KXCfEiq/dYs8y
PlmhZ7bV5CtvC7bAZUoH4d+//xKYP5epbpUUXFQYm6gb99vT1XcGStLXCKVG
KHquLiV4RwbxLDQMoWbQJHlwsA8NE4qedd0+ccermTuUrbmYCzYVIz7JveCx
SXRcTM0zjhrs3TJ7h8ImaRGb9EcJVi4R6wjVXU7NbmaeutfKGqycJ7468S2l
5jOjhK2NfQHkGbJ8GJbzHHJyJWZOaxBzlpjraAOe++w2t+OEL7JPdG3PNiWN
r4gH5Im1AXuniXWM7HVjIMc6tfZRK+6sUWJZyx7WgrVnfby5GNXYRlwcwTS3
mdemiDtH3BPgniRu4zPuLOu3VeqHHj5u47No43Hiazg8bKdZg+h+NSN4mvgK
xDcN+xrE12SP8bDZz0qvqhWCtUxMHVjG69Kxbm/tbc8NGrFvNUORN145Ys/B
thZJwXnYOkwKWoR9TjHnnRZ3x6utSrZobVJQIgULaAPerYyTgs7xFPRSIkj2
MO6HJbRC2dMKcTRLz903/qQNeDQPEf8K2qBI/HE9PM+m1mE8JyRE8cYasV8C
e57KThL7zLHY3d2yJzqiPSqkaA39kU2lyIwHX2TvItplIpDRAawbaAdzusCM
gZldenMRGAqkk2fJKjFdkQ+MUkFtE147ZolPTXzrSqBzf27Jh5wjxEvDqUR8
O5V5ho7Bo/9Kph05AvRK0jlC1auDR2GJdAyTjk1hjoqbtSVHDt5Nu/OTalFn
zq6QjgLpGCEdl6Ejq3o3bpcgB13N/6DLrEO8u3roqZOeVegpkJ48eort5XGT
tp1Yl9jV8EQ4KTJEWop9M6DlHSfUwvNYjIM2GiVdy8IfFa+RrrI1L/piSlo9
avXZd6bX9Mx/QlwnBRW0jL2LDKzIbp/a9HwkXklokx2282BrElsV9vKeteW1
iiMp9/YsWCaJxewOyl17PcN9z7MDo7eBPk3oI0AvEV7zRCyTYOkQyyhaynda
cnyWFljmicXsK8yphbbBnFn79i7mlG4Q4xgYl4mx2TfnkgVJa3pnpyE6W76d
WUR0iRjHYSOP9dFjMfK+kO2tgX2d2KV/w4T5ybRp9lSVVBBrNknJhJpHHXyr
RUSjvHA6I98JmoynePvvCFUltM9VT++4NvIbmbTKOLZnUrRXHsq2SVmrv72A
xiyuMjN6zHqR/W5QS2Wh57ZPz6C5i+b9nnfxychAFRHxPc/YPYrRvx6n/FRK
hPS+J1b190cYuHvXHoev7+vAti19QDxjZCVbUU20wqCr0yoR9+dfODbe9UR3
3js4a0LnHM+3nxHQnMWn/0qhnQGctl2isZqKswTO+DRDEwY5sH40gJVHdjkV
ax6sJWItgfUusdY97RuvchSbzzvk9Esi5xCxVMFyx7MScPdnvedSsm2902pY
ViHOEXDeGsCp5pUo+4h2xLth/adGPA3wcPQb9ox15dvqgd5nOLx1lB4htgmw
XSe2msWmhqd4tZeJT/CH+3QF7l4YzG0w8/xTNczYifPZSI81fncJbcPE0Ik+
pMwWMVSoJZMZ2HekkORyn83Blo1TYerzIIouNusiWC8T69CJWI0/VYmVx94K
WNcGsPLZiGbVQc788Z0NmPWs8lbSUiYta9DCK8xyKi2D95rxfKqHqjf22no2
4HErA/RwjxSOpSf5PK1IerbQPrzmL52SHj7f4/0hz0k3oGeR9BRPSQ9HqDrp
yZOe29DDu7DCKelRe3XZ40ff3Df34CtzxJ1Pxe17A87neHI+wz2wA4t5d5uO
le/p8Ilkjth2wTZDbLlUbC1K5XPJkNgeg609gI2jgWbjt0wcfbPE9hxsU8QW
DrBNrbfUCX/GE+MzxPI5vGTiRCx8Xynev8YrHfGfV7CkRRzZVBz8JjJ+TxAT
fAX8BuFnUuG3KdU+/RT13wBdrWtzMbo8Be6bHY05TalmZ/YtsNSarnfCnYgz
g16MV+7ote/Qa7WUOB0lIk6FmjdQU7HaLdmmc5Qq0SlroZQNim5wB0VfHU26
A2ZQioTCMUejzHkUGhR1hpkKZR6ta279HEJDaGon+I2uvUipjKLdW7+K8fPz
LQ514yOq8T2ssN8XcUzRCHzDrQYN+0Dg+ZznL43Cd1hGgPK1uBrPPwPRVtCq
5l3za0LhWjzHaxS+x2PQvoRl3KKMopeBfJOuCZQXpIl9lS3VaHx/aRxozwht
KBXaOtppCr3+EJb53zRw7Q8o9Sy07JAW9yau+KMe0RuEMQ2Mu4ShVl296BH9
0PX5Rtks6t+EJfb82mO9QrVmuLWimtdIgR9pCy3oIEDHJqFMEIr2NL6v55tv
pH9WYVUbrLo2383jGbEMLRdISz/KDarFN2DMDdoFQlE3XaJieoWxTbUm6NmM
a7NvVTfcomzlr+oWsCjiWmbktYm7CW71li64TbV4JWfumY6Du4Ha+kz+DpXm
GzLmRs+ox7sFRb9N+tCj3OffNUKpAkX1XXCXavEdmg5QSrCkgtr6zsC9rn0n
oFdrDrVyxG12/fomyMdUi2PBYtfcT9UHjZJWAP+CQtihGvwOVcf6/pgutfW9
yPtUmu/OXERpfWf0AeXye+0llFaxKthFy3B0nEepLVXqEeXy3NtBaf1/CT6h
XJ4lp9G6t1Xpx5Tru5ci2MoD9C1yE+vIs6WUaml1a/2oWF9H6Yeq9HPK5dhu
PPGJKv2pfDqxewhlVG7wWZdjs/GHlyr/BVogxPcrlSp5AvxaPQVn/gW9M0nk
\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21374],

Cell["Random cuboid collections:", "ExampleText",
 CellID->120632237],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Opacity", "[", ".3", "]"}], "]"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
      RowBox[{"Cuboid", "[", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"4", ",", "3"}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "40", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->192475024],

Cell[BoxData[
 Graphics3DBox[{
   {Hue[0.9161047183204392], EdgeForm[Opacity[0.3]], 
    CuboidBox[{0.19871576785493428`, 3.768117964420889, 
     1.1185387691022335`}]}, 
   {Hue[0.7220330927434031], EdgeForm[Opacity[0.3]], 
    CuboidBox[{3.4453288845757584`, 0.5425015415312204, 
     2.2208055520601038`}]}, 
   {Hue[0.9535511758460979], EdgeForm[Opacity[0.3]], 
    CuboidBox[{2.4048466714780234`, 0.7247891981003045, 
     0.42601419926420814`}]}, 
   {Hue[0.2931542459849441], EdgeForm[Opacity[0.3]], 
    CuboidBox[{2.6261079303373744`, 0.21853251964937037`, 
     3.0164550489856117`}]}, 
   {Hue[0.2909158283390718], EdgeForm[Opacity[0.3]], 
    CuboidBox[{0.12287836754369241`, 1.5660514934846326`, 
     2.8500303190353975`}]}, 
   {Hue[0.4146865341916832], EdgeForm[Opacity[0.3]], 
    CuboidBox[{2.7006837936303425`, 2.373519616989471, 
     1.8439981909610426`}]}, 
   {Hue[0.6711619558857813], EdgeForm[Opacity[0.3]], 
    CuboidBox[{1.7262217315476889`, 2.9990805472809976`, 
     2.9823427522875328`}]}, 
   {Hue[0.7107723098710963], EdgeForm[Opacity[0.3]], 
    CuboidBox[{1.7435889668987468`, 2.9278624841348178`, 
     1.6320940753211755`}]}, 
   {Hue[0.5565385591792116], EdgeForm[Opacity[0.3]], 
    CuboidBox[{2.0636319735630284`, 3.949454722676739, 1.92339121902425}]}, 
   {Hue[0.40084737354200173`], EdgeForm[Opacity[0.3]], 
    CuboidBox[{2.759742182382838, 3.895211544137693, 
     0.27473243730949815`}]}, 
   {Hue[0.9615787937269991], EdgeForm[Opacity[0.3]], 
    CuboidBox[{2.0651237689016293`, 2.766073871884231, 2.446706939484356}]}, 
   {Hue[0.8466642262993849], EdgeForm[Opacity[0.3]], 
    CuboidBox[{1.8619408592084739`, 2.928859229039168, 
     1.2427740183572276`}]}, 
   {Hue[0.3732261583058347], EdgeForm[Opacity[0.3]], 
    CuboidBox[{3.318859160446652, 3.5957099212660486`, 
     2.7553780038982083`}]}, 
   {Hue[0.2661843655194702], EdgeForm[Opacity[0.3]], 
    CuboidBox[{0.09165811321988215, 0.18710815002349523`, 
     2.795065433899154}]}, 
   {Hue[0.6112449953936341], EdgeForm[Opacity[0.3]], 
    CuboidBox[{1.5956861193682768`, 1.2716949136808244`, 
     0.9820309509135026}]}, 
   {Hue[0.135809171849538], EdgeForm[Opacity[0.3]], 
    CuboidBox[{2.7218153939543495`, 2.936757392432445, 
     3.2925178535572366`}]}, 
   {Hue[0.7241648432418935], EdgeForm[Opacity[0.3]], 
    CuboidBox[{3.2739411546327375`, 3.3956866330070765`, 
     3.7967172017130473`}]}, 
   {Hue[0.6354903185108156], EdgeForm[Opacity[0.3]], 
    CuboidBox[{1.0585232504135291`, 2.8089735726158604`, 
     0.8852517937930946}]}, 
   {Hue[0.49892203652521827`], EdgeForm[Opacity[0.3]], 
    CuboidBox[{0.24382216510040422`, 0.9975079723563622, 
     2.8377168369082906`}]}, 
   {Hue[0.13448161294414596`], EdgeForm[Opacity[0.3]], 
    CuboidBox[{0.8877189070327303, 0.3082496598566733, 3.206354405709482}]}, 
   {Hue[0.41151030169534164`], EdgeForm[Opacity[0.3]], 
    CuboidBox[{3.5230253101550595`, 2.710877693225207, 1.503580171650639}]}, 
   {Hue[0.32224289211633184`], EdgeForm[Opacity[0.3]], 
    CuboidBox[{0.5994997176940506, 3.873424957583329, 
     1.2530590145695744`}]}, 
   {Hue[0.1877812327118662], EdgeForm[Opacity[0.3]], 
    CuboidBox[{1.4822335801185007`, 3.350902115841869, 
     3.0380492261413847`}]}, 
   {Hue[0.863768054027402], EdgeForm[Opacity[0.3]], 
    CuboidBox[{3.430424497889799, 3.391351581862903, 2.718662842153708}]}, 
   {Hue[0.08152060049088772], EdgeForm[Opacity[0.3]], 
    CuboidBox[{1.9025656771975026`, 3.225382155660645, 
     1.9534598816482145`}]}, 
   {Hue[0.3722099494843467], EdgeForm[Opacity[0.3]], 
    CuboidBox[{1.997250970227194, 0.48381508345154867`, 
     0.42046808193696705`}]}, 
   {Hue[0.3135318977414605], EdgeForm[Opacity[0.3]], 
    CuboidBox[{2.788460856733341, 3.608762575969079, 2.614376796795928}]}, 
   {Hue[0.0461466273063984], EdgeForm[Opacity[0.3]], 
    CuboidBox[{0.5054875432088632, 0.6115100319552678, 3.89777776569258}]}, 
   {Hue[0.47443413481780805`], EdgeForm[Opacity[0.3]], 
    CuboidBox[{3.923005599717065, 3.069651672612131, 3.8129944036333416`}]}, 
   {Hue[0.7314062729968767], EdgeForm[Opacity[0.3]], 
    CuboidBox[{3.9885411207790975`, 0.30994246609849263`, 
     2.1377196773267277`}]}, 
   {Hue[0.9812866571881778], EdgeForm[Opacity[0.3]], 
    CuboidBox[{2.759193097761009, 1.231910875500878, 1.448950660050044}]}, 
   {Hue[0.14416485517325217`], EdgeForm[Opacity[0.3]], 
    CuboidBox[{3.34172443490021, 2.042802541128202, 0.10331002923135557`}]}, 
   {Hue[0.16898125326414304`], EdgeForm[Opacity[0.3]], 
    CuboidBox[{0.6342690037252643, 1.1576777850530462`, 
     0.7854949635471336}]}, 
   {Hue[0.5482331579322604], EdgeForm[Opacity[0.3]], 
    CuboidBox[{3.222823350684105, 3.3422570522507495`, 
     3.6549779921105445`}]}, 
   {Hue[0.805349973417248], EdgeForm[Opacity[0.3]], 
    CuboidBox[{1.715253779047277, 3.3924410980779456`, 
     1.0202698500681349`}]}, 
   {Hue[0.8476164839039355], EdgeForm[Opacity[0.3]], 
    CuboidBox[{0.20646189252489844`, 3.7682434853094247`, 
     3.0857785175293557`}]}, 
   {Hue[0.5639568969790245], EdgeForm[Opacity[0.3]], 
    CuboidBox[{1.1990266274148995`, 1.3541644503065804`, 
     3.1639421145344517`}]}, 
   {Hue[0.6057988321416585], EdgeForm[Opacity[0.3]], 
    CuboidBox[{0.01404592320814313, 0.6655092812969174, 
     0.45032840060704427`}]}, 
   {Hue[0.9255505799045718], EdgeForm[Opacity[0.3]], 
    CuboidBox[{3.175010636826853, 0.23894864456206122`, 
     2.6638723841338203`}]}, 
   {Hue[0.7794911004498641], EdgeForm[Opacity[0.3]], 
    CuboidBox[{0.16562783078322685`, 0.7121858416666118, 
     0.03604337956707848}]}}]], "Output",
 ImageSize->{229, 242},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->318465201,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3200033],

Cell["A pyramid with random color cubes:", "ExampleText",
 CellID->34799832],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"EdgeForm", "[", 
      RowBox[{"Opacity", "[", ".3", "]"}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Hue", "[", 
            RowBox[{
             RowBox[{"RandomReal", "[", "]"}], ",", ".8"}], "]"}], ",", 
           RowBox[{"Cuboid", "[", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}], ",", 
              RowBox[{"#", "[", 
               RowBox[{"[", "2", "]"}], "]"}], ",", 
              RowBox[{"-", "n"}]}], "}"}], "]"}]}], "}"}], "&"}], "/@", 
        RowBox[{"Tuples", "[", 
         RowBox[{
          RowBox[{"Range", "[", 
           RowBox[{
            RowBox[{"-", "n"}], ",", "n"}], "]"}], ",", "2"}], "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199066759],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 261},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{300, Automatic}},
 CellLabel->"Out[1]=",
 CellID->154077726]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31593],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Polygon",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Polygon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rectangle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rectangle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsComplex",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsComplex"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sphere",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sphere"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23990]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->23201],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Primitives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"]], "Tutorials",
 CellID->595610080]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->81381247],

Cell[TextData[ButtonBox["Graphics Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsObjects"]], "MoreAbout",
 CellID->96905482],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->27081685]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Cuboid",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Cuboid"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Cuboid"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cuboid - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 10.9735974}", "context" -> "System`", 
    "keywords" -> {
     "voxel", "cube", "rectangular parallelepiped", "volume element", 
      "cuboid", "box", "block"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Cuboid[{x_min, y_min, z_min}] is a three-dimensional graphics primitive \
that represents a unit cuboid, oriented parallel to the axes. Cuboid[{x_min, \
y_min, z_min}, {x_max, y_max, z_max}] specifies a cuboid by giving the \
coordinates of opposite corners. ", "synonyms" -> {}, "title" -> "Cuboid", 
    "type" -> "Symbol", "uri" -> "ref/Cuboid"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11393, 320, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->43950327]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 216617, 4532}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2289, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2912, 82, 4190, 83, 70, "ObjectNameGrid"],
Cell[7105, 167, 1842, 58, 70, "Usage",
 CellID->17644]
}, Open  ]],
Cell[CellGroupData[{
Cell[8984, 230, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9462, 247, 285, 8, 70, "Notes",
 CellID->19512],
Cell[9750, 257, 262, 7, 70, "Notes",
 CellID->29482],
Cell[10015, 266, 444, 14, 70, "Notes",
 CellID->2815],
Cell[10462, 282, 319, 11, 70, "Notes",
 CellID->5105],
Cell[10784, 295, 572, 20, 70, "Notes",
 CellID->25726]
}, Closed]],
Cell[CellGroupData[{
Cell[11393, 320, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->43950327],
Cell[CellGroupData[{
Cell[11777, 334, 148, 5, 70, "ExampleSection",
 CellID->330370630],
Cell[11928, 341, 56, 1, 70, "ExampleText",
 CellID->60734798],
Cell[CellGroupData[{
Cell[12009, 346, 133, 4, 28, "Input",
 CellID->25858966],
Cell[12145, 352, 1734, 33, 129, 62, 1, "CachedBoxData", "BoxData", "Output",
 CellID->507014065]
}, Open  ]],
Cell[13894, 388, 68, 2, 70, "Input",
 CellID->71137257],
Cell[13965, 392, 125, 3, 70, "ExampleDelimiter",
 CellID->341079342],
Cell[14093, 397, 60, 1, 70, "ExampleText",
 CellID->148782367],
Cell[CellGroupData[{
Cell[14178, 402, 130, 4, 70, "Input",
 CellID->13138992],
Cell[14311, 408, 3453, 62, 184, 142, 3, "CachedBoxData", "BoxData", "Output",
 CellID->619344078]
}, Open  ]],
Cell[17779, 473, 125, 3, 70, "ExampleDelimiter",
 CellID->138122153],
Cell[17907, 478, 72, 1, 70, "ExampleText",
 CellID->409176069],
Cell[CellGroupData[{
Cell[18004, 483, 566, 18, 70, "Input",
 CellID->630930797],
Cell[18573, 503, 3225, 58, 166, 158, 3, "CachedBoxData", "BoxData", "Output",
 CellID->396257291]
}, Open  ]],
Cell[21813, 564, 125, 3, 70, "ExampleDelimiter",
 CellID->270697137],
Cell[21941, 569, 70, 1, 70, "ExampleText",
 CellID->623678635],
Cell[CellGroupData[{
Cell[22036, 574, 859, 26, 70, "Input",
 CellID->58513546],
Cell[22898, 602, 7093, 130, 131, "Output",
 CellID->286235489]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30040, 738, 215, 7, 70, "ExampleSection",
 CellID->2700],
Cell[CellGroupData[{
Cell[30280, 749, 241, 7, 70, "ExampleSubsection",
 CellID->100694218],
Cell[30524, 758, 55, 1, 70, "ExampleText",
 CellID->346080421],
Cell[CellGroupData[{
Cell[30604, 763, 198, 6, 70, "Input",
 CellID->551570173],
Cell[30805, 771, 1734, 33, 129, 62, 1, "CachedBoxData", "BoxData", "Output",
 CellID->105636344]
}, Open  ]],
Cell[32554, 807, 125, 3, 70, "ExampleDelimiter",
 CellID->123000813],
Cell[32682, 812, 74, 1, 70, "ExampleText",
 CellID->371588825],
Cell[CellGroupData[{
Cell[32781, 817, 285, 9, 70, "Input",
 CellID->414149705],
Cell[33069, 828, 2069, 38, 131, 73, 1, "CachedBoxData", "BoxData", "Output",
 CellID->29779970]
}, Open  ]],
Cell[35153, 869, 125, 3, 70, "ExampleDelimiter",
 CellID->544915418],
Cell[35281, 874, 93, 1, 70, "ExampleText",
 CellID->733728274],
Cell[CellGroupData[{
Cell[35399, 879, 194, 6, 70, "Input",
 CellID->393465097],
Cell[35596, 887, 2646, 49, 194, 76, 2, "CachedBoxData", "BoxData", "Output",
 CellID->81424888]
}, Open  ]],
Cell[38257, 939, 125, 3, 70, "ExampleDelimiter",
 CellID->385973761],
Cell[38385, 944, 242, 9, 70, "ExampleText",
 CellID->53106414],
Cell[CellGroupData[{
Cell[38652, 957, 706, 22, 70, "Input",
 CellID->42510562],
Cell[39361, 981, 3186, 57, 199, 153, 3, "CachedBoxData", "BoxData", "Output",
 CellID->64740920]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[42596, 1044, 235, 7, 70, "ExampleSubsection",
 CellID->462895622],
Cell[42834, 1053, 95, 1, 70, "ExampleText",
 CellID->151980596],
Cell[CellGroupData[{
Cell[42954, 1058, 385, 13, 70, "Input",
 CellID->75401255],
Cell[43342, 1073, 6470, 120, 131, "Output",
 CellID->41296232]
}, Open  ]],
Cell[49827, 1196, 125, 3, 70, "ExampleDelimiter",
 CellID->356363649],
Cell[49955, 1201, 412, 13, 70, "ExampleText",
 CellID->134118418],
Cell[CellGroupData[{
Cell[50392, 1218, 358, 10, 70, "Input",
 CellID->136321887],
Cell[50753, 1230, 3001, 54, 184, 178, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->625968028]
}, Open  ]],
Cell[53769, 1287, 125, 3, 70, "ExampleDelimiter",
 CellID->100439864],
Cell[53897, 1292, 303, 9, 70, "ExampleText",
 CellID->512602954],
Cell[CellGroupData[{
Cell[54225, 1305, 1051, 35, 70, "Input",
 CellID->30276328],
Cell[55279, 1342, 3283, 63, 185, 379, 11, "CachedBoxData", "BoxData", \
"Output",
 CellID->155196366]
}, Open  ]],
Cell[58577, 1408, 125, 3, 70, "ExampleDelimiter",
 CellID->493157315],
Cell[58705, 1413, 84, 1, 70, "ExampleText",
 CellID->358441062],
Cell[CellGroupData[{
Cell[58814, 1418, 781, 25, 70, "Input",
 CellID->227665862],
Cell[59598, 1445, 19753, 342, 131, "Output",
 CellID->807113532]
}, Open  ]],
Cell[79366, 1790, 71, 1, 70, "ExampleText",
 CellID->291906364],
Cell[CellGroupData[{
Cell[79462, 1795, 230, 7, 70, "Input",
 CellID->3405511],
Cell[79695, 1804, 1762, 35, 129, 111, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->53108342]
}, Open  ]],
Cell[81472, 1842, 125, 3, 70, "ExampleDelimiter",
 CellID->101004100],
Cell[81600, 1847, 248, 8, 70, "ExampleText",
 CellID->94273435],
Cell[CellGroupData[{
Cell[81873, 1859, 472, 16, 70, "Input",
 CellID->36811579],
Cell[82348, 1877, 5383, 101, 131, "Output",
 CellID->222658126]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[87792, 1985, 223, 7, 70, "ExampleSection",
 CellID->13285],
Cell[88018, 1994, 63, 1, 70, "ExampleText",
 CellID->4437456],
Cell[88084, 1997, 283, 10, 70, "Input",
 CellID->12188379],
Cell[CellGroupData[{
Cell[88392, 2011, 1337, 40, 70, "Input",
 CellID->58746949],
Cell[89732, 2053, 12300, 276, 199, 5425, 159, "CachedBoxData", "BoxData", \
"Output",
 CellID->99700299]
}, Open  ]],
Cell[102047, 2332, 125, 3, 70, "ExampleDelimiter",
 CellID->561626156],
Cell[102175, 2337, 116, 3, 70, "ExampleText",
 CellID->36869246],
Cell[CellGroupData[{
Cell[102316, 2344, 952, 30, 70, "Input",
 CellID->23867461],
Cell[103271, 2376, 16231, 270, 70, "Output",
 Evaluatable->False,
 CellID->532794878]
}, Open  ]],
Cell[119517, 2649, 125, 3, 70, "ExampleDelimiter",
 CellID->716725367],
Cell[119645, 2654, 83, 1, 70, "ExampleText",
 CellID->77061886],
Cell[119731, 2657, 1597, 46, 70, "Input",
 CellID->403843786],
Cell[CellGroupData[{
Cell[121353, 2707, 706, 21, 70, "Input",
 CellID->472955575],
Cell[122062, 2730, 7796, 132, 70, "Output",
 Evaluatable->False,
 CellID->44659025]
}, Open  ]],
Cell[129873, 2865, 125, 3, 70, "ExampleDelimiter",
 CellID->735396897],
Cell[130001, 2870, 56, 1, 70, "ExampleText",
 CellID->409920192],
Cell[CellGroupData[{
Cell[130082, 2875, 1940, 59, 70, "Input",
 CellID->589276927],
Cell[132025, 2936, 21372, 355, 70, "Output",
 Evaluatable->False,
 CellID->59708455]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[153446, 3297, 232, 7, 70, "ExampleSection",
 CellID->6762],
Cell[153681, 3306, 211, 8, 70, "ExampleText",
 CellID->810135533],
Cell[CellGroupData[{
Cell[153917, 3318, 547, 17, 70, "Input",
 CellID->56050736],
Cell[154467, 3337, 4288, 78, 172, 681, 14, "CachedBoxData", "BoxData", \
"Output",
 CellID->202349895]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[158804, 3421, 224, 7, 70, "ExampleSection",
 CellID->21374],
Cell[159031, 3430, 69, 1, 70, "ExampleText",
 CellID->120632237],
Cell[CellGroupData[{
Cell[159125, 3435, 507, 15, 70, "Input",
 CellID->192475024],
Cell[159635, 3452, 17725, 314, 263, 5602, 111, "CachedBoxData", "BoxData", \
"Output",
 CellID->318465201]
}, Open  ]],
Cell[177375, 3769, 123, 3, 70, "ExampleDelimiter",
 CellID->3200033],
Cell[177501, 3774, 76, 1, 70, "ExampleText",
 CellID->34799832],
Cell[CellGroupData[{
Cell[177602, 3779, 1184, 34, 70, "Input",
 CellID->199066759],
Cell[178789, 3815, 32853, 543, 70, "Output",
 Evaluatable->False,
 CellID->154077726]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[211703, 4365, 311, 9, 70, "SeeAlsoSection",
 CellID->31593],
Cell[212017, 4376, 951, 35, 70, "SeeAlso",
 CellID->23990]
}, Open  ]],
Cell[CellGroupData[{
Cell[213005, 4416, 314, 9, 70, "TutorialsSection",
 CellID->23201],
Cell[213322, 4427, 197, 4, 70, "Tutorials",
 CellID->595610080]
}, Open  ]],
Cell[CellGroupData[{
Cell[213556, 4436, 318, 9, 70, "MoreAboutSection",
 CellID->81381247],
Cell[213877, 4447, 142, 3, 70, "MoreAbout",
 CellID->96905482],
Cell[214022, 4452, 161, 3, 70, "MoreAbout",
 CellID->27081685]
}, Open  ]],
Cell[CellGroupData[{
Cell[214220, 4460, 305, 8, 70, "RelatedLinksSection"],
Cell[214528, 4470, 357, 12, 70, "RelatedLinks"],
Cell[214888, 4484, 384, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[215287, 4500, 50, 0, 70, "History"],
Cell[215340, 4502, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

