(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22380,        588]
NotebookOptionsPosition[     19738,        498]
NotebookOutlinePosition[     20928,        534]
CellTagsIndexPosition[     20843,        529]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LightCyan" :> Documentation`HelpLookup["paclet:ref/LightCyan"],
           "ColorData" :> Documentation`HelpLookup["paclet:ref/ColorData"], 
          "Lighter" :> Documentation`HelpLookup["paclet:ref/Lighter"], 
          "Darker" :> Documentation`HelpLookup["paclet:ref/Darker"], "Hue" :> 
          Documentation`HelpLookup["paclet:ref/Hue"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "Style" :> 
          Documentation`HelpLookup["paclet:ref/Style"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LightCyan\"\>", 2->"\<\"ColorData\"\>", 
       3->"\<\"Lighter\"\>", 4->"\<\"Darker\"\>", 5->"\<\"Hue\"\>", 
       6->"\<\"RGBColor\"\>", 7->"\<\"Style\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Colors" :> Documentation`HelpLookup["paclet:guide/Colors"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Colors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Cyan", "ObjectName",
 CellID->6361],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Cyan",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cyan"]], "InlineFormula"],
     "\[LineSeparator]represents the color cyan in graphics or style \
specifications. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32421]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cyan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cyan"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"], "[", 
   RowBox[{"0", ",", "1", ",", "1"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->77445997],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->303315877],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Cyan", ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->511908593],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0, 1, 1], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->36408704]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", "Cyan"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->245967023],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->69037162]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{"Cyan", ",", 
    RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->82364862],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0, 1, 1], SphereBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->101111778,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27445],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LightCyan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LightCyan"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColorData",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColorData"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Lighter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Lighter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Darker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Darker"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Style",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Style"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2524]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->413328406],

Cell[TextData[ButtonBox["Colors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Colors"]], "MoreAbout",
 CellID->14058519]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cyan - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 16.0831032}", "context" -> "System`", 
    "keywords" -> {"color"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Cyan represents the color cyan in graphics or style specifications. ", 
    "synonyms" -> {}, "title" -> "Cyan", "type" -> "Symbol", "uri" -> 
    "ref/Cyan"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3686, 121, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->77445997]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20701, 522}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1660, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2283, 63, 41, 1, 70, "ObjectName",
 CellID->6361],
Cell[2327, 66, 440, 14, 70, "Usage",
 CellID->32421]
}, Open  ]],
Cell[CellGroupData[{
Cell[2804, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3282, 102, 367, 14, 70, "Notes",
 CellID->5162]
}, Closed]],
Cell[CellGroupData[{
Cell[3686, 121, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->77445997],
Cell[CellGroupData[{
Cell[4070, 135, 148, 5, 70, "ExampleSection",
 CellID->303315877],
Cell[CellGroupData[{
Cell[4243, 144, 182, 6, 28, "Input",
 CellID->511908593],
Cell[4428, 152, 262, 8, 121, "Output",
 CellID->36408704]
}, Open  ]],
Cell[CellGroupData[{
Cell[4727, 165, 265, 8, 28, "Input",
 CellID->245967023],
Cell[4995, 175, 2271, 41, 109, "Output",
 Evaluatable->False,
 CellID->69037162]
}, Open  ]],
Cell[CellGroupData[{
Cell[7303, 221, 185, 6, 70, "Input",
 CellID->82364862],
Cell[7491, 229, 9659, 163, 129, 86, 2, "CachedBoxData", "BoxData", "Output",
 CellID->101111778]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17211, 399, 311, 9, 70, "SeeAlsoSection",
 CellID->27445],
Cell[17525, 410, 1657, 62, 70, "SeeAlso",
 CellID->2524]
}, Open  ]],
Cell[CellGroupData[{
Cell[19219, 477, 319, 9, 70, "MoreAboutSection",
 CellID->413328406],
Cell[19541, 488, 123, 3, 70, "MoreAbout",
 CellID->14058519]
}, Open  ]],
Cell[19679, 494, 29, 0, 70, "History"],
Cell[19711, 496, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

