(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     98656,       2582]
NotebookOptionsPosition[     90025,       2276]
NotebookOutlinePosition[     91250,       2312]
CellTagsIndexPosition[     91164,       2307]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Operations on Polynomials" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AlgebraicOperationsOnPolynomials"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Algebraic Operations on Polynomials\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Factor" :> Documentation`HelpLookup["paclet:ref/Factor"], 
          "Roots" :> Documentation`HelpLookup["paclet:ref/Roots"], 
          "RootOfUnityQ" :> 
          Documentation`HelpLookup["paclet:ref/RootOfUnityQ"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Factor\"\>", 2->"\<\"Roots\"\>", 
       3->"\<\"RootOfUnityQ\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Polynomial Algebra\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Cyclotomic", "ObjectName",
 CellID->16544],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Cyclotomic",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cyclotomic"], "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " cyclotomic polynomial in ",
     Cell[BoxData[
      FormBox["x", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20236]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The cyclotomic polynomial ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["C", "n"], "(", "x", ")"}], TraditionalForm]], 
  "InlineMath"],
 " of order ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " is defined to be ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderscriptBox["\[Product]", "k",
     LimitsPositioning->True], 
    RowBox[{"(", 
     RowBox[{"x", "-", 
      SuperscriptBox["e", 
       RowBox[{
       "2", "\[InvisibleSpace]", "\[Pi]", "\[InvisibleSpace]", "i", 
        "\[InvisibleSpace]", 
        RowBox[{"k", "/", "n"}]}]]}], ")"}]}], TraditionalForm]], 
  "InlineMath"],
 ", where the product runs over integers ",
 Cell[BoxData[
  FormBox["k", TraditionalForm]], "InlineMath"],
 " less than ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " that are relatively prime to ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->20012]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->89796633],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->169578442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cyclotomic", "[", 
  RowBox[{"5", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32134],

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["x", "3"], "+", 
  SuperscriptBox["x", "4"]}]], "Output",
 ImageSize->{106, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->498636145]
}, Open  ]],

Cell[TextData[{
 "The roots are the irreducible 5",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " roots of -1:"
}], "ExampleText",
 CellID->674750681],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Cyclotomic", "[", 
     RowBox[{"5", ",", "x"}], "]"}], "==", "0"}], ",", "x"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->3671],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"1", "/", "5"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"2", "/", "5"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], 
       RowBox[{"3", "/", "5"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"4", "/", "5"}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{392, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->671876583]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19659],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->42917134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Cyclotomic", "[", 
   RowBox[{"n", ",", "x"}], "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->887377959],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubscriptBox[
    TagBox["C",
     Cyclotomic], "n"], "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->191319427]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10282],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"x", "^", "11"}], "-", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1848],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", "x", "+", 
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["x", "3"], "+", 
    SuperscriptBox["x", "4"], "+", 
    SuperscriptBox["x", "5"], "+", 
    SuperscriptBox["x", "6"], "+", 
    SuperscriptBox["x", "7"], "+", 
    SuperscriptBox["x", "8"], "+", 
    SuperscriptBox["x", "9"], "+", 
    SuperscriptBox["x", "10"]}], ")"}]}]], "Output",
 ImageSize->{328, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->322352305]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cyclotomic", "[", 
  RowBox[{"11", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23290],

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["x", "3"], "+", 
  SuperscriptBox["x", "4"], "+", 
  SuperscriptBox["x", "5"], "+", 
  SuperscriptBox["x", "6"], "+", 
  SuperscriptBox["x", "7"], "+", 
  SuperscriptBox["x", "8"], "+", 
  SuperscriptBox["x", "9"], "+", 
  SuperscriptBox["x", "10"]}]], "Output",
 ImageSize->{262, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->245115692]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14458],

Cell["Values of successive cyclotomic polynomials at 1:", "ExampleText",
 CellID->32071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Cyclotomic", "[", 
    RowBox[{"n", ",", "1"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "2", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30106],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2", ",", "3", ",", "2", ",", "5", ",", "1", ",", "7", ",", "2", ",", "3", 
   ",", "1", ",", "11", ",", "1", ",", "13", ",", "1", ",", "1", ",", "2", 
   ",", "17", ",", "1", ",", "19", ",", "1"}], "}"}]], "Output",
 ImageSize->{381, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102201175]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->138730271],

Cell[TextData[{
 "Calculate ",
 ButtonBox["unique primes",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/UniquePrime.html"], None}],
 " for which the decimal expansion of ",
 Cell[BoxData[
  FormBox[
   RowBox[{"1", "/", "p"}], TraditionalForm]], "InlineMath"],
 " has a unique period:"
}], "ExampleText",
 CellID->238108908],

Cell[BoxData[
 RowBox[{
  RowBox[{"up", "[", "n_", "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Length", "[", "#", "]"}], "===", "1"}], ",", 
      RowBox[{"#", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}], "&"}], "[", 
   RowBox[{"FactorInteger", "[", 
    RowBox[{
     RowBox[{"Cyclotomic", "[", 
      RowBox[{"n", ",", "10"}], "]"}], "/", 
     RowBox[{"GCD", "[", 
      RowBox[{
       RowBox[{"Cyclotomic", "[", 
        RowBox[{"n", ",", "10"}], "]"}], ",", "n"}], "]"}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->693938140],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"up", "[", "n", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "10"}], "}"}]}], "]"}], ",", "NumberQ"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->90747633],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "11", ",", "37", ",", "101", ",", "333667", ",", "9091"}],
   "}"}]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->204184131]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RealDigits", "[", 
  RowBox[{"1", "/", "%"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->104551757],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", "3", "}"}], "}"}], ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"9", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"2", ",", "7", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"9", ",", "9", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"-", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
       "2", ",", "9", ",", "9", ",", "7", ",", "0", ",", "0", ",", "0", ",", 
        "0", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"-", "5"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
       "1", ",", "0", ",", "9", ",", "9", ",", "9", ",", "8", ",", "9", ",", 
        "0", ",", "0", ",", "0"}], "}"}], "}"}], ",", 
     RowBox[{"-", "3"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{489, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->395228363]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->108690062],

Cell["Plot cyclotomic polynomials:", "ExampleText",
 CellID->402321775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Cyclotomic", "[", 
       RowBox[{"k", ",", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "0", ",", "10"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->191646633],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135563036]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->613196266],

Cell[TextData[{
 "Plot arguments of roots of ",
 Cell[BoxData[
  ButtonBox["Cyclotomic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cyclotomic"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->93937456],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Arg", "[", "#", "]"}], ",", "n"}], "}"}], "&"}], "/@", 
      RowBox[{"(", 
       RowBox[{"z", "/.", 
        RowBox[{"NSolve", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"Cyclotomic", "[", 
            RowBox[{"n", ",", "z"}], "]"}], "==", "0"}], ",", "z"}], "]"}]}], 
       ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"PlotMarkers", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16162773],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->125714969]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5553237],

Cell["\<\
Plot the degree and number of terms of cyclotomic polynomials:\
\>", "ExampleText",
 CellID->10311134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Exponent", "[", 
       RowBox[{
        RowBox[{"Cyclotomic", "[", 
         RowBox[{"n", ",", "x"}], "]"}], ",", "x"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "500"}], "}"}]}], "]"}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Length", "[", 
       RowBox[{"Cyclotomic", "[", 
        RowBox[{"n", ",", "x"}], "]"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "500"}], "}"}]}], "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38958207],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdl0uOHEUQhhtWLHvBggWLAiGEEELF+42TwcZgsCk/MH5hl9sevx9ljz0z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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 500.}, {0., 498.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}], ",", 
   GraphicsBox[{{}, 
     {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxtmEmOHEUUhgNWLGvBggWLpIQQQggV84yDxsbMFGY0k9NNe8B4SNNut4e2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       "]]}, {}},
    AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
    Axes->True,
    AxesOrigin->{0, 0},
    PlotRange->{{0., 500.}, {0., 499.}},
    PlotRangeClipping->True,
    PlotRangePadding->{
      Scaled[0.02], 
      Scaled[0.02]}]}], "}"}]], "Output",
 ImageSize->{390, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->360764094]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11001],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Cyclotomic", "[", 
     RowBox[{"3", ",", "x"}], "]"}]}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25434],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"ArcTan", "[", 
    FractionBox[
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "x"}]}], 
     SqrtBox["3"]], "]"}]}], 
  SqrtBox["3"]]], "Output",
 ImageSize->{101, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1537509]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->429019529],

Cell["Factor a cyclotomic polynomial over an extension field:", "ExampleText",
 CellID->879150250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{"Cyclotomic", "[", 
   RowBox[{"5", ",", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54993685],

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  SuperscriptBox["x", "2"], "+", 
  SuperscriptBox["x", "3"], "+", 
  SuperscriptBox["x", "4"]}]], "Output",
 ImageSize->{106, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->547160533]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Factor", "[", 
  RowBox[{
   RowBox[{"Cyclotomic", "[", 
    RowBox[{"5", ",", "x"}], "]"}], ",", 
   RowBox[{"Extension", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"1", "/", "5"}], ")"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->373004704],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWdtOwkAQXVoKisYLiPIgUI0mJkZ81hcv8fLkN5iGmMCD0SC/qXxS7Q2B
0y0zU0pSE0iAzs7lnJmd7i7lxRn23t6dYb/r2M8D57PX737ZTx8Db8gsKFX4
UUpVG8q7dr2r4O2/Rt5bKcv/NMdjrroBeQPkb0J/K9QXAxZFGL0DeR3kEaG/
F+rNHLPAGdoC+YxAOSL8T0DeFuopfOS/bP+wiiYRZYeIUiaqiP7HIO8K9RQ+
8l+2v6GtIvamP1eWivds0/swPNGIvlGP7CpRHBxHOQnPToiHdvtMHovmg3ou
n2JOcHizj2s76lvB4ESO7zaYzyahR5ligH2B8aX9QfnLM8YIUoZWDhF53eNb
6XoV5Xpk56P4vVoi8jOm7JG3bo2R8kD8JDz03yPwuf4lZh2S6v1fcLJZg9rM
LP77ysPNc9G7P21XZIWz2pl4/FY7U/qdiZo75F1zZac2zAvP4lJ8rANVt6z9
pflL5znvePquwt6rgIz2vmxGKPPsDgi2mF1VyGO8f0c/pJWuQlTHps0tTVxD
xWsvrRnOFYXLqVHWmGlzDbuTeqq05up7G+UArfwnT9L3XoiMT3IqEUadia1d
vROwaxrsRfPhxgzOKBbEmJkXTnUw2yQ0SVWywkyXof55ZkvHf04/Y7dgDtfC
eOdLtqf4tnMWTzBLk7OVG/ZJg+CmnZtYlA7L6tJN6kEOE22VxPnYIg5hZfEe
O5yS1fhemzm1YhzcGa50ODMROiQGbUGxwA6Js6AiNMUcwn+LTnXI07J3+RrN
CVbfv7xg+HNsHuZgPDL8m2GShV/KVgWw\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{462, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->304055804]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->429047335],

Cell["Generate cyclotomic polynomials from a definition:", "ExampleText",
 CellID->17677922],

Cell[BoxData[
 RowBox[{
  RowBox[{"c", "[", 
   RowBox[{"n_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{"Product", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", 
         RowBox[{"E", "^", 
          RowBox[{"(", 
           RowBox[{"2", "Pi", " ", "I", " ", 
            RowBox[{"k", "/", "n"}]}], ")"}]}]}], ")"}], "^", 
       RowBox[{"KroneckerDelta", "[", 
        RowBox[{
         RowBox[{"GCD", "[", 
          RowBox[{"k", ",", "n"}], "]"}], ",", "1"}], "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "1", ",", "n"}], "}"}]}], "]"}], ",", "z", ",", 
    RowBox[{
     RowBox[{"RootReduce", "[", 
      RowBox[{"Together", "[", "#", "]"}], "]"}], "&"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->175421337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"c", "[", 
    RowBox[{"n", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->282233393],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", "z"}], ",", 
   RowBox[{"1", "+", "z"}], ",", 
   RowBox[{"1", "+", "z", "+", 
    SuperscriptBox["z", "2"]}], ",", 
   RowBox[{"1", "+", 
    SuperscriptBox["z", "2"]}], ",", 
   RowBox[{"1", "+", "z", "+", 
    SuperscriptBox["z", "2"], "+", 
    SuperscriptBox["z", "3"], "+", 
    SuperscriptBox["z", "4"]}], ",", 
   RowBox[{"1", "-", "z", "+", 
    SuperscriptBox["z", "2"]}]}], "}"}]], "Output",
 ImageSize->{373, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->242263636]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Cyclotomic", "[", 
    RowBox[{"n", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->67888974],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", "z"}], ",", 
   RowBox[{"1", "+", "z"}], ",", 
   RowBox[{"1", "+", "z", "+", 
    SuperscriptBox["z", "2"]}], ",", 
   RowBox[{"1", "+", 
    SuperscriptBox["z", "2"]}], ",", 
   RowBox[{"1", "+", "z", "+", 
    SuperscriptBox["z", "2"], "+", 
    SuperscriptBox["z", "3"], "+", 
    SuperscriptBox["z", "4"]}], ",", 
   RowBox[{"1", "-", "z", "+", 
    SuperscriptBox["z", "2"]}]}], "}"}]], "Output",
 ImageSize->{373, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->427548072]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24334920],

Cell[TextData[{
 "Use an alternative definition, valid for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"n", ">", "2"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->23946580],

Cell[BoxData[
 RowBox[{
  RowBox[{"c", "[", 
   RowBox[{"n_", ",", "z_"}], "]"}], ":=", 
  RowBox[{"Cancel", "[", 
   RowBox[{"Times", "@@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"z", "^", "#"}]}], ")"}], "^", 
        RowBox[{"MoebiusMu", "[", 
         RowBox[{"n", "/", "#"}], "]"}]}], "&"}], "/@", 
      RowBox[{"Divisors", "[", "n", "]"}]}], ")"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->44312945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"c", "[", 
    RowBox[{"n", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->33746308],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"1", "-", "z"}], ",", 
   RowBox[{"1", "+", "z"}], ",", 
   RowBox[{"1", "+", "z", "+", 
    SuperscriptBox["z", "2"]}], ",", 
   RowBox[{"1", "+", 
    SuperscriptBox["z", "2"]}], ",", 
   RowBox[{"1", "+", "z", "+", 
    SuperscriptBox["z", "2"], "+", 
    SuperscriptBox["z", "3"], "+", 
    SuperscriptBox["z", "4"]}], ",", 
   RowBox[{"1", "-", "z", "+", 
    SuperscriptBox["z", "2"]}]}], "}"}]], "Output",
 ImageSize->{365, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->476510903]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Cyclotomic", "[", 
    RowBox[{"n", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->251879289],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "1"}], "+", "z"}], ",", 
   RowBox[{"1", "+", "z"}], ",", 
   RowBox[{"1", "+", "z", "+", 
    SuperscriptBox["z", "2"]}], ",", 
   RowBox[{"1", "+", 
    SuperscriptBox["z", "2"]}], ",", 
   RowBox[{"1", "+", "z", "+", 
    SuperscriptBox["z", "2"], "+", 
    SuperscriptBox["z", "3"], "+", 
    SuperscriptBox["z", "4"]}], ",", 
   RowBox[{"1", "-", "z", "+", 
    SuperscriptBox["z", "2"]}]}], "}"}]], "Output",
 ImageSize->{373, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->150169069]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->857131980],

Cell["Form products of cyclotomic polynomials:", "ExampleText",
 CellID->46427616],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"n_", ",", " ", "z_"}], "]"}], ":=", 
  RowBox[{"Expand", "[", 
   RowBox[{"Times", "@@", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Cyclotomic", "[", 
        RowBox[{"#", ",", "z"}], "]"}], "&"}], "/@", 
      RowBox[{"Divisors", "[", "n", "]"}]}], ")"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21632654],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"n", ",", "z"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "8"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->72038215],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV01PAjEQnd12JaDRaGTBg4aLJ42A/gc5edCT1w0xgYPRIL/CeNafW9ul
FXxMuwtiuOwm2/a9vpl+znZ7l01HT8/ZdDzMOoNJ9joaD986ty8TTYmIKPok
oqM26bLSpfw1z5d+iaROY0u923KS1wiTCqdWefYBXPxH5Tng3j/jfulemXno
r5hfl/Je10miYQ34xPIS+H2PXlq+UelX0vOrsguYWx1KfnDuYx49hwXWkrVu
VNZbsV7eDTGwZndwsehidAd4twcTjx7540of1O8BjtQ6MYu4VVCPq3pa6YP6
DX5Z5RwTtQss5JLFWWVR2gLXo9yqHahZpGIMuS8f7p1t8+vtzQvATZ0IZkca
3pxBJ8CnVo+zlALG+pC/kB3W43nFj9qdoJc2R68tT298vWwyfsjiEI+zmnr0
eDrwo3oAjP/+XZ2YQMA7wBW0hvXdjfSmqNWe+n2XuAn0wr/S7n/0nvGOY4yB
5+YM7RALtXhjfCzwxs2BgN44vKirz1qLvgHBBcdR\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{406, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->605350365]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10397363],

Cell["\<\
Plot the Riemann surface of an inverse of a cyclotomic polynomial over the \
complex plane:\
\>", "ExampleText",
 CellID->141202884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Re", "[", 
       RowBox[{"Cyclotomic", "[", 
        RowBox[{"10", ",", 
         RowBox[{"x", "+", 
          RowBox[{"I", " ", "y"}]}]}], "]"}], "]"}], ",", 
      RowBox[{"Im", "[", 
       RowBox[{"Cyclotomic", "[", 
        RowBox[{"10", ",", 
         RowBox[{"x", "+", 
          RowBox[{"I", " ", "y"}]}]}], "]"}], "]"}], ",", "x"}], "}"}], "]"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Mesh", "->", "False"}], ",", 
   RowBox[{"BoxRatios", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21486753],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 200},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->733103189]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->538447],

Cell[TextData[{
 "Plot the complex roots of successive derivatives of the 50",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " cyclotomic polynomial:"
}], "ExampleText",
 CellID->700628572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Point", "[", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Map", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Re", "[", "#", "]"}], ",", 
          RowBox[{"Im", "[", "#", "]"}]}], "}"}], "&"}], ",", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"z", "/.", 
          RowBox[{"NSolve", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"D", "[", 
              RowBox[{
               RowBox[{"Cyclotomic", "[", 
                RowBox[{"50", ",", "z"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"z", ",", "k"}], "}"}]}], "]"}], "==", "0"}], ",", 
            "z"}], "]"}]}], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{
            RowBox[{"EulerPhi", "[", "50", "]"}], "-", "2"}]}], "}"}]}], 
        "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"-", "1"}], "}"}]}], "]"}], ",", "1"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->464799622],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1mW9PG0cQxg+f/wCpUztBcZSqCNQWOSQhqVqkUIEDtMQoQBOikLaqBHKd
VFCpoYK86Iu+Kmrpm0j5BnyJSEj9cnS9c7qd+93YoUpricPz3Mwzc+vd2Z25
jc7L3ec/d17udTsT7YPOL7t73cOJ+/sHDoqHoih64/7+vhq572fum/97c3bm
/uvrd71rfHx87G7v7u5G3yp0YmLCocPDwxn09PR0cXHx5OQkQTXbAdjuKTSw
aTSwCfo9GJ4qNDBoNDA8zcUj1x1wPlZo4KxCa1lpBR9VWDVg1fRW+7BqwEq0
JmH7HFZaK9i+VmjQXQDXOOTb3qoDrnHIWitwj0O+rcb2N/iZVWjgFfQj6M5D
bsCPtgpc85AvgeULZRW45iGXYDUKVmH5CegoWLRWQNsePYSHlke7QDmfROtj
c6Q4V4NHbcWRClpfK62AvvLoC3j80qPvA92CXIRHbRXQLchFRKCtAjpmjV/c
6XScvLS0FD3wVlPW+ClZa2G8lPxAzeir8Ovvxe1228nT09PRutIKfi7Cas7L
hUIhko+2Cn4vgkWsarWak+M4Tqyuw2oO8rqK/hni2FBo8CPoTWvtKt4Nc9WW
wfWHuUrL4NJaXJVhbB96rR88WiwWk7HT6NHRkRuebreboPLUNxDjnx69DLQA
udaTSxKzeOuhn0LrkeeKgTJ/lPD8Bci095mkJCMxNjaWaN3poUXREkh7D2z0
VsK4FiDTvmhGH/QlDtF3c9hBOg5m0SDXIDM/DHt5amrKyfV6PboF/U3v5ROg
YjU0NJTMB85b2c99zPH29rb7KVutVqKFTMBnjj4H2rSyDEc6scJ+nvOFcUqs
sL8rWZ7jbnYOuKB+Vbj4EDd7iP09pedYZ2Zmms2mI+Y5YwXRit18zu+HXq/3
O0k2WkG82k7HJXaNRsOJpVIpehL0KjquENE1MIvFork+eUKsK12uJ54bRXcZ
3q6AkffFyj6D3s+NWh3WPJldUXZ61DbBr/X0qG1a0Udr8LIK+QOlFXysQtZa
wcMqZNF6DQ+TCg2MGg0Mkyp36+s3WOkXrAyeGW2PVFKNzBe/95adcOY/6TbD
fcDLo2lWclKerwwbRlaBHKfPE6fPgd0h8+vLc6QamS/+OYpOkOdwS6GHcIeR
p0jHzkl5Nu7djKti7VqZX6V3vWDtNpk5KrGkGvpLVkft59yzhCPN507K8/GU
wcgqkOPcjHv3WcyV9+OAlWavR640rsd8jlm3xuo/zDF18C2YOcfOiMtWLMqW
93X+FrRarQ7M33pfKJfLCS+7AaLrIy+n3tLb1xCF2qMy5y/ugVpPn4+4562A
X/bKuT7RsMK2d+i7uej2YKf1dHTqBKG0WWXK+cM+EZ3vHMUTESqs3DnqTjZ7
6zWeMLAO45lKTn0jIyNJbuKpT57pbad3dnHkxNn7veVzE74169tO5WTtXz2X
srMjTY23YLepvPc/i9sVCXaoAVU57XVNIBRSE1w2cxErn3B/VK30tbW1TMXh
tHomqvJhxVwD+2e4L1Y3gEo9KBXk+apNu1fF6tOueoOVXfXaFTTn2Cy4BlXy
z2ArqOxw18HzlxrXgNqdiFCpDep6sDMRzm9210NWcqjUdP9iCnG1rCxwzq4P
u1djiMPuKJ2ve2V3ygL3FmS7U/YCWoIyL79SKLt7Qcvu7tmdQ7sr2b/LLVqH
1vgl3c/A2FYoO6d2lzagX1m5IteVtTvCgeUSWAZ1hPt38mdVdujfydf9bnau
ZUb/Dl7dY2e/np14Vu4L0LI783xjwNPbI6UVUHmvsA+P9vuNHaD2WxG+79gx
5yLHlu8/doA+VmObv77L+yN2nO95rX/z9ur/fr8WDf0DeP+9sQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 186},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58059452]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4075],

Cell["\<\
The first cyclotomic polynomial with a coefficient other than 0, \
\[PlusMinus]1:\
\>", "ExampleText",
 CellID->8803],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cyclotomic", "[", 
  RowBox[{"105", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21439],

Cell[BoxData[
 RowBox[{"1", "+", "x", "+", 
  SuperscriptBox["x", "2"], "-", 
  SuperscriptBox["x", "5"], "-", 
  SuperscriptBox["x", "6"], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "7"]}], "-", 
  SuperscriptBox["x", "8"], "-", 
  SuperscriptBox["x", "9"], "+", 
  SuperscriptBox["x", "12"], "+", 
  SuperscriptBox["x", "13"], "+", 
  SuperscriptBox["x", "14"], "+", 
  SuperscriptBox["x", "15"], "+", 
  SuperscriptBox["x", "16"], "+", 
  SuperscriptBox["x", "17"], "-", 
  SuperscriptBox["x", "20"], "-", 
  SuperscriptBox["x", "22"], "-", 
  SuperscriptBox["x", "24"], "-", 
  SuperscriptBox["x", "26"], "-", 
  SuperscriptBox["x", "28"], "+", 
  SuperscriptBox["x", "31"], "+", 
  SuperscriptBox["x", "32"], "+", 
  SuperscriptBox["x", "33"], "+", 
  SuperscriptBox["x", "34"], "+", 
  SuperscriptBox["x", "35"], "+", 
  SuperscriptBox["x", "36"], "-", 
  SuperscriptBox["x", "39"], "-", 
  SuperscriptBox["x", "40"], "-", 
  RowBox[{"2", " ", 
   SuperscriptBox["x", "41"]}], "-", 
  SuperscriptBox["x", "42"], "-", 
  SuperscriptBox["x", "43"], "+", 
  SuperscriptBox["x", "46"], "+", 
  SuperscriptBox["x", "47"], "+", 
  SuperscriptBox["x", "48"]}]], "Output",
 ImageSize->{491, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->869473371]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22488],

Cell["Nonzero coefficients of successive cyclotomic polynomials:", \
"ExampleText",
 CellID->28664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"CoefficientList", "[", 
   RowBox[{
    RowBox[{"Array", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Cyclotomic", "[", 
        RowBox[{"#", ",", "x"}], "]"}], "&"}], ",", "40"}], "]"}], ",", "x"}],
    "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26673],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzVlN0NwjAMhF3BIjwgMQ8jdAH2f6OALFkoP057zrknWU2itrl8tnNbX8/1
IiKPLe5bXOWrxWrnXJDx+afu4x2PvLvHs36HCDSnbFFSZx1aP616svv+e66d
pXU+Zj1FcuqNo/qs5OmIIjmResudO3QuzsDJ48nUhfcZzqmngXdouWNwAqxB
PVXmoVxKnlj9hfA0m5PmqdT7s+/QDPdRZD2hOVk2LD5ITlH1VBOznnR/Rp+N
5G62F48nltcM99ERTkxPGTipMt2ZVlk4seun5YnNp8Upg6flN6B7OUPu2D6y
e3oDp0AQxw==
   "], {{0, 0}, {37, 40}}, {0, 1}],
  Frame->Automatic,
  FrameTicks->{None, None},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 194},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->351927798]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20183],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Factor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Roots",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Roots"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootOfUnityQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootOfUnityQ"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21135]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16274],

Cell[TextData[ButtonBox["Algebraic Operations on Polynomials",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicOperationsOnPolynomials"]], "Tutorials",\

 CellID->5433]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->29740],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/CyclotomicPolynomial.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/Polynomials/Cyclotomic/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Cyclotomic"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->378305329],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->50049711]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cyclotomic - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 16.4268620}", "context" -> "System`", 
    "keywords" -> {"cyclotomic polynomial"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Cyclotomic[n, x] gives the n\\[Null]^th cyclotomic polynomial in x. ", 
    "synonyms" -> {}, "title" -> "Cyclotomic", "type" -> "Symbol", "uri" -> 
    "ref/Cyclotomic"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4961, 168, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->89796633]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 91022, 2300}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1983, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2606, 77, 48, 1, 70, "ObjectName",
 CellID->16544],
Cell[2657, 80, 787, 26, 70, "Usage",
 CellID->20236]
}, Open  ]],
Cell[CellGroupData[{
Cell[3481, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3959, 128, 965, 35, 70, "Notes",
 CellID->20012]
}, Closed]],
Cell[CellGroupData[{
Cell[4961, 168, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->89796633],
Cell[CellGroupData[{
Cell[5345, 182, 148, 5, 70, "ExampleSection",
 CellID->169578442],
Cell[CellGroupData[{
Cell[5518, 191, 125, 4, 28, "Input",
 CellID->32134],
Cell[5646, 197, 283, 9, 36, "Output",
 CellID->498636145]
}, Open  ]],
Cell[5944, 209, 189, 7, 70, "ExampleText",
 CellID->674750681],
Cell[CellGroupData[{
Cell[6158, 220, 211, 8, 28, "Input",
 CellID->3671],
Cell[6372, 230, 910, 33, 39, "Output",
 CellID->671876583]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7331, 269, 216, 7, 70, "ExampleSection",
 CellID->19659],
Cell[7550, 278, 202, 7, 70, "ExampleText",
 CellID->42917134],
Cell[CellGroupData[{
Cell[7777, 289, 168, 5, 70, "Input",
 CellID->887377959],
Cell[7948, 296, 284, 10, 50, "Output",
 CellID->191319427]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8281, 312, 223, 7, 70, "ExampleSection",
 CellID->10282],
Cell[CellGroupData[{
Cell[8529, 323, 145, 5, 70, "Input",
 CellID->1848],
Cell[8677, 330, 620, 20, 39, "Output",
 CellID->322352305]
}, Open  ]],
Cell[CellGroupData[{
Cell[9334, 355, 126, 4, 70, "Input",
 CellID->23290],
Cell[9463, 361, 488, 15, 36, "Output",
 CellID->245115692]
}, Open  ]],
Cell[9966, 379, 121, 3, 70, "ExampleDelimiter",
 CellID->14458],
Cell[10090, 384, 88, 1, 70, "ExampleText",
 CellID->32071],
Cell[CellGroupData[{
Cell[10203, 389, 243, 8, 70, "Input",
 CellID->30106],
Cell[10449, 399, 389, 10, 36, "Output",
 CellID->102201175]
}, Open  ]],
Cell[10853, 412, 125, 3, 70, "ExampleDelimiter",
 CellID->138730271],
Cell[10981, 417, 359, 12, 70, "ExampleText",
 CellID->238108908],
Cell[11343, 431, 653, 22, 70, "Input",
 CellID->693938140],
Cell[CellGroupData[{
Cell[12021, 457, 277, 10, 70, "Input",
 CellID->90747633],
Cell[12301, 469, 259, 8, 36, "Output",
 CellID->204184131]
}, Open  ]],
Cell[CellGroupData[{
Cell[12597, 482, 129, 4, 70, "Input",
 CellID->104551757],
Cell[12729, 488, 1315, 45, 54, "Output",
 CellID->395228363]
}, Open  ]],
Cell[14059, 536, 125, 3, 70, "ExampleDelimiter",
 CellID->108690062],
Cell[14187, 541, 71, 1, 70, "ExampleText",
 CellID->402321775],
Cell[CellGroupData[{
Cell[14283, 546, 434, 14, 70, "Input",
 CellID->191646633],
Cell[14720, 562, 11225, 188, 70, "Output",
 Evaluatable->False,
 CellID->135563036]
}, Open  ]],
Cell[25960, 753, 125, 3, 70, "ExampleDelimiter",
 CellID->613196266],
Cell[26088, 758, 213, 8, 70, "ExampleText",
 CellID->93937456],
Cell[CellGroupData[{
Cell[26326, 770, 668, 22, 70, "Input",
 CellID->16162773],
Cell[26997, 794, 7411, 126, 70, "Output",
 Evaluatable->False,
 CellID->125714969]
}, Open  ]],
Cell[34423, 923, 123, 3, 70, "ExampleDelimiter",
 CellID->5553237],
Cell[34549, 928, 112, 3, 70, "ExampleText",
 CellID->10311134],
Cell[CellGroupData[{
Cell[34686, 935, 695, 22, 70, "Input",
 CellID->38958207],
Cell[35384, 959, 5522, 106, 140, "Output",
 CellID->360764094]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40955, 1071, 233, 7, 70, "ExampleSection",
 CellID->11001],
Cell[CellGroupData[{
Cell[41213, 1082, 213, 7, 70, "Input",
 CellID->25434],
Cell[41429, 1091, 337, 13, 72, "Output",
 CellID->1537509]
}, Open  ]],
Cell[41781, 1107, 125, 3, 70, "ExampleDelimiter",
 CellID->429019529],
Cell[41909, 1112, 98, 1, 70, "ExampleText",
 CellID->879150250],
Cell[CellGroupData[{
Cell[42032, 1117, 162, 5, 70, "Input",
 CellID->54993685],
Cell[42197, 1124, 283, 9, 36, "Output",
 CellID->547160533]
}, Open  ]],
Cell[CellGroupData[{
Cell[42517, 1138, 377, 13, 70, "Input",
 CellID->373004704],
Cell[42897, 1153, 1037, 21, 70, "Output",
 Evaluatable->False,
 CellID->304055804]
}, Open  ]],
Cell[43949, 1177, 125, 3, 70, "ExampleDelimiter",
 CellID->429047335],
Cell[44077, 1182, 92, 1, 70, "ExampleText",
 CellID->17677922],
Cell[44172, 1185, 810, 25, 70, "Input",
 CellID->175421337],
Cell[CellGroupData[{
Cell[45007, 1214, 227, 8, 70, "Input",
 CellID->282233393],
Cell[45237, 1224, 614, 20, 39, "Output",
 CellID->242263636]
}, Open  ]],
Cell[CellGroupData[{
Cell[45888, 1249, 235, 8, 70, "Input",
 CellID->67888974],
Cell[46126, 1259, 614, 20, 39, "Output",
 CellID->427548072]
}, Open  ]],
Cell[46755, 1282, 124, 3, 70, "ExampleDelimiter",
 CellID->24334920],
Cell[46882, 1287, 192, 7, 70, "ExampleText",
 CellID->23946580],
Cell[47077, 1296, 511, 17, 70, "Input",
 CellID->44312945],
Cell[CellGroupData[{
Cell[47613, 1317, 226, 8, 70, "Input",
 CellID->33746308],
Cell[47842, 1327, 594, 19, 39, "Output",
 CellID->476510903]
}, Open  ]],
Cell[CellGroupData[{
Cell[48473, 1351, 236, 8, 70, "Input",
 CellID->251879289],
Cell[48712, 1361, 614, 20, 39, "Output",
 CellID->150169069]
}, Open  ]],
Cell[49341, 1384, 125, 3, 70, "ExampleDelimiter",
 CellID->857131980],
Cell[49469, 1389, 82, 1, 70, "ExampleText",
 CellID->46427616],
Cell[49554, 1392, 397, 13, 70, "Input",
 CellID->21632654],
Cell[CellGroupData[{
Cell[49976, 1409, 236, 8, 70, "Input",
 CellID->72038215],
Cell[50215, 1419, 740, 16, 70, "Output",
 Evaluatable->False,
 CellID->605350365]
}, Open  ]],
Cell[50970, 1438, 124, 3, 70, "ExampleDelimiter",
 CellID->10397363],
Cell[51097, 1443, 142, 4, 70, "ExampleText",
 CellID->141202884],
Cell[CellGroupData[{
Cell[51264, 1451, 827, 26, 70, "Input",
 CellID->21486753],
Cell[52094, 1479, 27963, 462, 70, "Output",
 Evaluatable->False,
 CellID->733103189]
}, Open  ]],
Cell[80072, 1944, 122, 3, 70, "ExampleDelimiter",
 CellID->538447],
Cell[80197, 1949, 226, 7, 70, "ExampleText",
 CellID->700628572],
Cell[CellGroupData[{
Cell[80448, 1960, 1077, 34, 70, "Input",
 CellID->464799622],
Cell[81528, 1996, 2094, 38, 70, "Output",
 Evaluatable->False,
 CellID->58059452]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[83671, 2040, 223, 7, 70, "ExampleSection",
 CellID->4075],
Cell[83897, 2049, 127, 4, 70, "ExampleText",
 CellID->8803],
Cell[CellGroupData[{
Cell[84049, 2057, 127, 4, 70, "Input",
 CellID->21439],
Cell[84179, 2063, 1308, 39, 54, "Output",
 CellID->869473371]
}, Open  ]],
Cell[85502, 2105, 121, 3, 70, "ExampleDelimiter",
 CellID->22488],
Cell[85626, 2110, 99, 2, 70, "ExampleText",
 CellID->28664],
Cell[CellGroupData[{
Cell[85750, 2116, 325, 11, 70, "Input",
 CellID->26673],
Cell[86078, 2129, 628, 16, 215, "Output",
 CellID->351927798]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[86767, 2152, 311, 9, 70, "SeeAlsoSection",
 CellID->20183],
Cell[87081, 2163, 694, 26, 70, "SeeAlso",
 CellID->21135]
}, Open  ]],
Cell[CellGroupData[{
Cell[87812, 2194, 314, 9, 70, "TutorialsSection",
 CellID->16274],
Cell[88129, 2205, 179, 4, 70, "Tutorials",
 CellID->5433]
}, Open  ]],
Cell[CellGroupData[{
Cell[88345, 2214, 321, 9, 70, "RelatedLinksSection",
 CellID->29740],
Cell[88669, 2225, 191, 4, 70, "RelatedLinks"],
Cell[88863, 2231, 194, 4, 70, "RelatedLinks"],
Cell[89060, 2237, 388, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[89485, 2255, 319, 9, 70, "MoreAboutSection",
 CellID->378305329],
Cell[89807, 2266, 146, 3, 70, "MoreAbout",
 CellID->50049711]
}, Open  ]],
Cell[89968, 2272, 27, 0, 70, "History"],
Cell[89998, 2274, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

