(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    430048,       8383]
NotebookOptionsPosition[    419508,       8032]
NotebookOutlinePosition[    420908,       8070]
CellTagsIndexPosition[    420821,       8065]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Graphics Primitives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Three\[Hyphen]Dimensional Graphics Primitives\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Circle" :> Documentation`HelpLookup["paclet:ref/Circle"], 
          "Sphere" :> Documentation`HelpLookup["paclet:ref/Sphere"], 
          "GraphicsComplex" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsComplex"], 
          "RevolutionPlot3D" :> 
          Documentation`HelpLookup["paclet:ref/RevolutionPlot3D"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Circle\"\>", 2->"\<\"Sphere\"\>", 
       3->"\<\"GraphicsComplex\"\>", 
       4->"\<\"RevolutionPlot3D\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Objects" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsObjects"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Objects\"\>", 
       2->"\<\"Symbolic Graphics Language\"\>", 
       3->"\<\"New in 6.0: Graphics Primitives & Directives\"\>", 
       4->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Cylinder", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Cylinder",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cylinder"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["z", "TI"], 
             StyleBox["1", "TR"]]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["y", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["z", "TI"], 
             StyleBox["2", "TR"]]}], "}"}]}], "}"}], ",", 
        StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a cylinder of radius ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " around the line from ",
     Cell[BoxData[
      RowBox[{"(", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["z", "TI"], 
         StyleBox["1", "TR"]]}], ")"}]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      RowBox[{"(", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["y", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["z", "TI"], 
         StyleBox["2", "TR"]]}], ")"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Cylinder",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Cylinder"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["z", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["z", "TI"], 
            StyleBox["2", "TR"]]}], "}"}]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a cylinder of radius 1. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->10869]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cylinder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cylinder"]], "InlineFormula"],
 " renders as a cylinder in ",
 Cell[BoxData[
  ButtonBox["Graphics3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics3D"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10165],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cylinder",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cylinder"]], "InlineFormula"],
 " represents the whole filled cylinder, not just the surface. "
}], "Notes",
 CellID->1903],

Cell[TextData[{
 "The ends of the cylinder are disks of radius ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30973],

Cell[TextData[{
 "Colors and other material properties of cylinders can be specified using \
color directives as well as ",
 Cell[BoxData[
  ButtonBox["Specularity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Specularity"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Glow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Glow"]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->27791],

Cell[TextData[{
 "Cylinders can be specified as transparent using ",
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " directives. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->2516],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cylinder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cylinder"], "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cylinder",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cylinder"], "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->6149]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->173860774],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->144956072],

Cell["Cylinder with unit radius:", "ExampleText",
 CellID->20295108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Cylinder", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1", ",", "2"}], "}"}]}], "}"}], ",", "1"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->259402621],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, 0}, {2, 1, 2}}, 1],
  ImageMargins->0.,
  ImageSize->Small,
  ViewAngle->Automatic,
  ViewCenter->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 ImageSize->{184, 196},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->369603596,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->329224730],

Cell["Differently styled cylinders:", "ExampleText",
 CellID->733062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Yellow", ",", 
      RowBox[{"Cylinder", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", 
      RowBox[{"Cylinder", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "Dashed", "]"}], ",", 
      RowBox[{"Cylinder", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Directive", "[", 
        RowBox[{"Thick", ",", "Dashed", ",", "Blue"}], "]"}], "]"}], ",", 
      "Yellow", ",", 
      RowBox[{"Cylinder", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11206405],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 1, 0], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {EdgeForm[Thickness[Large]], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {EdgeForm[Dashing[{Small, Small}]], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 1, 0], EdgeForm[{RGBColor[0, 0, 1], Thickness[Large], 
     Dashing[{Small, Small}]}], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->3638935]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7007],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Cylinder Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->559797865],

Cell["If no radius is specified, it is assumed to be 1:", "ExampleText",
 CellID->538508358],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Cylinder", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "1"}], "}"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->152448279],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, 0}, {0, 0, 1}}],
  ImageMargins->0.,
  ImageSize->Small,
  ViewAngle->Automatic,
  ViewCenter->Automatic,
  ViewPoint->{1.3, -2.4, 2.},
  ViewVertical->{0., 0., 1.}]], "Output",
 ImageSize->{184, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->758255035,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->862699776],

Cell["Cylinders with different radii:", "ExampleText",
 CellID->25794299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Cylinder", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", 
          RowBox[{"-", "3"}]}], "}"}]}], "}"}], ",", "1"}], "]"}], ",", 
    RowBox[{"Cylinder", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"5", ",", "0", ",", "3"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"5", ",", "0", ",", 
          RowBox[{"-", "3"}]}], "}"}]}], "}"}], ",", "3"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->400768792],

Cell[BoxData[
 Graphics3DBox[{CylinderBox[{{0, 0, 3}, {0, 0, -3}}, 1], 
   CylinderBox[{{5, 0, 3}, {5, 0, -3}}, 3]}]], "Output",
 ImageSize->{154, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->61645369,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzFXQt4FeWZHskFwt2IIIouiqKWDglFRVAEhCIiAUURQUW5BBICCbkQICQ5
58ypqHitVhSxCpjE3a4tbnWrVm0rtmrbrXa7XW2Le6nWbV2rq1ZEhPNsv+/7
L/PPN//MOSEJzaMhkzNn5nvfufzv+37/mZQtbagoX7u0oXL50pGX1C1dV1G5
vH7kzJo6+FXeMY7jbIP/t57gwM//Dz/R/9WZTMbJKy8vz9CXcwZ+c6rgewH8
cjQtVcL3XrCUL/8V66yE7/jGwsBvV8ilImO78N05nV5dKt/Tz/rqDfK9A3Ep
X9cEP4yi16+T7x6MSwX6dbmN02idRXKd42LWWSj3M5Rh78WW/47Wvkpu8QT2
ah5bPoXWni+3fVJOa8+T2z6ZvZrPlul1Z45ce2ROa8+WlfSGf4fAoe7D1ipg
yyPoXZfIfeA2C+BdzpCHSr2dpV77OO8fzvG+PcH7p0neP0/2np2afmF6+kcz
0z++NP3qHO/n87zX53u/WuD9+zXeb6/13lri/ddS7+0VXj5sgFdXyJaJKeer
Gf8cy8P9nnyTm9zqpu4cm7q3JHV/SSprGa8Ey/iNUca7q1J/qkz975rUBzVJ
B7fOjzTnQtR0scFFL6xpVKOb2Owmk27yyIp7zShuny5upV/cR3XJT9Yn929M
OLS/GNZOpAqnyAoLVIVnV7mJWjfR2Tqf9+tM8zqv9/7zRu/t5VjnH1Wd/yfr
TH7WlPi8JYGXluUMG041TpZHtlDVOOZGt2Wl29qdlS70frNYVvr75d4f/EpT
otJPN/iVHkq3ErucUVHtpIxxV8NqS65ymxe7LTe6rTnW3DbO+/vx3uMTvCcm
eU9N9p5RNb9k1nxVZM1/hpprk5808JozN7VkbmmmyvnZSncm53zjeqfKz7nc
3XyF23yE9Z9nr/9nc73XrvD+Nab+alv9nqw/c1tz5s7NFgzDCMO5kn06k86H
1ea6TfPcpq4CmSiAeM9fnP7RV9MvzUq/cpkP5NdhIBWp96okkI8VkAMKyGED
SObuJssdTmAZL49HX1yaCKuVuZu6Dc6F3jNTIuG8acIpt8HZlDjQHIJzB8LJ
3LuJzjE+XtFY6ZRmjPF7MmHayGAt6A5YP4yA9TsD1v8oWB8KWI0hWDe3ZLb6
sDLbNmYe2OBY7v4CmyuxDcCliwjbhh6F9zLB+0UQ3n/c4P33Mu8dBq8++ZfG
5H4F7wuA97UQvPsQXmZHIz9yxxO6MfJsHIRLUwld45EDHIsAd0QAfC4K4CLv
d9dxgO8DwHUhgKkQwHuaNEDL2TmEMJ6VMfThxYSxIQbmtdEwbz0imL8EmFfb
YK5Ovb82G8zbN2fu2kwwNyHMBxsz31xvOVcF0tHyaBbj0gxCWp8j2DURYO+J
Bvu0ArvXBHulDewqH+xHAuzGxIHNQbC3BsHev1GAzeyst+AlHe+MkkeW0M8o
c2uz4W3JHe8j2fD+FPBejnj/jeFd4QHeP5l410u8n7e2QrWId0sQ7zcE3g0a
Lz+T6Yg6IyVeujPNpOMrIK+Ph7z0iCA/GQv5jSDkd2MhH0oHIX/dgPzQ+swj
9Yd311qOskB9ijyrSYnNLHNruh31o1bUM9J7L0m/PDv90zLvXwzUv73Oe+sG
w0EQ6g/W+SL9Mx91q4/6TgP1doG64fDuOsuxPpZQnySPNSn6S+hY9wjwx8Z7
/3iet0cDn5b+QQzwJSHgvjtJInCtS7cYckgA32YA31V3uK0mpJDoDk2Ku5dy
v7PK3LWEvC4C+easyL+WC/KLfOQ/Uchf18gjTKNEblPkPvJ7NfLGzMMKefio
C+xD5VGnHOBSOuo9D/8ChP99K/wF3htB627aUjRRIUHPdLAPfwfCzyD8dY5F
HZMCofs6/vLUAP513YV/m4n/K5H4X43CH7C7qSz4gwpT4a8//Oi6TzuqIvAf
K8/9048O/nO9Pecj/u9Z8ZOJZvijDGnQB9klKOLfifgPtK8JOT1K9+h7nkoY
Ly1zK3LEf3U34X9R4w9mRvuW2A2t7wOjHIahUMXoDvgPtq8N5QzkL5z+8vif
LfFXdjv+B0P4vxvGH8rMuKE3jaPhsLgFuauJSVfCX3uovToCf5E8/mO6CX+i
J/CHHGZ26W6oO5A6hwF/b4a/P+Gf0JO4HzZwf8fA/QLh1pGtH/NFBAYW62lV
8aaqfUTh5mkgZQb0WzzvXR9/tcLf0BX8d+SIf2YI/0KO37fepmUzXUycxEWx
hyN/NH6z8/FlycPqHuXhWwYPz07DWPrFYCzNAr2AQzfd3KYIqW8VvUIBFTEe
+vo8BHo8dCeY3XNM7A4zMdVkgqJZFW1aw5iwr+VMWFRwo2bio45KzgUth+4Q
3B2d1XlmrsvGzNcFMyWSmQ6DmVDrIv2zecEULiLe0HbQYowiVLKQiX/pWJ0b
M1xLn9kZZuZHMNOUIzOWpk4onwxmIXbLaHVOFgGNAmJ/R1VfhrmPlRmuMkcH
mKmNYeaKo8BMICXyU5OAp7Q6K6u0VtIyN2a4/jxDMlMVz8zlXWcm1AjEFkpM
JrrCxkxW0xESnV+0r+3HMPe2MsOV2ek5MDOvh5iZFWQmlLSJHMLsPtrsmE2O
G3IUZEnfjNFhCjHCl0dlY2RuBCOrYhm5jzFyToCR57MxYiYzYYMeMGgWge7H
rUKo4VmAAzEfdQqtDHFVgz6uCOxrv6PA1DhkijeDbRG8JcOyWfkIKxOS8krS
5mX83nCYKf5bPNNQ6ZLTwyCkaIubhGuhfRzmUHCEwXnDIQXJCZXRrIQ+Poc1
R8xheJzvNIcROaAfh+g4wGoHw7bAkMVIEB/r7fz1t1ybxONAQLzeTdzsYsoF
l89TF3rgan5xOcpXqBTunqDPQH/A+Kr7/MDqGiNX/ZuyGgzZzJCFdWctZitC
ZHOu7IwOsI2MQ0RnGmTjcrcVkN7iph4oST02HoHsBVqvQFesaT0ItEI9IFi2
bVRd/Mty53bhEXFrTgHB6QhG4401KuzcGgEGN7JWIxeU7R93rHb4eGrndyBb
JrU6lPhdLygud1s3uomtbmp7CTYiwIMADLBfUDcoRigUDv/BBFF8F1IseoD5
fwOWvUiWrTGhERNZ4oKwTbRZgBxZHsSWadwaJjraQATgBzmyyU3e5mIECKie
nuKB8Hr9Shw9/2CyDEIKhsX7kWUQB47K6qOYFsLQwvSyCKZvMZjeniPTZXam
dSBnCWZibKjNUnzWUZUj09SpOEkvwxd5LGC56Uq3ucJtBaS3j8WJDqDpnpni
gfCHysE3Q6kgSsDuHEwSy3drltfFsGzK766yzCaO6WkXexXLst+1wMZyOP6K
N/s2e/J5+5rQCFZgZZm6gCfqZSIEKV7gtqx2W5vdJKD7Zim2MJ6d6v1kdhrE
4L7r8e4mKP7CpPjhBtj1xx2ViuG1PcEwFLMryPBTk/0JEchwqLHEg/VwwBZg
OMIaS4almAebkyPD1F0eLpaJjQ2AHSBXuYlWN3nX2BScM4+fhwHhy5eh1oaT
AeQO1AZXF9zB8FjDUYa9E70fdVQ6neG3uUf5tQTXwQDTHsqEe3fMRooM184v
d9Q0K+MEWCbFiuQuclvWuglAd/fY1COliOK5aWBnsFogF8qDS8tK7ocdFXQ/
n6M6QkeFXmM+T6Avau0LhNPAULLDXXrYixK9ubFL87eGKWo3L3ZbatxE0k0C
oJ2lGL/Ane2VOThggDWE0mAUBm+DMy63KmpByrTV/Lm9wjka3Bqzdp/IhVsj
ew8nrTI1CycgAZ8vXK3h1cKKOJ5b4GAjIAag69yE5ybvGZuCc2TPRA90/Ktl
aCmhQBh9wT363MKet0tu32tfdYTcXt81bs0ZLHHchrPacO4WlRiEPFznuG0Q
3C5xWwBf2k3eW5KCAfqJid4LM7DeXy+U3EJFcA3hzek2zW097O2P7SvD3Nb1
LLfGNLBAr1z3CsO9klDaa8mnWMbA/LHVycXdcal7Jum9wW2pdxOADAC1jcO7
GhQOzhPOAhA2UBpcTAeQ3haid5Om9922lcRuWbZeZPewyybZmez+PMSuJUuv
iWA3Kn0I+uRPLC4jnuE12ruBn2pwEzrD+e4FHtzSoOY3iGG4sEDJgOvBSqAG
GFHhwMKdvq36nbbynmD49lwYnsYZNj98YHS4AslzlozM6paFjxMzXvg5nB/L
8FrNsAggZK6jUjJkeBEWCcMCuEsLw+3Vv29bcfQYZvMHQ7MJRDeVT+iOyWvj
s56wf7M4C8Ew7wEdLxmuBh7mEsMr3NYNOuIRyVkwh0SGWxJ4r4IaYO8gWIjh
13fmyHBT1xlmMzTD8zUCDKseAU/Eo9I0lkUwh6xn7XSC4WE0IgWyB53wgPd8
UYRoiyXDcO/6XDB8BzEM+91Vj/Nk8jrP7zVd59c2H8bS0Qzn6OEpQTH8Brxx
7aFO8+unDoC0ibKdBynb+d5FHhii14yQEvltJYPj81uHXpH4nRjsFXc/v3xe
tcGvP+8k1P1jfQqRBtP0CGewPXZgpjjGVcQzK93wAre5UuU5O0oxzX7ayCbf
XpEyU3Vk9j5k9rDB7HndxWyaM4vph/mhhD02Zl+xMetP36bsDOE7Q/yIkgwx
nLbISjhwyMWxxXNbZyQNrS0U5DxUinOSRFYGYgdqFLmvjNa3ULQOe34IuT2o
uB3fQ9w+EPqUkpgly2ZLBbr5qg8pEjOC7QwTKXs4lfwi2QqCHpmxNq0Fucqy
dfKeINkFtGsox7mTYrLHVUz2y3Dee7Nmdz0YGUzoiN3SrrPbFGT37rGpb3SS
XbPLS5yeyML1cBhpJ5f3LiM8Wzy39TprqA7GOM9Og2HCExEkVAc3Kt6xIG4P
KG5d1RGOmZvTA9xO59yK8/QUv6PJ8nSWQ7a0HiRyYZhGcmIMsZrZxfnNy8av
zBvMLAf41RnkviV+xCtTdNURgqvls/YqsYezc+f3yi7wi/Pnzw/wC8pcjE+n
hptv4ZCXpWRIrpqxgeTEOmLsDNnZtX5G1U8crqfEQaY5lJQ9R0mZCCFhsAWr
7gfocHQVu/sVu6OPJrtiTiKdp2eYE4UYvyxE5ylkU5BfcmzIEPfEvmPbb3Fs
dn6Vn6gyU4c6I9SRgRmFkW9RGOmH6GYbaHct2ETa+qis87C6i2FxBzjLnIsl
e/PBfpvfp2BhZDAwg3ueGTtIii2mWM5V6wTDww1PvPlGt1XkOgDqURGbqUhS
xL2BJN1vtNXCZYMbwxkozsieZpm4HbMnOLFWTGKyto+tJPvzJDf4JLPkAakK
++JI1xbPcrVOHpbRjJItwfTMDCdFqA7FyH6F6rV90rEaoZM3PpnSou5nmUov
xsbpiEBMbosbwYoFSFNWDMFbSMMPaHTu2pdO10xrzDwME8eFtrDc6PEAZ3ny
CKyJmunUWb5oLMI5VMW7f5UpRK6GyqiwIchMijMDlSHKXJxUPDPSo86nWR4i
ZRHzk55USaGfxUYwozq3Q7vODF2RSAjwAf85I+AbPo3HKRaG3eci5CoRWhe5
qDX9ushDdOJkZnoil5axv2ipGG1W2vpxR8aFenzOaMBNzxMaBHCtJlrCZV6E
z5WiK9z+5IgTtIu+imZFyHzCyH9EwiYzzEAO77eQPuyoILyDO4sXy/myQtk/
bLSw2qAX6Bw26bOupukIOiGQ2QtlW29SthXIZ/0eA2J7v11gGxAzh8nERmV8
BTDRfL9+zNlgiUY36mOLPswJ0TU0A0D7cj/zMNM6ljirrsl77asIUVGo2ecj
onvSBIWiyDQPWFOcvo2vH90DuDPRZNfOV+QKL1GuQJlNMG0M9CSwqUZb723r
V64XWikPDokjvibhLQSn+Wp5g1XFKch4BFI+Xqv8pZ6DAd79xzRXC5zaOyJ1
QgStfl6quiqqb5VvIqC688UREJVPVvwXCk2GteySE3Ryq1mphdWmsVjnJlKm
LZ6a1pEDjM48LDOC9HfapFqAM6eiXH2ZJw8WOw35xmFMjNWwhpjX37mKpYrU
zVdhhXDSgGE0xXQtEUEFKt7RqJor5eJ8KGAnCj0naDpWig+KE5ICK7XMG4mp
83hDh4Ha9f3ErnHSsklDzAIHGZVtcvTc9UKVncsSoaiZWB0Oe7o0fu87hiqj
gUz8Ujy9qZi2Euj83UQaXLocZiRrkqIqcd2IzPmQSu8KzLrw6M7CqvB2DWMN
viHHmgYpjSHVl1as6AsmSV8gnBfUJI5ZoQxmVKQI51CevGpkTbCj2bqethp8
Ez96EfX01+O81jxCDZoKmqoo+jDgtFVOZCSceaIeZOcydcygGrFH3rGNqKfI
1B0raaat0GCgTgUb/YWeD7gmbf1VKMjrmaPYkVo/x2oK9TgjVAGoIKph0JMX
hoRybdAky2JqdYoG1awWUs4pU9WI3Tn8M1AR1eSJauj0xG/Ft1GH6rHxviIT
6lTrdu4oMXRaY60mX1Qj9sjn9ofrUU++cIbqbLyZVMWDpUoxUU8SFCJXy7we
kSEYKrdM343UF51+8O8x8APWourxK1RPoqDHkehobhHFylocaLmjpZwvXbWM
V4XheNgdlQ2WlSm3VMkGTj30f+tclC57Z0kxJoSmmvDBTAZGL6Hq5lqr6xNb
3YCM8WkY4eUaWKwphnUQJjgF2xBWXAYbFgjVUC9W3TzjnM9kwp+PLYitEznO
V2cmHxXNcRzkxzNTZWMG24m6Ie5L2oCJDdU5l9XJ09/82DoLM8bz58x0QqZs
evQmvYEtDiGTpNBjdW7XlrK761Sfghos66whuSXHyXo9elPg+v1phi4iOScF
aUBQS+ubtU4+gyQvvs5y+RTg4ea4uYyN5YbCACUktZuWnGaNFPPbr2ujRj73
uFeoRnxxqKzLHz9XUJqix3OpMUzloxWaKebJjHzQURGqaw6ri39uz6wryJuq
DccL69gutIbQP/uWyNo+5XpXGg2wfllroyuzQFcg7z7BkYMGDKMyMa6uwlE+
qUd5UB0vzFAqKKjMuBIXczbzWWWzWWV9Yyrj2Yc61+q1Xxaj/q2UfXRQQiY0
kZiqa69uR6M2aFmrIyUSeIaCqIxfz8XByhYqJ08aAFOZJ1V2B/pIpMqiNWI0
TX0/AMZLXol+ZbNYZaai9RnDd2EeLT7xQL7Nt7JgxaUMoOBEyBJfJYlWguiF
mSXtkqaqkFU0k1U0SO5bVMI/1TpQVuR3NhaTuRbj/w4lTLRQErpNikitakFk
k/IXpqk3q2gGq2hwoCJ+fRKDfWi08kdVPeb3QWHaN6AbpaoWzqP6zV0r+P6n
s/0XB+4ARbIa2m++Hn1gvyjv+qh8qTCgl8lP0DvhpYst+PL19rlq7iv3gy5L
OPVBah95vjfoxzBMZvsYKPch5nBy3yK0KNz9pVo9zvdddapbgJVfIDMC9Uwq
8eyJARnzSfZ+DUPUVsAr+Oe6//oEyz0EaxTP/eGfXuNX0lDLlYS1nSPZUWpG
PEVuMNsav2MMs/CFiyUScR+5NfFUUfVMsmxbOVbW9CVZk/oEuXgO9XGsJj6q
c4S4Pp5jp8mEukBuTTyPfkiWrQ1hW8MaUMgOZ1ujZ+aLxCFma8Vsa/h0vr64
Ffh9X4kU3y7+XsFQyVee5GOwZHWMrKG/3Dc9pcThfz+gl8RdpM97/7UJ8p30
TBzxZHJ2zhQ54RFovHxXCb3rxIxxtzXWKpFrjae1RrBX+WdYx8i16XlV4i8L
8LuUsXymXPsCWls9z5OvNUquNYXW4n/NgDta9SzU6bT2qexV7jdHyG3PpLVP
y4T/GoU6S3Ct2bTW6exVruGGyLXn0tpnsFf5aHusXHs+rT2avcqP2QC59tW0
9pkZ/4yyeZjFtBY9My4w7veWry+h179kvBtH33zJ4DJ6FY9oYbk0445zzF8B
5uwU0g==\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->40505955],

Cell["Cylinders with different directions:", "ExampleText",
 CellID->2637737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Cylinder", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Cylinder", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "3", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->449711130],

Cell[BoxData[
 Graphics3DBox[{CylinderBox[{{0, 0, 0}, {1, 0, 0}}], 
   CylinderBox[{{1, 1, 1}, {2, 3, 1}}]}]], "Output",
 ImageSize->{154, 168},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->741128463,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->488965400],

Cell[TextData[{
 "Short form for a cylinder centered at the origin with a radius 1: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->6149]
}], "ExampleText",
 CellID->205960977],

Cell[CellGroupData[{

Cell["Graphics3D[Cylinder[],Axes->True]", "Input",
 CellLabel->"In[1]:=",
 CellID->285743169],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->34164968,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16614001],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " coordinates: "
}], "ExampleText",
 CellID->20615673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{".5", ",", ".5", ",", ".2"}], "}"}], "]"}], ",", 
       RowBox[{"Scaled", "[", 
        RowBox[{"{", 
         RowBox[{".5", ",", ".5", ",", ".8"}], "}"}], "]"}]}], "}"}], ",", 
     "3"}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "10"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->503772365],

Cell[BoxData[
 Graphics3DBox[
  CylinderBox[{Scaled[{0.5, 0.5, 0.2}], Scaled[{0.5, 0.5, 0.8}]}, 3],
  Axes->True,
  PlotRange->{{0, 10}, {0, 10}, {0, 10}}]], "Output",
 ImageSize->{154, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->221028928,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Cylinder Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->46435114],

Cell["Color directives specify the face colors of cylinders:", "ExampleText",
 CellID->34807083],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"Cylinder", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->169402638],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0, 0], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[0, 1, 0], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[0, 0, 1], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 1, 0], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->317022588]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->557186039],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FaceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 " can be used to specify the styles of the faces and edges:"
}], "ExampleText",
 CellID->95527098],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"FaceForm", "[", "Pink", "]"}], ",", 
    RowBox[{"EdgeForm", "[", 
     RowBox[{"Directive", "[", 
      RowBox[{"Dashed", ",", "Thick", ",", "Blue"}], "]"}], "]"}], ",", 
    RowBox[{"Cylinder", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->267354076],

Cell[BoxData[
 Graphics3DBox[
  {EdgeForm[{RGBColor[0, 0, 1], Thickness[Large], Dashing[{Small, Small}]}], 
   FaceForm[RGBColor[1, 0.5, 0.5]], 
   CylinderBox[{{0, 0, -1}, {0, 0, 1}}]}]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->246724556,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->591166596],

Cell[TextData[{
 "Different properties can be specified for front and back of faces using ",
 Cell[BoxData[
  ButtonBox["FaceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->515512134],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"FaceForm", "[", 
      RowBox[{"Yellow", ",", "Blue"}], "]"}], ",", 
     RowBox[{"Cylinder", "[", "]"}]}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", ".8"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->224326090],

Cell[BoxData[
 Graphics3DBox[
  {FaceForm[RGBColor[1, 1, 0], RGBColor[0, 0, 1]], 
   CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
  PlotRange->{{-1, 1}, {-0.8, 1}, {-1, 1}}]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->471899821,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->493157315],

Cell[TextData[{
 "Cylinder with different specular exponents: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->27791]
}], "ExampleText",
 CellID->358441062],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Orange", ",", 
       RowBox[{"Specularity", "[", 
        RowBox[{"White", ",", "n"}], "]"}], ",", 
       RowBox[{"Cylinder", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Lighting", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\"\<Point\>\"", ",", "White", ",", 
         RowBox[{"Scaled", "[", 
          RowBox[{"{", 
           RowBox[{"2", ",", 
            RowBox[{"-", "1"}], ",", "1.2"}], "}"}], "]"}]}], "}"}], 
       "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "20", ",", "100"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->227665862],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 5], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    Lighting->{{"Point", 
       GrayLevel[1], 
       Scaled[{2, -1, 1.2}]}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 20], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    Lighting->{{"Point", 
       GrayLevel[1], 
       Scaled[{2, -1, 1.2}]}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], Specularity[
      GrayLevel[1], 100], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    Lighting->{{"Point", 
       GrayLevel[1], 
       Scaled[{2, -1, 1.2}]}},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->84312977]
}, Open  ]],

Cell["White cylinder that glows red:", "ExampleText",
 CellID->291906364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Glow", "[", "Red", "]"}], ",", "Black", ",", 
    RowBox[{"Cylinder", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3405511],

Cell[BoxData[
 Graphics3DBox[
  {GrayLevel[0], Glow[
    RGBColor[1, 0, 0]], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->304959150,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzlmWtvEzkUhqfJTJp7Sim0pVACbCm0QMu9QrAsXWn5xI+o2Egg7QoE/H0L
fC7OeF6fIRP4hIiamXh83sf28XVO35x9eTf7/+zL+7dn09efzj6+e//28/Sf
D5/8o/ZKlmX/+u9/W5n//dX/4u+pcy5rz2Yzx5/sKl2yl/5a+IdTTr3w15ZP
tfUuT5/5KwmLiOCvSjhR266Z+0Rz+5TK56X7H7uc/1DZQ0oV83xlXGGb+8qY
fMfmSG3WTZvLbHNHy9oAT7Qgvc3WB0rcbGS9r+xtyG1Deout95Td8feJ75zV
RqobUe8UXjXxz3J/R+sc0tyCbKo1pPq3vWrLP6N7bFmA8iIrd+NRkVFaVf5W
r9rR8oJqSioeAZl+UHeBddtamuRSEfxX0ctfy2i7MDYjBlndCDVWVpsuhVS/
HCVS7w2tdwfKR0ZuMqT8dRfPiZLxBzAKBs0ZPkP0a6rvgX4P9J1Ez2M7G2kb
+qC/CfoueRE8eI4JA63BEAj7BkHypf3nWd1T9QjUt0DdAzXP3qyr6jGob5tq
kZY1x3UIW3CwoA4RpbJeDRZw+oYvxyUrWZOob+4ajLgua0mLnLEC4Ug9tKiV
UcIrabLq4LqBM/BHuTjP8wXcgUvn9dAkdyBNqnsGDVs2MGmYbv0UDUZQDQt9
0zdZPUhbJPQFa5KngzjtlTgCm5OG87Qo7xgk0ycJaVTjmx9XD+t6t7Ea51yn
1gdHjdXY11T2cc2YyMPu0VjF+7p/ZM7i5hSfNOdvYwKO1V9djf4cG2qrz5dT
Y9m5qaaa3/8N1Lj6j39p9bHOq4mhateqaGWW8/rism0K+fxQKZ0G410o1hnm
llL6QOkvRaHTL61rY6D0lqJc07qs/xRlVykXgdJdirKjlEtAWXWZ7OR4ajMp
m+oX6uluRm8g6Sm/OW0j9HhojY6ZmFjUEuPzNJ0+19jcf2fh43/7dzQ5+PUM
LnrP5o6cnh3nXO5Xbe3yTDp5DhLmvjJzYOaNmV3tG5qN8r5ZJbUbkwrtl/jk
e6xUnOMto39WTGprTqVMUT8OfhDajN7B63nV0RNWHKrVid6rb92LOWRBEt4C
5zr6PI96qClt1ZXRJ/FT6b/nIS28BrRcabJblz57CSTsUyVVzvOUjW+Ff8Uc
55JTgXAIM4IavGqkxP6Kyz41CCv+Nymro4c6p1YtJoYa9xds++l83PFnJifJ
KoP83zL89nei7SRaPH1jdKUJw37nA0YS1SkSTohRoD72ogt7B6wNVRKOWXw7
RiKerGJiGbcpgPIKKJxfxKOZ2imMkVGCOcZjH1ZiJcIZL+D8CZw05iKciSvj
j+bsV33sybI155KWZoZ2qGWIJsTvsMYnoBpXfJ/Elb3hU1CEyJwoLtSU8wBU
1KvkGDljJhHpaCcJa6+8O24ZPUBWB7ovUs+RayS6EiKvvEZmEq2UHVmYEhnb
ASZZ06S74sJeK0yJZF52ZSSUphWd2gq1IuYlttoFJs50qvdaVBP538FVV0bR
Y+vzWoPrbHUNcnFGTpS5z9bXjZJxzSPrQ7YOEXkrIkc1OGKrPRiXoe2POPem
v3Z86kRG5so3D25bLw==\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101004100],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Opacity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Opacity"]], "InlineFormula"],
 " specify the face opacity: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->2516]
}], "ExampleText",
 CellID->94273435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", "o", "]"}], ",", 
      RowBox[{"Cylinder", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"o", ",", 
     RowBox[{"{", 
      RowBox[{"0.3", ",", "0.5", ",", "0.9"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36811579],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {Opacity[0.3], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Opacity[0.5], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {Opacity[0.9], CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->110892260]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7727],

Cell["A simple 3D bar chart:", "ExampleText",
 CellID->4437456],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"12", ",", "4"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12188379],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"MapIndexed", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"Last", "[", "#2", "]"}], "-", "1"}], ")"}], "/", "4"}], 
         "]"}], ",", 
        RowBox[{"Cylinder", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Append", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "#2"}], ",", "0"}], "]"}], 
            ",", 
            RowBox[{"Append", "[", 
             RowBox[{
              RowBox[{
               RowBox[{"{", 
                RowBox[{"1", ",", "2"}], "}"}], "#2"}], ",", "#1"}], "]"}]}], 
           "}"}], ",", ".4"}], "]"}]}], "}"}], "&"}], ",", "data", ",", 
     RowBox[{"{", "2", "}"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"False", ",", "False", ",", "True"}], "}"}]}], ",", 
   RowBox[{"Lighting", "\[Rule]", "\"\<Neutral\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->58746949],

Cell[BoxData[
 Graphics3DBox[{{
    {Hue[0], CylinderBox[{{1, 2, 0}, {1, 2, 8.236700949047517}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CylinderBox[{{1, 4, 0}, {1, 4, 4.938723943165784}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CylinderBox[{{1, 6, 0}, {1, 6, 8.667659573658229}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CylinderBox[{{1, 8, 0}, {1, 8, 7.353833273890471}}, 0.4]}}, {
    {Hue[0], CylinderBox[{{2, 2, 0}, {2, 2, 1.5553091095792897`}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CylinderBox[{{2, 4, 0}, {2, 4, 2.4526326364809616`}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CylinderBox[{{2, 6, 0}, {2, 6, 6.8826444294990905`}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CylinderBox[{{2, 8, 0}, {2, 8, 7.067866342758077}}, 0.4]}}, {
    {Hue[0], CylinderBox[{{3, 2, 0}, {3, 2, 6.6695806034605996`}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CylinderBox[{{3, 4, 0}, {3, 4, 2.016035935271997}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CylinderBox[{{3, 6, 0}, {3, 6, 3.993505770544461}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CylinderBox[{{3, 8, 0}, {3, 8, 8.130765183049729}}, 0.4]}}, {
    {Hue[0], CylinderBox[{{4, 2, 0}, {4, 2, 3.2861455086033584`}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CylinderBox[{{4, 4, 0}, {4, 4, 5.022161443547748}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CylinderBox[{{4, 6, 0}, {4, 6, 3.0095092789637867`}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CylinderBox[{{4, 8, 0}, {4, 8, 4.403887098452649}}, 0.4]}}, {
    {Hue[0], CylinderBox[{{5, 2, 0}, {5, 2, 5.3051481692962135`}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CylinderBox[{{5, 4, 0}, {5, 4, 8.01320039104801}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CylinderBox[{{5, 6, 0}, {5, 6, 5.7542130635763575`}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CylinderBox[{{5, 8, 0}, {5, 8, 1.5490749270305175`}}, 0.4]}}, {
    {Hue[0], CylinderBox[{{6, 2, 0}, {6, 2, 8.44814067213161}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CylinderBox[{{6, 4, 0}, {6, 4, 6.261359580637541}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CylinderBox[{{6, 6, 0}, {6, 6, 3.381215350427757}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CylinderBox[{{6, 8, 0}, {6, 8, 9.913391552752547}}, 0.4]}}, {
    {Hue[0], CylinderBox[{{7, 2, 0}, {7, 2, 3.196802932419229}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CylinderBox[{{7, 4, 0}, {7, 4, 8.358762169132994}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CylinderBox[{{7, 6, 0}, {7, 6, 4.983528369208001}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CylinderBox[{{7, 8, 0}, {7, 8, 5.512239692612069}}, 0.4]}}, {
    {Hue[0], CylinderBox[{{8, 2, 0}, {8, 2, 6.048762325806473}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CylinderBox[{{8, 4, 0}, {8, 4, 2.4508969502257436`}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CylinderBox[{{8, 6, 0}, {8, 6, 2.727238153724656}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CylinderBox[{{8, 8, 0}, {8, 8, 3.3786206680830144`}}, 0.4]}}, {
    {Hue[0], CylinderBox[{{9, 2, 0}, {9, 2, 7.8248184205150455`}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CylinderBox[{{9, 4, 0}, {9, 4, 3.1877053006297764`}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CylinderBox[{{9, 6, 0}, {9, 6, 1.1355653923711164`}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CylinderBox[{{9, 8, 0}, {9, 8, 8.252182989462213}}, 0.4]}}, {
    {Hue[0], CylinderBox[{{10, 2, 0}, {10, 2, 4.058893458949588}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CylinderBox[{{10, 4, 0}, {10, 4, 2.749892332020186}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CylinderBox[{{10, 6, 0}, {10, 6, 6.6135893530086465`}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CylinderBox[{{10, 8, 0}, {10, 8, 4.29841315929972}}, 0.4]}}, {
    {Hue[0], CylinderBox[{{11, 2, 0}, {11, 2, 6.532572224536339}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CylinderBox[{{11, 4, 0}, {11, 4, 9.495897168872373}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CylinderBox[{{11, 6, 0}, {11, 6, 4.526019400655274}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CylinderBox[{{11, 8, 0}, {11, 8, 7.947330301142548}}, 0.4]}}, {
    {Hue[0], CylinderBox[{{12, 2, 0}, {12, 2, 6.704671232434177}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], 
     CylinderBox[{{12, 4, 0}, {12, 4, 7.514241772386474}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], 
     CylinderBox[{{12, 6, 0}, {12, 6, 9.187208037017221}}, 0.4]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], 
     CylinderBox[{{12, 8, 0}, {12, 8, 8.239885528168163}}, 0.4]}}},
  Axes->{False, False, True},
  Lighting->"Neutral"]], "Output",
 ImageSize->{184, 170},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->417078709,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20533129],

Cell["Platonic polyhedrons:", "ExampleText",
 CellID->27289629],

Cell[BoxData[
 RowBox[{
  RowBox[{"vc", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"PolyhedronData", "[", 
      RowBox[{"#", ",", "\"\<VertexCoordinates\>\""}], "]"}], "&"}], "/@", 
    RowBox[{"PolyhedronData", "[", "\"\<Platonic\>\"", "]"}]}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69733258],

Cell[BoxData[
 RowBox[{
  RowBox[{"ei", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"PolyhedronData", "[", 
      RowBox[{"#", ",", "\"\<EdgeIndices\>\""}], "]"}], "&"}], "/@", 
    RowBox[{"PolyhedronData", "[", "\"\<Platonic\>\"", "]"}]}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->258341605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "@", 
  RowBox[{"MapThread", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Graphics3D", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Specularity", "[", 
          RowBox[{"White", ",", "30"}], "]"}], ",", 
         RowBox[{"EdgeForm", "[", "]"}], ",", "Orange", ",", 
         RowBox[{"GraphicsComplex", "[", 
          RowBox[{"#1", ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"Sphere", "[", 
                RowBox[{"i", ",", ".2"}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"i", ",", 
                 RowBox[{"Length", "[", "#1", "]"}]}], "}"}]}], "]"}], ",", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"Cylinder", "[", 
                 RowBox[{"#", ",", ".1"}], "]"}], "&"}], "/@", "#2"}], 
              ")"}]}], "}"}]}], "]"}]}], "}"}], ",", 
       RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], "&"}], ",", 
    RowBox[{"{", 
     RowBox[{"vc", ",", "ei"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->250350978],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], EdgeForm[None], Specularity[
      GrayLevel[1], 30], 
     GraphicsComplex3DBox[
      NCache[{{Rational[-1, 2], Rational[-1, 2], Rational[-1, 2]}, {
        Rational[-1, 2], Rational[-1, 2], Rational[1, 2]}, {
        Rational[-1, 2], Rational[1, 2], Rational[-1, 2]}, {
        Rational[-1, 2], Rational[1, 2], Rational[1, 2]}, {
        Rational[1, 2], Rational[-1, 2], Rational[-1, 2]}, {
        Rational[1, 2], Rational[-1, 2], Rational[1, 2]}, {
        Rational[1, 2], Rational[1, 2], Rational[-1, 2]}, {
        Rational[1, 2], Rational[1, 2], Rational[
         1, 2]}}, {{-0.5, -0.5, -0.5}, {-0.5, -0.5, 0.5}, {-0.5, 
       0.5, -0.5}, {-0.5, 0.5, 0.5}, {0.5, -0.5, -0.5}, {0.5, -0.5, 0.5}, {
       0.5, 0.5, -0.5}, {0.5, 0.5, 
       0.5}}], {{SphereBox[1, 0.2], SphereBox[2, 0.2], SphereBox[3, 0.2], 
        SphereBox[4, 0.2], SphereBox[5, 0.2], SphereBox[6, 0.2], 
        SphereBox[7, 0.2], SphereBox[8, 0.2]}, {CylinderBox[{1, 2}, 0.1], 
        CylinderBox[{1, 3}, 0.1], CylinderBox[{1, 5}, 0.1], 
        CylinderBox[{2, 4}, 0.1], CylinderBox[{2, 6}, 0.1], 
        CylinderBox[{3, 4}, 0.1], CylinderBox[{3, 7}, 0.1], 
        CylinderBox[{4, 8}, 0.1], CylinderBox[{5, 6}, 0.1], 
        CylinderBox[{5, 7}, 0.1], CylinderBox[{6, 8}, 0.1], 
        CylinderBox[{7, 8}, 0.1]}}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], "\[InvisibleSpace]", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], EdgeForm[None], Specularity[
      GrayLevel[1], 30], 
     GraphicsComplex3DBox[
      NCache[{{0, 0, (Rational[9, 8] + Rational[3, 8] 5^Rational[1, 2])^
         Rational[1, 2]}, {
        0, 0, Rational[-1, 2] (Rational[3, 2] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {(Rational[1, 8] + 
          Rational[-1, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-3 - 5^Rational[1, 2]), (Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {(Rational[1, 8] + 
          Rational[-1, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (3 + 5^Rational[1, 2]), (Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {(Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-1 - 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {(Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (1 + 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {(Rational[5, 8] + 
          Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {(Rational[5, 8] + 
          Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^
         Rational[
          1, 2]}, {-(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
          Rational[1, 2], 
         Rational[-1, 2], (Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
         Rational[
          1, 2]}, {-(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
          Rational[1, 2], Rational[
         1, 2], (Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
         Rational[1, 2], Rational[-1, 2], 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {(Rational[3, 4] + 
          Rational[1, 3] 5^Rational[1, 2])^Rational[1, 2], Rational[1, 2], 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {-(Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], 0, 
         Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {
        Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], 
         Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], 
         Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[5, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {(Rational[1, 6] (3 + 5^Rational[1, 2]))^
         Rational[1, 2], 
         0, (Rational[5, 8] + Rational[5, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {
        Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {
        Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {
        Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
         Rational[1, 4] (-3 - 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {
        Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
         Rational[1, 4] (3 + 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}}, {{0, 0, 1.4012585384440737`}, {
        0, 0, -1.4012585384440737`}, {
        0.17841104488654497`, -1.3090169943749475`, 0.46708617948135783`}, {
        0.17841104488654497`, 1.3090169943749475`, 0.46708617948135783`}, {
        0.46708617948135783`, -0.8090169943749475, -1.0444364486709836`}, {
        0.46708617948135783`, 0.8090169943749475, -1.0444364486709836`}, {
        1.0444364486709836`, -0.8090169943749475, 0.46708617948135783`}, {
        1.0444364486709836`, 0.8090169943749475, 
        0.46708617948135783`}, {-1.2228474935575286`, -0.5, 
        0.46708617948135783`}, {-1.2228474935575286`, 0.5, 
        0.46708617948135783`}, {
        1.2228474935575286`, -0.5, -0.46708617948135783`}, {
        1.2228474935575286`, 
        0.5, -0.46708617948135783`}, {-0.9341723589627157, 
         0, -1.0444364486709836`}, {-0.46708617948135783`, \
-0.8090169943749475, 1.0444364486709836`}, {-0.46708617948135783`, 
        0.8090169943749475, 1.0444364486709836`}, {
        0.9341723589627157, 0, 
         1.0444364486709836`}, {-1.0444364486709836`, -0.8090169943749475, \
-0.46708617948135783`}, {-1.0444364486709836`, 
        0.8090169943749475, -0.46708617948135783`}, {-0.17841104488654494`, \
-1.3090169943749475`, -0.46708617948135783`}, {-0.17841104488654494`, 
        1.3090169943749475`, -0.46708617948135783`}}], {{SphereBox[1, 0.2], 
        SphereBox[2, 0.2], SphereBox[3, 0.2], SphereBox[4, 0.2], 
        SphereBox[5, 0.2], SphereBox[6, 0.2], SphereBox[7, 0.2], 
        SphereBox[8, 0.2], SphereBox[9, 0.2], SphereBox[10, 0.2], 
        SphereBox[11, 0.2], SphereBox[12, 0.2], SphereBox[13, 0.2], 
        SphereBox[14, 0.2], SphereBox[15, 0.2], SphereBox[16, 0.2], 
        SphereBox[17, 0.2], SphereBox[18, 0.2], SphereBox[19, 0.2], 
        SphereBox[20, 0.2]}, {CylinderBox[{1, 14}, 0.1], 
        CylinderBox[{1, 15}, 0.1], CylinderBox[{1, 16}, 0.1], 
        CylinderBox[{2, 5}, 0.1], CylinderBox[{2, 6}, 0.1], 
        CylinderBox[{2, 13}, 0.1], CylinderBox[{3, 7}, 0.1], 
        CylinderBox[{3, 14}, 0.1], CylinderBox[{3, 19}, 0.1], 
        CylinderBox[{4, 8}, 0.1], CylinderBox[{4, 15}, 0.1], 
        CylinderBox[{4, 20}, 0.1], CylinderBox[{5, 11}, 0.1], 
        CylinderBox[{5, 19}, 0.1], CylinderBox[{6, 12}, 0.1], 
        CylinderBox[{6, 20}, 0.1], CylinderBox[{7, 11}, 0.1], 
        CylinderBox[{7, 16}, 0.1], CylinderBox[{8, 12}, 0.1], 
        CylinderBox[{8, 16}, 0.1], CylinderBox[{9, 10}, 0.1], 
        CylinderBox[{9, 14}, 0.1], CylinderBox[{9, 17}, 0.1], 
        CylinderBox[{10, 15}, 0.1], CylinderBox[{10, 18}, 0.1], 
        CylinderBox[{11, 12}, 0.1], CylinderBox[{13, 17}, 0.1], 
        CylinderBox[{13, 18}, 0.1], CylinderBox[{17, 19}, 0.1], 
        CylinderBox[{18, 20}, 0.1]}}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], "\[InvisibleSpace]", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], EdgeForm[None], Specularity[
      GrayLevel[1], 30], 
     GraphicsComplex3DBox[
      NCache[{{0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
        0, 0, 5 (50 - 10 5^Rational[1, 2])^
          Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
         0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
          Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
         Rational[-1, 2]}, {
        Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
          5^Rational[1, 2]), 
         Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
        Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
          5^Rational[1, 2]), Rational[
         1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
        Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
          5^Rational[1, 2]), Rational[-1, 2], (10 - 2 5^Rational[1, 2])^
         Rational[-1, 2]}, {
        Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
          5^Rational[1, 2]), Rational[1, 2], (10 - 2 5^Rational[1, 2])^
         Rational[-1, 2]}, {
        Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
          5^Rational[1, 2]), 
         Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
          Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
        Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
          5^Rational[1, 2]), 
         Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
          Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
        Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
          5^Rational[1, 2]), 
         Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
          Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
        Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
          5^Rational[1, 2]), 
         Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
          Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
        0, 0, -0.9510565162951536}, {
        0, 0, 0.9510565162951536}, {-0.85065080835204, 
         0, -0.42532540417601994`}, {
        0.85065080835204, 0, 0.42532540417601994`}, {
        0.6881909602355868, -0.5, -0.42532540417601994`}, {0.6881909602355868,
         0.5, -0.42532540417601994`}, {-0.6881909602355868, -0.5, 
        0.42532540417601994`}, {-0.6881909602355868, 0.5, 
        0.42532540417601994`}, {-0.2628655560595668, -0.8090169943749475, \
-0.42532540417601994`}, {-0.2628655560595668, 
        0.8090169943749475, -0.42532540417601994`}, {
        0.2628655560595668, -0.8090169943749475, 0.42532540417601994`}, {
        0.2628655560595668, 0.8090169943749475, 0.42532540417601994`}}], {{
        SphereBox[1, 0.2], SphereBox[2, 0.2], SphereBox[3, 0.2], 
        SphereBox[4, 0.2], SphereBox[5, 0.2], SphereBox[6, 0.2], 
        SphereBox[7, 0.2], SphereBox[8, 0.2], SphereBox[9, 0.2], 
        SphereBox[10, 0.2], SphereBox[11, 0.2], SphereBox[12, 0.2]}, {
        CylinderBox[{1, 3}, 0.1], CylinderBox[{1, 5}, 0.1], 
        CylinderBox[{1, 6}, 0.1], CylinderBox[{1, 9}, 0.1], 
        CylinderBox[{1, 10}, 0.1], CylinderBox[{2, 4}, 0.1], 
        CylinderBox[{2, 7}, 0.1], CylinderBox[{2, 8}, 0.1], 
        CylinderBox[{2, 11}, 0.1], CylinderBox[{2, 12}, 0.1], 
        CylinderBox[{3, 7}, 0.1], CylinderBox[{3, 8}, 0.1], 
        CylinderBox[{3, 9}, 0.1], CylinderBox[{3, 10}, 0.1], 
        CylinderBox[{4, 5}, 0.1], CylinderBox[{4, 6}, 0.1], 
        CylinderBox[{4, 11}, 0.1], CylinderBox[{4, 12}, 0.1], 
        CylinderBox[{5, 6}, 0.1], CylinderBox[{5, 9}, 0.1], 
        CylinderBox[{5, 11}, 0.1], CylinderBox[{6, 10}, 0.1], 
        CylinderBox[{6, 12}, 0.1], CylinderBox[{7, 8}, 0.1], 
        CylinderBox[{7, 9}, 0.1], CylinderBox[{7, 11}, 0.1], 
        CylinderBox[{8, 10}, 0.1], CylinderBox[{8, 12}, 0.1], 
        CylinderBox[{9, 11}, 0.1], CylinderBox[{10, 12}, 0.1]}}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], "\[InvisibleSpace]", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], EdgeForm[None], Specularity[
      GrayLevel[1], 30], 
     GraphicsComplex3DBox[
      NCache[{{Rational[-1, 2], Rational[-1, 2], 0}, {
        Rational[-1, 2], Rational[1, 2], 0}, {0, 0, -2^Rational[-1, 2]}, {
        0, 0, 2^Rational[-1, 2]}, {Rational[1, 2], Rational[-1, 2], 0}, {
        Rational[1, 2], Rational[1, 2], 0}}, {{-0.5, -0.5, 0}, {-0.5, 0.5, 
         0}, {0, 0, -0.7071067811865475}, {0, 0, 0.7071067811865475}, {
        0.5, -0.5, 0}, {0.5, 0.5, 0}}], {{SphereBox[1, 0.2], 
        SphereBox[2, 0.2], SphereBox[3, 0.2], SphereBox[4, 0.2], 
        SphereBox[5, 0.2], SphereBox[6, 0.2]}, {CylinderBox[{1, 2}, 0.1], 
        CylinderBox[{1, 3}, 0.1], CylinderBox[{1, 4}, 0.1], 
        CylinderBox[{1, 5}, 0.1], CylinderBox[{2, 3}, 0.1], 
        CylinderBox[{2, 4}, 0.1], CylinderBox[{2, 6}, 0.1], 
        CylinderBox[{3, 5}, 0.1], CylinderBox[{3, 6}, 0.1], 
        CylinderBox[{4, 5}, 0.1], CylinderBox[{4, 6}, 0.1], 
        CylinderBox[{5, 6}, 0.1]}}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], "\[InvisibleSpace]", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0], EdgeForm[None], Specularity[
      GrayLevel[1], 30], 
     GraphicsComplex3DBox[
      NCache[{{0, 0, Rational[2, 3]^Rational[1, 2] + 
         Rational[-1, 2] 6^Rational[-1, 2]}, {
        Rational[-1, 2] 3^Rational[-1, 2], Rational[-1, 2], Rational[-1, 2] 
         6^Rational[-1, 2]}, {
        Rational[-1, 2] 3^Rational[-1, 2], Rational[1, 2], Rational[-1, 2] 
         6^Rational[-1, 2]}, {
        3^Rational[-1, 2], 0, Rational[-1, 2] 6^Rational[-1, 2]}}, {{
        0, 0, 0.6123724356957945}, {-0.2886751345948129, -0.5, \
-0.20412414523193154`}, {-0.2886751345948129, 0.5, -0.20412414523193154`}, {
        0.5773502691896258, 0, -0.20412414523193154`}}], {{SphereBox[1, 0.2], 
        SphereBox[2, 0.2], SphereBox[3, 0.2], SphereBox[4, 0.2]}, {
        CylinderBox[{1, 2}, 0.1], CylinderBox[{1, 3}, 0.1], 
        CylinderBox[{1, 4}, 0.1], CylinderBox[{2, 3}, 0.1], 
        CylinderBox[{2, 4}, 0.1], CylinderBox[{3, 4}, 0.1]}}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}],
  Row[{
    Graphics3D[{
      Specularity[
       GrayLevel[1], 30], 
      EdgeForm[], 
      RGBColor[1, 0.5, 0], 
      GraphicsComplex[{{
         Rational[-1, 2], 
         Rational[-1, 2], 
         Rational[-1, 2]}, {
         Rational[-1, 2], 
         Rational[-1, 2], 
         Rational[1, 2]}, {
         Rational[-1, 2], 
         Rational[1, 2], 
         Rational[-1, 2]}, {
         Rational[-1, 2], 
         Rational[1, 2], 
         Rational[1, 2]}, {
         Rational[1, 2], 
         Rational[-1, 2], 
         Rational[-1, 2]}, {
         Rational[1, 2], 
         Rational[-1, 2], 
         Rational[1, 2]}, {
         Rational[1, 2], 
         Rational[1, 2], 
         Rational[-1, 2]}, {
         Rational[1, 2], 
         Rational[1, 2], 
         Rational[1, 2]}}, {{
         Sphere[1, 0.2], 
         Sphere[2, 0.2], 
         Sphere[3, 0.2], 
         Sphere[4, 0.2], 
         Sphere[5, 0.2], 
         Sphere[6, 0.2], 
         Sphere[7, 0.2], 
         Sphere[8, 0.2]}, {
         Cylinder[{1, 2}, 0.1], 
         Cylinder[{1, 3}, 0.1], 
         Cylinder[{1, 5}, 0.1], 
         Cylinder[{2, 4}, 0.1], 
         Cylinder[{2, 6}, 0.1], 
         Cylinder[{3, 4}, 0.1], 
         Cylinder[{3, 7}, 0.1], 
         Cylinder[{4, 8}, 0.1], 
         Cylinder[{5, 6}, 0.1], 
         Cylinder[{5, 7}, 0.1], 
         Cylinder[{6, 8}, 0.1], 
         Cylinder[{7, 8}, 0.1]}}]}, Boxed -> False], 
    Graphics3D[{
      Specularity[
       GrayLevel[1], 30], 
      EdgeForm[], 
      RGBColor[1, 0.5, 0], 
      GraphicsComplex[{{
        0, 0, (Rational[9, 8] + Rational[3, 8] 5^Rational[1, 2])^
         Rational[1, 2]}, {
        0, 0, Rational[-1, 2] (Rational[3, 2] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {(Rational[1, 8] + 
          Rational[-1, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-3 - 5^Rational[1, 2]), (Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {(Rational[1, 8] + 
          Rational[-1, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (3 + 5^Rational[1, 2]), (Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {(Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-1 - 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {(Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (1 + 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {(Rational[5, 8] + 
          Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {(Rational[5, 8] + 
          Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[1, 8] + 
          Rational[1, 24] 5^Rational[1, 2])^
         Rational[
          1, 2]}, {-(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
          Rational[1, 2], 
         Rational[-1, 2], (Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
         Rational[
          1, 2]}, {-(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
          Rational[1, 2], 
         Rational[1, 2], (Rational[1, 8] + Rational[1, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {(Rational[3, 4] + Rational[1, 3] 5^Rational[1, 2])^
         Rational[1, 2], 
         Rational[-1, 2], 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {(Rational[3, 4] + 
          Rational[1, 3] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 2], 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {-(Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], 0, 
         Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {
        Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], 
         Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[5, 24] 5^Rational[1, 2])^Rational[1, 2]}, {
        Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], 
         Rational[1, 4] (1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[5, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {(Rational[1, 6] (3 + 5^Rational[1, 2]))^
         Rational[1, 2], 
         0, (Rational[5, 8] + Rational[5, 24] 5^Rational[1, 2])^
         Rational[1, 2]}, {
        Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], Rational[1, 4] (-1 - 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {
        Rational[-1, 2] (Rational[5, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {
         Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
         Rational[1, 4] (-3 - 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}, {
         Root[1 - 36 #^2 + 144 #^4& , 2, 0], 
         Rational[1, 4] (3 + 5^Rational[1, 2]), 
         Rational[-1, 2] (Rational[1, 6] (3 + 5^Rational[1, 2]))^
          Rational[1, 2]}}, {{
         Sphere[1, 0.2], 
         Sphere[2, 0.2], 
         Sphere[3, 0.2], 
         Sphere[4, 0.2], 
         Sphere[5, 0.2], 
         Sphere[6, 0.2], 
         Sphere[7, 0.2], 
         Sphere[8, 0.2], 
         Sphere[9, 0.2], 
         Sphere[10, 0.2], 
         Sphere[11, 0.2], 
         Sphere[12, 0.2], 
         Sphere[13, 0.2], 
         Sphere[14, 0.2], 
         Sphere[15, 0.2], 
         Sphere[16, 0.2], 
         Sphere[17, 0.2], 
         Sphere[18, 0.2], 
         Sphere[19, 0.2], 
         Sphere[20, 0.2]}, {
         Cylinder[{1, 14}, 0.1], 
         Cylinder[{1, 15}, 0.1], 
         Cylinder[{1, 16}, 0.1], 
         Cylinder[{2, 5}, 0.1], 
         Cylinder[{2, 6}, 0.1], 
         Cylinder[{2, 13}, 0.1], 
         Cylinder[{3, 7}, 0.1], 
         Cylinder[{3, 14}, 0.1], 
         Cylinder[{3, 19}, 0.1], 
         Cylinder[{4, 8}, 0.1], 
         Cylinder[{4, 15}, 0.1], 
         Cylinder[{4, 20}, 0.1], 
         Cylinder[{5, 11}, 0.1], 
         Cylinder[{5, 19}, 0.1], 
         Cylinder[{6, 12}, 0.1], 
         Cylinder[{6, 20}, 0.1], 
         Cylinder[{7, 11}, 0.1], 
         Cylinder[{7, 16}, 0.1], 
         Cylinder[{8, 12}, 0.1], 
         Cylinder[{8, 16}, 0.1], 
         Cylinder[{9, 10}, 0.1], 
         Cylinder[{9, 14}, 0.1], 
         Cylinder[{9, 17}, 0.1], 
         Cylinder[{10, 15}, 0.1], 
         Cylinder[{10, 18}, 0.1], 
         Cylinder[{11, 12}, 0.1], 
         Cylinder[{13, 17}, 0.1], 
         Cylinder[{13, 18}, 0.1], 
         Cylinder[{17, 19}, 0.1], 
         Cylinder[{18, 20}, 0.1]}}]}, Boxed -> False], 
    Graphics3D[{
      Specularity[
       GrayLevel[1], 30], 
      EdgeForm[], 
      RGBColor[1, 0.5, 0], 
      GraphicsComplex[{{
        0, 0, (-5) (50 - 10 5^Rational[1, 2])^Rational[-1, 2]}, {
        0, 0, 5 (50 - 10 5^Rational[1, 2])^
          Rational[-1, 2]}, {-(2/(5 - 5^Rational[1, 2]))^Rational[1, 2], 
         0, -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {(2/(5 - 5^
          Rational[1, 2]))^Rational[1, 2], 0, (10 - 2 5^Rational[1, 2])^
         Rational[-1, 2]}, {
        Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
          5^Rational[1, 2]), 
         Rational[-1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
        Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
          5^Rational[1, 2]), 
         Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
        Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
          5^Rational[1, 2]), 
         Rational[-1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
        Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (1 + 
          5^Rational[1, 2]), 
         Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
        Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
          5^Rational[1, 2]), 
         Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
          Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
        Rational[-1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
          5^Rational[1, 2]), 
         Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
          Rational[1, 2], -(10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
        Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
          5^Rational[1, 2]), 
         Rational[-1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
          Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}, {
        Rational[1, 2] (10 - 2 5^Rational[1, 2])^Rational[-1, 2] (-1 + 
          5^Rational[1, 2]), 
         Rational[1, 2] ((5 - 5^Rational[1, 2])^(-1) (5 + 5^Rational[1, 2]))^
          Rational[1, 2], (10 - 2 5^Rational[1, 2])^Rational[-1, 2]}}, {{
         Sphere[1, 0.2], 
         Sphere[2, 0.2], 
         Sphere[3, 0.2], 
         Sphere[4, 0.2], 
         Sphere[5, 0.2], 
         Sphere[6, 0.2], 
         Sphere[7, 0.2], 
         Sphere[8, 0.2], 
         Sphere[9, 0.2], 
         Sphere[10, 0.2], 
         Sphere[11, 0.2], 
         Sphere[12, 0.2]}, {
         Cylinder[{1, 3}, 0.1], 
         Cylinder[{1, 5}, 0.1], 
         Cylinder[{1, 6}, 0.1], 
         Cylinder[{1, 9}, 0.1], 
         Cylinder[{1, 10}, 0.1], 
         Cylinder[{2, 4}, 0.1], 
         Cylinder[{2, 7}, 0.1], 
         Cylinder[{2, 8}, 0.1], 
         Cylinder[{2, 11}, 0.1], 
         Cylinder[{2, 12}, 0.1], 
         Cylinder[{3, 7}, 0.1], 
         Cylinder[{3, 8}, 0.1], 
         Cylinder[{3, 9}, 0.1], 
         Cylinder[{3, 10}, 0.1], 
         Cylinder[{4, 5}, 0.1], 
         Cylinder[{4, 6}, 0.1], 
         Cylinder[{4, 11}, 0.1], 
         Cylinder[{4, 12}, 0.1], 
         Cylinder[{5, 6}, 0.1], 
         Cylinder[{5, 9}, 0.1], 
         Cylinder[{5, 11}, 0.1], 
         Cylinder[{6, 10}, 0.1], 
         Cylinder[{6, 12}, 0.1], 
         Cylinder[{7, 8}, 0.1], 
         Cylinder[{7, 9}, 0.1], 
         Cylinder[{7, 11}, 0.1], 
         Cylinder[{8, 10}, 0.1], 
         Cylinder[{8, 12}, 0.1], 
         Cylinder[{9, 11}, 0.1], 
         Cylinder[{10, 12}, 0.1]}}]}, Boxed -> False], 
    Graphics3D[{
      Specularity[
       GrayLevel[1], 30], 
      EdgeForm[], 
      RGBColor[1, 0.5, 0], 
      GraphicsComplex[{{
         Rational[-1, 2], 
         Rational[-1, 2], 0}, {
         Rational[-1, 2], 
         Rational[1, 2], 0}, {0, 0, -2^Rational[-1, 2]}, {
        0, 0, 2^Rational[-1, 2]}, {
         Rational[1, 2], 
         Rational[-1, 2], 0}, {
         Rational[1, 2], 
         Rational[1, 2], 0}}, {{
         Sphere[1, 0.2], 
         Sphere[2, 0.2], 
         Sphere[3, 0.2], 
         Sphere[4, 0.2], 
         Sphere[5, 0.2], 
         Sphere[6, 0.2]}, {
         Cylinder[{1, 2}, 0.1], 
         Cylinder[{1, 3}, 0.1], 
         Cylinder[{1, 4}, 0.1], 
         Cylinder[{1, 5}, 0.1], 
         Cylinder[{2, 3}, 0.1], 
         Cylinder[{2, 4}, 0.1], 
         Cylinder[{2, 6}, 0.1], 
         Cylinder[{3, 5}, 0.1], 
         Cylinder[{3, 6}, 0.1], 
         Cylinder[{4, 5}, 0.1], 
         Cylinder[{4, 6}, 0.1], 
         Cylinder[{5, 6}, 0.1]}}]}, Boxed -> False], 
    Graphics3D[{
      Specularity[
       GrayLevel[1], 30], 
      EdgeForm[], 
      RGBColor[1, 0.5, 0], 
      GraphicsComplex[{{
        0, 0, Rational[2, 3]^Rational[1, 2] + 
         Rational[-1, 2] 6^Rational[-1, 2]}, {
        Rational[-1, 2] 3^Rational[-1, 2], 
         Rational[-1, 2], Rational[-1, 2] 6^Rational[-1, 2]}, {
        Rational[-1, 2] 3^Rational[-1, 2], 
         Rational[1, 2], Rational[-1, 2] 6^Rational[-1, 2]}, {
        3^Rational[-1, 2], 0, Rational[-1, 2] 6^Rational[-1, 2]}}, {{
         Sphere[1, 0.2], 
         Sphere[2, 0.2], 
         Sphere[3, 0.2], 
         Sphere[4, 0.2]}, {
         Cylinder[{1, 2}, 0.1], 
         Cylinder[{1, 3}, 0.1], 
         Cylinder[{1, 4}, 0.1], 
         Cylinder[{2, 3}, 0.1], 
         Cylinder[{2, 4}, 0.1], 
         Cylinder[{3, 4}, 0.1]}}]}, Boxed -> False]}]]], "Output",
 ImageSize->{504, 126},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[3]=",
 CellID->186264372]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->533025963],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Sphere",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sphere"]], "InlineFormula"],
 " to render nodes in a ",
 Cell[BoxData[
  ButtonBox["GraphPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GraphPlot3D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->432756382],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GraphPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"i", "\[Rule]", 
      RowBox[{"Mod", "[", 
       RowBox[{
        RowBox[{"i", "^", "2"}], ",", "50"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "0", ",", "50"}], "}"}]}], "]"}], ",", 
   RowBox[{"SelfLoopStyle", "\[Rule]", "None"}], ",", 
   RowBox[{"EdgeRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Cylinder", "[", 
        RowBox[{"#1", ",", "0.1"}], "]"}], "}"}], "&"}], ")"}]}], ",", 
   RowBox[{"VertexRenderingFunction", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Sphere", "[", 
        RowBox[{"#", ",", "0.3"}], "]"}], "}"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->35075088],

Cell[BoxData[
 Graphics3DBox[
  TagBox[{{
     CylinderBox[{{1.1721484307569534`, -10.725600641115502`, 
      2.108959357747445}, {1.5639894602669575`, -10.298603871695837`, 
      1.523048039966398}}, 0.1], 
     CylinderBox[{{1.5639894602669575`, -10.298603871695837`, 
      1.523048039966398}, {2.2838591323395194`, -9.399509914585488, 
      1.1651916493196308`}}, 0.1], 
     CylinderBox[{{0.6483534787183691, -4.2197462623975905`, 
      0.7439528378651883}, {1.3532298807936507`, -3.8125627112808753`, 
      0.6259897484825266}}, 0.1], 
     CylinderBox[{{1.3532298807936507`, -3.8125627112808753`, 
      0.6259897484825266}, {2.3875664216193426`, -3.3243976210922286`, 
      1.0104155796565384`}}, 0.1], 
     CylinderBox[{{2.2838591323395194`, -9.399509914585488, 
      1.1651916493196308`}, {3.345256361380913, -9.281973713350302, 
      0.949554530220349}}, 0.1], 
     CylinderBox[{{7.063805839579562, -9.49268738990686, 0.}, {
      7.770912620718489, -10.199794171141027`, 0.}}, 0.1], 
     CylinderBox[{{3.345256361380913, -9.281973713350302, 
      0.949554530220349}, {3.2283362618049316`, -8.219921348336792, 
      1.1636053964577961`}}, 0.1], 
     CylinderBox[{{3.2283362618049316`, -8.219921348336792, 
      1.1636053964577961`}, {2.1669391733197663`, -8.338749606854543, 
      0.9448114468877651}}, 0.1], 
     CylinderBox[{{7.770912620548202, -8.147581751024529, 0.}, {
      7.770912620682892, -7.1475817510245285`, 0.}}, 0.1], 
     CylinderBox[{{7.770912620682892, -7.1475817510245285`, 0.}, {
      6.904887216935867, -6.647581750959726, 0.}}, 0.1], 
     CylinderBox[{{0.6483534787183691, -7.094493788375964, 
      0.7300713125464304}, {1.266732340127061, -7.619729005002492, 
      0.5850752453833055}}, 0.1], 
     CylinderBox[{{1.266732340127061, -7.619729005002492, 
      0.5850752453833055}, {2.1669391733197663`, -8.338749606854543, 
      0.9448114468877651}}, 0.1], 
     CylinderBox[{{2.3875664216193426`, -3.3243976210922286`, 
      1.0104155796565384`}, {2.7487337392470628`, -2.3233646124846663`, 
      1.243831944116861}}, 0.1], 
     CylinderBox[{{7.1831273685502355`, -0.6483534787183693, 0.}, {
      7.770912620791858, -1.4573704731302621`, 0.}}, 0.1], 
     CylinderBox[{{2.7487337392470628`, -2.3233646124846663`, 
      1.243831944116861}, {3.74719383210438, -2.685840432377382, 
      1.001138983650924}}, 0.1], 
     CylinderBox[{{3.74719383210438, -2.685840432377382, 1.001138983650924}, {
      3.387645521160266, -3.684779950783155, 1.2447467088530106`}}, 0.1], 
     CylinderBox[{{4.549188208941657, -6.770652932907409, 
      1.3923625979386745`}, {3.950717276405192, -7.320962413617819, 
      1.5183640463158414`}}, 0.1], 
     CylinderBox[{{3.950717276405192, -7.320962413617819, 
      1.5183640463158414`}, {3.2283362618049316`, -8.219921348336792, 
      1.1636053964577961`}}, 0.1], 
     CylinderBox[{{2.2255457207013944`, -0.6483534787183691, 
      2.1504421989560116`}, {2.264160197264273, -1.2878752583523871`, 
      1.6324827933232195`}}, 0.1], 
     CylinderBox[{{2.264160197264273, -1.2878752583523871`, 
      1.6324827933232195`}, {2.7487337392470628`, -2.3233646124846663`, 
      1.243831944116861}}, 0.1], 
     CylinderBox[{{2.1669391733197663`, -8.338749606854543, 
      0.9448114468877651}, {2.2838591323395194`, -9.399509914585488, 
      1.1651916493196308`}}, 0.1], 
     CylinderBox[{{7.063805839452575, -10.906900952248208`, 0.}, {
      7.770912620718489, -10.199794171141027`, 0.}}, 0.1], 
     CylinderBox[{{5.523149147029444, -1.8662039256725445`, 
      0.721505837589105}, {4.781100675086404, -2.203838265930645, 
      0.6049935385663198}}, 0.1], 
     CylinderBox[{{4.781100675086404, -2.203838265930645, 
      0.6049935385663198}, {3.74719383210438, -2.685840432377382, 
      1.001138983650924}}, 0.1], 
     CylinderBox[{{6.904887216935867, -3.8024761120125934`, 0.}, {
      7.770912620682892, -4.302476112077396, 0.}}, 0.1], 
     CylinderBox[{{7.770912620682892, -4.302476112077396, 0.}, {
      7.770912620548202, -5.302476112077396, 0.}}, 0.1], 
     CylinderBox[{{6.819856104466182, -1.7663874674112716`, 0.}, {
      7.770912620791858, -1.4573704731302621`, 0.}}, 0.1], 
     CylinderBox[{{3.387645521160266, -3.684779950783155, 
      1.2447467088530106`}, {2.3875664216193426`, -3.3243976210922286`, 
      1.0104155796565384`}}, 0.1], 
     CylinderBox[{{4.880146823665609, -10.506117514497866`, 
      0.7482364660203219}, {4.245618735140671, -10.003207631020977`, 
      0.5976470465028314}}, 0.1], 
     CylinderBox[{{4.245618735140671, -10.003207631020977`, 
      0.5976470465028314}, {3.345256361380913, -9.281973713350302, 
      0.949554530220349}}, 0.1], 
     CylinderBox[{{4.179205544430305, -5.473945975470671, 
      1.5158986108498584`}, {3.8739031269176722`, -4.718305400407193, 
      1.6341896150392876`}}, 0.1], 
     CylinderBox[{{3.8739031269176722`, -4.718305400407193, 
      1.6341896150392876`}, {3.387645521160266, -3.684779950783155, 
      1.2447467088530106`}}, 0.1], 
     CylinderBox[{{4.154199961738533, -5.209423405100645, 
      2.233310496618497}, {3.8739031269176722`, -4.718305400407193, 
      1.6341896150392876`}}, 0.1], 
     CylinderBox[{{4.696458634260625, -10.370239357036512`, 
      0.01374291795333904}, {4.245618735140671, -10.003207631020977`, 
      0.5976470465028314}}, 0.1], 
     CylinderBox[{{7.770912620657169, -2.457370473130262, 0.}, {
      7.770912620791858, -1.4573704731302621`, 0.}}, 0.1], 
     CylinderBox[{{8.636938024564607, -3.8024761122458828`, 0.}, {
      7.770912620682892, -4.302476112077396, 0.}}, 0.1], 
     CylinderBox[{{5.285016025937254, -1.9623498402928048`, 0.}, {
      4.781100675086404, -2.203838265930645, 0.6049935385663198}}, 0.1], 
     CylinderBox[{{8.478019401793924, -10.906900952438688`, 0.}, {
      7.770912620718489, -10.199794171141027`, 0.}}, 0.1], 
     CylinderBox[{{1.7164837218704114`, -0.6732162596522508, 
      1.5962356716757307`}, {2.264160197264273, -1.2878752583523871`, 
      1.6324827933232195`}}, 0.1], 
     CylinderBox[{{4.225546571367519, -6.7877592537986216`, 
      2.082044311446766}, {3.950717276405192, -7.320962413617819, 
      1.5183640463158414`}}, 0.1], 
     CylinderBox[{{8.721969137034291, -1.7663874676674665`, 0.}, {
      7.770912620791858, -1.4573704731302621`, 0.}}, 0.1], 
     CylinderBox[{{0.7987328948235619, -7.2771651354098985`, 0.}, {
      1.266732340127061, -7.619729005002492, 0.5850752453833055}}, 0.1], 
     CylinderBox[{{8.636938024564607, -6.647581751193016, 0.}, {
      7.770912620682892, -7.1475817510245285`, 0.}}, 0.1], 
     CylinderBox[{{8.478019402047897, -9.492687390097341, 0.}, {
      7.770912620718489, -10.199794171141027`, 0.}}, 0.1], 
     CylinderBox[{{0.8115797774473554, -3.99445546379731, 
      0.03306167449385167}, {1.3532298807936507`, -3.8125627112808753`, 
      0.6259897484825266}}, 0.1], 
     CylinderBox[{{1.087798418663198, -10.95529963388428, 
      1.3779910738079852`}, {1.5639894602669575`, -10.298603871695837`, 
      1.523048039966398}}, 0.1], 
     CylinderBox[{{8.358697873251412, -0.648353478876706, 0.}, {
      7.770912620791858, -1.4573704731302621`, 0.}}, 0.1]}, {
     SphereBox[{7.770912620791858, -1.4573704731302621`, 0.}, 0.3], 
     SphereBox[{6.904887216935867, -6.647581750959726, 0.}, 0.3], 
     SphereBox[{1.1721484307569534`, -10.725600641115502`, 2.108959357747445},
       0.3], SphereBox[{1.5639894602669575`, -10.298603871695837`, 
      1.523048039966398}, 0.3], 
     SphereBox[{0.6483534787183691, -4.2197462623975905`, 0.7439528378651883},
       0.3], SphereBox[{1.3532298807936507`, -3.8125627112808753`, 
      0.6259897484825266}, 0.3], 
     SphereBox[{2.2838591323395194`, -9.399509914585488, 1.1651916493196308`},
       0.3], SphereBox[{7.063805839579562, -9.49268738990686, 0.}, 0.3], 
     SphereBox[{7.770912620718489, -10.199794171141027`, 0.}, 0.3], 
     SphereBox[{3.345256361380913, -9.281973713350302, 0.949554530220349}, 
      0.3], SphereBox[{3.2283362618049316`, -8.219921348336792, 
      1.1636053964577961`}, 0.3], 
     SphereBox[{7.770912620548202, -8.147581751024529, 0.}, 0.3], 
     SphereBox[{7.770912620682892, -7.1475817510245285`, 0.}, 0.3], 
     SphereBox[{0.6483534787183691, -7.094493788375964, 0.7300713125464304}, 
      0.3], SphereBox[{1.266732340127061, -7.619729005002492, 
      0.5850752453833055}, 0.3], 
     SphereBox[{2.3875664216193426`, -3.3243976210922286`, 
      1.0104155796565384`}, 0.3], 
     SphereBox[{7.1831273685502355`, -0.6483534787183693, 0.}, 0.3], 
     SphereBox[{2.7487337392470628`, -2.3233646124846663`, 1.243831944116861},
       0.3], SphereBox[{3.74719383210438, -2.685840432377382, 
      1.001138983650924}, 0.3], 
     SphereBox[{4.549188208941657, -6.770652932907409, 1.3923625979386745`}, 
      0.3], SphereBox[{3.950717276405192, -7.320962413617819, 
      1.5183640463158414`}, 0.3], 
     SphereBox[{2.2255457207013944`, -0.6483534787183691, 
      2.1504421989560116`}, 0.3], 
     SphereBox[{2.264160197264273, -1.2878752583523871`, 1.6324827933232195`},
       0.3], SphereBox[{2.1669391733197663`, -8.338749606854543, 
      0.9448114468877651}, 0.3], 
     SphereBox[{7.063805839452575, -10.906900952248208`, 0.}, 0.3], 
     SphereBox[{5.523149147029444, -1.8662039256725445`, 0.721505837589105}, 
      0.3], SphereBox[{4.781100675086404, -2.203838265930645, 
      0.6049935385663198}, 0.3], 
     SphereBox[{6.904887216935867, -3.8024761120125934`, 0.}, 0.3], 
     SphereBox[{7.770912620682892, -4.302476112077396, 0.}, 0.3], 
     SphereBox[{6.819856104466182, -1.7663874674112716`, 0.}, 0.3], 
     SphereBox[{3.387645521160266, -3.684779950783155, 1.2447467088530106`}, 
      0.3], SphereBox[{4.880146823665609, -10.506117514497866`, 
      0.7482364660203219}, 0.3], 
     SphereBox[{4.245618735140671, -10.003207631020977`, 0.5976470465028314}, 
      0.3], SphereBox[{4.179205544430305, -5.473945975470671, 
      1.5158986108498584`}, 0.3], 
     SphereBox[{3.8739031269176722`, -4.718305400407193, 1.6341896150392876`},
       0.3], SphereBox[{7.770912620548202, -5.302476112077396, 0.}, 0.3], 
     SphereBox[{4.154199961738533, -5.209423405100645, 2.233310496618497}, 
      0.3], SphereBox[{4.696458634260625, -10.370239357036512`, 
      0.01374291795333904}, 0.3], 
     SphereBox[{7.770912620657169, -2.457370473130262, 0.}, 0.3], 
     SphereBox[{8.636938024564607, -3.8024761122458828`, 0.}, 0.3], 
     SphereBox[{5.285016025937254, -1.9623498402928048`, 0.}, 0.3], 
     SphereBox[{8.478019401793924, -10.906900952438688`, 0.}, 0.3], 
     SphereBox[{1.7164837218704114`, -0.6732162596522508, 
      1.5962356716757307`}, 0.3], 
     SphereBox[{4.225546571367519, -6.7877592537986216`, 2.082044311446766}, 
      0.3], SphereBox[{8.721969137034291, -1.7663874676674665`, 0.}, 0.3], 
     SphereBox[{0.7987328948235619, -7.2771651354098985`, 0.}, 0.3], 
     SphereBox[{8.636938024564607, -6.647581751193016, 0.}, 0.3], 
     SphereBox[{8.478019402047897, -9.492687390097341, 0.}, 0.3], 
     SphereBox[{0.8115797774473554, -3.99445546379731, 0.03306167449385167}, 
      0.3], SphereBox[{1.087798418663198, -10.95529963388428, 
      1.3779910738079852`}, 0.3], 
     SphereBox[{8.358697873251412, -0.648353478876706, 0.}, 0.3]}},
   Annotation[#, VertexCoordinateRules -> CompressedData["
1:eJxllHlM02cYx3sIEUQsYJlYegAtM4gQBQYOyPuCClIMlwOT0XVEpFyTI0Tm
cIsgFBwihxgtJRwiRy0bG45rG9BXMExhDBy4IExQ6AGMy1pquUdAfknjmzz/
fP/45vt8nud5Lc7HB0UQcDicw2YRN+uHq8dpMWQ6ZBIyfgkPfCfBvX881yOP
hKUUuCe+ppZ+9yDa0e9mX2uiPVKCuANfzqYlsVCBMoFsPYaDZBtln5nuEiA+
9SseFzAR4TStLJKrAS0rMT3+EikYfaBno/OahNjNOXbJfylAt4geNli9COiO
714xUg1R4f3DNZTdUiC+2T9/7hQBklkn8nP+tERjvKaNskolUFlHB4Z4mMNI
IZ/vsWqJ5Vl3c9nKP6KejfXlMTG9cJ73mNypD2vPdY9w8y3R4P4KO3R+DsTe
8FbfG9CDi4LZrKIEBlrrdKhnlCoBKcBpy0fXa/B5ni8D84kvd97SDXJEmxzM
MX2nr8mN7uWOMHN0y/9CejtHARrMPrf4/qQK2HyT7i5MoaHJ4cKW+ZZxoEvK
+6rVjAg/nav94wuBPvKUj2U+sFkAOg21bfzfzeFv234Y/56/Q6lRazqQmyi0
h3cI6GtXytlW+VtwlM3vgMt7YV+dcLLoWx0kTBX4i3ctAH/iwAXuMWN4teSl
vjWZgnLpMhzNWw38XPpERsX7IHdezRWfpqLc2ywzF18NiA46Oj3di4fv+5AI
K6z0KY54yHFP08FRCTDDGZhaFask6/V63tW0ZXD4fq6jNBgP3ZVVdxJ+ZKB/
Sw85y1znQLKGtzUXkltwUHA/C+Pz+qfFqIaPTKF0vKtKM7ImSbbXjy40VYC2
jKXhIboJzOycU126h0dZr3qjKJwJsLNvt4OyBJdjDT/g79t18kyrkxGm98X1
h173pkBZlk8a/cQqxg0noMlkZntgdZ7t1MWUvajOLSLzyvRb0OvzndMpvglc
5f363ILIQo2xiqKbbxTAaYSdkr5CghyxW1wlnokOrkw+nKFPgGOca6K0ZhIs
GCUcCJKR0ZW4YTnNQwPYo/YzaM0Q7jp0MenGmDFqUqQSKlnL2P5s5yRjOTOH
PAXyEhKMfthnmvTPfjQU2CV99hIPHcSPk2yfGsOps58R89uYKJXJPg5YOcDP
frtfY3zHi3oREfOZsaloM/eygCUheVp8jJQt7iNWZGggc1I+idjAOMio6Yvt
KgacHw3RmstEj6CiOXkFXF9gD6xmyyTd0qgYu+wlEL5uV7coJ8H/2ss5YmsK
6pCavNAV4aBzQcBCVaIFnLEM1eJM++RnH5e8KWDbGHbkGYX6QU5SYq3WvxF+
hr+Vx8s9S+t+XSK9P07WTAFmg5JUpdqHwi5HNl6aLQdpT3ICyiLfgKEB4W7q
FAuJ1J5caKAG8owIUNPMgA3tqVr38j98TPhe
     "]]& ],
  AspectRatio->Automatic,
  PlotRange->All,
  PlotRangePadding->Scaled[0.1]]], "Output",
 ImageSize->{229, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->481076712,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2658],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Scale",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scale"]], "InlineFormula"],
 " to get elliptical cylinders:"
}], "ExampleText",
 CellID->332788306],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Scale", "[", 
    RowBox[{
     RowBox[{"Cylinder", "[", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->503769331],

Cell[BoxData[
 Graphics3DBox[
  InterpretationBox[GraphicsComplex3DBox[CompressedData["
1:eJztlc1LVVEUxU9PMbV4BjoNDKOJkYMGIhlnDRxKH35M6qkRlBNfz4mIBDVw
1jhwIIhNSv8FCY5NmpQ6aZoTnTSIoEIJ1Ffcve+Gu2HNGt4Dl8tbnHve2nud
H/vK48bYk0oIYf3f0xJsIRRW+3btcOD11dVmXBjfmL3QdhhzvTkx0l1tnMW7
3wYGf3z8ZXr9+u3LvcsnMeyP9N+onpq+8XtldfHgT5x+sNDat1dBru/cevl0
bf0ofs7ebabLvp9Rvusw/Vx27vc4l/3PRdPvZT4Ooviqmr6Y+f4SpY4u08/X
em5ee/tmWH5fMv257E8P3f47cn4Kk8Xzm18zP6nu/EyJ/+T9S51HacfV+076
k2Zcf6TOk1Rx/dT+p/uu/+K7mZZcXhqo1v1h2OWb5mV/8udPyvmmN9TPcVb3
qemb6l/qrmzn+q7Wq/maPqP9kbo7TG+RfJPma/qY9l/zNd3lZXrnq7XRoaWt
95qv6c+K98H0Ub0/mq/pZ5JvrDs/Nb2fm87/J73Pu65ezTc+cv3RfGPrfrGf
OV/jrv+ab3zh8tJ8EQqrHYRfEH5B+AXhF4RfEH5B+AXhF4RfEH5B+AXhF4Rf
EH5B+AXhF4RfEH5B+M1z9fyC8AvCLwi/IPyC8AvCLwi/IPz6vEwn/ILwC8Iv
CL8g/ILwC8IvCL8g/ILwm+ebv3WV8zfXy/krejl/tW/l/A3l/C3nbzl//8/8
/QtVPaUb
    "], {
     {EdgeForm[None], 
      Polygon3DBox[{{1, 2, 42, 41}, {2, 3, 43, 42}, {3, 4, 44, 43}, {4, 5, 45,
        44}, {5, 6, 46, 45}, {6, 7, 47, 46}, {7, 8, 48, 47}, {8, 9, 49, 48}, {
       9, 10, 50, 49}, {10, 11, 51, 50}, {11, 12, 52, 51}, {12, 13, 53, 52}, {
       13, 14, 54, 53}, {14, 15, 55, 54}, {15, 16, 56, 55}, {16, 17, 57, 
       56}, {17, 18, 58, 57}, {18, 19, 59, 58}, {19, 20, 60, 59}, {20, 21, 61,
        60}, {21, 22, 62, 61}, {22, 23, 63, 62}, {23, 24, 64, 63}, {24, 25, 
       65, 64}, {25, 26, 66, 65}, {26, 27, 67, 66}, {27, 28, 68, 67}, {28, 29,
        69, 68}, {29, 30, 70, 69}, {30, 31, 71, 70}, {31, 32, 72, 71}, {32, 
       33, 73, 72}, {33, 34, 74, 73}, {34, 35, 75, 74}, {35, 36, 76, 75}, {36,
        37, 77, 76}, {37, 38, 78, 77}, {38, 39, 79, 78}, {39, 40, 80, 79}, {
       40, 1, 41, 80}}]}, 
     Polygon3DBox[{{120, 119, 118, 117, 116, 115, 114, 113, 112, 111, 110, 
      109, 108, 107, 106, 105, 104, 103, 102, 101, 100, 99, 98, 97, 96, 95, 
      94, 93, 92, 91, 90, 89, 88, 87, 86, 85, 84, 83, 82, 81}, {121, 122, 123,
       124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 
      138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 
      152, 153, 154, 155, 156, 157, 158, 159, 160}}]},
    VertexColors->Automatic,
    VertexNormals->CompressedData["
1:eJxTTMoPSmViYGBYAMTMDDCg4cCABlxfK+dHb1F3MKitkRbkfGcPE99vX9zn
dVnN4dvd45fSVv2Fiwc9fCsakaTq0LCseMGiU6xw8+q+b9wyM0vZoZd9Q9sW
Mx64+K2c+2fKfig43ATTAnBxiDoZB4g+Ybh4I9hcUYdAsD2icPEfYHfwOkDc
JQYXNwK7+589xB/icHGurnk+lpWnbCA8Cbi4BUT9fhc09V8h5h84gGZ+PcQ9
B4LQ3NMDcf8BdPdD/Klw4Baaf2sh4XOgDy18IP5UPdCEFp7Q8D/wCy38Ie5W
P2CGFl8QoHEA1d/w+D2gAVG/H918hntg8+HiwVD3VELccwAeDlD3Q/zNAxeH
xu8BaPzCxfug4QPxtzBcvAkantD4hYv/hoY/NH7h4mjxBRfveF7289Wtx3sg
PAm4uCpqeoCLf4KmnwNo5tdB01sQmnu6oOmzHs39N6Dp+Raaf6Hx6zABLXyg
8evQjBaesPz15y5q+EPj18EWLb4gYDT/juZfVPNH8+9Qyr/oQOHAqPio+Kj4
kBV3GBUfFR8VH/ziAHWukCc=
     "]],
   Scale[
    Cylinder[{{0, 0, -1}, {0, 0, 1}}], {2, 4, 3}, {0, 0, 0}]],
  Axes->True]], "Output",
 ImageSize->{154, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->90523192,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->592859],

Cell[TextData[{
 "A parametric specification of a cylinder shell generated using ",
 Cell[BoxData[
  ButtonBox["ParametricPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot3D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->618987645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "\[Theta]", "]"}], ",", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}], ",", "z"}], "}"}], ",", ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->374567681],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->316338387]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->738472534],

Cell[TextData[{
 "An implicit specification of a cylinder shell generated by ",
 Cell[BoxData[
  ButtonBox["ContourPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ContourPlot3D"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->624302783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->82648641],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->410814658]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->58000789],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ChemicalData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ChemicalData"]], "InlineFormula"],
 " plots a molecule using spheres and cylinders:"
}], "ExampleText",
 CellID->96400878],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChemicalData", "[", 
  RowBox[{"\"\<Acridone\>\"", ",", "\"\<MoleculePlot\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->913821479],

Cell[BoxData[
 Graphics3DBox[
  {AbsoluteThickness[3], EdgeForm[None], Specularity[
    GrayLevel[1], 100], 
   GraphicsComplex3DBox[{{27.335, 217.15, -161.43}, {-33.623, -71.57, 
    111.63}, {122.02, 78.877, 3.8726}, {-106.09, 35.807, -92.713}, {
    92.782, -17.113, 102.32}, {-125.95, -58.472, 9.663}, {15.403, 
    119.48, -89.708}, {249.9, 134.07, -4.5024}, {-200.08, 49.16, -194.98}, {
    193.14, -56.366, 190.57}, {-240.1, -138.25, 7.0586}, {346.81, 94.169, 
    83.288}, {-311.49, -30.083, -195.4}, {318.81, -0.77981, 
    180.56}, {-331.63, -123.63, -94.874}, {-58.133, -120.62, 191.64}, {272.22,
     208.01, -79.985}, {-184.86, 121.75, -273.48}, {172.51, -130.2, 
    266.64}, {-256.83, -211.35, 84.777}, {445.82, 136.86, 
    76.93}, {-384.31, -19.821, -274.49}, {396.39, -31.445, 
    249.15}, {-420.05, -185.62, -96.556}, {21.369, 168.315, -125.569}, {
    29.579500000000003`, -44.341499999999996`, 
    106.975}, {-79.78649999999999, -65.021, 
    60.646499999999996`}, {-45.878, -96.095, 151.635}, {261.06, 
    171.04, -42.243700000000004`}, {-192.47000000000003`, 
    85.455, -234.23000000000002`}, {182.825, -93.28299999999999, 
    228.605}, {-248.46499999999997`, -174.8, 45.9178}, {396.315, 115.5145, 
    80.10900000000001}, {-347.9, -24.951999999999998`, -234.945}, {
    357.6, -16.112405, 
    214.85500000000002`}, {-375.84000000000003`, -154.625, -95.715}}, {
     {RGBColor[0.65, 0.7, 0.7], SphereBox[16, 24.], SphereBox[17, 24.], 
      SphereBox[18, 24.], SphereBox[19, 24.], SphereBox[20, 24.], 
      SphereBox[21, 24.], SphereBox[22, 24.], SphereBox[23, 24.], 
      SphereBox[24, 24.]}, 
     {RGBColor[0.4, 0.4, 0.4], SphereBox[3, 34.], SphereBox[4, 34.], 
      SphereBox[5, 34.], SphereBox[6, 34.], SphereBox[7, 34.], 
      SphereBox[8, 34.], SphereBox[9, 34.], SphereBox[10, 34.], 
      SphereBox[11, 34.], SphereBox[12, 34.], SphereBox[13, 34.], 
      SphereBox[14, 34.], SphereBox[15, 34.]}, 
     {RGBColor[0.291989, 0.437977, 0.888609], SphereBox[2, 32.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], SphereBox[1, 31.]}, 
     {RGBColor[0.65, 0.7, 0.7], CylinderBox[{28, 16}, 15.], 
      CylinderBox[{29, 17}, 15.], CylinderBox[{30, 18}, 15.], 
      CylinderBox[{31, 19}, 15.], CylinderBox[{32, 20}, 15.], 
      CylinderBox[{33, 21}, 15.], CylinderBox[{34, 22}, 15.], 
      CylinderBox[{35, 23}, 15.], CylinderBox[{36, 24}, 15.]}, 
     {RGBColor[0.4, 0.4, 0.4], CylinderBox[{25, 7}, 15.], 
      CylinderBox[{26, 5}, 15.], CylinderBox[{27, 6}, 15.], 
      CylinderBox[{3, 5}, 15.], CylinderBox[{3, 7}, 15.], 
      CylinderBox[{3, 8}, 15.], CylinderBox[{4, 6}, 15.], 
      CylinderBox[{4, 7}, 15.], CylinderBox[{4, 9}, 15.], 
      CylinderBox[{5, 10}, 15.], CylinderBox[{6, 11}, 15.], 
      CylinderBox[{8, 12}, 15.], CylinderBox[{8, 29}, 15.], 
      CylinderBox[{9, 13}, 15.], CylinderBox[{9, 30}, 15.], 
      CylinderBox[{10, 14}, 15.], CylinderBox[{10, 31}, 15.], 
      CylinderBox[{11, 15}, 15.], CylinderBox[{11, 32}, 15.], 
      CylinderBox[{12, 14}, 15.], CylinderBox[{12, 33}, 15.], 
      CylinderBox[{13, 15}, 15.], CylinderBox[{13, 34}, 15.], 
      CylinderBox[{14, 35}, 15.], CylinderBox[{15, 36}, 15.]}, 
     {RGBColor[0.291989, 0.437977, 0.888609], CylinderBox[{2, 26}, 15.], 
      CylinderBox[{2, 27}, 15.], CylinderBox[{2, 28}, 15.]}, 
     {RGBColor[0.800498, 0.201504, 0.192061], CylinderBox[{1, 25}, 15.]}}]},
  Boxed->False,
  ImageSize->303.0251889564551,
  Lighting->"Neutral",
  ViewPoint->{1.3, -2.4, -2.}]], "Output",
 ImageSize->{307, 273},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12758413,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1221],

Cell["Ten random unit cylinders:", "ExampleText",
 CellID->255829116],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Opacity", "[", ".3", "]"}], "]"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
      RowBox[{"Cylinder", "[", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"10", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "20", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->304936124],

Cell[BoxData[
 Graphics3DBox[{
   {Hue[0.380945550254131], EdgeForm[Opacity[0.3]], 
    CylinderBox[{{0.1734480111649428, 7.569766037820022, 6.337524520119273}, {
     9.87762970379195, 4.944473839383532, 2.362628494056136}}]}, 
   {Hue[0.21247271899759657`], EdgeForm[Opacity[0.3]], 
    CylinderBox[{{7.49835478944858, 1.2287402462189756`, 
     2.9870710394242384`}, {8.127036686870504, 7.865309261296365, 
     8.521879337955054}}]}, 
   {Hue[0.8645122680261341], EdgeForm[Opacity[0.3]], 
    CylinderBox[{{8.175606178888495, 3.920224595070534, 8.76205797533702}, {
     5.701896008412721, 3.1020382631441734`, 7.606015153029748}}]}, 
   {Hue[0.07723838631743862], EdgeForm[Opacity[0.3]], 
    CylinderBox[{{2.3414512404155374`, 1.4749133722483476`, 
     2.4211275994216908`}, {1.964955050944417, 2.024154706013357, 
     9.711663840384812}}]}, 
   {Hue[0.4875308423226823], EdgeForm[Opacity[0.3]], 
    CylinderBox[{{8.583000904032662, 9.887724436580243, 0.8769224245377294}, {
     8.81921180950457, 5.876552540466644, 8.136936275033218}}]}, 
   {Hue[0.7175019829525702], EdgeForm[Opacity[0.3]], 
    CylinderBox[{{9.184528516992883, 8.214732817945825, 
     7.6337488391148955`}, {0.8596242881706551, 7.880002412152891, 
     8.797888150790145}}]}, 
   {Hue[0.7774534675158584], EdgeForm[Opacity[0.3]], 
    CylinderBox[{{0.2873137006960724, 6.28635653991418, 9.75225371749637}, {
     1.74174122589847, 8.847035246860411, 0.7634330606811779}}]}, 
   {Hue[0.2180177063914981], EdgeForm[Opacity[0.3]], 
    CylinderBox[{{4.616678284317848, 7.177417199244223, 4.638399090318687}, {
     0.3908794491962775, 7.187133327296376, 1.910713183557593}}]}, 
   {Hue[0.28656187396598054`], EdgeForm[Opacity[0.3]], 
    CylinderBox[{{0.9806514745099815, 0.11401525360291265`, 
     3.8322666643663905`}, {4.398117259141179, 4.723159941190513, 
     4.599148281837413}}]}, 
   {Hue[0.22413886477483058`], EdgeForm[Opacity[0.3]], 
    CylinderBox[{{1.9097291817221995`, 6.621095335879252, 
     4.115788498312478}, {9.257358579947228, 4.104804276341348, 
     4.625605754978306}}]}, 
   {Hue[0.569304648592682], EdgeForm[Opacity[0.3]], 
    CylinderBox[{{2.7186337251422543`, 6.178374456486189, 
     5.532796980881889}, {9.138142735601175, 2.900482366228476, 
     8.347438761519248}}]}, 
   {Hue[0.9704764007448097], EdgeForm[Opacity[0.3]], 
    CylinderBox[{{2.4790343021535555`, 1.3087802312372165`, 
     3.5644737503443857`}, {9.905833305788933, 7.867362088906409, 
     8.155258632874364}}]}, 
   {Hue[0.31522313714328165`], EdgeForm[Opacity[0.3]], 
    CylinderBox[{{9.828912859260186, 3.4178618073045897`, 
     7.448103188705191}, {5.0633775062142945`, 4.355968712619969, 
     2.8591986824387194`}}]}, 
   {Hue[0.11472787774302495`], EdgeForm[Opacity[0.3]], 
    CylinderBox[{{8.42894125138182, 3.6029454571641617`, 3.652626393823899}, {
     0.36207254759032415`, 3.5058638065933323`, 9.722358019943169}}]}, 
   {Hue[0.5176161703005633], EdgeForm[Opacity[0.3]], 
    CylinderBox[{{5.124497062180636, 5.51698748919568, 2.214339433122534}, {
     6.931143733634906, 4.115826145576557, 4.5726796593288155`}}]}, 
   {Hue[0.6778215785717876], EdgeForm[Opacity[0.3]], 
    CylinderBox[{{9.803372532989247, 2.486555802443724, 7.631128642574209}, {
     5.552119423422576, 5.885524957679156, 8.898863841682907}}]}, 
   {Hue[0.25755488448022223`], EdgeForm[Opacity[0.3]], 
    CylinderBox[{{3.5912562731910103`, 0.43722678322632325`, 
     1.2613377497590794`}, {9.176206335978305, 5.589230062514073, 
     8.362653547680345}}]}, 
   {Hue[0.03071500793387938], EdgeForm[Opacity[0.3]], 
    CylinderBox[{{4.033441080793104, 0.851584422100482, 1.689446568812949}, {
     3.0801778010450342`, 2.543553361717159, 4.534997988680798}}]}, 
   {Hue[0.6674793178999205], EdgeForm[Opacity[0.3]], 
    CylinderBox[{{7.190789880072677, 2.1770590553829794`, 
     1.095746490736107}, {5.191493350316286, 1.4924415998903506`, 
     4.876021430346224}}]}, 
   {Hue[0.8977409616991332], EdgeForm[Opacity[0.3]], 
    CylinderBox[{{3.169507194448833, 0.7811431524376689, 2.583130830323759}, {
     1.2593823117271952`, 5.415202648416589, 
     0.8557916350858941}}]}}]], "Output",
 ImageSize->{229, 238},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->125437871,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy9nQV8FNfa/3/vboJLCostEpIQgsWACO4JlhDcFt/gTnApBYq7uwWS4gRp
cW2pUOrutIXK7e291VthP///Oc+ZmZ05Mytp7/v2s12ymcnszPM9zznP+T1H
MobljM6eMCxnzIhhNdOnDps8esyIaTXTJk1lv7L/D4D77P/vK4P9/P/YT/T/
fY/HA2xh7/bs7OxO9Gmj8snG/rWxfzvSb9crn0INv12rfCrKP/E/Yv+yd6TT
0VXKlYrzTyHiqDghjY6vUP66lI/jS5W/L8M/hWrHle/oQOcsUa7xmJ9zFinn
lNfdJf/RJn1uS2c/rnxrBemoXfrchs6er1y7clBnz1Gu7ZSOhkifW9PZs5Rr
Vw/q7BnK2TUDnN2Kzp6m3EmkdDRU+tySzp6iXDs6qLMnKWfHSEeLSJ9b0Nnj
lTupKx0tKn1uTmePVa7dIKizRynXjpOOFpM+N6Ozs5VrJwZ19gjl7EbS0eLS
56Z09lDlTpKkoyWkz03o7MHKtVODOnugcu2m0tGS0me6Gvor124R1Nl9lbNb
SUdLSZ9T6Oxeyp20kY6Wlj4n09k9lGu3D+rsbsq106SjZaTPZGFkKNfuHODs
xnR2F+XsrkGd3VG5k0zpaFnpM5UMpCnX7h7U2e2Ua/eUjoZJnxvS2W2Ua/eR
jj4mfaYSTZ7Pz+4X1NnNlTsZIB0tJ31OoLObKtceJB2V69x4OjtFufaQoM5O
Uq49XDrqkD6Tl5Md+dnuoM5OUO5kpHRUrv1j6ew45dpjpKMVpc9UO6G+cu1x
QZ1dV7n2ROloJelzfTo7xuMtsaEFBQXhQf1VLeWOqJwXY3/GiifgptdYVs0D
s4EBNnageoDr1aPrRSp3QZ5Qmq7nVl+jWUMAzGQNKmvJgTXAZlbZ83OqSteS
205qCRCu3CvdOX/EDilol4hW9cCvQc8bZvzGbGACkAPMY3EBCz9YLANsB/YC
uax9ZCdXCeqbq3t0bUxR9mfpbZE9AO7eGJGFYR3hainuLoR/a2lgHDCVte0s
0GAxDQuVgK3AbuAgkA8cB7/hAtN3yfdSh767qv67S7C/S+sIFshkD0f2YLqJ
PnQTnTCoFd0n3UNZsvZkFjEAC4FlLDAja+8E9gN5wDHgNHAOuMAtI7OUoxFq
t+l++S+p5JdidzJ8PEaMhXu0ej9DkD2Q7qc7hnXGoDaoxv+C389jwEhiMZ0F
SMCTwGpisQPYBxwCjgAngbPAM8Bl4Dqw3OQV1ndVUbEP1Qxl2F0NmYRhE6Hd
m1t3b9l9MaIHhnXB4LZ0NbJVOeI1DZgLLAZWAhuAbcAe4vUUcILxAp4GLgFX
gZvAs6wsyfWBXIZr092VV2xGdeJjrbLgmopBU8Ducaj+HkciewTdo4vfo7sH
hnfFkHbo0wjEhu7TAYwhpswjn+D2wToWqQO7gANGpheBK8AN4DZwB3iR0Zfr
Ouu7pei4fLPu6DcN/adhoLjXyVb3OpTutR/cPTE8A0M6oF+yYEG8K7JIC5jI
fAxYoPLepON91MT7FvAc8ALwEvAywyjX/NWkzxR5UttjU+1bgf1Zzxz0zkHf
HPn+h03AiHFwj9Hd/yBk96f7z8TQNAxoAmoR6P4rUd0xXq07pGKRqxaLM2qx
uKYWi+fF/QP3uNvLz1Bd+lxLewZ9X4naoUrsWTJzkJUD8xMNVp9o+DiMEE/k
RvYw9Yl6YQR7onQMbCauTaWnsq4+tyw9x6n0nKfSc9VYeu7S47wCvMpuSm7t
/TyToQdH9VcVdoGO09AlBxn0bD0sn22S7tlG6Z5N1LjdMLQjBrYARUAhSmmz
bFtEbXeYStspKm0XLEsbezYbezjYRa+W36gcXdWQPkfRU8pxktx/pNbDGZeF
DtPAHruz7rF7BfnYg+WGpqxaRqsa61Rz+2Yuo7dMZZRDpfd7vEWSn0eOISIt
n1ru2VK9XI1dr+UUtJmK9tOQbvXsrI4ZMJXXh+zZDXX2KFP71p3at9bUDwhR
nj1gGyuV5mdNpXlD7XAsYpfB3b/+7HJfmurR6rW7oukktJyMNlPQfqr38bup
j9/Hz+P7bk6pR0bPX01tCyzbd63Ei/b9CpV44c1aiV/PHn7VAjx7AtcPoGAl
j0jkZ5N1gwhLC8g9fvL/muxyDccheQK3QwujHbqSHbqb7TBFtoPUdPNmkZru
3onUpyYvqK62NFJkIbxAiyzOUEujecFzqhes42ZYiheu4PlncKcAt/JxcRus
ykNw1pAVDaonIqqnI24MhEGakEFaT0E7Mkij7kjqjpTuSO0O1vA2744WWRgw
zUeckK2LE/qpcUJ79GkM0jvIIjXUtksf0liEoDr30NquF5k5li3Hszdx5wae
v4oXLuH5c3j2OK7tx6nlpqeNsLKR6SxZiaG/imI2rj0cdUcidjS3TBKzzESv
ZdKmoZOuqPTUioovy/iKSlJAJTREscwYXRsovEa0gVpUrPcapQ1kNlm4DJdv
4vot3LqF527i+et44TKVmNO4lYeLW019YNky4ZaWkXUksl8tZpnIIYhWjZOo
Gqe5yTiZqnF4I2oK2QKHPE2p7ibb1AwUsen96LLwI2aYmYtx+irOX8elm7h6
CzdvGcvOWTx7DNf24eSTAcuOsJDc7sr6Fp0VXakZIvsjcjA3Up1sMtJYJI1H
Khmplc5IXchIAaMot2UU1Y2iqOagdp18K8JvXKjvLpwX3QVmovHzcPBpPHUR
J6/g7DU8cwNXbvGidFtflJ7mRenmYVzYYi4lsiJbw9JSslpXnb/FsLJUKQmR
PVV7DeP2ajAaCWPRWGevtlOVECWAvYKIzFwsMqMSFRko4vT2QZmVhuZgw1Fs
P4V953D4GRy7jNPXcP4GL1fXpHJ1kZer20dxdQ+OLzbZIThryWol9YdiVqPH
C5jB3iO7kM36IXKQarNRXps1m2Rts0JEs7qwTlgryiqGtegxMVN1H435u/Hk
Qax5CltOYPcZtXxdxdnruHCTl68bWvm6ppavU7x8PbPZbIsoq5JjOkvWYIVa
ISzGXrDxt6jIzojsoRiuFjOcG6NLKIZLsTKcZTwsgqKhIhgYZx0Tgvwx2kcM
bOinMZO1HoBRKzB5A2bvwKJ9WHkYG45h+2kqbBd4YSvQFbZbxsJ2hwrbld3I
Zx4va7S8bbFSx6pZ2lBWjytJNgzhbxGRnRDZHRlF+KtPUW7AuaWxpiwaMRtO
4DYUcbVlnyLIwFKUuWjfUTTz0Bxmtwbp6DIFfedi+JMYtwbTt2DBbiw9iLUB
S94NteSdx3Os5B3C0xusrcdAppZD96r8Xe7jW1tRvopQYhgExYpF2Jud2Q7V
9NbbWw4nHNyATVUD/rXInCwX4zv+nlw7AimteTjXZAjSxqHHTAxaqJS+OaL0
5WHjMew4jf3nkHcBx6n0PW0sfc8z+13BCxdw5wxuH8HlXdjHalK5/IjeB2Kr
IpxMaONv3BIGH5VqOZP95PbGIZVKgz3HlMA8nT0bqUF+y4BB/jTrIJ/8uI4u
+jBH8bkpcUhJQUpnNOmH1iPRlRXJebxIjl+rFslcrD2CLSd5kcx9Gkcu4ZT/
InkSN3Jxbp3JojwesnGDMqvWUAqmsCr74MOqTkuryhFhOamUFlWtWlWz6lrV
qpcrQt97aq0atpNvw+pDYmHTusH0A1ISkdKGF9amQ5E2ngrrExi9ElM2UmHd
j1VaYT1vKKyX9YX1urew3noKl3eaS6rNYNfYSIRXZZ5ktKush1vbVdbUHpNK
q2ZXZ99iFnZ9obJFP8xPb0MLqMnv6xljGut+Ny+tqVRa+/PSmjEV/eZhxFJM
WIsZW/H4HizLxboj2HoSe856S+u567hIMTQvraL5uUYxNCutJ3DjIM6sFm2w
V1VTbRqq2DQ2BrH1ER4R0LJVLC0ra8RhhbbsW05/XTlfvRUqrfXV+Mfc/5D6
8U/zMtsWqT3QdBjSJ6DnLAxWy+zcnVhMZXbTcezUyuwVb5m9bi6zBbzMXmI1
jRzhkG2LGmwbG4/GDXm1ECrVtHKuwtrCcs6gjFQncGPDPteBxZWwysn6Hewz
WbwKs/jYEphPFt9ntLifLmIXyegUYAl7x6qRk6+ejEElSIlHShOkdEGTAWgz
CpmM3nyfRfrQM3KRvqkVaZ2kIHQnEYmXFjbhBucvk8WbJyEtNRi7V7a0u3wW
kS7JrsLsK8r3lgrIrYLT1XElEi/Uxhv18HEcsxS3fWXJ9icduKLa/tNqFp3P
tmR+c2cqRLG7FnP56hUZlDte2tshtSeaDUPHCejFSvsijFmFqZuU0r46n0p7
AQ6cR/4FnLiCM9TLlAULo8Ql7F6G5xv8G717MwxqyUwfyPIUy5rqfbnmoV4q
zx3WLQ5R6Jc6sLUCDlVBQQ1cjcSLtfFmfXwcL2xfqZ9q+3VWtg+yLyssH08x
m58eloVSyMt9U6R0RZOBaDtaKffuZZi4DjO3YeFeLD+E9Uex7ST2Urk/GkS5
51LaMqHloqxqf73x42Tjj26NqW2tSr9cn1gzkOMVGo/Ec/MZDvR2QDjAMge2
VcBhJ87UwLUovBSDt+rjk3jFBypacnixMt4mDt9WD9xFJgYJVv01c16twJyI
4m7QHqm90Hw4Ok5Er9kYQm4wbRPm7cKSA0Y3uOjbDVTd7ibpdqQvPcYQEIgg
KMxvj6VpKgu5dFe0tL+ctyY9tIywf6aKYJYDKxzYXhF5TpytgeuE4O36+DTe
S2BcCSxgBMJkAp8RgR/DeXe7/ihDd7ulDgIRSFSz3Vqfbx2FhBaqjC5zwHNl
3BeaITUDTVzcF1ioNGABss2+cEr1hcuKNHjRtzR4dS9OsKae66DU2j5GGIJj
sL4jdnTmJORoR/YKf1QYBUcsYmKFfo6yyWXAqHRzoI8DncpgjgMrHdhREflO
nAvHjSjcjcE7DTiVrxux9pmTqaAns98HmVrDEENw4sfI/XjBpZGpR6nlMC0z
5lIe4+WUhkjpgNTeaD4CnSaiN/OPxRi72usfa/Kx+Th2BeMfOjGSZ0KKqHTK
I7Y6o0OM6gVF52AXHM0IhlEF34xCGaAy4UhqiMRYNGCkqNdbW/iPgNWXYLG4
abUDOyvhSFWcD8fNWni5Dt5tgM8S8E1jLqYkhyAYVr/XRK2hMi7WEyNOSSad
3DLrah4w4k0+ckdqjtRM7kjtxiBrOjnSckxaj1nb8cRerFAdyauF+tLY9Vpo
U6IVotKqIGghtjYBk2i18EnrbCYudwuGmcN3a1NS+FW9VDTtiCatkJyMRrGI
j0XtWLDj/D5tDB2ishzo58A4hrAM1jiwuxKOVsXTNXGrFu4RvPsEbwtKvoaw
/iq89QTvlANXreBFuhDF+I1APcGPunsi6k0x9Ykl0ctcAd4wpU7vpcQipRFS
0ri7tRiBzpPQew6GkrvlbMb8XXjyANdmN5/ArjM67V+VI66btNnnhDa7CVc7
YUUqvL3lShpD5nEcYzAMj6kMb2Xhpe5ekt64Qe7p+SZpYxRRvEF7tHShRS80
64qm7XhIlJSoeiNxjOzuwAAHJjiwwIG1DuyphGPV8ExN3K6FV+rgPeJ4qBY+
QLl3EfYWwoLh6IlA5ECOsjZDOZJnUMkDU4Ppg/upKbVxDykJSGlBfjgI7cdy
Pxz4OEaSH85mfrgPKw77y0n4komfy8LLfbGpreg/ViGCEYIg80IOkRHsUBiC
r/XAuz2C4UjaiLVSHy88klWkLB5oM54LE62GoGU/NM9C03Sk6nyUsRzowCQH
Fjqw3oG9lXG8Gi7UxLPReLUu3o/F3kh8igqfwPERyr+PxxjRx4Ng6YkknEM4
TkGyt1Wf388IFkOmWj8sib1zn2yMFPYkfdDSjc6T0WcOhi3hqjX3ySDzJUaJ
8OYhnF+PNwbjPTd2d4FEEo0acpgJMUitizb1CkHy4574oidym7I6yX8NW84n
T/LLWEaz/eNoNwdtp6PNJLQeg1bDVU/tYvDUyQ484cAGB/ZVxolquBiB54jm
B4wmHruPyp+hksq0HGPKaB5Qab5UGe+oNH/S0+yjAIU65s+XoiANyzEPUVTq
VhvHWc8LlDko63p2Q5PB3EG7z4CLOajI45CDWuZxAirpjOYn4/DlFOT2gJdm
VNTs8WBGtp9goXB59jP6xvtD+boO5dc98V0PPNWE+6iswcs+as20ss5H2Ssh
Gx1Wo8MytF+EdvPRbpbqtdnktX3RvBt5bUskJ3Gv3ejA/so4WR2XInAnGq/V
ZVQd91HtPpz3UUXD+zEclmD/YQTriUJkb/LRNLQCuvjQKyxrW/PYOsMos+zB
4GCTkNIRqX3RMhtdJvP8kvBUc35JyKMBPfVGroL06xn45zwcGcDAxkWFs9aJ
0+R2Zv/Sj/ytHKcbJNR/98BP3fFrNxxPtjG88kjpx3zS1Dw0bSfStiJtIzqs
RYeVaL/EymcHokVPr88eqIJT1XE5As/Xxsbq+Azh91Hjc1Q3Eq3IiEos71ux
5NFoKMAiCvYDa6wH+1Y+zKNZDfUs+WdtLYvI/bMVUrN4pqvDOPLPv5fp4smD
HQrDH57AL0txchgYLJliiOajwfP7NQM/d8Y/2/PYMziKlYw+yVCmH0L6fqTt
Rtp2pG1Gh/X+vLSF6qVCVWQod3MnjPgMNX0B/QQVrlXyiZLjK844Ioz6F2ON
Sq023NFXvVpXOKE+E8wzFclI6YTUfmiVTXk1SvWOXyPn1fackTMVmitKmYrr
Bzm9H4neb6vw53oO0EQwlL+F8SO+2P2zB36Q2clKSpgfbgyX4JY4F+nHkX4E
6YeRfhBpewN55GjFI4UgudqJD1HrI0R9gkgTvap6ehK3P/TcSnJuzYlbjqrx
+hmP7K0z5fGQI8jrRH55qC6/7Cdld8Vvyo4E4UvbvbhYtcngMDTsnRm1GCdV
hpMKjpGcwyct3jTexsK3nkb6WaQXIP0E0o8iPb8Q3nYtkvXgnO+h9vuIDhKW
hKmgEntIzqg0MZofsCoE+VSM5TBEJVdN2b+uavZvvGX2z5QqueEjVSLYPNoM
b6sm4hX+IzEqxRn5p/Nd++p/hU7iUqRdQdolpD2D9PNIP4P0U359aoXBp5ZW
xhuo8xZi3kFtxugDYvRxIEafUnX4Mcp/iHKcThinU5xES/P0BD6EHzSGn9Vy
r8gjRNXxfUqyu4eS7O6pS3b7ShwGk0phUBrGEhe7VMsRlxLY3dRIJEtPRB5n
XsYnETtFFAkr0OEW0m4g7RrSLiPtInnOOfKck4E9Zy2q30O911A3OCTVdEgq
aUi4jxCPBPIWfwGfd3SCaUwqT5J34W7SJlCSPNjMyj7YGAmEiipMvHgfrSTn
UJz3uASBnzUCnRgBbt8irLBznZgn18MsCZCKnKivsdq/iPbPo8Nz6HAbaTeR
dr0QXpIwgpms/guofxf17qGukUe0mcd9Ew+K6CvuZrXWY5xEUSJhXUvVZr8y
z+jSj0oU+fRm+nz6KkzdaJVhDC614o8Dr6ckCP9oR1M4W6MIYl021Gyt70Fx
j+Ag5Hkm1p5CnBpqrX/cerR7Ge3uov1LaP8COtxBh2cL4UCLEX4dsbfQQKP1
io7WuwqtWla0qku0GCAiFUKkFEZUZ9UhWC8HM+RWSsG7l2ECpV+Yw5hTkQHT
L3ZOKUQ09QJRKQrOcCxVYfMTZ8Nch1OJc3GtwoWE1hxWSYWKPOPBNxXqESUw
Mm1eR5tX0fYVtLvH4bS/a+VKV61dKTGHy4q3arG4KdY/mfcVMlFGMjX0ZPYi
rBxnkkhMDBUXQxTkMGiemx+u5OaHqLn5Qicl1aRLwzg0SrCMmUtQ14cfUcGU
ULmEoJkLHV3o42Joiipk5LHzFCebxomTvzTW6rX6m9HqTbR+A60ZpNfQVnAK
2oOOkVKoV319QXpbB+kjgvSpAilcD2kvypVTWpr1Khv2uht4oLouLBPZ+245
PrL3p7D3nCFjaZloEQJv40QkN0LtaBMdqtvsONqIO0ysC5wNq5UZnEQX1+S6
utDfhdEcEI0y5H8q91z8EAoVNRp7b/4WWrzFSkfLN4H4Vm9wVm0Eq1fQNpBD
7SMx96JOzP08Ed82Zp3G2BuIvY0Gdwyg6rxpASqSQNXUQN1XvUm0RAmk+r1C
ocCLfobHWw6wbT6cZy97UfZyjFX2UkunnDFPpdClU5IbI7UpmraxUg9KCFKH
4jkh9tJqt6Jo7EIbF7q5MMiFcS7MdqWnp8OmxgRBkaJazh6zBU3eQlPOifFC
AiPGeFl41j0LzxJq3olqXM17jtS8D4jTPxrjx1T83kzQaiBovYj6LxOt133S
ijDTougtRq31WNz2nK8h+X5GQ7fTRgEsx8T1mEU+JZKX26XkpW4iB2wlY2Ev
xVue0rFo3gEtuvqmxGs7E6UUF9q70MOFIS5MdGG+C8PbmMbbWhMihb2kVttF
b0bKm0h9S4HV7C2Dd8X68a4lDmxycKFOL7oyTF8wTEn4KRV/NMejVriIWCOs
esHDUvWhqnw5Bw+fIbKWRXj6YTX+Bv+bBlp30qUpp/lKU5LQipASjBCjFEKU
4lpL8YEVlWJo6kK6C71dGOHCFBcWurBusMWsUj9cmmt1XMPX0Oh1JL2B5Det
AVk603QHnnRgSwUc1Omnr9fDh3H4MhHfMSxNFCxnEHcecQzOVROcVxU4MRqc
D/3CKc3ZRJCkeks/N8Pn1ALLGYxjDOnHWeb04wUGongskQlR/cfO/EdRAAQX
HkELLsVEE8TAJLjQwoXOLvRzYaQLOS4sdmHTUEzrFDwZqtPKhK9F3MtIeAWJ
r6LRa2hMgCzpkPc00LxnpgPLaJSfNMTyI8alIf6ZhJ+b4E/i8qgtTiKe0Xla
pXMTDZ71Qces95joOEl3q8nqOf2IKP3cD3/j6Y091j7MeZZg3GpvPlHLUtiL
xRKdUIUO4eHeEmsmU1T1mOJo5EJrFzJcGOjCGBdmurDUha3DML2LaU6GNRvK
LbXRMrt1bqPeHTR4AbF3EX8Pia8E5UcjHZjlwHIa/3fIqaieDNCbBOgBA5Ts
BeRpC08HHEW8humSDtPzqP+SEdM7VpjMCrjQtWswTvoBN77mlFiOz5d6tFKa
0F6UkWGUQhUf4rUbQgUi8SrNBzr4YlUCyS60cyHLhcEujHdhjgsrXNg5Ascm
WtRx1PsxzV2lOq4tO52hqnkOkRcRfRUxN1GXBcfPo8GLgb2rjwOjHZitGyrI
R2tG4sUYGjQbh4cN8X0yfmG0WuBRa3jacVqejjiMBInZNSOzeyqzt4JjVozz
qlY1zTtGyjzXX5pSIY36lxcxGaUkAG1FGCVGK1TnUzTngRETL63u02eDrKk1
cSHNhV4uDHNhkgsLXFgzCHvcODWlcNR41qjMWFQ+iKpHUaMAEc8g6jJqX9e5
3Euqy71qcLksGp02xsFHp2lDCc+GKwM8xRhbC2ppnNoeJBxAQh6xO4X4s0Gx
qx1QBg8ldszXaqmjpLTFCZpaTYoxTyHw1RMuorBTPc3G2VFXlMCR18n0bBb0
UIrji3ehuQudeK8WbhemuvCEC+sHY/8onM0Jmh9l1oc71nCtrEo+qp1A+Fnu
e7WE7z2r+t5dxfdYlZnhgDYubZ4YVFgRT1X1jgB9m7B91Qj/SsavTWVsni7Y
hgQG7yCHF39MhfeMb3hB6uN7+WJVBZUaolIqIvsqA9200VG+5jUFO6d7LIop
/Hh7ZgsNZxyRRrYsGo6iPO8gRx9KIFjM63ENXWildnZHuTDdhSUUbhwagwsz
5Rjdmhhl+Uo5HodjCyrvJ487jYinucdFX0OdW6hHagLzOBp71kOMPRvvwHwH
H0O4SxsAGsUHgL5DY6g5qxRrVp4MbETidpVYvpHYZSKmKRiCWNDyOXe3yHRE
ZnkHyyi4fC964QuXa4qhC1ZCYcVgIa0U3OzF4nX2xi3J/i0eK+J43tuyMXgh
5Q4b/CzUyyzJhbbU63W5MNaFWS4sc2HbMDw1DlfnBcesOn8r7liBijtR5TCq
HScvu4BaV1D7BvcywapnDwdcDkx04HEaJ6gf78lZ0WDdrxvh3yn4j2DVRmXV
SWF1tgJuVsImIrZXR+w04s+pxPwIg74Edn3CI7KbAZd5GQ7LST56ecPcY0ap
IpwVAyZwoYjEyk5vDBhjxVEVrfod+8x/EshCvLxSXeig9n8nuDDXhZVKLIJb
i4LjRSuNFHFsRqV9cB5B9VOoeR5Rl7yUBulHAOpGc97TDalWKLUkSu0NlAqS
MQCRQxA5ApGjEDkOEYxVLrE6rrK6ECwrS3m9RkY4MsMJFH2TtpiMeTZW8NKG
QikkHIpH6SkV0ygVCQejwwEV1ygJr7J5o/tman94uAuT9bHHZNMcVsFIXidY
rMvgWIoKO1DlEJ+Jw9n0dGCIA1N04/mU0Zk6zZWx+SEFvzXTsUn3svFkIoeP
ikhchMQVSFyLxM1I3IGEfUToKSOhK8HK7F5CAkyPcAwJx8RwzA3HsnBazkZd
qcVytlZALUNh463tZDY2AsRYKGxKEhtvjad4j5Bju1CHONuFaSKsGCLCCnm0
XklLMnyVL43GUAemObDY4ZXttNGV78dyGt8yGqn+aLiRMAGJ05E4T2Wyjpjs
NDIpMDK5HYSqboliQy3sboDDjeXpc9KcLf/qhTWNUEGD13KxVIuV5QzKKAzi
6CU01kwXBnA5HDMoQthMEcIzMwtr/14OFtshx6HqceogyOeM8raQTR/5sP+/
MuDiQy69FBYjcSVR2IIEQeEQUThBFM6rFDTJ/EUfkrkw/lCd8TeS8fMa42Rz
PNPOMG3OoE8YBSSzPoGSZH873DZkctMXpQBA2J+9WBUWRrZX6iZh+xS1F6vq
20pLnz8OV+YW0va9ejvgdmAGiW6bdaKbpIUqtidxx2z77zKQibg+iB9EBCYi
cQYS55sI7CcCR3QETMqqQQbXDD/Jh+Gvd8GdHsYJc9qcrCA0h+Kq9e0YaUNv
FNPXRSxoLkGf2U9KXRTK30pzPxAgmlLHtKcLQ0nCnqc14RNw8wnTmGHfJKi9
7i1mEWY7LJQ2TQH9QiigqjD9iIQcDqMzPF0VGN9mKFpDN0IyGAkjkTBJRbKE
kKwnJLuMSHzpqVr9E5DEvX54c4jFpKuWQQgKgkYI0Zhix1Jm9qI6HvzHkhKP
EP5Wig800CRS0dEU4vXjLqxVGmt5TH4gFmLu4Ci9qFbFK6opqmcgFo8y8XVX
r/qTgVhGpC8RGUVEZiJxARFZRUS2qkQOExFJQ2VECgGiPwfxfjY+Ha/DEbQ6
QH1IhBKLMXbMt2OTjYUbxQLwsOt5NNL1IYVkvciFDUoLbc1DXkkvRuXRR0wP
HO3gczmFbCYmOYu55m9oIiep0AYeHb08/szEg65c12msk1IZlSyiMgQJrBmd
rFJ5kqhsICq7ScKR5Le/BuPLqcq0xGAEG333sSgnUoSI5Nixwo49dpy08JFS
9NkbP9mICW8/GJNkXR9RaNVPelvtQjLpJ9SVsTpRTMx6vhbllTIl4dmSyRdd
kXBPEW0aq6JbBuozMt0R3w/xQ4nMFCTOQuLjfBxj4mois00lI8Q1BqTbXwLy
zUx8P1+dbagXYYLo1ReJQwgnU5TIjLNjoR1b7ci34xkbVkKmU5q/hWl02Esh
00TtDQplmrXpy9U2/fLcwpLp7kB/o+6VT7qXJld+bClXGsn8kYlPunBdjYui
pGk3FJq2wqeB4NOf+IwhPrN1fDYSnz1IsMYSHQDLAxXLj4vwyzKdQqaTXPTr
pJj78EXiYWN0uBKNYkRnph2r7dhvx2k7rtv5gPptRYLiIzTMjtQPFBo0a+pX
aU39QnkVjRL++cSKuXlinqVe69Lrkg8bBeDzeyZe72RQr+NEwkjnSIJSD6I0
jEdICVOJ0kIkLkMibIwN6gZP5y0fdH5fHVhnsey+MzrxLAiG002AJtqx2I4d
dhyx46Idd+x4y45PbMhFqBWnslrLo3ASsiXrFPZVtWYtBDg52TRfxJqSFhk3
ECrXJEnlUqekexVJS/VYUMrEb5moftIiURRrShQRqzjGagAShhOraUgMilB7
I6GR1oT4wPMtnFOhZBaEMDgoaUe2HXPsWGfjsdlZO27a8YodH9jxpR3f23DM
oFryH8vQm7cdYkFBkq7POMoYEZyZVkg69VmffbCDz4gU6pY2V1nTIMXqDj71
YqLzn0w4tqLyAVWe9pUQelXJwQpGPYmR8J4Yic3yv8Hm0Q4+Y08IYWalRd+x
R3GignJpdhy347IdL9jxth2f2fGPEPwYgt/sKOA9GFtgKqk0Dkf0JscaY4Kn
ZxSSSj2ha011YBHpWmLWsaQ5GpRhKyq/ZqJdPNrHwbESFXehSp4p32PKtWag
LmNDRKIFkWFWRE4VnohnDzz7VS7qWsV6wYUFvIxFGXRZacd5O27b8ZodH9rx
MAT/CsEvoXgUCk8ReEJQwIzPR6FJDCJaKyqj6EhOoLw0b/2H89b/0hxrBvJ6
3DEqg6q9HBhmUrPEzG+9tmjQfY3qPGPwSybaJKJNAtomsFqa4UApoTNXPWJK
5NxREjnMU4hAlJ7API1AbFAEjg7E8cEWBDy5iMxAZC/DGsjM7Mz2JZgfYPxz
dly14yU73rXjvh3fheCnUPzObG9jxoe9KPj+FXz8ellj26E0HC11fcfJNBxN
NPBHJ+DG4z7aDr8MRjj4UCa9omWhKEr6rolBqxS0SkJrvkoNw2HjMIprWjLP
z5yR8zPM/hF/2f75fZGN1HXIWo2s5chagqx5yNLs78mD5ylEduWrKqMst7wd
zmw4R6NcF9gYAd5jfMOOj+34OgT/DsGvsDH7cwPZikFYSsmblDLXQ41pHI3o
LwpFdyFrvAeLxlteo8m3/SnCqiO0FCFsLdUJW9ogP01U9C/q/pyJ5i3Rojla
NkXLVLRKRuvGaN3Q6xuODai0F86nlOQL2T9cs//kIOz/gbH8szplB7K2IWsL
sjYhawOyGI5VKo65yBKWLwLnKDjHwDkezolwTmHVDxEIseM9O76w458h+Jmb
BnZW/IvSC0SBq7vF+eeCoqKNKKb24gUO0WMsyZEIoVF0F0dTGnixt8G2XpHM
N5MYoamMVPUtbbE+WWwMJPT+lImmHfgc62Zt0LwVWrRAi2Zo2cTrKwxObCQc
i1Bhm+IRtSyJ7AmOyGSk7kP3vcjag6xdyNqJLEtAy5C1mAAVFXWS8AznWDgn
wDkZzqlwTodzNpzzVVbMWz7NVv8L5XwYKhsDxTnZikOsEloCHvYqSUcK2JEC
hDJWxVFAr9Ol8Zmiuyg9SSFKip7kOMoDL/W254VkVkvTwWYbdTBJk/QKxD6Y
/ZjB199L7YwmHdEkDU3bo1lbNGvtda76MTTbiGhVNtPaJGglmWgNlWmx9iMX
PQ6ixwH0sO1Hd5QW8Har8LYb4a1V4bEazMn3fXOOJL8ap/iVMwfOmXDOhXMB
nIvgXIpyQzk88i3mbd9TG/+n0s4Y6NlLUJtTkpNlbyxCZr8rDU9p/Fka3wlq
pRVqiaReal3MiZQQXqEGARdnF9bborQhS2L1M6GY6RXMDy0VTBO5f2cgqSeS
uyO5G1Iy+NSl1E5okq64YF2esVO51fib3A5j6GG4DqH/IfTJRU8NI6NoYxBR
3hdG1csm6bxsHpwL4VwC53I4V5Ej2Qkbhce/W3kbx0W2ZKwIFX8LIV6PSuM/
pfC6IKbom42Nnc0plBzWYobrC3wQk2da1dF8TRutNNeBVaqepgwNVAdyipG2
PzUxac46Yt8zYgOQ1A9JfZDUC8k9kJyFlEzFAaPCofKyaKeC58Ui5Rxk5mF8
HsbkYeRhDD+MISq+3gwfbIwewgS/ffTao/LbQfzIseZ4Hcu5As41os2Ccxef
11VuCut/Cmq/MmQqNYQwbMXUF2dnY+y4jym5M4942UoLj2Pu9lBr2VSP0+RQ
rUMqksjrlJDDtOJjAH5R+hFMiuqmDhI06KFmjdqYv/kH4zccSUOQNAhJA5HU
H0l9kdRbcUOaOa62aT3/Bj0WZedjTj5m5iMnD1PyMDEP4/IwOg/ZAuYhDDyE
fgImsSyusRSN4W6OkLnXajjXi/qQRSV74NwPZy6ceXAeRbnZxC8kFH+IXpDk
c5ybnXMrquem+twPoo40Zj+bUH+1u9pfFZnnjRSUFEwLjpkWp0dqI5k0JU4b
ISgppX407EeZ+KYrksYgaRSSsgneUCQN5noHc8ToFl6djfEabuKV74PXZ6Z+
6SnWGGBJPhbl4/F8zMvH7HzMyMc0E75hhzFYj0/4ov0AujN+HBSfDcVjlH1w
HoTzMA9gncfhPAXnGTjPwfkMi1FUch4tgOTU7AZqpaiF0yH7oxQ+EH5W1kAt
gSRU0ckdokrcLDDZMowHJudnBOltGrkIbXTT4w6sI3VOGy9ooaE2J6XBitxX
XRHdDUkTuQ6WNBZJownhCCQNU/ysvn9uF3xxm6Vw+5X0hBxk52FtHl+cYEU+
lhLGJ/KxIB9zdRgn52FCHsbmYVQe3BpG4VulOULnITjz4TwG50k4C+A8C+fT
cF6E8wqc1+G8xbBRjSm3bSox0abxSYtKGPKtTR37NKQ9+iZBjK8pybN3LWnC
SR8a+iQkbxaPbBfxyCzT3qPF/POqqR/xJPQ6w5hBnZr6S1OfmvefmfiyK197
MroHknKQNAVJk7jQnDROsKojsVrhg9UrflmdzmahyM7D2J6HLXnYlIf1eVhD
6JYTusU6dLPyMT0fU7lJEXaYQ2MxzKBDGKA603k4L8B5Gc5rcN6E81k478D5
Ipx3GapQTkqKQLRIsWJp8q3S+KUU7jI+6S3UreI6oH+qms5rQ1NPRJdZpLxX
D1JCkGsLCsmoSi8aB6VX7zRN9Z5eU/WjeFPe6POuYvVLhESzlmsOkmYiabog
VPu/QujPDZiKnFwcPIT9h7D3MHYfxo7D2EbANuZhHQFbmc+BPUne46C2TqGV
h0kUuIylwGUEnFfhvAHnbWLzApwvoeo9VH0VVd9A1bdQflsRri5ZeVJFtdr7
k31Henvdpn60dd3QNNq+NVXtRg+kbnSOLsw4MUleaUcwCrWIMjRGYqyUpu4d
V2drSwqrH0a/Z+L9zhD7pBQUFOjjCUFmvkSmhULm+SDIPNqCKZh9EMcO4kgu
8nNxSAW15zB2CVDEpHIeVhOlZYwStWoL8zFfC0o0UByI82UC8joHUu0dVHsf
1T9EjY8R/qnqRxKfEC8fVs19z75P2XdRv7tgpro3nNZjFgq4iCgOsIhiavB8
KAp0asqTmMcoxD8xnJALsHVNAqzvxNG9jmIdYE4nMjCdrhZ0vrWiUzAOe3F+
H87uR8F+nDqAEwTrqVzkEZeqKilWAW6lCnADtV2rqe1aZgpBOCyC8h6qqVAi
7iPyC9R6iOiv+fXIg2TvqaR6z++l8HaHznyunWEHSG3/PrE3e2+dPL5Mixym
m/abCkCoijbOSq8NSgMOteG3skRuTB55+dTU+EzxwedG0Hwe7UDBROzGlT24
tAcX9uLpfThHZMIP4PhBHCVWh3ORewgHDmHfIV797dThWm8VanBcfNQ1wxL1
ANFfofY3qPMd6n6P+v9Cgx945FCE+lrFSXCizrBCivpRFcmRvmbnidmuBlra
botig+NW8MroWtBwYVZhSelHYWmKoX54olfF9SWka6TsKqnq/11Snj0Yi5U7
cJvCKkTqme3Dmf04fQAnCduRg7wyFNh4q6Vi01otOcxAnX948cT9hPifkfAr
Gv4HUaeKESmhC1K3l/tTZdWffuRHu6zUJiYrqKSNHrOU/ZiVPLkWN1ydX1hO
WeroLL1KqI1c1FY+EEN4/SQ8fs1UVs3mnKpacKpt4tSzEJxEHB2zFS9sw53t
eHYHbu3EzV24vhtXd+PyHlzci2esakZB7pAu3tilxhub9fGGl1Cj35H0B5If
IdWDJh7uW5yYTa35hAr4iGMiJdjRpps6k5wmKhuA6TfQ7oy2cWgWAQofsln4
gNuLC9tCaeO2zMqgounGBqXp/pIJlVUVxqrXf4mVoFTfk4tsbNyAVzfilU14
eQvubsGLW/H8NjynoruxC9cCoeONmopuny4C2UroNngRNfWguQctPGjlQWsi
FsbJlG2VJU8kZ7fn3QVUt5ll+zxWeof9k89WUIMH047zRS3ZeCNw/cgtvQZo
qdr6YfNzptJ7rSTIjDCS2VtIMoJJnD4TOBxb1+DttXhzHd5Yj9cYqE24t5mD
eokc7PntHNTtHbipgrriu2o8qoLSWrQ9WoumAGnrQTsPOniQxhdwK0tsGCXL
+eMSofS2XjZFMLi1CB1uIOw8lyfDZP8RjOQ94bUIPL6HOnrLoPOJcY86nVZh
5FtZ/ykTYmycLz6nGZ8OKp8BVnwWK2QaSZlyxqdgBpbiw+X4YAXeW4V3V+Od
NXiLcL2+Aa+RUzFcd1Vcoj68vZPjur6LO5V/XPm6AERpydDRg07Mczzo6kGG
BykF3ItKcVJ8dIQ29cE8b1XjlZ4OO6dUnAcOK5XA4R7CnkeYwLWXeaXlTjy+
edX3pfGJ0ZA+dVkrXmZYmxmsuACwRGSQIrVG+pz66Zl4Ap8uwidL8PGT+GgZ
PliO91cq4JiTvUVO9rpWG2721oZ3dLVhkA3ZYa0hQ2oBenjQ04PeHvShWq+E
yks/Y0Ke8q9SY0E78SqFeQU8Xb9GiSHeRtjrCHuZwF1H2DmE7UaYnMMPwK2O
foSXXuHTa7Pa+GI/+ZAfMgoHjTyquXAvcxChx/bnUZychTn4fB7uL8D9hfiM
UVyMj5fgI+Z7y7jvcYrke4aqcqO3qtTatNv6Nm2PX4pTkePBNvTzYIAHAz0Y
5MFgVj0W2BTVlv/LR7hs62yea2GaN94+g1Z15LWjDQV87VzGUg0vaKuPxxjO
1wjnHcJ5FmE7mB/Ko14D8IwWs+xkBVBSbC21dmN+5F8ZQcEUHPvqK8uANH87
hh+PojsOTMeXM/HFbHwxF5/Px/3H8dlC8s/F5J9+K1apHWT++dyOQO3gFMzh
QId4MNSD4R6M8CDbg5EejPZgLHPLAnQtKEYZf+qEfaOfSeNrYYe2mWBImQ24
g4YIsiPb8jTJ6ali1w8z3GsIO8PIyuPNA5CN1EacmXVDoe2KdRa8WrxVFkVM
IxNYV1phFX5pbgKDpPrNEXTBgQl4OJn/9YMcPJiBL2fhC3JfBbKfSniNtxLW
t54vSq3nLl3ruRcXCji+bSbdMEztqf0sZkb5mffBeLIQlGpZMgDjWOARnlqW
e2ruGJybrtv3o7y2O4+g+hxR5Sv9yvOVfVOlfkJNoZOM0ImN+4xioxCEA4r2
YkraAhNVepzW3rZywl+k+uEhtMcBNx6OwsOxeDgeDyfi4RQ8mIYH5MZfzlYg
+6ujVxnq6NcD9TuuC7A+uTInvW+e1SPNUGjRnbgSS5ltGF8/6pmZ+n0/tG1d
NLx3Ce9VhJ1GmLxiAKn8kFfbravSrWbWKbWBopKULA+hNqXQvu6qoKU4p7Uc
A0lclwfL9YND4P3o6NP98aULD4biwQg8HImHowkzc+RJhFk4chC19fvG2po3
xaba+vmxWGljYA2ZmLKqivxPXzPoNLBNujOPYkztnGFFL1P2Yr56Za5574+P
jVRfJarPEtVTCJNXrAxAtYp+jJ3QNsXihnr12TpBYEq0iSLZPj/ZR2j7d7Cm
Un+7mScZu7PwWS983hdfDsSDwXgwDA+FJ4/Bw3HkyX+pulYo66vr0VjLyRr8
tazqr7+Vwuu+5n2J6RDJCtlQzrKCl+y8Al+bE0hw31Th8rVjC8m1YpZJCdXG
swrN+r3YAFkFopn+RVeqf/83mGrSCeupt2dk12fg3Qx8lIlPe+B+b3whvHgI
HgzHw+zCVdafmCrrd9eo3aJsbATnihBNDVX9tozqtw/1E/vM85IaZhHZIhLZ
As9uVPKz+YS2sQHj+w7x/Qtky2vj9DTtVBoVyzVuKRtBZAXRzlpC734XPBWQ
64LCcyWcXHhJp+59Z+reZ3rQzYPu7JvfzMD7GfiYuXFP7sZfDMCDQcbKepxS
WXvdOJjKeiXeZW0skZV1bs1rfzCsnTXagi7XfXgbW4wDLa+x3YXKAfcW0fBu
R0nTSo7WVLWIOEzoeNrc2O0VlUUZzYq4yFwQywwpwcSgvt3Jiuiov0c0XafT
qCC5BtCLNADWq+xPvUoXo/tSBt7JwIfMibtTPd2vkPX0AlM9zaCSv5rr4D9L
4UO+Hpp5JqE6Q43T5J5anFMsx002r8DXwkLGXS+UjUgs1psLQLKUNqrPUpEV
ajnFPVm+sk+/ZXKGF3UM39YYTvurDDMIXZaKrreKThMEtL6km/qSozwY48E4
hvS1DLzH6uVuVC/3MdXLo9V6eZKpXp6rq5cZRjv5Zkl10B6fa6arc/8hr5hm
nHIYk0EkS1Ksy8zne6l/GeZeX7GuzaKOJYbFhQJoodhGKrVoqj7f4SeL+F+G
2IN8jrHrSz43gPscV3IYu2EkArh1IsB4Dyb+SU9a0Q53Bt7OwAcZ+ESLn9SK
96GoeMdYVbyzqOJV2ZXT2OkG8P1aCndb9UNkGpQF1HTTERuMRkRn4lZK9FHm
FTDrmfcAsNyogfme3AMN9c+tSE91jJ+m3BKtFD6c1rgEh59UyK+Z/1Vmfb3V
I0el12tUH8OER3z7gBIqK5p5vtaOgxm4ZwyKrOvT8Wp9ypxPYaVl4UuTc30p
lgFn9o/sQJx000brZGutXmlSCdahOrOa77XKvdsA7IXDtGpNAEZ2Ma5vskPx
pCZHjNq6RS7ERy7RktC/NEJrTIQO+SA0SHWg4RYOpN+tRhCqpE49X2LHTppO
e0WdRvi5MbzhteUAfCnCG31tyds0lZK3BvyXtjN4q/58JePI9ojM9M4kZZA0
RtyTxFo7zIavBlpYni8VXShKRKaZXnY1yOhq+uMnv+kPhui/w6dDAd9jRO8s
B5uaNnnshG/biXUuKqlzzzfYcciOp+14lmYZfmLHNyH4IQS/hcIbqWRYRSoq
H10LJYYqv63t/d1nDh9VPm4NItsp80wrtVRUN+5NokdArVXZJQjX1n5lhrVc
bV4Q24VKJi3VmhSPNyiKaCHG9xm0VBone7OWQSWXsx5WGWAzq58Ky+paFu50
x73ueKsHPmQe0BNfmTbk/MnLqoy6etMyWp/mlB3X7HjZjvfFOgH66dB83CuK
FYNFRNIS+yVafOBRSnPvLt9iE+GOQ/nq4JFtOTAGyabSyr/A9+hRYov5qCmt
t8zMrF9vWb8MPfOs4HhFe8TeL6y/6/EwD2MvTS6dbpRLNR08QIbDmGn88P8I
XFviVpq4jaKVnjbT6jUX1OU3PhVLCoRaz5miXreIRZKxm6KKssV4lkK42E98
m+CGSElTNvTuMhl9aG/SLiP4KuGVYpWsfOiYOd4d4k5fhYjww3IQYbnuMjO8
tGj2m3xYT1U5I2XNLlJhF6L2wZsL1SxbXQbPrIVqSrdFCsM00fH/gts3bWm1
0ZLqelAr7dhnR4EdN+x4Vbf8gJiBLc8BNsy8cSZjPasgddRYR+yTynCnxCOl
hbJxd4ex6sbAYovSnXBNVjdaNO6LRSpKOdaeidVi9Sv7amsxM+PfMq2erezd
Z+ZHnTPxS0Qo7Iqq7JqZFc8pj2FOeSyqiBVVsL4attXA7gg1S6Etp2OVfvp3
xn8J3Ef+wIl1YoXHjaX1orbTgjeX7HjRjnd0ixf8ofc4voy3p7j6sun16cra
nFIn3NWQzZ2uEVLS+d7crbLRRdsQ2Lgro3eTOXXHLFKtyzN2AxGpX1PWvOov
48goaGtqM45rUd20SoKZXw2Pd1cz4mcX+lenMuzHMW1RdOtg+hf1TtdDQax1
Nun7jL8N6e0AkGinjlL62N2Oc3bcsuN1Oz5S1zf4j8WsX4O+HK/Tl1+pgQnh
mMLhJCClpXfH7R6mHUylDedmL8H8J/HEMixZjmXLoV/fVFtlVlv5V0+JGVpb
m5lrk/IIjBATH6cSh5TS4vvUMmA8GBaUZW82zia6oKE8YfGvw3glMAyxb4qI
LSbQElFanH5Xv9yBIbawnFMTp3rKg5rIicDsSCyMwlKOpDHtZa9uoC3tYirt
MCfthnXrFkaqa57qV53drK46q1/7l9n2AuIWI1yeHWxmUUnxFaEoMxjJhAIV
OIwo9lNBknf2YeGsn4t8LDiGRX6t35Vb/2vF+qVZ+SEA+kD8OTvepED8WwrE
LSMEa3/4IRLzo7CkFlZGY0NtbFe8QuxDT/v6Mq8YTF4hNjAV2zAado+jXa4u
6PYwt1zp1HL5X2ZV7g+BGTgUBkK5YACY7bn5K/G3mgXJPFH2VdegTf8UN/0h
zDuChcex+DSW+TV9mzLeNn6yMaa+RzH1gyDbeKPtWb/nvWisrY0tMdhVBwfq
IK8ujmu7yDfpx3e89m7la9pm0bslHG1Ifkm3IblYRtNycVP9crM8cJZH8Zlt
/5hiexEViEqIm70yf6vBPj/oGqzV38/FAczJw4KjeOIknjyN5Wew2pfVyyp1
vz4cvmjH8+oKW97GOYi2OUGbaFkbO2Kwtw4O1cXRejhVH+cb4JJS7mkn+KZD
kT6eNu41bj/Kd0007e6mL/d3bkAslGm5hKm2sCwr8cyavsq89zfqTr1VJLtX
4W/V9iUFa/F9mJWLuU/hcVbUT2FpAVaexZqzWH8Gm9Rtg8niX7UJU8r5NF0g
e1MNZL/Smtog65Zf6uBgXeTXw4l6OFsfFxrgaixuxeH5OLzMS7m6r7t+/11t
M9EVhwzbtbFSXmAq5WLzcMu1SYXJsxFp6nXIsa3Z7iWUtreald2rss/BGH0X
ZhzA7MOYz0r6CSyhkr7qLNaexYYCbFaN3pEZXeS0StowwI5tdhylZeREBPq5
2p7+qa24YNdWXIC+VdV0yTgq5J+zoK0+nm6Ayw1wIxbPxeGleLwaj7cS8B4v
6urW7WKPam2nXbFBqLaR4W5R1C8pRV1sfXxDt1d4MmqIpRLFspZjVAD9EdmJ
VZaSpeUevdny6l67tJ8G37Nab3lnwejAZt+OaXsxM5fPCObt6kle3FecxWpW
3M9i02lsOcZO+ZGbnXIXJWwYocaUtymm/FivZvkt57W1OY31cbEBrsXidhxe
iMO9eLyRgHcT8GEiPm3IVdeveWlPNew2zbf5XEbbfG7HE3tpc8JjSmnPu4Dj
amnXdjZeuQx1UGBrwrUa/QKVYjHRRkhj9pZHkMn2tpvsHaLYu5ZoVSsYavYq
rOdoaewfVGNvwZRdmL6fF3PeklIxX3aGVy+8mJ/B5pN8escOPGwtxryVpNjl
OK0PJwJGWYyCT2tH6+YovhGLO3G4G4/XEvB2At5PxCeJ+Lwh71v+oxG+57lc
UcbbqrtJq5vgejfr1O03mPs0jlzCqas4p5ZxFtwjhGydyiO7aG25yVaIKJSt
Q7TfKJYWK5uH83i+ghrPVwzO2hswaRum7cHMg3xiLivdvAUtoBb0LNadxcYC
bDmObQeYwUmVLl6R72awUI0O/etHhrayllqyv6JK401WaSTio0R81pAL1N80
wj8b4d+N8VNj/JqE35PwiJfvJnxdG21raLGN7aT13j0DWfnecRr7z1P5vsLL
9+NambanclunwJNMrwzUZTVLIjyxeMSKjDxLR9bcha25qeuo1g3JCkffcIwM
R1YF6iuVU+vugvEBzLwGEzZjyk7ksGaTRYiWzeYpbH0K2zczS/NaxF6Rb9hR
FmkUDn6gST5BRYOaCv5TAt5JwAdUZ3zRkI8M+64R/tUYPzbGL0n4jbX2dmYa
lFeKdjuk9lL2d+49W9mHVmyluZQV7SO8aO+hoj1jEbcyL8xk5aKalVmnpTE8
rAcZD49pRyM5Q2iuO2JUj2b2Zi/N4DnhWBiOVeE8qp0UAbJ+SbXHWu10Nng1
vtMnhK8JwkqMW4+JWzF1N29GWcBo3YyewLZc7OBRSxHOoGglXuK3WCk3/tpN
lNIJbqyY32/IFyz5lhXzxryY/5yE/yThD259OzMeHmNm5JJcU6R2hZZa4rvN
ik0yd2ARK/B52HgM4+aqtrexP7Lxvw7VLN8IngSIKE9vVzmnrlre41HXzSTL
JwvLy2avia0x2B+PIykoaIlLaViWjBd64dWBeHsY17LvT8DDafh2NhcKjrpw
fIgucg8EZSlGr8b4TZi8AzmikWXOwRrZU3Iju5UFbruwg/dXi3IuxSrD7YS7
KtzVMdqGXL+ajVYLldBGMFCdo/cGXufYFB4hvFSXVryiPfSJpGFLlF0w+03A
4KkchewDAoOoaUxji+TPgoQc1fAMBBozGnoOq00cbmb45CBLBiYOfxg5PIFR
KzB2HfkHa39FmKlrf1fp2t9trP0tpfpHKeYfVYhDNYysjnHhmETyyxwbjllq
NoaaqphuBba7rI1VPYPqJZtCws4Lewlmae4hzZCaQYkiNfmaPpRD8FcPyXW7
NQO59SUGjdIr/F9Yfz5GLsHoVRi/EZO2K+2xFm0+qTqC1h5v389aieIqgdKM
gHCGauQMJEVOjcDMSCwgGWZVNDaybpf/9rmI6hlfJlELnGz0hiKcQQgzdO0o
1E5ATDPYqOizX6fSC9Y1kaxKyrannhRpyTYlkkHDARX+d609C9kLMWo5xqzF
hC28WWbh5ixNuDmFZeZmeSN2FFXtHVZZV+Jr8BI/uSamR2BuFJ6oheXRWFeb
3/zuOjjAeqohLBrxuVaTWvr/HY3TemuXVuMXH7WKvPaPPC5VWFVeP5J2q0vk
PaD/NdPmwD0P2Yu5tDdOjS1nHJTVmVVqWVYaW+JPtq1oLMtjamBiTUyLwKxI
PB6FJ2thdTSfQrsjBvvq4HBdHNP6pOFYFsqXvPWYWuJQ/ZiAZKWk+rByEllZ
qTfCJfuVtbRyMaXsUn+H6zDB2/WPoO06Ce6ZcLNwYBnGUDDJ20tTMLlCK7Wi
vdyJHXbVsk5dqR1VA+PDMaUmZkRiXhQW18KKaKyvjW0x2EP6ylP1cLI+zql9
0Gfj8GI8XmFRewS2FeFT1Yx1h7LuaXHkGmzrOz6JkiwpxyvCsnL8yHO7iGcW
/u/adizc0+Cei+xFPAGqjxFn62JEuQ08jB38dsi21UUbKBJ01TFWbQOVFEQt
rKmNzTHYWQf7hR5bD2fq45kGuBKLm7GkXcXjdep3slj9E4rVv4rCYdCqwKoS
U5zXt7VRoNa3QdQT0UHZWd6znuzMc0oGC0/0YeGtgS2cDfdEuGfAvQAjzQFf
PgV85nbuGLaTdSP0kZ6ucTPkGFT19YimvjbAdUmkSsTHFIg/MAfisEczSzPj
IiRFbdGCqCHqSpYrbWnfUkoNQaW+HrPr37foELjHwD0F7jnI1kK3LRS6adKJ
SEKcMbZlIdyikaaYTbRgcyKVFsybP7DSWjU96h29HuU/mvZfH8RKditlaUe5
9PLxAujK7Pl3LNkf7hFwj4d7OtwsDHtSDsO8soix6WJ94W3Mlr7bqwX+26tY
rqFaKk4PNcXJ0E/002ppPt+A+XyCZCXZu4Utyyplkny9E7OhP+sdsLbee7no
BfdgvraDezLcs32EVZZqB2ugTA0SL4SRPIxapGuQdls1SLe1BikB70oyErn1
T1oQC30pLBXAnxsHsN3/kO3kGJaU5Q7MhoW1Xgbc/eAeDvc4uM2R024lcrKW
KVgTJBobtcjNphDJ29jEBGhs3tE1NhbCEIL33pSgrCZrEGS1NsxqwdsrnS+S
6XbBPRJuFhHNsoqIrBQExWNF1BPBo575FPVobQeLenKDazuEiGNwThTGO5tK
VpBjHGGr8op3Ug3XktkoGOu0hrsr3H3hHga3PqZhjYM+pjH26726Omsc1BZg
md8WwFdGQtNTFA1X6kEG8r2WkiXk/TuFZWRNnGL0psxC/m3TFO4OcHeHeyDc
ltHIdm80ovW6ZRVc9KSNtflptTa/GTB/oLlW8J7VVnpaeW8mYRM5+0g24Vpe
wTRra6TA3QruLnyhOPdQiiSmqpHEciWSUJIwul6xXH0f5Y5jWTs/a6qdpaDr
p8K3ah2kZ5T7tsISlfR+07BghvzgjeBuAnd7uLPgHgC3G+4Jvht+0Wc94W34
vTWvqWJVMtC6itVScZejokA+0TGop5az/sQ/9OQs73NHIQ1FW7PoNrI30geg
4zJqpH2kJOQgXK0S5ZwvVYnBxSu+S3hXiyf8H/aRP5l4OqfCVMvfbpsKFxcE
+VsN9lDZyBzL16uXRH1Dh02oOFZ112dq3SUHDionexCls5v0FEVMTyGvQ1ad
PkfxtWk9/EFK87fK7GmkDpFUBeVih1rDeHuKZH9D412YMtZTurNQ071Xl84Q
z8LuVbn3MvzN0ZqvSjZAdDrMVYWa7tPnQQpVXhqK8tJXupcQ093WUMpLVbW8
KHf5GH8LY3dpzvewvryxDxN0C2YoBf0D3ltN6YzK0j2W42+l2D0K62mjC/Zh
h582RL0vvcVUvo8wSPpOu+muIhSLyXdTnr8Vo7tREu/52LEWOwrLbJh0BzbT
Hch6UEWphNGdhLLPmhckBY7sNTb12bluP/cA1JKOVpAs4eBvIXMxRohquif3
bfs49q2jyaH0+XqeaxPfGa1Y3fJZQ9hnoTDFiNyGfwuP8/M9MdKzOaTvK6fa
dh99H3tobsZA9pxIBVy7qmbJOspTOVQLii9SnmoExorz66CguK96KVHYbqru
vr1PU096mvLS05CXh/B4kP5jPxT1a7kZyv2Kq9e3vLq3HJTlb/zbdKWIvo19
h3j5s9lsQ5lr4MNSVJvatScQ2amQGFX3Y5fm5R4hemPNNTxFnK+nYN/Ag4AS
6lOILxEzrIvURoFknDkeMWZN5MfideWVrytP8YTuPouqJYL9KoKuPUv5e7EW
VaJ0V7WlzznsjRdhsf91Q+morGROVq5NmQ80Uu5NPmu8chbZGEnS0Ujp8yjl
DqgeRLJHp5DozhqhXLM6nZUqHZVzBkOUsykiRRPpaHXps0s5m56D+oo29Zt0
Z/VV7pPURzSXjspjb3sq16RSgRbKNeWzuilnkd3RSjoqz/3orNxBMp3dWjoq
90fSlGs3o7PbePT1nvestspZ9N1oJx2Vx460UO6AzkN75ZryWU2Ua1IcTffh
L2uWpJxNMSnSpaNy9idROTuLzu6o3IF8VgPlPnvRWZ2lo7LOqc4UpUgCXZRr
ymfVUs4aRGdlSEflfnO4cgfUCiNTOir3KKsq1x5JZ3dT7kA+q5Jy1lg6q7t0
VB5bVV45m9oM9FCuKZ9VRrlPqvfRSzoqj7hVx9POpLN709fK7V8x5Zy5dE4f
5Xv1o9Btync+Tmf0Uz4toU/4n/8PtF7wDA==\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->173925011],

Cell["Nested transparent cylinders:", "ExampleText",
 CellID->389159735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Opacity", "[", ".3", "]"}], ",", 
     RowBox[{"EdgeForm", "[", 
      RowBox[{"Opacity", "[", ".3", "]"}], "]"}], ",", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"Cylinder", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"0", ",", "0", ",", 
             RowBox[{"2", "r"}]}], "}"}]}], "}"}], ",", "r"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"r", ",", "1", ",", "5"}], "}"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->310803497],

Cell[BoxData[
 Graphics3DBox[
  {Opacity[0.3], EdgeForm[Opacity[0.3]], 
   CylinderBox[{{0, 0, 0}, {0, 0, 2}}, 1], 
   CylinderBox[{{0, 0, 0}, {0, 0, 4}}, 2], 
   CylinderBox[{{0, 0, 0}, {0, 0, 6}}, 3], 
   CylinderBox[{{0, 0, 0}, {0, 0, 8}}, 4], 
   CylinderBox[{{0, 0, 0}, {0, 0, 10}}, 5]},
  Boxed->False]], "Output",
 ImageSize->{229, 244},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->281605631,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2497],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Circle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Circle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sphere",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sphere"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsComplex",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsComplex"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RevolutionPlot3D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RevolutionPlot3D"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27711]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4515],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Primitives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"]], "Tutorials",
 CellID->595610080]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Cylinder",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Cylinder"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->121248503],

Cell[TextData[ButtonBox["Graphics Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsObjects"]], "MoreAbout",
 CellID->399669626],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->25093448],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->398356127],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->732349963]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Cylinder - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 19.1144308}", "context" -> "System`", 
    "keywords" -> {"graphics primitives", "cylinder", "tube", "pipe"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Cylinder[{{x_1, y_1, z_1}, {x_2, y_2, z_2}}, r] represents a cylinder of \
radius r around the line from (x_1, y_1, z_1) to (x_2, y_2, z_2). \
Cylinder[{{x_1, y_1, z_1}, {x_2, y_2, z_2}}] represents a cylinder of radius \
1. ", "synonyms" -> {}, "title" -> "Cylinder", "type" -> "Symbol", "uri" -> 
    "ref/Cylinder"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10643, 340, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->173860774]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 420677, 8058}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2749, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3372, 91, 1573, 37, 70, "ObjectNameGrid"],
Cell[4948, 130, 3076, 101, 70, "Usage",
 CellID->10869]
}, Open  ]],
Cell[CellGroupData[{
Cell[8061, 236, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8539, 253, 323, 12, 70, "Notes",
 CellID->10165],
Cell[8865, 267, 227, 7, 70, "Notes",
 CellID->1903],
Cell[9095, 276, 157, 6, 70, "Notes",
 CellID->30973],
Cell[9255, 284, 452, 15, 70, "Notes",
 CellID->27791],
Cell[9710, 301, 278, 9, 70, "Notes",
 CellID->2516],
Cell[9991, 312, 615, 23, 70, "Notes",
 CellID->6149]
}, Closed]],
Cell[CellGroupData[{
Cell[10643, 340, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->173860774],
Cell[CellGroupData[{
Cell[11028, 354, 148, 5, 70, "ExampleSection",
 CellID->144956072],
Cell[11179, 361, 68, 1, 70, "ExampleText",
 CellID->20295108],
Cell[CellGroupData[{
Cell[11272, 366, 349, 12, 28, "Input",
 CellID->259402621],
Cell[11624, 380, 8936, 154, 217, 229, 7, "CachedBoxData", "BoxData", "Output",
 
 CellID->369603596]
}, Open  ]],
Cell[20575, 537, 125, 3, 70, "ExampleDelimiter",
 CellID->329224730],
Cell[20703, 542, 69, 1, 70, "ExampleText",
 CellID->733062],
Cell[CellGroupData[{
Cell[20797, 547, 871, 26, 70, "Input",
 CellID->11206405],
Cell[21671, 575, 18155, 310, 131, "Output",
 CellID->3638935]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39875, 891, 215, 7, 70, "ExampleSection",
 CellID->7007],
Cell[CellGroupData[{
Cell[40115, 902, 243, 7, 70, "ExampleSubsection",
 CellID->559797865],
Cell[40361, 911, 92, 1, 70, "ExampleText",
 CellID->538508358],
Cell[CellGroupData[{
Cell[40478, 916, 319, 11, 70, "Input",
 CellID->152448279],
Cell[40800, 929, 6996, 122, 176, 226, 7, "CachedBoxData", "BoxData", "Output",
 
 CellID->758255035]
}, Open  ]],
Cell[47811, 1054, 125, 3, 70, "ExampleDelimiter",
 CellID->862699776],
Cell[47939, 1059, 73, 1, 70, "ExampleText",
 CellID->25794299],
Cell[CellGroupData[{
Cell[48037, 1064, 720, 24, 70, "Input",
 CellID->400768792],
Cell[48760, 1090, 8310, 141, 159, 128, 2, "CachedBoxData", "BoxData", \
"Output",
 CellID->61645369]
}, Open  ]],
Cell[57085, 1234, 124, 3, 70, "ExampleDelimiter",
 CellID->40505955],
Cell[57212, 1239, 77, 1, 70, "ExampleText",
 CellID->2637737],
Cell[CellGroupData[{
Cell[57314, 1244, 604, 20, 70, "Input",
 CellID->449711130],
Cell[57921, 1266, 9901, 167, 189, 120, 2, "CachedBoxData", "BoxData", \
"Output",
 CellID->741128463]
}, Open  ]],
Cell[67837, 1436, 125, 3, 70, "ExampleDelimiter",
 CellID->488965400],
Cell[67965, 1441, 206, 6, 70, "ExampleText",
 CellID->205960977],
Cell[CellGroupData[{
Cell[68196, 1451, 93, 2, 70, "Input",
 CellID->285743169],
Cell[68292, 1455, 7351, 126, 194, 92, 2, "CachedBoxData", "BoxData", "Output",
 
 CellID->34164968]
}, Open  ]],
Cell[75658, 1584, 124, 3, 70, "ExampleDelimiter",
 CellID->16614001],
Cell[75785, 1589, 195, 8, 70, "ExampleText",
 CellID->20615673],
Cell[CellGroupData[{
Cell[76005, 1601, 782, 25, 70, "Input",
 CellID->503772365],
Cell[76790, 1628, 5003, 88, 199, 167, 4, "CachedBoxData", "BoxData", "Output",
 
 CellID->221028928]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[81842, 1722, 236, 7, 70, "ExampleSubsection",
 CellID->46435114],
Cell[82081, 1731, 96, 1, 70, "ExampleText",
 CellID->34807083],
Cell[CellGroupData[{
Cell[82202, 1736, 388, 13, 70, "Input",
 CellID->169402638],
Cell[82593, 1751, 13801, 238, 131, "Output",
 CellID->317022588]
}, Open  ]],
Cell[96409, 1992, 125, 3, 70, "ExampleDelimiter",
 CellID->557186039],
Cell[96537, 1997, 363, 12, 70, "ExampleText",
 CellID->95527098],
Cell[CellGroupData[{
Cell[96925, 2013, 360, 10, 70, "Input",
 CellID->267354076],
Cell[97288, 2025, 6795, 117, 184, 198, 4, "CachedBoxData", "BoxData", \
"Output",
 CellID->246724556]
}, Open  ]],
Cell[104098, 2145, 125, 3, 70, "ExampleDelimiter",
 CellID->591166596],
Cell[104226, 2150, 255, 8, 70, "ExampleText",
 CellID->515512134],
Cell[CellGroupData[{
Cell[104506, 2162, 621, 21, 70, "Input",
 CellID->224326090],
Cell[105130, 2185, 5686, 99, 184, 179, 4, "CachedBoxData", "BoxData", \
"Output",
 CellID->471899821]
}, Open  ]],
Cell[110831, 2287, 125, 3, 70, "ExampleDelimiter",
 CellID->493157315],
Cell[110959, 2292, 185, 6, 70, "ExampleText",
 CellID->358441062],
Cell[CellGroupData[{
Cell[111169, 2302, 783, 25, 70, "Input",
 CellID->227665862],
Cell[111955, 2329, 30454, 516, 131, "Output",
 CellID->84312977]
}, Open  ]],
Cell[142424, 2848, 73, 1, 70, "ExampleText",
 CellID->291906364],
Cell[CellGroupData[{
Cell[142522, 2853, 232, 7, 70, "Input",
 CellID->3405511],
Cell[142757, 2862, 1978, 38, 129, 127, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->304959150]
}, Open  ]],
Cell[144750, 2903, 125, 3, 70, "ExampleDelimiter",
 CellID->101004100],
Cell[144878, 2908, 283, 10, 70, "ExampleText",
 CellID->94273435],
Cell[CellGroupData[{
Cell[145186, 2922, 405, 14, 70, "Input",
 CellID->36811579],
Cell[145594, 2938, 17679, 300, 131, "Output",
 CellID->110892260]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[163334, 3245, 222, 7, 70, "ExampleSection",
 CellID->7727],
Cell[163559, 3254, 63, 1, 70, "ExampleText",
 CellID->4437456],
Cell[163625, 3257, 283, 10, 70, "Input",
 CellID->12188379],
Cell[CellGroupData[{
Cell[163933, 3271, 1176, 36, 70, "Input",
 CellID->58746949],
Cell[165112, 3309, 25328, 490, 191, 5390, 159, "CachedBoxData", "BoxData", \
"Output",
 CellID->417078709]
}, Open  ]],
Cell[190455, 3802, 124, 3, 70, "ExampleDelimiter",
 CellID->20533129],
Cell[190582, 3807, 63, 1, 70, "ExampleText",
 CellID->27289629],
Cell[190648, 3810, 311, 10, 70, "Input",
 CellID->69733258],
Cell[190962, 3822, 306, 10, 70, "Input",
 CellID->258341605],
Cell[CellGroupData[{
Cell[191293, 3836, 1171, 33, 70, "Input",
 CellID->250350978],
Cell[192467, 3871, 72116, 1327, 147, "Output",
 CellID->186264372]
}, Open  ]],
Cell[264598, 5201, 125, 3, 70, "ExampleDelimiter",
 CellID->533025963],
Cell[264726, 5206, 335, 13, 70, "ExampleText",
 CellID->432756382],
Cell[CellGroupData[{
Cell[265086, 5223, 832, 26, 70, "Input",
 CellID->35075088],
Cell[265921, 5251, 27734, 468, 202, 12878, 220, "CachedBoxData", "BoxData", \
"Output",
 CellID->481076712]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[293704, 5725, 232, 7, 70, "ExampleSection",
 CellID->2658],
Cell[293939, 5734, 209, 8, 70, "ExampleText",
 CellID->332788306],
Cell[CellGroupData[{
Cell[294173, 5746, 392, 12, 70, "Input",
 CellID->503769331],
Cell[294568, 5760, 10746, 184, 218, 2861, 50, "CachedBoxData", "BoxData", \
"Output",
 CellID->90523192]
}, Open  ]],
Cell[305329, 5947, 122, 3, 70, "ExampleDelimiter",
 CellID->592859],
Cell[305454, 5952, 262, 8, 70, "ExampleText",
 CellID->618987645],
Cell[CellGroupData[{
Cell[305741, 5964, 511, 15, 70, "Input",
 CellID->374567681],
Cell[306255, 5981, 15629, 260, 70, "Output",
 Evaluatable->False,
 CellID->316338387]
}, Open  ]],
Cell[321899, 6244, 125, 3, 70, "ExampleDelimiter",
 CellID->738472534],
Cell[322027, 6249, 252, 8, 70, "ExampleText",
 CellID->624302783],
Cell[CellGroupData[{
Cell[322304, 6261, 545, 18, 70, "Input",
 CellID->82648641],
Cell[322852, 6281, 11355, 190, 70, "Output",
 Evaluatable->False,
 CellID->410814658]
}, Open  ]],
Cell[334222, 6474, 124, 3, 70, "ExampleDelimiter",
 CellID->58000789],
Cell[334349, 6479, 230, 7, 70, "ExampleText",
 CellID->96400878],
Cell[CellGroupData[{
Cell[334604, 6490, 165, 4, 70, "Input",
 CellID->913821479],
Cell[334772, 6496, 25266, 420, 294, 3511, 59, "CachedBoxData", "BoxData", \
"Output",
 CellID->12758413]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[360087, 6922, 223, 7, 70, "ExampleSection",
 CellID->1221],
Cell[360313, 6931, 69, 1, 70, "ExampleText",
 CellID->255829116],
Cell[CellGroupData[{
Cell[360407, 6936, 571, 17, 70, "Input",
 CellID->304936124],
Cell[360981, 6955, 29938, 499, 259, 4159, 72, "CachedBoxData", "BoxData", \
"Output",
 CellID->125437871]
}, Open  ]],
Cell[390934, 7457, 125, 3, 70, "ExampleDelimiter",
 CellID->173925011],
Cell[391062, 7462, 72, 1, 70, "ExampleText",
 CellID->389159735],
Cell[CellGroupData[{
Cell[391159, 7467, 779, 23, 70, "Input",
 CellID->310803497],
Cell[391941, 7492, 23854, 398, 265, 320, 8, "CachedBoxData", "BoxData", \
"Output",
 CellID->281605631]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[415856, 7897, 310, 9, 70, "SeeAlsoSection",
 CellID->2497],
Cell[416169, 7908, 963, 35, 70, "SeeAlso",
 CellID->27711]
}, Open  ]],
Cell[CellGroupData[{
Cell[417169, 7948, 313, 9, 70, "TutorialsSection",
 CellID->4515],
Cell[417485, 7959, 197, 4, 70, "Tutorials",
 CellID->595610080]
}, Open  ]],
Cell[CellGroupData[{
Cell[417719, 7968, 305, 8, 70, "RelatedLinksSection"],
Cell[418027, 7978, 361, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[418425, 7995, 319, 9, 70, "MoreAboutSection",
 CellID->121248503],
Cell[418747, 8006, 143, 3, 70, "MoreAbout",
 CellID->399669626],
Cell[418893, 8011, 161, 3, 70, "MoreAbout",
 CellID->25093448],
Cell[419057, 8016, 197, 4, 70, "MoreAbout",
 CellID->398356127],
Cell[419257, 8022, 179, 3, 70, "MoreAbout",
 CellID->732349963]
}, Open  ]],
Cell[419451, 8028, 27, 0, 70, "History"],
Cell[419481, 8030, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

