(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    428145,      10749]
NotebookOptionsPosition[    413770,      10244]
NotebookOutlinePosition[    415285,      10285]
CellTagsIndexPosition[    415197,      10280]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Representation of Solution Sets" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfSolutionSets"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"The Representation of Solution Sets\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reduce" :> Documentation`HelpLookup["paclet:ref/Reduce"], 
          "Resolve" :> Documentation`HelpLookup["paclet:ref/Resolve"], 
          "FindInstance" :> 
          Documentation`HelpLookup["paclet:ref/FindInstance"], "Discriminant" :> 
          Documentation`HelpLookup["paclet:ref/Discriminant"], "Resultant" :> 
          Documentation`HelpLookup["paclet:ref/Resultant"], 
          "SemialgebraicComponentInstances" :> 
          Documentation`HelpLookup[
           "paclet:ref/SemialgebraicComponentInstances"], 
          "GenericCylindricalDecomposition" :> 
          Documentation`HelpLookup[
           "paclet:ref/GenericCylindricalDecomposition"], "GroebnerBasis" :> 
          Documentation`HelpLookup["paclet:ref/GroebnerBasis"], 
          "FullSimplify" :> 
          Documentation`HelpLookup["paclet:ref/FullSimplify"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Reduce\"\>", 2->"\<\"Resolve\"\>", 
       3->"\<\"FindInstance\"\>", 4->"\<\"Discriminant\"\>", 
       5->"\<\"Resultant\"\>", 6->"\<\"SemialgebraicComponentInstances\"\>", 
       7->"\<\"GenericCylindricalDecomposition\"\>", 
       8->"\<\"GroebnerBasis\"\>", 
       9->"\<\"FullSimplify\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Computational Geometry" :> 
          Documentation`HelpLookup["paclet:guide/ComputationalGeometry"], 
          "Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Systems" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialSystems"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Computational Geometry\"\>", 
       2->"\<\"Polynomial Algebra\"\>", 
       3->"\<\"Polynomial Systems\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CylindricalDecomposition", "ObjectName",
 CellID->5494],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["CylindricalDecomposition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/CylindricalDecomposition"], "[", 
       RowBox[{
        StyleBox["ineqs", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds a decomposition of the region represented by the \
inequalities ",
     Cell[BoxData[
      StyleBox["ineqs", "TI"]], "InlineFormula"],
     " into cylindrical parts whose directions correspond to the successive ",
     
     Cell[BoxData[
      FormBox[
       SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->30562]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CylindricalDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CylindricalDecomposition"]], "InlineFormula"],
 " assumes that all variables are real. "
}], "Notes",
 CellID->23865],

Cell["Lists or logical combinations of inequalities can be given. ", "Notes",
 CellID->17554],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CylindricalDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CylindricalDecomposition"]], "InlineFormula"],
 " returns inequalities whose bounds in general involve algebraic functions. \
"
}], "Notes",
 CellID->20700]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->14121958],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->141216260],

Cell["Find a cylindrical decomposition of the unit disc:", "ExampleText",
 CellID->504489806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21351],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "1"}], "<", "x", "<", "1"}], "&&", 
  RowBox[{
   RowBox[{"-", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]]}]}]], "Output",
 ImageSize->{225, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38970276]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18442],

Cell["\<\
For univariate polynomials the result consists of intervals: \
\>", "ExampleText",
 CellID->339227672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}], "^", "2"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "3"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "4"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "5"}], ")"}]}], ">", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->87781740],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "<", "1"}], "||", 
  RowBox[{"3", "<", "x", "<", "4"}], "||", 
  RowBox[{"x", ">", "5"}]}]], "Output",
 ImageSize->{149, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->151639920]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], "^", "2"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "3"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "4"}], ")"}], 
    RowBox[{"(", 
     RowBox[{"x", "-", "5"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0.5", ",", "5.5"}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"PointSize", "[", "Medium", "]"}], ",", "Red", ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"3", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"5", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->69190976],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->715845405]
}, Open  ]],

Cell["In general individual points can occur:", "ExampleText",
 CellID->436863141],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}], "^", "2"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "3"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "4"}], ")"}], 
     RowBox[{"(", 
      RowBox[{"x", "-", "5"}], ")"}]}], "\[GreaterEqual]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->513746345],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[LessEqual]", "1"}], "||", 
  RowBox[{"x", "\[Equal]", "2"}], "||", 
  RowBox[{"3", "\[LessEqual]", "x", "\[LessEqual]", "4"}], "||", 
  RowBox[{"x", "\[GreaterEqual]", "5"}]}]], "Output",
 ImageSize->{199, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->157545642]
}, Open  ]],

Cell["This is the form for any logical combination as well:", "ExampleText",
 CellID->11011043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "1"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"x", "-", "2"}], ")"}]}], "\[GreaterEqual]", "0"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", 
        RowBox[{"1", "/", "2"}]}], ")"}], 
      RowBox[{"(", 
       RowBox[{"x", "-", 
        RowBox[{"3", "/", "2"}]}], ")"}]}], "\[GreaterEqual]", "0"}]}], ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->47990707],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[LessEqual]", 
   FractionBox["1", "2"]}], "||", 
  RowBox[{"x", "\[GreaterEqual]", "2"}]}]], "Output",
 ImageSize->{84, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->638328924]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{"Xor", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"x", "-", "2"}], ")"}]}], "\[GreaterEqual]", "0"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", 
         RowBox[{"1", "/", "2"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{"x", "-", 
         RowBox[{"3", "/", "2"}]}], ")"}]}], "\[GreaterEqual]", "0"}]}], 
    "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->556060682],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox["1", "2"], "<", "x", "\[LessEqual]", "1"}], "||", 
  RowBox[{
   FractionBox["3", "2"], "\[LessEqual]", "x", "<", "2"}]}]], "Output",
 ImageSize->{130, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->425916880]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->524425154],

Cell[TextData[{
 "For multivariate polynomials the result is in cylinder form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["l", "1"], "<", "x", "<", 
     SubscriptBox["u", "1"]}], "\[And]", 
    RowBox[{
     RowBox[{
      SubscriptBox["l", "2"], "[", "x", "]"}], "<", "y", "<", 
     RowBox[{
      SubscriptBox["u", "2"], "[", "x", "]"}]}], "\[And]", 
    "\[CenterEllipsis]"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->166815026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->362521927],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "1"}], "<", "x", "<", "1"}], "&&", 
  RowBox[{
   RowBox[{"-", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]]}]}]], "Output",
 ImageSize->{225, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->305026621]
}, Open  ]],

Cell["In general several cylinders will result:", "ExampleText",
 CellID->9733281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "1"}], "&&", 
    RowBox[{"y", ">", "x"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->748938624],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "\[LessEqual]", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}], "<", "x", "<", 
     FractionBox["1", 
      SqrtBox["2"]]}], "&&", 
    RowBox[{"x", "<", "y", "<", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{513, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->628882071]
}, Open  ]],

Cell[TextData[{
 "Plot the individual cylinders using ",
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->706868372],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c1", ",", "c2"}], "}"}], "=", 
   RowBox[{"Apply", "[", 
    RowBox[{"List", ",", "%"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->26486982],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"RegionPlot", "[", 
     RowBox[{"c1", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "50"}]}], "]"}], ",", 
    RowBox[{"RegionPlot", "[", 
     RowBox[{"c2", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Green"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "50"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->112113104],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->613386223]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->498156180],

Cell[TextData[{
 "By changing the order of variables, the cylinders take the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["l", "1"], "<", "y", "<", 
     SubscriptBox["u", "1"]}], "\[And]", 
    RowBox[{
     RowBox[{
      SubscriptBox["l", "2"], "[", "y", "]"}], "<", "x", "<", 
     RowBox[{
      SubscriptBox["u", "2"], "[", "y", "]"}]}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->907656866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "1"}], "&&", 
    RowBox[{"y", ">", "x"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "x"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->203137226],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}], "<", "y", "\[LessEqual]", 
     FractionBox["1", 
      SqrtBox["2"]]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["y", "2"]}]]}], "<", "x", "<", "y"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      SqrtBox["2"]], "<", "y", "<", "1"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["y", "2"]}]]}], "<", "x", "<", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["y", "2"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{505, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->142608501]
}, Open  ]],

Cell["Plot the individual cylinders: ", "ExampleText",
 CellID->549981057],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c1", ",", "c2"}], "}"}], "=", 
   RowBox[{"Apply", "[", 
    RowBox[{"List", ",", "%"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->38851922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"RegionPlot", "[", 
     RowBox[{"c1", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "50"}]}], "]"}], ",", 
    RowBox[{"RegionPlot", "[", 
     RowBox[{"c2", ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Green"}], ",", 
      RowBox[{"PlotPoints", "\[Rule]", "50"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->8491266],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->333954883]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->133629119],

Cell[TextData[{
 "Here cylinders of dimensions ",
 Cell[BoxData[
  FormBox["0", TraditionalForm]], "InlineMath"],
 ", ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineMath"],
 ", and ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " occur in the result:"
}], "ExampleText",
 CellID->386718163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}], "||", 
    RowBox[{"x", "\[Equal]", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90001242],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "<", "1"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]]}], "\[LessEqual]", "y", "\[LessEqual]", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"x", "\[Equal]", "1"}]}]], "Output",
 ImageSize->{413, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->122247706]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->306824023],

Cell["Three- and four-dimensional decompositions:", "ExampleText",
 CellID->41837984],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}], "+", 
     RowBox[{"z", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65622872],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "1"}], "<", "x", "<", "1"}], "&&", 
  RowBox[{
   RowBox[{"-", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]]}], "&&", 
  RowBox[{
   RowBox[{"-", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"], "-", 
      SuperscriptBox["y", "2"]}]]}], "<", "z", "<", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"], "-", 
     SuperscriptBox["y", "2"]}]]}]}]], "Output",
 ImageSize->{440, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->331224290]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}], "+", 
     RowBox[{"z", "^", "2"}], "+", 
     RowBox[{"w", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "z", ",", "w"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->55757457],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "1"}], "<", "x", "<", "1"}], "&&", 
  RowBox[{
   RowBox[{"-", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]]}], "&&", 
  RowBox[{
   RowBox[{"-", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"], "-", 
      SuperscriptBox["y", "2"]}]]}], "<", "z", "<", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"], "-", 
     SuperscriptBox["y", "2"]}]]}], "&&", 
  RowBox[{
   RowBox[{"-", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"], "-", 
      SuperscriptBox["y", "2"], "-", 
      SuperscriptBox["z", "2"]}]]}], "<", "w", "<", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"], "-", 
     SuperscriptBox["y", "2"], "-", 
     SuperscriptBox["z", "2"]}]]}]}]], "Output",
 ImageSize->{471, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->407802383]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19280],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CylindricalDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CylindricalDecomposition"]], "InlineFormula"],
 " also allows quantified formulas:"
}], "ExampleText",
 CellID->48493443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"y", ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "<", "1"}], "&&", 
      RowBox[{"y", ">", "x"}]}]}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67389443],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1"}], "<", "x", "<", 
  FractionBox["1", 
   SqrtBox["2"]]}]], "Output",
 ImageSize->{82, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->210520125]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->336986953],

Cell["Coefficients can include real algebraic numbers: ", "ExampleText",
 CellID->401279341],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"#", "^", "5"}], "-", 
          RowBox[{"2", "#"}], "-", "11"}], "&"}], ",", "1"}], "]"}], 
      RowBox[{"y", "^", "2"}]}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39816937],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", 
     SuperscriptBox["2", 
      RowBox[{"1", "/", "4"}]]]}], "<", "x", "<", 
   FractionBox["1", 
    SuperscriptBox["2", 
     RowBox[{"1", "/", "4"}]]]}], "&&", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SqrtBox[
      RowBox[{"1", "-", 
       RowBox[{
        SqrtBox["2"], " ", 
        SuperscriptBox["x", "2"]}]}]], 
     SqrtBox[
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"-", "11"}], "-", 
          RowBox[{"2", " ", "#1"}], "+", 
          SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], "]"}]]]}], "<", "y",
    "<", 
   SqrtBox[
    FractionBox[
     RowBox[{"1", "-", 
      RowBox[{
       SqrtBox["2"], " ", 
       SuperscriptBox["x", "2"]}]}], 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"-", "11"}], "-", 
         RowBox[{"2", " ", "#1"}], "+", 
         SuperscriptBox["#1", "5"]}], "&"}], ",", "1"}], 
      "]"}]]]}]}]], "Output",
 ImageSize->{531, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->393960380]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->256599323],

Cell["Coefficients can include real exact transcendental numbers: ", \
"ExampleText",
 CellID->361338437],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"E", "^", "Pi"}], " ", 
       RowBox[{"x", "^", "2"}]}], "+", 
      RowBox[{
       RowBox[{"Pi", "^", "E"}], " ", 
       RowBox[{"y", "^", "2"}]}]}], "\[LessEqual]", "77"}], "&&", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"Log", "[", "2", "]"}], "x"}], "+", 
      RowBox[{
       RowBox[{"Log", "[", "3", "]"}], "y"}]}], "==", "2"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19620618],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{571, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21500647]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9895948],

Cell["Functions can be real algebraic:", "ExampleText",
 CellID->624279460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"x", "-", "y"}], "]"}], "\[LessEqual]", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#", "^", "3"}], "-", 
        RowBox[{"y", " ", "#"}], "+", "x"}], "&"}], ",", "1"}], "]"}]}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37830882],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "<", "0"}], "&&", 
    RowBox[{
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], "-", 
         SuperscriptBox["x", "3"], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["x", "2"], " ", "#1"}], "-", 
         RowBox[{"8", " ", "x", " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}], 
     "\[LessEqual]", "y", "\[LessEqual]", "x"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{478, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->26988186]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10016],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->15290],

Cell["\<\
This computation takes a long time due to high degrees of algebraic numbers \
involved:\
\>", "ExampleText",
 CellID->777105701],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TimeConstrained", "[", 
  RowBox[{
   RowBox[{"CylindricalDecomposition", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "8"}], " ", "+", " ", 
        RowBox[{"2", 
         RowBox[{"y", "^", "8"}]}], " ", "+", " ", 
        RowBox[{"3", 
         RowBox[{"z", "^", "8"}]}]}], " ", "<=", " ", "1"}], " ", "&&", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "3"}], " ", "-", " ", 
        RowBox[{"9", 
         RowBox[{"y", "^", "3"}]}], " ", "+", " ", 
        RowBox[{"7", 
         RowBox[{"z", "^", "3"}]}]}], " ", ">=", " ", "3"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}], ",", "300"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->139317936],

Cell[BoxData["$Aborted"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->119418680]
}, Open  ]],

Cell[TextData[{
 "This finds a decomposition using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorkingPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WorkingPrecision"], "->", "100"}]], 
  "InlineFormula"],
 ", but the result may be incorrect:"
}], "ExampleText",
 CellID->2548684],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CylindricalDecomposition", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "8"}], " ", "+", " ", 
       RowBox[{"2", 
        RowBox[{"y", "^", "8"}]}], " ", "+", " ", 
       RowBox[{"3", 
        RowBox[{"z", "^", "8"}]}]}], " ", "<=", " ", "1"}], " ", "&&", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "3"}], " ", "-", " ", 
       RowBox[{"9", 
        RowBox[{"y", "^", "3"}]}], " ", "+", " ", 
       RowBox[{"7", 
        RowBox[{"z", "^", "3"}]}]}], " ", ">=", " ", "3"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}], ",", 
    RowBox[{"WorkingPrecision", "\[Rule]", "100"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->54627604],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"66.45499999999998`", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "2618196522352684701774606608633544092649073499"}], 
           "+", 
           RowBox[{"112137303438920075611127400135124077321328320", " ", 
            SuperscriptBox["#1", "3"]}], "-", 
           RowBox[{"132814474280704167113940479747995449194074080", " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{"39146793368921485441556580804351146802749608125", " ", 
            SuperscriptBox["#1", "8"]}], "+", 
           RowBox[{"91856705198484666269070399879775363171210560", " ", 
            SuperscriptBox["#1", "9"]}], "-", 
           RowBox[{"1341175495662621729806372147543199870137760000", " ", 
            SuperscriptBox["#1", "11"]}], "-", 
           RowBox[{"42141596434943420720542775053872665433472560", " ", 
            SuperscriptBox["#1", "12"]}], "+", 
           RowBox[{"1582589878455148632715539236814693300312720000", " ", 
            SuperscriptBox["#1", "14"]}], "+", 
           RowBox[{"14592876096802804747928270810337344964750144", " ", 
            SuperscriptBox["#1", "15"]}], "-", 
           RowBox[{"273273142366140173367879981297464977692294766875", " ", 
            SuperscriptBox["#1", "16"]}], "-", 
           RowBox[{"1084874600671729351240909310589456169549920000", " ", 
            SuperscriptBox["#1", "17"]}], "-", 
           RowBox[{"4672251468213613165500303866540607470285280", " ", 
            SuperscriptBox["#1", "18"]}], "+", 
           RowBox[{"7356344450939568322500928613721519152461680000", " ", 
            SuperscriptBox["#1", "19"]}], "+", 
           RowBox[{"486826623827220403020230939919133417925160000", " ", 
            SuperscriptBox["#1", "20"]}], "+", 
           RowBox[{"1621571466270389965629654616387930805757120", " ", 
            SuperscriptBox["#1", "21"]}], "-", 
           RowBox[{"8653932056131816411521412982277635828456280000", " ", 
            SuperscriptBox["#1", "22"]}], "-", 
           RowBox[{"159993801360094923449431503286528552237920000", " ", 
            SuperscriptBox["#1", "23"]}], "+", 
           RowBox[{"1181424427392038088337249041705578494130159397085", " ", 
            SuperscriptBox["#1", "24"]}], "+", 
           RowBox[{"5888520338213011791817834072101573901146000000", " ", 
            SuperscriptBox["#1", "25"]}], "+", 
           RowBox[{"46801330922844246880795344194337790150800000", " ", 
            SuperscriptBox["#1", "26"]}], "-", 
           RowBox[{"24467334554119716937184952245655314221972911360", " ", 
            SuperscriptBox["#1", "27"]}], "-", 
           RowBox[{"2592683832594860546674917271501222308863100000", " ", 
            SuperscriptBox["#1", "28"]}], "-", 
           RowBox[{"15023717692172852187405796260244955218080000", " ", 
            SuperscriptBox["#1", "29"]}], "+", 
           RowBox[{"28712264151480474791676088438741348538206419072", " ", 
            SuperscriptBox["#1", "30"]}], "+", 
           RowBox[{"812007928880976140189494202018689306183440000", " ", 
            SuperscriptBox["#1", "31"]}], "-", 
           RowBox[{"3537388434852562446245779712340529662767287374375", " ", 
            SuperscriptBox["#1", "32"]}], "-", 
           RowBox[{"19419692926214247862900336814814700349248715520", " ", 
            SuperscriptBox["#1", "33"]}], "-", 
           RowBox[{"215801930758779344936762324367020005964760000", " ", 
            SuperscriptBox["#1", "34"]}], "+", 
           RowBox[{"54956519692073469839737650809448309844165320000", " ", 
            SuperscriptBox["#1", "35"]}], "+", 
           RowBox[{"8416105250955529068503592692330519350762985280", " ", 
            SuperscriptBox["#1", "36"]}], "+", 
           RowBox[{"62749943086937329078155618392566103762160000", " ", 
            SuperscriptBox["#1", "37"]}], "-", 
           RowBox[{"64367630445629017037391403984608079326797460000", " ", 
            SuperscriptBox["#1", "38"]}], "-", 
           RowBox[{"2525641537787781382376498550629952426026914560", " ", 
            SuperscriptBox["#1", "39"]}], "+", 
           RowBox[{"7769879867923988538207935524603223179597438700625", " ", 
            SuperscriptBox["#1", "40"]}], "+", 
           RowBox[{"43329124582475416283094388364421875447511480000", " ", 
            SuperscriptBox["#1", "41"]}], "+", 
           RowBox[{"608571619842211233122870844723209029615839360", " ", 
            SuperscriptBox["#1", "42"]}], "-", 
           RowBox[{"87814264603382842854822220404984016052585280000", " ", 
            SuperscriptBox["#1", "43"]}], "-", 
           RowBox[{"18540585580851717955554798423035685485022690000", " ", 
            SuperscriptBox["#1", "44"]}], "-", 
           RowBox[{"156306036132841583716281672642560892872625408", " ", 
            SuperscriptBox["#1", "45"]}], "+", 
           RowBox[{"102705768764820593232701679939710711938148640000", " ", 
            SuperscriptBox["#1", "46"]}], "+", 
           RowBox[{"5366064551542083207779168329149533496316920000", " ", 
            SuperscriptBox["#1", "47"]}], "-", 
           RowBox[{
           "12933319682733588182976356272163450519472577361975", " ", 
            SuperscriptBox["#1", "48"]}], "-", 
           RowBox[{"68888356902963978599391691551819737543190720000", " ", 
            SuperscriptBox["#1", "49"]}], "-", 
           RowBox[{"1175665676613966204279385048731055803883860000", " ", 
            SuperscriptBox["#1", "50"]}], "+", 
           RowBox[{"102349284026470938371782065432062687964569222400", " ", 
            SuperscriptBox["#1", "51"]}], "+", 
           RowBox[{"29190269364846825839973582629765084651591760000", " ", 
            SuperscriptBox["#1", "52"]}], "+", 
           RowBox[{"259374843939446832787459753544489388431880000", " ", 
            SuperscriptBox["#1", "53"]}], "-", 
           RowBox[{"119587139497995006342197262000331067394096028800", " ", 
            SuperscriptBox["#1", "54"]}], "-", 
           RowBox[{"8205916620950552633901449156541143750450880000", " ", 
            SuperscriptBox["#1", "55"]}], "+", 
           RowBox[{
           "16612091542028724056189112117561283747502505950625", " ", 
            SuperscriptBox["#1", "56"]}], "+", 
           RowBox[{"80004420208874816613224028609118173868304044800", " ", 
            SuperscriptBox["#1", "57"]}], "+", 
           RowBox[{"1648899263817925705121815992021920771761440000", " ", 
            SuperscriptBox["#1", "58"]}], "-", 
           RowBox[{"87665562868557594190677261244388005157686080000", " ", 
            SuperscriptBox["#1", "59"]}], "-", 
           RowBox[{"33659799063004124213882498578714308256508431680", " ", 
            SuperscriptBox["#1", "60"]}], "-", 
           RowBox[{"304376591320557139693314112878863610419520000", " ", 
            SuperscriptBox["#1", "61"]}], "+", 
           RowBox[{"102367132287597953565962994166169290757271840000", " ", 
            SuperscriptBox["#1", "62"]}], "+", 
           RowBox[{"9257163005429436876882202557014641599211027200", " ", 
            SuperscriptBox["#1", "63"]}], "-", 
           RowBox[{
           "16599758863903187132239700274652562160030244580625", " ", 
            SuperscriptBox["#1", "64"]}], "-", 
           RowBox[{"68366264026784452691041760938370396396003520000", " ", 
            SuperscriptBox["#1", "65"]}], "-", 
           RowBox[{"1730333554954169873611503086841804695577244800", " ", 
            SuperscriptBox["#1", "66"]}], "+", 
           RowBox[{"54763204308086194241501487468704819730450120000", " ", 
            SuperscriptBox["#1", "67"]}], "+", 
           RowBox[{"28625238073607620492282326877769441262734160000", " ", 
            SuperscriptBox["#1", "68"]}], "+", 
           RowBox[{"262996675955904001926787571198960559623865600", " ", 
            SuperscriptBox["#1", "69"]}], "-", 
           RowBox[{"63927391124183312791754433167377126419456660000", " ", 
            SuperscriptBox["#1", "70"]}], "-", 
           RowBox[{"7753929047003383073397617193398919823922880000", " ", 
            SuperscriptBox["#1", "71"]}], "+", 
           RowBox[{
           "12904081346226982280605562154285759160691539102775", " ", 
            SuperscriptBox["#1", "72"]}], "+", 
           RowBox[{"42650374794315928136358667562312747263268280000", " ", 
            SuperscriptBox["#1", "73"]}], "+", 
           RowBox[{"1372664308200444591592026324160636334411040000", " ", 
            SuperscriptBox["#1", "74"]}], "-", 
           RowBox[{"24330192224494514789655337374770350707667752192", " ", 
            SuperscriptBox["#1", "75"]}], "-", 
           RowBox[{"17805994084894383068160064561294049724904290000", " ", 
            SuperscriptBox["#1", "76"]}], "-", 
           RowBox[{"172813707224560334012750477036141012377920000", " ", 
            SuperscriptBox["#1", "77"]}], "+", 
           RowBox[{"28399942154308671185921648759612368175302776960", " ", 
            SuperscriptBox["#1", "78"]}], "+", 
           RowBox[{"4778412956595368622445860449020422516912120000", " ", 
            SuperscriptBox["#1", "79"]}], "-", 
           RowBox[{"7739716518119225272823894164887244927820332880625", " ", 
            SuperscriptBox["#1", "80"]}], "-", 
           RowBox[{"18938148902700282758237541155853595804003818240", " ", 
            SuperscriptBox["#1", "81"]}], "-", 
           RowBox[{"816488724555469657654545787895529399711060000", " ", 
            SuperscriptBox["#1", "82"]}], "+", 
           RowBox[{"7296858294042704418061125066571398260373360000", " ", 
            SuperscriptBox["#1", "83"]}], "+", 
           RowBox[{"7894918722252097363756733535000107407825615680", " ", 
            SuperscriptBox["#1", "84"]}], "+", 
           RowBox[{"88281801526603013508862318022814564163080000", " ", 
            SuperscriptBox["#1", "85"]}], "-", 
           RowBox[{"8518456644360681975737407018339545163281240000", " ", 
            SuperscriptBox["#1", "86"]}], "-", 
           RowBox[{"2108672407972653082729083376940532733527847680", " ", 
            SuperscriptBox["#1", "87"]}], "+", 
           RowBox[{"3517309276665022732685811568661876577620337744375", " ", 
            SuperscriptBox["#1", "88"]}], "+", 
           RowBox[{"5679632344998648546512579795877443006666640000", " ", 
            SuperscriptBox["#1", "89"]}], "+", 
           RowBox[{"353677893356315750550316740327368006350342272", " ", 
            SuperscriptBox["#1", "90"]}], "-", 
           RowBox[{"1326302987927784759457772780540558196865440000", " ", 
            SuperscriptBox["#1", "91"]}], "-", 
           RowBox[{"2366582357168305977580095813080181113432700000", " ", 
            SuperscriptBox["#1", "92"]}], "-", 
           RowBox[{"34852629611923609899244650713526533868023040", " ", 
            SuperscriptBox["#1", "93"]}], "+", 
           RowBox[{"1548717310907078775829818316566134361601680000", " ", 
            SuperscriptBox["#1", "94"]}], "+", 
           RowBox[{"631094280277848382313861941203902638909200000", " ", 
            SuperscriptBox["#1", "95"]}], "-", 
           RowBox[{"1172312695762124031690192344345807052060166385965", " ", 
            SuperscriptBox["#1", "96"]}], "-", 
           RowBox[{"1032643519437328344321445223025112312126560000", " ", 
            SuperscriptBox["#1", "97"]}], "-", 
           RowBox[{"105182716457011345078522983571228368962520000", " ", 
            SuperscriptBox["#1", "98"]}], "+", 
           RowBox[{"110484659009863463733574569256113624845465280", " ", 
            SuperscriptBox["#1", "99"]}], "+", 
           RowBox[{"430285353118795373628887591244084593755560000", " ", 
            SuperscriptBox["#1", "100"]}], "+", 
           RowBox[{"10017414382980503861733953120029986800880000", " ", 
            SuperscriptBox["#1", "101"]}], "-", 
           RowBox[{"129050304905153671105623220758057551634624480", " ", 
            SuperscriptBox["#1", "102"]}], "-", 
           RowBox[{"114744173756512190403275159458628937840480000", " ", 
            SuperscriptBox["#1", "103"]}], "+", 
           RowBox[{"270524153931355107361142975288559200669258266875", " ", 
            SuperscriptBox["#1", "104"]}], "+", 
           RowBox[{"86051904618376655059098105797611845779240256", " ", 
            SuperscriptBox["#1", "105"]}], "+", 
           RowBox[{"19124113062091680117605596372788119970960000", " ", 
            SuperscriptBox["#1", "106"]}], "-", 
           RowBox[{"35856873592983761706727696842043851656858160", " ", 
            SuperscriptBox["#1", "108"]}], "-", 
           RowBox[{"1821347305063040569017930666661064484000000", " ", 
            SuperscriptBox["#1", "109"]}], "+", 
           RowBox[{"9561989949766059189667676243578440624786240", " ", 
            SuperscriptBox["#1", "111"]}], "-", 
           RowBox[{"38646291442449791560158201666841790621818288125", " ", 
            SuperscriptBox["#1", "112"]}], "-", 
           RowBox[{"1593674336368698407981121050114388435456480", " ", 
            SuperscriptBox["#1", "114"]}], "+", 
           RowBox[{"151778864215741208274407584901857202930880", " ", 
            SuperscriptBox["#1", "117"]}], "+", 
           RowBox[{"2576418164672784306167144491059578525977861451", " ", 
            SuperscriptBox["#1", "120"]}]}], "&"}], ",", "1"}], "]"}]}], "&&",
       
      RowBox[{"y", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "5587654"}], "-", 
           RowBox[{"472392", " ", 
            SuperscriptBox["x", "3"]}], "+", 
           RowBox[{"551124", " ", 
            SuperscriptBox["x", "6"]}], "+", 
           RowBox[{"17294403", " ", 
            SuperscriptBox["x", "8"]}], "-", 
           RowBox[{"367416", " ", 
            SuperscriptBox["x", "9"]}], "+", 
           RowBox[{"153090", " ", 
            SuperscriptBox["x", "12"]}], "-", 
           RowBox[{"40824", " ", 
            SuperscriptBox["x", "15"]}], "-", 
           RowBox[{"17294403", " ", 
            SuperscriptBox["x", "16"]}], "+", 
           RowBox[{"6804", " ", 
            SuperscriptBox["x", "18"]}], "-", 
           RowBox[{"648", " ", 
            SuperscriptBox["x", "21"]}], "+", 
           RowBox[{"5764828", " ", 
            SuperscriptBox["x", "24"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4251528", "-", 
              RowBox[{"9920232", " ", 
               SuperscriptBox["x", "3"]}], "+", 
              RowBox[{"9920232", " ", 
               SuperscriptBox["x", "6"]}], "-", 
              RowBox[{"5511240", " ", 
               SuperscriptBox["x", "9"]}], "+", 
              RowBox[{"1837080", " ", 
               SuperscriptBox["x", "12"]}], "-", 
              RowBox[{"367416", " ", 
               SuperscriptBox["x", "15"]}], "+", 
              RowBox[{"40824", " ", 
               SuperscriptBox["x", "18"]}], "-", 
              RowBox[{"1944", " ", 
               SuperscriptBox["x", "21"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"44641044", "-", 
              RowBox[{"89282088", " ", 
               SuperscriptBox["x", "3"]}], "+", 
              RowBox[{"74401740", " ", 
               SuperscriptBox["x", "6"]}], "-", 
              RowBox[{"33067440", " ", 
               SuperscriptBox["x", "9"]}], "+", 
              RowBox[{"8266860", " ", 
               SuperscriptBox["x", "12"]}], "-", 
              RowBox[{"1102248", " ", 
               SuperscriptBox["x", "15"]}], "+", 
              RowBox[{"61236", " ", 
               SuperscriptBox["x", "18"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"34588806", "-", 
              RowBox[{"69177612", " ", 
               SuperscriptBox["x", "8"]}], "+", 
              RowBox[{"34588806", " ", 
               SuperscriptBox["x", "16"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "8"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"267846264", "-", 
              RowBox[{"446410440", " ", 
               SuperscriptBox["x", "3"]}], "+", 
              RowBox[{"297606960", " ", 
               SuperscriptBox["x", "6"]}], "-", 
              RowBox[{"99202320", " ", 
               SuperscriptBox["x", "9"]}], "+", 
              RowBox[{"16533720", " ", 
               SuperscriptBox["x", "12"]}], "-", 
              RowBox[{"1102248", " ", 
               SuperscriptBox["x", "15"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "9"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1004423490", "-", 
              RowBox[{"1339231320", " ", 
               SuperscriptBox["x", "3"]}], "+", 
              RowBox[{"669615660", " ", 
               SuperscriptBox["x", "6"]}], "-", 
              RowBox[{"148803480", " ", 
               SuperscriptBox["x", "9"]}], "+", 
              RowBox[{"12400290", " ", 
               SuperscriptBox["x", "12"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "12"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2410616376", "-", 
              RowBox[{"2410616376", " ", 
               SuperscriptBox["x", "3"]}], "+", 
              RowBox[{"803538792", " ", 
               SuperscriptBox["x", "6"]}], "-", 
              RowBox[{"89282088", " ", 
               SuperscriptBox["x", "9"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "15"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "69177612"}], "+", 
              RowBox[{"69177612", " ", 
               SuperscriptBox["x", "8"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "16"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3615924564", "-", 
              RowBox[{"2410616376", " ", 
               SuperscriptBox["x", "3"]}], "+", 
              RowBox[{"401769396", " ", 
               SuperscriptBox["x", "6"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "18"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3099363912", "-", 
              RowBox[{"1033121304", " ", 
               SuperscriptBox["x", "3"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "21"]}], "+", 
           RowBox[{"1208379875", " ", 
            SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}]}], "&&", 
      
      RowBox[{"z", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["x", "8"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["y", "8"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
     ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "2618196522352684701774606608633544092649073499"}], 
           "+", 
           RowBox[{"112137303438920075611127400135124077321328320", " ", 
            SuperscriptBox["#1", "3"]}], "-", 
           RowBox[{"132814474280704167113940479747995449194074080", " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{"39146793368921485441556580804351146802749608125", " ", 
            SuperscriptBox["#1", "8"]}], "+", 
           RowBox[{"91856705198484666269070399879775363171210560", " ", 
            SuperscriptBox["#1", "9"]}], "-", 
           RowBox[{"1341175495662621729806372147543199870137760000", " ", 
            SuperscriptBox["#1", "11"]}], "-", 
           RowBox[{"42141596434943420720542775053872665433472560", " ", 
            SuperscriptBox["#1", "12"]}], "+", 
           RowBox[{"1582589878455148632715539236814693300312720000", " ", 
            SuperscriptBox["#1", "14"]}], "+", 
           RowBox[{"14592876096802804747928270810337344964750144", " ", 
            SuperscriptBox["#1", "15"]}], "-", 
           RowBox[{"273273142366140173367879981297464977692294766875", " ", 
            SuperscriptBox["#1", "16"]}], "-", 
           RowBox[{"1084874600671729351240909310589456169549920000", " ", 
            SuperscriptBox["#1", "17"]}], "-", 
           RowBox[{"4672251468213613165500303866540607470285280", " ", 
            SuperscriptBox["#1", "18"]}], "+", 
           RowBox[{"7356344450939568322500928613721519152461680000", " ", 
            SuperscriptBox["#1", "19"]}], "+", 
           RowBox[{"486826623827220403020230939919133417925160000", " ", 
            SuperscriptBox["#1", "20"]}], "+", 
           RowBox[{"1621571466270389965629654616387930805757120", " ", 
            SuperscriptBox["#1", "21"]}], "-", 
           RowBox[{"8653932056131816411521412982277635828456280000", " ", 
            SuperscriptBox["#1", "22"]}], "-", 
           RowBox[{"159993801360094923449431503286528552237920000", " ", 
            SuperscriptBox["#1", "23"]}], "+", 
           RowBox[{"1181424427392038088337249041705578494130159397085", " ", 
            SuperscriptBox["#1", "24"]}], "+", 
           RowBox[{"5888520338213011791817834072101573901146000000", " ", 
            SuperscriptBox["#1", "25"]}], "+", 
           RowBox[{"46801330922844246880795344194337790150800000", " ", 
            SuperscriptBox["#1", "26"]}], "-", 
           RowBox[{"24467334554119716937184952245655314221972911360", " ", 
            SuperscriptBox["#1", "27"]}], "-", 
           RowBox[{"2592683832594860546674917271501222308863100000", " ", 
            SuperscriptBox["#1", "28"]}], "-", 
           RowBox[{"15023717692172852187405796260244955218080000", " ", 
            SuperscriptBox["#1", "29"]}], "+", 
           RowBox[{"28712264151480474791676088438741348538206419072", " ", 
            SuperscriptBox["#1", "30"]}], "+", 
           RowBox[{"812007928880976140189494202018689306183440000", " ", 
            SuperscriptBox["#1", "31"]}], "-", 
           RowBox[{"3537388434852562446245779712340529662767287374375", " ", 
            SuperscriptBox["#1", "32"]}], "-", 
           RowBox[{"19419692926214247862900336814814700349248715520", " ", 
            SuperscriptBox["#1", "33"]}], "-", 
           RowBox[{"215801930758779344936762324367020005964760000", " ", 
            SuperscriptBox["#1", "34"]}], "+", 
           RowBox[{"54956519692073469839737650809448309844165320000", " ", 
            SuperscriptBox["#1", "35"]}], "+", 
           RowBox[{"8416105250955529068503592692330519350762985280", " ", 
            SuperscriptBox["#1", "36"]}], "+", 
           RowBox[{"62749943086937329078155618392566103762160000", " ", 
            SuperscriptBox["#1", "37"]}], "-", 
           RowBox[{"64367630445629017037391403984608079326797460000", " ", 
            SuperscriptBox["#1", "38"]}], "-", 
           RowBox[{"2525641537787781382376498550629952426026914560", " ", 
            SuperscriptBox["#1", "39"]}], "+", 
           RowBox[{"7769879867923988538207935524603223179597438700625", " ", 
            SuperscriptBox["#1", "40"]}], "+", 
           RowBox[{"43329124582475416283094388364421875447511480000", " ", 
            SuperscriptBox["#1", "41"]}], "+", 
           RowBox[{"608571619842211233122870844723209029615839360", " ", 
            SuperscriptBox["#1", "42"]}], "-", 
           RowBox[{"87814264603382842854822220404984016052585280000", " ", 
            SuperscriptBox["#1", "43"]}], "-", 
           RowBox[{"18540585580851717955554798423035685485022690000", " ", 
            SuperscriptBox["#1", "44"]}], "-", 
           RowBox[{"156306036132841583716281672642560892872625408", " ", 
            SuperscriptBox["#1", "45"]}], "+", 
           RowBox[{"102705768764820593232701679939710711938148640000", " ", 
            SuperscriptBox["#1", "46"]}], "+", 
           RowBox[{"5366064551542083207779168329149533496316920000", " ", 
            SuperscriptBox["#1", "47"]}], "-", 
           RowBox[{
           "12933319682733588182976356272163450519472577361975", " ", 
            SuperscriptBox["#1", "48"]}], "-", 
           RowBox[{"68888356902963978599391691551819737543190720000", " ", 
            SuperscriptBox["#1", "49"]}], "-", 
           RowBox[{"1175665676613966204279385048731055803883860000", " ", 
            SuperscriptBox["#1", "50"]}], "+", 
           RowBox[{"102349284026470938371782065432062687964569222400", " ", 
            SuperscriptBox["#1", "51"]}], "+", 
           RowBox[{"29190269364846825839973582629765084651591760000", " ", 
            SuperscriptBox["#1", "52"]}], "+", 
           RowBox[{"259374843939446832787459753544489388431880000", " ", 
            SuperscriptBox["#1", "53"]}], "-", 
           RowBox[{"119587139497995006342197262000331067394096028800", " ", 
            SuperscriptBox["#1", "54"]}], "-", 
           RowBox[{"8205916620950552633901449156541143750450880000", " ", 
            SuperscriptBox["#1", "55"]}], "+", 
           RowBox[{
           "16612091542028724056189112117561283747502505950625", " ", 
            SuperscriptBox["#1", "56"]}], "+", 
           RowBox[{"80004420208874816613224028609118173868304044800", " ", 
            SuperscriptBox["#1", "57"]}], "+", 
           RowBox[{"1648899263817925705121815992021920771761440000", " ", 
            SuperscriptBox["#1", "58"]}], "-", 
           RowBox[{"87665562868557594190677261244388005157686080000", " ", 
            SuperscriptBox["#1", "59"]}], "-", 
           RowBox[{"33659799063004124213882498578714308256508431680", " ", 
            SuperscriptBox["#1", "60"]}], "-", 
           RowBox[{"304376591320557139693314112878863610419520000", " ", 
            SuperscriptBox["#1", "61"]}], "+", 
           RowBox[{"102367132287597953565962994166169290757271840000", " ", 
            SuperscriptBox["#1", "62"]}], "+", 
           RowBox[{"9257163005429436876882202557014641599211027200", " ", 
            SuperscriptBox["#1", "63"]}], "-", 
           RowBox[{
           "16599758863903187132239700274652562160030244580625", " ", 
            SuperscriptBox["#1", "64"]}], "-", 
           RowBox[{"68366264026784452691041760938370396396003520000", " ", 
            SuperscriptBox["#1", "65"]}], "-", 
           RowBox[{"1730333554954169873611503086841804695577244800", " ", 
            SuperscriptBox["#1", "66"]}], "+", 
           RowBox[{"54763204308086194241501487468704819730450120000", " ", 
            SuperscriptBox["#1", "67"]}], "+", 
           RowBox[{"28625238073607620492282326877769441262734160000", " ", 
            SuperscriptBox["#1", "68"]}], "+", 
           RowBox[{"262996675955904001926787571198960559623865600", " ", 
            SuperscriptBox["#1", "69"]}], "-", 
           RowBox[{"63927391124183312791754433167377126419456660000", " ", 
            SuperscriptBox["#1", "70"]}], "-", 
           RowBox[{"7753929047003383073397617193398919823922880000", " ", 
            SuperscriptBox["#1", "71"]}], "+", 
           RowBox[{
           "12904081346226982280605562154285759160691539102775", " ", 
            SuperscriptBox["#1", "72"]}], "+", 
           RowBox[{"42650374794315928136358667562312747263268280000", " ", 
            SuperscriptBox["#1", "73"]}], "+", 
           RowBox[{"1372664308200444591592026324160636334411040000", " ", 
            SuperscriptBox["#1", "74"]}], "-", 
           RowBox[{"24330192224494514789655337374770350707667752192", " ", 
            SuperscriptBox["#1", "75"]}], "-", 
           RowBox[{"17805994084894383068160064561294049724904290000", " ", 
            SuperscriptBox["#1", "76"]}], "-", 
           RowBox[{"172813707224560334012750477036141012377920000", " ", 
            SuperscriptBox["#1", "77"]}], "+", 
           RowBox[{"28399942154308671185921648759612368175302776960", " ", 
            SuperscriptBox["#1", "78"]}], "+", 
           RowBox[{"4778412956595368622445860449020422516912120000", " ", 
            SuperscriptBox["#1", "79"]}], "-", 
           RowBox[{"7739716518119225272823894164887244927820332880625", " ", 
            SuperscriptBox["#1", "80"]}], "-", 
           RowBox[{"18938148902700282758237541155853595804003818240", " ", 
            SuperscriptBox["#1", "81"]}], "-", 
           RowBox[{"816488724555469657654545787895529399711060000", " ", 
            SuperscriptBox["#1", "82"]}], "+", 
           RowBox[{"7296858294042704418061125066571398260373360000", " ", 
            SuperscriptBox["#1", "83"]}], "+", 
           RowBox[{"7894918722252097363756733535000107407825615680", " ", 
            SuperscriptBox["#1", "84"]}], "+", 
           RowBox[{"88281801526603013508862318022814564163080000", " ", 
            SuperscriptBox["#1", "85"]}], "-", 
           RowBox[{"8518456644360681975737407018339545163281240000", " ", 
            SuperscriptBox["#1", "86"]}], "-", 
           RowBox[{"2108672407972653082729083376940532733527847680", " ", 
            SuperscriptBox["#1", "87"]}], "+", 
           RowBox[{"3517309276665022732685811568661876577620337744375", " ", 
            SuperscriptBox["#1", "88"]}], "+", 
           RowBox[{"5679632344998648546512579795877443006666640000", " ", 
            SuperscriptBox["#1", "89"]}], "+", 
           RowBox[{"353677893356315750550316740327368006350342272", " ", 
            SuperscriptBox["#1", "90"]}], "-", 
           RowBox[{"1326302987927784759457772780540558196865440000", " ", 
            SuperscriptBox["#1", "91"]}], "-", 
           RowBox[{"2366582357168305977580095813080181113432700000", " ", 
            SuperscriptBox["#1", "92"]}], "-", 
           RowBox[{"34852629611923609899244650713526533868023040", " ", 
            SuperscriptBox["#1", "93"]}], "+", 
           RowBox[{"1548717310907078775829818316566134361601680000", " ", 
            SuperscriptBox["#1", "94"]}], "+", 
           RowBox[{"631094280277848382313861941203902638909200000", " ", 
            SuperscriptBox["#1", "95"]}], "-", 
           RowBox[{"1172312695762124031690192344345807052060166385965", " ", 
            SuperscriptBox["#1", "96"]}], "-", 
           RowBox[{"1032643519437328344321445223025112312126560000", " ", 
            SuperscriptBox["#1", "97"]}], "-", 
           RowBox[{"105182716457011345078522983571228368962520000", " ", 
            SuperscriptBox["#1", "98"]}], "+", 
           RowBox[{"110484659009863463733574569256113624845465280", " ", 
            SuperscriptBox["#1", "99"]}], "+", 
           RowBox[{"430285353118795373628887591244084593755560000", " ", 
            SuperscriptBox["#1", "100"]}], "+", 
           RowBox[{"10017414382980503861733953120029986800880000", " ", 
            SuperscriptBox["#1", "101"]}], "-", 
           RowBox[{"129050304905153671105623220758057551634624480", " ", 
            SuperscriptBox["#1", "102"]}], "-", 
           RowBox[{"114744173756512190403275159458628937840480000", " ", 
            SuperscriptBox["#1", "103"]}], "+", 
           RowBox[{"270524153931355107361142975288559200669258266875", " ", 
            SuperscriptBox["#1", "104"]}], "+", 
           RowBox[{"86051904618376655059098105797611845779240256", " ", 
            SuperscriptBox["#1", "105"]}], "+", 
           RowBox[{"19124113062091680117605596372788119970960000", " ", 
            SuperscriptBox["#1", "106"]}], "-", 
           RowBox[{"35856873592983761706727696842043851656858160", " ", 
            SuperscriptBox["#1", "108"]}], "-", 
           RowBox[{"1821347305063040569017930666661064484000000", " ", 
            SuperscriptBox["#1", "109"]}], "+", 
           RowBox[{"9561989949766059189667676243578440624786240", " ", 
            SuperscriptBox["#1", "111"]}], "-", 
           RowBox[{"38646291442449791560158201666841790621818288125", " ", 
            SuperscriptBox["#1", "112"]}], "-", 
           RowBox[{"1593674336368698407981121050114388435456480", " ", 
            SuperscriptBox["#1", "114"]}], "+", 
           RowBox[{"151778864215741208274407584901857202930880", " ", 
            SuperscriptBox["#1", "117"]}], "+", 
           RowBox[{"2576418164672784306167144491059578525977861451", " ", 
            SuperscriptBox["#1", "120"]}]}], "&"}], ",", "1"}], "]"}], "<", 
       "x", "<", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "42994233"}], "-", 
           RowBox[{"139968", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"163296", " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{"129140163", " ", 
            SuperscriptBox["#1", "8"]}], "-", 
           RowBox[{"108864", " ", 
            SuperscriptBox["#1", "9"]}], "+", 
           RowBox[{"45360", " ", 
            SuperscriptBox["#1", "12"]}], "-", 
           RowBox[{"12096", " ", 
            SuperscriptBox["#1", "15"]}], "-", 
           RowBox[{"129140163", " ", 
            SuperscriptBox["#1", "16"]}], "+", 
           RowBox[{"2016", " ", 
            SuperscriptBox["#1", "18"]}], "-", 
           RowBox[{"192", " ", 
            SuperscriptBox["#1", "21"]}], "+", 
           RowBox[{"43046729", " ", 
            SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}]}], "&&", 
      
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}]}], "&&",
           
          RowBox[{"z", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               SuperscriptBox["x", "3"], "-", 
               RowBox[{"9", " ", 
                SuperscriptBox["y", "3"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}], "<",
            "y", "<", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "2"}], "]"}]}], "&&",
           
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               SuperscriptBox["x", "3"], "-", 
               RowBox[{"9", " ", 
                SuperscriptBox["y", "3"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}], 
           "\[LessEqual]", "z", "\[LessEqual]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "2"}], "]"}]}], "&&",
           
          RowBox[{"z", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               SuperscriptBox["x", "3"], "-", 
               RowBox[{"9", " ", 
                SuperscriptBox["y", "3"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
         ")"}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "42994233"}], "-", 
           RowBox[{"139968", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"163296", " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{"129140163", " ", 
            SuperscriptBox["#1", "8"]}], "-", 
           RowBox[{"108864", " ", 
            SuperscriptBox["#1", "9"]}], "+", 
           RowBox[{"45360", " ", 
            SuperscriptBox["#1", "12"]}], "-", 
           RowBox[{"12096", " ", 
            SuperscriptBox["#1", "15"]}], "-", 
           RowBox[{"129140163", " ", 
            SuperscriptBox["#1", "16"]}], "+", 
           RowBox[{"2016", " ", 
            SuperscriptBox["#1", "18"]}], "-", 
           RowBox[{"192", " ", 
            SuperscriptBox["#1", "21"]}], "+", 
           RowBox[{"43046729", " ", 
            SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}]}], "&&", 
      
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}]}], "&&",
           
          RowBox[{"z", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               SuperscriptBox["x", "3"], "-", 
               RowBox[{"9", " ", 
                SuperscriptBox["y", "3"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}], "<", 
           "y", "<", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "4"}], "]"}]}], "&&",
           
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               SuperscriptBox["x", "3"], "-", 
               RowBox[{"9", " ", 
                SuperscriptBox["y", "3"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}], 
           "\[LessEqual]", "z", "\[LessEqual]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "4"}], "]"}]}], "&&",
           
          RowBox[{"z", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
         ")"}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "42994233"}], "-", 
           RowBox[{"139968", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"163296", " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{"129140163", " ", 
            SuperscriptBox["#1", "8"]}], "-", 
           RowBox[{"108864", " ", 
            SuperscriptBox["#1", "9"]}], "+", 
           RowBox[{"45360", " ", 
            SuperscriptBox["#1", "12"]}], "-", 
           RowBox[{"12096", " ", 
            SuperscriptBox["#1", "15"]}], "-", 
           RowBox[{"129140163", " ", 
            SuperscriptBox["#1", "16"]}], "+", 
           RowBox[{"2016", " ", 
            SuperscriptBox["#1", "18"]}], "-", 
           RowBox[{"192", " ", 
            SuperscriptBox["#1", "21"]}], "+", 
           RowBox[{"43046729", " ", 
            SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}], "<", 
       "x", "<", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "5587654"}], "-", 
           RowBox[{"472392", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"551124", " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{"17294403", " ", 
            SuperscriptBox["#1", "8"]}], "-", 
           RowBox[{"367416", " ", 
            SuperscriptBox["#1", "9"]}], "+", 
           RowBox[{"153090", " ", 
            SuperscriptBox["#1", "12"]}], "-", 
           RowBox[{"40824", " ", 
            SuperscriptBox["#1", "15"]}], "-", 
           RowBox[{"17294403", " ", 
            SuperscriptBox["#1", "16"]}], "+", 
           RowBox[{"6804", " ", 
            SuperscriptBox["#1", "18"]}], "-", 
           RowBox[{"648", " ", 
            SuperscriptBox["#1", "21"]}], "+", 
           RowBox[{"5764828", " ", 
            SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}]}], "&&", 
      
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}]}], "&&",
           
          RowBox[{"z", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}], "<", 
           "y", "\[LessEqual]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}]}], "&&",
           
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}], 
           "\[LessEqual]", "z", "\[LessEqual]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}], "<",
            "y", "<", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "2"}], "]"}]}], "&&",
           
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               SuperscriptBox["x", "3"], "-", 
               RowBox[{"9", " ", 
                SuperscriptBox["y", "3"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}], 
           "\[LessEqual]", "z", "\[LessEqual]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "2"}], "]"}]}], "&&",
           
          RowBox[{"z", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               SuperscriptBox["x", "3"], "-", 
               RowBox[{"9", " ", 
                SuperscriptBox["y", "3"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
         ")"}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "5587654"}], "-", 
           RowBox[{"472392", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"551124", " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{"17294403", " ", 
            SuperscriptBox["#1", "8"]}], "-", 
           RowBox[{"367416", " ", 
            SuperscriptBox["#1", "9"]}], "+", 
           RowBox[{"153090", " ", 
            SuperscriptBox["#1", "12"]}], "-", 
           RowBox[{"40824", " ", 
            SuperscriptBox["#1", "15"]}], "-", 
           RowBox[{"17294403", " ", 
            SuperscriptBox["#1", "16"]}], "+", 
           RowBox[{"6804", " ", 
            SuperscriptBox["#1", "18"]}], "-", 
           RowBox[{"648", " ", 
            SuperscriptBox["#1", "21"]}], "+", 
           RowBox[{"5764828", " ", 
            SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}]}], "&&", 
      
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}]}], "&&",
           
          RowBox[{"z", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}], "<", 
           "y", "\[LessEqual]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}]}], "&&",
           
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}], 
           "\[LessEqual]", "z", "\[LessEqual]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}], "<",
            "y", "<", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "2"}], "]"}]}], "&&",
           
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               SuperscriptBox["x", "3"], "-", 
               RowBox[{"9", " ", 
                SuperscriptBox["y", "3"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}], 
           "\[LessEqual]", "z", "\[LessEqual]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "2"}], "]"}]}], "&&",
           
          RowBox[{"z", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
         ")"}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "5587654"}], "-", 
           RowBox[{"472392", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"551124", " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{"17294403", " ", 
            SuperscriptBox["#1", "8"]}], "-", 
           RowBox[{"367416", " ", 
            SuperscriptBox["#1", "9"]}], "+", 
           RowBox[{"153090", " ", 
            SuperscriptBox["#1", "12"]}], "-", 
           RowBox[{"40824", " ", 
            SuperscriptBox["#1", "15"]}], "-", 
           RowBox[{"17294403", " ", 
            SuperscriptBox["#1", "16"]}], "+", 
           RowBox[{"6804", " ", 
            SuperscriptBox["#1", "18"]}], "-", 
           RowBox[{"648", " ", 
            SuperscriptBox["#1", "21"]}], "+", 
           RowBox[{"5764828", " ", 
            SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}], "<", 
       "x", "<", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "5587654"}], "-", 
           RowBox[{"472392", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"551124", " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{"17294403", " ", 
            SuperscriptBox["#1", "8"]}], "-", 
           RowBox[{"367416", " ", 
            SuperscriptBox["#1", "9"]}], "+", 
           RowBox[{"153090", " ", 
            SuperscriptBox["#1", "12"]}], "-", 
           RowBox[{"40824", " ", 
            SuperscriptBox["#1", "15"]}], "-", 
           RowBox[{"17294403", " ", 
            SuperscriptBox["#1", "16"]}], "+", 
           RowBox[{"6804", " ", 
            SuperscriptBox["#1", "18"]}], "-", 
           RowBox[{"648", " ", 
            SuperscriptBox["#1", "21"]}], "+", 
           RowBox[{"5764828", " ", 
            SuperscriptBox["#1", "24"]}]}], "&"}], ",", "2"}], "]"}]}], "&&", 
      
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}]}], "&&",
           
          RowBox[{"z", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}], "<", 
           "y", "<", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}]}], "&&",
           
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}], 
           "\[LessEqual]", "z", "\[LessEqual]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}], 
           "\[LessEqual]", "y", "<", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "2"}], "]"}]}], "&&",
           
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               SuperscriptBox["x", "3"], "-", 
               RowBox[{"9", " ", 
                SuperscriptBox["y", "3"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}], 
           "\[LessEqual]", "z", "\[LessEqual]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "2"}], "]"}]}], "&&",
           
          RowBox[{"z", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
         ")"}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "5587654"}], "-", 
           RowBox[{"472392", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"551124", " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{"17294403", " ", 
            SuperscriptBox["#1", "8"]}], "-", 
           RowBox[{"367416", " ", 
            SuperscriptBox["#1", "9"]}], "+", 
           RowBox[{"153090", " ", 
            SuperscriptBox["#1", "12"]}], "-", 
           RowBox[{"40824", " ", 
            SuperscriptBox["#1", "15"]}], "-", 
           RowBox[{"17294403", " ", 
            SuperscriptBox["#1", "16"]}], "+", 
           RowBox[{"6804", " ", 
            SuperscriptBox["#1", "18"]}], "-", 
           RowBox[{"648", " ", 
            SuperscriptBox["#1", "21"]}], "+", 
           RowBox[{"5764828", " ", 
            SuperscriptBox["#1", "24"]}]}], "&"}], ",", "2"}], "]"}]}], "&&", 
      
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}]}], "&&",
           
          RowBox[{"z", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}], "<", 
           "y", "\[LessEqual]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}]}], "&&",
           
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}], 
           "\[LessEqual]", "z", "\[LessEqual]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}], "<",
            "y", "<", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "2"}], "]"}]}], "&&",
           
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               SuperscriptBox["x", "3"], "-", 
               RowBox[{"9", " ", 
                SuperscriptBox["y", "3"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}], 
           "\[LessEqual]", "z", "\[LessEqual]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "2"}], "]"}]}], "&&",
           
          RowBox[{"z", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
         ")"}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "5587654"}], "-", 
           RowBox[{"472392", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"551124", " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{"17294403", " ", 
            SuperscriptBox["#1", "8"]}], "-", 
           RowBox[{"367416", " ", 
            SuperscriptBox["#1", "9"]}], "+", 
           RowBox[{"153090", " ", 
            SuperscriptBox["#1", "12"]}], "-", 
           RowBox[{"40824", " ", 
            SuperscriptBox["#1", "15"]}], "-", 
           RowBox[{"17294403", " ", 
            SuperscriptBox["#1", "16"]}], "+", 
           RowBox[{"6804", " ", 
            SuperscriptBox["#1", "18"]}], "-", 
           RowBox[{"648", " ", 
            SuperscriptBox["#1", "21"]}], "+", 
           RowBox[{"5764828", " ", 
            SuperscriptBox["#1", "24"]}]}], "&"}], ",", "2"}], "]"}], "<", 
       "x", "<", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "42994233"}], "-", 
           RowBox[{"139968", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"163296", " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{"129140163", " ", 
            SuperscriptBox["#1", "8"]}], "-", 
           RowBox[{"108864", " ", 
            SuperscriptBox["#1", "9"]}], "+", 
           RowBox[{"45360", " ", 
            SuperscriptBox["#1", "12"]}], "-", 
           RowBox[{"12096", " ", 
            SuperscriptBox["#1", "15"]}], "-", 
           RowBox[{"129140163", " ", 
            SuperscriptBox["#1", "16"]}], "+", 
           RowBox[{"2016", " ", 
            SuperscriptBox["#1", "18"]}], "-", 
           RowBox[{"192", " ", 
            SuperscriptBox["#1", "21"]}], "+", 
           RowBox[{"43046729", " ", 
            SuperscriptBox["#1", "24"]}]}], "&"}], ",", "2"}], "]"}]}], "&&", 
      
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}]}], "&&",
           
          RowBox[{"z", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}], "<", 
           "y", "\[LessEqual]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}]}], "&&",
           
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}], 
           "\[LessEqual]", "z", "\[LessEqual]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}], "<",
            "y", "<", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "2"}], "]"}]}], "&&",
           
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               SuperscriptBox["x", "3"], "-", 
               RowBox[{"9", " ", 
                SuperscriptBox["y", "3"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}], 
           "\[LessEqual]", "z", "\[LessEqual]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "2"}], "]"}]}], "&&",
           
          RowBox[{"z", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               SuperscriptBox["x", "3"], "-", 
               RowBox[{"9", " ", 
                SuperscriptBox["y", "3"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
         ")"}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "42994233"}], "-", 
           RowBox[{"139968", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"163296", " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{"129140163", " ", 
            SuperscriptBox["#1", "8"]}], "-", 
           RowBox[{"108864", " ", 
            SuperscriptBox["#1", "9"]}], "+", 
           RowBox[{"45360", " ", 
            SuperscriptBox["#1", "12"]}], "-", 
           RowBox[{"12096", " ", 
            SuperscriptBox["#1", "15"]}], "-", 
           RowBox[{"129140163", " ", 
            SuperscriptBox["#1", "16"]}], "+", 
           RowBox[{"2016", " ", 
            SuperscriptBox["#1", "18"]}], "-", 
           RowBox[{"192", " ", 
            SuperscriptBox["#1", "21"]}], "+", 
           RowBox[{"43046729", " ", 
            SuperscriptBox["#1", "24"]}]}], "&"}], ",", "2"}], "]"}]}], "&&", 
      
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}]}], 
          "&&", 
          RowBox[{"z", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               SuperscriptBox["x", "3"], "-", 
               RowBox[{"9", " ", 
                SuperscriptBox["y", "3"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "1"}], "]"}], "<", 
           "y", "<", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "4"}], "]"}]}], "&&",
           
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               SuperscriptBox["x", "3"], "-", 
               RowBox[{"9", " ", 
                SuperscriptBox["y", "3"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}], 
           "\[LessEqual]", "z", "\[LessEqual]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "4"}], "]"}]}], "&&",
           
          RowBox[{"z", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
         ")"}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "42994233"}], "-", 
           RowBox[{"139968", " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{"163296", " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{"129140163", " ", 
            SuperscriptBox["#1", "8"]}], "-", 
           RowBox[{"108864", " ", 
            SuperscriptBox["#1", "9"]}], "+", 
           RowBox[{"45360", " ", 
            SuperscriptBox["#1", "12"]}], "-", 
           RowBox[{"12096", " ", 
            SuperscriptBox["#1", "15"]}], "-", 
           RowBox[{"129140163", " ", 
            SuperscriptBox["#1", "16"]}], "+", 
           RowBox[{"2016", " ", 
            SuperscriptBox["#1", "18"]}], "-", 
           RowBox[{"192", " ", 
            SuperscriptBox["#1", "21"]}], "+", 
           RowBox[{"43046729", " ", 
            SuperscriptBox["#1", "24"]}]}], "&"}], ",", "2"}], "]"}], "<", 
       "x", "<", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "2618196522352684701774606608633544092649073499"}], 
           "+", 
           RowBox[{"112137303438920075611127400135124077321328320", " ", 
            SuperscriptBox["#1", "3"]}], "-", 
           RowBox[{"132814474280704167113940479747995449194074080", " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{"39146793368921485441556580804351146802749608125", " ", 
            SuperscriptBox["#1", "8"]}], "+", 
           RowBox[{"91856705198484666269070399879775363171210560", " ", 
            SuperscriptBox["#1", "9"]}], "-", 
           RowBox[{"1341175495662621729806372147543199870137760000", " ", 
            SuperscriptBox["#1", "11"]}], "-", 
           RowBox[{"42141596434943420720542775053872665433472560", " ", 
            SuperscriptBox["#1", "12"]}], "+", 
           RowBox[{"1582589878455148632715539236814693300312720000", " ", 
            SuperscriptBox["#1", "14"]}], "+", 
           RowBox[{"14592876096802804747928270810337344964750144", " ", 
            SuperscriptBox["#1", "15"]}], "-", 
           RowBox[{"273273142366140173367879981297464977692294766875", " ", 
            SuperscriptBox["#1", "16"]}], "-", 
           RowBox[{"1084874600671729351240909310589456169549920000", " ", 
            SuperscriptBox["#1", "17"]}], "-", 
           RowBox[{"4672251468213613165500303866540607470285280", " ", 
            SuperscriptBox["#1", "18"]}], "+", 
           RowBox[{"7356344450939568322500928613721519152461680000", " ", 
            SuperscriptBox["#1", "19"]}], "+", 
           RowBox[{"486826623827220403020230939919133417925160000", " ", 
            SuperscriptBox["#1", "20"]}], "+", 
           RowBox[{"1621571466270389965629654616387930805757120", " ", 
            SuperscriptBox["#1", "21"]}], "-", 
           RowBox[{"8653932056131816411521412982277635828456280000", " ", 
            SuperscriptBox["#1", "22"]}], "-", 
           RowBox[{"159993801360094923449431503286528552237920000", " ", 
            SuperscriptBox["#1", "23"]}], "+", 
           RowBox[{"1181424427392038088337249041705578494130159397085", " ", 
            SuperscriptBox["#1", "24"]}], "+", 
           RowBox[{"5888520338213011791817834072101573901146000000", " ", 
            SuperscriptBox["#1", "25"]}], "+", 
           RowBox[{"46801330922844246880795344194337790150800000", " ", 
            SuperscriptBox["#1", "26"]}], "-", 
           RowBox[{"24467334554119716937184952245655314221972911360", " ", 
            SuperscriptBox["#1", "27"]}], "-", 
           RowBox[{"2592683832594860546674917271501222308863100000", " ", 
            SuperscriptBox["#1", "28"]}], "-", 
           RowBox[{"15023717692172852187405796260244955218080000", " ", 
            SuperscriptBox["#1", "29"]}], "+", 
           RowBox[{"28712264151480474791676088438741348538206419072", " ", 
            SuperscriptBox["#1", "30"]}], "+", 
           RowBox[{"812007928880976140189494202018689306183440000", " ", 
            SuperscriptBox["#1", "31"]}], "-", 
           RowBox[{"3537388434852562446245779712340529662767287374375", " ", 
            SuperscriptBox["#1", "32"]}], "-", 
           RowBox[{"19419692926214247862900336814814700349248715520", " ", 
            SuperscriptBox["#1", "33"]}], "-", 
           RowBox[{"215801930758779344936762324367020005964760000", " ", 
            SuperscriptBox["#1", "34"]}], "+", 
           RowBox[{"54956519692073469839737650809448309844165320000", " ", 
            SuperscriptBox["#1", "35"]}], "+", 
           RowBox[{"8416105250955529068503592692330519350762985280", " ", 
            SuperscriptBox["#1", "36"]}], "+", 
           RowBox[{"62749943086937329078155618392566103762160000", " ", 
            SuperscriptBox["#1", "37"]}], "-", 
           RowBox[{"64367630445629017037391403984608079326797460000", " ", 
            SuperscriptBox["#1", "38"]}], "-", 
           RowBox[{"2525641537787781382376498550629952426026914560", " ", 
            SuperscriptBox["#1", "39"]}], "+", 
           RowBox[{"7769879867923988538207935524603223179597438700625", " ", 
            SuperscriptBox["#1", "40"]}], "+", 
           RowBox[{"43329124582475416283094388364421875447511480000", " ", 
            SuperscriptBox["#1", "41"]}], "+", 
           RowBox[{"608571619842211233122870844723209029615839360", " ", 
            SuperscriptBox["#1", "42"]}], "-", 
           RowBox[{"87814264603382842854822220404984016052585280000", " ", 
            SuperscriptBox["#1", "43"]}], "-", 
           RowBox[{"18540585580851717955554798423035685485022690000", " ", 
            SuperscriptBox["#1", "44"]}], "-", 
           RowBox[{"156306036132841583716281672642560892872625408", " ", 
            SuperscriptBox["#1", "45"]}], "+", 
           RowBox[{"102705768764820593232701679939710711938148640000", " ", 
            SuperscriptBox["#1", "46"]}], "+", 
           RowBox[{"5366064551542083207779168329149533496316920000", " ", 
            SuperscriptBox["#1", "47"]}], "-", 
           RowBox[{
           "12933319682733588182976356272163450519472577361975", " ", 
            SuperscriptBox["#1", "48"]}], "-", 
           RowBox[{"68888356902963978599391691551819737543190720000", " ", 
            SuperscriptBox["#1", "49"]}], "-", 
           RowBox[{"1175665676613966204279385048731055803883860000", " ", 
            SuperscriptBox["#1", "50"]}], "+", 
           RowBox[{"102349284026470938371782065432062687964569222400", " ", 
            SuperscriptBox["#1", "51"]}], "+", 
           RowBox[{"29190269364846825839973582629765084651591760000", " ", 
            SuperscriptBox["#1", "52"]}], "+", 
           RowBox[{"259374843939446832787459753544489388431880000", " ", 
            SuperscriptBox["#1", "53"]}], "-", 
           RowBox[{"119587139497995006342197262000331067394096028800", " ", 
            SuperscriptBox["#1", "54"]}], "-", 
           RowBox[{"8205916620950552633901449156541143750450880000", " ", 
            SuperscriptBox["#1", "55"]}], "+", 
           RowBox[{
           "16612091542028724056189112117561283747502505950625", " ", 
            SuperscriptBox["#1", "56"]}], "+", 
           RowBox[{"80004420208874816613224028609118173868304044800", " ", 
            SuperscriptBox["#1", "57"]}], "+", 
           RowBox[{"1648899263817925705121815992021920771761440000", " ", 
            SuperscriptBox["#1", "58"]}], "-", 
           RowBox[{"87665562868557594190677261244388005157686080000", " ", 
            SuperscriptBox["#1", "59"]}], "-", 
           RowBox[{"33659799063004124213882498578714308256508431680", " ", 
            SuperscriptBox["#1", "60"]}], "-", 
           RowBox[{"304376591320557139693314112878863610419520000", " ", 
            SuperscriptBox["#1", "61"]}], "+", 
           RowBox[{"102367132287597953565962994166169290757271840000", " ", 
            SuperscriptBox["#1", "62"]}], "+", 
           RowBox[{"9257163005429436876882202557014641599211027200", " ", 
            SuperscriptBox["#1", "63"]}], "-", 
           RowBox[{
           "16599758863903187132239700274652562160030244580625", " ", 
            SuperscriptBox["#1", "64"]}], "-", 
           RowBox[{"68366264026784452691041760938370396396003520000", " ", 
            SuperscriptBox["#1", "65"]}], "-", 
           RowBox[{"1730333554954169873611503086841804695577244800", " ", 
            SuperscriptBox["#1", "66"]}], "+", 
           RowBox[{"54763204308086194241501487468704819730450120000", " ", 
            SuperscriptBox["#1", "67"]}], "+", 
           RowBox[{"28625238073607620492282326877769441262734160000", " ", 
            SuperscriptBox["#1", "68"]}], "+", 
           RowBox[{"262996675955904001926787571198960559623865600", " ", 
            SuperscriptBox["#1", "69"]}], "-", 
           RowBox[{"63927391124183312791754433167377126419456660000", " ", 
            SuperscriptBox["#1", "70"]}], "-", 
           RowBox[{"7753929047003383073397617193398919823922880000", " ", 
            SuperscriptBox["#1", "71"]}], "+", 
           RowBox[{
           "12904081346226982280605562154285759160691539102775", " ", 
            SuperscriptBox["#1", "72"]}], "+", 
           RowBox[{"42650374794315928136358667562312747263268280000", " ", 
            SuperscriptBox["#1", "73"]}], "+", 
           RowBox[{"1372664308200444591592026324160636334411040000", " ", 
            SuperscriptBox["#1", "74"]}], "-", 
           RowBox[{"24330192224494514789655337374770350707667752192", " ", 
            SuperscriptBox["#1", "75"]}], "-", 
           RowBox[{"17805994084894383068160064561294049724904290000", " ", 
            SuperscriptBox["#1", "76"]}], "-", 
           RowBox[{"172813707224560334012750477036141012377920000", " ", 
            SuperscriptBox["#1", "77"]}], "+", 
           RowBox[{"28399942154308671185921648759612368175302776960", " ", 
            SuperscriptBox["#1", "78"]}], "+", 
           RowBox[{"4778412956595368622445860449020422516912120000", " ", 
            SuperscriptBox["#1", "79"]}], "-", 
           RowBox[{"7739716518119225272823894164887244927820332880625", " ", 
            SuperscriptBox["#1", "80"]}], "-", 
           RowBox[{"18938148902700282758237541155853595804003818240", " ", 
            SuperscriptBox["#1", "81"]}], "-", 
           RowBox[{"816488724555469657654545787895529399711060000", " ", 
            SuperscriptBox["#1", "82"]}], "+", 
           RowBox[{"7296858294042704418061125066571398260373360000", " ", 
            SuperscriptBox["#1", "83"]}], "+", 
           RowBox[{"7894918722252097363756733535000107407825615680", " ", 
            SuperscriptBox["#1", "84"]}], "+", 
           RowBox[{"88281801526603013508862318022814564163080000", " ", 
            SuperscriptBox["#1", "85"]}], "-", 
           RowBox[{"8518456644360681975737407018339545163281240000", " ", 
            SuperscriptBox["#1", "86"]}], "-", 
           RowBox[{"2108672407972653082729083376940532733527847680", " ", 
            SuperscriptBox["#1", "87"]}], "+", 
           RowBox[{"3517309276665022732685811568661876577620337744375", " ", 
            SuperscriptBox["#1", "88"]}], "+", 
           RowBox[{"5679632344998648546512579795877443006666640000", " ", 
            SuperscriptBox["#1", "89"]}], "+", 
           RowBox[{"353677893356315750550316740327368006350342272", " ", 
            SuperscriptBox["#1", "90"]}], "-", 
           RowBox[{"1326302987927784759457772780540558196865440000", " ", 
            SuperscriptBox["#1", "91"]}], "-", 
           RowBox[{"2366582357168305977580095813080181113432700000", " ", 
            SuperscriptBox["#1", "92"]}], "-", 
           RowBox[{"34852629611923609899244650713526533868023040", " ", 
            SuperscriptBox["#1", "93"]}], "+", 
           RowBox[{"1548717310907078775829818316566134361601680000", " ", 
            SuperscriptBox["#1", "94"]}], "+", 
           RowBox[{"631094280277848382313861941203902638909200000", " ", 
            SuperscriptBox["#1", "95"]}], "-", 
           RowBox[{"1172312695762124031690192344345807052060166385965", " ", 
            SuperscriptBox["#1", "96"]}], "-", 
           RowBox[{"1032643519437328344321445223025112312126560000", " ", 
            SuperscriptBox["#1", "97"]}], "-", 
           RowBox[{"105182716457011345078522983571228368962520000", " ", 
            SuperscriptBox["#1", "98"]}], "+", 
           RowBox[{"110484659009863463733574569256113624845465280", " ", 
            SuperscriptBox["#1", "99"]}], "+", 
           RowBox[{"430285353118795373628887591244084593755560000", " ", 
            SuperscriptBox["#1", "100"]}], "+", 
           RowBox[{"10017414382980503861733953120029986800880000", " ", 
            SuperscriptBox["#1", "101"]}], "-", 
           RowBox[{"129050304905153671105623220758057551634624480", " ", 
            SuperscriptBox["#1", "102"]}], "-", 
           RowBox[{"114744173756512190403275159458628937840480000", " ", 
            SuperscriptBox["#1", "103"]}], "+", 
           RowBox[{"270524153931355107361142975288559200669258266875", " ", 
            SuperscriptBox["#1", "104"]}], "+", 
           RowBox[{"86051904618376655059098105797611845779240256", " ", 
            SuperscriptBox["#1", "105"]}], "+", 
           RowBox[{"19124113062091680117605596372788119970960000", " ", 
            SuperscriptBox["#1", "106"]}], "-", 
           RowBox[{"35856873592983761706727696842043851656858160", " ", 
            SuperscriptBox["#1", "108"]}], "-", 
           RowBox[{"1821347305063040569017930666661064484000000", " ", 
            SuperscriptBox["#1", "109"]}], "+", 
           RowBox[{"9561989949766059189667676243578440624786240", " ", 
            SuperscriptBox["#1", "111"]}], "-", 
           RowBox[{"38646291442449791560158201666841790621818288125", " ", 
            SuperscriptBox["#1", "112"]}], "-", 
           RowBox[{"1593674336368698407981121050114388435456480", " ", 
            SuperscriptBox["#1", "114"]}], "+", 
           RowBox[{"151778864215741208274407584901857202930880", " ", 
            SuperscriptBox["#1", "117"]}], "+", 
           RowBox[{"2576418164672784306167144491059578525977861451", " ", 
            SuperscriptBox["#1", "120"]}]}], "&"}], ",", "2"}], "]"}]}], "&&",
       
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}]}], "&&",
           
          RowBox[{"z", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               SuperscriptBox["x", "3"], "-", 
               RowBox[{"9", " ", 
                SuperscriptBox["y", "3"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}], "<",
            "y", "<", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "2"}], "]"}]}], "&&",
           
          RowBox[{
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "3"}], "+", 
               SuperscriptBox["x", "3"], "-", 
               RowBox[{"9", " ", 
                SuperscriptBox["y", "3"]}], "+", 
               RowBox[{"7", " ", 
                SuperscriptBox["#1", "3"]}]}], "&"}], ",", "1"}], "]"}], 
           "\[LessEqual]", "z", "\[LessEqual]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
         ")"}], "||", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"y", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "5587654"}], "-", 
               RowBox[{"472392", " ", 
                SuperscriptBox["x", "3"]}], "+", 
               RowBox[{"551124", " ", 
                SuperscriptBox["x", "6"]}], "+", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "8"]}], "-", 
               RowBox[{"367416", " ", 
                SuperscriptBox["x", "9"]}], "+", 
               RowBox[{"153090", " ", 
                SuperscriptBox["x", "12"]}], "-", 
               RowBox[{"40824", " ", 
                SuperscriptBox["x", "15"]}], "-", 
               RowBox[{"17294403", " ", 
                SuperscriptBox["x", "16"]}], "+", 
               RowBox[{"6804", " ", 
                SuperscriptBox["x", "18"]}], "-", 
               RowBox[{"648", " ", 
                SuperscriptBox["x", "21"]}], "+", 
               RowBox[{"5764828", " ", 
                SuperscriptBox["x", "24"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4251528", "-", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"9920232", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"5511240", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"1837080", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"367416", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"40824", " ", 
                   SuperscriptBox["x", "18"]}], "-", 
                  RowBox[{"1944", " ", 
                   SuperscriptBox["x", "21"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "3"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"44641044", "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"74401740", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"33067440", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"8266860", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}], "+", 
                  RowBox[{"61236", " ", 
                   SuperscriptBox["x", "18"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "6"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"34588806", "-", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}], "+", 
                  RowBox[{"34588806", " ", 
                   SuperscriptBox["x", "16"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "8"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"267846264", "-", 
                  RowBox[{"446410440", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"297606960", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"99202320", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"16533720", " ", 
                   SuperscriptBox["x", "12"]}], "-", 
                  RowBox[{"1102248", " ", 
                   SuperscriptBox["x", "15"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "9"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1004423490", "-", 
                  RowBox[{"1339231320", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"669615660", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"148803480", " ", 
                   SuperscriptBox["x", "9"]}], "+", 
                  RowBox[{"12400290", " ", 
                   SuperscriptBox["x", "12"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "12"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"2410616376", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"803538792", " ", 
                   SuperscriptBox["x", "6"]}], "-", 
                  RowBox[{"89282088", " ", 
                   SuperscriptBox["x", "9"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "15"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "69177612"}], "+", 
                  RowBox[{"69177612", " ", 
                   SuperscriptBox["x", "8"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "16"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3615924564", "-", 
                  RowBox[{"2410616376", " ", 
                   SuperscriptBox["x", "3"]}], "+", 
                  RowBox[{"401769396", " ", 
                   SuperscriptBox["x", "6"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "18"]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"3099363912", "-", 
                  RowBox[{"1033121304", " ", 
                   SuperscriptBox["x", "3"]}]}], ")"}], " ", 
                SuperscriptBox["#1", "21"]}], "+", 
               RowBox[{"1208379875", " ", 
                SuperscriptBox["#1", "24"]}]}], "&"}], ",", "2"}], "]"}]}], "&&",
           
          RowBox[{"z", "\[Equal]", 
           RowBox[{"Root", "[", 
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SuperscriptBox["x", "8"], "+", 
               RowBox[{"2", " ", 
                SuperscriptBox["y", "8"]}], "+", 
               RowBox[{"3", " ", 
                SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
         ")"}]}], ")"}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "2618196522352684701774606608633544092649073499"}], 
           "+", 
           RowBox[{"112137303438920075611127400135124077321328320", " ", 
            SuperscriptBox["#1", "3"]}], "-", 
           RowBox[{"132814474280704167113940479747995449194074080", " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{"39146793368921485441556580804351146802749608125", " ", 
            SuperscriptBox["#1", "8"]}], "+", 
           RowBox[{"91856705198484666269070399879775363171210560", " ", 
            SuperscriptBox["#1", "9"]}], "-", 
           RowBox[{"1341175495662621729806372147543199870137760000", " ", 
            SuperscriptBox["#1", "11"]}], "-", 
           RowBox[{"42141596434943420720542775053872665433472560", " ", 
            SuperscriptBox["#1", "12"]}], "+", 
           RowBox[{"1582589878455148632715539236814693300312720000", " ", 
            SuperscriptBox["#1", "14"]}], "+", 
           RowBox[{"14592876096802804747928270810337344964750144", " ", 
            SuperscriptBox["#1", "15"]}], "-", 
           RowBox[{"273273142366140173367879981297464977692294766875", " ", 
            SuperscriptBox["#1", "16"]}], "-", 
           RowBox[{"1084874600671729351240909310589456169549920000", " ", 
            SuperscriptBox["#1", "17"]}], "-", 
           RowBox[{"4672251468213613165500303866540607470285280", " ", 
            SuperscriptBox["#1", "18"]}], "+", 
           RowBox[{"7356344450939568322500928613721519152461680000", " ", 
            SuperscriptBox["#1", "19"]}], "+", 
           RowBox[{"486826623827220403020230939919133417925160000", " ", 
            SuperscriptBox["#1", "20"]}], "+", 
           RowBox[{"1621571466270389965629654616387930805757120", " ", 
            SuperscriptBox["#1", "21"]}], "-", 
           RowBox[{"8653932056131816411521412982277635828456280000", " ", 
            SuperscriptBox["#1", "22"]}], "-", 
           RowBox[{"159993801360094923449431503286528552237920000", " ", 
            SuperscriptBox["#1", "23"]}], "+", 
           RowBox[{"1181424427392038088337249041705578494130159397085", " ", 
            SuperscriptBox["#1", "24"]}], "+", 
           RowBox[{"5888520338213011791817834072101573901146000000", " ", 
            SuperscriptBox["#1", "25"]}], "+", 
           RowBox[{"46801330922844246880795344194337790150800000", " ", 
            SuperscriptBox["#1", "26"]}], "-", 
           RowBox[{"24467334554119716937184952245655314221972911360", " ", 
            SuperscriptBox["#1", "27"]}], "-", 
           RowBox[{"2592683832594860546674917271501222308863100000", " ", 
            SuperscriptBox["#1", "28"]}], "-", 
           RowBox[{"15023717692172852187405796260244955218080000", " ", 
            SuperscriptBox["#1", "29"]}], "+", 
           RowBox[{"28712264151480474791676088438741348538206419072", " ", 
            SuperscriptBox["#1", "30"]}], "+", 
           RowBox[{"812007928880976140189494202018689306183440000", " ", 
            SuperscriptBox["#1", "31"]}], "-", 
           RowBox[{"3537388434852562446245779712340529662767287374375", " ", 
            SuperscriptBox["#1", "32"]}], "-", 
           RowBox[{"19419692926214247862900336814814700349248715520", " ", 
            SuperscriptBox["#1", "33"]}], "-", 
           RowBox[{"215801930758779344936762324367020005964760000", " ", 
            SuperscriptBox["#1", "34"]}], "+", 
           RowBox[{"54956519692073469839737650809448309844165320000", " ", 
            SuperscriptBox["#1", "35"]}], "+", 
           RowBox[{"8416105250955529068503592692330519350762985280", " ", 
            SuperscriptBox["#1", "36"]}], "+", 
           RowBox[{"62749943086937329078155618392566103762160000", " ", 
            SuperscriptBox["#1", "37"]}], "-", 
           RowBox[{"64367630445629017037391403984608079326797460000", " ", 
            SuperscriptBox["#1", "38"]}], "-", 
           RowBox[{"2525641537787781382376498550629952426026914560", " ", 
            SuperscriptBox["#1", "39"]}], "+", 
           RowBox[{"7769879867923988538207935524603223179597438700625", " ", 
            SuperscriptBox["#1", "40"]}], "+", 
           RowBox[{"43329124582475416283094388364421875447511480000", " ", 
            SuperscriptBox["#1", "41"]}], "+", 
           RowBox[{"608571619842211233122870844723209029615839360", " ", 
            SuperscriptBox["#1", "42"]}], "-", 
           RowBox[{"87814264603382842854822220404984016052585280000", " ", 
            SuperscriptBox["#1", "43"]}], "-", 
           RowBox[{"18540585580851717955554798423035685485022690000", " ", 
            SuperscriptBox["#1", "44"]}], "-", 
           RowBox[{"156306036132841583716281672642560892872625408", " ", 
            SuperscriptBox["#1", "45"]}], "+", 
           RowBox[{"102705768764820593232701679939710711938148640000", " ", 
            SuperscriptBox["#1", "46"]}], "+", 
           RowBox[{"5366064551542083207779168329149533496316920000", " ", 
            SuperscriptBox["#1", "47"]}], "-", 
           RowBox[{
           "12933319682733588182976356272163450519472577361975", " ", 
            SuperscriptBox["#1", "48"]}], "-", 
           RowBox[{"68888356902963978599391691551819737543190720000", " ", 
            SuperscriptBox["#1", "49"]}], "-", 
           RowBox[{"1175665676613966204279385048731055803883860000", " ", 
            SuperscriptBox["#1", "50"]}], "+", 
           RowBox[{"102349284026470938371782065432062687964569222400", " ", 
            SuperscriptBox["#1", "51"]}], "+", 
           RowBox[{"29190269364846825839973582629765084651591760000", " ", 
            SuperscriptBox["#1", "52"]}], "+", 
           RowBox[{"259374843939446832787459753544489388431880000", " ", 
            SuperscriptBox["#1", "53"]}], "-", 
           RowBox[{"119587139497995006342197262000331067394096028800", " ", 
            SuperscriptBox["#1", "54"]}], "-", 
           RowBox[{"8205916620950552633901449156541143750450880000", " ", 
            SuperscriptBox["#1", "55"]}], "+", 
           RowBox[{
           "16612091542028724056189112117561283747502505950625", " ", 
            SuperscriptBox["#1", "56"]}], "+", 
           RowBox[{"80004420208874816613224028609118173868304044800", " ", 
            SuperscriptBox["#1", "57"]}], "+", 
           RowBox[{"1648899263817925705121815992021920771761440000", " ", 
            SuperscriptBox["#1", "58"]}], "-", 
           RowBox[{"87665562868557594190677261244388005157686080000", " ", 
            SuperscriptBox["#1", "59"]}], "-", 
           RowBox[{"33659799063004124213882498578714308256508431680", " ", 
            SuperscriptBox["#1", "60"]}], "-", 
           RowBox[{"304376591320557139693314112878863610419520000", " ", 
            SuperscriptBox["#1", "61"]}], "+", 
           RowBox[{"102367132287597953565962994166169290757271840000", " ", 
            SuperscriptBox["#1", "62"]}], "+", 
           RowBox[{"9257163005429436876882202557014641599211027200", " ", 
            SuperscriptBox["#1", "63"]}], "-", 
           RowBox[{
           "16599758863903187132239700274652562160030244580625", " ", 
            SuperscriptBox["#1", "64"]}], "-", 
           RowBox[{"68366264026784452691041760938370396396003520000", " ", 
            SuperscriptBox["#1", "65"]}], "-", 
           RowBox[{"1730333554954169873611503086841804695577244800", " ", 
            SuperscriptBox["#1", "66"]}], "+", 
           RowBox[{"54763204308086194241501487468704819730450120000", " ", 
            SuperscriptBox["#1", "67"]}], "+", 
           RowBox[{"28625238073607620492282326877769441262734160000", " ", 
            SuperscriptBox["#1", "68"]}], "+", 
           RowBox[{"262996675955904001926787571198960559623865600", " ", 
            SuperscriptBox["#1", "69"]}], "-", 
           RowBox[{"63927391124183312791754433167377126419456660000", " ", 
            SuperscriptBox["#1", "70"]}], "-", 
           RowBox[{"7753929047003383073397617193398919823922880000", " ", 
            SuperscriptBox["#1", "71"]}], "+", 
           RowBox[{
           "12904081346226982280605562154285759160691539102775", " ", 
            SuperscriptBox["#1", "72"]}], "+", 
           RowBox[{"42650374794315928136358667562312747263268280000", " ", 
            SuperscriptBox["#1", "73"]}], "+", 
           RowBox[{"1372664308200444591592026324160636334411040000", " ", 
            SuperscriptBox["#1", "74"]}], "-", 
           RowBox[{"24330192224494514789655337374770350707667752192", " ", 
            SuperscriptBox["#1", "75"]}], "-", 
           RowBox[{"17805994084894383068160064561294049724904290000", " ", 
            SuperscriptBox["#1", "76"]}], "-", 
           RowBox[{"172813707224560334012750477036141012377920000", " ", 
            SuperscriptBox["#1", "77"]}], "+", 
           RowBox[{"28399942154308671185921648759612368175302776960", " ", 
            SuperscriptBox["#1", "78"]}], "+", 
           RowBox[{"4778412956595368622445860449020422516912120000", " ", 
            SuperscriptBox["#1", "79"]}], "-", 
           RowBox[{"7739716518119225272823894164887244927820332880625", " ", 
            SuperscriptBox["#1", "80"]}], "-", 
           RowBox[{"18938148902700282758237541155853595804003818240", " ", 
            SuperscriptBox["#1", "81"]}], "-", 
           RowBox[{"816488724555469657654545787895529399711060000", " ", 
            SuperscriptBox["#1", "82"]}], "+", 
           RowBox[{"7296858294042704418061125066571398260373360000", " ", 
            SuperscriptBox["#1", "83"]}], "+", 
           RowBox[{"7894918722252097363756733535000107407825615680", " ", 
            SuperscriptBox["#1", "84"]}], "+", 
           RowBox[{"88281801526603013508862318022814564163080000", " ", 
            SuperscriptBox["#1", "85"]}], "-", 
           RowBox[{"8518456644360681975737407018339545163281240000", " ", 
            SuperscriptBox["#1", "86"]}], "-", 
           RowBox[{"2108672407972653082729083376940532733527847680", " ", 
            SuperscriptBox["#1", "87"]}], "+", 
           RowBox[{"3517309276665022732685811568661876577620337744375", " ", 
            SuperscriptBox["#1", "88"]}], "+", 
           RowBox[{"5679632344998648546512579795877443006666640000", " ", 
            SuperscriptBox["#1", "89"]}], "+", 
           RowBox[{"353677893356315750550316740327368006350342272", " ", 
            SuperscriptBox["#1", "90"]}], "-", 
           RowBox[{"1326302987927784759457772780540558196865440000", " ", 
            SuperscriptBox["#1", "91"]}], "-", 
           RowBox[{"2366582357168305977580095813080181113432700000", " ", 
            SuperscriptBox["#1", "92"]}], "-", 
           RowBox[{"34852629611923609899244650713526533868023040", " ", 
            SuperscriptBox["#1", "93"]}], "+", 
           RowBox[{"1548717310907078775829818316566134361601680000", " ", 
            SuperscriptBox["#1", "94"]}], "+", 
           RowBox[{"631094280277848382313861941203902638909200000", " ", 
            SuperscriptBox["#1", "95"]}], "-", 
           RowBox[{"1172312695762124031690192344345807052060166385965", " ", 
            SuperscriptBox["#1", "96"]}], "-", 
           RowBox[{"1032643519437328344321445223025112312126560000", " ", 
            SuperscriptBox["#1", "97"]}], "-", 
           RowBox[{"105182716457011345078522983571228368962520000", " ", 
            SuperscriptBox["#1", "98"]}], "+", 
           RowBox[{"110484659009863463733574569256113624845465280", " ", 
            SuperscriptBox["#1", "99"]}], "+", 
           RowBox[{"430285353118795373628887591244084593755560000", " ", 
            SuperscriptBox["#1", "100"]}], "+", 
           RowBox[{"10017414382980503861733953120029986800880000", " ", 
            SuperscriptBox["#1", "101"]}], "-", 
           RowBox[{"129050304905153671105623220758057551634624480", " ", 
            SuperscriptBox["#1", "102"]}], "-", 
           RowBox[{"114744173756512190403275159458628937840480000", " ", 
            SuperscriptBox["#1", "103"]}], "+", 
           RowBox[{"270524153931355107361142975288559200669258266875", " ", 
            SuperscriptBox["#1", "104"]}], "+", 
           RowBox[{"86051904618376655059098105797611845779240256", " ", 
            SuperscriptBox["#1", "105"]}], "+", 
           RowBox[{"19124113062091680117605596372788119970960000", " ", 
            SuperscriptBox["#1", "106"]}], "-", 
           RowBox[{"35856873592983761706727696842043851656858160", " ", 
            SuperscriptBox["#1", "108"]}], "-", 
           RowBox[{"1821347305063040569017930666661064484000000", " ", 
            SuperscriptBox["#1", "109"]}], "+", 
           RowBox[{"9561989949766059189667676243578440624786240", " ", 
            SuperscriptBox["#1", "111"]}], "-", 
           RowBox[{"38646291442449791560158201666841790621818288125", " ", 
            SuperscriptBox["#1", "112"]}], "-", 
           RowBox[{"1593674336368698407981121050114388435456480", " ", 
            SuperscriptBox["#1", "114"]}], "+", 
           RowBox[{"151778864215741208274407584901857202930880", " ", 
            SuperscriptBox["#1", "117"]}], "+", 
           RowBox[{"2576418164672784306167144491059578525977861451", " ", 
            SuperscriptBox["#1", "120"]}]}], "&"}], ",", "2"}], "]"}]}], "&&",
       
      RowBox[{"y", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "5587654"}], "-", 
           RowBox[{"472392", " ", 
            SuperscriptBox["x", "3"]}], "+", 
           RowBox[{"551124", " ", 
            SuperscriptBox["x", "6"]}], "+", 
           RowBox[{"17294403", " ", 
            SuperscriptBox["x", "8"]}], "-", 
           RowBox[{"367416", " ", 
            SuperscriptBox["x", "9"]}], "+", 
           RowBox[{"153090", " ", 
            SuperscriptBox["x", "12"]}], "-", 
           RowBox[{"40824", " ", 
            SuperscriptBox["x", "15"]}], "-", 
           RowBox[{"17294403", " ", 
            SuperscriptBox["x", "16"]}], "+", 
           RowBox[{"6804", " ", 
            SuperscriptBox["x", "18"]}], "-", 
           RowBox[{"648", " ", 
            SuperscriptBox["x", "21"]}], "+", 
           RowBox[{"5764828", " ", 
            SuperscriptBox["x", "24"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"4251528", "-", 
              RowBox[{"9920232", " ", 
               SuperscriptBox["x", "3"]}], "+", 
              RowBox[{"9920232", " ", 
               SuperscriptBox["x", "6"]}], "-", 
              RowBox[{"5511240", " ", 
               SuperscriptBox["x", "9"]}], "+", 
              RowBox[{"1837080", " ", 
               SuperscriptBox["x", "12"]}], "-", 
              RowBox[{"367416", " ", 
               SuperscriptBox["x", "15"]}], "+", 
              RowBox[{"40824", " ", 
               SuperscriptBox["x", "18"]}], "-", 
              RowBox[{"1944", " ", 
               SuperscriptBox["x", "21"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "3"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"44641044", "-", 
              RowBox[{"89282088", " ", 
               SuperscriptBox["x", "3"]}], "+", 
              RowBox[{"74401740", " ", 
               SuperscriptBox["x", "6"]}], "-", 
              RowBox[{"33067440", " ", 
               SuperscriptBox["x", "9"]}], "+", 
              RowBox[{"8266860", " ", 
               SuperscriptBox["x", "12"]}], "-", 
              RowBox[{"1102248", " ", 
               SuperscriptBox["x", "15"]}], "+", 
              RowBox[{"61236", " ", 
               SuperscriptBox["x", "18"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "6"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"34588806", "-", 
              RowBox[{"69177612", " ", 
               SuperscriptBox["x", "8"]}], "+", 
              RowBox[{"34588806", " ", 
               SuperscriptBox["x", "16"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "8"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"267846264", "-", 
              RowBox[{"446410440", " ", 
               SuperscriptBox["x", "3"]}], "+", 
              RowBox[{"297606960", " ", 
               SuperscriptBox["x", "6"]}], "-", 
              RowBox[{"99202320", " ", 
               SuperscriptBox["x", "9"]}], "+", 
              RowBox[{"16533720", " ", 
               SuperscriptBox["x", "12"]}], "-", 
              RowBox[{"1102248", " ", 
               SuperscriptBox["x", "15"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "9"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1004423490", "-", 
              RowBox[{"1339231320", " ", 
               SuperscriptBox["x", "3"]}], "+", 
              RowBox[{"669615660", " ", 
               SuperscriptBox["x", "6"]}], "-", 
              RowBox[{"148803480", " ", 
               SuperscriptBox["x", "9"]}], "+", 
              RowBox[{"12400290", " ", 
               SuperscriptBox["x", "12"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "12"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2410616376", "-", 
              RowBox[{"2410616376", " ", 
               SuperscriptBox["x", "3"]}], "+", 
              RowBox[{"803538792", " ", 
               SuperscriptBox["x", "6"]}], "-", 
              RowBox[{"89282088", " ", 
               SuperscriptBox["x", "9"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "15"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "69177612"}], "+", 
              RowBox[{"69177612", " ", 
               SuperscriptBox["x", "8"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "16"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3615924564", "-", 
              RowBox[{"2410616376", " ", 
               SuperscriptBox["x", "3"]}], "+", 
              RowBox[{"401769396", " ", 
               SuperscriptBox["x", "6"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "18"]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"3099363912", "-", 
              RowBox[{"1033121304", " ", 
               SuperscriptBox["x", "3"]}]}], ")"}], " ", 
            SuperscriptBox["#1", "21"]}], "+", 
           RowBox[{"1208379875", " ", 
            SuperscriptBox["#1", "24"]}]}], "&"}], ",", "1"}], "]"}]}], "&&", 
      
      RowBox[{"z", "\[Equal]", 
       RowBox[{"Root", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"-", "1"}], "+", 
           SuperscriptBox["x", "8"], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["y", "8"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["#1", "8"]}]}], "&"}], ",", "2"}], "]"}]}]}], 
     ")"}]}]}], "}"}]], "Output",
 ImageSize->{577, 15753},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->144081711]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9858],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 " to visualize 2D semialgebraic sets: "
}], "ExampleText",
 CellID->353000079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "<", "1"}], "&&", 
    RowBox[{"y", ">", "x"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->435689485],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->660457048]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43479156],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["RegionPlot3D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot3D"]], "InlineFormula"],
 " to visualize 3D semialgebraic sets: "
}], "ExampleText",
 CellID->161036941],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot3D", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}], "+", 
     RowBox[{"z", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20660112],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 206},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->265393072]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->486659198],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Resolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Resolve"]], "InlineFormula"],
 " performs quantifier elimination, and may avoid computing cylindrical \
decomposition:"
}], "ExampleText",
 CellID->123250600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{"Exists", "[", 
    RowBox[{"z", ",", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}], "+", 
        RowBox[{"z", "^", "2"}]}], "<", "1"}], "&&", 
      RowBox[{"y", ">", "x"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->503633744],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "\[LessEqual]", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}], "<", "x", "<", 
     FractionBox["1", 
      SqrtBox["2"]]}], "&&", 
    RowBox[{"x", "<", "y", "<", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{513, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->518819656]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Resolve", "[", 
  RowBox[{"Exists", "[", 
   RowBox[{"z", ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"z", "^", "2"}]}], "<", "1"}], "&&", 
     RowBox[{"y", ">", "x"}]}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->458866655],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "|", "y"}], ")"}], "\[Element]", "Reals"}], "&&", 
  RowBox[{
   RowBox[{"x", "-", "y"}], "<", "0"}], "&&", 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], "<", "1"}]}]], "Output",
 ImageSize->{240, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->195668739]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->722607045],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " in addition deals with different domains and transcendental functions:"
}], "ExampleText",
 CellID->414648690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"2", 
      RowBox[{"y", "^", "2"}]}]}], "==", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Complexes"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28035033],

Cell[BoxData[
 RowBox[{
  RowBox[{"y", "\[Equal]", 
   RowBox[{"-", 
    FractionBox[
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       SuperscriptBox["x", "2"]}]], 
     SqrtBox["2"]]}]}], "||", 
  RowBox[{"y", "\[Equal]", 
   FractionBox[
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["x", "2"]}]], 
    SqrtBox["2"]]}]}]], "Output",
 ImageSize->{205, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->109836344]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"2", 
       RowBox[{"y", "^", "2"}]}]}], "==", "1"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Reals"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->236774702],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", ">", "1"}], "&&", 
  RowBox[{"y", "\[Equal]", 
   FractionBox[
    SqrtBox[
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["x", "2"]}]], 
    SqrtBox["2"]]}]}]], "Output",
 ImageSize->{139, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->44457420]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", 
      RowBox[{"2", 
       RowBox[{"y", "^", "2"}]}]}], "==", "1"}], "&&", 
    RowBox[{"x", ">", "0"}], "&&", 
    RowBox[{"y", ">", "0"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "Integers"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->358878365],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[GreaterEqual]", "1"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "-", 
         RowBox[{"2", " ", 
          SqrtBox["2"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"2", " ", 
          SqrtBox["2"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]]}], ")"}]}]}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "-", 
         RowBox[{"2", " ", 
          SqrtBox["2"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]], "-", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", "+", 
         RowBox[{"2", " ", 
          SqrtBox["2"]}]}], ")"}], 
       RowBox[{"C", "[", "1", "]"}]]}], 
     RowBox[{"2", " ", 
      SqrtBox["2"]}]]}]}]}]], "Output",
 ImageSize->{496, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->60741310]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Exp", "[", "x", "]"}], "-", 
      RowBox[{"2", "y"}]}], "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"x", "+", "1"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->171084875],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["3", "2"]}], "-", 
    RowBox[{"ProductLog", "[", 
     RowBox[{
      RowBox[{"C", "[", "1", "]"}], ",", 
      RowBox[{"-", 
       FractionBox["1", 
        RowBox[{"2", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"3", "/", "2"}]]}]]}]}], "]"}]}]}], "&&", 
  RowBox[{"y", "\[Equal]", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["\[ExponentialE]", "x"]}], ")"}]}]}]}]], "Output",
 ImageSize->{457, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->18422524]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->721962243],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FindInstance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FindInstance"]], "InlineFormula"],
 " to find points that satisfy equations and inequalities:"
}], "ExampleText",
 CellID->276274527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindInstance", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}], ",", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->424493338],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["220", "251"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["47", "105"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["218", "251"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["23", "51"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["16", "251"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["22", "51"]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["84", "251"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["31", "54"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["149", "251"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["47", "63"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{392, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2600620]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"y", "^", "2"}]}], "<", "1"}], "/.", "%"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->159768050],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "True", ",", "True", ",", "True"}], 
  "}"}]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->576283672]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->647969050],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SemialgebraicComponentInstances",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SemialgebraicComponentInstances"]], 
  "InlineFormula"],
 " will give sample points in each cylinder:"
}], "ExampleText",
 CellID->1031952177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SemialgebraicComponentInstances", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3107950],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", "2"]}]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", "0"}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["1", "2"]}], ",", 
     RowBox[{"y", "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      RowBox[{"-", 
       FractionBox["1", 
        SqrtBox["2"]]}]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "\[Rule]", 
      FractionBox["1", 
       SqrtBox["2"]]}], ",", 
     RowBox[{"y", "\[Rule]", "0"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{379, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->683750444]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CylindricalDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CylindricalDecomposition"]], "InlineFormula"],
 " merges several cylinders to get a more compact representation:"
}], "ExampleText",
 CellID->119097633],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->358541032],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "1"}], "<", "x", "<", "1"}], "&&", 
  RowBox[{
   RowBox[{"-", 
    SqrtBox[
     RowBox[{"1", "-", 
      SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["x", "2"]}]]}]}]], "Output",
 ImageSize->{225, 24},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->359762750]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26465616],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GenericCylindricalDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GenericCylindricalDecomposition"]], 
  "InlineFormula"],
 " will compute the full dimensional part only:"
}], "ExampleText",
 CellID->539297238],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}], "||", 
    RowBox[{"x", "\[Equal]", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8716868],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "<", "1"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]]}], "\[LessEqual]", "y", "\[LessEqual]", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"x", "\[Equal]", "1"}]}]], "Output",
 ImageSize->{413, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->152985366]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GenericCylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], "\[LessEqual]", "1"}], "||", 
    RowBox[{"x", "\[Equal]", "1"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->130547604],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "<", "1"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", "x"}], "\[Equal]", "0"}], "||", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "\[Equal]", "0"}]}]}], "}"}]], "Output",
 ImageSize->{418, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1473382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->327219555],

Cell["The output and input are equal as sets:", "ExampleText",
 CellID->866199546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"set1", "=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], "&&", 
   RowBox[{"y", ">", "x"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->95416593],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], "+", 
    SuperscriptBox["y", "2"]}], "<", "1"}], "&&", 
  RowBox[{"y", ">", "x"}]}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4748239]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"set2", "=", 
  RowBox[{"CylindricalDecomposition", "[", 
   RowBox[{"set1", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->179973059],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "\[LessEqual]", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]]}], "<", "y", "<", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}], "<", "x", "<", 
     FractionBox["1", 
      SqrtBox["2"]]}], "&&", 
    RowBox[{"x", "<", "y", "<", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["x", "2"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{513, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->149462437]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"set3", "=", 
  RowBox[{"CylindricalDecomposition", "[", 
   RowBox[{"set1", ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "x"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->224201515],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}], "<", "y", "\[LessEqual]", 
     FractionBox["1", 
      SqrtBox["2"]]}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["y", "2"]}]]}], "<", "x", "<", "y"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["1", 
      SqrtBox["2"]], "<", "y", "<", "1"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["y", "2"]}]]}], "<", "x", "<", 
     SqrtBox[
      RowBox[{"1", "-", 
       SuperscriptBox["y", "2"]}]]}]}], ")"}]}]], "Output",
 ImageSize->{505, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->201234283]
}, Open  ]],

Cell["Points are simultaneously inside or outside of the sets:", "ExampleText",
 CellID->94566008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"set1", ",", "set2", ",", "set3"}], "}"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", "1"}], ",", 
      RowBox[{"y", "\[Rule]", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", "\[Rule]", "0"}], ",", 
      RowBox[{"y", "\[Rule]", 
       RowBox[{"1", "/", "2"}]}]}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->120164780],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"False", ",", "False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"True", ",", "True", ",", "True"}], "}"}]}], "}"}]], "Output",
 ImageSize->{291, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->483463431]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1730],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CylindricalDecomposition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CylindricalDecomposition"]], "InlineFormula"],
 " requires exact, infinite\[Hyphen]precision input:"
}], "ExampleText",
 CellID->974954179],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1.2", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"3.2", 
      RowBox[{"y", "^", "2"}]}]}], "<", "1.0"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88653419],

Cell[BoxData[
 RowBox[{
  RowBox[{"CylindricalDecomposition", "::", "\<\"nrtpi\"\>"}], ":", 
  " ", "\<\"\\!\\(\\(\\(\\(\\(1.2`\\\\ x\\^2\\)\\) + \\(\\(3.2`\\\\ \
y\\^2\\)\\)\\)\\) < 1.`\\) is not a logical formula consisting of polynomial \
equations and inequalities in \\!\\({x, y}\\) with rational number \
coefficients. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/CylindricalDecomposition/nrtpi\\\", \
ButtonNote -> \\\"CylindricalDecomposition::nrtpi\\\"]\\)\"\>"}]], "Message", \
"MSG",
 CellID->262021997],

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1.2`", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"3.2`", " ", 
      SuperscriptBox["y", "2"]}]}], "<", "1.`"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Output",
 ImageSize->{350, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->485234206]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Rationalize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rationalize"]], "InlineFormula"],
 " will convert inexact numbers to exact ones:"
}], "ExampleText",
 CellID->142216720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Rationalize", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"1.2", 
      RowBox[{"x", "^", "2"}]}], "+", 
     RowBox[{"3.2", 
      RowBox[{"y", "^", "2"}]}]}], "<", "1.0"}], ",", "0"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->223914007],

Cell[BoxData[
 RowBox[{
  RowBox[{
   FractionBox[
    RowBox[{"6", " ", 
     SuperscriptBox["x", "2"]}], "5"], "+", 
   FractionBox[
    RowBox[{"16", " ", 
     SuperscriptBox["y", "2"]}], "5"]}], "<", "1"}]], "Output",
 ImageSize->{98, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->158346188]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CylindricalDecomposition", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->307772146],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SqrtBox[
     FractionBox["5", "6"]]}], "<", "x", "<", 
   SqrtBox[
    FractionBox["5", "6"]]}], "&&", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "4"]}], " ", 
    SqrtBox[
     RowBox[{"5", "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["x", "2"]}]}]]}], "<", "y", "<", 
   RowBox[{
    FractionBox["1", "4"], " ", 
    SqrtBox[
     RowBox[{"5", "-", 
      RowBox[{"6", " ", 
       SuperscriptBox["x", "2"]}]}]]}]}]}]], "Output",
 ImageSize->{322, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->247062036]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1191872],

Cell["\<\
In general the output can be in a nested and more compact form:\
\>", "ExampleText",
 CellID->722083976],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cd", "=", 
  RowBox[{"CylindricalDecomposition", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}], "+", 
       RowBox[{"y", "^", "2"}]}], "<=", "1"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "+", 
       RowBox[{"2", 
        RowBox[{"y", "^", "2"}]}], "+", 
       RowBox[{"3", 
        RowBox[{"z", "^", "2"}]}]}], "\[GreaterEqual]", 
      RowBox[{
       RowBox[{"4", "x", " ", "y", " ", "z"}], "+", "1"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->227643531],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "<", "0"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]], 
       SqrtBox["2"]]}], "\[LessEqual]", "y", "\[LessEqual]", 
     FractionBox[
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]], 
      SqrtBox["2"]]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", "\[LessEqual]", 
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", "x", " ", "y"}], "3"], "-", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         SqrtBox[
          RowBox[{"3", "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["x", "2"]}], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["y", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["x", "2"], " ", 
            SuperscriptBox["y", "2"]}]}]]}]}]}], "||", 
      RowBox[{"z", "\[GreaterEqual]", 
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", "x", " ", "y"}], "3"], "+", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         SqrtBox[
          RowBox[{"3", "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["x", "2"]}], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["y", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["x", "2"], " ", 
            SuperscriptBox["y", "2"]}]}]]}]}]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", 
        FractionBox["1", 
         SqrtBox["2"]]}]}], "||", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", 
           SqrtBox["2"]]}], "<", "y", "<", 
         FractionBox["1", 
          SqrtBox["2"]]}], "&&", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"z", "\[LessEqual]", 
           RowBox[{
            RowBox[{"-", 
             FractionBox["1", "3"]}], " ", 
            SqrtBox[
             RowBox[{"3", "-", 
              RowBox[{"6", " ", 
               SuperscriptBox["y", "2"]}]}]]}]}], "||", 
          RowBox[{"z", "\[GreaterEqual]", 
           RowBox[{
            FractionBox["1", "3"], " ", 
            SqrtBox[
             RowBox[{"3", "-", 
              RowBox[{"6", " ", 
               SuperscriptBox["y", "2"]}]}]]}]}]}], ")"}]}], ")"}], "||", 
      RowBox[{"y", "\[Equal]", 
       FractionBox["1", 
        SqrtBox["2"]]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", "1"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]], 
       SqrtBox["2"]]}], "\[LessEqual]", "y", "\[LessEqual]", 
     FractionBox[
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]], 
      SqrtBox["2"]]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"z", "\[LessEqual]", 
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", "x", " ", "y"}], "3"], "-", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         SqrtBox[
          RowBox[{"3", "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["x", "2"]}], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["y", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["x", "2"], " ", 
            SuperscriptBox["y", "2"]}]}]]}]}]}], "||", 
      RowBox[{"z", "\[GreaterEqual]", 
       RowBox[{
        FractionBox[
         RowBox[{"2", " ", "x", " ", "y"}], "3"], "+", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         SqrtBox[
          RowBox[{"3", "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["x", "2"]}], "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["y", "2"]}], "+", 
           RowBox[{"4", " ", 
            SuperscriptBox["x", "2"], " ", 
            SuperscriptBox["y", "2"]}]}]]}]}]}]}], ")"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{580, 254},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->535231705]
}, Open  ]],

Cell["\<\
Flatten the result into disjunctive normal form without splitting the \
inequalities:\
\>", "ExampleText",
 CellID->364305526],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"ToDNF", "[", "e_Or", "]"}], ":=", 
   RowBox[{"ToDNF", "/@", "e"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ToDNF", "[", 
    RowBox[{"And", "[", 
     RowBox[{"a___", ",", "b_Or", ",", "c___"}], "]"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"ToDNF", "[", 
      RowBox[{"And", "[", 
       RowBox[{"a", ",", "#", ",", "c"}], "]"}], "]"}], "&"}], "/@", "b"}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"ToDNF", "[", "e_", "]"}], ":=", "e"}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->34109817],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToDNF", "[", "cd", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->359104985],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", 
     RowBox[{"-", "1"}]}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "<", "0"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]], 
       SqrtBox["2"]]}], "\[LessEqual]", "y", "\[LessEqual]", 
     FractionBox[
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]], 
      SqrtBox["2"]]}], "&&", 
    RowBox[{"z", "\[LessEqual]", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "x", " ", "y"}], "3"], "-", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       SqrtBox[
        RowBox[{"3", "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["x", "2"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox["y", "2"]}]}]]}]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "<", "x", "<", "0"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]], 
       SqrtBox["2"]]}], "\[LessEqual]", "y", "\[LessEqual]", 
     FractionBox[
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]], 
      SqrtBox["2"]]}], "&&", 
    RowBox[{"z", "\[GreaterEqual]", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "x", " ", "y"}], "3"], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       SqrtBox[
        RowBox[{"3", "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["x", "2"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox["y", "2"]}]}]]}]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}], "<", "y", "<", 
     FractionBox["1", 
      SqrtBox["2"]]}], "&&", 
    RowBox[{"z", "\[LessEqual]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "3"]}], " ", 
      SqrtBox[
       RowBox[{"3", "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["y", "2"]}]}]]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", 
       SqrtBox["2"]]}], "<", "y", "<", 
     FractionBox["1", 
      SqrtBox["2"]]}], "&&", 
    RowBox[{"z", "\[GreaterEqual]", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      SqrtBox[
       RowBox[{"3", "-", 
        RowBox[{"6", " ", 
         SuperscriptBox["y", "2"]}]}]]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "0"}], "&&", 
    RowBox[{"y", "\[Equal]", 
     FractionBox["1", 
      SqrtBox["2"]]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", "1"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]], 
       SqrtBox["2"]]}], "\[LessEqual]", "y", "\[LessEqual]", 
     FractionBox[
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]], 
      SqrtBox["2"]]}], "&&", 
    RowBox[{"z", "\[LessEqual]", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "x", " ", "y"}], "3"], "-", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       SqrtBox[
        RowBox[{"3", "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["x", "2"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox["y", "2"]}]}]]}]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"0", "<", "x", "<", "1"}], "&&", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SqrtBox[
        RowBox[{"1", "-", 
         SuperscriptBox["x", "2"]}]], 
       SqrtBox["2"]]}], "\[LessEqual]", "y", "\[LessEqual]", 
     FractionBox[
      SqrtBox[
       RowBox[{"1", "-", 
        SuperscriptBox["x", "2"]}]], 
      SqrtBox["2"]]}], "&&", 
    RowBox[{"z", "\[GreaterEqual]", 
     RowBox[{
      FractionBox[
       RowBox[{"2", " ", "x", " ", "y"}], "3"], "+", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       SqrtBox[
        RowBox[{"3", "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["x", "2"]}], "-", 
         RowBox[{"6", " ", 
          SuperscriptBox["y", "2"]}], "+", 
         RowBox[{"4", " ", 
          SuperscriptBox["x", "2"], " ", 
          SuperscriptBox["y", "2"]}]}]]}]}]}]}], ")"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "&&", 
    RowBox[{"y", "\[Equal]", "0"}]}], ")"}]}]], "Output",
 ImageSize->{517, 313},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22014768]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29551],

Cell["Semi-algebraic sets are quite general:", "ExampleText",
 CellID->499561935],

Cell[BoxData[
 RowBox[{
  RowBox[{"disk", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x0_", ",", "y0_"}], "}"}], ",", "r_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "x0"}], ")"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"y", "-", "y0"}], ")"}], "^", "2"}]}], "<", 
   RowBox[{"r", "^", "2"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91838576],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"disk", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "7"}], "/", "4"}], ",", 
      RowBox[{"9", "/", "4"}]}], "}"}], ",", 
    RowBox[{"1", "/", "3"}]}], "]"}], "||", 
  RowBox[{"disk", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"9", "/", "4"}], ",", 
      RowBox[{"9", "/", "4"}]}], "}"}], ",", 
    RowBox[{"1", "/", "3"}]}], "]"}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"disk", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "5"}], "]"}], "&&", 
    RowBox[{"!", 
     RowBox[{"disk", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], ",", "1"}], "]"}]}], "&&", 
    RowBox[{"!", 
     RowBox[{"disk", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", "1"}], "]"}]}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"!", 
       RowBox[{"disk", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", 
           RowBox[{"-", "1"}]}], "}"}], ",", 
         RowBox[{"Sqrt", "[", "5", "]"}]}], "]"}]}], "||", 
      RowBox[{"disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}], ",", "3"}], "]"}]}], ")"}]}], 
   ")"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10812290],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       FractionBox["7", "4"], "+", "x"}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["9", "4"]}], "+", "y"}], ")"}], "2"]}], "<", 
   FractionBox["1", "9"]}], "||", 
  RowBox[{
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["9", "4"]}], "+", "x"}], ")"}], "2"], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["9", "4"]}], "+", "y"}], ")"}], "2"]}], "<", 
   FractionBox["1", "9"]}], "||", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "<", "25"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "x"}], ")"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "y"}], ")"}], "2"]}], "\[GreaterEqual]", 
     "1"}], "&&", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"2", "+", "x"}], ")"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", "y"}], ")"}], "2"]}], "\[GreaterEqual]", 
     "1"}], "&&", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "+", "y"}], ")"}], "2"]}], "\[GreaterEqual]", "5"}], "||",
       
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "y"}], ")"}], "2"]}], "<", "9"}]}], 
     ")"}]}], ")"}]}]], "Output",
 ImageSize->{411, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->938509117]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->95277761],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->660036888]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21026],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Resolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Resolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FindInstance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FindInstance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Discriminant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Discriminant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Resultant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Resultant"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SemialgebraicComponentInstances",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SemialgebraicComponentInstances"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GenericCylindricalDecomposition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GenericCylindricalDecomposition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GroebnerBasis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GroebnerBasis"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullSimplify",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullSimplify"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20463]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32302],

Cell[TextData[ButtonBox["The Representation of Solution Sets",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheRepresentationOfSolutionSets"]], "Tutorials",\

 CellID->227434737]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->31629],

Cell[TextData[ButtonBox["Implementation notes: Algebra and Calculus",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#11701"], None}]], "RelatedLinks",
 CellID->16794]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->309968051],

Cell[TextData[ButtonBox["Computational Geometry",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ComputationalGeometry"]], "MoreAbout",
 CellID->42157104],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->651222188],

Cell[TextData[ButtonBox["Polynomial Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialSystems"]], "MoreAbout",
 CellID->212248844]
}, Open  ]],

Cell["New in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CylindricalDecomposition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 21.7551234}", "context" -> "System`", 
    "keywords" -> {
     "CAD", "Collins-Hong algorithm", "cylindrical algebraic decomposition", 
      "cylindrical parts"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "CylindricalDecomposition[ineqs, {x_1, x_2, ...}] finds a decomposition \
of the region represented by the inequalities ineqs into cylindrical parts \
whose directions correspond to the successive x_i. ", 
    "synonyms" -> {"cylindrical decomposition"}, "title" -> 
    "CylindricalDecomposition", "type" -> "Symbol", "uri" -> 
    "ref/CylindricalDecomposition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6107, 181, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->14121958]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 415055, 10273}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3137, 70, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3760, 97, 61, 1, 70, "ObjectName",
 CellID->5494],
Cell[3824, 100, 1119, 34, 70, "Usage",
 CellID->30562]
}, Open  ]],
Cell[CellGroupData[{
Cell[4980, 139, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5458, 156, 237, 7, 70, "Notes",
 CellID->23865],
Cell[5698, 165, 93, 1, 70, "Notes",
 CellID->17554],
Cell[5794, 168, 276, 8, 70, "Notes",
 CellID->20700]
}, Closed]],
Cell[CellGroupData[{
Cell[6107, 181, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->14121958],
Cell[CellGroupData[{
Cell[6491, 195, 148, 5, 70, "ExampleSection",
 CellID->141216260],
Cell[6642, 202, 93, 1, 70, "ExampleText",
 CellID->504489806],
Cell[CellGroupData[{
Cell[6760, 207, 289, 10, 28, "Input",
 CellID->21351],
Cell[7052, 219, 418, 16, 45, "Output",
 CellID->38970276]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7519, 241, 216, 7, 70, "ExampleSection",
 CellID->18442],
Cell[7738, 250, 112, 3, 70, "ExampleText",
 CellID->339227672],
Cell[CellGroupData[{
Cell[7875, 257, 497, 18, 70, "Input",
 CellID->87781740],
Cell[8375, 277, 272, 9, 36, "Output",
 CellID->151639920]
}, Open  ]],
Cell[CellGroupData[{
Cell[8684, 291, 1085, 36, 70, "Input",
 CellID->69190976],
Cell[9772, 329, 2970, 53, 70, "Output",
 Evaluatable->False,
 CellID->715845405]
}, Open  ]],
Cell[12757, 385, 82, 1, 70, "ExampleText",
 CellID->436863141],
Cell[CellGroupData[{
Cell[12864, 390, 512, 18, 70, "Input",
 CellID->513746345],
Cell[13379, 410, 360, 10, 36, "Output",
 CellID->157545642]
}, Open  ]],
Cell[13754, 423, 95, 1, 70, "ExampleText",
 CellID->11011043],
Cell[CellGroupData[{
Cell[13874, 428, 569, 20, 70, "Input",
 CellID->47990707],
Cell[14446, 450, 274, 9, 51, "Output",
 CellID->638328924]
}, Open  ]],
Cell[CellGroupData[{
Cell[14757, 464, 616, 21, 70, "Input",
 CellID->556060682],
Cell[15376, 487, 314, 10, 51, "Output",
 CellID->425916880]
}, Open  ]],
Cell[15705, 500, 125, 3, 70, "ExampleDelimiter",
 CellID->524425154],
Cell[15833, 505, 487, 16, 70, "ExampleText",
 CellID->166815026],
Cell[CellGroupData[{
Cell[16345, 525, 293, 10, 70, "Input",
 CellID->362521927],
Cell[16641, 537, 419, 16, 45, "Output",
 CellID->305026621]
}, Open  ]],
Cell[17075, 556, 82, 1, 70, "ExampleText",
 CellID->9733281],
Cell[CellGroupData[{
Cell[17182, 561, 347, 12, 70, "Input",
 CellID->748938624],
Cell[17532, 575, 853, 33, 58, "Output",
 CellID->628882071]
}, Open  ]],
Cell[18400, 611, 223, 8, 70, "ExampleText",
 CellID->706868372],
Cell[18626, 621, 221, 8, 70, "Input",
 CellID->26486982],
Cell[CellGroupData[{
Cell[18872, 633, 872, 26, 70, "Input",
 CellID->112113104],
Cell[19747, 661, 3502, 61, 70, "Output",
 Evaluatable->False,
 CellID->613386223]
}, Open  ]],
Cell[23264, 725, 125, 3, 70, "ExampleDelimiter",
 CellID->498156180],
Cell[23392, 730, 458, 16, 70, "ExampleText",
 CellID->907656866],
Cell[CellGroupData[{
Cell[23875, 750, 347, 12, 70, "Input",
 CellID->203137226],
Cell[24225, 764, 833, 32, 58, "Output",
 CellID->142608501]
}, Open  ]],
Cell[25073, 799, 74, 1, 70, "ExampleText",
 CellID->549981057],
Cell[25150, 802, 221, 8, 70, "Input",
 CellID->38851922],
Cell[CellGroupData[{
Cell[25396, 814, 870, 26, 70, "Input",
 CellID->8491266],
Cell[26269, 842, 3242, 57, 70, "Output",
 Evaluatable->False,
 CellID->333954883]
}, Open  ]],
Cell[29526, 902, 125, 3, 70, "ExampleDelimiter",
 CellID->133629119],
Cell[29654, 907, 323, 12, 70, "ExampleText",
 CellID->386718163],
Cell[CellGroupData[{
Cell[30002, 923, 364, 12, 70, "Input",
 CellID->90001242],
Cell[30369, 937, 683, 24, 52, "Output",
 CellID->122247706]
}, Open  ]],
Cell[31067, 964, 125, 3, 70, "ExampleDelimiter",
 CellID->306824023],
Cell[31195, 969, 85, 1, 70, "ExampleText",
 CellID->41837984],
Cell[CellGroupData[{
Cell[31305, 974, 338, 11, 70, "Input",
 CellID->65622872],
Cell[31646, 987, 690, 26, 45, "Output",
 CellID->331224290]
}, Open  ]],
Cell[CellGroupData[{
Cell[32373, 1018, 384, 12, 70, "Input",
 CellID->55757457],
Cell[32760, 1032, 1036, 38, 68, "Output",
 CellID->407802383]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[33845, 1076, 239, 7, 70, "ExampleSection",
 CellID->19280],
Cell[34087, 1085, 241, 7, 70, "ExampleText",
 CellID->48493443],
Cell[CellGroupData[{
Cell[34353, 1096, 368, 12, 70, "Input",
 CellID->67389443],
Cell[34724, 1110, 242, 9, 55, "Output",
 CellID->210520125]
}, Open  ]],
Cell[34981, 1122, 125, 3, 70, "ExampleDelimiter",
 CellID->336986953],
Cell[35109, 1127, 92, 1, 70, "ExampleText",
 CellID->401279341],
Cell[CellGroupData[{
Cell[35226, 1132, 556, 19, 70, "Input",
 CellID->39816937],
Cell[35785, 1153, 1170, 45, 74, "Output",
 CellID->393960380]
}, Open  ]],
Cell[36970, 1201, 125, 3, 70, "ExampleDelimiter",
 CellID->256599323],
Cell[37098, 1206, 105, 2, 70, "ExampleText",
 CellID->361338437],
Cell[CellGroupData[{
Cell[37228, 1212, 613, 21, 70, "Input",
 CellID->19620618],
Cell[37844, 1235, 2920, 52, 70, "Output",
 Evaluatable->False,
 CellID->21500647]
}, Open  ]],
Cell[40779, 1290, 123, 3, 70, "ExampleDelimiter",
 CellID->9895948],
Cell[40905, 1295, 75, 1, 70, "ExampleText",
 CellID->624279460],
Cell[CellGroupData[{
Cell[41005, 1300, 466, 16, 70, "Input",
 CellID->37830882],
Cell[41474, 1318, 843, 27, 39, "Output",
 CellID->26988186]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[42366, 1351, 218, 7, 70, "ExampleSection",
 CellID->10016],
Cell[CellGroupData[{
Cell[42609, 1362, 233, 7, 70, "ExampleSubsection",
 CellID->15290],
Cell[42845, 1371, 138, 4, 70, "ExampleText",
 CellID->777105701],
Cell[CellGroupData[{
Cell[43008, 1379, 782, 24, 70, "Input",
 CellID->139317936],
Cell[43793, 1405, 165, 5, 36, "Output",
 CellID->119418680]
}, Open  ]],
Cell[43973, 1413, 295, 10, 70, "ExampleText",
 CellID->2548684],
Cell[CellGroupData[{
Cell[44293, 1427, 782, 24, 70, "Input",
 CellID->54627604],
Cell[45078, 1453, 285155, 6367, 15774, "Output",
 CellID->144081711]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[330294, 7827, 232, 7, 70, "ExampleSection",
 CellID->9858],
Cell[330529, 7836, 227, 8, 70, "ExampleText",
 CellID->353000079],
Cell[CellGroupData[{
Cell[330781, 7848, 454, 16, 70, "Input",
 CellID->435689485],
Cell[331238, 7866, 3352, 59, 70, "Output",
 Evaluatable->False,
 CellID->660457048]
}, Open  ]],
Cell[334605, 7928, 124, 3, 70, "ExampleDelimiter",
 CellID->43479156],
Cell[334732, 7933, 231, 8, 70, "ExampleText",
 CellID->161036941],
Cell[CellGroupData[{
Cell[334988, 7945, 527, 18, 70, "Input",
 CellID->20660112],
Cell[335518, 7965, 27321, 452, 70, "Output",
 Evaluatable->False,
 CellID->265393072]
}, Open  ]],
Cell[362854, 8420, 125, 3, 70, "ExampleDelimiter",
 CellID->486659198],
Cell[362982, 8425, 261, 8, 70, "ExampleText",
 CellID->123250600],
Cell[CellGroupData[{
Cell[363268, 8437, 457, 15, 70, "Input",
 CellID->503633744],
Cell[363728, 8454, 853, 33, 58, "Output",
 CellID->518819656]
}, Open  ]],
Cell[CellGroupData[{
Cell[364618, 8492, 359, 12, 70, "Input",
 CellID->458866655],
Cell[364980, 8506, 424, 15, 36, "Output",
 CellID->195668739]
}, Open  ]],
Cell[365419, 8524, 125, 3, 70, "ExampleDelimiter",
 CellID->722607045],
Cell[365547, 8529, 244, 7, 70, "ExampleText",
 CellID->414648690],
Cell[CellGroupData[{
Cell[365816, 8540, 315, 11, 70, "Input",
 CellID->28035033],
Cell[366134, 8553, 519, 21, 65, "Output",
 CellID->109836344]
}, Open  ]],
Cell[CellGroupData[{
Cell[366690, 8579, 403, 14, 70, "Input",
 CellID->236774702],
Cell[367096, 8595, 360, 14, 65, "Output",
 CellID->44457420]
}, Open  ]],
Cell[CellGroupData[{
Cell[367493, 8614, 406, 14, 70, "Input",
 CellID->358878365],
Cell[367902, 8630, 1277, 45, 82, "Output",
 CellID->60741310]
}, Open  ]],
Cell[CellGroupData[{
Cell[369216, 8680, 371, 13, 70, "Input",
 CellID->171084875],
Cell[369590, 8695, 800, 27, 53, "Output",
 CellID->18422524]
}, Open  ]],
Cell[370405, 8725, 125, 3, 70, "ExampleDelimiter",
 CellID->721962243],
Cell[370533, 8730, 250, 8, 70, "ExampleText",
 CellID->276274527],
Cell[CellGroupData[{
Cell[370808, 8742, 291, 10, 70, "Input",
 CellID->424493338],
Cell[371102, 8754, 1168, 41, 81, "Output",
 CellID->2600620]
}, Open  ]],
Cell[CellGroupData[{
Cell[372307, 8800, 190, 7, 70, "Input",
 CellID->159768050],
Cell[372500, 8809, 252, 8, 36, "Output",
 CellID->576283672]
}, Open  ]],
Cell[372767, 8820, 125, 3, 70, "ExampleDelimiter",
 CellID->647969050],
Cell[372895, 8825, 269, 8, 70, "ExampleText",
 CellID->1031952177],
Cell[CellGroupData[{
Cell[373189, 8837, 298, 10, 70, "Input",
 CellID->3107950],
Cell[373490, 8849, 1870, 69, 123, "Output",
 CellID->683750444]
}, Open  ]],
Cell[375375, 8921, 272, 7, 70, "ExampleText",
 CellID->119097633],
Cell[CellGroupData[{
Cell[375672, 8932, 293, 10, 70, "Input",
 CellID->358541032],
Cell[375968, 8944, 419, 16, 45, "Output",
 CellID->359762750]
}, Open  ]],
Cell[376402, 8963, 124, 3, 70, "ExampleDelimiter",
 CellID->26465616],
Cell[376529, 8968, 271, 8, 70, "ExampleText",
 CellID->539297238],
Cell[CellGroupData[{
Cell[376825, 8980, 363, 12, 70, "Input",
 CellID->8716868],
Cell[377191, 8994, 683, 24, 52, "Output",
 CellID->152985366]
}, Open  ]],
Cell[CellGroupData[{
Cell[377911, 9023, 372, 12, 70, "Input",
 CellID->130547604],
Cell[378286, 9037, 735, 27, 48, "Output",
 CellID->1473382]
}, Open  ]],
Cell[379036, 9067, 125, 3, 70, "ExampleDelimiter",
 CellID->327219555],
Cell[379164, 9072, 82, 1, 70, "ExampleText",
 CellID->866199546],
Cell[CellGroupData[{
Cell[379271, 9077, 243, 9, 70, "Input",
 CellID->95416593],
Cell[379517, 9088, 302, 11, 36, "Output",
 CellID->4748239]
}, Open  ]],
Cell[CellGroupData[{
Cell[379856, 9104, 224, 7, 70, "Input",
 CellID->179973059],
Cell[380083, 9113, 853, 33, 58, "Output",
 CellID->149462437]
}, Open  ]],
Cell[CellGroupData[{
Cell[380973, 9151, 224, 7, 70, "Input",
 CellID->224201515],
Cell[381200, 9160, 833, 32, 58, "Output",
 CellID->201234283]
}, Open  ]],
Cell[382048, 9195, 98, 1, 70, "ExampleText",
 CellID->94566008],
Cell[CellGroupData[{
Cell[382171, 9200, 468, 16, 70, "Input",
 CellID->120164780],
Cell[382642, 9218, 343, 11, 36, "Output",
 CellID->483463431]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[383034, 9235, 225, 7, 70, "ExampleSection",
 CellID->1730],
Cell[383262, 9244, 259, 7, 70, "ExampleText",
 CellID->974954179],
Cell[CellGroupData[{
Cell[383546, 9255, 342, 12, 70, "Input",
 CellID->88653419],
Cell[383891, 9269, 599, 11, 70, "Message",
 CellID->262021997],
Cell[384493, 9282, 446, 15, 39, "Output",
 CellID->485234206]
}, Open  ]],
Cell[384954, 9300, 227, 7, 70, "ExampleText",
 CellID->142216720],
Cell[CellGroupData[{
Cell[385206, 9311, 281, 10, 70, "Input",
 CellID->223914007],
Cell[385490, 9323, 352, 13, 54, "Output",
 CellID->158346188]
}, Open  ]],
Cell[CellGroupData[{
Cell[385879, 9341, 192, 6, 70, "Input",
 CellID->307772146],
Cell[386074, 9349, 648, 26, 60, "Output",
 CellID->247062036]
}, Open  ]],
Cell[386737, 9378, 123, 3, 70, "ExampleDelimiter",
 CellID->1191872],
Cell[386863, 9383, 114, 3, 70, "ExampleText",
 CellID->722083976],
Cell[CellGroupData[{
Cell[387002, 9390, 682, 22, 70, "Input",
 CellID->227643531],
Cell[387687, 9414, 4510, 147, 275, "Output",
 CellID->535231705]
}, Open  ]],
Cell[392212, 9564, 136, 4, 70, "ExampleText",
 CellID->364305526],
Cell[392351, 9570, 580, 20, 70, "Input",
 CellID->34109817],
Cell[CellGroupData[{
Cell[392956, 9594, 102, 3, 70, "Input",
 CellID->359104985],
Cell[393061, 9599, 5264, 183, 334, "Output",
 CellID->22014768]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[398374, 9788, 224, 7, 70, "ExampleSection",
 CellID->29551],
Cell[398601, 9797, 81, 1, 70, "ExampleText",
 CellID->499561935],
Cell[398685, 9800, 432, 16, 70, "Input",
 CellID->91838576],
Cell[CellGroupData[{
Cell[399142, 9820, 1372, 49, 70, "Input",
 CellID->10812290],
Cell[400517, 9871, 2016, 75, 90, "Output",
 CellID->938509117]
}, Open  ]],
Cell[CellGroupData[{
Cell[402570, 9951, 298, 10, 70, "Input",
 CellID->95277761],
Cell[402871, 9963, 6199, 106, 70, "Output",
 Evaluatable->False,
 CellID->660036888]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[409131, 10076, 311, 9, 70, "SeeAlsoSection",
 CellID->21026],
Cell[409445, 10087, 2288, 80, 70, "SeeAlso",
 CellID->20463]
}, Open  ]],
Cell[CellGroupData[{
Cell[411770, 10172, 314, 9, 70, "TutorialsSection",
 CellID->32302],
Cell[412087, 10183, 183, 4, 70, "Tutorials",
 CellID->227434737]
}, Open  ]],
Cell[CellGroupData[{
Cell[412307, 10192, 321, 9, 70, "RelatedLinksSection",
 CellID->31629],
Cell[412631, 10203, 254, 5, 70, "RelatedLinks",
 CellID->16794]
}, Open  ]],
Cell[CellGroupData[{
Cell[412922, 10213, 319, 9, 70, "MoreAboutSection",
 CellID->309968051],
Cell[413244, 10224, 154, 3, 70, "MoreAbout",
 CellID->42157104],
Cell[413401, 10229, 147, 3, 70, "MoreAbout",
 CellID->651222188],
Cell[413551, 10234, 147, 3, 70, "MoreAbout",
 CellID->212248844]
}, Open  ]],
Cell[413713, 10240, 27, 0, 70, "History"],
Cell[413743, 10242, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

