(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    244472,       7578]
NotebookOptionsPosition[    219110,       6697]
NotebookOutlinePosition[    221317,       6747]
CellTagsIndexPosition[    221230,       6742]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Differential Equations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DifferentialEquations-Basics"], 
          "Differential Equations" :> 
          Documentation`HelpLookup["paclet:tutorial/DifferentialEquations"], 
          "Differential Equation Solving with DSolve" :> 
          Documentation`HelpLookup["paclet:tutorial/DSolveOverview"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Differential Equations\"\>", 
       2->"\<\"Differential Equations\"\>", 
       3->"\<\"Differential Equation Solving with DSolve\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NDSolve" :> Documentation`HelpLookup["paclet:ref/NDSolve"], 
          "Solve" :> Documentation`HelpLookup["paclet:ref/Solve"], "RSolve" :> 
          Documentation`HelpLookup["paclet:ref/RSolve"], "Integrate" :> 
          Documentation`HelpLookup["paclet:ref/Integrate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NDSolve\"\>", 2->"\<\"Solve\"\>", 
       3->"\<\"RSolve\"\>", 4->"\<\"Integrate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Calculus" :> Documentation`HelpLookup["paclet:guide/Calculus"],
           "Differential Equations" :> 
          Documentation`HelpLookup["paclet:guide/DifferentialEquations"], 
          "Equation Solving" :> 
          Documentation`HelpLookup["paclet:guide/EquationSolving"], 
          "New in 6.0: Symbolic Computation" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60AlgebraicComputing"], 
          "New in 6.0: Mathematics & Algorithms" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MathematicsAndAlgorithms"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Calculus\"\>", 
       2->"\<\"Differential Equations\"\>", 3->"\<\"Equation Solving\"\>", 
       4->"\<\"New in 6.0: Symbolic Computation\"\>", 
       5->"\<\"New in 6.0: Mathematics & Algorithms\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DSolve", "ObjectName",
 CellID->20078],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DSolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DSolve"], "[", 
       RowBox[{
        StyleBox["eqn", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]solves a differential equation for the function ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", with independent variable\[NonBreakingSpace]",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DSolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DSolve"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["eqn", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["eqn", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["y", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]solves a list of differential equations. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DSolve",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DSolve"], "[", 
       RowBox[{
        StyleBox["eqn", "TI"], ",", 
        StyleBox["y", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]solves a partial differential equation. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->21349]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DSolve"], "[", 
   RowBox[{
    StyleBox["eqn", "TI"], ",", 
    RowBox[{
     StyleBox["y", "TI"], "[", 
     StyleBox["x", "TI"], "]"}], ",", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 " gives solutions for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["y", "TI"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " rather than for the function ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 " itself. "
}], "Notes",
 CellID->8330],

Cell[TextData[{
 "Differential equations must be stated in terms of derivatives such as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"y", "'"}], "[", "x", "]"}], TraditionalForm]], "InlineMath"],
 ", obtained with ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 ", not total derivatives obtained with ",
 Cell[BoxData[
  ButtonBox["Dt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dt"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14964],

Cell[TextData[{
 "The list of equations given to ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " can include algebraic ones that do not involve derivatives. "
}], "Notes",
 CellID->21695],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " generates constants of integration indexed by successive integers. The \
option ",
 Cell[BoxData[
  ButtonBox["GeneratedParameters",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GeneratedParameters"]], "InlineFormula"],
 " specifies the function to apply to each index. The default is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["GeneratedParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeneratedParameters"], "->", 
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"]}]], "InlineFormula"],
 ", which yields constants of integration ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "2", "]"}]], "InlineFormula"],
 ", \[Ellipsis] . ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->518909729,
  ButtonNote->"518909729"]
}], "Notes",
 CellID->27772],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["GeneratedParameters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GeneratedParameters"], "->", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      ButtonBox["Module",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Module"], "[", 
      RowBox[{
       RowBox[{"{", 
        ButtonBox["C",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/C"], "}"}], ",", 
       ButtonBox["C",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/C"]}], "]"}], "&"}], ")"}]}]], 
  "InlineFormula"],
 " guarantees that the constants of integration are unique, even across \
different invocations of ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31646],

Cell[TextData[{
 "For partial differential equations, ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " typically generates arbitrary functions ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["C",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/C"], "[", 
    StyleBox["n", "TI"], "]"}], "[", 
   StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->41585100,
  ButtonNote->"41585100"]
}], "Notes",
 CellID->27803],

Cell[TextData[{
 "Boundary conditions can be specified by giving equations such as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    RowBox[{"y", "'"}], "[", "0", "]"}], "==", "b"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6698],

Cell[TextData[{
 "Solutions given by ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " sometimes include integrals that cannot be carried out explicitly by ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 ". Dummy variables with local names are used in such integrals. "
}], "Notes",
 CellID->15577],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " sometimes gives implicit solutions in terms of ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->126035173,
  ButtonNote->"126035173"]
}], "Notes",
 CellID->3047],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " can solve linear ordinary differential equations of any order with \
constant coefficients. It can solve also many linear equations up to second \
order with non\[Hyphen]constant coefficients. "
}], "Notes",
 CellID->3551],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " includes general procedures that handle almost all the nonlinear ordinary \
differential equations whose solutions are given in standard reference books \
such as Kamke. "
}], "Notes",
 CellID->15684],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " can find general solutions for linear and weakly nonlinear partial \
differential equations. Truly nonlinear partial differential equations \
usually admit no general solutions. "
}], "Notes",
 CellID->18205],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 " can handle not only pure differential equations but also differential\
\[Hyphen]algebraic equations. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->78909139,
  ButtonNote->"78909139"]
}], "Notes",
 CellID->31144]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->528114744],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->289695397],

Cell["Solve a differential equation:", "ExampleText",
 CellID->301967363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", 
    RowBox[{"a", " ", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->311052625],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "x"}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", "a", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", 
         RowBox[{"Cos", "[", "x", "]"}]}], "+", 
        RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{280, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76930690]
}, Open  ]],

Cell["Include a boundary condition:", "ExampleText",
 CellID->9978540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
       RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", 
      RowBox[{"a", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20238327],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], " ", "a", " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"-", "x"}]], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "x"], " ", 
        RowBox[{"Cos", "[", "x", "]"}]}], "-", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "x"], " ", 
        RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{298, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->485652530]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->81312734],

Cell[TextData[{
 "Get a \[OpenCurlyDoubleQuote]pure function",
 "\[CloseCurlyDoubleQuote]",
 " solution for ",
 Cell[BoxData["y"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->287581676],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
       RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", 
      RowBox[{"a", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", "y", ",",
    "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->65678545],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], " ", "a", " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "x"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", "x"], " ", 
          RowBox[{"Cos", "[", "x", "]"}]}], "-", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", "x"], " ", 
          RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{379, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1454950]
}, Open  ]],

Cell["Substitute the solution into an expression:", "ExampleText",
 CellID->444355483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "^", "2"}]}], "/.", "%"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->80106270],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", "4"], " ", "a", " ", 
   RowBox[{"(", 
    RowBox[{"a", "+", 
     RowBox[{"a", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "x"}]]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "x"}]]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "+", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "x"}]]}]}], ")"}], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}], "+", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"2", " ", "a", " ", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "x"}]]}], "-", 
        RowBox[{"2", " ", "a", " ", 
         RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}]}], ")"}]}], 
  "}"}]], "Output",
 ImageSize->{491, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->250437346]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(19)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  InterpretationBox[Cell[TextData[{
    "Linear Differential Equations",
    "\[NonBreakingSpace]\[NonBreakingSpace]",
    Cell["(4)", "ExampleCount"]
   }], "ExampleSubsection"],
   $Line = 0; Null], " "}]], "ExampleSubsection",
 CellID->535640651],

Cell["Exponential equation:", "ExampleText",
 CellID->254895219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
      RowBox[{"a", 
       RowBox[{"y", "[", "x", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->347597487],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"a", " ", "x"}]]}], "}"}], "}"}]], "Output",
 ImageSize->{96, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->177171641]
}, Open  ]],

Cell["Inhomogeneous first-order equation:", "ExampleText",
 CellID->867387677],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
     RowBox[{"x", " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
    RowBox[{"Cos", "[", "x", "]"}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->54083640],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         SuperscriptBox["x", "2"], "2"]}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        FractionBox["1", "2"], "-", 
        FractionBox[
         SuperscriptBox["x", "2"], "2"]}]], " ", 
      SqrtBox[
       FractionBox["\[Pi]", "2"]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Erfi", "[", 
         FractionBox[
          RowBox[{
           RowBox[{"-", "\[ImaginaryI]"}], "+", "x"}], 
          SqrtBox["2"]], "]"}], "+", 
        RowBox[{"Erfi", "[", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", "+", "x"}], 
          SqrtBox["2"]], "]"}]}], ")"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{414, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->194591347]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->448405997],

Cell["Solve a boundary value problem: ", "ExampleText",
 CellID->243498779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}], "-", 
       RowBox[{"x", " ", 
        RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "9", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "y", ",",
    "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->37813044],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SqrtBox["3"], " ", 
          RowBox[{"AiryAi", "[", "x", "]"}]}], "-", 
         RowBox[{"AiryBi", "[", "x", "]"}], "-", 
         RowBox[{
          SuperscriptBox["3", 
           RowBox[{"2", "/", "3"}]], " ", 
          RowBox[{"AiryAi", "[", "x", "]"}], " ", 
          RowBox[{"AiryBi", "[", "9", "]"}], " ", 
          RowBox[{"Gamma", "[", 
           FractionBox["2", "3"], "]"}]}], "+", 
         RowBox[{
          SuperscriptBox["3", 
           RowBox[{"2", "/", "3"}]], " ", 
          RowBox[{"AiryAi", "[", "9", "]"}], " ", 
          RowBox[{"AiryBi", "[", "x", "]"}], " ", 
          RowBox[{"Gamma", "[", 
           FractionBox["2", "3"], "]"}]}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SqrtBox["3"], " ", 
          RowBox[{"AiryAi", "[", "9", "]"}]}], "-", 
         RowBox[{"AiryBi", "[", "9", "]"}]}], ")"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{549, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->195217524]
}, Open  ]],

Cell["Plot the solution: ", "ExampleText",
 CellID->112305520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "/.", "%"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->549916451],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->455987102]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->755095530],

Cell["Second-order equation with constant coefficients:", "ExampleText",
 CellID->3409293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
     RowBox[{"4", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{"5", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->82546440],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "x"}]], " ", 
      RowBox[{"C", "[", "2", "]"}], " ", 
      RowBox[{"Cos", "[", "x", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "2"}], " ", "x"}]], " ", 
      RowBox[{"C", "[", "1", "]"}], " ", 
      RowBox[{"Sin", "[", "x", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{290, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->317172572]
}, Open  ]],

Cell["Cauchy\[Dash]Euler equation:", "ExampleText",
 CellID->234261175],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "2"}], 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], " ", "+", 
     RowBox[{"4", "x", " ", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
     RowBox[{"7", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->393431179],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"C", "[", "2", "]"}], " ", 
       RowBox[{"Cos", "[", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         SqrtBox["19"], " ", 
         RowBox[{"Log", "[", "x", "]"}]}], "]"}]}], 
      SuperscriptBox["x", 
       RowBox[{"3", "/", "2"}]]], "+", 
     FractionBox[
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], " ", 
       RowBox[{"Sin", "[", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         SqrtBox["19"], " ", 
         RowBox[{"Log", "[", "x", "]"}]}], "]"}]}], 
      SuperscriptBox["x", 
       RowBox[{"3", "/", "2"}]]]}]}], "}"}], "}"}]], "Output",
 ImageSize->{407, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->438016509]
}, Open  ]],

Cell["\<\
Second-order equation with variable coefficients, solved in terms of \
elementary functions:\
\>", "ExampleText",
 CellID->290604774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", " ", 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
     RowBox[{"2", " ", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "-", 
     RowBox[{"x", " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", "y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->169767137],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       FractionBox[
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", "x"}]], " ", 
         RowBox[{"C", "[", "1", "]"}]}], "x"], "+", 
       FractionBox[
        RowBox[{
         SuperscriptBox["\[ExponentialE]", "x"], " ", 
         RowBox[{"C", "[", "2", "]"}]}], 
        RowBox[{"2", " ", "x"}]], "-", 
       FractionBox[
        RowBox[{"Sin", "[", "x", "]"}], 
        RowBox[{"2", " ", "x"}]]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{329, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->335538908]
}, Open  ]],

Cell["Airy's equation:", "ExampleText",
 CellID->573637239],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], "-", 
     RowBox[{"x", " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], " ", "\[Equal]", "0"}], ",", "y", ",",
    "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->575192690],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"AiryAi", "[", "x", "]"}], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{
        RowBox[{"AiryBi", "[", "x", "]"}], " ", 
        RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{358, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->417763476]
}, Open  ]],

Cell["Spheroidal equation:", "ExampleText",
 CellID->9615483],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", " ", "-", " ", 
        RowBox[{"x", "^", "2"}]}], ")"}], 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], "-", 
     RowBox[{"2", "x", " ", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", " ", "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"49", "-", 
        RowBox[{"49", 
         RowBox[{"x", "^", "2"}]}], "-", 
        RowBox[{"16", "/", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"x", "^", "2"}]}], ")"}]}], "+", 
        RowBox[{"SpheroidalEigenvalue", "[", 
         RowBox[{"5", ",", "4", ",", "7"}], "]"}]}], ")"}], 
      RowBox[{"y", "[", "x", "]"}]}]}], " ", "==", " ", "\n", "   ", "0"}], 
   ",", "y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->677040620],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"SpheroidalPS", "[", 
         RowBox[{"5", ",", "4", ",", "7", ",", "x"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"SpheroidalQS", "[", 
         RowBox[{"5", ",", "4", ",", "7", ",", "x"}], "]"}]}]}]}], "]"}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{551, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->166275757]
}, Open  ]],

Cell["Equations with nonrational coefficients:", "ExampleText",
 CellID->12722250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"8", "+", 
         RowBox[{"3", 
          RowBox[{
           RowBox[{"Cos", "[", "x", "]"}], "^", "2"}]}]}], ")"}], 
       RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], ",", "y", ",", "x"}], 
   "]"}], " "}]], "Input",
 CellLabel->"In[6]:=",
 CellID->687172792],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"MathieuC", "[", 
         RowBox[{
          FractionBox["19", "2"], ",", 
          RowBox[{"-", 
           FractionBox["3", "4"]}], ",", "x"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"MathieuS", "[", 
         RowBox[{
          FractionBox["19", "2"], ",", 
          RowBox[{"-", 
           FractionBox["3", "4"]}], ",", "x"}], "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{505, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->106016930]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"9", "+", 
         RowBox[{
          RowBox[{"Sech", "[", "x", "]"}], "^", "2"}]}], ")"}], 
       RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], ",", "y", ",", "x"}], 
   "]"}], " "}]], "Input",
 CellLabel->"In[7]:=",
 CellID->82989247],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"LegendreP", "[", 
         RowBox[{
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SqrtBox["5"]}], ")"}]}], ",", 
          RowBox[{"3", " ", "\[ImaginaryI]"}], ",", 
          RowBox[{"Tanh", "[", "x", "]"}]}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"LegendreQ", "[", 
         RowBox[{
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SqrtBox["5"]}], ")"}]}], ",", 
          RowBox[{"3", " ", "\[ImaginaryI]"}], ",", 
          RowBox[{"Tanh", "[", "x", "]"}]}], "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{423, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->41045215]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], "\[Equal]", " ", 
     RowBox[{
      RowBox[{"Exp", "[", 
       RowBox[{"-", "x"}], "]"}], " ", 
      RowBox[{"y", "[", "x", "]"}]}]}], ",", "y", ",", "x"}], "]"}], 
  "\n"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->877265069],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"BesselI", "[", 
         RowBox[{"0", ",", 
          RowBox[{"2", " ", 
           SqrtBox[
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"-", "x"}]]]}]}], "]"}], " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"BesselK", "[", 
         RowBox[{"0", ",", 
          RowBox[{"2", " ", 
           SqrtBox[
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"-", "x"}]]]}]}], "]"}], " ", 
        RowBox[{"C", "[", "2", "]"}]}]}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{497, 26},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->211861613]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->533549112],

Cell["Higher-order equations:", "ExampleText",
 CellID->404350673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'''"}], "[", "x", "]"}], "+", 
     RowBox[{"4", 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}]}], "\[Equal]", 
    RowBox[{"5", 
     RowBox[{"y", "[", "x", "]"}]}]}], ",", "y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->163775661],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "x"], " ", 
        RowBox[{"C", "[", "3", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "x"}], "/", "2"}]], " ", 
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"Cos", "[", 
         FractionBox[
          RowBox[{
           SqrtBox["19"], " ", "x"}], "2"], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "x"}], "/", "2"}]], " ", 
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"Sin", "[", 
         FractionBox[
          RowBox[{
           SqrtBox["19"], " ", "x"}], "2"], "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{509, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72097679]
}, Open  ]],

Cell["Solution in terms of hypergeometric functions:", "ExampleText",
 CellID->97193184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"3", 
      RowBox[{"x", "^", "3"}], 
      RowBox[{
       RowBox[{"y", "''''"}], "[", "x", "]"}]}], "+", 
     RowBox[{"19", 
      RowBox[{"x", "^", "2"}], " ", 
      RowBox[{
       RowBox[{"y", "'''"}], "[", "x", "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", "x"}], "-", 
        RowBox[{"3", 
         RowBox[{"x", "^", "2"}]}]}], ")"}], 
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "-", 
        RowBox[{"9", "x"}]}], ")"}], 
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}]}], "-", 
     RowBox[{"3", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", "y", ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->323824983],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{"2", "/", "3"}]]}], " ", 
        SuperscriptBox["x", 
         RowBox[{"5", "/", "3"}]], " ", 
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"HypergeometricPFQ", "[", 
         RowBox[{
          RowBox[{"{", 
           FractionBox["8", "3"], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             FractionBox["11", "3"], "-", 
             SqrtBox["5"]}], ",", 
            RowBox[{
             FractionBox["11", "3"], "+", 
             SqrtBox["5"]}]}], "}"}], ",", "x"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          SqrtBox["5"]}]], " ", 
        SuperscriptBox["x", 
         RowBox[{
          RowBox[{"-", "1"}], "-", 
          SqrtBox["5"]}]], " ", 
        RowBox[{"C", "[", "3", "]"}], " ", 
        RowBox[{"HypergeometricPFQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"-", 
            SqrtBox["5"]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "-", 
             RowBox[{"2", " ", 
              SqrtBox["5"]}]}], ",", 
            RowBox[{
             RowBox[{"-", 
              FractionBox["5", "3"]}], "-", 
             SqrtBox["5"]}]}], "}"}], ",", "x"}], "]"}]}], "+", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox["5"]}]], " ", 
        SuperscriptBox["x", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          SqrtBox["5"]}]], " ", 
        RowBox[{"C", "[", "4", "]"}], " ", 
        RowBox[{"HypergeometricPFQ", "[", 
         RowBox[{
          RowBox[{"{", 
           SqrtBox["5"], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              FractionBox["5", "3"]}], "+", 
             SqrtBox["5"]}], ",", 
            RowBox[{"1", "+", 
             RowBox[{"2", " ", 
              SqrtBox["5"]}]}]}], "}"}], ",", "x"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"HypergeometricPFQ", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", 
             FractionBox["2", "3"]}], ",", 
            RowBox[{"2", "-", 
             SqrtBox["5"]}], ",", 
            RowBox[{"2", "+", 
             SqrtBox["5"]}]}], "}"}], ",", "x"}], "]"}]}]}]}], "]"}]}], "}"}],
   "}"}]], "Output",
 ImageSize->{564, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->211686067]
}, Open  ]],

Cell["Fourth-order equation solved in terms of Kelvin functions:", \
"ExampleText",
 CellID->249860454],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"525", "+", 
        RowBox[{"x", "^", "4"}]}], ")"}], 
      RowBox[{"y", "[", "x", "]"}]}], "-", 
     RowBox[{"51", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "x"}], " ", 
         RowBox[{
          RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
        RowBox[{
         RowBox[{"x", "^", "2"}], " ", 
         RowBox[{
          RowBox[{"y", "''"}], "[", "x", "]"}]}]}], ")"}]}], "+", " ", 
     RowBox[{"2", 
      RowBox[{"x", "^", "3"}], 
      RowBox[{
       RowBox[{"y", "'''"}], "[", "x", "]"}]}], "+", 
     RowBox[{
      RowBox[{"x", "^", "4"}], " ", 
      RowBox[{
       RowBox[{"y", "''''"}], "[", "x", "]"}]}]}], "==", "0"}], ",", "y", ",",
    "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->596438192],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"C", "[", "4", "]"}], " ", 
        RowBox[{"KelvinBei", "[", 
         RowBox[{"5", ",", "x"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "3", "]"}], " ", 
        RowBox[{"KelvinBer", "[", 
         RowBox[{"5", ",", "x"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"KelvinKei", "[", 
         RowBox[{"5", ",", "x"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"KelvinKer", "[", 
         RowBox[{"5", ",", "x"}], "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{485, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->254708848]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Piecewise & Generalized Functions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->325369133],

Cell["Using a piecewise forcing function:", "ExampleText",
 CellID->416336744],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}], "-", 
       RowBox[{"y", "[", "x", "]"}]}], "==", 
      RowBox[{"Max", "[", 
       RowBox[{"x", ",", 
        RowBox[{"x", "^", "2"}]}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "2"}]}], "}"}], ",", 
   "y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17312088],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{532, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->631957033]
}, Open  ]],

Cell["A differential equation with a piecewise coefficient:", "ExampleText",
 CellID->5166198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
     RowBox[{
      RowBox[{
       RowBox[{"Clip", "[", "x", "]"}], "^", "2"}], 
      RowBox[{"y", "[", "x", "]"}]}]}], "==", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->236753084],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWEtvEzEQdtbZNk3VVpRHERSpZyQKJ8RDogUkegGOPMUhqpASUFVUeoFL
fkKOkRBSfkJOPeeYY35KfoIZv7Kz49msxSZcWGnXO/Z45pvxzNi7r1rn7c8n
rfPOcWvv6Kz1rd05/r734vQMumRNCHEB98F1Ae8K3sx9oRS0dXgmQKau/UXo
1HBJ/ZR6lrnMLEz/LhlP/lMpmquOvLnu2hNCryxEWxm9TuivJeNl8iqgqs9o
54HEtZS7SWjtyRTIl9BKH58EU8rIibMlKeHKZQWdndnEcFDfYq/BU7w24rFX
xF9YQbXS8ZqVK23DzcC0YOyQqjhi1whigSL8KeEvi3hKc/y6sGmLalFrR+KO
8W6RbWVrJ71LZb/fH41G4/E4kP2kov1xKxtTj8qjrDyaaVbSVQ/1DAaDQMpB
RZ9UqE+5+iNnTvCXDHjm1ahtZau87QdLC/BUjYHF1GMazZS+QazAeaV9c6hi
Yujf2YL30V2Cnc4/RCuViPD0s5h9+L7x0AwFXJPJRNS73a6Q8Oa4TDbkskzH
kXRx5muKpzW6O0tCN51OHTp487OQ3iucniACaJzcXRxatKJblTAt2IsI16Z3
2kz55XwPXCv5OqPs6sbhoZFK9ftYuYX8kNn9UHGn+udEBtWss0mLOmK5/dm2
UziKPf+F5fI7Lj9K8bRZrtMl9fro33TtxyiMG4R+V2j3vFnvK+h6ZnohkyGj
qS69EhuE/oBmweFlOBzG6LpJ6Md5KU63jQKoeV1ziYSrgWh81Yz3ej2kNQ33
YyazG3DvZ16Lqm9GrHWUaJhxa7weX1M2uslZSIX7Rh7XPXblbhNvFZ8vsrNk
xr0fJZM9g8091fFYPYpmwL9DJF6Kwklx+L16x7XbruXRUF80HfenKG69imhX
cM7R8/kMo1FFLXwTpXWL0G/ZWdeiZON9TiPi68nVKI3LqpTVe825Kxdr5hQa
rJz/l6IHHmSS6jjb8cllV4Xf6ybxmfxA8hCyVSLJZ0djzmz4/nNfgQV2zf0K
pV9JVvJPtveHQ/XIUPaPnqj9AafZ6w8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{181, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->49491450]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->787751176],

Cell["A nonlinear piecewise-defined differential equation:", "ExampleText",
 CellID->387007818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
       RowBox[{"Piecewise", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"Cos", "[", "x", "]"}], "^", "2"}], ",", 
            RowBox[{"x", " ", ">", "2"}]}], "}"}], "}"}], ",", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"y", "[", "x", "]"}], "^", "2"}], "/", "3"}]}], "]"}]}], 
      ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], " ", "==", " ", "1"}]}], "}"}], ",", "y",
     ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69064100],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"\[Piecewise]", GridBox[{
         {
          RowBox[{"-", 
           FractionBox["3", 
            RowBox[{
             RowBox[{"-", "3"}], "+", "x"}]]}], 
          RowBox[{"x", "\[LessEqual]", "2"}]},
         {
          RowBox[{
           FractionBox["1", "4"], " ", 
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"2", " ", "x"}], "-", 
             RowBox[{"Sin", "[", "4", "]"}], "+", 
             RowBox[{"Sin", "[", 
              RowBox[{"2", " ", "x"}], "]"}]}], ")"}]}], 
          TagBox["True",
           "PiecewiseDefault",
           AutoDelete->False,
           DeletionWarning->True]}
        },
        GridBoxAlignment->{
         "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, 
          "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}},
           "RowsIndexed" -> {}},
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.84]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{390, 47},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->314644953]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "/.", "sol"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->626931519],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->523145496]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->345805531],

Cell["Differential equations involving generalized functions:", "ExampleText",
 CellID->21183403],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], "-", 
     RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", 
    RowBox[{"HeavisideTheta", "[", "x", "]"}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->116462530],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "x"}]], " ", 
      RowBox[{"C", "[", "2", "]"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "x"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", 
         SuperscriptBox["\[ExponentialE]", "x"]}], ")"}], "2"], " ", 
      RowBox[{"HeavisideTheta", "[", "x", "]"}]}]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{410, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->330151804]
}, Open  ]],

Cell["A simple impulse response or Green's function:", "ExampleText",
 CellID->243153742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
     RowBox[{"7", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
    RowBox[{"DiracDelta", "[", "x", "]"}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->227135054],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "7"}], " ", "x"}]], " ", 
      RowBox[{"C", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "7"}], " ", "x"}]], " ", 
      RowBox[{"HeavisideTheta", "[", "x", "]"}]}]}]}], "}"}], "}"}]], "Output",\

 ImageSize->{291, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83480956]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Nonlinear Differential Equations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->91103246],

Cell["Solve a Riccati equation:", "ExampleText",
 CellID->87618354],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
     RowBox[{"x", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "^", "2"}]}]}], "\[Equal]", 
    "1"}], ",", "y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6627813],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "+", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SqrtBox[
             RowBox[{"1", "+", 
              RowBox[{"4", " ", "x"}]}]]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{"Log", "[", 
             RowBox[{
              RowBox[{"-", "1"}], "+", 
              SqrtBox[
               RowBox[{"1", "+", 
                RowBox[{"4", " ", "x"}]}]]}], "]"}]}]}], ")"}]}]}]}], "]"}]}],
     "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "+", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SqrtBox[
             RowBox[{"1", "+", 
              RowBox[{"4", " ", "x"}]}]]}], "-", 
           RowBox[{"2", " ", 
            RowBox[{"Log", "[", 
             RowBox[{"1", "+", 
              SqrtBox[
               RowBox[{"1", "+", 
                RowBox[{"4", " ", "x"}]}]]}], "]"}]}]}], ")"}]}]}]}], "]"}]}],
     "}"}]}], "}"}]], "Output",
 ImageSize->{436, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25735881]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->654545363],

Cell["Implicit solution for an Abel equation:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->126035173],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "^", "3"}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "+", "1"}], ")"}], 
         RowBox[{
          RowBox[{"y", "[", "x", "]"}], "^", "2"}]}], ")"}], "/", "x"}]}]}], 
    ",", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], "//", "Quiet"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->206271663],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox[
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", "x"}], "+", 
        FractionBox["1", 
         RowBox[{"y", "[", "x", "]"}]]}]], "x"], "+", 
     RowBox[{"C", "[", "1", "]"}], "+", 
     RowBox[{"ExpIntegralEi", "[", 
      RowBox[{
       RowBox[{"-", "x"}], "+", 
       FractionBox["1", 
        RowBox[{"y", "[", "x", "]"}]]}], "]"}]}], "\[Equal]", "0"}], ",", 
   RowBox[{"y", "[", "x", "]"}]}], "]"}]], "Output",
 ImageSize->{384, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->364065574]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->207276519],

Cell["Homogeneous equation:", "ExampleText",
 CellID->315539216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "'"}], "[", "x", "]"}], "-", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"y", "[", "x", "]"}], "/", "x"}], ")"}], "]"}]}], "\[Equal]", 
    
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "/", "x"}]}], ",", "y", ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206687039],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"x", " ", 
          SuperscriptBox[
           RowBox[{"C", "[", "1", "]"}], "2"]}], "+", 
         RowBox[{"2", " ", "x", " ", 
          RowBox[{"C", "[", "1", "]"}], " ", 
          RowBox[{"Log", "[", "x", "]"}]}], "+", 
         RowBox[{"x", " ", 
          SuperscriptBox[
           RowBox[{"Log", "[", "x", "]"}], "2"]}]}], ")"}]}]}], "]"}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{405, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81793051]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->139521916],

Cell[TextData[{
 "Solution in terms of ",
 Cell[BoxData[
  ButtonBox["WeierstrassP",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WeierstrassP"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7713519],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "''"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "^", "2"}], "+", "1"}]}], ",", "y", ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->447421],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       SuperscriptBox["6", 
        RowBox[{"1", "/", "3"}]], " ", 
       RowBox[{"WeierstrassP", "[", 
        RowBox[{
         FractionBox[
          RowBox[{"x", "+", 
           RowBox[{"C", "[", "1", "]"}]}], 
          SuperscriptBox["6", 
           RowBox[{"1", "/", "3"}]]], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SuperscriptBox["6", 
             RowBox[{"1", "/", "3"}]]}], ",", 
           RowBox[{"C", "[", "2", "]"}]}], "}"}]}], "]"}]}]}], "]"}]}], "}"}],
   "}"}]], "Output",
 ImageSize->{437, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->184981978]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->132953522],

Cell["Solution in terms of hyperbolic functions:", "ExampleText",
 CellID->745290227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", "x", "]"}], " ", "==", 
      RowBox[{
       RowBox[{"3", 
        RowBox[{"y", "[", "x", "]"}], " ", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", 
          RowBox[{
           RowBox[{"y", "[", "x", "]"}], "^", "2"}]}], "+", 
         RowBox[{"4", 
          RowBox[{"y", "[", "x", "]"}]}], "+", "1"}], ")"}]}]}], ",", 
     RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], "[", 
   RowBox[{"[", "1", "]"}], "]"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->394063199],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["6"], " ", 
          SqrtBox[
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "2"}], " ", "x"}]]], " ", 
          SqrtBox[
           RowBox[{"C", "[", "1", "]"}]]}], "-", 
         RowBox[{"6", " ", 
          RowBox[{"C", "[", "2", "]"}]}]}], ")"}], " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{
         SqrtBox[
          FractionBox["3", "2"]], " ", 
         SqrtBox[
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", "x"}]]], " ", 
         SqrtBox[
          RowBox[{"C", "[", "1", "]"}]]}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", "\[ImaginaryI]"}], "+", 
         RowBox[{"2", " ", 
          SqrtBox["6"], " ", 
          SqrtBox[
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{
             RowBox[{"-", "2"}], " ", "x"}]]], " ", 
          SqrtBox[
           RowBox[{"C", "[", "1", "]"}]], " ", 
          RowBox[{"C", "[", "2", "]"}]}]}], ")"}], " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{
         SqrtBox[
          FractionBox["3", "2"]], " ", 
         SqrtBox[
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", "x"}]]], " ", 
         SqrtBox[
          RowBox[{"C", "[", "1", "]"}]]}], "]"}]}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"6", " ", 
       RowBox[{"C", "[", "2", "]"}], " ", 
       RowBox[{"Cosh", "[", 
        RowBox[{
         SqrtBox[
          FractionBox["3", "2"]], " ", 
         SqrtBox[
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", "x"}]]], " ", 
         SqrtBox[
          RowBox[{"C", "[", "1", "]"}]]}], "]"}]}], "+", 
      RowBox[{"3", " ", "\[ImaginaryI]", " ", 
       RowBox[{"Sinh", "[", 
        RowBox[{
         SqrtBox[
          FractionBox["3", "2"]], " ", 
         SqrtBox[
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", "x"}]]], " ", 
         SqrtBox[
          RowBox[{"C", "[", "1", "]"}]]}], "]"}]}]}], ")"}]}]}], 
  "}"}]], "Output",
 ImageSize->{456, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->276214095]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Systems of Differential Equations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->121512680],

Cell["Diagonal linear system:", "ExampleText",
 CellID->156137180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"x", "^", "2"}], 
       RowBox[{"y", "[", "x", "]"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"z", "'"}], "[", "x", "]"}], "\[Equal]", 
      RowBox[{"5", 
       RowBox[{"z", "[", "x", "]"}]}]}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->345850836],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         FractionBox[
          SuperscriptBox["x", "3"], "3"]], " ", 
        RowBox[{"C", "[", "1", "]"}]}]}], "]"}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{"5", " ", "x"}]], " ", 
        RowBox[{"C", "[", "2", "]"}]}]}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{397, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5613588]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->339134918],

Cell["Inhomogeneous linear system with constant coefficients:", "ExampleText",
 CellID->448103595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Theta]", "=", 
     RowBox[{"Pi", "/", "3"}]}], "}"}], ",", 
   RowBox[{"DSolve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"Cos", "[", "\[Theta]", "]"}], 
          RowBox[{"y", "[", "x", "]"}]}], "-", 
         RowBox[{
          RowBox[{"Sin", "[", "\[Theta]", "]"}], 
          RowBox[{"z", "[", "x", "]"}]}], "+", "1"}]}], ",", 
       RowBox[{
        RowBox[{
         RowBox[{"z", "'"}], "[", "x", "]"}], "\[Equal]", 
        RowBox[{
         RowBox[{
          RowBox[{"Sin", "[", "\[Theta]", "]"}], 
          RowBox[{"y", "[", "x", "]"}]}], "+", 
         RowBox[{
          RowBox[{"Cos", "[", "\[Theta]", "]"}], 
          RowBox[{"z", "[", "x", "]"}]}]}]}], ",", 
       RowBox[{
        RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
       RowBox[{
        RowBox[{"z", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", " ", "z"}], "}"}], ",", "x"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->619550095],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"x", "/", "2"}]], " ", 
           RowBox[{"Cos", "[", 
            FractionBox[
             RowBox[{
              SqrtBox["3"], " ", "x"}], "2"], "]"}]}], "-", 
          SuperscriptBox[
           RowBox[{"Cos", "[", 
            FractionBox[
             RowBox[{
              SqrtBox["3"], " ", "x"}], "2"], "]"}], "2"], "-", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"x", "/", "2"}]], " ", 
           RowBox[{"Sin", "[", 
            FractionBox[
             RowBox[{
              SqrtBox["3"], " ", "x"}], "2"], "]"}]}], "+", 
          RowBox[{
           SqrtBox["3"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"x", "/", "2"}]], " ", 
           RowBox[{"Sin", "[", 
            FractionBox[
             RowBox[{
              SqrtBox["3"], " ", "x"}], "2"], "]"}]}], "-", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            FractionBox[
             RowBox[{
              SqrtBox["3"], " ", "x"}], "2"], "]"}], "2"]}], ")"}]}]}], 
      "]"}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"x", "/", "2"}]], " ", 
           RowBox[{"Cos", "[", 
            FractionBox[
             RowBox[{
              SqrtBox["3"], " ", "x"}], "2"], "]"}]}], "-", 
          RowBox[{
           SqrtBox["3"], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"x", "/", "2"}]], " ", 
           RowBox[{"Cos", "[", 
            FractionBox[
             RowBox[{
              SqrtBox["3"], " ", "x"}], "2"], "]"}]}], "+", 
          RowBox[{
           SqrtBox["3"], " ", 
           SuperscriptBox[
            RowBox[{"Cos", "[", 
             FractionBox[
              RowBox[{
               SqrtBox["3"], " ", "x"}], "2"], "]"}], "2"]}], "+", 
          RowBox[{"3", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"x", "/", "2"}]], " ", 
           RowBox[{"Sin", "[", 
            FractionBox[
             RowBox[{
              SqrtBox["3"], " ", "x"}], "2"], "]"}]}], "+", 
          RowBox[{
           SqrtBox["3"], " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             FractionBox[
              RowBox[{
               SqrtBox["3"], " ", "x"}], "2"], "]"}], "2"]}]}], ")"}]}]}], 
      "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{503, 165},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->85820360]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], ",", 
       RowBox[{"z", "[", "x", "]"}]}], "}"}], "/.", 
     RowBox[{"First", "[", "%", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "9"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30014467],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->558292825]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120051939],

Cell["Nonlinear system:", "ExampleText",
 CellID->54137464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", " ", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{"z", "[", "x", "]"}], "]"}], "+", "1"}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"z", "'"}], "[", "x", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"y", "[", "x", "]"}], "-", "x"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "z"}], "}"}], ",", "x"}], "]"}], "//", 
  "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2545688],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"z", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{"Log", "[", 
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "+", 
         RowBox[{
          RowBox[{"C", "[", "1", "]"}], " ", 
          SuperscriptBox[
           RowBox[{"Tan", "[", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SqrtBox["2"], " ", "x", " ", 
                SqrtBox[
                 RowBox[{"C", "[", "1", "]"}]]}], "+", 
               RowBox[{"2", " ", 
                SqrtBox["2"], " ", 
                SqrtBox[
                 RowBox[{"C", "[", "1", "]"}]], " ", 
                RowBox[{"C", "[", "2", "]"}]}]}], ")"}]}], "]"}], "2"]}]}], 
        "]"}]}], "]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{"x", "+", 
        RowBox[{
         SqrtBox["2"], " ", 
         SqrtBox[
          RowBox[{"C", "[", "1", "]"}]], " ", 
         RowBox[{"Tan", "[", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SqrtBox["2"], " ", "x", " ", 
              SqrtBox[
               RowBox[{"C", "[", "1", "]"}]]}], "+", 
             RowBox[{"2", " ", 
              SqrtBox["2"], " ", 
              SqrtBox[
               RowBox[{"C", "[", "1", "]"}]], " ", 
              RowBox[{"C", "[", "2", "]"}]}]}], ")"}]}], "]"}]}]}]}], 
      "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{533, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->71936314]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Differential-Algebraic Equations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->39907188],

Cell["Solve a system of linear differential-algebraic equations:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->78909139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", " ", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
       RowBox[{
        RowBox[{"z", "'"}], "[", "x", "]"}]}], "==", 
      RowBox[{
       RowBox[{"4", 
        RowBox[{"y", "[", "x", "]"}]}], "+", "x"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "-", 
       RowBox[{"z", "[", "x", "]"}]}], "==", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], ",", 
     RowBox[{"z", "[", "x", "]"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->429044150],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
     RowBox[{
      FractionBox["1", "3"], "+", 
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FractionBox["1", "288"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "25"}], "-", 
            RowBox[{"12", " ", "x"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"4", " ", "x"}], "/", "3"}]], " ", 
          RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}]}]}], ",", 
    RowBox[{
     RowBox[{"z", "[", "x", "]"}], "\[Rule]", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["2", "3"]}], "+", 
      RowBox[{"6", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          FractionBox["1", "288"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "25"}], "-", 
            RowBox[{"12", " ", "x"}]}], ")"}]}], "+", 
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"4", " ", "x"}], "/", "3"}]], " ", 
          RowBox[{"C", "[", "1", "]"}]}]}], ")"}]}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{305, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->223842905]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->256197627],

Cell["Solve a boundary value problem:", "ExampleText",
 CellID->856714166],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "-", 
       RowBox[{"4", 
        RowBox[{"z", "[", "x", "]"}]}]}], "\[Equal]", 
      RowBox[{"Cos", "[", "x", "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], "+", 
       RowBox[{"z", "[", "x", "]"}]}], "==", 
      RowBox[{"1", "/", "2"}]}], ",", " ", 
     RowBox[{
      RowBox[{"y", "[", 
       RowBox[{"Pi", "/", "2"}], "]"}], "==", 
      RowBox[{"1", "/", "2"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "z"}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->394137252],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        FractionBox["1", "34"], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "4"}], " ", "x"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"-", "2"}], " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", "\[Pi]"}]]}], "+", 
          RowBox[{"17", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"4", " ", "x"}]]}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"4", " ", "x"}]], " ", 
           RowBox[{"Cos", "[", "x", "]"}]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"4", " ", "x"}]], " ", 
           RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}]}], "]"}]}], ",", 
    RowBox[{"z", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "17"]}], " ", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "4"}], " ", "x"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"2", " ", "\[Pi]"}]]}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"4", " ", "x"}]], " ", 
           RowBox[{"Cos", "[", "x", "]"}]}], "+", 
          RowBox[{
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"4", " ", "x"}]], " ", 
           RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}]}], "]"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{475, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33698482]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"y", "[", "x", "]"}], ",", 
       RowBox[{"z", "[", "x", "]"}], ",", 
       RowBox[{
        RowBox[{"y", "[", "x", "]"}], "+", 
        RowBox[{"z", "[", "x", "]"}]}]}], "}"}], "/.", "%"}], "]"}], ",", " ",
    
   RowBox[{"{", 
    RowBox[{"x", ",", "2", ",", "16"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->239531080],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 98},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->178378675]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->154715252],

Cell["An index-2 differential-algebraic equation:", "ExampleText",
 CellID->373372613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], "+", 
       RowBox[{"2", 
        RowBox[{"y", "[", "t", "]"}]}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "t", "]"}], "\[Equal]", 
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], "+", 
       RowBox[{"2", "^", "t"}]}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "t", "]"}], "+", 
       RowBox[{"z", "[", "t", "]"}]}], "\[Equal]", "0"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], ",", 
     RowBox[{"y", "[", "t", "]"}], ",", 
     RowBox[{"z", "[", "t", "]"}]}], "}"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->236244804],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "[", "t", "]"}], "\[Rule]", 
     RowBox[{
      FractionBox["1", "8"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"3", " ", "t"}]]}], " ", 
         RowBox[{"C", "[", "1", "]"}]}], "+", 
        FractionBox[
         SuperscriptBox["2", 
          RowBox[{"4", "+", "t"}]], 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          RowBox[{"Log", "[", "2", "]"}]}]]}], ")"}]}]}], ",", 
    RowBox[{
     RowBox[{"y", "[", "t", "]"}], "\[Rule]", 
     RowBox[{
      SuperscriptBox["2", "t"], "+", 
      RowBox[{
       FractionBox["1", "8"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["\[ExponentialE]", 
            RowBox[{"3", " ", "t"}]]}], " ", 
          RowBox[{"C", "[", "1", "]"}]}], "+", 
         FractionBox[
          SuperscriptBox["2", 
           RowBox[{"4", "+", "t"}]], 
          RowBox[{
           RowBox[{"-", "3"}], "+", 
           RowBox[{"Log", "[", "2", "]"}]}]]}], ")"}]}]}]}], ",", 
    RowBox[{
     RowBox[{"z", "[", "t", "]"}], "\[Rule]", 
     RowBox[{
      FractionBox["1", "8"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"3", " ", "t"}]], " ", 
         RowBox[{"C", "[", "1", "]"}]}], "-", 
        FractionBox[
         SuperscriptBox["2", 
          RowBox[{"4", "+", "t"}]], 
         RowBox[{
          RowBox[{"-", "3"}], "+", 
          RowBox[{"Log", "[", "2", "]"}]}]]}], ")"}]}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{494, 70},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->157952475]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Partial Differential Equations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->15000432],

Cell["\<\
General solution for a linear first-order partial differential equation:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->41585100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"3", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"y", "[", 
         RowBox[{"x1", ",", "x2"}], "]"}], ",", "x1"}], "]"}]}], "+", 
     RowBox[{"5", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"y", "[", 
         RowBox[{"x1", ",", "x2"}], "]"}], ",", "x2"}], "]"}]}]}], "\[Equal]",
     "x1"}], " ", ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->39575588],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x1", ",", "x2"}], "}"}], ",", 
      RowBox[{
       FractionBox["1", "6"], " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["x1", "2"], "+", 
         RowBox[{"6", " ", 
          RowBox[{
           RowBox[{"C", "[", "1", "]"}], "[", 
           RowBox[{
            FractionBox["1", "3"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"-", "5"}], " ", "x1"}], "+", 
              RowBox[{"3", " ", "x2"}]}], ")"}]}], "]"}]}]}], ")"}]}]}], 
     "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{399, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17901190]
}, Open  ]],

Cell[TextData[{
 "The solution with a particular choice of the arbitrary function ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["C",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/C"], "[", "1", "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->352072776],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"y", "[", 
     RowBox[{"x1", ",", "x2"}], "]"}], "/.", 
    RowBox[{"%", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"C", "[", "1", "]"}], "[", "e_", "]"}], "\[RuleDelayed]", 
    RowBox[{
     RowBox[{"Sin", "[", "e", "]"}], "+", 
     RowBox[{"Cos", "[", "e", "]"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3870441],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["x1", "2"], "+", 
    RowBox[{"6", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", "x1"}], "+", 
           RowBox[{"3", " ", "x2"}]}], ")"}]}], "]"}], "+", 
       RowBox[{"Sin", "[", 
        RowBox[{
         FractionBox["1", "3"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "5"}], " ", "x1"}], "+", 
           RowBox[{"3", " ", "x2"}]}], ")"}]}], "]"}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 ImageSize->{364, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1011897]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x2", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1626814],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 154},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->41645759]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->353957082],

Cell["\<\
General solution for a quasilinear first-order partial differential equation:\
\
\>", "ExampleText",
 CellID->678752222],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"2", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"y", "[", 
         RowBox[{"x1", ",", "x2"}], "]"}], ",", "x1"}], "]"}]}], "+", 
     RowBox[{"5", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"y", "[", 
         RowBox[{"x1", ",", "x2"}], "]"}], ",", "x2"}], "]"}]}]}], "\[Equal]",
     
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", 
       RowBox[{"x1", ",", "x2"}], "]"}], "^", "2"}], "+", "1"}]}], ",", "y", 
   ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->321039854],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->65067019],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x1", ",", "x2"}], "}"}], ",", 
      RowBox[{"Tan", "[", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"x1", "+", 
          RowBox[{"2", " ", 
           RowBox[{
            RowBox[{"C", "[", "1", "]"}], "[", 
            RowBox[{
             FractionBox["1", "2"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "5"}], " ", "x1"}], "+", 
               RowBox[{"2", " ", "x2"}]}], ")"}]}], "]"}]}]}], ")"}]}], 
       "]"}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{428, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->372016616]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->496268987],

Cell["\<\
Complete integral for a nonlinear, first-order Clairaut equation:\
\>", "ExampleText",
 CellID->496493079],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", 
     RowBox[{"x1", ",", "x2"}], "]"}], "\[Equal]", 
    RowBox[{
     RowBox[{"x1", " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"y", "[", 
         RowBox[{"x1", ",", " ", "x2"}], "]"}], ",", "x1"}], "]"}]}], "+", 
     RowBox[{"x2", " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"y", "[", 
         RowBox[{"x1", ",", " ", "x2"}], "]"}], ",", "x2"}], "]"}]}], "+", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"y", "[", 
          RowBox[{"x1", ",", "x2"}], "]"}], ",", "x1"}], "]"}], "+", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"y", "[", 
          RowBox[{"x1", ",", "x2"}], "]"}], ",", "x2"}], "]"}]}], "]"}]}]}], 
   " ", ",", "y", ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->107988600],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"nlpde\"\>"}], ":", 
  " ", "\<\"Solution requested to nonlinear partial differential equation. \
Trying to build a special solution. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/DSolve/nlpde\\\", ButtonNote -> \
\\\"DSolve::nlpde\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->296741009],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x1", ",", "x2"}], "}"}], ",", 
      RowBox[{
       RowBox[{"x1", " ", 
        RowBox[{"C", "[", "1", "]"}]}], "+", 
       RowBox[{"x2", " ", 
        RowBox[{"C", "[", "2", "]"}]}], "+", 
       RowBox[{"Sin", "[", 
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "+", 
         RowBox[{"C", "[", "2", "]"}]}], "]"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{409, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->221586583]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->695670436],

Cell["\<\
Initial value problem for a linear first-order partial differential equation:\
\
\>", "ExampleText",
 CellID->214657157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"2", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"y", "[", 
           RowBox[{"x1", ",", "x2"}], "]"}], ",", "x1"}], "]"}]}], "+", 
       RowBox[{"7", 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"y", "[", 
           RowBox[{"x1", ",", "x2"}], "]"}], ",", "x2"}], "]"}]}]}], "==", 
      "3"}], ",", 
     RowBox[{
      RowBox[{"y", "[", 
       RowBox[{"x1", ",", "0"}], "]"}], "==", "x1"}]}], "}"}], ",", "y", ",", 
   
   RowBox[{"{", 
    RowBox[{"x1", ",", " ", "x2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54232694],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x1", ",", "x2"}], "}"}], ",", 
      RowBox[{
       FractionBox["1", "7"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"7", " ", "x1"}], "+", "x2"}], ")"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{269, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16488863]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->137931841],

Cell["\<\
Linear second-order partial differential equation with constant coefficients:\
\
\>", "ExampleText",
 CellID->65626117],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"3", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"y", "[", 
         RowBox[{"x1", ",", "x2"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x1", ",", "2"}], "}"}]}], "]"}]}], "-", 
     RowBox[{"12", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"y", "[", 
         RowBox[{"x1", ",", "x2"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x2", ",", "2"}], "}"}]}], "]"}]}]}], "\[Equal]", "1"}], ",",
    "y", ",", 
   RowBox[{"{", 
    RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->610541269],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x1", ",", "x2"}], "}"}], ",", 
      RowBox[{
       FractionBox[
        SuperscriptBox["x1", "2"], "6"], "+", 
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], "[", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", "x1"}], "+", "x2"}], "]"}], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], "[", 
        RowBox[{
         RowBox[{"2", " ", "x1"}], "+", "x2"}], "]"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{432, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->189256358]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->210843504],

Cell["\<\
Traveling wave solution for the Korteweg\[Dash]deVries (KdV)  equation:\
\>", "ExampleText",
 CellID->795437752],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"KdV", " ", "=", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"y", "[", 
          RowBox[{"x1", ",", " ", "x2"}], "]"}], ",", "x2"}], "]"}], "+", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"y", "[", 
          RowBox[{"x1", ",", "x2"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x1", ",", " ", "3"}], "}"}]}], "]"}], "+", " ", "\n", 
       "      ", 
       RowBox[{"6", 
        RowBox[{"y", "[", 
         RowBox[{"x1", ",", "x2"}], "]"}], 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"y", "[", 
           RowBox[{"x1", ",", "x2"}], "]"}], ",", "x1"}], "]"}]}]}], "==", 
      "0"}], "}"}]}], ";"}], " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->272206926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{"KdV", ",", "y", ",", 
    RowBox[{"{", 
     RowBox[{"x1", ",", "x2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->362215921],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "::", "\<\"nlpde\"\>"}], ":", 
  " ", "\<\"Solution requested to nonlinear partial differential equation. \
Trying to build a special solution. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\
\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/DSolve/nlpde\\\", ButtonNote -> \
\\\"DSolve::nlpde\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->404462447],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x1", ",", "x2"}], "}"}], ",", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{
          RowBox[{"-", "8"}], " ", 
          SuperscriptBox[
           RowBox[{"C", "[", "1", "]"}], "3"]}], "+", 
         RowBox[{"C", "[", "2", "]"}], "+", 
         RowBox[{"12", " ", 
          SuperscriptBox[
           RowBox[{"C", "[", "1", "]"}], "3"], " ", 
          SuperscriptBox[
           RowBox[{"Tanh", "[", 
            RowBox[{
             RowBox[{"x1", " ", 
              RowBox[{"C", "[", "1", "]"}]}], "+", 
             RowBox[{"x2", " ", 
              RowBox[{"C", "[", "2", "]"}]}], "+", 
             RowBox[{"C", "[", "3", "]"}]}], "]"}], "2"]}]}], 
        RowBox[{"6", " ", 
         RowBox[{"C", "[", "1", "]"}]}]]}]}], "]"}]}], "}"}], "}"}]], "Output",\

 ImageSize->{550, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->767988259]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "[", 
        RowBox[{"x", ",", "1.2"}], "]"}], "/.", 
       RowBox[{"sol", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"C", "[", "1", "]"}], "\[Rule]", "1"}], ",", 
        RowBox[{
         RowBox[{"C", "[", "2", "]"}], "\[Rule]", 
         RowBox[{"-", "4"}]}], ",", 
        RowBox[{
         RowBox[{"C", "[", "3", "]"}], "\[Rule]", 
         RowBox[{"1", "/", "4"}]}]}], "}"}]}], "]"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "7"}], ",", "20"}], "}"}], ",", 
    RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->234366954],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 125},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->186116266]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13627],

Cell["No boundary condition, gives two generated parameters:", "ExampleText",
 CellID->4991966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
     RowBox[{"4", 
      RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", "y", ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->721588173],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{336, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->266232945]
}, Open  ]],

Cell["One boundary condition:", "ExampleText",
 CellID->490851081],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
       RowBox[{"4", 
        RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",", "y", ",",
    "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->531383639],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "x"}], "]"}], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{305, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11994561]
}, Open  ]],

Cell["Two boundary conditions:", "ExampleText",
 CellID->17015412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
       RowBox[{"4", 
        RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "4"}]}], "}"}], ",", 
   "y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->223255139],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{"Cos", "[", 
        RowBox[{"2", " ", "x"}], "]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"2", " ", "x"}], "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{284, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->331541010]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21712],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "GeneratedParameters",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->16787],

Cell["Use differently named constants:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->518909729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "''"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{"y", "[", "x", "]"}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x", ",", " ", 
   RowBox[{"GeneratedParameters", "\[Rule]", "d"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->167693793],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], " ", 
      RowBox[{"d", "[", "1", "]"}]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "x"}]], " ", 
      RowBox[{"d", "[", "2", "]"}]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{181, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->212842]
}, Open  ]],

Cell["Use subscripted constants:", "ExampleText",
 CellID->668299265],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "''"}], "[", "x", "]"}], "\[Equal]", 
    RowBox[{"y", "[", "x", "]"}]}], ",", 
   RowBox[{"y", "[", "x", "]"}], ",", "x", ",", 
   RowBox[{"GeneratedParameters", "\[Rule]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Subscript", "[", 
       RowBox[{"c", ",", "#"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->512825972],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["\[ExponentialE]", "x"], " ", 
      SubscriptBox["c", "1"]}], "+", 
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", "x"}]], " ", 
      SubscriptBox["c", "2"]}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->168808596]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2586],

Cell["Solve a logistic (Riccati) equation:", "ExampleText",
 CellID->27123007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], " ", "\[Equal]", " ", 
       RowBox[{
        RowBox[{"y", "[", "x", "]"}], 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{
           RowBox[{"y", "[", "x", "]"}], "/", "27"}]}], ")"}]}]}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "a"}]}], "}"}], ",", "y", 
    ",", "x"}], "]"}], "//", "Quiet"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->296987857],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      FractionBox[
       RowBox[{"27", " ", "a", " ", 
        SuperscriptBox["\[ExponentialE]", "x"]}], 
       RowBox[{"27", "-", "a", "+", 
        RowBox[{"a", " ", 
         SuperscriptBox["\[ExponentialE]", "x"]}]}]]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{231, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->394240195]
}, Open  ]],

Cell["Plot the solution for different initial values:", "ExampleText",
 CellID->169469254],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], "/.", "%"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", "\[Rule]", 
         RowBox[{"1", "/", "13"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", "\[Rule]", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"a", "\[Rule]", " ", "4"}], "}"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "18"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->60958664],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlmX1sVeUdxx967qVWaucbDudYmPGdZH/4j9OE7I9lLsQYxjLmFnxZqdXW
F3BQhitoi7pW4zU4DKG12EZoO4sluwZSIdZAIBKaELoQiASISDMEEhoyOhYb
SO4+z/Oce373nPuccy/6l7G5Pfc5557n+3v/Pr/nnIdrmxrqn69taqyrnfXr
pbUvNDTWLZv14JKlXPKmKKW28b9ihmKcY2T+t+VyfBcf7+PoccPd/ncF3xV8
3+Gfq5S5zf+baU4e0Ef9Y878qTv1ISXnFqXwjtsi517k/EffSdyf+766pzw8
ucOfNzNAKbz37vLQ0oVoOjY/Md/3+9h3+d9eQTwr/HDq7x/noplwTURKb8LV
qzkOcHFK+J6e7v3tbbtUasnirar6obk9v5jTydVHFvRzYWXzDn7u6x0dPXDq
9OkLVumrIuhTv2fnFeI/HfGhps7R3uFzR/+d1lequYKn8Nee3SfwXWfHCH7E
m3gWb+LKw4fOzIgg3lPifKZIrOTq2L7PRzq2DS7KbJr38p7Mh2cOfWliqyon
JiaRisjGhuz8eZveyuxBD7UmmF2Rz8v0xfELh7OfZRveHljYfmRoRFUbQ8fH
L36UPYy+jy0c+HjoyOTk5Ywznwy9pM6fPLur7R/9C149sfug9cbJk+dJJYxl
8pvOmcaXqQunx3c0dyOdgZ2JZGaiNhBvOGfarMNW7D4+fEDVmHOcWbdo8MPN
B9XrISuNP7zJif8Nt27cuzZr705h0Dtr965uHWbQ5pQyzZwf3LwL/S5PXvKl
YM7ypiEmqb85ZxnvebghNGtk3xgR17Nec86y5wQzZtarIYt+YH4lVvhcD4O7
0UwPX3HKsLPIFlJUZpGFJIkernbOutacb1287tSBYzKLAOEIPWwNaXad+ZWM
sgH17yYXiQyl4N+tq0OLSOdl7cg266GdjSDEiSzyljTUwxYzO8o5Abvu2t52
5NCQut6cUwxktaBQAOSzHr4cj6Jr+OJ/xwe6F05+PXFdPm+oCywSW6gIcjQB
x6y73t6da0M+RB2UEo0+HT5O+unhSwZpqu9D4xV/dbh8aTLb13Du7FHfKhIe
dhEMHIN79HBVgFFUnbLSnDi2G1f7WGQbfCVYx46eI0qCVZmTFUdNLVythrY0
jX2xz6KQsCS7oJCw8I4ergxlho0SlgxuXCSxxhhMcukgs4tjjQ1YIijxOjQn
oFhnlKOLoAT+8DADY8rR4a9OHTynDtHcFx3cKFaX/q4FF/5zWlDis+TFBJSD
+zfblPVRovmKORgVRgny1aNgNq2fR776s2ExlgNdN5Z3WIMoGj1c4dTBoqAA
aogO8DUELDrA7rB2KZRolqEFy6OgUMOoo3nVjWKryGZ5fISFUf4S8kdlWZFl
tWKJk9nhPj3fxacjmllsHA1LCTYExQIs2BAUa6ceLjegAbf5KMUdafTc1P7+
z7ptjbNgsGy4ovBt8JVH0pK68XEiYWggdJyuRI4X9KVbBxafGjsg+NAdpCf4
UqNN39AOK4dVh7VH5NjVX+RI5Xw7OVQXoafSStbYMgvrSU7l9xHpXGFXtOeT
zOF/ZUXzaL3RGtAgCGK0UqrM+ZmvDrFKCUqUSUlGUjIexerCqnt+/KSgRFmM
cqFo9HBpAsroSO/I7g5BwRyMEhRKlsINo2h/2G6PssLDoYzEw9KRSUa6dZh2
hXn35wSUaFbR6dLBurIqCcXBy9QYXY2Pgi2kDYxYgKL9YdGGt7Ue/3xYdKDh
pO0UHYQDX3DqYLthaBQyFZR4LkxCwQbYggj5/QuBocUUFGG9JSFLapyZHu6D
K9ieuWVf48xw6BbSFdn0tuSFyLbEnf/LQ0bZvMaZ97TObG3kd1m9F+cC9kh4
thH9vaasuqCdp6m/Mile4N1STC4r7jezwfJbqbqinaap1sPnRUrRU5toFPzd
VIlqk91VAXbRM5xo/22xHTXYM7dZs0qUt5+zOAW8nX/ek/+2CKXqkuWZRVoQ
3bu6UnUpvO1GsbNKdSPC288moJCcpGg5+Sko2h/Xx+VfiLfJvIfm9uj8c+tg
Ucrv+J5JQCEwhEdQovssYbtnQpbcYHOjBMuxHWBToIeNTh0sSrSPju/gklCg
Jcgp5NWY/syNcqM5hzihz3K82hDyx3Tza7SPhhohSJktOyQ7O5XQPU935mu0
zxAPP20QbVFbFs8fS/VrVlL5Oyor6cr7wumRnHH3hQTJf2L7lIEtZFsVI0Wf
3uS0IlqZkkvloxee35S3oeedua79Y1DBmKGfuzzlR6XQT+V564c5V23E21Nv
YWO66GJkIkAcyrGhPpTpN+cKd1vx+jwZzCqUPaNEDgSyYR0SOwblZnNe/k6m
LmTBLebX6DORaCcjfe8ipw7mrUzJZ0SkMquSZh03yi3OKBf3e0mz8SY6wH/i
TYxBkyJv1ob8YJ7OezQptCoiGyewrspqxLoKyWgL/uTUYWZiPshK+IRztnmP
VPSMLL5DeDwBRZ4/Bn5gLaNP8JlFetPHQn6Yla8HZosX2XXgB/EiXSEA2ot2
dirf8ASdc7TOLC6rfUgrNy7rrHrUgvmYBScJLPHTvAxiSDsgMsgA6iEkg3ZT
mQWy7H75Vov29QTNBj2PRU/hV+qMHGVg34KQHZQLgWbwRyOhVI/sfgdKU2UX
YOkEbFnKfphq0r76g1uKIwq3Gw3BxEPYgDGmn0wRAbBJVmgneAtEndCXQ3q/
992ftL5FY6Pfeqo0WYgZrNts4oiL7V5T1AUMR17TbVppRINWGp9BEb+zAhI6
afOedirY7AuhTuLBAPgae33yEvVCL4tFrNtYZHahaaoPDsdlVI9+ozHfWT2z
9aGS7EFjsOmi8BONoX52Y9/dEQF6AdopuA2Psd3Q70vsuzu8RnlaMZ0dI5jF
FfWwU9LP9GEaNYaHaDtZQ/ETcYH/YBAoADLSlWKe1FQRIdzGxgbPsQWhapC9
v3s7Paqq0GWtK7wwg6chua93lAiiy69+uYGcZwx7QuRUvs6bB5163WssgQGQ
DxGjC4yEXtCq8jozc1Qap3BuP/qtRJp7VHpk57s7t2SGulq2rlv5QeuzqqL/
pUaV6nqkvnP+k3z6nm5KDS5vUVXbM2t2dnZ+ur5jS/ua/tWZruVtbzW0vFG3
qr12lfJWzF+WXv3c6wh6bd2G9vV8VJU+eNmu9z/e2MdHzdYH7+zYKV9feROu
c2OOiTVeRXv7wZOqWmuYIlGs0v98vyE1+F698j5Y90T/3x/lo6o4pN975bfV
77b8Rnkdq+atNx81Wx88RBZJK/eNvZryf1XgBbY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26970766]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->143714723],

Cell["Solve a linear pendulum equation:", "ExampleText",
 CellID->197082999],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
       RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", 
      RowBox[{"1", "/", "3"}]}]}], "}"}], ",", "y", " ", ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->60898323],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       FractionBox["1", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", 
          RowBox[{"Cos", "[", "x", "]"}]}], "+", 
         RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{292, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->607390813]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "/.", "%"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "17"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->593887885],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 103},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->398867391]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->588500511],

Cell["Displacement of a linear, damped pendulum:", "ExampleText",
 CellID->454854854],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
       RowBox[{"3", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
       RowBox[{"40", " ", 
        RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", 
      RowBox[{"1", "/", "3"}]}]}], "}"}], ",", "y", ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->609335315],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       FractionBox["1", "453"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", "x"}], "/", "2"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"453", " ", 
          RowBox[{"Cos", "[", 
           FractionBox[
            RowBox[{
             SqrtBox["151"], " ", "x"}], "2"], "]"}]}], "+", 
         RowBox[{"11", " ", 
          SqrtBox["151"], " ", 
          RowBox[{"Sin", "[", 
           FractionBox[
            RowBox[{
             SqrtBox["151"], " ", "x"}], "2"], "]"}]}]}], ")"}]}]}], "]"}]}], 
   "}"}], "}"}]], "Output",
 ImageSize->{506, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6529411]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "/.", "%"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", "4"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", " ", "\[Rule]", " ", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->374510743],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylWc1rHVUUv5mZNy95/dQ2aRUXsa3+BW7FhagUEXEhouIiBiWhttE0bnRh
00q70YUvKTYqVvAD/FhULBWhglgQC2JBLEgVpILURYtgcREQxt+55945M2fu
3DjmkUzunTn3d75+59w7Lw9MLcw8tX9qYXZ6avK++alnZ2anD07eOzePW+mI
MeY0fp/eaTAuMLK/O4qiMCmN7Me8QRdDdxPcfLOcVWW22vnq6j8Xf/yDhseC
Ulvo0rty5a8nHv9wdubU8wtnsMIctbJ9h59amXKNfWZM7p5ahByr5g58xqrO
ff3riy98wRgkZTLR5+5ULMjUfLOdf/zRD0vDb2iY2DkAAUvDlxkmdWbgQ1aY
Hs/FPsLN/IMG/iMPfwCnBf/y5T8RAcFv2l210/tP0032/oXvf4f/4o/Ye6QF
r+fip+PBeMeOfvX5mZ8ET/D/H574y/GAs3CZhodrue4HspOUXv586er0k5/Y
hNP9k29/dyTIqo12/v57F1ZOnPfS1RgfjqyCm3CWhn1l6WK5iixiafDu/r0n
ibOjzqIw9gY7Bz9BchqOKn8WI6uEi2MqlocCFknmWPrVV859euqiSNeqqsKn
NMDVDSoCjHj+299Qp4IY5kIVW+MOVOz0nHHXrrG1anmgos7+wHi4QMOXWuzX
LCRDaDpQ+WA8hBdB7orXtFMyxbhIMlJdOP6S+K6Ce8puN79N4SQt+rNohsQC
hMl1642KaTrSu1SGb488F8s893L1l/1F8q9fXxXtKF6UcEj7bjXXcZh0cWIC
6apiFl+79vdDD75LQ91BtbY9Ad8Sl4VqDLKINqkZ1gaWQzvcbWi7sXCchUG4
8v4W8d1bI9qTAFN515FdQeffahmDVehg99z9FoiAYOAKI4GAWLEfNQ7pnN/a
sKQZB+E4W4RWhYZVFNLp7bkhA+2gHcbAJJvFDDbAHTASnBhzspSZ9joIWyAc
36x4MG7naHXoyejMXLUZDAARsQqCjwViLKzdovC3Fa6KEUpcpRuhoSIN5tGg
lbwzABLANKR40L6yzfMGCsg6WyMZ5JBURBUPbrISeAbm4MdkdKEVDvmOiD7p
kVt9FNxeyXxcPHT2y7O/SNSQRHgFKfYyR3BwC6nEqrvuXEEEczw3fXAJUwwB
ACfgNtk+4X1xlg6spdxqCt+NzHZc37HdX9ts2SsnQm4U7iSlpEJz11X0bmGf
j5ZzuAQ3cGW26x5e2sAEgd/gctiGHHNEB4lCTlFOCLaWC9qSl3OkGSFC9IgJ
Vg4hpQAndOlBP903hkNsEpt+Np2t112mNTZuPhLhinSRGxR3tBcsLzW/3XoF
1oAoKDo8gCymNhp9DGA3Fxs/JV9uUZi6/4mlVJNc43JiYfbKPrZJWWw9zJi9
aNBYmICvJsMAkQVRILo3EgvwmwvMaqLslP3d1em+4Gpmk/Sesle4HV+fYPfV
vGTdsmPZuFZOrgOPBjfoPPVMxAY5vTAKvz0JiqDGUGSvHlcZYFulz++PoAiz
xtWqvvcIJUm75gGLMlq0n2X9fsL6uaXTcELNez5f/P5o5iwG9/7YmVZzva/4
MOGZBlzKQc/XAnYxGrbp0ZWqz4q5Ys5OOweoi1Ti/cGcmsJzLXp0P6N1aalf
KsTuKjmSi5ABDz/c6uY74Dbtl8zebBGQDAZHig+2IDdPsToH/q1wWGOHP2X6
N9S+z4TrSq8FGcl2yrtCTErYLlKiSTgRxmBmSO0PI1JS88OaJrZDarkegfA3
KOE9QCp52JKHtRjKOFLLbTj+GxL6K2+fUpmxdbG3S57LuawNx/NBr2d8qbCl
/7BecKRylmo5WOsdkLXikIWTkqzWLLBdDQxfbn1a/QZAMMQ+6eftGkwK193J
JyzF1oPWIDcNl2u+at+qUWJ8OV8ux7IcrXbWIvvVepHkbakbUlp6LD0lhhD6
poXXS7dpWx/mqsaR8049L/792++NOovHg7nmDi7fVcWkJBsiJZrkPBPDkHeN
mJT0iZAm6bnHaxFoY2blrI0P9+LXu/GphsDv+90QUuMM5DCZttW1flPTyj13
PXbzTtYRQXYWppI5UYu53n+tj9wmneSOOgoXYvgZu1h5ViIy6aurnKWczZXG
fd4tV0pbKf76tFK3W+qTtYwp6TQcH5Lg7cT956TDOj4wdlpHAp31uDvrW9eW
cf4P0enG1Yz8C7KK01I=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->244056792]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->221789260],

Cell["Study the phase portrait of a dynamical system:", "ExampleText",
 CellID->86766237],

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], 
         RowBox[{"y", "[", "t", "]"}]}], "+", 
        RowBox[{"3", 
         RowBox[{"x", "[", "t", "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "t", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"15", 
         RowBox[{"x", "[", "t", "]"}]}], "-", 
        RowBox[{"y", "[", "t", "]"}]}]}], ",", 
      RowBox[{
       RowBox[{"x", "[", "0", "]"}], "\[Equal]", "a"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "b"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], ",", " ", "t"}], "]"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->72133840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"x", "[", "t", "]"}], ",", " ", 
         RowBox[{"y", "[", "t", "]"}]}], "}"}], "/.", "%"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"a", "\[Rule]", 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"13", "+", "m"}], ")"}]}]}], ",", " ", 
        RowBox[{"b", "\[Rule]", 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{"15", "+", "m"}], ")"}]}]}]}], "}"}]}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"m", ",", "0", ",", "20", ",", "7"}], "}"}]}], "]"}], ",", " ", 
   
   RowBox[{"{", 
    RowBox[{"t", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"Evaluated", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->193359593],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{96, 216},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->116561999]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->255042640],

Cell["\<\
Find a power series solution when the exact solution is known:\
\>", "ExampleText",
 CellID->742016881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "+", 
       RowBox[{
        RowBox[{"Exp", "[", "x", "]"}], 
        RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", "1"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "3"}]}], "}"}], ",", "y", " ",
    ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156207104],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", 
         SuperscriptBox["\[ExponentialE]", "x"]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"3", " ", "\[ExponentialE]"}], "-", 
         RowBox[{"ExpIntegralEi", "[", "1", "]"}], "+", 
         RowBox[{"ExpIntegralEi", "[", 
          SuperscriptBox["\[ExponentialE]", "x"], "]"}]}], ")"}]}]}], "]"}]}],
    "}"}], "}"}]], "Output",
 ImageSize->{469, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->348680830]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "/.", 
    RowBox[{"%", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->346495992],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"3", "-", 
   RowBox[{"2", " ", "x"}], "-", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "+", 
   FractionBox[
    SuperscriptBox["x", "4"], "6"], "-", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "-", 
   FractionBox[
    RowBox[{"11", " ", 
     SuperscriptBox["x", "6"]}], "360"], "-", 
   FractionBox[
    SuperscriptBox["x", "7"], "105"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "8"],
    SeriesData[$CellContext`x, 0, {}, 0, 8, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {3, -2, 
    Rational[-1, 2], 
    Rational[1, 3], 
    Rational[1, 6], 
    Rational[-1, 120], 
    Rational[-11, 360], 
    Rational[-1, 105]}, 0, 8, 1],
  Editable->False]], "Output",
 ImageSize->{297, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->382340244]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->152663548],

Cell["Recover a function from its gradient vector:", "ExampleText",
 CellID->225115348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"x", ",", " ", "y"}], "]"}], ",", " ", "x"}], "]"}], "==", 
      RowBox[{
       RowBox[{"2", "x", " ", 
        RowBox[{"y", "^", "3"}]}], "+", 
       RowBox[{"y", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"x", " ", "y"}], "]"}]}]}]}], ",", " ", "\n", 
     "                ", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}], "==", 
      RowBox[{
       RowBox[{"3", 
        RowBox[{"x", "^", "2"}], 
        RowBox[{"y", "^", "2"}]}], "+", 
       RowBox[{"x", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"x", " ", "y"}], "]"}]}]}]}]}], "}"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36516823],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], " ", 
      SuperscriptBox["y", "3"]}], "+", 
     RowBox[{"C", "[", "1", "]"}], "+", 
     RowBox[{"Sin", "[", 
      RowBox[{"x", " ", "y"}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{228, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->590316055]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->152078584],

Cell["Solve a Cauchy problem to generate Stirling numbers:", "ExampleText",
 CellID->23973678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GeneratorForStirlingS1", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], " ", "=", " ", 
  RowBox[{"FullSimplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", " ", "y"}], "]"}], " ", "/.", 
     RowBox[{
      RowBox[{"DSolve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"1", "-", "x"}], ")"}], 
            RowBox[{"D", "[", 
             RowBox[{
              RowBox[{"u", "[", 
               RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}]}], "==", 
           RowBox[{"y", " ", 
            RowBox[{"u", "[", 
             RowBox[{"x", ",", " ", "y"}], "]"}]}]}], ",", 
          RowBox[{
           RowBox[{"u", "[", 
            RowBox[{"0", ",", " ", "y"}], "]"}], "==", "1"}]}], "}"}], ",", 
        "u", ",", " ", 
        RowBox[{"{", 
         RowBox[{"x", ",", "y"}], "}"}]}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ",", " ", "\n", "   ", 
    RowBox[{
     RowBox[{"x", ">=", "0"}], " ", "&&", " ", 
     RowBox[{"y", ">=", "0"}]}]}], "]"}]}]], "Input",
 Evaluatable->True,
 CellLabel->"In[1]:=",
 CellID->203060099],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   FractionBox["1", 
    RowBox[{"1", "-", "x"}]], ")"}], "y"]], "Output",
 ImageSize->{55, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->29685719]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SeriesCoefficient", "[", 
   RowBox[{
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"GeneratorForStirlingS1", "[", 
       RowBox[{"x", ",", "y"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"y", ",", "0", ",", "4"}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"10", ",", "4"}], "}"}]}], "]"}], 
  RowBox[{"10", "!"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->706507859],

Cell[BoxData["723680"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->523178789]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StirlingS1", "[", 
  RowBox[{"10", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20549847],

Cell[BoxData["723680"], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->52133453]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32474],

Cell["\<\
Solutions satisfy the differential equation and boundary conditions:\
\>", "ExampleText",
 CellID->588875236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}], "-", 
       RowBox[{"y", "[", "x", "]"}]}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "==", "4"}]}], "}"}], ",", "y", 
   ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->886221327],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{"-", "x"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", 
         RowBox[{"5", " ", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"2", " ", "x"}]]}]}], ")"}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{263, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11728215]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}], "-", 
       RowBox[{"y", "[", "x", "]"}]}], "==", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "==", "1"}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "0", "]"}], "==", "4"}]}], "}"}], "/.", "%"}],
   "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->91162354],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"True", ",", "True", ",", "True"}], "}"}], "}"}]], "Output",
 ImageSize->{139, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->261751209]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->820648221],

Cell[TextData[{
 "Differential equation corresponding to ",
 Cell[BoxData[
  ButtonBox["Integrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integrate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->576300460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
    RowBox[{"Exp", "[", 
     RowBox[{"x", "^", "2"}], "]"}]}], ",", "y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->173516581],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        SqrtBox["\[Pi]"], " ", 
        RowBox[{"Erfi", "[", "x", "]"}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{289, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64686769]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"x", "^", "2"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->158306030],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  SqrtBox["\[Pi]"], " ", 
  RowBox[{"Erfi", "[", "x", "]"}]}]], "Output",
 ImageSize->{95, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7395133]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145464064],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["NDSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NDSolve"]], "InlineFormula"],
 " to find a numerical solution:"
}], "ExampleText",
 CellID->570222531],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"exactsol", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], "+", 
        RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
    "y", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70859778],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"Cos", "[", "x", "]"}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->280744878]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "/.", 
    RowBox[{"exactsol", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2."}], ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->408304438],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.4161468365471424`"}], ",", "0.5403023058681398`", ",", 
   "1.`", ",", "0.5403023058681398`", ",", 
   RowBox[{"-", "0.4161468365471424`"}]}], "}"}]], "Output",
 ImageSize->{317, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->379804217]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"numsol", "=", 
  RowBox[{"NDSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}], " ", "+", 
        RowBox[{"y", "[", "x", "]"}]}], "\[Equal]", "0"}], ",", 
      RowBox[{
       RowBox[{"y", "[", "0", "]"}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", 
    " ", "y", ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->228784146],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    TagBox[
     RowBox[{"InterpolatingFunction", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "2.`"}], ",", "2.`"}], "}"}], "}"}], 
       ",", "\<\"<>\"\>"}], "]"}],
     False,
     Editable->False]}], "}"}], "}"}]], "Output",
 ImageSize->{317, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->2508220]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "/.", 
    RowBox[{"numsol", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2."}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->278041262],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.41614676427368`"}], ",", "0.5403023186438519`", ",", "1.`",
    ",", "0.5403023186438519`", ",", 
   RowBox[{"-", "0.41614676427368`"}]}], "}"}]], "Output",
 ImageSize->{317, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->162511186]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->486467376],

Cell[TextData[{
 "Compute an impulse response using ",
 Cell[BoxData[
  ButtonBox["DSolve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DSolve"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->241997163],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "'''"}], "[", "x", "]"}], "-", 
       RowBox[{"5", 
        RowBox[{
         RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", 
       RowBox[{"9", 
        RowBox[{
         RowBox[{"y", "'"}], "[", "x", "]"}]}], "-", 
       RowBox[{"5", 
        RowBox[{"y", "[", "x", "]"}]}]}], "\[Equal]", 
      RowBox[{
       RowBox[{
        RowBox[{"DiracDelta", "''"}], "[", "x", "]"}], "+", 
       RowBox[{"2", 
        RowBox[{
         RowBox[{"DiracDelta", "'"}], "[", "x", "]"}]}], "+", 
       RowBox[{"DiracDelta", "[", "x", "]"}]}]}], "&&", 
     RowBox[{
      RowBox[{"y", "[", 
       RowBox[{"-", "1"}], "]"}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", 
       RowBox[{"-", "1"}], "]"}], "\[Equal]", "0"}], "&&", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "''"}], "[", 
       RowBox[{"-", "1"}], "]"}], "\[Equal]", "0"}]}], ",", 
    RowBox[{"y", "[", "x", "]"}], ",", "x"}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26409797],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"y", "[", "x", "]"}], "\[Rule]", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["\[ExponentialE]", "x"]}], " ", 
     RowBox[{"HeavisideTheta", "[", "x", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", "x"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Cos", "[", "x", "]"}], "-", 
          RowBox[{"7", " ", 
           RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}]}], ")"}]}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{399, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->285033745]
}, Open  ]],

Cell[TextData[{
 "The same computation using ",
 Cell[BoxData[
  ButtonBox["InverseLaplaceTransform",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseLaplaceTransform"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->485054696],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"InverseLaplaceTransform", "[", 
   RowBox[{
    FractionBox[
     RowBox[{
      RowBox[{"s", "^", "2"}], "+", 
      RowBox[{"2", "s"}], "+", "1"}], 
     RowBox[{
      RowBox[{"s", "^", "3"}], "-", 
      RowBox[{"5", 
       RowBox[{"s", "^", "2"}]}], "+", 
      RowBox[{"9", "s"}], "-", "5"}]], ",", "s", ",", "x"}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280514401],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["\[ExponentialE]", "x"], " ", 
  RowBox[{"(", 
   RowBox[{"2", "-", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", "x"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Cos", "[", "x", "]"}], "-", 
       RowBox[{"7", " ", 
        RowBox[{"Sin", "[", "x", "]"}]}]}], ")"}]}]}], ")"}]}]], "Output",
 ImageSize->{190, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->43100140]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29957],

Cell["Results may contain symbolic integrals:", "ExampleText",
 CellID->133971055],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], "==", 
    RowBox[{"f", "[", "x", "]"}]}], ",", "y", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->149231047],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{"C", "[", "1", "]"}], "+", 
       RowBox[{
        SubsuperscriptBox["\[Integral]", "1", "x"], 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"K", "[", "1", "]"}], "]"}], 
         RowBox[{"\[DifferentialD]", 
          RowBox[{"K", "[", "1", "]"}]}]}]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{304, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->668911171]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->385699740],

Cell["Inverse functions may be required to find the solution:", "ExampleText",
 CellID->22385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}], "^", "2"}], "\[Equal]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          RowBox[{"y", "[", "x", "]"}], "^", "2"}]}], ")"}], 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "/", "2"}], ")"}], 
          RowBox[{
           RowBox[{"y", "[", "x", "]"}], "^", "2"}]}]}], ")"}]}]}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", "y", ",",
    "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23247],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->139981575],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "::", "\<\"ifun\"\>"}], ":", 
  " ", "\<\"Inverse functions are being used by \\!\\(Solve\\), so some \
solutions may not be found; use Reduce for complete solution information. \\!\
\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/Solve/ifun\\\", \
ButtonNote -> \\\"Solve::ifun\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->26080280],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{"-", 
        RowBox[{"JacobiSN", "[", 
         RowBox[{"x", ",", 
          FractionBox["1", "2"]}], "]"}]}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "x", "}"}], ",", 
       RowBox[{"JacobiSN", "[", 
        RowBox[{"x", ",", 
         FractionBox["1", "2"]}], "]"}]}], "]"}]}], "}"}]}], "}"}]], "Output",\

 ImageSize->{514, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->59494574]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3520],

Cell["Generate a Cornu spiral:", "ExampleText",
 CellID->295701773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"x", "'"}], "[", "s", "]"}], "\[Equal]", 
      RowBox[{"Cos", "[", 
       RowBox[{"t", "[", "s", "]"}], "]"}]}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"y", "'"}], "[", "s", "]"}], "\[Equal]", 
      RowBox[{"Sin", "[", 
       RowBox[{"t", "[", "s", "]"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{
       RowBox[{"t", "'"}], "[", "s", "]"}], " ", "\[Equal]", "s"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"y", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
     RowBox[{
      RowBox[{"t", "[", "0", "]"}], "\[Equal]", "0"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", "t"}], "}"}], ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->316015371],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"t", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "s", "}"}], ",", 
       FractionBox[
        SuperscriptBox["s", "2"], "2"]}], "]"}]}], ",", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "s", "}"}], ",", 
       RowBox[{
        SqrtBox["\[Pi]"], " ", 
        RowBox[{"FresnelC", "[", 
         FractionBox["s", 
          SqrtBox["\[Pi]"]], "]"}]}]}], "]"}]}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"Function", "[", 
      RowBox[{
       RowBox[{"{", "s", "}"}], ",", 
       RowBox[{
        SqrtBox["\[Pi]"], " ", 
        RowBox[{"FresnelS", "[", 
         FractionBox["s", 
          SqrtBox["\[Pi]"]], "]"}]}]}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{431, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->258315598]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "[", "s", "]"}], ",", " ", 
       RowBox[{"y", "[", "s", "]"}]}], "}"}], "/.", "%"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->623236321],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNm1vIpWUVx1/3e9j7O8z5qGnOmI5aWUnSiTxlzqTTZF6ERXQxSeBclGHT
Td3UTXNTN3WTEHlRBh0ujMQIDCIhEiIhEqKCMAi7SIKkCyHY/db6P4d3P9+z
9/eNA9bw+foe1rPW/1lrPYe11rPPnD3/0Kc+ffb8uQfPHjv1yNnPPnTuwc8d
O/nwI7xqL2ua5kn+e/xow/2cO//vyfmc/3+Ma8vjR9NTY49z/xfeXuFvX3rp
38/99m+Pf/e5Znjs279p2p8//efnf/93+/T2aqsjdh3+9Md/fOPrv3rwkz+6
/77vPPyZnzz6zWe99fDlLz197qEn7r7rW1/8ws9++tQfXn75lbdVuRx0Lq+8
8p8fP/H8Jz7+fRj98Ae/g+lGfP/ML/9y4Su/gDscX3zxX2+pctlv1x5q4D/w
ke997avPvPDCP5t98S1d4S1s6GPz5ioHp+3oMAjoBISHnQ7swOLavKnabq+/
pQW9NZmXOx+6izQQI/zGBQvsdnq+Q2+6vsqfAYjyeNvcUJWyy9/SfdCBsbna
n7kLra6vttqMraDi2hz3Z4z8+fNPAaw5UW21UbSSbjEJDfVnb8Ubo6Fru72u
ymt91FvTzh7nhXIxMq9uv/VROtS0SGo6LISVUduzv/6r2nGP4u322hXccTB8
xG5dSz3SwAQr/NJ0NUSZ8KLjWBMBzSwi49m84toFK635V0DCI3E2zUFNn9X7
jh7BECvDZlq0eEMVsaSiSzpvFhBf/AANGIo2+hydogdNh4aaFiEINTtPCm/x
vrVwgh9cV0qFJIxn2Y5hitvarXPdpd6hc7TJPVcokKt7VIqB6F/AgLQFDGCm
qd0eCJqcFFgm3PZVfNIdQuh1xpd9yzkdBCwS0TmigAJWTTncnL7nMWYa5NNB
9E9PAUYjDRDU00c9QWl6P1jgcL13+blpuhVI8Vm6b7cbURe8Skg7gGBSRglA
JubbLeiwpBlzYpcZyOkCf6g4jWLaTngeCq82GV0F0U4xD4V2NwqfccwDgFEw
2qUnqBA9zQzpGhhxP3qEGwATWlry0ry1L+x0YEcI7cUDI2TZLx3ZeuInA8qY
oEI1oHL99eiTYccb/oDXtK5VzfGg5w9Ppb3Go3DSN1xl5zi3arLk4366K3kD
/3QPNHDIKQGGXm2cOM9N9AYi3vINL9BspDkIIt4kb4UmSN9/SXgRj3GTfteS
t/JPRtWqZ/ONa9csGvi4hdbhIO9FwZAn7XIPA0nhEw5vt7aS2lgfwv/rY75s
5dhm8kIR4gQAQZcYWLgS7DAOURWa81GFNpueiUEuqi4HGXm0Hqsike6AAZhk
1Vkaf/xDM5iHq41nR6JlyQldp7ihNITRkcyV15oSAwrpajsUeRYVCrqHu3GL
b8BUKHgpFDwuoECAUPAnRCWKRV3k9U7SpfEkfYpSUTG3Uo6u7pgbO5SX7buq
18XKNEueP5ZLx+u9xkwJBbpXY00igT+doCt2e3wFCvSrSTigkNVFKE1wxYxC
wRq8gEKDWuMaXdAlXmukBP55laij0NovQ9ut7w1mW2cXhgPOWR0R6wBOSw06
YxyAhS/yI+HI8/UqHBmt4+gYh6nLE48PNDjNI8pZw22/Tk+AKizoEkXIlpo/
5R95lVuFJS09wrKwQsg5MI727dwLjSZdI59EvdIszXFTyLERoMRpwVJpIm6u
WRglVTSjmcMlratPWtW1EZVJMKvZzXS3ifTks8CAklWAl8jUEsyNsKQZ0bFs
r6HdIwwixCdgqP0vIxNuE6AMvrprEQIB4rXdR7BWhDx2wmpf31tW5Y92G66T
Kex5hhcYFPiY3ziGGWDkp6DUZKF9fx88rb73L+V6ZGE7ZUQluUPaKcudbfTa
5LQBGEgRq/0CYLgCD0rFq3mtlzGWRCBt4QFCgbbwcFvz/ftUO2sNH+5xCh7D
TlBzCgrRXIPi0A/XtGMNu7R6fNVGqjC/7S20798t9mGkKnSxKMx599wp5obW
3mo3lsb5EonyirQuBYl53fLvFhmpl/RR0R1W5lGBeYpaEGa6vn6+dS3KM8O+
KEHhtM90ZngfpwHbEPWOLOAviaK74FHa/ykpYLGgJDD+QWief+OKnkOP59it
c+mQybMGsK8bvbxcLmU+8MYV3PJsf8i7odhcbbnns9vKsixSANQoGoerZzHK
vYbnMHZBTud4S2uF3ON7+KEK02w9tyKeeR563TysDwLo2aFsvb4YEfdXeZY7
/w+voAIcHbfbO+faUbYj6sYizaW7zORpYQ67w2023jlPi3Zl1DqO+3J0/+65
4pjJJfHLuG7fEZ8cOc0KPLdtad/PV+2+Z4X8evtxu3qEoTxJHhO3BanT8P96
qzJv88EVVGn1WkKlaDbPeKfnY29UJiFHQPdWeWgdz2vHPSuo8HgGj83Idard
ETXObXmyD1SptE7kHNupKtXegurkQt/2jb4anrurPPZHKi3yzfurVAeiP6AE
26DcVaXyOcryRiFbdWeVSnlTJgfsZhLvqFJ59jjMnsxAqPW2Kp3nU1tNqJZ5
u3VBB0fDk8cu9LAJY9J879B8+WxxtJB1ZAXtofnyfNbRjHGavmjrhz82lVbK
M68a6YeK58Pbttg+n3Ek+UJX9HIe56ieMcQrYNsS2MiTjVpTwYjZa4j48hpd
z7P2SdzY/mH//1CnVYSzMZ2qF0zU7Hz2bOES5+nSI7cijJSHLwXZdEw39+DA
c7q2IbX1ZJyNWbkemIw2ollJWep+Gd6j80reaEBp2qCDUMnS9fniGnOkgmz8
/WDBV2PWd2VTuCtYV6EKBZjz13ePN9l1TRUpJZm1d+ceJ7R29QjpZrtu0o4p
EQG4gyofdIjWiGdt4hNT+JXV9u+MeoBIOXuaMbd6/NAJA3/Mo63H5chQmabp
fJesjbqDr/K30uHWOeFSn6vZ6v93ftkrMdfEVcgbaZNtqMfuu3kjjfOnyN4G
T9PgB7JkGENbR8Jr3cfLHMae4m3pBXsv8ft68ezyNiyibBp8Uf7KAEZRGi1o
0r6WK+N2cnz/taWC7WNupqGlIBebMBYwBUPypmobr5bOMDHbE1VuCYYUi7IP
ubHaxqu/Uz6D/oIn95UoSHXUVGl/qz31KlsrXLO54doqV58bhpQXUYjO4/Eq
9S3OWbE1SwreaPHX1VXadzgt36FS4c6QXlWlfZddrGatmRYsV1bp3uN0LBn0
iQkIpV9RpXuv06lCiH4RfHRBQ9rpYaFQzT5S5XK7P9NbFGMD73CVSntQlYFM
GwerVO/zZ8wdduUHqlR3jSTajnp/lUo7aO3wU/Yg9U27cLqMe9jXvVUeJwuq
PVWqU5EqZOR2V6kUYeQae32cKFrRCQLT02aVSvFRzqptLPTNYiubAzeqbU9H
tEF761UqRXG5Ar5WpToTJOmrodpp3H8momAsmaU90lXvLypO/5A/57hyehF8
jEDtc71leJU47itwLOOzLN6/L+ojRPqr2q9ai5ShyVmgfsEyy+J9tUKucvSh
VWlt5Yhy/N0lKiO6OfIIuxpfl1sVpuyTds5FBnKLDF8J+pQJU02i6Tw3yYqh
0jFqPhKl8Xk5N18N+iJbJ1sOyNABjjTtHip8oa3y9HWnU65W+URVXuAHfxWK
dW4hFWCXcNL+VRG4ZUNTpgC0tA2xTZElrq+SrQ7NmOf4SOqZh9I5IJuTUmYs
aF+yco28zvvEqJX5hXtlpyqBSiLKGmunrJW2L+wsSblKPlnwmusKam8d1iQ6
ROcdead1GlPRn5gfFudcu5xU+6CKQJ7JXMKU9ZtnpV/RArxtd+jneAZEa3lX
0obBpPGS87V7iue6ZMUZeY5zyVaDZl+gIobE8oYbOx9hp1Astd/0Wt/nXiP3
cCH6BvTWi2odZQmCnH/0fszSs5SiRwaX13msmswjgBYqbm3h0cqfXUgnv+ry
r4mjNMwrLn8tHfeRfrXc6xhGM8RqC8/aHgqGctCTqIWQtb4YFIUWphrnqkjq
bEesmje9BiR/aD/VgAYw4OJIwztUqGoLP9i1FI/BEY5Urw6RfhrfsjRC7Kyd
qqOpHBU0B63qATDRSS9YKUEbVqTyLFyuE9V1k84ahp2EyxmkbdkNE6Savszm
JO5JEKU6NpLogaoA6ezZuDa97Xg5Hsa1Y1hPVtZiBgZ1HYEA8x3HNFXzNb+r
TBM0kattkp5rYas0kUeUW2dIVQ05IxylCU1XroSoiVTOT+dQuApLnv2U6U4n
NlZiWfSUSZwGZBN56uiEi2nE33XSs+bFUv5GHJFh3azP+8cKDbpF+nTuhLdY
JCCQSS8WQW1VMwDHihFeSNa5nSA5n2RwG2yAN53tkLXT2hA8Q56w3bpcw+Da
txvFfvGEW+kHVkEXBjxfJ4GyR+qUXPaC7XYaVV2sJ49EKXRDU+XiuGjTgY5m
YsvKkCo/aTgJQa5r1vdPxwvbacZKiMRW0WiYsXRkeZ5mCHSVjpZoPdd0JY0U
Zwq37A7vne/8jKqw5lE+nuXnfigHuEpQBqxZehtHBdLTObVOFRTNYuXKI/3l
GU14TxeYtj8BKNS5xlas0NIw35RL1OjS8b7RmwEjaulQaR1MwptPikm/eb/X
XwTeLo3LYg1dS/HKPG4UdLbPVjA/l9ppoVI4b2OoXBk2ixF5Mbi26rHo33qa
ZeZ+WgUZvNHPF7j6bm9KB1Rp1/4ZKHm/Vfpn3skMrxLnNYWXOs4DyU7SI0iU
RBY2jW+l5uQpfNXGLeDMO45Sn5eGM9vb+Uy1wxeJTkLZ9n8Cdj/pYVGHfjEQ
MiFt9EIdbwvosvUVrcfodNlJVGEpYuOO5wt+KshywE6hMztWb2rj+A6/LUi7
Z15ZdXJX5BhyIMo+bLd7TjGUtmWh+sIcql0igrQfzXXszNfYKhLJs36KQ3U+
Dx3Rg3iizN4rh8kQgh3vxT1X8es5GUlJe2xRbcJN05nWC24UsyFXGVVI90Tr
6Cz3ksxQGbGllSREmgdGuraop56FOlH47bEoO9TQ63mv62OroN/XR7uHVvWc
2g3RKoq7mivjc/hlRD1fp9NFeAsGS78YanUG2/YgOWNojbxO1ekcmn6X5NkE
ywpc8EoSXdtXlaMcRfpNFI2tJ6o/K9JWLFjPhXq+ZEitdWgvVN/8PSyUhtY6
cqjKxX/zNdBMaXaVAPCL3n8jph9vKF+PPuhbPRN8S7QGfuvbJZ9IeQ5zXT0L
nX/xZi9DrcuvzWX/BZHmEGg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 165},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->89597874]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->61108469],

Cell[TextData[{
 "Solve the 6",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " symmetric power of the Legendre differential operator:"
}], "ExampleText",
 CellID->273724135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"sol", " ", "=", " ", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"192", "n", 
              RowBox[{"(", 
               RowBox[{"1", "+", "n"}], ")"}], 
              RowBox[{"x", "^", "5"}]}], ")"}], "/", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"x", "^", "2"}]}], ")"}], "^", "6"}]}], ")"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2496", "n", 
            RowBox[{"(", 
             RowBox[{"1", "+", "n"}], ")"}], 
            RowBox[{"x", "^", "3"}]}], ")"}], "/", "\n", "        ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "5"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"8160", 
            RowBox[{"n", "^", "2"}], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "n"}], ")"}], "^", "2"}], 
            RowBox[{"x", "^", "3"}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "5"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1632", "n", 
            RowBox[{"(", 
             RowBox[{"1", "+", "n"}], ")"}], "x"}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "4"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"7824", 
            RowBox[{"n", "^", "2"}], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "n"}], ")"}], "^", "2"}], "x"}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "4"}]}], "-", " ", "\n", 
         "       ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"6912", 
            RowBox[{"n", "^", "3"}], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "n"}], ")"}], "^", "3"}], "x"}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "4"}]}]}], ")"}], 
       RowBox[{"y", "[", "x", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"64", 
            RowBox[{"x", "^", "6"}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "6"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1824", 
            RowBox[{"x", "^", "4"}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "5"}]}], "+", " ", "\n", 
         "       ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"8256", "n", 
            RowBox[{"(", 
             RowBox[{"1", "+", "n"}], ")"}], 
            RowBox[{"x", "^", "4"}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "5"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2880", 
            RowBox[{"x", "^", "2"}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "4"}]}], "-", " ", "\n", 
         "       ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"19200", "n", 
            RowBox[{"(", 
             RowBox[{"1", "+", "n"}], ")"}], 
            RowBox[{"x", "^", "2"}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "4"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"22896", 
            RowBox[{"n", "^", "2"}], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "n"}], ")"}], "^", "2"}], 
            RowBox[{"x", "^", "2"}]}], ")"}], "/", "\n", "        ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "4"}]}], "-", 
         RowBox[{"272", "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "3"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2208", "n", 
            RowBox[{"(", 
             RowBox[{"1", "+", "n"}], ")"}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "3"}]}], "-", " ", "\n", 
         "       ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"4384", 
            RowBox[{"n", "^", "2"}], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "n"}], ")"}], "^", "2"}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "3"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"2304", 
            RowBox[{"n", "^", "3"}], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "n"}], ")"}], "^", "3"}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "3"}]}]}], ")"}], "\n", 
       "      ", 
       RowBox[{
        RowBox[{"y", "'"}], "[", "x", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2016", 
              RowBox[{"x", "^", "5"}]}], ")"}], "/", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"x", "^", "2"}]}], ")"}], "^", "5"}]}], ")"}]}], "+", 
         " ", "\n", "       ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"9408", 
            RowBox[{"x", "^", "3"}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "4"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"19488", "n", 
            RowBox[{"(", 
             RowBox[{"1", "+", "n"}], ")"}], 
            RowBox[{"x", "^", "3"}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "4"}]}], "-", "\n", 
         "       ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"3696", "x"}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "3"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"12768", "n", 
            RowBox[{"(", 
             RowBox[{"1", "+", "n"}], ")"}], "x"}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "3"}]}], "-", " ", "\n", 
         "       ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"9408", 
            RowBox[{"n", "^", "2"}], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "n"}], ")"}], "^", "2"}], "x"}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "3"}]}]}], ")"}], 
       RowBox[{
        RowBox[{"y", "''"}], "[", "x", "]"}]}], "+", " ", "\n", "     ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"4816", 
            RowBox[{"x", "^", "4"}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "4"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"7168", 
            RowBox[{"x", "^", "2"}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "3"}]}], "+", " ", "\n", 
         "       ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"9632", "n", 
            RowBox[{"(", 
             RowBox[{"1", "+", "n"}], ")"}], 
            RowBox[{"x", "^", "2"}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "3"}]}], "+", 
         RowBox[{"616", "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}]}], "-", " ", "\n", 
         "       ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1456", "n", 
            RowBox[{"(", 
             RowBox[{"1", "+", "n"}], ")"}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"784", 
            RowBox[{"n", "^", "2"}], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "+", "n"}], ")"}], "^", "2"}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}]}]}], ")"}], " ", 
       RowBox[{
        RowBox[{"y", "'''"}], "[", "x", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"2800", 
              RowBox[{"x", "^", "3"}]}], ")"}], "/", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"x", "^", "2"}]}], ")"}], "^", "3"}]}], ")"}]}], "+", 
         "\n", "       ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1400", "x"}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}]}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1400", "n", 
            RowBox[{"(", 
             RowBox[{"1", "+", "n"}], ")"}], "x"}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}]}]}], ")"}], "\n", 
       "      ", 
       RowBox[{
        RowBox[{"y", "''''"}], "[", "x", "]"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"560", 
            RowBox[{"x", "^", "2"}]}], ")"}], "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"x", "^", "2"}]}], ")"}], "^", "2"}]}], "-", 
         RowBox[{"70", "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"x", "^", "2"}]}], ")"}]}], "+", " ", "\n", "       ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"56", "n", 
            RowBox[{"(", 
             RowBox[{"1", "+", "n"}], ")"}]}], ")"}], "/", 
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"x", "^", "2"}]}], ")"}]}]}], ")"}], 
       RowBox[{
        RowBox[{"y", "'''''"}], "[", "x", "]"}]}], "-", " ", "\n", "     ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"42", "x", " ", 
         RowBox[{
          RowBox[{"y", "''''''"}], "[", "x", "]"}]}], ")"}], "/", 
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"x", "^", "2"}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"y", "'''''''"}], "[", "x", "]"}]}], "==", " ", "0"}], ",", 
    "y", ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43300764],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"y", "\[Rule]", 
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"C", "[", "1", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"LegendreP", "[", 
          RowBox[{"n", ",", "x"}], "]"}], "6"]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "2", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"LegendreP", "[", 
          RowBox[{"n", ",", "x"}], "]"}], "5"], " ", 
        RowBox[{"LegendreQ", "[", 
         RowBox[{"n", ",", "x"}], "]"}]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "3", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"LegendreP", "[", 
          RowBox[{"n", ",", "x"}], "]"}], "4"], " ", 
        SuperscriptBox[
         RowBox[{"LegendreQ", "[", 
          RowBox[{"n", ",", "x"}], "]"}], "2"]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "4", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"LegendreP", "[", 
          RowBox[{"n", ",", "x"}], "]"}], "3"], " ", 
        SuperscriptBox[
         RowBox[{"LegendreQ", "[", 
          RowBox[{"n", ",", "x"}], "]"}], "3"]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "5", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"LegendreP", "[", 
          RowBox[{"n", ",", "x"}], "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"LegendreQ", "[", 
          RowBox[{"n", ",", "x"}], "]"}], "4"]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "6", "]"}], " ", 
        RowBox[{"LegendreP", "[", 
         RowBox[{"n", ",", "x"}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"LegendreQ", "[", 
          RowBox[{"n", ",", "x"}], "]"}], "5"]}], "+", 
       RowBox[{
        RowBox[{"C", "[", "7", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"LegendreQ", "[", 
          RowBox[{"n", ",", "x"}], "]"}], "6"]}]}]}], "]"}]}], "}"}], 
  "}"}]], "Output",
 ImageSize->{561, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->61490348]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21161],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NDSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NDSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Integrate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Integrate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23840]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26931],

Cell[TextData[ButtonBox["Differential Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DifferentialEquations-Basics"]], "Tutorials",
 CellID->24258],

Cell[TextData[ButtonBox["Differential Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DifferentialEquations"]], "Tutorials",
 CellID->25716],

Cell[TextData[ButtonBox["Differential Equation Solving with DSolve",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DSolveOverview"]], "Tutorials",
 CellID->332395997]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->18284],

Cell[TextData[ButtonBox["Implementation notes: Algebra and Calculus",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#8313"], None}]], "RelatedLinks",
 CellID->3269]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->50439543],

Cell[TextData[ButtonBox["Calculus",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Calculus"]], "MoreAbout",
 CellID->881697988],

Cell[TextData[ButtonBox["Differential Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DifferentialEquations"]], "MoreAbout",
 CellID->626998396],

Cell[TextData[ButtonBox["Equation Solving",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EquationSolving"]], "MoreAbout",
 CellID->260390562],

Cell[TextData[ButtonBox["New in 6.0: Symbolic Computation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60AlgebraicComputing"]], "MoreAbout",
 CellID->106963821],

Cell[TextData[ButtonBox["New in 6.0: Mathematics & Algorithms",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60MathematicsAndAlgorithms"]], "MoreAbout",
 CellID->529068518]
}, Open  ]],

Cell["New in 2  |  Last modified in 5", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DSolve - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 39, 23.5879032}", "context" -> "System`", 
    "keywords" -> {
     "Abel equation", "Abramov algorithm", "Airy's differential equation", 
      "analytical solution", "Bernoulli equation", "Bocharov techniques", 
      "Bronstein algorithm", "closed-form solution", "DAE", "diff", "diffeq", 
      "differential-algebraic equations", "differential equations", 
      "Hamilton-Jacobi equations", "homogeneous differential equations", 
      "inhomogeneous differential equations", "Kamke", "Kovacic algorithm", 
      "linear differential equations", "Mellin transform methods", 
      "multivariate differential equations", 
      "nonlinear differential equations", "ODE", 
      "ordinary differential equations", "partial differential equations", 
      "PDE", "piecewise differential equations", "Riccati equations", 
      "solving differential equations", "symmetry reduction"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "DSolve[eqn, y, x] solves a differential equation for the function y, \
with independent variable x. DSolve[{eqn_1, eqn_2, ...}, {y_1, y_2, ...}, x] \
solves a list of differential equations. DSolve[eqn, y, {x_1, x_2, ...}] \
solves a partial differential equation. ", "synonyms" -> {}, "title" -> 
    "DSolve", "type" -> "Symbol", "uri" -> "ref/DSolve"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[13007, 431, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->528114744]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 221086, 6735}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3006, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3629, 93, 44, 1, 70, "ObjectName",
 CellID->20078],
Cell[3676, 96, 2305, 72, 70, "Usage",
 CellID->21349]
}, Open  ]],
Cell[CellGroupData[{
Cell[6018, 173, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6496, 190, 578, 22, 70, "Notes",
 CellID->8330],
Cell[7077, 214, 514, 18, 70, "Notes",
 CellID->14964],
Cell[7594, 234, 260, 8, 70, "Notes",
 CellID->21695],
Cell[7857, 244, 1150, 38, 70, "Notes",
 CellID->27772],
Cell[9010, 284, 824, 29, 70, "Notes",
 CellID->31646],
Cell[9837, 315, 583, 21, 70, "Notes",
 CellID->27803],
Cell[10423, 338, 230, 8, 70, "Notes",
 CellID->6698],
Cell[10656, 348, 446, 13, 70, "Notes",
 CellID->15577],
Cell[11105, 363, 444, 16, 70, "Notes",
 CellID->3047],
Cell[11552, 381, 356, 9, 70, "Notes",
 CellID->3551],
Cell[11911, 392, 334, 9, 70, "Notes",
 CellID->15684],
Cell[12248, 403, 342, 9, 70, "Notes",
 CellID->18205],
Cell[12593, 414, 377, 12, 70, "Notes",
 CellID->31144]
}, Closed]],
Cell[CellGroupData[{
Cell[13007, 431, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->528114744],
Cell[CellGroupData[{
Cell[13392, 445, 148, 5, 70, "ExampleSection",
 CellID->289695397],
Cell[13543, 452, 73, 1, 70, "ExampleText",
 CellID->301967363],
Cell[CellGroupData[{
Cell[13641, 457, 362, 12, 28, "Input",
 CellID->311052625],
Cell[14006, 471, 626, 22, 51, "Output",
 CellID->76930690]
}, Open  ]],
Cell[14647, 496, 70, 1, 70, "ExampleText",
 CellID->9978540],
Cell[CellGroupData[{
Cell[14742, 501, 489, 16, 28, "Input",
 CellID->20238327],
Cell[15234, 519, 722, 24, 51, "Output",
 CellID->485652530]
}, Open  ]],
Cell[15971, 546, 124, 3, 70, "ExampleDelimiter",
 CellID->81312734],
Cell[16098, 551, 192, 7, 70, "ExampleText",
 CellID->287581676],
Cell[CellGroupData[{
Cell[16315, 562, 464, 16, 70, "Input",
 CellID->65678545],
Cell[16782, 580, 809, 26, 51, "Output",
 CellID->1454950]
}, Open  ]],
Cell[17606, 609, 86, 1, 70, "ExampleText",
 CellID->444355483],
Cell[CellGroupData[{
Cell[17717, 614, 261, 10, 70, "Input",
 CellID->80106270],
Cell[17981, 626, 1089, 35, 51, "Output",
 CellID->250437346]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19119, 667, 217, 7, 70, "ExampleSection",
 CellID->17410],
Cell[CellGroupData[{
Cell[19361, 678, 273, 8, 70, "ExampleSubsection",
 CellID->535640651],
Cell[19637, 688, 64, 1, 70, "ExampleText",
 CellID->254895219],
Cell[CellGroupData[{
Cell[19726, 693, 409, 14, 70, "Input",
 CellID->347597487],
Cell[20138, 709, 329, 11, 36, "Output",
 CellID->177171641]
}, Open  ]],
Cell[20482, 723, 78, 1, 70, "ExampleText",
 CellID->867387677],
Cell[CellGroupData[{
Cell[20585, 728, 362, 12, 70, "Input",
 CellID->54083640],
Cell[20950, 742, 1080, 36, 62, "Output",
 CellID->194591347]
}, Open  ]],
Cell[22045, 781, 125, 3, 70, "ExampleDelimiter",
 CellID->448405997],
Cell[22173, 786, 75, 1, 70, "ExampleText",
 CellID->243498779],
Cell[CellGroupData[{
Cell[22273, 791, 507, 17, 70, "Input",
 CellID->37813044],
Cell[22783, 810, 1282, 39, 81, "Output",
 CellID->195217524]
}, Open  ]],
Cell[24080, 852, 62, 1, 70, "ExampleText",
 CellID->112305520],
Cell[CellGroupData[{
Cell[24167, 857, 260, 9, 70, "Input",
 CellID->549916451],
Cell[24430, 868, 3311, 58, 70, "Output",
 Evaluatable->False,
 CellID->455987102]
}, Open  ]],
Cell[27756, 929, 125, 3, 70, "ExampleDelimiter",
 CellID->755095530],
Cell[27884, 934, 90, 1, 70, "ExampleText",
 CellID->3409293],
Cell[CellGroupData[{
Cell[27999, 939, 412, 14, 70, "Input",
 CellID->82546440],
Cell[28414, 955, 681, 22, 39, "Output",
 CellID->317172572]
}, Open  ]],
Cell[29110, 980, 71, 1, 70, "ExampleText",
 CellID->234261175],
Cell[CellGroupData[{
Cell[29206, 985, 478, 16, 70, "Input",
 CellID->393431179],
Cell[29687, 1003, 887, 30, 62, "Output",
 CellID->438016509]
}, Open  ]],
Cell[30589, 1036, 143, 4, 70, "ExampleText",
 CellID->290604774],
Cell[CellGroupData[{
Cell[30757, 1044, 454, 15, 70, "Input",
 CellID->169767137],
Cell[31214, 1061, 777, 25, 53, "Output",
 CellID->335538908]
}, Open  ]],
Cell[32006, 1089, 59, 1, 70, "ExampleText",
 CellID->573637239],
Cell[CellGroupData[{
Cell[32090, 1094, 312, 11, 70, "Input",
 CellID->575192690],
Cell[32405, 1107, 553, 18, 36, "Output",
 CellID->417763476]
}, Open  ]],
Cell[32973, 1128, 61, 1, 70, "ExampleText",
 CellID->9615483],
Cell[CellGroupData[{
Cell[33059, 1133, 898, 28, 70, "Input",
 CellID->677040620],
Cell[33960, 1163, 669, 21, 36, "Output",
 CellID->166275757]
}, Open  ]],
Cell[34644, 1187, 82, 1, 70, "ExampleText",
 CellID->12722250],
Cell[CellGroupData[{
Cell[34751, 1192, 473, 17, 70, "Input",
 CellID->687172792],
Cell[35227, 1211, 812, 27, 51, "Output",
 CellID->106016930]
}, Open  ]],
Cell[CellGroupData[{
Cell[36076, 1243, 446, 16, 70, "Input",
 CellID->82989247],
Cell[36525, 1261, 1161, 37, 81, "Output",
 CellID->41045215]
}, Open  ]],
Cell[CellGroupData[{
Cell[37723, 1303, 364, 13, 70, "Input",
 CellID->877265069],
Cell[38090, 1318, 883, 28, 47, "Output",
 CellID->211861613]
}, Open  ]],
Cell[38988, 1349, 125, 3, 70, "ExampleDelimiter",
 CellID->533549112],
Cell[39116, 1354, 66, 1, 70, "ExampleText",
 CellID->404350673],
Cell[CellGroupData[{
Cell[39207, 1359, 373, 13, 70, "Input",
 CellID->163775661],
Cell[39583, 1374, 1047, 34, 56, "Output",
 CellID->72097679]
}, Open  ]],
Cell[40645, 1411, 88, 1, 70, "ExampleText",
 CellID->97193184],
Cell[CellGroupData[{
Cell[40758, 1416, 870, 31, 70, "Input",
 CellID->323824983],
Cell[41631, 1449, 3069, 99, 165, "Output",
 CellID->211686067]
}, Open  ]],
Cell[44715, 1551, 103, 2, 70, "ExampleText",
 CellID->249860454],
Cell[CellGroupData[{
Cell[44843, 1557, 887, 31, 70, "Input",
 CellID->596438192],
Cell[45733, 1590, 910, 29, 54, "Output",
 CellID->254708848]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46692, 1625, 254, 7, 70, "ExampleSubsection",
 CellID->325369133],
Cell[46949, 1634, 78, 1, 70, "ExampleText",
 CellID->416336744],
Cell[CellGroupData[{
Cell[47052, 1639, 586, 20, 70, "Input",
 CellID->17312088],
Cell[47641, 1661, 2586, 46, 70, "Output",
 Evaluatable->False,
 CellID->631957033]
}, Open  ]],
Cell[50242, 1710, 94, 1, 70, "ExampleText",
 CellID->5166198],
Cell[CellGroupData[{
Cell[50361, 1715, 383, 13, 70, "Input",
 CellID->236753084],
Cell[50747, 1730, 1280, 25, 70, "Output",
 Evaluatable->False,
 CellID->49491450]
}, Open  ]],
Cell[52042, 1758, 125, 3, 70, "ExampleDelimiter",
 CellID->787751176],
Cell[52170, 1763, 95, 1, 70, "ExampleText",
 CellID->387007818],
Cell[CellGroupData[{
Cell[52290, 1768, 767, 25, 70, "Input",
 CellID->69064100],
Cell[53060, 1795, 1579, 47, 68, "Output",
 CellID->314644953]
}, Open  ]],
Cell[CellGroupData[{
Cell[54676, 1847, 244, 8, 70, "Input",
 CellID->626931519],
Cell[54923, 1857, 2368, 43, 70, "Output",
 Evaluatable->False,
 CellID->523145496]
}, Open  ]],
Cell[57306, 1903, 125, 3, 70, "ExampleDelimiter",
 CellID->345805531],
Cell[57434, 1908, 97, 1, 70, "ExampleText",
 CellID->21183403],
Cell[CellGroupData[{
Cell[57556, 1913, 348, 11, 70, "Input",
 CellID->116462530],
Cell[57907, 1926, 860, 28, 51, "Output",
 CellID->330151804]
}, Open  ]],
Cell[58782, 1957, 89, 1, 70, "ExampleText",
 CellID->243153742],
Cell[CellGroupData[{
Cell[58896, 1962, 365, 12, 70, "Input",
 CellID->227135054],
Cell[59264, 1976, 607, 21, 39, "Output",
 CellID->83480956]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[59920, 2003, 252, 7, 70, "ExampleSubsection",
 CellID->91103246],
Cell[60175, 2012, 67, 1, 70, "ExampleText",
 CellID->87618354],
Cell[CellGroupData[{
Cell[60267, 2017, 357, 13, 70, "Input",
 CellID->6627813],
Cell[60627, 2032, 1579, 53, 81, "Output",
 CellID->25735881]
}, Open  ]],
Cell[62221, 2088, 125, 3, 70, "ExampleDelimiter",
 CellID->654545363],
Cell[62349, 2093, 130, 2, 70, "ExampleText",
 CellID->126035173],
Cell[CellGroupData[{
Cell[62504, 2099, 572, 21, 70, "Input",
 CellID->206271663],
Cell[63079, 2122, 672, 22, 64, "Output",
 CellID->364065574]
}, Open  ]],
Cell[63766, 2147, 125, 3, 70, "ExampleDelimiter",
 CellID->207276519],
Cell[63894, 2152, 64, 1, 70, "ExampleText",
 CellID->315539216],
Cell[CellGroupData[{
Cell[63983, 2157, 431, 16, 70, "Input",
 CellID->206687039],
Cell[64417, 2175, 771, 25, 51, "Output",
 CellID->81793051]
}, Open  ]],
Cell[65203, 2203, 125, 3, 70, "ExampleDelimiter",
 CellID->139521916],
Cell[65331, 2208, 210, 8, 70, "ExampleText",
 CellID->7713519],
Cell[CellGroupData[{
Cell[65566, 2220, 302, 11, 70, "Input",
 CellID->447421],
Cell[65871, 2233, 871, 29, 52, "Output",
 CellID->184981978]
}, Open  ]],
Cell[66757, 2265, 125, 3, 70, "ExampleDelimiter",
 CellID->132953522],
Cell[66885, 2270, 85, 1, 70, "ExampleText",
 CellID->745290227],
Cell[CellGroupData[{
Cell[66995, 2275, 714, 23, 70, "Input",
 CellID->394063199],
Cell[67712, 2300, 2572, 84, 149, "Output",
 CellID->276214095]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[70333, 2390, 254, 7, 70, "ExampleSubsection",
 CellID->121512680],
Cell[70590, 2399, 66, 1, 70, "ExampleText",
 CellID->156137180],
Cell[CellGroupData[{
Cell[70681, 2404, 552, 19, 70, "Input",
 CellID->345850836],
Cell[71236, 2425, 776, 25, 51, "Output",
 CellID->5613588]
}, Open  ]],
Cell[72027, 2453, 125, 3, 70, "ExampleDelimiter",
 CellID->339134918],
Cell[72155, 2458, 98, 1, 70, "ExampleText",
 CellID->448103595],
Cell[CellGroupData[{
Cell[72278, 2463, 1227, 38, 70, "Input",
 CellID->619550095],
Cell[73508, 2503, 3068, 94, 186, "Output",
 CellID->85820360]
}, Open  ]],
Cell[CellGroupData[{
Cell[76613, 2602, 397, 13, 70, "Input",
 CellID->30014467],
Cell[77013, 2617, 3108, 55, 70, "Output",
 Evaluatable->False,
 CellID->558292825]
}, Open  ]],
Cell[80136, 2675, 125, 3, 70, "ExampleDelimiter",
 CellID->120051939],
Cell[80264, 2680, 59, 1, 70, "ExampleText",
 CellID->54137464],
Cell[CellGroupData[{
Cell[80348, 2685, 615, 21, 70, "Input",
 CellID->2545688],
Cell[80966, 2708, 1815, 57, 82, "Output",
 CellID->71936314]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[82830, 2771, 252, 7, 70, "ExampleSubsection",
 CellID->39907188],
Cell[83085, 2780, 150, 3, 70, "ExampleText",
 CellID->78909139],
Cell[CellGroupData[{
Cell[83260, 2787, 697, 24, 70, "Input",
 CellID->429044150],
Cell[83960, 2813, 1376, 46, 81, "Output",
 CellID->223842905]
}, Open  ]],
Cell[85351, 2862, 125, 3, 70, "ExampleDelimiter",
 CellID->256197627],
Cell[85479, 2867, 74, 1, 70, "ExampleText",
 CellID->856714166],
Cell[CellGroupData[{
Cell[85578, 2872, 723, 24, 70, "Input",
 CellID->394137252],
Cell[86304, 2898, 1977, 58, 81, "Output",
 CellID->33698482]
}, Open  ]],
Cell[CellGroupData[{
Cell[88318, 2961, 479, 16, 70, "Input",
 CellID->239531080],
Cell[88800, 2979, 3839, 67, 70, "Output",
 Evaluatable->False,
 CellID->178378675]
}, Open  ]],
Cell[92654, 3049, 125, 3, 70, "ExampleDelimiter",
 CellID->154715252],
Cell[92782, 3054, 86, 1, 70, "ExampleText",
 CellID->373372613],
Cell[CellGroupData[{
Cell[92893, 3059, 830, 27, 70, "Input",
 CellID->236244804],
Cell[93726, 3088, 1837, 61, 91, "Output",
 CellID->157952475]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[95612, 3155, 250, 7, 70, "ExampleSubsection",
 CellID->15000432],
Cell[95865, 3164, 170, 4, 70, "ExampleText",
 CellID->41585100],
Cell[CellGroupData[{
Cell[96060, 3172, 548, 19, 70, "Input",
 CellID->39575588],
Cell[96611, 3193, 837, 28, 51, "Output",
 CellID->17901190]
}, Open  ]],
Cell[97463, 3224, 264, 9, 70, "ExampleText",
 CellID->352072776],
Cell[CellGroupData[{
Cell[97752, 3237, 466, 16, 70, "Input",
 CellID->3870441],
Cell[98221, 3255, 850, 30, 51, "Output",
 CellID->1011897]
}, Open  ]],
Cell[CellGroupData[{
Cell[99108, 3290, 295, 10, 70, "Input",
 CellID->1626814],
Cell[99406, 3302, 24319, 403, 70, "Output",
 Evaluatable->False,
 CellID->41645759]
}, Open  ]],
Cell[123740, 3708, 125, 3, 70, "ExampleDelimiter",
 CellID->353957082],
Cell[123868, 3713, 130, 4, 70, "ExampleText",
 CellID->678752222],
Cell[CellGroupData[{
Cell[124023, 3721, 660, 24, 70, "Input",
 CellID->321039854],
Cell[124686, 3747, 452, 8, 70, "Message",
 CellID->65067019],
Cell[125141, 3757, 857, 28, 51, "Output",
 CellID->372016616]
}, Open  ]],
Cell[126013, 3788, 125, 3, 70, "ExampleDelimiter",
 CellID->496268987],
Cell[126141, 3793, 116, 3, 70, "ExampleText",
 CellID->496493079],
Cell[CellGroupData[{
Cell[126282, 3800, 959, 31, 70, "Input",
 CellID->107988600],
Cell[127244, 3833, 424, 8, 70, "Message",
 CellID->296741009],
Cell[127671, 3843, 654, 22, 36, "Output",
 CellID->221586583]
}, Open  ]],
Cell[128340, 3868, 125, 3, 70, "ExampleDelimiter",
 CellID->695670436],
Cell[128468, 3873, 130, 4, 70, "ExampleText",
 CellID->214657157],
Cell[CellGroupData[{
Cell[128623, 3881, 709, 25, 70, "Input",
 CellID->54232694],
Cell[129335, 3908, 498, 18, 51, "Output",
 CellID->16488863]
}, Open  ]],
Cell[129848, 3929, 125, 3, 70, "ExampleDelimiter",
 CellID->137931841],
Cell[129976, 3934, 129, 4, 70, "ExampleText",
 CellID->65626117],
Cell[CellGroupData[{
Cell[130130, 3942, 661, 23, 70, "Input",
 CellID->610541269],
Cell[130794, 3967, 733, 25, 54, "Output",
 CellID->189256358]
}, Open  ]],
Cell[131542, 3995, 125, 3, 70, "ExampleDelimiter",
 CellID->210843504],
Cell[131670, 4000, 122, 3, 70, "ExampleText",
 CellID->795437752],
Cell[131795, 4005, 828, 27, 70, "Input",
 CellID->272206926],
Cell[CellGroupData[{
Cell[132648, 4036, 226, 7, 70, "Input",
 CellID->362215921],
Cell[132877, 4045, 424, 8, 70, "Message",
 CellID->404462447],
Cell[133304, 4055, 1081, 34, 56, "Output",
 CellID->767988259]
}, Open  ]],
Cell[CellGroupData[{
Cell[134422, 4094, 853, 27, 70, "Input",
 CellID->234366954],
Cell[135278, 4123, 2254, 41, 70, "Output",
 Evaluatable->False,
 CellID->186116266]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[137593, 4171, 239, 7, 70, "ExampleSection",
 CellID->13627],
Cell[137835, 4180, 95, 1, 70, "ExampleText",
 CellID->4991966],
Cell[CellGroupData[{
Cell[137955, 4185, 302, 11, 70, "Input",
 CellID->721588173],
Cell[138260, 4198, 610, 21, 36, "Output",
 CellID->266232945]
}, Open  ]],
Cell[138885, 4222, 66, 1, 70, "ExampleText",
 CellID->490851081],
Cell[CellGroupData[{
Cell[138976, 4227, 428, 15, 70, "Input",
 CellID->531383639],
Cell[139407, 4244, 545, 19, 36, "Output",
 CellID->11994561]
}, Open  ]],
Cell[139967, 4266, 66, 1, 70, "ExampleText",
 CellID->17015412],
Cell[CellGroupData[{
Cell[140058, 4271, 526, 18, 70, "Input",
 CellID->223255139],
Cell[140587, 4291, 512, 18, 36, "Output",
 CellID->331541010]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[141148, 4315, 218, 7, 70, "ExampleSection",
 CellID->21712],
Cell[CellGroupData[{
Cell[141391, 4326, 236, 7, 70, "ExampleSubsection",
 CellID->16787],
Cell[141630, 4335, 123, 2, 70, "ExampleText",
 CellID->518909729],
Cell[CellGroupData[{
Cell[141778, 4341, 340, 10, 70, "Input",
 CellID->167693793],
Cell[142121, 4353, 509, 17, 36, "Output",
 CellID->212842]
}, Open  ]],
Cell[142645, 4373, 69, 1, 70, "ExampleText",
 CellID->668299265],
Cell[CellGroupData[{
Cell[142739, 4378, 449, 14, 70, "Input",
 CellID->512825972],
Cell[143191, 4394, 500, 17, 36, "Output",
 CellID->168808596]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[143752, 4418, 222, 7, 70, "ExampleSection",
 CellID->2586],
Cell[143977, 4427, 78, 1, 70, "ExampleText",
 CellID->27123007],
Cell[CellGroupData[{
Cell[144080, 4432, 573, 19, 70, "Input",
 CellID->296987857],
Cell[144656, 4453, 548, 18, 53, "Output",
 CellID->394240195]
}, Open  ]],
Cell[145219, 4474, 90, 1, 70, "ExampleText",
 CellID->169469254],
Cell[CellGroupData[{
Cell[145334, 4479, 621, 20, 70, "Input",
 CellID->60958664],
Cell[145958, 4501, 3546, 62, 70, "Output",
 Evaluatable->False,
 CellID->26970766]
}, Open  ]],
Cell[149519, 4566, 125, 3, 70, "ExampleDelimiter",
 CellID->143714723],
Cell[149647, 4571, 76, 1, 70, "ExampleText",
 CellID->197082999],
Cell[CellGroupData[{
Cell[149748, 4576, 532, 18, 70, "Input",
 CellID->60898323],
Cell[150283, 4596, 542, 19, 51, "Output",
 CellID->607390813]
}, Open  ]],
Cell[CellGroupData[{
Cell[150862, 4620, 243, 8, 70, "Input",
 CellID->593887885],
Cell[151108, 4630, 3421, 60, 70, "Output",
 Evaluatable->False,
 CellID->398867391]
}, Open  ]],
Cell[154544, 4693, 125, 3, 70, "ExampleDelimiter",
 CellID->588500511],
Cell[154672, 4698, 85, 1, 70, "ExampleText",
 CellID->454854854],
Cell[CellGroupData[{
Cell[154782, 4703, 650, 22, 70, "Input",
 CellID->609335315],
Cell[155435, 4727, 923, 31, 61, "Output",
 CellID->6529411]
}, Open  ]],
Cell[CellGroupData[{
Cell[156395, 4763, 312, 9, 70, "Input",
 CellID->374510743],
Cell[156710, 4774, 2429, 44, 70, "Output",
 Evaluatable->False,
 CellID->244056792]
}, Open  ]],
Cell[159154, 4821, 125, 3, 70, "ExampleDelimiter",
 CellID->221789260],
Cell[159282, 4826, 89, 1, 70, "ExampleText",
 CellID->86766237],
Cell[159374, 4829, 889, 29, 70, "Input",
 CellID->72133840],
Cell[CellGroupData[{
Cell[160288, 4862, 915, 29, 70, "Input",
 CellID->193359593],
Cell[161206, 4893, 8577, 145, 70, "Output",
 Evaluatable->False,
 CellID->116561999]
}, Open  ]],
Cell[169798, 5041, 125, 3, 70, "ExampleDelimiter",
 CellID->255042640],
Cell[169926, 5046, 113, 3, 70, "ExampleText",
 CellID->742016881],
Cell[CellGroupData[{
Cell[170064, 5053, 468, 16, 70, "Input",
 CellID->156207104],
Cell[170535, 5071, 718, 22, 43, "Output",
 CellID->348680830]
}, Open  ]],
Cell[CellGroupData[{
Cell[171290, 5098, 295, 10, 70, "Input",
 CellID->346495992],
Cell[171588, 5110, 974, 34, 54, "Output",
 CellID->382340244]
}, Open  ]],
Cell[172577, 5147, 125, 3, 70, "ExampleDelimiter",
 CellID->152663548],
Cell[172705, 5152, 87, 1, 70, "ExampleText",
 CellID->225115348],
Cell[CellGroupData[{
Cell[172817, 5157, 1025, 34, 70, "Input",
 CellID->36516823],
Cell[173845, 5193, 498, 17, 39, "Output",
 CellID->590316055]
}, Open  ]],
Cell[174358, 5213, 125, 3, 70, "ExampleDelimiter",
 CellID->152078584],
Cell[174486, 5218, 94, 1, 70, "ExampleText",
 CellID->23973678],
Cell[CellGroupData[{
Cell[174605, 5223, 1217, 37, 70, "Input",
 Evaluatable->True,
 CellID->203060099],
Cell[175825, 5262, 250, 9, 51, "Output",
 CellID->29685719]
}, Open  ]],
Cell[CellGroupData[{
Cell[176112, 5276, 509, 16, 70, "Input",
 CellID->706507859],
Cell[176624, 5294, 163, 5, 36, "Output",
 CellID->523178789]
}, Open  ]],
Cell[CellGroupData[{
Cell[176824, 5304, 129, 4, 70, "Input",
 CellID->20549847],
Cell[176956, 5310, 162, 5, 36, "Output",
 CellID->52133453]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[177167, 5321, 233, 7, 70, "ExampleSection",
 CellID->32474],
Cell[177403, 5330, 119, 3, 70, "ExampleText",
 CellID->588875236],
Cell[CellGroupData[{
Cell[177547, 5337, 484, 17, 70, "Input",
 CellID->886221327],
Cell[178034, 5356, 646, 22, 51, "Output",
 CellID->11728215]
}, Open  ]],
Cell[CellGroupData[{
Cell[178717, 5383, 475, 17, 70, "Input",
 CellID->91162354],
Cell[179195, 5402, 247, 8, 36, "Output",
 CellID->261751209]
}, Open  ]],
Cell[179457, 5413, 125, 3, 70, "ExampleDelimiter",
 CellID->820648221],
Cell[179585, 5418, 224, 8, 70, "ExampleText",
 CellID->576300460],
Cell[CellGroupData[{
Cell[179834, 5430, 269, 9, 70, "Input",
 CellID->173516581],
Cell[180106, 5441, 510, 18, 51, "Output",
 CellID->64686769]
}, Open  ]],
Cell[CellGroupData[{
Cell[180653, 5464, 184, 6, 70, "Input",
 CellID->158306030],
Cell[180840, 5472, 256, 9, 51, "Output",
 CellID->7395133]
}, Open  ]],
Cell[181111, 5484, 125, 3, 70, "ExampleDelimiter",
 CellID->145464064],
Cell[181239, 5489, 214, 8, 70, "ExampleText",
 CellID->570222531],
Cell[CellGroupData[{
Cell[181478, 5501, 545, 18, 70, "Input",
 CellID->70859778],
Cell[182026, 5521, 358, 12, 36, "Output",
 CellID->280744878]
}, Open  ]],
Cell[CellGroupData[{
Cell[182421, 5538, 328, 11, 70, "Input",
 CellID->408304438],
Cell[182752, 5551, 350, 10, 36, "Output",
 CellID->379804217]
}, Open  ]],
Cell[CellGroupData[{
Cell[183139, 5566, 638, 21, 70, "Input",
 CellID->228784146],
Cell[183780, 5589, 491, 18, 36, "Output",
 CellID->2508220]
}, Open  ]],
Cell[CellGroupData[{
Cell[184308, 5612, 321, 11, 70, "Input",
 CellID->278041262],
Cell[184632, 5625, 346, 10, 36, "Output",
 CellID->162511186]
}, Open  ]],
Cell[184993, 5638, 125, 3, 70, "ExampleDelimiter",
 CellID->486467376],
Cell[185121, 5643, 213, 8, 70, "ExampleText",
 CellID->241997163],
Cell[CellGroupData[{
Cell[185359, 5655, 1160, 38, 70, "Input",
 CellID->26409797],
Cell[186522, 5695, 724, 24, 36, "Output",
 CellID->285033745]
}, Open  ]],
Cell[187261, 5722, 240, 8, 70, "ExampleText",
 CellID->485054696],
Cell[CellGroupData[{
Cell[187526, 5734, 444, 15, 70, "Input",
 CellID->280514401],
Cell[187973, 5751, 483, 16, 36, "Output",
 CellID->43100140]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[188505, 5773, 226, 7, 70, "ExampleSection",
 CellID->29957],
Cell[188734, 5782, 82, 1, 70, "ExampleText",
 CellID->133971055],
Cell[CellGroupData[{
Cell[188841, 5787, 241, 8, 70, "Input",
 CellID->149231047],
Cell[189085, 5797, 629, 21, 50, "Output",
 CellID->668911171]
}, Open  ]],
Cell[189729, 5821, 125, 3, 70, "ExampleDelimiter",
 CellID->385699740],
Cell[189857, 5826, 94, 1, 70, "ExampleText",
 CellID->22385],
Cell[CellGroupData[{
Cell[189976, 5831, 724, 25, 70, "Input",
 CellID->23247],
Cell[190703, 5858, 453, 8, 70, "Message",
 CellID->139981575],
Cell[191159, 5868, 452, 8, 70, "Message",
 CellID->26080280],
Cell[191614, 5878, 721, 25, 51, "Output",
 CellID->59494574]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[192384, 5909, 223, 7, 70, "ExampleSection",
 CellID->3520],
Cell[192610, 5918, 67, 1, 70, "ExampleText",
 CellID->295701773],
Cell[CellGroupData[{
Cell[192702, 5923, 891, 27, 70, "Input",
 CellID->316015371],
Cell[193596, 5952, 952, 32, 90, "Output",
 CellID->258315598]
}, Open  ]],
Cell[CellGroupData[{
Cell[194585, 5989, 406, 13, 70, "Input",
 CellID->623236321],
Cell[194994, 6004, 5482, 94, 70, "Output",
 Evaluatable->False,
 CellID->89597874]
}, Open  ]],
Cell[200491, 6101, 124, 3, 70, "ExampleDelimiter",
 CellID->61108469],
Cell[200618, 6106, 211, 7, 70, "ExampleText",
 CellID->273724135],
Cell[CellGroupData[{
Cell[200854, 6117, 12179, 368, 70, "Input",
 CellID->43300764],
Cell[213036, 6487, 2071, 61, 92, "Output",
 CellID->61490348]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[215168, 6555, 311, 9, 70, "SeeAlsoSection",
 CellID->21161],
Cell[215482, 6566, 931, 35, 70, "SeeAlso",
 CellID->23840]
}, Open  ]],
Cell[CellGroupData[{
Cell[216450, 6606, 314, 9, 70, "TutorialsSection",
 CellID->26931],
Cell[216767, 6617, 161, 3, 70, "Tutorials",
 CellID->24258],
Cell[216931, 6622, 154, 3, 70, "Tutorials",
 CellID->25716],
Cell[217088, 6627, 170, 3, 70, "Tutorials",
 CellID->332395997]
}, Open  ]],
Cell[CellGroupData[{
Cell[217295, 6635, 321, 9, 70, "RelatedLinksSection",
 CellID->18284],
Cell[217619, 6646, 252, 5, 70, "RelatedLinks",
 CellID->3269]
}, Open  ]],
Cell[CellGroupData[{
Cell[217908, 6656, 318, 9, 70, "MoreAboutSection",
 CellID->50439543],
Cell[218229, 6667, 128, 3, 70, "MoreAbout",
 CellID->881697988],
Cell[218360, 6672, 155, 3, 70, "MoreAbout",
 CellID->626998396],
Cell[218518, 6677, 143, 3, 70, "MoreAbout",
 CellID->260390562],
Cell[218664, 6682, 169, 3, 70, "MoreAbout",
 CellID->106963821],
Cell[218836, 6687, 179, 3, 70, "MoreAbout",
 CellID->529068518]
}, Open  ]],
Cell[219030, 6693, 50, 0, 70, "History"],
Cell[219083, 6695, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

