(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     99955,       2782]
NotebookOptionsPosition[     90613,       2461]
NotebookOutlinePosition[     92125,       2501]
CellTagsIndexPosition[     92039,       2496]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Graphics Directives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Three\[Hyphen]Dimensional Graphics Directives\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AbsoluteDashing" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteDashing"], "Dashed" :> 
          Documentation`HelpLookup["paclet:ref/Dashed"], "Dotted" :> 
          Documentation`HelpLookup["paclet:ref/Dotted"], "DotDashed" :> 
          Documentation`HelpLookup["paclet:ref/DotDashed"], "Thickness" :> 
          Documentation`HelpLookup["paclet:ref/Thickness"], "GrayLevel" :> 
          Documentation`HelpLookup["paclet:ref/GrayLevel"], "Hue" :> 
          Documentation`HelpLookup["paclet:ref/Hue"], "RGBColor" :> 
          Documentation`HelpLookup["paclet:ref/RGBColor"], "PlotStyle" :> 
          Documentation`HelpLookup["paclet:ref/PlotStyle"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AbsoluteDashing\"\>", 
       2->"\<\"Dashed\"\>", 3->"\<\"Dotted\"\>", 4->"\<\"DotDashed\"\>", 
       5->"\<\"Thickness\"\>", 6->"\<\"GrayLevel\"\>", 7->"\<\"Hue\"\>", 
       8->"\<\"RGBColor\"\>", 9->"\<\"PlotStyle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Directives" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsDirectives"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicGraphicsLanguage"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graphics Directives\"\>", 
       2->"\<\"Symbolic Graphics Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Dashing", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Dashing",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Dashing"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["r", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["r", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a two\[Hyphen]dimensional graphics directive which \
specifies that lines which follow are to be drawn dashed, with successive \
segments of lengths ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", \[Ellipsis] (repeated cyclically). The ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " are given as a fraction of the total width of the graph. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Dashing",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Dashing"], "[", 
       StyleBox["r", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]is equivalent to ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["Dashing",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Dashing"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["r", "TI"], ",", 
         StyleBox["r", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->8804]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " can be used in both two\[Hyphen] and three\[Hyphen]dimensional graphics, \
as well as in ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " specifications. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->19785],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dashing"], "[", 
   RowBox[{"{", "}"}], "]"}]], "InlineFormula"],
 " specifies that lines should be solid. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->20333],

Cell[TextData[{
 "The following symbolic forms for ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " can be used: ",
 Cell[BoxData[
  ButtonBox["Tiny",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tiny"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Small",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Small"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Medium",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Medium"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Large",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Large"]], "InlineFormula"],
 ". These specify absolute segment lengths independent of the total width of \
the graphic. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->6210372]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->21564],

Cell[TextData[{
 "If a segment has a length ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " specified as 0, it is drawn as a dot whose diameter is the thickness of \
the line. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->205667129]
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->41]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->177125650],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->133883356],

Cell["\<\
Specify the dashing of lines as successive segments with scaled lengths:\
\>", "ExampleText",
 CellID->243434727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Dashing", "[", 
       RowBox[{"{", 
        RowBox[{"r", ",", 
         RowBox[{"0.1", "-", "r"}]}], "}"}], "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.03", ",", "0.05", ",", "0.08"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110933490],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Dashing[{0.01, 0.09000000000000001}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[{0.03, 0.07}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[{0.05, 0.05}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[{0.08, 0.020000000000000004`}], LineBox[{{0, 0}, {2, 1}}]}]}], 
  "}"}]], "Output",
 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->380121874]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Dashing", "[", 
       RowBox[{"{", 
        RowBox[{"r", ",", 
         RowBox[{"0.1", "-", "r"}]}], "}"}], "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.03", ",", "0.05", ",", "0.08"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->483937840],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {Dashing[{0.01, 0.09000000000000001}], Line3DBox[{{0, 0, 0}, {2, 1, 1}}]},
    
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydV21vEkEQXu4OqLRIAZFKgtJGolZJm76paGutglbTD/4EUknaD0ZT+/c3
ujs7C3vPrtwhCXCz8+yzc7Mzs7MXk9ur6Y/J7fXlpPfpZvLr6vryd2/880YN
xQUhxHf1/bYh1PMf9UTfCyllNJ1OW+pfiK8siVg9qH89eI80n9VvrEZiRpjR
EY+WtBSbCXp6k7RnrL0T1J4y05qWEqM1gAbpj3n2XS0VZ3rmqBNmyJj6Aswr
1+J4hhERyLSOOGTGdga6Sug9RndyoXcY3QVtDDJ5RAzY7l4u9DZzb4E2AXmV
0E8Y3QdtEeQKoftsydNc6C3m3gZtCWSKCvGI0QPQlkFeIXSXLdnNhe4w915I
i7NFm9GHITvxPSgr9ODrDG6DbrDdbzO4yaOixtwnIf/i3tL+68H3udAVtuQj
aFdBpigjz+jBccBuLRp7E5bOA++uRcyGeDaLRoX54OxY+rVF2txKZYHm+IKz
oe7AzFS9OeeV1v6N92qLiThlNmPfqJ/EVquF1s5GHfmdnFdXL7cz2VAesi2Y
FbjHYTasGEdsG87Ox6YjRMfbvnSq+dIs+CYDZltndmQtEAt6GePhmcMSilO0
LcyKedYHVqyS+VgRtclsNd5bfBe0IsyK8dR1WEO7g6uEWasg35fp3HBXqP/X
CmhXC+xugR6rcJi1BnIdWB+AHqMwzLoe8I6tLpEudDrBpvbTDaxRUKLmDvOj
B/W72sqj/7Ff8Bm97g6y3/UBdgilhWy4D35szaNiA7DFhcw6piKHDfuFJHM2
ZpcWsY9YjqXMHj/At16KxXr8MfinAbgom3V+qjHn8QIOf76efpoxY66xHRB1
EkV3ZfUsfLzNLoznD2nLg2tV2TqspW4XE161Iv07iH48AW9jP+Ez2V4Ia+hI
msj0Z7i55I6P0z71dg0zfJxaQcMxa8/YP7FnA2ak7TTKXgQg0nY0pquPZPgW
9VI6fY/XO+CbHPDq5oaHu4mVc5e5zd0U+0D06gtGU9Wm3YoCvrdnfpdQGBW4
t33p1FTvjA2d0YnNZE+Lsx+yJXSropUj620H1WHO54TCcxBPJJvFO4TGd0cP
NtmCfUKj93F3bOdxROg62xvqbjRqSKgmaDH3V6Rz0zFnUaoS2ApLd5vZqR/z
6IhG2yzR/UGIwl9A6ABV\
\>"]], ",", 
   Graphics3DBox[
    {Dashing[{0.03, 0.07}], Line3DBox[{{0, 0, 0}, {2, 1, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJylWP1PE0EQ3d61le/yUT4kqSihEYgkqAgKSkAFJIYf/BMacgn8YDTIv3/R
m9m39O7dwF2QpO3Nzdu3szuzb3e5GNxeJT8Ht9eXg+dnN4PfV9eXf56f/rrJ
XsUN51ySfX4suez5b/akn4s0TaMkSRayX+e+w3Jx9pDon5tXz7fsO87MGAj/
9gRv22LJg2/muur9Auyo6T1C23Gxmt7rAXPq/wT/lFitOz84ZhVzgB5mSxze
/x4cXZNjRjHvgFnMRSmPEdkah3sD9HIt9Dbi65E3JntS0VvgXiFvk+wJRW8C
vVoLvY5I+uRtka3ZcH1wvyRvm+wxRa8CvVkLvQL0FnmfkK1V43qIe5u8I5bt
lsH9toLboxeB3q3g1ta6DiSSD1acPGqtT3l5UAvdAfrQmjHOlmZUXh7XQo8h
7q9WprludKzy8tSIWxaY52wCdW6MJqhEqd4LlZlpj+PWcVpWk2LrO23KWsv3
GSNJbey+heQcfU2YaP0e6gl69nH5ruXxABxBLdOw2my+B9a/js0N9YrXMOfK
ZuVW+2Dj6q/HxsqwCzauMh5xZLJZWiBTGZRm8lGsPDLRFElbBxmbqsXC630D
MU3jl7Wd589m5ToUNsnxHLGbClxir4pB97JcbU5SLxwNZ9HuhbPQA1sH88xZ
415sVm61gJnRAk7CX9DE2Yps2X1w5oN6W3M0/6geOkYG4lzcTytYGybrtDFX
QafKc9QjNK8Hu48ZI2v5yF+Qn9euzcp5aqXD85vUylot1ryWcl6aYAus+Vwu
Gb0/zK5VR3UmM8x5Y1W1mXhtivma3rNCVDONgGnnv5lCNtYwSs6WNG1kpjDd
w1bYD8X4SBxRJYe00lNLK88lyzIq4buIeA8Rjz/YrrwOuT730mLFjBbHFFoU
uEK1cTXlz1J2FGMYLa/6Q4xGGCOzz3ACY+09ovijexnC6YwV6hQtkJtCPi2l
PcF7j28aSnmMUTZLMXD9HYJrpJRnRu6D099Ewii7hAonpY6PjbyscDvg9LdC
ziZr7jbQ/k7cRgSMCrc1vQmW1J33uA1w9hTN+yTnug+0KnFpr+a9P9y/+ooe
R7yMegbOdUVxfBz/MtCvFM27Ke8z4Salt7TSzshKPwduvaX5c1FSPvWHM4au
W1OveAbF1PuW9lDawWm0wq33LWf/d6ANzGfFDM8P6V3lRmnurqRzICR6q3Gu
8Q9paUhl\
\>"]], ",", 
   Graphics3DBox[
    {Dashing[{0.05, 0.05}], Line3DBox[{{0, 0, 0}, {2, 1, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydV/1PE0EQ3d71APkqUApIrCCxEfEL0wAqsamggDGa+Cc05BL4wWiQf/+i
O3Nv2713Cz0g6XGz8/bt7MzszO33wfVF+mtwfXk+2Dy9Gvy5uDz/u3ny+8oO
xTVjTGp/P9eMff9n3/T3I8syE6dpmumfWZaH+WafiR1sqXRmnwKJ7f9oOHoC
acJjsE8wHGPOA9I2VduHdjao/QhtQ6T60Db7sqT6Q6ysUjLUg2NRMe/AsXwL
Zg+YVfJBRPK8ortYdZ20Mclzit4F96NK6FdAb5C2TrL6y+wAvUXahOQZRW/D
7k4ldAfcz0g7QfK0oreAfjGGO0dvwpLXY7g1Z0wb3LuknSR5StHrQHcroVeB
3g9pebZpwe73ITt5H2YJ3IeV0A2geyGPsUc1W8SST6HYcd4ohwweV0JPAn0S
sFsOYW5BAgu+BnbjakQp33UFmWViW3OgOSNkBAbOhhGDXymE6JTGIqo3NLtQ
SfIzPrLG1avZm+eXqsgEcRyCQyflYBPmC3qJIiLEB2DkOsARDLPyLLb3Ldj5
jLDNUZCdz/g+2Dhzq7GF6ouY6urR3L1YwzsbeWAjG3UayZ75SqxcJXY8lniY
WzdHK8zKmbsAD0g9qXvswUo8lp1RwhqZvKLI8EJW7tc3s/MOORptYuXo8Sph
Vp61Aps1sVP314B/FsesUQuuwRF3tT72fLNCGI5/mLlB8mJWzJKH92JdCPho
5OE8s10tbBOWT0N4hZAfC9ltF+HvFM7JMPMSyQkxJ94eMmTRbRUnvEoTEXT9
RCJcJw/J69q92F1+zINdu70lZTauvTmb3xn4q9N16zWyk7NPmGtWFMYyayhX
Rdyj8fhOLC5ST7FbzpG7sbnI7NBO+cREY1kT+95XA4ezMuR/Cb+MVaWnSg7P
VJznzi1nwgF8oXWm/G1R4HDZwjn22ZP91Yu9Q0SuDj3sIiGGWolBTr2Yx12o
D/ujsQz1zLuPeePuBogZdd+X7mz4+C8Yz/ECbxHiKPO+dwo2cA71sKvJgq/F
fkZ+8Pdf6ovNUFTdXkunmHfUBXd+L+Xo8il5A7RaqDVTvMcV3d0F9Z5Z6grc
E5+Ds61o7nnclztAP1H0NCxglLvVdRTFWl7jMTi3Fc32sf3rQL9UNHdf7lDu
nqZ3QOO+0hjVBKfe/Upe5xi674UDRXNEOT9mM+82V8oWrglT4NbbnFYc14nY
IkEdKcrP1xSXBxH1HqYekCKl9y1jav8BR5RrYA==\
\>"]], ",", 
   Graphics3DBox[
    {Dashing[{0.08, 0.020000000000000004`}], 
     Line3DBox[{{0, 0, 0}, {2, 1, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydl31PE0EQxrftFZCWUvoCBeVFhIQIRAwRiMSGQATFaOJHaEgT+MNokK9/
0Z3ZZ+nec0t7SsLB3D7729ndmdm9r4OH2+GPwcPdzWDj6n7w6/bu5vfG5c97
+6pSMsYM7e/3nrH//7H/6e+3NE1NZTgcpvpjOvIwX+yzal921fpknyJJ7N+y
/es0l7CmM28voH0WcO3TtLX1DK11sZLHUe0/LW3vgzX/RPsp+i+IVX1sxxj6
1pxA0xmjeQfNEs2+THZD1YfwaoVaK2TPqfoA7BeF1PtQr1NrQraumNmFJ5vU
WiW7puodsLcnsJ16G+qdCexZVb+CJ7vUOkW2xoHZAHu/kHoV6gNqnSZ7RtUr
UB/GWrm36cHvo0LqLtgnMT95HqYF9WlsxXhFTROe9Aup58A+i+0d760y5OVF
IfU01FeRWYrpPKjC3+vI3MXk3NF4N75mlG2x+UwK6ZF4frSnrwHuKYzQR8nn
MtWaeH8nlvEqZlSj6k/3y9UNlzO2M7QfwNBOTuwymqtJLtt4nRJ4dZyOqmwu
8ydSubpMgfoWVM6dOJUpvDMztAq7oHPMFqNz9s/CZ1+JeD2LUWMzFeo6qHK2
SNQ0CtG4LjRoBZYDaiwLOOPio3AEN+Fzm+ixFZtMZ1UL9Dmis469itN5hnLu
SqbKPiQBnXeTRytF6bzni/BdXjXT4DYwxm9Hjp7tge1rvdDr8L1LGo6GONlH
mD8PpoIVEZvvERyxcSrPsp5ZVxeRviKu/tcIrchsM7GNLBqXw3Fym+yEyFXs
KvvN9SdO75AdkmvB6tin4bUvNkI3HdWMBBEn0F6EVrKmUJ4m5WqeNXsgLkZW
KksMTxy+v/oIWwtmHV2hf6L63dqCjxyJBWijcxis12DNE6s8lhWujo/1A5qr
5kPu/C7nWB3s5RE8qWX99LU802chjVf5EzBmCjAaaXCrChhya/RVIsvIr0MN
DK5HfTBCtsw+T/C5zdX7DDMRaTkYOxsNSeT8vMDYfpRg3Nzuc6W5zIwWq7zn
GNXd0UTLUdqHwt3cJ9UI/yXpvn341OF6dRzOOXf34tkcQu2+Wf29mVX+O1Fj
OlehOS/2wFxWdfxWMrJ3oF5VNZ+HfBL7+9ZLVc/CXz55N8HcUhW38hhrUOvX
ZG5E9v85PNhTdQMesGoJzDeqalIr51Mbav0uzNUs3kN/lzhWNe9V7FYi7Peq
bsPf2N1RVPqF5yp/Jq99tT7Xdq5tFfT+qK0ydylq+g1lTOkvr0FgHQ==\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 83},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->133274237]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->225212368],

Cell["Set the dashing of edges of polygons:", "ExampleText",
 CellID->349071966],

Cell[BoxData[
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"Sqrt", "[", "3", "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->136970930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", 
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Dashing", "[", "r", "]"}], "]"}], ",", "p2"}], "}"}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.05", ",", "0.1"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->442974176],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[0.01]], 
     PolygonBox[
      NCache[{{-1, 0}, {0, 3^Rational[1, 2]}, {1, 0}}, {{-1, 0}, {
        0, 1.7320508075688772`}, {1, 0}}]]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[0.05]], 
     PolygonBox[
      NCache[{{-1, 0}, {0, 3^Rational[1, 2]}, {1, 0}}, {{-1, 0}, {
        0, 1.7320508075688772`}, {1, 0}}]]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[0.1]], 
     PolygonBox[
      NCache[{{-1, 0}, {0, 3^Rational[1, 2]}, {1, 0}}, {{-1, 0}, {
        0, 1.7320508075688772`}, {1, 0}}]]}]}], "}"}]], "Output",
 ImageSize->{341, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->73932194]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"Polygon", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "1", ",", "1"}], "}"}]}], "}"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->4417547],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", 
      RowBox[{"EdgeForm", "[", 
       RowBox[{"{", 
        RowBox[{"Dashing", "[", "r", "]"}], "}"}], "]"}], ",", "p3"}], "}"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.05", ",", "0.1"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->283162231],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[0.01]], 
     Polygon3DBox[{{1, 0, 0}, {0, 0, 1}, {1, 1, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJydmetu20YQhWmRlCjqalmypEixZcWKGzepk16SoFcgBZoCRdAn6A8jFZAA
LVqkAfrwhtDu7A7J1eHRxTZgUivOfHN2djncpd5cf3y3/PP64/u317PXH67/
fvf+7T+zn/76YL4KD4Ig+N38/zEKzOf/zCf7/2q1WgXhcrlc2b/gVA7BD+YY
my9ntvWdOVZMK9Sz+/ZrcxTH2COYoxJeqm1VWrGJdPPbv2jzXG0SOZvrQZTr
MB9OrM0XGqUurchxHCoE5RNr/0yZDWlVc3vnYpoV6nWlXk1zroqSOLdQxVNr
91jVtCwlpweRHEIXQS5hlLH1vtQoHfCOM29z3ux9obEPzTmBeJiLkfVYaLwj
iFf14plvN3g/UO++OafgEYHH0HrMVOHAnBvgEYPHsfU40RhDUFj3vG2GqPdE
443AO83mUj726D+w/mONLpzWnj5D9ZlCzEY2a3J/1uu+ZfRV931z7kBP5T6o
gpcdv6CnkeXe6dJo3K+78u5aT3GbRK4BoWcJLdV7BgSm3V5Xb+z9oaU1VM+5
OfeAEBINzquuXgvQ0CWEbRq6lpZ4tMEeGgovv9LJHXJMvBPw7hTeaxUO89kn
rDqw2gWrVKNOgcd65ucG54vH9r7FaiQzfwTkaAfZ1ssAs4pVZAz6hyQK5oOT
cdSlQtzboRkZTUrGnkklmmC1MocU7BqUhu0+ZGBMyNs08yg4olIXpkCuEs0p
peEIyP15n9B8najAMkq5bEC7DdlAzTWimZObZNac7tCM/UwouUX7UGjGzIhm
7Ccnt2neC/IJIW/TX6NROkTLGZBltYEZrFJal1jNCW2bTkfGO7gH7RCywaJI
X6TgJpR4BG2pcwtCET/5CqtVTKn2Di6qvBHImFb50v4F8hyi9YuztS3P+4e3
zCynDrK2UjbqvTX1EyDVydzn3rhivSCkbfXFUXHEJH+XQEpJDeHeqAl7l+7Q
FFFqD6iPgNog+jaTHhPvbc8LTpKK/uTOOnB3czdNuCeRynIFpOaOVQcnoT7s
6d2o+Kz6DKitm/K6cDPpqbG2O8Wb8oonpF5NknW5XLll7zgdn2qXSq8SOvbS
EXEVKXozSnqzfYZgdeBE1HhuDlKIcZ8jdJxznCjzfaEacaeCd/t+GoU4VyLu
HNK9dSXQ0xMl4goXqyRqrFB6DegTzSOuN+pE737Ekep9sONJg5XF0W1S9CGI
mThWMj4vhIwzvUwTnUMl4HNif0JfCVgBansRYuhRR7P/OdBwtYp3bJkcAbml
Ol8AGfcYOAoHO8mpkr8hZMxARtu8skuU9j3JAM7oMk3ykGgOXxE9+xFi1fAa
CLiHxJmvtLX1YKisXwhrQ66jfM2nvr+Cr93Zx7kONzRaPcQ5ewObH4M3hLBp
pOFO1jgF62dg4XsgycqBuSy89dkj0vJ3qZm1+fgjIUYlClsjeFlQgcL71uYn
56nusESUGPLcHdN+PrfD5FPKBJzfU0p6ugcJa6t9H576M8lHuiOuHsvU7M3X
CdATqvMcx6HEwzXhBNrt9TFRrr/3lrbPLd4QIsvtrXKN4pfNNK/+Z+Nc3AeO
ijv1ERmpSjYtNAVH2TjlMMfCvfkQ2vOMFfnpbG6gdVb+W/CC8kgONTrQxW8G
a308ZBnz2s/oKFdyJdk7ZvR7sTY+eBWjfrVyO2ZnPVAmWokWSYZLEfYdM/xk
5e/lcezw7YRkTqaBe4eXvedHq4Uy3RtmnG247p4p0/0OMFUmWk2Vec9a4V2G
1WGk1u63rtOV95uZZ3WkkefW6gyusv2NMC+s9RyuslWzWH9qrbPffNCqqgqu
rNXCuypzL1LGl/bqQ3OsmtZL2woO/gc7TfvG\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[0.05]], 
     Polygon3DBox[{{1, 0, 0}, {0, 0, 1}, {1, 1, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJytmW1PE0EQx5f2rs8t2FIKFNrypIgg+KwxamIivDBGv4AvCGmCiUajJn74
5qI7s3PX7f+GXtvYwLW7O/PbmdnnvQ+Xv6+H3y5/f7m6HFz8vPxx/eXq1+D8
+0+blV8yxgzt/9d1Y3//tb/4/20URSY/HA4j/pgBPcwb+wxt5g6nXtlnzqby
8u1yX0oqoFRAdIbYp2M8t08Ch1yDLR99/mOTJgc1brP0U6GVKFVw0j6zz1KP
hFmmVOik3J9G3mKdB0Kukk9EDRMJhxYLTkWuniF3LDY07HeB5Lwa0YJN1jgS
8rIXCa4g1rbfN2sfivatKdo21+RBe4O1D8TaJmgXQDsA7XXW3pO6V0G7OJP2
QOpes98VkgychlNCnQ7r9KRGIlS9WthjVWNLNMjf2mQt9g911lhnQyyjCNdT
OgXQabNOR+rZglhUZ9Rvi/426NfAy5xC4PibpljdA0JdIXC5aGOkW0xbEXsG
QGssRKuLbbv2uxmPniQi1EeKoMc90lTFin373ZqzZkcoC4F6+moGAXsDjylT
8ghtIOTtowRaK4lWnEuzwx7EEb3JIAVJbjzDeiz0K1BYy2NWaubqAw+9zOBN
meFwNGhkvwWwZzfUWnAuo3G6kUHG/lVnMuZiD6B5ZvO/kNGzjkIOM8g1lYxp
nI0xMovVgm2AKwb6QitIBXSqKrkMaVzJNHIVdCoqGevHFbYL5KJisyNj69WU
Nu8rNLSzrNLqCl2jYa0lldZQPNhRYuj3AWwDnbysSO0qdk4jF1XyCqT9XSEB
0f7FarkF6WDOWohHxTwBOYzUhPNGC9I5qAmjVhq5vQhl4TpWUGvgUT5eFSz6
QGHmhKnORilm20sTAYnlOO33kkwq7anuKCQcGzfbdAjaFWWc3hylu6oX41ad
zYsWtCB6VMmgMk/fHXlUzdP5qTg3YwQWpx4DqZqxlugkGocnQKJ9Lo5iXZvm
ivsLa9McdjqzNu40cAWZxY5AJTWAhDZlRVan1hUq7V0bykyWTasBjVo/4Plv
xEfqUXK6WIRMNMoqKDGctivXiTSbHAmxkhFLnYh7VyIeChFPPUTUWwQpFYjh
rsSwqYzJ2YhlIA7ExjWFqO6cU8QSEHtCxJ2XZuNsxK4Qe8pcPBuRpLoSO231
nHYS1InUUzfELpzNceXXif4+gDxeE9q9DBr23TSNvF0VGs4x89NwN7UscXwI
ZNwVote5THJNbH6mkHFmSNNwP1YR2kuFhmM4TcsDrSS0N0ALp9AmoxoT3i5E
oJxQIn8OBDxTYl8V2ni/Zz95seY9sPLzsoTzcU7OEnMIQ0KfQBvvVnRtnNfo
ovhiQZJreVqeklVQJN4pROzbjoJjifYadJH8WiGgrMQjGt83kuZTbt5E80Y9
HB1deoSJD66ZTM5mnGE7qbyi2NGHUgrLScomPaa4k9mCdEl83J/kGTfXLtkM
4jgW7te7kOazWeC03Wfb89OozPh2EFl8lxpfeo+8W5CQekcc0mH8TiB1/l5X
/CY/W7GfjmF/OP1GNL6V9vUOItejkzvciVrxzNuG9F2OiN8DkpEwMUKRi6fc
VUifiVVEyyU+NCP/Ln8s/UzyXcSxFOt6QuxEOr7TRqkHIuX22B0oxfuLE5F2
dyfrwkQpeg9Czetu3zahFM+a+8J0d8TYf7CvDkTavR2I3yhoPZoscO9lelCK
u5yOMN2bq74wUaolUnx7bHagVDudkAV3WHo3Gr+Xw1gQ85ilKBKTt8tlKT/j
8gNPm/pYIHU85tLb9lmwqRecMkv/AGwKFM8=\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[0.1]], 
     Polygon3DBox[{{1, 0, 0}, {0, 0, 1}, {1, 1, 1}}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy1mWlv2zgQhhUdtiM7vhJfiZ24Sdw06V0EPVAULVqg/bDXL9gPQWGgBXax
i7ZAf3wh7HKGI5l+NY4EIRUSyZTmfTi8hhT129W3T8u/r759/ng1//Dl6t9P
nz9+nb//54u5FWx5nrc0/3+NPfP7P/OL/98mSeIFy+Uy4cOb08l7Y86huXmL
U6/MmUwCc/XN1dq8lFRIqdCwzHXJh33+XFQ1SkXm+Y8/v9t8zNk7YpunwmhQ
qmZtXDNrdSlW2w4pM/R8KMGUNY8l95ifZhrPp1OUWYs3M9Y8lHxaoAlSjS3k
mua+aHZAE7Iw0+S83Gf1hXjZKVAHoJ6w+o7k3TPXRqqgqzl0xULy65vrNihC
UIxZcSJ5DEorboliaK4xF8YqrAg1I9Ycil+UauY0EWiGrJlKPlSy1rrG/Oma
ieRDtb+T09RAM2DNSPKZQhs1ndpIexbmagkDIcyAUOzBHuv74vUh6Ns5fR30
u6zvJs64dfQdpQTogSW0hXBcgoA+9JnQlDKcAKGrEBpA6DFhW3xYAKEHhEDx
YUVw76IvfYXEz8UeW7fLVNdbGrGn5jqoTgqzu1LfwwIWtlhnxcrFOeoBI+CF
Bbx2rpSJEs9odIxvhIyRi8bqpICM7b2jkjH2TBRyVOCzJWN+aEUxY7+AjIyW
SsY0RwSnzxb5j3XQVHNBq92CXGrmFJci45jrARlrqa6QY5WMVjiHThWfm5p3
OTJa4dw+K01We08upxX5UKkNJDdUclut9xX5qDK5o/aV68kt0NRVchfS9PwE
aA3xM1sl5ig9SNMoP1UopOYlFQUYa77Brz6kgw1Ed5z5QscYU1Nz4PG1ivTm
WFzDJ6ep/GrUyc0lAydNECRvF0QInUrrp7MbIZF/d26EhLHwNlDjAmqkUjH2
YamrUftAxRooR8XehdRzoDYL5hydijH64qdQ7ypUnC10UhdI9yqTcM64r5Bw
ngk3kh6BuqX4YdW4xiH148rqtqgpRnR+5NfPuormogfGmsKQr+RdjkKRnuqf
btUqUyjCXwglVijYwzZTzoTSLhhfGJEDlYiz6InQ8U0B6Tj6LR3XzEifS2vg
ih+jYzX6THzHFVc1Oq4CDoSOKxik47jR6XWgT4R+fM0sWZ5eA/pQ6h3nj3ol
egT0PfEd4x3Sse9ZurtaQb/7Qn4I5FqB375KTmlPFD9xtOQJVOqO1ONTxZ9i
Anm5Iz68VAjYL3VCLITXQIhKEehnQwjvgBBeQ1i/E0k9vFd82NAWa2vBQDz4
pYQHW6gX7R+gDTZqSUqbqr8rCvTWKtK1KHWxX0Hlb1bB3baU1O3R2Gp2tzbr
ybahNsRqWl/UjSn3nShjUErZD5WyJ/bNgnYu/dRMRM9UDpbCcrB30761D2V7
wE24KpvNbMvcIIbl1MWfI+BRudxVmKeqcbUwRQoPErc2b+d88nPUOHH3P2E9
F4ozfMzAwzwL3wsnkB5IG47Sul/bcbdjBd+hx0rdD9JyZS9QVpvuY6JmYU5U
Ma20BGs54nvqANLn4jVFKT/Lq5esds5d68usb6zysbWzC5b4HvpMiNZ6T1Jo
Rd9UgsxqCE/xbZ6+k1BF2xXVCJ7irgJ97aBqtbsbY/EArc7Fyu6V7cNT3HU4
FQ/sHu2BMNFqLky7jz+Dp7jKPBCm/cpyCE9xNTkStv3adCQeaHvpZMW7xvyV
I7cihZojD87Y+jhxvpU5VrEw77EV1QT3+iQ9qG80xOYR2yyE5M5avuR1yRZn
knrBKW/rf2MR3lk=\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[4]=",
 CellID->239741655]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->128675677],

Cell[TextData[{
 "Set the dashings of lines in plots using ",
 Cell[BoxData[
  ButtonBox["PlotStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->379411272],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", " ", 
     RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", " ", "0", ",", " ", 
     RowBox[{"2", " ", "\[Pi]"}]}], "}"}], ",", " ", "\n", " ", 
   RowBox[{"PlotStyle", " ", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Dashing", "[", "Tiny", "]"}], ",", " ", 
      RowBox[{"Dashing", "[", "Large", "]"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32617465],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->651952030]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6262659],

Cell["Set the dashing of the frame:", "ExampleText",
 CellID->3660616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{"x", ",", 
     RowBox[{"{", "4", "}"}], ",", 
     RowBox[{"{", "7", "}"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "All"}], ",", 
   RowBox[{"FrameStyle", "\[Rule]", 
    RowBox[{"Dashing", "[", "Tiny", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->343545544],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmMEOgjAMhjsGzhg18eaRdzHRkw+xEBM4EAV5/9mNicXEREMQlJKs7X52
6P6N78BRV+kp11WW6PhQ6kuaJdd4fy5RkgIAChy7LWBtsHKjMAZzHSG0inuw
kDZFjVKLrBI1sAVQBzc2yoeLqz7mQJUcg3B9RL6jwOdFz/OZ68XF1r1ZflFR
Linf0fzJLTkGvXVaoX+z/jCr5pTH4PcwN23Ib4t+4/YMX1AipOp9BxNcSzwM
3nSVycnkZHIyOQ3ZwQTXMjmZnN11JieTc2prmZxMzu46k/PPyDmWf4W/pAri
H4gbBPr1YA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{113, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55388467]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->88],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Dashing Specifications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->68059140],

Cell[TextData[{
 "No dashing: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->20333]
}], "ExampleText",
 CellID->150207859],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Dashing", "[", 
     RowBox[{"{", "}"}], "]"}], ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12189373],

Cell[BoxData[
 GraphicsBox[
  {Dashing[{}], LineBox[{{0, 0}, {2, 1}}]}]], "Output",
 ImageSize->{184, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->721328326]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dashing"], "[", 
   StyleBox["r", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Dashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dashing"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["r", "TI"], ",", 
     StyleBox["r", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->982634541],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Dashing", "[", "r", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.03", ",", "0.05", ",", "0.08"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22421334],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Dashing[0.01], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[0.03], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[0.05], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[0.08], LineBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",
 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->16589604]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60872454],

Cell["Symbolic values for predefined absolute dashings:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->6210372],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Dashing", "[", "r", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"Tiny", ",", "Small", ",", "Medium", ",", "Large"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->493657934],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Dashing[Tiny], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[Small], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[Medium], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[Large], LineBox[{{0, 0}, {2, 1}}]}]}], "}"}]], "Output",
 ImageSize->{452, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->22282697]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->232071657],

Cell["Specify multiple cyclic segments:", "ExampleText",
 CellID->204743699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Dashing", "[", 
     RowBox[{"{", 
      RowBox[{"0.1", ",", "0.02", ",", "0.05"}], "}"}], "]"}], ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->218225009],

Cell[BoxData[
 GraphicsBox[
  {Dashing[{0.1, 0.02, 0.05}], LineBox[{{0, 0}, {2, 1}}]}]], "Output",
 ImageSize->{184, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->620300]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Primitives Affected",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->877725465],

Cell["Specify the dashing of the shaft of an arrow:", "ExampleText",
 CellID->81504682],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Dashing", "[", "0.02", "]"}], ",", 
    RowBox[{"Arrow", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4953682],

Cell[BoxData[
 GraphicsBox[
  {Dashing[0.02], ArrowBox[{{0, 0}, {2, 1}}]}]], "Output",
 ImageSize->{184, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->493701189]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->121880674],

Cell[TextData[{
 "Specify the dashing of edges of primitives using ",
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->96904699],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", 
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Dashing", "[", "r", "]"}], "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.05", ",", "0.1"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->354061769],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[0.01]], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[0.05]], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[0.1]], DiskBox[{0, 0}]}]}], 
  "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->37972941]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", 
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Dashing", "[", "r", "]"}], "]"}], ",", 
      RowBox[{"Rectangle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.05", ",", "0.1"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->571115787],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[0.01]], RectangleBox[{0, 0}]}], 
   ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[0.05]], RectangleBox[{0, 0}]}], 
   ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[0.1]], RectangleBox[{0, 0}]}]}], 
  "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->323992032]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->812456635],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Pink", ",", 
       RowBox[{"EdgeForm", "[", 
        RowBox[{"Dashing", "[", "r", "]"}], "]"}], ",", 
       RowBox[{"Cylinder", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.05", ",", "0.1"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26084294],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], Thickness[Large], EdgeForm[Dashing[0.01]], 
     CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], Thickness[Large], EdgeForm[Dashing[0.05]], 
     CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], Thickness[Large], EdgeForm[Dashing[0.1]], 
     CylinderBox[{{0, 0, -1}, {0, 0, 1}}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->315092132]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Pink", ",", 
       RowBox[{"EdgeForm", "[", 
        RowBox[{"Dashing", "[", "r", "]"}], "]"}], ",", 
       RowBox[{"Cuboid", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Boxed", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.05", ",", "0.1"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->230811004],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[0.01]], CuboidBox[{0, 0, 0}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJy9mPtOE0EUxpfdbu/3KxQolYtIRTCAUETQP1DjBYmP0IAJJBoM8iq+gO/Z
6Dkzh+3sl6kdMJHQ027P7/vmm93udrYng5uLL98GN5dng+7b68H3i8uzH903
V9f0VjDled45Pb5Oe/T6N71Sj/PhcEgNo76iGlDrgdo65MqbV40jqp7Pz7w9
VH/egqIODIqBBBWfNruq2xfHVKQ97bOX1u5SZTZrdBnQ3R3p5pXtqOt5HdXf
kn4x3qd/3X8KyUpcQpPjJPOKXZecNWJC7hjzbCuiJ6M1IWtAZU4RazBey+I1
o8gVINvgmQDVtFItSYIO0SkidK6uJF8ADxy5pegOjLxIJU2kzjUnIyyDVxK8
moqekZEfAp0CuqHolnj3iM4SofPUxeMxeKTBo67oGqR/QiVHpM5Tge7mBE/l
5hUkwTbQGaCris7JLHaB5hnpjFlIYSNN34qTKgeqspMqT0XnzgC5R6UEnqWx
pOlZoFKxkn2LZ9HJs0il7ESyv1tOTJJ3UpWp6Mxpy+xMskKlcEeSR38O3Srk
zDh5uqn2J6jSTqoaFfVJozM7TuJc7kaaSVJRkhdA1qlknDzj5OE/+ZjZkmNV
rYkj2n3cyCSMeOCsOgKyQSXt5HkfMgQSj2ADcob/XZWUfc6NppNvX2j/18XP
v+1zu/qZqJMWdcqq2JJVU44UzYhKAMXfaLzQKYJvdaxiXZLUQFGBeSSs6rXb
fXYvdbQuIDUbtMGl7OSyLHumA2q8vtvVCzKDJVK7pZ4TxSqMx99R+gwLQNEW
Rc9Z0RLFBigKkDCwqmui3gZ13kldFvUeqHGFYVcXRH1Aare0WVG8hPFwfaXV
PqhTcvSPQc2rqNCqSMKn7rVl3DBKGki6D0ClY/58zp0CgatcP55GRv9MZTRi
ArroietsP36tGKPClb4fXfN4z3ECu28afD+BL9+F6HMkM4EMIjIH5AmQfkTm
gfxoIc3MU0pVkFkp39g9n3YtgSsf18DqVLaQ8TkxVQXqvUlFe7IG1DsrVZfs
Iw8zTxM8jg2KqlytWkC9BEp/I88Atc97wZN9ru9nje6OdPUKfFZSboKzvoub
B+0joPR9ZAeoJaCUi/6FwKBmbyl+9vT9rvwWYVBNoFYVtSipq/Qufyx66t1l
0Ga5hJFW0myo5xVgQxhnR1FqtJGD9NRBjv2S4k39AZMOOrg=\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[0.05]], CuboidBox[{0, 0, 0}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzFmIlOE1EUhodO12lhug1LLZSyNYJAiMomoMYEjYYgj9AQEkg0GORVfAHf
s9Fzzj1Mb//cqeOSSNLTzj3ff5Y7272c9e+vrz73728u+4tv7/pfrm8uvy6e
3t7RkD/hed4VfT7NevT7B/2Sz9VgMCCHZV+R9cm1JEfHepS5jU4y9N2V0SOy
eRrx2DU43+fBRfEckGWuYHnJqndXo5VsLQHG+0y1FfL6PCyE/HnzQuyw1VEO
MUUmC2RbyG2NVYNMGTILQmwq0XAQdrxHQq9r5RHQWGdL6Mdk51KRqxq3BTR2
NSf0stY8D3SOjKlz6WGGiGDIRdpxZ0W1AKouqPKgmhFVW6tZJbpEhKlxTjvq
/SLGtNCcfwPIApCRkBHUmE5V12q2gC4C3RS6qh3tAM3dmXpDqMJF2nEboipr
3F2gA6DrQgeQA1VlMs1EcirRu6deO2M1Jg/Heg+ghkkgw0SSY9bGeu04U0KW
HJXbqhBUk6lUVTJhatKOX0mlqoGqLKoiqHgGGqnJJpBBXMkLyF4nU4njHDm8
dpxSIom1FX+TLEAXh6DijoL/Sto1F5wqntvpRPJkrPc4dcY/JyMypRTevKOv
f03iVYFd5P9ClQMVdzqTGP9E1yh4boYEXw3s8L9ff8PsxTjjvlL5sdSuZguA
wrsi5+xkW9UhqaM4bhaoJ7y+ocM6Uc1Eal1jzRDlzo6KNe2wBbXjc8+tXlb1
gkNdcCq6WuESKMIRRUfj9oDCd0Q2VrRVsQEKfDsNFWadxbjnsd0ig2+TIT2t
8Z8S5a7Ch06resb2VJF3UuHD1U8UV3EA9ZcTlYFW9BIUQaKioIo3oCjFigwo
smLMsZmpU4fWngt/GCcbx9G8H0CLKy8/rpoHz4nGVZE/WqXO2QUZdx1ZID9C
BbgG9kfvUFWdg4rXr7n4mXvhiGm8/JTEjNkRb0b7tAncHUi3Zl1g1XRGBqs3
ZMVB4h7CkLzC4uzujLziY62cR61NZ9SrPfhGOhvoKtvO/t6m4hluJFJ2BRFQ
75wU70Diq5K+h08r3lG85v48XbGZvZMVcR90Zs3ZAorveZ4Es3Ztg5efG2bv
NA+enurM/q5Ddk3yySE3oXtZ3vN2yMNXw4qMdCHSrHp74l0Gb1W9m+JdAW9F
Z2BbvKvgzcEMPBeK82S0ejltI/8X8CZ+ArUhLAo=\
\>"]], ",", 
   Graphics3DBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[0.1]], CuboidBox[{0, 0, 0}]},
    Boxed->False,
    ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzFmPtOE1EQxpfdtkvvC7SUa2lBLioEBOWqlT/wLoKP0BASSDQY5FV8Ad+z
0Zk50+X0y1lcTYgJnXbn+31z5uxuu+dw3L25OP/avbk867beXHe/XVyefW+9
vrqmVDDked45vb5MePT5F32S13mv1yPBiocUA5Lm5ahD0acj/6re4fe2ZA+U
yVDW4w+9k10WWqLuqSe0VIqqbnOULB95Xp6pjNYQcE6Up1qlNKjTn9E3Va+w
nrV1rtoUZl37jOw+CfApGGJNq4w5iH6XDE4L/Ujr1YEOgJ4SekVrTxKdI2JG
skuandas7ZsUYqF/hojggWZhtAy4JsTV1rotoLMUTD/N/pV1EHa9htAzWm8R
aO7Z9DmlxLKDsOuNC93Q0R8CHQJdF7qutVeBHqZg+qvBWXKRdl3hvUjrPgE6
D/SY0BWlt1LRRZ3hM6ALQI8KXYD+t8FVpFBLTdr1R1K5SuCKUrnKFNL1X4b6
VXHlwbUDrgq4Kk7XLoUoNTkCZDnufx9Gr1K47fPAodp1Sokk9lZMJLk3088w
dL7nIO2ahVSuUXDl79E1Bq7hVK4ahXRz+TvS7iQUVwguvPq39f8HWaeQvzcy
ByTeh8nkcwoNOJ+5ePTOH9W7rksuHvHlPZA4C5yvuT+zQL5ITfJvCy9M/J8X
P+7qKOt081OCD0Nw47fI7d5Ud+Gf3BsyR7Z6HscyVMHvv7vKGoUaOd3zzQAd
P/fpnYdrqDN00ks6v2noLEp0LKijmdrRUsc8OKqJjiact0VwVhKdvNpbBbqc
SI9fmdX2BjhKsSMAR03nsukYI+d0RHr3bjvGyMVdVbXuAVDFgbpMHQKBq54g
potEvwIaV1S3dKjn4i04cH0XOGfJM3yfyulTZPqU6ORuJEsEl/xMwV0rA+Qp
dMArZPhOJZDZmAyB/OQg7U783sCTMsGFewnjKoDrGFxB3BWvgU5A9WO1nKDK
+TErNmuUjxwGdnqGqwL3IYEbAQ6vu6FG76LiK8grer7reCx+N9k6eN/FXnP2
hoQaB+qIArdrxp8AtaOqecZMgrpHgQ/NGpF3oTuUMfsN3qFtqNvsmmbBvayq
2f/NgdpW1eyEW6Ca31GRZKtudv79XWZD+1qR7AJ4I638WNQHoBZVXRd1USuG
mt2S7DLHjP7MStyX/Eq/lp5xkzX/ufCGfgNT3Sk+\
\>"]]}], "}"}]], "Output",
 ImageSize->{341, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->698286995]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19923],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Dashed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashed"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Dotted",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dotted"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DotDashed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DotDashed"]], "InlineFormula"],
 " to specify predefined absolute dashings:"
}], "ExampleText",
 CellID->177864763],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Dashed", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Dotted", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"DotDashed", ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126769941],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Dashing[{Small, Small}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[{0, Small}], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Dashing[{0, Small, Small, Small}], LineBox[{{0, 0}, {2, 1}}]}]}], 
  "}"}]], "Output",
 ImageSize->{341, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->71511954]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->494755710],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " defines the length of a segment as a fraction of the total width of the \
graphic:"
}], "ExampleText",
 CellID->45340192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Thick", ",", 
     RowBox[{"Dashing", "[", 
      RowBox[{"{", 
       RowBox[{"0.05", ",", "0.1"}], "}"}], "]"}], ",", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32584783],

Cell[BoxData[
 GraphicsBox[
  {Thickness[Large], Dashing[{0.05, 0.1}], LineBox[{{-1, 0}, {1, 0}}]},
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->814706423]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dashing"]], "InlineFormula"],
 " depends on the image size:"
}], "ExampleText",
 CellID->85601104],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Dashing", "[", ".05", "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "100", ",", "150"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->146120593],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Dashing[0.05], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->50], ",", 
   GraphicsBox[
    {Dashing[0.05], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->100], ",", 
   GraphicsBox[
    {Dashing[0.05], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->150]}], "}"}]], "Output",
 ImageSize->{341, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->331473684]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->512293227],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteDashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteDashing"]], "InlineFormula"],
 " defines the length of a segment in units of printer's points:"
}], "ExampleText",
 CellID->688634888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Thickness", "[", ".02", "]"}], ",", 
    RowBox[{"AbsoluteDashing", "[", 
     RowBox[{"{", "15", "}"}], "]"}], ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<15 points\>\"", ",", "Black", ",", 
        RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0.5", ",", "0.1"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->183044747],

Cell[BoxData[
 GraphicsBox[
  {Thickness[0.02], AbsoluteDashing[{15}], LineBox[{{0, 0}, {1, 0}}], 
   InsetBox[
    StyleBox["\<\"15 points\"\>",
     StripOnInput->False,
     FrontFaceColor->GrayLevel[0],
     BackFaceColor->GrayLevel[0],
     GraphicsColor->GrayLevel[0],
     FontSize->15,
     FontColor->GrayLevel[0]], {0.5, 0.1}]}]], "Output",
 ImageSize->{184, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4536051]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteDashing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteDashing"]], "InlineFormula"],
 " is independent of the image size:"
}], "ExampleText",
 CellID->339440019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"AbsoluteDashing", "[", "10", "]"}], ",", 
       RowBox[{"Line", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "s"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "100", ",", "150"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->106096680],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {AbsoluteDashing[10], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->50], ",", 
   GraphicsBox[
    {AbsoluteDashing[10], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->100], ",", 
   GraphicsBox[
    {AbsoluteDashing[10], LineBox[{{0, 0}, {2, 1}}]},
    ImageSize->150]}], "}"}]], "Output",
 ImageSize->{341, 80},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->16185156]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->537268196],

Cell[TextData[{
 "The thickness of segments can be specified by ",
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->139643274],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Thickness", "[", "r", "]"}], ",", 
      RowBox[{"Dashing", "[", "Medium", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], "]"}], ",",
    
   RowBox[{"{", 
    RowBox[{"r", ",", 
     RowBox[{"{", 
      RowBox[{"0.01", ",", "0.03", ",", "0.05"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->448894772],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {Thickness[0.01], Dashing[Medium], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[0.03], Dashing[Medium], LineBox[{{0, 0}, {2, 1}}]}], ",", 
   GraphicsBox[
    {Thickness[0.05], Dashing[Medium], LineBox[{{0, 0}, {2, 1}}]}]}], 
  "}"}]], "Output",
 ImageSize->{341, 55},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->355560985]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->577181293],

Cell[TextData[{
 "A segment with length 0 specifies a dot of the size defined by ",
 Cell[BoxData[
  ButtonBox["Thickness",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Thickness"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->205667129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Thickness", "[", ".05", "]"}], ",", 
    RowBox[{"Dashing", "[", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0.1"}], "}"}], "]"}], ",", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}]}], "}"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->609336778],

Cell[BoxData[
 GraphicsBox[
  {Thickness[0.05], Dashing[{0, 0.1}], LineBox[{{0, 0}, {2, 1}}]}]], "Output",\

 ImageSize->{184, 95},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->248269621]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5876],

Cell["Randomly dashed circles:", "ExampleText",
 CellID->122308981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
      RowBox[{"Dashing", "[", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0.07"}], "}"}], "]"}], "]"}], ",", 
      RowBox[{"Circle", "[", 
       RowBox[{
        RowBox[{"RandomReal", "[", 
         RowBox[{"1", ",", 
          RowBox[{"{", "2", "}"}]}], "]"}], ",", 
        RowBox[{"RandomReal", "[", "]"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "20", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->928315980],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.4322736944900536], Dashing[0.03481843988428958], 
    CircleBox[{0.36990130173580393`, 0.843878926427017}, 
     0.8543243977369896]}, 
   {Hue[0.8963160504489185], Dashing[0.003017180923502332], 
    CircleBox[{0.6930834902409657, 0.21372105626196425`}, 
     0.8983460284421627]}, 
   {Hue[0.14236163566602555`], Dashing[0.05714103485961763], 
    CircleBox[{0.78233408172079, 0.9441919900550055}, 0.6445873675435612]}, 
   {Hue[0.8002044120735055], Dashing[0.00724118120224993], 
    CircleBox[{0.12078471210166475`, 0.7058829124015251}, 
     0.10507026749054926`]}, 
   {Hue[0.5568950588194013], Dashing[0.056173409792249045`], 
    CircleBox[{0.8568304372441529, 0.44719714048702075`}, 
     0.7137504363684328]}, 
   {Hue[0.39894020228963467`], Dashing[0.06370052749978941], 
    CircleBox[{0.5486200877550325, 0.9713654554362536}, 
     0.9719589340814323]}, 
   {Hue[0.22061675465786568`], Dashing[0.0546268783895929], 
    CircleBox[{0.9279302130096849, 0.8937073701898732}, 
     0.23646372650175773`]}, 
   {Hue[0.11629056244267533`], Dashing[0.05437631845327012], 
    CircleBox[{0.22169600469538286`, 0.46174326791121256`}, 
     0.30775458468183925`]}, 
   {Hue[0.5607851324988671], Dashing[0.023639381482995412`], 
    CircleBox[{0.682260085601484, 0.5306159026771984}, 0.9419849927906718]}, 
   {Hue[0.6029903587185452], Dashing[0.019048287672260855`], 
    CircleBox[{0.6953163297290692, 0.018511596417913445`}, 
     0.22338960316594214`]}, 
   {Hue[0.6448225069128917], Dashing[0.023487315175383695`], 
    CircleBox[{0.9563694225117023, 0.5573971643095226}, 
     0.7968234575064932]}, 
   {Hue[0.9169332871582438], Dashing[0.06631731657151323], 
    CircleBox[{0.41467074702752527`, 0.1408107930171798}, 
     0.5697537649556319]}, 
   {Hue[0.2689730115479334], Dashing[0.022458175853253937`], 
    CircleBox[{0.9136566988982031, 0.22247456345195848`}, 
     0.6213274080572697]}, 
   {Hue[0.0009315404885466005], Dashing[0.0013918208720068727`], 
    CircleBox[{0.6636387438670555, 0.15056493240833224`}, 
     0.4017007917294584]}, 
   {Hue[0.07904604413219785], Dashing[0.05610756759746672], 
    CircleBox[{0.8938698035238835, 0.4045181149035513}, 
     0.5334679672720612]}, 
   {Hue[0.03214434016052281], Dashing[0.009293025445077315], 
    CircleBox[{0.4482743619939884, 0.9018611040918176}, 
     0.8766541323443866]}, 
   {Hue[0.2757476250891029], Dashing[0.010451080045558964`], 
    CircleBox[{0.6820626248753208, 0.1699012182398003}, 
     0.043545528470187334`]}, 
   {Hue[0.14352981907591844`], Dashing[0.00029198431621542344`], 
    CircleBox[{0.5950646102251058, 0.5020771827742725}, 
     0.18761068258263958`]}, 
   {Hue[0.7746230680514554], Dashing[0.014286238092573992`], 
    CircleBox[{0.24418356920811735`, 0.10689738109373725`}, 
     0.995097084903326]}, 
   {Hue[0.910486789372938], Dashing[0.04730733485129201], 
    CircleBox[{0.11369133180912394`, 0.2969413757085697}, 
     0.30534456978732294`]}}]], "Output",
 ImageSize->{184, 202},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88416423]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->65550596],

Cell["A curve with random dash pattern:", "ExampleText",
 CellID->43846749],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"t", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "t", "]"}], ",", " ", 
      RowBox[{"Sin", "[", "t", "]"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "50"}], "}"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Thick", ",", 
      RowBox[{"Dashing", "[", 
       RowBox[{"RandomReal", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0.05"}], "}"}], ",", "100"}], "]"}], "]"}]}], 
     "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43805635],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->215376190]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16333],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteDashing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteDashing"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dashed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dashed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dotted",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dotted"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DotDashed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DotDashed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Thickness",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Thickness"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GrayLevel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GrayLevel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RGBColor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RGBColor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotStyle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16972]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10504],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsDirectives"]], "Tutorials",
 CellID->815154705]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->844553832],

Cell[TextData[ButtonBox["Graphics Directives",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsDirectives"]], "MoreAbout",
 CellID->464173306],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->51075215]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Dashing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 27.3802674}", "context" -> "System`", 
    "keywords" -> {
     "curves", "dashed lines", "dotted lines", "lines", "edge styles"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Dashing[{r_1, r_2, ...}] is a two-dimensional graphics directive which \
specifies that lines which follow are to be drawn dashed, with successive \
segments of lengths r_1, r_2, ... (repeated cyclically). The r_i are given as \
a fraction of the total width of the graph. Dashing[r] is equivalent to \
Dashing[{r, r}]. ", "synonyms" -> {}, "title" -> "Dashing", "type" -> 
    "Symbol", "uri" -> "ref/Dashing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12276, 339, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->177125650]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 91895, 2489}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2782, 61, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3405, 88, 4191, 83, 70, "ObjectNameGrid"],
Cell[7599, 173, 1873, 59, 70, "Usage",
 CellID->8804]
}, Open  ]],
Cell[CellGroupData[{
Cell[9509, 237, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9987, 254, 520, 16, 70, "Notes",
 CellID->19785],
Cell[10510, 272, 302, 10, 70, "Notes",
 CellID->20333],
Cell[10815, 284, 943, 33, 70, "Notes",
 CellID->21564],
Cell[11761, 319, 478, 15, 70, "Notes",
 CellID->41]
}, Closed]],
Cell[CellGroupData[{
Cell[12276, 339, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->177125650],
Cell[CellGroupData[{
Cell[12661, 353, 148, 5, 70, "ExampleSection",
 CellID->133883356],
Cell[12812, 360, 123, 3, 70, "ExampleText",
 CellID->243434727],
Cell[CellGroupData[{
Cell[12960, 367, 695, 24, 47, "Input",
 CellID->110933490],
Cell[13658, 393, 587, 17, 75, "Output",
 CellID->380121874]
}, Open  ]],
Cell[CellGroupData[{
Cell[14282, 415, 718, 24, 47, "Input",
 CellID->483937840],
Cell[15003, 441, 5828, 109, 104, "Output",
 CellID->133274237]
}, Open  ]],
Cell[20846, 553, 125, 3, 70, "ExampleDelimiter",
 CellID->225212368],
Cell[20974, 558, 80, 1, 70, "ExampleText",
 CellID->349071966],
Cell[21057, 561, 433, 15, 70, "Input",
 CellID->136970930],
Cell[CellGroupData[{
Cell[21515, 580, 430, 15, 70, "Input",
 CellID->442974176],
Cell[21948, 597, 852, 23, 110, "Output",
 CellID->73932194]
}, Open  ]],
Cell[22815, 623, 403, 14, 70, "Input",
 CellID->4417547],
Cell[CellGroupData[{
Cell[23243, 641, 462, 16, 70, "Input",
 CellID->283162231],
Cell[23708, 659, 6282, 114, 131, "Output",
 CellID->239741655]
}, Open  ]],
Cell[30005, 776, 125, 3, 70, "ExampleDelimiter",
 CellID->128675677],
Cell[30133, 781, 226, 8, 70, "ExampleText",
 CellID->379411272],
Cell[CellGroupData[{
Cell[30384, 793, 559, 16, 47, "Input",
 CellID->32617465],
Cell[30946, 811, 3019, 54, 128, "Output",
 Evaluatable->False,
 CellID->651952030]
}, Open  ]],
Cell[33980, 868, 123, 3, 70, "ExampleDelimiter",
 CellID->6262659],
Cell[34106, 873, 70, 1, 70, "ExampleText",
 CellID->3660616],
Cell[CellGroupData[{
Cell[34201, 878, 367, 11, 28, "Input",
 CellID->343545544],
Cell[34571, 891, 528, 13, 88, "Output",
 Evaluatable->False,
 CellID->55388467]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35148, 910, 213, 7, 70, "ExampleSection",
 CellID->88],
Cell[CellGroupData[{
Cell[35386, 921, 242, 7, 70, "ExampleSubsection",
 CellID->68059140],
Cell[35631, 930, 153, 6, 70, "ExampleText",
 CellID->150207859],
Cell[CellGroupData[{
Cell[35809, 940, 410, 15, 70, "Input",
 CellID->12189373],
Cell[36222, 957, 214, 7, 115, "Output",
 CellID->721328326]
}, Open  ]],
Cell[36451, 967, 491, 19, 70, "ExampleText",
 CellID->982634541],
Cell[CellGroupData[{
Cell[36967, 990, 605, 21, 70, "Input",
 CellID->22421334],
Cell[37575, 1013, 519, 16, 75, "Output",
 CellID->16589604]
}, Open  ]],
Cell[38109, 1032, 124, 3, 70, "ExampleDelimiter",
 CellID->60872454],
Cell[38236, 1037, 138, 2, 70, "ExampleText",
 CellID->6210372],
Cell[CellGroupData[{
Cell[38399, 1043, 610, 21, 70, "Input",
 CellID->493657934],
Cell[39012, 1066, 523, 16, 75, "Output",
 CellID->22282697]
}, Open  ]],
Cell[39550, 1085, 125, 3, 70, "ExampleDelimiter",
 CellID->232071657],
Cell[39678, 1090, 76, 1, 70, "ExampleText",
 CellID->204743699],
Cell[CellGroupData[{
Cell[39779, 1095, 461, 16, 70, "Input",
 CellID->218225009],
Cell[40243, 1113, 226, 7, 115, "Output",
 CellID->620300]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40518, 1126, 240, 7, 70, "ExampleSubsection",
 CellID->877725465],
Cell[40761, 1135, 87, 1, 70, "ExampleText",
 CellID->81504682],
Cell[CellGroupData[{
Cell[40873, 1140, 392, 14, 70, "Input",
 CellID->4953682],
Cell[41268, 1156, 217, 7, 115, "Output",
 CellID->493701189]
}, Open  ]],
Cell[41500, 1166, 125, 3, 70, "ExampleDelimiter",
 CellID->121880674],
Cell[41628, 1171, 231, 8, 70, "ExampleText",
 CellID->96904699],
Cell[CellGroupData[{
Cell[41884, 1183, 455, 15, 70, "Input",
 CellID->354061769],
Cell[42342, 1200, 520, 15, 123, "Output",
 CellID->37972941]
}, Open  ]],
Cell[CellGroupData[{
Cell[42899, 1220, 460, 15, 70, "Input",
 CellID->571115787],
Cell[43362, 1237, 544, 17, 123, "Output",
 CellID->323992032]
}, Open  ]],
Cell[43921, 1257, 125, 3, 70, "ExampleDelimiter",
 CellID->812456635],
Cell[CellGroupData[{
Cell[44071, 1264, 530, 17, 70, "Input",
 CellID->26084294],
Cell[44604, 1283, 10448, 184, 131, "Output",
 CellID->315092132]
}, Open  ]],
Cell[CellGroupData[{
Cell[55089, 1472, 529, 17, 70, "Input",
 CellID->230811004],
Cell[55621, 1491, 4386, 83, 131, "Output",
 CellID->698286995]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[60068, 1581, 233, 7, 70, "ExampleSection",
 CellID->19923],
Cell[60304, 1590, 476, 18, 70, "ExampleText",
 CellID->177864763],
Cell[CellGroupData[{
Cell[60805, 1612, 1057, 37, 70, "Input",
 CellID->126769941],
Cell[61865, 1651, 487, 15, 75, "Output",
 CellID->71511954]
}, Open  ]],
Cell[62367, 1669, 125, 3, 70, "ExampleDelimiter",
 CellID->494755710],
Cell[62495, 1674, 257, 8, 70, "ExampleText",
 CellID->45340192],
Cell[CellGroupData[{
Cell[62777, 1686, 556, 18, 70, "Input",
 CellID->32584783],
Cell[63336, 1706, 310, 9, 162, "Output",
 CellID->814706423]
}, Open  ]],
Cell[63661, 1718, 201, 7, 70, "ExampleText",
 CellID->85601104],
Cell[CellGroupData[{
Cell[63887, 1729, 660, 22, 70, "Input",
 CellID->146120593],
Cell[64550, 1753, 456, 16, 101, "Output",
 CellID->331473684]
}, Open  ]],
Cell[65021, 1772, 125, 3, 70, "ExampleDelimiter",
 CellID->512293227],
Cell[65149, 1777, 253, 7, 70, "ExampleText",
 CellID->688634888],
Cell[CellGroupData[{
Cell[65427, 1788, 737, 22, 70, "Input",
 CellID->183044747],
Cell[66167, 1812, 479, 15, 51, "Output",
 CellID->4536051]
}, Open  ]],
Cell[66661, 1830, 225, 7, 70, "ExampleText",
 CellID->339440019],
Cell[CellGroupData[{
Cell[66911, 1841, 667, 22, 70, "Input",
 CellID->106096680],
Cell[67581, 1865, 473, 16, 101, "Output",
 CellID->16185156]
}, Open  ]],
Cell[68069, 1884, 125, 3, 70, "ExampleDelimiter",
 CellID->537268196],
Cell[68197, 1889, 231, 8, 70, "ExampleText",
 CellID->139643274],
Cell[CellGroupData[{
Cell[68453, 1901, 646, 22, 70, "Input",
 CellID->448894772],
Cell[69102, 1925, 509, 15, 76, "Output",
 CellID->355560985]
}, Open  ]],
Cell[69626, 1943, 125, 3, 70, "ExampleDelimiter",
 CellID->577181293],
Cell[69754, 1948, 296, 9, 70, "ExampleText",
 CellID->205667129],
Cell[CellGroupData[{
Cell[70075, 1961, 495, 17, 70, "Input",
 CellID->609336778],
Cell[70573, 1980, 239, 8, 116, "Output",
 CellID->248269621]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[70861, 1994, 223, 7, 70, "ExampleSection",
 CellID->5876],
Cell[71087, 2003, 67, 1, 70, "ExampleText",
 CellID->122308981],
Cell[CellGroupData[{
Cell[71179, 2008, 667, 20, 70, "Input",
 CellID->928315980],
Cell[71849, 2030, 3132, 64, 223, "Output",
 CellID->88416423]
}, Open  ]],
Cell[74996, 2097, 124, 3, 70, "ExampleDelimiter",
 CellID->65550596],
Cell[75123, 2102, 75, 1, 70, "ExampleText",
 CellID->43846749],
Cell[CellGroupData[{
Cell[75223, 2107, 632, 20, 70, "Input",
 CellID->43805635],
Cell[75858, 2129, 10892, 183, 70, "Output",
 Evaluatable->False,
 CellID->215376190]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[86811, 2319, 311, 9, 70, "SeeAlsoSection",
 CellID->16333],
Cell[87125, 2330, 2170, 80, 70, "SeeAlso",
 CellID->16972]
}, Open  ]],
Cell[CellGroupData[{
Cell[89332, 2415, 314, 9, 70, "TutorialsSection",
 CellID->10504],
Cell[89649, 2426, 197, 4, 70, "Tutorials",
 CellID->815154705]
}, Open  ]],
Cell[CellGroupData[{
Cell[89883, 2435, 319, 9, 70, "MoreAboutSection",
 CellID->844553832],
Cell[90205, 2446, 149, 3, 70, "MoreAbout",
 CellID->464173306],
Cell[90357, 2451, 161, 3, 70, "MoreAbout",
 CellID->51075215]
}, Open  ]],
Cell[90533, 2457, 50, 0, 70, "History"],
Cell[90586, 2459, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

