(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    163897,       3081]
NotebookOptionsPosition[    160038,       2957]
NotebookOutlinePosition[    161524,       2997]
CellTagsIndexPosition[    161437,       2992]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Full" :> Documentation`HelpLookup["paclet:ref/Full"], 
          "PlotRange" :> Documentation`HelpLookup["paclet:ref/PlotRange"], 
          "DataReversed" :> 
          Documentation`HelpLookup["paclet:ref/DataReversed"], 
          "LayerSizeFunction" :> 
          Documentation`HelpLookup["paclet:ref/LayerSizeFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Full\"\>", 2->"\<\"PlotRange\"\>", 
       3->"\<\"DataReversed\"\>", 
       4->"\<\"LayerSizeFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Coordinates" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsCoordinates"], 
          "Plotting and Image Regions" :> 
          Documentation`HelpLookup["paclet:guide/PlottingAndImageRegions"], 
          "Plotting Options" :> 
          Documentation`HelpLookup["paclet:guide/PlottingOptions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Coordinates\"\>", 
       2->"\<\"Plotting and Image Regions\"\>", 
       3->"\<\"Plotting Options\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DataRange", "ObjectName",
 CellID->31321],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DataRange",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DataRange"]], "InlineFormula"],
     " \[LineSeparator]is an option for functions such as ",
     Cell[BoxData[
      ButtonBox["ListPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["ListDensityPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ListDensityPlot"]], "InlineFormula"],
     ", that specifies what range of actual coordinates the data should be \
assumed to occupy. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32606]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "For 1D data a typical setting is ",
 Cell[BoxData[
  RowBox[{"DataRange", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["min", "TI"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["max", "TI"]]}], "}"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->101708928],

Cell[TextData[{
 "For 2D and higher-dimensional data a typical setting is ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["max", "TI"]]}], "}"}], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->140086382],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 ", the settings for ",
 Cell[BoxData[
  ButtonBox["DataRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DataRange"]], "InlineFormula"],
 " refer to the coordinates of the centers of each cell."
}], "Notes",
 CellID->993315467]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->62089001],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->222246612],

Cell[TextData[{
 "By default lists of ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " values are assumed to have integer ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " values: "
}], "ExampleText",
 CellID->92921393],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->287939091],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->955528766],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxVk3tMU2cYxjsZCyCGy2ZAEHGADIW2QIEiiDzlfhPohbaijE0hzjkcEaIJ
LqSYjakEjRsboHEFgxkuEXEwGAWk6QYMEBAYtwm2XHRcysUNZMZmbEvf88dO
cnLyO7+853zfOc/z9rGPRZlbWCxW5r/nf1fjsRrK+v8Br56inporTXTfDC2D
Ia6bWV3E1vBTqb7qnR8kfgunTnjOB+nHiO2xahqfO1fzhHgnUgW37Yptpol3
o2lH1MnTN2eJXdD7d5umZO0ZsRsE1WllJjbzxO5YtjS/KllaIPZA4HF2Qvun
euJ9aE9xuBU+tETshfhd7S/PDS8Tc2AyFaHtvbhC7I2iLK8beYsM+6A9TNdZ
YGDYFw1l3NHGZoZ5WN3eWqDZy7AfZIEOznYxzPP9EVU/sPDCnnl/AF6dWQw9
qVwk5sNs9LtxnpbZTyBcuHL2wMTvxPtRNvDTesbNp8RBqO3u33bPfYY4GM2f
VTQb8nXEB2D5rZubT+pj4hCon6a5nskeJj6IIe+YkR+VfcShODLckBVorSEG
ONZlF6zibhtZAfiy5/bzZ+62Gb0ApZaN3Vt8fjayQoDchE3rrtRH5MPgfEyV
H5wzQj4MzwdWwwWiCfLhEDhy9B+u6ciHo0Kt35SWzJCPQF+dM5uz5Rn5CNTs
mphs4s+Rj0TrL9N5Yu4C+UiM2T7S/jGzSD4Key6/FhQsXCIfhRWPSJ/CnGXy
0VCgM2QpeoV8NFT6tDeFD4lZMRDp+Vbpm4yPwWaI5fUSHeNjUbXochbZjI8F
r1y3XnCPeX4cmlzGdkZVMO+Pw6ib6vuwSD35ePBtWyQrlcz645Ft6lv6iYrZ
XwJktRaJXV8y+09A/frXdlLeLPlDqOjMi+Urp8gfQrf2SqdFyyT5RDi2bs0o
Wxolnwj1rdrLz6cGyCfh6Cve6A5hJ/kkOPU+eCyP/IF8MvJDezR3+NeM/x/J
8Nrnz/UcaaU8JONATwe2XeoxsjoZX5jPc+NXhyg/Qhgu+ldZzY/TvBDmNgvX
i5VamheizWHMseQC9V0thJlFlsbsDSbfIhQdz5hqEFP+IYJV18weVSb1QyFC
bK7TREcA9Uctwou9puf5GqbvYnjXGArtX6f+QQyrv6zv+r4kVoghlywbbJXU
V7UY3EaFl80a018J7qQHDYs3iCHB+X6PisFqYoUEJ+pjj0jNmXkJOLz5jbMO
TN9TkPS+57nSJ7QepKB8g92vldN6FSkwjKeP+RXTftQpYN+vl3EUTN+l2Kjk
hG7l0/eAFJOD3WFVjfS9FFIo+K6zR82o72oprnEtA9zf+43mZbAbV15y/OhX
mpfh1I1hp+rPH9K8DMlefQ8OTrTRvAzTgohq1bvlNC9H3jtVJQ4hdcY8QA6P
xu1msuQOyoscOZX3awozKE9qOUxO1+kycilvrMPIbthdGRFDecRhiJL+XP/m
g6m2fwA9DPZ1
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 101.}, {-0.9999232575641008, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->140892542]
}, Open  ]],

Cell[TextData[{
 "Use DataRange to specify a different range of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " values: "
}], "ExampleText",
 CellID->16825853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "10"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->243350036],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd1HtMU3cUB3Dk4QqUteVVaHmUFh0OSgXUMhz7HRAYDDPlMSAoY1OYcw5H
hGiCCwGzMZWgcWPjYVzBYIZLRBwMRgFL2IDxFhgUJkihvAptL0weEhrZsKf/
7CQ3zc39nc/Jzf2eup36IjrV2MjIKPW/a+f3/1VaslMNxKs7v7vqRgPR33eS
psFAwXZaJ/F7VUPkgFT6fa9qEJ+PkXNnPFUB6lGiVxRk2Swyc6HqGZ5XksSg
e+wC1jT55FXNkQbHsLPn78xgv4r0vpS1Fq7Okd6enVKToMqkYhOWCr1loqWb
34zVLOL5FeJ/Wni07Ss1+s9J2wecu0eGNNi/SiJd2jYvDWtx3joxmQqZ7L1K
ofeC5Kd53c5aotDbJG3Bio5cHYXeFqkrFsnrGyn0dGTZrjm3dR+F3ksS789x
ZYdr0TOCsNqBxXUHw3wj2LqwRM5KltDfBTT5z2N+kyrsNwa+KEE4MD6P80yg
eOD3tZQ7s+iZQnVXv9XDvUr0TKHx67JGXbYCPTOg/+Tu7pP4FL3d0DKbJLiQ
PozeazC0P3zkN0kfejQ4MVyX5s9sRY8G3sziK4z37qFnDr7ChbfEygcyvWcB
RfT6LmOfP2R6zxIyj24zOxOfyPQeHVxPSbMPZ4zI9B4dVgaWjwRFj8v0nhUE
cb3Vn60q0HsdylrU23GFSvQY0FfjKvQ2nkOPCVUu4xMN4gU8z4TmP6ezYkSL
6DNh1PrJ5D/KJexnwZ7ruwIOR2lwHgsoj1CfvAwtetaQAx2Bmncp9KxBqk6y
ieqh0LOGaLWYkbxNoWcD24H00kIFhZ4NVCzxL0I6hZ4t+JUo1nIfatGzhQb+
qFNYmQY9W5C7S38JDlWjZwdi66ZYqnwRPTtIN/Mt+lK6gJ49xFdbvN/53Rx6
9lC79gM7zm8GPXso68iKEEum0GND1+SNDoumCfTYwG22TCnWyNFzgJa71ddX
pgbQc4CTW35yx6gO9BzAuffx04TQX9FzhGzS3XpffAu/vyN4vXlQ5DnSjHnh
wNvd7WB1rRvzxYFvzVWiyOUhzA8HdFcPVjBUY5g3LpizFksLJJPocUHGGeUW
XplGzwloFmmttN2z6DlB/umUqbqYefScgNGp3CNNVaHnDBGZzuPthwz74wzr
+8wui1vV6LnA/ipdnoOpYb9dgPGC+cB3U4ueCyTEanXWEsM+u4KoPseLtWrY
d1e4nxwwHLNh+D/gweV+j7LBSsN5HpypjTgRZ27Ydx54+6k2LnK02M+DYx97
Xip6psZ5PCjZEPZPJiyh5wa6seTRAwWG93ED4aPaeO+cefTcYKPcm1iKZ9Fz
g4nBruCK+mn03CBHLJg5SVOgx4dbIvqhvR/9jR4f2GOSa9zP/0KPD+duDztX
ftODHh+Oe/U9fmdchh4fpoNCKqUflqAngKw3Kgo5gTWYBwF41NvR4o+3Y34E
kFH+qCovZQDzJgCT8zWKlEw55kkA6XW88pDwCcyfO0Qfe77246dTsn8BaHXM
gw==
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 10.}, {-0.9999232575641008, 0.9995736030415051}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->150262993]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->368480152],

Cell[TextData[{
 "Specify the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 ",",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " coordinate range for tabular data:"
}], "ExampleText",
 CellID->1850560363],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"x", "+", 
       RowBox[{"y", "^", "2"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0.1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", 
       RowBox[{"-", "2"}], ",", "2", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->362361440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{"data", ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2092582835],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->270166610]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListContourPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"DataRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1336285016],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJx0nWdYFL/XhhF7b9hRwK5YwF7AAKJiR+yKig3sqChWFCxYEcvPhqgoFuwN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   "], {{
     {RGBColor[0.293416, 0.0574044, 0.529412], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmGmMltUVx59hZt4X3nnnfYXBBVAWoU1sjco2DMsAwrApTRrRBBj2TdZh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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllElIVWEUx7+X777bu/elFLVocigLjIhKWjRYEZkVtDGCBn2QRQOBWoRF
g6VNGkJBVBJolDbRoO4qyHwFlVmL2mREm7RokKzAhFb9Dv/Fn3v+90zfOd/5
Tk5ZRXH5COdcCYiCbt+55oRzdRHn6sGNmHPXQYhuHpiU4VwOpNFzLgXepjv3
KHBuCOdMeJbxuHNtac71gmnoivk3A30e+AHvhxdhuwJ8Rh7k3xrkXHCTXJ+J
n0muLNCJrjeQ7h/+NdivspjIB6OKHYVHosqxE/kEuIlcDXZz3ofE20bcAjCB
2vr51hG7A8xGvyhULd/BReSN/BuLzTjwnH404VNLL44Bn3yd1NdObafAefiO
QGdpBbXpOoPlXgc2hcphsb9ZvdZL4lWQuxIcQn8ADKIbj24ltofhE5H/8G87
8aYH6p3VPBf9YvTPPPkEyCFYjbwXTEGOY7MbeQ9Yi38e/jPxTQN16B5gs4X4
DeA2+uOBzv7a+gdfHejs5pMN76Pe92mq2XrTGKqX1qNh9Al4lac77KFflxOa
ndOgCvsm9Muw3QUK0S3FZjS6r9R/B/9r5HsT1Z21oGvAZjP6MvA31Aza7CVB
PvE2h+pNN9gHT8HLLTYYCY/DKzzNaD38I/xMTDMQwqfBL3s6c5ChHlrvmjz1
bir8kqceXuU8V8D6iGbgN/ITzteO3AHmYF+K/QC2T+2ORzl3Lq7ZSIJM9Lmh
YtudJTN053bX1pNs4uUTr4vaUk5nWxKqNjvjL/Qp9G0R5RxG1xPT7BSBF75m
1GbzbkS9a/XVe+vhBvJV4TMGn4Wgi3630u9XUb1Ze+svfdVib74Q+/2hZt9q
mgwvCFWb9aQl0MzYrFiMI/hWg1kR9SiVrjdrb9XutBL/C6FybwVJ8iWxXxDR
DFjtOfBvTj2w2W8OdZf2Bn6ie5xQbffAILwrIdl6shheAD7g68GzkDN9vW37
dz/UGSy3zbzNshfoLdhM2y7oi2m2bCeUJhTTYllNlfAaX7M4HwxR30Cg3WUz
5sHPEvNkmnbeEl8zbrNtNdmuexdoN9rOs7f/hXyNTjtgOWcrCbUb7I7mY/8p
rt1pO+2orzNYbuvZROQRvmbFYtiuvBXTLNjO/A//7L2y
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.383551840643457, 0.21412628434297823`, 0.6561088280283003], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlnlsVUUUxuf1lXdf3719FfAPIxRalIStibIEKbKJQjHGRExQkEIoEJQo
oCgYEKGggEKiUauAsm+yaBCNC0JZgkEBjYKUPTFARUUBwYjGBPydfOePyXz3
zHfOzJxtbnnNxMETCkIIvzHSjLvjEO4oCWFXkxDyxSGMzobQAcLkJITZEeup
EGqZJ/E9Gtwbfmf4X8H/C+4Vxln4deiWFoUQY3Q53APofAy/gLVOjI6M+5D3
Qd4M+TLwN+Ct4B25EA7lsVcYwijsd8H+VezvgfMnnBNwloL3gTeDS9hrTFY2
X0b3CcZMdFeyvopRa/tibxvn+dAuWaA7tWc8h/3+2G+aCeFx9OrgTUN3GPJO
yH9h3+nggeBb4EAJXRldGCm/h9maBueFWJyfGTHnWwxnDfhcLP4M5irstDQ7
4Bx4MvZvpHSWdownkX3KWg2ctWy2mfMc4jz9kXVlbT/8PuC2jBXgCnTTjELG
HPhvwV8N/1RKvjSfl+ODLoli3AvcOxL/RNBs+kuxNwX7/dh3LnbmMzZgpz3z
w9isKJRfZ+fl2wbwD+DSJrJXnciW5YfFsznjdmy2wuZ7cIrAWfAEcDt0O+Rk
M488QT4V+UBkY7H5EPL7LY7gIeDt4HrPh3rwbvB/5hPi+T2x70ZMx1nMPXbl
2GyJzXewuRL5euQHkNcgH+S5dBN6Y7PKxeHI7/VYWxwsHpYjj6SUO7NS8scH
efnE1hqQHWXs5e4rInE2Otd0qj1HLFcKC5SzJxn7MsoJW6vM6hx2hlHgu7LK
gXWWt/hzoeU2st/5Pgz+Fr1i5E8H1dmiYtVaGX7YCk7ww2mP+SfGR29vIjwH
/Bp4DPgc97iQU+x+9HNvMjn2b4UzD/vrwX/HOv8WxtwgudXvMbjHGefhlMJf
EnTvISn5bDl7zYj0nS4Q1+5vNdGYUV1cZz6TkV2rI/Ol2d1k+ZtTDr+U8+9C
xeRISn6/ntK57XsnNi9G0t8FvhTJThlnz3gOrAI/Dx7AfiNYHwGvZ0o1FJeo
jnYjuxzprFb3Q2PlQ4XfaYjnteW36b4Id2aktdvgFqHzLvxG8PvsU2U+5Px7
vH57IS+FsxfOm8TrV+I1n3itgbPL89NqtCxSnV4F98gqd6wfPxarJ2/0u1s+
fFmkvmY9rR4cgT8C94Tbwnv4F+D5JeonfWP1EeshVhMrctr3DXTrinSe7ay/
Cn8c/GHmP757gyPmq3nV7xHPF+u9Z9ErQ34irTy2/LCY38M9RibqA8e871uc
Lea5RHG3N2RWpHdkCfarvf8czSlHLT+nsz6c0cn3a/C4FyLrhv6eoF4y3ntU
R9/H9rOYtIkVl03YPQ8us3qEPzhvQG/I1/6OPMVdviMu1WnVXH0iP1eCSy03
UPksVo82f+6P9G5t9R5q69ZT7T0Ifo6FrK+Gt8BzyO5R4f474rE87nViZ96N
/anYn5iR3VPeN6x210aq3wOsXYvVB6yuCt3nTXKKh8WieVY5ZGtnM6ptq1+L
czavWP+LjYPIBwXFNhMrvvXMz3KG8axdYc9TifqKzTdnhY8n6k3mn5PgZlmd
tcF7p9Xr8li1Z3XXqkj/BPY/0Be8BdzV+hXrr7DX63BGRvrPsBqz/ncwUg80
P93wum+DrIq1C2xzEt156C7IKEeGJ/Kv9aR0pL60LNa7a2+u6fWLpHsJXzVy
5we57yRsfA6nEs4U5qH+P2Bv0YCc3qPu3K9pVmdIewxtr76R/mOsNyyKVTNW
LxfRu5yT/QT5tbzeOOvv1/0+Bei28BxOw+3uOfkT/ikFH8U/b8c6n53N7P3j
Z16M/Bnfy3pfynNuJ5zD/j4ey+m9NBzH+uew/40tnqeWr4NYr/U3txXnaR1p
rZEzVHpd13q+bvS35bTnpdVE50R2kmK9YXY/q622Od3lAeY5/o5vs5z13rIh
o15pffIMe/Xw+66JVDNWL/Y/NcL/u3bAae29rpi9arJ6q6v9XbJ+Ugf/UffV
uozeMHu/dqJb7r1xc0Z5bzlfzXwn/D/wyf+ykGWX
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtll1slUUQhvf0tN+enu/rqaAXRmhp1aAoXCgQpBYoogWMMeIF/lGILabI
BaSogBIpBaUoaDAqIooUa9FiNYgmJopQalH5MxGNtQWNsUKJWn9QgcSE+LyZ
vXhzZr6ZnZ19d2b2lNcuvnNRnnNuE8gHR7xz2xPn1qec2wDmIFfyLY08GpQW
Ozc5du5AgXOvgtqMc0mRc1cTZBToyjm3L+vcfwQ7Bt5BfzNrcjvoRP8E/R/k
wyBN7OHs8TJ7bwFTiT0FtBD7EBjOfpXoncgvgfOsz6EvQ74dzMB+P/rf8o3I
hViH+W0I8RLsI0M8rXmu0LnT5DsANiIvxd6JfSFrpoLr0Cehd+M7CErQr0B/
pcC+RegefVHIZxh6WWyyclyG3oJeTazFisn5ppPTL+TyK3gK+0fY67FtBNXY
yr3ZL4bfh7FviS0X5XSM8/bAV0mBcTYN+73YT6MPkQ/227DPxjYGXIU8i293
gJHIDfhvxn9yZHuKi6rYuBUnR/h2Hn0G+88Ey/Hvii13nWEm+srYuBXHN6Mv
jW1v5XAP+ib0isi+ZdGvjK02HgIZ9PLAjzgbW2x3rP0VT1y9FuJrv3HwkQcf
XYGvS6iv43w7ATffg3WsP4H/enxrwVxsVfgPxXYjmIj/Gb6lqcV88DO+rcqL
WGNBG/IO7ePs2xp4WojQmG8cNqEvQH8MeRaYy35bw31cCmL0JNSf+JuIf37W
mqcn7dxqclmSWC6V4BS+O1lXFvi9HpvDZxc/veAZ9Cb0utBvJ0MNq3bVEyOw
TQL52PrQW5C3gdnoq8B4fC/3xpU4208+baHf1IPn0P/IWq8oZ/Vyhbe91dM1
yCvBXchjUlarN3mrRdVkA/pcb+eZD+ahz/N2NvnUJBZDa5XjAeRub7ntBOc4
f3tk9aWenEA+PxYaV+Lsrcg4EjfyKfNWAzqP9n8Q/1FZq23dz2r0W0O9686m
eOsh5aIaaMQ+PWt3pztckLOeUC/UIz+L7w5vXIvzL5kDVeQzjnxq0jaL8kP9
if+D5Pd5ZLVTA84SY5BYv4F/xS2++1nTS6zvwO/onYnJPWAQfV9i8rfgT8VG
70vZmhuo1wngQspmaDe2M95q/YOUzeKj3mTN5CH4XgS+Sdmap6nHH2KbJepv
1d4ab3elO3sceYW32a2aUa8fDfNRfJ9VL0Z2NvXEAHpHZPehmt0MP2Xwk8BN
f57V7gXsa53VcBH7DURWr4p5GXoq1HczOIzcklj+74ODqt/E5N2qad1dxnr1
OPpXcLonvA+aeSXoH7P/u2mrGZ29lzVfp4yDRr1XoCllNTwC/59CfWmNcin1
1jvK6QHWF3Oma9lvNKhDLyqyt+uaPLvbfsXI2R03w++Hsc0azZxh7H0qstpQ
jXxG7K1862Dvt8Gj+M5hzX1gOXI2sRoSv+LsReI+QdzWUJ/ivj8yruSjWbst
vB+aiTXEWRHb7NEMambtk2Fe6T1t81bTdaE/y4l/kvP3cfb3QHWx5aRcbkEe
mjHOxbVmahn+ewvNV2vG4VMb3lPN6LvRHwnzXjP+dW9n1lnFeUfOcmoP7/0S
/PeE901vzipvM2R+6DfVwhvealk1sRvup7H/+LTVWKu3mbgh1Pte4m/P2n8F
1cSn2A55qx2d4QXs9WFei9MvvPWcek13EuXszddbX6CzJjajNJtUQ/PhI1dk
d6+a8Pg8j++6wN9f3vbUXupZvS0VGasdvTG7WFuKf5y2GaK3ZG3gQ3eU0f+h
wK9i/g8R/zkx
         "],
         VertexColors->None], 
        PolygonBox[{{2935, 3910, 3909, 2909, 1517}, {3911, 2911, 2910, 2938, 
         1560}, {3536, 2415, 2414, 2416, 821}, {2630, 3688, 3687, 2633, 
         1105}, {3932, 2969, 1598, 2967, 3931}, {3754, 2691, 1187, 2723, 
         3753}, {2905, 3887, 3886, 2908, 1512}, {2911, 2912, 1477, 3890, 
         2910}, {2720, 3754, 3753, 2724, 1227}, {2822, 3830, 3829, 2825, 
         1390}, {3665, 2563, 1024, 2597, 3664}, {2567, 2600, 1069, 3667, 
         2566}, {2415, 2450, 904, 3561, 2414}, {3560, 2413, 861, 2447, 
         3559}, {3795, 2778, 2777, 2776, 1275}, {3887, 2875, 1472, 2907, 
         3886}, {3642, 2567, 2566, 2565, 986}, {2778, 2798, 1358, 3813, 
         2777}, {3811, 2774, 1309, 2795, 3810}, {2998, 3951, 3950, 3001, 
         1634}, {3951, 2965, 1594, 3000, 3950}, {2490, 3590, 3589, 2493, 
         942}},
         VertexColors->None]}]}, 
     {RGBColor[0.47368832432335617`, 0.37084928675266776`, 0.78280655992211], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlnlsVUUUxqeP9t377ruvRdwSrWJVKJFAI7EVWoyyS0GBClRttbW2YupS
JaLU2mKAaiIpW5DEmMgmi0Y0URZpiITNJWURUIMQTZClDVFMAA0JdfmdfPPH
3Dn3zDdnzj5TUNdU8WLCOXeU0YeRyTj3dOjcIzAfTzs3Js+57hznagJG7Nx9
Wc51sT4XXCeYyZFzjbnOVWY7Vw++HPxl8JPgPxSJPxZ+Mfwu+JeR8wtyfkVO
A+ut7G0G0wi9APpN6KaUc98jvwaFCuE/C38Q/BrkTEDOBeQ8yPoW9HgdHSZB
b4duhZ4Pfjn4teBPQB+DHgC+jL1F7N0FXQzPsfYf8ndC74C+BL4cOduQ8wZy
hjAqGTMZm9C1jTGPsQI5lcgZkXTuAeiBjDXInIBNo7DtOjDjWX8N/g1gprG/
JSE9x7JeGwuzPCU7zcbb4RfD/x21lnD+ZPRoA38H/HLPb0TmF8h8Cpn94eWw
9j78fOa7+T8O/Q1r3zGqod8DW82e+42HzCpk7kBmNvh88HvBnADTDuYdME3M
29Kyy4EZBuYzyH/9v9F/IudV5PyGnNmsz4ffgC0jmav5T2Qp5gt9PpQGWjN+
RUJ+NV8c5b+XcZVRjMzcUHQ3Z2Vi2ZVkX4nX0/zxZSifWF62ell3ctbDPjfW
sfcM+uNSt4xPEn47vh3K3qWhYjkEenGomH4K/qrlK/g9zHOx/yV4FyLljeXM
DB9zi/1E9m4Npf8r4EeB7wt+A3ouRs8OMLPYt8LncxuYiWBuScq+47FsXAN/
neUx/A/YuyiW/DXMB/jfmiXdO1PSvw7sPb6mLrK+z9dOF/o0gqkG8zznrvS1
swrM6kB6V/o8HpqQjusD6flWpHozvOVCn0B+nsNZj3q7NrG+F5nHwJzlnALo
k5z1IfhDZjNyNgb6N9psas6TXRbbgZw5gPEPdGFC/2tZOw1uGGd1IPNsRjb2
xT/XhMJuBtMDpgBMFfKrkD8Y/nZ4b+cp/3t8DVieHAzkO/PbYeivobdlKces
bj9i7If/VSz63bRy3fL8vNkdCHcGfc6lZGMva6cY7cjfHShOFqNVacXVYmr1
9G2ommqB9wQyb4SfFam/WG/5mznJ2jhiNz2h/LXcHR6obq1mByNnEXKmwF/P
vI6xDHpDpBiY/y+i+4hQsUzBm47cbPg/Qh+Gzkf+RujNPl5zwC8M1KsXwP/Y
98MWeK2B8noX/D3we+H3gZ7mde6M1BOtH15B9wPYNNupr0SxeksReuQwkoyT
4M/5HvtHJJvN3qk+5hb7KT4X7H8QmCCS/qbX6ki61WBfSSjcOOJwBL+UoM/P
sfLDcuOk9c5Q52bQra/VbY5q0vpshfev9Qjzt90b4yP1hxPs7RdKb+vFU/0e
u3/qI9Ws+f7JjPxvOpZ6Pxd6rO3pz5nZxHpljnpQhT9vS1o92vLT8qjM18tO
5Bzx/swFcyVXOg/08sw3Fv9anwP9OP+ZUD5u83bMYMwK1cuspncj8wcfO9Pl
1rT0KQ2VK5Yn+5OqN6u1BYH6tfXqe8EMD2XTPF8flv8/IfO0z6XmQLVndbcv
UP0YzvrloaR6ptVHKlaNHEwqVyxPagPln+Vec1p3od2DL+CTnoz6VSX8u/y7
YnRa7wN7G4wB87mPu917YwLdfS/DP+/fA7nM9aH8YrEs8v1tdKA72O5Wy4tM
nvxcm9a7wd4Mdv8/ltYbwPrEpUC94rmU+qnpZnGx/mX5FsOrCxXjv8CXQQcJ
3flxnu79w9bfY9k+OqXcNf2vDZVzpqO9Uzr8W8XsnpmW7SNDxdtsyGNuCBXr
60OdZ2eVgr3Jv1s+4axuf2fdxnyzz0Ormav+Tm3HpqU+1ueJ6Slfj/8DIWQ6
OQ==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtll1sVFUQx0+XZe+9u3t3wQ9M1IKNITXBj0hsKa1GoDGFYlBRqIkbWyrg
g0YFxVALlKQ2JtYWMLZRecAWFYyJH4mgInbFlqhBqYgaTBUFJDSKPrB9s4q/
f+Y8/LMzd+bM15kzsxWtjy9/LOGc6wZJEGed+ybl3HronWA3/Gjg3P4y53rA
n9B/gL3Q34GDkXNTcs4lwCfQC8H7sXPvgQXQp/j+Q9q5q6c6dweog4/gkzgb
m+LcNux3Ym8NtnrBZaFzP/MtIKgUaIFuQX6bZOA16BHwFnQHGEJ+PrBY9O04
9ovYn8T+bPx9Sxz1xFGNr2bwRmA+e30+X5LrYTCXXAsgh2w8ZbmrBqc4OxOb
5eA36MqMc4vAEWwPgJvRv4j+u+ieAKOx1UC5H4UeR/cd5I3IKsB88itx5kZy
uwGkoU8j7/L+f0f/dR8PJlwP+i+Au9F9BuyDXhwb3Q72wy+Jjd4EPoJfCr8Z
egs4jP0Jcj5JrvvALIz2I+8DMyOLfdL7Vw7T+f4wNpoSFuM95F1JPa+jnhep
Xx22agLLNYG9PLo/4eNf6ElQgC4gn1Nm8l/gLw/tPhXDZmS7Aru7FaAaWRX4
B3o2Ol8jG8xavyneCehbkd/k+6EbflNgZ7eAS5CNZU02FXxOvHuI93jSeqAI
Pwg/AIagx8lvB3l3kUsBtHC+OTTfdyXMdpuPXz6CvHMhdxKAFPSH6DbGVmvV
WLIJ7JZypqO7/M/3g2rawbcB0MC3clDARhv8DOjbwUb4QS9/ApyRfsruXj3Q
mDcbOjtBvz2E/xz+78P3vaABeTvyK5D/jfwl4ugk10FybwNrQ7tT3aVqWI/+
BvSnoX8O/fvh++Dnp+xbFfzqjPlSjxehN/DtKTAE/SS/n/J7EKyH7ga/Qp8E
z0M/B8ZEY2sVaIMfyVhuyvFBYjlCTAeIZQdokm0fj2I4i/yRyO5Gd9SF/IOM
2ZLNZ8nvUfLbSm5NSXsrX6Ts7aheeluXhtYLyll3v1c9kbMemIb92tDe3sqE
5aIcFLtyWshvU8Zqo5iGOXfIzxP1VF1oPal+U08vQ16WtrehN7IKeRYfy/V2
QCt8HNtd6VtNaDqSVYJOzt+ZtlyUUxW2k/TfMLmcd/b258TWm5oBmnV6c5N+
/vZCX498hc9Hs/OCf++KbzryeaH50hsd0XwP7G1JZ7tqEdtZvfnFxLKWmNaA
BugTWZv58qU3egv1qffzTz3yonTT1mvqua05s6GzHTnrnZ3ov5qxHlKv7/L9
rH6I8zZTNUs3gnPQb6dsVmpmlgKbYYpXM2EUmwewXUraTpmLrNzPI725o4Ht
rB6/TxTrAm9fMR8j13WR7QLthKvwX4e8iKwfPI38K2ryMbU4DfrRjfAZgj7o
K9GflTFdnWnG16LAdpN2lGbXm4H5V7zD0IcCm1Xama9gvwI714CXoavRvzaw
u9ady9dnyIqR+XwgazNXs1QzaTv8nsBy087UrG3381By9cK20Ga/eiJLvLmM
1VY1iLK28wp+PtXi42xku1g7eQn6rf79645qcrYDtfvm6a5De0Mrvf1jfPvR
73fdyWrked+PmlHfIx9L2y7WGzoD/1fa/gvojHar/kPov4N2bCm0Gqk2F0L7
L6GdpV2l/xS661pfD935/yQRG3Y=
         "],
         VertexColors->None], 
        PolygonBox[{{2496, 2532, 987, 3617, 2495}, {3828, 2794, 1349, 2822, 
         3827}, {3188, 1925, 357, 1922, 3187}, {2410, 3535, 3534, 2413, 
         860}, {3003, 3955, 3954, 2969, 1599}, {3448, 2291, 2290, 2292, 
         698}, {3752, 2690, 1186, 2720, 3751}, {2560, 3640, 3639, 2563, 
         1023}, {2801, 2829, 1400, 3832, 2800}, {3949, 2964, 1593, 2998, 
         3948}, {2660, 3712, 3711, 2663, 1145}, {2697, 2726, 1235, 3757, 
         2696}, {2971, 2972, 1559, 3933, 2970}, {2902, 3885, 3884, 2906, 
         1511}, {3066, 1743, 114, 1740, 3065}, {3734, 2697, 2696, 2694, 
         1152}, {2603, 2635, 1111, 3690, 2602}, {2745, 3775, 3774, 2748, 
         1267}, {3686, 2596, 1064, 2630, 3685}, {3814, 2801, 2800, 2798, 
         1317}, {3145, 1860, 276, 1857, 3144}, {3885, 2874, 1471, 2905, 
         3884}, {2337, 2370, 822, 3506, 2336}, {3478, 2287, 738, 2333, 
         3477}, {1859, 3145, 3144, 1826, 236}, {3102, 1798, 195, 1795, 
         3101}, {1924, 3188, 3187, 1887, 317}, {3668, 2603, 2602, 2600, 
         1028}, {1797, 3102, 3101, 1767, 155}, {2846, 3847, 3846, 2848, 
         1430}, {3562, 2454, 2453, 2450, 863}, {3587, 2445, 901, 2490, 
         3586}, {1742, 3066, 3065, 1708, 74}, {2995, 3949, 3948, 2999, 1633}},
         
         VertexColors->None]}]}, 
     {RGBColor[0.563823762453118, 0.527570087964398, 0.9094988073185917], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlmtsVUUQx7e1vWfPPff2hkTUUFPS0kgUMRAFURQQwQDFSgz4ACMgWFBE
o2DaGrUtVE1BpSBCVAwW5GViDRAFVBQoqFHpQ0UxigUlSjF+QB4fiER/k/9+
8MNk58z+57GzM7On9IHH7nw03zl3DLoI2hM59yb0TJ5zt7PRDyqHSmPnXss6
lwX0YOJcRc65s4XO3eedu84Lt5j9NLhO+N7IjmSc8/AdKefOo7MA+4PALGfv
XuTz086tLnKuocC5M/g8AL4bvyvA9MFOGl9t6H0GPY6NseBngZ8E/lv4g/DF
xPAVtlqgdfmKfUlG8VeAGQBdA/48351QF3QO/6/j4zj4H7G9mLM0Yf8o5NFt
JM5Zic5pZ/w62F4PncLe7/i9A/lJ+DPwY+ATbPZE8tGNjUv4Pgr/M+t2r/jq
oC3QZqg41jntjPPSyoXlYTyyD8BvADMO/n34t+GXsV6dlY196Jbhdxu6ZfDb
w71UgimHHwnmLfgR8M3wM4mrmphGEE8lsl3sNSB/DvlC5FWWF/jP4XfAHyAP
X0DTyMPH2C/B17vYv0A+OpFXIB+BvBVb1yL/F9lgdFuRn410fjv7artDdJvA
1OCzFPwc/FaDmQpdBeYRzt0YauA2ZDPR7Z2nu/0mrfvthV4V+vegewJfRWDW
4GsN8bwBjUK2n7U2pzrJJronu6PZ8ENCrf6E7DvsXgG/h9jikMOlyFvh3ynQ
PddAtdAN6F6G7ifg94E5BOZCgXL5fKR85sD0Mt9gVnjl13J7M/zF8INDbVYH
uxux05SWL6v305Fqfhv4JV64LaFW6qGHvHrG+uVy/OQTz6v4aiaWOuy0WMys
n/L9ZYH0rW8rQ99Whu8m7NzvxU9nneG11x+bWWyuw+YwbDhsfU9OnmJ/FH7n
gjmE7FjoNauLOKPamORVc1ZvR8D8EXLbxfemUOd21lUht+PRuzXS/V6K3rkw
Hyz2XWnFb7ksyimfE5GXIu+PfBGxxNxZB/hCMH+zNx/MKmQns6qxWmw/DU3G
/p+shzPq9zrwE7BZQuxdUC6jWXSGdbjlF5sHQ39br7Uk0jH8K6xT0B0GP9Lq
i+8cfHvAWp/2EGN3mAM2+zaG83eEffuuZ392WrNrPX7bI/XanrRqy+pqL2tb
qDGPnyinM9rsbE8p5g+JtyqrGrnJ6wwW/xOJ4rPYGuCnh/O2QicS9azNj5e9
aus95D3Iy5CPSys+i60DzMOx+roNzFrrbTArwc4PeTDZr4nka9HdEGrP4vrF
K7Yr2e8b6qovfJ9Qt9avT+bUs1tTmikWW2XoD6vf09ioCfO5kFiOeM34Us4a
Rer9YazDobw85dpqznJvM6baa87cEus8dhbrxble/fgCesvD3NsL3wZtgu9J
yYfZXxlrflld2RsyuUjvSCN2klj+NqO3EfwydF/E9ktec8PurSTR3dnbcjjR
+2JvUHl4Uzsi1YHVQB02U7HemXJ8VRWp5kvYLwS3397nWP1pvdkA3seqwW6v
mCyeZ7PKl+WqHj6KVdf1ac0LmxU7kbkwz20GT81oDg8EMy+csRtMcfCVihSH
xbAJvjmcd3Si2WH3a/Z2xLJZG/rI5ugQYhvqdea+7G8N7539L5zKKA9jIs0F
mwmjY/1n2Ft2I7YHhtlr612J+Jpg22bqImLeHM41x+udsDeiHzaHYvMvp3vt
Cm//yUhzwb4ngN3h1Zs2U4sT1edC1rtDHw0FWwz9gJ3z4f/A/g3KkU0M9heA
/Qiduewdj/Wu2JsyA8yM8Obaf8HujGKowO9Or5pNE/8U4i8sUM7srqwGfFp7
Jt+dyIfZt3nTHnBlac1HqxOLcVBGcQ7IqhZrw9zp/N8c6gj6NiOXZjQnPfz1
4X7tX6AxUl9Yr29P1O/WZ9My6rUWvn9Djgs30P4vvN6pbmRL0VmeUm7GRsrP
unAmq8lTXv9e1tfWN52RaumflP4h7P8h5lzDQ07+A47zYIA=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtln1oVXUYx3876j2/c+4990ZhRROhNYoUzREue7MMC3OpEYrWxLRyzuyF
jJoTprulgRvqZjUpQnBqrkBB0zRrlVpGutrWO9Rc68WaEJa6/pCEPl+e88eX
+zy/5/X3e17OvfqRpx94KnDONYHhYE/i3JTIuRuHOReDhd65ZrACpZkgiJ2r
zDs3EZRAr0e2D2xDVg/6cs6dD53rL3HOw3+LXh96145w7iIB2jPOfQqqiVUB
xhNvCfbz0C2C8+j7rHNPoj8VZMnlRXR6kPWCS5AlYBayeuCRNyL/AtmX4Bi+
j2bMt2L4nJ2JXgOmF5x7DPshbEdzXkNuq4jZABZD34O/r/DXC+6Gfgj7m7lP
CfcZAybAX8RuN76+B5eidxv5TyD2g4HZLsfumch8jMJ2Umov/SbsV8LPhm8A
Nd58yFZvsAG7U/C/g/XQzeTbSb61xGwFd8HPg58LpkCXo7cSH7XY3gG+4R6H
Y3trvfkO+Eb4rfDHweXonsxZfX4Gk7FfwdkSbFvAAPqnY3v7UvAeshnoNKb1
CclpNXxXYG/egq+13KcGXxvBbmSlkfWOeigDvYqzE4HZXEnOo8j9VXx/CP4g
3tnY6ql8S+EPYrML2+9AD/z7yA+BbugnkHXJH1gGfR+/G8lxNb47wKPolKF7
HXe9H1STX3VotVMN/oW/Hf2KwPrzoDcfst0ZmG59Wh/ZLEA+H1yDbAY4AF2V
mO6boBJ/GfQ/obZ/gc3I/kbnDGiDfg2cg/4N3YT7XAa/1Fu91TP7oe/lbAf0
9sBmaVpitGbqXfjpicWSjmp3hbfcVUPV5hD8W4HVaJC33UOfVJFLGXgH2V5Q
h2wrWIT9IvKdjO1IcAT649B6cSdICjZjmq120Ip+R2i1VY0TfGVBD/QF8APy
vDe6t8R6VzVSbdTD6vW69P31pp+hPxRa7x0AzxHvI+ItJec7QR7++qzFVg5z
4JfDF5BNAgPgv3T+NM+LidHvbTeohpqNsdiMKdiMLCTe1NDuqjtHOfOxJt0P
27F9GB8LwDboq7C7JWu9qR6VrIvzE950Ivqrjbuto5Z7QR1nx5F9Dp5P6fn8
Vid2VpGzHaDZV859nP3krRaaiX78fR3brGnmtFsupPlJX7unMrVX/w7P247Q
bhgG/RL57ifffWBtwXpPOSmXM+nuHpvYbtYOP4XNj+k+1sz9id2ujPWKeuYm
8i0PrZfV0wX4QeRvQD8LWrzt7GLabzF5vADfHdiOzqPfnTFd2bRpZolXZBbf
BjH8kcjeTm9Y620mNAuaydHIByKbfe2AGvhpsc2yZjpCVkxs1yvmPznrSfWf
ZvQouZ8OrRfVz0PIR6bzIv9z8DcOf+PxNQJsQDYu3W/aIbPy9o3Tt20m9GwQ
xaYrm5Peek69pplT708E5YHlcEz3D6231ePaXZ34+CBvO6xS/ebtWyqbVugb
Etv92gm3esu5It0PHdi1x7a7tcM7czazuptm8Bfqt4X39un3VL42eauPfM6l
J17J2uxohjbjrzm2WqgmL+ftG6hv36Z0FxfS+Vd/nOVsMP0e6JusXluGz8cL
1nNNxFrnbTdqx7xO/LLIdp123hZyPZzmqx3TnLOzhnQf/Jq1/wTKXXeowm8x
a99mfaPPhfamekvtu/8BMV8efw==
         "],
         VertexColors->None], 
        PolygonBox[{{1861, 3147, 3146, 1827, 237}, {2729, 2752, 1277, 3779, 
         2728}, {2252, 2289, 740, 3448, 2251}, {2843, 3845, 3844, 2847, 
         1429}, {3871, 2885, 2884, 2882, 1442}, {3507, 2374, 2373, 2370, 
         781}, {2418, 2452, 905, 3562, 2417}, {3068, 1745, 115, 1742, 3067}, {
         3420, 2208, 656, 2248, 3419}, {2885, 2915, 1525, 3893, 2884}, {3618, 
         2535, 2534, 2532, 946}, {3883, 2873, 1470, 2902, 3882}, {2687, 3731, 
         3730, 2690, 1185}, {1926, 3190, 3189, 1888, 318}, {3147, 1862, 277, 
         1859, 3146}, {2980, 3011, 1649, 3961, 2979}, {3773, 2719, 1226, 2745,
          3772}, {3392, 2212, 2211, 2213, 616}, {3845, 2821, 1389, 2846, 
         3844}, {2487, 3588, 3587, 2492, 941}, {3032, 3974, 3973, 3034, 
         1673}, {3691, 2638, 2637, 2635, 1070}, {3190, 1927, 358, 1924, 
         3189}, {2929, 3906, 3905, 2932, 1551}, {3532, 2366, 819, 2410, 
         3531}, {3935, 2980, 2979, 2977, 1566}, {2330, 3479, 3478, 2335, 
         778}, {3237, 2001, 439, 1998, 3236}, {1744, 3068, 3067, 1710, 75}, {
         3710, 2629, 1104, 2660, 3709}, {3104, 1800, 196, 1797, 3103}, {3758, 
         2729, 2728, 2726, 1194}, {2770, 3792, 3791, 2773, 1307}, {2000, 3237,
          3236, 1959, 399}, {3638, 2527, 982, 2560, 3637}, {1799, 3104, 3103, 
         1768, 156}, {2535, 2568, 1029, 3643, 2534}, {3947, 2963, 1592, 2995, 
         3946}, {2638, 2667, 1153, 3716, 2637}, {2593, 3663, 3662, 2596, 
         1063}},
         VertexColors->None]}]}, 
     {RGBColor[0.6300949348090615, 0.634049421790555, 0.9110095859303066], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlnls1UUQx7fvte93vfdqYqyCUUorEfAoh2klUTQgh0GRSFBajVxRwBKN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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVtsVUUUhofTy569z97n+CJqWiycShSNaUHC8ak1IUEfkBKNWI4otRqQ
QDTRIlUMUoohYGJoedM0QpRGbaABYqQtTYgKigEvFH1QkDYmYL2lIrZcIvH7
s/bDn71m/2vNzFqz5p9ZrS888nzGObcNlIO1OefujZyrY9AMbss7NyPrXDW4
FXs//JvwfXBnwH2Mz4XOfV/m3A2wF79j4MVK5x4CdxFTZDxc4dwFMIh/D/En
iL0EauDnwL8HdxLEzPVG4txpNjUC5jLew/ga9nWwjPEnjGew1u3gWearZb4C
eAa7AD7F5xDcWXBT7Nzv7KOH3NrA43CHE4utAcsZDzKehV0A1cQPyAdUYQ95
55rgt7B2J5jg30XWWshe14HTcIvwLRLbAr4NnOtlzYFpzAF68e/AfzPYi30K
/0b8G8BJ7IuqH9ydzLUUjDI+w3gEnMduxm8Av5lltsdl1Osl1Rc8hv0L3HP4
PAG3FZSwhxLLpRaswacb3yI1aAGj5LMa/iNy6QMbWWMhazVxFu1gPvwKsBiu
AFYS30F8TXqeU+TWAD8PLgRPM15EztPJtRHEcBH4Bvsq+Du2OTWXxsOMxwPj
e8Fs9rIR/lVwB3Y3/IfwO+FWg1bGrYHNrTXasdeDOdiPgrnE7PJ2NiUBbkNg
nHxe0do6X9CO/SXzTcKPpedTii1Gvg78hM+P4F3mOpGxWo1560XVrB7/Kvx/
wH0fKGLPT8eK34D/BP5j+B4G7zCu5UwK4O3EejsJrZfV4575RqlrJ+ElZ712
xNvZqOeuw11Jea1XTewu1QlUYZeDstD2+g84QGw/WJ+xHPZgN+LbAHZj72C9
Hvb7Wlq/Ef63hda76uELjN8KrZfUU134bwvsLHQmA8yxJLH9qR5/wM/m33Ts
P+HrYtuz9qqaKLdr6Vg55OG/q7S7qDupuz0vtF7VHe9PLEflth87wP/zSquN
4rtYqz6x81Z97tf67O8vuGNge2w9otyU4/LYzsil/bCAfs9EplXSLGnHw/xb
nDMNqWfdutBqKY2p5f94aFoiTVHtjgbWu5pfd/2DtF915zfhvyqyu6Q7JS2Z
xj+XM03R3VeOyk0a8IXqEVgvqid1N7Le7oruyDrilkamxdLkrcSd99Y76qHf
uJsHqc8BMJ7aN/j+l7V/IWtsIeYqvlcypkVdzLkzZ5q0Cm7Q21mqxwP8N/Nv
CnsSVDJ+PTH7X3AI37PgK+zdIILvTPVZa0ySzy3etEEaUQG/KbHYyxl7S8rQ
lEze3pRsaDkpF82h3ur2drbqMWnh19LNnGnisDQ5srdDb8hEbJqjeklj+uH7
Inub9EY9BbcdvJwxTXsysTuhu7ACu1z3E/tmuAbx2KVUr+QvrX2AvTbmTXNX
4v8+fDfcEGjypmHSriXYLXl7A6WV0kxPfh2J1V41XQv/cda0WJr8s7czGEn1
QNqyIO1X3Z9fyedyZG+D3oh7iG/O2luqN/WctxqrtjqT43CfpevrDW5j7uPe
tEiaNJP4B7P21urN3QF30NtZqkYt+J/ylptyvDuxmqgW0pQpb5omLZtM7+Ia
b9qrO3mJ/VZk7W3UG1nkfHxgd1N3VFokTZYWS5P+B7dVIgQ=
         "],
         VertexColors->None], 
        PolygonBox[{{3334, 2127, 2126, 2128, 534}, {2407, 3533, 3532, 2412, 
         859}, {2339, 2372, 823, 3507, 2338}, {2790, 3808, 3807, 2793, 
         1347}, {2626, 3684, 3683, 2629, 1103}, {2755, 2780, 1319, 3797, 
         2754}, {2171, 2210, 658, 3392, 2170}, {3563, 2456, 2455, 2452, 
         864}, {3061, 1696, 1695, 1731, 90}, {3833, 2834, 2833, 2831, 1360}, {
         3661, 2559, 1022, 2593, 3660}, {2456, 2497, 947, 3594, 2455}, {3729, 
         2659, 1144, 2687, 3728}, {1712, 3050, 3049, 1711, 35}, {3972, 2994, 
         1632, 3032, 3971}, {1801, 3106, 3105, 1769, 157}, {2834, 2856, 1443, 
         3854, 2833}, {2716, 3750, 3749, 2719, 1225}, {3449, 2295, 2294, 2289,
          699}, {2670, 2698, 1195, 3735, 2669}, {3070, 1746, 116, 1744, 
         3069}, {2870, 3865, 3864, 2873, 1469}, {2918, 2944, 1567, 3915, 
         2917}, {3149, 1864, 278, 1861, 3148}, {3030, 3972, 3971, 3033, 
         1672}, {3843, 2820, 1388, 2843, 3842}, {3894, 2918, 2917, 2915, 
         1484}, {2245, 3421, 3420, 2250, 696}, {3106, 1802, 197, 1799, 
         3105}, {2961, 3926, 3925, 2963, 1591}, {1928, 3192, 3191, 1889, 
         319}, {1863, 3149, 3148, 1828, 238}, {3475, 2285, 737, 2330, 3474}, {
         3296, 2073, 521, 2070, 3295}, {3644, 2571, 2570, 2568, 988}, {3717, 
         2670, 2669, 2667, 1112}, {3904, 2901, 1510, 2929, 3903}, {2524, 3612,
          3611, 2527, 981}, {2072, 3296, 3295, 2037, 481}, {3349, 2155, 602, 
         2152, 3348}, {1696, 1692, 7, 3042, 1695}, {3192, 1929, 359, 1926, 
         3191}, {3585, 2444, 900, 2487, 3584}, {3790, 2744, 1266, 2770, 
         3789}, {3780, 2755, 2754, 2752, 1236}, {3362, 2123, 574, 2167, 
         3361}, {2154, 3349, 3348, 2109, 562}, {2571, 2604, 1071, 3669, 
         2570}},
         VertexColors->None]}]}, 
     {RGBColor[0.696366107165005, 0.740528755616712, 0.9125203645420216], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNlmlsVVUQx+97xXfvffe9NsEYCmIEtYhGWQoBTViqEUoLhFWkKJEtLIJQ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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlltsVFUUhvfMaWfOmemZakwEqiZgWwQTobQVMEHbxAvIJSqiYVoTaTHa
hkTQtpqIFy6KwIOK9EkuUZEWoRHFK1Digy0FDfXBNhoNDVQJYKu0iBQMFL8/
6zz8mbXOuu+19tozoXb5wmfjzrlmkAPaQufGBs4FnnOl4Hb49b5zjSjNA8Pw
HyPfgux5UJnvXEPauUzCuVO5+EH+N/p/gc3QU/OcK0g61yvf4DFsv+b7bGwf
AI/DfwM/x7NvefDr4K8S6wp4Df5VcD+y5WBWxrmz8MehEyS8GPoA+vPg54KY
YhNzEDjoKcjvAMP4ugn5IuhHA6Plsxx/ffIHyqCvUUsPtTRhPh9Mwc/lhOWu
Gt4kVn5g+fWAWuRzqG9MjLMAWWQH0ZnvWU4lgdWsWm8GVdDtyBd4prMVuphv
GehTcav9pG++FeN61UL8AXAd9CZyXJ1y7n1qfxHUcP4t5Pwg8vFgFvZN2D+N
7dvgEPwTgcUrApnAapD/3rj1phxci+qbia8x+LwRzICenG/fRE+C/oIYg9AD
4HPoVvy1gOc8m4mJ+H6F+PX4rgQ74MuRF3vWz7LAvl2J6ruLmm4j/jliHwY/
UN9X1DdMbQXMUym6zfh7Hd3quJ1FETaFeXYmmrUmdBpDm7nL2F/A/hFsXwI5
xJsa2Nmfx/4SdpXolUGnwJfwJ4jfQe+2gFHq2pew3msG5LsL/cO+xViK/tKk
9Vo9r8f393w/Cuqga/jtRvcYWAK9Gf3d6G9Ct07gDN8hxnRiPAmmYfNhaOej
/swl/6uaL50lZzAZWbVvd093cC22q8DFXOv3AvQLU6Yrm2H4M/CnwRB0Hfbt
2LdF/V7HtxXI1qCfFcgvS36TYjYDg+i/R/yN+KrRfUJ/P3wb9FqwAf2t6K9E
fyFYD/9C0mh90yx2gYaEzeRi5HdG86UY06l/NvJjuVZDB/73kE8vuYyC/+Bv
SFvv1MNO+M6UyaTzM/5O468bXyPgDHSK+i7F7Jtq78PmeMbOYDv4CHoH2Abt
Ef8W/Dfjexm4m+9hynaJdsoQ/svwNyFuPl9Gfh/ye8FK6HeRb0haL9VT6VZF
/ZHNXs6vIrDdqR36I/p96H+H7mDMdulesD3qZ6F2hezBrdCl/Jb4Vpv8vUXM
mpTddd15zUoY2P3RzLyB/OGU9VI9rUD+gW93XzvgKPFHiN+Pv/1gN7bn0WnA
ttGz3jVE/VcPlUsu8pzQcmrH/lvkO6PzXYX9L9F+007p135HLx23GEXQf/Lt
rO4o9IDuZmCzpJnaxfefkpZLK/ROZOdC2+0rPJvFpmielNPBjPVQvTsA3Q16
UrYbtCP+pZcdzFmW+SpxluuhaD6V867A3iy9Vap5D/w/odXeBEbIYZxvu0A7
QbtsKLRctNN0FqpJtehM6kG/b3dJd6rCt50ie53BCd/uXG/0PuhtKSDncRl7
Y46Qb2e0r3VHdLez0bxphvR2TYQv9u0N090pjd5P3aEL2G5LWK2qWbNZqxnJ
2IwuybcdMT66f3FiOtAVtzdQb09pYLtG/SuGf8i3Xa2dXR3YmyG55utTZJ9E
779mttW3Hafd1gI9FpzMs9p1BvcQf1Ha/gvoP8EW9EZ8e9v0xv0G7QW2i4+A
mTq7pO1+vQHT0F/m267Xzh+F3xjY7tEO+gzZr77ZKp8ZxHsm2ofaKTF4L213
W3dcsjXReUjnqdBqkq3ORLlfjO6HaqjHfl/adrN2tGZ9dWCzopnXW1DFt2xo
b8Ifob0B2v2/Q/8P28o91Q==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwt0ltoznEYB/DfDnbwbu+4sbZcsNlyCpl2R0hOOc1Q44JNOZ8KaSNlFIaE
XYgVIUMrlElEySiKmsPcDInJqZCUC6fP28/Ft+f7PL//832+z/O+A+vWz12X
HkKogF5QmBtCc34IR6A/npsRwqC8EBLZIdzzniuWyhsLQricCGFxVghd4g75
00Ssp/hzfLe3g+I8eTUcxivVipMhXKXdRrtbLJI/MG8sPlptuXhf/ignhB/Q
w2C9/CG+pHcI23y/FZbiWzJDeEWzG2r4y+btJd7EZwNeD3X4+DR1PZ16ii36
TnwhX0j3BN2DZtwVa+QJ9Q4e7sBtaMqIO2zgP0n7UCLuU5QXZ6fm/YQ28z97
a8dn4JfET4mo9R5e0ClNRt0z4nYeTvLfIp6WjxRnQ43aGvkI/CZPVTzNSf0m
+C4+f+kf470C/uK/6ZZ7mwnjvWf5tgxPN/ubb75CJr7a3l34K7ovoRv+mDWV
xkaopfNE7xT8qO8OeN8PTdCYGe+5zy1XuOWe7HjbTeaU6imBenyZ+Qv+75Ly
Pxyy9LaLN9SvwzX8W2bUvwDP8IvJOKuTZhqdkPIPHWYN430yPOR/gLsPxdd4
KzSzH4zDK8z96N599feBx/jmEHf9DlV63yfj3tN4n+2bWVCGf/HdY/GcvBXO
44fM3esOb+m/gf34Tve5kh/vlbrRJEhmRK3pegr1TMmOunVmDTCr3G4TxVr5
BL2tvJ6FU7CS54KCuF9qp8HQwGe1OER9MMzHe9Rei8ftdAxaYBTPH835bd5n
c0vofciL/5VbeBvtGznxf5O601p8kdqqnHizQtrFNJtpV4r95P8ABuyGbw==

         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7626366394360095, 0.8469998806016411, 0.9140284735377214], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1l3uQjlUcx8++b/Z9zvu8z741XdZqKqa16EKJyTDKyhRbkmXoXnRVLok0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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnlsVVUQxs97j/bd+967r0ZQWkwUEhAwiqwRFwwgUakKthhBBAwVIxCp
IIsRwYVFjCSgLCKVFpcS0LYkSlmULS5QQYWqWMQotkDUKFQjm0to/X3M+ePL
nTlzZjkzc+bcTiWPF5fGnXPVoA3onnXubOhcc8K5PeD3jHMtSecugN+gTyP7
C3yM7CQ4xVosYH/MufYY2p92rg4U5jo3A/yHvXbwT+c4Vwwq0f0jcm41uq+B
mdDN6DeiuxVk2L+XPbXIFoN3oU+zpwK6HJyBfp61WdBrwWT4E+g3oFsDHs1z
bgn++uF7HMhBfjfyAcjagSz2v0a/LmE2jxH/ec52nPgzyDfofJH5WgNi8K3o
70X2J5iEbFdgvuTzOeRHWHsyYTGV4H+9P38nsB55PfgUWRmI8P9OaLaV33nQ
36M/DHo4yEO/rc9XJThOfFcEFptiHM/e9fDL4XeAFvR7Y7MXuAD9EN8rU851
oZjDwLOh5Vy5LgW90O0BzmGrI/ox/HXA33J8TQaH8Rd6+ZdgNP7qAqvNEtCM
vFtgtb5Yc/T7o78jx2w4+FjabInvzd4HQGHc/N2VtZgVayH0COzvRr4R2UJw
CfrXpu3syoFyuS9tvaScTmD/EV+PcjCR/e+lrdaq+RuR1Uy1KuC8I1XLwGLX
GQ4iOwBWIfsIxKGvAx0SpjMUW7d7/wfAOtmKrHbq2e/Ua2BN3GK4DP8FPn/K
gXLXM7CzKoc6y51psyWbcWx1DKwX1ZPr4Pvhoyu2W+DHY29h2npH5y1GviKw
3ChHHcjZUfYfYn8VeJh6FNK/+fgaBLrAR/B1lKICnMRWLXY6Q98D7kc/oj+S
9EZPkI6sJxTv0Ljd9XpsHMzYnX8C+Se+/rqjBaz/g70qbM0DK5H1Yc8YZGPV
o4HdyRof72JiPQbfBF6CHoX+KOx2JdYW9BfBz4Avgp8ds9nSLWu10YxpIv5y
/F3PXj6uDjs3s6cXstGgkbOcTdls6QbeRvYWmJKwGu9if1/4q/39uiHPaqx6
nAdpfJWFNms0c0qwNZu1p8B46C/4buW7BXwOXQKGpOxu6Y7p7s4P7f7rDr/I
eV5P2ll0pnz4H3MtV8pZA/p70G9tY/HepPukfIAboc+ENoM1G/aCzqydzLVa
qqbnkF+TNZlm2A/Q9dgrwNZg3T/2f8v+Q6CVc7ZHNog9pxI20zWrxoQWq2JW
Lab7/Ksm+9D/Bv7DmM2bCfCPJK231GO70R8XWi6V06VZy5lytQR6M/JC5P01
y8C/rJ3z9bk405Dnhdbr6vka+AL4fFCt2Yqv7T5/laCa9bORzVbFO5J4+iSt
dxTvY/RbfmS9px58E39z8LeW/H7WxnJbhM69GctxLXu7hBabYlRsp1NWC8U4
GPkGP18ng8NZ6zHJVbPtGYux0s/HTdBbWNsM3of+ST6gN4Gj0EfR/zVltVGN
ivFdFNpsuk1vIPKpyOdjuxo0oPdz0mxrfuyA/8Xz8ilfTfCNSfOpuyqf8qU7
uzOwmbHRv4f7Wfvbv2+qqXpzp49fOb4c3wOz/i0HBeiWBpbPvnHL7cDAaK0N
gp8bWG6Uo0Z6bFWu3U3d0arQ3ui1/n2diHyBn2e6b72RTQmsVppplfiuSFmt
VLOxofWYekv9sZr4lxHvNGItA7M0q5BfBWYGNivnpc22fKiXXkH2cmQ9NSAy
He29BfoO8AL09LjN8NbIZpRmUwt0e+KpDW22asYu0tsU2FsjnVuZH1PxF+Hr
RI69Rc6/N3oPukemo7168+YT/0rNUWIfCk6huy3XZrFmsmJZENjslY5m6at+
3itHy9FfjP4kdJeBB0ObacP9vOkT2p3q6u9jD/gRYEjC3rT7oJ8J7e3XmmZD
W2xemrEZMVL/Dil7C/QmrGC9Kmm+5FOzeZqf15oRc7E1J7Te1Yxdjf7SlPWu
eliz8gPWtmVtZurfJ/LzTP9AA8hfcdpypxzuJ/ZJoc1yzfSvQvtHq/D/d/3z
rIfO+/dYs6AmNNnF/y34+sD+hdSP/wMPkXdq
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwt01toz2EYB/B3xg7+hzllo7Sp4c5hUSxLW25sDf9x5UKiFMXKqZgQtcxx
3DnEtR0K24RWIqIoYXODYlGa4YZC2nx+vS6+Pd/nfU7f5/29v9mbm5t2jgsh
LIYJ8CcdQl0R3+EK9je/ujiE7kwIXVCDL8oPoQKvF6+Rt4ct5/eIjbGjcAvv
lFeIN4nnoBFK5V/Ss6cwhJvQC7vyQnhVYLjzsVQIfXgjd5IebeqPw5Da12oH
5HfIuwYd+Hm1VdkQ3sgdMO9voo//hU1PNH88jfzh4qjjIGzXZ24masqZN6+E
D+vxjy7hCH4d30jHAHuYf07+iPz3akv1audX/p+T9P4MveYfcFZr7mpzN7H7
+b/VVYqXiF9W96so7jXZ2ah+2eK4YzDru/xvkI9vp2UH3qRPDtbAQn1P2fug
/VtgC16bF3dYoqZfzbpU3GeG2HTo1Hq+3DJ8KvvVXlecDbNT+HOdV7PLIIU/
FmtS36xPRs5ZNsc/kIm7JPp/Qj/td+i7RNcTuvrY2/zr0I13QUdixWaxDc7r
oQKfMz7mPIQx/FE25if7f2Lr7DEuFe9in/u5ACfd3wgNe/EPdI7BN7u/oPs9
/oDWe7CA/h9q7+M5sQaxMnmr2LX8lel4N8l9VMGo/F5nN/CL8t6xPfzTqXgP
ye7t+BL9Xqbi+0jexCDeWhDf46Cau2pfFsa3OUTnVjo30NyW6M3E79gMx+zb
mo3f9HLyD4kth6v4GXfa4vys+Bk4hF+VP5CJ95DsvhuW6ltbFP/X5B+diafV
lrNf+MNQiU9zVpCOd5Pcx1s4GuL7OU3rNppPFMa39NysZ2Y+hRf4DN/gH1eL
kG0=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8221526501068523, 0.8668468843001036, 0.8873653540914228], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNl3uQl2MUx99s/d7L77LU7rbrMpUpFYUkl4i2GkWh3RoJMbMjl6jtQugy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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJw1lnlsVVUQxk/p8u599/UVpbWtUQEDpkJFEZBdoRitgNoWogUFTGMxoIKW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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtk09IlGEQxmd3Tb/Wb9ebbUhUkC4dggI7pFIsBmkRRERWh4pFg3LbRRe8
VIYG1UGFUNGvP0Sdqu0PUdYhwpNYQRgpSggWWBblilDUwbX6DbOHh3lm5nnn
nfne+dbHU/uTfhGpBCtAjSuysUhkEV6BrcZPhETmHJEphLPYZvxO4s3k63wi
V7Ad+N/Jpcm1gnn4R/S12By5JVAGDxHbERQ5HhY5BmLwvQUifwpFfoEO7o2g
/Q1/DhaKRbLgGbyc3HtyBdQJgH/cO8L9CWKn4QmQBOuI3Sc2BX8Bn8Bm8KP0
dZ5z7eAsiNHLDWLRlcwKNoA5YsvELsM7AyJPsDn8Ta71qH2VUm+CXhqwB8Cy
cvIH4VvRDlL7InX6sZX4Web8zJwx/cDMMo/voq3gTDnIUvMmqQzaUu5zuLcK
ew//LjXGwEvqxfHvwOs5v6R9oVtD3Tr8L469k77NMPwR+utoRsAQOhfNNXg1
+TT5Js1jq/Lz14Nt6IZC9i389DVJX230NY714Q84Np/OlIQfpUbKte+gs7eA
fXzvn8zocWYQDIND1PhAzQg9rALT8PGA7cVOrUmdmGM70kjuFfVHwQn4YXQe
M97m3C2dAT7KvmyHl8DDwAUz6N4QewpfJD+GfY3fiu0BD4h5+C3wb9yTo9cf
9LqWe7/mdyoKIvSy4Np+NaJp0p7AHvhq9N26t9Roo94ZbBd+O/ke8qfId2HP
4b8NWj/awzt4hLfPhuxN9B08EKfnh+ivovfAY7jns7k2gy3c0RC2GSeLbKd1
jzPwXnSX8vPpTClwBP0u/Te4xw92w2v89hb9hfZ/fyq2d9H/pQ+kqXPBtX/n
b9B2VffTh+4kB/4D5b+OWA==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8816686607776952, 0.886693887998566, 0.8607022346451243], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mHl0V9URx1/IL/m9936//ELYQoHaQ0uhLCKlirKoHEA4VgIWEKnYYmUN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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtl3uU1VUVx3/Dvdx7f78794LDyyBxsSIfE6/GFcpASIAhhTMGgyJUVJDJ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         "],
         VertexColors->None], 
        PolygonBox[{{2621, 3678, 3677, 2624, 1100}, {3204, 1943, 1942, 1940, 
         330}, {3056, 1724, 78, 1719, 3055}, {1723, 3056, 3055, 1722, 38}, {
         1839, 1872, 289, 3158, 1838}, {3112, 1808, 200, 1804, 3111}, {3115, 
         1811, 1810, 1812, 165}, {2010, 3250, 3249, 2012, 449}, {3246, 2009, 
         444, 2006, 3245}, {1807, 3112, 3111, 1774, 160}, {2008, 3246, 3245, 
         1964, 404}, {3135, 1809, 205, 1835, 3134}, {3859, 2839, 1425, 2867, 
         3858}, {2090, 2131, 578, 3336, 2089}, {3224, 1936, 368, 1966, 
         3223}, {3329, 2078, 531, 2119, 3328}, {2402, 3526, 3525, 2405, 
         856}, {2201, 3383, 3382, 2159, 607}, {2161, 3358, 3357, 2163, 612}, {
         3383, 2202, 647, 2199, 3382}, {3326, 2118, 566, 2115, 3325}, {1895, 
         3175, 3174, 1868, 282}, {2117, 3326, 3325, 2076, 526}, {2812, 3819, 
         3818, 2815, 1384}, {1943, 1973, 413, 3228, 1942}, {3678, 2588, 1060, 
         2623, 3677}, {3175, 1896, 322, 1892, 3174}, {1897, 3179, 3178, 1899, 
         327}, {3441, 2242, 694, 2282, 3440}, {3784, 2739, 1263, 2765, 
         3783}, {2763, 3784, 3783, 2766, 1303}, {3606, 2482, 938, 2521, 
         3605}, {3819, 2787, 1344, 2814, 3818}, {2519, 3606, 3605, 2522, 
         978}, {2280, 3441, 3440, 2283, 734}, {3311, 2090, 2089, 2087, 495}, {
         2865, 3859, 3858, 2868, 1465}, {3526, 2361, 816, 2404, 3525}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmgmUlNWVx6u7q3qprip2cxLBiTEJhFVk388MQhYVROhGDcjSCs5EtsQ9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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwllnlsVUUUxm/7yrvv3tdFlkKUJRGDCBUE3CgIjQI1BllCLWpEg9QEMNCi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         "],
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1682, 1683, 1686, 3058, 1726, 3076, 1754, 1779, 1781, 3116, 
         1813, 3138, 1840, 1875, 1877, 3182, 1904, 3205, 1944, 1976, 1978, 
         3257, 2020, 3284, 2054, 2091, 2093, 3337, 2134, 2177, 2179, 3397, 
         2219, 3427, 2260, 2300, 2301, 3487, 2345, 2382, 2383, 3543, 2425, 
         2462, 2463, 2506, 2507, 3623, 2542, 2577, 2578, 2613, 2614, 2645, 
         2646, 2677, 2678, 2706, 3739, 2707, 2708, 2736, 3763, 2737, 3764, 
         2738, 3765, 2710, 3740, 2709, 3741, 2711, 3742, 2680, 3720, 2679, 
         3721, 2653, 3701, 2652, 3702, 2620, 3674, 2619, 3675, 2587, 3653, 
         2586, 3654, 2553, 3630, 2518, 3602, 2517, 3603, 2481, 3577, 2480, 
         3578, 2438, 3550, 2401, 3522, 2400, 3523, 2360, 3496, 2324, 3468, 
         2323, 3469, 2279, 3438, 2241, 3413, 2202, 3383, 2201, 3384, 2160, 
         3355, 2118, 3326, 2117, 3327, 2077, 3301, 2042, 3276, 2009, 3246, 
         2008, 3247, 1965, 3222, 1935, 3199, 1896, 3175, 1895, 3176, 1869, 
         3155, 1834, 3133, 1808, 3112, 1807, 3113, 1775, 3093, 1751, 3075, 
         1724, 3056, 1723, 3057, 1725}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1753, 1752, 3095, 1778, 3115, 1811, 3137, 1839, 1872, 1874, 
         3181, 1903, 3204, 1943, 1973, 1975, 3256, 2019, 3283, 2053, 3311, 
         2090, 2131, 2133, 3368, 2176, 3396, 2218, 2257, 2259, 3452, 2299, 
         3486, 2344, 2379, 2381, 3542, 2424, 3566, 2461, 2503, 2505, 3622, 
         2541, 3647, 2576, 2610, 2612, 3695, 2644, 2675, 2676, 3738, 2705, 
         3762, 2735, 2760, 2762, 3801, 2786, 2809, 2811, 3837, 2838, 2862, 
         2864, 2892, 2893, 3897, 2923, 2952, 2953, 2986, 2987, 3021, 3022}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1776, 3094, 1777, 3114, 1809, 3135, 1837, 3157, 1871, 3179, 
         1897, 3177, 1898, 3200, 1936, 3224, 1968, 3250, 2010, 3248, 2011, 
         3277, 2043, 3302, 2078, 3329, 2121, 3358, 2161, 3356, 2162, 3385, 
         2203, 3414, 2242, 3441, 2280, 3439, 2281, 3470, 2325, 3497, 2361, 
         3526, 2402, 3524, 2403, 3551, 2439, 3579, 2482, 3606, 2519, 3604, 
         2520, 3631, 2554, 3655, 2588, 3678, 2621, 3676, 2622, 3703, 2654, 
         3723, 2681, 3722, 2682, 3743, 2712, 3766, 2739, 3784, 2763, 3782, 
         2764, 3802, 2787, 3819, 2812, 3817, 2813, 3838, 2839, 3859, 2865, 
         3857, 2866, 3875, 2894, 3874, 2895, 3898, 2924, 3918, 2954, 3917, 
         2955, 3940, 2988, 3939, 2989, 3964, 3023, 3963, 3024}],
        "0.8`"],
       Annotation[#, 0.8, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1684, 1685, 1689, 3059, 1728, 3077, 1755, 1780, 1783, 3117, 
         1815, 3139, 1841, 1876, 1879, 3183, 1906, 3206, 1945, 1977, 1980, 
         3258, 2021, 3285, 2055, 2092, 2095, 3338, 2135, 2178, 2181, 3398, 
         2220, 2261, 2263, 3453, 2302, 2346, 2347, 3510, 2384, 2426, 2427, 
         2464, 2465, 2508, 2509, 2543, 2544, 2579, 2580, 2615, 2616, 2647, 
         3696, 2648, 3697, 2649, 3698, 2650, 3699, 2651, 3700, 2618, 3672, 
         2617, 3673, 2585, 3651, 2584, 3652, 2552, 3628, 2551, 3629, 2516, 
         3600, 2515, 3601, 2479, 3575, 2478, 3576, 2437, 3548, 2436, 3549, 
         2399, 3521, 2359, 3494, 2358, 3495, 2322, 3467, 2278, 3436, 2277, 
         3437, 2240, 3412, 2200, 3381, 2199, 3382, 2159, 3354, 2116, 3324, 
         2115, 3325, 2076, 3300, 2041, 3275, 2007, 3244, 2006, 3245, 1964, 
         3221, 1934, 3198, 1894, 3173, 1892, 3174, 1868, 3154, 1833, 3132, 
         1806, 3110, 1804, 3111, 1774, 3092, 1750, 3074, 1721, 3054, 1719, 
         3055, 1722}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1812, 1810, 3136, 1838, 3158, 1873, 3180, 1901, 1940, 1942, 
         3228, 1974, 3255, 2018, 3282, 2052, 2087, 2089, 3336, 2132, 3367, 
         2175, 3395, 2217, 2255, 2258, 3451, 2298, 3485, 2343, 2377, 2380, 
         3541, 2423, 3565, 2460, 2501, 2504, 3621, 2540, 3646, 2575, 2608, 
         2611, 3694, 2643, 3719, 2674, 2702, 2704, 3761, 2734, 2758, 2761, 
         3800, 2785, 2807, 2810, 3836, 2837, 2861, 2863, 3873, 2891, 2921, 
         2922, 3916, 2951, 2984, 2985, 3962, 3020}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1835, 3134, 1836, 3156, 1870, 3178, 1899, 3202, 1939, 3226, 
         1966, 3223, 1967, 3249, 2012, 3278, 2044, 3304, 2081, 3331, 2119, 
         3328, 2120, 3357, 2163, 3387, 2206, 3416, 2244, 3443, 2282, 3440, 
         2283, 3471, 2326, 3499, 2364, 3528, 2404, 3525, 2405, 3552, 2440, 
         3581, 2485, 3608, 2521, 3605, 2522, 3632, 2555, 3657, 2591, 3680, 
         2623, 3677, 2624, 3704, 2655, 3725, 2685, 3746, 2713, 3744, 2714, 
         3767, 2740, 3786, 2765, 3783, 2766, 3803, 2788, 3821, 2814, 3818, 
         2815, 3839, 2840, 3860, 2867, 3858, 2868, 3876, 2896, 3900, 2925, 
         3899, 2926, 3919, 2956, 3942, 2990, 3941, 2991, 3965, 3025}],
        "0.6`"],
       Annotation[#, 0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1687, 3040, 1688, 1727, 1730, 3078, 1757, 3096, 1782, 1814, 
         1817, 3140, 1843, 3159, 1878, 1905, 1908, 3207, 1946, 1979, 1982, 
         3259, 2022, 3286, 2056, 2094, 2097, 3339, 2136, 2180, 2182, 3399, 
         2221, 2262, 2264, 2303, 2305, 3488, 2348, 2385, 2386, 2428, 2429, 
         2466, 2467, 2510, 2511, 2545, 3624, 2546, 2547, 2581, 3648, 2582, 
         3649, 2583, 3650, 2549, 3625, 2548, 3626, 2550, 3627, 2514, 3598, 
         2513, 3599, 2477, 3573, 2476, 3574, 2435, 3546, 2434, 3547, 2398, 
         3519, 2397, 3520, 2357, 3493, 2321, 3465, 2320, 3466, 2276, 3434, 
         2275, 3435, 2239, 3411, 2198, 3379, 2197, 3380, 2158, 3353, 2114, 
         3322, 2113, 3323, 2075, 3299, 2040, 3274, 2005, 3242, 2004, 3243, 
         1963, 3220, 1933, 3196, 1932, 3197, 1893, 3172, 1867, 3153, 1832, 
         3130, 1830, 3131, 1805, 3109, 1773, 3091, 1749, 3072, 1747, 3073, 
         1720, 3053, 1718}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1902, 1900, 3203, 1941, 3227, 1971, 3254, 2017, 2047, 2051, 
         3310, 2088, 3335, 2130, 2172, 2174, 3394, 2216, 3426, 2256, 3450, 
         2297, 2340, 2342, 3509, 2378, 3540, 2422, 2457, 2459, 3596, 2502, 
         3620, 2539, 2572, 2574, 3671, 2609, 3693, 2642, 2671, 2673, 3737, 
         2703, 3760, 2733, 2756, 2759, 3799, 2784, 2805, 2808, 3835, 2836, 
         3856, 2860, 2888, 2890, 3896, 2920, 2948, 2950, 3938, 2983, 3017, 
         3019}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1937, 3201, 1938, 3225, 1969, 3252, 2015, 3280, 2046, 3307, 
         2079, 3303, 2080, 3330, 2122, 3360, 2166, 3389, 2204, 3386, 2205, 
         3415, 2243, 3442, 2284, 3473, 2329, 3501, 2362, 3498, 2363, 3527, 
         2406, 3554, 2443, 3583, 2483, 3580, 2484, 3607, 2523, 3634, 2558, 
         3659, 2589, 3656, 2590, 3679, 2625, 3706, 2658, 3727, 2683, 3724, 
         2684, 3745, 2715, 3769, 2743, 3788, 2767, 3785, 2768, 3804, 2789, 
         3823, 2816, 3820, 2817, 3840, 2841, 3861, 2869, 3879, 2897, 3877, 
         2898, 3901, 2927, 3922, 2957, 3920, 2958, 3943, 2992, 3968, 3026, 
         3966, 3027}],
        "0.4`"],
       Annotation[#, 0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1691, 3041, 1693, 3060, 1729, 1756, 1759, 3097, 1785, 3118, 
         1816, 1842, 1845, 3160, 1880, 1907, 1910, 3208, 1947, 1981, 1983, 
         3260, 2023, 3287, 2057, 2096, 2098, 2137, 2139, 3369, 2183, 2222, 
         2224, 3428, 2265, 2304, 2306, 2349, 2350, 2387, 2388, 2430, 2431, 
         2468, 3567, 2469, 3568, 2470, 2471, 2512, 3597, 2473, 3569, 2472, 
         3570, 2474, 3571, 2475, 3572, 2433, 3544, 2432, 3545, 2396, 3517, 
         2395, 3518, 2356, 3491, 2355, 3492, 2319, 3463, 2318, 3464, 2274, 
         3433, 2238, 3409, 2237, 3410, 2196, 3378, 2157, 3351, 2156, 3352, 
         2112, 3320, 2111, 3321, 2074, 3298, 2039, 3273, 2003, 3240, 2002, 
         3241, 1962, 3219, 1931, 3194, 1930, 3195, 1891, 3171, 1866, 3151, 
         1865, 3152, 1831, 3129, 1803, 3108, 1772, 3089, 1770, 3090, 1748, 
         3071, 1717, 3052, 1716}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{1972, 1970, 3253, 2016, 3281, 2049, 3309, 2086, 2125, 2129, 
         3366, 2173, 3393, 2215, 3425, 2254, 2293, 2296, 3484, 2341, 3508, 
         2376, 2419, 2421, 3564, 2458, 3595, 2500, 2536, 2538, 3645, 2573, 
         3670, 2607, 2639, 2641, 3718, 2672, 3736, 2701, 2730, 2732, 3781, 
         2757, 3798, 2783, 2803, 2806, 3834, 2835, 3855, 2859, 2886, 2889, 
         3895, 2919, 2946, 2949, 3937, 2982, 3015, 3018}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2013, 3251, 2014, 3279, 2045, 3306, 2084, 3333, 2124, 3363, 
         2164, 3359, 2165, 3388, 2207, 3418, 2247, 3445, 2286, 3476, 2327, 
         3472, 2328, 3500, 2365, 3530, 2409, 3556, 2441, 3553, 2442, 3582, 
         2486, 3610, 2526, 3636, 2556, 3633, 2557, 3658, 2592, 3682, 2628, 
         3708, 2656, 3705, 2657, 3726, 2686, 3748, 2718, 3771, 2741, 3768, 
         2742, 3787, 2769, 3806, 2792, 3825, 2818, 3822, 2819, 3841, 2842, 
         3863, 2872, 3881, 2899, 3878, 2900, 3902, 2928, 3924, 2959, 3921, 
         2960, 3944, 2993, 3970, 3028, 3967, 3029}],
        "0.2`"],
       Annotation[#, 0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1715, 3051, 1712, 3050, 1714, 3070, 1746, 3088, 1771, 3107, 
         1801, 3106, 1802, 3128, 1829, 3150, 1863, 3149, 1864, 3170, 1890, 
         3193, 1928, 3192, 1929, 3218, 1961, 3239, 441, 3272, 2038, 3297, 
         2072, 3296, 2073, 3319, 2110, 3350, 2154, 3349, 2155, 3377, 2195, 
         3408, 2235, 3407, 2236, 3432, 2272, 3431, 2273, 3462, 2316, 3461, 
         2317, 3490, 2353, 3489, 2354, 3516, 2394, 3515, 2393, 3514, 2392, 
         3513, 841, 2391, 3512, 2390, 3511, 2389, 2352, 2351, 2308, 2307, 
         2267, 2266, 2225, 2223, 2184, 3370, 2141, 2138, 2099, 3312, 2060, 
         2058, 2024, 421, 1948, 3209, 1912, 1909, 1881, 3161, 1847, 1844, 
         1818, 3119, 1787, 1784, 1758, 3079, 1732, 3061, 1696, 1692, 1690}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2050, 2048, 3308, 2085, 3334, 2127, 3365, 2171, 2210, 2214, 
         3424, 2253, 3449, 2295, 3483, 2339, 2372, 2375, 3539, 2420, 3563, 
         2456, 2497, 2499, 3619, 2537, 3644, 2571, 2604, 2606, 3692, 2640, 
         3717, 2670, 2698, 2700, 3759, 2731, 3780, 2755, 2780, 2782, 3816, 
         2804, 3833, 2834, 2856, 2858, 3872, 2887, 3894, 2918, 2944, 2947, 
         3936, 2981, 3013, 3016}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2082, 3305, 2083, 3332, 2123, 3362, 2169, 3391, 2209, 3421, 
         2245, 3417, 2246, 3444, 2285, 3475, 2332, 3503, 2367, 3533, 2407, 
         3529, 2408, 3555, 2444, 3585, 2489, 3612, 2524, 3609, 2525, 3635, 
         2559, 3661, 2595, 3684, 2626, 3681, 2627, 3707, 2659, 3729, 2689, 
         3750, 2716, 3747, 2717, 3770, 2744, 3790, 2772, 3808, 2790, 3805, 
         2791, 3824, 2820, 3843, 2845, 3865, 2870, 3862, 2871, 3880, 2901, 
         3904, 2931, 3926, 2961, 3923, 2962, 3945, 2994, 3972, 3030, 3969, 
         3031}],
        "0"],
       Annotation[#, 0, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1694, 3042, 1695, 1731, 1734, 3080, 1760, 1786, 1789, 3120, 
         1819, 1846, 1849, 3162, 1882, 1911, 1914, 3210, 1949, 1984, 1986, 
         3261, 2025, 2059, 2061, 3313, 2100, 2140, 2142, 2185, 2186, 2226, 
         2227, 2268, 2269, 2309, 3454, 2310, 3455, 2311, 3456, 2312, 3457, 
         2313, 3458, 2314, 3459, 2315, 3460, 2271, 3429, 2270, 3430, 2234, 
         3405, 2233, 3406, 2194, 3375, 2193, 3376, 2153, 3347, 2152, 3348, 
         2109, 3318, 2071, 3294, 2070, 3295, 2037, 3271, 2001, 3237, 2000, 
         3238, 1960, 3217, 1927, 3190, 1926, 3191, 1889, 3169, 1862, 3147, 
         1861, 3148, 1828, 3127, 1800, 3104, 1799, 3105, 1769, 3087, 1745, 
         3068, 1744, 3069, 1713, 3049, 1711}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2128, 2126, 3364, 2170, 3392, 2212, 3423, 2252, 2289, 2294, 
         3482, 2338, 3507, 2374, 3538, 2418, 2452, 2455, 3594, 2498, 3618, 
         2535, 2568, 2570, 3669, 2605, 3691, 2638, 2667, 2669, 3735, 2699, 
         3758, 2729, 2752, 2754, 3797, 2781, 3815, 2802, 2831, 2833, 3854, 
         2857, 3871, 2885, 2915, 2917, 3915, 2945, 3935, 2980, 3011, 3014}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2167, 3361, 2168, 3390, 2208, 3420, 2250, 3447, 2288, 3479, 
         2330, 3474, 2331, 3502, 2366, 3532, 2412, 3558, 2446, 3588, 2487, 
         3584, 2488, 3611, 2527, 3638, 2562, 3663, 2593, 3660, 2594, 3683, 
         2629, 3710, 2662, 3731, 2687, 3728, 2688, 3749, 2719, 3773, 2747, 
         3792, 2770, 3789, 2771, 3807, 2793, 3826, 2821, 3845, 2843, 3842, 
         2844, 3864, 2873, 3883, 2904, 3906, 2929, 3903, 2930, 3925, 2963, 
         3947, 2997, 3974, 3032, 3971, 3033}],
        RowBox[{"-", "0.2`"}]],
       Annotation[#, -0.2, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1697, 3043, 1698, 1733, 1736, 3081, 1761, 1788, 1791, 3121, 
         1820, 1848, 1851, 3163, 1883, 1913, 1916, 3211, 1950, 1985, 1987, 
         2026, 2027, 3288, 2062, 2101, 2102, 2143, 2144, 2187, 3371, 2188, 
         2189, 2228, 3400, 2229, 3401, 2230, 3402, 2231, 3403, 2232, 3404, 
         2191, 3372, 2190, 3373, 2192, 3374, 2151, 3345, 2150, 3346, 2108, 
         3316, 2107, 3317, 2069, 3293, 2036, 3269, 2035, 3270, 1999, 3235, 
         1998, 3236, 1959, 3216, 1925, 3188, 1924, 3189, 1888, 3168, 1860, 
         3145, 1859, 3146, 1827, 3126, 1798, 3102, 1797, 3103, 1768, 3086, 
         1743, 3066, 1742, 3067, 1710, 3048, 1709}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2213, 2211, 3422, 2251, 3448, 2291, 3481, 2337, 2370, 2373, 
         3537, 2417, 3562, 2454, 3593, 2496, 2532, 2534, 3643, 2569, 3668, 
         2603, 2635, 2637, 3716, 2668, 3734, 2697, 2726, 2728, 3779, 2753, 
         3796, 2779, 3814, 2801, 2829, 2832, 3853, 2855, 2882, 2884, 3893, 
         2916, 3914, 2943, 2977, 2979, 3961, 3012}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2248, 3419, 2249, 3446, 2287, 3478, 2335, 3505, 2369, 3535, 
         2410, 3531, 2411, 3557, 2445, 3587, 2492, 3614, 2529, 3640, 2560, 
         3637, 2561, 3662, 2596, 3686, 2632, 3712, 2660, 3709, 2661, 3730, 
         2690, 3752, 2722, 3775, 2745, 3772, 2746, 3791, 2773, 3809, 2794, 
         3828, 2824, 3847, 2846, 3844, 2847, 3866, 2874, 3885, 2902, 3882, 
         2903, 3905, 2932, 3927, 2964, 3949, 2995, 3946, 2996, 3973, 3034}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2972, 2971, 3957, 3007}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{3003, 3955, 3005, 3979, 3039}],
        RowBox[{"-", "0.4`"}]],
       Annotation[#, -0.4, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1699, 3044, 1700, 1735, 1737, 3082, 1762, 1790, 1792, 3122, 
         1821, 1850, 1852, 3164, 1884, 1915, 1917, 1951, 1952, 1988, 1989, 
         3262, 2028, 2063, 3289, 2064, 2065, 2103, 2104, 2145, 3340, 2146, 
         3341, 2147, 3342, 2148, 3343, 2149, 3344, 2106, 3314, 2105, 3315, 
         2067, 3290, 2066, 3291, 2068, 3292, 2034, 3268, 1997, 3233, 1996, 
         3234, 1958, 3214, 1957, 3215, 1923, 3186, 1922, 3187, 1887, 3167, 
         1858, 3143, 1857, 3144, 1826, 3125, 1796, 3100, 1795, 3101, 1767, 
         3085, 1741, 3064, 1740, 3065, 1708, 3047, 1707}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2292, 2290, 3480, 2336, 3506, 2371, 3536, 2415, 2450, 2453, 
         3592, 2495, 3617, 2533, 3642, 2567, 2600, 2602, 3690, 2636, 3715, 
         2666, 2694, 2696, 3757, 2727, 3778, 2751, 3795, 2778, 2798, 2800, 
         3832, 2830, 3852, 2854, 2880, 2883, 3892, 2914, 3913, 2942, 2975, 
         2978, 3960, 3010}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2333, 3477, 2334, 3504, 2368, 3534, 2413, 3560, 2449, 3590, 
         2490, 3586, 2491, 3613, 2528, 3639, 2563, 3665, 2599, 3688, 2630, 
         3685, 2631, 3711, 2663, 3732, 2691, 3754, 2720, 3751, 2721, 3774, 
         2748, 3793, 2774, 3811, 2797, 3830, 2822, 3827, 2823, 3846, 2848, 
         3867, 2875, 3887, 2905, 3884, 2906, 3907, 2933, 3928, 2965, 3951, 
         2998, 3948, 2999, 3975, 3035}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[LineBox[{2912, 2911, 3911, 2939, 3933, 2970, 3956, 3006}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2935, 3910, 2937, 3932, 2969, 3954, 3004, 3978, 3038}],
        RowBox[{"-", "0.6`"}]],
       Annotation[#, -0.6, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1701, 1702, 1703, 3062, 1738, 1763, 1764, 3098, 1793, 1822, 
         1823, 1853, 1854, 3165, 1885, 1918, 1919, 1953, 1954, 1990, 3229, 
         1991, 1992, 2029, 3263, 2030, 3264, 2031, 3265, 2032, 3266, 2033, 
         3267, 1994, 3230, 1993, 3231, 1995, 3232, 1956, 3212, 1955, 3213, 
         1921, 3184, 1920, 3185, 1886, 3166, 1856, 3141, 1855, 3142, 1825, 
         3123, 1824, 3124, 1794, 3099, 1766, 3083, 1765, 3084, 1739, 3063, 
         1705, 3045, 1704, 3046, 1706}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2416, 2414, 3561, 2451, 3591, 2494, 3616, 2531, 2565, 2566, 
         3667, 2601, 3689, 2634, 3714, 2665, 2693, 2695, 3756, 2725, 3777, 
         2750, 2776, 2777, 3813, 2799, 3831, 2828, 3851, 2853, 2879, 2881, 
         3891, 2913, 3912, 2941, 2974, 2976, 3959, 3009}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2447, 3559, 2448, 3589, 2493, 3615, 2530, 3641, 2564, 3666, 
         2597, 3664, 2598, 3687, 2633, 3713, 2664, 3733, 2692, 3755, 2723, 
         3753, 2724, 3776, 2749, 3794, 2775, 3812, 2795, 3810, 2796, 3829, 
         2825, 3848, 2849, 3868, 2876, 3888, 2907, 3886, 2908, 3908, 2934, 
         3929, 2966, 3952, 3000, 3950, 3001, 3976, 3036}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2827, 2826, 3850, 2852, 3870, 2878, 3890, 2910, 2938, 2940, 
         3934, 2973, 3958, 3008}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ], 
      TagBox[
       TooltipBox[
        LineBox[{2850, 3849, 2851, 3869, 2877, 3889, 2909, 3909, 2936, 3931, 
         2967, 3930, 2968, 3953, 3002, 3977, 3037}],
        RowBox[{"-", "0.8`"}]],
       Annotation[#, -0.8, "Tooltip"]& ]}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-2., 2.}, {-2., 2.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1569570999]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18664],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Full",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Full"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DataReversed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataReversed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LayerSizeFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LayerSizeFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25547]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with DataRange",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=DataRange"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->105580706],

Cell[TextData[ButtonBox["Graphics Coordinates",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsCoordinates"]], "MoreAbout",
 CellID->577527233],

Cell[TextData[ButtonBox["Plotting and Image Regions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingAndImageRegions"]], "MoreAbout",
 CellID->905401757],

Cell[TextData[ButtonBox["Plotting Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PlottingOptions"]], "MoreAbout",
 CellID->62348015]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DataRange - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 28.1615374}", "context" -> "System`", 
    "keywords" -> {
     "range of data", "range of data values", "rescale values", 
      "structured data range", "regular data range", 
      "height values data range", "data domain", "data region"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "DataRange is an option for functions such as ListPlot and \
ListDensityPlot, that specifies what range of actual coordinates the data \
should be assumed to occupy. ", "synonyms" -> {"data range"}, "title" -> 
    "DataRange", "type" -> "Symbol", "uri" -> "ref/DataRange"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5233, 177, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->62089001]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 161295, 2985}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1801, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2424, 68, 47, 1, 70, "ObjectName",
 CellID->31321],
Cell[2474, 71, 818, 24, 70, "Usage",
 CellID->32606]
}, Open  ]],
Cell[CellGroupData[{
Cell[3329, 100, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3807, 117, 356, 14, 70, "Notes",
 CellID->101708928],
Cell[4166, 133, 646, 24, 70, "Notes",
 CellID->140086382],
Cell[4815, 159, 381, 13, 70, "Notes",
 CellID->993315467]
}, Closed]],
Cell[CellGroupData[{
Cell[5233, 177, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->62089001],
Cell[CellGroupData[{
Cell[5617, 191, 148, 5, 70, "ExampleSection",
 CellID->222246612],
Cell[5768, 198, 260, 9, 70, "ExampleText",
 CellID->92921393],
Cell[6031, 209, 283, 10, 70, "Input",
 CellID->287939091],
Cell[CellGroupData[{
Cell[6339, 223, 107, 3, 28, "Input",
 CellID->955528766],
Cell[6449, 228, 1976, 41, 127, "Output",
 CellID->140892542]
}, Open  ]],
Cell[8440, 272, 181, 6, 70, "ExampleText",
 CellID->16825853],
Cell[CellGroupData[{
Cell[8646, 282, 220, 7, 70, "Input",
 CellID->243350036],
Cell[8869, 291, 2028, 42, 127, "Output",
 CellID->150262993]
}, Open  ]],
Cell[10912, 336, 125, 3, 70, "ExampleDelimiter",
 CellID->368480152],
Cell[11040, 341, 245, 9, 70, "ExampleText",
 CellID->1850560363],
Cell[11288, 352, 468, 16, 70, "Input",
 CellID->362361440],
Cell[CellGroupData[{
Cell[11781, 372, 380, 13, 28, "Input",
 CellID->2092582835],
Cell[12164, 387, 24889, 412, 165, "Output",
 Evaluatable->False,
 CellID->270166610]
}, Open  ]],
Cell[CellGroupData[{
Cell[37090, 804, 385, 13, 70, "Input",
 CellID->1336285016],
Cell[37478, 819, 119623, 2022, 70, "Output",
 CellID->1569570999]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[157162, 2848, 311, 9, 70, "SeeAlsoSection",
 CellID->18664],
Cell[157476, 2859, 961, 35, 70, "SeeAlso",
 CellID->25547]
}, Open  ]],
Cell[CellGroupData[{
Cell[158474, 2899, 305, 8, 70, "RelatedLinksSection"],
Cell[158782, 2909, 363, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[159182, 2926, 319, 9, 70, "MoreAboutSection",
 CellID->105580706],
Cell[159504, 2937, 151, 3, 70, "MoreAbout",
 CellID->577527233],
Cell[159658, 2942, 161, 3, 70, "MoreAbout",
 CellID->905401757],
Cell[159822, 2947, 142, 3, 70, "MoreAbout",
 CellID->62348015]
}, Open  ]],
Cell[159979, 2953, 29, 0, 70, "History"],
Cell[160011, 2955, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

