(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23615,        717]
NotebookOptionsPosition[     20011,        596]
NotebookOutlinePosition[     21360,        634]
CellTagsIndexPosition[     21275,        629]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"DateList" :> Documentation`HelpLookup["paclet:ref/DateList"], 
         "AbsoluteTime" :> 
         Documentation`HelpLookup["paclet:ref/AbsoluteTime"], "DateString" :> 
         Documentation`HelpLookup["paclet:ref/DateString"], "DateTicksFormat" :> 
         Documentation`HelpLookup["paclet:ref/DateTicksFormat"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"DateList\"\>", 
      2->"\<\"AbsoluteTime\"\>", 3->"\<\"DateString\"\>", 
      4->"\<\"DateTicksFormat\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DateFunction", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DateFunction",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DateFunction"]], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["DateListPlot",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DateListPlot"]], "InlineFormula"],
     " which specifies how dates given as input should be converted to date \
lists."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A setting such as ",
 Cell[BoxData[
  RowBox[{"DateFunction", "->", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      ButtonBox["DateList",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DateList"], "[", 
      RowBox[{"#", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}], "&"}], ")"}]}]], 
  "InlineFormula"],
 " specifies that a sequence of elements ",
 Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
 " should be extracted from each date.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->80984464]
}], "Notes",
 CellID->1067943069],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"DateFunction", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " automatically converts standard non-ambiguous dates."
}], "Notes",
 CellID->149400301]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->169752153],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->479271410],

Cell[TextData[{
 "Prepend a year to create dates from ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["month", "TI"], ",", 
    StyleBox["day", "TI"]}], "}"}]], "InlineFormula"],
 " lists:"
}], "ExampleText",
 CellID->905026462],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "1"}], "}"}], ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "10"}], "}"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "20"}], "}"}], ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "24"}], "}"}], ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"11", ",", "5"}], "}"}], ",", "15"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"11", ",", "15"}], "}"}], ",", "20"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70487484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"DateFunction", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", "2006", "}"}], ",", "#"}], "]"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13895297],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWk1u1DAU9kziGYQoArW0M7u5AEdALBCwYolYjyqkdgFFpTdgCwdAYoWA
FTsqOAAbkEbqljUXSf0bO89OYs8krjP1SBPHzvN7n9+z/dlOni3Pjl6+Wp4d
Hy4XT0+Xb46OD98unpyckqJshBA6J/93M0TuC3LH/udFQVLzeoNcMyKQkXRM
UpSzYvHLRemYpDlJZ63SmZCmT+eN0hl4uq/VRvSmYD801mQmQsbUhNCUXqdl
PS4gxDKgk+Vzla9apTUOPLThRm309p6HtglAAnXtNeiy+W5qaTvtJCOaduA5
KLEft+eAd3jjNQA1dfOevQj1+7S7Wy/qY76qVY8suBrjx+q/XEcgx7XwHAbo
mAYsPdPuq9r6EyBNb2ftNRr9uaf7CPYoXGhzkyzFUBLktT5k4IJ1mdcmZqe1
Rr1VG7ZKzZ3qOo04Q8sdS3uqY0my0k6h+onOKLJc9lXJS7cKk1NknGj5bZDn
/a+OGydCmrb6cxlYc7TlWiu/frl4+ODjh/e/7dHoMW+b5+vQMg7FBOjjR59U
XA56Rqj7s+pd6b2/f/6fvP7x6+c/4b3VaiXq3vfM+3jDnOe3xa7uYzULrW+l
GsGdIG3YNispDnFYGWocqnsfudeCzNyPbXNNaKyAWnBwjlEsuRsQV1bOuxDP
i+ffOBl646n2gK78o3gwpH+G0H86GkMiQdpaMXFkPFZSHOKwMtQ4mHvwPNia
m81gNWctvghusrxiy8X6iBrmWHkS64ZGcWUbGiz0atwIsW0w83M0iim78c2m
qBIvxjQPbJuVFIc4rAw1Dpb3Zg1zX49zXQsb+aDw3VG6oZLrBRde9N1DWnjR
cprvu6P33Tk6MVFxhacLQW3rzGd71zfUET8MK3eL6hieO1tdJy7cmhqv0Fq3
ceLW1Lh0b1v8cbtujDm009aQOFyYsi1vYcZY2q+Xhu0Bxvtz+EVDGEbU37cP
cSRvm5UUhzisDDUOidmiYbbk+yvEkc4847aS4hCHle7jkAfnHb50lids/Hpd
Zj9mF5dnLNyoiIR+5opqsCgWVOV9f9PKcfGTGobLC7HpvcDIcXnqU/G2y7fb
NK++ObZx1HdWVPft8iZXNLoEvrGyHw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24798404]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->149708174],

Cell["Interpret dates indexed by a week number:", "ExampleText",
 CellID->31755341],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Sin", "[", 
        RowBox[{"i", "/", "Pi"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "50"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45917260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"DateFunction", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"DateList", "[", 
       RowBox[{"{", 
        RowBox[{"2006", ",", "1", ",", 
         RowBox[{"1", "+", 
          RowBox[{"#", "*", "7"}]}]}], "}"}], "]"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->353594224],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WkuPDUEU7rl9+z6YYYwMgzHGIPwCj4RYCFYiFmJ9iYQFI4y1NeEHSEi8
/4AJKysbkklsrf2Rqx7ddaq+rup69L0zydx+VX/fd86px6mqvjbauHf3wWjj
/p3R6tXHo0f37t95snpl/TG7lc9kWbbJ/p8tZex8zM7E/+Z4zI7n2W/OLp+K
qwv8l1+OxV+2Ie6eLst02LFgx6wrbpd/y+yiw445O/bZ8XBZOi/vm6WPiIsz
/LeveGSBslhH06DeyOF5lzRKRhdaDhYRv7Ckrwobb02D86wNs1cnnxp3V5Vi
v11VWP51tMgZ9wHvEP8pgFvVjFWrpScBowjCxFLSknNw90SpmZfmNqyU16dE
6U3Hb39MNVpH4wgfRYkBPMlrUeCMb6WTwI8YA/u7eomdcD2E6x02xPzzpz8X
L7x+9fKnbGINePg+PhfNoEd4WSZPfO/hc44zI/wQ5j9e4LgweGtrSz5RIm7d
/MJOLl96ky14WBeFelVenchyClnUzjxCnV4CVCqO37/+rT/8+v3b37LdEptU
pZ6rE1S1FumzmqqewlIcWD+WgfOEUwOPIK/DPe1YY9TelM8pVsh0CJT0ncz7
S0bUJhnIz8iwAAyoCBmPljySsck2VLIAyKis2bY604vnm6VmOxMhz0ci37j+
rtSIyO7I25E+ffxRaohDskVyCJE64EEMj9QQIuND9lmNyBSJySHjmyvgnW60
f/F6NyDOgpeQIb1l7AbkWfBasy3xTIS8NxiZW5d1lTfYKyeTYymxlL3RWNzL
awJDWRKAkR4ff3+v5yxVHuPr+2WUqX7tC2YVyMbI1gcuzKHs3FTjwrkxW5OD
qiYlUQvVyUn7QWVJERGmXKfOUeXKvvja6l9WqHizK/ZMvOWyBvMVa/7SwIg1
TIyLhYp6TUFVm6tjGh9knoWKbI0vtCf21RB3y8ZRIY+sB+4+bAVsnTQyWTs5
5PR+LjRS29Hn+pBw3MYxri0yxdyHLCLZ1Vt8DI97lLbz6O26XdSwBqZF8DjE
4Viw/b7Mdwni0BaZkJYqy2+PvnDLTeQQX/oy3mm0iMG4noXwU1sfjjPKXjKr
GGuN8aprv1Njxzng9rJTbKbP3i73SLGxXS67fWxVna1WSny5Bq5T4Jw+fuzC
9QgfIrYctULvbcm+9Qg7kznTbDGiF/IaVw7M+WV7fNK7mozXAx8va/ik18QP
6ZV962zpvbJvfc2dXSyBrcMQX0cgk7Utkcu9BZypks3t8IXfNbVrkWgQu1It
qYvFm1b+3IS0CHVhLtqDWGIR6oAPEWtj1S+Haid/hzGZK8zuPIbfT5mL4nUH
7NsLqklFfRzEVQXc9/Jpwf2EI1Zt5JHDU9dCXHYt5JdYLSEZTw4cqKEpA6pW
X9rWh6a8B7Ex68HWOpvMXdX4asUFmbDWzkP00pmxVWMdnIcYtWOiVu2O+uTW
ErAvwz3D9H4a+y4fMtaUHZFM5K0wJlNZu1WAArTPgaJhcDwEMu2zKkgcmQuw
4WCwt4BBQdgZyAY3wx6w3pqzW/aOkdFdt/aAtb5Zgb+FYfaMaxGxDO4Wh5Hy
7ZCHtziMUOyOuH2WZ9bisDqFszAf08CqzMzAmlskrk9IBPc+98Cq0Oyz7fHb
BVrtK4zuffABMO13ehW9gvmHndm9b26Ona6vkHAER0/hWIQqfLvJqArXnOeV
SvwWqf5VCo75Qit9+aJAcddDaBwom2BjCXdDxbdHfb2Q2fPEqOUF1LdMxhyT
SuJXRr5voQTTQFmtL2azQnMp6H2lbqzPB3HfrhhX2WZ8rJQVxkw43QtCm7Fj
lqVar6lyf2cWZvHbwLLvxQFX9j6Iu65vCdN+s5n/fgnodg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29874954]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Define functions for interpreting ambiguous date strings:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->80984464],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<06/01/06\>\"", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<07/01/06\>\"", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<08/01/06\>\"", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<09/01/06\>\"", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<10/01/06\>\"", ",", "15"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<11/01/06\>\"", ",", "20"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98385114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"DateFunction", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"DateList", "[", 
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<Month\>\"", ",", "\"\<Day\>\"", ",", "\"\<YearShort\>\""}], 
          "}"}]}], "}"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->980938488],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW81uEzEQdvYnEdCipASJkhT1RRASFXDiABLiHCqk9gBFpU/ADQQPgMQJ
QU+9NWofgAtIkbj2zIss/tv1eNbO7obUm10cKWuPPTvzecY7Yzubx5OjvZev
Jkf7u5PtR4eTN3v7u2+3Hx4c0qawQwiZ0u+7W4TWE1rj32mS0PIpvYaU3JTl
Dm99wq4x40o/RPKQMGsl93n7FXoNaGNIyy6RFSI+A9DXkzQTEMh2yNsF/WHa
H6l+QoZze/tANkQZgDuEumuAg6A7MM2qG6b+SPUTcoMVPWQvi3Q2Cj5YxBjm
pG7MkRoijIOSCKBFLssSbOKQOIMAeJnmm1iGkbvy2NH4SA9JBCjYA9Fhpd0G
XUWnlWHh2I0cBk9jq/alZXh7nLFZfNBfcFbMk2u3TJiJFR/41LLr0MRjmjUR
1I+ffXYHY+ijO0OEMZQzLB+bmIRYzpvAgAHOMuXVQI5XnwWsOkZ0bBoTQDbO
zYaRESeWMzByrfHyqrTtWJZxkn+CUqyQbxPYgNF8bGRquXYl9wmn4tw4WJD9
mhnP3J+O4Pu337Ty6eMPMQKAcR3RW4jG9r9e0I/lje3WzkbIqIhPowc7XyTT
bS5nNptpuBSN58HI2C/o9PkoY6lfP/+8mByfn11oEuwIFG1EEGe0NnILBtVC
b8P6lqkfWt6d1vUERBjpmqVYGdCBps3t2Nqszfutmdrc+U1f9aerSrcRJr/2
y603Vh6P0Ecz9r27n1nGvuMcj1g3KokiFz9/dkwR0Qy9GCJjLl7cPipPu7eP
u/kD1+LpXtnn7OZGY++3ZlqyrX7L77wj53sRHlEt5ybFSHC2xP2VkeBYj049
cG4021rlylJ47LnRcuaSoSthG5Upl2mb6mjqXlfVkad9BG6mNu+3Zmprq9/0
vTWOvegXKhextyBLVkMjtKscjtFVQZOuX4rytBmDyttGDPY8bfg1qfo+TWCw
n0BXyIjJCpy+1IIBZmL+0KCZ2dYI0TRt4kwJrdsvMbLjMyzMv0y/CV1o3d0S
v/mM7E+7l3u6XJSZ3Z4uu1w5hfXMmNyv8V2nGHCGDkDZxkjRdm3eb83U1la/
+cy8KJ7aMrP30Qri8Wfa7dLm/dZMbe78FtWWL8UWJD05Fdf/NRp/eD8VZ2Ia
HvzGvQkNA7OF2jE9RvTI1k8x6Dm7DALdYvhdcEyvIbro3fKq754b72e734PX
p+dnF5p9y/wfhNHqjXtTfjzhTbY3+v/lSjp/AU48mC8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2217628]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"DateFunction", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"DateList", "[", 
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<Day\>\"", ",", "\"\<Month\>\"", ",", "\"\<YearShort\>\""}], 
          "}"}]}], "}"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->693595886],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztG8tu1DDQu3ES1MIdsa3UH0EcEHDiiDiHCqk9oFZtP4APgA+oBDeohNRj
1X4Al1ZaiWvP/ZHg2HEyO5usx97Ns460ceyMZ8Yz45mx432fnB18/pKcHe4n
e+9OkuODw/3TvbdHJ6IpmDDGrsTv63MmnlPxJH9XaSrK5Xsg7lOmypDlD0xd
HLzLyogIy4KMorxYuGH807yMDbABgDXh1bC6ZJJrFqtRoLuCACOU9aisa0AM
Z42TQ5wYIu4dh1jzkQU2bhyvDW+8ildQn5Q6hlAZqrBAnOPmNrKjYTNLrXOu
9GyISf0jmvZoeGh6i5YtYQpmtuxoIyMqPrPunDBpT/Wko7GFNA1SMdF0GGL+
MS5eCRVoOdH6mzVGw0OVdsvYiHOPhsfaZ24bqWMPsm0z+g77PaPJFfcwSlDn
Gxl0pgOd10SoPcjrVe06/9lEuzKBuuxQZ06XpfYXZJJx/1OUWyvec2lpb17/
gBoBcnnahzovDKMYjR47nD93tw+fkoub63u2I7HM5/Mcy4xUL6nOlmS1Soag
RaDcdaKN6rys94E2lHbhmxSYo6yraUINozne4OjGSslraiiU2tKUchn60nkt
8iwNjtW8ckYQPeNF6eX3r3+vXp5///bXTU/OvATSSsreLyTMxw8XghsRwd25
KSxiXcmsGYF7bjFwZ0pnaO3NHe/Rh0TJa8rLb3FUekdNXZpsezm89JNxQUm9
ylkyc6FijWXkq+NixTpcr6xX4XaKe3VxDtG2iyyKE8uoR5CKPSdjzNDq4u34
fMNYKXlNDYVSNytQ7OfQt5em/ZwhDnXDiVtWQIrPddQrduAzP2uKw05x2bze
TF1XVqRobI55zvQ3Eefw1/H27ND76+p65cxqkBKaPw1pqnKuDFxTj9vS/d7u
uvupTtTt41v3koHxpX0bKU87qFf4lESLkRZ+4x+XNxgrJa+poVDy3zT7Gvc6
4QXopbG4my5aRo+l0Skv/jum962PW35eU+6j4p1EWbVI0LuT6t68B5W7JGGx
95PL3MajZwC7qH1mWS/2hXSOU/AA98+ZWSJs+T8jeL8Rn5se2vtG8IV3tw+i
6eb6PoUWQJF+ef6acs79j2quiM+XsqnuJLjbnU3+AxHQSWg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->254991432]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"DateFunction", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"DateList", "[", 
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<YearShort\>\"", ",", "\"\<Month\>\"", ",", "\"\<Day\>\""}], 
          "}"}]}], "}"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->166013156],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWz9v1DAU911yV6B3VwYGRFupXwQxIGBCiAExhwqpHaCo9BOwgeADIDEU
ce3ExqlMTCytdFJX5n6RYMdx4jzbsfP3EteRzo7/vp/fs/1zXnJPg6O912+C
o/3dYOfJYfBub3/3/c7jg0Oc5Q0QQgv8+3AX4fsQ30W/RRjiWAxHOPRxhSGO
hzj2QDzNKUce6Tm60ETTj6qcpWeSco9Ly3CwchYjNCbhiKJKQlrmmaXJ7bp5
L37aCqGNWqTfMu9llLSKc2fqtkJdEf+0QGsfoB5E+WtCn0VHPzHrQcCzUVny
eqEe2O1M3spA26Yt5Zq+UWB0MuxTk/oCltsFpQyZZepGaqBfqdymtGuqm0oa
Va6XnmmXcA4a872F6vUmrhnTlro9toZ+braBx8Aak0Lt5VYh3Cljbj9MGVhW
zpg4r1zXnp0AqpRHJxLJCWeRGR2Ze8coZio6EzOa9DmNncwv8c2Xz39pPU5j
ujTU8LWsL8y7cY7OSQbyHj38FufeAz1ugfQdDaLNnPbRGkrw8DODYb44v3oV
nP4++xe3Wy6XmX7U6U1Z+ShJG2iCy8HNti2Wz2t+iOIlTKvWo3cundp72uoY
bZfm7NZPabbajW5h7GLeArDTNYxBPJ8Jz0UKPJ8+Lh7c/0pOHO3j8aIZASU8
f3aMEWFerjQjsoxbXj/zH38O3v4y4eV27NW1+dPQmvLCZE2x07bj7P5Ka9Ju
2ZVuuybtsVuYWW+UMNnFBtru00G0x60l0mhZXGMFSODuy/uBtWiotJP5Zczu
8vJyaOCbGDWXw/TLF6cxtxvhUXO5Bo2JbtIn7sq66QFz2rpv2L4DO7v1U5O2
2i37tAv3Xj0vdYslm0RT7vwCeVuKMA+B5J0M2f91/CzHkfJ1nqYk/JyOOSzL
QZClC2uiBgx1MTF8W9HuzHQ7e9ekAa9b43ZT+9TqtxvwmFllty6ut377n1eJ
pygnlvdKdVI/4LuyFcwY+fv6lTE0/+2J48r+SXN266c0W+3mmLksnpUxs7NR
B/G4t8F2SXN266e09uzG/++qZa9dHPHh9duNoRda8G1HQHjvP1LgIrC2Qf6W
Jg2/pE580TiL+LC8RDcmCLK6G4ManfyOvUP1afri/ApnEZ+efCbo/pHCbPE9
l9N/Rlmq/1NUCdHgPwJRuNE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->145961762]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateTicksFormat",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateTicksFormat"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DateFunction - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 32.5679002}", "context" -> "System`", 
    "keywords" -> {
     "custom date interpretation", "financial plots", "time series plots"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "DateFunction is an option for DateListPlot which specifies how dates \
given as input should be converted to date lists.", 
    "synonyms" -> {"date function"}, "title" -> "DateFunction", "type" -> 
    "Symbol", "uri" -> "ref/DateFunction"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5391, 168, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->169752153]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21132, 622}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 899, 19, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1522, 46, 1577, 37, 70, "ObjectNameGrid"],
Cell[3102, 85, 643, 19, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3782, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4260, 126, 802, 26, 70, "Notes",
 CellID->1067943069],
Cell[5065, 154, 289, 9, 70, "Notes",
 CellID->149400301]
}, Closed]],
Cell[CellGroupData[{
Cell[5391, 168, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->169752153],
Cell[CellGroupData[{
Cell[5776, 182, 148, 5, 70, "ExampleSection",
 CellID->479271410],
Cell[5927, 189, 239, 9, 70, "ExampleText",
 CellID->905026462],
Cell[6169, 200, 884, 31, 70, "Input",
 CellID->70487484],
Cell[CellGroupData[{
Cell[7078, 235, 325, 11, 28, "Input",
 CellID->13895297],
Cell[7406, 248, 1342, 26, 152, "Output",
 Evaluatable->False,
 CellID->24798404]
}, Open  ]],
Cell[8763, 277, 125, 3, 70, "ExampleDelimiter",
 CellID->149708174],
Cell[8891, 282, 83, 1, 70, "ExampleText",
 CellID->31755341],
Cell[8977, 285, 342, 12, 70, "Input",
 CellID->45917260],
Cell[CellGroupData[{
Cell[9344, 301, 401, 13, 28, "Input",
 CellID->353594224],
Cell[9748, 316, 2090, 38, 148, "Output",
 Evaluatable->False,
 CellID->29874954]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11887, 360, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[12111, 369, 149, 3, 70, "ExampleText",
 CellID->80984464],
Cell[12263, 374, 622, 19, 70, "Input",
 CellID->98385114],
Cell[CellGroupData[{
Cell[12910, 397, 455, 14, 70, "Input",
 CellID->980938488],
Cell[13368, 413, 1475, 28, 70, "Output",
 Evaluatable->False,
 CellID->2217628]
}, Open  ]],
Cell[CellGroupData[{
Cell[14880, 446, 455, 14, 70, "Input",
 CellID->693595886],
Cell[15338, 462, 1359, 26, 70, "Output",
 Evaluatable->False,
 CellID->254991432]
}, Open  ]],
Cell[CellGroupData[{
Cell[16734, 493, 455, 14, 70, "Input",
 CellID->166013156],
Cell[17192, 509, 1396, 27, 70, "Output",
 Evaluatable->False,
 CellID->145961762]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18649, 543, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[18968, 554, 971, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[19954, 592, 27, 0, 70, "History"],
Cell[19984, 594, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

