(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    162285,       4623]
NotebookOptionsPosition[    144483,       3998]
NotebookOutlinePosition[    146010,       4039]
CellTagsIndexPosition[    145923,       4034]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ListPlot" :> Documentation`HelpLookup["paclet:ref/ListPlot"], 
          "DateString" :> Documentation`HelpLookup["paclet:ref/DateString"], 
          "DateList" :> Documentation`HelpLookup["paclet:ref/DateList"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"ListPlot\"\>", 
       2->"\<\"DateString\"\>", 3->"\<\"DateList\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "Date & Time" :> 
          Documentation`HelpLookup["paclet:guide/DateAndTime"], 
          "New in 6.0: Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60DataVisualization"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Data Visualization\"\>", 
       2->"\<\"Date & Time\"\>", 3->"\<\"New in 6.0: Data Visualization\"\>", 
       4->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DateListPlot", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DateListPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DateListPlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["date", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["v", "TI"], 
            StyleBox["1", "TR"]]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["date", "TI"], 
            StyleBox["2", "TR"]], ",", 
           SubscriptBox[
            StyleBox["v", "TI"], 
            StyleBox["2", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]plots points with values ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["v", "i"], TraditionalForm]], "InlineMath"],
     " at a sequence of dates."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DateListPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DateListPlot"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["datespec", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots points with dates at equal intervals specified by \
",
     Cell[BoxData[
      StyleBox["datespec", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DateListPlot",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DateListPlot"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["list", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]plots several lists of values."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateListPlot"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " by default plots each value in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " as a separate point."
}], "Notes",
 CellID->35506798],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateListPlot"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{
     ButtonBox["Joined",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Joined"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " draws a line through the list of points. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->4948224]
}], "Notes",
 CellID->721546604],

Cell[TextData[{
 "Possible forms of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["date", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " include:",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->45081443]
}], "Notes",
 CellID->128543136],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["t", "TI"], Cell[
    "absolute time given as a single number", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["y", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["d", "TI"], ",", 
      StyleBox["h", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["s", "TI"]}], "}"}], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DateList",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
     " specification"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData[
      RowBox[{"{", 
       StyleBox["y", "TI"], "}"}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["y", "TI"], ",", 
        StyleBox["m", "TI"]}], "}"}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["y", "TI"], ",", 
        StyleBox["m", "TI"], ",", 
        StyleBox["d", "TI"]}], "}"}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"]
    }], "TableText"], Cell["shortened date list", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DateString",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
     " specification"
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->156973587],

Cell[TextData[{
 "In shortened date lists, omitted elements are taken to have default values \
",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", "1", ",", "1", ",", "0", ",", "0", ",", "0"}], 
   "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->553812165],

Cell[TextData[{
 "Possible forms of ",
 Cell[BoxData[
  StyleBox["datespec", "TI"]], "InlineFormula"],
 " include:",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->57868944]
}], "Notes",
 CellID->149856229],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["start", "TI"], ",", 
      StyleBox["end", "TI"]}], "}"}], Cell[TextData[{
     "dates from ",
     Cell[BoxData[
      StyleBox["start", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["end", "TI"]], "InlineFormula"],
     " in equal steps"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["start", "TI"], ",", 
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"], ",", 
      StyleBox["step", "TI"]}], "}"}], Cell[TextData[{
     "dates beginning with ",
     Cell[BoxData[
      StyleBox["start", "TI"]], "InlineFormula"],
     " in steps ",
     Cell[BoxData[
      StyleBox["step", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"], ",", 
      StyleBox["end", "TI"], ",", 
      StyleBox["step", "TI"]}], "}"}], Cell[TextData[{
     "dates ending with ",
     Cell[BoxData[
      StyleBox["end", "TI"]], "InlineFormula"],
     " in steps ",
     Cell[BoxData[
      StyleBox["step", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["start", "TI"], Cell[TextData[{
     "dates with steps determined by the form of ",
     Cell[BoxData[
      StyleBox["start", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->506900793],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["step", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  StyleBox["datespec", "TI"]], "InlineFormula"],
 " can be a ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["d", "TI"], ",", 
    StyleBox["h", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["s", "TI"]}], "}"}]], "InlineFormula"],
 " date list specification or any of the special forms ",
 Cell[BoxData["\"\<Year\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Quarter\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Month\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Week\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Day\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Hour\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Minute\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Second\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Millisecond\>\""], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->20622360]
}], "Notes",
 CellID->45469351],

Cell[TextData[{
 "If no explicit ",
 Cell[BoxData[
  StyleBox["step", "TI"]], "InlineFormula"],
 " is given, the step used will be the smallest time unit specified \
explicitly in ",
 Cell[BoxData[
  StyleBox["start", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->550442375],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DateListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateListPlot"]], "InlineFormula"],
 " has the same options as ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 ", with the following additions and changes:"
}], "Notes",
 CellID->15564970],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Axes",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Axes"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether to include axes", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DateFunction",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DateFunction"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to convert dates to standard form", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DateTicksFormat",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DateTicksFormat"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "format for date tick labels", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Frame",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Frame"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "whether to put a frame around the plot", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["GridLines",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/GridLines"], 
    RowBox[{"{", 
     RowBox[{
      ButtonBox["Automatic",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Automatic"], ",", 
      ButtonBox["None",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/None"]}], "}"}], Cell[
    "whether to include grid lines", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PlotRange",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/PlotRange"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "range of values to include", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->21418857],

Cell[TextData[{
 "All explicit ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " coordinates in ",
 Cell[BoxData[
  ButtonBox["Prolog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Prolog"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Epilog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Epilog"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Ticks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ticks"]], "InlineFormula"],
 ", etc. are taken to be dates.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->15484210]
}], "Notes",
 CellID->40588176]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->78083278],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->397673108],

Cell["Plot data with explicit date values:", "ExampleText",
 CellID->740468034],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "1"}], "}"}], ",", "10"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "15"}], "}"}], ",", "12"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "30"}], "}"}], ",", "15"}], "}"}], 
     ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "11", ",", "20"}], "}"}], ",", "20"}], "}"}]}], 
    "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98872995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->226265787],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1u1DAQdhJnF4mCSn8Wjj0hgXgFxAEBJ45Vz6FCag9QVPoMnOABkDjC
cuFGBQ/QSyutxJVzXyRM/JM4YydOyM8mkSPFv+NvnBl7ZuLkZXR29PpNdHZ8
GO29OI3eHR0fvt97fnIKTYFHCDmH+8M9AuUYSuw+j2PI9fQGpAEQBJD7kBPK
msVFRasPOYV8x0odCOqkd1FKHaDeLWU0SQoxu4iv0MwETR7pNqvMk3SejuME
gixAmKxOs3qeazJiuwZaWIqWFLdqoM3QTDDWZgmWSXZz07Mr9ZstSA9T1Hne
NUgPSYg/vDKBgrG0B0liHnfWJkl17+dRVRSUavvIKEOqzsDP7+AQzY4hhFIy
dlkVjp8h6qS4ax9RKs9NVUZ4VYUCjl2yNcSUqL5RIgk8lmlspi9cjGmWC0YL
jVSLSmMr7ToNBe9F836SHuqWkLX0BbuonaL2jVj3L1JXgVhzuG7ykDzNexzp
4RI5LCH3WKe+U7R1EWc759vXP08ef/708UKVtEK7banvNKT30iepPueD/SXM
+dnTLyOYM48TTt7+/P3rL1RXq9UjRgUFQfUQ1R+gulxJlaWkreViXjbedyGp
paFOeHOorGiyYO1xU3dyE8SFwOGI3c3VITvNTQHZaU6P1SjR48uWbXpBHG7j
ej9JQjV6gD6CfZuFt8V7yLhJ56tGAFX4Ih9aEu3ZvBjnf3V5rbr0Bs9dl7/z
4M6aTBvZaW6syGPRnH4CXGaRW7bAVnvbB+ce4grDiVBi8U0+vS6nwjfiuGvP
0jc/1W/azn2dlRiTFIaBzJHSKF7rr685jpjG51r//2uOI0Pk/SpaQuRtmesw
5DsU5LHsueLz7em9Ew2fdwe+Gn356liz2rce7etba/ywp852nLMW45SCk69D
dprDyM5D9+Al1/dGO0D5uhPpqdiOsSI7zY0VeSyao734Uv76I09jeTpla8/+
46LqN2ovM/1BKgKLV8/am/43ZqPn9YP9pfBLfuXZlp0L9zJrenV5DU38i7hc
baqu40KNfy/0xz9YU9G/kE1S4v0DdjEQmQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->34417414]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->209465802],

Cell["Plot monthly values starting in August 2000:", "ExampleText",
 CellID->3347631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "11"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"2000", ",", "8"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38513733],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1O3DAQdn52t5deWzblQCvQIlQElHPFoaI99Vj1HFAlOLQgyiMUTu0D
IPXYwgOA4AG4FGmlXnvui7gzjpNMJlk52fXS7G4ire2Z2N9njz1jZ5O34fHe
h4/h8f5uuPDmKDzc29/9vPD64AhUniOEuILf6ZyAsoSS+l1JCXmUPofUA+WJ
klYxRVGqS3xR2kVdx4PchVz4Sq2vnr7rsrYuabGsc5RbQhd0+27CIdppa1WI
K/pUj3yik2ho5cI+rJD6LM3Vn1P6HtGqWpi0koZa2yvgEh1WawBPYdscQ6Dy
JW07hdEyjWCp5GgH9qqdb+uSGcOUzBhp7TF0j8x70bzE442uWLtMRpky8h4E
aQ8ya2M921oTbDL2p4ldUblG+ojyhs6fydRL8ulDSM+hlpNIMe/PH7+h8O3r
bbSaPC6z1Ubkx4b7XHaU5Sj3+3fYp+1X33VdLo+DO5qbu19/Dz5d3lz/0TVB
3gnPUY6s3+/3dcsXTA5ijGgkhOOJoSWXsb5TayQc53xFhHrbB50YXdC3htgm
SKIE8iOpvWzr5Rl6Wbc0U4chY4BBsZgBfAkY0JdMDF2NI8QDxsDjYDFT6kvl
x1KVqdoMZ6Os3bl2Y47Gy2qAtCGz3sSjt9nSEULqLRyhvKUjpME7yWRbetbX
dFH0rTsy3e2KdgoTUroz0IjH5dH6aD+m2kcc3wxNp6/8PyTT6aq65U2nqeFn
wnR6qoM9Z22/sB87xnkevX/s0XcRz3qsp0j2xo8x37Vq0en0mOlHaiw9a5au
4y7An3TnDdhlIjV/9g1kHKmHtQB/Bjb1si7Wbf7zmVakxtKNpYdFyr45dqXt
SKD+9c7Erdybx3vmGu18X7/xTB4X/dYg/h6h2XsmBUm9l/aTU1rO7rnvEiq8
0y53P32HTuYrs3aDcfD6cOYDFZz5MmO+UKVBXyWMngrnH6jVdqo=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->173027490]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->338368658],

Cell["Join the points:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->4948224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "11"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"2000", ",", "8"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->222609142],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{3.1740768*^9, 1.}, {3.1767552*^9, 1.}, {3.1793472*^9, 2.}, {
     3.1820256*^9, 3.}, {3.1846176*^9, 5.}, {3.187296*^9, 8.}, {3.1899744*^9, 
     11.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  AxesOrigin->NCache[{3174076800, Automatic}, {3.1740768*^9, Automatic}],
  Frame->True,
  FrameTicks->{{{
      NCache[3176755200, 3.1767552*^9], 
      FormBox["\"Sep\"", TraditionalForm]}, {
      NCache[3182025600, 3.1820256*^9], 
      FormBox["\"Nov\"", TraditionalForm]}, {
      NCache[3187296000, 3.187296*^9], 
      FormBox["\"Jan\"", TraditionalForm]}, {
      NCache[3192393600, 3.1923936*^9], 
      FormBox["\"Mar\"", TraditionalForm]}, {
      NCache[3174076800, 3.1740768*^9], 
      FormBox["\"\"", TraditionalForm]}, {
      NCache[3179347200, 3.1793472*^9], 
      FormBox["\"\"", TraditionalForm]}, {
      NCache[3184617600, 3.1846176*^9], 
      FormBox["\"\"", TraditionalForm]}, {
      NCache[3189974400, 3.1899744*^9], 
      FormBox["\"\"", TraditionalForm]}}, Automatic, {{
      NCache[3176755200, 3.1767552*^9], 
      FormBox["\"\"", TraditionalForm]}, {
      NCache[3182025600, 3.1820256*^9], 
      FormBox["\"\"", TraditionalForm]}, {
      NCache[3187296000, 3.187296*^9], 
      FormBox["\"\"", TraditionalForm]}, {
      NCache[3192393600, 3.1923936*^9], 
      FormBox["\"\"", TraditionalForm]}, {
      NCache[3174076800, 3.1740768*^9], 
      FormBox["\"\"", TraditionalForm]}, {
      NCache[3179347200, 3.1793472*^9], 
      FormBox["\"\"", TraditionalForm]}, {
      NCache[3184617600, 3.1846176*^9], 
      FormBox["\"\"", TraditionalForm]}, {
      NCache[3189974400, 3.1899744*^9], 
      FormBox["\"\"", TraditionalForm]}}, Automatic},
  GridLines->NCache[{{{3176755200, 
       GrayLevel[0.8]}, {3182025600, 
       GrayLevel[0.8]}, {3187296000, 
       GrayLevel[0.8]}, {3192393600, 
       GrayLevel[0.8]}}, None}, {{{3.1767552*^9, 
       GrayLevel[0.8]}, {3.1820256*^9, 
       GrayLevel[0.8]}, {3.187296*^9, 
       GrayLevel[0.8]}, {3.1923936*^9, 
       GrayLevel[0.8]}}, None}],
  PlotRange->{{3.1740768*^9, 3.1899744*^9}, {1., 11.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->None]], "Output",
 ImageSize->{184, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->90646661]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->287749260],

Cell["Plot multiple datasets:", "ExampleText",
 CellID->189181803],

Cell[BoxData[
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "1"}], "}"}], ",", "10"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "15"}], "}"}], ",", "12"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "30"}], "}"}], ",", "15"}], "}"}], 
     ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "11", ",", "20"}], "}"}], ",", "20"}], "}"}]}], 
    "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->83736067],

Cell[BoxData[
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "5"}], "}"}], ",", "15"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "20"}], "}"}], ",", "8"}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "11", ",", "10"}], "}"}], ",", "5"}], "}"}], ",",
      " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "11", ",", "15"}], "}"}], ",", "1"}], "}"}]}], 
    "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->117138108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"data1", ",", "data2"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->681386578],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{3.3686496*^9, 10.}, {3.3698592*^9, 12.}, {3.3711552*^9, 15.}, {
     3.3729696*^9, 20.}}]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], 
    LineBox[{{3.3689952*^9, 15.}, {3.3702912*^9, 8.}, {3.3721056*^9, 5.}, {
     3.3725376*^9, 1.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  AxesOrigin->NCache[{3368649600, 0}, {3.3686496*^9, 0}],
  Frame->True,
  FrameTicks->{{Automatic, Automatic}, {{{
       NCache[3368736000, 3.368736*^9], 
       FormBox["\"Oct 02\"", TraditionalForm]}, {
       NCache[3369945600, 3.3699456*^9], 
       FormBox["\"Oct 16\"", TraditionalForm]}, {
       NCache[3371155200, 3.3711552*^9], 
       FormBox["\"Oct 30\"", TraditionalForm]}, {
       NCache[3372364800, 3.3723648*^9], 
       FormBox["\"Nov 13\"", TraditionalForm]}, {
       NCache[3369340800, 3.3693408*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3370550400, 3.3705504*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3371760000, 3.37176*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3372969600, 3.3729696*^9], 
       FormBox["\" \"", TraditionalForm]}}, {{
       NCache[3368736000, 3.368736*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3369945600, 3.3699456*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3371155200, 3.3711552*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3372364800, 3.3723648*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3369340800, 3.3693408*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3370550400, 3.3705504*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3371760000, 3.37176*^9], 
       FormBox["\" \"", TraditionalForm]}, {
       NCache[3372969600, 3.3729696*^9], 
       FormBox["\" \"", TraditionalForm]}}}},
  GridLines->NCache[{{{3368736000, 
       GrayLevel[0.8]}, {3369945600, 
       GrayLevel[0.8]}, {3371155200, 
       GrayLevel[0.8]}, {3372364800, 
       GrayLevel[0.8]}}, None}, {{{3.368736*^9, 
       GrayLevel[0.8]}, {3.3699456*^9, 
       GrayLevel[0.8]}, {3.3711552*^9, 
       GrayLevel[0.8]}, {3.3723648*^9, 
       GrayLevel[0.8]}}, None}],
  PlotRange->{{3.3686496*^9, 3.3729696*^9}, {0., 20.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->None]], "Output",
 ImageSize->{184, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->417810626]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->437997029],

Cell["Retrieve and plot a historical stock price:", "ExampleText",
 CellID->601746168],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"FinancialData", "[", 
   RowBox[{"\"\<IBM\>\"", ",", "\"\<Jan. 1, 2004\>\""}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->929039302],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->82391756]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[TextData[{
 "Dates given as ",
 Cell[BoxData[
  ButtonBox["AbsoluteTime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteTime"]], "InlineFormula"],
 " specifications:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->45081443],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3368649600", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3369859200", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3371155200", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3372969600", ",", "20"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->270635656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->77366686],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1u1DAQdhJnF4mCSn8Wjj0hgXgFxAEBJ45Vz6FCag9QVPoMnOABkDjC
cuFGBQ/QSyutxJVzXyRM/JM4YydOyM8mkSPFv+NvnBl7ZuLkZXR29PpNdHZ8
GO29OI3eHR0fvt97fnIKTYFHCDmH+8M9AuUYSuw+j2PI9fQGpAEQBJD7kBPK
msVFRasPOYV8x0odCOqkd1FKHaDeLWU0SQoxu4iv0MwETR7pNqvMk3SejuME
gixAmKxOs3qeazJiuwZaWIqWFLdqoM3QTDDWZgmWSXZz07Mr9ZstSA9T1Hne
NUgPSYg/vDKBgrG0B0liHnfWJkl17+dRVRSUavvIKEOqzsDP7+AQzY4hhFIy
dlkVjp8h6qS4ax9RKs9NVUZ4VYUCjl2yNcSUqL5RIgk8lmlspi9cjGmWC0YL
jVSLSmMr7ToNBe9F836SHuqWkLX0BbuonaL2jVj3L1JXgVhzuG7ykDzNexzp
4RI5LCH3WKe+U7R1EWc759vXP08ef/708UKVtEK7banvNKT30iepPueD/SXM
+dnTLyOYM48TTt7+/P3rL1RXq9UjRgUFQfUQ1R+gulxJlaWkreViXjbedyGp
paFOeHOorGiyYO1xU3dyE8SFwOGI3c3VITvNTQHZaU6P1SjR48uWbXpBHG7j
ej9JQjV6gD6CfZuFt8V7yLhJ56tGAFX4Ih9aEu3ZvBjnf3V5rbr0Bs9dl7/z
4M6aTBvZaW6syGPRnH4CXGaRW7bAVnvbB+ce4grDiVBi8U0+vS6nwjfiuGvP
0jc/1W/azn2dlRiTFIaBzJHSKF7rr685jpjG51r//2uOI0Pk/SpaQuRtmesw
5DsU5LHsueLz7em9Ew2fdwe+Gn356liz2rce7etba/ywp852nLMW45SCk69D
dprDyM5D9+Al1/dGO0D5uhPpqdiOsSI7zY0VeSyao734Uv76I09jeTpla8/+
46LqN2ovM/1BKgKLV8/am/43ZqPn9YP9pfBLfuXZlp0L9zJrenV5DU38i7hc
baqu40KNfy/0xz9YU9G/kE1S4v0DdjEQmQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->483322177]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83525986],

Cell[TextData[{
 "Dates given as ",
 Cell[BoxData[
  ButtonBox["DateString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
 " specifications:"
}], "ExampleText",
 CellID->432959438],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<June 2006\>\"", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<August 2006\>\"", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<November 2006\>\"", ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<January 2007\>\"", ",", "20"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->938311294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->535157729],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs2O0zAQduO0FUhc+L+g7VZIsMszIA4IOHFjxQUOYYW0e4BFyz4CFxA8
ABI3lj1xo4IH4AJSJa6ceZHg32Y8duq01GldHKlOZmJ/82X8MxM394ujvafP
iqP93WJw77B4sbe/+3Jw9+CQqWiHEDJiv1eXCbsu2ZX4jcqSnWX5gJWUKR8L
aYeXXCzFQR4J7YCVGVNSdu4TKVMlcz3JRTV1bKi7GcLKQAuI2CXqQrXviMsh
aE00Wl6hEbLJTz2okSW1anJGpD/RwMpOlkNQH5WifkexbMr0Kq7Bi+4EVmk3
HExIH9WqYe1sa1nIGvIdqt4Rd7ouD0BbVzzesmxh3j27bQbGBC8rT1M0Wnye
oIgBBaPP1ffaa/LQ2gHwRMUKs7T9K5q5GBr+vm6iKwI3ULtTQr+pfNBVz6B9
cg08E5e31Pl0Wc11uzRnbqYwOPbHyU17fFh+A/w/Hf9iF+/efifnUS0sn/PI
jepbXqMzcM5Fgzu3Pyjd2TYYo3VgFr76aX/++HPw/Mu3r7+VxfF4rGpte+Qt
gTKR5/AZlC+ujXW4ougYheftIu2dUTYuzYMJ5MxADMk2YdvYqQdjx46nB+28
JNcROuSKXJM1B7c7Zd2n5XTbMsqyPOTWzfdVHrIYLti2zrbcHB7unDAOLL9o
xkHJjszAw8DvjeYZQ4rRae1p2xPJywk79aBn9TPe1HEU8MXEZcbjRdrWOY8r
5s4yJhwx1rGTGDK6oFhaho9n7VuEERtnjCFHTVo1VhFberfKy7c92E16UGJW
eTa+P38PSmSWNz8pTnje7GO7Kl5eJex45mD9Pvh67nc2sx4gyi73iWH8aaN/
rX8negEt4mibOaLu/zvDE7YbO/Vg7Njx9GCKsku0Dry9dnE97UkvCDuetSRm
7OTl2LHj6cG8pUgrX230zqks1zEOvHk9kvtXhnX8lWHd12YXkD7YF2aMoxml
mzA0/dcKV/6GLP+ZNvzp2o13MT6eGok/C1Xdt4//UpLOX6Vtw0g=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->225634674]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->213533275],

Cell[TextData[{
 "Dates given as elided ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " specifications:"
}], "ExampleText",
 CellID->394625575],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "6"}], "}"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "8"}], "}"}], ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "11"}], "}"}], ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2007", ",", "1"}], "}"}], ",", "20"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->187144601],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18810249],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs2O0zAQduO0FUhc+L+g7VZIsMszIA4IOHFjxQUOYYW0e4BFyz4CFxA8
ABI3lj1xo4IH4AJSJa6ceZHg32Y8duq01GldHKlOZmJ/82X8MxM394ujvafP
iqP93WJw77B4sbe/+3Jw9+CQqWiHEDJiv1eXCbsu2ZX4jcqSnWX5gJWUKR8L
aYeXXCzFQR4J7YCVGVNSdu4TKVMlcz3JRTV1bKi7GcLKQAuI2CXqQrXviMsh
aE00Wl6hEbLJTz2okSW1anJGpD/RwMpOlkNQH5WifkexbMr0Kq7Bi+4EVmk3
HExIH9WqYe1sa1nIGvIdqt4Rd7ouD0BbVzzesmxh3j27bQbGBC8rT1M0Wnye
oIgBBaPP1ffaa/LQ2gHwRMUKs7T9K5q5GBr+vm6iKwI3ULtTQr+pfNBVz6B9
cg08E5e31Pl0Wc11uzRnbqYwOPbHyU17fFh+A/w/Hf9iF+/efifnUS0sn/PI
jepbXqMzcM5Fgzu3Pyjd2TYYo3VgFr76aX/++HPw/Mu3r7+VxfF4rGpte+Qt
gTKR5/AZlC+ujXW4ougYheftIu2dUTYuzYMJ5MxADMk2YdvYqQdjx46nB+28
JNcROuSKXJM1B7c7Zd2n5XTbMsqyPOTWzfdVHrIYLti2zrbcHB7unDAOLL9o
xkHJjszAw8DvjeYZQ4rRae1p2xPJywk79aBn9TPe1HEU8MXEZcbjRdrWOY8r
5s4yJhwx1rGTGDK6oFhaho9n7VuEERtnjCFHTVo1VhFberfKy7c92E16UGJW
eTa+P38PSmSWNz8pTnje7GO7Kl5eJex45mD9Pvh67nc2sx4gyi73iWH8aaN/
rX8negEt4mibOaLu/zvDE7YbO/Vg7Njx9GCKsku0Dry9dnE97UkvCDuetSRm
7OTl2LHj6cG8pUgrX230zqks1zEOvHk9kvtXhnX8lWHd12YXkD7YF2aMoxml
mzA0/dcKV/6GLP+ZNvzp2o13MT6eGok/C1Xdt4//UpLOX6Vtw0g=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->229770951]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->499832053],

Cell["\<\
Plot a series of data using an initial starting date or time:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->57868944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{
     RowBox[{"Range", "[", "100", "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "Pi"}], ")"}]}], "]"}], ",", "\"\<August 15, 2006\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85925722],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->94797863]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{
     RowBox[{"Range", "[", "100", "]"}], "/", 
     RowBox[{"(", 
      RowBox[{"2", "Pi"}], ")"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2006", ",", "8", ",", "15", ",", "12", ",", "15", ",", "0"}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->190454611],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->352890459]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->433223537],

Cell["\<\
Plot data spaced equally in time between a starting and ending date:\
\>", "ExampleText",
 CellID->17396477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Range", "[", "10", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2006", ",", "5", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2006", ",", "5", ",", "30"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->634852428],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztGstuEzHQyW4SpDahlIeKxKEVSC0fgRCqgBNHxDmqkNoDFJVKcOQD4AoC
ASfgyIUIuHMBKRJXzvzIYnvstdfrje31xtkUR4q948fMeMaemZ31nfHx/v0H
4+ODvfHm7aPxo/2Dvcebtw6PcFPSQQhN8P/ZBsLPGX6i/0mW4RrKLVx2ceOO
Ul9l9ToddZmUCZlLf2jbAO8o8GmK5TwuSSNKKIj4INQHGH7wPGD0E1YPHefS
vlTuc8FAmlJpLPm5cqHDAQxdIOVKPrCqRF229h6B+0KafEBXkfKKI96BMj/x
xNeX5iOFPwKPPPGp/HWENAezMdWSpCVOKynWxKXyNXTFleZzM9i5XSGzoVET
Gj3mXAnMEs2RF97URpK1sfcMsl1tDDvvJ+aX7FGxT2WLJksRIVmDdN2Wu9QO
Y6+0F7i27Ob3M7Ps3DHZyWlYUxrU5/TkNSPWWge7usJZ84rr4V4vYfVQg0nX
n7J61TB/ZOgH9zOpKIs+snTS2d55h5g9KY1IijuLI2Ry//jhN3548fyH8WxH
OABcOg0QttjpFGKZm7tvWat2VoQXAtOz66hPvht+/fx7+PDLt69/0BodPJ1O
2bhtR1iNXlIXbqQR6yeaD/l9gOiL21hSn/WkyPHBPlgLsp5IpQ6VqO12UGlC
D+T0JlEP3no4Q3txzHj92uunTz7THFRz5wHge3c/Yey7N944Y6+w5pXxM/fJ
6nsn8AFe99XL7w3xoXo30xtbGB/bXi4I6Eu9eO512Qyd/sOsWY1lwsc2PIMb
hnL0qe2hEl4PNHfHPAfJNmwEkRhQBY+C34uDUhVvbWGoLvPuWLbzE/Uwi/cU
VecpA3g4VkmAUw7hEoWFpTrVCFd2uQ1dzAP8CBvmyk8xBlJzVOUvRXbyEdat
Gfn489XU7inRjBmoJbKZJ4mKjbbh3AhrtWUY76d9oCZskYlaMxIEqsLihKG6
WL8dM1bt0IPfeTmXFU+n6fuNXTxFvEKdeAq4Eae3HjfF+Eod45o/Ap7sv3DZ
RVeLyWqpMYzuPkvzWS3dV8eQ0bYcHak0Y07LDvazMlcoQ7mVwR1qxroZSwx0
cvsxZzq5TXCis3httN0rniQqdbRN7yhKPvmi0t+s9oGa8LkqtflIEKgKrxqG
6jLZzJoeHmkyFcF87fxzJKbclw9fdSIfU+6rGAnJcUBPy4O/bKrzXnaR6aLu
NLUlv8a1FTNaRRhuf+YnD1Qir2hmnN2mm47/DUxuZ4JditpqP0y0BZa7pK33
OVR1B9+/RJ1/djYx0Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->248554789]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45306138],

Cell["\<\
Plot data gathered every 90 days starting on January 1, 2006:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->20622360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2006", ",", "1", ",", "1"}], "}"}], ",", "Automatic", ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "90"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->409607544],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWb9v1DAU9jW5tiD64zqxUco/wI9eCwNCUNqbGBFzqJDaAYpKJfgLmGAF
gRjhWBALFbCzgHQSKzP/iLH9kji2E9uvyfUc1JNiJ7bf956/fH5JzneSg50H
D5OD3e1kebCfPN7Z3X6yvLW3z5qiDiHkkB3PzxJ2TtmZOA4pZbVZTrMyZgOm
WD3F6kir1yz9JOLI4kdWHThzwtsML7tglZfCJsNyXWe+PFFiaUXIeiPeT4v2
WQMdi9P3Q+jmI9LW9dqeYQanEFZlKGs+443oryK9SO2g42XHtbHHWM0vX1lk
unifLHfL1KmvpSWOyw3hwHz42i1b2TGVmaKsn9ccrG/pl3fZlqf4qC6rh6zu
iNauwV1stPS02Swc8/UiK3hSPp5oN5He+VASjUYjxb76ej6zcc+GGQ0caAhu
UGhFtRwVYy7FEAKFAWTLYb2Q2YCaa3iemG2aDT+8/33j+puXL34451zG2L27
Q2a9ufEOy1jq/dfPv/eT4bevf5De28h4+zTGV1XcwAotPnNMrEUxQupw1Rt7
poAtTqmZ5+ZFh9SpC13mvVkNXXt+55EzDe89+sI17B+5G/sko7Ztfau2K1RV
9Uot9s5TVcUuNBubYCtVi4ssDHbboMWy7BQCVnVWv0JVzfZQmMUsz6/1THyJ
qhp2octMXJ2TIGKpZf+Im8hzTd6Vdmo8HFsYC9p99vQz0bHsbN2mUpsbN98a
1ja2wDNo8PWr7w7PYbDVBm01sUIn/+0qGCjk1D4S3fXdDvgyq+r46nd85MUn
YMqsWh1z8e1ewNZgN/vfqQ5GO5U+XttzVFXghVoMAJrUm46GYQSwpM7skYXJ
7v+mp0ll3YtUVekSEt2VJwFf6lbH93nbLI9Z6hcbcxhPtZMv/vHY3hIjckWz
jiUUX2CfK5Z19BCMgXWuTcN7mJyFqDBYXNkv2/eus1rMnUBjNzQw9DNU0TLS
Fx8w0Nr1/SvhIc3PAvlocyGT3wcErvKVh+TqI8gsornmsn3TT6Kpat+0Tkk6
/wCZ17T6\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->53231432]
}, Open  ]],

Cell[TextData[{
 "Plot data gathered on the 15",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " day of each month starting in January:"
}], "ExampleText",
 CellID->360754758],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2006", ",", "1", ",", "15"}], "}"}], ",", "Automatic", ",", 
     "\"\<Month\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->741635],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1uEzEQdvYnKaCCSmmahAql8BwIiZ9y4oAQ4hxVSO0BikqfgRM8ABJH
Wi7cGsEDcAEpUq+c+yKL/3btnaxjO2uXNWyk2Dve8Xxjj8efs9knk6O9l68m
R/u7k/Hjw8mbvf3dt+Odg0PcFHcQQlP8fTdA+DrDV/Q7zTJcs/IpLiPc+BDX
Ma5HtPUZKYmY0Q+6D+Qh1brN+6CYiihXymV6ib83VHpdocdaEdrk/hDVHq4H
vG/M21Ei92F+3CHlamFicYn6pL6i14s44kAae96OEjEX3Iuu3MLKeE5zIPzt
LUaV52rDQN/c2y2oQYq0MMpbJU/tZtZYOwJrakPr+UgaK0p19vrFCPL1FAEt
eX3O6SRCR8xuH6zkKtxNIMcViMNK37aAPAaW0iqk0gxtZ3JexpnIaVm+xeuU
4+T3We+pouxybdLrBNcd2prO+ZAALy8D+SqQr1net5WhvUu46KBi0f9TvhPV
m7TPbDbjd8ZA3tbI+Y5rMj91sUYWsXCHJa9kPwirmcjoOhaH3A6z6M/XIC1z
Bjj+fHbv7scP73+wXdVp/FD84vkJtv7owafa1kEsufe/fp4fvD79/u23Y++D
jGibi94sk70u8b6ryucciLRGZZGtPWfIPYCUn3MYosjguoiCGVcAIjwDMmSR
2+7GqkNuGbndBZpoma0dNVfXjyRDUPO1u8gyJDVzhxCPploOJUerOCd0JNMz
An2ysoDJLTlGOjMQueo3LENUM7k5c5syDUNUM3iTuO3iVkib+/+LZcjXI+eR
hHytQ1g+spCv7cbSjHg0xXIoOep/1w3r6Sjk7JWa2CZPmiFr6zDLT57jJaIH
Wdt8lF2A5C+WhK0jr6ul3QGabVnHrfXnW8et7uZfx60hxKPNpL81CyGytI5J
XTBnNaaaSe1/35ohqpk01HNQk9ZmuweEZRny9rrzSELevu4tspC3y2MJIx4t
T5d9Lb8bmb+z5m//mn9DD/4b6e/fyYvHpoyYFNlv6QkRm/Y2GVsZbLehI1ly
Zhs5rqTY2ywj9YWlj/wOc8Yy6SttUr0fWadEnT+VSIMD\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->354029545]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->546370530],

Cell["Dates determined by an ending date and a step:", "ExampleText",
 CellID->26450409],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"ArcTan", "[", 
    RowBox[{
     RowBox[{"Range", "[", "50", "]"}], "/", "5"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "Automatic", ",", "\"\<September 2010\>\"", ",", "\"\<Month\>\""}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199919385],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWstu1DAUTZOZKX3R9/SptrSAhPgGxAIBK5aI9VAhtQsoKv0ElvABSCxL
f4AKPoANSJXYsuZHgh+J7Vw7tm8SZ2ZQRxonjp177sv32o6fDc6OXr0enB0f
Dvaeng7eHh0fvtt7cnJKHiUTURRdkv/79Yjcp+SO/S/TlFz1coOUHdIhJteY
XBPlGiX0TfaLli396HWlpD2v9w3tCWiPok1adjmqKFmfnBdR70jesrf93iup
09slfypd8Vb21MKB1lfnf5VdtrTnCGz3exbJl1EU8tsSXG95t3241KitIWWL
ke+YaKx6cTY8OU08rwxVZhpXop76XPEQBBeLI0ZnyUbHWzs0zpmiaB4VVyzt
cUbF1t73aDdlA17y4M9/ah5gdfLvkPtz3lyQrQv6dhSdfDn//fDBp48ffhR6
MWWC+iSyHds/dLtP/wmD9mC/RNHei+cXRHuPH32OboJet0H9wFHfLEGHXFPP
TZjBT958/f7tD302x/pcXV0VsGX9wFFfz2l6YKv1hZq4ZTIz/9SfhEFWxhS1
dJyNF3pdrImykdGJMn5D8D+ulK/1O0761TKPllFh9uD5SWaX6cak84jOWl3G
6VB80AjVMUQqjv/r518eroPiqzme2iMRXtZ8bshjJLR7qJzQAp7i4zDzQa8a
5bF6HbHa1QKPQDLSTQZGkrGsWaRY+L2MVnURLBkE7AS0FUdanVuONHLI7JDT
bzM7qDjtrBfo6IiD2jF8XJxKi9Gr0yjvOpKMXqGRZBRrFmlc89Q4eWWY8eqT
d2Zp0RXjgdQI1ehudXxkDuD4YpS0gk/hOa4YMxVxR2W1MGq59n/au5pndZkx
7lTm30xZZoimKRPvfjm4oBmhHuVxiX1Gyj3RU5jwVjPakJSFCbGUHVqRCCJQ
VeedD8z8Z/o6GS5aaV9t0/aihh+2aXUA9/R2kDzI7FBffrivh+WlSVvAPb5h
8tJONoF7HltIVP/oB/c8sEj+8+EesGI4JLjmWq+FZLIPXGthEfztA9da9WSx
Ic0Cra0GRpLaq4dkss8s0BoWQdlXK81ibEh7RAw4n1uqLC2MXvCbhB8nUu/N
cWL6OmXKcIyDSXUVJPVyE8lNebaD36xc39XZKbCe0ItgaaYx/VTjSOhJsNYc
R/jM1y/yJLR0ozJPmIzIzlUpvotF9Y+4GyVydivL6UJk5+QM/heHRZzW/StV
BqRrpuOOwrtFlFRZuHivjfztxt6cEmtQHco5b0Tu7c3wuq5F/3lb9d1E5htz
FmzVlNmZyDq2hPjdEnyjkTVqqHzrPAvh0hWLFQuqH1r05h39cdkQw+98kV/B
o93IcBcelwtMZytcfLL5Q1/w6ekM+g2MAY6sVeEUBps1b9o9wKJmo77XDBjm
+QjVa5X9jl1abKv65aHNwrunxuFcyz7HbGKvhtHd130FawrVAkb7EMjt1DTD
MJ05qbLTyNYW93RJ7O7v412eQrIzTs3sbbJ10X2jMSxy2d0OO44oC7YcKOuu
M7/7tNgh/JJHRgmw8qlipWWZehjnqNtsh3UWCWZ0LavKLdqUn5kvO3Vfv4wm
/gFX/m4X\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->562377133]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->189722811],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "AxesOrigin",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->467648442],

Cell[TextData[{
 "Axes origin specified with a date string ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " coordinate:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->15484210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10", "]"}], ",", 
   RowBox[{"{", "2007", "}"}], ",", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<July 1, 2011\>\"", ",", "0"}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->171912587],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztms9O2zAcx03TFqZ1g7Zs4sjYQzCQ0A5oQ0LiiHbOqklwGCDGcY+wPQDS
jhu3nUDwALswqdKuO+9Fgv+Q2Plh13bquHGWSk3ivx//4l+++cXJXnx28OFj
fHY4ild3TuOTg8PRp9W3x6c4K5pDCF3h/+cVhI8TfET/V0mC9+L2Md62cVEL
71t4H4H9UFIeCelXinKyR+QgoT/U1/RD66Me2XZYq2xL66R96dIpS9FLJ6sl
5rZ5W2aRaes2IA+mItMc9ESeb2H/QN6DwQg2LFqSasuFSczWp5aWEU95Lqtj
QNw0byfUKkqzt09m77BUW9Nr3NzG7MqmuoG6IlOw28LCpUn9GFi6btVeVDW7
VjkvpPm9RK6Y6X5ZU76hyJdpiqpeK/O0h8rOZnU8Ht/3swbSK4DT1dSH6QWP
lJ+4g3l6BM/Ooia9pCnvatK69rpy8SzxXGil2ah4fR11bcIo6uERJpRW6jUB
2xAKhWnkj+9/Xm+df/3y695D/VDf7V9g6pvtb0bU4l7BaL9v/x0fXd5c//Vk
Y528pDqURhtMKMTD25KYpBjtGc3lGvES1OoLFOSYyjUCUgeAkj6ZTkPDGvE+
viAaAWlDQIPxcDnzOBsq1cdctO5mRnVc4kfk+u54oTVqMlsKe8bmqtL3SOWq
IqO68wpG45GHHxvr5CV1p4SuQLK7cF2oL2g6r1Duoio5DSoTj6rIXbF4fCOn
8XgnXa3yc+/1e6efjY82GvI/UmBUM++RyrWDUMvzChjV+LGxTl7SaEO1KH7v
R/rnazYO9YqLS26U2a1eaynXTvWqS3Fu5DWWESl+1krSeM0PrVGSsCjsvaL5
W53pvIDRzN/muLTR/K1OSPMXGqXRBhNK1aKMqnDhOguMAuzPrmydBK6vFKMU
tU4d41R7Nv2/k2kUq6FMrq+Lbtx6gS66KdNGdXQT8vxVnRK6NvSS/Df6frR7
8vfv5BCmQxkHjE8eORyHyRsdGLm45NufBx7JzGoccr/YTfLfWY9o7sPvq9Hc
HXqWt10=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 124},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9665221]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DateFunction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->529152931],

Cell[TextData[{
 "Prepend a year to create dates from ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["month", "TI"], ",", 
    StyleBox["day", "TI"]}], "}"}]], "InlineFormula"],
 " lists:"
}], "ExampleText",
 CellID->905026462],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "1"}], "}"}], ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "10"}], "}"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "20"}], "}"}], ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "24"}], "}"}], ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"11", ",", "5"}], "}"}], ",", "15"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"11", ",", "15"}], "}"}], ",", "20"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70487484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"DateFunction", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Join", "[", 
       RowBox[{
        RowBox[{"{", "2006", "}"}], ",", "#"}], "]"}], "&"}], ")"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13895297],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWk1u1DAU9kziGYQoArW0M7u5AEdALBCwYolYjyqkdgFFpTdgCwdAYoWA
FTsqOAAbkEbqljUXSf0bO89OYs8krjP1SBPHzvN7n9+z/dlOni3Pjl6+Wp4d
Hy4XT0+Xb46OD98unpyckqJshBA6J/93M0TuC3LH/udFQVLzeoNcMyKQkXRM
UpSzYvHLRemYpDlJZ63SmZCmT+eN0hl4uq/VRvSmYD801mQmQsbUhNCUXqdl
PS4gxDKgk+Vzla9apTUOPLThRm309p6HtglAAnXtNeiy+W5qaTvtJCOaduA5
KLEft+eAd3jjNQA1dfOevQj1+7S7Wy/qY76qVY8suBrjx+q/XEcgx7XwHAbo
mAYsPdPuq9r6EyBNb2ftNRr9uaf7CPYoXGhzkyzFUBLktT5k4IJ1mdcmZqe1
Rr1VG7ZKzZ3qOo04Q8sdS3uqY0my0k6h+onOKLJc9lXJS7cKk1NknGj5bZDn
/a+OGydCmrb6cxlYc7TlWiu/frl4+ODjh/e/7dHoMW+b5+vQMg7FBOjjR59U
XA56Rqj7s+pd6b2/f/6fvP7x6+c/4b3VaiXq3vfM+3jDnOe3xa7uYzULrW+l
GsGdIG3YNispDnFYGWocqnsfudeCzNyPbXNNaKyAWnBwjlEsuRsQV1bOuxDP
i+ffOBl646n2gK78o3gwpH+G0H86GkMiQdpaMXFkPFZSHOKwMtQ4mHvwPNia
m81gNWctvghusrxiy8X6iBrmWHkS64ZGcWUbGiz0atwIsW0w83M0iim78c2m
qBIvxjQPbJuVFIc4rAw1Dpb3Zg1zX49zXQsb+aDw3VG6oZLrBRde9N1DWnjR
cprvu6P33Tk6MVFxhacLQW3rzGd71zfUET8MK3eL6hieO1tdJy7cmhqv0Fq3
ceLW1Lh0b1v8cbtujDm009aQOFyYsi1vYcZY2q+Xhu0Bxvtz+EVDGEbU37cP
cSRvm5UUhzisDDUOidmiYbbk+yvEkc4847aS4hCHle7jkAfnHb50lids/Hpd
Zj9mF5dnLNyoiIR+5opqsCgWVOV9f9PKcfGTGobLC7HpvcDIcXnqU/G2y7fb
NK++ObZx1HdWVPft8iZXNLoEvrGyHw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->64535053]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->82491380],

Cell["Define functions for interpreting ambiguous date strings:", \
"ExampleText",
 CellID->80984464],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<06/01/06\>\"", ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<07/01/06\>\"", ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<08/01/06\>\"", ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<09/01/06\>\"", ",", "14"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\"\<10/01/06\>\"", ",", "15"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"\"\<11/01/06\>\"", ",", "20"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98385114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"DateFunction", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"DateList", "[", 
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<Month\>\"", ",", "\"\<Day\>\"", ",", "\"\<YearShort\>\""}], 
          "}"}]}], "}"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->980938488],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW81uEzEQdvYnEdCipASJkhT1RRASFXDiABLiHCqk9gBFpU/ADQQPgMQJ
QU+9NWofgAtIkbj2zIss/tv1eNbO7obUm10cKWuPPTvzecY7Yzubx5OjvZev
Jkf7u5PtR4eTN3v7u2+3Hx4c0qawQwiZ0u+7W4TWE1rj32mS0PIpvYaU3JTl
Dm99wq4x40o/RPKQMGsl93n7FXoNaGNIyy6RFSI+A9DXkzQTEMh2yNsF/WHa
H6l+QoZze/tANkQZgDuEumuAg6A7MM2qG6b+SPUTcoMVPWQvi3Q2Cj5YxBjm
pG7MkRoijIOSCKBFLssSbOKQOIMAeJnmm1iGkbvy2NH4SA9JBCjYA9Fhpd0G
XUWnlWHh2I0cBk9jq/alZXh7nLFZfNBfcFbMk2u3TJiJFR/41LLr0MRjmjUR
1I+ffXYHY+ijO0OEMZQzLB+bmIRYzpvAgAHOMuXVQI5XnwWsOkZ0bBoTQDbO
zYaRESeWMzByrfHyqrTtWJZxkn+CUqyQbxPYgNF8bGRquXYl9wmn4tw4WJD9
mhnP3J+O4Pu337Ty6eMPMQKAcR3RW4jG9r9e0I/lje3WzkbIqIhPowc7XyTT
bS5nNptpuBSN58HI2C/o9PkoY6lfP/+8mByfn11oEuwIFG1EEGe0NnILBtVC
b8P6lqkfWt6d1vUERBjpmqVYGdCBps3t2Nqszfutmdrc+U1f9aerSrcRJr/2
y603Vh6P0Ecz9r27n1nGvuMcj1g3KokiFz9/dkwR0Qy9GCJjLl7cPipPu7eP
u/kD1+LpXtnn7OZGY++3ZlqyrX7L77wj53sRHlEt5ybFSHC2xP2VkeBYj049
cG4021rlylJ47LnRcuaSoSthG5Upl2mb6mjqXlfVkad9BG6mNu+3Zmprq9/0
vTWOvegXKhextyBLVkMjtKscjtFVQZOuX4rytBmDyttGDPY8bfg1qfo+TWCw
n0BXyIjJCpy+1IIBZmL+0KCZ2dYI0TRt4kwJrdsvMbLjMyzMv0y/CV1o3d0S
v/mM7E+7l3u6XJSZ3Z4uu1w5hfXMmNyv8V2nGHCGDkDZxkjRdm3eb83U1la/
+cy8KJ7aMrP30Qri8Wfa7dLm/dZMbe78FtWWL8UWJD05Fdf/NRp/eD8VZ2Ia
HvzGvQkNA7OF2jE9RvTI1k8x6Dm7DALdYvhdcEyvIbro3fKq754b72e734PX
p+dnF5p9y/wfhNHqjXtTfjzhTbY3+v/lSjp/AU48mC8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->73107086]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"DateFunction", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"DateList", "[", 
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<Day\>\"", ",", "\"\<Month\>\"", ",", "\"\<YearShort\>\""}], 
          "}"}]}], "}"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->693595886],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztG8tu1DDQu3ES1MIdsa3UH0EcEHDiiDiHCqk9oFZtP4APgA+oBDeohNRj
1X4Al1ZaiWvP/ZHg2HEyO5usx97Ns460ceyMZ8Yz45mx432fnB18/pKcHe4n
e+9OkuODw/3TvbdHJ6IpmDDGrsTv63MmnlPxJH9XaSrK5Xsg7lOmypDlD0xd
HLzLyogIy4KMorxYuGH807yMDbABgDXh1bC6ZJJrFqtRoLuCACOU9aisa0AM
Z42TQ5wYIu4dh1jzkQU2bhyvDW+8ildQn5Q6hlAZqrBAnOPmNrKjYTNLrXOu
9GyISf0jmvZoeGh6i5YtYQpmtuxoIyMqPrPunDBpT/Wko7GFNA1SMdF0GGL+
MS5eCRVoOdH6mzVGw0OVdsvYiHOPhsfaZ24bqWMPsm0z+g77PaPJFfcwSlDn
Gxl0pgOd10SoPcjrVe06/9lEuzKBuuxQZ06XpfYXZJJx/1OUWyvec2lpb17/
gBoBcnnahzovDKMYjR47nD93tw+fkoub63u2I7HM5/Mcy4xUL6nOlmS1Soag
RaDcdaKN6rys94E2lHbhmxSYo6yraUINozne4OjGSslraiiU2tKUchn60nkt
8iwNjtW8ckYQPeNF6eX3r3+vXp5///bXTU/OvATSSsreLyTMxw8XghsRwd25
KSxiXcmsGYF7bjFwZ0pnaO3NHe/Rh0TJa8rLb3FUekdNXZpsezm89JNxQUm9
ylkyc6FijWXkq+NixTpcr6xX4XaKe3VxDtG2iyyKE8uoR5CKPSdjzNDq4u34
fMNYKXlNDYVSNytQ7OfQt5em/ZwhDnXDiVtWQIrPddQrduAzP2uKw05x2bze
TF1XVqRobI55zvQ3Eefw1/H27ND76+p65cxqkBKaPw1pqnKuDFxTj9vS/d7u
uvupTtTt41v3koHxpX0bKU87qFf4lESLkRZ+4x+XNxgrJa+poVDy3zT7Gvc6
4QXopbG4my5aRo+l0Skv/jum962PW35eU+6j4p1EWbVI0LuT6t68B5W7JGGx
95PL3MajZwC7qH1mWS/2hXSOU/AA98+ZWSJs+T8jeL8Rn5se2vtG8IV3tw+i
6eb6PoUWQJF+ef6acs79j2quiM+XsqnuJLjbnU3+AxHQSWg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->476649759]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"DateFunction", "\[RuleDelayed]", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"DateList", "[", 
       RowBox[{"{", 
        RowBox[{"#", ",", 
         RowBox[{"{", 
          RowBox[{
          "\"\<YearShort\>\"", ",", "\"\<Month\>\"", ",", "\"\<Day\>\""}], 
          "}"}]}], "}"}], "]"}], "&"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->166013156],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWz9v1DAU911yV6B3VwYGRFupXwQxIGBCiAExhwqpHaCo9BOwgeADIDEU
ce3ExqlMTCytdFJX5n6RYMdx4jzbsfP3EteRzo7/vp/fs/1zXnJPg6O912+C
o/3dYOfJYfBub3/3/c7jg0Oc5Q0QQgv8+3AX4fsQ30W/RRjiWAxHOPRxhSGO
hzj2QDzNKUce6Tm60ETTj6qcpWeSco9Ly3CwchYjNCbhiKJKQlrmmaXJ7bp5
L37aCqGNWqTfMu9llLSKc2fqtkJdEf+0QGsfoB5E+WtCn0VHPzHrQcCzUVny
eqEe2O1M3spA26Yt5Zq+UWB0MuxTk/oCltsFpQyZZepGaqBfqdymtGuqm0oa
Va6XnmmXcA4a872F6vUmrhnTlro9toZ+braBx8Aak0Lt5VYh3Cljbj9MGVhW
zpg4r1zXnp0AqpRHJxLJCWeRGR2Ze8coZio6EzOa9DmNncwv8c2Xz39pPU5j
ujTU8LWsL8y7cY7OSQbyHj38FufeAz1ugfQdDaLNnPbRGkrw8DODYb44v3oV
nP4++xe3Wy6XmX7U6U1Z+ShJG2iCy8HNti2Wz2t+iOIlTKvWo3cundp72uoY
bZfm7NZPabbajW5h7GLeArDTNYxBPJ8Jz0UKPJ8+Lh7c/0pOHO3j8aIZASU8
f3aMEWFerjQjsoxbXj/zH38O3v4y4eV27NW1+dPQmvLCZE2x07bj7P5Ka9Ju
2ZVuuybtsVuYWW+UMNnFBtru00G0x60l0mhZXGMFSODuy/uBtWiotJP5Zczu
8vJyaOCbGDWXw/TLF6cxtxvhUXO5Bo2JbtIn7sq66QFz2rpv2L4DO7v1U5O2
2i37tAv3Xj0vdYslm0RT7vwCeVuKMA+B5J0M2f91/CzHkfJ1nqYk/JyOOSzL
QZClC2uiBgx1MTF8W9HuzHQ7e9ekAa9b43ZT+9TqtxvwmFllty6ut377n1eJ
pygnlvdKdVI/4LuyFcwY+fv6lTE0/+2J48r+SXN266c0W+3mmLksnpUxs7NR
B/G4t8F2SXN266e09uzG/++qZa9dHPHh9duNoRda8G1HQHjvP1LgIrC2Qf6W
Jg2/pE580TiL+LC8RDcmCLK6G4ManfyOvUP1afri/ApnEZ+efCbo/pHCbPE9
l9N/Rlmq/1NUCdHgPwJRuNE=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->81189445]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "DateTicksFormat",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->28213509],

Cell[TextData[{
 "Specify the format of date ticks as ",
 Cell[BoxData[
  ButtonBox["DateString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
 " elements:"
}], "ExampleText",
 CellID->352817134],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "1"}], "}"}], ",", "8"}], "}"}], ",", 
     
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "10"}], "}"}], ",", "10"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "20"}], "}"}], ",", "12"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "24"}], "}"}], ",", "14"}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "11", ",", "5"}], "}"}], ",", "15"}], "}"}], ",",
      " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "11", ",", "15"}], "}"}], ",", "20"}], "}"}]}], 
    "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->351516546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"DateTicksFormat", "->", 
    RowBox[{"{", 
     RowBox[{"\"\<MonthShort\>\"", ",", "\"\</\>\"", ",", "\"\<Day\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->58745033],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWrlu1EAYnvWxCVcBCBRls1J4gcALIAoEVJSIehUhJQUEhbwCHTwAEiWh
omMFD0AD0kppU/MiZk7P6TnWx9pmLO3Yc/j/P38z83+eWT9fnB29er04Oz5c
7D87Xbw9Oj58t//05BQWpRMAwBL+3u8AeF3AK/xbFgU8k/QmSlNUig9w4Mjf
V/LXsZVbNa1cw1a2YYoKE3hO4DlFpVnZipaiWlQ4c7YWa/dMrQUEKS1DdXOh
LTvrlkGGQdMD2wNX5Jb6vdUlFAugWF33ZFYr6HLXw0queFZtzJQ8rs9FJkoi
RC5hgobeBJ1tvGwplkQUmpe52YbWLjW3czNjfS5vdpxs5U2wY/Hq+3TN8cTm
lD6+5msxxOahdU51wY4SH5obgeuNHHWeWUePYi0Bepzx5EbFJbVQeaqIXaoN
z95z8aQzrc+u7YKPpoS2YPcAII63PWfLjNbMDC0zICuI3RLTFjLGlxXpVLj/
nPEjWSMGM2G8nH+5ePTw08cPvzS27ij5uw3Xb2nc25G+fPEVIn3y+HMPkIpM
Y3XPT958//njktywWq3AA2wDXlEbB448s2jtMwFTFmhfzXuz36pPkcd2Pd2Q
PDVtuX3sY/AQ+R8+/3Kcklc1SdHVbLavitClmu8jhh2c5wp8uyNMaRnbVSxc
Y0OxyOOiKW7+/P5LhLUzbtodM/QFTnqPHI72yX08lqgYuY/ch3BPzLGjoEGl
/Xdl20q4I++utXUAgqs4z7XvXm1EKoIqpTMj4crnQsLWfILSOVCE88J1b01e
os7FWDuCWDsWZiL3xiih/ydWQ1E2r2mh6zk3IvZm4aNjoSs4w4ptKqoGSUOj
dui6zalfxYb2FDrzK2ql6b/RIc7s/nsgXzLwubrr5XGdviCe+Lz081T/2fgc
bN9jX0bEUHeY4z7qEDD4qHBYJNbeOLrrde17gWnrflWlSwyKF+PCGD1E/ofP
f/znr8cYBP5bUql+Pe9GMMRdzf5Ftsh95D6E+6xTtSIv1WwvjaT/Q+zEgTIv
d1eIU9oD4q4qqMDCNYyXt/2VJ8FF9mkwriDEOnsdI8/L/R6JbdOergk//17Y
pHLfcFHVd8d1UjD5B0upv44=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 133},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106262655]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Epilog",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->72592511],

Cell[TextData[{
 "Place text using a shortened ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " as the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " coordinate:"
}], "ExampleText",
 CellID->930137739],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10", "]"}], ",", 
   RowBox[{"{", "2007", "}"}], ",", 
   RowBox[{"Epilog", "\[RuleDelayed]", 
    RowBox[{"Text", "[", 
     RowBox[{"\"\<linear trend\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2010", ",", "1", ",", "15"}], "}"}], ",", "6"}], "}"}]}], 
     "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->626977198],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW8tu1DAUdeOk0wLDzLQLBhYwP4JYIGDFErEOFVK7gKLSH2APH4DEoguo
hNQdFXwAG5BGYsuaHwl+xI7j3Eyu85pMmkjjxM9zX76+iT1Pw9PDl6/C06OD
cPHkJHxzeHTwdvH4+IQV0S1CyCX7vZsT9hyxJ/G7jCJ2N9NbLPVZlcfuHrtT
6z4F6qmRz6sXD0RevHyS00404w+RuMjNAjw57JyngeylU9FGjVWUV1g5owS6
lVnqJ30l59jeJpfEsa9vUT2pRLUoIbfhcgfZTeAREBTMkD1tvqcOiL4DTp6M
7jhKhFvnPtQGgbiH6hdAEsGhGa3K0uguFUhKDjS3JiHl6/CS0Z5L+E+ybVJq
SMtBLuNV4yDkM2m1v7k6uPVKzRhRPo/glUfdZw3VQ341r52n7T+7gsp0O251
IXJBRr58lDN2H62oB9YXe7VqO5+iaBXtNJY0ocvlMq65B+broYiIa6U0jZ44
ygryfpJfP7KyN9vjNYU3jvH2ahzf1OG4RT56hxN72i+f/zy4//HD+5/Smzdo
BYQ+f3bOsB49/FQrVsYiYs5+//p3/Prbj+9/G+Wsd3Yx+AUnT+637L/NeBB8
26HJjF7UhDuycOyYTOIms7su3B0LR0XREo/N7xfhOZ/fVfBMu4HwhoigTry+
zPyrhiPrK8YKDvYg8SrGCyXsQ9ZXjBw6rMdNxOmDvyhaQbuCezdKz3PUyloQ
GUFv+RLHMWIA9GeuWwSxjklcx8ihA+tm23jrste+zPerjlMqXqhgD6XihRrs
o1S8sEF63AScPvgLrH/nb6g7+tVfXFGy0xAQtUeU9AiMunQvvj5fL0mv+xvr
Lk8Qe15UEW02kqUpOrK7URSBoCkpinHQPEPRDZZXpTdPsyirPJhbcz1OTNQG
yeG3INbiaERdlXQc2CQJ7m6YJOalOVoeZZnU4/rFmi6I9nI0TRGzcdfSp3mG
ResxsQNd4at2scMZ2f2AcagSYknvYvKB0qNRv58Zd2a1uFaSMp5C+6qQ3/MA
DU+tdmrftqyk+rKeDDjpPCoerdEeUPFoA/aBikc3WI8uOMM87u73hfp3PMAv
V5WiOByiFVcBcVRdsgW/XXVqN2nYx6oyfp/9y6bigHFDg/YAxg0t2AcYN/RI
j6twhnmMxzG+IJHk20VbXjfnfHmDJzbEmhvo+R8z70INb7DuU7naqyi9uUq0
U2eM5Rk/5qtYEfNVJXRy5tD+qyw2/pmkznhfiKK8s93lUrL1HxLGO40=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->254469531]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Filling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->512663939],

Cell["Fill from data points to the bottom:", "ExampleText",
 CellID->489947408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Range", "[", "10", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2007", ",", "4", ",", "10"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
   RowBox[{"FillingStyle", "\[Rule]", "Pink"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79508687],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW71v1DAUT+9ybemVtmwIhrvyfyAkELDAQAW6+aiQ2gGKSpHY6AATIFXq
AqJIiN7dSiWqsgAdGACp0o1lO4lKLB0q0aFDh+DETmI/58NOk9jX5qSLY/v5
vZ+fn+33nORmc2Hm3v3mwux0s359vvlwZnb6Uf3a3DwqKg8YhrGO/s/OGuje
QnfOf92yUIqvVXQto8I6SWsg76bnHepR+2pnLefn1NL5Wkw9zJ9zuFaIjBJK
Kyg1TKeY/OjaEkpPCVEbZb/UbjUk1KoM8Im1kkPmUo84lYOOGE8ibkCalSg0
BumDYfroWAoXrxS3ENphWT4UBohJmle6PYzn5oxBxWtAkUvxieUQoSPZ9iax
thxQC+iPRueNwyDPMJ7fsAwnql3QvBXmE1BeVdMjn5NFrxF0Hb7aGbjCVcSw
iPGJ060sGtKfajIEci0TWOy49DjGt4iRQWsEUlVoKrt0NJl0BrV9e5pILZMU
7uewvhpSb4LykQi6KD6uHGzn6yFXdh+FPXXHvRVYW+Y0ZVIabre66ObVy+/G
BGg3FpMfT5ke1g9I9AbPhKtXVijtItLdXWIw4bJ3dvy8tb/P0R8csPTb2xT9
4SFHv7dH1Tvy3ZkpOzK/fv652+x83vhNuFvdrrW25kuzFheZ3tiViMTP93r/
lpcp+qUlBt3fTsfa3KToUSUi8ejtxr2eV2968tFPZmyokq2trYmiL5n3hd4T
bM8uYF/QGP0EQez0AuGkZKnFSskveUj7R6cF0sJO+0GnBdKTjLSYUSd59PsH
abCdtl9sXLr4xo6m9LbTxtQqwoniJW10Gh7huvFTmAeL4qS5B5+oOEl5X2As
MQjyJa4nFwrkOSDHT0XwhLXL6iqwkznqWjWP3D0x4u1dV13DszA+UtYFuUFF
xkMWdZKnJdqgfWZSoc3at2H7ik46K5AdJ2RwBuBVu93qsp6W8hmAZ2bjTof1
rDQYTYyMO0/WABm2M39H1snOJlVgE15p9dBZgew4IStmgJzOzABfOMpzV4/Y
jbLxFXi+Eb6wjxw/WSW775OPLlJNns8FR3gQPdmjL7/NBj0X4cH3R0AULaF3
7qwjc72ngb2WE9ZIXHohFXpCqwqdyF6QCZYEa3+eOimQ9LudtJe/sVGjstHh
4kRlSLi4UImdwJ16TJGdZIIj0egUSNQi6VeLZTz051+InPSjHde/jfdbIr1w
bwVMO7oJ/OIgAU7oc6t8VhWeryXBFhupwPfQ5XWYCJdAHOK+Ny1vfWkhYmML
qKn4WCMzXBLPuLJHk2QlTSQ7hZUTy339+D3xEfPbx7DkqRvvyIqYt+TW6ley
xuU/ztwOmtM4S8pNUduFZLUW1l75wUSBeVlY43ab8Xjy0zb0YfKQXM9xXANl
ZTCOon0K+pL6KN5KAgRQOiv5CD6BnlhwnkQ9Tzewncd4R/y3kiLPEMSQcOc7
MW99iXxvlEwn4HxHqa2AdSlk5oifiKclNb01iNvnMlqDxPqUhSTvHecwSejm
jMVa1FhMfjwLerNx6wMqwl+F6o0UzVFUhOYogxR/zxv2TfDRr8bAfzFqgGY=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->124994919]
}, Open  ]],

Cell["Fill to the bottom with points joined:", "ExampleText",
 CellID->207463267],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Range", "[", "10", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2007", ",", "4", ",", "10"}], "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->612648634],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->139218767]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FrameTicks",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->140532627],

Cell["Give explicit dates for horizontal ticks:", "ExampleText",
 CellID->183285157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Range", "[", "10", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2007", ",", "4", ",", "10"}], "}"}], ",", 
   RowBox[{"FrameTicks", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2007", ",", "4", ",", "12"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"2007", ",", "4", ",", "18"}], "}"}]}], "}"}], ",", 
        "Automatic"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->418010759],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1uEzEQ3mR3EwmptCkXBAfCzwGKBIg7QqICTkFCUcV5KUXtAYpKH4Ej
fQAkjqUvQAQPwAWkSFw58yLG63F27Im99totDSGR1puxPd/8eGbs3R0U+9tb
r4r9nc2i/3iveLO9s/m2/2h3j3elrSRJRvx6dz7h/xn/J64RY/wO7S3eprxz
S94vit7bZVuSTPzEqEpfELOuS542v+f8nmSiW/5yOZqk2Nvm18CLqxwtZ58R
gzfKtlvJBwbJ1lZ0K+luzdwnTXEytFmfIYAq3fKKQZmu4ihcFGXgw++hxxrR
X8zqTANSfVKDPt44qJe2XmvKGLSZIRJyH038UAL8s+zko55wc4Ckm6R3Sfom
lfenjnHw4cjS6vlCNZh45NA4mk5ZIMBy6Pl0+PP+vQ8H778llwkfzf9V3rQa
SIA6wMEfrn8se/sO/JUJT0MLfnz/vfv689cvv6QF4/FYk4B0UwvUGVdnAlvN
gw6DyKEZ5Y+2IhGuOTh6ch5whMs6Dc55t2/hmTr7VsUMrHHLwfb2BP1s4wgK
mhNJyVlr7Ra0IYNBFtY1f1m09nQITcfDq9rfRS5JF6J9/8hYbKU0IdbRYRW9
K/UMR/sf8jrOM8CBFeGlt2euML0CUE67lsDJ8/l5cVTmsz/nYuX/Lc9khloR
V3kmuwe0gmh0llxierxvWCX5n+rNMjAzqAyszPRprx1oD+6NdnviZdWtyhTO
4oR/SpzHa98lpufLerDWgIRZEYuEMV+PNO/rPSuRcofpkXLXKpvuCqLaeuQ1
SMAIskvQdwnX20ezHIwvu5zjP6vTKk19Ev5cQZEnb9pi9mK1xlOc+X0GeMD0
SO/XynYjYUTHImHM1iMtamITzwzJetP3D/6eGpL1pkj+VgzJeocjzcZpKTVU
qLjqdJLn3XjsF0yPqXPMVP2mv+vYnjkADyOrxxp+PXDqis/rqOuJ+jiZ9xP/
WeGtKgYcOEjTL0WAU619JE5VUzQc+JZm+x4X3yatP91509c=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45222059]
}, Open  ]],

Cell["Use different date specifications:", "ExampleText",
 CellID->216465658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Range", "[", "10", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2007", ",", "4", ",", "10"}], "}"}], ",", 
   RowBox[{"FrameTicks", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<April 12, 2007\>\"", ",", "\"\<April 18, 2007\>\""}], 
         "}"}], ",", "Automatic"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->182363409],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1uEzEQ3mR3EwmptCkXBAfCzwGKBIg7QqICTkFCUcV5KUXtAYpKH4Ej
fQAkjqUvQAQPwAWkSFw58yLG63F27Im99totDSGR1puxPd/8eGbs3R0U+9tb
r4r9nc2i/3iveLO9s/m2/2h3j3elrSRJRvx6dz7h/xn/J64RY/wO7S3eprxz
S94vit7bZVuSTPzEqEpfELOuS542v+f8nmSiW/5yOZqk2Nvm18CLqxwtZ58R
gzfKtlvJBwbJ1lZ0K+luzdwnTXEytFmfIYAq3fKKQZmu4ihcFGXgw++hxxrR
X8zqTANSfVKDPt44qJe2XmvKGLSZIRJyH038UAL8s+zko55wc4Ckm6R3Sfom
lfenjnHw4cjS6vlCNZh45NA4mk5ZIMBy6Pl0+PP+vQ8H778llwkfzf9V3rQa
SIA6wMEfrn8se/sO/JUJT0MLfnz/vfv689cvv6QF4/FYk4B0UwvUGVdnAlvN
gw6DyKEZ5Y+2IhGuOTh6ch5whMs6Dc55t2/hmTr7VsUMrHHLwfb2BP1s4wgK
mhNJyVlr7Ra0IYNBFtY1f1m09nQITcfDq9rfRS5JF6J9/8hYbKU0IdbRYRW9
K/UMR/sf8jrOM8CBFeGlt2euML0CUE67lsDJ8/l5cVTmsz/nYuX/Lc9khloR
V3kmuwe0gmh0llxierxvWCX5n+rNMjAzqAyszPRprx1oD+6NdnviZdWtyhTO
4oR/SpzHa98lpufLerDWgIRZEYuEMV+PNO/rPSuRcofpkXLXKpvuCqLaeuQ1
SMAIskvQdwnX20ezHIwvu5zjP6vTKk19Ev5cQZEnb9pi9mK1xlOc+X0GeMD0
SO/XynYjYUTHImHM1iMtamITzwzJetP3D/6eGpL1pkj+VgzJeocjzcZpKTVU
qLjqdJLn3XjsF0yPqXPMVP2mv+vYnjkADyOrxxp+PXDqis/rqOuJ+jiZ9xP/
WeGtKgYcOEjTL0WAU619JE5VUzQc+JZm+x4X3yatP91509c=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2694793]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Range", "[", "10", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2007", ",", "4", ",", "10"}], "}"}], ",", 
   RowBox[{"FrameTicks", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"3385324800", ",", "3385843200"}], "}"}], ",", "Automatic"}],
        "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->63588356],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1uEzEQ3mR3EwmptCkXBAfCzwGKBIg7QqICTkFCUcV5KUXtAYpKH4Ej
fQAkjqUvQAQPwAWkSFw58yLG63F27Im99totDSGR1puxPd/8eGbs3R0U+9tb
r4r9nc2i/3iveLO9s/m2/2h3j3elrSRJRvx6dz7h/xn/J64RY/wO7S3eprxz
S94vit7bZVuSTPzEqEpfELOuS542v+f8nmSiW/5yOZqk2Nvm18CLqxwtZ58R
gzfKtlvJBwbJ1lZ0K+luzdwnTXEytFmfIYAq3fKKQZmu4ihcFGXgw++hxxrR
X8zqTANSfVKDPt44qJe2XmvKGLSZIRJyH038UAL8s+zko55wc4Ckm6R3Sfom
lfenjnHw4cjS6vlCNZh45NA4mk5ZIMBy6Pl0+PP+vQ8H778llwkfzf9V3rQa
SIA6wMEfrn8se/sO/JUJT0MLfnz/vfv689cvv6QF4/FYk4B0UwvUGVdnAlvN
gw6DyKEZ5Y+2IhGuOTh6ch5whMs6Dc55t2/hmTr7VsUMrHHLwfb2BP1s4wgK
mhNJyVlr7Ra0IYNBFtY1f1m09nQITcfDq9rfRS5JF6J9/8hYbKU0IdbRYRW9
K/UMR/sf8jrOM8CBFeGlt2euML0CUE67lsDJ8/l5cVTmsz/nYuX/Lc9khloR
V3kmuwe0gmh0llxierxvWCX5n+rNMjAzqAyszPRprx1oD+6NdnviZdWtyhTO
4oR/SpzHa98lpufLerDWgIRZEYuEMV+PNO/rPSuRcofpkXLXKpvuCqLaeuQ1
SMAIskvQdwnX20ezHIwvu5zjP6vTKk19Ev5cQZEnb9pi9mK1xlOc+X0GeMD0
SO/XynYjYUTHImHM1iMtamITzwzJetP3D/6eGpL1pkj+VgzJeocjzcZpKTVU
qLjqdJLn3XjsF0yPqXPMVP2mv+vYnjkADyOrxxp+PXDqis/rqOuJ+jiZ9xP/
WeGtKgYcOEjTL0WAU619JE5VUzQc+JZm+x4X3yatP91509c=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->929235401]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->544428247],

Cell["Include a specific tick label, length and style:", "ExampleText",
 CellID->135608639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Range", "[", "10", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2007", ",", "4", ",", "10"}], "}"}], ",", 
   RowBox[{"FrameTicks", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"2007", ",", "4", ",", "15"}], "}"}], ",", 
           "\"\<tax day\>\"", ",", ".05", ",", "Red"}], "}"}], "}"}], ",", 
        "None"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21011029],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1uEzEQdrKbtOJAKb1wS6E8QAXiApRKDZucuNEUAZelQmqRSlFb1JeA
B0Dqse0LEMEDcAEpUq+ceRFjj3d31rN2GKtZ1BRWWsdjz/dlxvMja5+kB1uv
d9KD7c10sb+Xvtva3txf7O3uqaWoIYQYqvfwhlBzqWbwDqVUv/tqbCpxFaT3
eoz0LjziIay+VKNeFBGI8FA5VtNYT9q4BjRqfFSwiDZy57vN0n/mTGK2qofa
2t4V5IwL3WwvIl5EtlaJxcHGtfCKz8IqRk/vw/KL7CTpbtNxmoVejP+MFj9A
i0s8c0TugtZOhklAGo4d35gDKxj6Y1bNQeSPy6eWmjw3vhV6fad2NUZA3jIr
J8dnqyufPn74JtaJJT01NAIYTd4qsqR7pFefEr7HuU6ghT++/9p9+/nrl5/n
trCssQHyaDSqlaucee0sV1ps9LUM8YxoJNm60eBz1aF50e27PJ5oO66DBtZs
l23vPMgb66emQCvIUs56ew/Ijgw23Finfm5aW20i031+ldbLpEXK4O9nsQyt
dBfDOJnXcWYyO/joaaiDME+WpF0xd9ie3ZJ2xVCk3yqDxHrgI6c7MpOyL3ZU
RFg95T3MjCD8tdvAXWln3E0vN71NN53cWsFwYi5STuxFPM6qvZitfnsdPP/v
RROpmp60c2aO7VlCMoMi/VYlJO585L8UGb4nAxLDvvT1M+grjowfkFgig93P
ZgiO9qhBHtlX6amOLPKc/65D+wv1gX/vcn1LCO3y5e5DcdNzZ7oq7cy5J7n5
apCYMaFIrH4beblruEPOe4ntWYec9222VR1y3nxkPd01clRgWPWF3zTq5Fom
MV2QrupuOXldHW+ZRHpeBn69+qOtmAto60TPVFz0u9UaeFfELBBXxCYQV5y7
hTs2CdL4DaKNrtY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7606256]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "GridLines",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->698067718],

Cell["Include grid lines at specific dates:", "ExampleText",
 CellID->588297020],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Range", "[", "15", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2007", ",", "4", ",", "10"}], "}"}], ",", 
   RowBox[{"GridLines", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2007", ",", "4", ",", "15"}], "}"}], ",", 
        "\"\<Apr 22, 2007\>\""}], "}"}], ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->76430056],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWbtuE0EUHe+u7SSAQCavKglleDRgYShQhBAvB5IKUVsRUlJAopAPcEEJ
FRUSZeAHsOADaKCipeZHhnnsemaOZ7wzu4ljR7Hk2b2zM+e+797dfd452H71
unOws9VZebzf2dve2Xq78mh3n03FFUJIj/3fLRJ2TtmZ+PcoZUc5brAxZpPr
6XFOzG7ykZNU/MRVnZ4Vq56keyJ2rLIjScR0+qtqVyN2bA5dzYnEOkvIUz7W
+9zlgnRZpEnG6To/JkpScwU/vRmAVgM6AaxKX75qn7nGOkimXARtfWyVow3S
Ci61Qbh8eW55Ik3Bvqjvs7bGQ47Cu7HybpTGiKEXO73ttVN4pgpe1Hlr0l+0
rm3BqgsDVrF7G3OB78v0jjL5Lde5DeO+jD3HaMY/+iWz2aH1amzXINX8y+Ef
dvLh/U8yDfuQRq+WpUeNXwmwjoythw8+p7OYaafBNkmBaPn969/um28/vv9N
47nb7abr1oFeYEOIxfUVd8YCW68tvK5kWcaPd3NQ5tN1hFwqzL/czjMpj05K
feeMoFnVXLv3iVfNa8H6nhMrXr74yhBYhclFUPq77wKCJoN3Timtylp/aTGz
akDj9eI5a0PmZB7iXLpulLJmd3O0cznEYXSxelWnZvcx/jnGuS9QM7eWC0s9
T80cy0NyayGRVAaFIU2G7YvtTCzRXOwemdU1OQrixPqDK9SMwVlvXvj0FVl5
8QWSh4rOPB6q0vnxGNRHxa+/Phbcs86q1E4u9w1qxtd0YX2vUzOK8pDcWkgk
FSNhSJPhtTApsbaJWkIG7/st8OYzpwxmjcPnSaxTLfCtGze092llvt7c+Mh9
7UbGWoO6h/dpiBjTst2UWZEQZ9x7KRkFKnruO+XxQ1LxUhZJ1YLhSJOb+w2w
Pb7P8Je6AbZHJH8tGmD74Uhhto8t+Vcu98J7kVFiL4F/rzp56bletfKxVbkl
8Driu59Ow99RSV4qLty6HKtPyHF2a6vgr2WnHH5I7me//CxaBXsjwslXtGE7
m2BJ7Pjz9W+CBRHBX/8mWHK4LKPq7rAWiiz1qIVrYFnsk8N6p3xO7t6+fJe2
Bp5BDqp+6fVx4MteYa8d/Zs1W3cZ0g22wbuLVK98eV1gGzy2QH1zpJ15Iu3I
Fd9xfrc+BdY6X1jqKbBcWSQV0ybS8drjMh+Svj1MHYw78AwgT/q3REEnzH9s
Sn4xNW2e1Q+bLKdCdx5xbIpHnIod+S3e9T2//Egq/wGr6EWE\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->615390660]
}, Open  ]],

Cell[TextData[{
 "Make the first grid line ",
 Cell[BoxData[
  ButtonBox["Blue",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Blue"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->80117335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Range", "[", "15", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2007", ",", "4", ",", "10"}], "}"}], ",", 
   RowBox[{"GridLines", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"2007", ",", "4", ",", "15"}], "}"}], ",", "Blue"}], "}"}],
         ",", "\"\<Apr 22, 2007\>\""}], "}"}], ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->340919349],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWbtu1EAUnbW9eQEChc2jSkIZnhKsslCgCCFeCyQVol5FSEkRgkI+IAUl
VFRIlIEfYAUfQAMVLTU/MszD9sycnVnP2MlmN8pKO/Ydz5z7vr62n3f2Nl9t
d/a2NjpLj3Y7bza3Nt4uPdzZZVNxjRDSZf9384SdU3Ym/l1K2VGOa2yM2eTT
9DgjZtf5yEkqfuKqTjfEqsfpnogd6+xIEjGd/ura1Ygdm31XcyKxzhLyhI/j
OXe5IF0WaZJxepwfEyWpuYKf3gxAGwM6AaxaLl89Z66xDpKpEEFbH1vlaIO0
gstYL1yxPLc8kSZgX5T7rK3xkKPwbqy8G6UxYujFTle8dgrP1MGLOm9N+vPW
tS1Yda7HKnZvYy7wfZneUSa/5Tq3YZzL2HWMZvyjXzKbHVivxnYNUs2/HPxh
Jx/e/ySTsA9p9GpVetD4tQDryNh6cP9zOouZdhJsk5SIlt+//u28/vbj+988
nmm6Tsb//v5+Ss+xIcTi+orbQ4Gt1xZeV7Is48c7BSiz6TpCLpTmX23nqZSH
J6W+c0rQrGqu3v3Eq+aVYH3PiBUvX3xlCKzCFCIo/d13AUGT3junlFZlrb+0
mFljQOP18jlrQ+ZkEeJMum6QsmZ3c7RzNcR+dLl6NU7N7mP4c4xzn6Nmbi2W
lnqWmjlWhOTWQiKpDApDGg3bl9uZWKK53D0yq2tyFMSx9QeXqBmDDW9e+PQV
WXnxBZKHis4iHqrS+fHo1UfFr78+FtzTzqrSTi73NWrG12QBglvfq9SMoiIk
txYSScVIGNJoeC1MSqxtopaQ3vt+C7z5zCmDWePweRLrVAt868YN7X1ama9v
XBe+diNjrUHdw/s0RIxp1W7KrEiIM+y9lIwCFT33nPL4Ial4qYqkakF/pNHN
/Wmw/UppqafB9ojkr8U02L4/UpjtY0v+Vcu98F5kkNgL4N/LTl56rtetfGxV
bgG8jvjup9Pwd1SSl4oLty5H6hNylN3aMvhr0SmHHxI++4Vk0TLYGxGOv6L1
29kESzaC9W+CBRHBX/8mWLK/LIPq7rAWiiz1qIWrYNlJp0w+vVMxJ+ztD7NL
WwXPIAdVv/T62PNlr7TXDv/Nmq27DOkG2+DdeapXvqIusA0em6O+OdLOPLG+
9pF7QvEd5nfrE2Cts6WlngDLVUVSMW0iHa09LvIhye1h6mDcgacAedS/JQo6
Yf5jU/KLqWnzrH7YZDkRuvOIY1M84lTsyG/xru/51UdS+w+u8BaH\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->504910436]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Joined",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->415758914],

Cell["Plot data with points joined by a line:", "ExampleText",
 CellID->728398930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{
     RowBox[{"Range", "[", "100", "]"}], "/", "Pi"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2006", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->771618067],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl1AtMU1cYB/DKQxrNZjNEHJtbnQ6ChPEmzqD28hiIMhEVQgVBmaA8QucG
bMqgbCAQGTYgiIXREgaIEi0iDAiMDsf7VSjCeFQKClwQaIUqo6DuO9+aNM0v
5/bm/r/7P2f3+WifCzoMBuMb+JJf+HDsFmhKYzA7JzAYPAzmBYJNPQLTNvSf
EYtTwS2Kw+30J/PEskrwFzsrmDp5S8SMcXDvmZNhTm9VxNabF2nKr0zkIbTE
9WBrsKuzq37nqTliARd8XTXpHqOeJJYmg10EjNiYn/qJ1ffBgyNFIY2HSprA
7BGwQ2em53DaELG37hJN/dW65sk2fE7MtwS77eKP/qyYJ5b4gZ8Xf/35gmaJ
WJkEtl8r6WarVcSsCvDZoEXZs+pFYs4QeIuf+8PERJqYx1DRVKJodF5PriQW
7wM/LFp2dB/uIZadAj8e8Dj0/oFqzJ8IZraEySwZI5i/HPz3sYDJS8bTmF8O
js+9YeUqeIH534CFM5UlVq44L6mZGp7XdKpPJUerT4BV9rciDG0Widnx4K4I
7XiYaJbYuxQ80ugg8gmYIObLwP05pmNXStuJJVpwdvaQ4FxXE+bf+5KmHJVF
RgmRY5j/OLhmS1xy6AczmP9H8CG+l0bhuID5i8EaLiO3PAXnJe4BGyXHTVSX
o2Wr4EBZTnmICK9nfLYMz3c3w3f6Ed7P+hhYPfXCrk1PQRwcC15qyOnuC39M
LBCDM8faRv3MWjB/J/jy92pBTbcC82vAXiGmqWW6mJf96QpNZWgfVG7uX8D8
R8B3DHp3HKzDefG/Aw/p2QlTvkVLfgMzrfQ7tm/C65Vt4IEl47QgKb4P1jK4
hLqtiRaPEnM+1tAUxz33prlXA/b/K7BEWLhyN6gT8/PAKfHbU6e3YR9kQnDP
4NtrzfOzmL8FnHPUPOrKWeyTtQqcNCq/JH+K8wr+8BVNpWmYbXEWaIEL2Dde
lhfp+4JYGgU2Yhm4OTdjn9W3wEVlKTNc63+w/83gaNuOqv21ldj/BfAPFn49
ARl9mH/Ha9g/4y5ZXFvcTxIOODPEMf9EG435w8GT7UWt2qfYJ1YOOMZwdf3M
a5wXpwns8NLM894w7lfeHDhdPOdfI8L9LjZchffZnJ7/ph7PA9lBsNg7yim/
+gn2/yJYN9R969OoAux/FjipTliUdXoA8zeAo23sTh/wmsL8M2CTJzeTVvLm
MD/rX5raY79meNwH96v6ALjlZF5k9zucF/sCeEXib+wWi+veN8BVxiaFzgr8
P78OXPBuX7H+Pby/5Bm4tcBU4WEjx/6/twb7PyR1U/CeDMy/H/zlVJz55Die
d5zz4NLGnYbMYMzHywCLF3w7jgb9n78G3BShe8W1FucjU4KXjc2y2Os4P8ZW
LU3lZv+xm2eA69YOYKdHV/eGbcPzLjgIXPan6MhAFr4fQTr4I7k9nfi7DPtf
BZZeK59PdqvA/ArwA5f2Xze4w5ifuU5T20IdCj3DsR/etmBtw8t1HRPsDz8A
vHHxlc59Fs5Lco1cn7d6lUujlRLwOat6j8Dr2E/WGLj51Z2qBEc87zj6GzQV
Iny+a+Iy9ptnBfav2OBJ2d3Yf3/wRGaLhaK+FvP/QtYTbkd29Y4c/g95FPLg

     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  AxesOrigin->NCache[{3345062400, Automatic}, {3.3450624*^9, Automatic}],
  Frame->True,
  FrameTicks->{{{
      NCache[3345062400, 3.3450624*^9], 
      FormBox["\"Jan\"", TraditionalForm], {0.020601132958329826`, 0}}, {
      NCache[3347740800, 3.3477408*^9], 
      FormBox["\"Feb\"", TraditionalForm], {0.020601132958329826`, 0}}, {
      NCache[3350160000, 3.35016*^9], 
      FormBox["\"Mar\"", TraditionalForm], {0.020601132958329826`, 0}}, {
      NCache[3352838400, 3.3528384*^9], 
      FormBox["\"Apr\"", TraditionalForm], {0.020601132958329826`, 0}}, {
      NCache[3355430400, 3.3554304*^9], 
      FormBox["\"May\"", TraditionalForm], {0.020601132958329826`, 0}}, {
      NCache[3346272000, 3.346272*^9], 
      FormBox["\"\"", TraditionalForm], {0.012360679774997897`, 0}}, {
      NCache[3348950400, 3.3489504*^9], 
      FormBox["\"\"", TraditionalForm], {0.012360679774997897`, 0}}, {
      NCache[3351369600, 3.3513696*^9], 
      FormBox["\"\"", TraditionalForm], {0.012360679774997897`, 0}}}, 
    Automatic, {{
      NCache[3345062400, 3.3450624*^9], 
      FormBox["\"\"", TraditionalForm], {0.020601132958329826`, 0}}, {
      NCache[3347740800, 3.3477408*^9], 
      FormBox["\"\"", TraditionalForm], {0.020601132958329826`, 0}}, {
      NCache[3350160000, 3.35016*^9], 
      FormBox["\"\"", TraditionalForm], {0.020601132958329826`, 0}}, {
      NCache[3352838400, 3.3528384*^9], 
      FormBox["\"\"", TraditionalForm], {0.020601132958329826`, 0}}, {
      NCache[3355430400, 3.3554304*^9], 
      FormBox["\"\"", TraditionalForm], {0.020601132958329826`, 0}}, {
      NCache[3346272000, 3.346272*^9], 
      FormBox["\"\"", TraditionalForm], {0.012360679774997897`, 0}}, {
      NCache[3348950400, 3.3489504*^9], 
      FormBox["\"\"", TraditionalForm], {0.012360679774997897`, 0}}, {
      NCache[3351369600, 3.3513696*^9], 
      FormBox["\"\"", TraditionalForm], {0.012360679774997897`, 0}}}, 
    Automatic},
  GridLines->NCache[{{{3345062400, 
       GrayLevel[0.8]}, {3347740800, 
       GrayLevel[0.8]}, {3350160000, 
       GrayLevel[0.8]}, {3352838400, 
       GrayLevel[0.8]}, {3355430400, 
       GrayLevel[0.8]}}, None}, {{{3.3450624*^9, 
       GrayLevel[0.8]}, {3.3477408*^9, 
       GrayLevel[0.8]}, {3.35016*^9, 
       GrayLevel[0.8]}, {3.3528384*^9, 
       GrayLevel[0.8]}, {3.3554304*^9, 
       GrayLevel[0.8]}}, None}],
  PlotRange->{{3.3450624*^9, 3.353616*^9}, {-0.999975406741776, 
   0.9997846620634563}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->None]], "Output",
 ImageSize->{184, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12720115]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16460060],

Cell["Plot multiple datasets with points joined:", "ExampleText",
 CellID->248426405],

Cell[BoxData[
 RowBox[{
  RowBox[{"data1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "1", ",", "0", ",", "0", ",", "0"}], 
        "}"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "15", ",", "0", ",", "0", ",", "0"}], 
        "}"}], ",", "12"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "30", ",", "0", ",", "0", ",", "0"}], 
        "}"}], ",", "15"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "11", ",", "20", ",", "0", ",", "0", ",", "0"}], 
        "}"}], ",", "20"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315320575],

Cell[BoxData[
 RowBox[{
  RowBox[{"data2", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "5", ",", "0", ",", "0", ",", "0"}], 
        "}"}], ",", "15"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "10", ",", "20", ",", "0", ",", "0", ",", "0"}], 
        "}"}], ",", "8"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "11", ",", "10", ",", "0", ",", "0", ",", "0"}], 
        "}"}], ",", "5"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2006", ",", "11", ",", "15", ",", "0", ",", "0", ",", "0"}], 
        "}"}], ",", "1"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->180169653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"data1", ",", "data2"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->49887399],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    LineBox[{{3.3686496*^9, 10.}, {3.3698592*^9, 12.}, {3.3711552*^9, 15.}, {
     3.3729696*^9, 20.}}]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], 
    LineBox[{{3.3689952*^9, 15.}, {3.3702912*^9, 8.}, {3.3721056*^9, 5.}, {
     3.3725376*^9, 1.}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  AxesOrigin->NCache[{3368649600, Automatic}, {3.3686496*^9, Automatic}],
  Frame->True,
  FrameTicks->{{{
      NCache[3368736000, 3.368736*^9], 
      FormBox["\"Oct 02\"", TraditionalForm]}, {
      NCache[3369945600, 3.3699456*^9], 
      FormBox["\"Oct 16\"", TraditionalForm]}, {
      NCache[3371155200, 3.3711552*^9], 
      FormBox["\"Oct 30\"", TraditionalForm]}, {
      NCache[3372364800, 3.3723648*^9], 
      FormBox["\"Nov 13\"", TraditionalForm]}, {
      NCache[3369340800, 3.3693408*^9], 
      FormBox["\"\"", TraditionalForm]}, {
      NCache[3370550400, 3.3705504*^9], 
      FormBox["\"\"", TraditionalForm]}, {
      NCache[3371760000, 3.37176*^9], 
      FormBox["\"\"", TraditionalForm]}, {
      NCache[3372969600, 3.3729696*^9], 
      FormBox["\"\"", TraditionalForm]}}, Automatic, {{
      NCache[3368736000, 3.368736*^9], 
      FormBox["\"\"", TraditionalForm]}, {
      NCache[3369945600, 3.3699456*^9], 
      FormBox["\"\"", TraditionalForm]}, {
      NCache[3371155200, 3.3711552*^9], 
      FormBox["\"\"", TraditionalForm]}, {
      NCache[3372364800, 3.3723648*^9], 
      FormBox["\"\"", TraditionalForm]}, {
      NCache[3369340800, 3.3693408*^9], 
      FormBox["\"\"", TraditionalForm]}, {
      NCache[3370550400, 3.3705504*^9], 
      FormBox["\"\"", TraditionalForm]}, {
      NCache[3371760000, 3.37176*^9], 
      FormBox["\"\"", TraditionalForm]}, {
      NCache[3372969600, 3.3729696*^9], 
      FormBox["\"\"", TraditionalForm]}}, Automatic},
  GridLines->NCache[{{{3368736000, 
       GrayLevel[0.8]}, {3369945600, 
       GrayLevel[0.8]}, {3371155200, 
       GrayLevel[0.8]}, {3372364800, 
       GrayLevel[0.8]}}, None}, {{{3.368736*^9, 
       GrayLevel[0.8]}, {3.3699456*^9, 
       GrayLevel[0.8]}, {3.3711552*^9, 
       GrayLevel[0.8]}, {3.3723648*^9, 
       GrayLevel[0.8]}}, None}],
  PlotRange->{{3.3686496*^9, 3.3729696*^9}, {0., 20.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->None]], "Output",
 ImageSize->{184, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->507837549]
}, Open  ]],

Cell["Only join points for the first dataset:", "ExampleText",
 CellID->29786356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"data1", ",", "data2"}], "}"}], ",", 
   RowBox[{"Joined", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"True", ",", "False"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->23794308],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->226312263]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "PlotRange",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->857486394],

Cell["Restrict the range of dates to plot over:", "ExampleText",
 CellID->4490604],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"10", "/", 
    RowBox[{"Range", "[", "100", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"2007", ",", "4", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2007", ",", "4", ",", "15"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2007", ",", "6", ",", "15"}], "}"}]}], "}"}], ",", 
      "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->361584413],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWktPFEEQbnZnFxdWZAPhkaCwSFbhQKIe9LKCkYfEEORgPC/ECAfFIMQ/
4EWjNz34iDERuXqQyMmTidGExKtn/wj2Y/oxNVPTPbMLAmGSramenf7qq+qq
6tnHbG1t6e792tryYm1gerX2cGl58dHA1MoqvZRtIoRs0deTHkL1Xarx19bu
Lj0LWaUyQy+u89EYk1l2Dz/IKr96gUp2kWT5kMibSF6MxSH0KR+P3Zo35rBj
gKsXmWxVEzBJMj7StMFJXsfGTO3XVprjkRtg4aTVDwRjIspGXo+lUla2ZFQl
c+KZd0tfJsFa8ffA2kVjzgGGw4G1z/rnWf88YuRQWLZTucFttwPU82A8CMYj
YHyWiiaFxHgOgzsg70H/Psz2zs5OYKYeB20lmXmar96njd9j1dfL9z5T+eL5
dzpMh3aKiU6BJnBMxcQXyp3bm1QZr76hcvL6OzpMZ5dnVdlqTigz0++VOVMx
aQjl18+/Kw++vHr5g8rtr3/okEStqOYxw0Ql7P+zp1smIathoUxce6sMm4pJ
SCg558wZ4+mSNEDzcx9MnlY+SiEdKjPNus4aLPmYvjwL88s8Xd0zKT6SGx+/
mcx5Z/F5epoDITnA1MZylIk+rAJiiFpDmUNrPsg4DxjK/geZVpjoxZhiRRLD
1M89baHsW4YMmwFDuMNAprzrdzkSxIqGKj2OEUzKr4+JDpCZ7rTE04UDL557
4SsxzLqYKFmTMIITRDI4GXXMci0DqiSKR4mJdusKgswaRTlg/beNC+BmzBpc
AvPdd+BC0BLwKBzQK7G+xFni9dxq9YlcTW3BMyzEuEDG3dajSO/AUk7RnXKO
/LkodiBlGLsbzv4PRUU0nBzkpjMi71CF8BpRrIXaJsO65YzVz0QLthr0TQoy
b10J3lNyMEc8MA8+R+GrwHtcXnmo+OQtiNF9g6s5he6/AbtIb9CmimrB3aZ1
ZzTH3UycwCKf1iqLueefmbHuyJUpWtCxvdTcAaJi2ImsW1tKb+STJrRTQtaq
tCd2wuWfwI6Rh3CnhxnBP8/khFeP17f9tep0tiWrUVSTYi325VR1WETW04aI
95si4NabGqmAcEuGyPxuAZz6UsdLVK3u6TYk3DuRK8o7cqZOJO1deiQPiXgy
RF1nmlM5dcQ9EHEbUswOYT6DS47N5q6hV2PI3YrLM3XAio5KY63wfs4UFSwb
fuwukOiTQRLmWRl7f8fWUa+kRIVd3TPQdbQToIOenpER8DF1NrpjYp8xHCqB
kk8WczVTPOHt4fd9DfEvla3DNXO/IuPU8xpUx3vXIaJ7hg0R62bYs99h8b3+
THD9XuVg5PBRr9HDN3PfuhdPd3nA70nry2CIxsujQbXmhp2sh/1/vgcP+7in
Hft3NCKjx/BXe/eZyf4xIP6FgP1PoX5Jmv4BiUulAA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->588791646]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Prolog",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->344422011],

Cell[TextData[{
 "Place text using a shortened ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " as the ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " coordinate:"
}], "ExampleText",
 CellID->387433594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Range", "[", "10", "]"}], ",", 
   RowBox[{"{", "2007", "}"}], ",", 
   RowBox[{"Prolog", "\[RuleDelayed]", 
    RowBox[{"Text", "[", 
     RowBox[{"\"\<linear trend\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2010", ",", "1", ",", "15"}], "}"}], ",", "6"}], "}"}]}], 
     "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->204640636],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW8tu1DAUdeOk0wLDzLQLBhYwP4JYIGDFErEOFVK7gKLSH2APH4DEoguo
hNQdFXwAG5BGYsuaHwl+xI7j3Eyu85pMmkjjxM9zX76+iT1Pw9PDl6/C06OD
cPHkJHxzeHTwdvH4+IQV0S1CyCX7vZsT9hyxJ/G7jCJ2N9NbLPVZlcfuHrtT
6z4F6qmRz6sXD0RevHyS00404w+RuMjNAjw57JyngeylU9FGjVWUV1g5owS6
lVnqJ30l59jeJpfEsa9vUT2pRLUoIbfhcgfZTeAREBTMkD1tvqcOiL4DTp6M
7jhKhFvnPtQGgbiH6hdAEsGhGa3K0uguFUhKDjS3JiHl6/CS0Z5L+E+ybVJq
SMtBLuNV4yDkM2m1v7k6uPVKzRhRPo/glUfdZw3VQ341r52n7T+7gsp0O251
IXJBRr58lDN2H62oB9YXe7VqO5+iaBXtNJY0ocvlMq65B+broYiIa6U0jZ44
ygryfpJfP7KyN9vjNYU3jvH2ahzf1OG4RT56hxN72i+f/zy4//HD+5/Smzdo
BYQ+f3bOsB49/FQrVsYiYs5+//p3/Prbj+9/G+Wsd3Yx+AUnT+637L/NeBB8
26HJjF7UhDuycOyYTOIms7su3B0LR0XREo/N7xfhOZ/fVfBMu4HwhoigTry+
zPyrhiPrK8YKDvYg8SrGCyXsQ9ZXjBw6rMdNxOmDvyhaQbuCezdKz3PUyloQ
GUFv+RLHMWIA9GeuWwSxjklcx8ihA+tm23jrste+zPerjlMqXqhgD6XihRrs
o1S8sEF63AScPvgLrH/nb6g7+tVfXFGy0xAQtUeU9AiMunQvvj5fL0mv+xvr
Lk8Qe15UEW02kqUpOrK7URSBoCkpinHQPEPRDZZXpTdPsyirPJhbcz1OTNQG
yeG3INbiaERdlXQc2CQJ7m6YJOalOVoeZZnU4/rFmi6I9nI0TRGzcdfSp3mG
ResxsQNd4at2scMZ2f2AcagSYknvYvKB0qNRv58Zd2a1uFaSMp5C+6qQ3/MA
DU+tdmrftqyk+rKeDDjpPCoerdEeUPFoA/aBikc3WI8uOMM87u73hfp3PMAv
V5WiOByiFVcBcVRdsgW/XXVqN2nYx6oyfp/9y6bigHFDg/YAxg0t2AcYN/RI
j6twhnmMxzG+IJHk20VbXjfnfHmDJzbEmhvo+R8z70INb7DuU7naqyi9uUq0
U2eM5Rk/5qtYEfNVJXRy5tD+qyw2/pmkznhfiKK8s93lUrL1HxLGO40=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->672609203]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Ticks",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->15852971],

Cell["Give explicit dates for horizontal ticks:", "ExampleText",
 CellID->294223479],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Range", "[", "10", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2007", ",", "4", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"2007", ",", "4", ",", "12"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"2007", ",", "4", ",", "18"}], "}"}]}], "}"}], ",", 
      "Automatic"}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->510369518],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1KHEEQbqd3XSH4A3oQIrgR1EBySs7Bg5icgoLInicSdvegBjVvYR4g
kEsgMQ+g6APkksBCrjnnRcb+26nusnR6unfdoDMw01PdXV9VV39d3TNv0+PO
+730uLubNt8cph863d2j5uuDQ1HFxxhj5+L+OM/Eeybe1H2eZaLUz2fiyUVl
25QLqva5fEoxU5dqteXHqtey0UlEWRclq6lqc9VNK+NQm4h700tLtsrej1Tj
inw2cvtawagllm9SbtzSd6ssTg3G7PaQrxO5b/Vcwepu41haGGXTR9/Dj1Xk
v+o1fh0Q+8MJf7xxwC9nvlatNv2sEUyo+3jihxIQn+lCPRyJYg1t6SmqnTSx
4abcLmjXMbRX6QzS+KpqlT/8+7c/ouHTyU/2RMm9Xs/06iB5VmlJaz9YPh7+
+9c/8X558dfog5UOkmdJX5oRWkW+hmvJOPrF4649q8ZTRcEeT76K1159lqt4
OsjmlJJbO6cCZWP9iyeKu/fiHZDK0dqOyBkH+2cyZ/jZwXlyHMm43S+Co0OV
YhiaDDgV13C022Q/VHtHbRj/wpCqlR0/nsXMzQfdElqw/stoidX8Lj2Vq9lP
q5rVYdmoEWfK8GzRz+6W4Jxew9Y49o+XxtV7CDC8RdrBXwMJaYfKxHgvjMEv
HgfshbQdAnMAs2DnbLlDhbPkPq7TUUdBy8DwjQgU4HEMCrA0DOXhcGdw43mR
uSx4SaLgnH/TyZtGB3bQ6O4eUPQvirYB3KFtDOccjvMzjke5czhG6/9rCd1Z
7QyOMf6HU/jgWLyeuSxeikABtsagAB/DUKpcVt7GTuayYCYCBVgQgwIsCEMZ
HQs4I06fwbko/hzbRnM7VwKXysBtNMsaz85v1//Z+/kIX6oaM/5bZFgxvXnm
799pHX/PJREowJoYFMgNgCKjdkKOl41dAVfbaYY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->440395914]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->332390384],

Cell["Give explicit dates as date strings or absolute times:", "ExampleText",
 CellID->246764468],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Range", "[", "10", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2007", ",", "4", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<April 12, 2007\>\"", ",", "\"\<April 18, 2007\>\""}], 
       "}"}], ",", "Automatic"}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->337869080],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1KHEEQbqd3XSH4A3oQIrgR1EBySs7Bg5icgoLInicSdvegBjVvYR4g
kEsgMQ+g6APkksBCrjnnRcb+26nusnR6unfdoDMw01PdXV9VV39d3TNv0+PO
+730uLubNt8cph863d2j5uuDQ1HFxxhj5+L+OM/Eeybe1H2eZaLUz2fiyUVl
25QLqva5fEoxU5dqteXHqtey0UlEWRclq6lqc9VNK+NQm4h700tLtsrej1Tj
inw2cvtawagllm9SbtzSd6ssTg3G7PaQrxO5b/Vcwepu41haGGXTR9/Dj1Xk
v+o1fh0Q+8MJf7xxwC9nvlatNv2sEUyo+3jihxIQn+lCPRyJYg1t6SmqnTSx
4abcLmjXMbRX6QzS+KpqlT/8+7c/ouHTyU/2RMm9Xs/06iB5VmlJaz9YPh7+
+9c/8X558dfog5UOkmdJX5oRWkW+hmvJOPrF4649q8ZTRcEeT76K1159lqt4
OsjmlJJbO6cCZWP9iyeKu/fiHZDK0dqOyBkH+2cyZ/jZwXlyHMm43S+Co0OV
YhiaDDgV13C022Q/VHtHbRj/wpCqlR0/nsXMzQfdElqw/stoidX8Lj2Vq9lP
q5rVYdmoEWfK8GzRz+6W4Jxew9Y49o+XxtV7CDC8RdrBXwMJaYfKxHgvjMEv
HgfshbQdAnMAs2DnbLlDhbPkPq7TUUdBy8DwjQgU4HEMCrA0DOXhcGdw43mR
uSx4SaLgnH/TyZtGB3bQ6O4eUPQvirYB3KFtDOccjvMzjke5czhG6/9rCd1Z
7QyOMf6HU/jgWLyeuSxeikABtsagAB/DUKpcVt7GTuayYCYCBVgQgwIsCEMZ
HQs4I06fwbko/hzbRnM7VwKXysBtNMsaz85v1//Z+/kIX6oaM/5bZFgxvXnm
799pHX/PJREowJoYFMgNgCKjdkKOl41dAVfbaYY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->169006035]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Range", "[", "10", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2007", ",", "4", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"3385324800", ",", "3385843200"}], "}"}], ",", "Automatic"}], 
     "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->149316989],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWM1KHEEQbqd3XSH4A3oQIrgR1EBySs7Bg5icgoLInicSdvegBjVvYR4g
kEsgMQ+g6APkksBCrjnnRcb+26nusnR6unfdoDMw01PdXV9VV39d3TNv0+PO
+730uLubNt8cph863d2j5uuDQ1HFxxhj5+L+OM/Eeybe1H2eZaLUz2fiyUVl
25QLqva5fEoxU5dqteXHqtey0UlEWRclq6lqc9VNK+NQm4h700tLtsrej1Tj
inw2cvtawagllm9SbtzSd6ssTg3G7PaQrxO5b/Vcwepu41haGGXTR9/Dj1Xk
v+o1fh0Q+8MJf7xxwC9nvlatNv2sEUyo+3jihxIQn+lCPRyJYg1t6SmqnTSx
4abcLmjXMbRX6QzS+KpqlT/8+7c/ouHTyU/2RMm9Xs/06iB5VmlJaz9YPh7+
+9c/8X558dfog5UOkmdJX5oRWkW+hmvJOPrF4649q8ZTRcEeT76K1159lqt4
OsjmlJJbO6cCZWP9iyeKu/fiHZDK0dqOyBkH+2cyZ/jZwXlyHMm43S+Co0OV
YhiaDDgV13C022Q/VHtHbRj/wpCqlR0/nsXMzQfdElqw/stoidX8Lj2Vq9lP
q5rVYdmoEWfK8GzRz+6W4Jxew9Y49o+XxtV7CDC8RdrBXwMJaYfKxHgvjMEv
HgfshbQdAnMAs2DnbLlDhbPkPq7TUUdBy8DwjQgU4HEMCrA0DOXhcGdw43mR
uSx4SaLgnH/TyZtGB3bQ6O4eUPQvirYB3KFtDOccjvMzjke5czhG6/9rCd1Z
7QyOMf6HU/jgWLyeuSxeikABtsagAB/DUKpcVt7GTuayYCYCBVgQgwIsCEMZ
HQs4I06fwbko/hzbRnM7VwKXysBtNMsaz85v1//Z+/kIX6oaM/5bZFgxvXnm
799pHX/PJREowJoYFMgNgCKjdkKOl41dAVfbaYY=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 117},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->155928]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->519891770],

Cell["Include a specific tick label, length and style:", "ExampleText",
 CellID->307115112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Sqrt", "[", 
    RowBox[{"Range", "[", "10", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"2007", ",", "4", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2007", ",", "4", ",", "15"}], "}"}], ",", 
         "\"\<tax day\>\"", ",", ".05", ",", "Red"}], "}"}], "}"}], ",", 
      "Automatic"}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Frame", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119813533],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdV71KA0EQ3tydUYSohYVdgoW9YGHhLxJ/CssYtDuDkCAa/8CX0AcQrETj
Axj0AWwUArbWvsi5P3c3e5O9MBujmBxks7M737eTmdm5ybZ/UT048i9qFb+w
ceafVGuV88J6/YwvuRnGWJN/LqcYnwd8Jj/NIODfp3x0uLgqpXMxumJXPmxJ
ru7xUSwyV4rywbLHp56YZGFN0vBxJWZhWeCOdh3tzIiJjbTrgbawdxk4vVg3
3HPRr3CTWhqLgY1q4Wiahe0YMV2Qy7uhJ/GuY/BmrOfByWDxIlis8YwjuSi1
DkPMhpSaHccJxLCjHBjLm1JLnfNw/8EVr69eWdmolePjo7Ra6b+/ffH5y/Nn
ij7tbLNWq9XqUkt4pvxDjkG2pz+tdpiWpcuLNyJLiyTOMSmXSw2OKq7dpqBU
EYgeXCHE6UNGXn4H6sdP4g6YeXFlyCIZ75s98HcsQqShvTAq2C90dCfZzKLX
1OHwfBqyvzOfZk8+SN6POQsU3A8bFGQ/DTWIXjdzeCldAe22RNVIExL9Di3n
8fntfRPmmQ2SGTRt5MX9mGPkFQqKD3LrJ3ztdkL2mXkNHF14Ua85omLSo/gf
87rXVq8FyYyZsEBBXtigIOo0VP/Ehm5PCXl9S2rhmpPWuZSQ9xU6WXOGEQbX
klIUi32/IWKhOHrTp+B6gO3v3KeY/i3aVF69QmDMX3Qp3WdlLkhmxbwFCrLB
BgV3kYYahLuHOfLI6zMWKPC6DQq8TkP1zusuM7ytyXfL/j2PeXB/MmnBa6oY
uD9RfPr9HerSRoiR4rTvxX7LhxDJ/9fN4G7CsUBBFG1QECdAiV95p5yZ+QZ5
nVC4\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104641934]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Get stock price data:", "ExampleText",
 CellID->71049978],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"FinancialData", "[", 
    RowBox[{"\"\<GE\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"2000", ",", "1", ",", "1"}], "}"}]}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->59863664],

Cell["A sample data point:", "ExampleText",
 CellID->581781680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "[", 
  RowBox[{"[", "1", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->422470238],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2000", ",", "1", ",", "3"}], "}"}], ",", "42.31`"}], 
  "}"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->606063169]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"Joined", "\[Rule]", "True"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->158915315],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVnOvPHFUdx6c7O7vPpTfu7QMYFNCg/gvmSRRBQFLrJb5AYwqStBDE0Boj
EAK+wKigEQiKIBdBECzlqVyFkkArl2pDo7aGRwkEDKLRxkTCCxKT9XN+3zNn
Z2dndmdmF4zNsju3c873d7/M4Tl707bN51+0aduW8zadcPolm766ect5W084
7eJLuBSviKLoIf67el3EcY8j+++hXo/f4e8O320eaPHb4jfO/S6U3G/56+tL
7rfd7LFb2f6VPpf+HmNouu470ajwbWPSucadu8N11Wfp9EelNxaqj07CaH/1
uKngP9Kuz7jvdhZf3XnWV5uhmIpaK8eNRhXTPVtjVNEsCzWfbzR+SMbvmRD1
/xHt2fFNKI9Sa3e+p8gC61J9zP9wnpQLx9YZO2Al5q3M8xX5xfT32Ib38354
YcRz7vdoQ1MWLVbxfTdPrQhnboxN4kk8Mrde/vyIKZ+nuKMoG12SIS4fNQbX
Kjt/88239+x+xQ6njNMhWmE4pfaD7qPQLvv49+3b9+HlF/8RxUsP7ObXHa6y
8wd3/vH8L+9wh4md79h+YNfjL7nDw3LPn5I7X8dXHDANa2URothkDRg/xwfL
MH3hnJ+7w7adA2jTl7Zf893d0eEVMKW65P4JW1YSpT6sAq/uved3n/7UnX1c
IFr8yE0Xf+XBSrj6vJoSnvaNNzwnPAf+8PfYnrhgyxKIEGhNROP8Tooq2KpE
GH2oCFcCX8AFqM9/7m5kF7UMLSIF26kfvRmGVdGtsF6UlWjqbZJqPEq+edWT
YEGjWJtvj4VLO5cOnnXGbVytp+erxq47677WPvvMqzrnAxsg+66f7heG/S/8
FU3imPHXXrOHAx5eWxvFOFkYjjazBxwtTqI5aS04brt1H8g2briTOQ4degtu
VMTRl0xFbgyj6Jx91h1C8a2rn4I5WzYvSd9AJNZFa6Yslxk7h/kCY5rggEVt
FPLjH7uFw6uu3PWuoEiYPLDEaaVwwAd++Vx/3bMBxze+/hhPN8AxTj8MSVeW
oUvSSlgRxQ6PWx25vPrqv7wvgE/eiqqgqaMl4gqxR8bAmfP2LQC0Uji/uO/3
vRBVERSXwPvOyGdOvkpIAHHeuduhHanc9KO9XDffE+sYI6qJoR2lSVX6L6ks
LfxWwMXxo4+8uP+F16PWG2/82/B4Ty0egawGvoy3bWejQD77Gx+buvYFRqkz
AQCbO+P0W/c+/5qvToDNDRTbx1Ge5YR44W20Vs6RwZbPuCpi7cgz80HpxLU5
N3JOOPFUPEVkRfFlrjKCelgLsdXMjoSWiCYrJcz/4Pu/TtHOk3aip5wCm7s8
xuMiDUk47hq32yEyMXFey8bnTz1frYyPvx2DLJ/CBzMCMBx2Br3Sje588Zx7
kTv3lO0RCSw2zELVchotQEtgEuuZe8gucnnMyAy0XRGzrIwPAMEMJ392135h
npXV8+EhsEGVoof5K5sC9kvzA+gxmDP8TmuRUJNkPMJJNgsCffqpl02QI7Dj
tnGRsBX+gsdjx4VyDzZjjdIivAcXOfbYJY4gkRLsozz7yfY882BIRSitypj5
7W/+Ih3Gc4EH0Nu2PvzkrpeEE03mLikJ+kziz/Gf//RPyHAeQzgZgGyk7jiY
sTyuj9POZ8EmE0POjBNUVMJ5XZtzLcj4RQdwEwpR+Dnkj95DJKoLGQxjCrjM
9KGi8eucNBZ3sR6AXGYyhFyVgHwXQCyKmrkCA5Aw1KFf49CvVkQnwnMGJXKB
zCtygc40PMPkmhUvovgTndxUL1igFHU3eGKwglKgI/MKsc57aaU9SzjmOgrE
2dtv/weYV1z+hBTDWz4joNZ5DZvdZ118E5CcPzyxqc6MoqEdbMj5M5tDSb7A
rslEQFD7GCXlxiyhQtiRCU8E7B2FHUxfBoF6va+55ozAb5lfG96KaqxD3Bef
A/fjgwf+pgqmTwFKI6oVL6Dmogvvc/PKZpGOor68IxiKKJhEh2ydRBm+Plik
1wVxHHuMDnPnSdAmab50rINEwlXGnnn6T8R9TF4VAkRxnWRgPPebYJeGqi7F
HfrIS8zB1blD9aCQjj+3iDa/ccPtwaHguOVuUDpo5ABzjt47dV1RHS28REe+
26leALyPFb6Dp4/1wgtczNckGKtCEkDh/GWX/gr0mtl5Gr/ScSO1JI5G9QTE
daSH8pVTAfMAgd9G24/v+S6e13aTwJptW+9XROSDD8UYoEvKgqGi0NDILOjF
jTc8Fx0/ktv1uz+BCnGumArXNcMCQR6dZBr+wxsfg8GgUrAVdxIZKUJlOte5
mhxrPms9sSpalndzCO3jjz8DWjlBZ6VCSx6j4MtVF8uK0A7nq9krw33J4Syw
lL8oIR63HDGqwCgQYo5C7KqujRtcCuajVlD2aGEkp6v1T0twg2sAt5q6Jbj3
7NkLN5XdYq3CPQduMZvPzqWDqhgY/+Ob9nKwbmItKfYvKgoGsO/YfqAUe5vB
KsexPWuCz+E6xPKvbXuEC9CEEQJagd5wtwNuQsMxdb2H6xWypkbHKUrWLEXp
bAGX7TIXq3dnQlRRuiXug+6I1MeK1d4bCS2ZED5LNWY/W1xZIcq0AGx+1/fQ
bdYus8IVFDZUsc76T07x4jac57D8O5FT1sd1e6wnmOBG1G32GaByKuaFL9xg
OpdTWY0aK6F3NVEVxNFqsYQp1Dcmx2FdplYuJRuCIzwQEHvdEmKwK6sg6rlq
xjoeHYCp2amiCFNWNGdipQPIFY7wWCdFrXq/AHVef9fbCHjiZeckZbnTvApD
OdksCSyjajHK0yCuEFRgvDJBdWyUMQVfspLhKLcWZGZCjWo5tXnUVpZUYKD4
QdYCxmh+eXRmtZBqoq+GTO9Wq4AQ/8Qw1mNhqTECVrOEdCRPUchyvUddaTrI
4/AEKvhIx1xpoq40z4oq9WAoAXFHLKGSSxkkAhQ/KEzUoZ0fo115ukw7Z+Eg
fFEkhH1KrXnosksf8F5bscBZ8PuLKOuSMTIQdgdrchbRTbUOy0NQrIEbQKwt
14Sb5RTGCUigs2f1oladZUoGMxniw52RVnEbmC4GDVNarJE5WmP1KBCRX0MV
FvSdu+luBS51CfD5Q7SuNQ+rcMYIaTVKiYWhe0DFV6vmEQv1bsfi66zKXgWm
LLWu9lSNgXAlTS4pYkCz3tVEc5X0NbBzgFbX7xCtAFCA+exn7oBQJIFt+45I
Ia2HSScYIYJgjSxJ6QfzyfiUavkc3eLGPEQokkEsz0l2rCgDCnreRQt66T94
xMTwwegdr8fA8TW/0bsavSDeoYsiFMpELmULSoVPDKZbSG0CTxjAE8yKlKMW
YO1NRIcDRqErV125C4hMZVSi268zAsSnnXozWRpLaw8USTBPqoOACyatUDXA
87DcvQOcHcwYfJYQR8Xd73UZreKDCzOKEyyOKiEEU/U2usrBdBU6RHKxhNei
MGrW8I0PYjaxQA5B0uIZWT90W5aRqJLi84nTbknbKVYlKBXx2SrnTCwtcbFP
UQU7UTkRtYaypV6vuBM8KP31g9xAzeXHFAD0GLYTzNkihs2qiFrKjUT9P56H
be49T+yI6aKX/OK74A4EoQBuBu2sU18CHnzn2w+5h1eb/PEeek8lYeEX1GsG
XngtUb0PPo76TpoVgcz6Q4ZMZS8UI8RPnnmrnxm15NzZaZ4Dh9u50l0jws5V
yzrd0u45aIRDCJCB8v3wAqcQooeaMb73gxZxO0tvthZJCmi16qkdqieYd3QJ
verYulAieiU4xeKNG2739KrX5GRZTC+jlI56erFZfIiT5HzuefNCXShXOyJd
yDkLn/eqt4+2GFFDNUyvLK9upbm/omd0pFGsZGLR3l+IYrW6+hTLClHKAYo1
zlGQp9j2E8Yh+47mcvdNd+fAwZSaGx1Sv0OqDGdyVc5AhdYpoUyFrMu7cpTh
UK3/3Q5vRVx/LUMb0kGlbr9t1wBt7jBP2ymFtEAIQ9RUV7bFcgq0GMKg/x16
19Dtpf532XozDCKL6dOAcvOhikgGqUqjQIImKO7JXPo0yGePpeHw9Hnfc1Iu
RihL7aUkOgauK3b3EaOzuB9m096m4CG8Lwsrw3znIT5QBV9H+NTcV+NqVOQu
xRYklKR5m5ruwjYCRSEqNyMOQvEx6Q3liQWyHYPGv29vhkbVAvbLvP39deO5
4yrNFo69NYgLOAGX/GtDXOjSYtqbH+RSNJvFpcaHvHuKK5qBPaGdQ+wlqYZJ
XFHvgqAPIS6/nWmEDaNREMeFF0jQZ0dWeac1iu8KrM6gUxhGFWCb6q/wjt3H
hbrotM8RI9crgNAv8XxLsnwbiS68FYVNQod7ETr5EreNoS66YwelWB1NaG8I
DWtzIDSKc266ydBkLU/xXNF5QKOEQ1v5hnEQgZrgSPfojozJAxovCWjrAHbr
8SnnUBmBNaiE4zTg832v5nyq2PcsxopSumbX2tQ3ZLslbb2ZVXoWTw1vOyRy
GcjqKc9lMeq1sd4yqa5fU4BStCoPCL26WNF6Mpyjd4w7vKFvr9o8yu98M0uJ
Q5U+Gq/ifm2861McVXr2/T2q11/3KGVOmjtlMGtfrKLPor1IC6i7ATXxRdbo
fPXsBByugXjb1vsz2d4QYuHB6fg9MDnE2v2MZTr/3RxxuS9opUosnIS1gBME
lHN+VwFZz3J2twkxT9B5SpVS0KTOor16VLpxxeVPYHn5/Lu6F1tVxE3EnN0l
GXaHuH48kSX0SdrwVW0vXEKSYoPTy9bLVteqLrZc3CnDNhOwLds2baCp4yxk
8vwKfaoO1e90nXRlv3JYvenEor6E05x9AB82JYf/9FMvB3w4AJ5BuOH9lo9g
whfaMRPEqBwHv3ftw+KIqgohhA8on+1nsXVJz5Yzuy4SYKo9LHH6/zMo1Ciq
YWHuhHLu5xe/3LnHgLir7S2bl9A49Q2VcfTf+wkf98LmFniWx6fSZGJ82Uyx
jw5+sDwfNCug8+8thE7eNEDx6MhItckmbCWd0IIHsjO3TsCnagHTED6YqW2X
Hp9yI+Ejh/L1m/x8P3ecULYDlYn6l0Jm6YTh0q51Z50BV0jhQo/Mx5+dSwf5
zndVmsvTHsyhMltIUG416Rezb+a0U02Kn8dGtdsAWy6rzO68jYr6PHkeCq1e
C4T026OFsyihump5tOqNNOdk/X3CxcgxhnDJxTmHXN6oGDc6CfTmuNtR8f7r
kLll8XcDNKWPeOzw1qcdvFFALIcTEMfisbOilTXxZnO4fs5Z1Oss4HES9sZ5
z2NvfUowy9Jd1pbF7Dp/dTEXZ3HlOwGENeSVi5muZKyNYS77iEuRHjr01qL6
eNNDWvj/MOZ9hcOMMqAbVJL93XBwGtiDmMNWLB/JQyN7qDPc3E+k7/SG9+Do
ChEHFQTt3udfE414KtS4v/M37O5TKwe4Rzfm6LDXV0+c9VW49XkYlNH2eRu/
9CbE8WsyBHm5yXIQmrblCsNcDkNIuZvxIBeXB3hgGtoZXk+ypNDzb7OOmiLf
teae3a8ob9eaONWFqXLW9Lgjr0HarbSowSpjuReHtwmRduOoteturZs61zAY
+Z9Fa9NMzLXBNZS36QXzom2Oce8/m6+Q33GVl5HRlIRkb1F765pLqP5uS1Gc
9fXOb05A8RQQuDj9ziLI5xTzQxiwztoYavV3xvDAedrmPMj+hYHq64c3jv79
ePP108iX/fsC+b98YLrfJlcg4mHVMDyf/b17fwsh5wmi8X//YNpYBt+B3GNH
ZX9VYvLvaMV/AQXFZP8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->253972153]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->224509542],

Cell["\<\
Plot data gathered at regular intervals and stored without explicit dates:\
\>", "ExampleText",
 CellID->272481792],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
    "56.1", ",", "60.7", ",", "51.6", ",", "52.", ",", "57.5", ",", "56.7", 
     ",", "67.4", ",", "69.9", ",", "72.9", ",", "69.7", ",", "70.3", ",", 
     "72.1"}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->345324107],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2006", ",", "6", ",", "1", ",", "8"}], "}"}], ",", "Automatic",
      ",", "\"\<Hour\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->211903672],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWk1u1DAU9kymUwlmhkql7RQ23XXgDogFKqxYItahQmoXUFR6BlZwACSW
UA5ARQ/ABqSR2LLmIsa/sfMST+zEzg+TkcaJHft978f2e3nO0/ji5OWr+OL0
OD54ch6/OTk9fnvw+OycNEUDhNAV+b+bI3KPyR37X2FMrtnyNimHpMNQXEe0
NaIj2A/Rtkg82yNX+og1IP6TY01j5nLMSI0RBApQJEer+t5gRLdpOVI9smNY
faz34CXkfIcWm0ld78oFsKCxm4et8+/CS0qqjJ4tKW0atDQUmraVbCcPv4SW
W60hi95O/HmQM5C+MF9DG/50VEAF2eqoBJ3dXNmiFaOM3GRnVAl+As4oLzOe
6WsD7HRoXDsfXE/SC8l9fQzqewXP51h5LzmnXcZzP2LykVNSXpJeg6SWln0G
ZGLUoi+ff5OmD+9/8BHa85ugPqn5OQ0R7OV4/ozKfvToU5vl0FpvsfpyuUxJ
8evn37PX366//xFUiHUePvhIrTMB/e+B+gLUKX2FTGfPFuixL/VGEKjeXBFm
gm6xbPu5spWVZRUSHPn/U86zrCtFe0u2VQtdpNwVy8m3nEh4rEAogHKup24M
mVarIk4FnSZl1d+JZVQRzqYSjXUAKPAN3h+q/kae5ApEDKn86dQbnlzLui+t
Sh2sa8G98qB+uXexA492lB7vBkZSOg2NpLTrhlTvPn4I9H/fm1YOgb59Uyb6
fRFfUv26Ue6Kn+wpd9VyNXtF20xLo+h+I55mZZYRbDqPEC4C0eOeYlyez1A7
OsRxj3zkFc5hjqR2+PJIcnVznamd3ZVivy/3+3Kv316/baHcFculzrZx6NzM
av8VMFYpxPUcpTQkZ4TWLBuz9uu3p9wuy/ETKvvsYHmtwFO30Ej2OcM22aMt
s7KLlLtiOeiPfHg/uI4nVujVcwMLgHsHp1e5mY8sdtW8yAJgc17Mp++uvNjE
XAuJKfICUD8zLGMu//LDOQHz2ltqDtSQlYK5bw099a2pKWeznntDT1mcSo2S
NePdjvB8LYxNuRTJ7tMBOyTfxRlOOPNOfnGyg9T99VmVr98o67Zf2dUjB5kn
pElFq/bjlRxf2Z3pK8nqJRr8AzbvE00=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->108554374]
}, Open  ]],

Cell["Modify the ticks:", "ExampleText",
 CellID->75289831],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2006", ",", "6", ",", "1", ",", "8"}], "}"}], ",", "Automatic",
      ",", "\"\<Hour\>\""}], "}"}], ",", 
   RowBox[{"DateTicksFormat", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Hour12Short\>\"", ",", "\"\<AMPMLowerCase\>\""}], "}"}]}]}],
   "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->853744073],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs1u00AQ3sQOBfJDD0DjcukpNX0HxAHxd+CIOJsKqT1AUekzcIIHQOII
7QMQwQNwASkSV868iNlf73jwOuvY69jEkbKb2Z/5dmb2ZzK7T6Kzoxcvo7Pj
w2jv4Wn0+uj48M3eg5NTWuT1CCFz+n07JfR3TH/x7zyOaS7SRzT1aOFM5qHM
b/DaxyxlZMw/vBWkQ0Rf571u0rRPC32aD2k+lTyJx6v5h9X3M8q3iOjvyeKs
+kDyN9Vf5SRDJZf12PiPJGXYxIe1uyzbSkpgY9H60r+8DFxSJX2gI5LZJ8ju
Y4U35NmO1ERfaoYMkl4QFVhqimheP0DSW4x9PfKyGUKumGzL5QFa0GPZRVJ7
2SMZ6B6Am6e578R6BgKt5WIbpLbsDeReYbyZcgMb8VXkQxaYQ4A4+FY91Jxc
3tok3yx3fsUZexKm+cgTi82A5RTNGh9IWrSeG9IxTc9pq15Cpcc2Qdh8J/I+
f/pFi96/+y56gPohokc11/e4OWzlePaUyX7/3scmywFKr3F6sVikpPj548/J
qy/fvv6WXKh17t75wKwzQu1vIzpENOOvkdns2UYtAqU3isD0VhRhIvkuly3I
lG1VWfKQcM//n3OWZYtytLdkU7XQRs5tsZw6J1k+cIeCOOOTFNP1IjOyLOJY
8lmnrPDfiPIy3NkU+lBYZt8ZqvqfoeTjSNIL1efpuDI8tZbhWVqWO1rXcvT6
BK129EXsILwdrcdbjpG0Tl0jae0WQ6p3H99H+j+oTCv7SN9Vc6b6fR6dM/0W
49yWc7Lj3FbL1XwqmmJJ9XgAlujVejzrlVl5sOk4gjsPBPo9y3FFPEPv6Bin
uOejcjyHBZLe4VdHUqtb6Ezv7EU5dvtyty93+u302xTObbFc6rYydh2byT+/
HPoqS3Er9lLWJKe6T96YaMzGr9+Oc7MsJ26o7KODq2sF37q5RrKPGTbJHk2Z
lW3k3BbL4fOoitMPr+ORFXr52ECIcMWbFvPdevp8zH9DUtTvCBG2GIv59r3o
WGx8rlBhyrgA1s8kVj5X9fLjOYHj2tt6DtQQlcKxb4Cu3xwRc8xmM/eGjrO8
lfKTNVO5HfH9mhubCimS3acFdkjexRluOLNufuNkB6n79VmZ129s6Lav7OqR
g84TWqS9Vfv+Wo4L/sv0SrJ8Snp/Afut1m0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->43937102]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->121472537],

Cell["Plot annual oil consumption since 1980:", "ExampleText",
 CellID->128962824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"Import", "[", 
   RowBox[{
   "\"\<http://www.eia.doe.gov/pub/international/iealf/table12.xls\>\"", ",", 
    " ", 
    RowBox[{"{", 
     RowBox[{"\"\<Data\>\"", ",", "1", ",", "248"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53568262],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"C_oil Total\"\>", ",", "\<\"World Total \"\>", 
   ",", "\<\"ww\"\>", ",", "63113.569`", ",", "60943.79199999999`", ",", 
   "59543.244000000006`", ",", "58778.197000000015`", ",", 
   "59817.16973409841`", ",", "60085.12051863011`", ",", 
   "61808.949310167445`", ",", "63095.11972944556`", ",", 
   "64965.31763254051`", ",", "66077.79013668589`", ",", "66545.88179823519`",
    ",", "67131.80859054538`", ",", "67359.45121051499`", ",", 
   "67454.63453894487`", ",", "68766.99963341946`", ",", "69912.33615947775`",
    ",", "71522.58393040804`", ",", "73330.7212147087`", ",", 
   "73994.33604841775`", ",", "75668.40964741519`", ",", "76687.78672703578`",
    ",", "77455.70456168831`", ",", "78153.73461575467`", ",", 
   "79794.22980633352`", ",", "82594.65600874316`"}], "}"}]], "Output",
 ImageSize->{465, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->353184624]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{
   RowBox[{"Take", "[", 
    RowBox[{"data", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", "1980", "}"}], ",", 
   RowBox[{"Filling", "\[Rule]", "Bottom"}], ",", 
   RowBox[{"Joined", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->955743079],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->40740165]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell["Date coordinates are plotted as absolute times:", "ExampleText",
 CellID->295105921],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1900", ",", "1", ",", "1", ",", "i"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "24"}], "}"}]}], "]"}], ",", 
      RowBox[{"Range", "[", "24", "]"}]}], "}"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->34143611],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"data", ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"5", " ", 
        RowBox[{"10", "^", "4"}]}], "}"}], ",", "None"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->351790076],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmU1PE0EYx5duW17CW8BUiBhQQ01BrQFr0AjFEDAGUTExxWNDTOCgGOQD
9APoyZOJiRf15E2iH8CLnrx69ouMO7sdZvrf2dlnuluVxE2Y7ezO8/L778zs
MLtRP9h5/KR+sLtdn7q1X3+2s7v9fGptb9+75HY5jnPo/TXGHO838375f4eM
eWe1nPXKjHfLVc6Oy9v6h6PeG/HO/FbQKDj49QzBJkP0T80lSGGGl3nZwv+h
y4jYbpgX3Ud1tamTtfGRVdu1m81gCnS8I3Txc+f0Qjul7v7XLFazUC9vTzMW
jIvc39Uphy1dGMcOxMB6pEIxuUb6CfeqNjwZ1SL606hl7PF/fr75l0eheE9l
meznpndHPuX7wfsm/P4MStH6o1/LhXTkWb/1zj2G+6ouA1DvhXpfTD2ufUf8
ybEfQBlpuXERvJT9eqPRaNaXmu2oqm2B/TLczxP9+C3c9+9+VBdfv3zx1blP
8iv6gOiZ/lW39vCD52V15U3IS7XZLqDDJx7k8P3br72nn758/knMAb3QFEGr
fuC/TfbCeQaAG63N3P3ATY+dnHsEuFesuEeBG63N3CPATY+dnHsMuBetuMeB
G61buXm/dpujJJyD5Kfl0ANX8f1C0yPOyyToc7Vtr7w6CXqht9ZZT51VwjlJ
vWg55eFqezNoN5PvYvXuNOh0meRN9KMi6ILWVWYaP9OgBz128vEzC9wzVtwX
gButzdyzwE2PnZx7DrjPWXHPAzdam7nngJseOzn3AnCftuK+Btxo3codDDJx
iF0UnA0WQA1aRv48F7/eV+pLQH6yo3GkRmnG4dUl0Av9t87B9vnT+pW931XQ
f5gUR92vE//PiFXqGiiNHqvMNApXQUdaPumMwnXQoo/shfPcAW60NnOvAzc9
dnLuTeDOWnE/AG60NnNvAjc9dnLuGnDfNHJuAedyC1cwgYpDOMJZtSZo7919
xWn1EbV7nunMDQm8uqDW9bajuEdqonep7gIzzJdM/87S+5R9y5BxaKcB17U0
jdV5Uewrxa2Ie0HXK1rPohc+0lpL3eaZabTpY0uFomMnH21oNQTcl6y4h4D7
ohX3EHBHx06fuwDc5624C8BdtOIuAHd07PS5J4D7jBX3BHBPtXBnneiVrD4P
qYE+D3FSS9s12lkgPqWNRF9j6v1LTcaZOmeavpHQs5c66bNPGiViHqXu9Bs8
l0D9E/pIhpUs9sES6D3KbMZeCfTU59OZsVcGLQYjvei4y8At2tG4y8AdHTt9
7gpw4w6ambsC3GKXisZdAe7o2Olz3+BF7oibMeXriaDF53AsvgjxevNpRD+J
Y/utK+gpoaclv/NFfS1MXjpdvwHUIXPv\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 128},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->238444623]
}, Open  ]],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 " using the ",
 Cell[BoxData[
  ButtonBox["AbsoluteTime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteTime"]], "InlineFormula"],
 " values:"
}], "ExampleText",
 CellID->814480392],

Cell[BoxData[{
 RowBox[{
  RowBox[{"lpdata", "=", "data"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"lpdata", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "1"}], "]"}], "]"}], "=", 
   RowBox[{"Map", "[", 
    RowBox[{"AbsoluteTime", ",", 
     RowBox[{"data", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->148095068],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"lpdata", ",", 
   RowBox[{"GridLines", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"5", " ", 
        RowBox[{"10", "^", "4"}]}], "}"}], ",", "None"}], "}"}]}], ",", 
   RowBox[{"Frame", "->", "True"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->319688310],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{3600., 1.}, {7200., 2.}, {10800., 3.}, {14400., 4.}, {18000., 
     5.}, {21600., 6.}, {25200., 7.}, {28800., 8.}, {32400., 9.}, {36000., 
     10.}, {39600., 11.}, {43200., 12.}, {46800., 13.}, {50400., 14.}, {
     54000., 15.}, {57600., 16.}, {61200., 17.}, {64800., 18.}, {68400., 
     19.}, {72000., 20.}, {75600., 21.}, {79200., 22.}, {82800., 23.}, {
     86400., 24.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  Frame->True,
  GridLines->{{50000}, None},
  PlotRange->{{0., 86400.}, {0., 24.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->59370346]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ListPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with DateListPlot",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=DateListPlot"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->522162299],

Cell[TextData[ButtonBox["Date & Time",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "MoreAbout",
 CellID->321311695],

Cell[TextData[ButtonBox["New in 6.0: Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataVisualization"]], "MoreAbout",
 CellID->178042384],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->85650740]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DateListPlot - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 34.0523132}", "context" -> "System`", 
    "keywords" -> {
     "date plotting", "financial plots", "plotting in time", 
      "time series plots"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DateListPlot[{{date_1, v_1}, {date_2, v_2}, ...}] plots points with \
values v_i at a sequence of dates. DateListPlot[{v_1, v_2, ...}, datespec] \
plots points with dates at equal intervals specified by datespec. \
DateListPlot[{list_1, list_2, ...}] plots several lists of values.", 
    "synonyms" -> {"date list plot"}, "title" -> "DateListPlot", "type" -> 
    "Symbol", "uri" -> "ref/DateListPlot"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[16958, 551, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->78083278]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 145780, 4027}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1843, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2466, 68, 1577, 37, 70, "ObjectNameGrid"],
Cell[4046, 107, 2442, 77, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6525, 189, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7003, 206, 350, 12, 70, "Notes",
 CellID->35506798],
Cell[7356, 220, 579, 20, 70, "Notes",
 CellID->721546604],
Cell[7938, 242, 273, 11, 70, "Notes",
 CellID->128543136],
Cell[8214, 255, 1812, 54, 70, "2ColumnTableMod",
 CellID->156973587],
Cell[10029, 311, 285, 10, 70, "Notes",
 CellID->553812165],
Cell[10317, 323, 234, 9, 70, "Notes",
 CellID->149856229],
Cell[10554, 334, 1827, 56, 70, "2ColumnTableMod",
 CellID->506900793],
Cell[12384, 392, 1115, 40, 70, "Notes",
 CellID->45469351],
Cell[13502, 434, 282, 10, 70, "Notes",
 CellID->550442375],
Cell[13787, 446, 370, 12, 70, "Notes",
 CellID->15564970],
Cell[14160, 460, 2139, 60, 70, "3ColumnTableMod",
 CellID->21418857],
Cell[16302, 522, 619, 24, 70, "Notes",
 CellID->40588176]
}, Closed]],
Cell[CellGroupData[{
Cell[16958, 551, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->78083278],
Cell[CellGroupData[{
Cell[17342, 565, 148, 5, 70, "ExampleSection",
 CellID->397673108],
Cell[17493, 572, 79, 1, 70, "ExampleText",
 CellID->740468034],
Cell[17575, 575, 712, 26, 70, "Input",
 CellID->98872995],
Cell[CellGroupData[{
Cell[18312, 605, 111, 3, 28, "Input",
 CellID->226265787],
Cell[18426, 610, 1285, 25, 155, "Output",
 Evaluatable->False,
 CellID->34417414]
}, Open  ]],
Cell[19726, 638, 125, 3, 70, "ExampleDelimiter",
 CellID->209465802],
Cell[19854, 643, 85, 1, 70, "ExampleText",
 CellID->3347631],
Cell[CellGroupData[{
Cell[19964, 648, 291, 10, 28, "Input",
 CellID->38513733],
Cell[20258, 660, 1180, 23, 155, "Output",
 Evaluatable->False,
 CellID->173027490]
}, Open  ]],
Cell[21453, 686, 125, 3, 70, "ExampleDelimiter",
 CellID->338368658],
Cell[21581, 691, 105, 2, 70, "ExampleText",
 CellID->4948224],
Cell[CellGroupData[{
Cell[21711, 697, 340, 11, 70, "Input",
 CellID->222609142],
Cell[22054, 710, 2430, 61, 155, "Output",
 CellID->90646661]
}, Open  ]],
Cell[24499, 774, 125, 3, 70, "ExampleDelimiter",
 CellID->287749260],
Cell[24627, 779, 66, 1, 70, "ExampleText",
 CellID->189181803],
Cell[24696, 782, 713, 26, 70, "Input",
 CellID->83736067],
Cell[25412, 810, 711, 26, 70, "Input",
 CellID->117138108],
Cell[CellGroupData[{
Cell[26148, 840, 226, 7, 70, "Input",
 CellID->681386578],
Cell[26377, 849, 2553, 63, 155, "Output",
 CellID->417810626]
}, Open  ]],
Cell[28945, 915, 125, 3, 70, "ExampleDelimiter",
 CellID->437997029],
Cell[29073, 920, 86, 1, 70, "ExampleText",
 CellID->601746168],
Cell[CellGroupData[{
Cell[29184, 925, 204, 6, 28, "Input",
 CellID->929039302],
Cell[29391, 933, 5909, 101, 151, "Output",
 Evaluatable->False,
 CellID->82391756]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[35349, 1040, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[35573, 1049, 268, 9, 70, "ExampleText",
 CellID->45081443],
Cell[35844, 1060, 434, 14, 70, "Input",
 CellID->270635656],
Cell[CellGroupData[{
Cell[36303, 1078, 110, 3, 70, "Input",
 CellID->77366686],
Cell[36416, 1083, 1286, 25, 70, "Output",
 Evaluatable->False,
 CellID->483322177]
}, Open  ]],
Cell[37717, 1111, 124, 3, 70, "ExampleDelimiter",
 CellID->83525986],
Cell[37844, 1116, 217, 8, 70, "ExampleText",
 CellID->432959438],
Cell[38064, 1126, 474, 15, 70, "Input",
 CellID->938311294],
Cell[CellGroupData[{
Cell[38563, 1145, 111, 3, 70, "Input",
 CellID->535157729],
Cell[38677, 1150, 1241, 24, 70, "Output",
 Evaluatable->False,
 CellID->225634674]
}, Open  ]],
Cell[39933, 1177, 125, 3, 70, "ExampleDelimiter",
 CellID->213533275],
Cell[40061, 1182, 220, 8, 70, "ExampleText",
 CellID->394625575],
Cell[40284, 1192, 642, 23, 70, "Input",
 CellID->187144601],
Cell[CellGroupData[{
Cell[40951, 1219, 110, 3, 70, "Input",
 CellID->18810249],
Cell[41064, 1224, 1241, 24, 70, "Output",
 Evaluatable->False,
 CellID->229770951]
}, Open  ]],
Cell[42320, 1251, 125, 3, 70, "ExampleDelimiter",
 CellID->499832053],
Cell[42448, 1256, 159, 4, 70, "ExampleText",
 CellID->57868944],
Cell[CellGroupData[{
Cell[42632, 1264, 297, 10, 70, "Input",
 CellID->85925722],
Cell[42932, 1276, 2920, 52, 70, "Output",
 Evaluatable->False,
 CellID->94797863]
}, Open  ]],
Cell[CellGroupData[{
Cell[45889, 1333, 373, 12, 70, "Input",
 CellID->190454611],
Cell[46265, 1347, 2897, 52, 70, "Output",
 Evaluatable->False,
 CellID->352890459]
}, Open  ]],
Cell[49177, 1402, 125, 3, 70, "ExampleDelimiter",
 CellID->433223537],
Cell[49305, 1407, 118, 3, 70, "ExampleText",
 CellID->17396477],
Cell[CellGroupData[{
Cell[49448, 1414, 382, 13, 70, "Input",
 CellID->634852428],
Cell[49833, 1429, 1514, 29, 70, "Output",
 Evaluatable->False,
 CellID->248554789]
}, Open  ]],
Cell[51362, 1461, 124, 3, 70, "ExampleDelimiter",
 CellID->45306138],
Cell[51489, 1466, 159, 4, 70, "ExampleText",
 CellID->20622360],
Cell[CellGroupData[{
Cell[51673, 1474, 362, 11, 70, "Input",
 CellID->409607544],
Cell[52038, 1487, 1257, 25, 70, "Output",
 Evaluatable->False,
 CellID->53231432]
}, Open  ]],
Cell[53310, 1515, 212, 7, 70, "ExampleText",
 CellID->360754758],
Cell[CellGroupData[{
Cell[53547, 1526, 314, 10, 70, "Input",
 CellID->741635],
Cell[53864, 1538, 1294, 25, 70, "Output",
 Evaluatable->False,
 CellID->354029545]
}, Open  ]],
Cell[55173, 1566, 125, 3, 70, "ExampleDelimiter",
 CellID->546370530],
Cell[55301, 1571, 88, 1, 70, "ExampleText",
 CellID->26450409],
Cell[CellGroupData[{
Cell[55414, 1576, 336, 11, 70, "Input",
 CellID->199919385],
Cell[55753, 1589, 1807, 34, 70, "Output",
 Evaluatable->False,
 CellID->562377133]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[57609, 1629, 222, 7, 70, "ExampleSection",
 CellID->189722811],
Cell[CellGroupData[{
Cell[57856, 1640, 231, 7, 70, "ExampleSubsection",
 CellID->467648442],
Cell[58090, 1649, 220, 7, 70, "ExampleText",
 CellID->15484210],
Cell[CellGroupData[{
Cell[58335, 1660, 405, 11, 70, "Input",
 CellID->171912587],
Cell[58743, 1673, 1256, 25, 70, "Output",
 Evaluatable->False,
 CellID->9665221]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60048, 1704, 233, 7, 70, "ExampleSubsection",
 CellID->529152931],
Cell[60284, 1713, 239, 9, 70, "ExampleText",
 CellID->905026462],
Cell[60526, 1724, 884, 31, 70, "Input",
 CellID->70487484],
Cell[CellGroupData[{
Cell[61435, 1759, 325, 11, 70, "Input",
 CellID->13895297],
Cell[61763, 1772, 1342, 26, 70, "Output",
 Evaluatable->False,
 CellID->64535053]
}, Open  ]],
Cell[63120, 1801, 124, 3, 70, "ExampleDelimiter",
 CellID->82491380],
Cell[63247, 1806, 101, 2, 70, "ExampleText",
 CellID->80984464],
Cell[63351, 1810, 622, 19, 70, "Input",
 CellID->98385114],
Cell[CellGroupData[{
Cell[63998, 1833, 455, 14, 70, "Input",
 CellID->980938488],
Cell[64456, 1849, 1476, 28, 70, "Output",
 Evaluatable->False,
 CellID->73107086]
}, Open  ]],
Cell[CellGroupData[{
Cell[65969, 1882, 455, 14, 70, "Input",
 CellID->693595886],
Cell[66427, 1898, 1359, 26, 70, "Output",
 Evaluatable->False,
 CellID->476649759]
}, Open  ]],
Cell[CellGroupData[{
Cell[67823, 1929, 455, 14, 70, "Input",
 CellID->166013156],
Cell[68281, 1945, 1395, 27, 70, "Output",
 Evaluatable->False,
 CellID->81189445]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[69725, 1978, 235, 7, 70, "ExampleSubsection",
 CellID->28213509],
Cell[69963, 1987, 232, 8, 70, "ExampleText",
 CellID->352817134],
Cell[70198, 1997, 995, 36, 70, "Input",
 CellID->351516546],
Cell[CellGroupData[{
Cell[71218, 2037, 274, 8, 70, "Input",
 CellID->58745033],
Cell[71495, 2047, 1335, 26, 70, "Output",
 Evaluatable->False,
 CellID->106262655]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[72879, 2079, 226, 7, 70, "ExampleSubsection",
 CellID->72592511],
Cell[73108, 2088, 293, 11, 70, "ExampleText",
 CellID->930137739],
Cell[CellGroupData[{
Cell[73426, 2103, 456, 14, 70, "Input",
 CellID->626977198],
Cell[73885, 2119, 1489, 28, 70, "Output",
 Evaluatable->False,
 CellID->254469531]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[75423, 2153, 228, 7, 70, "ExampleSubsection",
 CellID->512663939],
Cell[75654, 2162, 79, 1, 70, "ExampleText",
 CellID->489947408],
Cell[CellGroupData[{
Cell[75758, 2167, 365, 10, 70, "Input",
 CellID->79508687],
Cell[76126, 2179, 1799, 34, 70, "Output",
 Evaluatable->False,
 CellID->124994919]
}, Open  ]],
Cell[77940, 2216, 81, 1, 70, "ExampleText",
 CellID->207463267],
Cell[CellGroupData[{
Cell[78046, 2221, 360, 10, 70, "Input",
 CellID->612648634],
Cell[78409, 2233, 3002, 53, 70, "Output",
 Evaluatable->False,
 CellID->139218767]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[81460, 2292, 231, 7, 70, "ExampleSubsection",
 CellID->140532627],
Cell[81694, 2301, 84, 1, 70, "ExampleText",
 CellID->183285157],
Cell[CellGroupData[{
Cell[81803, 2306, 712, 22, 70, "Input",
 CellID->418010759],
Cell[82518, 2330, 1236, 24, 70, "Output",
 Evaluatable->False,
 CellID->45222059]
}, Open  ]],
Cell[83769, 2357, 77, 1, 70, "ExampleText",
 CellID->216465658],
Cell[CellGroupData[{
Cell[83871, 2362, 601, 18, 70, "Input",
 CellID->182363409],
Cell[84475, 2382, 1235, 24, 70, "Output",
 Evaluatable->False,
 CellID->2694793]
}, Open  ]],
Cell[CellGroupData[{
Cell[85747, 2411, 574, 18, 70, "Input",
 CellID->63588356],
Cell[86324, 2431, 1237, 24, 70, "Output",
 Evaluatable->False,
 CellID->929235401]
}, Open  ]],
Cell[87576, 2458, 125, 3, 70, "ExampleDelimiter",
 CellID->544428247],
Cell[87704, 2463, 91, 1, 70, "ExampleText",
 CellID->135608639],
Cell[CellGroupData[{
Cell[87820, 2468, 712, 22, 70, "Input",
 CellID->21011029],
Cell[88535, 2492, 1142, 23, 70, "Output",
 Evaluatable->False,
 CellID->7606256]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[89726, 2521, 230, 7, 70, "ExampleSubsection",
 CellID->698067718],
Cell[89959, 2530, 80, 1, 70, "ExampleText",
 CellID->588297020],
Cell[CellGroupData[{
Cell[90064, 2535, 516, 17, 70, "Input",
 CellID->76430056],
Cell[90583, 2554, 1481, 28, 70, "Output",
 Evaluatable->False,
 CellID->615390660]
}, Open  ]],
Cell[92079, 2585, 199, 8, 70, "ExampleText",
 CellID->80117335],
Cell[CellGroupData[{
Cell[92303, 2597, 583, 19, 70, "Input",
 CellID->340919349],
Cell[92889, 2618, 1485, 28, 70, "Output",
 Evaluatable->False,
 CellID->504910436]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[94423, 2652, 227, 7, 70, "ExampleSubsection",
 CellID->415758914],
Cell[94653, 2661, 82, 1, 70, "ExampleText",
 CellID->728398930],
Cell[CellGroupData[{
Cell[94760, 2666, 335, 10, 70, "Input",
 CellID->771618067],
Cell[95098, 2678, 4515, 92, 148, "Output",
 CellID->12720115]
}, Open  ]],
Cell[99628, 2773, 124, 3, 70, "ExampleDelimiter",
 CellID->16460060],
Cell[99755, 2778, 85, 1, 70, "ExampleText",
 CellID->248426405],
Cell[99843, 2781, 847, 26, 70, "Input",
 CellID->315320575],
Cell[100693, 2809, 844, 26, 70, "Input",
 CellID->180169653],
Cell[CellGroupData[{
Cell[101562, 2839, 225, 7, 70, "Input",
 CellID->49887399],
Cell[101790, 2848, 2521, 63, 155, "Output",
 CellID->507837549]
}, Open  ]],
Cell[104326, 2914, 81, 1, 70, "ExampleText",
 CellID->29786356],
Cell[CellGroupData[{
Cell[104432, 2919, 280, 9, 70, "Input",
 CellID->23794308],
Cell[104715, 2930, 2437, 44, 70, "Output",
 Evaluatable->False,
 CellID->226312263]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[107201, 2980, 230, 7, 70, "ExampleSubsection",
 CellID->857486394],
Cell[107434, 2989, 82, 1, 70, "ExampleText",
 CellID->4490604],
Cell[CellGroupData[{
Cell[107541, 2994, 564, 18, 70, "Input",
 CellID->361584413],
Cell[108108, 3014, 1660, 31, 70, "Output",
 Evaluatable->False,
 CellID->588791646]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[109817, 3051, 227, 7, 70, "ExampleSubsection",
 CellID->344422011],
Cell[110047, 3060, 293, 11, 70, "ExampleText",
 CellID->387433594],
Cell[CellGroupData[{
Cell[110365, 3075, 456, 14, 70, "Input",
 CellID->204640636],
Cell[110824, 3091, 1489, 28, 70, "Output",
 Evaluatable->False,
 CellID->672609203]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[112362, 3125, 225, 7, 70, "ExampleSubsection",
 CellID->15852971],
Cell[112590, 3134, 84, 1, 70, "ExampleText",
 CellID->294223479],
Cell[CellGroupData[{
Cell[112699, 3139, 661, 20, 70, "Input",
 CellID->510369518],
Cell[113363, 3161, 1168, 23, 70, "Output",
 Evaluatable->False,
 CellID->440395914]
}, Open  ]],
Cell[114546, 3187, 125, 3, 70, "ExampleDelimiter",
 CellID->332390384],
Cell[114674, 3192, 97, 1, 70, "ExampleText",
 CellID->246764468],
Cell[CellGroupData[{
Cell[114796, 3197, 558, 16, 70, "Input",
 CellID->337869080],
Cell[115357, 3215, 1168, 23, 70, "Output",
 Evaluatable->False,
 CellID->169006035]
}, Open  ]],
Cell[CellGroupData[{
Cell[116562, 3243, 532, 16, 70, "Input",
 CellID->149316989],
Cell[117097, 3261, 1165, 23, 70, "Output",
 Evaluatable->False,
 CellID->155928]
}, Open  ]],
Cell[118277, 3287, 125, 3, 70, "ExampleDelimiter",
 CellID->519891770],
Cell[118405, 3292, 91, 1, 70, "ExampleText",
 CellID->307115112],
Cell[CellGroupData[{
Cell[118521, 3297, 667, 20, 70, "Input",
 CellID->119813533],
Cell[119191, 3319, 1071, 22, 70, "Output",
 Evaluatable->False,
 CellID->104641934]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[120323, 3348, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[120553, 3357, 63, 1, 70, "ExampleText",
 CellID->71049978],
Cell[120619, 3360, 255, 9, 70, "Input",
 CellID->59863664],
Cell[120877, 3371, 63, 1, 70, "ExampleText",
 CellID->581781680],
Cell[CellGroupData[{
Cell[120965, 3376, 123, 4, 70, "Input",
 CellID->422470238],
Cell[121091, 3382, 274, 10, 36, "Output",
 CellID->606063169]
}, Open  ]],
Cell[CellGroupData[{
Cell[121402, 3397, 223, 6, 70, "Input",
 CellID->158915315],
Cell[121628, 3405, 6028, 103, 70, "Output",
 Evaluatable->False,
 CellID->253972153]
}, Open  ]],
Cell[127671, 3511, 125, 3, 70, "ExampleDelimiter",
 CellID->224509542],
Cell[127799, 3516, 125, 3, 70, "ExampleText",
 CellID->272481792],
Cell[127927, 3521, 314, 9, 70, "Input",
 CellID->345324107],
Cell[CellGroupData[{
Cell[128266, 3534, 294, 9, 70, "Input",
 CellID->211903672],
Cell[128563, 3545, 1343, 26, 70, "Output",
 Evaluatable->False,
 CellID->108554374]
}, Open  ]],
Cell[129921, 3574, 59, 1, 70, "ExampleText",
 CellID->75289831],
Cell[CellGroupData[{
Cell[130005, 3579, 440, 13, 70, "Input",
 CellID->853744073],
Cell[130448, 3594, 1407, 27, 70, "Output",
 Evaluatable->False,
 CellID->43937102]
}, Open  ]],
Cell[131870, 3624, 125, 3, 70, "ExampleDelimiter",
 CellID->121472537],
Cell[131998, 3629, 82, 1, 70, "ExampleText",
 CellID->128962824],
Cell[CellGroupData[{
Cell[132105, 3634, 308, 10, 70, "Input",
 CellID->53568262],
Cell[132416, 3646, 973, 18, 88, "Output",
 CellID->353184624]
}, Open  ]],
Cell[CellGroupData[{
Cell[133426, 3669, 393, 12, 70, "Input",
 CellID->955743079],
Cell[133822, 3683, 3066, 54, 70, "Output",
 Evaluatable->False,
 CellID->40740165]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[136937, 3743, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[137178, 3752, 90, 1, 70, "ExampleText",
 CellID->295105921],
Cell[137271, 3755, 443, 14, 70, "Input",
 CellID->34143611],
Cell[CellGroupData[{
Cell[137739, 3773, 314, 11, 70, "Input",
 CellID->351790076],
Cell[138056, 3786, 1587, 30, 70, "Output",
 Evaluatable->False,
 CellID->238444623]
}, Open  ]],
Cell[139658, 3819, 335, 13, 70, "ExampleText",
 CellID->814480392],
Cell[139996, 3834, 416, 14, 70, "Input",
 CellID->148095068],
Cell[CellGroupData[{
Cell[140437, 3852, 351, 11, 70, "Input",
 CellID->319688310],
Cell[140791, 3865, 849, 22, 140, "Output",
 CellID->59370346]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[141701, 3894, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[142020, 3905, 704, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[142761, 3936, 305, 8, 70, "RelatedLinksSection"],
Cell[143069, 3946, 369, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[143475, 3963, 299, 8, 70, "MoreAboutSection"],
Cell[143777, 3973, 147, 3, 70, "MoreAbout",
 CellID->522162299],
Cell[143927, 3978, 134, 3, 70, "MoreAbout",
 CellID->321311695],
Cell[144064, 3983, 166, 3, 70, "MoreAbout",
 CellID->178042384],
Cell[144233, 3988, 178, 3, 70, "MoreAbout",
 CellID->85650740]
}, Open  ]],
Cell[144426, 3994, 27, 0, 70, "History"],
Cell[144456, 3996, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

