(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23775,        840]
NotebookOptionsPosition[     18217,        656]
NotebookOutlinePosition[     19828,        697]
CellTagsIndexPosition[     19743,        692]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DateList" :> Documentation`HelpLookup["paclet:ref/DateList"], 
          "DateString" :> Documentation`HelpLookup["paclet:ref/DateString"], 
          "DateFunction" :> 
          Documentation`HelpLookup["paclet:ref/DateFunction"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DateList\"\>", 
       2->"\<\"DateString\"\>", 
       3->"\<\"DateFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date & Time" :> 
          Documentation`HelpLookup["paclet:guide/DateAndTime"], 
          "String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Date & Time\"\>", 
       2->"\<\"String Patterns\"\>", 
       3->"\<\"New in 6.0: Core Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DatePattern", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DatePattern",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DatePattern"], "[", 
       RowBox[{"{", 
        RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents the characters of a date with elements of \
type ",
     Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
     " in ",
     Cell[BoxData[
      ButtonBox["StringExpression",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DatePattern",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DatePattern"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["sep", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]allows separators that match the string expression ",
     Cell[BoxData[
      StyleBox["sep", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Possible element types ",
 Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
 " are: ",
 Cell[BoxData["\"\<Year\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Quarter\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Month\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<MonthName\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Day\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<DayName\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Hour\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<AMPM\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Minute\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Second\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->69267552],

Cell[TextData[{
 "If no explicit separator is specified, the ",
 Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
 " must be separated by ",
 Cell[BoxData["/"], "InlineFormula"],
 ", ",
 Cell[BoxData["-"], "InlineFormula"],
 ", ",
 Cell[BoxData[":"], "InlineFormula"],
 " or ",
 Cell[BoxData["."], "InlineFormula"],
 " characters."
}], "Notes",
 CellID->1067943069]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->963151935],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->623015864],

Cell["Compare a string to a list of date elements:", "ExampleText",
 CellID->329959905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<3/15/1984\>\"", ",", 
   RowBox[{"DatePattern", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<Month\>\"", ",", "\"\<Day\>\"", ",", "\"\<Year\>\""}], 
     "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->553565305],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->137486930]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->232205827],

Cell["Compare to a list of time elements:", "ExampleText",
 CellID->191735932],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<00:38:16\>\"", ",", 
   RowBox[{"DatePattern", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<Hour\>\"", ",", "\"\<Minute\>\"", ",", "\"\<Second\>\""}], 
     "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->817865802],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->281411482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->237543642],

Cell["Compare to a pattern with all separators explicitly given:", \
"ExampleText",
 CellID->397645693],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<Wed, 15 Nov 2006\>\"", ",", 
   RowBox[{"DatePattern", "[", 
    RowBox[{"{", 
     RowBox[{
     "\"\<DayName\>\"", ",", "\"\<, \>\"", ",", "\"\<Day\>\"", ",", 
      "\"\< \>\"", ",", "\"\<MonthName\>\"", ",", "\"\< \>\"", ",", 
      "\"\<Year\>\""}], "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->282006579],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->256939611]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Date elements do not match out-of-range values:", "ExampleText",
 CellID->357530177],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<3/15/1984\>\"", ",", 
   RowBox[{"DatePattern", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<Day\>\"", ",", "\"\<Month\>\"", ",", "\"\<Year\>\""}], 
     "}"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->847377343],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143066572]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->293452947],

Cell["Test a string allowing only \"/\" characters as separators:", \
"ExampleText",
 CellID->101150500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<12/10/06\>\"", ",", 
   RowBox[{"DatePattern", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Year\>\"", ",", "\"\<Month\>\"", ",", "\"\<Day\>\""}], 
      "}"}], ",", "\"\</\>\""}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->466173903],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->309382674]
}, Open  ]],

Cell["Test the same string allowing only colon separators:", "ExampleText",
 CellID->21701416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<12/10/06\>\"", ",", 
   RowBox[{"DatePattern", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"\"\<Year\>\"", ",", "\"\<Month\>\"", ",", "\"\<Day\>\""}], 
      "}"}], ",", "\"\<:\>\""}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->775503160],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->649970608]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell["Define a function only for month, year strings:", "ExampleText",
 CellID->372622202],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"dt_", "?", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"StringMatchQ", "[", 
       RowBox[{"#", ",", 
        RowBox[{"DatePattern", "[", 
         RowBox[{"{", 
          RowBox[{"\"\<Month\>\"", ",", "\"\<Year\>\""}], "}"}], "]"}]}], 
       "]"}], "&"}], ")"}]}], "]"}], ":=", 
  RowBox[{"AbsoluteTime", "[", "dt", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4147790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "\"\<5/2007\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->258747069],

Cell[BoxData["3386966400"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->210787122]
}, Open  ]],

Cell["The function returns unevaluated for other input patterns:", \
"ExampleText",
 CellID->554720440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", "\"\<1/2/3\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->213531104],

Cell[BoxData[
 RowBox[{"f", "[", "\<\"1/2/3\"\>", "]"}]], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->543446419]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DateString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
 " gives results that match a date pattern:"
}], "ExampleText",
 CellID->91533353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<Hour\>\"", ",", "\"\<:\>\"", ",", "\"\<Minute\>\""}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->444307496],

Cell[BoxData["\<\"14:47\"\>"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->199557826]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"%", ",", 
   RowBox[{"DatePattern", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<Hour\>\"", ",", "\"\<:\>\"", ",", "\"\<Minute\>\""}], "}"}],
     "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->733018175],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->99021289]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Date & Time",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "MoreAbout",
 CellID->33998311],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->156840404],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->450063912]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DatePattern - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 35.6461040}", "context" -> "System`", 
    "keywords" -> {
     "date string formatting", "date string matching", "date string patterns",
       "matching date strings", "date string", "date representation", "date"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "DatePattern[{\"SubscriptBox[ e, 1]\", \"SubscriptBox[ e, 2]\", ...}] \
represents the characters of a date with elements of type \"SubscriptBox[ e, \
i]\" in StringExpression. DatePattern[{\"SubscriptBox[ e, 1]\", \
\"SubscriptBox[ e, 2]\", ...}, sep] allows separators that match the string \
expression sep.", "synonyms" -> {"date pattern"}, "title" -> "DatePattern", 
    "type" -> "Symbol", "uri" -> "ref/DatePattern"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7962, 243, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->963151935]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19600, 685}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2264, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2887, 82, 1576, 37, 70, "ObjectNameGrid"],
Cell[4466, 121, 1732, 51, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6235, 177, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6713, 194, 777, 27, 70, "Notes",
 CellID->69267552],
Cell[7493, 223, 432, 15, 70, "Notes",
 CellID->1067943069]
}, Closed]],
Cell[CellGroupData[{
Cell[7962, 243, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->963151935],
Cell[CellGroupData[{
Cell[8347, 257, 148, 5, 70, "ExampleSection",
 CellID->623015864],
Cell[8498, 264, 87, 1, 70, "ExampleText",
 CellID->329959905],
Cell[CellGroupData[{
Cell[8610, 269, 286, 8, 28, "Input",
 CellID->553565305],
Cell[8899, 279, 161, 5, 36, "Output",
 CellID->137486930]
}, Open  ]],
Cell[9075, 287, 125, 3, 70, "ExampleDelimiter",
 CellID->232205827],
Cell[9203, 292, 78, 1, 70, "ExampleText",
 CellID->191735932],
Cell[CellGroupData[{
Cell[9306, 297, 289, 8, 70, "Input",
 CellID->817865802],
Cell[9598, 307, 161, 5, 36, "Output",
 CellID->281411482]
}, Open  ]],
Cell[9774, 315, 125, 3, 70, "ExampleDelimiter",
 CellID->237543642],
Cell[9902, 320, 103, 2, 70, "ExampleText",
 CellID->397645693],
Cell[CellGroupData[{
Cell[10030, 326, 390, 10, 70, "Input",
 CellID->282006579],
Cell[10423, 338, 161, 5, 36, "Output",
 CellID->256939611]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10633, 349, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[10857, 358, 90, 1, 70, "ExampleText",
 CellID->357530177],
Cell[CellGroupData[{
Cell[10972, 363, 286, 8, 70, "Input",
 CellID->847377343],
Cell[11261, 373, 162, 5, 36, "Output",
 CellID->143066572]
}, Open  ]],
Cell[11438, 381, 125, 3, 70, "ExampleDelimiter",
 CellID->293452947],
Cell[11566, 386, 104, 2, 70, "ExampleText",
 CellID->101150500],
Cell[CellGroupData[{
Cell[11695, 392, 321, 9, 70, "Input",
 CellID->466173903],
Cell[12019, 403, 161, 5, 36, "Output",
 CellID->309382674]
}, Open  ]],
Cell[12195, 411, 94, 1, 70, "ExampleText",
 CellID->21701416],
Cell[CellGroupData[{
Cell[12314, 416, 321, 9, 70, "Input",
 CellID->775503160],
Cell[12638, 427, 162, 5, 36, "Output",
 CellID->649970608]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12849, 438, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[13079, 447, 90, 1, 70, "ExampleText",
 CellID->372622202],
Cell[13172, 450, 438, 14, 70, "Input",
 CellID->4147790],
Cell[CellGroupData[{
Cell[13635, 468, 110, 3, 70, "Input",
 CellID->258747069],
Cell[13748, 473, 167, 5, 36, "Output",
 CellID->210787122]
}, Open  ]],
Cell[13930, 481, 103, 2, 70, "ExampleText",
 CellID->554720440],
Cell[CellGroupData[{
Cell[14058, 487, 109, 3, 70, "Input",
 CellID->213531104],
Cell[14170, 492, 197, 6, 36, "Output",
 CellID->543446419]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14416, 504, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[14657, 513, 221, 7, 70, "ExampleText",
 CellID->91533353],
Cell[CellGroupData[{
Cell[14903, 524, 198, 6, 70, "Input",
 CellID->444307496],
Cell[15104, 532, 170, 5, 36, "Output",
 CellID->199557826]
}, Open  ]],
Cell[CellGroupData[{
Cell[15311, 542, 268, 8, 70, "Input",
 CellID->733018175],
Cell[15582, 552, 160, 5, 36, "Output",
 CellID->99021289]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15803, 564, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[16122, 575, 712, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[16871, 606, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[17192, 617, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[17407, 626, 299, 8, 70, "MoreAboutSection"],
Cell[17709, 636, 133, 3, 70, "MoreAbout",
 CellID->33998311],
Cell[17845, 641, 141, 3, 70, "MoreAbout",
 CellID->156840404],
Cell[17989, 646, 156, 3, 70, "MoreAbout",
 CellID->450063912]
}, Open  ]],
Cell[18160, 652, 27, 0, 70, "History"],
Cell[18190, 654, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

