(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     44364,       1668]
NotebookOptionsPosition[     34325,       1327]
NotebookOutlinePosition[     35933,       1367]
CellTagsIndexPosition[     35847,       1362]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DateDifference" :> 
          Documentation`HelpLookup["paclet:ref/DateDifference"], "DateString" :> 
          Documentation`HelpLookup["paclet:ref/DateString"], "DateList" :> 
          Documentation`HelpLookup["paclet:ref/DateList"], "DateListPlot" :> 
          Documentation`HelpLookup["paclet:ref/DateListPlot"], "DatePattern" :> 
          Documentation`HelpLookup["paclet:ref/DatePattern"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DateDifference\"\>", 
       2->"\<\"DateString\"\>", 3->"\<\"DateList\"\>", 
       4->"\<\"DateListPlot\"\>", 
       5->"\<\"DatePattern\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date & Time" :> 
          Documentation`HelpLookup["paclet:guide/DateAndTime"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Date & Time\"\>", 
       2->"\<\"New in 6.0: Data Handling & Data Sources\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DatePlus", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DatePlus",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DatePlus"], "[", 
       RowBox[{
        StyleBox["date", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the date ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " days after ",
     Cell[BoxData[
      StyleBox["date", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DatePlus",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DatePlus"], "[", 
       RowBox[{
        StyleBox["date", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["n", "TI"], ",", "\"\<\!\(\*
StyleBox[\"unit\", \"TI\"]\)\>\""}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the date ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " units after ",
     Cell[BoxData[
      StyleBox["date", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DatePlus",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DatePlus"], "[", 
       RowBox[{
        StyleBox["date", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["n", "TI"], 
             StyleBox["1", "TR"]], ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"unit\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["n", "TI"], 
             StyleBox["2", "TR"]], ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"unit\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\""}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a date offset by ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " units of each specified size. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DatePlus",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DatePlus"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the date ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " days after the current date."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DatePlus",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DatePlus"], "[", 
       StyleBox["offset", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the date with the specified offset from the \
current date."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DatePlus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DatePlus"], "[", 
   RowBox[{
    StyleBox["date", "TI"], ",", 
    RowBox[{"-", 
     StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
 " gives the date ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " days before ",
 Cell[BoxData[
  StyleBox["date", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->30571461],

Cell["Dates can be specified in the following forms:", "Notes",
 CellID->89433052],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["y", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["d", "TI"]}], "}"}], Cell["year, month, day", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["y", "TI"], ",", 
      StyleBox["m", "TI"]}], "}"}], Cell[
    "the first day of the specified month", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     StyleBox["y", "TI"], "}"}], Cell[TextData[{
     "January 1 of the year ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", Cell[TextData[{
     "date as a string (",
     Cell[BoxData["\"\<Jan. 1, 2000\>\""], "InlineFormula"],
     ")"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["y", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["d", "TI"], ",", 
      StyleBox["h", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["s", "TI"]}], "}"}], Cell["precise time", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["time", "TI"], Cell["absolute time specification", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True, True}}}},
 CellID->166719552],

Cell[TextData[{
 "Possible offset units are ",
 Cell[BoxData["\"\<Year\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Quarter\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Month\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Week\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Day\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Hour\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Minute\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Second\>\""], "InlineFormula"],
 "."
}], "Notes",
 CellID->8760711],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["d", "TI"]}], "}"}]], "InlineFormula"],
 " is taken to be equivalent to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["d", "TI"], ",", "0", ",", "0", ",", "0"}], "}"}]], 
  "InlineFormula"],
 ", etc."
}], "Notes",
 CellID->180144667],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DatePlus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DatePlus"], "[", 
   RowBox[{
    StyleBox["date", "TI"], ",", 
    StyleBox["offset", "TI"]}], "]"}]], "InlineFormula"],
 " gives results in the same general format as ",
 Cell[BoxData[
  StyleBox["date", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->209937765],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  StyleBox["date", "TI"]], "InlineFormula"],
 " is a list, the result has the same length as ",
 Cell[BoxData[
  StyleBox["date", "TI"]], "InlineFormula"],
 ", possibly extended to include the smallest unit in ",
 Cell[BoxData[
  StyleBox["offset", "TI"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->36596405]
}], "Notes",
 CellID->364391474],

Cell[TextData[{
 "When ",
 Cell[BoxData[
  StyleBox["date", "TI"]], "InlineFormula"],
 " is a string, the result is in the form specified by ",
 Cell[BoxData[
  ButtonBox["$DateStringFormat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$DateStringFormat"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->232759571]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->913156316],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->167595044],

Cell["Add 35 days to January 1, 2009:", "ExampleText",
 CellID->52668850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2009", ",", "1", ",", "1"}], "}"}], ",", "35"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->510982450],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2009", ",", "2", ",", "5"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77968079]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9879382],

Cell["Use a date string as input:", "ExampleText",
 CellID->563555218],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{"\"\<Jan. 1, 2009\>\"", ",", "35"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->115415941],

Cell[BoxData["\<\"Thu 5 Feb 2009 00:00:00\"\>"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->915658786]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->139867709],

Cell["Subtract from a date:", "ExampleText",
 CellID->134321875],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2009", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"-", "35"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->353485994],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2008", ",", "11", ",", "27"}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->624759035]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->860286549],

Cell["Add 14 weeks to a date:", "ExampleText",
 CellID->276523157],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2009", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"14", ",", "\"\<Week\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->325882553],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2009", ",", "4", ",", "9"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99312907]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->731219076],

Cell["Add 34 days to the current time:", "ExampleText",
 CellID->73417833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", "34", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20419628],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2007", ",", "4", ",", "13", ",", "23", ",", "8", ",", "47.778`"}], 
  "}"}]], "Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->560858476]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Date Formats",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->290884748],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DatePlus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DatePlus"]], "InlineFormula"],
 " can take dates in the standard {y,m,d,h,m,s} format of ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->34942617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2009", ",", "1", ",", "1", ",", "6", ",", "17", ",", "44"}], 
    "}"}], ",", "15"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69566931],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2009", ",", "1", ",", "16", ",", "6", ",", "17", ",", "44.`"}], 
  "}"}]], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->443915507]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->393901720],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DatePlus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DatePlus"]], "InlineFormula"],
 " can take dates in any format supported by ",
 Cell[BoxData[
  ButtonBox["DateString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->299338409],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{"\"\<Jan. 1, 2009 06:17:44\>\"", ",", "15"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->102384760],

Cell[BoxData["\<\"Fri 16 Jan 2009 06:17:44\"\>"], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->159486775]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{"\"\<1/1/2009 06:17:44\>\"", ",", "15"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->390646907],

Cell[BoxData["\<\"Fri 16 Jan 2009 06:17:44\"\>"], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->165289777]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->241746384],

Cell[TextData[{
 "If a date is given as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["d", "TI"]}], "}"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["DatePlus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DatePlus"]], "InlineFormula"],
 " returns in the same form:"
}], "ExampleText",
 CellID->324782132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2009", ",", "1", ",", "1"}], "}"}], ",", "15"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->133798474],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2009", ",", "1", ",", "16"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3142477]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->252697309],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"]}], "}"}]], "InlineFormula"],
 " is interpreted as the first day of the specified month:"
}], "ExampleText",
 CellID->209386783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2009", ",", "1"}], "}"}], ",", "15"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->290310482],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2009", ",", "1", ",", "16"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30952002]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->146489308],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"{", 
   StyleBox["y", "TI"], "}"}]], "InlineFormula"],
 " is interpreted as January 1 of the specified year:"
}], "ExampleText",
 CellID->73290748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"{", "2009", "}"}], ",", "15"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->183258949],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2009", ",", "1", ",", "16"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->175263245]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Increments",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->28012580],

Cell["Add 10 months to a date:", "ExampleText",
 CellID->225170187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2009", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "\"\<Month\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->559698344],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2009", ",", "11", ",", "1"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->393515670]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->327973926],

Cell["Add 40 weeks to a date:", "ExampleText",
 CellID->630835180],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2009", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"40", ",", "\"\<Week\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143446201],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2009", ",", "10", ",", "8"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->145498399]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->205642065],

Cell["Add 7 weeks and 2 days:", "ExampleText",
 CellID->143326746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2009", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"7", ",", "\"\<Week\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "\"\<Day\>\""}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68880070],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2009", ",", "2", ",", "21"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->327190477]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->355475177],

Cell["Lists are extended to include smaller offset units: ", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->36596405],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2007", ",", "2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "\"\<Hour\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155292362],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2007", ",", "2", ",", "1", ",", "10"}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->50661931]
}, Open  ]],

Cell["Add 1 year to a date list:", "ExampleText",
 CellID->464556736],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2007", ",", "1", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "\"\<Year\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->588913234],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2008", ",", "1", ",", "4"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->289872275]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->464321325],

Cell["Add 1 month and 15 days to the specified date list:", "ExampleText",
 CellID->48692727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1990", ",", "2", ",", "3", ",", "1", ",", "12", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "\"\<Month\>\""}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"15", ",", "\"\<Day\>\""}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8485454],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1990", ",", "3", ",", "18", ",", "1", ",", "12", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->219907387]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->130998682],

Cell["Add 2.45 days:", "ExampleText",
 CellID->23927615],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2009", ",", "1", ",", "1"}], "}"}], ",", "2.45"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->365519584],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2009", ",", "1", ",", "3", ",", "10", ",", "48"}], "}"}]], "Output",\

 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->108101903]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->420939084],

Cell["Subtract 4.6 hours:", "ExampleText",
 CellID->480507596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2009", ",", "1", ",", "1", ",", "6", ",", "17", ",", "44"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "4.6"}], ",", "\"\<Hour\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->10371361],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2009", ",", "1", ",", "1", ",", "1", ",", "41", ",", "44.`"}], 
  "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->573086215]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DatePlus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DatePlus"]], "InlineFormula"],
 " adds time units to dates, while ",
 Cell[BoxData[
  ButtonBox["DateDifference",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateDifference"]], "InlineFormula"],
 " computes units between dates:"
}], "ExampleText",
 CellID->351901144],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateDifference", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2007", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2007", ",", "3"}], "}"}], ",", "\"\<Month\>\""}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->71026221],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "\<\"Month\"\>"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->218936484]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2007", ",", "1"}], "}"}], ",", "%"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->419281970],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2007", ",", "3"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->117452940]
}, Open  ]],

Cell["The inverse relationship:", "ExampleText",
 CellID->176313335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2007", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "\"\<Month\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14311124],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2007", ",", "3"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->454384743]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateDifference", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2007", ",", "1"}], "}"}], ",", "%", ",", "\"\<Month\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->246455929],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "\<\"Month\"\>"}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->207796565]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->374676453],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["$DateStringFormat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$DateStringFormat"]], "InlineFormula"],
 " to set the default format for date strings:"
}], "ExampleText",
 CellID->348825690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$DateStringFormat", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Month\>\"", ",", "\"\</\>\"", ",", "\"\<Day\>\"", ",", "\"\</\>\"",
        ",", "\"\<Year\>\""}], "}"}]}], "}"}], ",", 
   RowBox[{"DatePlus", "[", 
    RowBox[{
     RowBox[{"DateString", "[", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "\"\<Month\>\""}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17483011],

Cell[BoxData["\<\"06/15/2007\"\>"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81208097]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell["Dates can be ambiguous: ", "ExampleText",
 CellID->153797900],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{"\"\<2/4/99\>\"", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3690731],

Cell[BoxData["\<\"Mon 8 Feb 1999 00:00:00\"\>"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86209575]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " to disambiguate between different interpretations: "
}], "ExampleText",
 CellID->168056412],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{
   RowBox[{"DateList", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<2/4/99\>\"", ",", 
      RowBox[{"{", 
       RowBox[{
       "\"\<Day\>\"", ",", "\"\<Month\>\"", ",", "\"\<YearShort\>\""}], 
       "}"}]}], "}"}], "]"}], ",", "4"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->238357484],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1999", ",", "4", ",", "6", ",", "0", ",", "0", ",", "0"}], 
  "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->581823439]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateDifference",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateDifference"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateListPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DatePattern",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DatePattern"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->210210074]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Date & Time",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "MoreAbout",
 CellID->255569680],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->629333621]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DatePlus - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 36.0211136}", "context" -> "System`", 
    "keywords" -> {"date addition", "date subtraction", "incrementing dates"},
     "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "DatePlus[date, n] gives the date n days after date. DatePlus[date, {n, \
\" unit\"}] gives the date n units after date. DatePlus[date, {{n_1, \
\"SubscriptBox[ unit, 1]\"}, {n_2, \"SubscriptBox[ unit, 2]\"}, ...}] gives a \
date offset by n_i units of each specified size. DatePlus[n] gives the date n \
days after the current date. DatePlus[offset] gives the date with the \
specified offset from the current date.", "synonyms" -> {"date plus"}, 
    "title" -> "DatePlus", "type" -> "Symbol", "uri" -> "ref/DatePlus"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[11837, 383, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->913156316]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 35703, 1355}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1795, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2418, 68, 1573, 37, 70, "ObjectNameGrid"],
Cell[3994, 107, 3034, 97, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[7065, 209, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7543, 226, 448, 18, 70, "Notes",
 CellID->30571461],
Cell[7994, 246, 82, 1, 70, "Notes",
 CellID->89433052],
Cell[8079, 249, 1589, 43, 70, "2ColumnTableMod",
 CellID->166719552],
Cell[9671, 294, 530, 19, 70, "Notes",
 CellID->8760711],
Cell[10204, 315, 442, 17, 70, "Notes",
 CellID->180144667],
Cell[10649, 334, 387, 14, 70, "Notes",
 CellID->209937765],
Cell[11039, 350, 440, 15, 70, "Notes",
 CellID->364391474],
Cell[11482, 367, 318, 11, 70, "Notes",
 CellID->232759571]
}, Closed]],
Cell[CellGroupData[{
Cell[11837, 383, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->913156316],
Cell[CellGroupData[{
Cell[12222, 397, 148, 5, 70, "ExampleSection",
 CellID->167595044],
Cell[12373, 404, 73, 1, 70, "ExampleText",
 CellID->52668850],
Cell[CellGroupData[{
Cell[12471, 409, 192, 7, 28, "Input",
 CellID->510982450],
Cell[12666, 418, 215, 7, 36, "Output",
 CellID->77968079]
}, Open  ]],
Cell[12896, 428, 123, 3, 70, "ExampleDelimiter",
 CellID->9879382],
Cell[13022, 433, 70, 1, 70, "ExampleText",
 CellID->563555218],
Cell[CellGroupData[{
Cell[13117, 438, 147, 4, 70, "Input",
 CellID->115415941],
Cell[13267, 444, 189, 5, 36, "Output",
 CellID->915658786]
}, Open  ]],
Cell[13471, 452, 125, 3, 70, "ExampleDelimiter",
 CellID->139867709],
Cell[13599, 457, 64, 1, 70, "ExampleText",
 CellID->134321875],
Cell[CellGroupData[{
Cell[13688, 462, 209, 7, 70, "Input",
 CellID->353485994],
Cell[13900, 471, 218, 7, 36, "Output",
 CellID->624759035]
}, Open  ]],
Cell[14133, 481, 125, 3, 70, "ExampleDelimiter",
 CellID->860286549],
Cell[14261, 486, 66, 1, 70, "ExampleText",
 CellID->276523157],
Cell[CellGroupData[{
Cell[14352, 491, 250, 8, 70, "Input",
 CellID->325882553],
Cell[14605, 501, 215, 7, 36, "Output",
 CellID->99312907]
}, Open  ]],
Cell[14835, 511, 125, 3, 70, "ExampleDelimiter",
 CellID->731219076],
Cell[14963, 516, 74, 1, 70, "ExampleText",
 CellID->73417833],
Cell[CellGroupData[{
Cell[15062, 521, 104, 3, 70, "Input",
 CellID->20419628],
Cell[15169, 526, 258, 8, 36, "Output",
 CellID->560858476]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15476, 540, 222, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[CellGroupData[{
Cell[15723, 551, 233, 7, 70, "ExampleSubsection",
 CellID->290884748],
Cell[15959, 560, 357, 12, 70, "ExampleText",
 CellID->34942617],
Cell[CellGroupData[{
Cell[16341, 576, 226, 7, 70, "Input",
 CellID->69566931],
Cell[16570, 585, 255, 8, 36, "Output",
 CellID->443915507]
}, Open  ]],
Cell[16840, 596, 125, 3, 70, "ExampleDelimiter",
 CellID->393901720],
Cell[16968, 601, 349, 12, 70, "ExampleText",
 CellID->299338409],
Cell[CellGroupData[{
Cell[17342, 617, 156, 4, 70, "Input",
 CellID->102384760],
Cell[17501, 623, 190, 5, 36, "Output",
 CellID->159486775]
}, Open  ]],
Cell[CellGroupData[{
Cell[17728, 633, 152, 4, 70, "Input",
 CellID->390646907],
Cell[17883, 639, 190, 5, 36, "Output",
 CellID->165289777]
}, Open  ]],
Cell[18088, 647, 125, 3, 70, "ExampleDelimiter",
 CellID->241746384],
Cell[18216, 652, 395, 15, 70, "ExampleText",
 CellID->324782132],
Cell[CellGroupData[{
Cell[18636, 671, 192, 7, 70, "Input",
 CellID->133798474],
Cell[18831, 680, 215, 7, 36, "Output",
 CellID->3142477]
}, Open  ]],
Cell[19061, 690, 125, 3, 70, "ExampleDelimiter",
 CellID->252697309],
Cell[19189, 695, 241, 8, 70, "ExampleText",
 CellID->209386783],
Cell[CellGroupData[{
Cell[19455, 707, 180, 6, 70, "Input",
 CellID->290310482],
Cell[19638, 715, 216, 7, 36, "Output",
 CellID->30952002]
}, Open  ]],
Cell[19869, 725, 125, 3, 70, "ExampleDelimiter",
 CellID->146489308],
Cell[19997, 730, 189, 6, 70, "ExampleText",
 CellID->73290748],
Cell[CellGroupData[{
Cell[20211, 740, 155, 5, 70, "Input",
 CellID->183258949],
Cell[20369, 747, 217, 7, 36, "Output",
 CellID->175263245]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20635, 760, 230, 7, 70, "ExampleSubsection",
 CellID->28012580],
Cell[20868, 769, 67, 1, 70, "ExampleText",
 CellID->225170187],
Cell[CellGroupData[{
Cell[20960, 774, 251, 8, 70, "Input",
 CellID->559698344],
Cell[21214, 784, 217, 7, 36, "Output",
 CellID->393515670]
}, Open  ]],
Cell[21446, 794, 125, 3, 70, "ExampleDelimiter",
 CellID->327973926],
Cell[21574, 799, 66, 1, 70, "ExampleText",
 CellID->630835180],
Cell[CellGroupData[{
Cell[21665, 804, 250, 8, 70, "Input",
 CellID->143446201],
Cell[21918, 814, 217, 7, 36, "Output",
 CellID->145498399]
}, Open  ]],
Cell[22150, 824, 125, 3, 70, "ExampleDelimiter",
 CellID->205642065],
Cell[22278, 829, 66, 1, 70, "ExampleText",
 CellID->143326746],
Cell[CellGroupData[{
Cell[22369, 834, 364, 12, 70, "Input",
 CellID->68880070],
Cell[22736, 848, 217, 7, 36, "Output",
 CellID->327190477]
}, Open  ]],
Cell[22968, 858, 125, 3, 70, "ExampleDelimiter",
 CellID->355475177],
Cell[23096, 863, 142, 2, 70, "ExampleText",
 CellID->36596405],
Cell[CellGroupData[{
Cell[23263, 869, 250, 8, 70, "Input",
 CellID->155292362],
Cell[23516, 879, 227, 7, 36, "Output",
 CellID->50661931]
}, Open  ]],
Cell[23758, 889, 69, 1, 70, "ExampleText",
 CellID->464556736],
Cell[CellGroupData[{
Cell[23852, 894, 249, 8, 70, "Input",
 CellID->588913234],
Cell[24104, 904, 216, 7, 36, "Output",
 CellID->289872275]
}, Open  ]],
Cell[24335, 914, 125, 3, 70, "ExampleDelimiter",
 CellID->464321325],
Cell[24463, 919, 93, 1, 70, "ExampleText",
 CellID->48692727],
Cell[CellGroupData[{
Cell[24581, 924, 401, 13, 70, "Input",
 CellID->8485454],
Cell[24985, 939, 252, 8, 36, "Output",
 CellID->219907387]
}, Open  ]],
Cell[25252, 950, 125, 3, 70, "ExampleDelimiter",
 CellID->130998682],
Cell[25380, 955, 56, 1, 70, "ExampleText",
 CellID->23927615],
Cell[CellGroupData[{
Cell[25461, 960, 195, 7, 70, "Input",
 CellID->365519584],
Cell[25659, 969, 241, 8, 36, "Output",
 CellID->108101903]
}, Open  ]],
Cell[25915, 980, 125, 3, 70, "ExampleDelimiter",
 CellID->420939084],
Cell[26043, 985, 62, 1, 70, "ExampleText",
 CellID->480507596],
Cell[CellGroupData[{
Cell[26130, 990, 308, 10, 70, "Input",
 CellID->10371361],
Cell[26441, 1002, 254, 8, 36, "Output",
 CellID->573086215]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[26756, 1017, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[26997, 1026, 376, 12, 70, "ExampleText",
 CellID->351901144],
Cell[CellGroupData[{
Cell[27398, 1042, 260, 9, 70, "Input",
 CellID->71026221],
Cell[27661, 1053, 215, 7, 36, "Output",
 CellID->218936484]
}, Open  ]],
Cell[CellGroupData[{
Cell[27913, 1065, 179, 6, 70, "Input",
 CellID->419281970],
Cell[28095, 1073, 206, 7, 36, "Output",
 CellID->117452940]
}, Open  ]],
Cell[28316, 1083, 68, 1, 70, "ExampleText",
 CellID->176313335],
Cell[CellGroupData[{
Cell[28409, 1088, 239, 8, 70, "Input",
 CellID->14311124],
Cell[28651, 1098, 206, 7, 36, "Output",
 CellID->454384743]
}, Open  ]],
Cell[CellGroupData[{
Cell[28894, 1110, 210, 7, 70, "Input",
 CellID->246455929],
Cell[29107, 1119, 215, 7, 36, "Output",
 CellID->207796565]
}, Open  ]],
Cell[29337, 1129, 125, 3, 70, "ExampleDelimiter",
 CellID->374676453],
Cell[29465, 1134, 248, 8, 70, "ExampleText",
 CellID->348825690],
Cell[CellGroupData[{
Cell[29738, 1146, 496, 15, 70, "Input",
 CellID->17483011],
Cell[30237, 1163, 174, 5, 36, "Output",
 CellID->81208097]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30460, 1174, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[30694, 1183, 67, 1, 70, "ExampleText",
 CellID->153797900],
Cell[CellGroupData[{
Cell[30786, 1188, 138, 4, 70, "Input",
 CellID->3690731],
Cell[30927, 1194, 188, 5, 36, "Output",
 CellID->86209575]
}, Open  ]],
Cell[31130, 1202, 238, 8, 70, "ExampleText",
 CellID->168056412],
Cell[CellGroupData[{
Cell[31393, 1214, 346, 11, 70, "Input",
 CellID->238357484],
Cell[31742, 1227, 250, 8, 36, "Output",
 CellID->581823439]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[32053, 1242, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[32372, 1253, 1220, 44, 70, "SeeAlso",
 CellID->210210074]
}, Open  ]],
Cell[CellGroupData[{
Cell[33629, 1302, 299, 8, 70, "MoreAboutSection"],
Cell[33931, 1312, 134, 3, 70, "MoreAbout",
 CellID->255569680],
Cell[34068, 1317, 185, 3, 70, "MoreAbout",
 CellID->629333621]
}, Open  ]],
Cell[34268, 1323, 27, 0, 70, "History"],
Cell[34298, 1325, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

