(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     65744,       2257]
NotebookOptionsPosition[     53904,       1857]
NotebookOutlinePosition[     55830,       1902]
CellTagsIndexPosition[     55744,       1897]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DateList" :> Documentation`HelpLookup["paclet:ref/DateList"], 
          "DatePlus" :> Documentation`HelpLookup["paclet:ref/DatePlus"], 
          "DateDifference" :> 
          Documentation`HelpLookup["paclet:ref/DateDifference"], 
          "AbsoluteTime" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteTime"], "$TimeZone" :> 
          Documentation`HelpLookup["paclet:ref/$TimeZone"], "SessionTime" :> 
          Documentation`HelpLookup["paclet:ref/SessionTime"], "TimeUsed" :> 
          Documentation`HelpLookup["paclet:ref/TimeUsed"], "FileDate" :> 
          Documentation`HelpLookup["paclet:ref/FileDate"], "$CreationDate" :> 
          Documentation`HelpLookup["paclet:ref/$CreationDate"], "ToUpperCase" :> 
          Documentation`HelpLookup["paclet:ref/ToUpperCase"], "ToLowerCase" :> 
          Documentation`HelpLookup["paclet:ref/ToLowerCase"], "DateListPlot" :> 
          Documentation`HelpLookup["paclet:ref/DateListPlot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"DateList\"\>", 
       2->"\<\"DatePlus\"\>", 3->"\<\"DateDifference\"\>", 
       4->"\<\"AbsoluteTime\"\>", 5->"\<\"$TimeZone\"\>", 
       6->"\<\"SessionTime\"\>", 7->"\<\"TimeUsed\"\>", 8->"\<\"FileDate\"\>",
        9->"\<\"$CreationDate\"\>", 10->"\<\"ToUpperCase\"\>", 
       11->"\<\"ToLowerCase\"\>", 
       12->"\<\"DateListPlot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Converting between Expressions & Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/ConvertingBetweenExpressionsAndStrings"], 
          "Date & Time" :> 
          Documentation`HelpLookup["paclet:guide/DateAndTime"], 
          "Locale & Internationalization" :> 
          Documentation`HelpLookup[
           "paclet:guide/LocaleAndInternationalization"], 
          "Mathematica Session Information" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionInformation"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"], 
          "New in 6.0: Data Handling & Data Sources" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DataHandlingAndDataSources"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Converting between Expressions & Strings\"\>", 
       2->"\<\"Date & Time\"\>", 3->"\<\"Locale & Internationalization\"\>", 
       4->"\<\"Mathematica Session Information\"\>", 
       5->"\<\"New in 6.0: Core Language\"\>", 
       6->"\<\"New in 6.0: Data Handling & Data Sources\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DateString", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DateString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DateString"], "[", "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a string representing the complete current local \
date and time. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DateString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DateString"], "[", "\"\<\!\(\*
StyleBox[\"elem\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the specified element or format for date and \
time."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DateString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DateString"], "[", 
       RowBox[{"{", 
        RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"elem\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"elem\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]concatenates the specified elements in the order \
given."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DateString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DateString"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["y", "TI"], ",", " ", 
         StyleBox["m", "TI"], ",", " ", 
         StyleBox["d", "TI"], ",", " ", 
         StyleBox["h", "TI"], ",", " ", 
         StyleBox["m", "TI"], ",", " ", 
         StyleBox["s", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a string corresponding to a ",
     Cell[BoxData[
      ButtonBox["DateList",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
     " specification."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DateString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DateString"], "[", 
       StyleBox["time", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a string corresponding to an ",
     Cell[BoxData[
      ButtonBox["AbsoluteTime",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/AbsoluteTime"]], "InlineFormula"],
     " specification."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DateString",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DateString"], "[", 
       RowBox[{
        StyleBox["spec", "TI"], ",", 
        StyleBox["elems", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives elements ",
     Cell[BoxData[
      StyleBox["elems", "TI"]], "InlineFormula"],
     " of the date or time specification ",
     Cell[BoxData[
      StyleBox["spec", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->31833]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"], "[", "]"}]], "InlineFormula"],
 " by default gives its output in the form specified by ",
 Cell[BoxData[
  ButtonBox["$DateStringFormat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$DateStringFormat"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->16235],

Cell["The following output elements can be given:", "Notes",
 CellID->10287],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Date\>\"", Cell[
    "full date", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DateShort\>\"", Cell[
    "full date, with short day and month names", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Time\>\"", Cell[
    "full time", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DateTime\>\"", Cell[
    "full date and time", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DateTimeShort\>\"", Cell[
    "full date and time, with short names", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Year\>\"", Cell[
    "full year (e.g. 2005)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<YearShort\>\"", Cell[
    "2\[Hyphen]digit year (e.g. 05)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<QuarterName\>\"", Cell[
    "quarter of year (e.g. \"Quarter 1\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<QuarterNameShort\>\"", Cell[
    "quarter of year in short form (e.g. \"Q1\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Quarter\>\"", Cell[
    "quarter number (e.g. 1)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MonthName\>\"", Cell[
    "month name (e.g. \"August\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MonthNameShort\>\"", Cell[
    "month name in short form (e.g. \"Aug\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MonthNameInitial\>\"", Cell[
    "first letter of month name (e.g. \"A\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Month\>\"", Cell[
    "2\[Hyphen]digit month number (e.g. 08)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MonthShort\>\"", Cell["\<\
1\[Hyphen] or 2\[Hyphen]digit month number (e.g. 8)\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DayName\>\"", Cell[
    "day of the week (e.g. \"Wednesday\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DayNameShort\>\"", Cell[
    "day of the week in short form (e.g. \"Wed\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DayNameInitial\>\"", Cell[
    "first letter of day name (e.g. \"W\")", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Day\>\"", Cell["\<\
2\[Hyphen]digit day of the month (e.g. 09)\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<DayShort\>\"", Cell["\<\
1\[Hyphen] or 2\[Hyphen]digit day of the month (e.g. 9 or 29)\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Hour\>\"", Cell["\<\
2\[Hyphen]digit hour based on system preferences\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Hour12\>\"", Cell["\<\
2\[Hyphen]digit hour on 12\[Hyphen]hour clock (e.g. 07)\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Hour24\>\"", Cell["\<\
2\[Hyphen]digit hour on 24\[Hyphen]hour clock (e.g. 19)\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<HourShort\>\"", Cell["\<\
1\[Hyphen] or 2\[Hyphen]digit hour based on system preferences\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Hour12Short\>\"", Cell["\<\
1\[Hyphen] or 2\[Hyphen]digit hour on 12\[Hyphen]hour clock (e.g. 7)\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Hour24Short\>\"", Cell["\<\
1\[Hyphen] or 2\[Hyphen]digit hour on 24\[Hyphen]hour clock (e.g. 7, 19)\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AMPM\>\"", Cell[
    "AM or PM", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<AMPMLowerCase\>\"", Cell[
    "am or pm", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Minute\>\"", Cell[
    "2\[Hyphen]digit minute (e.g. 05)", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MinuteShort\>\"", Cell["\<\
1\[Hyphen] or 2\[Hyphen]digit minute (e.g. 5 or 35)\
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Second\>\"", Cell[
    "2\[Hyphen]digit seconds", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SecondShort\>\"", Cell[
    "1\[Hyphen] or 2\[Hyphen]digit seconds", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<SecondExact\>\"", Cell[
    "seconds including fractions", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Millisecond\>\"", Cell[
    "3\[Hyphen]digit milliseconds", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<MillisecondShort\>\"", Cell[
    "1\[Hyphen], 2\[Hyphen] or 3\[Hyphen]digit milliseconds", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, None, None, None, None, None, 
     None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True, True, 
      True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->28393],

Cell["\<\
Any other string given in the list of elements is concatenated literally in \
the output string. \
\>", "Notes",
 CellID->4827],

Cell[TextData[{
 "With a typical value for ",
 Cell[BoxData[
  ButtonBox["$DateStringFormat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$DateStringFormat"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["y", "TI"], ",", 
     StyleBox["m", "TI"], ",", 
     StyleBox["d", "TI"], ",", 
     StyleBox["h", "TI"], ",", 
     StyleBox["m", "TI"], ",", 
     StyleBox["s", "TI"]}], "}"}], "]"}]], "InlineFormula"],
 " will truncate fractional seconds."
}], "Notes",
 CellID->3348],

Cell[TextData[{
 "Shorter lists can be used in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["y", "TI"], ",", 
     StyleBox["m", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 ": ",
 Cell[BoxData[
  RowBox[{"{", 
   StyleBox["y", "TI"], "}"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", "1", ",", "1", ",", "0", ",", "0", ",", "0"}], 
   "}"}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"]}], "}"}]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"], ",", "1", ",", "0", ",", "0", ",", "0"}], "}"}]], 
  "InlineFormula"],
 ", etc."
}], "Notes",
 CellID->89151030],

Cell[TextData[{
 "Values of ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " outside their normal ranges are appropriately reduced. Non-integer values \
of ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["h", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " can also be used.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->47250627]
}], "Notes",
 CellID->124355884],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"], "[", 
   RowBox[{
    StyleBox["spec", "TI"], ",", 
    StyleBox["elems", "TI"]}], "]"}]], "InlineFormula"],
 "the following date and time specifications can be given as ",
 Cell[BoxData[
  StyleBox["spec", "TI"]], "InlineFormula"],
 ":"
}], "Notes",
 CellID->16624],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    StyleBox["time", "TI"], Cell[
    "absolute time specification", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["y", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["d", "TI"], ",", 
      StyleBox["h", "TI"], ",", 
      StyleBox["m", "TI"], ",", 
      StyleBox["s", "TI"]}], "}"}], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DateList",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
     " specification"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DateString",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
     " output"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "}"}], Cell[
    "date string formed from specific elements ", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->32692],

Cell[TextData[{
 "In the form ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"DateString", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}]}]}], "]"}]], "InlineFormula"],
 " the ",
 Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
 " can be ",
 Cell[BoxData["\"\<Year\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<YearShort\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Quarter\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Month\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<MonthName\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Day\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<DayName\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Hour\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Hour12\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<AMPM\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Minute\>\""], "InlineFormula"],
 ", or ",
 Cell[BoxData["\"\<Second\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->69267552],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"DateString", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}]}]}], "]"}]], "InlineFormula"],
 " uses the ",
 Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
 " to fill in elements of ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["y", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["d", "TI"], ",", 
    StyleBox["h", "TI"], ",", 
    StyleBox["m", "TI"], ",", 
    StyleBox["s", "TI"]}], "}"}]], "InlineFormula"],
 ". Those not filled in are taken to have default values ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["c", "TI"]], ",", "1", ",", "1", ",", "0", ",", "0", ",", "0"}],
    "}"}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["c", "TI"]]], "InlineFormula"],
 " is the current year.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->33092171],
 " "
}], "Notes",
 CellID->262340544],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"DateString", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}]}]}], "]"}]], "InlineFormula"],
 ", the ",
 Cell[BoxData["\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"i\", \"TI\"]]\)\>\""], "InlineFormula"],
 " are extracted from ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\""], "InlineFormula"],
 " in the order given, and can be separated by any non-alphanumeric \
characters.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->171106044]
}], "Notes",
 CellID->32350066],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"DateString", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"sep\", \"TI\"], 
StyleBox[\"12\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"e\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"sep\", \"TI\"], 
StyleBox[\"23\", \"TR\"]]\)\>\"", ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}]}]}], "]"}]], "InlineFormula"],
 " extracts elements using the explicit separators specified.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->439205085]
}], "Notes",
 CellID->205302116],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"], "[", 
   RowBox[{
    StyleBox["spec", "TI"], ",", 
    StyleBox["elems", "TI"]}], "]"}]], "InlineFormula"],
 " the time and date corresponding to ",
 Cell[BoxData[
  StyleBox["spec", "TI"]], "InlineFormula"],
 " are by default assumed to be in the time zone specified by ",
 Cell[BoxData[
  ButtonBox["$TimeZone",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeZone"]], "InlineFormula"],
 ", unless ",
 Cell[BoxData[
  StyleBox["spec", "TI"]], "InlineFormula"],
 " explicitly specifies another time zone."
}], "Notes",
 CellID->17244],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"], "[", 
   RowBox[{
    StyleBox["spec", "TI"], ",", 
    StyleBox["elems", "TI"], ",", 
    RowBox[{
     ButtonBox["TimeZone",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TimeZone"], "->", 
     StyleBox["z", "TI"]}]}], "]"}]], "InlineFormula"],
 " gives output converted to time zone ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->6431],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"], "[", "]"}]], "InlineFormula"],
 " uses whatever date and time have been set on your computer system. It \
performs no corrections for time zones, daylight saving time, etc. "
}], "Notes",
 CellID->9086],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"], "[", 
   RowBox[{
    ButtonBox["TimeZone",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TimeZone"], " ", "->", " ", 
    StyleBox["z", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " gives the date and time inferred for time zone ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " by assuming that your computer is set for the time zone specified by ",
 Cell[BoxData[
  ButtonBox["$TimeZone",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeZone"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->208232548]
}], "Notes",
 CellID->9695]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->241772317],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->846460957],

Cell["Find the current date:", "ExampleText",
 CellID->200492176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->455724222],

Cell[BoxData["\<\"Wed 21 Mar 2007 14:34:30\"\>"], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->426137565]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->313405224],

Cell["The current date in a specific format:", "ExampleText",
 CellID->384785887],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{"{", 
   RowBox[{
   "\"\<DayName\>\"", ",", " ", "\"\<  \>\"", ",", "\"\<Month\>\"", ",", 
    "\"\</\>\"", ",", "\"\<YearShort\>\""}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20561],

Cell[BoxData["\<\"Wednesday  03/07\"\>"], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28251175]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297064912],

Cell["Another date in a specific format:", "ExampleText",
 CellID->474092861],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1959", ",", "8", ",", "29", ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "\"\<DayName\>\"", ",", " ", "\"\<  \>\"", ",", "\"\<Month\>\"", ",", 
     "\"\</\>\"", ",", "\"\<YearShort\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->80055411],

Cell[BoxData["\<\"Saturday  08/59\"\>"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101039438]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(8)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1523],

Cell["Find the day of the week corresponding to a date:", "ExampleText",
 CellID->28965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1959", ",", "8", ",", "29", ",", "0", ",", "0", ",", "0"}], 
    "}"}], ",", "\"\<DayName\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24956],

Cell[BoxData["\<\"Saturday\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->759467625]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->847863302],

Cell["Date lists are converted to standard normalized form:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->47250627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{"{", 
   RowBox[{"2006", ",", "2", ",", "31"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->67281060],

Cell[BoxData["\<\"Fri 3 Mar 2006 00:00:00\"\>"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->48689299]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{"{", 
   RowBox[{"2006", ",", "3", ",", "3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10350211],

Cell[BoxData["\<\"Fri 3 Mar 2006 00:00:00\"\>"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->14649232]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->40678967],

Cell["Strings are automatically interpreted when possible:", "ExampleText",
 CellID->228124850],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{"\"\<2006-12-1\>\"", ",", "\"\<MonthName\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26535382],

Cell[BoxData["\<\"December\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->386054048]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{"\"\<10 March 2006\>\"", ",", "\"\<Year\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->267969406],

Cell[BoxData["\<\"2006\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->211196794]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25392021],

Cell["Separators for input strings are assumed if not specified:", \
"ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->171106044],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<12/26/1980\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Month\>\"", ",", "\"\<Day\>\"", ",", "\"\<Year\>\""}], 
     "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->168427058],

Cell[BoxData["\<\"Fri 26 Dec 1980 00:00:00\"\>"], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->270817237]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15061],

Cell["Give explicit separators for an input date string:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->439205085],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<12/26/1980\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Month\>\"", ",", "\"\</\>\"", ",", "\"\<Day\>\"", ",", "\"\</\>\"", 
      ",", "\"\<Year\>\""}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->502619061],

Cell[BoxData["\<\"Fri 26 Dec 1980 00:00:00\"\>"], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->107082918]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->112362973],

Cell["Day, hour, minute and second values can be non-integers:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->27928209],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{"{", 
   RowBox[{"2007", ",", "3", ",", "15.5"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->751779630],

Cell[BoxData["\<\"Thu 15 Mar 2007 12:00:00\"\>"], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->391786218]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{"{", 
   RowBox[{"2007", ",", "3", ",", "15", ",", "12.3"}], "}"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->632638308],

Cell[BoxData["\<\"Thu 15 Mar 2007 12:18:00\"\>"], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->224336521]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11264346],

Cell["The current year is used if not specified in a string:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->33092171],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<2/15\>\"", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Month\>\"", ",", "\"\<Day\>\""}], "}"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12776873],

Cell[BoxData["\<\"Thu 15 Feb 2007 00:00:00\"\>"], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->415748109]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->77510635],

Cell["Convert an absolute time to a date string:", "ExampleText",
 CellID->30687951],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", "3155673600", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->931154209],

Cell[BoxData["\<\"Sat 1 Jan 2000 00:00:00\"\>"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86436691]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->402924422],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TimeZone",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->274042967],

Cell["Find the current date in Greenwich, United Kingdom:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->208232548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{"TimeZone", "\[Rule]", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->78442617],

Cell[BoxData["\<\"Wed 21 Mar 2007 19:35:55\"\>"], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->108263432]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27953],

Cell["Make a dynamically updating clock:", "ExampleText",
 CellID->62612958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"Refresh", "[", 
   RowBox[{
    RowBox[{"DateString", "[", "]"}], ",", 
    RowBox[{"UpdateInterval", "\[Rule]", "1"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->303952573],

Cell[BoxData[
 DynamicBox[ToBoxes[
   Refresh[
    DateString[], UpdateInterval -> 1], StandardForm],
  ImageSizeCache->{168., {2., 8.}}]], "Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->425919628]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24612],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteTime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteTime"]], "InlineFormula"],
 " represents dates as seconds since the beginning of 1900:"
}], "ExampleText",
 CellID->294473746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"AbsoluteTime", "[", 
  RowBox[{"{", 
   RowBox[{"2007", ",", "1", ",", "1"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->244032669],

Cell[BoxData["3376598400"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55998844]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " represents dates as lists of date elements:"
}], "ExampleText",
 CellID->512534639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateList", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->452464721],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2007", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0.`"}], 
  "}"}]], "Output",
 ImageSize->{144, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->206694218]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DateString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
 " represents dates as strings:"
}], "ExampleText",
 CellID->221426326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->56881056],

Cell[BoxData["\<\"Mon 1 Jan 2007 00:00:00\"\>"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->782973969]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->571965600],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["$DateStringFormat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$DateStringFormat"]], "InlineFormula"],
 " to define the output formatting:"
}], "ExampleText",
 CellID->129845856],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$DateStringFormat", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<Month\>\"", ",", "\"\</\>\"", ",", "\"\<Day\>\"", ",", "\"\</\>\"",
        ",", "\"\<Year\>\""}], "}"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"DateString", "[", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->116048079],

Cell[BoxData["\<\"02/15/2007\"\>"], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->406666154]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->42636508],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DateString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateString"]], "InlineFormula"],
 " gives results that match a ",
 Cell[BoxData[
  ButtonBox["DatePattern",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DatePattern"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->91533353],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<Hour\>\"", ",", "\"\<:\>\"", ",", "\"\<Minute\>\""}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->444307496],

Cell[BoxData["\<\"13:35\"\>"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37545935]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"%", ",", 
   RowBox[{"DatePattern", "[", 
    RowBox[{"{", 
     RowBox[{"\"\<Hour\>\"", ",", "\"\<:\>\"", ",", "\"\<Minute\>\""}], "}"}],
     "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->733018175],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->282541912]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->123040038],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DateListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateListPlot"]], "InlineFormula"],
 " to plot data with date string ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " coordinates:"
}], "ExampleText",
 CellID->17347369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateListPlot", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"\"\<Jan 1\>\"", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Feb 1\>\"", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Mar 1\>\"", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Apr 1\>\"", ",", "8"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->111258812],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWs9rE0EUnuyPpFi8eyxSC02lQrXexEPRnkQ8SM9rEdpDW6n9GwRF/wDB
g2Bail6UBj156kUh0GvP/iPr/Hiz+/J2dpM1M5A1E8jsvNmZb7/3zczLy7CP
kqOd53vJ0e52srB5mLzY2d1+ufDw4JA3hS3GWJ9/X11jvJ7ymvz205RfP/My
5GZHWl9EKcxUflhbtka8DHhjyK8xgwpTny6M130CuC5Cu+6rgfFYYS9Dv0Bj
R/l91coUiw6ADJeqB2LcJba8H2d2yajrorhqfILhmSuIT4ZpQM7dbVNW4lac
DYS+N8nYQGtY6Lk4QpGAKN/V6nYIUpFlu4hK0VbQnGlty2eknrYmDTQn3BEx
juldypdihoShqN5I8zUeMMM8wlpnEWYckRUtRraMM37buA4j0ouyWCMs5uU1
Bv0FZhv1XoL2EK5rBP2KHN0vKYUvX9VzIqy0ME6zRjq7IfLruHfBK+/enrN1
0usWse+Uq1GYnSDT+cHGB6xmOBgMqvDhvp6XcnTN5PevP8+Skx/fL4E/xc9t
xT+zh/jrFYKkzFv4kLuTYKO1FqdoZ4KrY/FGdq7LnFWe0442O7p5T+t7GsLu
ssfPGHWcoqtcq9zbKjWGIyaNOfZ4G39LmqL5zEVg7+n/56nbvWxPR7eRIqrI
09687t+/917ktPXyNJbl7DpbL3r65PFHjs2zWsvRuPfp58H+mchjJ8ktm7I2
pnlX+NjkPfWZaz10e5mrW+7u4iU+u7IfibU+fn95T5vraRPO1JyeBNbEXpX2
ce8Cstn1WtijYrJC33p6Avks1ozE5LGipcIj57E+Who4Tjva7OjmPf2HCOls
77qNCvTfrL2c1e1Jh1t0t793YDLd5veb97S5nvr81QZ2djpbqYgAVnj5M81v
DHCb4w1H5Eqm4yKLNwzUmewIFU6NXnyT1bI3NyYpWesvdRtEZw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->462348214]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->100265182],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DatePlus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DatePlus"]], "InlineFormula"],
 " to add time units to a date string:"
}], "ExampleText",
 CellID->206399130],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DatePlus", "[", 
  RowBox[{"\"\<January 1, 2007\>\"", ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "\"\<Day\>\""}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->484824814],

Cell[BoxData["\<\"Thu 4 Jan 2007 00:00:00\"\>"], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->449629985]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DateDifference",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateDifference"]], "InlineFormula"],
 " to find the number of time units between dates:"
}], "ExampleText",
 CellID->680283911],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateDifference", "[", 
  RowBox[{
  "\"\<Feb 1, 2007\>\"", ",", "\"\<May 1, 2007\>\"", ",", "\"\<Day\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30828526],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"89", ",", "\<\"Day\"\>"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->150532782]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78355837],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Order",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Order"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DateList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DateList"]], "InlineFormula"],
 " to determine the order of dates:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->212396129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Order", "[", 
  RowBox[{
   RowBox[{"DateList", "[", "\"\<Jan 1, 2007\>\"", "]"}], ",", 
   RowBox[{"DateList", "[", "\"\<May 1, 2007\>\"", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->275570032],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->380707567]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Order", "[", 
  RowBox[{
   RowBox[{"DateList", "[", "\"\<May 1, 2007\>\"", "]"}], ",", 
   RowBox[{"DateList", "[", "\"\<Jan 1, 2007\>\"", "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->216784907],

Cell[BoxData[
 RowBox[{"-", "1"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->196887876]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13682],

Cell["\<\
Explicit elements may be needed to interpret ambiguous strings:\
\>", "ExampleText",
 CellID->139144165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{"\"\<05/10/1\>\"", ",", "\"\<MonthName\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->187066901],

Cell[BoxData[
 RowBox[{
  RowBox[{"DateString", "::", "\<\"ambig\"\>"}], ":", 
  " ", "\<\"Warning: the interpretation of the string \
\\!\\(\\\"05/10/1\\\"\\) as a date is ambiguous. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/DateString\\\", ButtonNote -> \
\\\"DateString::ambig\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->2577251],

Cell[BoxData["\<\"May\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->362729740]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DateString", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<05/10/1\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<YearShort\>\"", ",", "\"\<Day\>\"", ",", "\"\<Month\>\""}],
       "}"}]}], "}"}], ",", "\"\<MonthName\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->543728066],

Cell[BoxData["\<\"January\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->580300547]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31121],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DatePlus",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DatePlus"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateDifference",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateDifference"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$TimeZone",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$TimeZone"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SessionTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SessionTime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimeUsed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimeUsed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FileDate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FileDate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$CreationDate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CreationDate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToUpperCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToUpperCase"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToLowerCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToLowerCase"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateListPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateListPlot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2819]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with DateString",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=DateString"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->335096328],

Cell[TextData[ButtonBox["Converting between Expressions & Strings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConvertingBetweenExpressionsAndStrings"]], "MoreAbout",
 CellID->852848],

Cell[TextData[ButtonBox["Date & Time",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "MoreAbout",
 CellID->229792218],

Cell[TextData[ButtonBox["Locale & Internationalization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LocaleAndInternationalization"]], "MoreAbout",
 CellID->60267721],

Cell[TextData[ButtonBox["Mathematica Session Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionInformation"]], "MoreAbout",
 CellID->34407029],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->134165112],

Cell[TextData[ButtonBox["New in 6.0: Data Handling & Data Sources",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DataHandlingAndDataSources"]], "MoreAbout",
 CellID->538883264]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DateString - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 36.6148788}", "context" -> "System`", 
    "keywords" -> {
     "calendar", "clock", "date as string", "day", "hour", "minute", "month", 
      "parse date", "second", "time", "year", "date representation", 
      "dates and times", "date conversion", "date formatting", "time zone"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "DateString[] gives a string representing the complete current local date \
and time. DateString[\"elem\"] gives the specified element or format for date \
and time. DateString[{\"SubscriptBox[ elem, 1]\", \"SubscriptBox[ elem, 2]\", \
...}] concatenates the specified elements in the order given. DateString[{y, \
m, d, h, m, s}] gives a string corresponding to a DateList specification. \
DateString[time] gives a string corresponding to an AbsoluteTime \
specification. DateString[spec, elems] gives elements elems of the date or \
time specification spec.", "synonyms" -> {"date string"}, "title" -> 
    "DateString", "type" -> "Symbol", "uri" -> "ref/DateString"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[26229, 774, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->241772317]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 55600, 1890}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3331, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3954, 94, 1575, 37, 70, "ObjectNameGrid"],
Cell[5532, 133, 3100, 93, 70, "Usage",
 CellID->31833]
}, Open  ]],
Cell[CellGroupData[{
Cell[8669, 231, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9147, 248, 394, 13, 70, "Notes",
 CellID->16235],
Cell[9544, 263, 76, 1, 70, "Notes",
 CellID->10287],
Cell[9623, 266, 5058, 96, 70, "2ColumnTableMod",
 CellID->28393],
Cell[14684, 364, 137, 4, 70, "Notes",
 CellID->4827],
Cell[14824, 370, 630, 22, 70, "Notes",
 CellID->3348],
Cell[15457, 394, 954, 37, 70, "Notes",
 CellID->89151030],
Cell[16414, 433, 818, 34, 70, "Notes",
 CellID->124355884],
Cell[17235, 469, 408, 15, 70, "Notes",
 CellID->16624],
Cell[17646, 486, 1612, 45, 70, "2ColumnTableMod",
 CellID->32692],
Cell[19261, 533, 1380, 46, 70, "Notes",
 CellID->69267552],
Cell[20644, 581, 1427, 48, 70, "Notes",
 CellID->262340544],
Cell[22074, 631, 940, 29, 70, "Notes",
 CellID->32350066],
Cell[23017, 662, 862, 24, 70, "Notes",
 CellID->205302116],
Cell[23882, 688, 684, 23, 70, "Notes",
 CellID->17244],
Cell[24569, 713, 522, 19, 70, "Notes",
 CellID->6431],
Cell[25094, 734, 336, 9, 70, "Notes",
 CellID->9086],
Cell[25433, 745, 759, 24, 70, "Notes",
 CellID->9695]
}, Closed]],
Cell[CellGroupData[{
Cell[26229, 774, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->241772317],
Cell[CellGroupData[{
Cell[26614, 788, 148, 5, 70, "ExampleSection",
 CellID->846460957],
Cell[26765, 795, 65, 1, 70, "ExampleText",
 CellID->200492176],
Cell[CellGroupData[{
Cell[26855, 800, 101, 3, 28, "Input",
 CellID->455724222],
Cell[26959, 805, 190, 5, 36, "Output",
 CellID->426137565]
}, Open  ]],
Cell[27164, 813, 125, 3, 70, "ExampleDelimiter",
 CellID->313405224],
Cell[27292, 818, 81, 1, 70, "ExampleText",
 CellID->384785887],
Cell[CellGroupData[{
Cell[27398, 823, 252, 7, 70, "Input",
 CellID->20561],
Cell[27653, 832, 181, 5, 36, "Output",
 CellID->28251175]
}, Open  ]],
Cell[27849, 840, 125, 3, 70, "ExampleDelimiter",
 CellID->297064912],
Cell[27977, 845, 77, 1, 70, "ExampleText",
 CellID->474092861],
Cell[CellGroupData[{
Cell[28079, 850, 380, 11, 70, "Input",
 CellID->80055411],
Cell[28462, 863, 181, 5, 36, "Output",
 CellID->101039438]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28692, 874, 215, 7, 70, "ExampleSection",
 CellID->1523],
Cell[28910, 883, 88, 1, 70, "ExampleText",
 CellID->28965],
Cell[CellGroupData[{
Cell[29023, 888, 237, 7, 70, "Input",
 CellID->24956],
Cell[29263, 897, 173, 5, 36, "Output",
 CellID->759467625]
}, Open  ]],
Cell[29451, 905, 125, 3, 70, "ExampleDelimiter",
 CellID->847863302],
Cell[29579, 910, 143, 2, 70, "ExampleText",
 CellID->47250627],
Cell[CellGroupData[{
Cell[29747, 916, 166, 5, 70, "Input",
 CellID->67281060],
Cell[29916, 923, 188, 5, 36, "Output",
 CellID->48689299]
}, Open  ]],
Cell[CellGroupData[{
Cell[30141, 933, 165, 5, 70, "Input",
 CellID->10350211],
Cell[30309, 940, 188, 5, 36, "Output",
 CellID->14649232]
}, Open  ]],
Cell[30512, 948, 124, 3, 70, "ExampleDelimiter",
 CellID->40678967],
Cell[30639, 953, 95, 1, 70, "ExampleText",
 CellID->228124850],
Cell[CellGroupData[{
Cell[30759, 958, 160, 4, 70, "Input",
 CellID->26535382],
Cell[30922, 964, 173, 5, 36, "Output",
 CellID->386054048]
}, Open  ]],
Cell[CellGroupData[{
Cell[31132, 974, 160, 4, 70, "Input",
 CellID->267969406],
Cell[31295, 980, 169, 5, 36, "Output",
 CellID->211196794]
}, Open  ]],
Cell[31479, 988, 124, 3, 70, "ExampleDelimiter",
 CellID->25392021],
Cell[31606, 993, 151, 3, 70, "ExampleText",
 CellID->171106044],
Cell[CellGroupData[{
Cell[31782, 1000, 270, 8, 70, "Input",
 CellID->168427058],
Cell[32055, 1010, 190, 5, 36, "Output",
 CellID->270817237]
}, Open  ]],
Cell[32260, 1018, 121, 3, 70, "ExampleDelimiter",
 CellID->15061],
Cell[32384, 1023, 141, 2, 70, "ExampleText",
 CellID->439205085],
Cell[CellGroupData[{
Cell[32550, 1029, 313, 9, 70, "Input",
 CellID->502619061],
Cell[32866, 1040, 190, 5, 36, "Output",
 CellID->107082918]
}, Open  ]],
Cell[33071, 1048, 125, 3, 70, "ExampleDelimiter",
 CellID->112362973],
Cell[33199, 1053, 146, 2, 70, "ExampleText",
 CellID->27928209],
Cell[CellGroupData[{
Cell[33370, 1059, 169, 5, 70, "Input",
 CellID->751779630],
Cell[33542, 1066, 190, 5, 36, "Output",
 CellID->391786218]
}, Open  ]],
Cell[CellGroupData[{
Cell[33769, 1076, 182, 6, 70, "Input",
 CellID->632638308],
Cell[33954, 1084, 190, 5, 36, "Output",
 CellID->224336521]
}, Open  ]],
Cell[34159, 1092, 124, 3, 70, "ExampleDelimiter",
 CellID->11264346],
Cell[34286, 1097, 144, 2, 70, "ExampleText",
 CellID->33092171],
Cell[CellGroupData[{
Cell[34455, 1103, 239, 8, 70, "Input",
 CellID->12776873],
Cell[34697, 1113, 190, 5, 36, "Output",
 CellID->415748109]
}, Open  ]],
Cell[34902, 1121, 124, 3, 70, "ExampleDelimiter",
 CellID->77510635],
Cell[35029, 1126, 84, 1, 70, "ExampleText",
 CellID->30687951],
Cell[CellGroupData[{
Cell[35138, 1131, 115, 3, 70, "Input",
 CellID->931154209],
Cell[35256, 1136, 188, 5, 36, "Output",
 CellID->86436691]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35493, 1147, 222, 7, 70, "ExampleSection",
 CellID->402924422],
Cell[CellGroupData[{
Cell[35740, 1158, 229, 7, 70, "ExampleSubsection",
 CellID->274042967],
Cell[35972, 1167, 142, 2, 70, "ExampleText",
 CellID->208232548],
Cell[CellGroupData[{
Cell[36139, 1173, 141, 4, 70, "Input",
 CellID->78442617],
Cell[36283, 1179, 190, 5, 36, "Output",
 CellID->108263432]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[36534, 1191, 223, 7, 70, "ExampleSection",
 CellID->27953],
Cell[36760, 1200, 76, 1, 70, "ExampleText",
 CellID->62612958],
Cell[CellGroupData[{
Cell[36861, 1205, 239, 7, 70, "Input",
 CellID->303952573],
Cell[37103, 1214, 280, 9, 70, "Output",
 CellID->425919628]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[37432, 1229, 233, 7, 70, "ExampleSection",
 CellID->24612],
Cell[37668, 1238, 242, 7, 70, "ExampleText",
 CellID->294473746],
Cell[CellGroupData[{
Cell[37935, 1249, 168, 5, 70, "Input",
 CellID->244032669],
Cell[38106, 1256, 166, 5, 36, "Output",
 CellID->55998844]
}, Open  ]],
Cell[38287, 1264, 221, 7, 70, "ExampleText",
 CellID->512534639],
Cell[CellGroupData[{
Cell[38533, 1275, 104, 3, 70, "Input",
 CellID->452464721],
Cell[38640, 1280, 252, 8, 36, "Output",
 CellID->206694218]
}, Open  ]],
Cell[38907, 1291, 210, 7, 70, "ExampleText",
 CellID->221426326],
Cell[CellGroupData[{
Cell[39142, 1302, 105, 3, 70, "Input",
 CellID->56881056],
Cell[39250, 1307, 189, 5, 36, "Output",
 CellID->782973969]
}, Open  ]],
Cell[39454, 1315, 125, 3, 70, "ExampleDelimiter",
 CellID->571965600],
Cell[39582, 1320, 237, 8, 70, "ExampleText",
 CellID->129845856],
Cell[CellGroupData[{
Cell[39844, 1332, 392, 11, 70, "Input",
 CellID->116048079],
Cell[40239, 1345, 175, 5, 36, "Output",
 CellID->406666154]
}, Open  ]],
Cell[40429, 1353, 124, 3, 70, "ExampleDelimiter",
 CellID->42636508],
Cell[40556, 1358, 339, 12, 70, "ExampleText",
 CellID->91533353],
Cell[CellGroupData[{
Cell[40920, 1374, 198, 6, 70, "Input",
 CellID->444307496],
Cell[41121, 1382, 169, 5, 36, "Output",
 CellID->37545935]
}, Open  ]],
Cell[CellGroupData[{
Cell[41327, 1392, 268, 8, 70, "Input",
 CellID->733018175],
Cell[41598, 1402, 161, 5, 36, "Output",
 CellID->282541912]
}, Open  ]],
Cell[41774, 1410, 125, 3, 70, "ExampleDelimiter",
 CellID->123040038],
Cell[41902, 1415, 299, 11, 70, "ExampleText",
 CellID->17347369],
Cell[CellGroupData[{
Cell[42226, 1430, 427, 13, 70, "Input",
 CellID->111258812],
Cell[42656, 1445, 1180, 23, 70, "Output",
 Evaluatable->False,
 CellID->462348214]
}, Open  ]],
Cell[43851, 1471, 125, 3, 70, "ExampleDelimiter",
 CellID->100265182],
Cell[43979, 1476, 222, 8, 70, "ExampleText",
 CellID->206399130],
Cell[CellGroupData[{
Cell[44226, 1488, 208, 6, 70, "Input",
 CellID->484824814],
Cell[44437, 1496, 189, 5, 36, "Output",
 CellID->449629985]
}, Open  ]],
Cell[44641, 1504, 246, 8, 70, "ExampleText",
 CellID->680283911],
Cell[CellGroupData[{
Cell[44912, 1516, 194, 6, 70, "Input",
 CellID->30828526],
Cell[45109, 1524, 214, 7, 36, "Output",
 CellID->150532782]
}, Open  ]],
Cell[45338, 1534, 124, 3, 70, "ExampleDelimiter",
 CellID->78355837],
Cell[45465, 1539, 390, 14, 70, "ExampleText",
 CellID->212396129],
Cell[CellGroupData[{
Cell[45880, 1557, 232, 6, 70, "Input",
 CellID->275570032],
Cell[46115, 1565, 158, 5, 36, "Output",
 CellID->380707567]
}, Open  ]],
Cell[CellGroupData[{
Cell[46310, 1575, 232, 6, 70, "Input",
 CellID->216784907],
Cell[46545, 1583, 175, 6, 36, "Output",
 CellID->196887876]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[46769, 1595, 226, 7, 70, "ExampleSection",
 CellID->13682],
Cell[46998, 1604, 114, 3, 70, "ExampleText",
 CellID->139144165],
Cell[CellGroupData[{
Cell[47137, 1611, 159, 4, 70, "Input",
 CellID->187066901],
Cell[47299, 1617, 412, 8, 70, "Message",
 CellID->2577251],
Cell[47714, 1627, 168, 5, 36, "Output",
 CellID->362729740]
}, Open  ]],
Cell[CellGroupData[{
Cell[47919, 1637, 316, 9, 70, "Input",
 CellID->543728066],
Cell[48238, 1648, 172, 5, 36, "Output",
 CellID->580300547]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[48471, 1660, 311, 9, 70, "SeeAlsoSection",
 CellID->31121],
Cell[48785, 1671, 2958, 107, 70, "SeeAlso",
 CellID->2819]
}, Open  ]],
Cell[CellGroupData[{
Cell[51780, 1783, 305, 8, 70, "RelatedLinksSection"],
Cell[52088, 1793, 365, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52490, 1810, 319, 9, 70, "MoreAboutSection",
 CellID->335096328],
Cell[52812, 1821, 190, 4, 70, "MoreAbout",
 CellID->852848],
Cell[53005, 1827, 134, 3, 70, "MoreAbout",
 CellID->229792218],
Cell[53142, 1832, 169, 3, 70, "MoreAbout",
 CellID->60267721],
Cell[53314, 1837, 171, 3, 70, "MoreAbout",
 CellID->34407029],
Cell[53488, 1842, 156, 3, 70, "MoreAbout",
 CellID->134165112],
Cell[53647, 1847, 185, 3, 70, "MoreAbout",
 CellID->538883264]
}, Open  ]],
Cell[53847, 1853, 27, 0, 70, "History"],
Cell[53877, 1855, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

