(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     22193,        618]
NotebookOptionsPosition[     18136,        485]
NotebookOutlinePosition[     20027,        539]
CellTagsIndexPosition[     19909,        533]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Notebooks" :> 
          Documentation`HelpLookup["paclet:tutorial/OptionsForNotebooks"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Options for Notebooks\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DefaultDuplicateCellStyle" :> 
          Documentation`HelpLookup[
           "paclet:ref/DefaultDuplicateCellStyle"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"DefaultDuplicateCellStyle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Programmatic Notebook & Interface Customization" :> 
          Documentation`HelpLookup[
           "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"], 
          "Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Programmatic Notebook & Interface Customization\"\>", 
       2->"\<\"Stylesheets\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DefaultNewCellStyle", "ObjectName",
 CellID->9963],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DefaultNewCellStyle",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DefaultNewCellStyle"]], "InlineFormula"],
     "\[LineSeparator]is a notebook option which specifies the default style \
to use for new cells created in the notebook. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14177]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "A typical default setting for ",
 Cell[BoxData[
  ButtonBox["DefaultNewCellStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DefaultNewCellStyle"]], "InlineFormula"],
 " is ",
 Cell[BoxData["\"\<Input\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15726],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DefaultNewCellStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DefaultNewCellStyle"]], "InlineFormula"],
 " determines the style for new cells created interactively in the front end. \
"
}], "Notes",
 CellID->2922]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->512709279],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->61866800],

Cell[TextData[{
 "Create a new notebook in which the default style for new cells is ",
 Cell[BoxData["\"\<Input\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->93956806],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"DefaultNewCellStyle", "\[Rule]", "\"\<Input\>\""}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->680440157],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt2ltPXFUYxnGM96Zfwa+iXtuk6ZUmFhqBVtMY/QBeNLbVYo30AKUFbBFo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   "], {{0, 0}, {458, 82}}, {0, 255}],
  ImageSize->{458 0.75, 82 0.75},
  PlotRange->{{0, 458}, {0, 82}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->78485109]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookWrite", "[", 
  RowBox[{"nb", ",", "\"\<2+2\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->352326463],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPlEcch7fpfeNX6FfpIemVpo03bZMqpqK2McamF02a9MJUbbU29QQe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   "], {{0, 0}, {458, 72}}, {0, 255}],
  ImageSize->{458 0.75, 72 0.75},
  PlotRange->{{0, 458}, {0, 72}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->799946636]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->238435627],

Cell[TextData[{
 "Create a new notebook in which the default style for new cells is ",
 Cell[BoxData[
  ButtonBox["\"\<Text\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Text"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->638898652],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"nb", "=", 
   RowBox[{"CreateDocument", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"DefaultNewCellStyle", "\[Rule]", "\"\<Text\>\""}]}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->262451454],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztmltPXFUYhjHem/4F/4p6441NTK80sdAItJrG6A/worGtFjXSA5QWsEWg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   "], {{0, 0}, {458, 73}}, {0, 255}],
  ImageSize->{458 0.75, 73 0.75},
  PlotRange->{{0, 458}, {0, 73}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->369722517]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NotebookWrite", "[", 
  RowBox[{"nb", ",", "\"\<2+2\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->107698309],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnVtPlEcch7fpfeNX6Ffp4aI3mjbetE0qmIraxpg2vWvSC1O11drUE3hA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   "], {{0, 0}, {458, 73}}, {0, 255}],
  ImageSize->{458 0.75, 73 0.75},
  PlotRange->{{0, 458}, {0, 73}}]], "NotebookImage",
 CellTags->"Notebook Image",
 CellID->17389777]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9425],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["DefaultDuplicateCellStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DefaultDuplicateCellStyle"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->19900]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11707],

Cell[TextData[ButtonBox["Options for Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OptionsForNotebooks"]], "Tutorials",
 CellID->23529]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->91864910],

Cell[TextData[ButtonBox["Programmatic Notebook & Interface Customization",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ProgrammaticNotebookAndInterfaceCustomization"]], "MoreAbout",\

 CellID->71772026],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->169657748]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DefaultNewCellStyle - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 36, 59.1467056}", "context" -> "System`", 
    "keywords" -> {
     "styles", "templates", "default new cell", "default cell", 
      "automatic cell style", "default style"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DefaultNewCellStyle is a notebook option which specifies the default \
style to use for new cells created in the notebook. ", 
    "synonyms" -> {"default new cell style"}, "title" -> 
    "DefaultNewCellStyle", "type" -> "Symbol", "uri" -> 
    "ref/DefaultNewCellStyle"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4315, 142, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->512709279]},
 "Notebook Image"->{
  Cell[5321, 183, 2409, 42, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->78485109],
  Cell[7913, 236, 2561, 45, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->799946636],
  Cell[11164, 312, 2353, 41, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->369722517],
  Cell[13700, 364, 2552, 45, 70, "NotebookImage",
   CellTags->"Notebook Image",
   CellID->17389777]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19332, 513},
 {"Notebook Image", 19473, 517}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2019, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2642, 78, 56, 1, 70, "ObjectName",
 CellID->9963],
Cell[2701, 81, 508, 14, 70, "Usage",
 CellID->14177]
}, Open  ]],
Cell[CellGroupData[{
Cell[3246, 100, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3724, 117, 285, 10, 70, "Notes",
 CellID->15726],
Cell[4012, 129, 266, 8, 70, "Notes",
 CellID->2922]
}, Closed]],
Cell[CellGroupData[{
Cell[4315, 142, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->512709279],
Cell[CellGroupData[{
Cell[4700, 156, 147, 5, 70, "ExampleSection",
 CellID->61866800],
Cell[4850, 163, 179, 5, 70, "ExampleText",
 CellID->93956806],
Cell[CellGroupData[{
Cell[5054, 172, 264, 9, 70, "Input",
 CellID->680440157],
Cell[5321, 183, 2409, 42, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->78485109]
}, Open  ]],
Cell[CellGroupData[{
Cell[7767, 230, 143, 4, 70, "Input",
 CellID->352326463],
Cell[7913, 236, 2561, 45, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->799946636]
}, Open  ]],
Cell[10489, 284, 125, 3, 70, "ExampleDelimiter",
 CellID->238435627],
Cell[10617, 289, 256, 8, 70, "ExampleText",
 CellID->638898652],
Cell[CellGroupData[{
Cell[10898, 301, 263, 9, 70, "Input",
 CellID->262451454],
Cell[11164, 312, 2353, 41, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->369722517]
}, Open  ]],
Cell[CellGroupData[{
Cell[13554, 358, 143, 4, 70, "Input",
 CellID->107698309],
Cell[13700, 364, 2552, 45, 70, "NotebookImage",
 CellTags->"Notebook Image",
 CellID->17389777]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16313, 416, 310, 9, 70, "SeeAlsoSection",
 CellID->9425],
Cell[16626, 427, 230, 6, 70, "SeeAlso",
 CellID->19900]
}, Open  ]],
Cell[CellGroupData[{
Cell[16893, 438, 314, 9, 70, "TutorialsSection",
 CellID->11707],
Cell[17210, 449, 151, 3, 70, "Tutorials",
 CellID->23529]
}, Open  ]],
Cell[CellGroupData[{
Cell[17398, 457, 318, 9, 70, "MoreAboutSection",
 CellID->91864910],
Cell[17719, 468, 208, 5, 70, "MoreAbout",
 CellID->71772026],
Cell[17930, 475, 134, 3, 70, "MoreAbout",
 CellID->169657748]
}, Open  ]],
Cell[18079, 481, 27, 0, 70, "History"],
Cell[18109, 483, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

