(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20322,        760]
NotebookOptionsPosition[     15509,        598]
NotebookOutlinePosition[     16915,        637]
CellTagsIndexPosition[     16830,        632]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Interpretation" :> 
          Documentation`HelpLookup["paclet:ref/Interpretation"], "HoldForm" :> 
          Documentation`HelpLookup["paclet:ref/HoldForm"], "DynamicSetting" :> 
          Documentation`HelpLookup["paclet:ref/DynamicSetting"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Interpretation\"\>", 
       2->"\<\"HoldForm\"\>", 
       3->"\<\"DynamicSetting\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Evaluation Control" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationControl"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Document Generation\"\>", 
       2->"\<\"Evaluation Control\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Defer", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Defer",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Defer"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]yields an object that displays as the unevaluated form \
of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", but which is evaluated if it is explicitly given as ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " input. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8339]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Defer",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Defer"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " returns an object which remains unchanged until it is explicitly supplied \
as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input, and evaluated using ",
 StyleBox["Shift", "KeyEvent"],
 StyleBox["+", "KeyEventDelimiter"],
 StyleBox["Enter", "KeyEvent"],
 ", ",
 StyleBox["Evaluate in Place", "MenuName"],
 ", etc. "
}], "Notes",
 CellID->21086],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Defer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Defer"]], "InlineFormula"],
 " gives an object whose evaluation is merely deferred until it is explicitly \
given as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input; ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 " gives an object that is never evaluated."
}], "Notes",
 CellID->420502933],

Cell[TextData[{
 "If an object contains several levels of nested ",
 Cell[BoxData[
  ButtonBox["Defer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Defer"]], "InlineFormula"],
 " constructs, one level is removed each time the object is evaluated as ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input."
}], "Notes",
 CellID->107322844]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->30308096],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->52224674],

Cell["By default, arguments are evaluated: ", "ExampleText",
 CellID->156941971],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", "1"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->679280423],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->41517783]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Defer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Defer"]], "InlineFormula"],
 " to display an unevaluated form:  "
}], "ExampleText",
 CellID->123412096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Defer", "[", 
  RowBox[{"1", "+", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31173769],

Cell[BoxData[
 RowBox[{"1", "+", "1"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->528097021]
}, Open  ]],

Cell["Copy the previous output and evaluate:", "ExampleText",
 CellID->28707589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", "1"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->94158039],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->762624001]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15827063],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Defer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Defer"]], "InlineFormula"],
 " to create cells with unevaluated contents:"
}], "ExampleText",
 CellID->816869883],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{
   RowBox[{"Function", "[", 
    RowBox[{
     RowBox[{"{", "n", "}"}], ",", 
     RowBox[{"ExpressionCell", "[", 
      RowBox[{
       RowBox[{"Defer", "[", 
        RowBox[{"Integrate", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"x", "^", "n"}], " ", 
           RowBox[{"Exp", "[", 
            RowBox[{"-", "x"}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}], ",", 
       "\"\<Input\>\""}], "]"}]}], "]"}], "/@", 
   RowBox[{"Range", "[", "5", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->414831289],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "1"], 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "1"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "x"}]]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellLabel->"In[2]:=",
 CellID->16233593],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "1"], 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "2"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "x"}]]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellLabel->"In[3]:=",
 CellID->822789121],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "1"], 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "3"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "x"}]]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellLabel->"In[4]:=",
 CellID->597961424],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "1"], 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "4"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "x"}]]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellLabel->"In[5]:=",
 CellID->520565682],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Integral]", "0", "1"], 
  RowBox[{
   RowBox[{
    SuperscriptBox["x", "5"], " ", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "x"}]]}], 
   RowBox[{"\[DifferentialD]", "x"}]}]}]], "Input",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 CellLabel->"In[6]:=",
 CellID->339588572]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 " to display in unevaluated form:"
}], "ExampleText",
 CellID->308573942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldForm", "[", 
  RowBox[{"1", "+", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->869569841],

Cell[BoxData[
 TagBox[
  RowBox[{"1", "+", "1"}],
  HoldForm]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21534806]
}, Open  ]],

Cell["Copy the output and evaluate; the result stays unevaluated: ", \
"ExampleText",
 CellID->221246839],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  RowBox[{"1", "+", "1"}],
  HoldForm]], "Input",
 CellLabel->"In[2]:=",
 CellID->78625186],

Cell[BoxData[
 TagBox[
  RowBox[{"1", "+", "1"}],
  HoldForm]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->228246046]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ReleaseHold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReleaseHold"]], "InlineFormula"],
 " to force evaluation of the result: "
}], "ExampleText",
 CellID->841547739],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ReleaseHold", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->3801962],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->513612094]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Defer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Defer"]], "InlineFormula"],
 " to display in unevaluated form:"
}], "ExampleText",
 CellID->176968691],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Defer", "[", 
  RowBox[{"1", "+", "1"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->556915804],

Cell[BoxData[
 RowBox[{"1", "+", "1"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->479038159]
}, Open  ]],

Cell["Copy the output and evaluate: ", "ExampleText",
 CellID->414964913],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", "1"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->442533524],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->708982616]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interpretation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interpretation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DynamicSetting",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DynamicSetting"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->477241916],

Cell[TextData[ButtonBox["Evaluation Control",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationControl"]], "MoreAbout",
 CellID->332964291]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Defer - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 37, 6.9594056}", "context" -> "System`", 
    "keywords" -> {
     "printing without evaluation", "preventing evaluation in printing", 
      "unevaluated expressions", "output of unevaluated expressions"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Defer[expr] yields an object that displays as the unevaluated form of \
expr, but which is evaluated if it is explicitly given as Mathematica input. \
", "synonyms" -> {}, "title" -> "Defer", "type" -> "Symbol", "uri" -> 
    "ref/Defer"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6361, 201, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->30308096]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16688, 625}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1534, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2157, 63, 1570, 37, 70, "ObjectNameGrid"],
Cell[3730, 102, 704, 22, 70, "Usage",
 CellID->8339]
}, Open  ]],
Cell[CellGroupData[{
Cell[4471, 129, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4949, 146, 541, 19, 70, "Notes",
 CellID->21086],
Cell[5493, 167, 479, 16, 70, "Notes",
 CellID->420502933],
Cell[5975, 185, 349, 11, 70, "Notes",
 CellID->107322844]
}, Closed]],
Cell[CellGroupData[{
Cell[6361, 201, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->30308096],
Cell[CellGroupData[{
Cell[6745, 215, 147, 5, 70, "ExampleSection",
 CellID->52224674],
Cell[6895, 222, 80, 1, 70, "ExampleText",
 CellID->156941971],
Cell[CellGroupData[{
Cell[7000, 227, 92, 3, 28, "Input",
 CellID->679280423],
Cell[7095, 232, 157, 5, 36, "Output",
 CellID->41517783]
}, Open  ]],
Cell[7267, 240, 214, 8, 70, "ExampleText",
 CellID->123412096],
Cell[CellGroupData[{
Cell[7506, 252, 123, 4, 28, "Input",
 CellID->31173769],
Cell[7632, 258, 180, 6, 36, "Output",
 CellID->528097021]
}, Open  ]],
Cell[7827, 267, 80, 1, 70, "ExampleText",
 CellID->28707589],
Cell[CellGroupData[{
Cell[7932, 272, 91, 3, 70, "Input",
 CellID->94158039],
Cell[8026, 277, 158, 5, 36, "Output",
 CellID->762624001]
}, Open  ]],
Cell[8199, 285, 124, 3, 70, "ExampleDelimiter",
 CellID->15827063],
Cell[8326, 290, 223, 8, 70, "ExampleText",
 CellID->816869883],
Cell[8552, 300, 652, 20, 70, "Input",
 CellID->414831289],
Cell[9207, 322, 339, 12, 70, "Input",
 CellID->16233593],
Cell[9549, 336, 340, 12, 70, "Input",
 CellID->822789121],
Cell[9892, 350, 340, 12, 70, "Input",
 CellID->597961424],
Cell[10235, 364, 340, 12, 70, "Input",
 CellID->520565682],
Cell[10578, 378, 340, 12, 70, "Input",
 CellID->339588572]
}, Open  ]],
Cell[CellGroupData[{
Cell[10955, 395, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[11196, 404, 218, 8, 70, "ExampleText",
 CellID->308573942],
Cell[CellGroupData[{
Cell[11439, 416, 127, 4, 70, "Input",
 CellID->869569841],
Cell[11569, 422, 202, 8, 36, "Output",
 CellID->21534806]
}, Open  ]],
Cell[11786, 433, 105, 2, 70, "ExampleText",
 CellID->221246839],
Cell[CellGroupData[{
Cell[11916, 439, 114, 5, 70, "Input",
 CellID->78625186],
Cell[12033, 446, 203, 8, 36, "Output",
 CellID->228246046]
}, Open  ]],
Cell[12251, 457, 228, 8, 70, "ExampleText",
 CellID->841547739],
Cell[CellGroupData[{
Cell[12504, 469, 105, 3, 70, "Input",
 CellID->3801962],
Cell[12612, 474, 158, 5, 36, "Output",
 CellID->513612094]
}, Open  ]],
Cell[12785, 482, 212, 8, 70, "ExampleText",
 CellID->176968691],
Cell[CellGroupData[{
Cell[13022, 494, 124, 4, 70, "Input",
 CellID->556915804],
Cell[13149, 500, 180, 6, 36, "Output",
 CellID->479038159]
}, Open  ]],
Cell[13344, 509, 73, 1, 70, "ExampleText",
 CellID->414964913],
Cell[CellGroupData[{
Cell[13442, 514, 92, 3, 70, "Input",
 CellID->442533524],
Cell[13537, 519, 158, 5, 36, "Output",
 CellID->708982616]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13756, 531, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[14075, 542, 724, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[14836, 573, 299, 8, 70, "MoreAboutSection"],
Cell[15138, 583, 149, 3, 70, "MoreAbout",
 CellID->477241916],
Cell[15290, 588, 147, 3, 70, "MoreAbout",
 CellID->332964291]
}, Open  ]],
Cell[15452, 594, 27, 0, 70, "History"],
Cell[15482, 596, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

