(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     35666,       1277]
NotebookOptionsPosition[     28188,       1018]
NotebookOutlinePosition[     30172,       1074]
CellTagsIndexPosition[     30002,       1067]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Reading and Writing Mathematica Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ReadingAndWritingMathematicaFiles"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Reading and Writing Mathematica Files\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FullDefinition" :> 
          Documentation`HelpLookup["paclet:ref/FullDefinition"], 
          "Information" :> 
          Documentation`HelpLookup["paclet:ref/Information"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FullDefinition\"\>", 
       2->"\<\"Information\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Session Information" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionInformation"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Mathematica Session Information\"\>", 
       2->"\<\"Mathematica Sessions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Definition", "ObjectName",
 CellID->9982],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Definition",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Definition"], "[", 
       StyleBox["symbol", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints as the definitions given for a symbol. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8113]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Definition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3287],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Definition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Definition"], "[", 
   StyleBox["symbol", "TI"], "]"}]], "InlineFormula"],
 " prints as all values and attributes defined for ",
 Cell[BoxData[
  StyleBox["symbol", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->32340],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"?", 
   StyleBox["s", "TI"]}]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["Definition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->766],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Definition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]], "InlineFormula"],
 " does not show rules associated with symbols that have attribute ",
 Cell[BoxData[
  ButtonBox["ReadProtected",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ReadProtected"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7633]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->160719422],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->147315706],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "Plus", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->79055235],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "Plus", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{
       "Flat", ",", "Listable", ",", "NumericFunction", ",", "OneIdentity", 
        ",", "Orderless", ",", "Protected"}], "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Default", "[", "Plus", "]"}], ":=", "0"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[Plus],
  Editable->False]], "Output",
 ImageSize->{592, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110916563]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->714338286],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41500995],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->284505166],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAweTIwMPBLMADZ/4Es
MIYBbyBmYOACkkxAYSEoDZPVhssyMMOFGTiBBBuQy4wmDtOlCdYFkYYAkCIW
EJcF2W6QTUxQmhvNLDaoOB+aOpheXrDhTGi6WNH4TKh2Ahk8OOwBuY4VSLNh
6IDZyEeUjcxQ83jRxCXQ3M9PkWk8UNeyk2Uq8aHCTyA0aBPHIJoZyRAOonwl
hMaXQ+OjmsYMtYPlP2rKV8Shix2syxGvrAOSLAOG+/HrhfEg+ZGBEQDKkhEz
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{585, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->248849089]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->270108534],

Cell[TextData[{
 "For built-in symbols, ",
 Cell[BoxData[
  ButtonBox["Definition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]], "InlineFormula"],
 " gives attributes, defaults, and options:"
}], "ExampleText",
 CellID->26013284],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "Information", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->204249407],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "Information", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"HoldAll", ",", "Protected", ",", "ReadProtected"}], "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Options", "[", "Information", "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"LongForm", "\[Rule]", "True"}], "}"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[Information],
  Editable->False]], "Output",
 ImageSize->{585, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->216441790]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->101937783],

Cell[TextData[{
 "For user-defined symbols, ",
 Cell[BoxData[
  ButtonBox["Definition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]], "InlineFormula"],
 " gives attributes, defaults, options, and definitions:"
}], "ExampleText",
 CellID->407498939],

Cell[BoxData[{
 RowBox[{
  RowBox[{"SetAttributes", "[", 
   RowBox[{"f", ",", "Listable"}], "]"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->68482110],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->840306275],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "f", "]"}], "=", 
      RowBox[{"{", "Listable", "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"f", "[", "x_", "]"}], ":=", 
         SuperscriptBox["x", "2"]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`f],
  Editable->False]], "Output",
 ImageSize->{585, 49},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->88559788]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->79063042],

Cell["For read-protected symbols, definitions are not given:", "ExampleText",
 CellID->145825448],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}], "\n", 
 RowBox[{"SetAttributes", "[", 
  RowBox[{"f", ",", 
   RowBox[{"{", "ReadProtected", "}"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->4394155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->318955566],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "f", "]"}], "=", 
      RowBox[{"{", "ReadProtected", "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[$CellContext`f],
  Editable->False]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->266778645]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->98646740],

Cell[TextData[{
 "The information given by ",
 Cell[BoxData[
  ButtonBox["Definition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]], "InlineFormula"],
 " is comprised of defaults, options, attributes, and values:"
}], "ExampleText",
 CellID->636827858],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "Union", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9679424],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "Union", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"Flat", ",", "OneIdentity", ",", "Protected"}], "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Options", "[", "Union", "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"SameTest", "\[Rule]", "Automatic"}], "}"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[Union],
  Editable->False]], "Output",
 ImageSize->{585, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->700283]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DefaultValues", "[", "Union", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->300679346],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"Options", "[", "Union", "]"}], "]"}], "\[RuleDelayed]", 
   RowBox[{"{", 
    RowBox[{"SameTest", "\[Rule]", "Automatic"}], "}"}]}], "}"}]], "Output",
 ImageSize->{372, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13481183]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Union", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->86991958],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Flat", ",", "OneIdentity", ",", "Protected"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->97287600]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113609083],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Information",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]], "InlineFormula"],
 " prints the values rendered by ",
 Cell[BoxData[
  ButtonBox["Definition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]], "InlineFormula"],
 ", as well as usage messages:"
}], "ExampleText",
 CellID->26523415],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Information", "[", "Union", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11667923],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"\\!\\(\\*RowBox[{\\\"Union\\\", \\\"[\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"list\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"list\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"]\\\"}]\\) gives a sorted list of all the distinct elements \
that appear in any of the \\!\\(\\*SubscriptBox[StyleBox[\\\"list\\\", \\\"TI\
\\\"], StyleBox[\\\"i\\\", \\\"TI\\\"]]\\). \
\\n\\!\\(\\*RowBox[{\\\"Union\\\", \\\"[\\\", StyleBox[\\\"list\\\", \\\"TI\\\
\"], \\\"]\\\"}]\\) gives a sorted version of a list, in which all duplicated \
elements have been dropped. \"\>", "MSG"]], "Print",
 CellTags->"Info3381674465-4236656",
 CellID->65907715],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "Union", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"Flat", ",", "OneIdentity", ",", "Protected"}], "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Options", "[", "Union", "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"SameTest", "\[Rule]", "Automatic"}], "}"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["Union"],
  Editable->False]], "Print",
 CellTags->"Info3381674465-4236656",
 CellID->40836850]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["??"], "InlineFormula"],
 " is the same as ",
 Cell[BoxData[
  ButtonBox["Information",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->47407235],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"??", "Union"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->406785884],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"\!\(\*RowBox[{\\\"Union\\\", \\\"[\\\", \
RowBox[{SubscriptBox[StyleBox[\\\"list\\\", \\\"TI\\\"], StyleBox[\\\"1\\\", \
\\\"TR\\\"]], \\\",\\\", SubscriptBox[StyleBox[\\\"list\\\", \\\"TI\\\"], \
StyleBox[\\\"2\\\", \\\"TR\\\"]], \\\",\\\", StyleBox[\\\"\[Ellipsis]\\\", \\\
\"TR\\\"]}], \\\"]\\\"}]\) gives a sorted list of all the distinct elements \
that appear in any of the \!\(\*SubscriptBox[StyleBox[\\\"list\\\", \
\\\"TI\\\"], StyleBox[\\\"i\\\", \\\"TI\\\"]]\). \\n\!\(\*RowBox[{\\\"Union\\\
\", \\\"[\\\", StyleBox[\\\"list\\\", \\\"TI\\\"], \\\"]\\\"}]\) gives a \
sorted version of a list, in which all duplicated elements have been dropped. \
\"\>", "MSG"]], "Print",
 CellTags->"Info3381674581-8096394",
 CellID->81501390],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "Union", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"Flat", ",", "OneIdentity", ",", "Protected"}], "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Options", "[", "Union", "]"}], "=", 
         RowBox[{"{", 
          RowBox[{"SameTest", "\[Rule]", "Automatic"}], "}"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["Union"],
  Editable->False]], "Print",
 CellTags->"Info3381674581-8096394",
 CellID->807391248]
}, Open  ]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17148977],

Cell[TextData[{
 "Definition is ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->18175492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "Definition", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->94399583],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "\<\"Definition\"\>", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{"HoldAll", ",", "Protected"}], "}"}]}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[Definition],
  Editable->False]], "Output",
 ImageSize->{310, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->481908944]
}, Open  ]],

Cell[TextData[{
 "This gives the definition of ",
 StyleBox["symbol", "InlineCode"],
 " itself:"
}], "ExampleText",
 CellID->106363507],

Cell[BoxData[
 RowBox[{
  RowBox[{"symbol", "=", "Plus"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->166955798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "symbol", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->260985168],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytU91qQjEMjv3Rw9ifA2WXPonebQzZQxxkoBdjQ311cXcuSZNDG9dtByw0
aZKvydc2fW3367f3dr9ZtbPnbfu53qx2s6ePLbr8AMC9AMDdI+D6hCueOpY4
ARqUIXMv2HtF0nfuLjrnKPikaDickcw8yekajYDaCziivhc7iE1+2s2OlCzj
8lVUIukMJyf7GRIFpDKhY86p7g0mcxSGox/8lkFhVyuQPvKac4xMXFCXP8n4
Pyc4yzI0KBIHjrnsDbMXN3wu/wpeu+xP7l7QZFd6qODNwSb35FJ7rLLvl14Y
n+2w5+tzN6SP3QtQ2nQdOmg9hPpZE0p/pL3JCtfiR+st6I8LBaupyXjT+za0
DvceTKTSregHqRjEVnTDaLWWPS0YfAPB776F\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{585, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->424465493]
}, Open  ]],

Cell["This gives the definition of its value:", "ExampleText",
 CellID->40465460],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", 
  RowBox[{"Evaluate", "[", "symbol", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->47362752],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "Plus", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{
       "Flat", ",", "Listable", ",", "NumericFunction", ",", "OneIdentity", 
        ",", "Orderless", ",", "Protected"}], "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Default", "[", "Plus", "]"}], ":=", "0"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[Plus],
  Editable->False]], "Output",
 ImageSize->{592, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->91773254]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->70694131],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Definition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]], "InlineFormula"],
 " is an output form: it does not evaluate:"
}], "ExampleText",
 CellID->49887158],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "Plus", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->145948613],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {
     RowBox[{
      RowBox[{"Attributes", "[", "Plus", "]"}], "=", 
      RowBox[{"{", 
       RowBox[{
       "Flat", ",", "Listable", ",", "NumericFunction", ",", "OneIdentity", 
        ",", "Orderless", ",", "Protected"}], "}"}]}]},
    {" "},
    {GridBox[{
       {
        RowBox[{
         RowBox[{"Default", "[", "Plus", "]"}], ":=", "0"}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition[Plus],
  Editable->False]], "Output",
 ImageSize->{592, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->64787316]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->460514176],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Definition", "[", "Plus", "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->6730139]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17995],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FullDefinition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FullDefinition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Information",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Information"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30906]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30290],

Cell[TextData[{
 ButtonBox["Reading and Writing ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"],
  FontSlant->"Italic"],
 ButtonBox[" Files",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/ReadingAndWritingMathematicaFiles"]
}], "Tutorials",
 CellID->3376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->60809623],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSessionInformation"],
  FontSlant->"Italic"],
 ButtonBox[" Session Information",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSessionInformation"]
}], "MoreAbout",
 CellID->537532565],

Cell[TextData[{
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSessions"],
  FontSlant->"Italic"],
 ButtonBox[" Sessions",
  BaseStyle->"Link",
  ButtonData->"paclet:guide/MathematicaSessions"]
}], "MoreAbout",
 CellID->277750474]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Definition - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 37, 7.3500406}", "context" -> "System`", 
    "keywords" -> {
     "function attributes", "function defaults", "function definition", 
      "function options", "function values", "symbol attributes", 
      "symbol defaults", "symbol definition", "symbol options", 
      "symbol values"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Definition[symbol] prints as the definitions given for a symbol. ", 
    "synonyms" -> {"?"}, "title" -> "Definition", "type" -> "Symbol", "uri" -> 
    "ref/Definition"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5142, 179, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->160719422]},
 "Info3381674465-4236656"->{
  Cell[15913, 586, 779, 12, 70, "Print",
   CellTags->"Info3381674465-4236656",
   CellID->65907715],
  Cell[16695, 600, 1018, 30, 70, "Print",
   CellTags->"Info3381674465-4236656",
   CellID->40836850]},
 "Info3381674581-8096394"->{
  Cell[18125, 654, 767, 12, 70, "Print",
   CellTags->"Info3381674581-8096394",
   CellID->81501390],
  Cell[18895, 668, 1019, 30, 70, "Print",
   CellTags->"Info3381674581-8096394",
   CellID->807391248]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29388, 1046},
 {"Info3381674465-4236656", 29537, 1050},
 {"Info3381674581-8096394", 29772, 1057}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2129, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2752, 81, 47, 1, 70, "ObjectName",
 CellID->9982],
Cell[2802, 84, 496, 15, 70, "Usage",
 CellID->8113]
}, Open  ]],
Cell[CellGroupData[{
Cell[3335, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3813, 121, 309, 12, 70, "Notes",
 CellID->3287],
Cell[4125, 135, 345, 12, 70, "Notes",
 CellID->32340],
Cell[4473, 149, 258, 11, 70, "Notes",
 CellID->766],
Cell[4734, 162, 371, 12, 70, "Notes",
 CellID->7633]
}, Closed]],
Cell[CellGroupData[{
Cell[5142, 179, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->160719422],
Cell[CellGroupData[{
Cell[5527, 193, 148, 5, 70, "ExampleSection",
 CellID->147315706],
Cell[CellGroupData[{
Cell[5700, 202, 108, 3, 28, "Input",
 CellID->79055235],
Cell[5811, 207, 1084, 33, 66, "Output",
 CellID->110916563]
}, Open  ]],
Cell[6910, 243, 125, 3, 70, "ExampleDelimiter",
 CellID->714338286],
Cell[7038, 248, 144, 5, 70, "Input",
 CellID->41500995],
Cell[CellGroupData[{
Cell[7207, 257, 106, 3, 28, "Input",
 CellID->284505166],
Cell[7316, 262, 517, 13, 36, "Output",
 Evaluatable->False,
 CellID->248849089]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7882, 281, 220, 7, 70, "ExampleSection",
 CellID->270108534],
Cell[8105, 290, 248, 8, 70, "ExampleText",
 CellID->26013284],
Cell[CellGroupData[{
Cell[8378, 302, 116, 3, 70, "Input",
 CellID->204249407],
Cell[8497, 307, 1110, 33, 66, "Output",
 CellID->216441790]
}, Open  ]],
Cell[9622, 343, 125, 3, 70, "ExampleDelimiter",
 CellID->101937783],
Cell[9750, 348, 266, 8, 70, "ExampleText",
 CellID->407498939],
Cell[10019, 358, 245, 8, 70, "Input",
 CellID->68482110],
Cell[CellGroupData[{
Cell[10289, 370, 106, 3, 70, "Input",
 CellID->840306275],
Cell[10398, 375, 985, 31, 70, "Output",
 CellID->88559788]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11432, 412, 236, 7, 70, "ExampleSection",
 CellID->79063042],
Cell[11671, 421, 97, 1, 70, "ExampleText",
 CellID->145825448],
Cell[11771, 424, 274, 9, 70, "Input",
 CellID->4394155],
Cell[CellGroupData[{
Cell[12070, 437, 106, 3, 70, "Input",
 CellID->318955566],
Cell[12179, 442, 524, 17, 36, "Output",
 CellID->266778645]
}, Open  ]],
Cell[12718, 462, 124, 3, 70, "ExampleDelimiter",
 CellID->98646740],
Cell[12845, 467, 270, 8, 70, "ExampleText",
 CellID->636827858],
Cell[CellGroupData[{
Cell[13140, 479, 108, 3, 70, "Input",
 CellID->9679424],
Cell[13251, 484, 1089, 33, 66, "Output",
 CellID->700283]
}, Open  ]],
Cell[CellGroupData[{
Cell[14377, 522, 113, 3, 70, "Input",
 CellID->300679346],
Cell[14493, 527, 365, 11, 36, "Output",
 CellID->13481183]
}, Open  ]],
Cell[CellGroupData[{
Cell[14895, 543, 109, 3, 70, "Input",
 CellID->86991958],
Cell[15007, 548, 234, 7, 36, "Output",
 CellID->97287600]
}, Open  ]],
Cell[15256, 558, 125, 3, 70, "ExampleDelimiter",
 CellID->113609083],
Cell[15384, 563, 369, 12, 70, "ExampleText",
 CellID->26523415],
Cell[CellGroupData[{
Cell[15778, 579, 110, 3, 70, "Input",
 CellID->11667923],
Cell[CellGroupData[{
Cell[15913, 586, 779, 12, 70, "Print",
 CellTags->"Info3381674465-4236656",
 CellID->65907715],
Cell[16695, 600, 1018, 30, 70, "Print",
 CellTags->"Info3381674465-4236656",
 CellID->40836850]
}, Open  ]]
}, Open  ]],
Cell[17740, 634, 243, 9, 70, "ExampleText",
 CellID->47407235],
Cell[CellGroupData[{
Cell[18008, 647, 92, 3, 70, "Input",
 CellID->406785884],
Cell[CellGroupData[{
Cell[18125, 654, 767, 12, 70, "Print",
 CellTags->"Info3381674581-8096394",
 CellID->81501390],
Cell[18895, 668, 1019, 30, 70, "Print",
 CellTags->"Info3381674581-8096394",
 CellID->807391248]
}, Open  ]]
}, Open  ]],
Cell[19941, 702, 124, 3, 70, "ExampleDelimiter",
 CellID->17148977],
Cell[20068, 707, 194, 8, 70, "ExampleText",
 CellID->18175492],
Cell[CellGroupData[{
Cell[20287, 719, 114, 3, 70, "Input",
 CellID->94399583],
Cell[20404, 724, 567, 18, 36, "Output",
 CellID->481908944]
}, Open  ]],
Cell[20986, 745, 135, 5, 70, "ExampleText",
 CellID->106363507],
Cell[21124, 752, 118, 4, 70, "Input",
 CellID->166955798],
Cell[CellGroupData[{
Cell[21267, 760, 111, 3, 70, "Input",
 CellID->260985168],
Cell[21381, 765, 614, 14, 70, "Output",
 Evaluatable->False,
 CellID->424465493]
}, Open  ]],
Cell[22010, 782, 81, 1, 70, "ExampleText",
 CellID->40465460],
Cell[CellGroupData[{
Cell[22116, 787, 145, 4, 70, "Input",
 CellID->47362752],
Cell[22264, 793, 1083, 33, 66, "Output",
 CellID->91773254]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23396, 832, 229, 7, 70, "ExampleSection",
 CellID->70694131],
Cell[23628, 841, 221, 7, 70, "ExampleText",
 CellID->49887158],
Cell[CellGroupData[{
Cell[23874, 852, 109, 3, 70, "Input",
 CellID->145948613],
Cell[23986, 857, 1083, 33, 66, "Output",
 CellID->64787316]
}, Open  ]],
Cell[CellGroupData[{
Cell[25106, 895, 104, 3, 70, "Input",
 CellID->460514176],
Cell[25213, 900, 329, 12, 50, "Output",
 CellID->6730139]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25603, 919, 311, 9, 70, "SeeAlsoSection",
 CellID->17995],
Cell[25917, 930, 469, 17, 70, "SeeAlso",
 CellID->30906]
}, Open  ]],
Cell[CellGroupData[{
Cell[26423, 952, 314, 9, 70, "TutorialsSection",
 CellID->30290],
Cell[26740, 963, 428, 12, 70, "Tutorials",
 CellID->3376]
}, Open  ]],
Cell[CellGroupData[{
Cell[27205, 980, 318, 9, 70, "MoreAboutSection",
 CellID->60809623],
Cell[27526, 991, 309, 9, 70, "MoreAbout",
 CellID->537532565],
Cell[27838, 1002, 278, 9, 70, "MoreAbout",
 CellID->277750474]
}, Open  ]],
Cell[28131, 1014, 27, 0, 70, "History"],
Cell[28161, 1016, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

