(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25858,        960]
NotebookOptionsPosition[     20264,        764]
NotebookOutlinePosition[     21757,        805]
CellTagsIndexPosition[     21672,        800]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Adding, Removing and Modifying List Elements" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AddingRemovingAndModifyingListElements"], 
          "Manipulating Lists by Their Indices" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingListsByTheirIndices"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Adding, Removing and Modifying List Elements\"\>", 
       2->"\<\"Manipulating Lists by Their Indices\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Insert" :> Documentation`HelpLookup["paclet:ref/Insert"], 
          "MapAt" :> Documentation`HelpLookup["paclet:ref/MapAt"], 
          "ReplacePart" :> Documentation`HelpLookup["paclet:ref/ReplacePart"],
           "FlattenAt" :> Documentation`HelpLookup["paclet:ref/FlattenAt"], 
          "DeleteCases" :> Documentation`HelpLookup["paclet:ref/DeleteCases"],
           "Drop" :> Documentation`HelpLookup["paclet:ref/Drop"], 
          "StringDrop" :> Documentation`HelpLookup["paclet:ref/StringDrop"], 
          "Position" :> Documentation`HelpLookup["paclet:ref/Position"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Insert\"\>", 
       2->"\<\"MapAt\"\>", 3->"\<\"ReplacePart\"\>", 4->"\<\"FlattenAt\"\>", 
       5->"\<\"DeleteCases\"\>", 6->"\<\"Drop\"\>", 7->"\<\"StringDrop\"\>", 
       8->"\<\"Position\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], 
          "Parts of Expressions" :> 
          Documentation`HelpLookup["paclet:guide/PartsOfExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Elements of Lists\"\>", 
       2->"\<\"Expressions\"\>", 
       3->"\<\"Parts of Expressions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Delete", "ObjectName",
 CellID->14398],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Delete",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Delete"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]deletes the element at position ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". If ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " is negative, the position is counted from the end. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Delete",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Delete"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          StyleBox["j", "TI"], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]deletes the part at position ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["i", "TI"], ",", 
        StyleBox["j", "TI"], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Delete",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Delete"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["i", "TI"], 
             StyleBox["1", "TR"]], ",", 
            SubscriptBox[
             StyleBox["j", "TI"], 
             StyleBox["1", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["i", "TI"], 
             StyleBox["2", "TR"]], ",", 
            SubscriptBox[
             StyleBox["j", "TI"], 
             StyleBox["2", "TR"]], ",", 
            StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]deletes parts at several positions. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->1244]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Deleting the head of a particular element in an expression is equivalent to \
applying ",
 Cell[BoxData[
  ButtonBox["FlattenAt",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FlattenAt"]], "InlineFormula"],
 " to the expression at that point. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->18667,
  ButtonNote->"18667"]
}], "Notes",
 CellID->20359],

Cell[TextData[{
 "Deleting the head of a whole expression makes the head be ",
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->16729,
  ButtonNote->"16729"]
}], "Notes",
 CellID->26850],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Delete",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Delete"]], "InlineFormula"],
 " works on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. "
}], "Notes",
 CellID->20456]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->55439101],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->515338715],

Cell["Delete the element at position 3:", "ExampleText",
 CellID->31464],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Delete", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21501],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "d"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15380]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30585],

Cell["Delete at position 2 from the end:", "ExampleText",
 CellID->16702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Delete", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"-", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11073],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "d"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->9653]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8594],

Cell["Delete at positions 1 and 3:", "ExampleText",
 CellID->28227],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Delete", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "1", "}"}], ",", 
     RowBox[{"{", "3", "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->388],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"b", ",", "d"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27954]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17802],

Cell["Delete in a 2D array:", "ExampleText",
 CellID->1866],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Delete", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19168],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], ",", 
   RowBox[{"{", "d", "}"}]}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27147]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26633],

Cell["Delete in an expression with any head:", "ExampleText",
 CellID->24312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Delete", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7862],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "d"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5320]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Delete", "[", 
  RowBox[{
   RowBox[{"a", "+", "b", "+", "c", "+", "d"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27101],

Cell[BoxData[
 RowBox[{"a", "+", "b", "+", "d"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->32555]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4685],

Cell["Delete at any position in any expression:", "ExampleText",
 CellID->28086],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"x", "^", 
   RowBox[{"(", 
    RowBox[{"a", "+", "b", "+", "c"}], ")"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13117],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", 
   RowBox[{"a", "+", "b", "+", "c"}]]}]], "Output",
 ImageSize->{57, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22741]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Delete", "[", 
  RowBox[{"%", ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19763],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox["x", 
   RowBox[{"a", "+", "b"}]]}]], "Output",
 ImageSize->{47, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10648]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27932],

Cell["Delete a head to splice in its arguments:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->18667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Delete", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], ",", "b", ",", "c"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28953],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "x", ",", "y", ",", "b", ",", "c"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31146]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Delete", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"u", "+", "v"}], ",", "c"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->213],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"a", ",", "b", ",", "u", ",", "v", ",", "c"}], "]"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23594]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3266],

Cell[TextData[{
 "Deleting the head of a whole expression gives a ",
 Cell[BoxData[
  ButtonBox["Sequence",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sequence"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->16729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Delete", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18482],

Cell[BoxData[
 RowBox[{"Sequence", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->24508]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16882],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Insert",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Insert"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MapAt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapAt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ReplacePart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ReplacePart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FlattenAt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FlattenAt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeleteCases",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DeleteCases"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Drop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Drop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringDrop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringDrop"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Position",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Position"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3032]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25605],

Cell[TextData[ButtonBox["Adding, Removing and Modifying List Elements",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AddingRemovingAndModifyingListElements"]], "Tutorials",
 CellID->25810],

Cell[TextData[ButtonBox["Manipulating Lists by Their Indices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingListsByTheirIndices"]], "Tutorials",\

 CellID->8428]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->229186026],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->346796300],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->254808545],

Cell[TextData[ButtonBox["Parts of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PartsOfExpressions"]], "MoreAbout",
 CellID->18372923]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Delete"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Delete - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 37, 15.2564930}", "context" -> "System`", 
    "keywords" -> {
     "deleting elements", "lists", "removing elements from lists", 
      "shortening lists"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Delete[expr, n] deletes the element at position n in expr. If n is \
negative, the position is counted from the end. Delete[expr, {i, j, ...}] \
deletes the part at position {i, j, ...}. Delete[expr, {{i_1, j_1, ...}, \
{i_2, j_2, ...}, ...}] deletes parts at several positions. ", 
    "synonyms" -> {}, "title" -> "Delete", "type" -> "Symbol", "uri" -> 
    "ref/Delete"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7768, 242, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->55439101]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21530, 793}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2978, 65, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3601, 92, 44, 1, 70, "ObjectName",
 CellID->14398],
Cell[3648, 95, 2510, 79, 70, "Usage",
 CellID->1244]
}, Open  ]],
Cell[CellGroupData[{
Cell[6195, 179, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6673, 196, 401, 13, 70, "Notes",
 CellID->20359],
Cell[7077, 211, 338, 12, 70, "Notes",
 CellID->26850],
Cell[7418, 225, 313, 12, 70, "Notes",
 CellID->20456]
}, Closed]],
Cell[CellGroupData[{
Cell[7768, 242, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->55439101],
Cell[CellGroupData[{
Cell[8152, 256, 148, 5, 70, "ExampleSection",
 CellID->515338715],
Cell[8303, 263, 72, 1, 70, "ExampleText",
 CellID->31464],
Cell[CellGroupData[{
Cell[8400, 268, 193, 7, 28, "Input",
 CellID->21501],
Cell[8596, 277, 209, 7, 36, "Output",
 CellID->15380]
}, Open  ]],
Cell[8820, 287, 121, 3, 70, "ExampleDelimiter",
 CellID->30585],
Cell[8944, 292, 73, 1, 70, "ExampleText",
 CellID->16702],
Cell[CellGroupData[{
Cell[9042, 297, 209, 7, 70, "Input",
 CellID->11073],
Cell[9254, 306, 208, 7, 36, "Output",
 CellID->9653]
}, Open  ]],
Cell[9477, 316, 120, 3, 70, "ExampleDelimiter",
 CellID->8594],
Cell[9600, 321, 67, 1, 70, "ExampleText",
 CellID->28227],
Cell[CellGroupData[{
Cell[9692, 326, 289, 10, 70, "Input",
 CellID->388],
Cell[9984, 338, 199, 7, 36, "Output",
 CellID->27954]
}, Open  ]],
Cell[10198, 348, 121, 3, 70, "ExampleDelimiter",
 CellID->17802],
Cell[10322, 353, 59, 1, 70, "ExampleText",
 CellID->1866],
Cell[CellGroupData[{
Cell[10406, 358, 325, 12, 70, "Input",
 CellID->19168],
Cell[10734, 372, 272, 10, 36, "Output",
 CellID->27147]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11055, 388, 239, 7, 70, "ExampleSection",
 CellID->26633],
Cell[11297, 397, 77, 1, 70, "ExampleText",
 CellID->24312],
Cell[CellGroupData[{
Cell[11399, 402, 197, 7, 70, "Input",
 CellID->7862],
Cell[11599, 411, 213, 7, 36, "Output",
 CellID->5320]
}, Open  ]],
Cell[CellGroupData[{
Cell[11849, 423, 165, 5, 70, "Input",
 CellID->27101],
Cell[12017, 430, 186, 6, 36, "Output",
 CellID->32555]
}, Open  ]],
Cell[12218, 439, 120, 3, 70, "ExampleDelimiter",
 CellID->4685],
Cell[12341, 444, 80, 1, 70, "ExampleText",
 CellID->28086],
Cell[CellGroupData[{
Cell[12446, 449, 170, 6, 70, "Input",
 CellID->13117],
Cell[12619, 457, 234, 8, 36, "Output",
 CellID->22741]
}, Open  ]],
Cell[CellGroupData[{
Cell[12890, 470, 180, 6, 70, "Input",
 CellID->19763],
Cell[13073, 478, 224, 8, 36, "Output",
 CellID->10648]
}, Open  ]],
Cell[13312, 489, 121, 3, 70, "ExampleDelimiter",
 CellID->27932],
Cell[13436, 494, 128, 2, 70, "ExampleText",
 CellID->18667],
Cell[CellGroupData[{
Cell[13589, 500, 292, 10, 70, "Input",
 CellID->28953],
Cell[13884, 512, 229, 7, 36, "Output",
 CellID->31146]
}, Open  ]],
Cell[CellGroupData[{
Cell[14150, 524, 268, 9, 70, "Input",
 CellID->213],
Cell[14421, 535, 235, 7, 36, "Output",
 CellID->23594]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14705, 548, 232, 7, 70, "ExampleSection",
 CellID->3266],
Cell[14940, 557, 275, 9, 70, "ExampleText",
 CellID->16729],
Cell[CellGroupData[{
Cell[15240, 570, 180, 6, 70, "Input",
 CellID->18482],
Cell[15423, 578, 222, 7, 36, "Output",
 CellID->24508]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15706, 592, 311, 9, 70, "SeeAlsoSection",
 CellID->16882],
Cell[16020, 603, 1920, 71, 70, "SeeAlso",
 CellID->3032]
}, Open  ]],
Cell[CellGroupData[{
Cell[17977, 679, 314, 9, 70, "TutorialsSection",
 CellID->25605],
Cell[18294, 690, 196, 4, 70, "Tutorials",
 CellID->25810],
Cell[18493, 696, 178, 4, 70, "Tutorials",
 CellID->8428]
}, Open  ]],
Cell[CellGroupData[{
Cell[18708, 705, 319, 9, 70, "MoreAboutSection",
 CellID->229186026],
Cell[19030, 716, 144, 3, 70, "MoreAbout",
 CellID->346796300],
Cell[19177, 721, 134, 3, 70, "MoreAbout",
 CellID->254808545],
Cell[19314, 726, 149, 3, 70, "MoreAbout",
 CellID->18372923]
}, Open  ]],
Cell[CellGroupData[{
Cell[19500, 734, 305, 8, 70, "RelatedLinksSection"],
Cell[19808, 744, 384, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[20207, 760, 27, 0, 70, "History"],
Cell[20237, 762, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

