(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13651,        487]
NotebookOptionsPosition[     10109,        369]
NotebookOutlinePosition[     11538,        408]
CellTagsIndexPosition[     11453,        403]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Finding and Manipulating Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/FindingAndManipulatingFiles"], 
          "Manipulating Files and Directories" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingFilesAndDirectories"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Finding and Manipulating Files\"\>",
        2->"\<\"Manipulating Files and Directories\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RenameFile" :> 
          Documentation`HelpLookup["paclet:ref/RenameFile"], 
          "DeleteDirectory" :> 
          Documentation`HelpLookup["paclet:ref/DeleteDirectory"], "CopyFile" :> 
          Documentation`HelpLookup["paclet:ref/CopyFile"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RenameFile\"\>", 
       2->"\<\"DeleteDirectory\"\>", 
       3->"\<\"CopyFile\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"File Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DeleteFile", "ObjectName",
 CellID->18098],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DeleteFile",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DeleteFile"], "[", "\"\<\!\(\*
StyleBox[\"file\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]deletes a file. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DeleteFile",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DeleteFile"], "[", 
       RowBox[{"{", 
        RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"file\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"file\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]deletes a list of files. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->21967]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DeleteFile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DeleteFile"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["Null",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Null"]], "InlineFormula"],
 " if it succeeds in deleting files, and ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if it fails. "
}], "Notes",
 CellID->31594]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->118776309],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->494216894],

Cell["Copy a file and change into the new directory: ", "ExampleText",
 CellID->884863203],

Cell[BoxData[
 RowBox[{
  RowBox[{"file", " ", "=", " ", 
   RowBox[{
   "$InstallationDirectory", "<>", " ", 
    "\"\</Documentation/English/System/ExampleData/coneflower.jpg\>\""}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->758895838],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CopyFile", "[", 
  RowBox[{"file", ",", 
   RowBox[{"$TemporaryPrefix", "<>", "\"\<coneflower.jpg\>\""}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1628776246],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\\\\coneflower.jpg\"\>"], "Output",
 ImageSize->{466, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->63193858]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  RowBox[{"DirectoryName", "[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->479722092],

Cell[BoxData["\<\"C:\\\\Documents and Settings\\\\roger\\\\Local \
Settings\\\\Temp\"\>"], "Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->97715907]
}, Open  ]],

Cell["The file is there: ", "ExampleText",
 CellID->173241949],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", "\"\<*cone*.jpg\>\"", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->339004],

Cell[BoxData[
 RowBox[{"{", "\<\"coneflower.jpg\"\>", "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->519329664]
}, Open  ]],

Cell["Delete the file:", "ExampleText",
 CellID->1519143913],

Cell[BoxData[
 RowBox[{"DeleteFile", "[", 
  RowBox[{"$TemporaryPrefix", "<>", "\"\<coneflower.jpg\>\""}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->818666608],

Cell["The file is no longer there: ", "ExampleText",
 CellID->79600526],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FileNames", "[", "\"\<*cone*.jpg\>\"", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->127501394],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->84264863]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1268],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RenameFile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RenameFile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DeleteDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DeleteDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CopyFile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CopyFile"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14460]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3572],

Cell[TextData[ButtonBox["Finding and Manipulating Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FindingAndManipulatingFiles"]], "Tutorials",
 CellID->6067],

Cell[TextData[ButtonBox["Manipulating Files and Directories",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ManipulatingFilesAndDirectories"]], "Tutorials",\

 CellID->5138]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->7496316],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->70463265]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DeleteFile - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 37, 14.9752358}", "context" -> "System`", 
    "keywords" -> {
     "clobbering files", "del DOS command", "erasing files", "files", 
      "removing files", "file utilities", "file operations"}, "index" -> True,
     "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DeleteFile[\"file\"] deletes a file. DeleteFile[{\"SubscriptBox[ file, \
1]\", \"SubscriptBox[ file, 2]\", ...}] deletes a list of files. ", 
    "synonyms" -> {"delete file", "rm", "del"}, "title" -> "DeleteFile", 
    "type" -> "Symbol", "uri" -> "ref/DeleteFile"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4914, 159, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->118776309]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11310, 396}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2207, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2830, 82, 48, 1, 70, "ObjectName",
 CellID->18098],
Cell[2881, 85, 1010, 30, 70, "Usage",
 CellID->21967]
}, Open  ]],
Cell[CellGroupData[{
Cell[3928, 120, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4406, 137, 471, 17, 70, "Notes",
 CellID->31594]
}, Closed]],
Cell[CellGroupData[{
Cell[4914, 159, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->118776309],
Cell[CellGroupData[{
Cell[5299, 173, 148, 5, 70, "ExampleSection",
 CellID->494216894],
Cell[5450, 180, 90, 1, 70, "ExampleText",
 CellID->884863203],
Cell[5543, 183, 249, 8, 70, "Input",
 CellID->758895838],
Cell[CellGroupData[{
Cell[5817, 195, 195, 6, 28, "Input",
 CellID->1628776246],
Cell[6015, 203, 248, 6, 36, "Output",
 CellID->63193858]
}, Open  ]],
Cell[CellGroupData[{
Cell[6300, 214, 148, 4, 28, "Input",
 CellID->479722092],
Cell[6451, 220, 230, 6, 36, "Output",
 CellID->97715907]
}, Open  ]],
Cell[6696, 229, 62, 1, 70, "ExampleText",
 CellID->173241949],
Cell[CellGroupData[{
Cell[6783, 234, 119, 3, 70, "Input",
 CellID->339004],
Cell[6905, 239, 202, 6, 36, "Output",
 CellID->519329664]
}, Open  ]],
Cell[7122, 248, 60, 1, 70, "ExampleText",
 CellID->1519143913],
Cell[7185, 251, 169, 5, 70, "Input",
 CellID->818666608],
Cell[7357, 258, 71, 1, 70, "ExampleText",
 CellID->79600526],
Cell[CellGroupData[{
Cell[7453, 263, 122, 3, 70, "Input",
 CellID->127501394],
Cell[7578, 268, 174, 6, 36, "Output",
 CellID->84264863]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7813, 281, 310, 9, 70, "SeeAlsoSection",
 CellID->1268],
Cell[8126, 292, 714, 26, 70, "SeeAlso",
 CellID->14460]
}, Open  ]],
Cell[CellGroupData[{
Cell[8877, 323, 313, 9, 70, "TutorialsSection",
 CellID->3572],
Cell[9193, 334, 167, 3, 70, "Tutorials",
 CellID->6067],
Cell[9363, 339, 177, 4, 70, "Tutorials",
 CellID->5138]
}, Open  ]],
Cell[CellGroupData[{
Cell[9577, 348, 317, 9, 70, "MoreAboutSection",
 CellID->7496316],
Cell[9897, 359, 140, 3, 70, "MoreAbout",
 CellID->70463265]
}, Open  ]],
Cell[10052, 365, 27, 0, 70, "History"],
Cell[10082, 367, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

