(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12076,        416]
NotebookOptionsPosition[      9014,        317]
NotebookOutlinePosition[     10474,        357]
CellTagsIndexPosition[     10389,        352]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Expression Input and Output" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OptionsForExpressionInputAndOutput"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Options for Expression Input and Output\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ShowAutoStyles" :> 
          Documentation`HelpLookup["paclet:ref/ShowAutoStyles"], "SyntaxQ" :> 
          Documentation`HelpLookup["paclet:ref/SyntaxQ"], "ShowCursorTracker" :> 
          Documentation`HelpLookup["paclet:ref/ShowCursorTracker"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ShowAutoStyles\"\>", 
       2->"\<\"SyntaxQ\"\>", 
       3->"\<\"ShowCursorTracker\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Accessibility" :> 
          Documentation`HelpLookup["paclet:guide/Accessibility"], 
          "Automatic Text Styling Features" :> 
          Documentation`HelpLookup[
           "paclet:guide/AutomaticTextStylingFeatures"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Accessibility\"\>", 
       2->"\<\"Automatic Text Styling Features\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DelimiterFlashTime", "ObjectName",
 CellID->4539],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DelimiterFlashTime",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DelimiterFlashTime"]], "InlineFormula"],
     "\[LineSeparator]is an option for cells and notebooks which specifies \
how long in seconds a delimiter should flash when its matching delimiter is \
entered. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19501]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"DelimiterFlashTime", "->", "0"}]], "InlineFormula"],
 " makes delimiters not flash."
}], "Notes",
 CellID->6423],

Cell[TextData[{
 "A typical default setting is ",
 Cell[BoxData[
  RowBox[{"DelimiterFlashTime", "->", "0.3"}]], "InlineFormula"],
 ", which makes matching delimiters flash for 0.3 seconds. "
}], "Notes",
 CellID->23815],

Cell[TextData[{
 "Delimiters include parentheses, brackets and braces, as well as ",
 Cell[BoxData[
  RowBox[{"[", "["}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"]", "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData["(*"], "InlineFormula"],
 " and ",
 Cell[BoxData["*)"], "InlineFormula"],
 ", and paired special characters such as ",
 Cell[BoxData["\[LeftAngleBracket]"], "InlineFormula"],
 ", ",
 Cell[BoxData["\[RightAngleBracket]"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29409],

Cell[TextData[{
 "If you enter an unpaired closing delimiter the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end will beep. "
}], "Notes",
 CellID->10053],

Cell[TextData[{
 "You can use the front end menu item ",
 StyleBox["Check Balance", "MenuName"],
 " to select ranges with balanced delimiters in an expression. "
}], "Notes",
 CellID->6002],

Cell[TextData[{
 "You can set ",
 Cell[BoxData[
  ButtonBox["DelimiterFlashTime",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DelimiterFlashTime"]], "InlineFormula"],
 " at the level of a single cell, a notebook, or the whole front end. "
}], "Notes",
 CellID->4431]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->195457807],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->26272818],

Cell["\<\
Create a cell in which matching delimiters are highlighted for two seconds:\
\>", "ExampleText",
 CellID->266642486],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Cell", "[", 
   RowBox[{
    RowBox[{
    "BoxData", "[", "\"\<\\\"type a closing quotation mark here:\>\"", "]"}], 
    ",", "\"\<Input\>\"", ",", 
    RowBox[{"DelimiterFlashTime", "\[Rule]", "2"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->144110134],

Cell[BoxData["\"\<type a closing quotation mark here:\>"], "Input",
 DelimiterFlashTime->2,
 CellLabel->"In[2]:=",
 CellID->57888129]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25535],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowAutoStyles",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowAutoStyles"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SyntaxQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SyntaxQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ShowCursorTracker",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ShowCursorTracker"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19264]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11585],

Cell[TextData[ButtonBox["Options for Expression Input and Output",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/OptionsForExpressionInputAndOutput"]], "Tutorials",
 CellID->15343]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->248653660],

Cell[TextData[ButtonBox["Accessibility",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Accessibility"]], "MoreAbout",
 CellID->119671402],

Cell[TextData[ButtonBox["Automatic Text Styling Features",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AutomaticTextStylingFeatures"]], "MoreAbout",
 CellID->197616465]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DelimiterFlashTime - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 37, 15.6627534}", "context" -> "System`", 
    "keywords" -> {
     "brackets", "flashing", "matching", "bracket matching", 
      "string bracket matching", "string quote matching"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DelimiterFlashTime is an option for cells and notebooks which specifies \
how long in seconds a delimiter should flash when its matching delimiter is \
entered. ", "synonyms" -> {"delimiter flash time"}, "title" -> 
    "DelimiterFlashTime", "type" -> "Symbol", "uri" -> 
    "ref/DelimiterFlashTime"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5521, 183, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->195457807]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10246, 345}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2213, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2836, 81, 55, 1, 70, "ObjectName",
 CellID->4539],
Cell[2894, 84, 545, 15, 70, "Usage",
 CellID->19501]
}, Open  ]],
Cell[CellGroupData[{
Cell[3476, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3954, 121, 154, 5, 70, "Notes",
 CellID->6423],
Cell[4111, 128, 220, 6, 70, "Notes",
 CellID->23815],
Cell[4334, 136, 501, 17, 70, "Notes",
 CellID->29409],
Cell[4838, 155, 180, 6, 70, "Notes",
 CellID->10053],
Cell[5021, 163, 189, 5, 70, "Notes",
 CellID->6002],
Cell[5213, 170, 271, 8, 70, "Notes",
 CellID->4431]
}, Closed]],
Cell[CellGroupData[{
Cell[5521, 183, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->195457807],
Cell[CellGroupData[{
Cell[5906, 197, 147, 5, 70, "ExampleSection",
 CellID->26272818],
Cell[6056, 204, 126, 3, 70, "ExampleText",
 CellID->266642486],
Cell[6185, 209, 322, 9, 70, "Input",
 CellID->144110134],
Cell[6510, 220, 133, 3, 70, "Input",
 CellID->57888129]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6692, 229, 311, 9, 70, "SeeAlsoSection",
 CellID->25535],
Cell[7006, 240, 724, 26, 70, "SeeAlso",
 CellID->19264]
}, Open  ]],
Cell[CellGroupData[{
Cell[7767, 271, 314, 9, 70, "TutorialsSection",
 CellID->11585],
Cell[8084, 282, 187, 4, 70, "Tutorials",
 CellID->15343]
}, Open  ]],
Cell[CellGroupData[{
Cell[8308, 291, 319, 9, 70, "MoreAboutSection",
 CellID->248653660],
Cell[8630, 302, 138, 3, 70, "MoreAbout",
 CellID->119671402],
Cell[8771, 307, 171, 3, 70, "MoreAbout",
 CellID->197616465]
}, Open  ]],
Cell[8957, 313, 27, 0, 70, "History"],
Cell[8987, 315, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

