(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     53148,       1713]
NotebookOptionsPosition[     45354,       1445]
NotebookOutlinePosition[     46955,       1487]
CellTagsIndexPosition[     46869,       1482]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Representation of Derivatives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfDerivatives"], 
          "Expressions with Heads That Are Not Symbols" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ExpressionsWithHeadsThatAreNotSymbols"], 
          "Defining Derivatives" :> 
          Documentation`HelpLookup["paclet:tutorial/DefiningDerivatives"], 
          "Derivatives of Unknown Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DerivativesOfUnknownFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"The Representation of Derivatives\"\>", 
       2->"\<\"Expressions with Heads That Are Not Symbols\"\>", 
       3->"\<\"Defining Derivatives\"\>", 
       4->"\<\"Derivatives of Unknown Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"D" :> Documentation`HelpLookup["paclet:ref/D"], "Dt" :> 
          Documentation`HelpLookup["paclet:ref/Dt"], "Residue" :> 
          Documentation`HelpLookup["paclet:ref/Residue"], "Limit" :> 
          Documentation`HelpLookup["paclet:ref/Limit"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"D\"\>", 2->"\<\"Dt\"\>", 3->"\<\"Residue\"\>", 
       4->"\<\"Limit\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Functions" :> 
          Documentation`HelpLookup["paclet:guide/SpecialFunctions"]}, #, 2]& ,
         Evaluator -> Automatic], {
       1->"\<\"Special Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Derivative ",
 StyleBox["(')", "OperatorCharacter"]
}], "ObjectName",
 CellID->17230],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "'"}]], "InlineFormula"],
     " \[LineSeparator]represents the derivative of a function ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " of one argument. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       RowBox[{"Derivative", "[", 
        RowBox[{
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["n", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "]"}], "[", 
       StyleBox["f", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]is the general form, representing a function obtained \
from ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " by differentiating ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["n", "1"], TraditionalForm]], "InlineMath"],
     " times with respect to the first argument, ",
     Cell[BoxData[
      FormBox[
       SubscriptBox["n", "2"], TraditionalForm]], "InlineMath"],
     " times with respect to the second argument, and so on. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->24611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "'"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Derivative", "[", "1", "]"}], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4309],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "''"}]], "InlineFormula"],
 " evaluates to ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Derivative", "[", "2", "]"}], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->4568],

Cell[TextData[{
 "You can think of ",
 Cell[BoxData[
  ButtonBox["Derivative",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Derivative"]], "InlineFormula"],
 " as a ",
 StyleBox["functional operator",
  FontSlant->"Italic"],
 " which acts on functions to give derivative functions. "
}], "Notes",
 CellID->7030],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Derivative",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Derivative"]], "InlineFormula"],
 " is generated when you apply ",
 Cell[BoxData[
  ButtonBox["D",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/D"]], "InlineFormula"],
 " to functions whose derivatives ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " does not know. "
}], "Notes",
 CellID->18138],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " attempts to convert ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Derivative", "[", 
    StyleBox["n", "TI"], "]"}], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 " and so on to pure functions. Whenever ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"Derivative", "[", 
    StyleBox["n", "TI"], "]"}], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 " is generated, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " rewrites it as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["D",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/D"], "[", 
    RowBox[{
     RowBox[{
      StyleBox["f", "TI"], "[", "#", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"#", ",", 
       StyleBox["n", "TI"]}], "}"}]}], "]"}], "&"}]], "InlineFormula"],
 ". If ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " finds an explicit value for this derivative, it returns this value. \
Otherwise, it returns the original ",
 Cell[BoxData[
  ButtonBox["Derivative",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Derivative"]], "InlineFormula"],
 " form. "
}], "Notes",
 CellID->24932],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Derivative", "[", 
    RowBox[{"-", 
     StyleBox["n", "TI"]}], "]"}], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 " represents the ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["n", "TI"], "\[Null]"}]]], "InlineFormula"],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " indefinite integral of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7001],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"Derivative", "[", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["n", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 " represents the derivative of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " taken ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["n", "i"], TraditionalForm]], "InlineMath"],
 " times with respect to ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["x", "i"], TraditionalForm]], "InlineMath"],
 ". In general, arguments given in lists in ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " can be handled by using a corresponding list structure in ",
 Cell[BoxData[
  ButtonBox["Derivative",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Derivative"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29102],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["N",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/N"], "[", 
   RowBox[{
    RowBox[{
     StyleBox["f", "TI"], "'"}], "[", 
    StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
 " will give a numerical approximation to a derivative. "
}], "Notes",
 CellID->16191]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->431580519],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->984662772],

Cell["Derivative of a defined function:", "ExampleText",
 CellID->182464984],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "x_", "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], " ", "+", " ", 
   RowBox[{"x", "^", "2"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->725134338],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "'"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->105333661],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "t"}], "+", 
  RowBox[{"Cos", "[", "t", "]"}]}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->969022]
}, Open  ]],

Cell[TextData[{
 "This is equivalent to ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{"\[PartialD]", 
     RowBox[{"f", "(", "x", ")"}]}], 
    RowBox[{"\[PartialD]", "x"}],
    MultilineFunction->None], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->23159972],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"f", "[", "x", "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7695749],

Cell[BoxData[
 RowBox[{
  RowBox[{"2", " ", "x"}], "+", 
  RowBox[{"Cos", "[", "x", "]"}]}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->9663057]
}, Open  ]],

Cell["Derivative at a particular value:", "ExampleText",
 CellID->140718618],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "'"}], "[", "0.5", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->375607985],

Cell[BoxData["1.8775825618903728`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->191641760]
}, Open  ]],

Cell[TextData[{
 "This is equivalent to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    FractionBox[
     RowBox[{"\[PartialD]", 
      RowBox[{"f", "(", "x", ")"}]}], 
     RowBox[{"\[PartialD]", "x"}],
     MultilineFunction->None], 
    SubscriptBox[
     StyleBox["\[VerticalSeparator]",
      FontSize->18], 
     RowBox[{"x", "=", "0.5"}]]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->520276204],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", " ", "x"}], "]"}], " ", "/.", " ", 
  RowBox[{"x", "\[Rule]", "0.5"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->615653548],

Cell[BoxData["1.8775825618903728`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->416098279]
}, Open  ]],

Cell["The second derivative:", "ExampleText",
 CellID->264952236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "''"}], "[", "x", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->49873955],

Cell[BoxData[
 RowBox[{"2", "-", 
  RowBox[{"Sin", "[", "x", "]"}]}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->194653312]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->215032737],

Cell["The derivative of a function returns a function:", "ExampleText",
 CellID->20870667],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "x_", "]"}], " ", ":=", " ", 
   RowBox[{"x", " ", 
    RowBox[{"Cos", "[", "x", "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->493320795],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "'"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->194829598],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cos", "[", "#1", "]"}], "-", 
   RowBox[{
    RowBox[{"Sin", "[", "#1", "]"}], " ", "#1"}]}], "&"}]], "Output",
 ImageSize->{143, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->538439389]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "''"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->268383440],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"-", "2"}], " ", 
    RowBox[{"Sin", "[", "#1", "]"}]}], "-", 
   RowBox[{
    RowBox[{"Cos", "[", "#1", "]"}], " ", "#1"}]}], "&"}]], "Output",
 ImageSize->{160, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->451301535]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->818537891],

Cell["Partial derivatives with respect to different arguments:", "ExampleText",
 CellID->66466613],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", ",", " ", "y_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Sin", "[", "y", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4001550],

Cell["The partial derivative with respect to the first argument:", \
"ExampleText",
 CellID->158936608],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Derivative", "[", 
    RowBox[{"1", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->142776108],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Sin", "[", "x", "]"}]}], " ", 
  RowBox[{"Sin", "[", "y", "]"}]}]], "Output",
 ImageSize->{99, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37180968]
}, Open  ]],

Cell["A mixed partial evaluated at a particular value:", "ExampleText",
 CellID->48883059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Derivative", "[", 
    RowBox[{"1", ",", "2"}], "]"}], "[", "f", "]"}], "[", 
  RowBox[{"3", ",", "4"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->923107498],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", "3", "]"}], " ", 
  RowBox[{"Sin", "[", "4", "]"}]}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->280824704]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->179924406],

Cell["Partial derivatives for functions with list arguments:", "ExampleText",
 CellID->17403628],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"{", 
    RowBox[{"x_", ",", " ", "y_"}], "}"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], " ", 
   RowBox[{"Sin", "[", "y", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180681064],

Cell["The partial derivative with respect to the first element:", \
"ExampleText",
 CellID->655156058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Derivative", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], "]"}], "[", "f", "]"}], "[", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->387789657],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Sin", "[", "x", "]"}]}], " ", 
  RowBox[{"Sin", "[", "y", "]"}]}]], "Output",
 ImageSize->{99, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->852000805]
}, Open  ]],

Cell["A mixed partial evaluated at a particular value:", "ExampleText",
 CellID->44821250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Derivative", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], "]"}], "[", "f", "]"}], "[", 
  RowBox[{"{", 
   RowBox[{"3", ",", "4"}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->231610933],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", "3", "]"}], " ", 
  RowBox[{"Sin", "[", "4", "]"}]}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->675549472]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->206304808],

Cell["Define a derivative for a function:", "ExampleText",
 CellID->142609714],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"f", "'"}], "[", "x_", "]"}], " ", ":=", " ", 
   RowBox[{"If", "[", 
    RowBox[{
     RowBox[{"PossibleZeroQ", "[", "x", "]"}], ",", " ", 
     RowBox[{"N", "[", 
      RowBox[{"0", ",", " ", 
       RowBox[{"Precision", "[", "x", "]"}]}], "]"}], ",", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", " ", 
         RowBox[{"Cos", "[", "x", "]"}]}], " ", "-", " ", 
        RowBox[{"Sin", "[", "x", "]"}]}], ")"}], "/", 
      RowBox[{"x", "^", "2"}]}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->58464393],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "'"}], "[", "0.", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->291424564],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->89682431]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f", "'"}], "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "10"}], ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->441383509],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->590802611]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->322995862],

Cell["Define partial derivatives for a function:", "ExampleText",
 CellID->499623254],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", 
      RowBox[{"1", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
    RowBox[{"x_", ",", " ", "y_"}], "]"}], " ", ":=", " ", "y"}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", 
      RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
    RowBox[{"x_", ",", " ", "y_"}], "]"}], " ", ":=", " ", "x"}], 
  ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->344852095],

Cell["This effectively defines the gradient:", "ExampleText",
 CellID->8933471],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"D", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->542479319],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"y", ",", "x"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->44198355]
}, Open  ]],

Cell["Show the vector field:", "ExampleText",
 CellID->387085565],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"points", " ", "=", " ", 
   RowBox[{"Flatten", "[", 
    RowBox[{
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x", ",", "y"}], "}"}], ",", " ", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", "2", ",", ".25"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y", ",", 
         RowBox[{"-", "2"}], ",", "2", ",", " ", ".25"}], "}"}]}], "]"}], ",",
      "1"}], "]"}]}], ";"}], "\n", 
 RowBox[{"ListPlot", "[", 
  RowBox[{"points", ",", " ", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"Apply", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Arrow", "[", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "##", "}"}], ",", 
          RowBox[{
           RowBox[{"{", "##", "}"}], "+", 
           RowBox[{".1", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"Derivative", "[", 
                 RowBox[{"1", ",", "0"}], "]"}], "[", "f", "]"}], "[", "##", 
               "]"}], ",", " ", 
              RowBox[{
               RowBox[{
                RowBox[{"Derivative", "[", 
                 RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", "##", 
               "]"}]}], "}"}]}]}]}], "}"}], "]"}], "&"}], ",", " ", "points", 
      ",", " ", 
      RowBox[{"{", "1", "}"}]}], "]"}]}]}], "]"}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->10971188],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJx117GNHDEMQNGxO7lK7mpwCQYcu0RvCSpBIUMGDBhMYBgYCdgHSwnxd7HY
0RdFcj5+/v7x6/t1XR/frutffNbr//H+884NF5xwwBMesM8zPvk9HHDCBTd8
w9fX8znPtdjYcMEJBzzhAa+1v//k93DACRfc8A0vH567++5DLDjhgCc84LUa
H42Pxkfjo/HR+Gh8ND7Me8/dfdchJhzwhAe8VuGj8FH4KHwUPgofhY/Ch/fe
vPfc3XceYsATHvBaiY/ER+Ij8ZH4SHwkPhIf1j3vvXnvubvvOMQJD3itwEfg
I/AR+Ah8BD4CH4EP6751z3tv3nvu7nse4oDXmviY+Jj4mPiY+Jj4mPiY+LDv
Wfete957895zd9/jENca+Bj4GPgY+Bj4GPgY+Bj42Ov1jvZB+4B10DrgPTAP
9ODa88f6PRxwwgU3fMM7P9bnr3d2DrAP2gesg9YB74F5sNb+njjhgBMuuOEb
3vUDH8499n37nnXfuue9N+89d/c9DzHghAtu+IZ3f8GHc59zj33fvmfdt+55
7817z919xyEmXHDDN7znD3w49zr3OffY9+171n3rnvfevPfc3XceYsEN3/Ce
T/Hh3O/c69zn3GPft+9Z96173nvz3nN333WIDd/wfn/Bh+89zv3Ovc59zj32
ffuedd+657037z13992HeMP7/RYfvvf53uPc79zr3OfcY9+371n3rXvee/Pe
c3ff9yHu+WPF1zsf34MfPr4HPXycgx8+zkHre57z2AfW/5/qwHr+Ux6s///6
CzBGxdI=
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Epilog->{
    ArrowBox[{{-2., -2.}, {-2.2, -2.2}}], 
    ArrowBox[{{-2., -1.75}, {-2.175, -1.95}}], 
    ArrowBox[{{-2., -1.5}, {-2.15, -1.7}}], 
    ArrowBox[{{-2., -1.25}, {-2.125, -1.45}}], 
    ArrowBox[{{-2., -1.}, {-2.1, -1.2}}], 
    ArrowBox[{{-2., -0.75}, {-2.075, -0.95}}], 
    ArrowBox[{{-2., -0.5}, {-2.05, -0.7}}], 
    ArrowBox[{{-2., -0.25}, {-2.025, -0.45}}], 
    ArrowBox[{{-2., 0.}, {-2., -0.2}}], 
    ArrowBox[{{-2., 0.25}, {-1.975, 0.04999999999999999}}], 
    ArrowBox[{{-2., 0.5}, {-1.95, 0.3}}], 
    ArrowBox[{{-2., 0.75}, {-1.925, 0.55}}], 
    ArrowBox[{{-2., 1.}, {-1.9, 0.8}}], 
    ArrowBox[{{-2., 1.25}, {-1.875, 1.05}}], 
    ArrowBox[{{-2., 1.5}, {-1.85, 1.3}}], 
    ArrowBox[{{-2., 1.75}, {-1.825, 1.55}}], 
    ArrowBox[{{-2., 2.}, {-1.8, 1.8}}], 
    ArrowBox[{{-1.75, -2.}, {-1.95, -2.175}}], 
    ArrowBox[{{-1.75, -1.75}, {-1.925, -1.925}}], 
    ArrowBox[{{-1.75, -1.5}, {-1.9, -1.675}}], 
    ArrowBox[{{-1.75, -1.25}, {-1.875, -1.425}}], 
    ArrowBox[{{-1.75, -1.}, {-1.85, -1.175}}], 
    ArrowBox[{{-1.75, -0.75}, {-1.825, -0.925}}], 
    ArrowBox[{{-1.75, -0.5}, {-1.8, -0.675}}], 
    ArrowBox[{{-1.75, -0.25}, {-1.775, -0.42500000000000004`}}], 
    ArrowBox[{{-1.75, 0.}, {-1.75, -0.17500000000000002`}}], 
    ArrowBox[{{-1.75, 0.25}, {-1.725, 0.07499999999999998}}], 
    ArrowBox[{{-1.75, 0.5}, {-1.7, 0.32499999999999996`}}], 
    ArrowBox[{{-1.75, 0.75}, {-1.675, 0.575}}], 
    ArrowBox[{{-1.75, 1.}, {-1.65, 0.825}}], 
    ArrowBox[{{-1.75, 1.25}, {-1.625, 1.075}}], 
    ArrowBox[{{-1.75, 1.5}, {-1.6, 1.325}}], 
    ArrowBox[{{-1.75, 1.75}, {-1.575, 1.575}}], 
    ArrowBox[{{-1.75, 2.}, {-1.55, 1.825}}], 
    ArrowBox[{{-1.5, -2.}, {-1.7, -2.15}}], 
    ArrowBox[{{-1.5, -1.75}, {-1.675, -1.9}}], 
    ArrowBox[{{-1.5, -1.5}, {-1.65, -1.65}}], 
    ArrowBox[{{-1.5, -1.25}, {-1.625, -1.4}}], 
    ArrowBox[{{-1.5, -1.}, {-1.6, -1.15}}], 
    ArrowBox[{{-1.5, -0.75}, {-1.575, -0.9}}], 
    ArrowBox[{{-1.5, -0.5}, {-1.55, -0.65}}], 
    ArrowBox[{{-1.5, -0.25}, {-1.525, -0.4}}], 
    ArrowBox[{{-1.5, 0.}, {-1.5, -0.15000000000000002`}}], 
    ArrowBox[{{-1.5, 0.25}, {-1.475, 0.09999999999999998}}], 
    ArrowBox[{{-1.5, 0.5}, {-1.45, 0.35}}], 
    ArrowBox[{{-1.5, 0.75}, {-1.425, 0.6}}], 
    ArrowBox[{{-1.5, 1.}, {-1.4, 0.85}}], 
    ArrowBox[{{-1.5, 1.25}, {-1.375, 1.1}}], 
    ArrowBox[{{-1.5, 1.5}, {-1.35, 1.35}}], 
    ArrowBox[{{-1.5, 1.75}, {-1.325, 1.6}}], 
    ArrowBox[{{-1.5, 2.}, {-1.3, 1.85}}], 
    ArrowBox[{{-1.25, -2.}, {-1.45, -2.125}}], 
    ArrowBox[{{-1.25, -1.75}, {-1.425, -1.875}}], 
    ArrowBox[{{-1.25, -1.5}, {-1.4, -1.625}}], 
    ArrowBox[{{-1.25, -1.25}, {-1.375, -1.375}}], 
    ArrowBox[{{-1.25, -1.}, {-1.35, -1.125}}], 
    ArrowBox[{{-1.25, -0.75}, {-1.325, -0.875}}], 
    ArrowBox[{{-1.25, -0.5}, {-1.3, -0.625}}], 
    ArrowBox[{{-1.25, -0.25}, {-1.275, -0.375}}], 
    ArrowBox[{{-1.25, 0.}, {-1.25, -0.125}}], 
    ArrowBox[{{-1.25, 0.25}, {-1.225, 0.125}}], 
    ArrowBox[{{-1.25, 0.5}, {-1.2, 0.375}}], 
    ArrowBox[{{-1.25, 0.75}, {-1.175, 0.625}}], 
    ArrowBox[{{-1.25, 1.}, {-1.15, 0.875}}], 
    ArrowBox[{{-1.25, 1.25}, {-1.125, 1.125}}], 
    ArrowBox[{{-1.25, 1.5}, {-1.1, 1.375}}], 
    ArrowBox[{{-1.25, 1.75}, {-1.075, 1.625}}], 
    ArrowBox[{{-1.25, 2.}, {-1.05, 1.875}}], 
    ArrowBox[{{-1., -2.}, {-1.2, -2.1}}], 
    ArrowBox[{{-1., -1.75}, {-1.175, -1.85}}], 
    ArrowBox[{{-1., -1.5}, {-1.15, -1.6}}], 
    ArrowBox[{{-1., -1.25}, {-1.125, -1.35}}], 
    ArrowBox[{{-1., -1.}, {-1.1, -1.1}}], 
    ArrowBox[{{-1., -0.75}, {-1.075, -0.85}}], 
    ArrowBox[{{-1., -0.5}, {-1.05, -0.6}}], 
    ArrowBox[{{-1., -0.25}, {-1.025, -0.35}}], 
    ArrowBox[{{-1., 0.}, {-1., -0.1}}], 
    ArrowBox[{{-1., 0.25}, {-0.975, 0.15}}], 
    ArrowBox[{{-1., 0.5}, {-0.95, 0.4}}], 
    ArrowBox[{{-1., 0.75}, {-0.925, 0.65}}], 
    ArrowBox[{{-1., 1.}, {-0.9, 0.9}}], 
    ArrowBox[{{-1., 1.25}, {-0.875, 1.15}}], 
    ArrowBox[{{-1., 1.5}, {-0.85, 1.4}}], 
    ArrowBox[{{-1., 1.75}, {-0.825, 1.65}}], 
    ArrowBox[{{-1., 2.}, {-0.8, 1.9}}], 
    ArrowBox[{{-0.75, -2.}, {-0.95, -2.075}}], 
    ArrowBox[{{-0.75, -1.75}, {-0.925, -1.825}}], 
    ArrowBox[{{-0.75, -1.5}, {-0.9, -1.575}}], 
    ArrowBox[{{-0.75, -1.25}, {-0.875, -1.325}}], 
    ArrowBox[{{-0.75, -1.}, {-0.85, -1.075}}], 
    ArrowBox[{{-0.75, -0.75}, {-0.825, -0.825}}], 
    ArrowBox[{{-0.75, -0.5}, {-0.8, -0.575}}], 
    ArrowBox[{{-0.75, -0.25}, {-0.775, -0.325}}], 
    ArrowBox[{{-0.75, 0.}, {-0.75, -0.07500000000000001}}], 
    ArrowBox[{{-0.75, 0.25}, {-0.725, 0.175}}], 
    ArrowBox[{{-0.75, 0.5}, {-0.7, 0.425}}], 
    ArrowBox[{{-0.75, 0.75}, {-0.675, 0.675}}], 
    ArrowBox[{{-0.75, 1.}, {-0.65, 0.925}}], 
    ArrowBox[{{-0.75, 1.25}, {-0.625, 1.175}}], 
    ArrowBox[{{-0.75, 1.5}, {-0.6, 1.425}}], 
    ArrowBox[{{-0.75, 1.75}, {-0.575, 1.675}}], 
    ArrowBox[{{-0.75, 2.}, {-0.55, 1.925}}], 
    ArrowBox[{{-0.5, -2.}, {-0.7, -2.05}}], 
    ArrowBox[{{-0.5, -1.75}, {-0.675, -1.8}}], 
    ArrowBox[{{-0.5, -1.5}, {-0.65, -1.55}}], 
    ArrowBox[{{-0.5, -1.25}, {-0.625, -1.3}}], 
    ArrowBox[{{-0.5, -1.}, {-0.6, -1.05}}], 
    ArrowBox[{{-0.5, -0.75}, {-0.575, -0.8}}], 
    ArrowBox[{{-0.5, -0.5}, {-0.55, -0.55}}], 
    ArrowBox[{{-0.5, -0.25}, {-0.525, -0.3}}], 
    ArrowBox[{{-0.5, 0.}, {-0.5, -0.05}}], 
    ArrowBox[{{-0.5, 0.25}, {-0.475, 0.2}}], 
    ArrowBox[{{-0.5, 0.5}, {-0.45, 0.45}}], 
    ArrowBox[{{-0.5, 0.75}, {-0.425, 0.7}}], 
    ArrowBox[{{-0.5, 1.}, {-0.4, 0.95}}], 
    ArrowBox[{{-0.5, 1.25}, {-0.375, 1.2}}], 
    ArrowBox[{{-0.5, 1.5}, {-0.35, 1.45}}], 
    ArrowBox[{{-0.5, 1.75}, {-0.32499999999999996`, 1.7}}], 
    ArrowBox[{{-0.5, 2.}, {-0.3, 1.95}}], 
    ArrowBox[{{-0.25, -2.}, {-0.45, -2.025}}], 
    ArrowBox[{{-0.25, -1.75}, {-0.42500000000000004`, -1.775}}], 
    ArrowBox[{{-0.25, -1.5}, {-0.4, -1.525}}], 
    ArrowBox[{{-0.25, -1.25}, {-0.375, -1.275}}], 
    ArrowBox[{{-0.25, -1.}, {-0.35, -1.025}}], 
    ArrowBox[{{-0.25, -0.75}, {-0.325, -0.775}}], 
    ArrowBox[{{-0.25, -0.5}, {-0.3, -0.525}}], 
    ArrowBox[{{-0.25, -0.25}, {-0.275, -0.275}}], 
    ArrowBox[{{-0.25, 0.}, {-0.25, -0.025}}], 
    ArrowBox[{{-0.25, 0.25}, {-0.225, 0.225}}], 
    ArrowBox[{{-0.25, 0.5}, {-0.2, 0.475}}], 
    ArrowBox[{{-0.25, 0.75}, {-0.175, 0.725}}], 
    ArrowBox[{{-0.25, 1.}, {-0.15, 0.975}}], 
    ArrowBox[{{-0.25, 1.25}, {-0.125, 1.225}}], 
    ArrowBox[{{-0.25, 1.5}, {-0.09999999999999998, 1.475}}], 
    ArrowBox[{{-0.25, 1.75}, {-0.07499999999999998, 1.725}}], 
    ArrowBox[{{-0.25, 2.}, {-0.04999999999999999, 1.975}}], 
    ArrowBox[{{0., -2.}, {-0.2, -2.}}], 
    ArrowBox[{{0., -1.75}, {-0.17500000000000002`, -1.75}}], 
    ArrowBox[{{0., -1.5}, {-0.15000000000000002`, -1.5}}], 
    ArrowBox[{{0., -1.25}, {-0.125, -1.25}}], 
    ArrowBox[{{0., -1.}, {-0.1, -1.}}], 
    ArrowBox[{{0., -0.75}, {-0.07500000000000001, -0.75}}], 
    ArrowBox[{{0., -0.5}, {-0.05, -0.5}}], 
    ArrowBox[{{0., -0.25}, {-0.025, -0.25}}], 
    ArrowBox[{{0., 0.}, {0., 0.}}], 
    ArrowBox[{{0., 0.25}, {0.025, 0.25}}], 
    ArrowBox[{{0., 0.5}, {0.05, 0.5}}], 
    ArrowBox[{{0., 0.75}, {0.07500000000000001, 0.75}}], 
    ArrowBox[{{0., 1.}, {0.1, 1.}}], 
    ArrowBox[{{0., 1.25}, {0.125, 1.25}}], 
    ArrowBox[{{0., 1.5}, {0.15000000000000002`, 1.5}}], 
    ArrowBox[{{0., 1.75}, {0.17500000000000002`, 1.75}}], 
    ArrowBox[{{0., 2.}, {0.2, 2.}}], 
    ArrowBox[{{0.25, -2.}, {0.04999999999999999, -1.975}}], 
    ArrowBox[{{0.25, -1.75}, {0.07499999999999998, -1.725}}], 
    ArrowBox[{{0.25, -1.5}, {0.09999999999999998, -1.475}}], 
    ArrowBox[{{0.25, -1.25}, {0.125, -1.225}}], 
    ArrowBox[{{0.25, -1.}, {0.15, -0.975}}], 
    ArrowBox[{{0.25, -0.75}, {0.175, -0.725}}], 
    ArrowBox[{{0.25, -0.5}, {0.2, -0.475}}], 
    ArrowBox[{{0.25, -0.25}, {0.225, -0.225}}], 
    ArrowBox[{{0.25, 0.}, {0.25, 0.025}}], 
    ArrowBox[{{0.25, 0.25}, {0.275, 0.275}}], 
    ArrowBox[{{0.25, 0.5}, {0.3, 0.525}}], 
    ArrowBox[{{0.25, 0.75}, {0.325, 0.775}}], 
    ArrowBox[{{0.25, 1.}, {0.35, 1.025}}], 
    ArrowBox[{{0.25, 1.25}, {0.375, 1.275}}], 
    ArrowBox[{{0.25, 1.5}, {0.4, 1.525}}], 
    ArrowBox[{{0.25, 1.75}, {0.42500000000000004`, 1.775}}], 
    ArrowBox[{{0.25, 2.}, {0.45, 2.025}}], 
    ArrowBox[{{0.5, -2.}, {0.3, -1.95}}], 
    ArrowBox[{{0.5, -1.75}, {0.32499999999999996`, -1.7}}], 
    ArrowBox[{{0.5, -1.5}, {0.35, -1.45}}], 
    ArrowBox[{{0.5, -1.25}, {0.375, -1.2}}], 
    ArrowBox[{{0.5, -1.}, {0.4, -0.95}}], 
    ArrowBox[{{0.5, -0.75}, {0.425, -0.7}}], 
    ArrowBox[{{0.5, -0.5}, {0.45, -0.45}}], 
    ArrowBox[{{0.5, -0.25}, {0.475, -0.2}}], 
    ArrowBox[{{0.5, 0.}, {0.5, 0.05}}], 
    ArrowBox[{{0.5, 0.25}, {0.525, 0.3}}], 
    ArrowBox[{{0.5, 0.5}, {0.55, 0.55}}], 
    ArrowBox[{{0.5, 0.75}, {0.575, 0.8}}], 
    ArrowBox[{{0.5, 1.}, {0.6, 1.05}}], 
    ArrowBox[{{0.5, 1.25}, {0.625, 1.3}}], 
    ArrowBox[{{0.5, 1.5}, {0.65, 1.55}}], 
    ArrowBox[{{0.5, 1.75}, {0.675, 1.8}}], 
    ArrowBox[{{0.5, 2.}, {0.7, 2.05}}], 
    ArrowBox[{{0.75, -2.}, {0.55, -1.925}}], 
    ArrowBox[{{0.75, -1.75}, {0.575, -1.675}}], 
    ArrowBox[{{0.75, -1.5}, {0.6, -1.425}}], 
    ArrowBox[{{0.75, -1.25}, {0.625, -1.175}}], 
    ArrowBox[{{0.75, -1.}, {0.65, -0.925}}], 
    ArrowBox[{{0.75, -0.75}, {0.675, -0.675}}], 
    ArrowBox[{{0.75, -0.5}, {0.7, -0.425}}], 
    ArrowBox[{{0.75, -0.25}, {0.725, -0.175}}], 
    ArrowBox[{{0.75, 0.}, {0.75, 0.07500000000000001}}], 
    ArrowBox[{{0.75, 0.25}, {0.775, 0.325}}], 
    ArrowBox[{{0.75, 0.5}, {0.8, 0.575}}], 
    ArrowBox[{{0.75, 0.75}, {0.825, 0.825}}], 
    ArrowBox[{{0.75, 1.}, {0.85, 1.075}}], 
    ArrowBox[{{0.75, 1.25}, {0.875, 1.325}}], 
    ArrowBox[{{0.75, 1.5}, {0.9, 1.575}}], 
    ArrowBox[{{0.75, 1.75}, {0.925, 1.825}}], 
    ArrowBox[{{0.75, 2.}, {0.95, 2.075}}], 
    ArrowBox[{{1., -2.}, {0.8, -1.9}}], 
    ArrowBox[{{1., -1.75}, {0.825, -1.65}}], 
    ArrowBox[{{1., -1.5}, {0.85, -1.4}}], 
    ArrowBox[{{1., -1.25}, {0.875, -1.15}}], 
    ArrowBox[{{1., -1.}, {0.9, -0.9}}], 
    ArrowBox[{{1., -0.75}, {0.925, -0.65}}], 
    ArrowBox[{{1., -0.5}, {0.95, -0.4}}], 
    ArrowBox[{{1., -0.25}, {0.975, -0.15}}], 
    ArrowBox[{{1., 0.}, {1., 0.1}}], 
    ArrowBox[{{1., 0.25}, {1.025, 0.35}}], 
    ArrowBox[{{1., 0.5}, {1.05, 0.6}}], 
    ArrowBox[{{1., 0.75}, {1.075, 0.85}}], 
    ArrowBox[{{1., 1.}, {1.1, 1.1}}], 
    ArrowBox[{{1., 1.25}, {1.125, 1.35}}], 
    ArrowBox[{{1., 1.5}, {1.15, 1.6}}], 
    ArrowBox[{{1., 1.75}, {1.175, 1.85}}], 
    ArrowBox[{{1., 2.}, {1.2, 2.1}}], 
    ArrowBox[{{1.25, -2.}, {1.05, -1.875}}], 
    ArrowBox[{{1.25, -1.75}, {1.075, -1.625}}], 
    ArrowBox[{{1.25, -1.5}, {1.1, -1.375}}], 
    ArrowBox[{{1.25, -1.25}, {1.125, -1.125}}], 
    ArrowBox[{{1.25, -1.}, {1.15, -0.875}}], 
    ArrowBox[{{1.25, -0.75}, {1.175, -0.625}}], 
    ArrowBox[{{1.25, -0.5}, {1.2, -0.375}}], 
    ArrowBox[{{1.25, -0.25}, {1.225, -0.125}}], 
    ArrowBox[{{1.25, 0.}, {1.25, 0.125}}], 
    ArrowBox[{{1.25, 0.25}, {1.275, 0.375}}], 
    ArrowBox[{{1.25, 0.5}, {1.3, 0.625}}], 
    ArrowBox[{{1.25, 0.75}, {1.325, 0.875}}], 
    ArrowBox[{{1.25, 1.}, {1.35, 1.125}}], 
    ArrowBox[{{1.25, 1.25}, {1.375, 1.375}}], 
    ArrowBox[{{1.25, 1.5}, {1.4, 1.625}}], 
    ArrowBox[{{1.25, 1.75}, {1.425, 1.875}}], 
    ArrowBox[{{1.25, 2.}, {1.45, 2.125}}], 
    ArrowBox[{{1.5, -2.}, {1.3, -1.85}}], 
    ArrowBox[{{1.5, -1.75}, {1.325, -1.6}}], 
    ArrowBox[{{1.5, -1.5}, {1.35, -1.35}}], 
    ArrowBox[{{1.5, -1.25}, {1.375, -1.1}}], 
    ArrowBox[{{1.5, -1.}, {1.4, -0.85}}], 
    ArrowBox[{{1.5, -0.75}, {1.425, -0.6}}], 
    ArrowBox[{{1.5, -0.5}, {1.45, -0.35}}], 
    ArrowBox[{{1.5, -0.25}, {1.475, -0.09999999999999998}}], 
    ArrowBox[{{1.5, 0.}, {1.5, 0.15000000000000002`}}], 
    ArrowBox[{{1.5, 0.25}, {1.525, 0.4}}], 
    ArrowBox[{{1.5, 0.5}, {1.55, 0.65}}], 
    ArrowBox[{{1.5, 0.75}, {1.575, 0.9}}], 
    ArrowBox[{{1.5, 1.}, {1.6, 1.15}}], 
    ArrowBox[{{1.5, 1.25}, {1.625, 1.4}}], 
    ArrowBox[{{1.5, 1.5}, {1.65, 1.65}}], 
    ArrowBox[{{1.5, 1.75}, {1.675, 1.9}}], 
    ArrowBox[{{1.5, 2.}, {1.7, 2.15}}], 
    ArrowBox[{{1.75, -2.}, {1.55, -1.825}}], 
    ArrowBox[{{1.75, -1.75}, {1.575, -1.575}}], 
    ArrowBox[{{1.75, -1.5}, {1.6, -1.325}}], 
    ArrowBox[{{1.75, -1.25}, {1.625, -1.075}}], 
    ArrowBox[{{1.75, -1.}, {1.65, -0.825}}], 
    ArrowBox[{{1.75, -0.75}, {1.675, -0.575}}], 
    ArrowBox[{{1.75, -0.5}, {1.7, -0.32499999999999996`}}], 
    ArrowBox[{{1.75, -0.25}, {1.725, -0.07499999999999998}}], 
    ArrowBox[{{1.75, 0.}, {1.75, 0.17500000000000002`}}], 
    ArrowBox[{{1.75, 0.25}, {1.775, 0.42500000000000004`}}], 
    ArrowBox[{{1.75, 0.5}, {1.8, 0.675}}], 
    ArrowBox[{{1.75, 0.75}, {1.825, 0.925}}], 
    ArrowBox[{{1.75, 1.}, {1.85, 1.175}}], 
    ArrowBox[{{1.75, 1.25}, {1.875, 1.425}}], 
    ArrowBox[{{1.75, 1.5}, {1.9, 1.675}}], 
    ArrowBox[{{1.75, 1.75}, {1.925, 1.925}}], 
    ArrowBox[{{1.75, 2.}, {1.95, 2.175}}], 
    ArrowBox[{{2., -2.}, {1.8, -1.8}}], 
    ArrowBox[{{2., -1.75}, {1.825, -1.55}}], 
    ArrowBox[{{2., -1.5}, {1.85, -1.3}}], 
    ArrowBox[{{2., -1.25}, {1.875, -1.05}}], 
    ArrowBox[{{2., -1.}, {1.9, -0.8}}], 
    ArrowBox[{{2., -0.75}, {1.925, -0.55}}], 
    ArrowBox[{{2., -0.5}, {1.95, -0.3}}], 
    ArrowBox[{{2., -0.25}, {1.975, -0.04999999999999999}}], 
    ArrowBox[{{2., 0.}, {2., 0.2}}], 
    ArrowBox[{{2., 0.25}, {2.025, 0.45}}], 
    ArrowBox[{{2., 0.5}, {2.05, 0.7}}], 
    ArrowBox[{{2., 0.75}, {2.075, 0.95}}], 
    ArrowBox[{{2., 1.}, {2.1, 1.2}}], 
    ArrowBox[{{2., 1.25}, {2.125, 1.45}}], 
    ArrowBox[{{2., 1.5}, {2.15, 1.7}}], 
    ArrowBox[{{2., 1.75}, {2.175, 1.95}}], 
    ArrowBox[{{2., 2.}, {2.2, 2.2}}]},
  PlotRange->{{-2., 2.}, {-2., 2.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->472623666]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9289],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Derivative",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Derivative"]], "InlineFormula"],
 " with a negative integer order can do integrals:"
}], "ExampleText",
 CellID->9033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Derivative", "[", 
   RowBox[{"-", "2"}], "]"}], "[", 
  RowBox[{"Function", "[", 
   RowBox[{"x", ",", 
    RowBox[{"x", "^", "n"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14672],

Cell[BoxData[
 RowBox[{"Function", "[", 
  RowBox[{"x", ",", 
   FractionBox[
    SuperscriptBox["x", 
     RowBox[{"2", "+", "n"}]], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "n"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"2", "+", "n"}], ")"}]}]]}], "]"}]], "Output",
 ImageSize->{181, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->206930008]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"x", "^", "n"}], ",", "x", ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25453],

Cell[BoxData[
 FractionBox[
  SuperscriptBox["x", 
   RowBox[{"2", "+", "n"}]], 
  RowBox[{"2", "+", 
   RowBox[{"3", " ", "n"}], "+", 
   SuperscriptBox["n", "2"]}]]], "Output",
 ImageSize->{70, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->836600285]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28965],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["D",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/D"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dt",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dt"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Residue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Residue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Limit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Limit"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->37]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3406],

Cell[TextData[ButtonBox["The Representation of Derivatives",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheRepresentationOfDerivatives"]], "Tutorials",
 CellID->8579],

Cell[TextData[ButtonBox["Expressions with Heads That Are Not Symbols",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ExpressionsWithHeadsThatAreNotSymbols"]], "Tutorials",
 CellID->17804],

Cell[TextData[ButtonBox["Defining Derivatives",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DefiningDerivatives"]], "Tutorials",
 CellID->502834547],

Cell[TextData[ButtonBox["Derivatives of Unknown Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DerivativesOfUnknownFunctions"]], "Tutorials",
 CellID->75862164]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->57824552],

Cell[TextData[ButtonBox["Special Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialFunctions"]], "MoreAbout",
 CellID->526706006]
}, Open  ]],

Cell["New in 1  |  Last modified in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Derivative (') - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 37, 58.1169652}", "context" -> "System`", 
    "keywords" -> {
     "'", "derivative symbol", "differentiate function", "partial derivative",
       "prime character", "rate of change", "derivative representation", 
      "derivative operator"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "f' represents the derivative of a function f of one argument. \
Derivative[n_1, n_2, ...][f] is the general form, representing a function \
obtained from f by differentiating n_1 times with respect to the first \
argument, n_2 times with respect to the second argument, and so on. ", 
    "synonyms" -> {}, "title" -> "Derivative", "type" -> "Symbol", "uri" -> 
    "ref/Derivative"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9814, 343, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->431580519]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 46726, 1475}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2593, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3216, 87, 103, 4, 70, "ObjectName",
 CellID->17230],
Cell[3322, 93, 1384, 42, 70, "Usage",
 CellID->24611]
}, Open  ]],
Cell[CellGroupData[{
Cell[4743, 140, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5221, 157, 272, 11, 70, "Notes",
 CellID->4309],
Cell[5496, 170, 269, 11, 70, "Notes",
 CellID->4568],
Cell[5768, 183, 315, 11, 70, "Notes",
 CellID->7030],
Cell[6086, 196, 412, 15, 70, "Notes",
 CellID->18138],
Cell[6501, 213, 1161, 42, 70, "Notes",
 CellID->24932],
Cell[7665, 257, 501, 20, 70, "Notes",
 CellID->7001],
Cell[8169, 279, 1275, 45, 70, "Notes",
 CellID->29102],
Cell[9447, 326, 330, 12, 70, "Notes",
 CellID->16191]
}, Closed]],
Cell[CellGroupData[{
Cell[9814, 343, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->431580519],
Cell[CellGroupData[{
Cell[10199, 357, 148, 5, 70, "ExampleSection",
 CellID->984662772],
Cell[10350, 364, 76, 1, 70, "ExampleText",
 CellID->182464984],
Cell[10429, 367, 220, 7, 70, "Input",
 CellID->725134338],
Cell[CellGroupData[{
Cell[10674, 378, 115, 4, 28, "Input",
 CellID->105333661],
Cell[10792, 384, 230, 8, 36, "Output",
 CellID->969022]
}, Open  ]],
Cell[11037, 395, 291, 11, 70, "ExampleText",
 CellID->23159972],
Cell[CellGroupData[{
Cell[11353, 410, 147, 5, 70, "Input",
 CellID->7695749],
Cell[11503, 417, 231, 8, 36, "Output",
 CellID->9663057]
}, Open  ]],
Cell[11749, 428, 76, 1, 70, "ExampleText",
 CellID->140718618],
Cell[CellGroupData[{
Cell[11850, 433, 117, 4, 70, "Input",
 CellID->375607985],
Cell[11970, 439, 176, 5, 36, "Output",
 CellID->191641760]
}, Open  ]],
Cell[12161, 447, 423, 16, 70, "ExampleText",
 CellID->520276204],
Cell[CellGroupData[{
Cell[12609, 467, 221, 7, 70, "Input",
 CellID->615653548],
Cell[12833, 476, 176, 5, 36, "Output",
 CellID->416098279]
}, Open  ]],
Cell[13024, 484, 65, 1, 70, "ExampleText",
 CellID->264952236],
Cell[CellGroupData[{
Cell[13114, 489, 115, 4, 70, "Input",
 CellID->49873955],
Cell[13232, 495, 210, 7, 36, "Output",
 CellID->194653312]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13491, 508, 220, 7, 70, "ExampleSection",
 CellID->215032737],
Cell[13714, 517, 90, 1, 70, "ExampleText",
 CellID->20870667],
Cell[13807, 520, 207, 7, 70, "Input",
 CellID->493320795],
Cell[CellGroupData[{
Cell[14039, 531, 87, 3, 70, "Input",
 CellID->194829598],
Cell[14129, 536, 289, 10, 36, "Output",
 CellID->538439389]
}, Open  ]],
Cell[CellGroupData[{
Cell[14455, 551, 88, 3, 70, "Input",
 CellID->268383440],
Cell[14546, 556, 334, 12, 36, "Output",
 CellID->451301535]
}, Open  ]],
Cell[14895, 571, 125, 3, 70, "ExampleDelimiter",
 CellID->818537891],
Cell[15023, 576, 98, 1, 70, "ExampleText",
 CellID->66466613],
Cell[15124, 579, 245, 8, 70, "Input",
 CellID->4001550],
Cell[15372, 589, 103, 2, 70, "ExampleText",
 CellID->158936608],
Cell[CellGroupData[{
Cell[15500, 595, 211, 7, 70, "Input",
 CellID->142776108],
Cell[15714, 604, 258, 9, 36, "Output",
 CellID->37180968]
}, Open  ]],
Cell[15987, 616, 90, 1, 70, "ExampleText",
 CellID->48883059],
Cell[CellGroupData[{
Cell[16102, 621, 211, 7, 70, "Input",
 CellID->923107498],
Cell[16316, 630, 240, 8, 36, "Output",
 CellID->280824704]
}, Open  ]],
Cell[16571, 641, 125, 3, 70, "ExampleDelimiter",
 CellID->179924406],
Cell[16699, 646, 96, 1, 70, "ExampleText",
 CellID->17403628],
Cell[16798, 649, 272, 9, 70, "Input",
 CellID->180681064],
Cell[17073, 660, 102, 2, 70, "ExampleText",
 CellID->655156058],
Cell[CellGroupData[{
Cell[17200, 666, 261, 9, 70, "Input",
 CellID->387789657],
Cell[17464, 677, 259, 9, 36, "Output",
 CellID->852000805]
}, Open  ]],
Cell[17738, 689, 90, 1, 70, "ExampleText",
 CellID->44821250],
Cell[CellGroupData[{
Cell[17853, 694, 261, 9, 70, "Input",
 CellID->231610933],
Cell[18117, 705, 240, 8, 36, "Output",
 CellID->675549472]
}, Open  ]],
Cell[18372, 716, 125, 3, 70, "ExampleDelimiter",
 CellID->206304808],
Cell[18500, 721, 78, 1, 70, "ExampleText",
 CellID->142609714],
Cell[18581, 724, 612, 19, 70, "Input",
 CellID->58464393],
Cell[CellGroupData[{
Cell[19218, 747, 116, 4, 70, "Input",
 CellID->291424564],
Cell[19337, 753, 159, 5, 36, "Output",
 CellID->89682431]
}, Open  ]],
Cell[CellGroupData[{
Cell[19533, 763, 254, 9, 70, "Input",
 CellID->441383509],
Cell[19790, 774, 3104, 55, 70, "Output",
 Evaluatable->False,
 CellID->590802611]
}, Open  ]],
Cell[22909, 832, 125, 3, 70, "ExampleDelimiter",
 CellID->322995862],
Cell[23037, 837, 85, 1, 70, "ExampleText",
 CellID->499623254],
Cell[23125, 840, 507, 18, 70, "Input",
 CellID->344852095],
Cell[23635, 860, 79, 1, 70, "ExampleText",
 CellID->8933471],
Cell[CellGroupData[{
Cell[23739, 865, 249, 9, 70, "Input",
 CellID->542479319],
Cell[23991, 876, 202, 7, 36, "Output",
 CellID->44198355]
}, Open  ]],
Cell[24208, 886, 65, 1, 70, "ExampleText",
 CellID->387085565],
Cell[CellGroupData[{
Cell[24298, 891, 1459, 44, 70, "Input",
 CellID->10971188],
Cell[25760, 937, 14957, 320, 139, "Output",
 CellID->472623666]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[40766, 1263, 238, 7, 70, "ExampleSection",
 CellID->9289],
Cell[41007, 1272, 224, 7, 70, "ExampleText",
 CellID->9033],
Cell[CellGroupData[{
Cell[41256, 1283, 233, 8, 70, "Input",
 CellID->14672],
Cell[41492, 1293, 421, 15, 56, "Output",
 CellID->206930008]
}, Open  ]],
Cell[CellGroupData[{
Cell[41950, 1313, 158, 5, 70, "Input",
 CellID->25453],
Cell[42111, 1320, 308, 11, 56, "Output",
 CellID->836600285]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42480, 1338, 311, 9, 70, "SeeAlsoSection",
 CellID->28965],
Cell[42794, 1349, 904, 35, 70, "SeeAlso",
 CellID->37]
}, Open  ]],
Cell[CellGroupData[{
Cell[43735, 1389, 313, 9, 70, "TutorialsSection",
 CellID->3406],
Cell[44051, 1400, 173, 3, 70, "Tutorials",
 CellID->8579],
Cell[44227, 1405, 194, 4, 70, "Tutorials",
 CellID->17804],
Cell[44424, 1411, 154, 3, 70, "Tutorials",
 CellID->502834547],
Cell[44581, 1416, 175, 3, 70, "Tutorials",
 CellID->75862164]
}, Open  ]],
Cell[CellGroupData[{
Cell[44793, 1424, 318, 9, 70, "MoreAboutSection",
 CellID->57824552],
Cell[45114, 1435, 145, 3, 70, "MoreAbout",
 CellID->526706006]
}, Open  ]],
Cell[45274, 1441, 50, 0, 70, "History"],
Cell[45327, 1443, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

