(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     57406,       2046]
NotebookOptionsPosition[     46399,       1651]
NotebookOutlinePosition[     47700,       1688]
CellTagsIndexPosition[     47614,       1683]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Vectors and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/VectorsAndMatrices"], 
          "Basic Matrix Operations" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/BasicMatrixOperations"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Vectors and Matrices\"\>", 
       2->"\<\"Basic Matrix Operations\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CharacteristicPolynomial" :> 
          Documentation`HelpLookup["paclet:ref/CharacteristicPolynomial"], 
          "Minors" :> Documentation`HelpLookup["paclet:ref/Minors"], 
          "RowReduce" :> Documentation`HelpLookup["paclet:ref/RowReduce"], 
          "MatrixRank" :> Documentation`HelpLookup["paclet:ref/MatrixRank"], 
          "NullSpace" :> Documentation`HelpLookup["paclet:ref/NullSpace"], 
          "Tr" :> Documentation`HelpLookup["paclet:ref/Tr"], "Signature" :> 
          Documentation`HelpLookup["paclet:ref/Signature"], "Eigenvalues" :> 
          Documentation`HelpLookup["paclet:ref/Eigenvalues"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CharacteristicPolynomial\"\>", 
       2->"\<\"Minors\"\>", 3->"\<\"RowReduce\"\>", 4->"\<\"MatrixRank\"\>", 
       5->"\<\"NullSpace\"\>", 6->"\<\"Tr\"\>", 7->"\<\"Signature\"\>", 
       8->"\<\"Eigenvalues\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Systems" :> 
          Documentation`HelpLookup["paclet:guide/LinearSystems"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Matrix Operations" :> 
          Documentation`HelpLookup["paclet:guide/MatrixOperations"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"Linear Systems\"\>", 
       2->"\<\"Matrices and Linear Algebra\"\>", 
       3->"\<\"Matrix Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Det", "ObjectName",
 CellID->3706],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Det",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Det"], "[", 
       StyleBox["m", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the determinant of the square matrix ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28419]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Det",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Det"], "[", 
   RowBox[{
    StyleBox["m", "TI"], ",", 
    RowBox[{
     ButtonBox["Modulus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Modulus"], "->", 
     StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
 " computes the determinant modulo ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9643]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20258169],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->672746627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       SubscriptBox["a", 
        RowBox[{"1", ",", "1"}]], 
       SubscriptBox["a", 
        RowBox[{"1", ",", "2"}]]},
      {
       SubscriptBox["a", 
        RowBox[{"2", ",", "1"}]], 
       SubscriptBox["a", 
        RowBox[{"2", ",", "2"}]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->228759878],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SubscriptBox["a", 
     RowBox[{"1", ",", "2"}]]}], " ", 
   SubscriptBox["a", 
    RowBox[{"2", ",", "1"}]]}], "+", 
  RowBox[{
   SubscriptBox["a", 
    RowBox[{"1", ",", "1"}]], " ", 
   SubscriptBox["a", 
    RowBox[{"2", ",", "2"}]]}]}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->47467031]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {
       SubscriptBox["a", 
        RowBox[{"1", ",", "1"}]], 
       SubscriptBox["a", 
        RowBox[{"1", ",", "2"}]], 
       SubscriptBox["a", 
        RowBox[{"1", ",", "3"}]]},
      {
       SubscriptBox["a", 
        RowBox[{"2", ",", "1"}]], 
       SubscriptBox["a", 
        RowBox[{"2", ",", "2"}]], 
       SubscriptBox["a", 
        RowBox[{"2", ",", "3"}]]},
      {
       SubscriptBox["a", 
        RowBox[{"3", ",", "1"}]], 
       SubscriptBox["a", 
        RowBox[{"3", ",", "2"}]], 
       SubscriptBox["a", 
        RowBox[{"3", ",", "3"}]]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->659410434],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdWNtOg0AQ3XIrTSlU05s+KP6MPvkRpDFpH4ym9v9xd4WmPQzsLILEkrQw
uzPnnJm9cHnNjru39+y432bpyyH73O23X+nzx0E2uSMhHCGPZCPkdS6v9G+Z
57lw1ZU+xBrsFdhpz/5Phn6MR/yu/QP1J2L578tGR1neqVceqqaqV4W4lV7V
GhVeHiArvEUtrnKc1eI6Ra89bkUvRE7PUSuKVue4RGS92rgRd9lYh6hBb1SL
67TWW9a+HlfHiDmgoj5knYIN2KKK6JRiT+xqCW8o3guchGJqUBa157XNt4KK
WmEOyIt7ireCM7PMGf2rvHfGOsesDMlRbbBxT7bI90LdDYNX3hbESJ11yCSn
18sY7IDp5zP92sZdq455x3hcfclAvEHP9eTi/ayCMKfWG+52Idj02scoZKSj
cO/C+vBQTNx+qzzp3agfxUPWOOmQq11eJoVxjwp5cwUVklHWM+6vFV/eA4uH
O3245Z5hZD8fG9UfkFEOeI3BpjVjFM6echfk1enalfLWlim/8o7R5YzlcLYb
Cb5SrGn7cexb6ZA11f36adgrLPXWNyFq6TGU+zV+QQ2u/894S7wxU9cceELL
eG7+iSEfU31CCz2Uvr7za3paXZKtC7IVv3nRK21YxEcLXxr34dcI+K2Q3sds
EPUbup6XblE1t+BR59Sy/QnsNfhz22+1qlKn06ElRt/qSL1w\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{512, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10578135]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->527922720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->480188104],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->666723273]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25651],

Cell["Use exact arithmetic to compute the determinant:", "ExampleText",
 CellID->41331787],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"HilbertMatrix", "[", "5", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->218779135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->272742706],

Cell[BoxData[
 FractionBox["1", "266716800000"]], "Output",
 ImageSize->{99, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->48977182]
}, Open  ]],

Cell["Use machine arithmetic:", "ExampleText",
 CellID->450291204],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"N", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->277940401],

Cell[BoxData["3.749295132518373`*^-12"], "Output",
 ImageSize->{87, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->915199491]
}, Open  ]],

Cell["Use 40-digit precision arithmetic:", "ExampleText",
 CellID->30370119],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"N", "[", 
   RowBox[{"m", ",", "40"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->278102280],

Cell[BoxData["3.7492951325150871636132407107463796806200434319`34.\
025186294398*^-12"], "Output",
 ImageSize->{290, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->390022357]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->484293617],

Cell["Determinant of a complex valued matrix:", "ExampleText",
 CellID->458400108],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"RandomComplex", "[", 
   RowBox[{
    RowBox[{"1", "+", "I"}], ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->47106202],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3.375975919753716`*^39"}], "-", 
  RowBox[{"1.7475175660470347`*^40", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{205, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121784382]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->447470696],

Cell["Determinant of a sparse matrix:", "ExampleText",
 CellID->609611779],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "i_"}], "}"}], "\[Rule]", 
       RowBox[{"-", "2."}]}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"i", "-", "j"}], "]"}], "\[Equal]", "1"}]}], "\[Rule]", 
       "1."}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1000", ",", "1000"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4502940],

Cell[BoxData["1001.0000000001685`"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15420724]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7475],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->8879],

Cell["Compute a determinant using arithmetic modulo 47:", "ExampleText",
 CellID->22888293],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", " ", "=", " ", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"46", ",", " ", 
     RowBox[{"{", 
      RowBox[{"100", ",", " ", "100"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110063470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"m", ",", " ", 
   RowBox[{"Modulus", "\[Rule]", "47"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->133599999],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->785197409]
}, Open  ]],

Cell[TextData[{
 "This is faster than computing ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Mod",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mod"], "[", 
   RowBox[{
    RowBox[{"Det", "[", 
     StyleBox["m", "TI"], "]"}], ",", " ", "47"}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->286974980],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{
   RowBox[{"Det", "[", "m", "]"}], ",", " ", "47"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20477338],

Cell[BoxData["7"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->39656045]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11858],

Cell[TextData[{
 "Cramer's rule for solving a linear system ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["m", "TI"], ".", 
    StyleBox["x", "TI"]}], " ", "=", " ", 
   StyleBox["b", "TI"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->452871632],

Cell[BoxData[
 RowBox[{
  RowBox[{"crule", "[", 
   RowBox[{"m_", ",", "b_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"d", "=", 
       RowBox[{"Det", "[", "m", "]"}]}], ",", "a"}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"a", "=", "m"}], ";", 
       RowBox[{
        RowBox[{"a", "[", 
         RowBox[{"[", 
          RowBox[{"All", ",", "k"}], "]"}], "]"}], "=", "b"}], ";", 
       RowBox[{
        RowBox[{"Det", "[", "a", "]"}], "/", "d"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", 
        RowBox[{"Length", "[", "m", "]"}]}], "}"}]}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119875586],

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "4", ",", "9"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "8", ",", "27"}], "}"}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"4", ",", "16", ",", "46"}], "}"}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->647257522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"crule", "[", 
   RowBox[{"m", ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "16", ",", "46"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->210992720],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "5"}], ",", "3", ",", "1"}], "}"}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->197314053]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"m", ".", "x"}], "\[Equal]", "b"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->9253361],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->560764733]
}, Open  ]],

Cell[TextData[{
 "For numerical systems,",
 Cell[BoxData[
  RowBox[{" ", 
   ButtonBox["LinearSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LinearSolve"]}]], "InlineFormula"],
 " is much faster and more accurate:"
}], "ExampleText",
 CellID->19900096],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "250"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "n"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"ConstantArray", "[", 
    RowBox[{"1", ",", "n"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"m", ".", "x"}]}], ";"}]}], "Input",
 CellLabel->"In[5]:=",
 CellID->324953127],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Norm", "[", 
   RowBox[{
    RowBox[{"crule", "[", 
     RowBox[{"m", ",", "b"}], "]"}], "-", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->282675086],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.5630000000000015`", ",", "1.1840340448021896`*^-12"}], 
  "}"}]], "Output",
 ImageSize->{154, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->97052269]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Norm", "[", 
   RowBox[{
    RowBox[{"LinearSolve", "[", 
     RowBox[{"m", ",", "b"}], "]"}], "-", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->371622240],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.030999999999999403`", ",", "2.8058379005137887`*^-12"}], 
  "}"}]], "Output",
 ImageSize->{154, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->177070177]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->324885446],

Cell["Modular computation of a determinant:", "ExampleText",
 CellID->633361373],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"12", ",", "13"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"14", ",", "15"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->990752637],

Cell["Modular determinants:", "ExampleText",
 CellID->8435738],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d1", "=", 
  RowBox[{"Det", "[", 
   RowBox[{"a", ",", 
    RowBox[{"Modulus", "\[Rule]", "5"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->146400330],

Cell[BoxData["3"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->252097942]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"d2", "=", 
  RowBox[{"Det", "[", 
   RowBox[{"a", ",", 
    RowBox[{"Modulus", "\[Rule]", "7"}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->264321756],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->232496375]
}, Open  ]],

Cell["Recover result: ", "ExampleText",
 CellID->300558006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ChineseRemainder", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"d1", ",", "d2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "7"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->49695079],

Cell[BoxData["33"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->202223394]
}, Open  ]],

Cell["Shift residue to be symmetric:", "ExampleText",
 CellID->75507059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mod", "[", 
  RowBox[{"33", ",", 
   RowBox[{"5", " ", "7"}], ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "5"}], " ", "7"}], "+", "1"}], ")"}], "/", "2"}]}], 
  "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->481160300],

Cell[BoxData[
 RowBox[{"-", "2"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->239457675]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", "a", "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->100114939],

Cell[BoxData[
 RowBox[{"-", "2"}]], "Output",
 ImageSize->{19, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->253144260]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18583],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CharacteristicPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacteristicPolynomial"], "[", 
   StyleBox["m", "TI"], "]"}]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  FormBox[
   TagBox[
    RowBox[{"\[LeftBracketingBar]", 
     RowBox[{"m", "-", 
      RowBox[{"\[Lambda]", " ", "I"}]}], " ", "\[RightBracketingBar]"}],
    {Det}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->246687494],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"RandomInteger", "[", 
    RowBox[{"9", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108117351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"m", "-", 
   RowBox[{"\[Lambda]", " ", 
    RowBox[{"IdentityMatrix", "[", "3", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->612469435],

Cell[BoxData[
 RowBox[{"137", "+", 
  RowBox[{"3", " ", "\[Lambda]"}], "+", 
  RowBox[{"10", " ", 
   SuperscriptBox["\[Lambda]", "2"]}], "-", 
  SuperscriptBox["\[Lambda]", "3"]}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->235914783]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"CharacteristicPolynomial", "[", 
  RowBox[{"m", ",", "\[Lambda]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->184348894],

Cell[BoxData[
 RowBox[{"137", "+", 
  RowBox[{"3", " ", "\[Lambda]"}], "+", 
  RowBox[{"10", " ", 
   SuperscriptBox["\[Lambda]", "2"]}], "-", 
  SuperscriptBox["\[Lambda]", "3"]}]], "Output",
 ImageSize->{122, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->170381173]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11351886],

Cell["The determinant is the product of the eigenvalues:", "ExampleText",
 CellID->426816741],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"100", ",", "100"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->747192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->159263446],

Cell[BoxData["2.614110724973401`*^26"], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17286952]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"Times", ",", 
   RowBox[{"Eigenvalues", "[", "m", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->606915334],

Cell[BoxData[
 RowBox[{"2.614110724973328`*^26", "-", 
  RowBox[{"5.7935921152`*^10", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{198, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->408717726]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24627488],

Cell["\<\
The determinant of a triangular matrix is the product of its diagonal \
elements:\
\>", "ExampleText",
 CellID->107659909],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"m", "=", 
   RowBox[{"SparseArray", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
       RowBox[{"i", "\[GreaterEqual]", "j"}]}], "\[RuleDelayed]", 
      RowBox[{"RandomReal", "[", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "5"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->88136536],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.5571369763906076`", "0", "0", "0", "0"},
     {"0.13867149076773755`", "0.3528109527764214`", "0", "0", "0"},
     {"0.9472373141722348`", "0.4923969645209132`", "0.3156886414885063`", 
      "0", "0"},
     {"0.6228632604607458`", "0.3484836177422703`", "0.4736633908080914`", 
      "0.5879115298148636`", "0"},
     {"0.11301300433309591`", "0.4037711705303699`", "0.13699394460188485`", 
      "0.8874752918551632`", "0.3400282783339075`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[
   SparseArray[
    Automatic, {5, 5}, 0, {
     1, {{0, 1, 3, 6, 10, 15}, {{1}, {2}, {1}, {3}, {2}, {1}, {4}, {1}, {2}, {
       3}, {2}, {1}, {4}, {5}, {3}}}, {0.5571369763906076, 0.3528109527764214,
       0.13867149076773755`, 0.3156886414885063, 0.4923969645209132, 
      0.9472373141722348, 0.5879115298148636, 0.6228632604607458, 
      0.3484836177422703, 0.4736633908080914, 0.4037711705303699, 
      0.11301300433309591`, 0.8874752918551632, 0.3400282783339075, 
      0.13699394460188485`}}]]]]], "Output",
 ImageSize->{336, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->17344622]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", "m", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->122515196],

Cell[BoxData["0.012404807011684988`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->160754329]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apply", "[", 
  RowBox[{"Times", ",", 
   RowBox[{"Diagonal", "[", "m", "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->483199888],

Cell[BoxData["0.012404807011684988`"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->36669090]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->135469644],

Cell["\<\
The determinant of a matrix product is the product of the determinants:\
\>", "ExampleText",
 CellID->23285793],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "100", ",", "100"}], "}"}]}], "]"}]}], ";"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->607973983],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"a", ".", "b"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->182831126],

Cell[BoxData[
 RowBox[{"-", "2.085948473695922`*^51"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->933294448]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Det", "[", "a", "]"}], 
  RowBox[{"Det", "[", "b", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->508729053],

Cell[BoxData[
 RowBox[{"-", "2.0859484736910962`*^51"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->119590041]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->527350143],

Cell["\<\
The determinant of the inverse is the reciprocal of the determinant:\
\>", "ExampleText",
 CellID->352411894],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        SubscriptBox["a", 
         RowBox[{"1", ",", "1"}]], 
        SubscriptBox["a", 
         RowBox[{"1", ",", "2"}]], 
        SubscriptBox["a", 
         RowBox[{"1", ",", "3"}]]},
       {
        SubscriptBox["a", 
         RowBox[{"2", ",", "1"}]], 
        SubscriptBox["a", 
         RowBox[{"2", ",", "2"}]], 
        SubscriptBox["a", 
         RowBox[{"2", ",", "3"}]]},
       {
        SubscriptBox["a", 
         RowBox[{"3", ",", "1"}]], 
        SubscriptBox["a", 
         RowBox[{"3", ",", "2"}]], 
        SubscriptBox["a", 
         RowBox[{"3", ",", "3"}]]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->293875187],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Det", "[", 
   RowBox[{"Inverse", "[", "m", "]"}], "]"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28368184],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWMtS2zAUle04hAQInZIEWECyYLppy1+0q35EhukMmemDgQCfl49hBzse
6yD5AfHRMbp2lVDPWNGRdI/uw1dS9GM8Pf35ezydnIyH38/HZ6eTk4vht7/n
uikKlApulVKjXaXrc11LXvPc6TetprVtU0Z571wdAe4DHgIeAP4E+MAzn0u/
kaM/sVet6zLWjaFBjZde/YQatEGmqwsDI2u0ad3IpBogZfh7i5LQV5CzWEPi
F65xRDReK9XYzLjpXeOQSBQ0BqaW2MOWvpbtA3l0LGb0QNMUqgOtaBla1ASM
OQVzKzvrwtwxL9qpzDKLxxpFuQqzxTBil9lXkEAPYLzQb+iRjWXb5+TeZzZa
o9ZhFI1cVTsLntxjjO5voQJOopvwsmxbA4zfakcoFwvH1ZVrCsdhLtblYbw+
/dD9T+1edfylekn5MSMTXJLd6DNcxXBdbItYqEaWFN1ZKrO45o5rzV2P1SWF
mK/LrpjwSLos2lqi96hd3r2HFsm+RT/e82OBLA9c61qVfF60w/SzSMWqjC18
Q9pg7gWUYmtKnNtdS7q6ptY5PtNBFkf0IurE83g53stPMfV9v2rvufJ4Fd8g
SuV7bj3pf5Cy8tiUjUza/N/C8zY7jTQEXo5LxjVL5nGNbwnnlUT/LXsZnw97
P7yTfa2FX59xlJwqffJXOVXijRLfqXdoq+wfb4+2fhTY6p6Rr+Zc24Ola+fT
l3wGLrsDsq+rVUSYO1l7P/sdzos3T8i2nbWze5Y6PC59RoB71LpDaL0C/AXw
H8CfAV8z/1v3uVPAx4B/Af4K+BJwekNnqniTzWrprjWbzVT6mODf6DfQTYHu
Cyqxsdr9PN1rHxL0CNq+R6spzZr8BJqq4BlFU9ko\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{490, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->433001856]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"Det", "[", "m", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->235065317],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWNtygjAQDVdpvfXirS8d/Jn2qR/BOJ3Rh0471v/zM/yajk0CqBwWWKIW
Oy0zSDbZPefskkTgJVrNX9+i1WIWhc/L6GO+mH2GT+9L2eVYQtiuEGI6EbK9
lS19pocvz70ZW2P16+y8cvYI7LCm/7RiHOMRv2n/QFfpRv56stNWlntYU1sa
PXlVIU5uVPV2Ei8XkBXeoBBXOXYLce1ktAh3WKo3gwuRGbU5RRlciGyXqu3x
cckK1terekdGetPaF+N6qlfcASrqQ9Y22IAt4nmWQ/AO2WVbTCjeDE6fYipR
1mHxPtTM95pSkUMlc85kQ/LmcLo1c0Z/Jm/Go2eeYYk9NM83o+62Jq+29Syl
1kwLbJ/p5zH9TOPOrePU+Fy8/h/j9S+k7nq1xXtXbs3hjheATa9/jEJGOgr3
L6wPD6WK2zPKk96R6io+JbdZnlWKe0ZcvDvBmztNKjSrIRlV+643qTj+H1TY
u/2ikvnwvqhxn4yywasFNq0Xo3DmpDsgr0aXoJQ3B1CpOadZfnylvNlaxWl+
J/5retqaai79JOwm3uqt74qopctQ7hX4+QW4XkO8fgVvFV7A1NUHniC5tpjx
3PyR51z5UE+uP5Ff2ZPqkOwdkL34zYteaccg0iuejqV5Hi8AAb8VHp/V/Tbd
Z5ykak7Co65hQf8U7DH4H9uvM9gJpb4am1rxvrter0V8qCJ8ydMKgsDabDbW
2ZhVKy3/ngXfBX/DqGrZyaBDZCqsb69/xBU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{516, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->159110529]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"%%", "\[Equal]", "%"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->826692764],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->14920578]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13407],

Cell["Determinants of tridiagonal matrices:", "ExampleText",
 CellID->368887866],

Cell[BoxData[
 RowBox[{
  RowBox[{"tridiagonal", "[", "n_", "]"}], ":=", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"2", ",", "1"}], "}"}], "]"}], "\[Rule]", "a"}], ",", 
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}], "]"}], "\[Rule]", "b"}], ",", 
      RowBox[{
       RowBox[{"Band", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "2"}], "}"}], "]"}], "\[Rule]", "c"}]}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "n"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59867904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"tridiagonal", "[", "5", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49341176],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmD1vwjAQhk1CWqDp0i5FSBW/phUDM3OEKtGhakUZ2BgZGRn5CYwZGRkZ
GRkZGRnd8xcJxpgEOwSpRErOSQ7fmzv7kbhm0Ot8fAW9z3ZQf+8GP53P9m/9
7bsLj9wCQqgFZ+MFwRjDiJ4tjMHGrx65upPJBNMDNej9YDDg9y71KtLhcrkM
w5AMyb0LE/oK64EtcXsvZl8sFvJs4/E4HoO4Y3HAGFUyenpHQ263236/H2ly
xVMmi2m8mCaWp+FwCALI0NlpcubzuWc8/wPY4onoUFoo8H50WqX1ep11Rhyw
NKq7e8tXZrTm4qqi9WmuiuTG5RYV2VtEjxLma4Jtj8wUVKUvr4jM8/uCMq6H
1XuwyvPpS/7qWZo3L00+4ywTz8uJZrssP0r5azpYvzbV6PmVffx05Copve3X
6Di5fJ4v+zFlVlUTRZD3lmBULdGvr5UY+TJKxaYbow5p4FtXk45G9uPboJH9
Gp2mkf2YMo1qBhHE3hJsesVp9tK1EiMfRunY9A8ZdZIGJmpIvk1plE02TGlk
mpVzaGQS81n6VjWNTCI84X02pdtL10qMNF6j0SiBV9TPinvBP+rNZkOHWM8m
YVlVVqvVdDolw3gHIAxD3tXKo1c0m80U3Rr4PK5Uo+lMGujUQFX2OlcpOnwZ
qIlWQ6TGgVpRmwmTjncaHagHzQbvZ0U5oSqMyaTrcUr55wpYO2+n4Exe6eJG
EVjcMlZTS9hH6sX60ajwB6sE9Mc=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{87, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->479013607]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Det", "[", 
     RowBox[{"tridiagonal", "[", "n", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "2", ",", "12"}], "}"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->187751789],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{418, 195},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TableForm=",
 CellID->12235916]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23218],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CharacteristicPolynomial",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacteristicPolynomial"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Minors",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Minors"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RowReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatrixRank",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixRank"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NullSpace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NullSpace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tr",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tr"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Signature",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Signature"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eigenvalues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigenvalues"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5144]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22302],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "Tutorials",
 CellID->26612],

Cell[TextData[ButtonBox["Basic Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicMatrixOperations"]], "Tutorials",
 CellID->5521]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->15692],

Cell[TextData[{
 ButtonBox["Demonstrations with Det",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Det"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[ButtonBox["Implementation notes: Numerical and Related \
Functions",
 BaseStyle->"Hyperlink",
 ButtonData->{
   URL["http://reference.wolfram.com/mathematica/note/\
SomeNotesOnInternalImplementation.html#5783"], None}]], "RelatedLinks",
 CellID->407],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Det"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->664460470],

Cell[TextData[ButtonBox["Linear Systems",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LinearSystems"]], "MoreAbout",
 CellID->88326323],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->21750804],

Cell[TextData[ButtonBox["Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixOperations"]], "MoreAbout",
 CellID->101685792]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Det - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 37, 58.6482288}", "context" -> "System`", 
    "keywords" -> {
     "characteristic polynomials for matrices", "Chinese remainder theorem", 
      "Cramer's rule", "determinant", "determinant of matrix"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Det[m] gives the determinant of the square matrix m. ", "synonyms" -> {},
     "title" -> "Det", "type" -> "Symbol", "uri" -> "ref/Det"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5168, 156, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->20258169]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 47472, 1676}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2934, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3557, 90, 40, 1, 70, "ObjectName",
 CellID->3706],
Cell[3600, 93, 551, 18, 70, "Usage",
 CellID->28419]
}, Open  ]],
Cell[CellGroupData[{
Cell[4188, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4666, 133, 465, 18, 70, "Notes",
 CellID->9643]
}, Closed]],
Cell[CellGroupData[{
Cell[5168, 156, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->20258169],
Cell[CellGroupData[{
Cell[5552, 170, 148, 5, 70, "ExampleSection",
 CellID->672746627],
Cell[CellGroupData[{
Cell[5725, 179, 895, 28, 43, "Input",
 CellID->228759878],
Cell[6623, 209, 439, 17, 36, "Output",
 CellID->47467031]
}, Open  ]],
Cell[CellGroupData[{
Cell[7099, 231, 1208, 39, 61, "Input",
 CellID->659410434],
Cell[8310, 272, 930, 19, 36, "Output",
 Evaluatable->False,
 CellID->10578135]
}, Open  ]],
Cell[9255, 294, 125, 3, 70, "ExampleDelimiter",
 CellID->527922720],
Cell[CellGroupData[{
Cell[9405, 301, 339, 11, 70, "Input",
 CellID->480188104],
Cell[9747, 314, 158, 5, 36, "Output",
 CellID->666723273]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9954, 325, 216, 7, 70, "ExampleSection",
 CellID->25651],
Cell[10173, 334, 90, 1, 70, "ExampleText",
 CellID->41331787],
Cell[10266, 337, 151, 5, 70, "Input",
 CellID->218779135],
Cell[CellGroupData[{
Cell[10442, 346, 99, 3, 70, "Input",
 CellID->272742706],
Cell[10544, 351, 188, 6, 51, "Output",
 CellID->48977182]
}, Open  ]],
Cell[10747, 360, 66, 1, 70, "ExampleText",
 CellID->450291204],
Cell[CellGroupData[{
Cell[10838, 365, 127, 4, 70, "Input",
 CellID->277940401],
Cell[10968, 371, 180, 5, 36, "Output",
 CellID->915199491]
}, Open  ]],
Cell[11163, 379, 76, 1, 70, "ExampleText",
 CellID->30370119],
Cell[CellGroupData[{
Cell[11264, 384, 152, 5, 70, "Input",
 CellID->278102280],
Cell[11419, 391, 229, 6, 36, "Output",
 CellID->390022357]
}, Open  ]],
Cell[11663, 400, 125, 3, 70, "ExampleDelimiter",
 CellID->484293617],
Cell[11791, 405, 82, 1, 70, "ExampleText",
 CellID->458400108],
Cell[CellGroupData[{
Cell[11898, 410, 242, 8, 70, "Input",
 CellID->47106202],
Cell[12143, 420, 277, 8, 36, "Output",
 CellID->121784382]
}, Open  ]],
Cell[12435, 431, 125, 3, 70, "ExampleDelimiter",
 CellID->447470696],
Cell[12563, 436, 74, 1, 70, "ExampleText",
 CellID->609611779],
Cell[CellGroupData[{
Cell[12662, 441, 619, 21, 70, "Input",
 CellID->4502940],
Cell[13284, 464, 175, 5, 36, "Output",
 CellID->15420724]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13508, 475, 217, 7, 70, "ExampleSection",
 CellID->7475],
Cell[CellGroupData[{
Cell[13750, 486, 223, 7, 70, "ExampleSubsection",
 CellID->8879],
Cell[13976, 495, 91, 1, 70, "ExampleText",
 CellID->22888293],
Cell[14070, 498, 254, 8, 70, "Input",
 CellID->110063470],
Cell[CellGroupData[{
Cell[14349, 510, 164, 5, 70, "Input",
 CellID->133599999],
Cell[14516, 517, 158, 5, 36, "Output",
 CellID->785197409]
}, Open  ]],
Cell[14689, 525, 318, 12, 70, "ExampleText",
 CellID->286974980],
Cell[CellGroupData[{
Cell[15032, 541, 158, 5, 70, "Input",
 CellID->20477338],
Cell[15193, 548, 157, 5, 36, "Output",
 CellID->39656045]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[15411, 560, 223, 7, 70, "ExampleSection",
 CellID->11858],
Cell[15637, 569, 263, 10, 70, "ExampleText",
 CellID->452871632],
Cell[15903, 581, 761, 26, 70, "Input",
 CellID->119875586],
Cell[16667, 609, 473, 16, 70, "Input",
 CellID->647257522],
Cell[CellGroupData[{
Cell[17165, 629, 211, 7, 70, "Input",
 CellID->210992720],
Cell[17379, 638, 232, 8, 36, "Output",
 CellID->197314053]
}, Open  ]],
Cell[CellGroupData[{
Cell[17648, 651, 120, 4, 70, "Input",
 CellID->9253361],
Cell[17771, 657, 161, 5, 36, "Output",
 CellID->560764733]
}, Open  ]],
Cell[17947, 665, 264, 9, 70, "ExampleText",
 CellID->19900096],
Cell[18214, 676, 473, 17, 70, "Input",
 CellID->324953127],
Cell[CellGroupData[{
Cell[18712, 697, 217, 7, 70, "Input",
 CellID->282675086],
Cell[18932, 706, 247, 8, 39, "Output",
 CellID->97052269]
}, Open  ]],
Cell[CellGroupData[{
Cell[19216, 719, 223, 7, 70, "Input",
 CellID->371622240],
Cell[19442, 728, 250, 8, 39, "Output",
 CellID->177070177]
}, Open  ]],
Cell[19707, 739, 125, 3, 70, "ExampleDelimiter",
 CellID->324885446],
Cell[19835, 744, 80, 1, 70, "ExampleText",
 CellID->633361373],
Cell[19918, 747, 269, 10, 70, "Input",
 CellID->990752637],
Cell[20190, 759, 62, 1, 70, "ExampleText",
 CellID->8435738],
Cell[CellGroupData[{
Cell[20277, 764, 184, 6, 70, "Input",
 CellID->146400330],
Cell[20464, 772, 158, 5, 36, "Output",
 CellID->252097942]
}, Open  ]],
Cell[CellGroupData[{
Cell[20659, 782, 184, 6, 70, "Input",
 CellID->264321756],
Cell[20846, 790, 158, 5, 36, "Output",
 CellID->232496375]
}, Open  ]],
Cell[21019, 798, 59, 1, 70, "ExampleText",
 CellID->300558006],
Cell[CellGroupData[{
Cell[21103, 803, 234, 8, 70, "Input",
 CellID->49695079],
Cell[21340, 813, 159, 5, 36, "Output",
 CellID->202223394]
}, Open  ]],
Cell[21514, 821, 72, 1, 70, "ExampleText",
 CellID->75507059],
Cell[CellGroupData[{
Cell[21611, 826, 285, 11, 70, "Input",
 CellID->481160300],
Cell[21899, 839, 175, 6, 36, "Output",
 CellID->239457675]
}, Open  ]],
Cell[CellGroupData[{
Cell[22111, 850, 99, 3, 70, "Input",
 CellID->100114939],
Cell[22213, 855, 175, 6, 36, "Output",
 CellID->253144260]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22437, 867, 233, 7, 70, "ExampleSection",
 CellID->18583],
Cell[22673, 876, 496, 17, 70, "ExampleText",
 CellID->246687494],
Cell[23172, 895, 229, 8, 70, "Input",
 CellID->108117351],
Cell[CellGroupData[{
Cell[23426, 907, 197, 6, 70, "Input",
 CellID->612469435],
Cell[23626, 915, 323, 10, 36, "Output",
 CellID->235914783]
}, Open  ]],
Cell[CellGroupData[{
Cell[23986, 930, 151, 4, 70, "Input",
 CellID->184348894],
Cell[24140, 936, 323, 10, 36, "Output",
 CellID->170381173]
}, Open  ]],
Cell[24478, 949, 124, 3, 70, "ExampleDelimiter",
 CellID->11351886],
Cell[24605, 954, 93, 1, 70, "ExampleText",
 CellID->426816741],
Cell[24701, 957, 227, 8, 70, "Input",
 CellID->747192],
Cell[CellGroupData[{
Cell[24953, 969, 99, 3, 70, "Input",
 CellID->159263446],
Cell[25055, 974, 178, 5, 36, "Output",
 CellID->17286952]
}, Open  ]],
Cell[CellGroupData[{
Cell[25270, 984, 167, 5, 70, "Input",
 CellID->606915334],
Cell[25440, 991, 253, 7, 36, "Output",
 CellID->408717726]
}, Open  ]],
Cell[25708, 1001, 124, 3, 70, "ExampleDelimiter",
 CellID->24627488],
Cell[25835, 1006, 132, 4, 70, "ExampleText",
 CellID->107659909],
Cell[CellGroupData[{
Cell[25992, 1014, 449, 14, 70, "Input",
 CellID->88136536],
Cell[26444, 1030, 1640, 37, 108, "Output",
 CellID->17344622]
}, Open  ]],
Cell[CellGroupData[{
Cell[28121, 1072, 99, 3, 70, "Input",
 CellID->122515196],
Cell[28223, 1077, 178, 5, 36, "Output",
 CellID->160754329]
}, Open  ]],
Cell[CellGroupData[{
Cell[28438, 1087, 164, 5, 70, "Input",
 CellID->483199888],
Cell[28605, 1094, 177, 5, 36, "Output",
 CellID->36669090]
}, Open  ]],
Cell[28797, 1102, 125, 3, 70, "ExampleDelimiter",
 CellID->135469644],
Cell[28925, 1107, 121, 3, 70, "ExampleText",
 CellID->23285793],
Cell[29049, 1112, 291, 11, 70, "Input",
 CellID->607973983],
Cell[CellGroupData[{
Cell[29365, 1127, 122, 4, 70, "Input",
 CellID->182831126],
Cell[29490, 1133, 196, 6, 36, "Output",
 CellID->933294448]
}, Open  ]],
Cell[CellGroupData[{
Cell[29723, 1144, 147, 5, 70, "Input",
 CellID->508729053],
Cell[29873, 1151, 197, 6, 36, "Output",
 CellID->119590041]
}, Open  ]],
Cell[30085, 1160, 125, 3, 70, "ExampleDelimiter",
 CellID->527350143],
Cell[30213, 1165, 119, 3, 70, "ExampleText",
 CellID->352411894],
Cell[30335, 1170, 1255, 40, 70, "Input",
 CellID->293875187],
Cell[CellGroupData[{
Cell[31615, 1214, 164, 5, 70, "Input",
 CellID->28368184],
Cell[31782, 1221, 1106, 22, 70, "Output",
 Evaluatable->False,
 CellID->433001856]
}, Open  ]],
Cell[CellGroupData[{
Cell[32925, 1248, 122, 4, 70, "Input",
 CellID->235065317],
Cell[33050, 1254, 980, 20, 70, "Output",
 Evaluatable->False,
 CellID->159110529]
}, Open  ]],
Cell[CellGroupData[{
Cell[34067, 1279, 131, 4, 70, "Input",
 CellID->826692764],
Cell[34201, 1285, 160, 5, 36, "Output",
 CellID->14920578]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[34410, 1296, 224, 7, 70, "ExampleSection",
 CellID->13407],
Cell[34637, 1305, 80, 1, 70, "ExampleText",
 CellID->368887866],
Cell[34720, 1308, 694, 23, 70, "Input",
 CellID->59867904],
Cell[CellGroupData[{
Cell[35439, 1335, 139, 4, 70, "Input",
 CellID->49341176],
Cell[35581, 1341, 983, 20, 70, "Output",
 Evaluatable->False,
 CellID->479013607]
}, Open  ]],
Cell[CellGroupData[{
Cell[36601, 1366, 295, 10, 70, "Input",
 CellID->187751789],
Cell[36899, 1378, 4273, 74, 70, "Output",
 Evaluatable->False,
 CellID->12235916]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41233, 1459, 311, 9, 70, "SeeAlsoSection",
 CellID->23218],
Cell[41547, 1470, 1952, 71, 70, "SeeAlso",
 CellID->5144]
}, Open  ]],
Cell[CellGroupData[{
Cell[43536, 1546, 314, 9, 70, "TutorialsSection",
 CellID->22302],
Cell[43853, 1557, 149, 3, 70, "Tutorials",
 CellID->26612],
Cell[44005, 1562, 154, 3, 70, "Tutorials",
 CellID->5521]
}, Open  ]],
Cell[CellGroupData[{
Cell[44196, 1570, 321, 9, 70, "RelatedLinksSection",
 CellID->15692],
Cell[44520, 1581, 346, 11, 70, "RelatedLinks"],
Cell[44869, 1594, 264, 6, 70, "RelatedLinks",
 CellID->407],
Cell[45136, 1602, 381, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45554, 1620, 319, 9, 70, "MoreAboutSection",
 CellID->664460470],
Cell[45876, 1631, 138, 3, 70, "MoreAbout",
 CellID->88326323],
Cell[46017, 1636, 162, 3, 70, "MoreAbout",
 CellID->21750804],
Cell[46182, 1641, 145, 3, 70, "MoreAbout",
 CellID->101685792]
}, Open  ]],
Cell[46342, 1647, 27, 0, 70, "History"],
Cell[46372, 1649, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

