(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21634,        812]
NotebookOptionsPosition[     16947,        652]
NotebookOutlinePosition[     18186,        688]
CellTagsIndexPosition[     18101,        683]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dialogs" :> 
          Documentation`HelpLookup["paclet:tutorial/Dialogs"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dialogs\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TraceDialog" :> 
          Documentation`HelpLookup["paclet:ref/TraceDialog"], "Input" :> 
          Documentation`HelpLookup["paclet:ref/Input"], "$Inspector" :> 
          Documentation`HelpLookup["paclet:ref/$Inspector"], "Return" :> 
          Documentation`HelpLookup["paclet:ref/Return"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"TraceDialog\"\>", 2->"\<\"Input\"\>", 
       3->"\<\"$Inspector\"\>", 4->"\<\"Return\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Evaluation Menu" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationMenu"], 
          "Tokens Related to the Evaluation Menu" :> 
          Documentation`HelpLookup["paclet:guide/EvaluationTokens"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Evaluation Menu\"\>", 
       2->"\<\"Tokens Related to the Evaluation Menu\"\>", 
       3->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Dialog", "ObjectName",
 CellID->30088],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Dialog",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Dialog"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]initiates a dialog. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Dialog",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Dialog"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]initiates a dialog with ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " as the current value of ",
     Cell[BoxData["%"], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->24298]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
 " creates a dialog which consists of a sequence of input and output lines. "
}], "Notes",
 CellID->6582],

Cell[TextData[{
 "You can exit a dialog using ",
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22252],

Cell[TextData[{
 "With the global setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["$IgnoreEOF",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$IgnoreEOF"], "=", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", you can also exit a dialog by entering an end\[Hyphen]of\[Hyphen]file \
character. "
}], "Notes",
 CellID->7977],

Cell[TextData[{
 "If you exit with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Return",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Return"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is the value returned by the ",
 Cell[BoxData[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
 " function. Otherwise, the value returned is the expression on the last \
output line in the dialog. "
}], "Notes",
 CellID->11457],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
 " automatically localizes the values of ",
 Cell[BoxData[
  ButtonBox["$Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Line"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["$MessageList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MessageList"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$Epilog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Epilog"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24385],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
 " initially sets the local value of ",
 Cell[BoxData[
  ButtonBox["$Line",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Line"]], "InlineFormula"],
 " to be equal to its global value. This means that the numbering of input \
and output lines in the dialog follows the sequence outside the dialog. When \
the dialog is exited, however, the numbering reverts to the sequence that \
would be followed if there had been no dialog. "
}], "Notes",
 CellID->19293],

Cell[TextData[{
 "Any local value assigned to ",
 Cell[BoxData[
  ButtonBox["$Epilog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Epilog"]], "InlineFormula"],
 " is evaluated when the dialog is exited. "
}], "Notes",
 CellID->31716],

Cell[TextData[{
 "The main loop within a dialog uses global variables such as ",
 Cell[BoxData[
  ButtonBox["$Pre",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Pre"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$Post",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Post"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19628],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DialogSymbols",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogSymbols"], ":>", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " sets up local values for variables within the dialog. ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DialogSymbols",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogSymbols"], ":>", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      StyleBox["x", "TI"], "=", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["0", "TR"]]}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " defines initial values for the variables. "
}], "Notes",
 CellID->12394],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DialogProlog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogProlog"], ":>", 
   StyleBox["expr", "TI"]}]], "InlineFormula"],
 " specifies an expression to evaluate before starting the dialog. "
}], "Notes",
 CellID->19291],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
 " first localizes variables, then evaluates any expression specified by ",
 Cell[BoxData[
  ButtonBox["DialogProlog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogProlog"]], "InlineFormula"],
 ", then evaluates any argument you have given for ",
 Cell[BoxData[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3771]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->365029859],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->582212341],

Cell[TextData[{
 "To evaluate this expression, ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " initiates a dialog:"
}], "ExampleText",
 CellID->214712370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{
   RowBox[{"Dialog", "[", "]"}], "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->225934034],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["t", "2"], "+", 
     RowBox[{"Cos", "[", "t", "]"}], "+", 
     RowBox[{"Sin", "[", "t", "]"}]}], ")"}], "2"]}]], "Output",
 ImageSize->{165, 20},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->853010676]
}, Open  ]],

Cell[TextData[{
 "Computations can be done within the dialog just like an ordinary ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " session:"
}], "ExampleText",
 CellID->122862262],

Cell[BoxData[
 RowBox[{
  RowBox[{"s", " ", "=", " ", 
   RowBox[{
    RowBox[{"Sin", "[", "t", "]"}], " ", "+", " ", 
    RowBox[{"Cos", "[", "t", "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->70448423],

Cell[TextData[{
 "Return from the dialog. The value is inserted in the original expression to \
get ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Out",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Out"], "[", "1", "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->315338953],

Cell[BoxData[
 RowBox[{"Return", "[", 
  RowBox[{"s", "+", 
   RowBox[{"t", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17962800]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9183],

Cell["Run a dialog each time through a loop:", "ExampleText",
 CellID->179775705],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", " ", "=", " ", "1"}], ";", 
  RowBox[{"Do", "[", 
   RowBox[{
    RowBox[{"x", " ", "*=", " ", 
     RowBox[{"Dialog", "[", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52934867],

Cell["\<\
You can see the current value of the loop variable i in the dialog:\
\>", "ExampleText",
 CellID->289052891],

Cell[CellGroupData[{

Cell[BoxData["i"], "Input",
 CellLabel->"In[2]:=",
 CellID->16120416],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"(Dialog) Out[2]=",
 CellID->68616761]
}, Open  ]],

Cell[TextData[{
 "Return from the first dialog. ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is multiplied by the current value of ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->472020038],

Cell[BoxData[
 RowBox[{"Return", "[", "i", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->352037794],

Cell[TextData[{
 "The current values of ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->163802385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"i", ",", "x"}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->484895982],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "1"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"(Dialog) Out[4]=",
 CellID->757353797]
}, Open  ]],

Cell[TextData[{
 "Return from the second dialog",
 ". ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is multiplied by the current value of ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 " squared:"
}], "ExampleText",
 CellID->143428088],

Cell[BoxData[
 RowBox[{"Return", "[", 
  RowBox[{"i", "^", "2"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->550200],

Cell["Return from the third dialog:", "ExampleText",
 CellID->691033152],

Cell[BoxData[
 RowBox[{"Return", "[", 
  RowBox[{"i", "^", "3"}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->213599431],

Cell[TextData[{
 "The value of ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " after the loop:"
}], "ExampleText",
 CellID->600401538],

Cell[CellGroupData[{

Cell[BoxData["x"], "Input",
 CellLabel->"In[7]:=",
 CellID->625146197],

Cell[BoxData["108"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->214670019]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23292],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraceDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceDialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Input"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Inspector",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Inspector"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Return",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Return"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5677]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5107],

Cell[TextData[ButtonBox["Dialogs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Dialogs"]], "Tutorials",
 CellID->12912]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Evaluation Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationMenu"]], "MoreAbout",
 CellID->79132372],

Cell[TextData[ButtonBox["Tokens Related to the Evaluation Menu",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/EvaluationTokens"]], "MoreAbout",
 CellID->643245920],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->70320851]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Dialog - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 4.3202490}", "context" -> "System`", 
    "keywords" -> {"subsession", "dialogs"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Dialog[] initiates a dialog. Dialog[expr] initiates a dialog with expr \
as the current value of %. ", "synonyms" -> {}, "title" -> "Dialog", "type" -> 
    "Symbol", "uri" -> "ref/Dialog"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9221, 319, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->365029859]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17958, 676}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2297, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2920, 81, 44, 1, 70, "ObjectName",
 CellID->30088],
Cell[2967, 84, 865, 28, 70, "Usage",
 CellID->24298]
}, Open  ]],
Cell[CellGroupData[{
Cell[3869, 117, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4347, 134, 236, 7, 70, "Notes",
 CellID->6582],
Cell[4586, 143, 198, 8, 70, "Notes",
 CellID->22252],
Cell[4787, 153, 388, 13, 70, "Notes",
 CellID->7977],
Cell[5178, 168, 561, 19, 70, "Notes",
 CellID->11457],
Cell[5742, 189, 583, 22, 70, "Notes",
 CellID->24385],
Cell[6328, 213, 593, 15, 70, "Notes",
 CellID->19293],
Cell[6924, 230, 239, 8, 70, "Notes",
 CellID->31716],
Cell[7166, 240, 349, 13, 70, "Notes",
 CellID->19628],
Cell[7518, 255, 818, 28, 70, "Notes",
 CellID->12394],
Cell[8339, 285, 306, 10, 70, "Notes",
 CellID->19291],
Cell[8648, 297, 536, 17, 70, "Notes",
 CellID->3771]
}, Closed]],
Cell[CellGroupData[{
Cell[9221, 319, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->365029859],
Cell[CellGroupData[{
Cell[9606, 333, 148, 5, 70, "ExampleSection",
 CellID->582212341],
Cell[9757, 340, 161, 6, 70, "ExampleText",
 CellID->214712370],
Cell[CellGroupData[{
Cell[9943, 350, 144, 5, 28, "Input",
 CellID->225934034],
Cell[10090, 357, 357, 12, 41, "Output",
 CellID->853010676]
}, Open  ]],
Cell[10462, 372, 186, 6, 70, "ExampleText",
 CellID->122862262],
Cell[10651, 380, 217, 7, 70, "Input",
 CellID->70448423],
Cell[10871, 389, 286, 10, 70, "ExampleText",
 CellID->315338953],
Cell[11160, 401, 148, 5, 70, "Input",
 CellID->17962800]
}, Open  ]],
Cell[CellGroupData[{
Cell[11345, 411, 215, 7, 70, "ExampleSection",
 CellID->9183],
Cell[11563, 420, 81, 1, 70, "ExampleText",
 CellID->179775705],
Cell[11647, 423, 295, 10, 70, "Input",
 CellID->52934867],
Cell[11945, 435, 118, 3, 70, "ExampleText",
 CellID->289052891],
Cell[CellGroupData[{
Cell[12088, 442, 69, 2, 70, "Input",
 CellID->16120416],
Cell[12160, 446, 166, 5, 50, "Output",
 CellID->68616761]
}, Open  ]],
Cell[12341, 454, 252, 9, 70, "ExampleText",
 CellID->472020038],
Cell[12596, 465, 102, 3, 70, "Input",
 CellID->352037794],
Cell[12701, 470, 210, 9, 70, "ExampleText",
 CellID->163802385],
Cell[CellGroupData[{
Cell[12936, 483, 115, 4, 70, "Input",
 CellID->484895982],
Cell[13054, 489, 212, 7, 50, "Output",
 CellID->757353797]
}, Open  ]],
Cell[13281, 499, 266, 10, 70, "ExampleText",
 CellID->143428088],
Cell[13550, 511, 122, 4, 70, "Input",
 CellID->550200],
Cell[13675, 517, 72, 1, 70, "ExampleText",
 CellID->691033152],
Cell[13750, 520, 125, 4, 70, "Input",
 CellID->213599431],
Cell[13878, 526, 149, 6, 70, "ExampleText",
 CellID->600401538],
Cell[CellGroupData[{
Cell[14052, 536, 70, 2, 70, "Input",
 CellID->625146197],
Cell[14125, 540, 160, 5, 36, "Output",
 CellID->214670019]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14346, 552, 311, 9, 70, "SeeAlsoSection",
 CellID->23292],
Cell[14660, 563, 940, 35, 70, "SeeAlso",
 CellID->5677]
}, Open  ]],
Cell[CellGroupData[{
Cell[15637, 603, 313, 9, 70, "TutorialsSection",
 CellID->5107],
Cell[15953, 614, 125, 3, 70, "Tutorials",
 CellID->12912]
}, Open  ]],
Cell[CellGroupData[{
Cell[16115, 622, 299, 8, 70, "MoreAboutSection"],
Cell[16417, 632, 140, 3, 70, "MoreAbout",
 CellID->79132372],
Cell[16560, 637, 165, 3, 70, "MoreAbout",
 CellID->643245920],
Cell[16728, 642, 147, 3, 70, "MoreAbout",
 CellID->70320851]
}, Open  ]],
Cell[16890, 648, 27, 0, 70, "History"],
Cell[16920, 650, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

