(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52688,       1377]
NotebookOptionsPosition[     46989,       1187]
NotebookOutlinePosition[     48499,       1227]
CellTagsIndexPosition[     48413,       1222]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SystemDialogInput" :> 
          Documentation`HelpLookup["paclet:ref/SystemDialogInput"], 
          "CreateDialog" :> 
          Documentation`HelpLookup["paclet:ref/CreateDialog"], "Input" :> 
          Documentation`HelpLookup["paclet:ref/Input"], "DefaultButton" :> 
          Documentation`HelpLookup["paclet:ref/DefaultButton"], 
          "CancelButton" :> 
          Documentation`HelpLookup["paclet:ref/CancelButton"], 
          "Interpretation" :> 
          Documentation`HelpLookup["paclet:ref/Interpretation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SystemDialogInput\"\>", 
       2->"\<\"CreateDialog\"\>", 3->"\<\"Input\"\>", 
       4->"\<\"DefaultButton\"\>", 5->"\<\"CancelButton\"\>", 
       6->"\<\"Interpretation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Custom Interface Construction" :> 
          Documentation`HelpLookup[
           "paclet:guide/CustomInterfaceConstruction"], "Dialog Boxes" :> 
          Documentation`HelpLookup["paclet:guide/DialogBoxes"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Custom Interface Construction\"\>", 
       2->"\<\"Dialog Boxes\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DialogInput", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DialogInput",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DialogInput"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]interactively puts up ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " as a dialog notebook, waits until a ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["DialogReturn",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DialogReturn"], "[", 
       StyleBox["e", "TI"], "]"}]], "InlineFormula"],
     " is evaluated from within it, and then returns the result ",
     Cell[BoxData[
      StyleBox["e", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DialogInput",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DialogInput"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           StyleBox["x", "TI"], "=", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["0", "TR"]]}], ",", 
          RowBox[{
           StyleBox["y", "TI"], "=", 
           SubscriptBox[
            StyleBox["y", "TI"], 
            StyleBox["0", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]sets up local variables ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->31695]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel in which ",
 Cell[BoxData[
  ButtonBox["DialogInput",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogInput"]], "InlineFormula"],
 " is evaluated will block until the ",
 Cell[BoxData[
  ButtonBox["DialogReturn",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogReturn"]], "InlineFormula"],
 " in the dialog is evaluated."
}], "Notes",
 CellID->673780721]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->195477333],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->171171368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"DialogInput", "[", 
    RowBox[{"DialogNotebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"TextCell", "[", "\"\<Click to proceed\>\"", "]"}], ",", 
       RowBox[{"Button", "[", 
        RowBox[{"\"\<Proceed\>\"", ",", 
         RowBox[{"DialogReturn", "[", "1", "]"}]}], "]"}]}], "}"}], "]"}], 
    "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->93453307],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnFtPG0cUgC31P/S9D/kXfWr7UFVqI1VpVLVSA1GBXJRWqfrQqkoeopC0
oalCIBASoIEACYSEYBpCSY0dwI4vYIKNr/iGL9wvtsEEiul0dscelt21sR2t
12Zn9bE658yZ9czn3X0B8d7J7z8/+Y5MJvsS/lyAP1RcXn6RIAo78V1CPsHa
H3a+IOQHlnbRHzopwKvd5w3wMuMLzobml5dWw+FoNLqxvp47W2+2ciN5hdjG
RiwW29xYj4WC86kWXJjg93mG2t0ub9Dv+6W++8jxy7L3fxSXdz+9eLaqPRJZ
iUbWRTcpqHan3VFW2fLJ+Rq5YkSjtomLSqP++Lsbp6/dX1uLiG5SUO12ixXe
Y8pXetGdI/oVCriepcUV0U0KrN0Cn24AwPiYtxCAK4HrmZ9bFN1kfrSbJoOF
ANI+N7sgusn8aLfa5goBqWl3OOcKAclql8lkLBWsiix5pKoc2MCssC4uNe0e
7zICesAxt8KNWf3pG1JVMFLTHgiFEdADjrkVbszqTz89/QUhUtO+sBRDMB9/
XGGOsmJmhTUdN3ArvBeESE17OBJHQA+sGOlKM4orBzakqmCkpn0jtouAHlgx
84wCdDDbmJUDG5gVZhEiNe2bb3YR0ANvLBCsj5Ca9q34LoJ5H+KicLA+RWra
d0U6oHZmSrSLciDts4ddu23KXIDaQ6FD/tsleLcfOX5ZaXSBwjiUxmm4npmZ
oOgmhdb+U23nFxdaVRNusZUDi3ceruTn2i6P2ye6SUG1O6x277QNmi+Q36WW
X2nxeRyuaZfoJgXVDu8raB6+4a3mt8VkNOQGvgJcBnz64HoO/d1OINqLF6Kd
aJcORDvRLh2IdqJdOhDtRLt0INqJdulAtBPt0oFoJ9qlQxFpx3+NI/pKJKUd
mRd9DUR78ZKbdu7zLuMcuMidwn1XpOrk1Z6mOdXCskrz8DbLQTtrndwYy+Gt
+/huWt4h3rYML8u7hgxT3o8WV3smxri7SF/PSvuBn5vmszJPC197Kg/p71Wx
tDNfINz0MGk/8OvISjvvZVN5y+0lI/SLXQjtLDNcUdxNcdt4N866S3mdc+fy
Xpz3e0z1DRamdt4bNbevrHAoNO2sJfE+9US7ENp9+59c3gc/1RTRfWbovDC1
E4j2YoRoJ9qlA9FOtEsHop1olw5EO9EuHYh20bWfPVfldvl6+7TXqtoIQrPz
745Gazv/Q3X5uetQO8Th8BCEhqndYQ/Q/zwjThCU/3bjTO1Wi39nJx7b3IJs
0iTiGDxv4zQWSzTAIm7GMZPNIkxpst7s7cbOpmMfdBz9sP3oR1xgHY7CHjRx
a2s7FtvG2k2T3kg0trwSWV4J0+dIMg6z41VmA+7Hxej+0eJKc9ms/Nhn8Zpa
cK8VNDfzcK8VjsIeNHFllZqCtU9MuGbnV/zBJX9gwR9YpEBxELGYIEDHAQaJ
oQWqP4grS4mgyNJcNjtdUQr6n4GerpT0P4M9aG4gtBQILmPthjGnyzvrmA6w
cCaC4F7RuT+lYj+jx+/cd4ViTLPbrLO8FMh7waMHiX92AwMETuW9sIeeEnS6
gtPuWaxdq7ObLd5Jsxvyeoo+m/fOzIAPD+5h9hddOsmoZ75ZtnZ4dDPipHY0
yzTlnrLOYO0wMBjt+nGbbtymH7Ppxuxag11HBTCFgR2d6QqMbXo0aqAadOP2
RDBGz6VjbRGm+uQ2s9qss7wEyHtAVzsF6+j4E7Q3gyedULsOXXPcbnztwtrV
GsuoxjxCYRpRm6hAbR7WoABWqKFh1KBOnpMMJ1JTsoHqHy7CFO0i2806vj1B
CW+9C1rvgJaGPefNdaCpFty9Cc07yk4kp5i0ervy5STSPqqxDKkmMIqXdPDS
SKfUWaEyMhsSbclR1KbYVynGNJfNUtrbmkBDNbhdzb7ba66Dm7+DpgaoHV9n
VDP1V78WaR9RTw0M6v5+oacxJAOKAQpDojhIxVQ6aKCHYIz7DclOfZGmA3tp
Fpt1lJWA5ob4jSose/uPvXjzt6ug/pazrGQAfcSgXjX8+mHXUEL76FRfv+bZ
c+1b8IpxZhWLK81us9S7vf5W9OoV5Hnj1ytRGpSuVVaCW7WwB89VKI2NzX1J
7Zae3le9fVpCtrhPlYK6uuVLl9YqL3OBdVBf564oQc1P5drBfyaqa7oS2kes
3Y9GnzzWELLFePorcKce1EPqeKirA3cax858g5ofd2ue9xuvVbUh7SqVubVF
0dGmJGTL7cbOibKvPadPuipKuXhOlRorSmEPam6/P/S0R0u05xminWiXDizt
wyPmtlbFgw4lQVA62ofkvXvaA8FVt2fR7VkgCE0oFMbaCXkGav8f/uL2kg==

   "], {{0, 0}, {125, 88}}, {0, 255}],
  ImageSize->{125 0.75, 88 0.75},
  PlotRange->{{0, 125}, {0, 88}}]], "NotebookImage",
 CellID->140740435]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["res"], "Input",
 CellLabel->"In[2]:=",
 CellID->1276646],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->393677872]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->34781718],

Cell["Use a dialog input window to set a variable:", "ExampleText",
 CellID->19666913],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"DialogInput", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"name", "=", "\"\<\>\""}], "}"}], ",", 
     RowBox[{"DialogNotebook", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"TextCell", "[", "\"\<Type a name\>\"", "]"}], ",", 
        RowBox[{"InputField", "[", 
         RowBox[{
          RowBox[{"Dynamic", "[", "name", "]"}], ",", "String"}], "]"}], ",", 
        
        RowBox[{"Button", "[", 
         RowBox[{"\"\<Proceed\>\"", ",", 
          RowBox[{"DialogReturn", "[", "name", "]"}]}], "]"}]}], "}"}], 
      "]"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->482517212],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3N1TG9cZx3F1+j/0rhe9yH/Rq7YXnc60memkuWhnGuMpOG4myaTTi2Y6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   "], {{0, 0}, {285, 121}}, {0, 255}],
  ImageSize->{285 0.75, 121 0.75},
  PlotRange->{{0, 285}, {0, 121}}]], "NotebookImage",
 CellID->103960546]
}, Open  ]],

Cell[TextData[{
 "Enter some text in the field and click \"Proceed\" to set ",
 Cell[BoxData["res"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->270420005],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzt3N1TG9cZx3F1+j/0rhe9yH/Rq7YXnc60memkuWhnGuMpOG4m7aTTi2Y6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   "], {{0, 0}, {285, 121}}, {0, 255}],
  ImageSize->{285 0.75, 121 0.75},
  PlotRange->{{0, 285}, {0, 121}}]], "NotebookImage",
 CellID->3398430],

Cell[CellGroupData[{

Cell[BoxData["res"], "Input",
 CellLabel->"In[2]:=",
 CellID->849964624],

Cell[BoxData["\<\"E Smith\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->508553961]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30985571],

Cell[TextData[{
 "Set ",
 Cell[BoxData["res"], "InlineFormula"],
 " to ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " or to ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", depending which button is clicked:"
}], "ExampleText",
 CellID->248467481],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"DialogInput", "[", 
    RowBox[{"DialogNotebook", "[", 
     RowBox[{"{", 
      RowBox[{"Row", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"DefaultButton", "[", 
          RowBox[{"DialogReturn", "[", "True", "]"}], "]"}], ",", 
         RowBox[{"CancelButton", "[", 
          RowBox[{"DialogReturn", "[", "False", "]"}], "]"}]}], "}"}], "]"}], 
      "}"}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13124466],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztmVtPG0cUgJH6H/rehyi/oVKf2j5UlWikKs1DKzUQFQiJ0ipVH1pVyUMU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   "], {{0, 0}, {125, 57}}, {0, 255}],
  ImageSize->{125 0.75, 57 0.75},
  PlotRange->{{0, 125}, {0, 57}}]], "NotebookImage",
 CellID->170486274]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->195812336],

Cell[TextData[{
 "This uses ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DialogReturn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogReturn"], "[", "]"}]], "InlineFormula"],
 " to return from the dialog notebook:"
}], "ExampleText",
 CellID->364029511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DialogInput", "[", 
  RowBox[{"DialogNotebook", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"TextCell", "[", "\"\<Click to proceed\>\"", "]"}], ",", 
     RowBox[{"Button", "[", 
      RowBox[{"\"\<OK\>\"", ",", 
       RowBox[{"DialogReturn", "[", "]"}]}], "]"}]}], "}"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->621833756],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnN1PU2cYwEl2v3i1+10Y/4ldbbtlJosxy5ZMMANkxixbdrFl0QsjOmWa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   "], {{0, 0}, {125, 88}}, {0, 255}],
  ImageSize->{125 0.75, 88 0.75},
  PlotRange->{{0, 125}, {0, 88}}]], "NotebookImage",
 CellID->537354237]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->302125785],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DefaultButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DefaultButton"], "[", "]"}]], "InlineFormula"],
 " can be used instead of an explicit ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DialogReturn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogReturn"], "[", "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->248069216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DialogInput", "[", 
  RowBox[{"DialogNotebook", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"TextCell", "[", "\"\<Click to proceed\>\"", "]"}], ",", 
     RowBox[{"DefaultButton", "[", "]"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->126551530],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnN1PU2cYwEl2v3i1+10Y/4ldbbtlJosxy5ZMMANkxixbdrFl0QsjOmWa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   "], {{0, 0}, {125, 88}}, {0, 255}],
  ImageSize->{125 0.75, 88 0.75},
  PlotRange->{{0, 125}, {0, 88}}]], "NotebookImage",
 CellID->906803923]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3876011],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["CancelButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CancelButton"], "[", "]"}]], "InlineFormula"],
 " implicitly uses ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DialogReturn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogReturn"], "[", "$Canceled", "]"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->577289620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"DialogInput", "[", 
    RowBox[{"DialogNotebook", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"TextCell", "[", "\"\<Click to proceed\>\"", "]"}], ",", 
       RowBox[{"CancelButton", "[", "]"}]}], "}"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->465056428],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztnNtP21YYwJH2P+x9D/0v9rTtYZq0VZq6PmzSCtWAdVU3ddrDpql9qEq7
lXUqhUJpgZUUaKG0lLBSRheSAklzgVByT8iNXLjfEgiFEXZ27JMcjO2kSSrH
8XysH0ff9/k7ts8vth8ilHdOfvfpybfKysqOwb9z8I+Kq6rOE0RhL7lPKCZY
+/3uZ4TiwNIu+kMnB3i1BwNhXmaDkbnowsry2sZGPB7f2tzMg51XO7mQ7k9s
bSUSie2tzUQ0spDpeiQKfp/nqN3nDURCwZ+beo8cv1j27g+C8vbH50/XdsZi
q/HYpuiixNXucbkra9o/OluvVI3ptE5B0ei0H3577dSVu+vrMdFFiavdZXfA
m1D9wii0c8SgSgVPt7y0KroosbXb4eMPAJicCBQBeCJ4uoX5JdFFlYh2y3Sk
CCDt83OLoosqEe0O5zyijLHxVnCdGWeawmoj2lna3Z55CPSDAgyzguLslewN
RDtXO9f5m2tnVYh2lvbF5QSUA0cuzJcMq41bYfWzGoh2lvbtV/tQDhyzgBqY
bdxK9gainaV9J0nJgSMXfN+yUmZ/ph6cooBoZ2nfpzfoZ1+ADR+WaOfVjhTh
TSDtc7LX7rRZWdqF2Fjao1G5fwMJ7/Yjxy+qzV5QlE1tnoGnm52NiC5KdO0/
NnR/dk6hmfIJ7dweWIAn+qmhx+8Lii5KXO1uhysw44Tmi/N9e9Wl9qDf7Z3x
ii5KXO3wxoPm4RveYc0bi9mUC7gfngU+XPB05G4nEO3ShWgn2uUD0U60ywei
nWiXD0Q70S4fiHaiXT4Q7US7fCDaiXb5ICHt+P8TRL8SWWlH5kW/BqJduhSm
nfu8l3E2XORO4b4rMnXyas/SnOnC8kqL8DYrQDvrOrkxlsNbD/LdtLy7eNty
PCzvNeSY8p5aXO25GOOuIns9L+2vPW+Wc+Welr72TB6y36tiaWe+QLjp/0n7
az+OvLTzHjaTt8JeMkK/2IXQzjLDFcVdFLeNd+Gsu5TXOXcu78F5P8dMn2Bp
aue9UQv7yEqHUtPOuiTep55oF0J78PCTy/vgZ5oius8cnZemdgLRLkWIdqJd
PhDtRLt8INqJdvlAtBPt8oFoF1376TO1Pm+wf0B/pbaDIDR7/+zp9M6z39dV
nbkKtUPcbj9BaJja3a4w/eMZSYKg/LufZGp32EN7e8nE9g5kmyYVJ+C4i9NE
ItUAi7gZx0y2JZjS5L3Ymy3drcfe6zr6fufRD7jAOtwLe9DEnZ3dRGIXa7dM
B2LxxMpqbGV1gx5j6XiDHa8xG3A/LsYP75VWWshilcc+SdY3gDsK0NbGwx0F
3At70MTVNWoK1j415Z1bWA1FlkPhxVB4iQLFEcRSijAdhxmkdi1S/RFcWU4F
EksLWexMdQUYfAL6ejIy+AT2oLnh6HI4soK1myY83sCceybMwpMKIgdFz+GU
ikOMnpDn0BGkmOa3WE9VBVD2gwf3Ur+GAwMETpX9sIeeEvF4IzO+Oaxdb3BZ
7YFpqw/y0kaP1oORGfDhxz3Mfsml04x67otla4dbLyNOa0ezLDafzTGLtcPA
ZHYZJ52GSadxwmmYcOlNLgMVwBQGLjTSFRg7jWiviWowTLpSwQQ9l471EkyN
6WXmtVhPVTlQ9oGeTgrW1vUH6GwDj7qhdgM65qTL/NKLtWt19nGddYzCMqa1
UIHWOqpDAaxQu0ZRgzY9phlNpZZ0A9U/KsEUrSLfxbq/OkEJV9wGilugvfnA
eVsjaG0At69D8+7KE+kpFr3RpX4+jbSP6+wjmimM6jkdPDfTKTWqNGZmQ6ot
vRe1qQ5VpJgWslhKe0craK4DN+vYd3v9VXD9N9DaDLXj44zrbH8O6pH2Ma1t
aNjw1zMjjSkdUAxRmFLFYSqm0mETvQvGuN+U7jRKNB06SPNYrLuyHLQ1J6/V
Ytm7vx/E279eBk03PJXlQ+gUw0bN6Mv7PSMp7eO2gUHdk6f6N+AFY2QVpZXm
t1jq3d50I375EvK89culOA1K12tqwI0G2IPnqtTmlraBtHZ7X/+L/gE9IV98
X1eAxsaVCxfWay5ygXXQ1OirLkfNj5X64b+n6up7UtrHHL0Pxh891BHyxXzq
c3CrCTRBGnlobAS3Wia++RI1P+zVPR00X6ntQNo1GquiXdXVoSbky82W7qnK
L/ynTnqrK7j4v64wV1fAHtTceXfkcZ+eaC8yRDvRLh9Y2kfHrB0K1b0uNUFQ
ujpHlP0H2sORNZ9/yedfJAhNNLqBtROKDNT+H3iYK/8=
   "], {{0, 0}, {125, 84}}, {0, 255}],
  ImageSize->{125 0.75, 84 0.75},
  PlotRange->{{0, 125}, {0, 84}}]], "NotebookImage",
 CellID->246273586]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["res"], "Input",
 CellLabel->"In[2]:=",
 CellID->86276198],

Cell[BoxData["$Canceled"], "Output",
 ImageSize->{67, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->111923134]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17677446],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Input"], "[", "]"}]], "InlineFormula"],
 " puts up a special dialog window for entering an expression:"
}], "ExampleText",
 CellID->554589120],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"Input", "[", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176012711],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztndtvFOcZh131f+h9L6L8E71qe1FVopGqNBet1AAqJjRKq1S9aFUlFwhI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   "], {{0, 0}, {408, 194}}, {0, 255}],
  ImageSize->{408 0.75, 194 0.75},
  PlotRange->{{0, 408}, {0, 194}}]], "NotebookImage",
 CellID->6853561]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["res"], "Input",
 CellLabel->"In[2]:=",
 CellID->156723052],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "2"}], "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", "x"}], ")"}]}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->425266005]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->173147657],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["InputString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputString"], "[", "]"}]], "InlineFormula"],
 " puts up a special dialog window for entering a string:"
}], "ExampleText",
 CellID->90115656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"res", "=", 
   RowBox[{"InputString", "[", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->185542526],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJztndtPHNcdgKn6P/S9D1H+iT61fagquZGqNA+t1BirxnGjtErVh1ZV8mAZ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   "], {{0, 0}, {408, 194}}, {0, 255}],
  ImageSize->{408 0.75, 194 0.75},
  PlotRange->{{0, 408}, {0, 194}}]], "NotebookImage",
 CellID->214314063]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["res"], "Input",
 CellLabel->"In[2]:=",
 CellID->199056417],

Cell[BoxData["\<\"1998--2004\"\>"], "Output",
 CellAutoOverwrite->False,
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->55820503]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30815],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SystemDialogInput",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemDialogInput"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CreateDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CreateDialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Input"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DefaultButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DefaultButton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CancelButton",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CancelButton"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Interpretation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Interpretation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10860]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->437397908],

Cell[TextData[ButtonBox["Custom Interface Construction",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CustomInterfaceConstruction"]], "MoreAbout",
 CellID->670604677],

Cell[TextData[ButtonBox["Dialog Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DialogBoxes"]], "MoreAbout",
 CellID->521240454]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DialogInput - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 3.1795948}", "context" -> "System`", 
    "keywords" -> {
     "dialog boxes", "dialog input", "forms for entering data", 
      "interactive evaluation", "modal dialog box"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DialogInput[expr] interactively puts up expr as a dialog notebook, waits \
until a DialogReturn[e] is evaluated from within it, and then returns the \
result e. DialogInput[{x = x_0, y = y_0, ...}, expr] sets up local variables \
x, y, ... in expr.", "synonyms" -> {"dialog input"}, "title" -> "DialogInput",
     "type" -> "Symbol", "uri" -> "ref/DialogInput"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7095, 215, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->195477333]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 48270, 1215}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1916, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2539, 70, 1576, 37, 70, "ObjectNameGrid"],
Cell[4118, 109, 1973, 63, 70, "Usage",
 CellID->31695]
}, Open  ]],
Cell[CellGroupData[{
Cell[6128, 177, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6606, 194, 452, 16, 70, "Notes",
 CellID->673780721]
}, Closed]],
Cell[CellGroupData[{
Cell[7095, 215, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->195477333],
Cell[CellGroupData[{
Cell[7480, 229, 148, 5, 70, "ExampleSection",
 CellID->171171368],
Cell[CellGroupData[{
Cell[7653, 238, 441, 13, 70, "Input",
 CellID->93453307],
Cell[8097, 253, 2581, 45, 70, "NotebookImage",
 CellID->140740435]
}, Open  ]],
Cell[CellGroupData[{
Cell[10715, 303, 70, 2, 28, "Input",
 CellID->1276646],
Cell[10788, 307, 158, 5, 36, "Output",
 CellID->393677872]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10995, 318, 219, 7, 70, "ExampleSection",
 CellID->34781718],
Cell[11217, 327, 86, 1, 70, "ExampleText",
 CellID->19666913],
Cell[CellGroupData[{
Cell[11328, 332, 679, 20, 70, "Input",
 CellID->482517212],
Cell[12010, 354, 3072, 53, 70, "NotebookImage",
 CellID->103960546]
}, Open  ]],
Cell[15097, 410, 162, 5, 70, "ExampleText",
 CellID->270420005],
Cell[15262, 417, 3216, 55, 70, "NotebookImage",
 CellID->3398430],
Cell[CellGroupData[{
Cell[18503, 476, 72, 2, 70, "Input",
 CellID->849964624],
Cell[18578, 480, 172, 5, 36, "Output",
 CellID->508553961]
}, Open  ]],
Cell[18765, 488, 124, 3, 70, "ExampleDelimiter",
 CellID->30985571],
Cell[18892, 493, 388, 15, 70, "ExampleText",
 CellID->248467481],
Cell[CellGroupData[{
Cell[19305, 512, 511, 15, 70, "Input",
 CellID->13124466],
Cell[19819, 529, 2593, 45, 70, "NotebookImage",
 CellID->170486274]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22461, 580, 237, 7, 70, "ExampleSection",
 CellID->195812336],
Cell[22701, 589, 262, 9, 70, "ExampleText",
 CellID->364029511],
Cell[CellGroupData[{
Cell[22988, 602, 372, 11, 70, "Input",
 CellID->621833756],
Cell[23363, 615, 2938, 50, 70, "NotebookImage",
 CellID->537354237]
}, Open  ]],
Cell[26316, 668, 125, 3, 70, "ExampleDelimiter",
 CellID->302125785],
Cell[26444, 673, 408, 14, 70, "ExampleText",
 CellID->248069216],
Cell[CellGroupData[{
Cell[26877, 691, 296, 8, 70, "Input",
 CellID->126551530],
Cell[27176, 701, 2938, 50, 70, "NotebookImage",
 CellID->906803923]
}, Open  ]],
Cell[30129, 754, 123, 3, 70, "ExampleDelimiter",
 CellID->3876011],
Cell[30255, 759, 403, 15, 70, "ExampleText",
 CellID->577289620],
Cell[CellGroupData[{
Cell[30683, 778, 352, 11, 70, "Input",
 CellID->465056428],
Cell[31038, 791, 2503, 43, 70, "NotebookImage",
 CellID->246273586]
}, Open  ]],
Cell[CellGroupData[{
Cell[33578, 839, 71, 2, 70, "Input",
 CellID->86276198],
Cell[33652, 843, 166, 5, 36, "Output",
 CellID->111923134]
}, Open  ]],
Cell[33833, 851, 124, 3, 70, "ExampleDelimiter",
 CellID->17677446],
Cell[33960, 856, 257, 8, 70, "ExampleText",
 CellID->554589120],
Cell[CellGroupData[{
Cell[34242, 868, 140, 5, 70, "Input",
 CellID->176012711],
Cell[34385, 875, 4460, 75, 70, "NotebookImage",
 CellID->6853561]
}, Open  ]],
Cell[CellGroupData[{
Cell[38882, 955, 72, 2, 70, "Input",
 CellID->156723052],
Cell[38957, 959, 315, 12, 36, "Output",
 CellID->425266005]
}, Open  ]],
Cell[39287, 974, 125, 3, 70, "ExampleDelimiter",
 CellID->173147657],
Cell[39415, 979, 263, 8, 70, "ExampleText",
 CellID->90115656],
Cell[CellGroupData[{
Cell[39703, 991, 146, 5, 70, "Input",
 CellID->185542526],
Cell[39852, 998, 4231, 72, 70, "NotebookImage",
 CellID->214314063]
}, Open  ]],
Cell[CellGroupData[{
Cell[44120, 1075, 72, 2, 70, "Input",
 CellID->199056417],
Cell[44195, 1079, 201, 6, 36, "Output",
 CellID->55820503]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[44457, 1092, 311, 9, 70, "SeeAlsoSection",
 CellID->30815],
Cell[44771, 1103, 1481, 53, 70, "SeeAlso",
 CellID->10860]
}, Open  ]],
Cell[CellGroupData[{
Cell[46289, 1161, 319, 9, 70, "MoreAboutSection",
 CellID->437397908],
Cell[46611, 1172, 168, 3, 70, "MoreAbout",
 CellID->670604677],
Cell[46782, 1177, 135, 3, 70, "MoreAbout",
 CellID->521240454]
}, Open  ]],
Cell[46932, 1183, 27, 0, 70, "History"],
Cell[46962, 1185, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

