(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9740,        353]
NotebookOptionsPosition[      7072,        265]
NotebookOutlinePosition[      8369,        302]
CellTagsIndexPosition[      8285,        297]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dialogs" :> 
          Documentation`HelpLookup["paclet:tutorial/Dialogs"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dialogs\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dialog" :> Documentation`HelpLookup["paclet:ref/Dialog"], 
          "$Epilog" :> Documentation`HelpLookup["paclet:ref/$Epilog"], 
          "DialogSymbols" :> 
          Documentation`HelpLookup["paclet:ref/DialogSymbols"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dialog\"\>", 2->"\<\"$Epilog\"\>", 
       3->"\<\"DialogSymbols\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DialogProlog", "ObjectName",
 CellID->12526],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DialogProlog",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DialogProlog"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Dialog",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
     " which can give an expression to evaluate before the dialog starts. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28959]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You must use a delayed rule of the form ",
 Cell[BoxData[
  RowBox[{"DialogProlog", ":>", 
   StyleBox["expr", "TI"]}]], "InlineFormula"],
 " to prevent ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " from evaluating prematurely. "
}], "Notes",
 CellID->10460],

Cell[TextData[{
 "Expressions given by ",
 Cell[BoxData[
  ButtonBox["DialogProlog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DialogProlog"]], "InlineFormula"],
 " are evaluated after symbol values are localized, and before any expression \
given as the argument of ",
 Cell[BoxData[
  ButtonBox["Dialog",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dialog"]], "InlineFormula"],
 " is evaluated. "
}], "Notes",
 CellID->7977]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->193502466],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->27775786],

Cell["Enter a dialog, first printing out the stack:", "ExampleText",
 CellID->48947666],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"Dialog", "[", 
   RowBox[{"DialogProlog", "\[RuleDelayed]", 
    RowBox[{"Print", "[", 
     RowBox[{"Stack", "[", "]"}], "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->440382149],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Plus", ",", "Dialog", ",", "Print"}], "}"}]], "Print",
 CellLabel->"During evaluation of In[2]:=",
 CellID->29463774],

Cell[BoxData[
 RowBox[{"1", "+", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"x", "+", "y"}], ")"}], "2"]}]], "Output",
 ImageSize->{70, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->475027893]
}, Open  ]],

Cell["Return from the dialog:", "ExampleText",
 CellID->79184866],

Cell[BoxData[
 RowBox[{"Return", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "+", "y"}], ")"}], "^", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->293502296]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30506],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dialog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Epilog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Epilog"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DialogSymbols",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DialogSymbols"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->4987]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->4200],

Cell[TextData[ButtonBox["Dialogs",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Dialogs"]], "Tutorials",
 CellID->31274]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DialogProlog - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 4.8671380}", "context" -> "System`", 
    "keywords" -> {"subsession", "evaluate before dialog"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DialogProlog is an option for Dialog which can give an expression to \
evaluate before the dialog starts. ", "synonyms" -> {"dialog prolog"}, 
    "title" -> "DialogProlog", "type" -> "Symbol", "uri" -> 
    "ref/DialogProlog"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3903, 134, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->193502466]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8142, 290}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1322, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1945, 60, 50, 1, 70, "ObjectName",
 CellID->12526],
Cell[1998, 63, 616, 18, 70, "Usage",
 CellID->28959]
}, Open  ]],
Cell[CellGroupData[{
Cell[2651, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3129, 103, 296, 10, 70, "Notes",
 CellID->10460],
Cell[3428, 115, 438, 14, 70, "Notes",
 CellID->7977]
}, Closed]],
Cell[CellGroupData[{
Cell[3903, 134, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->193502466],
Cell[CellGroupData[{
Cell[4288, 148, 147, 5, 70, "ExampleSection",
 CellID->27775786],
Cell[4438, 155, 87, 1, 70, "ExampleText",
 CellID->48947666],
Cell[CellGroupData[{
Cell[4550, 160, 237, 7, 70, "Input",
 CellID->440382149],
Cell[4790, 169, 157, 4, 23, "Print",
 CellID->29463774],
Cell[4950, 175, 253, 9, 36, "Output",
 CellID->475027893]
}, Open  ]],
Cell[5218, 187, 65, 1, 70, "ExampleText",
 CellID->79184866],
Cell[5286, 190, 174, 6, 70, "Input",
 CellID->293502296]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5509, 202, 311, 9, 70, "SeeAlsoSection",
 CellID->30506],
Cell[5823, 213, 699, 26, 70, "SeeAlso",
 CellID->4987]
}, Open  ]],
Cell[CellGroupData[{
Cell[6559, 244, 313, 9, 70, "TutorialsSection",
 CellID->4200],
Cell[6875, 255, 125, 3, 70, "Tutorials",
 CellID->31274]
}, Open  ]],
Cell[7015, 261, 27, 0, 70, "History"],
Cell[7045, 263, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

