(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12142,        438]
NotebookOptionsPosition[      8866,        330]
NotebookOutlinePosition[     10258,        369]
CellTagsIndexPosition[     10173,        364]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Output Formats for Numbers" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/OutputFormatsForNumbers"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Output Formats for Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Math Typesetting Options & Tweaking" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathTypesettingOptionsAndTweaking"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Math Typesetting Options & Tweaking\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DigitBlock", "ObjectName",
 CellID->25304],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DigitBlock",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DigitBlock"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["NumberForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/NumberForm"]], "InlineFormula"],
     " and related functions which specifies the maximum length of blocks of \
digits between breaks. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14512]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting is ",
 Cell[BoxData[
  RowBox[{"DigitBlock", "->", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 ", which specifies that no breaks should be inserted. "
}], "Notes",
 CellID->23916],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"DigitBlock", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " inserts a break every ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " digits. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->263067636]
}], "Notes",
 CellID->13855],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"DigitBlock", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["nleft", "TI"], ",", 
     StyleBox["nright", "TI"]}], "}"}]}]], "InlineFormula"],
 " inserts a break every ",
 Cell[BoxData[
  StyleBox["nleft", "TI"]], "InlineFormula"],
 " digits to the left of the decimal point, and every ",
 Cell[BoxData[
  StyleBox["nright", "TI"]], "InlineFormula"],
 " digits to the right of the decimal point. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->215925935]
}], "Notes",
 CellID->27198],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["NumberSeparator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NumberSeparator"]], "InlineFormula"],
 " determines what string should be used at each break. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->880881911]
}], "Notes",
 CellID->6762]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->563523878],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->355230869],

Cell["Separate integer digits in blocks of 3:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->263067636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"30", "!"}], ",", 
   RowBox[{"DigitBlock", "\[Rule]", "3"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->172619616],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"265,252,859,812,191,058,636,308,480,000,000\"\>",
   265252859812191058636308480000000,
   Editable->False],
  NumberForm[#, DigitBlock -> 3]& ]], "Output",
 ImageSize->{305, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//NumberForm=",
 CellID->109390442]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->126083048],

Cell["Separate real digits in blocks of 2:", "ExampleText",
 CellID->65928263],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"10", "^", "5"}], "E"}], "]"}], ",", "15", ",", 
   RowBox[{"DigitBlock", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->181529350],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"27,18,28.18 28 45 90 5\"\>",
   271828.1828459045,
   AutoDelete->True],
  NumberForm[#, 15, DigitBlock -> 2]& ]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//NumberForm=",
 CellID->215960152]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->388700242],

Cell["\<\
Use three\[Hyphen]digit blocks on the left of the decimal and \
two\[Hyphen]digit blocks on the right:\
\>", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->215925935],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberForm", "[", 
  RowBox[{
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"10", "^", "5"}], "E"}], "]"}], ",", "15", ",", 
   RowBox[{"DigitBlock", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->62950887],

Cell[BoxData[
 TagBox[
  InterpretationBox["\<\"271,828.18 28 45 90 5\"\>",
   271828.1828459045,
   AutoDelete->True],
  NumberForm[#, 15, DigitBlock -> {3, 2}]& ]], "Output",
 ImageSize->{151, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//NumberForm=",
 CellID->162223361]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20157],

Cell[TextData[ButtonBox["Output Formats for Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/OutputFormatsForNumbers"]], "Tutorials",
 CellID->9196]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->31683524],

Cell[TextData[ButtonBox["Math Typesetting Options & Tweaking",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathTypesettingOptionsAndTweaking"]], "MoreAbout",
 CellID->617811411]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DigitBlock - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 13.0392222}", "context" -> "System`", 
    "keywords" -> {
     "number form", "number formatting", "numeric formatting", 
      "number output", "number representation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DigitBlock is an option for NumberForm and related functions which \
specifies the maximum length of blocks of digits between breaks. ", 
    "synonyms" -> {"digit block"}, "title" -> "DigitBlock", "type" -> 
    "Symbol", "uri" -> "ref/DigitBlock"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4675, 166, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->563523878]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10030, 357}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1287, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1910, 61, 48, 1, 70, "ObjectName",
 CellID->25304],
Cell[1961, 64, 648, 19, 70, "Usage",
 CellID->14512]
}, Open  ]],
Cell[CellGroupData[{
Cell[2646, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3124, 105, 284, 9, 70, "Notes",
 CellID->23916],
Cell[3411, 116, 320, 12, 70, "Notes",
 CellID->13855],
Cell[3734, 130, 559, 18, 70, "Notes",
 CellID->27198],
Cell[4296, 150, 342, 11, 70, "Notes",
 CellID->6762]
}, Closed]],
Cell[CellGroupData[{
Cell[4675, 166, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->563523878],
Cell[CellGroupData[{
Cell[5060, 180, 148, 5, 70, "ExampleSection",
 CellID->355230869],
Cell[5211, 187, 130, 2, 70, "ExampleText",
 CellID->263067636],
Cell[CellGroupData[{
Cell[5366, 193, 188, 6, 28, "Input",
 CellID->172619616],
Cell[5557, 201, 347, 10, 50, "Output",
 CellID->109390442]
}, Open  ]],
Cell[5919, 214, 125, 3, 70, "ExampleDelimiter",
 CellID->126083048],
Cell[6047, 219, 78, 1, 70, "ExampleText",
 CellID->65928263],
Cell[CellGroupData[{
Cell[6150, 224, 255, 8, 70, "Input",
 CellID->181529350],
Cell[6408, 234, 315, 10, 50, "Output",
 CellID->215960152]
}, Open  ]],
Cell[6738, 247, 125, 3, 70, "ExampleDelimiter",
 CellID->388700242],
Cell[6866, 252, 201, 5, 70, "ExampleText",
 CellID->215925935],
Cell[CellGroupData[{
Cell[7092, 261, 305, 10, 70, "Input",
 CellID->62950887],
Cell[7400, 273, 319, 10, 50, "Output",
 CellID->162223361]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7780, 290, 314, 9, 70, "TutorialsSection",
 CellID->20157],
Cell[8097, 301, 159, 3, 70, "Tutorials",
 CellID->9196]
}, Open  ]],
Cell[CellGroupData[{
Cell[8293, 309, 318, 9, 70, "MoreAboutSection",
 CellID->31683524],
Cell[8614, 320, 180, 3, 70, "MoreAbout",
 CellID->617811411]
}, Open  ]],
Cell[8809, 326, 27, 0, 70, "History"],
Cell[8839, 328, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

