(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15254,        557]
NotebookOptionsPosition[     11731,        435]
NotebookOutlinePosition[     12959,        471]
CellTagsIndexPosition[     12874,        466]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:tutorial/StringPatterns"], 
          "Working with String Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithStringPatternsOverview"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"String Patterns\"\>", 
       2->"\<\"Working with String Patterns\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NumberString" :> 
          Documentation`HelpLookup["paclet:ref/NumberString"], "DigitQ" :> 
          Documentation`HelpLookup["paclet:ref/DigitQ"], "WordCharacter" :> 
          Documentation`HelpLookup["paclet:ref/WordCharacter"], 
          "StringExpression" :> 
          Documentation`HelpLookup["paclet:ref/StringExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NumberString\"\>", 
       2->"\<\"DigitQ\"\>", 3->"\<\"WordCharacter\"\>", 
       4->"\<\"StringExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"String Patterns" :> 
          Documentation`HelpLookup["paclet:guide/StringPatterns"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"String Patterns\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DigitCharacter", "ObjectName",
 CellID->17274],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["DigitCharacter",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DigitCharacter"]], "InlineFormula"],
     " \[LineSeparator]represents a digit character 0\[Dash]9 in ",
     Cell[BoxData[
      ButtonBox["StringExpression",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StringExpression"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9747]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->14222646],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"StringMatchQ", "[", 
    RowBox[{"#", ",", "DigitCharacter"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
   "\"\<1\>\"", ",", "\"\<a\>\"", ",", "\"\<2\>\"", ",", "\"\<b\>\"", ",", 
    "\"\<.\>\"", ",", " ", "\"\< \>\""}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->91217813],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "True", ",", "False", ",", "True", ",", "False", ",", "False", ",", 
   "False"}], "}"}]], "Output",
 ImageSize->{270, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->659458168]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->726675496],

Cell["Test whether a string contains only digits:", "ExampleText",
 CellID->241028784],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<1234567890\>\"", ",", " ", 
   RowBox[{"DigitCharacter", " ", ".."}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2131585975],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->88909973]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"StringMatchQ", "[", 
  RowBox[{"\"\<12345a678\>\"", ",", " ", 
   RowBox[{"DigitCharacter", " ", ".."}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1448196690],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->700721158]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->72511798],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DigitCharacter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DigitCharacter"]], "InlineFormula"],
 " matches any character for which ",
 Cell[BoxData[
  ButtonBox["DigitQ",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DigitQ"]], "InlineFormula"],
 " gives ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->1079706603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"StringMatchQ", "[", 
    RowBox[{"#", ",", "DigitCharacter"}], "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
   "\"\<a\>\"", ",", "\"\<1\>\"", ",", "\"\<2\>\"", ",", "\"\<B\>\""}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->210338754],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "True", ",", "True", ",", "False"}], "}"}]], "Output",\

 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->408099990]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DigitQ", "[", "#", "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
   "\"\<a\>\"", ",", "\"\<1\>\"", ",", "\"\<2\>\"", ",", "\"\<B\>\""}], 
   "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->333872666],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"False", ",", "True", ",", "True", ",", "False"}], "}"}]], "Output",\

 ImageSize->{178, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->431539687]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->470285198],

Cell[TextData[{
 "Related predefined character classes include ",
 Cell[BoxData[
  ButtonBox["LetterCharacter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LetterCharacter"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["WhitespaceCharacter",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WhitespaceCharacter"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->96412309],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"m", "=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"StringMatchQ", "[", 
     RowBox[{"c", ",", "p"}], "]"}], ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<a\>\"", ",", "\"\<1\>\"", ",", "\"\<\\t\>\""}], "}"}]}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"p", ",", 
      RowBox[{"{", 
       RowBox[{
       "LetterCharacter", ",", "DigitCharacter", ",", "WhitespaceCharacter"}],
        "}"}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16531007],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"True", ",", "False", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "True", ",", "False"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", "False", ",", "True"}], "}"}]}], "}"}]], "Output",
 ImageSize->{444, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->336301016]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24814],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NumberString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NumberString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DigitQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DigitQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WordCharacter",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WordCharacter"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22050]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14400],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/StringPatterns"]], "Tutorials",
 CellID->8153],

Cell[TextData[ButtonBox["Working with String Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/WorkingWithStringPatternsOverview"]], "Tutorials",
 CellID->22514736]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->198283649],

Cell[TextData[ButtonBox["String Patterns",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringPatterns"]], "MoreAbout",
 CellID->729365541]
}, Open  ]],

Cell["New in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DigitCharacter - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 13.2423524}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DigitCharacter represents a digit character 0\\[Dash]9 in \
StringExpression. ", "synonyms" -> {"digit character"}, "title" -> 
    "DigitCharacter", "type" -> "Symbol", "uri" -> "ref/DigitCharacter"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3563, 107, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12739, 459}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2249, 54, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2872, 81, 52, 1, 70, "ObjectName",
 CellID->17274],
Cell[2927, 84, 599, 18, 70, "Usage",
 CellID->9747]
}, Open  ]],
Cell[CellGroupData[{
Cell[3563, 107, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3940, 121, 147, 5, 70, "ExampleSection",
 CellID->14222646],
Cell[CellGroupData[{
Cell[4112, 130, 337, 10, 28, "Input",
 CellID->91217813],
Cell[4452, 142, 273, 9, 36, "Output",
 CellID->659458168]
}, Open  ]],
Cell[4740, 154, 125, 3, 70, "ExampleDelimiter",
 CellID->726675496],
Cell[4868, 159, 86, 1, 70, "ExampleText",
 CellID->241028784],
Cell[CellGroupData[{
Cell[4979, 164, 192, 5, 28, "Input",
 CellID->2131585975],
Cell[5174, 171, 160, 5, 36, "Output",
 CellID->88909973]
}, Open  ]],
Cell[CellGroupData[{
Cell[5371, 181, 191, 5, 28, "Input",
 CellID->1448196690],
Cell[5565, 188, 162, 5, 36, "Output",
 CellID->700721158]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5776, 199, 236, 7, 70, "ExampleSection",
 CellID->72511798],
Cell[6015, 208, 467, 17, 70, "ExampleText",
 CellID->1079706603],
Cell[CellGroupData[{
Cell[6507, 229, 296, 10, 70, "Input",
 CellID->210338754],
Cell[6806, 241, 240, 8, 36, "Output",
 CellID->408099990]
}, Open  ]],
Cell[CellGroupData[{
Cell[7083, 254, 252, 9, 70, "Input",
 CellID->333872666],
Cell[7338, 265, 240, 8, 36, "Output",
 CellID->431539687]
}, Open  ]],
Cell[7593, 276, 125, 3, 70, "ExampleDelimiter",
 CellID->470285198],
Cell[7721, 281, 392, 13, 70, "ExampleText",
 CellID->96412309],
Cell[CellGroupData[{
Cell[8138, 298, 572, 18, 70, "Input",
 CellID->16531007],
Cell[8713, 318, 424, 13, 36, "Output",
 CellID->336301016]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9198, 338, 311, 9, 70, "SeeAlsoSection",
 CellID->24814],
Cell[9512, 349, 971, 35, 70, "SeeAlso",
 CellID->22050]
}, Open  ]],
Cell[CellGroupData[{
Cell[10520, 389, 314, 9, 70, "TutorialsSection",
 CellID->14400],
Cell[10837, 400, 139, 3, 70, "Tutorials",
 CellID->8153],
Cell[10979, 405, 178, 4, 70, "Tutorials",
 CellID->22514736]
}, Open  ]],
Cell[CellGroupData[{
Cell[11194, 414, 319, 9, 70, "MoreAboutSection",
 CellID->198283649],
Cell[11516, 425, 141, 3, 70, "MoreAbout",
 CellID->729365541]
}, Open  ]],
Cell[11672, 431, 29, 0, 70, "History"],
Cell[11704, 433, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

