(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     52428,       1945]
NotebookOptionsPosition[     41471,       1560]
NotebookOutlinePosition[     42932,       1599]
CellTagsIndexPosition[     42846,       1594]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Indeterminate and Infinite Results" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/IndeterminateAndInfiniteResults"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Indeterminate and Infinite Results\"\>"}, "\<\"tutorials\"\>", 
       
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Indeterminate" :> 
          Documentation`HelpLookup["paclet:ref/Indeterminate"], 
          "ComplexInfinity" :> 
          Documentation`HelpLookup["paclet:ref/ComplexInfinity"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Indeterminate\"\>", 
       2->"\<\"ComplexInfinity\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DirectedInfinity", "ObjectName",
 CellID->22091],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DirectedInfinity",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DirectedInfinity"], "[", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]represents an infinite numerical quantity whose \
direction in the complex plane is unknown. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DirectedInfinity",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DirectedInfinity"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents an infinite numerical quantity that is a \
positive real multiple of the complex number ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->5830]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "You can think of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectedInfinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedInfinity"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " as representing a point in the complex plane reached by starting at the \
origin and going an infinite distance in the direction of the point ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->14957],

Cell["The following conversions are made: ", "Notes",
 CellID->6051],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[TextData[Cell[BoxData[
     RowBox[{
      ButtonBox["DirectedInfinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DirectedInfinity"], "[", "1", "]"}]], 
     "InlineFormula"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"-", 
     ButtonBox["Infinity",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Infinity"]}], Cell[TextData[Cell[BoxData[
     RowBox[{
      ButtonBox["DirectedInfinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DirectedInfinity"], "[", 
      RowBox[{"-", "1"}], "]"}]], "InlineFormula"]], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ComplexInfinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ComplexInfinity"], Cell[TextData[Cell[BoxData[
     RowBox[{
      ButtonBox["DirectedInfinity",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/DirectedInfinity"], "[", "]"}]], 
     "InlineFormula"]], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->304],

Cell[TextData[{
 "Certain arithmetic operations are performed on ",
 Cell[BoxData[
  ButtonBox["DirectedInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectedInfinity"]], "InlineFormula"],
 " quantities. "
}], "Notes",
 CellID->29672],

Cell[TextData[{
 "In ",
 Cell[BoxData[
  ButtonBox["OutputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OutputForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectedInfinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedInfinity"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " is printed in terms of ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectedInfinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedInfinity"], "[", "]"}]], 
  "InlineFormula"],
 " is printed as ",
 Cell[BoxData[
  ButtonBox["ComplexInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13521]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->35143025],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->415370563],

Cell["Use as an expansion point and direction:", "ExampleText",
 CellID->74178475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", "z", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", 
     RowBox[{"DirectedInfinity", "[", "I", "]"}], ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->722508060],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{"\[Pi]", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       RowBox[{"Log", "[", "4", "]"}]}], "-", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       RowBox[{"Log", "[", 
        FractionBox["1", "z"], "]"}]}]}], ")"}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "z"], "]"}], "2"],
    SeriesData[$CellContext`z, 
     DirectedInfinity[
      Complex[0, 1]], {}, 0, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`z, 
   DirectedInfinity[
    Complex[0, 1]], {
   Rational[1, 2] (Pi + Complex[0, 1] Log[4] + 
     Complex[0, -2] Log[$CellContext`z^(-1)])}, 0, 2, 1],
  Editable->False]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{236, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->356818187]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->138229432],

Cell["Use as an integration limit:", "ExampleText",
 CellID->1911299],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Exp", "[", 
    RowBox[{"-", 
     RowBox[{"x", "^", "2"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"DirectedInfinity", "[", 
      RowBox[{"1", "+", "I"}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->240092440],

Cell[BoxData[
 FractionBox[
  SqrtBox["\[Pi]"], "2"]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{33, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->73354642]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16244085],

Cell["Use as a limiting point:", "ExampleText",
 CellID->386890591],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "x"}], "+", "3"}], ")"}]}], ",", 
   RowBox[{"x", "\[Rule]", 
    RowBox[{"DirectedInfinity", "[", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->110133851],

Cell[BoxData[
 FractionBox["1", "2"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->140428977]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10100],

Cell[TextData[{
 "Some directions have a special ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->73199198],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"DirectedInfinity", "[", "i", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "I", ",", 
       RowBox[{"-", "I"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->93487276],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwlAIxvwQDkP0fyALj
0v//gTQLiGQG8cGAgQuNL47Gl0HjK6HxmcGmMqOJcgMJJiBXAkrLQmkVNHVM
WHXzEHATO5BgB3L50MR5cYhjt4UJ6iaoF8CAFSrGh0cOOcRA4mx41AoQqRbT
tUzYRFkQfEwVoDBnhRuIpBBDJXL4wDUQZTYLyTrRQ50RERescFFkd6KYJkzQ
fNL9IkKyDqx8otKTKBYxQTT7saUJcSLUYE836K4ygMacApQWIEpXFlZV6GWH
ERofvWxAz4cQx5fiIBkYAbB+SZ0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{117, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->205731462]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2595818],

Cell[TextData[{
 "Use ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]inf\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " to enter ",
 Cell[BoxData[
  FormBox["\[Infinity]", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->667377328],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], ",", 
   RowBox[{"x", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->410529775],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121305735]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 " as an alternative input form: "
}], "ExampleText",
 CellID->19982996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Infinity", "//", "FullForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->544462645],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"DirectedInfinity", "[", "1", "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->231560255]
}, Open  ]],

Cell["Multiplying by a number changes the direction:", "ExampleText",
 CellID->64709539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", "I"}], ")"}], " ", "Infinity"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->157361279],

Cell[BoxData[
 RowBox[{"DirectedInfinity", "[", 
  FractionBox[
   RowBox[{"1", "+", "\[ImaginaryI]"}], 
   SqrtBox["2"]], "]"}]], "Output",
 ImageSize->{162, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->177987098]
}, Open  ]],

Cell[TextData[{
 "Unspecified or ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 " direction represents ",
 Cell[BoxData[
  ButtonBox["ComplexInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ComplexInfinity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->333927100],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DirectedInfinity", "[", "]"}], ",", 
   RowBox[{"DirectedInfinity", "[", "Indeterminate", "]"}]}], "}"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->64567827],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ComplexInfinity", ",", "ComplexInfinity"}], "}"}]], "Output",
 ImageSize->{240, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->180771420]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->658934572],

Cell["Finite or symbolic quantities are absorbed:", "ExampleText",
 CellID->658899830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"3", " ", 
  RowBox[{"DirectedInfinity", "[", "z", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->812925771],

Cell[BoxData[
 RowBox[{"DirectedInfinity", "[", "z", "]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->370983727]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"I", " ", 
  RowBox[{"DirectedInfinity", "[", "z", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24922894],

Cell[BoxData[
 RowBox[{"DirectedInfinity", "[", 
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"Sign", "[", "z", "]"}]}], "]"}]], "Output",
 ImageSize->{190, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23035222]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DirectedInfinity", "[", "z", "]"}], "+", "x"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->48193871],

Cell[BoxData[
 RowBox[{"DirectedInfinity", "[", "z", "]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->257678688]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15189044],

Cell["Extended arithmetic with infinite quantities:", "ExampleText",
 CellID->701551511],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DirectedInfinity", "[", "x", "]"}], " ", 
  RowBox[{"DirectedInfinity", "[", "y", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->233882837],

Cell[BoxData[
 RowBox[{"DirectedInfinity", "[", 
  RowBox[{"x", " ", "y"}], "]"}]], "Output",
 ImageSize->{147, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->92697414]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DirectedInfinity", "[", "x", "]"}], "+", 
  RowBox[{"DirectedInfinity", "[", "y", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->173800171],

Cell[BoxData[
 RowBox[{
  RowBox[{"DirectedInfinity", "[", "x", "]"}], "+", 
  RowBox[{"DirectedInfinity", "[", "y", "]"}]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{283, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->170336713]
}, Open  ]],

Cell[TextData[{
 "In this case the result depends on the directions ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["y", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->983526375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DirectedInfinity", "[", "x", "]"}], "+", 
   RowBox[{"DirectedInfinity", "[", "y", "]"}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1"}], ",", 
    RowBox[{"y", "\[Rule]", "2"}]}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->205479584],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->936869270]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"DirectedInfinity", "[", "x", "]"}], "+", 
   RowBox[{"DirectedInfinity", "[", "y", "]"}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"x", "\[Rule]", "1"}], ",", 
    RowBox[{"y", "\[Rule]", 
     RowBox[{"-", "1"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->345578524],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(\\(\\(-\[Infinity]\\)\\) + \
\[Infinity]\\) encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->152562461],

Cell[BoxData["Indeterminate"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->216023188]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8612456],

Cell[TextData[{
 "Operations that cannot be unambiguously defined produce ",
 Cell[BoxData[
  ButtonBox["Indeterminate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Indeterminate"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->774418690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DirectedInfinity", "[", "x", "]"}], "/", " ", 
  RowBox[{"DirectedInfinity", "[", "y", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->926765090],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0\\\\ \\(\\(DirectedInfinity[x]\\)\
\\)\\) encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->57339672],

Cell[BoxData["Indeterminate"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->161625664]
}, Open  ]],

Cell["\<\
In this case the result depends on the growth rates of the numerator and \
denominator:\
\>", "ExampleText",
 CellID->209129375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", " ", "t"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"y", " ", 
      RowBox[{"t", "^", "2"}]}], ")"}]}], ",", 
   RowBox[{"t", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->772619823],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->62171285]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Limit", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", " ", "t"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{"y", " ", 
      RowBox[{"(", 
       RowBox[{"t", "+", "1"}], ")"}]}], ")"}]}], ",", 
   RowBox[{"t", "\[Rule]", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->223162989],

Cell[BoxData[
 FractionBox["x", "y"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->82002264]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->704346538],

Cell["Use in mathematical functions: ", "ExampleText",
 CellID->52842574],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{"DirectedInfinity", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27339581],

Cell[BoxData["Indeterminate"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->84723818]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BesselJ", "[", 
  RowBox[{"0", ",", 
   RowBox[{"-", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30227333],

Cell[BoxData["0"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->129159551]
}, Open  ]],

Cell["The value in different directions may vary:", "ExampleText",
 CellID->301005561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Exp", "[", "Infinity", "]"}], ",", 
   RowBox[{"Exp", "[", 
    RowBox[{"-", "Infinity"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->558581392],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[Infinity]", ",", "0"}], "}"}]], "Output",
 ImageSize->{45, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->243862714]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15822],

Cell[TextData[{
 "Integrate along a line from the origin with direction ",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Pi]", "/", "4"}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->141330518],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      RowBox[{"x", "^", "2"}]}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"DirectedInfinity", "[", 
      RowBox[{"Exp", "[", 
       RowBox[{"I", " ", 
        RowBox[{"Pi", "/", "4"}]}], "]"}], "]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->274444544],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"\[Pi]", " ", 
    RowBox[{"(", 
     RowBox[{"\[ImaginaryI]", "+", 
      RowBox[{"Erfi", "[", "1", "]"}]}], ")"}]}], 
   RowBox[{"2", " ", "\[ExponentialE]"}]]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{111, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->198909939]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->470646411],

Cell[TextData[{
 "Asymptotics of the ",
 Cell[BoxData[
  ButtonBox["LogGamma",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LogGamma"]], "InlineFormula"],
 " function at ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectedInfinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedInfinity"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->190348583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Series", "[", 
   RowBox[{
    RowBox[{"LogGamma", "[", "n", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"DirectedInfinity", "[", "z", "]"}], ",", "3"}], "}"}]}], "]"}],
   " "}]], "Input",
 CellLabel->"In[1]:=",
 CellID->803468338],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
      RowBox[{"Floor", "[", 
       FractionBox[
        RowBox[{"\[Pi]", "+", 
         RowBox[{"Arg", "[", "z", "]"}]}], 
        RowBox[{"2", " ", "\[Pi]"}]], "]"}]}], "-", 
     RowBox[{"Log", "[", 
      FractionBox["1", "n"], "]"}]}], 
    FractionBox["1", "n"]], "+", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "\[ImaginaryI]"}], " ", "\[Pi]", " ", 
      RowBox[{"Floor", "[", 
       FractionBox[
        RowBox[{"\[Pi]", "+", 
         RowBox[{"Arg", "[", "z", "]"}]}], 
        RowBox[{"2", " ", "\[Pi]"}]], "]"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Log", "[", 
       FractionBox["1", "n"], "]"}]}], "+", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"Log", "[", 
       RowBox[{"2", " ", "\[Pi]"}], "]"}]}]}], ")"}], "+", 
   FractionBox["1", 
    RowBox[{"12", " ", "n"}]], "-", 
   RowBox[{
    FractionBox["1", "360"], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox["1", "n"], ")"}], "3"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      FractionBox["1", "n"], "]"}], "4"],
    SeriesData[$CellContext`n, 
     DirectedInfinity[$CellContext`z], {}, -1, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`n, 
   DirectedInfinity[$CellContext`z], {-1 + 
    Complex[0, 2] Pi Floor[Rational[1, 2] Pi^(-1) (Pi + Arg[$CellContext`z])] - 
    Log[$CellContext`n^(-1)], 
    Complex[0, -1] Pi 
     Floor[Rational[1, 2] Pi^(-1) (Pi + Arg[$CellContext`z])] + 
    Rational[1, 2] Log[$CellContext`n^(-1)] + Rational[1, 2] Log[2 Pi], 
    Rational[1, 12], 0, 
    Rational[-1, 360]}, -1, 4, 1],
  Editable->False]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{486, 82},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55736261]
}, Open  ]],

Cell["\<\
Plot asymptotic value compared to function value in different directions:\
\>", "ExampleText",
 CellID->5872242],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Abs", "[", 
       RowBox[{
        RowBox[{"Normal", "[", "%", "]"}], "-", 
        RowBox[{"LogGamma", "[", "n", "]"}]}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{"n", "\[Rule]", 
        RowBox[{
         RowBox[{"121", "/", "3"}], "z"}]}], "}"}]}], "/.", 
     RowBox[{"z", "\[Rule]", 
      RowBox[{"Exp", "[", 
       RowBox[{"I", " ", "\[Phi]"}], "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8569331],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJw1VXtUjGkYn6aacanJ5WQVohIq0XZZtePr/bRtS4UudFFNIa2ERjTKpQuV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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 7.41*^-12},
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{-3, 3}, {7.405436724792428*^-12, 7.462482433344989*^-12}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{229, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->442697886]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12578],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " can generate infinities:"
}], "ExampleText",
 CellID->187351271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"1", "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"E", "+", "1"}], ")"}], "^", "2"}], "-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"E", "^", "2"}], "+", 
       RowBox[{"2", "E"}], "+", "1"}], ")"}]}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->116045302],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "::", "\<\"infd\"\>"}], ":", 
  " ", "\<\"Expression \\!\\(1\\/\\(\\(\\(-1\\)\\) - \\(\\(2\\\\ \
\[ExponentialE]\\)\\) - \[ExponentialE]\\^2 + \\((1 + \[ExponentialE])\\)\\^2\
\\)\\) simplified to \\!\\(ComplexInfinity\\). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Simplify/infd\\\", ButtonNote -> \
\\\"Simplify::infd\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->28954973],

Cell[BoxData["ComplexInfinity"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->4552588]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"Log", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"Pi", "/", "16"}], "]"}], "-", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{"2", "-", 
       RowBox[{"Sqrt", "[", 
        RowBox[{"2", "+", 
         RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}]}], "]"}], "/", "2"}]}], 
   "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->36645279],

Cell[BoxData[
 RowBox[{
  RowBox[{"FullSimplify", "::", "\<\"infd\"\>"}], ":", 
  " ", "\<\"Expression \\!\\(Log[\\(\\(\\(\\(\\(\\(-\\(\\(1\\/2\\)\\)\\)\\)\\\
\\ \\@\\(2 - \\@\\(Plus[\\(\\(\[LeftSkeleton] 2 \[RightSkeleton]\\)\\)]\\)\\)\
\\)\\) + \\(\\(Sin[\\(\\(\[Pi]\\/16\\)\\)]\\)\\)\\)\\)]\\) simplified to \
\\!\\(-\[Infinity]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FullSimplify/infd\\\", ButtonNote -> \
\\\"FullSimplify::infd\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->227963827],

Cell[BoxData[
 RowBox[{"-", "\[Infinity]"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{20, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->161632214]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->777841948],

Cell[TextData[{
 "A nested ",
 Cell[BoxData[
  ButtonBox["DirectedInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectedInfinity"]], "InlineFormula"],
 " reduces to one ",
 Cell[BoxData[
  ButtonBox["DirectedInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectedInfinity"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->71675015],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirectedInfinity", "[", 
  RowBox[{"DirectedInfinity", "[", 
   RowBox[{"DirectedInfinity", "[", "I", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->665697429],

Cell[BoxData[
 TagBox[
  RowBox[{
   TagBox["\[ImaginaryI]",
    "DirectedInfinityCoefficient",
    Editable->True], " ", "\[Infinity]"}],
  DirectedInfinity,
  Editable->False]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{23, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->769962624]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->193455489],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectedInfinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectedInfinity"], "[", "]"}]], 
  "InlineFormula"],
 " is not a number:"
}], "ExampleText",
 CellID->441726279],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumberQ", "[", 
  RowBox[{"DirectedInfinity", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->146790867],

Cell[BoxData["False"], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104179255]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30959],

Cell["Symbolic quantities might get lost in operations:", "ExampleText",
 CellID->425480201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"DirectedInfinity", "[", "z", "]"}], "+", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->256456929],

Cell[BoxData[
 RowBox[{"DirectedInfinity", "[", "z", "]"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->677004895]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->214165074],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Accuracy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Accuracy"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Precision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Precision"]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  ButtonBox["DirectedInfinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DirectedInfinity"]], "InlineFormula"],
 " refers to the direction argument:"
}], "ExampleText",
 CellID->243294192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", 
  RowBox[{"DirectedInfinity", "[", 
   RowBox[{"Exp", "[", 
    RowBox[{"I", " ", 
     RowBox[{"Pi", "/", "4"}]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->342572769],

Cell[BoxData["\[Infinity]"], "Output",
 ImageSize->{12, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->38020555]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Precision", "[", 
  RowBox[{"DirectedInfinity", "[", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{"I", " ", 
       RowBox[{"Pi", "/", "4"}]}], "]"}], ",", "20"}], "]"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->46183314],

Cell[BoxData["20.`"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->734447197]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->386607895],

Cell[TextData[{
 "Simplifications performed by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " assume symbols to represent numbers:"
}], "ExampleText",
 CellID->113351548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "/", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->383522144],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127462526]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Infinity]", "/", "\[Infinity]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->122291777],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0\\\\ \[Infinity]\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/indet\\\", \
ButtonNote -> \\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->37941036],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->159582194]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1578],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Indeterminate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Indeterminate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexInfinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexInfinity"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->398]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29017],

Cell[TextData[ButtonBox["Indeterminate and Infinite Results",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IndeterminateAndInfiniteResults"]], "Tutorials",\

 CellID->7855]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->3023],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/index.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/Constants/DirectedInfinity/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DirectedInfinity - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 21.5238144}", "context" -> "System`", 
    "keywords" -> {"complex infinity", "directional infinity", "infinity"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "DirectedInfinity[] represents an infinite numerical quantity whose \
direction in the complex plane is unknown. DirectedInfinity[z] represents an \
infinite numerical quantity that is a positive real multiple of the complex \
number z. ", "synonyms" -> {"directed infinity"}, "title" -> 
    "DirectedInfinity", "type" -> "Symbol", "uri" -> 
    "ref/DirectedInfinity"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6682, 222, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->35143025]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 42704, 1587}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1364, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1987, 62, 54, 1, 70, "ObjectName",
 CellID->22091],
Cell[2044, 65, 977, 29, 70, "Usage",
 CellID->5830]
}, Open  ]],
Cell[CellGroupData[{
Cell[3058, 99, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3536, 116, 463, 14, 70, "Notes",
 CellID->14957],
Cell[4002, 132, 68, 1, 70, "Notes",
 CellID->6051],
Cell[4073, 135, 1468, 38, 70, "2ColumnTableMod",
 CellID->304],
Cell[5544, 175, 248, 8, 70, "Notes",
 CellID->29672],
Cell[5795, 185, 850, 32, 70, "Notes",
 CellID->13521]
}, Closed]],
Cell[CellGroupData[{
Cell[6682, 222, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->35143025],
Cell[CellGroupData[{
Cell[7066, 236, 148, 5, 70, "ExampleSection",
 CellID->415370563],
Cell[7217, 243, 82, 1, 70, "ExampleText",
 CellID->74178475],
Cell[CellGroupData[{
Cell[7324, 248, 267, 9, 28, "Input",
 CellID->722508060],
Cell[7594, 259, 963, 32, 52, "Output",
 CellID->356818187]
}, Open  ]],
Cell[8572, 294, 125, 3, 70, "ExampleDelimiter",
 CellID->138229432],
Cell[8700, 299, 69, 1, 70, "ExampleText",
 CellID->1911299],
Cell[CellGroupData[{
Cell[8794, 304, 337, 11, 70, "Input",
 CellID->240092440],
Cell[9134, 317, 241, 9, 56, "Output",
 CellID->73354642]
}, Open  ]],
Cell[9390, 329, 124, 3, 70, "ExampleDelimiter",
 CellID->16244085],
Cell[9517, 334, 67, 1, 70, "ExampleText",
 CellID->386890591],
Cell[CellGroupData[{
Cell[9609, 339, 342, 12, 70, "Input",
 CellID->110133851],
Cell[9954, 353, 178, 6, 51, "Output",
 CellID->140428977]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10181, 365, 216, 7, 70, "ExampleSection",
 CellID->10100],
Cell[10400, 374, 222, 8, 70, "ExampleText",
 CellID->73199198],
Cell[CellGroupData[{
Cell[10647, 386, 335, 11, 70, "Input",
 CellID->93487276],
Cell[10985, 399, 545, 13, 70, "Output",
 Evaluatable->False,
 CellID->205731462]
}, Open  ]],
Cell[11545, 415, 123, 3, 70, "ExampleDelimiter",
 CellID->2595818],
Cell[11671, 420, 273, 10, 70, "ExampleText",
 CellID->667377328],
Cell[CellGroupData[{
Cell[11969, 434, 188, 6, 70, "Input",
 CellID->410529775],
Cell[12160, 442, 158, 5, 36, "Output",
 CellID->121305735]
}, Open  ]],
Cell[12333, 450, 216, 8, 70, "ExampleText",
 CellID->19982996],
Cell[CellGroupData[{
Cell[12574, 462, 107, 3, 70, "Input",
 CellID->544462645],
Cell[12684, 467, 334, 12, 50, "Output",
 CellID->231560255]
}, Open  ]],
Cell[13033, 482, 88, 1, 70, "ExampleText",
 CellID->64709539],
Cell[CellGroupData[{
Cell[13146, 487, 146, 5, 70, "Input",
 CellID->157361279],
Cell[13295, 494, 271, 9, 55, "Output",
 CellID->177987098]
}, Open  ]],
Cell[13581, 506, 368, 13, 70, "ExampleText",
 CellID->333927100],
Cell[CellGroupData[{
Cell[13974, 523, 211, 7, 70, "Input",
 CellID->64567827],
Cell[14188, 532, 232, 7, 36, "Output",
 CellID->180771420]
}, Open  ]],
Cell[14435, 542, 125, 3, 70, "ExampleDelimiter",
 CellID->658934572],
Cell[14563, 547, 86, 1, 70, "ExampleText",
 CellID->658899830],
Cell[CellGroupData[{
Cell[14674, 552, 135, 4, 70, "Input",
 CellID->812925771],
Cell[14812, 558, 249, 8, 36, "Output",
 CellID->370983727]
}, Open  ]],
Cell[CellGroupData[{
Cell[15098, 571, 134, 4, 70, "Input",
 CellID->24922894],
Cell[15235, 577, 267, 8, 36, "Output",
 CellID->23035222]
}, Open  ]],
Cell[CellGroupData[{
Cell[15539, 590, 134, 4, 70, "Input",
 CellID->48193871],
Cell[15676, 596, 249, 8, 36, "Output",
 CellID->257678688]
}, Open  ]],
Cell[15940, 607, 124, 3, 70, "ExampleDelimiter",
 CellID->15189044],
Cell[16067, 612, 88, 1, 70, "ExampleText",
 CellID->701551511],
Cell[CellGroupData[{
Cell[16180, 617, 178, 5, 70, "Input",
 CellID->233882837],
Cell[16361, 624, 223, 7, 36, "Output",
 CellID->92697414]
}, Open  ]],
Cell[CellGroupData[{
Cell[16621, 636, 178, 5, 70, "Input",
 CellID->173800171],
Cell[16802, 643, 315, 10, 36, "Output",
 CellID->170336713]
}, Open  ]],
Cell[17132, 656, 238, 9, 70, "ExampleText",
 CellID->983526375],
Cell[CellGroupData[{
Cell[17395, 669, 313, 10, 70, "Input",
 CellID->205479584],
Cell[17711, 681, 168, 5, 36, "Output",
 CellID->936869270]
}, Open  ]],
Cell[CellGroupData[{
Cell[17916, 691, 334, 11, 70, "Input",
 CellID->345578524],
Cell[18253, 704, 419, 8, 70, "Message",
 CellID->152562461],
Cell[18675, 714, 218, 7, 36, "Output",
 CellID->216023188]
}, Open  ]],
Cell[18908, 724, 123, 3, 70, "ExampleDelimiter",
 CellID->8612456],
Cell[19034, 729, 249, 8, 70, "ExampleText",
 CellID->774418690],
Cell[CellGroupData[{
Cell[19308, 741, 183, 5, 70, "Input",
 CellID->926765090],
Cell[19494, 748, 417, 8, 70, "Message",
 CellID->57339672],
Cell[19914, 758, 218, 7, 36, "Output",
 CellID->161625664]
}, Open  ]],
Cell[20147, 768, 138, 4, 70, "ExampleText",
 CellID->209129375],
Cell[CellGroupData[{
Cell[20310, 776, 314, 11, 70, "Input",
 CellID->772619823],
Cell[20627, 789, 157, 5, 36, "Output",
 CellID->62171285]
}, Open  ]],
Cell[CellGroupData[{
Cell[20821, 799, 342, 12, 70, "Input",
 CellID->223162989],
Cell[21166, 813, 177, 6, 51, "Output",
 CellID->82002264]
}, Open  ]],
Cell[21358, 822, 125, 3, 70, "ExampleDelimiter",
 CellID->704346538],
Cell[21486, 827, 73, 1, 70, "ExampleText",
 CellID->52842574],
Cell[CellGroupData[{
Cell[21584, 832, 136, 4, 70, "Input",
 CellID->27339581],
Cell[21723, 838, 217, 7, 36, "Output",
 CellID->84723818]
}, Open  ]],
Cell[CellGroupData[{
Cell[21977, 850, 151, 5, 70, "Input",
 CellID->30227333],
Cell[22131, 857, 206, 7, 36, "Output",
 CellID->129159551]
}, Open  ]],
Cell[22352, 867, 86, 1, 70, "ExampleText",
 CellID->301005561],
Cell[CellGroupData[{
Cell[22463, 872, 211, 7, 70, "Input",
 CellID->558581392],
Cell[22677, 881, 213, 7, 36, "Output",
 CellID->243862714]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[22939, 894, 223, 7, 70, "ExampleSection",
 CellID->15822],
Cell[23165, 903, 210, 7, 70, "ExampleText",
 CellID->141330518],
Cell[CellGroupData[{
Cell[23400, 914, 507, 17, 70, "Input",
 CellID->274444544],
Cell[23910, 933, 409, 14, 52, "Output",
 CellID->198909939]
}, Open  ]],
Cell[24334, 950, 125, 3, 70, "ExampleDelimiter",
 CellID->470646411],
Cell[24462, 955, 406, 15, 70, "ExampleText",
 CellID->190348583],
Cell[CellGroupData[{
Cell[24893, 974, 292, 10, 70, "Input",
 CellID->803468338],
Cell[25188, 986, 2004, 62, 103, "Output",
 CellID->55736261]
}, Open  ]],
Cell[27207, 1051, 122, 3, 70, "ExampleText",
 CellID->5872242],
Cell[CellGroupData[{
Cell[27354, 1058, 653, 21, 70, "Input",
 CellID->8569331],
Cell[28010, 1081, 2777, 56, 161, "Output",
 CellID->442697886]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30836, 1143, 233, 7, 70, "ExampleSection",
 CellID->12578],
Cell[31072, 1152, 339, 12, 70, "ExampleText",
 CellID->187351271],
Cell[CellGroupData[{
Cell[31436, 1168, 371, 13, 70, "Input",
 CellID->116045302],
Cell[31810, 1183, 506, 9, 70, "Message",
 CellID->28954973],
Cell[32319, 1194, 219, 7, 36, "Output",
 CellID->4552588]
}, Open  ]],
Cell[CellGroupData[{
Cell[32575, 1206, 414, 14, 70, "Input",
 CellID->36645279],
Cell[32992, 1222, 582, 10, 70, "Message",
 CellID->227963827],
Cell[33577, 1234, 233, 8, 36, "Output",
 CellID->161632214]
}, Open  ]],
Cell[33825, 1245, 125, 3, 70, "ExampleDelimiter",
 CellID->777841948],
Cell[33953, 1250, 363, 13, 70, "ExampleText",
 CellID->71675015],
Cell[CellGroupData[{
Cell[34341, 1267, 199, 5, 70, "Input",
 CellID->665697429],
Cell[34543, 1274, 367, 14, 36, "Output",
 CellID->769962624]
}, Open  ]],
Cell[34925, 1291, 125, 3, 70, "ExampleDelimiter",
 CellID->193455489],
Cell[35053, 1296, 239, 9, 70, "ExampleText",
 CellID->441726279],
Cell[CellGroupData[{
Cell[35317, 1309, 141, 4, 70, "Input",
 CellID->146790867],
Cell[35461, 1315, 210, 7, 36, "Output",
 CellID->104179255]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[35720, 1328, 226, 7, 70, "ExampleSection",
 CellID->30959],
Cell[35949, 1337, 92, 1, 70, "ExampleText",
 CellID->425480201],
Cell[CellGroupData[{
Cell[36066, 1342, 135, 4, 70, "Input",
 CellID->256456929],
Cell[36204, 1348, 201, 6, 36, "Output",
 CellID->677004895]
}, Open  ]],
Cell[36420, 1357, 125, 3, 70, "ExampleDelimiter",
 CellID->214165074],
Cell[36548, 1362, 496, 18, 70, "ExampleText",
 CellID->243294192],
Cell[CellGroupData[{
Cell[37069, 1384, 231, 7, 70, "Input",
 CellID->342572769],
Cell[37303, 1393, 167, 5, 36, "Output",
 CellID->38020555]
}, Open  ]],
Cell[CellGroupData[{
Cell[37507, 1403, 294, 10, 70, "Input",
 CellID->46183314],
Cell[37804, 1415, 161, 5, 36, "Output",
 CellID->734447197]
}, Open  ]],
Cell[37980, 1423, 125, 3, 70, "ExampleDelimiter",
 CellID->386607895],
Cell[38108, 1428, 178, 6, 70, "ExampleText",
 CellID->113351548],
Cell[CellGroupData[{
Cell[38311, 1438, 92, 3, 70, "Input",
 CellID->383522144],
Cell[38406, 1443, 158, 5, 36, "Output",
 CellID->127462526]
}, Open  ]],
Cell[CellGroupData[{
Cell[38601, 1453, 112, 3, 70, "Input",
 CellID->122291777],
Cell[38716, 1458, 395, 7, 70, "Message",
 CellID->37941036],
Cell[39114, 1467, 170, 5, 36, "Output",
 CellID->159582194]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[39345, 1479, 310, 9, 70, "SeeAlsoSection",
 CellID->1578],
Cell[39658, 1490, 473, 17, 70, "SeeAlso",
 CellID->398]
}, Open  ]],
Cell[CellGroupData[{
Cell[40168, 1512, 314, 9, 70, "TutorialsSection",
 CellID->29017],
Cell[40485, 1523, 177, 4, 70, "Tutorials",
 CellID->7855]
}, Open  ]],
Cell[CellGroupData[{
Cell[40699, 1532, 320, 9, 70, "RelatedLinksSection",
 CellID->3023],
Cell[41022, 1543, 176, 4, 70, "RelatedLinks"],
Cell[41201, 1549, 198, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[41414, 1556, 27, 0, 70, "History"],
Cell[41444, 1558, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

