(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12856,        461]
NotebookOptionsPosition[      9706,        354]
NotebookOutlinePosition[     10977,        390]
CellTagsIndexPosition[     10892,        385]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Naming and Finding Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NamingAndFindingFiles"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Naming and Finding Files\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directory" :> Documentation`HelpLookup["paclet:ref/Directory"],
           "SetDirectory" :> 
          Documentation`HelpLookup["paclet:ref/SetDirectory"], 
          "ResetDirectory" :> 
          Documentation`HelpLookup["paclet:ref/ResetDirectory"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Directory\"\>", 
       2->"\<\"SetDirectory\"\>", 
       3->"\<\"ResetDirectory\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directories & Directory Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/DirectoriesAndDirectoryOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Directories & Directory Operations\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DirectoryStack", "ObjectName",
 CellID->11274],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DirectoryStack",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DirectoryStack"], "[", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]gives the directory stack which represents the sequence \
of current directories used. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->22810]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectoryStack",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectoryStack"], "[", "]"}]], "InlineFormula"],
 " returns a list of full names of directories. "
}], "Notes",
 CellID->30819],

Cell[TextData[{
 "Each call to ",
 Cell[BoxData[
  ButtonBox["SetDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDirectory"]], "InlineFormula"],
 " prepends one element to the directory stack; each call to ",
 Cell[BoxData[
  ButtonBox["ResetDirectory",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ResetDirectory"]], "InlineFormula"],
 " drops one. "
}], "Notes",
 CellID->24586]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->763549690],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->145500150],

Cell[TextData[{
 "Setting directory pushes a directory onto the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectoryStack",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectoryStack"], "[", "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->545770821],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", "$InstallationDirectory", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->365646888],

Cell[BoxData["\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\"\>"], "Output",
 ImageSize->{347, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->464015974]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirectoryStack", "[", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->223241202],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\"\>", 
   ",", "\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\Documentation\\\\English\\\\System\\\\\
ReferencePages\\\\Symbols\"\>", 
   ",", "\<\"C:\\\\Documents and Settings\\\\roger\\\\My Documents\"\>"}], 
  "}"}]], "Output",
 ImageSize->{564, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->626772017]
}, Open  ]],

Cell[TextData[{
 "Resetting directory pops a directory from the ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DirectoryStack",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectoryStack"], "[", "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->714022966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ResetDirectory", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->300499958],

Cell[BoxData["\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\"\>"], "Output",
 ImageSize->{347, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->199115048]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DirectoryStack", "[", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->45218536],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"C:\\\\Program Files\\\\Wolfram \
Research\\\\Mathematica\\\\6.0\\\\Documentation\\\\English\\\\System\\\\\
ReferencePages\\\\Symbols\"\>", 
   ",", "\<\"C:\\\\Documents and Settings\\\\roger\\\\My Documents\"\>"}], 
  "}"}]], "Output",
 ImageSize->{564, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->295687246]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12248],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Directory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Directory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ResetDirectory",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ResetDirectory"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12859]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28091],

Cell[TextData[ButtonBox["Naming and Finding Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NamingAndFindingFiles"]], "Tutorials",
 CellID->30504]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->204434852],

Cell[TextData[ButtonBox["Directories & Directory Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DirectoriesAndDirectoryOperations"]], "MoreAbout",
 CellID->465277679]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DirectoryStack - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 26.9927044}", "context" -> "System`", 
    "keywords" -> {"history"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "DirectoryStack[] gives the directory stack which represents the sequence \
of current directories used. ", "synonyms" -> {"directory stack"}, "title" -> 
    "DirectoryStack", "type" -> "Symbol", "uri" -> "ref/DirectoryStack"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4467, 149, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->763549690]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10749, 378}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2064, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2687, 80, 52, 1, 70, "ObjectName",
 CellID->11274],
Cell[2742, 83, 519, 16, 70, "Usage",
 CellID->22810]
}, Open  ]],
Cell[CellGroupData[{
Cell[3298, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3776, 121, 251, 8, 70, "Notes",
 CellID->30819],
Cell[4030, 131, 400, 13, 70, "Notes",
 CellID->24586]
}, Closed]],
Cell[CellGroupData[{
Cell[4467, 149, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->763549690],
Cell[CellGroupData[{
Cell[4852, 163, 148, 5, 70, "ExampleSection",
 CellID->145500150],
Cell[5003, 170, 267, 9, 70, "ExampleText",
 CellID->545770821],
Cell[CellGroupData[{
Cell[5295, 183, 129, 3, 28, "Input",
 CellID->365646888],
Cell[5427, 188, 229, 6, 36, "Output",
 CellID->464015974]
}, Open  ]],
Cell[CellGroupData[{
Cell[5693, 199, 105, 3, 28, "Input",
 CellID->223241202],
Cell[5801, 204, 494, 13, 71, "Output",
 CellID->626772017]
}, Open  ]],
Cell[6310, 220, 267, 9, 70, "ExampleText",
 CellID->714022966],
Cell[CellGroupData[{
Cell[6602, 233, 105, 3, 70, "Input",
 CellID->300499958],
Cell[6710, 238, 229, 6, 36, "Output",
 CellID->199115048]
}, Open  ]],
Cell[CellGroupData[{
Cell[6976, 249, 104, 3, 70, "Input",
 CellID->45218536],
Cell[7083, 254, 410, 11, 71, "Output",
 CellID->295687246]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7554, 272, 311, 9, 70, "SeeAlsoSection",
 CellID->12248],
Cell[7868, 283, 718, 26, 70, "SeeAlso",
 CellID->12859]
}, Open  ]],
Cell[CellGroupData[{
Cell[8623, 314, 314, 9, 70, "TutorialsSection",
 CellID->28091],
Cell[8940, 325, 156, 3, 70, "Tutorials",
 CellID->30504]
}, Open  ]],
Cell[CellGroupData[{
Cell[9133, 333, 319, 9, 70, "MoreAboutSection",
 CellID->204434852],
Cell[9455, 344, 179, 3, 70, "MoreAbout",
 CellID->465277679]
}, Open  ]],
Cell[9649, 350, 27, 0, 70, "History"],
Cell[9679, 352, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

