(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     39251,       1414]
NotebookOptionsPosition[     31802,       1149]
NotebookOutlinePosition[     33220,       1188]
CellTagsIndexPosition[     33134,       1183]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete Distributions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DiscreteDistributions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Discrete Distributions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"UniformDistribution" :> 
          Documentation`HelpLookup["paclet:ref/UniformDistribution"], 
          "RandomInteger" :> 
          Documentation`HelpLookup["paclet:ref/RandomInteger"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"UniformDistribution\"\>", 
       2->"\<\"RandomInteger\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Discrete Statistical Distributions" :> 
          Documentation`HelpLookup[
           "paclet:guide/DiscreteStatisticalDistributions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Discrete Statistical Distributions\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["DiscreteUniformDistribution", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["DiscreteUniformDistribution",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/DiscreteUniformDistribution"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["min", "TR"]], ",", 
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["max", "TR"]]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a discrete uniform distribution over the \
integers from ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["min", "TR"]]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TR"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19787]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The probability for value ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in a discrete uniform distribution is constant for integers ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["i", "min"], "\[LessEqual]", "x", "\[LessEqual]", 
    SubscriptBox["i", "max"]}], TraditionalForm]], "InlineMath"],
 ", and is zero otherwise.",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->9425,
  ButtonNote->"9425"]
}], "Notes",
 CellID->429991538],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DiscreteUniformDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiscreteUniformDistribution"]], "InlineFormula"],
 " allows ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["min", "TR"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["max", "TR"]]], "InlineFormula"],
 " to be any integers such that ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["i", "TI"], 
    StyleBox["min", "TR"]], "<", 
   SubscriptBox[
    StyleBox["i", "TI"], 
    StyleBox["max", "TR"]]}]], "InlineFormula"],
 "."
}], "Notes",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0.7, 0},
 ScriptMinSize->9,
 CellID->10777],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DiscreteUniformDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiscreteUniformDistribution"]], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 ".",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->15726,
  ButtonNote->"15726"]
}], "Notes",
 CellID->33143606]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->143711865],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->40923890],

Cell["Mean and variance of a discrete uniform distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->15726],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"DiscreteUniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"min", ",", "max"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2922],

Cell[BoxData[
 FractionBox[
  RowBox[{"max", "+", "min"}], "2"]], "Output",
 ImageSize->{63, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->346791856]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"DiscreteUniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"min", ",", "max"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23529],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "12"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1"}], "+", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"1", "+", "max", "-", "min"}], ")"}], "2"]}], ")"}]}]], "Output",\

 ImageSize->{161, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->496037825]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23627],

Cell["Probability density function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 CellFrameLabels->{{None, None}, {None, None}},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9425],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"DiscreteUniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"min", ",", "max"}], "}"}], "]"}], ",", "k"}], "]"}]], "Input",
 CellFrameLabels->{{None, None}, {None, None}},
 CellLabel->"In[1]:=",
 CellID->19900],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", "max", "-", "min"}]]], "Output",
 ImageSize->{83, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->194709908]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"PDF", "[", 
      RowBox[{
       RowBox[{"DiscreteUniformDistribution", "[", 
        RowBox[{"{", 
         RowBox[{"1", ",", "10"}], "}"}], "]"}], ",", "k"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"k", ",", "1", ",", "10"}], "}"}]}], "]"}], ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7975],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 0.1}, {2., 0.1}, {3., 0.1}, {4., 0.1}, {5., 0.1}, {
   6., 0.1}, {7., 0.1}, {8., 0.1}, {9., 0.1}, {10., 0.1}, {1., 0.}, {2., 
   0.}, {3., 0.}, {4., 0.}, {5., 0.}, {6., 0.}, {7., 0.}, {8., 0.}, {9., 
   0.}, {10., 0.}, {1., 0.1}, {2., 0.1}, {3., 0.1}, {4., 0.1}, {5., 0.1}, {6.,
    0.1}, {7., 0.1}, {8., 0.1}, {9., 0.1}, {10., 0.1}}, {{{}, {}, {}, {}, 
     {Hue[0.67, 0.6, 0.6], Opacity[0.2], LineBox[{11, 1}], LineBox[{12, 2}], 
      LineBox[{13, 3}], LineBox[{14, 4}], LineBox[{15, 5}], LineBox[{16, 6}], 
      LineBox[{17, 7}], LineBox[{18, 8}], LineBox[{19, 9}], 
      LineBox[{20, 10}]}}, {{}, 
     {Hue[0.67, 0.6, 0.6], 
      PointBox[{21, 22, 23, 24, 25, 26, 27, 28, 29, 30}]}, {}}}],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageMargins->0.,
  ImageSize->{225, Automatic},
  PlotRange->{{0., 10.}, {0.1, 0.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{229, 144},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->711637457]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21413],

Cell["\<\
Generate a set of pseudorandom numbers that have the discrete uniform \
distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->19096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{
   RowBox[{"DiscreteUniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"1", ",", "10"}], "}"}], "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17016],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4", ",", "6", ",", "2", ",", "4", ",", "10", ",", "10", ",", "2", ",", "1",
    ",", "1", ",", "7"}], "}"}]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->481140741]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26905],

Cell["\<\
Properties based on higher\[Hyphen]order moments:\
\>", "ExampleText",
 CellID->20699375],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"DiscreteUniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"min", ",", "max"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7251],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->6843592]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"DiscreteUniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"min", ",", "max"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27703],

Cell[BoxData[
 RowBox[{
  FractionBox["3", "5"], " ", 
  RowBox[{"(", 
   RowBox[{"3", "-", 
    FractionBox["4", 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "+", "max", "-", "min"}], ")"}], "2"]}]]}], 
   ")"}]}]], "Output",
 ImageSize->{177, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->340273580]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17262],

Cell["Second moment of a discrete uniform distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->18534],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ExpectedValue", "[", 
  RowBox[{
   RowBox[{"k", "^", "2"}], ",", 
   RowBox[{"DiscreteUniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"min", ",", "max"}], "}"}], "]"}], ",", "k"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29831],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "6"], " ", 
  RowBox[{"(", 
   RowBox[{"max", "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["max", "2"]}], "-", "min", "+", 
    RowBox[{"2", " ", "max", " ", "min"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["min", "2"]}]}], ")"}]}]], "Output",
 ImageSize->{253, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->279730606]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->113],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  FormBox["0.9", TraditionalForm]], "InlineMath"],
 " quantile of a discrete uniform distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->48521834],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"DiscreteUniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"2", ",", "15"}], "}"}], "]"}], ",", ".9"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4591],

Cell[BoxData["14"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->182214005]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7790],

Cell["\<\
Plot the cumulative distribution function of a discrete uniform distribution:\
\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->13370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"CDF", "[", 
    RowBox[{
     RowBox[{"DiscreteUniformDistribution", "[", 
      RowBox[{"{", 
       RowBox[{"5", ",", "15"}], "}"}], "]"}], ",", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26124],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWU1oE1EQftlNmggePHrs1VbTnDwoYrRWUdEiWNSLkgYhEWuljQqKiB7s
QS9aFIvFHvw5eRMqgoIoCIKklwoeBMlB6qUIFg8BYZ2Zfcm+vH27eZvt5ick
b3d2vvnm/czOztscyZUKZydypWI+139gKnexUMxP9++fnIJLZowxVoHf7GYG
5xac0a9iWXAU2yy0JqjS/GjA0YDjVi6zOMH4ZxCEuIAySTmMLYIt+pAtizuy
jRcRA5JsSvIWbBK2XG+JBQcWw2NEngeUDFF7HRRk9Uj38Bkf0vPlILhdWsuD
yJPW85QQPTEeOaxPtPOax728b9ssJ5pqsWfw0DN41Il6O+rEKN4k9aysc3Xh
yRf4sgw25lL5J0c9JtRGaJd5b91MyYBySpL7SAaffHZkfVD+Zv7C8q03v6mc
1SFpVjKSvpnchHXywis8nY8EhXGZaYunEKj8+Euc3RQ25srKH66/52O1uvr3
UmkR6FkKG/PwwQWXFY59J6F375rz5dzRc6huGhsPcPqITxCSa49qF8vI8Dys
HC5eklbw2tU31eo/VM3Ytg05PiHxqjkrld8QQxhGSYqlY6NP7XBScvZJHPLT
bx/JJ8Ze+HDIGQSfJii2ahvUP82D+0pzFmHNcB4MaY69LeWYCItCzyNReHr3
9nstq9zwQT5/ttQQh5BJ7Icuu660OkoyQFtE4XhHQ3J0Kyqasc3cfg8pB74s
iQ1mjq/Lv1A1rbQ6WbN6vfjNQbmylKtClOPfgydQDtHhwDs2rrhzdW3FvIhj
QFHHNmGp7/sIbIW5V9ZcTRn01lgfhX0/VdPCoweL7RRV3E79UfDhBBSv05Nk
BZEMR1QVlVbj6BMQ59qgxbHl2+hvPbXM/PjhB7/bU3S3z97/xPWnG0Y4QWhY
WFhAPD2j5DwfAuVV1+CpKvY9WAI+rzvNgiS61maLsyDbaPZeyiKG9rjV6w0F
AhSIzh5i7tFnrj+utMKI20B1JVhCgYHXxupI7M0Vi+cGl1bkudxzqA6PDVbJ
2R9Cjc/1h3ysYCsBEeCsLdQMvlY3SXZ2NkFROEO3QnI0RwXNSB4sAXNJ+1jE
qgJNu6//sDtoqEUhgNfWqqjKulbIa191h2RnH5NVRkBYFHq+2xZPPTE2KCOc
ag32fPxdw3YfK6hEGmo8YOG7FbXVA5KdPU0nUThDDyP31PgvjPz+QhX7ah7Z
km4i37uxG3gQYNtDcPGskKGsYL/2rFu20K9yKDudLGQj3f+8sdh/VR9o7A==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->464312253]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->462148167],

Cell["\<\
The density functions of discrete uniform random variables are not highly \
concentrated about their means:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->24052],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"PDF", "[", 
     RowBox[{
      RowBox[{"DiscreteUniformDistribution", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "max"}], "}"}], "]"}], ",", "x"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "1", ",", "12"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"max", ",", "1", ",", "12"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28041],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmqEOglAUQB/iD+gMRpLf4Bfo5makWZhz08B0aOcbjGQbXSqRQiGwUQx8
Cb4rSYtzw4l62N7be9xzTqMxdw7rlescNkvHmnrObr1Z7q3J1tOvTEMpVcoa
Kn2u9KleZlXJQZ6LXkZ9NWV2e9RFb0YNNPo20Vu/KIouU6YP07NM8zyHgHgX
cRIiyzIoqLZTR6HSNIWE/BfSFzJJEmho6NdoV+g4jjEwMD5jLPTWi6IICwvr
u62ZfP1hGGJiYmKKORYzCAJsbGzse3sktu/7FChQoNDGwkAKtm1ToUKFyi9X
OlLRV0qUKFGi9LzU5J+/ZT0zrt1aX2A=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 225},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->441170705]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23946],

Cell[TextData[{
 "The probability of getting any real number except an integer between ",
 Cell[BoxData[
  StyleBox["min", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["max", "TI"]], "InlineFormula"],
 " is zero:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->1627],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"DiscreteUniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"min", ",", "max"}], "}"}], "]"}], ",", 
   RowBox[{"3", "/", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17831],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->58998446]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12012],

Cell["Moments can be obtained from the characteristic function:", \
"ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->3912],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ev", "=", 
  RowBox[{"ExpectedValue", "[", 
   RowBox[{
    RowBox[{"k", "^", "3"}], ",", 
    RowBox[{"DiscreteUniformDistribution", "[", 
     RowBox[{"{", 
      RowBox[{"min", ",", "max"}], "}"}], "]"}], ",", "k"}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->8922],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{"max", "+", "min"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"max", "+", 
    SuperscriptBox["max", "2"], "-", "min", "+", 
    SuperscriptBox["min", "2"]}], ")"}]}]], "Output",
 ImageSize->{234, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->413672999]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cf", "=", 
  RowBox[{"CharacteristicFunction", "[", 
   RowBox[{
    RowBox[{"DiscreteUniformDistribution", "[", 
     RowBox[{"{", 
      RowBox[{"min", ",", "max"}], "}"}], "]"}], ",", "t"}], "]"}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->464069605],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"\[ImaginaryI]", " ", "min", " ", "t"}]]}], "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", "t"}], "+", 
     RowBox[{"\[ImaginaryI]", " ", "max", " ", "t"}]}]]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "t"}]]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "max", "-", "min"}], ")"}]}]]], "Output",
 ImageSize->{161, 41},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->172983664]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Limit", "[", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"cf", ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "3"}], "}"}]}], "]"}], ",", 
    RowBox[{"t", "\[Rule]", "0"}]}], "]"}], "/", 
  RowBox[{"I", "^", "3"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->22174],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    SuperscriptBox["max", "3"], "+", 
    RowBox[{"max", " ", 
     SuperscriptBox["min", "2"]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "min"}], ")"}], " ", 
     SuperscriptBox["min", "2"]}], "+", 
    RowBox[{
     SuperscriptBox["max", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "min"}], ")"}]}]}], ")"}]}]], "Output",
 ImageSize->{323, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->678989733]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ev", "\[Equal]", "%"}], "//", "Simplify"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->314510727],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->121704678]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45709179],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DiscreteUniformDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiscreteUniformDistribution"]], "InlineFormula"],
 " is the discrete analog of ",
 Cell[BoxData[
  ButtonBox["UniformDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UniformDistribution"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->109559857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"DiscreteUniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"min", ",", "max"}], "}"}], "]"}], ",", "k"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3178766],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", "max", "-", "min"}]]], "Output",
 ImageSize->{83, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->603832804]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"UniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"min", ",", "max"}], "}"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->114635251],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytVUtOAzEMTfNp2nKAlgVShZC4A12xgRUHQGLBqEJqhSpQ6R1Y9UxztJCP
HTzGSAzTSJPEjuf5xXaSh+awedk1h+26Wd7vm/fNdv2xvHvbR5UZKaWO8Zsv
VJyHOMvfMYQ4mtibKH5WSSUx5KYmqRsXmfY2DspVsUzU+BfrBFigS9PMy2Mv
3wbANCDZ6rprmr24igfue/h2DLBYWYqYOHjRdqh3TWKWek12TDjA1rO1pfmg
0XkSvcgZv2Lyc49/ixaZruLoWeYNqZvSECKRd7CI3DXIqPeg92RdV5+UyUrM
iWVWco6mzMr+iPhMsuhTAR00I+4gV6Bp2xbidJnDF2VYPxuwQw+xwzqbhv6V
jCfQipVwM4AdVsCMsEKW8pm0J+RTa4roHWHSzd0k/PMOECqAc56HUvkXoXuD
IlN6D9IzxquT3pU1jmyd46NOs3+1yPScya9/srpm8u0JsWWrBexiV1e/X77y
GqrRF7hRePA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{141, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->230768389]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[Cell[BoxData[
   InterpretationBox[Cell[TextData[{
     "Possible Issues",
     "\[NonBreakingSpace]\[NonBreakingSpace]",
     Cell["(2)", "ExampleCount"]
    }], "ExampleSection"],
    $Line = 0; Null]]]], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4654],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DiscreteUniformDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DiscreteUniformDistribution"]], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["min", "TI"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  StyleBox["max", "TI"]], "InlineFormula"],
 " is not an integer:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->28540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"DiscreteUniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2.5"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31597],

Cell[BoxData[
 RowBox[{
  RowBox[{"DiscreteUniformDistribution", "::", "\<\"intparm\"\>"}], ":", 
  " ", "\<\"The value \\!\\(2.5`\\) is expected to be an integer.\"\>"}]], \
"Message", "MSG",
 CellID->231212777],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"DiscreteUniformDistribution", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "2.5`"}], "}"}], "]"}], "]"}]], "Output",
 ImageSize->{303, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->407636319]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19046],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"DiscreteUniformDistribution", "[", 
    RowBox[{"{", 
     RowBox[{"min", ",", "max"}], "}"}], "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"min", "->", 
     RowBox[{"3", "+", "I"}]}], ",", 
    RowBox[{"max", "\[Rule]", "2"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25838],

Cell[BoxData[
 RowBox[{
  FractionBox["5", "2"], "+", 
  FractionBox["\[ImaginaryI]", "2"]}]], "Output",
 ImageSize->{40, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->108250741]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->24296],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["UniformDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UniformDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RandomInteger",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RandomInteger"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23714]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11430],

Cell[TextData[ButtonBox["Discrete Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DiscreteDistributions"]], "Tutorials",
 CellID->4738]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Discrete Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DiscreteStatisticalDistributions"]], "MoreAbout",
 CellID->172174221]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DiscreteUniformDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 27.6958474}", "context" -> "System`", 
    "keywords" -> {
     "discrete rectangular distribution", "rectangular distribution"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "DiscreteUniformDistribution[{i_min, i_max}] represents a discrete \
uniform distribution over the integers from i_min to i_max.", 
    "synonyms" -> {"discrete uniform distribution"}, "title" -> 
    "DiscreteUniformDistribution", "type" -> "Symbol", "uri" -> 
    "ref/DiscreteUniformDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7859, 256, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->143711865]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 32991, 1176}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1969, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2592, 78, 1592, 37, 70, "ObjectNameGrid"],
Cell[4187, 117, 1011, 33, 70, "Usage",
 CellID->19787]
}, Open  ]],
Cell[CellGroupData[{
Cell[5235, 155, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5713, 172, 579, 19, 70, "Notes",
 CellID->429991538],
Cell[6295, 193, 802, 30, 70, "Notes",
 CellID->10777],
Cell[7100, 225, 722, 26, 70, "Notes",
 CellID->33143606]
}, Closed]],
Cell[CellGroupData[{
Cell[7859, 256, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->143711865],
Cell[CellGroupData[{
Cell[8244, 270, 147, 5, 70, "ExampleSection",
 CellID->40923890],
Cell[8394, 277, 277, 6, 70, "ExampleText",
 CellID->15726],
Cell[CellGroupData[{
Cell[8696, 287, 202, 6, 28, "Input",
 CellID->2922],
Cell[8901, 295, 205, 7, 51, "Output",
 CellID->346791856]
}, Open  ]],
Cell[CellGroupData[{
Cell[9143, 307, 207, 6, 28, "Input",
 CellID->23529],
Cell[9353, 315, 365, 14, 51, "Output",
 CellID->496037825]
}, Open  ]],
Cell[9733, 332, 121, 3, 70, "ExampleDelimiter",
 CellID->23627],
Cell[9857, 337, 252, 6, 70, "ExampleText",
 CellID->9425],
Cell[CellGroupData[{
Cell[10134, 347, 276, 8, 70, "Input",
 CellID->19900],
Cell[10413, 357, 215, 7, 51, "Output",
 CellID->194709908]
}, Open  ]],
Cell[CellGroupData[{
Cell[10665, 369, 457, 14, 70, "Input",
 CellID->7975],
Cell[11125, 385, 1170, 27, 165, "Output",
 CellID->711637457]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12344, 418, 216, 7, 70, "ExampleSection",
 CellID->21413],
Cell[12563, 427, 269, 8, 70, "ExampleText",
 CellID->19096],
Cell[CellGroupData[{
Cell[12857, 439, 236, 7, 70, "Input",
 CellID->17016],
Cell[13096, 448, 293, 9, 36, "Output",
 CellID->481140741]
}, Open  ]],
Cell[13404, 460, 121, 3, 70, "ExampleDelimiter",
 CellID->26905],
Cell[13528, 465, 99, 3, 70, "ExampleText",
 CellID->20699375],
Cell[CellGroupData[{
Cell[13652, 472, 206, 6, 70, "Input",
 CellID->7251],
Cell[13861, 480, 156, 5, 36, "Output",
 CellID->6843592]
}, Open  ]],
Cell[CellGroupData[{
Cell[14054, 490, 207, 6, 70, "Input",
 CellID->27703],
Cell[14264, 498, 423, 16, 55, "Output",
 CellID->340273580]
}, Open  ]],
Cell[14702, 517, 121, 3, 70, "ExampleDelimiter",
 CellID->17262],
Cell[14826, 522, 225, 5, 70, "ExampleText",
 CellID->18534],
Cell[CellGroupData[{
Cell[15076, 531, 272, 8, 70, "Input",
 CellID->29831],
Cell[15351, 541, 430, 14, 51, "Output",
 CellID->279730606]
}, Open  ]],
Cell[15796, 558, 119, 3, 70, "ExampleDelimiter",
 CellID->113],
Cell[15918, 563, 314, 10, 70, "ExampleText",
 CellID->48521834],
Cell[CellGroupData[{
Cell[16257, 577, 230, 7, 70, "Input",
 CellID->4591],
Cell[16490, 586, 159, 5, 36, "Output",
 CellID->182214005]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16698, 597, 222, 7, 70, "ExampleSection",
 CellID->7790],
Cell[16923, 606, 263, 8, 70, "ExampleText",
 CellID->13370],
Cell[CellGroupData[{
Cell[17211, 618, 348, 11, 70, "Input",
 CellID->26124],
Cell[17562, 631, 1494, 29, 70, "Output",
 Evaluatable->False,
 CellID->464312253]
}, Open  ]],
Cell[19071, 663, 125, 3, 70, "ExampleDelimiter",
 CellID->462148167],
Cell[19199, 668, 291, 8, 70, "ExampleText",
 CellID->24052],
Cell[CellGroupData[{
Cell[19515, 680, 468, 14, 70, "Input",
 CellID->28041],
Cell[19986, 696, 550, 13, 70, "Output",
 Evaluatable->False,
 CellID->441170705]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20585, 715, 233, 7, 70, "ExampleSection",
 CellID->23946],
Cell[20821, 724, 401, 13, 70, "ExampleText",
 CellID->1627],
Cell[CellGroupData[{
Cell[21247, 741, 252, 8, 70, "Input",
 CellID->17831],
Cell[21502, 751, 157, 5, 36, "Output",
 CellID->58998446]
}, Open  ]],
Cell[21674, 759, 121, 3, 70, "ExampleDelimiter",
 CellID->12012],
Cell[21798, 764, 234, 6, 70, "ExampleText",
 CellID->3912],
Cell[CellGroupData[{
Cell[22057, 774, 302, 10, 70, "Input",
 CellID->8922],
Cell[22362, 786, 390, 13, 51, "Output",
 CellID->413672999]
}, Open  ]],
Cell[CellGroupData[{
Cell[22789, 804, 281, 9, 70, "Input",
 CellID->464069605],
Cell[23073, 815, 699, 22, 62, "Output",
 CellID->172983664]
}, Open  ]],
Cell[CellGroupData[{
Cell[23809, 842, 310, 11, 70, "Input",
 CellID->22174],
Cell[24122, 855, 594, 21, 51, "Output",
 CellID->678989733]
}, Open  ]],
Cell[CellGroupData[{
Cell[24753, 881, 131, 4, 70, "Input",
 CellID->314510727],
Cell[24887, 887, 161, 5, 36, "Output",
 CellID->121704678]
}, Open  ]],
Cell[25063, 895, 124, 3, 70, "ExampleDelimiter",
 CellID->45709179],
Cell[25190, 900, 526, 16, 70, "ExampleText",
 CellID->109559857],
Cell[CellGroupData[{
Cell[25741, 920, 230, 7, 70, "Input",
 CellID->3178766],
Cell[25974, 929, 215, 7, 51, "Output",
 CellID->603832804]
}, Open  ]],
Cell[CellGroupData[{
Cell[26226, 941, 224, 7, 70, "Input",
 CellID->114635251],
Cell[26453, 950, 712, 16, 70, "Output",
 Evaluatable->False,
 CellID->230768389]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27214, 972, 326, 9, 70, "ExampleSection",
 CellID->4654],
Cell[27543, 983, 520, 17, 70, "ExampleText",
 CellID->28540],
Cell[CellGroupData[{
Cell[28088, 1004, 201, 6, 70, "Input",
 CellID->31597],
Cell[28292, 1012, 212, 5, 70, "Message",
 CellID->231212777],
Cell[28507, 1019, 295, 9, 36, "Output",
 CellID->407636319]
}, Open  ]],
Cell[28817, 1031, 121, 3, 70, "ExampleDelimiter",
 CellID->19046],
Cell[28941, 1036, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[29247, 1048, 364, 12, 70, "Input",
 CellID->25838],
Cell[29614, 1062, 234, 8, 51, "Output",
 CellID->108250741]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[29909, 1077, 311, 9, 70, "SeeAlsoSection",
 CellID->24296],
Cell[30223, 1088, 483, 17, 70, "SeeAlso",
 CellID->23714]
}, Open  ]],
Cell[CellGroupData[{
Cell[30743, 1110, 314, 9, 70, "TutorialsSection",
 CellID->11430],
Cell[31060, 1121, 153, 3, 70, "Tutorials",
 CellID->4738]
}, Open  ]],
Cell[CellGroupData[{
Cell[31250, 1129, 299, 8, 70, "MoreAboutSection"],
Cell[31552, 1139, 178, 3, 70, "MoreAbout",
 CellID->172174221]
}, Open  ]],
Cell[31745, 1145, 27, 0, 70, "History"],
Cell[31775, 1147, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

