(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    169503,       4728]
NotebookOptionsPosition[    155634,       4251]
NotebookOutlinePosition[    157237,       4293]
CellTagsIndexPosition[    157150,       4288]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Circle" :> Documentation`HelpLookup["paclet:ref/Circle"], 
          "Polygon" :> Documentation`HelpLookup["paclet:ref/Polygon"], 
          "Rotate" :> Documentation`HelpLookup["paclet:ref/Rotate"], 
          "PlotRangeClipping" :> 
          Documentation`HelpLookup["paclet:ref/PlotRangeClipping"], 
          "PointSize" :> Documentation`HelpLookup["paclet:ref/PointSize"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Circle\"\>", 
       2->"\<\"Polygon\"\>", 3->"\<\"Rotate\"\>", 
       4->"\<\"PlotRangeClipping\"\>", 
       5->"\<\"PointSize\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Objects" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsObjects"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "New in 6.0: Graphics Primitives & Directives" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Graphics Objects\"\>", 
       2->"\<\"Symbolic Graphics Language\"\>", 
       3->"\<\"New in 6.0: Graphics Primitives & Directives\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Disk", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Disk",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Disk"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"]}], "}"}], ",", 
        StyleBox["r", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a two\[Hyphen]dimensional graphics primitive that \
represents a filled disk of radius ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " centered at the point ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Disk",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Disk"], "[", 
       RowBox[{"{", 
        RowBox[{
         StyleBox["x", "TI"], ",", 
         StyleBox["y", "TI"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a disk of radius 1. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Disk",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Disk"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"]}], "}"}], ",", 
        StyleBox["r", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox["\[Theta]", 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox["\[Theta]", 
           StyleBox["2", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a segment of a disk. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Disk",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Disk"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          StyleBox["y", "TI"]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["r", "TI"], 
           StyleBox["x", "TI"]], ",", 
          SubscriptBox[
           StyleBox["r", "TI"], 
           StyleBox["y", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives an elliptical disk with semi\[Hyphen]axes of \
lengths ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["x", "TI"]]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["y", "TI"]]], "InlineFormula"],
     ", oriented parallel to the coordinate axes. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->27866]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Angles are measured in radians counterclockwise from the positive ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " direction. "
}], "Notes",
 CellID->7418],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Disk",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Disk"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["y", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Theta]", 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox["\[Theta]", 
       StyleBox["2", "TR"]]}], "}"}]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " yields an elliptical disk segment obtained by transforming a circular disk \
segment with the specified starting and ending angles. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->16979],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["dr", "TI"], 
      StyleBox["x", "TI"]], ",", 
     SubscriptBox[
      StyleBox["dr", "TI"], 
      StyleBox["y", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["dr", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["dr", "TI"], 
       StyleBox["y", "TI"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["x", "TI"]], ",", 
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["y", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
 " can be used in the radius specification. The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["dr", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are in scaled coordinates, and the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " are in ordinary coordinates. "
}], "Notes",
 CellID->18443],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Disk",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Disk"], "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"]}], "}"}], ",", 
    RowBox[{
     ButtonBox["Scaled",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Scaled"], "[", 
     StyleBox["s", "TI"], "]"}]}], "]"}]], "InlineFormula"],
 " gives a disk of scaled radius ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->20676],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Offset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Offset"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["x", "TI"]], ",", 
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["y", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
 " can be used to specify radii in printer\[CloseCurlyQuote]s points. "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->14183],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FaceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 " can be used to specify how the interiors and boundaries of disks should be \
rendered. The default is that no explicit edge is drawn."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->21960],

Cell[TextData[{
 "Individual coordinates, lists of coordinates, and parameters in disks can \
be ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " objects. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->17852],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Disk",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Disk"], "[", "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Disk",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Disk"], "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->3781]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->497889714],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->146956760],

Cell["A unit disk:", "ExampleText",
 CellID->64135791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Disk", "[", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12902770],

Cell[BoxData[
 GraphicsBox[DiskBox[{0, 0}]]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->62383137]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->110273157],

Cell["A disk segment:", "ExampleText",
 CellID->77089960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Orange", ",", 
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "1", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Pi", "/", "4"}], ",", 
        RowBox[{"3", 
         RowBox[{"Pi", "/", "4"}]}]}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69305470],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0], 
   DiskBox[{0, 0}, 1, 
    NCache[{Rational[1, 4] Pi, Rational[3, 4] Pi}, {0.7853981633974483, 
     2.356194490192345}]]}]], "Output",
 ImageSize->{104, 72},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->62304270]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->227143818],

Cell["An elliptical disk:", "ExampleText",
 CellID->16193628],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Orange", ",", 
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->558999048],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0], DiskBox[{0, 0}, {3., 4.}]}]], "Output",
 ImageSize->{104, 132},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->225729427]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->517700974],

Cell["Differently styled unit disks:", "ExampleText",
 CellID->217517280],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"Pink", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "Thick", "]"}], ",", "Pink", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "Dashed", "]"}], ",", "Pink", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Directive", "[", 
        RowBox[{"Thick", ",", "Dashed", ",", "Blue"}], "]"}], "]"}], ",", 
      "Pink", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17828104],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Thickness[Large]], DiskBox[{0, 0}]}], 
   ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[Dashing[{Small, Small}]], 
     DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[1, 0.5, 0.5], EdgeForm[{RGBColor[0, 0, 1], Thickness[Large], 
     Dashing[{Small, Small}]}], DiskBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->258457316]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(10)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->46074458],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Disk Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->702892053],

Cell["Specify radii:", "ExampleText",
 CellID->137796048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Red", ",", 
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "5"}], "]"}], ",", "Green", ",", 
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "3"}], "]"}], ",", "Blue", ",", 
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11794488],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], DiskBox[{0, 0}, 5]}, 
   {RGBColor[0, 1, 0], DiskBox[{0, 0}, 3]}, 
   {RGBColor[0, 0, 1], DiskBox[{0, 0}]}}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->241085763]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->326926988],

Cell["Specify centers:", "ExampleText",
 CellID->144729799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Red", ",", 
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "1"}], "]"}], ",", "Green", ",", 
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "1"}], "}"}], ",", "1"}], "]"}], ",", "Blue", ",", 
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}], ",", "1"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->392018628],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], DiskBox[{0, 0}]}, 
   {RGBColor[0, 1, 0], DiskBox[{1, 1}]}, 
   {RGBColor[0, 0, 1], DiskBox[{2, 2}]}}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->275106943]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->527872799],

Cell["A disk segment:", "ExampleText",
 CellID->62479769],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Disk", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", "1", ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"4", 
       RowBox[{"Pi", "/", "3"}]}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->131804889],

Cell[BoxData[
 GraphicsBox[
  DiskBox[{0, 0}, 1, 
   NCache[{0, Rational[4, 3] Pi}, {0, 4.1887902047863905`}]]]], "Output",
 ImageSize->{104, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->133807002]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Disk", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", "1", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"4", 
       RowBox[{"Pi", "/", "3"}]}], ",", 
      RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->236584046],

Cell[BoxData[
 GraphicsBox[
  DiskBox[{0, 0}, 1, 
   NCache[{Rational[4, 3] Pi, 2 Pi}, {4.1887902047863905`, 
    6.283185307179586}]]]], "Output",
 ImageSize->{104, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->32529545]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->844545353],

Cell["An elliptical disk:", "ExampleText",
 CellID->913725950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Disk", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->307994183],

Cell[BoxData[
 GraphicsBox[DiskBox[{0, 0}, {3., 2.}]]], "Output",
 ImageSize->{104, 68},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->965666160]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->441377968],

Cell[TextData[{
 "An elliptical disk segment: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->16979,
  ButtonNote->"16979"]
}], "ExampleText",
 CellID->6262908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Disk", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"4", 
       RowBox[{"Pi", "/", "3"}]}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21126177],

Cell[BoxData[
 GraphicsBox[
  DiskBox[{0, 0}, {3., 2.}, 
   NCache[{0, Rational[4, 3] Pi}, {0, 4.1887902047863905`}]]]], "Output",
 ImageSize->{104, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->486555717]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->173614351],

Cell[TextData[{
 "Short form for a unit disk at the origin: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->3781,
  ButtonNote->"3781"]
}], "ExampleText",
 CellID->205502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Disk", "[", "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->122989917],

Cell[BoxData[
 GraphicsBox[DiskBox[{0, 0}],
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->175048798]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Disk Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->456816427],

Cell["Color directives specify the face colors of disks:", "ExampleText",
 CellID->164074182],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{"c", ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Red", ",", "Green", ",", "Blue", ",", "Yellow"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->808748643],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {RGBColor[1, 0, 0], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 1, 0], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[0, 0, 1], DiskBox[{0, 0}]}], ",", 
   GraphicsBox[
    {RGBColor[1, 1, 0], DiskBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->190749985]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->131492187],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FaceForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["EdgeForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/EdgeForm"]], "InlineFormula"],
 " can be used to specify the styles of the interiors and boundaries: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->21960,
  ButtonNote->"21960"]
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->468986790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"FaceForm", "[", "Pink", "]"}], ",", 
    RowBox[{"EdgeForm", "[", 
     RowBox[{"Directive", "[", 
      RowBox[{"Dashed", ",", "Thick", ",", "Blue"}], "]"}], "]"}], ",", 
    RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->579367583],

Cell[BoxData[
 GraphicsBox[
  {EdgeForm[{RGBColor[0, 0, 1], Thickness[Large], Dashing[{Small, Small}]}], 
   FaceForm[RGBColor[1, 0.5, 0.5]], DiskBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->29034320]
}, Open  ]],

Cell["Boundaries of an elliptical disk segment:", "ExampleText",
 CellID->734333566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{"Yellow", ",", 
    RowBox[{"EdgeForm", "[", 
     RowBox[{"Directive", "[", 
      RowBox[{"Thick", ",", "Blue"}], "]"}], "]"}], ",", 
    RowBox[{"Disk", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"4", 
         RowBox[{"Pi", "/", "3"}]}]}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5508369],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 1, 0], EdgeForm[{RGBColor[0, 0, 1], Thickness[Large]}], 
   DiskBox[{0, 0}, {3., 2.}, 
    NCache[{0, Rational[4, 3] Pi}, {0, 4.1887902047863905`}]]}]], "Output",
 ImageSize->{104, 64},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->12468923]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Coordinate and Radii Specification",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->441259165],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " coordinates and radii: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->20676,
  ButtonNote->"20676"]
}], "ExampleText",
 CellID->19804318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Disk", "[", 
    RowBox[{
     RowBox[{"Scaled", "[", 
      RowBox[{"{", 
       RowBox[{".2", ",", ".2"}], "}"}], "]"}], ",", ".2"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73519992],

Cell[BoxData[
 GraphicsBox[DiskBox[Scaled[{0.2, 0.2}], 0.2],
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->751911117]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Disk", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"Scaled", "[", ".25", "]"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->61585090],

Cell[BoxData[
 GraphicsBox[DiskBox[{0, 0}, Scaled[0.25]],
  Frame->True]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->275819490]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Disk", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"Scaled", "[", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".25"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->518233082],

Cell[BoxData[
 GraphicsBox[DiskBox[{0, 0}, Scaled[{0.5, 0.25}]],
  Frame->True]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[3]=",
 CellID->98046726]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20096378],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " coordinates and radii:"
}], "ExampleText",
 CellID->347843897],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Disk", "[", 
    RowBox[{
     RowBox[{"ImageScaled", "[", 
      RowBox[{"{", 
       RowBox[{".2", ",", ".2"}], "}"}], "]"}], ",", ".2"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->769181745],

Cell[BoxData[
 GraphicsBox[DiskBox[ImageScaled[{0.2, 0.2}], 0.2],
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->58050623]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Disk", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"ImageScaled", "[", 
      RowBox[{"{", 
       RowBox[{".5", ",", ".25"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->399448777],

Cell[BoxData[
 GraphicsBox[DiskBox[{0, 0}, ImageScaled[{0.5, 0.25}]],
  Frame->True]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->268890056]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->264086837],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 " coordinates:"
}], "ExampleText",
 CellID->11628004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Disk", "[", 
    RowBox[{
     RowBox[{"Offset", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "10"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", ".5"}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->690732740],

Cell[BoxData[
 GraphicsBox[DiskBox[Offset[{10, 10}, {0, 0}], 0.5],
  Frame->True]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->751632404]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->233279087],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 " to specify the radii in printer's points: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->14183]
}], "ExampleText",
 CellID->236972502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Disk", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"Offset", "[", 
      RowBox[{"{", 
       RowBox[{"10", ",", "40"}], "}"}], "]"}]}], "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->225944801],

Cell[BoxData[
 GraphicsBox[DiskBox[{0, 0}, Offset[{10., 40.}, {0., 0.}]],
  Frame->True]], "Output",
 ImageSize->{154, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->504171559]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27626],

Cell[TextData[{
 "Use a ",
 Cell[BoxData[
  ButtonBox["Disk",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Disk"]], "InlineFormula"],
 " to annotate a plot of trig function: "
}], "ExampleText",
 CellID->35739729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"4", "Pi"}]}], "}"}], ",", 
   RowBox[{"Epilog", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Opacity", "[", "0.5", "]"}], ",", 
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Opacity", "[", ".7", "]"}], "]"}], ",", "Red", ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Disk", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"x", ",", 
            RowBox[{"Sin", "[", "x", "]"}]}], "}"}], ",", 
          RowBox[{"Offset", "[", 
           RowBox[{"{", 
            RowBox[{"8", ",", "8"}], "}"}], "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", 
            RowBox[{"Mod", "[", 
             RowBox[{"x", ",", 
              RowBox[{"2", "Pi"}]}], "]"}]}], "}"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"x", ",", "0", ",", 
          RowBox[{"4", "Pi"}], ",", 
          RowBox[{"Pi", "/", "2"}]}], "}"}]}], "]"}]}], "}"}]}], ",", 
   RowBox[{"PlotRangePadding", "\[Rule]", ".2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4648924],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 127},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->426246115]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->213968444],

Cell["Make a pie chart: ", "ExampleText",
 CellID->287045242],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"Reverse", "[", 
    RowBox[{"Sort", "[", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"1", ",", "5"}], "]"}], "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->297659809],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "=", "0"}], ",", 
     RowBox[{"len", "=", 
      RowBox[{"Length", "[", "data", "]"}]}], ",", 
     RowBox[{"sum", "=", 
      RowBox[{"Total", "[", "data", "]"}]}]}], "}"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Hue", "[", 
         RowBox[{"i", "/", "len"}], "]"}], ",", 
        RowBox[{"EdgeForm", "[", 
         RowBox[{"Opacity", "[", ".8", "]"}], "]"}], ",", 
        RowBox[{"Disk", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "1", ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", 
            RowBox[{"t", "+=", 
             RowBox[{"2", " ", "Pi", " ", 
              RowBox[{
               RowBox[{"data", "[", 
                RowBox[{"[", "i", "]"}], "]"}], "/", "sum"}]}]}]}], "}"}]}], 
         "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "len"}], "}"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->74492583],

Cell[BoxData[
 GraphicsBox[{
   {Hue[
     NCache[
      Rational[1, 5], 0.2]], EdgeForm[Opacity[0.8]], 
    DiskBox[{0, 0}, 1, {0, 2.1463113014301802`}]}, 
   {Hue[
     NCache[
      Rational[2, 5], 0.4]], EdgeForm[Opacity[0.8]], 
    DiskBox[{0, 0}, 1, {2.1463113014301802`, 3.479859068186564}]}, 
   {Hue[
     NCache[
      Rational[3, 5], 0.6]], EdgeForm[Opacity[0.8]], 
    DiskBox[{0, 0}, 1, {3.479859068186564, 4.549049396067129}]}, 
   {Hue[
     NCache[
      Rational[4, 5], 0.8]], EdgeForm[Opacity[0.8]], 
    DiskBox[{0, 0}, 1, {4.549049396067129, 5.532464795458581}]}, 
   {Hue[1], EdgeForm[Opacity[0.8]], 
    DiskBox[{0, 0}, 1, {5.532464795458581, 6.283185307179586}]}}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->141907814]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->767995213],

Cell["Archimedes' approximation of the circle area:", "ExampleText",
 CellID->225545640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Opacity", "[", ".8", "]"}], "]"}], ",", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Hue", "[", 
           RowBox[{
            RowBox[{"i", "/", "n"}], ",", ".5"}], "]"}], ",", 
          RowBox[{"Disk", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"i", " ", 
               RowBox[{"Sin", "[", 
                RowBox[{"Pi", "/", "n"}], " ", "]"}]}], ",", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}], "^", 
                  RowBox[{"(", 
                   RowBox[{"i", "+", "1"}], ")"}]}], "+", "1"}], ")"}], 
               RowBox[{
                RowBox[{"Cos", "[", 
                 RowBox[{"Pi", "/", "n"}], "]"}], "/", "2"}]}]}], "}"}], ",", 
            "1", ",", 
            RowBox[{"Pi", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}], "^", "i"}], "/", "2"}], "-", 
                RowBox[{"1", "/", "n"}]}], ",", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"-", "1"}], ")"}], "^", "i"}], "/", "2"}], "+", 
                RowBox[{"1", "/", "n"}]}]}], "}"}]}]}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "4", ",", "12"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->203772782],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    {EdgeForm[Opacity[0.8]], 
     {Hue[
       NCache[
        Rational[1, 4], 0.25], 0.5], 
      DiskBox[NCache[{2^Rational[-1, 2], 2^Rational[-1, 2]}, {
        0.7071067811865475, 0.7071067811865475}], 1, 
       NCache[{Rational[-3, 4] Pi, Rational[-1, 4] 
         Pi}, {-2.356194490192345, -0.7853981633974483}]]}, 
     {Hue[
       NCache[
        Rational[1, 2], 0.5], 0.5], 
      DiskBox[NCache[{2^Rational[1, 2], 0}, {1.4142135623730951`, 0}], 1, 
       NCache[{Rational[1, 4] Pi, Rational[3, 4] Pi}, {0.7853981633974483, 
        2.356194490192345}]]}, 
     {Hue[
       NCache[
        Rational[3, 4], 0.75], 0.5], 
      DiskBox[NCache[{3 2^Rational[-1, 2], 2^Rational[-1, 2]}, {
        2.1213203435596424`, 0.7071067811865475}], 1, 
       NCache[{Rational[-3, 4] Pi, Rational[-1, 4] 
         Pi}, {-2.356194490192345, -0.7853981633974483}]]}, 
     {Hue[1, 0.5], 
      DiskBox[NCache[{2 2^Rational[1, 2], 0}, {2.8284271247461903`, 0}], 1, 
       NCache[{Rational[1, 4] Pi, Rational[3, 4] Pi}, {0.7853981633974483, 
        2.356194490192345}]]}}], ",", 
   GraphicsBox[
    {EdgeForm[Opacity[0.8]], 
     {Hue[
       NCache[
        Rational[1, 5], 0.2], 0.5], 
      DiskBox[NCache[{(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
         Rational[1, 2], Rational[1, 4] (1 + 5^Rational[1, 2])}, {
        0.5877852522924731, 0.8090169943749475}], 1, 
       NCache[{Rational[-7, 10] Pi, Rational[-3, 10] 
         Pi}, {-2.199114857512855, -0.9424777960769379}]]}, 
     {Hue[
       NCache[
        Rational[2, 5], 0.4], 0.5], 
      DiskBox[NCache[{
        2 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         0}, {1.1755705045849463`, 0}], 1, 
       NCache[{Rational[3, 10] Pi, Rational[7, 10] Pi}, {0.9424777960769379, 
        2.199114857512855}]]}, 
     {Hue[
       NCache[
        Rational[3, 5], 0.6], 0.5], 
      DiskBox[NCache[{
        3 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (1 + 5^Rational[1, 2])}, {1.7633557568774194`, 
        0.8090169943749475}], 1, 
       NCache[{Rational[-7, 10] Pi, Rational[-3, 10] 
         Pi}, {-2.199114857512855, -0.9424777960769379}]]}, 
     {Hue[
       NCache[
        Rational[4, 5], 0.8], 0.5], 
      DiskBox[NCache[{
        4 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         0}, {2.3511410091698925`, 0}], 1, 
       NCache[{Rational[3, 10] Pi, Rational[7, 10] Pi}, {0.9424777960769379, 
        2.199114857512855}]]}, 
     {Hue[1, 0.5], 
      DiskBox[NCache[{
        5 (Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^Rational[1, 2], 
         Rational[1, 4] (1 + 5^Rational[1, 2])}, {2.938926261462366, 
        0.8090169943749475}], 1, 
       NCache[{Rational[-7, 10] Pi, Rational[-3, 10] 
         Pi}, {-2.199114857512855, -0.9424777960769379}]]}}], ",", 
   GraphicsBox[
    {EdgeForm[Opacity[0.8]], 
     {Hue[
       NCache[
        Rational[1, 6], 0.16666666666666666`], 0.5], 
      DiskBox[NCache[{Rational[1, 2], Rational[1, 2] 3^Rational[1, 2]}, {0.5, 
        0.8660254037844386}], 1, 
       NCache[{Rational[-2, 3] Pi, Rational[-1, 3] 
         Pi}, {-2.0943951023931953`, -1.0471975511965976`}]]}, 
     {Hue[
       NCache[
        Rational[1, 3], 0.3333333333333333], 0.5], 
      DiskBox[{1, 0}, 1, 
       NCache[{Rational[1, 3] Pi, Rational[2, 3] Pi}, {1.0471975511965976`, 
        2.0943951023931953`}]]}, 
     {Hue[
       NCache[
        Rational[1, 2], 0.5], 0.5], 
      DiskBox[NCache[{Rational[3, 2], Rational[1, 2] 3^Rational[1, 2]}, {1.5, 
        0.8660254037844386}], 1, 
       NCache[{Rational[-2, 3] Pi, Rational[-1, 3] 
         Pi}, {-2.0943951023931953`, -1.0471975511965976`}]]}, 
     {Hue[
       NCache[
        Rational[2, 3], 0.6666666666666666], 0.5], 
      DiskBox[{2, 0}, 1, 
       NCache[{Rational[1, 3] Pi, Rational[2, 3] Pi}, {1.0471975511965976`, 
        2.0943951023931953`}]]}, 
     {Hue[
       NCache[
        Rational[5, 6], 0.8333333333333334], 0.5], 
      DiskBox[NCache[{Rational[5, 2], Rational[1, 2] 3^Rational[1, 2]}, {2.5, 
        0.8660254037844386}], 1, 
       NCache[{
        Rational[-2, 3] Pi, Rational[-1, 3] 
         Pi}, {-2.0943951023931953`, -1.0471975511965976`}]]}, 
     {Hue[1, 0.5], 
      DiskBox[{3, 0}, 1, 
       NCache[{Rational[1, 3] Pi, Rational[2, 3] Pi}, {1.0471975511965976`, 
        2.0943951023931953`}]]}}], ",", 
   GraphicsBox[
    {EdgeForm[Opacity[0.8]], 
     {Hue[
       NCache[
        Rational[1, 7], 0.14285714285714285`], 0.5], 
      DiskBox[NCache[{Sin[Rational[1, 7] Pi], Cos[Rational[1, 7] Pi]}, {
        0.4338837391175581, 0.9009688679024191}], 1, 
       NCache[{Rational[-9, 14] Pi, Rational[-5, 14] 
         Pi}, {-2.019595277307724, -1.121997376282069}]]}, 
     {Hue[
       NCache[
        Rational[2, 7], 0.2857142857142857], 0.5], 
      DiskBox[NCache[{2 Sin[Rational[1, 7] Pi], 0}, {0.8677674782351162, 0}], 
       1, NCache[{Rational[5, 14] Pi, Rational[9, 14] Pi}, {1.121997376282069,
         2.019595277307724}]]}, 
     {Hue[
       NCache[
        Rational[3, 7], 0.42857142857142855`], 0.5], 
      DiskBox[NCache[{3 Sin[Rational[1, 7] Pi], Cos[Rational[1, 7] Pi]}, {
        1.3016512173526744`, 0.9009688679024191}], 1, 
       NCache[{Rational[-9, 14] Pi, Rational[-5, 14] 
         Pi}, {-2.019595277307724, -1.121997376282069}]]}, 
     {Hue[
       NCache[
        Rational[4, 7], 0.5714285714285714], 0.5], 
      DiskBox[NCache[{4 Sin[Rational[1, 7] Pi], 0}, {1.7355349564702325`, 0}],
        1, NCache[{Rational[5, 14] Pi, Rational[9, 14] Pi}, {
        1.121997376282069, 2.019595277307724}]]}, 
     {Hue[
       NCache[
        Rational[5, 7], 0.7142857142857143], 0.5], 
      DiskBox[NCache[{5 Sin[Rational[1, 7] Pi], Cos[Rational[1, 7] Pi]}, {
        2.1694186955877908`, 0.9009688679024191}], 1, 
       NCache[{Rational[-9, 14] Pi, Rational[-5, 14] 
         Pi}, {-2.019595277307724, -1.121997376282069}]]}, 
     {Hue[
       NCache[
        Rational[6, 7], 0.8571428571428571], 0.5], 
      DiskBox[NCache[{6 Sin[Rational[1, 7] Pi], 0}, {2.603302434705349, 0}], 
       1, NCache[{Rational[5, 14] Pi, Rational[9, 14] Pi}, {1.121997376282069,
         2.019595277307724}]]}, 
     {Hue[1, 0.5], 
      DiskBox[NCache[{7 Sin[Rational[1, 7] Pi], Cos[Rational[1, 7] Pi]}, {
        3.037186173822907, 0.9009688679024191}], 1, 
       NCache[{Rational[-9, 14] Pi, Rational[-5, 14] 
         Pi}, {-2.019595277307724, -1.121997376282069}]]}}], ",", 
   GraphicsBox[
    {EdgeForm[Opacity[0.8]], 
     {Hue[
       NCache[
        Rational[1, 8], 0.125], 0.5], 
      DiskBox[NCache[{Sin[Rational[1, 8] Pi], Cos[Rational[1, 8] Pi]}, {
        0.3826834323650898, 0.9238795325112867}], 1, 
       NCache[{Rational[-5, 8] Pi, Rational[-3, 8] 
         Pi}, {-1.9634954084936207`, -1.1780972450961724`}]]}, 
     {Hue[
       NCache[
        Rational[1, 4], 0.25], 0.5], 
      DiskBox[NCache[{2 Sin[Rational[1, 8] Pi], 0}, {0.7653668647301796, 0}], 
       1, NCache[{Rational[3, 8] Pi, Rational[5, 8] Pi}, {1.1780972450961724`,
         1.9634954084936207`}]]}, 
     {Hue[
       NCache[
        Rational[3, 8], 0.375], 0.5], 
      DiskBox[NCache[{3 Sin[Rational[1, 8] Pi], Cos[Rational[1, 8] Pi]}, {
        1.1480502970952693`, 0.9238795325112867}], 1, 
       NCache[{Rational[-5, 8] Pi, Rational[-3, 8] 
         Pi}, {-1.9634954084936207`, -1.1780972450961724`}]]}, 
     {Hue[
       NCache[
        Rational[1, 2], 0.5], 0.5], 
      DiskBox[NCache[{4 Sin[Rational[1, 8] Pi], 0}, {1.5307337294603591`, 0}],
        1, NCache[{Rational[3, 8] Pi, Rational[5, 8] Pi}, {
        1.1780972450961724`, 1.9634954084936207`}]]}, 
     {Hue[
       NCache[
        Rational[5, 8], 0.625], 0.5], 
      DiskBox[NCache[{5 Sin[Rational[1, 8] Pi], Cos[Rational[1, 8] Pi]}, {
        1.913417161825449, 0.9238795325112867}], 1, 
       NCache[{Rational[-5, 8] Pi, Rational[-3, 8] 
         Pi}, {-1.9634954084936207`, -1.1780972450961724`}]]}, 
     {Hue[
       NCache[
        Rational[3, 4], 0.75], 0.5], 
      DiskBox[NCache[{6 Sin[Rational[1, 8] Pi], 0}, {2.2961005941905386`, 0}],
        1, NCache[{Rational[3, 8] Pi, Rational[5, 8] Pi}, {
        1.1780972450961724`, 1.9634954084936207`}]]}, 
     {Hue[
       NCache[
        Rational[7, 8], 0.875], 0.5], 
      DiskBox[NCache[{7 Sin[Rational[1, 8] Pi], Cos[Rational[1, 8] Pi]}, {
        2.6787840265556286`, 0.9238795325112867}], 1, 
       NCache[{Rational[-5, 8] Pi, Rational[-3, 8] 
         Pi}, {-1.9634954084936207`, -1.1780972450961724`}]]}, 
     {Hue[1, 0.5], 
      DiskBox[NCache[{8 Sin[Rational[1, 8] Pi], 0}, {3.0614674589207183`, 0}],
        1, NCache[{Rational[3, 8] Pi, Rational[5, 8] Pi}, {
        1.1780972450961724`, 1.9634954084936207`}]]}}], ",", 
   GraphicsBox[
    {EdgeForm[Opacity[0.8]], 
     {Hue[
       NCache[
        Rational[1, 9], 0.1111111111111111], 0.5], 
      DiskBox[NCache[{Sin[Rational[1, 9] Pi], Cos[Rational[1, 9] Pi]}, {
        0.3420201433256687, 0.9396926207859084}], 1, 
       NCache[{Rational[-11, 18] Pi, Rational[-7, 18] 
         Pi}, {-1.9198621771937625`, -1.2217304763960306`}]]}, 
     {Hue[
       NCache[
        Rational[2, 9], 0.2222222222222222], 0.5], 
      DiskBox[NCache[{2 Sin[Rational[1, 9] Pi], 0}, {0.6840402866513374, 0}], 
       1, NCache[{Rational[7, 18] Pi, Rational[11, 18] Pi}, {
        1.2217304763960306`, 1.9198621771937625`}]]}, 
     {Hue[
       NCache[
        Rational[1, 3], 0.3333333333333333], 0.5], 
      DiskBox[NCache[{3 Sin[Rational[1, 9] Pi], Cos[Rational[1, 9] Pi]}, {
        1.0260604299770062`, 0.9396926207859084}], 1, 
       NCache[{Rational[-11, 18] Pi, Rational[-7, 18] 
         Pi}, {-1.9198621771937625`, -1.2217304763960306`}]]}, 
     {Hue[
       NCache[
        Rational[4, 9], 0.4444444444444444], 0.5], 
      DiskBox[NCache[{4 Sin[Rational[1, 9] Pi], 0}, {1.3680805733026749`, 0}],
        1, NCache[{Rational[7, 18] Pi, Rational[11, 18] Pi}, {
        1.2217304763960306`, 1.9198621771937625`}]]}, 
     {Hue[
       NCache[
        Rational[5, 9], 0.5555555555555556], 0.5], 
      DiskBox[NCache[{5 Sin[Rational[1, 9] Pi], Cos[Rational[1, 9] Pi]}, {
        1.7101007166283435`, 0.9396926207859084}], 1, 
       NCache[{Rational[-11, 18] Pi, Rational[-7, 18] 
         Pi}, {-1.9198621771937625`, -1.2217304763960306`}]]}, 
     {Hue[
       NCache[
        Rational[2, 3], 0.6666666666666666], 0.5], 
      DiskBox[NCache[{6 Sin[Rational[1, 9] Pi], 0}, {2.0521208599540124`, 0}],
        1, NCache[{Rational[7, 18] Pi, Rational[11, 18] Pi}, {
        1.2217304763960306`, 1.9198621771937625`}]]}, 
     {Hue[
       NCache[
        Rational[7, 9], 0.7777777777777778], 0.5], 
      DiskBox[NCache[{7 Sin[Rational[1, 9] Pi], Cos[Rational[1, 9] Pi]}, {
        2.394141003279681, 0.9396926207859084}], 1, 
       NCache[{Rational[-11, 18] Pi, Rational[-7, 18] 
         Pi}, {-1.9198621771937625`, -1.2217304763960306`}]]}, 
     {Hue[
       NCache[
        Rational[8, 9], 0.8888888888888888], 0.5], 
      DiskBox[NCache[{8 Sin[Rational[1, 9] Pi], 0}, {2.7361611466053497`, 0}],
        1, NCache[{Rational[7, 18] Pi, Rational[11, 18] Pi}, {
        1.2217304763960306`, 1.9198621771937625`}]]}, 
     {Hue[1, 0.5], 
      DiskBox[NCache[{9 Sin[Rational[1, 9] Pi], Cos[Rational[1, 9] Pi]}, {
        3.0781812899310186`, 0.9396926207859084}], 1, 
       NCache[{Rational[-11, 18] Pi, Rational[-7, 18] 
         Pi}, {-1.9198621771937625`, -1.2217304763960306`}]]}}], ",", 
   GraphicsBox[
    {EdgeForm[Opacity[0.8]], 
     {Hue[
       NCache[
        Rational[1, 10], 0.1], 0.5], 
      DiskBox[NCache[{
        Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        0.30901699437494745`, 0.9510565162951535}], 1, 
       NCache[{Rational[-3, 5] Pi, Rational[-2, 5] 
         Pi}, {-1.8849555921538759`, -1.2566370614359172`}]]}, 
     {Hue[
       NCache[
        Rational[1, 5], 0.2], 0.5], 
      DiskBox[NCache[{Rational[1, 2] (-1 + 5^Rational[1, 2]), 0}, {
        0.6180339887498949, 0}], 1, 
       NCache[{Rational[2, 5] Pi, Rational[3, 5] Pi}, {1.2566370614359172`, 
        1.8849555921538759`}]]}, 
     {Hue[
       NCache[
        Rational[3, 10], 0.3], 0.5], 
      DiskBox[NCache[{
        Rational[3, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        0.9270509831248424, 0.9510565162951535}], 1, 
       NCache[{Rational[-3, 5] Pi, Rational[-2, 5] 
         Pi}, {-1.8849555921538759`, -1.2566370614359172`}]]}, 
     {Hue[
       NCache[
        Rational[2, 5], 0.4], 0.5], 
      DiskBox[NCache[{-1 + 5^Rational[1, 2], 0}, {1.2360679774997898`, 0}], 1,
        NCache[{Rational[2, 5] Pi, Rational[3, 5] Pi}, {1.2566370614359172`, 
        1.8849555921538759`}]]}, 
     {Hue[
       NCache[
        Rational[1, 2], 0.5], 0.5], 
      DiskBox[NCache[{
        Rational[5, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        1.5450849718747373`, 0.9510565162951535}], 1, 
       NCache[{Rational[-3, 5] Pi, Rational[-2, 5] 
         Pi}, {-1.8849555921538759`, -1.2566370614359172`}]]}, 
     {Hue[
       NCache[
        Rational[3, 5], 0.6], 0.5], 
      DiskBox[NCache[{Rational[3, 2] (-1 + 5^Rational[1, 2]), 0}, {
        1.8541019662496847`, 0}], 1, 
       NCache[{Rational[2, 5] Pi, Rational[3, 5] Pi}, {1.2566370614359172`, 
        1.8849555921538759`}]]}, 
     {Hue[
       NCache[
        Rational[7, 10], 0.7], 0.5], 
      DiskBox[NCache[{
        Rational[7, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        2.163118960624632, 0.9510565162951535}], 1, 
       NCache[{Rational[-3, 5] Pi, Rational[-2, 5] 
         Pi}, {-1.8849555921538759`, -1.2566370614359172`}]]}, 
     {Hue[
       NCache[
        Rational[4, 5], 0.8], 0.5], 
      DiskBox[NCache[{2 (-1 + 5^Rational[1, 2]), 0}, {
        2.4721359549995796`, 0}], 1, 
       NCache[{Rational[2, 5] Pi, Rational[3, 5] Pi}, {1.2566370614359172`, 
        1.8849555921538759`}]]}, 
     {Hue[
       NCache[
        Rational[9, 10], 0.9], 0.5], 
      DiskBox[NCache[{
        Rational[9, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
          Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
        2.781152949374527, 0.9510565162951535}], 1, 
       NCache[{Rational[-3, 5] Pi, Rational[-2, 5] 
         Pi}, {-1.8849555921538759`, -1.2566370614359172`}]]}, 
     {Hue[1, 0.5], 
      DiskBox[NCache[{Rational[5, 2] (-1 + 5^Rational[1, 2]), 0}, {
        3.0901699437494745`, 0}], 1, 
       NCache[{Rational[2, 5] Pi, Rational[3, 5] Pi}, {1.2566370614359172`, 
        1.8849555921538759`}]]}}], ",", 
   GraphicsBox[
    {EdgeForm[Opacity[0.8]], 
     {Hue[
       NCache[
        Rational[1, 11], 0.09090909090909091], 0.5], 
      DiskBox[NCache[{Sin[Rational[1, 11] Pi], Cos[Rational[1, 11] Pi]}, {
        0.28173255684142967`, 0.9594929736144974}], 1, 
       NCache[{Rational[-13, 22] Pi, Rational[-9, 22] 
         Pi}, {-1.8563956589394233`, -1.28519699465037}]]}, 
     {Hue[
       NCache[
        Rational[2, 11], 0.18181818181818182`], 0.5], 
      DiskBox[NCache[{2 Sin[Rational[1, 11] Pi], 0}, {0.5634651136828593, 0}],
        1, NCache[{Rational[9, 22] Pi, Rational[13, 22] Pi}, {
        1.28519699465037, 1.8563956589394233`}]]}, 
     {Hue[
       NCache[
        Rational[3, 11], 0.2727272727272727], 0.5], 
      DiskBox[NCache[{3 Sin[Rational[1, 11] Pi], Cos[Rational[1, 11] Pi]}, {
        0.845197670524289, 0.9594929736144974}], 1, 
       NCache[{Rational[-13, 22] Pi, Rational[-9, 22] 
         Pi}, {-1.8563956589394233`, -1.28519699465037}]]}, 
     {Hue[
       NCache[
        Rational[4, 11], 0.36363636363636365`], 0.5], 
      DiskBox[NCache[{4 Sin[Rational[1, 11] Pi], 0}, {
        1.1269302273657187`, 0}], 1, 
       NCache[{Rational[9, 22] Pi, Rational[13, 22] Pi}, {1.28519699465037, 
        1.8563956589394233`}]]}, 
     {Hue[
       NCache[
        Rational[5, 11], 0.45454545454545453`], 0.5], 
      DiskBox[NCache[{5 Sin[Rational[1, 11] Pi], Cos[Rational[1, 11] Pi]}, {
        1.4086627842071484`, 0.9594929736144974}], 1, 
       NCache[{Rational[-13, 22] Pi, Rational[-9, 22] 
         Pi}, {-1.8563956589394233`, -1.28519699465037}]]}, 
     {Hue[
       NCache[
        Rational[6, 11], 0.5454545454545454], 0.5], 
      DiskBox[NCache[{6 Sin[Rational[1, 11] Pi], 0}, {1.690395341048578, 0}], 
       1, 
       NCache[{Rational[9, 22] Pi, Rational[13, 22] Pi}, {1.28519699465037, 
        1.8563956589394233`}]]}, 
     {Hue[
       NCache[
        Rational[7, 11], 0.6363636363636364], 0.5], 
      DiskBox[NCache[{7 Sin[Rational[1, 11] Pi], Cos[Rational[1, 11] Pi]}, {
        1.9721278978900076`, 0.9594929736144974}], 1, 
       NCache[{Rational[-13, 22] Pi, Rational[-9, 22] 
         Pi}, {-1.8563956589394233`, -1.28519699465037}]]}, 
     {Hue[
       NCache[
        Rational[8, 11], 0.7272727272727273], 0.5], 
      DiskBox[NCache[{8 Sin[Rational[1, 11] Pi], 0}, {
        2.2538604547314374`, 0}], 1, 
       NCache[{Rational[9, 22] Pi, Rational[13, 22] Pi}, {1.28519699465037, 
        1.8563956589394233`}]]}, 
     {Hue[
       NCache[
        Rational[9, 11], 0.8181818181818182], 0.5], 
      DiskBox[NCache[{9 Sin[Rational[1, 11] Pi], Cos[Rational[1, 11] Pi]}, {
        2.535593011572867, 0.9594929736144974}], 1, 
       NCache[{Rational[-13, 22] Pi, Rational[-9, 22] 
         Pi}, {-1.8563956589394233`, -1.28519699465037}]]}, 
     {Hue[
       NCache[
        Rational[10, 11], 0.9090909090909091], 0.5], 
      DiskBox[NCache[{10 Sin[Rational[1, 11] Pi], 0}, {2.817325568414297, 0}],
        1, NCache[{Rational[9, 22] Pi, Rational[13, 22] Pi}, {
        1.28519699465037, 1.8563956589394233`}]]}, 
     {Hue[1, 0.5], 
      DiskBox[NCache[{11 Sin[Rational[1, 11] Pi], Cos[Rational[1, 11] Pi]}, {
        3.0990581252557265`, 0.9594929736144974}], 1, 
       NCache[{Rational[-13, 22] Pi, Rational[-9, 22] 
         Pi}, {-1.8563956589394233`, -1.28519699465037}]]}}], ",", 
   GraphicsBox[
    {EdgeForm[Opacity[0.8]], 
     {Hue[
       NCache[
        Rational[1, 12], 0.08333333333333333], 0.5], 
      DiskBox[NCache[{(Rational[1, 2] 2^Rational[-1, 2]) (-1 + 
          3^Rational[1, 2]), (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
          3^Rational[1, 2])}, {0.2588190451025207, 0.9659258262890682}], 1, 
       NCache[{Rational[-7, 12] Pi, Rational[-5, 12] 
         Pi}, {-1.8325957145940461`, -1.3089969389957472`}]]}, 
     {Hue[
       NCache[
        Rational[1, 6], 0.16666666666666666`], 0.5], 
      DiskBox[NCache[{2^Rational[-1, 2] (-1 + 3^Rational[1, 2]), 0}, {
        0.5176380902050414, 0}], 1, 
       NCache[{Rational[5, 12] Pi, Rational[7, 12] Pi}, {1.3089969389957472`, 
        1.8325957145940461`}]]}, 
     {Hue[
       NCache[
        Rational[1, 4], 0.25], 0.5], 
      DiskBox[NCache[{(Rational[3, 2] 2^Rational[-1, 2]) (-1 + 
          3^Rational[1, 2]), (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
          3^Rational[1, 2])}, {0.776457135307562, 0.9659258262890682}], 1, 
       NCache[{Rational[-7, 12] Pi, Rational[-5, 12] 
         Pi}, {-1.8325957145940461`, -1.3089969389957472`}]]}, 
     {Hue[
       NCache[
        Rational[1, 3], 0.3333333333333333], 0.5], 
      DiskBox[NCache[{2^Rational[1, 2] (-1 + 3^Rational[1, 2]), 0}, {
        1.035276180410083, 0}], 1, 
       NCache[{Rational[5, 12] Pi, Rational[7, 12] Pi}, {1.3089969389957472`, 
        1.8325957145940461`}]]}, 
     {Hue[
       NCache[
        Rational[5, 12], 0.4166666666666667], 0.5], 
      DiskBox[NCache[{(Rational[5, 2] 2^Rational[-1, 2]) (-1 + 
          3^Rational[1, 2]), (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
          3^Rational[1, 2])}, {1.2940952255126035`, 0.9659258262890682}], 1, 
       NCache[{Rational[-7, 12] Pi, Rational[-5, 12] 
         Pi}, {-1.8325957145940461`, -1.3089969389957472`}]]}, 
     {Hue[
       NCache[
        Rational[1, 2], 0.5], 0.5], 
      DiskBox[NCache[{(3 2^Rational[-1, 2]) (-1 + 3^Rational[1, 2]), 0}, {
        1.552914270615124, 0}], 1, 
       NCache[{Rational[5, 12] Pi, Rational[7, 12] Pi}, {1.3089969389957472`, 
        1.8325957145940461`}]]}, 
     {Hue[
       NCache[
        Rational[7, 12], 0.5833333333333334], 0.5], 
      DiskBox[NCache[{(Rational[7, 2] 2^Rational[-1, 2]) (-1 + 
          3^Rational[1, 2]), (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
          3^Rational[1, 2])}, {1.8117333157176447`, 0.9659258262890682}], 1, 
       NCache[{Rational[-7, 12] Pi, Rational[-5, 12] 
         Pi}, {-1.8325957145940461`, -1.3089969389957472`}]]}, 
     {Hue[
       NCache[
        Rational[2, 3], 0.6666666666666666], 0.5], 
      DiskBox[NCache[{(2 2^Rational[1, 2]) (-1 + 3^Rational[1, 2]), 0}, {
        2.070552360820166, 0}], 1, 
       NCache[{Rational[5, 12] Pi, Rational[7, 12] Pi}, {1.3089969389957472`, 
        1.8325957145940461`}]]}, 
     {Hue[
       NCache[
        Rational[3, 4], 0.75], 0.5], 
      DiskBox[NCache[{(Rational[9, 2] 2^Rational[-1, 2]) (-1 + 
          3^Rational[1, 2]), (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
          3^Rational[1, 2])}, {2.329371405922686, 0.9659258262890682}], 1, 
       NCache[{Rational[-7, 12] Pi, Rational[-5, 12] 
         Pi}, {-1.8325957145940461`, -1.3089969389957472`}]]}, 
     {Hue[
       NCache[
        Rational[5, 6], 0.8333333333333334], 0.5], 
      DiskBox[NCache[{(5 2^Rational[-1, 2]) (-1 + 3^Rational[1, 2]), 0}, {
        2.588190451025207, 0}], 1, 
       NCache[{Rational[5, 12] Pi, Rational[7, 12] Pi}, {1.3089969389957472`, 
        1.8325957145940461`}]]}, 
     {Hue[
       NCache[
        Rational[11, 12], 0.9166666666666666], 0.5], 
      DiskBox[NCache[{(Rational[11, 2] 2^Rational[-1, 2]) (-1 + 
          3^Rational[1, 2]), (Rational[1, 2] 2^Rational[-1, 2]) (1 + 
          3^Rational[1, 2])}, {2.8470094961277277`, 0.9659258262890682}], 1, 
       NCache[{Rational[-7, 12] Pi, Rational[-5, 12] 
         Pi}, {-1.8325957145940461`, -1.3089969389957472`}]]}, 
     {Hue[1, 0.5], 
      DiskBox[NCache[{(3 2^Rational[1, 2]) (-1 + 3^Rational[1, 2]), 0}, {
        3.105828541230249, 0}], 1, 
       NCache[{Rational[5, 12] Pi, Rational[7, 12] Pi}, {1.3089969389957472`, 
        1.8325957145940461`}]]}}]}], "}"}]], "Output",
 ImageSize->{491, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->583400998]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->564325026],

Cell["The square packing of disks:", "ExampleText",
 CellID->260968007],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EdgeForm", "[", "Black", "]"}], ",", "LightYellow", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"i", ",", "j"}], "}"}], ",", 
        RowBox[{"1", "/", "2"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "5"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->394677528],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXD9oG1cYf8ndSY6NZbdOHbdgo9K6yKQ2cl2MWmhyS1MvDRpKyVSkhkIy
hByJaU2hZOiggkGaupXekILppIJDtZiaTBo6CLoITxo9atR4/b33znfK+c7v
LncKGb6Az37f7/d99937/3488mV99953D+q79+/Wi188qlv37t99XLz18BFM
2iXG2DP8/LzE8LeDv8TPM8fB7/FngT+1brd7LP6xy3gshNiuxrTF9Q3jiVzY
DH/qKNZq38zPz1UqH+mm+QnTpqby1ept27bZrJJRyICRxVvUMcTXsiv8afT7
/Z2dz0Gw7cZw+C8zHOeEGaPRf+32r7XaV+XyBq+pJNzpCXEnlUPiemBToh91
On9XKludzm+8Pk+Y1uv9BfdWq8nyClzlP+n4sfxdlm3/vrNj8hopCJZlffvk
yU+iiylwIyWeNr7KPye+Ujw1tC1YaG02f8ZCRXDosgLXUuJp46v8RS25dXV6
eloqrfK6eJOzcmhuOALyAGHPe/ZxiCmxl4kX5aN5dtmO7hfcufP1wUGLEwTL
QJ/FyAQkAbYgYnpWD7jQnixKOFvzrG6+svf1er1y+TonXBWsavVWs9mEib3F
yzrK7XZbsiIsap8gQ5MMr/e4uezt/dBoPPZzOThobmysw+TGRRlfJFkRFrVP
kKFJRjCXUumDfr/j54Jmn5ubhcmNizKWLsmKsKh9ggxNMoK58D2Kc8IJkhUs
F4vL0sQWQ8sqfgg+GAy8seuOcJgA+KzB4J9r1xb8KJubHy4vvxNWVvHDcWwL
sBEKZoFVsFR63/dC3a2svO17bW+XV1ffDSur+OG4P8rHsxgOh6KdTvx2m56+
4nutr5fQrmFlFT8cx8jBcPKzkP0C+yVMqL6XrusvlJeWFiXFjRIsq/ghOObA
YBam+dnx8VN/pKAdFxcXYHJ7PcrF4opkRVjUPkGGJhnBkdJqtSyr5ufSav14
8+YNmNy4KFvWQ8mKsKh9ggxNMoK5oKowXnhtilx0tOHR0ZE0CYshWzXAC7fG
9T7PG+s72tg6hcXXsur+OmXbv2A3DkgC7grjWT3gQnuyKOFszbO+sK6ORiN0
h273T/YGZ+XR/pXKx7I7BjDNw9y9R0I8TeyYvsbYzg5lWIGxubOxj10vmsyd
a6JxPSWeNr7KX+5f8/4+Y53XxexZXZjmp9jhu+0bjedS4mnjq/zF98kTCVb4
YaWyjb6MShDTN59AG41duCJAPgYnTpxX+a7YcdwTLYYy5mWcR3Eq5bOSLkY6
znCYLrF73tv7HrEScWcmxJ1UDkniytP6zFkd27Zdrd7O5QwdWzKm4biPZQf7
LlcxuYhRyICRxVvUMWbGvpn0LNKzSM8iPYv0LNKzSM8iPYv0LNKzfC/Ss0jP
Ij2L9CzSs0jPeh30rOfP/+DH/KdxNJ9o7nktKRvupHJIEndczzo8PDTNG1j2
19bewzS+xjTD0Le2Nvf3913F5CJGIQNGFm9RxyBth7Qd0nZI2yFth7Qd0nZI
23FI2yFth7Qd0nZI2yFtJyFO2g7dVXqVOdBdJbqrRHeVSM8iPYv0LNKzSM/y
cyE9i/SsYBakZzmkZ5GeRXoW6VmkZ5Ge9VrrWXRXie4q0V0l0nZewp+0HdJ2
HNJ2YrJJ2yFth7Qd0nZI2yFth7Qd0nZI2yFtJ8s4dFcpq7tKWIMVN4BCGIUM
GFm8RR1Dajvn/y9z+WSX/gdvgkHf\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->497586663]
}, Open  ]],

Cell["The hexagonal packing of disks:", "ExampleText",
 CellID->52340893],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"EdgeForm", "[", "Black", "]"}], ",", "LightYellow", ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"i", "+", 
           RowBox[{
            RowBox[{"Boole", "[", 
             RowBox[{"EvenQ", "[", "j", "]"}], "]"}], "/", "2"}]}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"Sqrt", "[", "3", "]"}], "/", "2"}], "j"}]}], "}"}], ",", 
        
        RowBox[{"1", "/", "2"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "7"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", "5"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->54037755],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->339837992]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4886675],

Cell["Simulation of elliptical gears:", "ExampleText",
 CellID->22599527],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a", "=", "4"}], ",", 
       RowBox[{"b", "=", "3"}], ",", "f", ",", "r"}], "}"}], ",", 
     RowBox[{
      RowBox[{"f", "=", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "-", 
         RowBox[{"b", "^", "2"}]}], "]"}]}], ";", 
      RowBox[{"r", "=", 
       RowBox[{
        RowBox[{"b", "^", "2"}], "/", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"f", " ", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ")"}]}]}], ";", 
      RowBox[{"Graphics", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Lighter", "[", "Red", "]"}], ",", 
          RowBox[{"Rotate", "[", 
           RowBox[{
            RowBox[{"Disk", "[", 
             RowBox[{
              RowBox[{"{", 
               RowBox[{
                RowBox[{"-", "f"}], ",", "0"}], "}"}], ",", 
              RowBox[{"{", 
               RowBox[{"a", ",", "b"}], "}"}]}], "]"}], ",", "\[Theta]", ",", 
            
            RowBox[{"{", 
             RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
          RowBox[{"Lighter", "[", "Blue", "]"}], ",", 
          RowBox[{"Translate", "[", 
           RowBox[{
            RowBox[{"Rotate", "[", 
             RowBox[{
              RowBox[{"Disk", "[", 
               RowBox[{
                RowBox[{"{", 
                 RowBox[{
                  RowBox[{"-", "f"}], ",", "0"}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"a", ",", "b"}], "}"}]}], "]"}], ",", 
              RowBox[{"-", 
               RowBox[{"ArcTan", "[", " ", 
                RowBox[{
                 RowBox[{
                  RowBox[{"2", " ", "f"}], " ", "+", 
                  RowBox[{"r", " ", 
                   RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], ",", 
                 RowBox[{"r", " ", 
                  RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "]"}]}], ",", 
              RowBox[{"{", 
               RowBox[{"0", ",", "0"}], "}"}]}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"2", "a"}], ",", "0"}], "}"}]}], "]"}], ",", "Black", 
          ",", 
          RowBox[{"Point", "[", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"0", ",", "0"}], "}"}], ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"2", "a"}], ",", "0"}], "}"}]}], "}"}], "]"}]}], "}"}],
         ",", 
        RowBox[{"PlotRange", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], "a"}], ",", 
             RowBox[{"4", "a"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "2"}], "a"}], ",", 
             RowBox[{"2", "a"}]}], "}"}]}], "}"}]}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "250"}]}], "]"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->541567839],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`\[Theta]$$ = 6.283185307179586, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`\[Theta]$$], 0, 2 Pi}}, Typeset`size$$ = {
    250., {81., 86.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`\[Theta]$1086$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`\[Theta]$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`\[Theta]$$, $CellContext`\[Theta]$1086$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`a$ = 4, $CellContext`b$ = 
         3, $CellContext`f$, $CellContext`r$}, $CellContext`f$ = 
         Sqrt[$CellContext`a$^2 - $CellContext`b$^2]; $CellContext`r$ = \
$CellContext`b$^2/($CellContext`a$ + $CellContext`f$ 
           Cos[$CellContext`\[Theta]$$]); Graphics[{
           Lighter[Red], 
           Rotate[
            
            Disk[{-$CellContext`f$, 
              0}, {$CellContext`a$, $CellContext`b$}], \
$CellContext`\[Theta]$$, {0, 0}], 
           Lighter[Blue], 
           Translate[
            Rotate[
             
             Disk[{-$CellContext`f$, 
               0}, {$CellContext`a$, $CellContext`b$}], -
             ArcTan[2 $CellContext`f$ + $CellContext`r$ 
                Cos[$CellContext`\[Theta]$$], $CellContext`r$ 
               Sin[$CellContext`\[Theta]$$]], {0, 0}], {
            2 $CellContext`a$, 0}], Black, 
           Point[{{0, 0}, {2 $CellContext`a$, 0}}]}, 
          PlotRange -> {{(-2) $CellContext`a$, 
             4 $CellContext`a$}, {(-2) $CellContext`a$, 2 $CellContext`a$}}, 
          ImageSize -> 250]], 
      "Specifications" :> {{$CellContext`\[Theta]$$, 0, 2 Pi, 
         AnimationRunning -> False, 
         AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{328., {118., 123.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{332, 243},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->72766112]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24570],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Rotate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rotate"]], "InlineFormula"],
 " to get all possible ",
 "elliptical",
 " disks:"
}], "ExampleText",
 CellID->19774549],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"Pink", ",", 
     RowBox[{"Rotate", "[", 
      RowBox[{
       RowBox[{"Disk", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"4", ",", "2"}], "}"}]}], "]"}], ",", 
       RowBox[{"Pi", "/", "6"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->41587213],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[1, 0.5, 0.5], 
   GeometricTransformationBox[
    DiskBox[{0, 0}, {4., 2.}], {{{0.8660254037844386, -0.5}, {0.5, 
     0.8660254037844386}}, Center}]},
  Axes->True]], "Output",
 ImageSize->{154, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->544149]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->147337869],

Cell["The boundary of a disk defines a circle:", "ExampleText",
 CellID->126224546],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"Circle", "[", "]"}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"FaceForm", "[", "]"}], ",", 
      RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
      RowBox[{"Disk", "[", "]"}]}], "}"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->74762595],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[CircleBox[{0, 0}]], ",", 
   GraphicsBox[
    {EdgeForm[GrayLevel[0]], FaceForm[None], DiskBox[{0, 0}]}]}], 
  "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->51078900]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->204306472],

Cell[TextData[{
 "An implicit specification of disk can be generated using ",
 Cell[BoxData[
  ButtonBox["RegionPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RegionPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->47836386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RegionPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "2"}], "+", 
     RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->185194839],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->387851841]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->78749878],

Cell[TextData[{
 "A parametric specification of disk can be generated using ",
 Cell[BoxData[
  ButtonBox["ParametricPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ParametricPlot"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->578540755],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"r", " ", 
      RowBox[{"Cos", "[", "\[Theta]", "]"}]}], ",", 
     RowBox[{"r", " ", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"r", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Theta]", ",", "0", ",", 
     RowBox[{"2", "\[Pi]"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->605478468],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 172},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->525060199]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20251],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " radii, will depend on the ",
 Cell[BoxData[
  ButtonBox["PlotRange",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PlotRange"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->353119521],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"Scaled", "[", ".25", "]"}]}], "]"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "n"}], ",", "n"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}], ",", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "n"}], ",", "n"}], "}"}], ",", "None"}], "}"}]}], 
       "}"}]}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->207375245],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[DiskBox[{0, 0}, Scaled[0.25]],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    PlotRange->{{-1, 1}, {-1, 1}}], ",", 
   GraphicsBox[DiskBox[{0, 0}, Scaled[0.25]],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-2, 
         FormBox[
          RowBox[{"-", "2"}], TraditionalForm]}, {2, 
         FormBox["2", TraditionalForm]}}, None}},
    PlotRange->{{-2, 2}, {-1, 1}}], ",", 
   GraphicsBox[DiskBox[{0, 0}, Scaled[0.25]],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-3, 
         FormBox[
          RowBox[{"-", "3"}], TraditionalForm]}, {3, 
         FormBox["3", TraditionalForm]}}, None}},
    PlotRange->{{-3, 3}, {-1, 1}}]}], "}"}]], "Output",
 ImageSize->{341, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->8400346]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->309175476],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " sizes, will depend on the ",
 Cell[BoxData[
  ButtonBox["ImageSize",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageSize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["AspectRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AspectRatio"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->14956960],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{".5", ",", ".5"}], "}"}], "]"}], ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{".25", ",", ".25"}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}], ",", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}]}], 
       "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "n"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"50", ",", "70", ",", "100"}], "}"}]}], "}"}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->42263118],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[DiskBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.25, 0.25}]],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    ImageSize->50], ",", 
   GraphicsBox[DiskBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.25, 0.25}]],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    ImageSize->70], ",", 
   GraphicsBox[DiskBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.25, 0.25}]],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    ImageSize->100]}], "}"}]], "Output",
 ImageSize->{261, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->315665331]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{".5", ",", ".5"}], "}"}], "]"}], ",", 
       RowBox[{"ImageScaled", "[", 
        RowBox[{"{", 
         RowBox[{".25", ",", ".25"}], "}"}], "]"}]}], "]"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}], ",", 
        
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", "None"}], "}"}]}], 
       "}"}]}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "100"}], ",", 
     RowBox[{"AspectRatio", "\[Rule]", "n"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"1", "/", "2"}], ",", 
       RowBox[{"1", "/", "3"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->284727558],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[DiskBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.25, 0.25}]],
    AspectRatio->1,
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    ImageSize->100], ",", 
   GraphicsBox[DiskBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.25, 0.25}]],
    AspectRatio->NCache[
      Rational[1, 2], 0.5],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    ImageSize->100], ",", 
   GraphicsBox[DiskBox[ImageScaled[{0.5, 0.5}], ImageScaled[{0.25, 0.25}]],
    AspectRatio->NCache[
      Rational[1, 3], 0.3333333333333333],
    Frame->True,
    FrameTicks->{{{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}, {{{-1, 
         FormBox[
          RowBox[{"-", "1"}], TraditionalForm]}, {1, 
         FormBox["1", TraditionalForm]}}, None}},
    ImageSize->100]}], "}"}]], "Output",
 ImageSize->{341, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->653744572]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10264],

Cell["Random disk collections:", "ExampleText",
 CellID->152190467],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", "Black", "]"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{"RandomReal", "[", "]"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{"RandomReal", "[", 
         RowBox[{"4", ",", 
          RowBox[{"{", "2", "}"}]}], "]"}], ",", 
        RowBox[{"RandomReal", "[", "1", "]"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"{", "40", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45131703],

Cell[BoxData[
 GraphicsBox[{
   {Hue[0.5319699774975455], EdgeForm[GrayLevel[0]], 
    DiskBox[{3.2459771621601563`, 2.0728724228932247`}, 
     0.06085868987504561]}, 
   {Hue[0.3066697485509102], EdgeForm[GrayLevel[0]], 
    DiskBox[{3.5553169195818466`, 0.2081699477035368}, 0.6410679186486932]}, 
   {Hue[0.9651528871672321], EdgeForm[GrayLevel[0]], 
    DiskBox[{0.03898621120212464, 2.2394826849525957`}, 
     0.09176552101188773]}, 
   {Hue[0.24960057383290168`], EdgeForm[GrayLevel[0]], 
    DiskBox[{2.9027634553342994`, 3.678345959129919}, 0.09902461642647475]}, 
   {Hue[0.7632171020094674], EdgeForm[GrayLevel[0]], 
    DiskBox[{0.7998677693963092, 3.8981922098952024`}, 0.6184436416753694]}, 
   {Hue[0.8047103981043202], EdgeForm[GrayLevel[0]], 
    DiskBox[{2.0784859927656845`, 1.2670819727452285`}, 0.897800595645061]}, 
   {Hue[0.3771626406939985], EdgeForm[GrayLevel[0]], 
    DiskBox[{1.156271790085495, 2.8983111753759774`}, 0.7266553919523719]}, 
   {Hue[0.8369421167708553], EdgeForm[GrayLevel[0]], 
    DiskBox[{3.738131845165001, 3.881493932483685}, 0.26341882854955023`]}, 
   {Hue[0.08999418488358746], EdgeForm[GrayLevel[0]], 
    DiskBox[{2.6561011592522004`, 3.995083092375001}, 0.2743935601905183]}, 
   {Hue[0.6597828524918092], EdgeForm[GrayLevel[0]], 
    DiskBox[{1.4111685769525755`, 3.530257569370816}, 0.6944767363573388]}, 
   {Hue[0.7471248266666337], EdgeForm[GrayLevel[0]], 
    DiskBox[{3.806735208143988, 0.5573396103119252}, 0.8573738827023656]}, 
   {Hue[0.8287578439098267], EdgeForm[GrayLevel[0]], 
    DiskBox[{3.3280709928665164`, 2.6906935769208253`}, 
     0.9324103949897398]}, 
   {Hue[0.6864977756569441], EdgeForm[GrayLevel[0]], 
    DiskBox[{2.621911533216849, 2.728831931480661}, 0.19939522150541977`]}, 
   {Hue[0.14754843956331287`], EdgeForm[GrayLevel[0]], 
    DiskBox[{0.6593479201716743, 1.8707749960300069`}, 0.5104811325754846]}, 
   {Hue[0.5869795984344355], EdgeForm[GrayLevel[0]], 
    DiskBox[{2.2603637283762685`, 1.6694585212000597`}, 
     0.6915699271147977]}, 
   {Hue[0.6572809277021976], EdgeForm[GrayLevel[0]], 
    DiskBox[{3.4156241351918313`, 2.833703980155337}, 
     0.15389364503204894`]}, 
   {Hue[0.43792701950975976`], EdgeForm[GrayLevel[0]], 
    DiskBox[{0.0313299427793714, 3.926705043312679}, 0.8498769790199834]}, 
   {Hue[0.13115137145958844`], EdgeForm[GrayLevel[0]], 
    DiskBox[{0.7218308009267593, 3.8985771104865297`}, 0.6500069699232138]}, 
   {Hue[0.09188461486151511], EdgeForm[GrayLevel[0]], 
    DiskBox[{1.0379923843593293`, 2.6006144884247036`}, 0.410096508313875]}, 
   {Hue[0.49362796484199567`], EdgeForm[GrayLevel[0]], 
    DiskBox[{0.1890236409979682, 3.9520667380631505`}, 0.590518367934878]}, 
   {Hue[0.1575296840548679], EdgeForm[GrayLevel[0]], 
    DiskBox[{2.6406429062717622`, 2.111496225308411}, 0.8780757142373095]}, 
   {Hue[0.4041094649497734], EdgeForm[GrayLevel[0]], 
    DiskBox[{2.6400750615241018`, 1.5152860759364941`}, 
     0.7627809411158939]}, 
   {Hue[0.11504970070633558`], EdgeForm[GrayLevel[0]], 
    DiskBox[{2.9980272714089615`, 3.1450671094263782`}, 
     0.7098319755809481]}, 
   {Hue[0.3580226719065105], EdgeForm[GrayLevel[0]], 
    DiskBox[{0.7311755633188319, 0.03002563198925401}, 0.7609724428848059]}, 
   {Hue[0.9646586377626625], EdgeForm[GrayLevel[0]], 
    DiskBox[{1.3187303156275592`, 3.8202439097372087`}, 
     0.04726855024857057]}, 
   {Hue[0.8178604482386445], EdgeForm[GrayLevel[0]], 
    DiskBox[{3.8858915614396645`, 2.2303600244769317`}, 
     0.04591509444034836]}, 
   {Hue[0.909225976389517], EdgeForm[GrayLevel[0]], 
    DiskBox[{1.7944998225240925`, 0.6097243726788841}, 0.8606146155041492]}, 
   {Hue[0.25545603705419184`], EdgeForm[GrayLevel[0]], 
    DiskBox[{3.2191517805181986`, 3.281891632500061}, 0.7518784882311864]}, 
   {Hue[0.10921698189478168`], EdgeForm[GrayLevel[0]], 
    DiskBox[{1.923772209969373, 3.1276630359600457`}, 0.7264916900051352]}, 
   {Hue[0.9329383277437002], EdgeForm[GrayLevel[0]], 
    DiskBox[{1.9728211130630315`, 1.418299159364877}, 0.3645037681901142]}, 
   {Hue[0.07304964905741196], EdgeForm[GrayLevel[0]], 
    DiskBox[{2.346619644084381, 1.8300039357827869`}, 
     0.29869164542830995`]}, 
   {Hue[0.8445117579758865], EdgeForm[GrayLevel[0]], 
    DiskBox[{2.023982358513874, 0.7281701755033296}, 0.44331748929855874`]}, 
   {Hue[0.9083894253853559], EdgeForm[GrayLevel[0]], 
    DiskBox[{0.8574862324659307, 1.8678057498852576`}, 0.3959330166223376]}, 
   {Hue[0.057544595456409775`], EdgeForm[GrayLevel[0]], 
    DiskBox[{2.4280732209125846`, 0.6047251197061714}, 0.6578521104265445]}, 
   {Hue[0.47134512303775766`], EdgeForm[GrayLevel[0]], 
    DiskBox[{3.8142572702714457`, 2.623316367501226}, 0.5685398538375424]}, 
   {Hue[0.673941372863778], EdgeForm[GrayLevel[0]], 
    DiskBox[{0.9068873059660794, 1.09867636591438}, 0.6093442458332747]}, 
   {Hue[0.39163242884736316`], EdgeForm[GrayLevel[0]], 
    DiskBox[{2.4180444191316015`, 0.9609862656204955}, 0.9257833002505471]}, 
   {Hue[0.4768422747669663], EdgeForm[GrayLevel[0]], 
    DiskBox[{3.614405734538413, 3.457923603727667}, 0.011490778746230612`]}, 
   {Hue[0.3900024805613407], EdgeForm[GrayLevel[0]], 
    DiskBox[{1.2734444657362571`, 3.7165416969964014`}, 0.76059270745284]}, 
   {Hue[0.39555103873661346`], EdgeForm[GrayLevel[0]], 
    DiskBox[{2.9135109386598064`, 0.5794284187177556}, 
     0.9671942801244919]}}]], "Output",
 ImageSize->{184, 181},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->135168511]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->235941495],

Cell["A family of disks:", "ExampleText",
 CellID->295179799],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Hue", "[", 
       RowBox[{
        RowBox[{"t", "/", "15"}], ",", "1", ",", ".9", ",", ".3"}], "]"}], 
      ",", 
      RowBox[{"Disk", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Cos", "[", 
          RowBox[{"2", "Pi", " ", 
           RowBox[{"t", "/", "15"}]}], "]"}], ",", 
         RowBox[{"Sin", "[", 
          RowBox[{"2", "Pi", " ", 
           RowBox[{"t", "/", "15"}]}], "]"}]}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t", ",", "15"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->54842079],

Cell[BoxData[
 GraphicsBox[{
   {Hue[
     NCache[
      Rational[1, 15], 0.06666666666666667], 1, 0.9], Opacity[0.3], 
    DiskBox[NCache[{Cos[Rational[2, 15] Pi], Sin[Rational[2, 15] Pi]}, {
      0.9135454576426009, 0.40673664307580015`}]]}, 
   {Hue[
     NCache[
      Rational[2, 15], 0.13333333333333333`], 1, 0.9], Opacity[0.3], 
    DiskBox[NCache[{Sin[Rational[7, 30] Pi], Cos[Rational[7, 30] Pi]}, {
      0.6691306063588582, 0.7431448254773942}]]}, 
   {Hue[
     NCache[
      Rational[1, 5], 0.2], 1, 0.9], Opacity[0.3], 
    DiskBox[NCache[{
      Rational[1, 4] (-1 + 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
      0.30901699437494745`, 0.9510565162951535}]]}, 
   {Hue[
     NCache[
      Rational[4, 15], 0.26666666666666666`], 1, 0.9], Opacity[0.3], 
    DiskBox[NCache[{-Sin[Rational[1, 30] Pi], Cos[
       Rational[1, 30] Pi]}, {-0.10452846326765346`, 0.9945218953682733}]]}, 
   {Hue[
     NCache[
      Rational[1, 3], 0.3333333333333333], 1, 0.9], Opacity[0.3], 
    DiskBox[NCache[{Rational[-1, 2], Rational[1, 2] 3^Rational[1, 2]}, {-0.5, 
      0.8660254037844386}]]}, 
   {Hue[
     NCache[
      Rational[2, 5], 0.4], 1, 0.9], Opacity[0.3], 
    DiskBox[NCache[{
      Rational[1, 4] (-1 - 5^Rational[1, 2]), (Rational[5, 8] + 
        Rational[-1, 8] 5^Rational[1, 2])^
       Rational[1, 2]}, {-0.8090169943749475, 0.5877852522924731}]]}, 
   {Hue[
     NCache[
      Rational[7, 15], 0.4666666666666667], 1, 0.9], Opacity[0.3], 
    DiskBox[NCache[{-Cos[Rational[1, 15] Pi], Sin[
       Rational[1, 15] Pi]}, {-0.9781476007338057, 0.20791169081775931`}]]}, 
   {Hue[
     NCache[
      Rational[8, 15], 0.5333333333333333], 1, 0.9], Opacity[0.3], 
    DiskBox[NCache[{-Cos[Rational[1, 15] Pi], -
       Sin[Rational[1, 15] 
         Pi]}, {-0.9781476007338057, -0.20791169081775931`}]]}, 
   {Hue[
     NCache[
      Rational[3, 5], 0.6], 1, 0.9], Opacity[0.3], 
    DiskBox[NCache[{
      Rational[1, 4] (-1 - 5^
        Rational[1, 2]), -(Rational[5, 8] + Rational[-1, 8] 5^Rational[1, 2])^
        Rational[1, 2]}, {-0.8090169943749475, -0.5877852522924731}]]}, 
   {Hue[
     NCache[
      Rational[2, 3], 0.6666666666666666], 1, 0.9], Opacity[0.3], 
    DiskBox[NCache[{
      Rational[-1, 2], Rational[-1, 2] 
       3^Rational[1, 2]}, {-0.5, -0.8660254037844386}]]}, 
   {Hue[
     NCache[
      Rational[11, 15], 0.7333333333333333], 1, 0.9], Opacity[0.3], 
    DiskBox[NCache[{-Sin[Rational[1, 30] Pi], -
       Cos[Rational[1, 30] 
         Pi]}, {-0.10452846326765346`, -0.9945218953682733}]]}, 
   {Hue[
     NCache[
      Rational[4, 5], 0.8], 1, 0.9], Opacity[0.3], 
    DiskBox[NCache[{
      Rational[1, 4] (-1 + 
        5^Rational[1, 2]), -(Rational[5, 8] + 
         Rational[1, 8] 5^Rational[1, 2])^Rational[1, 2]}, {
      0.30901699437494745`, -0.9510565162951535}]]}, 
   {Hue[
     NCache[
      Rational[13, 15], 0.8666666666666667], 1, 0.9], Opacity[0.3], 
    DiskBox[NCache[{Sin[Rational[7, 30] Pi], -Cos[Rational[7, 30] Pi]}, {
      0.6691306063588582, -0.7431448254773942}]]}, 
   {Hue[
     NCache[
      Rational[14, 15], 0.9333333333333333], 1, 0.9], Opacity[0.3], 
    DiskBox[NCache[{Cos[Rational[2, 15] Pi], -Sin[Rational[2, 15] Pi]}, {
      0.9135454576426009, -0.40673664307580015`}]]}, 
   {Hue[1, 1, 0.9], Opacity[0.3], DiskBox[{1, 0}]}}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14233911]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->282122593],

Cell["Digital petals: ", "ExampleText",
 CellID->54371934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"EdgeForm", "[", 
       RowBox[{"Opacity", "[", ".6", "]"}], "]"}], ",", 
      RowBox[{"Hue", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "11"}], "+", "q", "+", 
          RowBox[{"10", " ", "r"}]}], ")"}], "/", "72"}], "]"}], ",", 
      RowBox[{"Disk", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"8", "-", "r"}], ")"}], 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Cos", "[", 
            RowBox[{"2", "Pi", " ", 
             RowBox[{"q", "/", "12"}]}], "]"}], ",", 
           RowBox[{"Sin", "[", 
            RowBox[{"2", "Pi", " ", 
             RowBox[{"q", "/", "12"}]}], "]"}]}], "}"}]}], ",", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"8", "-", "r"}], ")"}], "/", "3"}]}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"r", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"q", ",", "12"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->208503405],

Cell[BoxData[
 GraphicsBox[{{
    {Hue[0], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{Rational[7, 2] 3^Rational[1, 2], Rational[7, 2]}, {
       6.06217782649107, 3.5}], NCache[
      Rational[7, 3], 2.3333333333333335`]]}, 
    {Hue[
      NCache[
       Rational[1, 72], 0.013888888888888888`]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{Rational[7, 2], Rational[7, 2] 3^Rational[1, 2]}, {3.5, 
       6.06217782649107}], NCache[Rational[7, 3], 2.3333333333333335`]]}, 
    {Hue[
      NCache[
       Rational[1, 36], 0.027777777777777776`]], EdgeForm[Opacity[0.6]], 
     DiskBox[{0, 7}, NCache[Rational[7, 3], 2.3333333333333335`]]}, 
    {Hue[
      NCache[
       Rational[1, 24], 0.041666666666666664`]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{Rational[-7, 2], Rational[7, 2] 3^Rational[1, 2]}, {-3.5,
        6.06217782649107}], NCache[Rational[7, 3], 2.3333333333333335`]]}, 
    {Hue[
      NCache[
       Rational[1, 18], 0.05555555555555555]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{
       Rational[-7, 2] 3^Rational[1, 2], Rational[7, 2]}, {-6.06217782649107, 
       3.5}], NCache[Rational[7, 3], 2.3333333333333335`]]}, 
    {Hue[
      NCache[
       Rational[5, 72], 0.06944444444444445]], EdgeForm[Opacity[0.6]], 
     DiskBox[{-7, 0}, NCache[Rational[7, 3], 2.3333333333333335`]]}, 
    {Hue[
      NCache[
       Rational[1, 12], 0.08333333333333333]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{
       Rational[-7, 2] 3^Rational[1, 2], 
        Rational[-7, 2]}, {-6.06217782649107, -3.5}], NCache[
      Rational[7, 3], 2.3333333333333335`]]}, 
    {Hue[
      NCache[
       Rational[7, 72], 0.09722222222222222]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{
       Rational[-7, 2], Rational[-7, 2] 
        3^Rational[1, 2]}, {-3.5, -6.06217782649107}], NCache[
      Rational[7, 3], 2.3333333333333335`]]}, 
    {Hue[
      NCache[
       Rational[1, 9], 0.1111111111111111]], EdgeForm[Opacity[0.6]], 
     DiskBox[{0, -7}, NCache[Rational[7, 3], 2.3333333333333335`]]}, 
    {Hue[
      NCache[
       Rational[1, 8], 0.125]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{Rational[7, 2], Rational[-7, 2] 3^Rational[1, 2]}, {
       3.5, -6.06217782649107}], NCache[
      Rational[7, 3], 2.3333333333333335`]]}, 
    {Hue[
      NCache[
       Rational[5, 36], 0.1388888888888889]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{Rational[7, 2] 3^Rational[1, 2], Rational[-7, 2]}, {
       6.06217782649107, -3.5}], NCache[
      Rational[7, 3], 2.3333333333333335`]]}, 
    {Hue[
      NCache[
       Rational[11, 72], 0.1527777777777778]], EdgeForm[Opacity[0.6]], 
     DiskBox[{7, 0}, NCache[Rational[7, 3], 2.3333333333333335`]]}}, {
    {Hue[
      NCache[
       Rational[5, 36], 0.1388888888888889]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{3 3^Rational[1, 2], 3}, {5.196152422706632, 3}], 2]}, 
    {Hue[
      NCache[
       Rational[11, 72], 0.1527777777777778]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{3, 3 3^Rational[1, 2]}, {3, 5.196152422706632}], 2]}, 
    {Hue[
      NCache[
       Rational[1, 6], 0.16666666666666666`]], EdgeForm[Opacity[0.6]], 
     DiskBox[{0, 6}, 2]}, 
    {Hue[
      NCache[
       Rational[13, 72], 0.18055555555555555`]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{-3, 3 3^Rational[1, 2]}, {-3, 5.196152422706632}], 2]}, 
    {Hue[
      NCache[
       Rational[7, 36], 0.19444444444444445`]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{(-3) 3^Rational[1, 2], 3}, {-5.196152422706632, 3}], 
      2]}, 
    {Hue[
      NCache[
       Rational[5, 24], 0.20833333333333334`]], EdgeForm[Opacity[0.6]], 
     DiskBox[{-6, 0}, 2]}, 
    {Hue[
      NCache[
       Rational[2, 9], 0.2222222222222222]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{(-3) 3^Rational[1, 2], -3}, {-5.196152422706632, -3}], 
      2]}, 
    {Hue[
      NCache[
       Rational[17, 72], 0.2361111111111111]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{-3, (-3) 3^Rational[1, 2]}, {-3, -5.196152422706632}], 
      2]}, 
    {Hue[
      NCache[
       Rational[1, 4], 0.25]], EdgeForm[Opacity[0.6]], DiskBox[{0, -6}, 2]}, 
    {Hue[
      NCache[
       Rational[19, 72], 0.2638888888888889]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{3, (-3) 3^Rational[1, 2]}, {3, -5.196152422706632}], 
      2]}, 
    {Hue[
      NCache[
       Rational[5, 18], 0.2777777777777778]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{3 3^Rational[1, 2], -3}, {5.196152422706632, -3}], 2]}, 
    {Hue[
      NCache[
       Rational[7, 24], 0.2916666666666667]], EdgeForm[Opacity[0.6]], 
     DiskBox[{6, 0}, 2]}}, {
    {Hue[
      NCache[
       Rational[5, 18], 0.2777777777777778]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{Rational[5, 2] 3^Rational[1, 2], Rational[5, 2]}, {
       4.330127018922193, 2.5}], NCache[
      Rational[5, 3], 1.6666666666666667`]]}, 
    {Hue[
      NCache[
       Rational[7, 24], 0.2916666666666667]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{Rational[5, 2], Rational[5, 2] 3^Rational[1, 2]}, {2.5, 
       4.330127018922193}], NCache[Rational[5, 3], 1.6666666666666667`]]}, 
    {Hue[
      NCache[
       Rational[11, 36], 0.3055555555555556]], EdgeForm[Opacity[0.6]], 
     DiskBox[{0, 5}, NCache[Rational[5, 3], 1.6666666666666667`]]}, 
    {Hue[
      NCache[
       Rational[23, 72], 0.3194444444444444]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{Rational[-5, 2], Rational[5, 2] 3^Rational[1, 2]}, {-2.5,
        4.330127018922193}], NCache[Rational[5, 3], 1.6666666666666667`]]}, 
    {Hue[
      NCache[
       Rational[1, 3], 0.3333333333333333]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{
       Rational[-5, 2] 3^Rational[1, 2], Rational[5, 2]}, {-4.330127018922193,
        2.5}], NCache[Rational[5, 3], 1.6666666666666667`]]}, 
    {Hue[
      NCache[
       Rational[25, 72], 0.3472222222222222]], EdgeForm[Opacity[0.6]], 
     DiskBox[{-5, 0}, NCache[Rational[5, 3], 1.6666666666666667`]]}, 
    {Hue[
      NCache[
       Rational[13, 36], 0.3611111111111111]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{
       Rational[-5, 2] 3^Rational[1, 2], 
        Rational[-5, 2]}, {-4.330127018922193, -2.5}], NCache[
      Rational[5, 3], 1.6666666666666667`]]}, 
    {Hue[
      NCache[
       Rational[3, 8], 0.375]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{
       Rational[-5, 2], Rational[-5, 2] 
        3^Rational[1, 2]}, {-2.5, -4.330127018922193}], NCache[
      Rational[5, 3], 1.6666666666666667`]]}, 
    {Hue[
      NCache[
       Rational[7, 18], 0.3888888888888889]], EdgeForm[Opacity[0.6]], 
     DiskBox[{0, -5}, NCache[Rational[5, 3], 1.6666666666666667`]]}, 
    {Hue[
      NCache[
       Rational[29, 72], 0.4027777777777778]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{Rational[5, 2], Rational[-5, 2] 3^Rational[1, 2]}, {
       2.5, -4.330127018922193}], NCache[
      Rational[5, 3], 1.6666666666666667`]]}, 
    {Hue[
      NCache[
       Rational[5, 12], 0.4166666666666667]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{Rational[5, 2] 3^Rational[1, 2], Rational[-5, 2]}, {
       4.330127018922193, -2.5}], NCache[
      Rational[5, 3], 1.6666666666666667`]]}, 
    {Hue[
      NCache[
       Rational[31, 72], 0.4305555555555556]], EdgeForm[Opacity[0.6]], 
     DiskBox[{5, 0}, NCache[Rational[5, 3], 1.6666666666666667`]]}}, {
    {Hue[
      NCache[
       Rational[5, 12], 0.4166666666666667]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{2 3^Rational[1, 2], 2}, {3.4641016151377544`, 2}], 
      NCache[Rational[4, 3], 1.3333333333333333`]]}, 
    {Hue[
      NCache[
       Rational[31, 72], 0.4305555555555556]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{2, 2 3^Rational[1, 2]}, {2, 3.4641016151377544`}], 
      NCache[Rational[4, 3], 1.3333333333333333`]]}, 
    {Hue[
      NCache[
       Rational[4, 9], 0.4444444444444444]], EdgeForm[Opacity[0.6]], 
     DiskBox[{0, 4}, NCache[Rational[4, 3], 1.3333333333333333`]]}, 
    {Hue[
      NCache[
       Rational[11, 24], 0.4583333333333333]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{-2, 2 3^Rational[1, 2]}, {-2, 3.4641016151377544`}], 
      NCache[Rational[4, 3], 1.3333333333333333`]]}, 
    {Hue[
      NCache[
       Rational[17, 36], 0.4722222222222222]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{(-2) 3^Rational[1, 2], 2}, {-3.4641016151377544`, 2}], 
      NCache[Rational[4, 3], 1.3333333333333333`]]}, 
    {Hue[
      NCache[
       Rational[35, 72], 0.4861111111111111]], EdgeForm[Opacity[0.6]], 
     DiskBox[{-4, 0}, NCache[Rational[4, 3], 1.3333333333333333`]]}, 
    {Hue[
      NCache[
       Rational[1, 2], 0.5]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{(-2) 3^Rational[1, 2], -2}, {-3.4641016151377544`, -2}], 
      NCache[Rational[4, 3], 1.3333333333333333`]]}, 
    {Hue[
      NCache[
       Rational[37, 72], 0.5138888888888888]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{-2, (-2) 3^Rational[1, 2]}, {-2, -3.4641016151377544`}], 
      NCache[Rational[4, 3], 1.3333333333333333`]]}, 
    {Hue[
      NCache[
       Rational[19, 36], 0.5277777777777778]], EdgeForm[Opacity[0.6]], 
     DiskBox[{0, -4}, NCache[Rational[4, 3], 1.3333333333333333`]]}, 
    {Hue[
      NCache[
       Rational[13, 24], 0.5416666666666666]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{2, (-2) 3^Rational[1, 2]}, {2, -3.4641016151377544`}], 
      NCache[Rational[4, 3], 1.3333333333333333`]]}, 
    {Hue[
      NCache[
       Rational[5, 9], 0.5555555555555556]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{2 3^Rational[1, 2], -2}, {3.4641016151377544`, -2}], 
      NCache[Rational[4, 3], 1.3333333333333333`]]}, 
    {Hue[
      NCache[
       Rational[41, 72], 0.5694444444444444]], EdgeForm[Opacity[0.6]], 
     DiskBox[{4, 0}, NCache[Rational[4, 3], 1.3333333333333333`]]}}, {
    {Hue[
      NCache[
       Rational[5, 9], 0.5555555555555556]], EdgeForm[Opacity[0.6]], 
     DiskBox[
      NCache[{Rational[3, 2] 3^Rational[1, 2], Rational[3, 2]}, {
       2.598076211353316, 1.5}]]}, 
    {Hue[
      NCache[
       Rational[41, 72], 0.5694444444444444]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{Rational[3, 2], Rational[3, 2] 3^Rational[1, 2]}, {1.5, 
       2.598076211353316}]]}, 
    {Hue[
      NCache[
       Rational[7, 12], 0.5833333333333334]], EdgeForm[Opacity[0.6]], 
     DiskBox[{0, 3}]}, 
    {Hue[
      NCache[
       Rational[43, 72], 0.5972222222222222]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{Rational[-3, 2], Rational[3, 2] 3^Rational[1, 2]}, {-1.5,
        2.598076211353316}]]}, 
    {Hue[
      NCache[
       Rational[11, 18], 0.6111111111111112]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{
       Rational[-3, 2] 3^Rational[1, 2], Rational[3, 2]}, {-2.598076211353316,
        1.5}]]}, 
    {Hue[
      NCache[
       Rational[5, 8], 0.625]], EdgeForm[Opacity[0.6]], DiskBox[{-3, 0}]}, 
    {Hue[
      NCache[
       Rational[23, 36], 0.6388888888888888]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{
       Rational[-3, 2] 3^Rational[1, 2], 
        Rational[-3, 2]}, {-2.598076211353316, -1.5}]]}, 
    {Hue[
      NCache[
       Rational[47, 72], 0.6527777777777778]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{
       Rational[-3, 2], Rational[-3, 2] 
        3^Rational[1, 2]}, {-1.5, -2.598076211353316}]]}, 
    {Hue[
      NCache[
       Rational[2, 3], 0.6666666666666666]], EdgeForm[Opacity[0.6]], 
     DiskBox[{0, -3}]}, 
    {Hue[
      NCache[
       Rational[49, 72], 0.6805555555555556]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{Rational[3, 2], Rational[-3, 2] 3^Rational[1, 2]}, {
       1.5, -2.598076211353316}]]}, 
    {Hue[
      NCache[
       Rational[25, 36], 0.6944444444444444]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{Rational[3, 2] 3^Rational[1, 2], Rational[-3, 2]}, {
       2.598076211353316, -1.5}]]}, 
    {Hue[
      NCache[
       Rational[17, 24], 0.7083333333333334]], EdgeForm[Opacity[0.6]], 
     DiskBox[{3, 0}]}}, {
    {Hue[
      NCache[
       Rational[25, 36], 0.6944444444444444]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{3^Rational[1, 2], 1}, {1.7320508075688772`, 1}], NCache[
      Rational[2, 3], 0.6666666666666666]]}, 
    {Hue[
      NCache[
       Rational[17, 24], 0.7083333333333334]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{1, 3^Rational[1, 2]}, {1, 1.7320508075688772`}], NCache[
      Rational[2, 3], 0.6666666666666666]]}, 
    {Hue[
      NCache[
       Rational[13, 18], 0.7222222222222222]], EdgeForm[Opacity[0.6]], 
     DiskBox[{0, 2}, NCache[Rational[2, 3], 0.6666666666666666]]}, 
    {Hue[
      NCache[
       Rational[53, 72], 0.7361111111111112]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{-1, 3^Rational[1, 2]}, {-1, 1.7320508075688772`}], 
      NCache[Rational[2, 3], 0.6666666666666666]]}, 
    {Hue[
      NCache[
       Rational[3, 4], 0.75]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{-3^Rational[1, 2], 1}, {-1.7320508075688772`, 1}], 
      NCache[Rational[2, 3], 0.6666666666666666]]}, 
    {Hue[
      NCache[
       Rational[55, 72], 0.7638888888888888]], EdgeForm[Opacity[0.6]], 
     DiskBox[{-2, 0}, NCache[Rational[2, 3], 0.6666666666666666]]}, 
    {Hue[
      NCache[
       Rational[7, 9], 0.7777777777777778]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{-3^Rational[1, 2], -1}, {-1.7320508075688772`, -1}], 
      NCache[Rational[2, 3], 0.6666666666666666]]}, 
    {Hue[
      NCache[
       Rational[19, 24], 0.7916666666666666]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{-1, -3^Rational[1, 2]}, {-1, -1.7320508075688772`}], 
      NCache[Rational[2, 3], 0.6666666666666666]]}, 
    {Hue[
      NCache[
       Rational[29, 36], 0.8055555555555556]], EdgeForm[Opacity[0.6]], 
     DiskBox[{0, -2}, NCache[Rational[2, 3], 0.6666666666666666]]}, 
    {Hue[
      NCache[
       Rational[59, 72], 0.8194444444444444]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{1, -3^Rational[1, 2]}, {1, -1.7320508075688772`}], 
      NCache[Rational[2, 3], 0.6666666666666666]]}, 
    {Hue[
      NCache[
       Rational[5, 6], 0.8333333333333334]], EdgeForm[Opacity[0.6]], 
     DiskBox[NCache[{3^Rational[1, 2], -1}, {1.7320508075688772`, -1}], 
      NCache[Rational[2, 3], 0.6666666666666666]]}, 
    {Hue[
      NCache[
       Rational[61, 72], 0.8472222222222222]], EdgeForm[Opacity[0.6]], 
     DiskBox[{2, 0}, NCache[
      Rational[2, 3], 0.6666666666666666]]}}}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16415603]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->399486017],

Cell["Ying and Yang:", "ExampleText",
 CellID->99903589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Animate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Red", ",", 
        RowBox[{"Disk", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "2", ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "Pi"}], "}"}]}], "]"}], ",", "Blue", ",", 
        RowBox[{"Disk", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0", ",", "0"}], "}"}], ",", "2", ",", 
          RowBox[{"{", 
           RowBox[{"Pi", ",", 
            RowBox[{"2", "Pi"}]}], "}"}]}], "]"}], ",", "Red", ",", 
        RowBox[{"Disk", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", "1"}], "]"}], ",", 
        "Blue", ",", 
        RowBox[{"Disk", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"1", ",", "0"}], "}"}], ",", "1"}], "]"}]}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "2.1"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "150"}]}], "]"}], "/.", 
    RowBox[{
     RowBox[{"Disk", "[", "x__", "]"}], "\[RuleDelayed]", 
     RowBox[{"Rotate", "[", 
      RowBox[{
       RowBox[{"Disk", "[", "x", "]"}], ",", 
       RowBox[{"d", " ", "Degree"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", "0", ",", "360"}], "}"}], ",", 
   RowBox[{"AnimationRunning", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->352282185],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`d$$ = 0., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`d$$], 0, 360}}, Typeset`size$$ = {150., {73., 77.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`d$1206$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`d$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`d$$, $CellContext`d$1206$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ReplaceAll[
        Graphics[{Red, 
          Disk[{0, 0}, 2, {0, Pi}], Blue, 
          Disk[{0, 0}, 2, {Pi, 2 Pi}], Red, 
          Disk[{-1, 0}, 1], Blue, 
          Disk[{1, 0}, 1]}, PlotRange -> 2.1, ImageSize -> 150], Disk[
          Pattern[$CellContext`x$, 
           BlankSequence[]]] :> Rotate[
          Disk[$CellContext`x$], $CellContext`d$$ Degree, {0, 0}]], 
      "Specifications" :> {{$CellContext`d$$, 0, 360, AnimationRunning -> 
         False, AppearanceElements -> {
          "ProgressSlider", "PlayPauseButton", "FasterSlowerButtons", 
           "DirectionButton"}}}, 
      "Options" :> {
       ControlType -> Animator, AppearanceElements -> None, 
        SynchronousUpdating -> True, ShrinkingDelay -> 10.}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{329., {110., 115.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 ImageSize->{333, 227},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->229465676]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->18422],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Circle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Circle"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Polygon",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Polygon"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rotate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rotate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotRangeClipping",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotRangeClipping"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PointSize",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PointSize"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3198]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Disk",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Disk"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->122171944],

Cell[TextData[ButtonBox["Graphics Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsObjects"]], "MoreAbout",
 CellID->416089420],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->372040962],

Cell[TextData[ButtonBox["New in 6.0: Graphics Primitives & Directives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsPrimitivesAndDirectives"]], "MoreAbout",
 CellID->87373782]
}, Open  ]],

Cell["New in 2  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Disk - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 19, 38, 29.0708826}", "context" -> "System`", 
    "keywords" -> {
     "pie slices", "segments", "wedges", "disk", "elliptical disk", 
      "filled circle", "filled ellipse"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Disk[{x, y}, r] is a two-dimensional graphics primitive that represents \
a filled disk of radius r centered at the point x, y. Disk[{x, y}] gives a \
disk of radius 1. Disk[{x, y}, r, {\\[Theta]_1, \\[Theta]_2}] gives a segment \
of a disk. Disk[{x, y}, {r_x, r_y}] gives an elliptical disk with semi-axes \
of lengths r_x and r_y, oriented parallel to the coordinate axes. ", 
    "synonyms" -> {}, "title" -> "Disk", "type" -> "Symbol", "uri" -> 
    "ref/Disk"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[15364, 467, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->497889714]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 157006, 4281}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1963, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2586, 71, 4188, 83, 70, "ObjectNameGrid"],
Cell[6777, 156, 2852, 94, 70, "Usage",
 CellID->27866]
}, Open  ]],
Cell[CellGroupData[{
Cell[9666, 255, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10144, 272, 187, 6, 70, "Notes",
 CellID->7418],
Cell[10334, 280, 890, 30, 70, "Notes",
 CellID->16979],
Cell[11227, 312, 1289, 49, 70, "Notes",
 CellID->18443],
Cell[12519, 363, 721, 25, 70, "Notes",
 CellID->20676],
Cell[13243, 390, 501, 17, 70, "Notes",
 CellID->14183],
Cell[13747, 409, 608, 17, 70, "Notes",
 CellID->21960],
Cell[14358, 428, 389, 12, 70, "Notes",
 CellID->17852],
Cell[14750, 442, 577, 20, 70, "Notes",
 CellID->3781]
}, Closed]],
Cell[CellGroupData[{
Cell[15364, 467, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->497889714],
Cell[CellGroupData[{
Cell[15749, 481, 148, 5, 70, "ExampleSection",
 CellID->146956760],
Cell[15900, 488, 54, 1, 70, "ExampleText",
 CellID->64135791],
Cell[CellGroupData[{
Cell[15979, 493, 129, 4, 28, "Input",
 CellID->12902770],
Cell[16111, 499, 238, 7, 121, "Output",
 CellID->62383137]
}, Open  ]],
Cell[16364, 509, 125, 3, 70, "ExampleDelimiter",
 CellID->110273157],
Cell[16492, 514, 57, 1, 70, "ExampleText",
 CellID->77089960],
Cell[CellGroupData[{
Cell[16574, 519, 422, 15, 70, "Input",
 CellID->69305470],
Cell[16999, 536, 370, 11, 93, "Output",
 CellID->62304270]
}, Open  ]],
Cell[17384, 550, 125, 3, 70, "ExampleDelimiter",
 CellID->227143818],
Cell[17512, 555, 61, 1, 70, "ExampleText",
 CellID->16193628],
Cell[CellGroupData[{
Cell[17598, 560, 325, 11, 70, "Input",
 CellID->558999048],
Cell[17926, 573, 275, 8, 153, "Output",
 CellID->225729427]
}, Open  ]],
Cell[18216, 584, 125, 3, 70, "ExampleDelimiter",
 CellID->517700974],
Cell[18344, 589, 73, 1, 70, "ExampleText",
 CellID->217517280],
Cell[CellGroupData[{
Cell[18442, 594, 869, 26, 70, "Input",
 CellID->17828104],
Cell[19314, 622, 666, 19, 123, "Output",
 CellID->258457316]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20029, 647, 220, 7, 70, "ExampleSection",
 CellID->46074458],
Cell[CellGroupData[{
Cell[20274, 658, 239, 7, 70, "ExampleSubsection",
 CellID->702892053],
Cell[20516, 667, 57, 1, 70, "ExampleText",
 CellID->137796048],
Cell[CellGroupData[{
Cell[20598, 672, 544, 18, 70, "Input",
 CellID->11794488],
Cell[21145, 692, 356, 10, 121, "Output",
 CellID->241085763]
}, Open  ]],
Cell[21516, 705, 125, 3, 70, "ExampleDelimiter",
 CellID->326926988],
Cell[21644, 710, 59, 1, 70, "ExampleText",
 CellID->144729799],
Cell[CellGroupData[{
Cell[21728, 715, 545, 18, 70, "Input",
 CellID->392018628],
Cell[22276, 735, 350, 10, 121, "Output",
 CellID->275106943]
}, Open  ]],
Cell[22641, 748, 125, 3, 70, "ExampleDelimiter",
 CellID->527872799],
Cell[22769, 753, 57, 1, 70, "ExampleText",
 CellID->62479769],
Cell[CellGroupData[{
Cell[22851, 758, 322, 11, 70, "Input",
 CellID->131804889],
Cell[23176, 771, 306, 9, 115, "Output",
 CellID->133807002]
}, Open  ]],
Cell[CellGroupData[{
Cell[23519, 785, 345, 12, 70, "Input",
 CellID->236584046],
Cell[23867, 799, 329, 10, 89, "Output",
 CellID->32529545]
}, Open  ]],
Cell[24211, 812, 125, 3, 70, "ExampleDelimiter",
 CellID->844545353],
Cell[24339, 817, 62, 1, 70, "ExampleText",
 CellID->913725950],
Cell[CellGroupData[{
Cell[24426, 822, 261, 9, 70, "Input",
 CellID->307994183],
Cell[24690, 833, 248, 7, 89, "Output",
 CellID->965666160]
}, Open  ]],
Cell[24953, 843, 125, 3, 70, "ExampleDelimiter",
 CellID->441377968],
Cell[25081, 848, 190, 7, 70, "ExampleText",
 CellID->6262908],
Cell[CellGroupData[{
Cell[25296, 859, 372, 13, 70, "Input",
 CellID->21126177],
Cell[25671, 874, 313, 9, 85, "Output",
 CellID->486555717]
}, Open  ]],
Cell[25999, 886, 125, 3, 70, "ExampleDelimiter",
 CellID->173614351],
Cell[26127, 891, 201, 7, 70, "ExampleText",
 CellID->205502],
Cell[CellGroupData[{
Cell[26353, 902, 191, 6, 70, "Input",
 CellID->122989917],
Cell[26547, 910, 254, 8, 162, "Output",
 CellID->175048798]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26850, 924, 233, 7, 70, "ExampleSubsection",
 CellID->456816427],
Cell[27086, 933, 93, 1, 70, "ExampleText",
 CellID->164074182],
Cell[CellGroupData[{
Cell[27204, 938, 382, 13, 70, "Input",
 CellID->808748643],
Cell[27589, 953, 497, 16, 123, "Output",
 CellID->190749985]
}, Open  ]],
Cell[28101, 972, 125, 3, 70, "ExampleDelimiter",
 CellID->131492187],
Cell[28229, 977, 528, 17, 70, "ExampleText",
 CellID->468986790],
Cell[CellGroupData[{
Cell[28782, 998, 354, 10, 70, "Input",
 CellID->579367583],
Cell[29139, 1010, 354, 9, 121, "Output",
 CellID->29034320]
}, Open  ]],
Cell[29508, 1022, 84, 1, 70, "ExampleText",
 CellID->734333566],
Cell[CellGroupData[{
Cell[29617, 1027, 566, 19, 70, "Input",
 CellID->5508369],
Cell[30186, 1048, 387, 10, 85, "Output",
 CellID->12468923]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30622, 1064, 255, 7, 70, "ExampleSubsection",
 CellID->441259165],
Cell[30880, 1073, 311, 12, 70, "ExampleText",
 CellID->19804318],
Cell[CellGroupData[{
Cell[31216, 1089, 314, 10, 70, "Input",
 CellID->73519992],
Cell[31533, 1101, 271, 8, 162, "Output",
 CellID->751911117]
}, Open  ]],
Cell[CellGroupData[{
Cell[31841, 1114, 311, 10, 70, "Input",
 CellID->61585090],
Cell[32155, 1126, 268, 8, 163, "Output",
 CellID->275819490]
}, Open  ]],
Cell[CellGroupData[{
Cell[32460, 1139, 368, 12, 70, "Input",
 CellID->518233082],
Cell[32831, 1153, 274, 8, 163, "Output",
 CellID->98046726]
}, Open  ]],
Cell[33120, 1164, 124, 3, 70, "ExampleDelimiter",
 CellID->20096378],
Cell[33247, 1169, 215, 8, 70, "ExampleText",
 CellID->347843897],
Cell[CellGroupData[{
Cell[33487, 1181, 320, 10, 70, "Input",
 CellID->769181745],
Cell[33810, 1193, 275, 8, 162, "Output",
 CellID->58050623]
}, Open  ]],
Cell[CellGroupData[{
Cell[34122, 1206, 373, 12, 70, "Input",
 CellID->399448777],
Cell[34498, 1220, 280, 8, 163, "Output",
 CellID->268890056]
}, Open  ]],
Cell[34793, 1231, 125, 3, 70, "ExampleDelimiter",
 CellID->264086837],
Cell[34921, 1236, 194, 8, 70, "ExampleText",
 CellID->11628004],
Cell[CellGroupData[{
Cell[35140, 1248, 401, 13, 70, "Input",
 CellID->690732740],
Cell[35544, 1263, 277, 8, 163, "Output",
 CellID->751632404]
}, Open  ]],
Cell[35836, 1274, 125, 3, 70, "ExampleDelimiter",
 CellID->233279087],
Cell[35964, 1279, 308, 11, 70, "ExampleText",
 CellID->236972502],
Cell[CellGroupData[{
Cell[36297, 1294, 367, 12, 70, "Input",
 CellID->225944801],
Cell[36667, 1308, 284, 8, 163, "Output",
 CellID->504171559]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[37012, 1323, 223, 7, 70, "ExampleSection",
 CellID->27626],
Cell[37238, 1332, 217, 8, 70, "ExampleText",
 CellID->35739729],
Cell[CellGroupData[{
Cell[37480, 1344, 1182, 34, 70, "Input",
 CellID->4648924],
Cell[38665, 1380, 5498, 94, 70, "Output",
 Evaluatable->False,
 CellID->426246115]
}, Open  ]],
Cell[44178, 1477, 125, 3, 70, "ExampleDelimiter",
 CellID->213968444],
Cell[44306, 1482, 61, 1, 70, "ExampleText",
 CellID->287045242],
Cell[44370, 1485, 248, 8, 70, "Input",
 CellID->297659809],
Cell[CellGroupData[{
Cell[44643, 1497, 1123, 34, 70, "Input",
 CellID->74492583],
Cell[45769, 1533, 831, 24, 201, "Output",
 CellID->141907814]
}, Open  ]],
Cell[46615, 1560, 125, 3, 70, "ExampleDelimiter",
 CellID->767995213],
Cell[46743, 1565, 88, 1, 70, "ExampleText",
 CellID->225545640],
Cell[CellGroupData[{
Cell[46856, 1570, 1873, 54, 70, "Input",
 CellID->203772782],
Cell[48732, 1626, 22630, 517, 195, "Output",
 CellID->583400998]
}, Open  ]],
Cell[71377, 2146, 125, 3, 70, "ExampleDelimiter",
 CellID->564325026],
Cell[71505, 2151, 71, 1, 70, "ExampleText",
 CellID->260968007],
Cell[CellGroupData[{
Cell[71601, 2156, 543, 17, 70, "Input",
 CellID->394677528],
Cell[72147, 2175, 1949, 36, 70, "Output",
 Evaluatable->False,
 CellID->497586663]
}, Open  ]],
Cell[74111, 2214, 73, 1, 70, "ExampleText",
 CellID->52340893],
Cell[CellGroupData[{
Cell[74209, 2219, 798, 25, 70, "Input",
 CellID->54037755],
Cell[75010, 2246, 2661, 48, 70, "Output",
 Evaluatable->False,
 CellID->339837992]
}, Open  ]],
Cell[77686, 2297, 123, 3, 70, "ExampleDelimiter",
 CellID->4886675],
Cell[77812, 2302, 73, 1, 70, "ExampleText",
 CellID->22599527],
Cell[CellGroupData[{
Cell[77910, 2307, 3284, 94, 70, "Input",
 CellID->541567839],
Cell[81197, 2403, 3012, 67, 70, "Output",
 CellID->72766112]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[84258, 2476, 233, 7, 70, "ExampleSection",
 CellID->24570],
Cell[84494, 2485, 229, 10, 70, "ExampleText",
 CellID->19774549],
Cell[CellGroupData[{
Cell[84748, 2499, 493, 16, 70, "Input",
 CellID->41587213],
Cell[85244, 2517, 398, 12, 133, "Output",
 CellID->544149]
}, Open  ]],
Cell[85657, 2532, 125, 3, 70, "ExampleDelimiter",
 CellID->147337869],
Cell[85785, 2537, 83, 1, 70, "ExampleText",
 CellID->126224546],
Cell[CellGroupData[{
Cell[85893, 2542, 384, 12, 70, "Input",
 CellID->74762595],
Cell[86280, 2556, 366, 12, 123, "Output",
 CellID->51078900]
}, Open  ]],
Cell[86661, 2571, 125, 3, 70, "ExampleDelimiter",
 CellID->204306472],
Cell[86789, 2576, 243, 8, 70, "ExampleText",
 CellID->47836386],
Cell[CellGroupData[{
Cell[87057, 2588, 400, 14, 70, "Input",
 CellID->185194839],
Cell[87460, 2604, 4234, 73, 70, "Output",
 Evaluatable->False,
 CellID->387851841]
}, Open  ]],
Cell[91709, 2680, 124, 3, 70, "ExampleDelimiter",
 CellID->78749878],
Cell[91836, 2685, 253, 8, 70, "ExampleText",
 CellID->578540755],
Cell[CellGroupData[{
Cell[92114, 2697, 476, 15, 70, "Input",
 CellID->605478468],
Cell[92593, 2714, 19932, 331, 70, "Output",
 Evaluatable->False,
 CellID->525060199]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[112574, 3051, 226, 7, 70, "ExampleSection",
 CellID->20251],
Cell[112803, 3060, 338, 13, 70, "ExampleText",
 CellID->353119521],
Cell[CellGroupData[{
Cell[113166, 3077, 1198, 40, 70, "Input",
 CellID->207375245],
Cell[114367, 3119, 1378, 38, 127, "Output",
 CellID->8400346]
}, Open  ]],
Cell[115760, 3160, 125, 3, 70, "ExampleDelimiter",
 CellID->309175476],
Cell[115888, 3165, 482, 18, 70, "ExampleText",
 CellID->14956960],
Cell[CellGroupData[{
Cell[116395, 3187, 1091, 36, 70, "Input",
 CellID->42263118],
Cell[117489, 3225, 1423, 38, 126, "Output",
 CellID->315665331]
}, Open  ]],
Cell[CellGroupData[{
Cell[118949, 3268, 1196, 38, 70, "Input",
 CellID->284727558],
Cell[120148, 3308, 1514, 42, 127, "Output",
 CellID->653744572]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[121711, 3356, 224, 7, 70, "ExampleSection",
 CellID->10264],
Cell[121938, 3365, 67, 1, 70, "ExampleText",
 CellID->152190467],
Cell[CellGroupData[{
Cell[122030, 3370, 570, 17, 70, "Input",
 CellID->45131703],
Cell[122603, 3389, 5539, 97, 202, "Output",
 CellID->135168511]
}, Open  ]],
Cell[128157, 3489, 125, 3, 70, "ExampleDelimiter",
 CellID->235941495],
Cell[128285, 3494, 61, 1, 70, "ExampleText",
 CellID->295179799],
Cell[CellGroupData[{
Cell[128371, 3499, 689, 22, 70, "Input",
 CellID->54842079],
Cell[129063, 3523, 3513, 89, 201, "Output",
 CellID->14233911]
}, Open  ]],
Cell[132591, 3615, 125, 3, 70, "ExampleDelimiter",
 CellID->282122593],
Cell[132719, 3620, 58, 1, 70, "ExampleText",
 CellID->54371934],
Cell[CellGroupData[{
Cell[132802, 3625, 1129, 35, 70, "Input",
 CellID->208503405],
Cell[133934, 3662, 14475, 355, 201, "Output",
 CellID->16415603]
}, Open  ]],
Cell[148424, 4020, 125, 3, 70, "ExampleDelimiter",
 CellID->399486017],
Cell[148552, 4025, 56, 1, 70, "ExampleText",
 CellID->99903589],
Cell[CellGroupData[{
Cell[148633, 4030, 1562, 45, 70, "Input",
 CellID->352282185],
Cell[150198, 4077, 2212, 49, 70, "Output",
 CellID->229465676]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[152471, 4133, 311, 9, 70, "SeeAlsoSection",
 CellID->18422],
Cell[152785, 4144, 1195, 44, 70, "SeeAlso",
 CellID->3198]
}, Open  ]],
Cell[CellGroupData[{
Cell[154017, 4193, 305, 8, 70, "RelatedLinksSection"],
Cell[154325, 4203, 348, 11, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[154710, 4219, 319, 9, 70, "MoreAboutSection",
 CellID->122171944],
Cell[155032, 4230, 143, 3, 70, "MoreAbout",
 CellID->416089420],
Cell[155178, 4235, 162, 3, 70, "MoreAbout",
 CellID->372040962],
Cell[155343, 4240, 196, 4, 70, "MoreAbout",
 CellID->87373782]
}, Open  ]],
Cell[155554, 4247, 50, 0, 70, "History"],
Cell[155607, 4249, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

